import{s as it,n as pt,o as mt}from"../chunks/scheduler.9bc65507.js";import{S as ct,i as Mt,g as o,s as n,r as p,A as ut,h as r,f as l,c as a,j as ot,u as m,x as i,k as rt,y as dt,a as s,v as c,d as M,t as u,w as d}from"../chunks/index.707bf1b6.js";import{C as w}from"../chunks/CodeBlock.54a9f38d.js";import{D as ft}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as ee}from"../chunks/Heading.342b1fa6.js";function wt(Ve){let f,te,D,le,y,se,T,ne,b,ze='加速線形代数（Accelerated Linear Algebra）、通称XLAは、TensorFlowモデルのランタイムを高速化するためのコンパイラです。<a href="https://www.tensorflow.org/xla" rel="nofollow">公式ドキュメント</a>によれば、XLA（Accelerated Linear Algebra）は線形代数のためのドメイン固有のコンパイラで、TensorFlowモデルを潜在的にソースコードの変更なしで高速化できます。',ae,h,Le='TensorFlowでXLAを使用するのは簡単です。XLAは<code>tensorflow</code>ライブラリ内にパッケージ化されており、<a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>などのグラフを作成する関数内で<code>jit_compile</code>引数を使用してトリガーできます。<code>fit()</code>や<code>predict()</code>などのKerasメソッドを使用する場合、<code>model.compile()</code>に<code>jit_compile</code>引数を渡すだけでXLAを有効にできます。ただし、XLAはこれらのメソッドに限定されているわけではありません。任意の<code>tf.function</code>を高速化するためにも使用できます。',oe,J,Ee='🤗 Transformers内のいくつかのTensorFlowメソッドは、XLAと互換性があるように書き直されています。これには、<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>、<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>、<a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>などのテキスト生成モデルや、<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>などの音声処理モデルも含まれます。',re,j,Qe="速度向上の具体的な量はモデルに非常に依存しますが、🤗 Transformers内のTensorFlowテキスト生成モデルでは、約100倍の速度向上を確認しています。このドキュメントでは、これらのモデルにXLAを使用して最大のパフォーマンスを得る方法を説明します。また、ベンチマークとXLA統合のデザイン哲学について詳しく学びたい場合の追加リソースへのリンクも提供します。",ie,g,pe,U,Ae="以下のTensorFlowモデルを考えてみましょう：",me,Z,ce,_,He="上記のモデルは、次元が<code>(10, )</code>の入力を受け入れます。このモデルをフォワードパスで実行するには、次のようにします：",Me,k,ue,X,Ne="XLAでコンパイルされた関数を使用してフォワードパスを実行するには、以下のようにします：",de,G,fe,R,Ye="<code>model</code>のデフォルトの <code>call()</code> 関数はXLAグラフをコンパイルするために使用されます。ただし、XLAにコンパイルしたい他のモデル関数がある場合、それも可能です。以下はその方法です：",we,I,ye,B,Te,W,qe="🤗 Transformers内でXLAでの高速化された生成を有効にするには、最新バージョンの<code>transformers</code>がインストールされている必要があります。次のコマンドを実行してインストールできます：",be,$,he,x,Se="次に、次のコードを実行できます：",Je,C,je,v,Pe="<code>generate()</code>でXLAを有効にするのは、たった一行のコードです。コードの残り部分は変更されていません。ただし、XLA固有のいくつかの注意点が上記のコードスニペットにあります。これらに注意する必要があり、XLAがもたらす速度向上を実現するためにそれらを把握することが重要です。次のセクションでこれらについて詳しく説明します。",ge,F,Ue,V,Ke='XLAを有効にした関数（上記の<code>xla_generate()</code>など）を初めて実行すると、内部で計算グラフを推論しようとしますが、これは時間がかかります。このプロセスは<a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“トレーシング”（tracing）</a>として知られています。',Ze,z,De="生成時間が高速ではないことに気付くかもしれません。<code>xla_generate()</code>（または他のXLA対応関数）の連続呼び出しでは、関数への入力が最初に計算グラフが構築されたときと同じ形状に従っている場合、計算グラフを推論する必要はありません。これは、入力形状が固定されているモダリティ（例：画像）には問題ありませんが、変数の入力形状モダリティ（例：テキスト）を扱う場合には注意が必要です。",_e,L,Oe="<code>xla_generate()</code>が常に同じ入力形状で動作するようにするには、トークナイザを呼び出す際に<code>padding</code>引数を指定できます。",ke,E,Xe,Q,et="これにより、<code>xla_generate()</code>への入力が常にトレースされた形状の入力を受け取ることを確認し、生成時間の高速化を実現できます。以下のコードでこれを確認できます：",Ge,A,Re,H,tt="Tesla T4 GPUを使用すると、次のような出力が期待されます：",Ie,N,Be,Y,lt="最初の<code>xla_generate()</code>呼び出しはトレーシングのために時間がかかりますが、連続する呼び出しは桁違いに高速です。生成オプションのいかなる変更も、再トレーシングを引き起こし、生成時間の遅延を引き起こすことに注意してください。",We,q,st="このドキュメントでは、🤗 Transformersが提供するテキスト生成オプションをすべて網羅していません。高度なユースケースについてはドキュメンテーションを参照することをお勧めします。",$e,S,xe,P,nt="ここでは、🤗 Transformersと一般的なXLAについてさらに詳しく学びたい場合のいくつかの追加リソースを提供します。",Ce,K,at='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">このColab Notebook</a>では、XLA対応のエンコーダーデコーダー（<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>など）およびデコーダー専用（<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>など）テキスト生成モデルを試すための対話型デモが提供されています。</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">このブログ記事</a>では、XLA対応モデルの比較ベンチマークの概要と、TensorFlowでのXLAについての友好的な紹介が提供されています。</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">このブログ記事</a>では、🤗 TransformersのTensorFlowモデルにXLAサポートを追加する際の設計哲学について説明しています。</li> <li>一般的なXLAとTensorFlowグラフについて詳しく学ぶためのおすすめの投稿：<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: 機械学習用の最適化コンパイラ</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">グラフと<code>tf.function</code>の紹介</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow"><code>tf.function</code>を使用したパフォーマンス向上</a></li></ul></li>',ve,O,Fe;return y=new ee({props:{title:"XLA Integration for TensorFlow Models",local:"xla-integration-for-tensorflow-models",headingTag:"h1"}}),T=new ft({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/tf_xla.ipynb"}]}}),g=new ee({props:{title:"Running TF functions with XLA",local:"running-tf-functions-with-xla",headingTag:"h2"}}),Z=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),k=new w({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`,wrap:!1}}),G=new w({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),I=new w({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),B=new ee({props:{title:"Running a TF text generation model with XLA from 🤗 Transformers",local:"running-a-tf-text-generation-model-with-xla-from--transformers",headingTag:"h2"}}),$=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),C=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dF9zdHJpbmclMjAlM0QlMjAlNUIlMjJUZW5zb3JGbG93JTIwaXMlMjIlNUQlMEElMEElMjMlMjBPbmUlMjBsaW5lJTIwdG8lMjBjcmVhdGUlMjBhbiUyMFhMQSUyMGdlbmVyYXRpb24lMjBmdW5jdGlvbiUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQXRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWdlbmVyYXRlZF90b2tlbnMlMjAlM0QlMjB4bGFfZ2VuZXJhdGUoKip0b2tlbml6ZWRfaW5wdXQlMkMlMjBudW1fYmVhbXMlM0QyKSUwQSUwQWRlY29kZWRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChmJTIyR2VuZXJhdGVkJTIwLS0lMjAlN0JkZWNvZGVkX3RleHQlN0QlMjIpJTBBJTIzJTIwR2VuZXJhdGVkJTIwLS0lMjBUZW5zb3JGbG93JTIwaXMlMjBhbiUyMG9wZW4tc291cmNlJTJDJTIwb3Blbi1zb3VyY2UlMkMlMjBkaXN0cmlidXRlZC1zb3VyY2UlMjBhcHBsaWNhdGlvbiUyMCUyMyUyMGZyYW1ld29yayUyMGZvciUyMHRoZQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),F=new ee({props:{title:"Gotchas to be aware of",local:"gotchas-to-be-aware-of",headingTag:"h2"}}),E=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQSUyMyUyMEhlcmUlMkMlMjB3ZSUyMGNhbGwlMjB0aGUlMjB0b2tlbml6ZXIlMjB3aXRoJTIwcGFkZGluZyUyMG9wdGlvbnMuJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHBhZF90b19tdWx0aXBsZV9vZiUzRDglMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),A=new w({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEElMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEFmb3IlMjBpbnB1dF9zdHJpbmclMjBpbiUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiUyQyUyMCUyMlRlbnNvckZsb3clMjBpcyUyMGElMjIlMkMlMjAlMjJURkxpdGUlMjBpcyUyMGElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMjAlMjAlMjAlMjBzdGFydCUyMCUzRCUyMHRpbWUudGltZV9ucygpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwJTdCKGVuZCUyMC0lMjBzdGFydCklMjAlMkYlMjAxZTYlM0EuMWYlN0QlMjBtcyU1Q24lMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),N=new w({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),S=new ee({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),{c(){f=o("meta"),te=n(),D=o("p"),le=n(),p(y.$$.fragment),se=n(),p(T.$$.fragment),ne=n(),b=o("p"),b.innerHTML=ze,ae=n(),h=o("p"),h.innerHTML=Le,oe=n(),J=o("p"),J.innerHTML=Ee,re=n(),j=o("p"),j.textContent=Qe,ie=n(),p(g.$$.fragment),pe=n(),U=o("p"),U.textContent=Ae,me=n(),p(Z.$$.fragment),ce=n(),_=o("p"),_.innerHTML=He,Me=n(),p(k.$$.fragment),ue=n(),X=o("p"),X.textContent=Ne,de=n(),p(G.$$.fragment),fe=n(),R=o("p"),R.innerHTML=Ye,we=n(),p(I.$$.fragment),ye=n(),p(B.$$.fragment),Te=n(),W=o("p"),W.innerHTML=qe,be=n(),p($.$$.fragment),he=n(),x=o("p"),x.textContent=Se,Je=n(),p(C.$$.fragment),je=n(),v=o("p"),v.innerHTML=Pe,ge=n(),p(F.$$.fragment),Ue=n(),V=o("p"),V.innerHTML=Ke,Ze=n(),z=o("p"),z.innerHTML=De,_e=n(),L=o("p"),L.innerHTML=Oe,ke=n(),p(E.$$.fragment),Xe=n(),Q=o("p"),Q.innerHTML=et,Ge=n(),p(A.$$.fragment),Re=n(),H=o("p"),H.textContent=tt,Ie=n(),p(N.$$.fragment),Be=n(),Y=o("p"),Y.innerHTML=lt,We=n(),q=o("p"),q.textContent=st,$e=n(),p(S.$$.fragment),xe=n(),P=o("p"),P.textContent=nt,Ce=n(),K=o("ul"),K.innerHTML=at,ve=n(),O=o("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);f=r(t,"META",{name:!0,content:!0}),t.forEach(l),te=a(e),D=r(e,"P",{}),ot(D).forEach(l),le=a(e),m(y.$$.fragment,e),se=a(e),m(T.$$.fragment,e),ne=a(e),b=r(e,"P",{"data-svelte-h":!0}),i(b)!=="svelte-zzdk25"&&(b.innerHTML=ze),ae=a(e),h=r(e,"P",{"data-svelte-h":!0}),i(h)!=="svelte-17c4ps"&&(h.innerHTML=Le),oe=a(e),J=r(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-jmz72m"&&(J.innerHTML=Ee),re=a(e),j=r(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-163nszz"&&(j.textContent=Qe),ie=a(e),m(g.$$.fragment,e),pe=a(e),U=r(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-i2jpr9"&&(U.textContent=Ae),me=a(e),m(Z.$$.fragment,e),ce=a(e),_=r(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-xhjq9d"&&(_.innerHTML=He),Me=a(e),m(k.$$.fragment,e),ue=a(e),X=r(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1xlk5bx"&&(X.textContent=Ne),de=a(e),m(G.$$.fragment,e),fe=a(e),R=r(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-bfwqnu"&&(R.innerHTML=Ye),we=a(e),m(I.$$.fragment,e),ye=a(e),m(B.$$.fragment,e),Te=a(e),W=r(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1rj7w64"&&(W.innerHTML=qe),be=a(e),m($.$$.fragment,e),he=a(e),x=r(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-kzcg3w"&&(x.textContent=Se),Je=a(e),m(C.$$.fragment,e),je=a(e),v=r(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1gq39rt"&&(v.innerHTML=Pe),ge=a(e),m(F.$$.fragment,e),Ue=a(e),V=r(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1u18xwm"&&(V.innerHTML=Ke),Ze=a(e),z=r(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-vj7dap"&&(z.innerHTML=De),_e=a(e),L=r(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-10cmu1q"&&(L.innerHTML=Oe),ke=a(e),m(E.$$.fragment,e),Xe=a(e),Q=r(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-q4vr22"&&(Q.innerHTML=et),Ge=a(e),m(A.$$.fragment,e),Re=a(e),H=r(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1pv1wyj"&&(H.textContent=tt),Ie=a(e),m(N.$$.fragment,e),Be=a(e),Y=r(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1ja7r83"&&(Y.innerHTML=lt),We=a(e),q=r(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-xpg5d5"&&(q.textContent=st),$e=a(e),m(S.$$.fragment,e),xe=a(e),P=r(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-ctf09q"&&(P.textContent=nt),Ce=a(e),K=r(e,"UL",{"data-svelte-h":!0}),i(K)!=="svelte-ycl3uy"&&(K.innerHTML=at),ve=a(e),O=r(e,"P",{}),ot(O).forEach(l),this.h()},h(){rt(f,"name","hf:doc:metadata"),rt(f,"content",yt)},m(e,t){dt(document.head,f),s(e,te,t),s(e,D,t),s(e,le,t),c(y,e,t),s(e,se,t),c(T,e,t),s(e,ne,t),s(e,b,t),s(e,ae,t),s(e,h,t),s(e,oe,t),s(e,J,t),s(e,re,t),s(e,j,t),s(e,ie,t),c(g,e,t),s(e,pe,t),s(e,U,t),s(e,me,t),c(Z,e,t),s(e,ce,t),s(e,_,t),s(e,Me,t),c(k,e,t),s(e,ue,t),s(e,X,t),s(e,de,t),c(G,e,t),s(e,fe,t),s(e,R,t),s(e,we,t),c(I,e,t),s(e,ye,t),c(B,e,t),s(e,Te,t),s(e,W,t),s(e,be,t),c($,e,t),s(e,he,t),s(e,x,t),s(e,Je,t),c(C,e,t),s(e,je,t),s(e,v,t),s(e,ge,t),c(F,e,t),s(e,Ue,t),s(e,V,t),s(e,Ze,t),s(e,z,t),s(e,_e,t),s(e,L,t),s(e,ke,t),c(E,e,t),s(e,Xe,t),s(e,Q,t),s(e,Ge,t),c(A,e,t),s(e,Re,t),s(e,H,t),s(e,Ie,t),c(N,e,t),s(e,Be,t),s(e,Y,t),s(e,We,t),s(e,q,t),s(e,$e,t),c(S,e,t),s(e,xe,t),s(e,P,t),s(e,Ce,t),s(e,K,t),s(e,ve,t),s(e,O,t),Fe=!0},p:pt,i(e){Fe||(M(y.$$.fragment,e),M(T.$$.fragment,e),M(g.$$.fragment,e),M(Z.$$.fragment,e),M(k.$$.fragment,e),M(G.$$.fragment,e),M(I.$$.fragment,e),M(B.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(F.$$.fragment,e),M(E.$$.fragment,e),M(A.$$.fragment,e),M(N.$$.fragment,e),M(S.$$.fragment,e),Fe=!0)},o(e){u(y.$$.fragment,e),u(T.$$.fragment,e),u(g.$$.fragment,e),u(Z.$$.fragment,e),u(k.$$.fragment,e),u(G.$$.fragment,e),u(I.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(C.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),Fe=!1},d(e){e&&(l(te),l(D),l(le),l(se),l(ne),l(b),l(ae),l(h),l(oe),l(J),l(re),l(j),l(ie),l(pe),l(U),l(me),l(ce),l(_),l(Me),l(ue),l(X),l(de),l(fe),l(R),l(we),l(ye),l(Te),l(W),l(be),l(he),l(x),l(Je),l(je),l(v),l(ge),l(Ue),l(V),l(Ze),l(z),l(_e),l(L),l(ke),l(Xe),l(Q),l(Ge),l(Re),l(H),l(Ie),l(Be),l(Y),l(We),l(q),l($e),l(xe),l(P),l(Ce),l(K),l(ve),l(O)),l(f),d(y,e),d(T,e),d(g,e),d(Z,e),d(k,e),d(G,e),d(I,e),d(B,e),d($,e),d(C,e),d(F,e),d(E,e),d(A,e),d(N,e),d(S,e)}}}const yt='{"title":"XLA Integration for TensorFlow Models","local":"xla-integration-for-tensorflow-models","sections":[{"title":"Running TF functions with XLA","local":"running-tf-functions-with-xla","sections":[],"depth":2},{"title":"Running a TF text generation model with XLA from 🤗 Transformers","local":"running-a-tf-text-generation-model-with-xla-from--transformers","sections":[],"depth":2},{"title":"Gotchas to be aware of","local":"gotchas-to-be-aware-of","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function Tt(Ve){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ut extends ct{constructor(f){super(),Mt(this,f,Tt,wt,it,{})}}export{Ut as component};
