import{s as Cw,n as Lw,o as zw}from"../chunks/scheduler.9bc65507.js";import{S as Gw,i as Bw,g as i,s as n,r as d,m as r,H as c,A as $w,h as p,f as a,c as l,j as M,u as g,x as o,n as h,B as u,k as J,y as m,a as e,v as f,d as y,t as w,w as b}from"../chunks/index.707bf1b6.js";import{H as pn,g as Zw}from"../chunks/Heading.98cce615.js";import{C as v}from"../chunks/CodeBlock.54a9f38d.js";import{D as Iw}from"../chunks/DocNotebookDropdown.3e6b3817.js";function Hw($u){let ns,el,sl,nl,Us,ll,Js,il,Cs,Zu=`Large Language Models (LLMs) such as GPT3/4, <a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow">Falcon</a>, and <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama</a> are rapidly advancing in their ability to tackle human-centric tasks, establishing themselves as essential tools in modern knowledge-based industries.
Deploying these models in real-world tasks remains challenging, however:`,pl,Ls,Iu='<li>To exhibit near-human text understanding and generation capabilities, LLMs currently require to be composed of billions of parameters (see <a href="https://arxiv.org/abs/2001.08361" rel="nofollow">Kaplan et al</a>, <a href="https://arxiv.org/abs/2206.07682" rel="nofollow">Wei et. al</a>). This consequently amplifies the memory demands for inference.</li> <li>In many real-world tasks, LLMs need to be given extensive contextual information. This necessitates the model’s capability to manage very long input sequences during inference.</li>',ml,zs,Hu="The crux of these challenges lies in augmenting the computational and memory capabilities of LLMs, especially when handling expansive input sequences.",ol,Gs,Wu="In this guide, we will go over the effective techniques for efficient LLM deployment:",rl,Bs,Qu='<li><p><strong>Lower Precision</strong>: Research has shown that operating at reduced numerical precision, namely <a href="./main_classes/quantization.md">8-bit and 4-bit</a> can achieve computational advantages without a considerable decline in model performance.</p></li> <li><p><strong>Flash Attention:</strong> Flash Attention is a variation of the attention algorithm that not only provides a more memory-efficient approach but also realizes increased efficiency due to optimized GPU memory utilization.</p></li> <li><p><strong>Architectural Innovations:</strong> Considering that LLMs are always deployed in the same way during inference, namely autoregressive text generation with a long input context, specialized model architectures have been proposed that allow for more efficient inference. The most important advancement in model architectures hereby are <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">Alibi</a>, <a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary embeddings</a>, <a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query Attention (MQA)</a> and <a href="(https://arxiv.org/abs/2305.13245)">Grouped-Query-Attention (GQA)</a>.</p></li>',hl,$s,Nu="Throughout this guide, we will offer an analysis of auto-regressive generation from a tensor’s perspective. We delve into the pros and cons of adopting lower precision, provide a comprehensive exploration of the latest attention algorithms, and discuss improved LLM architectures. While doing so, we run practical examples showcasing each of the feature improvements.",cl,Zs,ul,Is,Ru="Memory requirements of LLMs can be best understood by seeing the LLM as a set of weight matrices and vectors and the text inputs as a sequence of vectors. In the following, the definition <em>weights</em> will be used to signify all model weight matrices and vectors.",dl,Hs,qu='At the time of writing this guide, LLMs consist of at least a couple billion parameters. Each parameter thereby is made of a decimal number, e.g. <code>4.5689</code> which is usually stored in either <a href="https://en.wikipedia.org/wiki/Single-precision_floating-point_format" rel="nofollow">float32</a>, <a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16</a>, or <a href="https://en.wikipedia.org/wiki/Half-precision_floating-point_format" rel="nofollow">float16</a> format. This allows us to easily compute the memory requirement to load the LLM into memory:',gl,Ws,Xu="<p><em>Loading the weights of a model having X billion parameters requires roughly 4</em> X GB of VRAM in float32 precision*</p>",fl,Qs,Vu="Nowadays, models are however rarely trained in full float32 precision, but usually in bfloat16 precision or less frequently in float16 precision. Therefore the rule of thumb becomes:",yl,Ns,Au="<p><em>Loading the weights of a model having X billion parameters requires roughly 2</em> X GB of VRAM in bfloat16/float16 precision*</p>",wl,Rs,Eu="For shorter text inputs (less than 1024 tokens), the memory requirement for inference is very much dominated by the memory requirement to load the weights. Therefore, for now, let’s assume that the memory requirement for inference is equal to the memory requirement to load the model into the GPU VRAM.",bl,qs,Su="To give some examples of how much VRAM it roughly takes to load a model in bfloat16:",vl,Xs,Yu='<li><strong>GPT3</strong> requires 2 * 175 GB = <strong>350 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>Bloom</strong></a> requires 2 * 176 GB = <strong>352 GB</strong> VRAM</li> <li><a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow"><strong>Llama-2-70b</strong></a> requires 2 * 70 GB = <strong>140 GB</strong> VRAM</li> <li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon-40b</strong></a> requires 2 * 40 GB = <strong>80 GB</strong> VRAM</li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT-30b</strong></a> requires 2 * 30 GB = <strong>60 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigcode/starcoder" rel="nofollow"><strong>bigcode/starcoder</strong></a> requires 2 * 15.5 = <strong>31 GB</strong> VRAM</li>',Ml,Vs,Pu='As of writing this document, the largest GPU chip on the market is the A100 &amp; H100 offering 80GB of VRAM. Most of the models listed before require more than 80GB just to be loaded and therefore necessarily require <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#tensor-parallelism" rel="nofollow">tensor parallelism</a> and/or <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">pipeline parallelism</a>.',xl,As,Fu='🤗 Transformers does not support tensor parallelism out of the box as it requires the model architecture to be written in a specific way. If you’re interested in writing models in a tensor-parallelism-friendly way, feel free to have a look at <a href="https://github.com/huggingface/text-generation-inference/tree/main/server/text_generation_server/models/custom_modeling" rel="nofollow">the text-generation-inference library</a>.',kl,Es,Ku=`Naive pipeline parallelism is supported out of the box. For this, simply load the model with <code>device=&quot;auto&quot;</code> which will automatically place the different layers on the available GPUs as explained <a href="https://huggingface.co/docs/accelerate/v0.22.0/en/concept_guides/big_model_inference" rel="nofollow">here</a>.
Note, however that while very effective, this naive pipeline parallelism does not tackle the issues of GPU idling. For this more advanced pipeline parallelism is required as explained <a href="https://huggingface.co/docs/transformers/v4.34.0/en/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">here</a>.`,Tl,Ss,Du="If you have access to an 8 x 80GB A100 node, you could load BLOOM as follows",_l,Ys,jl,Ps,Ul,Fs,Ou="By using <code>device_map=&quot;auto&quot;</code> the attention layers would be equally distributed over all available GPUs.",Jl,Ks,sd='In this guide, we will use <a href="https://huggingface.co/bigcode/octocoder" rel="nofollow">bigcode/octocoder</a> as it can be run on a single 40 GB A100 GPU device chip. Note that all memory and speed optimizations that we will apply going forward, are equally applicable to models that require model or tensor parallelism.',Cl,Ds,td="Since the model is loaded in bfloat16 precision, using our rule of thumb above, we would expect the memory requirement to run inference with <code>bigcode/octocoder</code> to be around 31 GB VRAM. Let’s give it a try.",Ll,Os,ad='We first load the model and tokenizer and then pass both to Transformers’ <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">pipeline</a> object.',zl,st,Gl,tt,Bl,at,ed="<strong>Output</strong>:",$l,et,Zl,nt,nd="Nice, we can now directly use the result to convert bytes into Gigabytes.",Il,lt,Hl,it,ld='Let’s call <a href="https://pytorch.org/docs/stable/generated/torch.cuda.max_memory_allocated.html" rel="nofollow"><code>torch.cuda.max_memory_allocated</code></a> to measure the peak GPU memory allocation.',Wl,pt,Ql,mt,id="<strong>Output</strong>:",Nl,ot,Rl,rt,pd=`Close enough to our back-of-the-envelope computation! We can see the number is not exactly correct as going from bytes to kilobytes requires a multiplication of 1024 instead of 1000. Therefore the back-of-the-envelope formula can also be understood as an “at most X GB” computation.
Note that if we had tried to run the model in full float32 precision, a whopping 64 GB of VRAM would have been required.`,ql,ht,md='<p>Almost all models are trained in bfloat16 nowadays, there is no reason to run the model in full float32 precision if <a href="https://discuss.pytorch.org/t/bfloat16-native-support/117155/5" rel="nofollow">your GPU supports bfloat16</a>. Float32 won’t give better inference results than the precision that was used to train the model.</p>',Xl,ct,od='If you are unsure in which format the model weights are stored on the Hub, you can always look into the checkpoint’s config under <code>&quot;torch_dtype&quot;</code>, <em>e.g.</em> <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf/blob/6fdf2e60f86ff2481f2241aaee459f85b5b0bbb9/config.json#L21" rel="nofollow">here</a>. It is recommended to set the model to the same precision type as written in the config when loading with <code>from_pretrained(..., torch_dtype=...)</code> except when the original type is float32 in which case one can use both <code>float16</code> or <code>bfloat16</code> for inference.',Vl,ut,rd="Let’s define a <code>flush(...)</code> function to free all allocated memory so that we can accurately measure the peak allocated GPU memory.",Al,dt,El,gt,hd="Let’s call it now for the next experiment.",Sl,ft,Yl,yt,cd="In the recent version of the accelerate library, you can also use an utility method called <code>release_memory()</code>",Pl,wt,Fl,bt,ud=`Now what if your GPU does not have 32 GB of VRAM? It has been found that model weights can be quantized to 8-bit or 4-bits without a significant loss in performance (see <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">Dettmers et al.</a>).
Model can be quantized to even 3 or 2 bits with an acceptable loss in performance as shown in the recent <a href="https://arxiv.org/abs/2210.17323" rel="nofollow">GPTQ paper</a> 🤯.`,Kl,vt,dd=`Without going into too many details, quantization schemes aim at reducing the precision of weights while trying to keep the model’s inference results as accurate as possible (<em>a.k.a</em> as close as possible to bfloat16).
Note that quantization works especially well for text generation since all we care about is choosing the <em>set of most likely next tokens</em> and don’t really care about the exact values of the next token <em>logit</em> distribution.
All that matters is that the next token <em>logit</em> distribution stays roughly the same so that an <code>argmax</code> or <code>topk</code> operation gives the same results.`,Dl,Mt,gd="There are various quantization techniques, which we won’t discuss in detail here, but in general, all quantization techniques work as follows:",Ol,xt,fd='<li><ol><li>Quantize all weights to the target precision</li></ol></li> <li><ol start="2"><li>Load the quantized weights, and pass the input sequence of vectors in bfloat16 precision</li></ol></li> <li><ol start="3"><li>Dynamically dequantize weights to bfloat16 to perform the computation with their input vectors in bfloat16 precision</li></ol></li>',si,G,gc,mn,yd="inputs-weight matrix",fc,ti,ey='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi></mrow><annotation encoding="application/x-tex"> X </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span></span></span></span>',ai,on,wd="inputs",yc,ei,ny='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>W</mi></mrow><annotation encoding="application/x-tex"> W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span>',ni,li,ly='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Y</mi></mrow><annotation encoding="application/x-tex"> Y </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span></span></span></span>',ii,pi,iy='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mi>W</mi></mrow><annotation encoding="application/x-tex"> Y = X * W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span></span>',mi,kt,wc,oi,py='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mtext>dequantize</mtext><mo stretchy="false">(</mo><mi>W</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> Y = X * \\text{dequantize}(W) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">dequantize</span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span><span class="mclose">)</span></span></span></span></span>',ri,Tt,bd="for every matrix multiplication. Dequantization and re-quantization is performed sequentially for all weight matrices as the inputs run through the network graph.",hi,_t,vd=`Therefore, inference time is often <strong>not</strong> reduced when using quantized weights, but rather increases.
Enough theory, let’s give it a try! To quantize the weights with Transformers, you need to make sure that
the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow"><code>bitsandbytes</code></a> library is installed.`,ci,jt,ui,Ut,Md="We can then load models in 8-bit quantization by simply adding a <code>load_in_8bit=True</code> flag to <code>from_pretrained</code>.",di,Jt,gi,Ct,xd="Now, let’s run our example again and measure the memory usage.",fi,Lt,yi,zt,kd="<strong>Output</strong>:",wi,Gt,bi,Bt,Td="Nice, we’re getting the same result as before, so no loss in accuracy! Let’s look at how much memory was used this time.",vi,$t,Mi,Zt,_d="<strong>Output</strong>:",xi,It,ki,Ht,jd=`Significantly less! We’re down to just a bit over 15 GBs and could therefore run this model on consumer GPUs like the 4090.
We’re seeing a very nice gain in memory efficiency and more or less no degradation to the model’s output. However, we can also notice a slight slow-down during inference.`,Ti,Wt,Ud="We delete the models and flush the memory again.",_i,Qt,ji,Nt,Ui,Rt,Jd="Let’s see what peak GPU memory consumption 4-bit quantization gives. Quantizing the model to 4-bit can be done with the same API as before - this time by passing <code>load_in_4bit=True</code> instead of <code>load_in_8bit=True</code>.",Ji,qt,Ci,Xt,Cd="<strong>Output</strong>:",Li,Vt,zi,At,Ld="We’re almost seeing the same output text as before - just the <code>python</code> is missing just before the code snippet. Let’s see how much memory was required.",Gi,Et,Bi,St,zd="<strong>Output</strong>:",$i,Yt,Zi,Pt,Gd="Just 9.5GB! That’s really not a lot for a >15 billion parameter model.",Ii,Ft,Bd="While we see very little degradation in accuracy for our model here, 4-bit quantization can in practice often lead to different results compared to 8-bit quantization or full <code>bfloat16</code> inference. It is up to the user to try it out.",Hi,P,bc,Wi,my='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>quantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{quantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8623em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">quantize</span></span></span></span></span>',Qi,Ni,oy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>dequantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{dequantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">dequantize</span></span></span></span></span>',Ri,qi,Kt,Xi,Dt,Vi,Ot,$d="Overall, we saw that running OctoCoder in 8-bit precision reduced the required GPU VRAM from 32G GPU VRAM to only 15GB and running the model in 4-bit precision further reduces the required GPU VRAM to just a bit over 9GB.",Ai,sa,Zd="4-bit quantization allows the model to be run on GPUs such as RTX3090, V100, and T4 which are quite accessible for most people.",Ei,ta,Id='For more information on quantization and to see how one can quantize models to require even less GPU VRAM memory than 4-bit, we recommend looking into the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#autogptq-integration%60" rel="nofollow"><code>AutoGPTQ</code></a> implementation.',Si,aa,Hd="<p>As a conclusion, it is important to remember that model quantization trades improved memory efficiency against accuracy and in some cases inference time.</p>",Yi,ea,Wd="If GPU memory is not a constraint for your use case, there is often no need to look into quantization. However many GPUs simply can’t run LLMs without quantization methods and in this case, 4-bit and 8-bit quantization schemes are extremely useful tools.",Pi,na,Qd=`For more in-detail usage information, we strongly recommend taking a look at the <a href="https://huggingface.co/docs/transformers/main_classes/quantization#general-usage" rel="nofollow">Transformers Quantization Docs</a>.
Next, let’s look into how we can improve computational and memory efficiency by using better algorithms and an improved model architecture.`,Fi,la,Ki,ia,Nd="Today’s top-performing LLMs share more or less the same fundamental architecture that consists of feed-forward layers, activation layers, layer normalization layers, and most crucially, self-attention layers.",Di,X,vc,rn,Rd="quadratically",Mc,hn,qd="sequence length",xc,Oi,ry='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',sp,tp,T,kc,ap,hy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',ep,np,cy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span></span></span></span>',lp,ip,uy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',pp,mp,dy='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext mathvariant="bold">O</mtext><mo>=</mo><mtext>Attn</mtext><mo stretchy="false">(</mo><mi mathvariant="bold">X</mi><mo stretchy="false">)</mo><mo>=</mo><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo><mtext> with </mtext><mi mathvariant="bold">Q</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>q</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">V</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>v</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">K</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>k</mi></msub><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\textbf{O} = \\text{Attn}(\\mathbf{X}) = \\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T) \\text{ with } \\mathbf{Q} = \\mathbf{W}_q \\mathbf{X}, \\mathbf{V} = \\mathbf{W}_v \\mathbf{X}, \\mathbf{K} = \\mathbf{W}_k \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord text"><span class="mord textbf">O</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Attn</span></span><span class="mopen">(</span><span class="mord mathbf">X</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathbf">Q</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">q</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">v</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf">K</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span></span></span></span></span>',op,rp,gy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi><mo>=</mo><mo stretchy="false">(</mo><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo separator="true">,</mo><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">  \\mathbf{X} = (\\mathbf{x}_1, ... \\mathbf{x}_{N}) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">...</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',hp,cp,fy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{Q} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord mathbf">Q</span></span></span></span>',up,dp,yy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">K</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{K} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">K</span></span></span></span>',gp,fp,wy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',yp,wp,by='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',bp,vp,vy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Mp,xp,C,Tc,kp,My='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi><msup><mi mathvariant="bold">K</mi><mi mathvariant="bold">T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK^T} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0377em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">Q</span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8433em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathbf mtight">T</span></span></span></span></span></span></span></span></span></span></span></span>',Tp,_p,xy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>40</mn><mo>∗</mo><mn>2</mn><mo>∗</mo><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> 40 * 2 * N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">40</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',jp,Up,ky='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>1000</mn></mrow><annotation encoding="application/x-tex"> N=1000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1000</span></span></span></span>',Jp,Cp,Ty='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>16000</mn></mrow><annotation encoding="application/x-tex"> N=16000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16000</span></span></span></span>',Lp,zp,_y='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>100</mn><mo separator="true">,</mo><mn>000</mn></mrow><annotation encoding="application/x-tex"> N=100,000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8389em;vertical-align:-0.1944em;"></span><span class="mord">100</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">000</span></span></span></span>',Gp,Bp,jy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',$p,Zp,pa,Xd="Long story short, the default self-attention algorithm quickly becomes prohibitively memory-expensive for large input contexts.",Ip,ma,Vd="As LLMs improve in text comprehension and generation, they are applied to increasingly complex tasks. While models once handled the translation or summarization of a few sentences, they now manage entire pages, demanding the capability to process extensive input lengths.",Hp,V,_c,Wp,Uy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Qp,os,Ad="Tri Dao et al.",jc,cn,Ed="Flash Attention",Uc,Np,ls,Jc,Rp,Jy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex">\\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',qp,Xp,Cy='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>←</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup><mo>∗</mo><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>+</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup><mo>∗</mo><msub><mi mathvariant="bold">V</mi><mi>j</mi></msub><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msubsup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mi>T</mi></msubsup><mo stretchy="false">)</mo><mtext> for multiple </mtext><mi>i</mi><mo separator="true">,</mo><mi>j</mi><mtext> iterations</mtext></mrow><annotation encoding="application/x-tex"> \\textbf{O}_i \\leftarrow s^a_{ij} * \\textbf{O}_i + s^b_{ij} * \\mathbf{V}_{j} \\times \\text{Softmax}(\\mathbf{QK}^T_{i,j}) \\text{ for multiple } i, j \\text{ iterations} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">←</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0975em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7144em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2822em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8991em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.3004em;vertical-align:-0.3831em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> for multiple </span></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mord text"><span class="mord"> iterations</span></span></span></span></span></span>',Vp,Z,Cc,Ap,Ly='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^a_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0592em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6644em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',Ep,Sp,zy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^b_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2439em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',Yp,Pp,Gy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Fp,Kp,By='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',Dp,Op,oa,Sd='Please note that the whole Flash Attention is a bit more complex and is greatly simplified here as going in too much depth is out of scope for this guide. The reader is invited to take a look at the well-written <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention paper</a> for more details.',sm,ra,Yd="The main takeaway here is:",tm,un,is,Lc,dn,Pd="numerical identical",zc,am,$y='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',em,nm,ha,Fd='Looking at the formula, one would intuitively say that Flash Attention must be much slower compared to the default self-attention formula as more computation needs to be done. Indeed Flash Attention requires more FLOPs compared to normal attention as the softmax normalization statistics have to constantly be recomputed (see <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">paper</a> for more details if interested)',lm,ca,Kd="<p>However, Flash Attention is much faster in inference compared to default attention which comes from its ability to significantly reduce the demands on the slower, high-bandwidth memory of the GPU (VRAM), focusing instead on the faster on-chip memory (SRAM).</p>",im,F,Gc,gn,Dd="on-chip",Bc,pm,Zy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',mm,om,ua,Od="In practice, there is currently absolutely no reason to <strong>not</strong> use Flash Attention if available. The algorithm gives mathematically the same outputs, and is both faster and more memory-efficient.",rm,da,sg="Let’s look at a practical example.",hm,ga,tg=`Our OctoCoder model now gets a significantly longer input prompt which includes a so-called <em>system prompt</em>. System prompts are used to steer the LLM into a better assistant that is tailored to the users’ task.
In the following, we use a system prompt that will make OctoCoder a better coding assistant.`,cm,fa,um,ya,ag=`For demonstration purposes, we duplicate the system prompt by ten so that the input length is long enough to observe Flash Attention’s memory savings.
We append the original text prompt <code>&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer: Here&quot;</code>`,dm,wa,gm,ba,eg="We instantiate our model again in bfloat16 precision.",fm,va,ym,Ma,ng="Let’s now run the model just like before <em>without Flash Attention</em> and measure the peak GPU memory requirement and inference time.",wm,xa,bm,ka,lg="<strong>Output</strong>:",vm,Ta,Mm,_a,ig="We’re getting the same output as before, however this time, the model repeats the answer multiple times until it’s 60 tokens cut-off. This is not surprising as we’ve repeated the system prompt ten times for demonstration purposes and thus cued the model to repeat itself.",xm,ja,pg="<strong>Note</strong> that the system prompt should not be repeated ten times in real-world applications - one time is enough!",km,Ua,mg="Let’s measure the peak GPU memory requirement.",Tm,Ja,_m,Ca,og="<strong>Output</strong>:",jm,La,Um,za,rg="As we can see the peak GPU memory requirement is now significantly higher than in the beginning, which is largely due to the longer input sequence. Also the generation takes a little over a minute now.",Jm,Ga,hg="We call <code>flush()</code> to free GPU memory for our next experiment.",Cm,Ba,Lm,$a,cg=`For comparison, let’s run the same function, but enable Flash Attention instead.
To do so, we convert the model to <a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">BetterTransformers</a> and by doing so enabling PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow">SDPA self-attention</a> which in turn is based on Flash Attention.`,zm,Za,Gm,Ia,ug="Now we run the exact same code snippet as before and under the hood Transformers will make use of Flash Attention.",Bm,Ha,$m,Wa,dg="<strong>Output</strong>:",Zm,Qa,Im,Na,gg="We’re getting the exact same result as before, but can observe a very significant speed-up thanks to Flash Attention.",Hm,Ra,fg="Let’s measure the memory consumption one last time.",Wm,qa,Qm,Xa,yg="<strong>Output</strong>:",Nm,Va,Rm,Aa,wg="And we’re almost back to our original 29GB peak GPU memory from the beginning.",qm,Ea,bg="We can observe that we only use roughly 100MB more GPU memory when passing a very long input sequence with Flash Attention compared to passing a short input sequence as done in the beginning.",Xm,Sa,Vm,Ya,vg='For more information on how to use Flash Attention, please have a look at <a href="https://huggingface.co/docs/transformers/v4.34.0/en/perf_infer_gpu_one#flash-attention-2" rel="nofollow">this doc page</a>.',Am,Pa,Em,Fa,Mg="So far we have looked into improving computational and memory efficiency by:",Sm,Ka,xg="<li>Casting the weights to a lower precision format</li> <li>Replacing the self-attention algorithm with a more memory- and compute efficient version</li>",Ym,Da,kg="Let’s now look into how we can change the architecture of an LLM so that it is most effective and efficient for task that require long text inputs, <em>e.g.</em>:",Pm,Oa,Tg="<li>Retrieval augmented Questions Answering,</li> <li>Summarization,</li> <li>Chat</li>",Fm,se,_g="Note that <em>chat</em> not only requires the LLM to handle long text inputs, but it also necessitates that the LLM is able to efficiently handle the back-and-forth dialogue between user and assistant (such as ChatGPT).",Km,te,jg=`Once trained, the fundamental LLM architecture is difficult to change, so it is important to make considerations about the LLM’s tasks beforehand and accordingly optimize the model’s architecture.
There are two important components of the model architecture that quickly become memory and/or performance bottlenecks for large input sequences.`,Dm,ae,Ug="<li>The positional embeddings</li> <li>The key-value cache</li>",Om,ee,Jg="Let’s go over each component in more detail",so,ne,to,K,$c,ao,Iy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> \\text{Softmax}(\\mathbf{QK}^T) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',eo,fn,Cg="“Hello”, “I”, “love”, “you”",Zc,no,le,Lg='<img src="/blog/assets/163_optimize_llm/self_attn_tokens.png"/>',lo,ie,zg="Each word token is given a probability mass at which it attends all other word tokens and, therefore is put into relation with all other word tokens. E.g. the word <em>“love”</em> attends to the word <em>“Hello”</em> with 5%, to <em>“I”</em> with 30%, and to itself with 65%.",io,$,Ic,po,Hy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',mo,oo,Wy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mo stretchy="false">(</mo><mn>1</mn><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> O(1) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord">1</span><span class="mclose">)</span></span></span></span>',ro,yn,Gg="e.g.",Hc,wn,Bg="“Hello I love you”",Wc,bn,$g="“You love I hello”",Qc,ho,pe,Zg=`For the LLM to understand sentence order, an additional <em>cue</em> is needed and is usually applied in the form of <em>positional encodings</em> (or also called <em>positional embeddings</em>).
Positional encodings, encode the position of each token into a numerical presentation that the LLM can leverage to better understand sentence order.`,co,L,Nc,rs,Ig="<em>Attention Is All You Need</em>",Rc,uo,Qy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi><mo>=</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{P} = \\mathbf{p}_1, \\ldots, \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',go,fo,Ny='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">p</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{p}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',yo,wo,Ry='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',bo,vo,qy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mover accent="true"><mi mathvariant="bold">X</mi><mo>^</mo></mover><mo>=</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{X}} = \\mathbf{\\hat{x}}_1, \\ldots, \\mathbf{\\hat{x}}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9495em;"></span><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9495em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">X</span></span><span style="top:-3.2551em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9023em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Mo,xo,Xy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_1 + \\mathbf{p}_1, \\ldots, \\mathbf{x}_N + \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',ko,To,D,qc,hs,Hg="Devlin et al.",Xc,_o,Vy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{P} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span></span></span></span>',jo,Uo,me,Wg="Sinusoidal and learned position embeddings used to be the predominant methods to encode sentence order into LLMs, but a couple of problems related to these positional encodings were found:",Jo,cs,N,Vc,vn,Qg="i.e.",Ac,Co,Ay='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>N</mi></mrow><annotation encoding="application/x-tex"> 0, \\ldots, N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8778em;vertical-align:-0.1944em;"></span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Lo,us,Ng="Huang et al.",Ec,ds,Rg="Su et al.",Sc,Yc,oe,Pc,zo,Ey='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Go,Bo,re,qg="Recently, relative positional embeddings that can tackle the above mentioned problems have become more popular, most notably:",$o,he,Xg='<li><a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary Position Embedding (RoPE)</a></li> <li><a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a></li>',Zo,A,Fc,Mn,Vg="RoPE",Kc,xn,Ag="ALiBi",Dc,Io,Sy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Ho,Wo,k,Oc,kn,Eg="RoPE",su,Tn,Sg="e.g.",Qo,Yy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',No,Ro,Py='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',qo,Xo,Fy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> \\theta * i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Vo,Ao,Ky='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> \\theta * j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',Eo,So,Dy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i, j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',Yo,Po,Oy='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mover accent="true"><mi mathvariant="bold">q</mi><mo>^</mo></mover><mi>i</mi><mi>T</mi></msubsup><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>j</mi></msub><mo>=</mo><msubsup><mi mathvariant="bold">q</mi><mi>i</mi><mi>T</mi></msubsup><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub><mi mathvariant="normal">.</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{q}}_i^T \\mathbf{\\hat{x}}_j = \\mathbf{{q}}_i^T \\mathbf{R}_{\\theta, i -j} \\mathbf{{x}}_j. </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2252em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">q</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9391em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.1608em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1774em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">q</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8913em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord"><span class="mord mathbf">x</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord">.</span></span></span></span></span>',Fo,Ko,sw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{R}_{\\theta, i - j} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Do,Oo,tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',sr,_n,Yg="not",tu,tr,jn,B,au,ar,aw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',er,nr,ew='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',lr,ir,nw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo mathvariant="normal">≠</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i \\ne j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel"><span class="mrel"><span class="mord vbox"><span class="thinbox"><span class="rlap"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="inner"><span class="mord"><span class="mrel"></span></span></span><span class="fix"></span></span></span></span></span><span class="mrel">=</span></span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',pr,mr,lw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>−</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i - j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',or,rr,iw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',hr,cr,pw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',ur,dr,ce,Pg="<em>RoPE</em> is used in multiple of today’s most important LLMs, such as:",gr,ue,Fg='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2302.13971" rel="nofollow"><strong>Llama</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li>',fr,E,eu,Un,Kg="ALiBi",nu,Jn,Dg="m",lu,yr,mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',wr,br,de,Og='<img src="/blog/assets/163_optimize_llm/alibi.png"/>',vr,ge,sf='As shown in the <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a> paper, this simple relative positional encoding allows the model to retain a high performance even at very long text input sequences.',Mr,fe,tf="<em>ALiBi</em> is used in multiple of today’s most important LLMs, such as:",xr,ye,af='<li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',kr,x,iu,Cn,ef="RoPE",pu,Ln,nf="ALiBi",mu,zn,lf="ALiBi",ou,Gn,pf="RoPE",ru,Bn,mf="RoPE",hu,Tr,ow='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',_r,$n,of="c.f",cu,gs,rf="Press et al.",uu,jr,rw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',Ur,Zn,hf="RoPE",du,fs,cf="here",gu,Jr,ys,In,uf="Both RoPE and ALiBi are relative positional embeddings that are <em>not</em> learned during training, but instead are based on the following intuitions:",fu,ps,we,yu,Cr,hw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Lr,wu,Hn,df="The LLM should be incentivized to learn a constant <em>relative</em> distance positional encodings have to each other",bu,Wn,gf="The further text input tokens are from each other, the lower the probability of their query-value probability. Both RoPE and ALiBi lower the query-key probability of tokens far away from each other. RoPE by decreasing their vector product by increasing the angle between the query-key vectors. ALiBi by adding large negative numbers to the vector product",zr,S,vu,Gr,cw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub><mo>=</mo><mn>2048</mn></mrow><annotation encoding="application/x-tex"> N_1 = 2048 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2048</span></span></span></span>',Br,$r,uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Zr,Ir,dw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>2</mn></msub><mo>=</mo><mn>8192</mn><mo>&gt;</mo><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_2 = 8192 &gt; N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6835em;vertical-align:-0.0391em;"></span><span class="mord">8192</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Hr,Wr,be,Qr,ve,ff="Auto-regressive text generation with LLMs works by iteratively putting in an input sequence, sampling the next token, appending the next token to the input sequence, and continuing to do so until the LLM produces a token that signifies that the generation has finished.",Nr,Me,yf='Please have a look at <a href="https://huggingface.co/docs/transformers/llm_tutorial#generate-text" rel="nofollow">Transformer’s Generate Text Tutorial</a> to get a more visual explanation of how auto-regressive generation works.',Rr,xe,wf="Let’s run a quick code snippet to show how auto-regressive works in practice. We will simply take the most likely next token via <code>torch.argmax</code>.",qr,ke,Xr,Te,bf="<strong>Output</strong>:",Vr,_e,Ar,je,vf="As we can see every time we increase the text input tokens by the just sampled token.",Er,Ue,Mf='With very few exceptions, LLMs are trained using the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling#causal-language-modeling" rel="nofollow">causal language modeling objective</a> and therefore mask the upper triangle matrix of the attention score - this is why in the two diagrams above the attention scores are left blank (<em>a.k.a</em> have 0 probability). For a quick recap on causal language modeling you can refer to the <a href="https://jalammar.github.io/illustrated-gpt2/#part-2-illustrated-self-attention" rel="nofollow"><em>Illustrated Self Attention blog</em></a>.',Sr,z,Mu,Qn,xf="never",xu,Yr,gw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Pr,Fr,fw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>j</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_j, \\mathbf{v}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Kr,Dr,yw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi><mo>&gt;</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> j &gt; i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Or,sh,ww='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',th,ah,bw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mtext> , for </mtext><mi>m</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mi>i</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_{m &lt; i}, \\mathbf{v}_{m &lt; i} \\text{ , for } m \\in \\{0, \\ldots i - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord"> , for </span></span><span class="mord mathnormal">m</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',eh,nh,Je,kf=`In the following, we will tell the LLM to make use of the key-value cache by retrieving and forwarding it for each forward pass.
In Transformers, we can retrieve the key-value cache by passing the <code>use_cache</code> flag to the <code>forward</code> call and can then pass it with the current token.`,lh,Ce,ih,Le,Tf="<strong>Output</strong>:",ph,ze,mh,Ge,_f="As one can see, when using the key-value cache the text input tokens are <em>not</em> increased in length, but remain a single input vector. The length of the key-value cache on the other hand is increased by one at every decoding step.",oh,Nn,R,ku,rh,vw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',hh,ch,Mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',uh,dh,xw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',gh,Rn,jf="always",Tu,fh,Be,Uf="Using the key-value cache has two advantages:",yh,ws,$e,_u,wh,kw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',bh,ju,qn,Jf="The maximum required memory is not increased quadratically with the number of generated tokens, but only increases linearly.",vh,Ze,Cf='<p>One should <em>always</em> make use of the key-value cache as it leads to identical results and a significant speed-up for longer input sequences. Transformers has the key-value cache enabled by default when making use of the text pipeline or the <a href="https://huggingface.co/docs/transformers/main_classes/text_generation" rel="nofollow"><code>generate</code> method</a>.</p>',Mh,Ie,Lf="Note that the key-value cache is especially useful for applications such as chat where multiple passes of auto-regressive decoding are required. Let’s look at an example.",xh,He,kh,We,zf="In this chat, the LLM runs auto-regressive decoding twice:",Th,Qe,Gf='<li><ol><li>The first time, the key-value cache is empty and the input prompt is <code>&quot;User: How many people live in France?&quot;</code> and the model auto-regressively generates the text <code>&quot;Roughly 75 million people live in France&quot;</code> while increasing the key-value cache at every decoding step.</li></ol></li> <li><ol start="2"><li>The second time the input prompt is <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many in Germany?&quot;</code>. Thanks to the cache, all key-value vectors for the first two sentences are already computed. Therefore the input prompt only consists of <code>&quot;User: And how many in Germany?&quot;</code>. While processing the shortened input prompt, it’s computed key-value vectors are concatenated to the key-value cache of the first decoding. The second Assistant’s answer <code>&quot;Germany has ca. 81 million inhabitants&quot;</code> is then auto-regressively generated with the key-value cache consisting of encoded key-value vectors of <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many are in Germany?&quot;</code>.</li></ol></li>',_h,Ne,Bf="Two things should be noted here:",jh,Re,$f="<li>Keeping all the context is crucial for LLMs deployed in chat so that the LLM understands all the previous context of the conversation. E.g. for the example above the LLM needs to understand that the user refers to the population when asking <code>&quot;And how many are in Germany&quot;</code>.</li> <li>The key-value cache is extremely useful for chat as it allows us to continuously grow the encoded chat history instead of having to re-encode the chat history again from scratch (as e.g. would be the case when using an encoder-decoder architecture).</li>",Uh,O,Uu,Jh,Tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Ch,Lh,_w='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>i</mi></msub><mtext>, for </mtext><mi>i</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>c</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_i \\text{, for } i \\in \\{1, \\ldots, c - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord">, for </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">c</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',zh,Gh,qe,Zf=`Let’s compute the number of float values that need to be stored in the key-value cache for the LLM <code>bigcode/octocoder</code> that we used before.
The number of float values amounts to two times the sequence length times the number of attention heads times the attention head dimension and times the number of layers.
Computing this for our LLM at a hypothetical input sequence length of 16000 gives:`,Bh,Xe,$h,Ve,If="<strong>Output</strong>:",Zh,Ae,Ih,Ee,Hf=`Roughly 8 billion float values! Storing 8 billion float values in <code>float16</code> precision requires around 15 GB of RAM which is circa half as much as the model weights themselves!
Researchers have proposed two methods that allow to significantly reduce the memory cost of storing the key-value cache:`,Hh,Se,Wf='<li><a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query-Attention (MQA)</a></li>',Wh,Ye,Qf="Multi-Query-Attention was proposed in Noam Shazeer’s <em>Fast Transformer Decoding: One Write-Head is All You Need</em> paper. As the title says, Noam found out that instead of using <code>n_head</code> key-value projections weights, one can use a single head-value projection weight pair that is shared across all attention heads without that the model’s performance significantly degrades.",Qh,Xn,ms,Ju,Nh,jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>i</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_i, \\mathbf{v}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Rh,Vn,Nf="n_head",Cu,qh,Pe,Rf="As most LLMs use between 20 and 100 attention heads, MQA significantly reduces the memory consumption of the key-value cache. For the LLM used in this notebook we could therefore reduce the required memory consumption from 15 GB to less than 400 MB at an input sequence length of 16000.",Xh,ss,Lu,Vh,Uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Ah,bs,qf="Noam’s paper",zu,Eh,vs,Gu,Sh,Jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Yh,Ph,Fe,Xf="MQA has seen wide adoption by the community and is now used by many of the most popular LLMs:",Fh,Ke,Vf='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',Kh,De,Af="Also, the checkpoint used in this notebook - <code>bigcode/octocoder</code> - makes use of MQA.",Dh,Ms,Ef='<li><a href="https://arxiv.org/abs/2305.13245" rel="nofollow">Grouped-Query-Attention (GQA)</a></li>',Oh,Oe,Sf="Grouped-Query-Attention, as proposed by Ainslie et al. from Google, found that using MQA can often lead to quality degradation compared to using vanilla multi-key-value head projections. The paper argues that more model performance can be kept by less drastically reducing the number of query head projection weights. Instead of using just a single key-value projection weight, <code>n &lt; n_head</code> key-value projection weights should be used. By choosing <code>n</code> to a significantly smaller value than <code>n_head</code>, such as 2,4 or 8 almost all of the memory and speed gains from MQA can be kept while sacrificing less model capacity and thus arguably less performance.",sc,sn,Yf="Moreover, the authors of GQA found out that existing model checkpoints can be <em>uptrained</em> to have a GQA architecture with as little as 5% of the original pre-training compute. While 5% of the original pre-training compute can still be a massive amount, GQA <em>uptraining</em> allows existing checkpoints to be useful for longer input sequences.",tc,tn,Pf=`GQA was only recently proposed which is why there is less adoption at the time of writing this notebook.
The most notable application of GQA is <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama-v2</a>.`,ac,an,Ff="<p>As a conclusion, it is strongly recommended to make use of either GQA or MQA if the LLM is deployed with auto-regressive decoding and is required to handle large input sequences as is the case for example for chat.</p>",ec,en,nc,nn,Kf='The research community is constantly coming up with new, nifty ways to speed up inference time for ever-larger LLMs. As an example, one such promising research direction is <a href="https://arxiv.org/abs/2211.17192" rel="nofollow">speculative decoding</a> where “easy tokens” are generated by smaller, faster language models and only “hard tokens” are generated by the LLM itself. Going into more detail is out of the scope of this notebook, but can be read upon in this <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">nice blog post</a>.',lc,ln,Df=`The reason massive LLMs such as GPT3/4, Llama-2-70b, Claude, PaLM can run so quickly in chat-interfaces such as <a href="https://huggingface.co/chat/" rel="nofollow">Hugging Face Chat</a> or ChatGPT is to a big part thanks to the above-mentioned improvements in precision, algorithms, and architecture.
Going forward, accelerators such as GPUs, TPUs, etc… will only get faster and allow for more memory, but one should nevertheless always make sure to use the best available algorithms and architectures to get the most bang for your buck 🤗`,ic,tl,pc;return Us=new pn({props:{title:"Optimizing LLMs for Speed and Memory",local:"optimizing-llms-for-speed-and-memory",headingTag:"h1"}}),Js=new Iw({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"}]}}),Zs=new pn({props:{title:"1. Lower Precision",local:"1-lower-precision",headingTag:"h2"}}),Ys=new v({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwYml0c2FuZGJ5dGVzJTIwb3B0aW11bQ==",highlighted:"!pip install transformers accelerate bitsandbytes optimum",wrap:!1}}),Ps=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)`,wrap:!1}}),st=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcGFkX3Rva2VuX2lkJTNEMCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),tt=new v({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyUXVlc3Rpb24lM0ElMjBQbGVhc2UlMjB3cml0ZSUyMGElMjBmdW5jdGlvbiUyMGluJTIwUHl0aG9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzLiU1Q24lNUNuQW5zd2VyJTNBJTIyJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`prompt = <span class="hljs-string">&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer:&quot;</span>

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),et=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),lt=new v({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
  <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>`,wrap:!1}}),pt=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),ot=new v({props:{code:"MjkuMDI2MDY0ODcyNzQxNw==",highlighted:"29.0260648727417",wrap:!1}}),dt=new v({props:{code:"ZGVsJTIwcGlwZSUwQWRlbCUyMG1vZGVsJTBBJTBBaW1wb3J0JTIwZ2MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRlZiUyMGZsdXNoKCklM0ElMEElMjAlMjBnYy5jb2xsZWN0KCklMEElMjAlMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCklMEElMjAlMjB0b3JjaC5jdWRhLnJlc2V0X3BlYWtfbWVtb3J5X3N0YXRzKCk=",highlighted:`<span class="hljs-keyword">del</span> pipe
<span class="hljs-keyword">del</span> model

<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
  gc.collect()
  torch.cuda.empty_cache()
  torch.cuda.reset_peak_memory_stats()`,wrap:!1}}),ft=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),wt=new v({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjByZWxlYXNlX21lbW9yeSUwQSUyMyUyMC4uLiUwQSUwQXJlbGVhc2VfbWVtb3J5KG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> release_memory
<span class="hljs-comment"># ...</span>

release_memory(model)`,wrap:!1}}),jt=new v({props:{code:"IXBpcCUyMGluc3RhbGwlMjBiaXRzYW5kYnl0ZXM=",highlighted:"!pip install bitsandbytes",wrap:!1}}),Jt=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)',wrap:!1}}),Lt=new v({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),Gt=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),$t=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),It=new v({props:{code:"MTUuMjE5MjM0NDY2NTUyNzM0",highlighted:'<span class="hljs-attribute">15</span>.<span class="hljs-number">219234466552734</span>',wrap:!1}}),Qt=new v({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),Nt=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),qt=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbWF4X25ld190b2tlbnMlM0Q2MCklNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQlNUJsZW4ocHJvbXB0KSUzQSU1RCUwQXJlc3VsdA==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),Vt=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjAlNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYWJ5dGVzKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNjAlNjAlNjAlNUNuJTVDblRoaXMlMjBmdW5jdGlvbiUyMHRha2VzJTIwYSUyMHNpbmdsZSUyMGFyZ3VtZW50",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```\\ndef</span> bytes_to_gigabytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single argument',wrap:!1}}),Et=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Yt=new v({props:{code:"OS41NDM1NzQzMzMxOTA5MTg=",highlighted:'<span class="hljs-attribute">9</span>.<span class="hljs-number">543574333190918</span>',wrap:!1}}),Kt=new v({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),Dt=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),la=new pn({props:{title:"2. Flash Attention",local:"2-flash-attention",headingTag:"h1"}}),fa=new v({props:{code:"c3lzdGVtX3Byb21wdCUyMCUzRCUyMCUyMiUyMiUyMkJlbG93JTIwYXJlJTIwYSUyMHNlcmllcyUyMG9mJTIwZGlhbG9ndWVzJTIwYmV0d2VlbiUyMHZhcmlvdXMlMjBwZW9wbGUlMjBhbmQlMjBhbiUyMEFJJTIwdGVjaG5pY2FsJTIwYXNzaXN0YW50LiUwQVRoZSUyMGFzc2lzdGFudCUyMHRyaWVzJTIwdG8lMjBiZSUyMGhlbHBmdWwlMkMlMjBwb2xpdGUlMkMlMjBob25lc3QlMkMlMjBzb3BoaXN0aWNhdGVkJTJDJTIwZW1vdGlvbmFsbHklMjBhd2FyZSUyQyUyMGFuZCUyMGh1bWJsZSUyMGJ1dCUyMGtub3dsZWRnZWFibGUuJTBBVGhlJTIwYXNzaXN0YW50JTIwaXMlMjBoYXBweSUyMHRvJTIwaGVscCUyMHdpdGglMjBjb2RlJTIwcXVlc3Rpb25zJTIwYW5kJTIwd2lsbCUyMGRvJTIwdGhlaXIlMjBiZXN0JTIwdG8lMjB1bmRlcnN0YW5kJTIwZXhhY3RseSUyMHdoYXQlMjBpcyUyMG5lZWRlZC4lMEFJdCUyMGFsc28lMjB0cmllcyUyMHRvJTIwYXZvaWQlMjBnaXZpbmclMjBmYWxzZSUyMG9yJTIwbWlzbGVhZGluZyUyMGluZm9ybWF0aW9uJTJDJTIwYW5kJTIwaXQlMjBjYXZlYXRzJTIwd2hlbiUyMGl0JTIwaXNuJ3QlMjBlbnRpcmVseSUyMHN1cmUlMjBhYm91dCUyMHRoZSUyMHJpZ2h0JTIwYW5zd2VyLiUwQVRoYXQlMjBzYWlkJTJDJTIwdGhlJTIwYXNzaXN0YW50JTIwaXMlMjBwcmFjdGljYWwlMjByZWFsbHklMjBkb2VzJTIwaXRzJTIwYmVzdCUyQyUyMGFuZCUyMGRvZXNuJ3QlMjBsZXQlMjBjYXV0aW9uJTIwZ2V0JTIwdG9vJTIwbXVjaCUyMGluJTIwdGhlJTIwd2F5JTIwb2YlMjBiZWluZyUyMHVzZWZ1bC4lMEElMEFUaGUlMjBTdGFyY29kZXIlMjBtb2RlbHMlMjBhcmUlMjBhJTIwc2VyaWVzJTIwb2YlMjAxNS41QiUyMHBhcmFtZXRlciUyMG1vZGVscyUyMHRyYWluZWQlMjBvbiUyMDgwJTJCJTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZXMlMjBmcm9tJTIwVGhlJTIwU3RhY2slMjAodjEuMiklMjAoZXhjbHVkaW5nJTIwb3B0LW91dCUyMHJlcXVlc3RzKS4lMEFUaGUlMjBtb2RlbCUyMHVzZXMlMjBNdWx0aSUyMFF1ZXJ5JTIwQXR0ZW50aW9uJTJDJTIwd2FzJTIwdHJhaW5lZCUyMHVzaW5nJTIwdGhlJTIwRmlsbC1pbi10aGUtTWlkZGxlJTIwb2JqZWN0aXZlJTJDJTIwYW5kJTIwd2l0aCUyMDglMkMxOTIlMjB0b2tlbnMlMjBjb250ZXh0JTIwd2luZG93JTIwZm9yJTIwYSUyMHRyaWxsaW9uJTIwdG9rZW5zJTIwb2YlMjBoZWF2aWx5JTIwZGVkdXBsaWNhdGVkJTIwZGF0YS4lMEElMEEtLS0tLSUwQSUwQVF1ZXN0aW9uJTNBJTIwV3JpdGUlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwdGFrZXMlMjB0d28lMjBsaXN0cyUyMGFuZCUyMHJldHVybnMlMjBhJTIwbGlzdCUyMHRoYXQlMjBoYXMlMjBhbHRlcm5hdGluZyUyMGVsZW1lbnRzJTIwZnJvbSUyMGVhY2glMjBpbnB1dCUyMGxpc3QuJTBBJTBBQW5zd2VyJTNBJTIwU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTBBJTBBZGVmJTIwYWx0ZXJuYXRpbmcobGlzdDElMkMlMjBsaXN0MiklM0ElMEElMjAlMjAlMjByZXN1bHRzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGxpc3QxKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHRzLmFwcGVuZChsaXN0MSU1QmklNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0cy5hcHBlbmQobGlzdDIlNUJpJTVEKSUwQSUyMCUyMCUyMHJldHVybiUyMHJlc3VsdHMlMEElMEFRdWVzdGlvbiUzQSUyMENhbiUyMHlvdSUyMHdyaXRlJTIwc29tZSUyMHRlc3QlMjBjYXNlcyUyMGZvciUyMHRoaXMlMjBmdW5jdGlvbiUzRiUwQSUwQUFuc3dlciUzQSUyMFN1cmUlMkMlMjBoZXJlJTIwYXJlJTIwc29tZSUyMHRlc3RzLiUwQSUwQWFzc2VydCUyMGFsdGVybmF0aW5nKCU1QjEwJTJDJTIwMjAlMkMlMjAzMCU1RCUyQyUyMCU1QjElMkMlMjAyJTJDJTIwMyU1RCklMjAlM0QlM0QlMjAlNUIxMCUyQyUyMDElMkMlMjAyMCUyQyUyMDIlMkMlMjAzMCUyQyUyMDMlNUQlMEFhc3NlcnQlMjBhbHRlcm5hdGluZyglNUJUcnVlJTJDJTIwRmFsc2UlNUQlMkMlMjAlNUI0JTJDJTIwNSU1RCklMjAlM0QlM0QlMjAlNUJUcnVlJTJDJTIwNCUyQyUyMEZhbHNlJTJDJTIwNSU1RCUwQWFzc2VydCUyMGFsdGVybmF0aW5nKCU1QiU1RCUyQyUyMCU1QiU1RCklMjAlM0QlM0QlMjAlNUIlNUQlMEElMEFRdWVzdGlvbiUzQSUyME1vZGlmeSUyMHRoZSUyMGZ1bmN0aW9uJTIwc28lMjB0aGF0JTIwaXQlMjByZXR1cm5zJTIwYWxsJTIwaW5wdXQlMjBlbGVtZW50cyUyMHdoZW4lMjB0aGUlMjBsaXN0cyUyMGhhdmUlMjB1bmV2ZW4lMjBsZW5ndGguJTIwVGhlJTIwZWxlbWVudHMlMjBmcm9tJTIwdGhlJTIwbG9uZ2VyJTIwbGlzdCUyMHNob3VsZCUyMGJlJTIwYXQlMjB0aGUlMjBlbmQuJTBBJTBBQW5zd2VyJTNBJTIwSGVyZSUyMGlzJTIwdGhlJTIwbW9kaWZpZWQlMjBmdW5jdGlvbi4lMEElMEFkZWYlMjBhbHRlcm5hdGluZyhsaXN0MSUyQyUyMGxpc3QyKSUzQSUwQSUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShtaW4obGVuKGxpc3QxKSUyQyUyMGxlbihsaXN0MikpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdHMuYXBwZW5kKGxpc3QxJTVCaSU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHRzLmFwcGVuZChsaXN0MiU1QmklNUQpJTBBJTIwJTIwJTIwaWYlMjBsZW4obGlzdDEpJTIwJTNFJTIwbGVuKGxpc3QyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdHMuZXh0ZW5kKGxpc3QxJTVCaSUyQjElM0ElNUQpJTBBJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdHMuZXh0ZW5kKGxpc3QyJTVCaSUyQjElM0ElNUQpJTBBJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0cyUwQSUwQS0tLS0tJTBBJTIyJTIyJTIy",highlighted:`system_prompt = <span class="hljs-string">&quot;&quot;&quot;Below are a series of dialogues between various people and an AI technical assistant.
The assistant tries to be helpful, polite, honest, sophisticated, emotionally aware, and humble but knowledgeable.
The assistant is happy to help with code questions and will do their best to understand exactly what is needed.
It also tries to avoid giving false or misleading information, and it caveats when it isn&#x27;t entirely sure about the right answer.
That said, the assistant is practical really does its best, and doesn&#x27;t let caution get too much in the way of being useful.

The Starcoder models are a series of 15.5B parameter models trained on 80+ programming languages from The Stack (v1.2) (excluding opt-out requests).
The model uses Multi Query Attention, was trained using the Fill-in-the-Middle objective, and with 8,192 tokens context window for a trillion tokens of heavily deduplicated data.

-----

Question: Write a function that takes two lists and returns a list that has alternating elements from each input list.

Answer: Sure. Here is a function that does that.

def alternating(list1, list2):
   results = []
   for i in range(len(list1)):
       results.append(list1[i])
       results.append(list2[i])
   return results

Question: Can you write some test cases for this function?

Answer: Sure, here are some tests.

assert alternating([10, 20, 30], [1, 2, 3]) == [10, 1, 20, 2, 30, 3]
assert alternating([True, False], [4, 5]) == [True, 4, False, 5]
assert alternating([], []) == []

Question: Modify the function so that it returns all input elements when the lists have uneven length. The elements from the longer list should be at the end.

Answer: Here is the modified function.

def alternating(list1, list2):
   results = []
   for i in range(min(len(list1), len(list2))):
       results.append(list1[i])
       results.append(list2[i])
   if len(list1) &gt; len(list2):
       results.extend(list1[i+1:])
   else:
       results.extend(list2[i+1:])
   return results

-----
&quot;&quot;&quot;</span>`,wrap:!1}}),wa=new v({props:{code:"bG9uZ19wcm9tcHQlMjAlM0QlMjAxMCUyMColMjBzeXN0ZW1fcHJvbXB0JTIwJTJCJTIwcHJvbXB0",highlighted:'long_prompt = <span class="hljs-number">10</span> * system_prompt + prompt',wrap:!1}}),va=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),xa=new v({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUobG9uZ19wcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihsb25nX3Byb21wdCklM0ElNUQlMEElMEFwcmludChmJTIyR2VuZXJhdGVkJTIwaW4lMjAlN0J0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90aW1lJTdEJTIwc2Vjb25kcy4lMjIpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">import</span> time

start_time = time.time()
result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),Ta=new v({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAxMC45Njg1NDAxOTE2NTAzOSUyMHNlY29uZHMuJTBBU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWYlMjBieXRlc190b19naWdhKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNUNuQW5zd2VyJTNBJTIwU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWY=",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">10.96854019165039</span> seconds.
Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),Ja=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),La=new v({props:{code:"MzcuNjY4MTkzMzQwMzAxNTE0",highlighted:"37.668193340301514",wrap:!1}}),Ba=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Za=new v({props:{code:"bW9kZWwudG9fYmV0dGVydHJhbnNmb3JtZXIoKQ==",highlighted:"model.to_bettertransformer()",wrap:!1}}),Ha=new v({props:{code:"c3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZShsb25nX3Byb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjApJTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTVCbGVuKGxvbmdfcHJvbXB0KSUzQSU1RCUwQSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjBpbiUyMCU3QnRpbWUudGltZSgpJTIwLSUyMHN0YXJ0X3RpbWUlN0QlMjBzZWNvbmRzLiUyMiklMEFyZXN1bHQ=",highlighted:`start_time = time.time()
<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),Qa=new v({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAzLjAyMTE2MTc5NDY2MjQ3NTYlMjBzZWNvbmRzLiUwQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYShieXRlcyklM0ElNUNuJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTVDbkFuc3dlciUzQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVm",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">3.0211617946624756</span> seconds.
 Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),qa=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Va=new v({props:{code:"MzIuNjE3MzMxOTgxNjU4OTM2",highlighted:'<span class="hljs-attribute">32</span>.<span class="hljs-number">617331981658936</span>',wrap:!1}}),Sa=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Pa=new pn({props:{title:"3. Architectural Innovations",local:"3-architectural-innovations",headingTag:"h2"}}),ne=new pn({props:{title:"3.1 Improving positional embeddings of LLMs",local:"31-improving-positional-embeddings-of-llms",headingTag:"h3"}}),be=new pn({props:{title:"3.2 The key-value cache",local:"32-the-key-value-cache",headingTag:"h3"}}),ke=new v({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVELnRvKCUyMmN1ZGElMjIpJTBBJTBBZm9yJTIwXyUyMGluJTIwcmFuZ2UoNSklM0ElMEElMjAlMjBuZXh0X2xvZ2l0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyklNUIlMjJsb2dpdHMlMjIlNUQlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkNkaW0lM0QtMSklMEElMEElMjAlMjBpbnB1dF9pZHMlMjAlM0QlMjB0b3JjaC5jYXQoJTVCaW5wdXRfaWRzJTJDJTIwbmV4dF90b2tlbl9pZCU1RCUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMHByaW50KCUyMnNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjIlMkMlMjBpbnB1dF9pZHMuc2hhcGUpJTBBJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGlucHV0X2lkcyU1QiUzQSUyQyUyMC01JTNBJTVEKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`input_ids = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits = model(input_ids)[<span class="hljs-string">&quot;logits&quot;</span>][:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits,dim=-<span class="hljs-number">1</span>)

  input_ids = torch.cat([input_ids, next_token_id], dim=-<span class="hljs-number">1</span>)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, input_ids.shape)

generated_text = tokenizer.batch_decode(input_ids[:, -<span class="hljs-number">5</span>:])
generated_text`,wrap:!1}}),_e=new v({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDIxJTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyMiU1RCklMEFzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMjMlNUQpJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDI0JTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyNSU1RCklMEElNUInJTIwSGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJyU1RA==",highlighted:`shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 21]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 22]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 23]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 24]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 25]</span>)
<span class="hljs-selector-attr">[<span class="hljs-string">&#x27; Here is a Python function&#x27;</span>]</span>`,wrap:!1}}),Ce=new v({props:{code:"cGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwTm9uZSUyMCUyMyUyMHBhc3Rfa2V5X3ZhbHVlcyUyMGlzJTIwdGhlJTIwa2V5LXZhbHVlJTIwY2FjaGUlMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIwJTVCJTVEJTBBbmV4dF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RC50byglMjJjdWRhJTIyKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwbmV4dF9sb2dpdHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlMjAlM0QlMjBtb2RlbChuZXh0X3Rva2VuX2lkJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSkudG9fdHVwbGUoKSUwQSUyMCUyMG5leHRfbG9naXRzJTIwJTNEJTIwbmV4dF9sb2dpdHMlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEElMjAlMjBwcmludCglMjJzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIyJTJDJTIwbmV4dF90b2tlbl9pZC5zaGFwZSklMEElMjAlMjBwcmludCglMjJsZW5ndGglMjBvZiUyMGtleS12YWx1ZSUyMGNhY2hlJTIyJTJDJTIwbGVuKHBhc3Rfa2V5X3ZhbHVlcyU1QjAlNUQlNUIwJTVEKSklMjAlMjAlMjMlMjBwYXN0X2tleV92YWx1ZXMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwJTVCbnVtX2xheWVycyUyQyUyMDAlMjBmb3IlMjBrJTJDJTIwMSUyMGZvciUyMHYlMkMlMjBiYXRjaF9zaXplJTJDJTIwbGVuZ3RoJTJDJTIwaGlkZGVuX2RpbSU1RCUwQSUyMCUyMGdlbmVyYXRlZF90b2tlbnMuYXBwZW5kKG5leHRfdG9rZW5faWQuaXRlbSgpKSUwQSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`past_key_values = <span class="hljs-literal">None</span> <span class="hljs-comment"># past_key_values is the key-value cache</span>
generated_tokens = []
next_token_id = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits, past_key_values = model(next_token_id, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>).to_tuple()
  next_logits = next_logits[:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits, dim=-<span class="hljs-number">1</span>)

  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, next_token_id.shape)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;length of key-value cache&quot;</span>, <span class="hljs-built_in">len</span>(past_key_values[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))  <span class="hljs-comment"># past_key_values are of shape [num_layers, 0 for k, 1 for v, batch_size, length, hidden_dim]</span>
  generated_tokens.append(next_token_id.item())

generated_text = tokenizer.batch_decode(generated_tokens)
generated_text`,wrap:!1}}),ze=new v({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIwJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIxJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIyJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIzJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDI0JTBBJTVCJyUyMEhlcmUnJTJDJTIwJyUyMGlzJyUyQyUyMCclMjBhJyUyQyUyMCclMjBQeXRob24nJTJDJTIwJyUyMGZ1bmN0aW9uJyU1RA==",highlighted:`<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">20</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">21</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">22</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">23</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">24</span><span class="hljs-meta">
[&#x27; Here&#x27;, &#x27; is&#x27;, &#x27; a&#x27;, &#x27; Python&#x27;, &#x27; function&#x27;]</span>`,wrap:!1}}),He=new v({props:{code:"VXNlciUzQSUyMEhvdyUyMG1hbnklMjBwZW9wbGUlMjBsaXZlJTIwaW4lMjBGcmFuY2UlM0YlMEFBc3Npc3RhbnQlM0ElMjBSb3VnaGx5JTIwNzUlMjBtaWxsaW9uJTIwcGVvcGxlJTIwbGl2ZSUyMGluJTIwRnJhbmNlJTBBVXNlciUzQSUyMEFuZCUyMGhvdyUyMG1hbnklMjBhcmUlMjBpbiUyMEdlcm1hbnklM0YlMEFBc3Npc3RhbnQlM0ElMjBHZXJtYW55JTIwaGFzJTIwY2EuJTIwODElMjBtaWxsaW9uJTIwaW5oYWJpdGFudHM=",highlighted:`<span class="hljs-symbol">User:</span> How many people live <span class="hljs-keyword">in</span> France?
<span class="hljs-symbol">Assistant:</span> Roughly <span class="hljs-number">75</span> million people live <span class="hljs-keyword">in</span> France
<span class="hljs-symbol">User:</span> <span class="hljs-keyword">And</span> how many are <span class="hljs-keyword">in</span> Germany?
<span class="hljs-symbol">Assistant:</span> Germany has ca. <span class="hljs-number">81</span> million inhabitants`,wrap:!1}}),Xe=new v({props:{code:"Y29uZmlnJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBMiUyMColMjAxNl8wMDAlMjAqJTIwY29uZmlnLm5fbGF5ZXIlMjAqJTIwY29uZmlnLm5faGVhZCUyMColMjBjb25maWcubl9lbWJkJTIwJTJGJTJGJTIwY29uZmlnLm5faGVhZA==",highlighted:`config = model.config
<span class="hljs-number">2</span> * <span class="hljs-number">16_000</span> * config.n_layer * config.n_head * config.n_embd // config.n_head`,wrap:!1}}),Ae=new v({props:{code:"Nzg2NDMyMDAwMA==",highlighted:'<span class="hljs-number">7864320000</span>',wrap:!1}}),en=new pn({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),{c(){ns=i("meta"),el=n(),sl=i("p"),nl=n(),d(Us.$$.fragment),ll=n(),d(Js.$$.fragment),il=n(),Cs=i("p"),Cs.innerHTML=Zu,pl=n(),Ls=i("ul"),Ls.innerHTML=Iu,ml=n(),zs=i("p"),zs.textContent=Hu,ol=n(),Gs=i("p"),Gs.textContent=Wu,rl=n(),Bs=i("ol"),Bs.innerHTML=Qu,hl=n(),$s=i("p"),$s.textContent=Nu,cl=n(),d(Zs.$$.fragment),ul=n(),Is=i("p"),Is.innerHTML=Ru,dl=n(),Hs=i("p"),Hs.innerHTML=qu,gl=n(),Ws=i("blockquote"),Ws.innerHTML=Xu,fl=n(),Qs=i("p"),Qs.textContent=Vu,yl=n(),Ns=i("blockquote"),Ns.innerHTML=Au,wl=n(),Rs=i("p"),Rs.textContent=Eu,bl=n(),qs=i("p"),qs.textContent=Su,vl=n(),Xs=i("ul"),Xs.innerHTML=Yu,Ml=n(),Vs=i("p"),Vs.innerHTML=Pu,xl=n(),As=i("p"),As.innerHTML=Fu,kl=n(),Es=i("p"),Es.innerHTML=Ku,Tl=n(),Ss=i("p"),Ss.textContent=Du,_l=n(),d(Ys.$$.fragment),jl=n(),d(Ps.$$.fragment),Ul=n(),Fs=i("p"),Fs.innerHTML=Ou,Jl=n(),Ks=i("p"),Ks.innerHTML=sd,Cl=n(),Ds=i("p"),Ds.innerHTML=td,Ll=n(),Os=i("p"),Os.innerHTML=ad,zl=n(),d(st.$$.fragment),Gl=n(),d(tt.$$.fragment),Bl=n(),at=i("p"),at.innerHTML=ed,$l=n(),d(et.$$.fragment),Zl=n(),nt=i("p"),nt.textContent=nd,Il=n(),d(lt.$$.fragment),Hl=n(),it=i("p"),it.innerHTML=ld,Wl=n(),d(pt.$$.fragment),Ql=n(),mt=i("p"),mt.innerHTML=id,Nl=n(),d(ot.$$.fragment),Rl=n(),rt=i("p"),rt.textContent=pd,ql=n(),ht=i("blockquote"),ht.innerHTML=md,Xl=n(),ct=i("p"),ct.innerHTML=od,Vl=n(),ut=i("p"),ut.innerHTML=rd,Al=n(),d(dt.$$.fragment),El=n(),gt=i("p"),gt.textContent=hd,Sl=n(),d(ft.$$.fragment),Yl=n(),yt=i("p"),yt.innerHTML=cd,Pl=n(),d(wt.$$.fragment),Fl=n(),bt=i("p"),bt.innerHTML=ud,Kl=n(),vt=i("p"),vt.innerHTML=dd,Dl=n(),Mt=i("p"),Mt.textContent=gd,Ol=n(),xt=i("ul"),xt.innerHTML=fd,si=n(),G=i("p"),gc=r("In a nutshell, this means that "),mn=i("em"),mn.textContent=yd,fc=r(" multiplications, with"),ti=new c(!1),ai=r(" being the "),on=i("em"),on.textContent=wd,yc=r(","),ei=new c(!1),ni=r(" being a weight matrix and"),li=new c(!1),ii=r(` being the output:
`),pi=new c(!1),mi=n(),kt=i("p"),wc=r(`are changed to
`),oi=new c(!1),ri=n(),Tt=i("p"),Tt.textContent=bd,hi=n(),_t=i("p"),_t.innerHTML=vd,ci=n(),d(jt.$$.fragment),ui=n(),Ut=i("p"),Ut.innerHTML=Md,di=n(),d(Jt.$$.fragment),gi=n(),Ct=i("p"),Ct.textContent=xd,fi=n(),d(Lt.$$.fragment),yi=n(),zt=i("p"),zt.innerHTML=kd,wi=n(),d(Gt.$$.fragment),bi=n(),Bt=i("p"),Bt.textContent=Td,vi=n(),d($t.$$.fragment),Mi=n(),Zt=i("p"),Zt.innerHTML=_d,xi=n(),d(It.$$.fragment),ki=n(),Ht=i("p"),Ht.textContent=jd,Ti=n(),Wt=i("p"),Wt.textContent=Ud,_i=n(),d(Qt.$$.fragment),ji=n(),d(Nt.$$.fragment),Ui=n(),Rt=i("p"),Rt.innerHTML=Jd,Ji=n(),d(qt.$$.fragment),Ci=n(),Xt=i("p"),Xt.innerHTML=Cd,Li=n(),d(Vt.$$.fragment),zi=n(),At=i("p"),At.innerHTML=Ld,Gi=n(),d(Et.$$.fragment),Bi=n(),St=i("p"),St.innerHTML=zd,$i=n(),d(Yt.$$.fragment),Zi=n(),Pt=i("p"),Pt.textContent=Gd,Ii=n(),Ft=i("p"),Ft.innerHTML=Bd,Hi=n(),P=i("p"),bc=r("Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to"),Wi=new c(!1),Qi=r(" and"),Ni=new c(!1),Ri=r(" taking longer during inference."),qi=n(),d(Kt.$$.fragment),Xi=n(),d(Dt.$$.fragment),Vi=n(),Ot=i("p"),Ot.textContent=$d,Ai=n(),sa=i("p"),sa.textContent=Zd,Ei=n(),ta=i("p"),ta.innerHTML=Id,Si=n(),aa=i("blockquote"),aa.innerHTML=Hd,Yi=n(),ea=i("p"),ea.textContent=Wd,Pi=n(),na=i("p"),na.innerHTML=Qd,Fi=n(),d(la.$$.fragment),Ki=n(),ia=i("p"),ia.textContent=Nd,Di=n(),X=i("p"),vc=r(`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),rn=i("em"),rn.textContent=Rd,Mc=r(" both in compute and memory complexity with number of input tokens (also called "),hn=i("em"),hn.textContent=qd,xc=r(") that we denote in the following by"),Oi=new c(!1),sp=r(` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),tp=n(),T=i("p"),kc=r("Let’s take a closer look. The formula to compute the output"),ap=new c(!1),ep=r(" of a self-attention layer for an input"),np=new c(!1),lp=r(" of length"),ip=new c(!1),pp=r(` is:
`),mp=new c(!1),op=n(),rp=new c(!1),hp=r(" is thereby the input sequence to the attention layer. The projections"),cp=new c(!1),up=r(" and"),dp=new c(!1),gp=r(" will each consist of"),fp=new c(!1),yp=r(" vectors resulting in the"),wp=new c(!1),bp=r(" being of size"),vp=new c(!1),Mp=r(" ."),xp=n(),C=i("p"),Tc=r(`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the`),kp=new c(!1),Tp=r(" matrices to be"),_p=new c(!1),jp=r(" bytes. For"),Up=new c(!1),Jp=r(" only around 50 MB of VRAM are needed, however, for"),Cp=new c(!1),Lp=r(" we would need 19 GB of VRAM, and for"),zp=new c(!1),Gp=r(" we would need almost 1TB just to store the"),Bp=new c(!1),$p=r(" matrices."),Zp=n(),pa=i("p"),pa.textContent=Xd,Ip=n(),ma=i("p"),ma.textContent=Vd,Hp=n(),V=i("p"),_c=r("How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the"),Wp=new c(!1),Qp=r(" matrix. "),os=i("a"),os.textContent=Ad,jc=r(" developed exactly such a new algorithm and called it "),cn=i("strong"),cn.textContent=Ed,Uc=r("."),Np=n(),ls=i("p"),Jc=r("In a nutshell, Flash Attention breaks the "),Rp=new c(!1),qp=r(`) computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:
`),Xp=new c(!1),Vp=n(),Z=i("p"),Cc=r("with"),Ap=new c(!1),Ep=r(" and"),Sp=new c(!1),Yp=r(" being some softmax normalization statistics that need to be recomputed for every"),Pp=new c(!1),Fp=r(" and"),Kp=new c(!1),Dp=r(" ."),Op=n(),oa=i("p"),oa.innerHTML=Sd,sm=n(),ra=i("p"),ra.textContent=Yd,tm=n(),un=i("blockquote"),is=i("p"),Lc=r("By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),dn=i("strong"),dn.textContent=Pd,zc=r(" outputs compared to the default self-attention layer at a memory cost that only increases linearly with"),am=new c(!1),em=r(" ."),nm=n(),ha=i("p"),ha.innerHTML=Fd,lm=n(),ca=i("blockquote"),ca.innerHTML=Kd,im=n(),F=i("p"),Gc=r("Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),gn=i("em"),gn.textContent=Dd,Bc=r(" SRAM memory instead of having to access the slower VRAM memory to compute the output vector"),pm=new c(!1),mm=r(" ."),om=n(),ua=i("p"),ua.innerHTML=Od,rm=n(),da=i("p"),da.textContent=sg,hm=n(),ga=i("p"),ga.innerHTML=tg,cm=n(),d(fa.$$.fragment),um=n(),ya=i("p"),ya.innerHTML=ag,dm=n(),d(wa.$$.fragment),gm=n(),ba=i("p"),ba.textContent=eg,fm=n(),d(va.$$.fragment),ym=n(),Ma=i("p"),Ma.innerHTML=ng,wm=n(),d(xa.$$.fragment),bm=n(),ka=i("p"),ka.innerHTML=lg,vm=n(),d(Ta.$$.fragment),Mm=n(),_a=i("p"),_a.textContent=ig,xm=n(),ja=i("p"),ja.innerHTML=pg,km=n(),Ua=i("p"),Ua.textContent=mg,Tm=n(),d(Ja.$$.fragment),_m=n(),Ca=i("p"),Ca.innerHTML=og,jm=n(),d(La.$$.fragment),Um=n(),za=i("p"),za.textContent=rg,Jm=n(),Ga=i("p"),Ga.innerHTML=hg,Cm=n(),d(Ba.$$.fragment),Lm=n(),$a=i("p"),$a.innerHTML=cg,zm=n(),d(Za.$$.fragment),Gm=n(),Ia=i("p"),Ia.textContent=ug,Bm=n(),d(Ha.$$.fragment),$m=n(),Wa=i("p"),Wa.innerHTML=dg,Zm=n(),d(Qa.$$.fragment),Im=n(),Na=i("p"),Na.textContent=gg,Hm=n(),Ra=i("p"),Ra.textContent=fg,Wm=n(),d(qa.$$.fragment),Qm=n(),Xa=i("p"),Xa.innerHTML=yg,Nm=n(),d(Va.$$.fragment),Rm=n(),Aa=i("p"),Aa.textContent=wg,qm=n(),Ea=i("p"),Ea.textContent=bg,Xm=n(),d(Sa.$$.fragment),Vm=n(),Ya=i("p"),Ya.innerHTML=vg,Am=n(),d(Pa.$$.fragment),Em=n(),Fa=i("p"),Fa.textContent=Mg,Sm=n(),Ka=i("ul"),Ka.innerHTML=xg,Ym=n(),Da=i("p"),Da.innerHTML=kg,Pm=n(),Oa=i("ul"),Oa.innerHTML=Tg,Fm=n(),se=i("p"),se.innerHTML=_g,Km=n(),te=i("p"),te.textContent=jg,Dm=n(),ae=i("ul"),ae.innerHTML=Ug,Om=n(),ee=i("p"),ee.textContent=Jg,so=n(),d(ne.$$.fragment),to=n(),K=i("p"),$c=r(`Self-attention puts each token in relation to each other’s tokens.
As an example, the`),ao=new c(!1),eo=r(" matrix of the text input sequence "),fn=i("em"),fn.textContent=Cg,Zc=r(" could look as follows:"),no=n(),le=i("p"),le.innerHTML=Lg,lo=n(),ie=i("p"),ie.innerHTML=zg,io=n(),$=i("p"),Ic=r(`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by`),po=new c(!1),mo=r(" relates each word token to each other word token in"),oo=new c(!1),ro=r(` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),yn=i("em"),yn.textContent=Gg,Hc=r(" differentiating between "),wn=i("em"),wn.textContent=Bg,Wc=r(" and "),bn=i("em"),bn.textContent=$g,Qc=r(" would be very challenging."),ho=n(),pe=i("p"),pe.innerHTML=Zg,co=n(),L=i("p"),Nc=r("The authors of the "),rs=i("a"),rs.innerHTML=Ig,Rc=r(" paper introduced sinusoidal positional embeddings"),uo=new c(!1),go=r(` .
where each vector`),fo=new c(!1),yo=r(" is computed as a sinusoidal function of its position"),wo=new c(!1),bo=r(` .
The positional encodings are then simply added to the input sequence vectors`),vo=new c(!1),Mo=r(" ="),xo=new c(!1),ko=r(" thereby cueing the model to better learn sentence order."),To=n(),D=i("p"),qc=r("Instead of using fixed position embeddings, others (such as "),hs=i("a"),hs.textContent=Hg,Xc=r(") used learned positional encodings for which the positional embeddings"),_o=new c(!1),jo=r(" are learned during training."),Uo=n(),me=i("p"),me.textContent=Wg,Jo=n(),cs=i("ol"),N=i("li"),Vc=r("Sinusoidal and learned position embeddings are both absolute positional embeddings, "),vn=i("em"),vn.textContent=Qg,Ac=r(" encoding a unique embedding for each position id:"),Co=new c(!1),Lo=r(" . As shown by "),us=i("a"),us.textContent=Ng,Ec=r(" and "),ds=i("a"),ds.textContent=Rg,Sc=r(", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),Yc=n(),oe=i("li"),Pc=r("When using learned position embeddings, the LLM has to be trained on a fixed input length"),zo=new c(!1),Go=r(", which makes it difficult to extrapolate to an input length longer than what it was trained on."),Bo=n(),re=i("p"),re.textContent=qg,$o=n(),he=i("ul"),he.innerHTML=Xg,Zo=n(),A=i("p"),Fc=r("Both "),Mn=i("em"),Mn.textContent=Vg,Kc=r(" and "),xn=i("em"),xn.textContent=Ag,Dc=r(" argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the"),Io=new c(!1),Ho=r(" computation."),Wo=n(),k=i("p"),Oc=r("Without going into too many details, "),kn=i("em"),kn.textContent=Eg,su=r(" notes that positional information can be encoded into query-key pairs, "),Tn=i("em"),Tn.textContent=Sg,Qo=new c(!1),No=r(" and"),Ro=new c(!1),qo=r(" by rotating each vector by an angle"),Xo=new c(!1),Vo=r(" and"),Ao=new c(!1),Eo=r(" respectively with"),So=new c(!1),Yo=r(` describing each vectors sentence position:
`),Po=new c(!1),Fo=n(),Ko=new c(!1),Do=r(" thereby represents a rotational matrix."),Oo=new c(!1),sr=r(" is "),_n=i("em"),_n.textContent=Yg,tu=r(" learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),tr=n(),jn=i("blockquote"),B=i("p"),au=r("By doing so, the propability score between"),ar=new c(!1),er=r(" and"),nr=new c(!1),lr=r(" is only affected if"),ir=new c(!1),pr=r(" and solely depends on the relative distance"),mr=new c(!1),or=r(" regardless of each vector’s specific positions"),rr=new c(!1),hr=r(" and"),cr=new c(!1),ur=r(" ."),dr=n(),ce=i("p"),ce.innerHTML=Pg,gr=n(),ue=i("ul"),ue.innerHTML=Fg,fr=n(),E=i("p"),eu=r("As an alternative, "),Un=i("em"),Un.textContent=Kg,nu=r(" proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Jn=i("code"),Jn.textContent=Dg,lu=r(" to each query-key entry of the"),yr=new c(!1),wr=r(" matrix right before the softmax computation."),br=n(),de=i("p"),de.innerHTML=Og,vr=n(),ge=i("p"),ge.innerHTML=sf,Mr=n(),fe=i("p"),fe.innerHTML=tf,xr=n(),ye=i("ul"),ye.innerHTML=af,kr=n(),x=i("p"),iu=r("Both "),Cn=i("em"),Cn.textContent=ef,pu=r(" and "),Ln=i("em"),Ln.textContent=nf,mu=r(" position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),zn=i("em"),zn.textContent=lf,ou=r(" as compared to "),Gn=i("em"),Gn.textContent=pf,ru=r(`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),Bn=i("em"),Bn.textContent=mf,hu=r(", keeping the same"),Tr=new c(!1),_r=r(" that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),$n=i("em"),$n.textContent=of,cu=n(),gs=i("a"),gs.textContent=rf,uu=r(". However, the community has found a couple of effective tricks that adapt"),jr=new c(!1),Ur=r(", thereby allowing "),Zn=i("em"),Zn.textContent=hf,du=r(" position embeddings to work well for extrapolated text input sequences (see "),fs=i("a"),fs.textContent=cf,gu=r(")."),Jr=n(),ys=i("blockquote"),In=i("p"),In.innerHTML=uf,fu=n(),ps=i("ul"),we=i("li"),yu=r("Positional cues about the text inputs should be given directly to the"),Cr=new c(!1),Lr=r(" matrix of the self-attention layer"),wu=n(),Hn=i("li"),Hn.innerHTML=df,bu=n(),Wn=i("li"),Wn.textContent=gf,zr=n(),S=i("p"),vu=r("In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say"),Gr=new c(!1),Br=r(" it can still be used in practice with text inputs much larger than"),$r=new c(!1),Zr=r(", like"),Ir=new c(!1),Hr=r(" by extrapolating the positional embeddings."),Wr=n(),d(be.$$.fragment),Qr=n(),ve=i("p"),ve.textContent=ff,Nr=n(),Me=i("p"),Me.innerHTML=yf,Rr=n(),xe=i("p"),xe.innerHTML=wf,qr=n(),d(ke.$$.fragment),Xr=n(),Te=i("p"),Te.innerHTML=bf,Vr=n(),d(_e.$$.fragment),Ar=n(),je=i("p"),je.textContent=vf,Er=n(),Ue=i("p"),Ue.innerHTML=Mf,Sr=n(),z=i("p"),Mu=r("As a consequence, tokens "),Qn=i("em"),Qn.textContent=xf,xu=r(" depend on previous tokens, more specifically the"),Yr=new c(!1),Pr=r(" vector is never put in relation with any key, values vectors"),Fr=new c(!1),Kr=r(" if"),Dr=new c(!1),Or=r(" . Instead"),sh=new c(!1),th=r(" only attends to previous key-value vectors"),ah=new c(!1),eh=r(". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),nh=n(),Je=i("p"),Je.innerHTML=kf,lh=n(),d(Ce.$$.fragment),ih=n(),Le=i("p"),Le.innerHTML=Tf,ph=n(),d(ze.$$.fragment),mh=n(),Ge=i("p"),Ge.innerHTML=_f,oh=n(),Nn=i("blockquote"),R=i("p"),ku=r("Making use of the key-value cache means that the"),rh=new c(!1),hh=r(" is essentially reduced to"),ch=new c(!1),uh=r(" with"),dh=new c(!1),gh=r(" being the query projection of the currently passed input token which is "),Rn=i("em"),Rn.textContent=jf,Tu=r(" just a single vector."),fh=n(),Be=i("p"),Be.textContent=Uf,yh=n(),ws=i("ul"),$e=i("li"),_u=r("Significant increase in computational efficiency as less computations are performed compared to computing the full"),wh=new c(!1),bh=r(" matrix. This leads to an increase in inference speed"),ju=n(),qn=i("li"),qn.textContent=Jf,vh=n(),Ze=i("blockquote"),Ze.innerHTML=Cf,Mh=n(),Ie=i("p"),Ie.textContent=Lf,xh=n(),d(He.$$.fragment),kh=n(),We=i("p"),We.textContent=zf,Th=n(),Qe=i("ul"),Qe.innerHTML=Gf,_h=n(),Ne=i("p"),Ne.textContent=Bf,jh=n(),Re=i("ol"),Re.innerHTML=$f,Uh=n(),O=i("p"),Uu=r("There is however one catch. While the required peak memory for the"),Jh=new c(!1),Ch=r(" matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors"),Lh=new c(!1),zh=r(" for all self-attention layers and for all attention heads."),Gh=n(),qe=i("p"),qe.innerHTML=Zf,Bh=n(),d(Xe.$$.fragment),$h=n(),Ve=i("p"),Ve.innerHTML=If,Zh=n(),d(Ae.$$.fragment),Ih=n(),Ee=i("p"),Ee.innerHTML=Hf,Hh=n(),Se=i("ol"),Se.innerHTML=Wf,Wh=n(),Ye=i("p"),Ye.innerHTML=Qf,Qh=n(),Xn=i("blockquote"),ms=i("p"),Ju=r("By using a single head-value projection weight pair, the key value vectors"),Nh=new c(!1),Rh=r(" have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),Vn=i("code"),Vn.textContent=Nf,Cu=r(" ones."),qh=n(),Pe=i("p"),Pe.textContent=Rf,Xh=n(),ss=i("p"),Lu=r(`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the`),Vh=new c(!1),Ah=r(" computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),bs=i("a"),bs.textContent=qf,zu=r("."),Eh=n(),vs=i("p"),Gu=r("The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different"),Sh=new c(!1),Yh=r(" matrix."),Ph=n(),Fe=i("p"),Fe.textContent=Xf,Fh=n(),Ke=i("ul"),Ke.innerHTML=Vf,Kh=n(),De=i("p"),De.innerHTML=Af,Dh=n(),Ms=i("ol"),Ms.innerHTML=Ef,Oh=n(),Oe=i("p"),Oe.innerHTML=Sf,sc=n(),sn=i("p"),sn.innerHTML=Yf,tc=n(),tn=i("p"),tn.innerHTML=Pf,ac=n(),an=i("blockquote"),an.innerHTML=Ff,ec=n(),d(en.$$.fragment),nc=n(),nn=i("p"),nn.innerHTML=Kf,lc=n(),ln=i("p"),ln.innerHTML=Df,ic=n(),tl=i("p"),this.h()},l(s){const t=$w("svelte-u9bgzb",document.head);ns=p(t,"META",{name:!0,content:!0}),t.forEach(a),el=l(s),sl=p(s,"P",{}),M(sl).forEach(a),nl=l(s),g(Us.$$.fragment,s),ll=l(s),g(Js.$$.fragment,s),il=l(s),Cs=p(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1b2qao5"&&(Cs.innerHTML=Zu),pl=l(s),Ls=p(s,"UL",{"data-svelte-h":!0}),o(Ls)!=="svelte-xknchk"&&(Ls.innerHTML=Iu),ml=l(s),zs=p(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-1cl588t"&&(zs.textContent=Hu),ol=l(s),Gs=p(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-f1zoss"&&(Gs.textContent=Wu),rl=l(s),Bs=p(s,"OL",{"data-svelte-h":!0}),o(Bs)!=="svelte-1d4b4yy"&&(Bs.innerHTML=Qu),hl=l(s),$s=p(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-ihy2a8"&&($s.textContent=Nu),cl=l(s),g(Zs.$$.fragment,s),ul=l(s),Is=p(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-qqgdso"&&(Is.innerHTML=Ru),dl=l(s),Hs=p(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-ljb3iz"&&(Hs.innerHTML=qu),gl=l(s),Ws=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Ws)!=="svelte-4jkxwr"&&(Ws.innerHTML=Xu),fl=l(s),Qs=p(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-i58rjm"&&(Qs.textContent=Vu),yl=l(s),Ns=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Ns)!=="svelte-z4szg9"&&(Ns.innerHTML=Au),wl=l(s),Rs=p(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-28orre"&&(Rs.textContent=Eu),bl=l(s),qs=p(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1jmd8j1"&&(qs.textContent=Su),vl=l(s),Xs=p(s,"UL",{"data-svelte-h":!0}),o(Xs)!=="svelte-1th1pdf"&&(Xs.innerHTML=Yu),Ml=l(s),Vs=p(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-28fp1w"&&(Vs.innerHTML=Pu),xl=l(s),As=p(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-189eose"&&(As.innerHTML=Fu),kl=l(s),Es=p(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-2rsruz"&&(Es.innerHTML=Ku),Tl=l(s),Ss=p(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-g7zrz4"&&(Ss.textContent=Du),_l=l(s),g(Ys.$$.fragment,s),jl=l(s),g(Ps.$$.fragment,s),Ul=l(s),Fs=p(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-z9gs9x"&&(Fs.innerHTML=Ou),Jl=l(s),Ks=p(s,"P",{"data-svelte-h":!0}),o(Ks)!=="svelte-19462o4"&&(Ks.innerHTML=sd),Cl=l(s),Ds=p(s,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-ppeb89"&&(Ds.innerHTML=td),Ll=l(s),Os=p(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-81gnnp"&&(Os.innerHTML=ad),zl=l(s),g(st.$$.fragment,s),Gl=l(s),g(tt.$$.fragment,s),Bl=l(s),at=p(s,"P",{"data-svelte-h":!0}),o(at)!=="svelte-jl1fz0"&&(at.innerHTML=ed),$l=l(s),g(et.$$.fragment,s),Zl=l(s),nt=p(s,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-174suzs"&&(nt.textContent=nd),Il=l(s),g(lt.$$.fragment,s),Hl=l(s),it=p(s,"P",{"data-svelte-h":!0}),o(it)!=="svelte-138fn6l"&&(it.innerHTML=ld),Wl=l(s),g(pt.$$.fragment,s),Ql=l(s),mt=p(s,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-jl1fz0"&&(mt.innerHTML=id),Nl=l(s),g(ot.$$.fragment,s),Rl=l(s),rt=p(s,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-14j7eyl"&&(rt.textContent=pd),ql=l(s),ht=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ht)!=="svelte-1gvcuxd"&&(ht.innerHTML=md),Xl=l(s),ct=p(s,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-1urmxur"&&(ct.innerHTML=od),Vl=l(s),ut=p(s,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1uylvrd"&&(ut.innerHTML=rd),Al=l(s),g(dt.$$.fragment,s),El=l(s),gt=p(s,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-zicod6"&&(gt.textContent=hd),Sl=l(s),g(ft.$$.fragment,s),Yl=l(s),yt=p(s,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1prc48e"&&(yt.innerHTML=cd),Pl=l(s),g(wt.$$.fragment,s),Fl=l(s),bt=p(s,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1xisv4k"&&(bt.innerHTML=ud),Kl=l(s),vt=p(s,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-xkk23p"&&(vt.innerHTML=dd),Dl=l(s),Mt=p(s,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-171gpq5"&&(Mt.textContent=gd),Ol=l(s),xt=p(s,"UL",{"data-svelte-h":!0}),o(xt)!=="svelte-11ifrvi"&&(xt.innerHTML=fd),si=l(s),G=p(s,"P",{});var q=M(G);gc=h(q,"In a nutshell, this means that "),mn=p(q,"EM",{"data-svelte-h":!0}),o(mn)!=="svelte-1hxrv2n"&&(mn.textContent=yd),fc=h(q," multiplications, with"),ti=u(q,!1),ai=h(q," being the "),on=p(q,"EM",{"data-svelte-h":!0}),o(on)!=="svelte-9j42in"&&(on.textContent=wd),yc=h(q,","),ei=u(q,!1),ni=h(q," being a weight matrix and"),li=u(q,!1),ii=h(q,` being the output:
`),pi=u(q,!1),q.forEach(a),mi=l(s),kt=p(s,"P",{});var Bu=M(kt);wc=h(Bu,`are changed to
`),oi=u(Bu,!1),Bu.forEach(a),ri=l(s),Tt=p(s,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-12wl41q"&&(Tt.textContent=bd),hi=l(s),_t=p(s,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-8mpqh2"&&(_t.innerHTML=vd),ci=l(s),g(jt.$$.fragment,s),ui=l(s),Ut=p(s,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-6n5flp"&&(Ut.innerHTML=Md),di=l(s),g(Jt.$$.fragment,s),gi=l(s),Ct=p(s,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1yy92n4"&&(Ct.textContent=xd),fi=l(s),g(Lt.$$.fragment,s),yi=l(s),zt=p(s,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-jl1fz0"&&(zt.innerHTML=kd),wi=l(s),g(Gt.$$.fragment,s),bi=l(s),Bt=p(s,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-12urs7j"&&(Bt.textContent=Td),vi=l(s),g($t.$$.fragment,s),Mi=l(s),Zt=p(s,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-jl1fz0"&&(Zt.innerHTML=_d),xi=l(s),g(It.$$.fragment,s),ki=l(s),Ht=p(s,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-x8wynt"&&(Ht.textContent=jd),Ti=l(s),Wt=p(s,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-3uld8v"&&(Wt.textContent=Ud),_i=l(s),g(Qt.$$.fragment,s),ji=l(s),g(Nt.$$.fragment,s),Ui=l(s),Rt=p(s,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1sadlnz"&&(Rt.innerHTML=Jd),Ji=l(s),g(qt.$$.fragment,s),Ci=l(s),Xt=p(s,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-jl1fz0"&&(Xt.innerHTML=Cd),Li=l(s),g(Vt.$$.fragment,s),zi=l(s),At=p(s,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1scve2"&&(At.innerHTML=Ld),Gi=l(s),g(Et.$$.fragment,s),Bi=l(s),St=p(s,"P",{"data-svelte-h":!0}),o(St)!=="svelte-jl1fz0"&&(St.innerHTML=zd),$i=l(s),g(Yt.$$.fragment,s),Zi=l(s),Pt=p(s,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-1mhmf5k"&&(Pt.textContent=Gd),Ii=l(s),Ft=p(s,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-sad4qj"&&(Ft.innerHTML=Bd),Hi=l(s),P=p(s,"P",{});var An=M(P);bc=h(An,"Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to"),Wi=u(An,!1),Qi=h(An," and"),Ni=u(An,!1),Ri=h(An," taking longer during inference."),An.forEach(a),qi=l(s),g(Kt.$$.fragment,s),Xi=l(s),g(Dt.$$.fragment,s),Vi=l(s),Ot=p(s,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-9e7sx8"&&(Ot.textContent=$d),Ai=l(s),sa=p(s,"P",{"data-svelte-h":!0}),o(sa)!=="svelte-pphiln"&&(sa.textContent=Zd),Ei=l(s),ta=p(s,"P",{"data-svelte-h":!0}),o(ta)!=="svelte-6h5u0r"&&(ta.innerHTML=Id),Si=l(s),aa=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(aa)!=="svelte-i1sgud"&&(aa.innerHTML=Hd),Yi=l(s),ea=p(s,"P",{"data-svelte-h":!0}),o(ea)!=="svelte-68w1lt"&&(ea.textContent=Wd),Pi=l(s),na=p(s,"P",{"data-svelte-h":!0}),o(na)!=="svelte-ei9u00"&&(na.innerHTML=Qd),Fi=l(s),g(la.$$.fragment,s),Ki=l(s),ia=p(s,"P",{"data-svelte-h":!0}),o(ia)!=="svelte-649tnu"&&(ia.textContent=Nd),Di=l(s),X=p(s,"P",{});var xs=M(X);vc=h(xs,`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),rn=p(xs,"EM",{"data-svelte-h":!0}),o(rn)!=="svelte-1jeo576"&&(rn.textContent=Rd),Mc=h(xs," both in compute and memory complexity with number of input tokens (also called "),hn=p(xs,"EM",{"data-svelte-h":!0}),o(hn)!=="svelte-1xe7eav"&&(hn.textContent=qd),xc=h(xs,") that we denote in the following by"),Oi=u(xs,!1),sp=h(xs,` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),xs.forEach(a),tp=l(s),T=p(s,"P",{});var U=M(T);kc=h(U,"Let’s take a closer look. The formula to compute the output"),ap=u(U,!1),ep=h(U," of a self-attention layer for an input"),np=u(U,!1),lp=h(U," of length"),ip=u(U,!1),pp=h(U,` is:
`),mp=u(U,!1),op=l(U),rp=u(U,!1),hp=h(U," is thereby the input sequence to the attention layer. The projections"),cp=u(U,!1),up=h(U," and"),dp=u(U,!1),gp=h(U," will each consist of"),fp=u(U,!1),yp=h(U," vectors resulting in the"),wp=u(U,!1),bp=h(U," being of size"),vp=u(U,!1),Mp=h(U," ."),U.forEach(a),xp=l(s),C=p(s,"P",{});var I=M(C);Tc=h(I,`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the`),kp=u(I,!1),Tp=h(I," matrices to be"),_p=u(I,!1),jp=h(I," bytes. For"),Up=u(I,!1),Jp=h(I," only around 50 MB of VRAM are needed, however, for"),Cp=u(I,!1),Lp=h(I," we would need 19 GB of VRAM, and for"),zp=u(I,!1),Gp=h(I," we would need almost 1TB just to store the"),Bp=u(I,!1),$p=h(I," matrices."),I.forEach(a),Zp=l(s),pa=p(s,"P",{"data-svelte-h":!0}),o(pa)!=="svelte-bptbn2"&&(pa.textContent=Xd),Ip=l(s),ma=p(s,"P",{"data-svelte-h":!0}),o(ma)!=="svelte-opmd8n"&&(ma.textContent=Vd),Hp=l(s),V=p(s,"P",{});var ks=M(V);_c=h(ks,"How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the"),Wp=u(ks,!1),Qp=h(ks," matrix. "),os=p(ks,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(os)!=="svelte-1h13bsr"&&(os.textContent=Ad),jc=h(ks," developed exactly such a new algorithm and called it "),cn=p(ks,"STRONG",{"data-svelte-h":!0}),o(cn)!=="svelte-eh0j4m"&&(cn.textContent=Ed),Uc=h(ks,"."),ks.forEach(a),Np=l(s),ls=p(s,"P",{});var al=M(ls);Jc=h(al,"In a nutshell, Flash Attention breaks the "),Rp=u(al,!1),qp=h(al,`) computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:
`),Xp=u(al,!1),al.forEach(a),Vp=l(s),Z=p(s,"P",{});var ts=M(Z);Cc=h(ts,"with"),Ap=u(ts,!1),Ep=h(ts," and"),Sp=u(ts,!1),Yp=h(ts," being some softmax normalization statistics that need to be recomputed for every"),Pp=u(ts,!1),Fp=h(ts," and"),Kp=u(ts,!1),Dp=h(ts," ."),ts.forEach(a),Op=l(s),oa=p(s,"P",{"data-svelte-h":!0}),o(oa)!=="svelte-1q8406g"&&(oa.innerHTML=Sd),sm=l(s),ra=p(s,"P",{"data-svelte-h":!0}),o(ra)!=="svelte-1ufr4xd"&&(ra.textContent=Yd),tm=l(s),un=p(s,"BLOCKQUOTE",{});var Of=M(un);is=p(Of,"P",{});var En=M(is);Lc=h(En,"By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),dn=p(En,"STRONG",{"data-svelte-h":!0}),o(dn)!=="svelte-1fh6qbl"&&(dn.textContent=Pd),zc=h(En," outputs compared to the default self-attention layer at a memory cost that only increases linearly with"),am=u(En,!1),em=h(En," ."),En.forEach(a),Of.forEach(a),nm=l(s),ha=p(s,"P",{"data-svelte-h":!0}),o(ha)!=="svelte-1re0bhf"&&(ha.innerHTML=Fd),lm=l(s),ca=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ca)!=="svelte-m261q0"&&(ca.innerHTML=Kd),im=l(s),F=p(s,"P",{});var Sn=M(F);Gc=h(Sn,"Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),gn=p(Sn,"EM",{"data-svelte-h":!0}),o(gn)!=="svelte-1g1d7vc"&&(gn.textContent=Dd),Bc=h(Sn," SRAM memory instead of having to access the slower VRAM memory to compute the output vector"),pm=u(Sn,!1),mm=h(Sn," ."),Sn.forEach(a),om=l(s),ua=p(s,"P",{"data-svelte-h":!0}),o(ua)!=="svelte-1ew53wd"&&(ua.innerHTML=Od),rm=l(s),da=p(s,"P",{"data-svelte-h":!0}),o(da)!=="svelte-1uhed9l"&&(da.textContent=sg),hm=l(s),ga=p(s,"P",{"data-svelte-h":!0}),o(ga)!=="svelte-66kx9u"&&(ga.innerHTML=tg),cm=l(s),g(fa.$$.fragment,s),um=l(s),ya=p(s,"P",{"data-svelte-h":!0}),o(ya)!=="svelte-1qzrmrh"&&(ya.innerHTML=ag),dm=l(s),g(wa.$$.fragment,s),gm=l(s),ba=p(s,"P",{"data-svelte-h":!0}),o(ba)!=="svelte-1lfqnh1"&&(ba.textContent=eg),fm=l(s),g(va.$$.fragment,s),ym=l(s),Ma=p(s,"P",{"data-svelte-h":!0}),o(Ma)!=="svelte-tc5wkn"&&(Ma.innerHTML=ng),wm=l(s),g(xa.$$.fragment,s),bm=l(s),ka=p(s,"P",{"data-svelte-h":!0}),o(ka)!=="svelte-jl1fz0"&&(ka.innerHTML=lg),vm=l(s),g(Ta.$$.fragment,s),Mm=l(s),_a=p(s,"P",{"data-svelte-h":!0}),o(_a)!=="svelte-sz1cee"&&(_a.textContent=ig),xm=l(s),ja=p(s,"P",{"data-svelte-h":!0}),o(ja)!=="svelte-d2g4iy"&&(ja.innerHTML=pg),km=l(s),Ua=p(s,"P",{"data-svelte-h":!0}),o(Ua)!=="svelte-2il51v"&&(Ua.textContent=mg),Tm=l(s),g(Ja.$$.fragment,s),_m=l(s),Ca=p(s,"P",{"data-svelte-h":!0}),o(Ca)!=="svelte-jl1fz0"&&(Ca.innerHTML=og),jm=l(s),g(La.$$.fragment,s),Um=l(s),za=p(s,"P",{"data-svelte-h":!0}),o(za)!=="svelte-1uumitt"&&(za.textContent=rg),Jm=l(s),Ga=p(s,"P",{"data-svelte-h":!0}),o(Ga)!=="svelte-bk1lpp"&&(Ga.innerHTML=hg),Cm=l(s),g(Ba.$$.fragment,s),Lm=l(s),$a=p(s,"P",{"data-svelte-h":!0}),o($a)!=="svelte-i73wiy"&&($a.innerHTML=cg),zm=l(s),g(Za.$$.fragment,s),Gm=l(s),Ia=p(s,"P",{"data-svelte-h":!0}),o(Ia)!=="svelte-ncw8pe"&&(Ia.textContent=ug),Bm=l(s),g(Ha.$$.fragment,s),$m=l(s),Wa=p(s,"P",{"data-svelte-h":!0}),o(Wa)!=="svelte-jl1fz0"&&(Wa.innerHTML=dg),Zm=l(s),g(Qa.$$.fragment,s),Im=l(s),Na=p(s,"P",{"data-svelte-h":!0}),o(Na)!=="svelte-1onj0qe"&&(Na.textContent=gg),Hm=l(s),Ra=p(s,"P",{"data-svelte-h":!0}),o(Ra)!=="svelte-1b8rrkf"&&(Ra.textContent=fg),Wm=l(s),g(qa.$$.fragment,s),Qm=l(s),Xa=p(s,"P",{"data-svelte-h":!0}),o(Xa)!=="svelte-jl1fz0"&&(Xa.innerHTML=yg),Nm=l(s),g(Va.$$.fragment,s),Rm=l(s),Aa=p(s,"P",{"data-svelte-h":!0}),o(Aa)!=="svelte-gk4woy"&&(Aa.textContent=wg),qm=l(s),Ea=p(s,"P",{"data-svelte-h":!0}),o(Ea)!=="svelte-1lt2th7"&&(Ea.textContent=bg),Xm=l(s),g(Sa.$$.fragment,s),Vm=l(s),Ya=p(s,"P",{"data-svelte-h":!0}),o(Ya)!=="svelte-1hx5pt6"&&(Ya.innerHTML=vg),Am=l(s),g(Pa.$$.fragment,s),Em=l(s),Fa=p(s,"P",{"data-svelte-h":!0}),o(Fa)!=="svelte-1i10a94"&&(Fa.textContent=Mg),Sm=l(s),Ka=p(s,"UL",{"data-svelte-h":!0}),o(Ka)!=="svelte-1ti1vbk"&&(Ka.innerHTML=xg),Ym=l(s),Da=p(s,"P",{"data-svelte-h":!0}),o(Da)!=="svelte-jqprou"&&(Da.innerHTML=kg),Pm=l(s),Oa=p(s,"UL",{"data-svelte-h":!0}),o(Oa)!=="svelte-ig4ec7"&&(Oa.innerHTML=Tg),Fm=l(s),se=p(s,"P",{"data-svelte-h":!0}),o(se)!=="svelte-awpy0j"&&(se.innerHTML=_g),Km=l(s),te=p(s,"P",{"data-svelte-h":!0}),o(te)!=="svelte-152e8kl"&&(te.textContent=jg),Dm=l(s),ae=p(s,"UL",{"data-svelte-h":!0}),o(ae)!=="svelte-k4f0dn"&&(ae.innerHTML=Ug),Om=l(s),ee=p(s,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-wxdkvm"&&(ee.textContent=Jg),so=l(s),g(ne.$$.fragment,s),to=l(s),K=p(s,"P",{});var Yn=M(K);$c=h(Yn,`Self-attention puts each token in relation to each other’s tokens.
As an example, the`),ao=u(Yn,!1),eo=h(Yn," matrix of the text input sequence "),fn=p(Yn,"EM",{"data-svelte-h":!0}),o(fn)!=="svelte-13ogmf8"&&(fn.textContent=Cg),Zc=h(Yn," could look as follows:"),Yn.forEach(a),no=l(s),le=p(s,"P",{"data-svelte-h":!0}),o(le)!=="svelte-7ssrcl"&&(le.innerHTML=Lg),lo=l(s),ie=p(s,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1xg4o0y"&&(ie.innerHTML=zg),io=l(s),$=p(s,"P",{});var Y=M($);Ic=h(Y,`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by`),po=u(Y,!1),mo=h(Y," relates each word token to each other word token in"),oo=u(Y,!1),ro=h(Y,` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),yn=p(Y,"EM",{"data-svelte-h":!0}),o(yn)!=="svelte-2dbwd4"&&(yn.textContent=Gg),Hc=h(Y," differentiating between "),wn=p(Y,"EM",{"data-svelte-h":!0}),o(wn)!=="svelte-1u1601v"&&(wn.textContent=Bg),Wc=h(Y," and "),bn=p(Y,"EM",{"data-svelte-h":!0}),o(bn)!=="svelte-16pe0y3"&&(bn.textContent=$g),Qc=h(Y," would be very challenging."),Y.forEach(a),ho=l(s),pe=p(s,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-10v2cm"&&(pe.innerHTML=Zg),co=l(s),L=p(s,"P",{});var H=M(L);Nc=h(H,"The authors of the "),rs=p(H,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(rs)!=="svelte-507xi2"&&(rs.innerHTML=Ig),Rc=h(H," paper introduced sinusoidal positional embeddings"),uo=u(H,!1),go=h(H,` .
where each vector`),fo=u(H,!1),yo=h(H," is computed as a sinusoidal function of its position"),wo=u(H,!1),bo=h(H,` .
The positional encodings are then simply added to the input sequence vectors`),vo=u(H,!1),Mo=h(H," ="),xo=u(H,!1),ko=h(H," thereby cueing the model to better learn sentence order."),H.forEach(a),To=l(s),D=p(s,"P",{});var Pn=M(D);qc=h(Pn,"Instead of using fixed position embeddings, others (such as "),hs=p(Pn,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(hs)!=="svelte-1j8obl2"&&(hs.textContent=Hg),Xc=h(Pn,") used learned positional encodings for which the positional embeddings"),_o=u(Pn,!1),jo=h(Pn," are learned during training."),Pn.forEach(a),Uo=l(s),me=p(s,"P",{"data-svelte-h":!0}),o(me)!=="svelte-gfh3nk"&&(me.textContent=Wg),Jo=l(s),cs=p(s,"OL",{});var mc=M(cs);N=p(mc,"LI",{});var as=M(N);Vc=h(as,"Sinusoidal and learned position embeddings are both absolute positional embeddings, "),vn=p(as,"EM",{"data-svelte-h":!0}),o(vn)!=="svelte-1636wt6"&&(vn.textContent=Qg),Ac=h(as," encoding a unique embedding for each position id:"),Co=u(as,!1),Lo=h(as," . As shown by "),us=p(as,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(us)!=="svelte-1elqrnk"&&(us.textContent=Ng),Ec=h(as," and "),ds=p(as,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(ds)!=="svelte-sksjon"&&(ds.textContent=Rg),Sc=h(as,", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),as.forEach(a),Yc=l(mc),oe=p(mc,"LI",{});var oc=M(oe);Pc=h(oc,"When using learned position embeddings, the LLM has to be trained on a fixed input length"),zo=u(oc,!1),Go=h(oc,", which makes it difficult to extrapolate to an input length longer than what it was trained on."),oc.forEach(a),mc.forEach(a),Bo=l(s),re=p(s,"P",{"data-svelte-h":!0}),o(re)!=="svelte-pzlnat"&&(re.textContent=qg),$o=l(s),he=p(s,"UL",{"data-svelte-h":!0}),o(he)!=="svelte-1q2i0ic"&&(he.innerHTML=Xg),Zo=l(s),A=p(s,"P",{});var Ts=M(A);Fc=h(Ts,"Both "),Mn=p(Ts,"EM",{"data-svelte-h":!0}),o(Mn)!=="svelte-1koqbni"&&(Mn.textContent=Vg),Kc=h(Ts," and "),xn=p(Ts,"EM",{"data-svelte-h":!0}),o(xn)!=="svelte-4g6i8t"&&(xn.textContent=Ag),Dc=h(Ts," argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the"),Io=u(Ts,!1),Ho=h(Ts," computation."),Ts.forEach(a),Wo=l(s),k=p(s,"P",{});var j=M(k);Oc=h(j,"Without going into too many details, "),kn=p(j,"EM",{"data-svelte-h":!0}),o(kn)!=="svelte-1koqbni"&&(kn.textContent=Eg),su=h(j," notes that positional information can be encoded into query-key pairs, "),Tn=p(j,"EM",{"data-svelte-h":!0}),o(Tn)!=="svelte-2dbwd4"&&(Tn.textContent=Sg),Qo=u(j,!1),No=h(j," and"),Ro=u(j,!1),qo=h(j," by rotating each vector by an angle"),Xo=u(j,!1),Vo=h(j," and"),Ao=u(j,!1),Eo=h(j," respectively with"),So=u(j,!1),Yo=h(j,` describing each vectors sentence position:
`),Po=u(j,!1),Fo=l(j),Ko=u(j,!1),Do=h(j," thereby represents a rotational matrix."),Oo=u(j,!1),sr=h(j," is "),_n=p(j,"EM",{"data-svelte-h":!0}),o(_n)!=="svelte-r5iszh"&&(_n.textContent=Yg),tu=h(j," learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),j.forEach(a),tr=l(s),jn=p(s,"BLOCKQUOTE",{});var sy=M(jn);B=p(sy,"P",{});var W=M(B);au=h(W,"By doing so, the propability score between"),ar=u(W,!1),er=h(W," and"),nr=u(W,!1),lr=h(W," is only affected if"),ir=u(W,!1),pr=h(W," and solely depends on the relative distance"),mr=u(W,!1),or=h(W," regardless of each vector’s specific positions"),rr=u(W,!1),hr=h(W," and"),cr=u(W,!1),ur=h(W," ."),W.forEach(a),sy.forEach(a),dr=l(s),ce=p(s,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ct7c61"&&(ce.innerHTML=Pg),gr=l(s),ue=p(s,"UL",{"data-svelte-h":!0}),o(ue)!=="svelte-1ggqrue"&&(ue.innerHTML=Fg),fr=l(s),E=p(s,"P",{});var _s=M(E);eu=h(_s,"As an alternative, "),Un=p(_s,"EM",{"data-svelte-h":!0}),o(Un)!=="svelte-4g6i8t"&&(Un.textContent=Kg),nu=h(_s," proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Jn=p(_s,"CODE",{"data-svelte-h":!0}),o(Jn)!=="svelte-1gskrin"&&(Jn.textContent=Dg),lu=h(_s," to each query-key entry of the"),yr=u(_s,!1),wr=h(_s," matrix right before the softmax computation."),_s.forEach(a),br=l(s),de=p(s,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1sb0gvf"&&(de.innerHTML=Og),vr=l(s),ge=p(s,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1stpbxv"&&(ge.innerHTML=sf),Mr=l(s),fe=p(s,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-3uyjm"&&(fe.innerHTML=tf),xr=l(s),ye=p(s,"UL",{"data-svelte-h":!0}),o(ye)!=="svelte-l3k8fx"&&(ye.innerHTML=af),kr=l(s),x=p(s,"P",{});var _=M(x);iu=h(_,"Both "),Cn=p(_,"EM",{"data-svelte-h":!0}),o(Cn)!=="svelte-1koqbni"&&(Cn.textContent=ef),pu=h(_," and "),Ln=p(_,"EM",{"data-svelte-h":!0}),o(Ln)!=="svelte-4g6i8t"&&(Ln.textContent=nf),mu=h(_," position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),zn=p(_,"EM",{"data-svelte-h":!0}),o(zn)!=="svelte-4g6i8t"&&(zn.textContent=lf),ou=h(_," as compared to "),Gn=p(_,"EM",{"data-svelte-h":!0}),o(Gn)!=="svelte-1koqbni"&&(Gn.textContent=pf),ru=h(_,`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),Bn=p(_,"EM",{"data-svelte-h":!0}),o(Bn)!=="svelte-1koqbni"&&(Bn.textContent=mf),hu=h(_,", keeping the same"),Tr=u(_,!1),_r=h(_," that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),$n=p(_,"EM",{"data-svelte-h":!0}),o($n)!=="svelte-6ye6px"&&($n.textContent=of),cu=l(_),gs=p(_,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(gs)!=="svelte-1wv3alf"&&(gs.textContent=rf),uu=h(_,". However, the community has found a couple of effective tricks that adapt"),jr=u(_,!1),Ur=h(_,", thereby allowing "),Zn=p(_,"EM",{"data-svelte-h":!0}),o(Zn)!=="svelte-1koqbni"&&(Zn.textContent=hf),du=h(_," position embeddings to work well for extrapolated text input sequences (see "),fs=p(_,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(fs)!=="svelte-ax8fr8"&&(fs.textContent=cf),gu=h(_,")."),_.forEach(a),Jr=l(s),ys=p(s,"BLOCKQUOTE",{});var rc=M(ys);In=p(rc,"P",{"data-svelte-h":!0}),o(In)!=="svelte-1bw79ap"&&(In.innerHTML=uf),fu=l(rc),ps=p(rc,"UL",{});var Fn=M(ps);we=p(Fn,"LI",{});var hc=M(we);yu=h(hc,"Positional cues about the text inputs should be given directly to the"),Cr=u(hc,!1),Lr=h(hc," matrix of the self-attention layer"),hc.forEach(a),wu=l(Fn),Hn=p(Fn,"LI",{"data-svelte-h":!0}),o(Hn)!=="svelte-lwsxvy"&&(Hn.innerHTML=df),bu=l(Fn),Wn=p(Fn,"LI",{"data-svelte-h":!0}),o(Wn)!=="svelte-as1kp0"&&(Wn.textContent=gf),Fn.forEach(a),rc.forEach(a),zr=l(s),S=p(s,"P",{});var js=M(S);vu=h(js,"In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say"),Gr=u(js,!1),Br=h(js," it can still be used in practice with text inputs much larger than"),$r=u(js,!1),Zr=h(js,", like"),Ir=u(js,!1),Hr=h(js," by extrapolating the positional embeddings."),js.forEach(a),Wr=l(s),g(be.$$.fragment,s),Qr=l(s),ve=p(s,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-ph4j6j"&&(ve.textContent=ff),Nr=l(s),Me=p(s,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-583sqe"&&(Me.innerHTML=yf),Rr=l(s),xe=p(s,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-809dal"&&(xe.innerHTML=wf),qr=l(s),g(ke.$$.fragment,s),Xr=l(s),Te=p(s,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-jl1fz0"&&(Te.innerHTML=bf),Vr=l(s),g(_e.$$.fragment,s),Ar=l(s),je=p(s,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1hvw6ou"&&(je.textContent=vf),Er=l(s),Ue=p(s,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-cclyh"&&(Ue.innerHTML=Mf),Sr=l(s),z=p(s,"P",{});var Q=M(z);Mu=h(Q,"As a consequence, tokens "),Qn=p(Q,"EM",{"data-svelte-h":!0}),o(Qn)!=="svelte-1pjm1n8"&&(Qn.textContent=xf),xu=h(Q," depend on previous tokens, more specifically the"),Yr=u(Q,!1),Pr=h(Q," vector is never put in relation with any key, values vectors"),Fr=u(Q,!1),Kr=h(Q," if"),Dr=u(Q,!1),Or=h(Q," . Instead"),sh=u(Q,!1),th=h(Q," only attends to previous key-value vectors"),ah=u(Q,!1),eh=h(Q,". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),Q.forEach(a),nh=l(s),Je=p(s,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1f21m0a"&&(Je.innerHTML=kf),lh=l(s),g(Ce.$$.fragment,s),ih=l(s),Le=p(s,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-jl1fz0"&&(Le.innerHTML=Tf),ph=l(s),g(ze.$$.fragment,s),mh=l(s),Ge=p(s,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-sjvt58"&&(Ge.innerHTML=_f),oh=l(s),Nn=p(s,"BLOCKQUOTE",{});var ty=M(Nn);R=p(ty,"P",{});var es=M(R);ku=h(es,"Making use of the key-value cache means that the"),rh=u(es,!1),hh=h(es," is essentially reduced to"),ch=u(es,!1),uh=h(es," with"),dh=u(es,!1),gh=h(es," being the query projection of the currently passed input token which is "),Rn=p(es,"EM",{"data-svelte-h":!0}),o(Rn)!=="svelte-x3mkar"&&(Rn.textContent=jf),Tu=h(es," just a single vector."),es.forEach(a),ty.forEach(a),fh=l(s),Be=p(s,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1xsdpw0"&&(Be.textContent=Uf),yh=l(s),ws=p(s,"UL",{});var cc=M(ws);$e=p(cc,"LI",{});var uc=M($e);_u=h(uc,"Significant increase in computational efficiency as less computations are performed compared to computing the full"),wh=u(uc,!1),bh=h(uc," matrix. This leads to an increase in inference speed"),uc.forEach(a),ju=l(cc),qn=p(cc,"LI",{"data-svelte-h":!0}),o(qn)!=="svelte-1uy8i0e"&&(qn.textContent=Jf),cc.forEach(a),vh=l(s),Ze=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Ze)!=="svelte-ecu5gq"&&(Ze.innerHTML=Cf),Mh=l(s),Ie=p(s,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-lkbxcr"&&(Ie.textContent=Lf),xh=l(s),g(He.$$.fragment,s),kh=l(s),We=p(s,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1nmendz"&&(We.textContent=zf),Th=l(s),Qe=p(s,"UL",{"data-svelte-h":!0}),o(Qe)!=="svelte-g7cmgx"&&(Qe.innerHTML=Gf),_h=l(s),Ne=p(s,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-cqzbwt"&&(Ne.textContent=Bf),jh=l(s),Re=p(s,"OL",{"data-svelte-h":!0}),o(Re)!=="svelte-1bgwi27"&&(Re.innerHTML=$f),Uh=l(s),O=p(s,"P",{});var Kn=M(O);Uu=h(Kn,"There is however one catch. While the required peak memory for the"),Jh=u(Kn,!1),Ch=h(Kn," matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors"),Lh=u(Kn,!1),zh=h(Kn," for all self-attention layers and for all attention heads."),Kn.forEach(a),Gh=l(s),qe=p(s,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-hoekyy"&&(qe.innerHTML=Zf),Bh=l(s),g(Xe.$$.fragment,s),$h=l(s),Ve=p(s,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-jl1fz0"&&(Ve.innerHTML=If),Zh=l(s),g(Ae.$$.fragment,s),Ih=l(s),Ee=p(s,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-19el5ck"&&(Ee.innerHTML=Hf),Hh=l(s),Se=p(s,"OL",{"data-svelte-h":!0}),o(Se)!=="svelte-179mx96"&&(Se.innerHTML=Wf),Wh=l(s),Ye=p(s,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-ritjb3"&&(Ye.innerHTML=Qf),Qh=l(s),Xn=p(s,"BLOCKQUOTE",{});var ay=M(Xn);ms=p(ay,"P",{});var Dn=M(ms);Ju=h(Dn,"By using a single head-value projection weight pair, the key value vectors"),Nh=u(Dn,!1),Rh=h(Dn," have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),Vn=p(Dn,"CODE",{"data-svelte-h":!0}),o(Vn)!=="svelte-6j0g1x"&&(Vn.textContent=Nf),Cu=h(Dn," ones."),Dn.forEach(a),ay.forEach(a),qh=l(s),Pe=p(s,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-16lijvq"&&(Pe.textContent=Rf),Xh=l(s),ss=p(s,"P",{});var On=M(ss);Lu=h(On,`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the`),Vh=u(On,!1),Ah=h(On," computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),bs=p(On,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(bs)!=="svelte-cg4wmi"&&(bs.textContent=qf),zu=h(On,"."),On.forEach(a),Eh=l(s),vs=p(s,"P",{});var dc=M(vs);Gu=h(dc,"The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different"),Sh=u(dc,!1),Yh=h(dc," matrix."),dc.forEach(a),Ph=l(s),Fe=p(s,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1q4ym7y"&&(Fe.textContent=Xf),Fh=l(s),Ke=p(s,"UL",{"data-svelte-h":!0}),o(Ke)!=="svelte-c4p3y"&&(Ke.innerHTML=Vf),Kh=l(s),De=p(s,"P",{"data-svelte-h":!0}),o(De)!=="svelte-fzvfyw"&&(De.innerHTML=Af),Dh=l(s),Ms=p(s,"OL",{start:!0,"data-svelte-h":!0}),o(Ms)!=="svelte-e4z24x"&&(Ms.innerHTML=Ef),Oh=l(s),Oe=p(s,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-jkms2s"&&(Oe.innerHTML=Sf),sc=l(s),sn=p(s,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-1rn3bde"&&(sn.innerHTML=Yf),tc=l(s),tn=p(s,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-c4mo8y"&&(tn.innerHTML=Pf),ac=l(s),an=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(an)!=="svelte-xhly52"&&(an.innerHTML=Ff),ec=l(s),g(en.$$.fragment,s),nc=l(s),nn=p(s,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-1r7m8vw"&&(nn.innerHTML=Kf),lc=l(s),ln=p(s,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-2w30uj"&&(ln.innerHTML=Df),ic=l(s),tl=p(s,"P",{}),M(tl).forEach(a),this.h()},h(){J(ns,"name","hf:doc:metadata"),J(ns,"content",Ww),ti.a=ai,ei.a=ni,li.a=ii,pi.a=null,oi.a=null,Wi.a=Qi,Ni.a=Ri,Oi.a=sp,ap.a=ep,np.a=lp,ip.a=pp,mp.a=op,rp.a=hp,cp.a=up,dp.a=gp,fp.a=yp,wp.a=bp,vp.a=Mp,kp.a=Tp,_p.a=jp,Up.a=Jp,Cp.a=Lp,zp.a=Gp,Bp.a=$p,Wp.a=Qp,J(os,"href","https://arxiv.org/abs/2205.14135"),J(os,"rel","nofollow"),Rp.a=qp,Xp.a=null,Ap.a=Ep,Sp.a=Yp,Pp.a=Fp,Kp.a=Dp,am.a=em,pm.a=mm,ao.a=eo,po.a=mo,oo.a=ro,J(rs,"href","https://arxiv.org/abs/1706.03762"),J(rs,"rel","nofollow"),uo.a=go,fo.a=yo,wo.a=bo,vo.a=Mo,xo.a=ko,J(hs,"href","https://arxiv.org/abs/1810.04805"),J(hs,"rel","nofollow"),_o.a=jo,Co.a=Lo,J(us,"href","https://arxiv.org/abs/2009.13658"),J(us,"rel","nofollow"),J(ds,"href","https://arxiv.org/abs/2104.09864"),J(ds,"rel","nofollow"),zo.a=Go,Io.a=Ho,Qo.a=No,Ro.a=qo,Xo.a=Vo,Ao.a=Eo,So.a=Yo,Po.a=Fo,Ko.a=Do,Oo.a=sr,ar.a=er,nr.a=lr,ir.a=pr,mr.a=or,rr.a=hr,cr.a=ur,yr.a=wr,Tr.a=_r,J(gs,"href","https://arxiv.org/abs/2108.12409"),J(gs,"rel","nofollow"),jr.a=Ur,J(fs,"href","https://github.com/huggingface/transformers/pull/24653"),J(fs,"rel","nofollow"),Cr.a=Lr,Gr.a=Br,$r.a=Zr,Ir.a=Hr,Yr.a=Pr,Fr.a=Kr,Dr.a=Or,sh.a=th,ah.a=eh,rh.a=hh,ch.a=uh,dh.a=gh,wh.a=bh,Jh.a=Ch,Lh.a=zh,Nh.a=Rh,Vh.a=Ah,J(bs,"href","https://arxiv.org/abs/1911.02150"),J(bs,"rel","nofollow"),Sh.a=Yh,J(Ms,"start","2")},m(s,t){m(document.head,ns),e(s,el,t),e(s,sl,t),e(s,nl,t),f(Us,s,t),e(s,ll,t),f(Js,s,t),e(s,il,t),e(s,Cs,t),e(s,pl,t),e(s,Ls,t),e(s,ml,t),e(s,zs,t),e(s,ol,t),e(s,Gs,t),e(s,rl,t),e(s,Bs,t),e(s,hl,t),e(s,$s,t),e(s,cl,t),f(Zs,s,t),e(s,ul,t),e(s,Is,t),e(s,dl,t),e(s,Hs,t),e(s,gl,t),e(s,Ws,t),e(s,fl,t),e(s,Qs,t),e(s,yl,t),e(s,Ns,t),e(s,wl,t),e(s,Rs,t),e(s,bl,t),e(s,qs,t),e(s,vl,t),e(s,Xs,t),e(s,Ml,t),e(s,Vs,t),e(s,xl,t),e(s,As,t),e(s,kl,t),e(s,Es,t),e(s,Tl,t),e(s,Ss,t),e(s,_l,t),f(Ys,s,t),e(s,jl,t),f(Ps,s,t),e(s,Ul,t),e(s,Fs,t),e(s,Jl,t),e(s,Ks,t),e(s,Cl,t),e(s,Ds,t),e(s,Ll,t),e(s,Os,t),e(s,zl,t),f(st,s,t),e(s,Gl,t),f(tt,s,t),e(s,Bl,t),e(s,at,t),e(s,$l,t),f(et,s,t),e(s,Zl,t),e(s,nt,t),e(s,Il,t),f(lt,s,t),e(s,Hl,t),e(s,it,t),e(s,Wl,t),f(pt,s,t),e(s,Ql,t),e(s,mt,t),e(s,Nl,t),f(ot,s,t),e(s,Rl,t),e(s,rt,t),e(s,ql,t),e(s,ht,t),e(s,Xl,t),e(s,ct,t),e(s,Vl,t),e(s,ut,t),e(s,Al,t),f(dt,s,t),e(s,El,t),e(s,gt,t),e(s,Sl,t),f(ft,s,t),e(s,Yl,t),e(s,yt,t),e(s,Pl,t),f(wt,s,t),e(s,Fl,t),e(s,bt,t),e(s,Kl,t),e(s,vt,t),e(s,Dl,t),e(s,Mt,t),e(s,Ol,t),e(s,xt,t),e(s,si,t),e(s,G,t),m(G,gc),m(G,mn),m(G,fc),ti.m(ey,G),m(G,ai),m(G,on),m(G,yc),ei.m(ny,G),m(G,ni),li.m(ly,G),m(G,ii),pi.m(iy,G),e(s,mi,t),e(s,kt,t),m(kt,wc),oi.m(py,kt),e(s,ri,t),e(s,Tt,t),e(s,hi,t),e(s,_t,t),e(s,ci,t),f(jt,s,t),e(s,ui,t),e(s,Ut,t),e(s,di,t),f(Jt,s,t),e(s,gi,t),e(s,Ct,t),e(s,fi,t),f(Lt,s,t),e(s,yi,t),e(s,zt,t),e(s,wi,t),f(Gt,s,t),e(s,bi,t),e(s,Bt,t),e(s,vi,t),f($t,s,t),e(s,Mi,t),e(s,Zt,t),e(s,xi,t),f(It,s,t),e(s,ki,t),e(s,Ht,t),e(s,Ti,t),e(s,Wt,t),e(s,_i,t),f(Qt,s,t),e(s,ji,t),f(Nt,s,t),e(s,Ui,t),e(s,Rt,t),e(s,Ji,t),f(qt,s,t),e(s,Ci,t),e(s,Xt,t),e(s,Li,t),f(Vt,s,t),e(s,zi,t),e(s,At,t),e(s,Gi,t),f(Et,s,t),e(s,Bi,t),e(s,St,t),e(s,$i,t),f(Yt,s,t),e(s,Zi,t),e(s,Pt,t),e(s,Ii,t),e(s,Ft,t),e(s,Hi,t),e(s,P,t),m(P,bc),Wi.m(my,P),m(P,Qi),Ni.m(oy,P),m(P,Ri),e(s,qi,t),f(Kt,s,t),e(s,Xi,t),f(Dt,s,t),e(s,Vi,t),e(s,Ot,t),e(s,Ai,t),e(s,sa,t),e(s,Ei,t),e(s,ta,t),e(s,Si,t),e(s,aa,t),e(s,Yi,t),e(s,ea,t),e(s,Pi,t),e(s,na,t),e(s,Fi,t),f(la,s,t),e(s,Ki,t),e(s,ia,t),e(s,Di,t),e(s,X,t),m(X,vc),m(X,rn),m(X,Mc),m(X,hn),m(X,xc),Oi.m(ry,X),m(X,sp),e(s,tp,t),e(s,T,t),m(T,kc),ap.m(hy,T),m(T,ep),np.m(cy,T),m(T,lp),ip.m(uy,T),m(T,pp),mp.m(dy,T),m(T,op),rp.m(gy,T),m(T,hp),cp.m(fy,T),m(T,up),dp.m(yy,T),m(T,gp),fp.m(wy,T),m(T,yp),wp.m(by,T),m(T,bp),vp.m(vy,T),m(T,Mp),e(s,xp,t),e(s,C,t),m(C,Tc),kp.m(My,C),m(C,Tp),_p.m(xy,C),m(C,jp),Up.m(ky,C),m(C,Jp),Cp.m(Ty,C),m(C,Lp),zp.m(_y,C),m(C,Gp),Bp.m(jy,C),m(C,$p),e(s,Zp,t),e(s,pa,t),e(s,Ip,t),e(s,ma,t),e(s,Hp,t),e(s,V,t),m(V,_c),Wp.m(Uy,V),m(V,Qp),m(V,os),m(V,jc),m(V,cn),m(V,Uc),e(s,Np,t),e(s,ls,t),m(ls,Jc),Rp.m(Jy,ls),m(ls,qp),Xp.m(Cy,ls),e(s,Vp,t),e(s,Z,t),m(Z,Cc),Ap.m(Ly,Z),m(Z,Ep),Sp.m(zy,Z),m(Z,Yp),Pp.m(Gy,Z),m(Z,Fp),Kp.m(By,Z),m(Z,Dp),e(s,Op,t),e(s,oa,t),e(s,sm,t),e(s,ra,t),e(s,tm,t),e(s,un,t),m(un,is),m(is,Lc),m(is,dn),m(is,zc),am.m($y,is),m(is,em),e(s,nm,t),e(s,ha,t),e(s,lm,t),e(s,ca,t),e(s,im,t),e(s,F,t),m(F,Gc),m(F,gn),m(F,Bc),pm.m(Zy,F),m(F,mm),e(s,om,t),e(s,ua,t),e(s,rm,t),e(s,da,t),e(s,hm,t),e(s,ga,t),e(s,cm,t),f(fa,s,t),e(s,um,t),e(s,ya,t),e(s,dm,t),f(wa,s,t),e(s,gm,t),e(s,ba,t),e(s,fm,t),f(va,s,t),e(s,ym,t),e(s,Ma,t),e(s,wm,t),f(xa,s,t),e(s,bm,t),e(s,ka,t),e(s,vm,t),f(Ta,s,t),e(s,Mm,t),e(s,_a,t),e(s,xm,t),e(s,ja,t),e(s,km,t),e(s,Ua,t),e(s,Tm,t),f(Ja,s,t),e(s,_m,t),e(s,Ca,t),e(s,jm,t),f(La,s,t),e(s,Um,t),e(s,za,t),e(s,Jm,t),e(s,Ga,t),e(s,Cm,t),f(Ba,s,t),e(s,Lm,t),e(s,$a,t),e(s,zm,t),f(Za,s,t),e(s,Gm,t),e(s,Ia,t),e(s,Bm,t),f(Ha,s,t),e(s,$m,t),e(s,Wa,t),e(s,Zm,t),f(Qa,s,t),e(s,Im,t),e(s,Na,t),e(s,Hm,t),e(s,Ra,t),e(s,Wm,t),f(qa,s,t),e(s,Qm,t),e(s,Xa,t),e(s,Nm,t),f(Va,s,t),e(s,Rm,t),e(s,Aa,t),e(s,qm,t),e(s,Ea,t),e(s,Xm,t),f(Sa,s,t),e(s,Vm,t),e(s,Ya,t),e(s,Am,t),f(Pa,s,t),e(s,Em,t),e(s,Fa,t),e(s,Sm,t),e(s,Ka,t),e(s,Ym,t),e(s,Da,t),e(s,Pm,t),e(s,Oa,t),e(s,Fm,t),e(s,se,t),e(s,Km,t),e(s,te,t),e(s,Dm,t),e(s,ae,t),e(s,Om,t),e(s,ee,t),e(s,so,t),f(ne,s,t),e(s,to,t),e(s,K,t),m(K,$c),ao.m(Iy,K),m(K,eo),m(K,fn),m(K,Zc),e(s,no,t),e(s,le,t),e(s,lo,t),e(s,ie,t),e(s,io,t),e(s,$,t),m($,Ic),po.m(Hy,$),m($,mo),oo.m(Wy,$),m($,ro),m($,yn),m($,Hc),m($,wn),m($,Wc),m($,bn),m($,Qc),e(s,ho,t),e(s,pe,t),e(s,co,t),e(s,L,t),m(L,Nc),m(L,rs),m(L,Rc),uo.m(Qy,L),m(L,go),fo.m(Ny,L),m(L,yo),wo.m(Ry,L),m(L,bo),vo.m(qy,L),m(L,Mo),xo.m(Xy,L),m(L,ko),e(s,To,t),e(s,D,t),m(D,qc),m(D,hs),m(D,Xc),_o.m(Vy,D),m(D,jo),e(s,Uo,t),e(s,me,t),e(s,Jo,t),e(s,cs,t),m(cs,N),m(N,Vc),m(N,vn),m(N,Ac),Co.m(Ay,N),m(N,Lo),m(N,us),m(N,Ec),m(N,ds),m(N,Sc),m(cs,Yc),m(cs,oe),m(oe,Pc),zo.m(Ey,oe),m(oe,Go),e(s,Bo,t),e(s,re,t),e(s,$o,t),e(s,he,t),e(s,Zo,t),e(s,A,t),m(A,Fc),m(A,Mn),m(A,Kc),m(A,xn),m(A,Dc),Io.m(Sy,A),m(A,Ho),e(s,Wo,t),e(s,k,t),m(k,Oc),m(k,kn),m(k,su),m(k,Tn),Qo.m(Yy,k),m(k,No),Ro.m(Py,k),m(k,qo),Xo.m(Fy,k),m(k,Vo),Ao.m(Ky,k),m(k,Eo),So.m(Dy,k),m(k,Yo),Po.m(Oy,k),m(k,Fo),Ko.m(sw,k),m(k,Do),Oo.m(tw,k),m(k,sr),m(k,_n),m(k,tu),e(s,tr,t),e(s,jn,t),m(jn,B),m(B,au),ar.m(aw,B),m(B,er),nr.m(ew,B),m(B,lr),ir.m(nw,B),m(B,pr),mr.m(lw,B),m(B,or),rr.m(iw,B),m(B,hr),cr.m(pw,B),m(B,ur),e(s,dr,t),e(s,ce,t),e(s,gr,t),e(s,ue,t),e(s,fr,t),e(s,E,t),m(E,eu),m(E,Un),m(E,nu),m(E,Jn),m(E,lu),yr.m(mw,E),m(E,wr),e(s,br,t),e(s,de,t),e(s,vr,t),e(s,ge,t),e(s,Mr,t),e(s,fe,t),e(s,xr,t),e(s,ye,t),e(s,kr,t),e(s,x,t),m(x,iu),m(x,Cn),m(x,pu),m(x,Ln),m(x,mu),m(x,zn),m(x,ou),m(x,Gn),m(x,ru),m(x,Bn),m(x,hu),Tr.m(ow,x),m(x,_r),m(x,$n),m(x,cu),m(x,gs),m(x,uu),jr.m(rw,x),m(x,Ur),m(x,Zn),m(x,du),m(x,fs),m(x,gu),e(s,Jr,t),e(s,ys,t),m(ys,In),m(ys,fu),m(ys,ps),m(ps,we),m(we,yu),Cr.m(hw,we),m(we,Lr),m(ps,wu),m(ps,Hn),m(ps,bu),m(ps,Wn),e(s,zr,t),e(s,S,t),m(S,vu),Gr.m(cw,S),m(S,Br),$r.m(uw,S),m(S,Zr),Ir.m(dw,S),m(S,Hr),e(s,Wr,t),f(be,s,t),e(s,Qr,t),e(s,ve,t),e(s,Nr,t),e(s,Me,t),e(s,Rr,t),e(s,xe,t),e(s,qr,t),f(ke,s,t),e(s,Xr,t),e(s,Te,t),e(s,Vr,t),f(_e,s,t),e(s,Ar,t),e(s,je,t),e(s,Er,t),e(s,Ue,t),e(s,Sr,t),e(s,z,t),m(z,Mu),m(z,Qn),m(z,xu),Yr.m(gw,z),m(z,Pr),Fr.m(fw,z),m(z,Kr),Dr.m(yw,z),m(z,Or),sh.m(ww,z),m(z,th),ah.m(bw,z),m(z,eh),e(s,nh,t),e(s,Je,t),e(s,lh,t),f(Ce,s,t),e(s,ih,t),e(s,Le,t),e(s,ph,t),f(ze,s,t),e(s,mh,t),e(s,Ge,t),e(s,oh,t),e(s,Nn,t),m(Nn,R),m(R,ku),rh.m(vw,R),m(R,hh),ch.m(Mw,R),m(R,uh),dh.m(xw,R),m(R,gh),m(R,Rn),m(R,Tu),e(s,fh,t),e(s,Be,t),e(s,yh,t),e(s,ws,t),m(ws,$e),m($e,_u),wh.m(kw,$e),m($e,bh),m(ws,ju),m(ws,qn),e(s,vh,t),e(s,Ze,t),e(s,Mh,t),e(s,Ie,t),e(s,xh,t),f(He,s,t),e(s,kh,t),e(s,We,t),e(s,Th,t),e(s,Qe,t),e(s,_h,t),e(s,Ne,t),e(s,jh,t),e(s,Re,t),e(s,Uh,t),e(s,O,t),m(O,Uu),Jh.m(Tw,O),m(O,Ch),Lh.m(_w,O),m(O,zh),e(s,Gh,t),e(s,qe,t),e(s,Bh,t),f(Xe,s,t),e(s,$h,t),e(s,Ve,t),e(s,Zh,t),f(Ae,s,t),e(s,Ih,t),e(s,Ee,t),e(s,Hh,t),e(s,Se,t),e(s,Wh,t),e(s,Ye,t),e(s,Qh,t),e(s,Xn,t),m(Xn,ms),m(ms,Ju),Nh.m(jw,ms),m(ms,Rh),m(ms,Vn),m(ms,Cu),e(s,qh,t),e(s,Pe,t),e(s,Xh,t),e(s,ss,t),m(ss,Lu),Vh.m(Uw,ss),m(ss,Ah),m(ss,bs),m(ss,zu),e(s,Eh,t),e(s,vs,t),m(vs,Gu),Sh.m(Jw,vs),m(vs,Yh),e(s,Ph,t),e(s,Fe,t),e(s,Fh,t),e(s,Ke,t),e(s,Kh,t),e(s,De,t),e(s,Dh,t),e(s,Ms,t),e(s,Oh,t),e(s,Oe,t),e(s,sc,t),e(s,sn,t),e(s,tc,t),e(s,tn,t),e(s,ac,t),e(s,an,t),e(s,ec,t),f(en,s,t),e(s,nc,t),e(s,nn,t),e(s,lc,t),e(s,ln,t),e(s,ic,t),e(s,tl,t),pc=!0},p:Lw,i(s){pc||(y(Us.$$.fragment,s),y(Js.$$.fragment,s),y(Zs.$$.fragment,s),y(Ys.$$.fragment,s),y(Ps.$$.fragment,s),y(st.$$.fragment,s),y(tt.$$.fragment,s),y(et.$$.fragment,s),y(lt.$$.fragment,s),y(pt.$$.fragment,s),y(ot.$$.fragment,s),y(dt.$$.fragment,s),y(ft.$$.fragment,s),y(wt.$$.fragment,s),y(jt.$$.fragment,s),y(Jt.$$.fragment,s),y(Lt.$$.fragment,s),y(Gt.$$.fragment,s),y($t.$$.fragment,s),y(It.$$.fragment,s),y(Qt.$$.fragment,s),y(Nt.$$.fragment,s),y(qt.$$.fragment,s),y(Vt.$$.fragment,s),y(Et.$$.fragment,s),y(Yt.$$.fragment,s),y(Kt.$$.fragment,s),y(Dt.$$.fragment,s),y(la.$$.fragment,s),y(fa.$$.fragment,s),y(wa.$$.fragment,s),y(va.$$.fragment,s),y(xa.$$.fragment,s),y(Ta.$$.fragment,s),y(Ja.$$.fragment,s),y(La.$$.fragment,s),y(Ba.$$.fragment,s),y(Za.$$.fragment,s),y(Ha.$$.fragment,s),y(Qa.$$.fragment,s),y(qa.$$.fragment,s),y(Va.$$.fragment,s),y(Sa.$$.fragment,s),y(Pa.$$.fragment,s),y(ne.$$.fragment,s),y(be.$$.fragment,s),y(ke.$$.fragment,s),y(_e.$$.fragment,s),y(Ce.$$.fragment,s),y(ze.$$.fragment,s),y(He.$$.fragment,s),y(Xe.$$.fragment,s),y(Ae.$$.fragment,s),y(en.$$.fragment,s),pc=!0)},o(s){w(Us.$$.fragment,s),w(Js.$$.fragment,s),w(Zs.$$.fragment,s),w(Ys.$$.fragment,s),w(Ps.$$.fragment,s),w(st.$$.fragment,s),w(tt.$$.fragment,s),w(et.$$.fragment,s),w(lt.$$.fragment,s),w(pt.$$.fragment,s),w(ot.$$.fragment,s),w(dt.$$.fragment,s),w(ft.$$.fragment,s),w(wt.$$.fragment,s),w(jt.$$.fragment,s),w(Jt.$$.fragment,s),w(Lt.$$.fragment,s),w(Gt.$$.fragment,s),w($t.$$.fragment,s),w(It.$$.fragment,s),w(Qt.$$.fragment,s),w(Nt.$$.fragment,s),w(qt.$$.fragment,s),w(Vt.$$.fragment,s),w(Et.$$.fragment,s),w(Yt.$$.fragment,s),w(Kt.$$.fragment,s),w(Dt.$$.fragment,s),w(la.$$.fragment,s),w(fa.$$.fragment,s),w(wa.$$.fragment,s),w(va.$$.fragment,s),w(xa.$$.fragment,s),w(Ta.$$.fragment,s),w(Ja.$$.fragment,s),w(La.$$.fragment,s),w(Ba.$$.fragment,s),w(Za.$$.fragment,s),w(Ha.$$.fragment,s),w(Qa.$$.fragment,s),w(qa.$$.fragment,s),w(Va.$$.fragment,s),w(Sa.$$.fragment,s),w(Pa.$$.fragment,s),w(ne.$$.fragment,s),w(be.$$.fragment,s),w(ke.$$.fragment,s),w(_e.$$.fragment,s),w(Ce.$$.fragment,s),w(ze.$$.fragment,s),w(He.$$.fragment,s),w(Xe.$$.fragment,s),w(Ae.$$.fragment,s),w(en.$$.fragment,s),pc=!1},d(s){s&&(a(el),a(sl),a(nl),a(ll),a(il),a(Cs),a(pl),a(Ls),a(ml),a(zs),a(ol),a(Gs),a(rl),a(Bs),a(hl),a($s),a(cl),a(ul),a(Is),a(dl),a(Hs),a(gl),a(Ws),a(fl),a(Qs),a(yl),a(Ns),a(wl),a(Rs),a(bl),a(qs),a(vl),a(Xs),a(Ml),a(Vs),a(xl),a(As),a(kl),a(Es),a(Tl),a(Ss),a(_l),a(jl),a(Ul),a(Fs),a(Jl),a(Ks),a(Cl),a(Ds),a(Ll),a(Os),a(zl),a(Gl),a(Bl),a(at),a($l),a(Zl),a(nt),a(Il),a(Hl),a(it),a(Wl),a(Ql),a(mt),a(Nl),a(Rl),a(rt),a(ql),a(ht),a(Xl),a(ct),a(Vl),a(ut),a(Al),a(El),a(gt),a(Sl),a(Yl),a(yt),a(Pl),a(Fl),a(bt),a(Kl),a(vt),a(Dl),a(Mt),a(Ol),a(xt),a(si),a(G),a(mi),a(kt),a(ri),a(Tt),a(hi),a(_t),a(ci),a(ui),a(Ut),a(di),a(gi),a(Ct),a(fi),a(yi),a(zt),a(wi),a(bi),a(Bt),a(vi),a(Mi),a(Zt),a(xi),a(ki),a(Ht),a(Ti),a(Wt),a(_i),a(ji),a(Ui),a(Rt),a(Ji),a(Ci),a(Xt),a(Li),a(zi),a(At),a(Gi),a(Bi),a(St),a($i),a(Zi),a(Pt),a(Ii),a(Ft),a(Hi),a(P),a(qi),a(Xi),a(Vi),a(Ot),a(Ai),a(sa),a(Ei),a(ta),a(Si),a(aa),a(Yi),a(ea),a(Pi),a(na),a(Fi),a(Ki),a(ia),a(Di),a(X),a(tp),a(T),a(xp),a(C),a(Zp),a(pa),a(Ip),a(ma),a(Hp),a(V),a(Np),a(ls),a(Vp),a(Z),a(Op),a(oa),a(sm),a(ra),a(tm),a(un),a(nm),a(ha),a(lm),a(ca),a(im),a(F),a(om),a(ua),a(rm),a(da),a(hm),a(ga),a(cm),a(um),a(ya),a(dm),a(gm),a(ba),a(fm),a(ym),a(Ma),a(wm),a(bm),a(ka),a(vm),a(Mm),a(_a),a(xm),a(ja),a(km),a(Ua),a(Tm),a(_m),a(Ca),a(jm),a(Um),a(za),a(Jm),a(Ga),a(Cm),a(Lm),a($a),a(zm),a(Gm),a(Ia),a(Bm),a($m),a(Wa),a(Zm),a(Im),a(Na),a(Hm),a(Ra),a(Wm),a(Qm),a(Xa),a(Nm),a(Rm),a(Aa),a(qm),a(Ea),a(Xm),a(Vm),a(Ya),a(Am),a(Em),a(Fa),a(Sm),a(Ka),a(Ym),a(Da),a(Pm),a(Oa),a(Fm),a(se),a(Km),a(te),a(Dm),a(ae),a(Om),a(ee),a(so),a(to),a(K),a(no),a(le),a(lo),a(ie),a(io),a($),a(ho),a(pe),a(co),a(L),a(To),a(D),a(Uo),a(me),a(Jo),a(cs),a(Bo),a(re),a($o),a(he),a(Zo),a(A),a(Wo),a(k),a(tr),a(jn),a(dr),a(ce),a(gr),a(ue),a(fr),a(E),a(br),a(de),a(vr),a(ge),a(Mr),a(fe),a(xr),a(ye),a(kr),a(x),a(Jr),a(ys),a(zr),a(S),a(Wr),a(Qr),a(ve),a(Nr),a(Me),a(Rr),a(xe),a(qr),a(Xr),a(Te),a(Vr),a(Ar),a(je),a(Er),a(Ue),a(Sr),a(z),a(nh),a(Je),a(lh),a(ih),a(Le),a(ph),a(mh),a(Ge),a(oh),a(Nn),a(fh),a(Be),a(yh),a(ws),a(vh),a(Ze),a(Mh),a(Ie),a(xh),a(kh),a(We),a(Th),a(Qe),a(_h),a(Ne),a(jh),a(Re),a(Uh),a(O),a(Gh),a(qe),a(Bh),a($h),a(Ve),a(Zh),a(Ih),a(Ee),a(Hh),a(Se),a(Wh),a(Ye),a(Qh),a(Xn),a(qh),a(Pe),a(Xh),a(ss),a(Eh),a(vs),a(Ph),a(Fe),a(Fh),a(Ke),a(Kh),a(De),a(Dh),a(Ms),a(Oh),a(Oe),a(sc),a(sn),a(tc),a(tn),a(ac),a(an),a(ec),a(nc),a(nn),a(lc),a(ln),a(ic),a(tl)),a(ns),b(Us,s),b(Js,s),b(Zs,s),b(Ys,s),b(Ps,s),b(st,s),b(tt,s),b(et,s),b(lt,s),b(pt,s),b(ot,s),b(dt,s),b(ft,s),b(wt,s),b(jt,s),b(Jt,s),b(Lt,s),b(Gt,s),b($t,s),b(It,s),b(Qt,s),b(Nt,s),b(qt,s),b(Vt,s),b(Et,s),b(Yt,s),b(Kt,s),b(Dt,s),b(la,s),b(fa,s),b(wa,s),b(va,s),b(xa,s),b(Ta,s),b(Ja,s),b(La,s),b(Ba,s),b(Za,s),b(Ha,s),b(Qa,s),b(qa,s),b(Va,s),b(Sa,s),b(Pa,s),b(ne,s),b(be,s),b(ke,s),b(_e,s),b(Ce,s),b(ze,s),b(He,s),b(Xe,s),b(Ae,s),b(en,s)}}}const Ww='{"title":"Optimizing LLMs for Speed and Memory","local":"optimizing-llms-for-speed-and-memory","sections":[{"title":"1. Lower Precision","local":"1-lower-precision","sections":[],"depth":2}],"depth":1}';function Qw($u){return zw(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Zw}),[]}class Aw extends Gw{constructor(ns){super(),Bw(this,ns,Qw,Hw,Cw,{})}}export{Aw as component};
