import{s as At,n as Kt,o as Ot}from"../chunks/scheduler.36a0863c.js";import{S as el,i as tl,g as i,s,r as d,A as ll,h as o,f as l,c as n,j as St,u as r,x as m,k as Dt,y as al,a,v as p,d as u,t as c,w as g}from"../chunks/index.9c13489a.js";import{H as b,g as sl}from"../chunks/Heading.10b69d76.js";import{C as M}from"../chunks/CodeBlock.05d8ec32.js";import{D as nl}from"../chunks/DocNotebookDropdown.1b1fcfa3.js";function il(bt){let f,be,Me,ye,y,Je,J,Te,T,yt='Existen varios modelos multilingües en 🤗 Transformers y su uso para inferencia difiere de los modelos monolingües. Sin embargo, no <em>todos</em> los usos de los modelos multilingües son diferentes. Algunos modelos, como <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>, pueden utilizarse igual que un modelo monolingüe. Esta guía te enseñará cómo utilizar modelos multilingües cuyo uso difiere en la inferencia.',he,h,Ue,U,Jt="XLM tiene diez checkpoints diferentes de los cuales solo uno es monolingüe. Los nueve checkpoints restantes del modelo pueden dividirse en dos categorías: los checkpoints que utilizan language embeddings y los que no.",je,j,$e,$,Tt="Los siguientes modelos XLM usan language embeddings para especificar el lenguaje utilizado en la inferencia:",ke,k,ht="<li><code>xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",we,w,Ut="Los language embeddings son representados como un tensor de la mismas dimensiones que los <code>input_ids</code> pasados al modelo. Los valores de estos tensores dependen del idioma utilizado y se identifican mediante los atributos <code>lang2id</code> y <code>id2lang</code> del tokenizador.",xe,x,jt="En este ejemplo, carga el checkpoint <code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French):",ve,v,Ce,C,$t="El atributo <code>lang2id</code> del tokenizador muestra los idiomas de este modelo y sus ids:",Ze,Z,_e,_,kt="A continuación, crea un input de ejemplo:",Xe,X,Ge,G,wt="Establece el id del idioma, por ejemplo <code>&quot;en&quot;</code>, y utilízalo para definir el language embedding. El language embedding es un tensor lleno de <code>0</code> ya que es el id del idioma para inglés. Este tensor debe ser del mismo tamaño que <code>input_ids</code>.",Ie,I,ze,z,xt="Ahora puedes pasar los <code>input_ids</code> y el language embedding al modelo:",Le,L,Re,R,vt='El script <a href="https://github.com/huggingface/transformers/tree/master/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> puede generar texto con language embeddings utilizando los checkpoints <code>xlm-clm</code>.',We,W,Ee,E,Ct="Los siguientes modelos XLM no requieren language embeddings durante la inferencia:",Ve,V,Zt="<li><code>xlm-mlm-17-1280</code> (modelado de lenguaje enmascarado, 17 idiomas)</li> <li><code>xlm-mlm-100-1280</code> (modelado de lenguaje enmascarado, 100 idiomas)</li>",Be,B,_t="Estos modelos se utilizan para representaciones genéricas de frases a diferencia de los anteriores checkpoints XLM.",He,H,qe,q,Xt="Los siguientes modelos de BERT pueden utilizarse para tareas multilingües:",Fe,F,Gt="<li><code>bert-base-multilingual-uncased</code> (modelado de lenguaje enmascarado + predicción de la siguiente oración, 102 idiomas)</li> <li><code>bert-base-multilingual-cased</code> (modelado de lenguaje enmascarado + predicción de la siguiente oración, 104 idiomas)</li>",Qe,Q,It=`Estos modelos no requieren language embeddings durante la inferencia. Deben identificar la lengua a partir del
contexto e inferir en consecuencia.`,Ye,Y,Ne,N,zt="Los siguientes modelos de XLM-RoBERTa pueden utilizarse para tareas multilingües:",Pe,P,Lt="<li><code>xlm-roberta-base</code> (modelado de lenguaje enmascarado, 100 idiomas)</li> <li><code>xlm-roberta-large</code> (Modelado de lenguaje enmascarado, 100 idiomas)</li>",Se,S,Rt="XLM-RoBERTa se entrenó con 2,5 TB de datos CommonCrawl recién creados y depurados en 100 idiomas. Proporciona fuertes ventajas sobre los modelos multilingües publicados anteriormente como mBERT o XLM en tareas posteriores como la clasificación, el etiquetado de secuencias y la respuesta a preguntas.",De,D,Ae,A,Wt="Los siguientes modelos de M2M100 pueden utilizarse para traducción multilingüe:",Ke,K,Et="<li><code>facebook/m2m100_418M</code> (traducción)</li> <li><code>facebook/m2m100_1.2B</code> (traducción)</li>",Oe,O,Vt="En este ejemplo, carga el checkpoint <code>facebook/m2m100_418M</code> para traducir del chino al inglés. Puedes establecer el idioma de origen en el tokenizador:",et,ee,tt,te,Bt="Tokeniza el texto:",lt,le,at,ae,Ht="M2M100 fuerza el id del idioma de destino como el primer token generado para traducir al idioma de destino.. Establece el <code>forced_bos_token_id</code> a <code>en</code> en el método <code>generate</code> para traducir al inglés:",st,se,nt,ne,it,ie,qt="Los siguientes modelos de MBart pueden utilizarse para traducción multilingüe:",ot,oe,Ft="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (traducción automática multilingüe de uno a muchos, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (traducción automática multilingüe de muchos a muchos, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (traducción automática multilingüe muchos a uno, 50 idiomas)</li> <li><code>facebook/mbart-large-50</code> (traducción multilingüe, 50 idiomas)</li> <li><code>facebook/mbart-large-cc25</code></li>",mt,me,Qt="En este ejemplo, carga el checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> para traducir del finlandés al inglés. Puedes establecer el idioma de origen en el tokenizador:",dt,de,rt,re,Yt="Tokeniza el texto:",pt,pe,ut,ue,Nt="MBart fuerza el id del idioma de destino como el primer token generado para traducirlo. Establece el <code>forced_bos_token_id</code> a <code>en</code> en el método <code>generate</code> para traducir al inglés:",ct,ce,gt,ge,Pt="Si estás usando el checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code> no necesitas forzar el id del idioma de destino como el primer token generado, de lo contrario el uso es el mismo.",Mt,fe,ft;return y=new b({props:{title:"Modelos multilingües para inferencia",local:"modelos-multilingües-para-inferencia",headingTag:"h1"}}),J=new nl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/multilingual.ipynb"}]}}),h=new b({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),j=new b({props:{title:"XLM con language embeddings",local:"xlm-con-language-embeddings",headingTag:"h3"}}),v=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),X=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),I=new M({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),L=new M({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),W=new b({props:{title:"XLM sin language embeddings",local:"xlm-sin-language-embeddings",headingTag:"h3"}}),H=new b({props:{title:"BERT",local:"bert",headingTag:"h2"}}),Y=new b({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),D=new b({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),se=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ne=new b({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),de=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),pe=new M({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ce=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){f=i("meta"),be=s(),Me=i("p"),ye=s(),d(y.$$.fragment),Je=s(),d(J.$$.fragment),Te=s(),T=i("p"),T.innerHTML=yt,he=s(),d(h.$$.fragment),Ue=s(),U=i("p"),U.textContent=Jt,je=s(),d(j.$$.fragment),$e=s(),$=i("p"),$.textContent=Tt,ke=s(),k=i("ul"),k.innerHTML=ht,we=s(),w=i("p"),w.innerHTML=Ut,xe=s(),x=i("p"),x.innerHTML=jt,ve=s(),d(v.$$.fragment),Ce=s(),C=i("p"),C.innerHTML=$t,Ze=s(),d(Z.$$.fragment),_e=s(),_=i("p"),_.textContent=kt,Xe=s(),d(X.$$.fragment),Ge=s(),G=i("p"),G.innerHTML=wt,Ie=s(),d(I.$$.fragment),ze=s(),z=i("p"),z.innerHTML=xt,Le=s(),d(L.$$.fragment),Re=s(),R=i("p"),R.innerHTML=vt,We=s(),d(W.$$.fragment),Ee=s(),E=i("p"),E.textContent=Ct,Ve=s(),V=i("ul"),V.innerHTML=Zt,Be=s(),B=i("p"),B.textContent=_t,He=s(),d(H.$$.fragment),qe=s(),q=i("p"),q.textContent=Xt,Fe=s(),F=i("ul"),F.innerHTML=Gt,Qe=s(),Q=i("p"),Q.textContent=It,Ye=s(),d(Y.$$.fragment),Ne=s(),N=i("p"),N.textContent=zt,Pe=s(),P=i("ul"),P.innerHTML=Lt,Se=s(),S=i("p"),S.textContent=Rt,De=s(),d(D.$$.fragment),Ae=s(),A=i("p"),A.textContent=Wt,Ke=s(),K=i("ul"),K.innerHTML=Et,Oe=s(),O=i("p"),O.innerHTML=Vt,et=s(),d(ee.$$.fragment),tt=s(),te=i("p"),te.textContent=Bt,lt=s(),d(le.$$.fragment),at=s(),ae=i("p"),ae.innerHTML=Ht,st=s(),d(se.$$.fragment),nt=s(),d(ne.$$.fragment),it=s(),ie=i("p"),ie.textContent=qt,ot=s(),oe=i("ul"),oe.innerHTML=Ft,mt=s(),me=i("p"),me.innerHTML=Qt,dt=s(),d(de.$$.fragment),rt=s(),re=i("p"),re.textContent=Yt,pt=s(),d(pe.$$.fragment),ut=s(),ue=i("p"),ue.innerHTML=Nt,ct=s(),d(ce.$$.fragment),gt=s(),ge=i("p"),ge.innerHTML=Pt,Mt=s(),fe=i("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),be=n(e),Me=o(e,"P",{}),St(Me).forEach(l),ye=n(e),r(y.$$.fragment,e),Je=n(e),r(J.$$.fragment,e),Te=n(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-12fdply"&&(T.innerHTML=yt),he=n(e),r(h.$$.fragment,e),Ue=n(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1tpv007"&&(U.textContent=Jt),je=n(e),r(j.$$.fragment,e),$e=n(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-sf6rgo"&&($.textContent=Tt),ke=n(e),k=o(e,"UL",{"data-svelte-h":!0}),m(k)!=="svelte-1iu32ge"&&(k.innerHTML=ht),we=n(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1j3qusn"&&(w.innerHTML=Ut),xe=n(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-15tg1x6"&&(x.innerHTML=jt),ve=n(e),r(v.$$.fragment,e),Ce=n(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-4lsbtx"&&(C.innerHTML=$t),Ze=n(e),r(Z.$$.fragment,e),_e=n(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1tlykvk"&&(_.textContent=kt),Xe=n(e),r(X.$$.fragment,e),Ge=n(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-zrx9u1"&&(G.innerHTML=wt),Ie=n(e),r(I.$$.fragment,e),ze=n(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-2882ma"&&(z.innerHTML=xt),Le=n(e),r(L.$$.fragment,e),Re=n(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-14aj7e4"&&(R.innerHTML=vt),We=n(e),r(W.$$.fragment,e),Ee=n(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-akh8od"&&(E.textContent=Ct),Ve=n(e),V=o(e,"UL",{"data-svelte-h":!0}),m(V)!=="svelte-1fb7h8u"&&(V.innerHTML=Zt),Be=n(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1yhdx4z"&&(B.textContent=_t),He=n(e),r(H.$$.fragment,e),qe=n(e),q=o(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-bc4ir5"&&(q.textContent=Xt),Fe=n(e),F=o(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-k7slx9"&&(F.innerHTML=Gt),Qe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1seqp0w"&&(Q.textContent=It),Ye=n(e),r(Y.$$.fragment,e),Ne=n(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1kvozu1"&&(N.textContent=zt),Pe=n(e),P=o(e,"UL",{"data-svelte-h":!0}),m(P)!=="svelte-1bin91k"&&(P.innerHTML=Lt),Se=n(e),S=o(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1u5ajxn"&&(S.textContent=Rt),De=n(e),r(D.$$.fragment,e),Ae=n(e),A=o(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-d5hmja"&&(A.textContent=Wt),Ke=n(e),K=o(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-1fs8mlx"&&(K.innerHTML=Et),Oe=n(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-15hj0dt"&&(O.innerHTML=Vt),et=n(e),r(ee.$$.fragment,e),tt=n(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-t0s1pc"&&(te.textContent=Bt),lt=n(e),r(le.$$.fragment,e),at=n(e),ae=o(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1ujoh2i"&&(ae.innerHTML=Ht),st=n(e),r(se.$$.fragment,e),nt=n(e),r(ne.$$.fragment,e),it=n(e),ie=o(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-11kyy3j"&&(ie.textContent=qt),ot=n(e),oe=o(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-1dl7zj1"&&(oe.innerHTML=Ft),mt=n(e),me=o(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-z8p06d"&&(me.innerHTML=Qt),dt=n(e),r(de.$$.fragment,e),rt=n(e),re=o(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-t0s1pc"&&(re.textContent=Yt),pt=n(e),r(pe.$$.fragment,e),ut=n(e),ue=o(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-qtehx9"&&(ue.innerHTML=Nt),ct=n(e),r(ce.$$.fragment,e),gt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1xi9zr5"&&(ge.innerHTML=Pt),Mt=n(e),fe=o(e,"P",{}),St(fe).forEach(l),this.h()},h(){Dt(f,"name","hf:doc:metadata"),Dt(f,"content",ol)},m(e,t){al(document.head,f),a(e,be,t),a(e,Me,t),a(e,ye,t),p(y,e,t),a(e,Je,t),p(J,e,t),a(e,Te,t),a(e,T,t),a(e,he,t),p(h,e,t),a(e,Ue,t),a(e,U,t),a(e,je,t),p(j,e,t),a(e,$e,t),a(e,$,t),a(e,ke,t),a(e,k,t),a(e,we,t),a(e,w,t),a(e,xe,t),a(e,x,t),a(e,ve,t),p(v,e,t),a(e,Ce,t),a(e,C,t),a(e,Ze,t),p(Z,e,t),a(e,_e,t),a(e,_,t),a(e,Xe,t),p(X,e,t),a(e,Ge,t),a(e,G,t),a(e,Ie,t),p(I,e,t),a(e,ze,t),a(e,z,t),a(e,Le,t),p(L,e,t),a(e,Re,t),a(e,R,t),a(e,We,t),p(W,e,t),a(e,Ee,t),a(e,E,t),a(e,Ve,t),a(e,V,t),a(e,Be,t),a(e,B,t),a(e,He,t),p(H,e,t),a(e,qe,t),a(e,q,t),a(e,Fe,t),a(e,F,t),a(e,Qe,t),a(e,Q,t),a(e,Ye,t),p(Y,e,t),a(e,Ne,t),a(e,N,t),a(e,Pe,t),a(e,P,t),a(e,Se,t),a(e,S,t),a(e,De,t),p(D,e,t),a(e,Ae,t),a(e,A,t),a(e,Ke,t),a(e,K,t),a(e,Oe,t),a(e,O,t),a(e,et,t),p(ee,e,t),a(e,tt,t),a(e,te,t),a(e,lt,t),p(le,e,t),a(e,at,t),a(e,ae,t),a(e,st,t),p(se,e,t),a(e,nt,t),p(ne,e,t),a(e,it,t),a(e,ie,t),a(e,ot,t),a(e,oe,t),a(e,mt,t),a(e,me,t),a(e,dt,t),p(de,e,t),a(e,rt,t),a(e,re,t),a(e,pt,t),p(pe,e,t),a(e,ut,t),a(e,ue,t),a(e,ct,t),p(ce,e,t),a(e,gt,t),a(e,ge,t),a(e,Mt,t),a(e,fe,t),ft=!0},p:Kt,i(e){ft||(u(y.$$.fragment,e),u(J.$$.fragment,e),u(h.$$.fragment,e),u(j.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(I.$$.fragment,e),u(L.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),ft=!0)},o(e){c(y.$$.fragment,e),c(J.$$.fragment,e),c(h.$$.fragment,e),c(j.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(X.$$.fragment,e),c(I.$$.fragment,e),c(L.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),ft=!1},d(e){e&&(l(be),l(Me),l(ye),l(Je),l(Te),l(T),l(he),l(Ue),l(U),l(je),l($e),l($),l(ke),l(k),l(we),l(w),l(xe),l(x),l(ve),l(Ce),l(C),l(Ze),l(_e),l(_),l(Xe),l(Ge),l(G),l(Ie),l(ze),l(z),l(Le),l(Re),l(R),l(We),l(Ee),l(E),l(Ve),l(V),l(Be),l(B),l(He),l(qe),l(q),l(Fe),l(F),l(Qe),l(Q),l(Ye),l(Ne),l(N),l(Pe),l(P),l(Se),l(S),l(De),l(Ae),l(A),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(at),l(ae),l(st),l(nt),l(it),l(ie),l(ot),l(oe),l(mt),l(me),l(dt),l(rt),l(re),l(pt),l(ut),l(ue),l(ct),l(gt),l(ge),l(Mt),l(fe)),l(f),g(y,e),g(J,e),g(h,e),g(j,e),g(v,e),g(Z,e),g(X,e),g(I,e),g(L,e),g(W,e),g(H,e),g(Y,e),g(D,e),g(ee,e),g(le,e),g(se,e),g(ne,e),g(de,e),g(pe,e),g(ce,e)}}}const ol='{"title":"Modelos multilingües para inferencia","local":"modelos-multilingües-para-inferencia","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM con language embeddings","local":"xlm-con-language-embeddings","sections":[],"depth":3},{"title":"XLM sin language embeddings","local":"xlm-sin-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function ml(bt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=sl}),[]}class gl extends el{constructor(f){super(),tl(this,f,ml,il,At,{})}}export{gl as component};
