import{s as tf,o as ef,n as lf}from"../chunks/scheduler.56730f09.js";import{S as sf,i as nf,g as p,s as n,r as u,A as pf,h as a,f as l,c as i,j as q1,u as r,x as f,k as K1,y as af,a as s,v as P,d as M,t as x,w as T}from"../chunks/index.1f144517.js";import{H as m,g as ff}from"../chunks/Heading.5c5b0b2d.js";import{T as uf}from"../chunks/Tip.41e845e5.js";import{C as Nl}from"../chunks/CodeBlock.738eeccb.js";function rf(Il){let v,h='참고: <a href="perf_train_gpu_one">단일 GPU 섹션</a>에서 소개된 전략(혼합 정밀도 훈련 또는 그래디언트 누적 등)은 일반적으로 모델 훈련에 적용되며, 다중-GPU 또는 CPU 훈련과 같은 다음 섹션으로 진입하기 전에 해당 섹션을 참고하는 것이 좋습니다.';return{c(){v=p("p"),v.innerHTML=h},l(C){v=a(C,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1whcmxn"&&(v.innerHTML=h)},m(C,$l){s(C,v,$l)},p:lf,d(C){C&&l(v)}}}function Pf(Il){let v,h,C,$l,j,El,L,ep="단일 GPU에서의 훈련이 너무 느리거나 모델 가중치가 단일 GPU의 메모리에 맞지 않는 경우, 다중-GPU 설정을 사용합니다. 단일 GPU에서 다중 GPU로 전환하기 위해서는 작업을 분산해야 합니다. 데이터, 텐서 또는 파이프라인과 같은 병렬화 기법을 사용하여 작업을 병렬로 처리할 수 있습니다. 그러나 이러한 설정을 모두에게 적용할 수 있는 완벽한 해결책은 없으며, 어떤 설정이 가장 적합한지는 사용하는 하드웨어에 따라 달라집니다. 이 문서는 주로 PyTorch 기반의 구현을 중심으로 설명하며, 대부분의 개념은 다른 프레임워크에도 적용될 수 있을 것으로 예상됩니다.",kl,o,Bl,_,lp="먼저 1D 병렬화 기술에 대해 자세히 논의한 후, 이러한 기술을 결합하여 2D 및 3D 병렬화를 구현하여 더 빠른 훈련과 더 큰 모델을 지원하는 방법을 살펴볼 것입니다. 또한 다른 효과적인 대안 방식도 소개될 예정입니다.",Ql,w,Zl,U,sp="다음은 이 문서에서 자세히 설명될 주요 개념에 대한 간단한 설명입니다.",Al,d,np="<li><strong>DataParallel (DP)</strong> - 동일한 설정이 여러 번 복제되고, 각 설정에 데이터 일부를 받습니다. 처리는 병렬로 수행되며 모든 설정은 각 훈련 단계의 끝날 때 동기화됩니다.</li> <li><strong>TensorParallel (TP)</strong> - 각 텐서는 여러 개의 묶음으로 분할되기에, 전체 텐서가 단일 GPU에 상주하는 대신 텐서의 각 샤드가 지정된 GPU에 상주합니다. 처리하는 동안 각 샤드는 서로 다른 GPU에서 개별적으로 병렬 처리되며 결과는 단계가 끝날 때 동기화됩니다. 분할이 수평 수준에서 이루어지기 때문에 이를 수평 병렬 처리라고 부를 수 있습니다.</li> <li><strong>PipelineParallel (PP)</strong> - 모델이 수직으로 (레이어 수준) 여러 GPU에 분할되어 모델의 단일 GPU에는 하나 또는 여러 레이어가 배치됩니다. 각 GPU는 파이프라인의 서로 다른 단계를 병렬로 처리하며 작은 배치 묶음에서 작동합니다.</li> <li><strong>Zero Redundancy Optimizer (ZeRO)</strong> - TP와 유사하게 텐서를 샤딩하지만, 전체 텐서는 순방향 또는 역방향 계산을 위해 재구성되므로 모델을 수정할 필요가 없습니다. 또한 제한된 GPU 메모리를 보완하기 위해 다양한 오프로드 기술을 지원합니다.</li> <li><strong>Sharded DDP</strong> - ZeRO의 기본 개념으로 다른 ZeRO 구현에서도 사용되는 용어입니다.</li>",Rl,c,ip="각 개념의 구체적인 내용에 대해 자세히 들어가기 전에 대규모 인프라에서 대규모 모델을 훈련하는 경우의 대략적인 결정 과정을 살펴보겠습니다.",Vl,b,Xl,y,pp="<strong>⇨ 단일 노드 / 다중-GPU</strong>",zl,g,ap="<li><p>모델이 단일 GPU에 맞는 경우:</p> <ol><li>DDP - 분산 DP</li> <li>ZeRO - 상황과 구성에 따라 더 빠를 수도 있고 그렇지 않을 수도 있음</li></ol></li> <li><p>모델이 단일 GPU에 맞지 않는 경우:</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>노드 내 연결 속도가 매우 빠른 NVLINK 또는 NVSwitch의 경우 세 가지 방법은 대부분 비슷한 성능을 보여야 하며, PP가 없는 경우 TP 또는 ZeRO보다 빠를 것입니다. TP의 정도도 차이를 만들 수 있습니다. 특정 설정에서 승자를 찾기 위해 실험하는 것이 가장 좋습니다.</p> <p>TP는 거의 항상 단일 노드 내에서 사용됩니다. 즉, TP 크기 &lt;= 노드당 GPU 수입니다.</p></li></ol></li> <li><p>가장 큰 레이어가 단일 GPU에 맞지 않는 경우:</p> <ol><li>ZeRO를 사용하지 않는 경우 - PP만으로는 맞지 않으므로 TP를 반드시 사용해야 함</li> <li>ZeRO를 사용하는 경우에는 위의 “단일 GPU” 항목과 동일</li></ol></li>",Fl,D,fp="<strong>⇨ 다중 노드 /  다중 GPU</strong>",Ol,J,up="<li><p>노드 간 연결 속도가 빠른 경우:</p> <ol><li>ZeRO - 모델에 대부분의 수정을 필요로 하지 않음</li> <li>PP+TP+DP - 통신이 적지만 모델에 대대적인 변경이 필요함</li></ol></li> <li><p>노드 간 연결 속도가 느리며, GPU 메모리가 여전히 부족한 경우:</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Wl,G,Yl,H,rp='2개의 GPU만으로도 대부분의 사용자들은 <code>DataParallel</code> (DP)과 <code>DistributedDataParallel</code> (DDP)을 통해 향상된 훈련 속도를 누릴 수 있습니다. 이는 PyTorch의 내장 기능입니다. 일반적으로 DDP를 사용하는 것이 좋으며, DP는 일부 모델에서 작동하지 않을 수 있으므로 주의해야 합니다. <a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch 문서</a>에서도 DDP의 사용을 권장합니다.',ql,$,Kl,S,Pp="<code>DistributedDataParallel</code> (DDP)은 일반적으로 <code>DataParallel</code> (DP)보다 빠르지만, 항상 그렇지는 않습니다:",ts,N,Mp="<li>DP는 파이썬 스레드 기반인 반면, DDP는 다중 프로세스 기반이기 때문에 GIL과 같은 파이썬 스레드 제한이 없습니다.</li> <li>그러나 GPU 카드 간의 느린 상호 연결성은 DDP로 인해 실제로 느린 결과를 낼 수 있습니다.</li>",es,I,xp="이 두 모드 간의 GPU 간 통신 오버헤드의 주요 차이점은 다음과 같습니다:",ls,E,Tp='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',ss,k,vp="<li>시작할 때, 주 프로세스가 모델을 gpu 0에서 다른 모든 gpu로 복제합니다.</li> <li>그런 다음 각 배치에 대해:<ol><li>각 gpu는 자체 미니 배치 데이터를 직접 사용합니다.</li> <li><code>backward</code> 동안 로컬 그래디언트가 준비되면, 모든 프로세스에 평균화됩니다.</li></ol></li>",ns,B,mp='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',is,Q,Cp="각 배치에 대해:",ps,Z,op="<li>gpu 0은 데이터 배치를 읽고 각 gpu에 미니 배치를 보냅니다.</li> <li>업데이트된 모델을 gpu 0에서 각 gpu로 복제합니다.</li> <li><code>forward</code>를 실행하고 각 gpu의 출력을 gpu 0으로 보내고 손실을 계산합니다.</li> <li>gpu 0에서 모든 gpu로 손실을 분산하고 <code>backward</code>를 실행합니다.</li> <li>각 gpu에서 그래디언트를 gpu 0으로 보내고 이를 평균화합니다.</li>",as,A,hp="DDP는 각 배치마다 그래디언트를 보내는 통신만을 수행하며, DP는 배치마다 5개의 다른 데이터 교환을 수행합니다.",fs,R,jp='DP는 파이썬 스레드를 통해 프로세스 내에서 데이터를 복제하며, DDP는 <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>를 통해 데이터를 복제합니다.',us,V,Lp="DP에서는 gpu 0이 다른 gpu보다 훨씬 더 많은 작업을 수행하므로, gpu의 활용도가 낮아집니다.",rs,X,_p="DDP는 여러 대의 컴퓨터에서 사용할 수 있지만, DP의 경우는 그렇지 않습니다.",Ps,z,wp="DP와 DDP 사이에는 다른 차이점이 있지만, 이 토론과는 관련이 없습니다.",Ms,F,Up='이 2가지 모드를 깊게 이해하고 싶다면, <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">이 문서</a>를 강력히 추천합니다. 이 문서는 멋진 다이어그램을 포함하고 있으며, 다양한 하드웨어에서 여러 벤치마크와 프로파일러 출력을 설명하여 필요한 세부 사항을 모두 설명합니다.',xs,O,dp="실제 벤치마크를 살펴보겠습니다:",Ts,W,cp='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',vs,Y,bp="분석:",ms,q,yp="여기서 DP는 NVlink가 있는 DDP보다 약 10% 느립니다. 그러나 NVlink가 없는 DDP보다 약 15% 빠릅니다.",Cs,K,gp="실제 차이는 각 GPU가 다른 GPU와 동기화해야 하는 데이터 양에 따라 달라질 것입니다. 동기화할 데이터가 많을수록 느린 링크가 총 실행 시간을 늦출 수 있습니다.",os,tt,Dp="다음은 전체 벤치마크 코드와 출력입니다:",hs,et,Jp="해당 벤치마크에서 <code>NCCL_P2P_DISABLE=1</code>을 사용하여 NVLink 기능을 비활성화했습니다.",js,lt,Ls,st,Gp=`하드웨어: 각각 24GB의 TITAN RTX 2개 + NVlink과 2개의 NVLink (<code>nvidia-smi topo -m</code>에서 <code>NV2</code>입니다.)
소프트웨어: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>`,_s,nt,ws,it,Hp=`ZeRO를 기반으로 한 데이터 병렬화 (ZeRO-DP)는 다음 <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">블로그 글</a>의 다음 다이어그램에서 설명되고 있습니다.
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>`,Us,pt,$p="이 개념은 이해하기 어려울 수 있지만, 실제로는 매우 간단한 개념입니다. 이는 일반적인 <code>DataParallel</code> (DP)과 동일하지만, 전체 모델 매개변수, 그래디언트 및 옵티마이저 상태를 복제하는 대신 각 GPU는 그 중 일부만 저장합니다. 그리고 실행 시간에는 주어진 레이어에 대해 전체 레이어 매개변수가 필요할 때 각 GPU가 서로에게 필요한 부분을 제공하기 위해 동기화됩니다 - 그게 전부입니다.",ds,at,Sp="각각 3개의 레이어와 3개의 매개변수가 있는 간단한 모델을 생각해 봅시다:",cs,ft,bs,ut,Np="레이어 La에는 가중치 a0, a1 및 a2가 있습니다.",ys,rt,Ip="3개의 GPU가 있는 경우, Sharded DDP (= Zero-DP)는 다음과 같이 모델을 3개의 GPU에 분할합니다:",gs,Pt,Ds,Mt,Ep="일반적인 DNN 다이어그램을 상상해보면 이는 텐서 병렬 처리와 같은 수평 슬라이싱입니다. 수직 슬라이싱은 전체 레이어 그룹을 다른 GPU에 배치하는 것입니다. 이는 시작에 불과합니다.",Js,xt,kp="이제 이러한 각각의 GPU는 DP에서 작동하는 것과 마찬가지로 일반적인 미니 배치를 받습니다:",Gs,Tt,Hs,vt,Bp="입력은 수정되지 않은 상태로 일반 모델에 의해 처리될 것으로 간주합니다.",$s,mt,Qp="먼저, 입력은 레이어 La에 도달합니다.",Ss,Ct,Zp="GPU0에만 집중해 보겠습니다. x0은 순방향 경로를 수행하기 위해 a0, a1, a2 파라미터가 필요하지만 GPU0에는 a0만 있습니다. GPU1에서 a1을, GPU2에서 a2를 전송받아 모델의 모든 조각을 하나로 모읍니다.",Ns,ot,Ap="병렬적으로, GPU1은 미니 배치 x1을 받고 a1만 가지고 있지만, a0 및 a2 매개변수가 필요합니다. 따라서 GPU0 및 GPU2에서 이를 가져옵니다.",Is,ht,Rp="GPU2도 동일한 작업을 수행합니다. 입력 x2를 받고 GPU0 및 GPU1에서 각각 a0과 a1을, 그리고 자신의 a2와 함께 전체 텐서를 복원합니다.",Es,jt,Vp="3개의 GPU는 복원된 전체 텐서를 받고 forward가 수행됩니다.",ks,Lt,Xp="계산이 완료되면 더 이상 필요하지 않은 데이터는 삭제되고, 해당 데이터는 계산 중에만 사용됩니다. 복원은 사전 패치를 통해 효율적으로 수행됩니다.",Bs,_t,zp="그리고 전체 프로세스는 레이어 Lb에 대해 반복되고, 그 다음 Lc로 순방향으로, 그다음은 역방향으로 Lc -> Lb -> La로 반복됩니다.",Qs,wt,Fp="개인적으로 이것은 효율적인 그룹 배낭 여행자의 중량 분배 전략처럼 들립니다:",Zs,Ut,Op="<li>사람 A가 텐트를 운반합니다.</li> <li>사람 B가 난로를 운반합니다.</li> <li>사람 C가 도끼를 운반합니다.</li>",As,dt,Wp="이제 매일 밤 각자 가진 것을 다른 사람들과 공유하고, 가지지 않은 것은 다른 사람들로부터 받고, 아침에는 할당된 유형의 장비를 싸고 계속해서 여행을 진행합니다. 이것이 Sharded DDP / Zero DP입니다.",Rs,ct,Yp="이 전략을 각각 자신의 텐트, 난로 및 도끼를 개별적으로 운반해야 하는 단순한 전략과 비교해보면 훨씬 비효율적일 것입니다. 이것이 Pytorch의 DataParallel (DP 및 DDP)입니다.",Vs,bt,qp="이 주제에 대해 논문을 읽을 때 다음 동의어를 만날 수 있습니다: Sharded, Partitioned.",Xs,yt,Kp="ZeRO가 모델 가중치를 분할하는 방식을 자세히 살펴보면, 텐서 병렬화와 매우 유사한 것을 알 수 있습니다. 이는 이후에 설명될 수직 모델 병렬화와는 달리 각 레이어의 가중치를 분할/분할하기 때문입니다.",zs,gt,ta="구현:",Fs,Dt,ea='<li><a href="https://www.deepspeed.ai/features/#the-zero-redundancy-optimizer" rel="nofollow">DeepSpeed</a>는 1단계 + 2단계 + 3단계의 ZeRO-DP를 제공합니다.</li> <li><a href="https://github.com/facebookresearch/fairscale/#optimizer-state-sharding-zero" rel="nofollow">Fairscale</a>은 1단계 + 2단계 + 3단계의 ZeRO-DP를 제공합니다.</li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> 통합</a></li>',Os,Jt,Ws,Gt,la="Naive Model Parallelism (MP)은 모델 레이어 그룹을 다중 GPU에 분산하는 방식입니다. 메커니즘은 상대적으로 간단합니다. 원하는 레이어를 <code>.to()</code>를 사용하여 원하는 장치로 전환하면 데이터가 해당 레이어로 들어오고 나갈 때 데이터도 레이어와 동일한 장치로 전환되고 나머지는 수정되지 않습니다.",Ys,Ht,sa="대부분의 모델이 그려지는 방식이 레이어를 세로로 슬라이스하기 때문에 이를 수직 모델 병렬화라고 부릅니다. 예를 들어 다음 다이어그램은 8레이어 모델을 보여줍니다:",qs,$t,Ks,St,na="우리는 모델을 수직으로 2개로 분할하여 레이어 0-3을 GPU0에 배치하고 레이어 4-7을 GPU1에 배치했습니다.",tn,Nt,ia="이제 데이터가 레이어 0에서 1로, 1에서 2로, 2에서 3으로 이동하는 동안에는 일반적인 모델입니다. 그러나 데이터가 레이어 3에서 레이어 4로 전달되어야 할 때는 GPU0에서 GPU1로 이동해야 하므로 통신 오버헤드가 발생합니다. 참여하는 GPU가 동일한 컴퓨팅 노드(예: 동일한 물리적인 기계)에 있는 경우 이 복사는 매우 빠릅니다. 그러나 GPU가 서로 다른 컴퓨팅 노드(예: 여러 기계)에 위치한 경우 통신 오버헤드는 상당히 크게 될 수 있습니다.",en,It,pa="그런 다음 레이어 4부터 5로, 6으로, 7로 진행되는 것은 일반적인 모델과 동일하게 진행되고, 7번째 레이어가 완료되면 데이터를 다시 레이어 0으로 보내거나 또는 레이블을 마지막 레이어로 보내야 할 필요가 있습니다. 이제 손실을 계산하고 옵티마이저가 작동할 수 있습니다.",ln,Et,aa="문제점:",sn,kt,fa="<li>이 방식을 “naive” MP라고 부르는 이유는 주어진 상황에 하나의 GPU를 제외한 모든 GPU가 유휴 상태라는 점입니다. 따라서 4개의 GPU를 사용하는 경우 단일 GPU의 메모리 양을 4배로 늘리고 나머지 하드웨어는 무시하는 것과 거의 동일합니다. 또한 장치 간 데이터 복사의 오버헤드도 있습니다. 따라서 4개의 6GB 카드는 naive MP를 사용하여 1개의 24GB 카드와 동일한 크기를 수용할 수 있지만, 후자는 데이터 복사의 오버헤드가 없으므로 훈련을 더 빨리 완료합니다. 그러나 예를 들어 40GB 카드가 있고 45GB 모델을 맞추어야 할 경우 4개의 40GB 카드로 맞출 수 있습니다 (하지만 그래디언트와 옵티마이저 상태 때문에 가까스로 가능합니다).</li> <li>공유 임베딩은 GPU 간에 복사해야 할 수도 있습니다.</li>",nn,Bt,ua="파이프라인 병렬화 (PP)은 거의 naive MP와 동일하지만 GPU 유휴 상태 문제를 해결하기 위해 들어오는 배치를 마이크로 배치로 나누고 인공적으로 파이프라인을 생성하여 서로 다른 GPU가 동시에 계산에 참여할 수 있게 합니다.",pn,Qt,ra='<a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe 논문</a>에서 가져온 그림은 상단에 naive MP를, 하단에는 PP를 보여줍니다:',an,Zt,Pa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="mp-pp"/>',fn,At,Ma="하단 다이어그램에서 PP가 유휴 영역이 적은 것을 쉽게 볼 수 있습니다. 유휴 부분을 “bubble”이라고 합니다.",un,Rt,xa="다이어그램의 양쪽 부분은 참여하는 GPU가 4개인 병렬성을 보여줍니다. 즉, 4개의 GPU가 파이프라인에 참여합니다. 따라서 4개의 파이프 단계 F0, F1, F2 및 F3의 순방향 경로와 B3, B2, B1 및 B0의 역방향 경로가 있습니다.",rn,Vt,Ta="PP는 조정해야 할 새로운 하이퍼파라미터인 <code>chunks</code>를 도입합니다. 이는 동일한 파이프 단계를 통해 일련의 데이터를 묶어서 보내는 방식을 정의합니다. 예를 들어, 아래 다이어그램에서 <code>chunks=4</code>를 볼 수 있습니다. GPU0은 0, 1, 2 및 3 (F0,0, F0,1, F0,2, F0,3) 묶음에서 동일한 순방향 경로를 수행하고, 다른 GPU가 작업을 수행하기 시작하고 완료가 시작될 때만 GPU0이 묶음의 역순으로 3, 2, 1 및 0 (B0,3, B0,2, B0,1, B0,0) 경로를 수행합니다.",Pn,Xt,va="개념적으로 이는 그래디언트 누적 단계 (GAS)와 동일한 개념입니다. 파이토치에서는 <code>chunks</code>를 사용하고 DeepSpeed에서는 동일한 하이퍼파라미터를 GAS로 참조합니다.",Mn,zt,ma="묶음으로 인해 PP는 마이크로 배치 (MBS)의 개념을 도입합니다. DP는 전역 데이터 배치 크기를 미니 배치로 나눕니다. 따라서 DP 차수가 4이고 전역 배치 크기가 1024이면 256씩 4개의 미니 배치로 분할됩니다 (1024/4). 그리고 <code>chunks</code> (또는 GAS)의 수가 32이면 마이크로 배치 크기는 8이 됩니다 (256/32). 각 파이프라인 단계는 한 번에 하나의 마이크로 배치와 함께 작동합니다.",xn,Ft,Ca="DP + PP 설정의 전역 배치 크기를 계산하려면 <code>mbs*chunks*dp_degree</code> (<code>8*32*4=1024</code>)를 수행합니다.",Tn,Ot,oa="다이어그램으로 돌아가 보겠습니다.",vn,Wt,ha="<code>chunks=1</code>로 설정하면 매우 비효율적인 naive MP가 생성되며, 매우 큰 <code>chunks</code> 값으로 설정하면 아주 작은 마이크로 배치 크기가 생성되어 효율적이지 않을 수 있습니다. 따라서 가장 효율적인 GPU 활용을 위해 어떤 값이 가장 적절한지 실험을 해야 합니다.",mn,Yt,ja="다이어그램에서 보이는 것처럼 “dead” 시간의 버블이 존재하여 마지막 <code>forward</code> 단계가 <code>backward</code> 단계가 파이프라인을 완료하기를 기다려야 하는 상황이 발생하지만, <code>chunks</code>의 가장 적절한 값을 찾는 것의 목적은 모든 참여하는 GPU에서 동시에 고도로 활용되는 GPU 활용을 가능하게 하여 버블의 크기를 최소화하는 것입니다.",Cn,qt,La="해결책은 전통적인 파이프라인 API와 더 현대적인 솔루션으로 나뉩니다. 전통적인 파이프라인 API 솔루션과 현대적인 솔루션에 대해 알아보겠습니다.",on,Kt,_a="전통적인 파이프라인 API 솔루션:",hn,te,wa="<li>파이토치</li> <li>FairScale</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",jn,ee,Ua="현대적인 솔루션:",Ln,le,da="<li>Varuna</li> <li>Sagemaker</li>",_n,se,ca="전통적인 파이프라인 API 솔루션의 문제점:",wn,ne,ba='<li>모델을 상당히 수정해야 한다는 점이 문제입니다. 파이프라인은 모듈의 정상적인 흐름을 <code>nn.Sequential</code> 시퀀스로 다시 작성해야 하므로 모델의 설계를 변경해야 할 수 있습니다.</li> <li>현재 파이프라인 API는 매우 제한적입니다. 파이프라인의 매우 첫 번째 단계에서 전달되는 많은 파이썬 변수가 있는 경우 이를 해결해야 합니다. 현재 파이프라인 인터페이스는 하나의 텐서 또는 텐서의 튜플을 유일한 입력 및 출력으로 요구합니다. 이러한 텐서는 마이크로 배치로 미니 배치로 묶을 것이므로 첫 번째 차원으로 배치 크기가 있어야 합니다. 가능한 개선 사항은 여기에서 논의되고 있습니다. <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>파이프 단계 수준에서 조건부 제어 흐름은 불가능합니다. 예를 들어, T5와 같은 인코더-디코더 모델은 조건부 인코더 단계를 처리하기 위해 특별한 해결책이 필요합니다.</li> <li>각 레이어를 정렬하여 하나의 모델의 출력이 다른 모델의 입력이 되도록해야 합니다.</li>',Un,ie,ya="우리는 아직 Varuna와 SageMaker로 실험하지 않았지만, 해당 논문들은 위에서 언급한 문제들의 목록을 극복했고 사용자의 모델에 대한 변경 사항이 훨씬 적게 필요하다고 보고하고 있습니다.",dn,pe,ga="구현:",cn,ae,Da='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">파이토치</a> (파이토치-1.8에서 초기 지원, 1.9에서 점진적으로 개선되고 1.10에서 더 개선됨). <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">예제</a>도 참고하세요.</li> <li><a href="https://fairscale.readthedocs.io/en/latest/tutorials/pipe.html" rel="nofollow">FairScale</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>은 내부 구현을 가지고 있습니다 - API 없음.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - 이는 AWS에서만 사용할 수 있는 소유 솔루션입니다.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - 이는 Hugging Face Transformers를 기반으로 구현된 파이프라인 병렬화입니다.</li>',bn,fe,Ja="🤗 Transformers 상태: 이 작성 시점에서 모델 중 어느 것도 완전한 PP를 지원하지 않습니다. GPT2와 T5 모델은 naive MP를 지원합니다. 주요 장애물은 모델을 <code>nn.Sequential</code>로 변환하고 모든 입력을 텐서로 가져와야 하는 것을 처리할 수 없기 때문입니다. 현재 모델에는 이러한 변환을 매우 복잡하게 만드는 많은 기능이 포함되어 있어 제거해야 합니다.",yn,ue,Ga="기타 접근 방법:",gn,re,Ha=`DeepSpeed, Varuna 및 SageMaker는 <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">교차 파이프라인(Interleaved Pipeline)</a> 개념을 사용합니다.
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="interleaved-pipeline-execution"/>`,Dn,Pe,$a="여기서는 버블(유휴 시간)을 역방향 패스에 우선순위를 부여하여 최소화합니다.",Jn,Me,Sa="Varuna는 가장 효율적인 스케줄링을 찾기 위해 시뮬레이션을 사용하여 스케줄을 개선하려고 합니다.",Gn,xe,Na="OSLO는 <code>nn.Sequential</code>로 변환하지 않고 Transformers를 기반으로 한 파이프라인 병렬화를 구현했습니다.",Hn,Te,$n,ve,Ia="텐서 병렬 처리에서는 각 GPU가 텐서의 일부분만 처리하고 전체 텐서가 필요한 연산에 대해서만 전체 텐서를 집계합니다.",Sn,me,Ea='이 섹션에서는 <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> 논문인 <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>에서의 개념과 다이어그램을 사용합니다.',Nn,Ce,ka="Transformer의 주요 구성 요소는 fully connected <code>nn.Linear</code>와 비선형 활성화 함수인 <code>GeLU</code>입니다.",In,oe,Ba="Megatron 논문의 표기법을 따라 행렬의 점곱 부분을 <code>Y = GeLU(XA)</code>로 표현할 수 있습니다. 여기서 <code>X</code>와 <code>Y</code>는 입력 및 출력 벡터이고 <code>A</code>는 가중치 행렬입니다.",En,he,Qa=`행렬 형태로 계산을 살펴보면, 행렬 곱셈을 다중 GPU로 분할할 수 있는 방법을 쉽게 알 수 있습니다:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>`,kn,je,Za=`가중치 행렬 <code>A</code>를 <code>N</code>개의 GPU에 대해 열별로 분할하고 병렬로 행렬 곱셈 <code>XA_1</code>에서 <code>XA_n</code>까지 수행하면 <code>N</code>개의 출력 벡터 <code>Y_1, Y_2, ..., Y_n</code>가 생성되며 독립적으로 <code>GeLU</code>에 전달될 수 있습니다:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="independent GeLU"/>`,Bn,Le,Aa=`이 원리를 사용하여 동기화가 필요하지 않은 GPU 간의 임의 깊이의 MLP를 업데이트할 수 있습니다. 그러나 결과 벡터를 샤드로부터 재구성해야 하는 마지막 단계까지는 GPU 간의 동기화가 필요합니다. Megatron-LM 논문의 저자들은 이에 대한 유용한 그림을 제공합니다:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="parallel shard processing"/>`,Qn,_e,Ra=`다중 헤드 어텐션 레이어의 병렬화는 더욱 간단합니다. 이미 독립적인 다중 헤드를 가지고 있기 때문에 이미 병렬화되어 있습니다!
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="parallel self-attention"/>`,Zn,we,Va="특별 고려사항: TP는 매우 빠른 네트워크가 필요하므로 한 개 이상의 노드에서 TP를 수행하는 것은 권장되지 않습니다. 실제로 노드에 4개의 GPU가 있는 경우 TP의 최대 차수는 4입니다. TP 차수가 8인 경우 최소한 8개의 GPU가 있는 노드를 사용해야 합니다.",An,Ue,Xa=`이 섹션은 원래의 <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">더 자세한 TP 개요</a>를 기반으로 합니다.
작성자는 <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>입니다.`,Rn,de,za="SageMaker는 더 효율적인 처리를 위해 TP와 DP를 결합합니다.",Vn,ce,Fa="대체 이름:",Xn,be,Oa='<li>DeepSpeed는 이를 <a href="https://www.deepspeed.ai/features/#model-parallelism" rel="nofollow">텐서 슬라이싱</a>이라고 부릅니다.</li>',zn,ye,Wa="구현:",Fn,ge,Ya='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>은 내부 구현을 가지고 있으므로 모델에 매우 특화되어 있습니다.</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (현재는 추론에만 해당)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - 이는 AWS에서만 사용할 수 있는 소유 솔루션입니다.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a>은 Transformers를 기반으로 한 텐서 병렬 처리 구현을 가지고 있습니다.</li>',On,De,qa="🤗 Transformers 현황:",Wn,Je,Ka='<li>core: 아직 핵심 부분에 구현되지 않음</li> <li>그러나 추론을 하려면 <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a>가 대부분의 모델을 지원합니다. 따라서 핵심 부분에 구현되기 전까지 그들의 것을 사용할 수 있습니다. 그리고 훈련 모드도 지원될 예정입니다.</li> <li>Deepspeed-Inference는 CUDA 커널을 기반으로 하는 매우 빠른 추론 모드에서 BERT, GPT-2 및 GPT-Neo 모델을 지원합니다. 자세한 내용은 <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">여기</a>를 참조하세요.</li>',Yn,Ge,qn,He,t1='DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a>에서 다음 다이어그램은 DP와 PP를 결합하는 방법을 보여줍니다.',Kn,$e,e1='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="dp-pp-2d"/>',ti,Se,l1="여기서 DP 랭크 0은 GPU2를 보지 못하고, DP 랭크 1은 GPU3을 보지 못하는 것이 중요합니다. DP에게는 딱 2개의 GPU인 것처럼 데이터를 공급합니다. GPU0은 PP를 사용하여 GPU2에게 일부 작업을 “비밀리에” 할당합니다. 그리고 GPU1도 GPU3을 도움으로 삼아 같은 방식으로 작업합니다.",ei,Ne,s1="각 차원마다 적어도 2개의 GPU가 필요하므로 최소한 4개의 GPU가 필요합니다.",li,Ie,n1="구현:",si,Ee,i1='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',ni,ke,p1="🤗 Transformers 현황: 아직 구현되지 않음",ii,Be,pi,Qe,a1="더 효율적인 훈련을 위해 PP와 TP 및 DP를 결합하여 3D 병렬 처리를 사용합니다. 다음 다이어그램에서 이를 확인할 수 있습니다.",ai,Ze,f1='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',fi,Ae,u1='이 다이어그램은 <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>이라는 블로그 글에서 확인할 수 있습니다.',ui,Re,r1="각 차원마다 적어도 2개의 GPU가 필요하므로 최소한 8개의 GPU가 필요합니다.",ri,Ve,P1="구현:",Pi,Xe,M1='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed는 더욱 효율적인 DP인 ZeRO-DP라고도 부릅니다.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Mi,ze,x1="🤗 Transformers 현황: 아직 구현되지 않음. PP와 TP가 없기 때문입니다.",xi,Fe,Ti,Oe,T1='DeepSpeed의 주요 기능 중 하나는 DP의 확장인 ZeRO입니다. ZeRO-DP에 대해 이미 <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>에서 논의되었습니다. 일반적으로 이는 PP나 TP를 필요로하지 않는 독립적인 기능입니다. 그러나 PP와 TP와 결합할 수도 있습니다.',vi,We,v1="ZeRO-DP가 PP와 (선택적으로 TP와) 결합되면 일반적으로 ZeRO 단계 1(옵티마이저 분할)만 활성화됩니다.",mi,Ye,m1="이론적으로는 ZeRO 단계 2(그라디언트 분할)를 파이프라인 병렬 처리와 함께 사용할 수도 있지만, 이는 성능에 나쁜 영향을 미칠 것입니다. 각 마이크로 배치마다 그라디언트를 샤딩하기 전에 추가적인 리듀스-스캐터 컬렉티브가 필요하며, 이는 잠재적으로 상당한 통신 오버헤드를 추가합니다. 파이프라인 병렬 처리의 특성상 작은 마이크로 배치가 사용되며, 산술 연산 강도(마이크로 배치 크기)를 균형 있게 유지하면서 파이프라인 버블(마이크로 배치 수)을 최소화하는 것에 중점을 둡니다. 따라서 해당 통신 비용은 문제가 될 것입니다.",Ci,qe,C1="또한, PP로 인해 정상보다 적은 수의 레이어가 있으므로 메모리 절약은 크지 않을 것입니다. PP는 이미 그래디언트 크기를 <code>1/PP</code>로 줄이기 때문에 그래디언트 샤딩의 절약 효과는 순수 DP보다는 미미합니다.",oi,Ke,o1="ZeRO 단계 3도 같은 이유로 좋은 선택이 아닙니다 - 더 많은 노드 간 통신이 필요합니다.",hi,tl,h1="그리고 ZeRO가 있기 때문에 다른 이점은 ZeRO-Offload입니다. 이는 단계 1이므로 옵티마이저 상태를 CPU로 오프로드할 수 있습니다.",ji,el,j1="구현:",Li,ll,L1='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> 및 <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">BigScience의 Megatron-Deepspeed</a>, 이전 저장소의 포크입니다.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',_i,sl,_1="중요한 논문:",wi,nl,w1='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',Ui,il,U1="🤗 Transformers 현황: 아직 구현되지 않음, PP와 TP가 없기 때문입니다.",di,pl,ci,al,d1='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a>는 약간 다른 방식으로 병렬화 문제를 해결합니다.',bi,fl,c1='논문: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',yi,ul,b1="이는 Sample-Operator-Attribute-Parameter를 기반으로 하는 일종의 4D 병렬화를 수행합니다.",gi,rl,y1="<li>Sample = 데이터 병렬화 (샘플별 병렬)</li> <li>Operator = 단일 연산을 여러 하위 연산으로 병렬화</li> <li>Attribute = 데이터 병렬화 (길이별 병렬)</li> <li>Parameter = 모델 병렬화 (수평 또는 수직과 관계없이)</li>",Di,Pl,g1="예시:",Ji,Ml,D1="<li>Sample</li>",Gi,xl,J1="512 길이의 10개의 배치를 가정해 봅시다. 이를 sample 차원으로 2개의 장치에 병렬화하면, 10 x 512는 5 x 2 x 512가 됩니다.",Hi,Tl,G1="<li>Operator</li>",$i,vl,H1="레이어 정규화를 수행한다면, 우선 std를 계산하고 두 번째로 mean을 계산한 다음 데이터를 정규화할 수 있습니다. Operator 병렬화는 std와 mean을 병렬로 계산할 수 있도록 합니다. 따라서 operator 차원으로 2개의 장치 (cuda:0, cuda:1)에 병렬화하면, 먼저 입력 데이터를 두 장치로 복사한 다음 cuda:0에서 std를 계산하고 cuda:1에서 동시에 mean을 계산합니다.",Si,ml,$1="<li>Attribute</li>",Ni,Cl,S1="512 길이의 10개의 배치가 있습니다. 이를 attribute 차원으로 2개의 장치에 병렬화하면, 10 x 512는 10 x 2 x 256이 됩니다.",Ii,ol,N1="<li>Parameter</li>",Ei,hl,I1="이는 tensor 모델 병렬화 또는 naive layer-wise 모델 병렬화와 유사합니다.",ki,jl,E1='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',Bi,Ll,k1="이 프레임워크의 중요한 점은 (1) GPU/TPU/CPU 대 (2) RAM/DRAM 대 (3) 빠른 인트라-커넥트 대 느린 인터-커넥트와 같은 리소스를 고려하여 어디에서 어떤 병렬화를 사용할지를 알고리즘적으로 자동으로 최적화한다는 것입니다.",Qi,_l,B1="하나 매우 중요한 측면은 FlexFlow가 정적이고 고정된 워크로드를 가진 모델에 대한 DNN 병렬화를 최적화하기 위해 설계되었다는 것입니다. 동적인 동작을 가진 모델은 반복마다 다른 병렬화 전략을 선호할 수 있습니다.",Zi,wl,Q1="따라서 이 프레임워크의 장점은 선택한 클러스터에서 30분 동안 시뮬레이션을 실행하고 이 특정 환경을 최적으로 활용하기 위한 최상의 전략을 제안한다는 것입니다. 부품을 추가/제거/교체하면 실행하고 그에 대한 계획을 다시 최적화한 후 훈련할 수 있습니다. 다른 설정은 자체적인 사용자 정의 최적화를 가질 수 있습니다.",Ai,Ul,Z1='🤗 Transformers 현황: 아직 통합되지 않음. 이미 <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>를 통해 모델을 FX-추적할 수 있으며, 이는 FlexFlow의 선행 조건입니다. 따라서 어떤 작업을 수행해야 FlexFlow가 우리의 모델과 함께 작동할 수 있는지 파악해야 합니다.',Ri,dl,Vi,cl,A1="다음은 어떤 병렬화 전략을 언제 사용해야 하는지에 대한 매우 대략적인 개요입니다. 각 목록의 첫 번째 전략이 일반적으로 더 빠릅니다.",Xi,bl,R1="<strong>⇨ 단일 GPU</strong>",zi,yl,V1="<li><p>모델이 단일 GPU에 맞는 경우:</p> <ol><li>일반적인 사용</li></ol></li> <li><p>모델이 단일 GPU에 맞지 않는 경우:</p> <ol><li>ZeRO + CPU 및 옵션으로 NVMe 언로드</li> <li>위와 동일하게 사용하되, 가장 큰 레이어가 단일 GPU에 맞지 않는 경우 Memory Centric Tiling(자세한 내용은 아래 참조)을 추가적으로 사용</li></ol></li> <li><p>가장 큰 레이어가 단일 GPU에 맞지 않는 경우:</p></li>",Fi,gl,X1='<li>ZeRO - <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#memory-centric-tiling" rel="nofollow">Memory Centric Tiling</a> (MCT) 활성화. 이를 통해 크기가 매우 큰 레이어를 임의로 분할하여 순차적으로 실행할 수 있습니다. MCT는 GPU에 활성화된 매개변수의 수를 줄이지만 활성화 메모리에는 영향을 주지 않습니다. 현재 작성 기준으로 이 요구사항은 매우 드물기 때문에 사용자가 <code>torch.nn.Linear</code>를 수동으로 수정해야 합니다.</li>',Oi,Dl,z1="<strong>⇨ 단일 노드 / 다중 GPU</strong>",Wi,Jl,F1="<li><p>모델이 단일 GPU에 맞는 경우:</p> <ol><li>DDP - 분산 DP</li> <li>ZeRO - 상황과 구성에 따라 빠를 수도 있고 그렇지 않을 수도 있습니다.</li></ol></li> <li><p>모델이 단일 GPU에 맞지 않는 경우:</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>NVLINK 또는 NVSwitch를 통한 매우 빠른 인트라-노드 연결이 있는 경우 이 세 가지 방법은 거의 동등할 것이며, 이러한 연결이 없는 경우 PP가 TP나 ZeRO보다 빠를 것입니다. 또한 TP의 차수도 영향을 줄 수 있습니다. 특정 설정에서 우승자를 찾기 위해 실험하는 것이 가장 좋습니다.</p> <p>TP는 거의 항상 단일 노드 내에서 사용됩니다. 즉, TP 크기 &lt;= 노드당 GPU 수입니다.</p></li></ol></li> <li><p>가장 큰 레이어가 단일 GPU에 맞지 않는 경우:</p> <ol><li>ZeRO를 사용하지 않을 경우 - PP만 사용할 수 없으므로 TP를 사용해야 합니다.</li> <li>ZeRO를 사용할 경우, “단일 GPU”의 항목과 동일한 항목 참조</li></ol></li>",Yi,Gl,O1="<strong>⇨ 다중 노드 / 다중 GPU</strong>",qi,Hl,W1="<li><p>빠른 노드 간 연결이 있는 경우:</p> <ol><li>ZeRO - 모델에 대한 수정이 거의 필요하지 않습니다.</li> <li>PP+TP+DP - 통신이 적지만 모델에 대한 대규모 변경이 필요합니다.</li></ol></li> <li><p>느린 노드 간 연결 및 GPU 메모리 부족한 경우:</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Ki,Sl,tp;return j=new m({props:{title:"다중 GPU에서 효율적인 훈련",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),o=new uf({props:{$$slots:{default:[rf]},$$scope:{ctx:Il}}}),w=new m({props:{title:"개념",local:"concepts",headingTag:"h2"}}),b=new m({props:{title:"확장성 전략",local:"scalability-strategy",headingTag:"h2"}}),G=new m({props:{title:"데이터 병렬화",local:"data-parallelism",headingTag:"h2"}}),$=new m({props:{title:"DP vs DDP",local:"dp-vs-ddp",headingTag:"h3"}}),lt=new Nl({props:{code:"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",highlighted:`
<span class="hljs-comment"># DP</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">110</span>.<span class="hljs-string">5948</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">808</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/ NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">101</span>.<span class="hljs-string">9003</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">963</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/o NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">NCCL_P2P_DISABLE</span>=<span class="hljs-string">1</span> <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">131</span>.<span class="hljs-string">4367</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">522</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),nt=new m({props:{title:"ZeRO 데이터 병렬화",local:"zero-data-parallelism",headingTag:"h2"}}),ft=new Nl({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Pt=new Nl({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Tt=new Nl({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),Jt=new m({props:{title:"네이티브 모델 병렬 처리(수직적) 및 파이프라인 병렬 처리",local:"naive-model-parallelism-vertical-and-pipeline-parallelism",headingTag:"h2"}}),$t=new Nl({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwJTIwMCUyMCU3QyUyMDElMjAlN0MlMjAyJTIwJTdDJTIwMyUyMCUyMCU3QyUyMCUyMCU3QyUyMCUyMDQlMjAlN0MlMjA1JTIwJTdDJTIwNiUyMCU3QyUyMDclMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjAlMjAlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncHUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3B1MQ==",highlighted:`===================  ===================
|<span class="hljs-string">  0 </span>|<span class="hljs-string"> 1 </span>|<span class="hljs-string"> 2 </span>|<span class="hljs-string"> 3  </span>|<span class="hljs-string">  </span>|<span class="hljs-string">  4 </span>|<span class="hljs-string"> 5 </span>|<span class="hljs-string"> 6 </span>|<span class="hljs-string"> 7  </span>|
===================  ===================
        gpu0                 gpu1`,wrap:!1}}),Te=new m({props:{title:"텐서 병렬 처리",local:"tensor-parallelism",headingTag:"h2"}}),Ge=new m({props:{title:"DP+PP",local:"dppp",headingTag:"h2"}}),Be=new m({props:{title:"DP+PP+TP",local:"dppptp",headingTag:"h2"}}),Fe=new m({props:{title:"ZeRO DP+PP+TP",local:"zero-dppptp",headingTag:"h2"}}),pl=new m({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),dl=new m({props:{title:"어떤 전략을 사용해야 할까요?",local:"which-strategy-to-use-when",headingTag:"h2"}}),{c(){v=p("meta"),h=n(),C=p("p"),$l=n(),u(j.$$.fragment),El=n(),L=p("p"),L.textContent=ep,kl=n(),u(o.$$.fragment),Bl=n(),_=p("p"),_.textContent=lp,Ql=n(),u(w.$$.fragment),Zl=n(),U=p("p"),U.textContent=sp,Al=n(),d=p("ol"),d.innerHTML=np,Rl=n(),c=p("p"),c.textContent=ip,Vl=n(),u(b.$$.fragment),Xl=n(),y=p("p"),y.innerHTML=pp,zl=n(),g=p("ul"),g.innerHTML=ap,Fl=n(),D=p("p"),D.innerHTML=fp,Ol=n(),J=p("ul"),J.innerHTML=up,Wl=n(),u(G.$$.fragment),Yl=n(),H=p("p"),H.innerHTML=rp,ql=n(),u($.$$.fragment),Kl=n(),S=p("p"),S.innerHTML=Pp,ts=n(),N=p("ul"),N.innerHTML=Mp,es=n(),I=p("p"),I.textContent=xp,ls=n(),E=p("p"),E.innerHTML=Tp,ss=n(),k=p("ul"),k.innerHTML=vp,ns=n(),B=p("p"),B.innerHTML=mp,is=n(),Q=p("p"),Q.textContent=Cp,ps=n(),Z=p("ol"),Z.innerHTML=op,as=n(),A=p("p"),A.textContent=hp,fs=n(),R=p("p"),R.innerHTML=jp,us=n(),V=p("p"),V.textContent=Lp,rs=n(),X=p("p"),X.textContent=_p,Ps=n(),z=p("p"),z.textContent=wp,Ms=n(),F=p("p"),F.innerHTML=Up,xs=n(),O=p("p"),O.textContent=dp,Ts=n(),W=p("table"),W.innerHTML=cp,vs=n(),Y=p("p"),Y.textContent=bp,ms=n(),q=p("p"),q.textContent=yp,Cs=n(),K=p("p"),K.textContent=gp,os=n(),tt=p("p"),tt.textContent=Dp,hs=n(),et=p("p"),et.innerHTML=Jp,js=n(),u(lt.$$.fragment),Ls=n(),st=p("p"),st.innerHTML=Gp,_s=n(),u(nt.$$.fragment),ws=n(),it=p("p"),it.innerHTML=Hp,Us=n(),pt=p("p"),pt.innerHTML=$p,ds=n(),at=p("p"),at.textContent=Sp,cs=n(),u(ft.$$.fragment),bs=n(),ut=p("p"),ut.textContent=Np,ys=n(),rt=p("p"),rt.textContent=Ip,gs=n(),u(Pt.$$.fragment),Ds=n(),Mt=p("p"),Mt.textContent=Ep,Js=n(),xt=p("p"),xt.textContent=kp,Gs=n(),u(Tt.$$.fragment),Hs=n(),vt=p("p"),vt.textContent=Bp,$s=n(),mt=p("p"),mt.textContent=Qp,Ss=n(),Ct=p("p"),Ct.textContent=Zp,Ns=n(),ot=p("p"),ot.textContent=Ap,Is=n(),ht=p("p"),ht.textContent=Rp,Es=n(),jt=p("p"),jt.textContent=Vp,ks=n(),Lt=p("p"),Lt.textContent=Xp,Bs=n(),_t=p("p"),_t.textContent=zp,Qs=n(),wt=p("p"),wt.textContent=Fp,Zs=n(),Ut=p("ol"),Ut.innerHTML=Op,As=n(),dt=p("p"),dt.textContent=Wp,Rs=n(),ct=p("p"),ct.textContent=Yp,Vs=n(),bt=p("p"),bt.textContent=qp,Xs=n(),yt=p("p"),yt.textContent=Kp,zs=n(),gt=p("p"),gt.textContent=ta,Fs=n(),Dt=p("ul"),Dt.innerHTML=ea,Os=n(),u(Jt.$$.fragment),Ws=n(),Gt=p("p"),Gt.innerHTML=la,Ys=n(),Ht=p("p"),Ht.textContent=sa,qs=n(),u($t.$$.fragment),Ks=n(),St=p("p"),St.textContent=na,tn=n(),Nt=p("p"),Nt.textContent=ia,en=n(),It=p("p"),It.textContent=pa,ln=n(),Et=p("p"),Et.textContent=aa,sn=n(),kt=p("ul"),kt.innerHTML=fa,nn=n(),Bt=p("p"),Bt.textContent=ua,pn=n(),Qt=p("p"),Qt.innerHTML=ra,an=n(),Zt=p("p"),Zt.innerHTML=Pa,fn=n(),At=p("p"),At.textContent=Ma,un=n(),Rt=p("p"),Rt.textContent=xa,rn=n(),Vt=p("p"),Vt.innerHTML=Ta,Pn=n(),Xt=p("p"),Xt.innerHTML=va,Mn=n(),zt=p("p"),zt.innerHTML=ma,xn=n(),Ft=p("p"),Ft.innerHTML=Ca,Tn=n(),Ot=p("p"),Ot.textContent=oa,vn=n(),Wt=p("p"),Wt.innerHTML=ha,mn=n(),Yt=p("p"),Yt.innerHTML=ja,Cn=n(),qt=p("p"),qt.textContent=La,on=n(),Kt=p("p"),Kt.textContent=_a,hn=n(),te=p("ul"),te.innerHTML=wa,jn=n(),ee=p("p"),ee.textContent=Ua,Ln=n(),le=p("ul"),le.innerHTML=da,_n=n(),se=p("p"),se.textContent=ca,wn=n(),ne=p("ul"),ne.innerHTML=ba,Un=n(),ie=p("p"),ie.textContent=ya,dn=n(),pe=p("p"),pe.textContent=ga,cn=n(),ae=p("ul"),ae.innerHTML=Da,bn=n(),fe=p("p"),fe.innerHTML=Ja,yn=n(),ue=p("p"),ue.textContent=Ga,gn=n(),re=p("p"),re.innerHTML=Ha,Dn=n(),Pe=p("p"),Pe.textContent=$a,Jn=n(),Me=p("p"),Me.textContent=Sa,Gn=n(),xe=p("p"),xe.innerHTML=Na,Hn=n(),u(Te.$$.fragment),$n=n(),ve=p("p"),ve.textContent=Ia,Sn=n(),me=p("p"),me.innerHTML=Ea,Nn=n(),Ce=p("p"),Ce.innerHTML=ka,In=n(),oe=p("p"),oe.innerHTML=Ba,En=n(),he=p("p"),he.innerHTML=Qa,kn=n(),je=p("p"),je.innerHTML=Za,Bn=n(),Le=p("p"),Le.innerHTML=Aa,Qn=n(),_e=p("p"),_e.innerHTML=Ra,Zn=n(),we=p("p"),we.textContent=Va,An=n(),Ue=p("p"),Ue.innerHTML=Xa,Rn=n(),de=p("p"),de.textContent=za,Vn=n(),ce=p("p"),ce.textContent=Fa,Xn=n(),be=p("ul"),be.innerHTML=Oa,zn=n(),ye=p("p"),ye.textContent=Wa,Fn=n(),ge=p("ul"),ge.innerHTML=Ya,On=n(),De=p("p"),De.textContent=qa,Wn=n(),Je=p("ul"),Je.innerHTML=Ka,Yn=n(),u(Ge.$$.fragment),qn=n(),He=p("p"),He.innerHTML=t1,Kn=n(),$e=p("p"),$e.innerHTML=e1,ti=n(),Se=p("p"),Se.textContent=l1,ei=n(),Ne=p("p"),Ne.textContent=s1,li=n(),Ie=p("p"),Ie.textContent=n1,si=n(),Ee=p("ul"),Ee.innerHTML=i1,ni=n(),ke=p("p"),ke.textContent=p1,ii=n(),u(Be.$$.fragment),pi=n(),Qe=p("p"),Qe.textContent=a1,ai=n(),Ze=p("p"),Ze.innerHTML=f1,fi=n(),Ae=p("p"),Ae.innerHTML=u1,ui=n(),Re=p("p"),Re.textContent=r1,ri=n(),Ve=p("p"),Ve.textContent=P1,Pi=n(),Xe=p("ul"),Xe.innerHTML=M1,Mi=n(),ze=p("p"),ze.textContent=x1,xi=n(),u(Fe.$$.fragment),Ti=n(),Oe=p("p"),Oe.innerHTML=T1,vi=n(),We=p("p"),We.textContent=v1,mi=n(),Ye=p("p"),Ye.textContent=m1,Ci=n(),qe=p("p"),qe.innerHTML=C1,oi=n(),Ke=p("p"),Ke.textContent=o1,hi=n(),tl=p("p"),tl.textContent=h1,ji=n(),el=p("p"),el.textContent=j1,Li=n(),ll=p("ul"),ll.innerHTML=L1,_i=n(),sl=p("p"),sl.textContent=_1,wi=n(),nl=p("ul"),nl.innerHTML=w1,Ui=n(),il=p("p"),il.textContent=U1,di=n(),u(pl.$$.fragment),ci=n(),al=p("p"),al.innerHTML=d1,bi=n(),fl=p("p"),fl.innerHTML=c1,yi=n(),ul=p("p"),ul.textContent=b1,gi=n(),rl=p("ol"),rl.innerHTML=y1,Di=n(),Pl=p("p"),Pl.textContent=g1,Ji=n(),Ml=p("ul"),Ml.innerHTML=D1,Gi=n(),xl=p("p"),xl.textContent=J1,Hi=n(),Tl=p("ul"),Tl.innerHTML=G1,$i=n(),vl=p("p"),vl.textContent=H1,Si=n(),ml=p("ul"),ml.innerHTML=$1,Ni=n(),Cl=p("p"),Cl.textContent=S1,Ii=n(),ol=p("ul"),ol.innerHTML=N1,Ei=n(),hl=p("p"),hl.textContent=I1,ki=n(),jl=p("p"),jl.innerHTML=E1,Bi=n(),Ll=p("p"),Ll.textContent=k1,Qi=n(),_l=p("p"),_l.textContent=B1,Zi=n(),wl=p("p"),wl.textContent=Q1,Ai=n(),Ul=p("p"),Ul.innerHTML=Z1,Ri=n(),u(dl.$$.fragment),Vi=n(),cl=p("p"),cl.textContent=A1,Xi=n(),bl=p("p"),bl.innerHTML=R1,zi=n(),yl=p("ul"),yl.innerHTML=V1,Fi=n(),gl=p("ol"),gl.innerHTML=X1,Oi=n(),Dl=p("p"),Dl.innerHTML=z1,Wi=n(),Jl=p("ul"),Jl.innerHTML=F1,Yi=n(),Gl=p("p"),Gl.innerHTML=O1,qi=n(),Hl=p("ul"),Hl.innerHTML=W1,Ki=n(),Sl=p("p"),this.h()},l(t){const e=pf("svelte-u9bgzb",document.head);v=a(e,"META",{name:!0,content:!0}),e.forEach(l),h=i(t),C=a(t,"P",{}),q1(C).forEach(l),$l=i(t),r(j.$$.fragment,t),El=i(t),L=a(t,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1jao6ea"&&(L.textContent=ep),kl=i(t),r(o.$$.fragment,t),Bl=i(t),_=a(t,"P",{"data-svelte-h":!0}),f(_)!=="svelte-1qmdx9z"&&(_.textContent=lp),Ql=i(t),r(w.$$.fragment,t),Zl=i(t),U=a(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-h8h6z3"&&(U.textContent=sp),Al=i(t),d=a(t,"OL",{"data-svelte-h":!0}),f(d)!=="svelte-1yy1ddc"&&(d.innerHTML=np),Rl=i(t),c=a(t,"P",{"data-svelte-h":!0}),f(c)!=="svelte-15s4bad"&&(c.textContent=ip),Vl=i(t),r(b.$$.fragment,t),Xl=i(t),y=a(t,"P",{"data-svelte-h":!0}),f(y)!=="svelte-umdnes"&&(y.innerHTML=pp),zl=i(t),g=a(t,"UL",{"data-svelte-h":!0}),f(g)!=="svelte-xako5z"&&(g.innerHTML=ap),Fl=i(t),D=a(t,"P",{"data-svelte-h":!0}),f(D)!=="svelte-1yw7q1s"&&(D.innerHTML=fp),Ol=i(t),J=a(t,"UL",{"data-svelte-h":!0}),f(J)!=="svelte-okuy22"&&(J.innerHTML=up),Wl=i(t),r(G.$$.fragment,t),Yl=i(t),H=a(t,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1vhoj0v"&&(H.innerHTML=rp),ql=i(t),r($.$$.fragment,t),Kl=i(t),S=a(t,"P",{"data-svelte-h":!0}),f(S)!=="svelte-1dj13ea"&&(S.innerHTML=Pp),ts=i(t),N=a(t,"UL",{"data-svelte-h":!0}),f(N)!=="svelte-ewdvjo"&&(N.innerHTML=Mp),es=i(t),I=a(t,"P",{"data-svelte-h":!0}),f(I)!=="svelte-q9zxx1"&&(I.textContent=xp),ls=i(t),E=a(t,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1v8b0bi"&&(E.innerHTML=Tp),ss=i(t),k=a(t,"UL",{"data-svelte-h":!0}),f(k)!=="svelte-g6b06p"&&(k.innerHTML=vp),ns=i(t),B=a(t,"P",{"data-svelte-h":!0}),f(B)!=="svelte-2za96j"&&(B.innerHTML=mp),is=i(t),Q=a(t,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1gcvs39"&&(Q.textContent=Cp),ps=i(t),Z=a(t,"OL",{"data-svelte-h":!0}),f(Z)!=="svelte-hcppm9"&&(Z.innerHTML=op),as=i(t),A=a(t,"P",{"data-svelte-h":!0}),f(A)!=="svelte-bhmw1w"&&(A.textContent=hp),fs=i(t),R=a(t,"P",{"data-svelte-h":!0}),f(R)!=="svelte-3u7ax"&&(R.innerHTML=jp),us=i(t),V=a(t,"P",{"data-svelte-h":!0}),f(V)!=="svelte-175wjjf"&&(V.textContent=Lp),rs=i(t),X=a(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1aijcya"&&(X.textContent=_p),Ps=i(t),z=a(t,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1ndo2n3"&&(z.textContent=wp),Ms=i(t),F=a(t,"P",{"data-svelte-h":!0}),f(F)!=="svelte-wa4k93"&&(F.innerHTML=Up),xs=i(t),O=a(t,"P",{"data-svelte-h":!0}),f(O)!=="svelte-e0bdj"&&(O.textContent=dp),Ts=i(t),W=a(t,"TABLE",{"data-svelte-h":!0}),f(W)!=="svelte-1glyygb"&&(W.innerHTML=cp),vs=i(t),Y=a(t,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-gns8bz"&&(Y.textContent=bp),ms=i(t),q=a(t,"P",{"data-svelte-h":!0}),f(q)!=="svelte-1cj1yfz"&&(q.textContent=yp),Cs=i(t),K=a(t,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1lky485"&&(K.textContent=gp),os=i(t),tt=a(t,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-xtimww"&&(tt.textContent=Dp),hs=i(t),et=a(t,"P",{"data-svelte-h":!0}),f(et)!=="svelte-eob9hs"&&(et.innerHTML=Jp),js=i(t),r(lt.$$.fragment,t),Ls=i(t),st=a(t,"P",{"data-svelte-h":!0}),f(st)!=="svelte-l47fa1"&&(st.innerHTML=Gp),_s=i(t),r(nt.$$.fragment,t),ws=i(t),it=a(t,"P",{"data-svelte-h":!0}),f(it)!=="svelte-k134pb"&&(it.innerHTML=Hp),Us=i(t),pt=a(t,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-1exoa85"&&(pt.innerHTML=$p),ds=i(t),at=a(t,"P",{"data-svelte-h":!0}),f(at)!=="svelte-ph00p1"&&(at.textContent=Sp),cs=i(t),r(ft.$$.fragment,t),bs=i(t),ut=a(t,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-l4da5u"&&(ut.textContent=Np),ys=i(t),rt=a(t,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-r5pl0x"&&(rt.textContent=Ip),gs=i(t),r(Pt.$$.fragment,t),Ds=i(t),Mt=a(t,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-1r1s32p"&&(Mt.textContent=Ep),Js=i(t),xt=a(t,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-1oxwq9o"&&(xt.textContent=kp),Gs=i(t),r(Tt.$$.fragment,t),Hs=i(t),vt=a(t,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-1lz2rm6"&&(vt.textContent=Bp),$s=i(t),mt=a(t,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-1xv2bz6"&&(mt.textContent=Qp),Ss=i(t),Ct=a(t,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-jhvjul"&&(Ct.textContent=Zp),Ns=i(t),ot=a(t,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-1lb4yw3"&&(ot.textContent=Ap),Is=i(t),ht=a(t,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-1s7ovny"&&(ht.textContent=Rp),Es=i(t),jt=a(t,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-63neh8"&&(jt.textContent=Vp),ks=i(t),Lt=a(t,"P",{"data-svelte-h":!0}),f(Lt)!=="svelte-1ya4uwf"&&(Lt.textContent=Xp),Bs=i(t),_t=a(t,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-cpklo7"&&(_t.textContent=zp),Qs=i(t),wt=a(t,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-xtjkh8"&&(wt.textContent=Fp),Zs=i(t),Ut=a(t,"OL",{"data-svelte-h":!0}),f(Ut)!=="svelte-18mu60i"&&(Ut.innerHTML=Op),As=i(t),dt=a(t,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-pdwhw"&&(dt.textContent=Wp),Rs=i(t),ct=a(t,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-1vn7sa3"&&(ct.textContent=Yp),Vs=i(t),bt=a(t,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-noqzqn"&&(bt.textContent=qp),Xs=i(t),yt=a(t,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-1pn9jzz"&&(yt.textContent=Kp),zs=i(t),gt=a(t,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-1ck5yhy"&&(gt.textContent=ta),Fs=i(t),Dt=a(t,"UL",{"data-svelte-h":!0}),f(Dt)!=="svelte-zko1xu"&&(Dt.innerHTML=ea),Os=i(t),r(Jt.$$.fragment,t),Ws=i(t),Gt=a(t,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-idnjm0"&&(Gt.innerHTML=la),Ys=i(t),Ht=a(t,"P",{"data-svelte-h":!0}),f(Ht)!=="svelte-1kgf5q0"&&(Ht.textContent=sa),qs=i(t),r($t.$$.fragment,t),Ks=i(t),St=a(t,"P",{"data-svelte-h":!0}),f(St)!=="svelte-16ap7o9"&&(St.textContent=na),tn=i(t),Nt=a(t,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-3pp5lk"&&(Nt.textContent=ia),en=i(t),It=a(t,"P",{"data-svelte-h":!0}),f(It)!=="svelte-3i4pxk"&&(It.textContent=pa),ln=i(t),Et=a(t,"P",{"data-svelte-h":!0}),f(Et)!=="svelte-1y09acq"&&(Et.textContent=aa),sn=i(t),kt=a(t,"UL",{"data-svelte-h":!0}),f(kt)!=="svelte-4n7c7t"&&(kt.innerHTML=fa),nn=i(t),Bt=a(t,"P",{"data-svelte-h":!0}),f(Bt)!=="svelte-1sve00y"&&(Bt.textContent=ua),pn=i(t),Qt=a(t,"P",{"data-svelte-h":!0}),f(Qt)!=="svelte-sn0idp"&&(Qt.innerHTML=ra),an=i(t),Zt=a(t,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-1q7hzge"&&(Zt.innerHTML=Pa),fn=i(t),At=a(t,"P",{"data-svelte-h":!0}),f(At)!=="svelte-znemda"&&(At.textContent=Ma),un=i(t),Rt=a(t,"P",{"data-svelte-h":!0}),f(Rt)!=="svelte-3rgbsr"&&(Rt.textContent=xa),rn=i(t),Vt=a(t,"P",{"data-svelte-h":!0}),f(Vt)!=="svelte-b90yd3"&&(Vt.innerHTML=Ta),Pn=i(t),Xt=a(t,"P",{"data-svelte-h":!0}),f(Xt)!=="svelte-1v94gfc"&&(Xt.innerHTML=va),Mn=i(t),zt=a(t,"P",{"data-svelte-h":!0}),f(zt)!=="svelte-1qg4a22"&&(zt.innerHTML=ma),xn=i(t),Ft=a(t,"P",{"data-svelte-h":!0}),f(Ft)!=="svelte-pzjzpg"&&(Ft.innerHTML=Ca),Tn=i(t),Ot=a(t,"P",{"data-svelte-h":!0}),f(Ot)!=="svelte-1vx2pyd"&&(Ot.textContent=oa),vn=i(t),Wt=a(t,"P",{"data-svelte-h":!0}),f(Wt)!=="svelte-k9e4ho"&&(Wt.innerHTML=ha),mn=i(t),Yt=a(t,"P",{"data-svelte-h":!0}),f(Yt)!=="svelte-pqvvy8"&&(Yt.innerHTML=ja),Cn=i(t),qt=a(t,"P",{"data-svelte-h":!0}),f(qt)!=="svelte-14x9p2x"&&(qt.textContent=La),on=i(t),Kt=a(t,"P",{"data-svelte-h":!0}),f(Kt)!=="svelte-15wgr5g"&&(Kt.textContent=_a),hn=i(t),te=a(t,"UL",{"data-svelte-h":!0}),f(te)!=="svelte-1dhtgc4"&&(te.innerHTML=wa),jn=i(t),ee=a(t,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-7d8wyp"&&(ee.textContent=Ua),Ln=i(t),le=a(t,"UL",{"data-svelte-h":!0}),f(le)!=="svelte-n2xihd"&&(le.innerHTML=da),_n=i(t),se=a(t,"P",{"data-svelte-h":!0}),f(se)!=="svelte-1pmki5k"&&(se.textContent=ca),wn=i(t),ne=a(t,"UL",{"data-svelte-h":!0}),f(ne)!=="svelte-rjpi63"&&(ne.innerHTML=ba),Un=i(t),ie=a(t,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1bil00b"&&(ie.textContent=ya),dn=i(t),pe=a(t,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1ck5yhy"&&(pe.textContent=ga),cn=i(t),ae=a(t,"UL",{"data-svelte-h":!0}),f(ae)!=="svelte-lrqs1p"&&(ae.innerHTML=Da),bn=i(t),fe=a(t,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1x5n0v7"&&(fe.innerHTML=Ja),yn=i(t),ue=a(t,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-s6jmr9"&&(ue.textContent=Ga),gn=i(t),re=a(t,"P",{"data-svelte-h":!0}),f(re)!=="svelte-hr6cyy"&&(re.innerHTML=Ha),Dn=i(t),Pe=a(t,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1rbsb1"&&(Pe.textContent=$a),Jn=i(t),Me=a(t,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-9wimm0"&&(Me.textContent=Sa),Gn=i(t),xe=a(t,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-11yxh41"&&(xe.innerHTML=Na),Hn=i(t),r(Te.$$.fragment,t),$n=i(t),ve=a(t,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-hgec2q"&&(ve.textContent=Ia),Sn=i(t),me=a(t,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1vw3hgn"&&(me.innerHTML=Ea),Nn=i(t),Ce=a(t,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-50iqcm"&&(Ce.innerHTML=ka),In=i(t),oe=a(t,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-ohreuk"&&(oe.innerHTML=Ba),En=i(t),he=a(t,"P",{"data-svelte-h":!0}),f(he)!=="svelte-ipix21"&&(he.innerHTML=Qa),kn=i(t),je=a(t,"P",{"data-svelte-h":!0}),f(je)!=="svelte-90hb7t"&&(je.innerHTML=Za),Bn=i(t),Le=a(t,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-1onnlsj"&&(Le.innerHTML=Aa),Qn=i(t),_e=a(t,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-3zwgu7"&&(_e.innerHTML=Ra),Zn=i(t),we=a(t,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1krwmp6"&&(we.textContent=Va),An=i(t),Ue=a(t,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-cjuku1"&&(Ue.innerHTML=Xa),Rn=i(t),de=a(t,"P",{"data-svelte-h":!0}),f(de)!=="svelte-cuih7l"&&(de.textContent=za),Vn=i(t),ce=a(t,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-1izv442"&&(ce.textContent=Fa),Xn=i(t),be=a(t,"UL",{"data-svelte-h":!0}),f(be)!=="svelte-mbcbok"&&(be.innerHTML=Oa),zn=i(t),ye=a(t,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-1ck5yhy"&&(ye.textContent=Wa),Fn=i(t),ge=a(t,"UL",{"data-svelte-h":!0}),f(ge)!=="svelte-1t8057b"&&(ge.innerHTML=Ya),On=i(t),De=a(t,"P",{"data-svelte-h":!0}),f(De)!=="svelte-rcjrdm"&&(De.textContent=qa),Wn=i(t),Je=a(t,"UL",{"data-svelte-h":!0}),f(Je)!=="svelte-o15bsc"&&(Je.innerHTML=Ka),Yn=i(t),r(Ge.$$.fragment,t),qn=i(t),He=a(t,"P",{"data-svelte-h":!0}),f(He)!=="svelte-vbpz2p"&&(He.innerHTML=t1),Kn=i(t),$e=a(t,"P",{"data-svelte-h":!0}),f($e)!=="svelte-qmcl9c"&&($e.innerHTML=e1),ti=i(t),Se=a(t,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-bv9cuy"&&(Se.textContent=l1),ei=i(t),Ne=a(t,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-59obyf"&&(Ne.textContent=s1),li=i(t),Ie=a(t,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1ck5yhy"&&(Ie.textContent=n1),si=i(t),Ee=a(t,"UL",{"data-svelte-h":!0}),f(Ee)!=="svelte-1ry6c7"&&(Ee.innerHTML=i1),ni=i(t),ke=a(t,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-epm7kl"&&(ke.textContent=p1),ii=i(t),r(Be.$$.fragment,t),pi=i(t),Qe=a(t,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-1343087"&&(Qe.textContent=a1),ai=i(t),Ze=a(t,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-18rdwc7"&&(Ze.innerHTML=f1),fi=i(t),Ae=a(t,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-1ym49qs"&&(Ae.innerHTML=u1),ui=i(t),Re=a(t,"P",{"data-svelte-h":!0}),f(Re)!=="svelte-1b51hqj"&&(Re.textContent=r1),ri=i(t),Ve=a(t,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-1ck5yhy"&&(Ve.textContent=P1),Pi=i(t),Xe=a(t,"UL",{"data-svelte-h":!0}),f(Xe)!=="svelte-ry9hp9"&&(Xe.innerHTML=M1),Mi=i(t),ze=a(t,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-1u1ugiy"&&(ze.textContent=x1),xi=i(t),r(Fe.$$.fragment,t),Ti=i(t),Oe=a(t,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-og6tc0"&&(Oe.innerHTML=T1),vi=i(t),We=a(t,"P",{"data-svelte-h":!0}),f(We)!=="svelte-1dako7d"&&(We.textContent=v1),mi=i(t),Ye=a(t,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-1i0vdje"&&(Ye.textContent=m1),Ci=i(t),qe=a(t,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-14ure2q"&&(qe.innerHTML=C1),oi=i(t),Ke=a(t,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-4kjzn4"&&(Ke.textContent=o1),hi=i(t),tl=a(t,"P",{"data-svelte-h":!0}),f(tl)!=="svelte-14d05mj"&&(tl.textContent=h1),ji=i(t),el=a(t,"P",{"data-svelte-h":!0}),f(el)!=="svelte-1ck5yhy"&&(el.textContent=j1),Li=i(t),ll=a(t,"UL",{"data-svelte-h":!0}),f(ll)!=="svelte-1ax2f6w"&&(ll.innerHTML=L1),_i=i(t),sl=a(t,"P",{"data-svelte-h":!0}),f(sl)!=="svelte-1ed40md"&&(sl.textContent=_1),wi=i(t),nl=a(t,"UL",{"data-svelte-h":!0}),f(nl)!=="svelte-1oyel1u"&&(nl.innerHTML=w1),Ui=i(t),il=a(t,"P",{"data-svelte-h":!0}),f(il)!=="svelte-5q337c"&&(il.textContent=U1),di=i(t),r(pl.$$.fragment,t),ci=i(t),al=a(t,"P",{"data-svelte-h":!0}),f(al)!=="svelte-1eblblg"&&(al.innerHTML=d1),bi=i(t),fl=a(t,"P",{"data-svelte-h":!0}),f(fl)!=="svelte-1qwfj1u"&&(fl.innerHTML=c1),yi=i(t),ul=a(t,"P",{"data-svelte-h":!0}),f(ul)!=="svelte-1c5ov5y"&&(ul.textContent=b1),gi=i(t),rl=a(t,"OL",{"data-svelte-h":!0}),f(rl)!=="svelte-1u56pf8"&&(rl.innerHTML=y1),Di=i(t),Pl=a(t,"P",{"data-svelte-h":!0}),f(Pl)!=="svelte-dyo5xu"&&(Pl.textContent=g1),Ji=i(t),Ml=a(t,"UL",{"data-svelte-h":!0}),f(Ml)!=="svelte-1734ihx"&&(Ml.innerHTML=D1),Gi=i(t),xl=a(t,"P",{"data-svelte-h":!0}),f(xl)!=="svelte-yf6t32"&&(xl.textContent=J1),Hi=i(t),Tl=a(t,"UL",{"data-svelte-h":!0}),f(Tl)!=="svelte-ilmkvr"&&(Tl.innerHTML=G1),$i=i(t),vl=a(t,"P",{"data-svelte-h":!0}),f(vl)!=="svelte-1jqtfsl"&&(vl.textContent=H1),Si=i(t),ml=a(t,"UL",{"data-svelte-h":!0}),f(ml)!=="svelte-dyjda9"&&(ml.innerHTML=$1),Ni=i(t),Cl=a(t,"P",{"data-svelte-h":!0}),f(Cl)!=="svelte-heytrw"&&(Cl.textContent=S1),Ii=i(t),ol=a(t,"UL",{"data-svelte-h":!0}),f(ol)!=="svelte-bzftse"&&(ol.innerHTML=N1),Ei=i(t),hl=a(t,"P",{"data-svelte-h":!0}),f(hl)!=="svelte-1qy6dyl"&&(hl.textContent=I1),ki=i(t),jl=a(t,"P",{"data-svelte-h":!0}),f(jl)!=="svelte-k8js9g"&&(jl.innerHTML=E1),Bi=i(t),Ll=a(t,"P",{"data-svelte-h":!0}),f(Ll)!=="svelte-1igtexe"&&(Ll.textContent=k1),Qi=i(t),_l=a(t,"P",{"data-svelte-h":!0}),f(_l)!=="svelte-xvgxme"&&(_l.textContent=B1),Zi=i(t),wl=a(t,"P",{"data-svelte-h":!0}),f(wl)!=="svelte-1swbltk"&&(wl.textContent=Q1),Ai=i(t),Ul=a(t,"P",{"data-svelte-h":!0}),f(Ul)!=="svelte-1rm99pd"&&(Ul.innerHTML=Z1),Ri=i(t),r(dl.$$.fragment,t),Vi=i(t),cl=a(t,"P",{"data-svelte-h":!0}),f(cl)!=="svelte-zoex81"&&(cl.textContent=A1),Xi=i(t),bl=a(t,"P",{"data-svelte-h":!0}),f(bl)!=="svelte-1orry83"&&(bl.innerHTML=R1),zi=i(t),yl=a(t,"UL",{"data-svelte-h":!0}),f(yl)!=="svelte-1qnozua"&&(yl.innerHTML=V1),Fi=i(t),gl=a(t,"OL",{"data-svelte-h":!0}),f(gl)!=="svelte-1jiif8z"&&(gl.innerHTML=X1),Oi=i(t),Dl=a(t,"P",{"data-svelte-h":!0}),f(Dl)!=="svelte-10tmreb"&&(Dl.innerHTML=z1),Wi=i(t),Jl=a(t,"UL",{"data-svelte-h":!0}),f(Jl)!=="svelte-1su60au"&&(Jl.innerHTML=F1),Yi=i(t),Gl=a(t,"P",{"data-svelte-h":!0}),f(Gl)!=="svelte-qkh5m"&&(Gl.innerHTML=O1),qi=i(t),Hl=a(t,"UL",{"data-svelte-h":!0}),f(Hl)!=="svelte-yy2g2e"&&(Hl.innerHTML=W1),Ki=i(t),Sl=a(t,"P",{}),q1(Sl).forEach(l),this.h()},h(){K1(v,"name","hf:doc:metadata"),K1(v,"content",Mf)},m(t,e){af(document.head,v),s(t,h,e),s(t,C,e),s(t,$l,e),P(j,t,e),s(t,El,e),s(t,L,e),s(t,kl,e),P(o,t,e),s(t,Bl,e),s(t,_,e),s(t,Ql,e),P(w,t,e),s(t,Zl,e),s(t,U,e),s(t,Al,e),s(t,d,e),s(t,Rl,e),s(t,c,e),s(t,Vl,e),P(b,t,e),s(t,Xl,e),s(t,y,e),s(t,zl,e),s(t,g,e),s(t,Fl,e),s(t,D,e),s(t,Ol,e),s(t,J,e),s(t,Wl,e),P(G,t,e),s(t,Yl,e),s(t,H,e),s(t,ql,e),P($,t,e),s(t,Kl,e),s(t,S,e),s(t,ts,e),s(t,N,e),s(t,es,e),s(t,I,e),s(t,ls,e),s(t,E,e),s(t,ss,e),s(t,k,e),s(t,ns,e),s(t,B,e),s(t,is,e),s(t,Q,e),s(t,ps,e),s(t,Z,e),s(t,as,e),s(t,A,e),s(t,fs,e),s(t,R,e),s(t,us,e),s(t,V,e),s(t,rs,e),s(t,X,e),s(t,Ps,e),s(t,z,e),s(t,Ms,e),s(t,F,e),s(t,xs,e),s(t,O,e),s(t,Ts,e),s(t,W,e),s(t,vs,e),s(t,Y,e),s(t,ms,e),s(t,q,e),s(t,Cs,e),s(t,K,e),s(t,os,e),s(t,tt,e),s(t,hs,e),s(t,et,e),s(t,js,e),P(lt,t,e),s(t,Ls,e),s(t,st,e),s(t,_s,e),P(nt,t,e),s(t,ws,e),s(t,it,e),s(t,Us,e),s(t,pt,e),s(t,ds,e),s(t,at,e),s(t,cs,e),P(ft,t,e),s(t,bs,e),s(t,ut,e),s(t,ys,e),s(t,rt,e),s(t,gs,e),P(Pt,t,e),s(t,Ds,e),s(t,Mt,e),s(t,Js,e),s(t,xt,e),s(t,Gs,e),P(Tt,t,e),s(t,Hs,e),s(t,vt,e),s(t,$s,e),s(t,mt,e),s(t,Ss,e),s(t,Ct,e),s(t,Ns,e),s(t,ot,e),s(t,Is,e),s(t,ht,e),s(t,Es,e),s(t,jt,e),s(t,ks,e),s(t,Lt,e),s(t,Bs,e),s(t,_t,e),s(t,Qs,e),s(t,wt,e),s(t,Zs,e),s(t,Ut,e),s(t,As,e),s(t,dt,e),s(t,Rs,e),s(t,ct,e),s(t,Vs,e),s(t,bt,e),s(t,Xs,e),s(t,yt,e),s(t,zs,e),s(t,gt,e),s(t,Fs,e),s(t,Dt,e),s(t,Os,e),P(Jt,t,e),s(t,Ws,e),s(t,Gt,e),s(t,Ys,e),s(t,Ht,e),s(t,qs,e),P($t,t,e),s(t,Ks,e),s(t,St,e),s(t,tn,e),s(t,Nt,e),s(t,en,e),s(t,It,e),s(t,ln,e),s(t,Et,e),s(t,sn,e),s(t,kt,e),s(t,nn,e),s(t,Bt,e),s(t,pn,e),s(t,Qt,e),s(t,an,e),s(t,Zt,e),s(t,fn,e),s(t,At,e),s(t,un,e),s(t,Rt,e),s(t,rn,e),s(t,Vt,e),s(t,Pn,e),s(t,Xt,e),s(t,Mn,e),s(t,zt,e),s(t,xn,e),s(t,Ft,e),s(t,Tn,e),s(t,Ot,e),s(t,vn,e),s(t,Wt,e),s(t,mn,e),s(t,Yt,e),s(t,Cn,e),s(t,qt,e),s(t,on,e),s(t,Kt,e),s(t,hn,e),s(t,te,e),s(t,jn,e),s(t,ee,e),s(t,Ln,e),s(t,le,e),s(t,_n,e),s(t,se,e),s(t,wn,e),s(t,ne,e),s(t,Un,e),s(t,ie,e),s(t,dn,e),s(t,pe,e),s(t,cn,e),s(t,ae,e),s(t,bn,e),s(t,fe,e),s(t,yn,e),s(t,ue,e),s(t,gn,e),s(t,re,e),s(t,Dn,e),s(t,Pe,e),s(t,Jn,e),s(t,Me,e),s(t,Gn,e),s(t,xe,e),s(t,Hn,e),P(Te,t,e),s(t,$n,e),s(t,ve,e),s(t,Sn,e),s(t,me,e),s(t,Nn,e),s(t,Ce,e),s(t,In,e),s(t,oe,e),s(t,En,e),s(t,he,e),s(t,kn,e),s(t,je,e),s(t,Bn,e),s(t,Le,e),s(t,Qn,e),s(t,_e,e),s(t,Zn,e),s(t,we,e),s(t,An,e),s(t,Ue,e),s(t,Rn,e),s(t,de,e),s(t,Vn,e),s(t,ce,e),s(t,Xn,e),s(t,be,e),s(t,zn,e),s(t,ye,e),s(t,Fn,e),s(t,ge,e),s(t,On,e),s(t,De,e),s(t,Wn,e),s(t,Je,e),s(t,Yn,e),P(Ge,t,e),s(t,qn,e),s(t,He,e),s(t,Kn,e),s(t,$e,e),s(t,ti,e),s(t,Se,e),s(t,ei,e),s(t,Ne,e),s(t,li,e),s(t,Ie,e),s(t,si,e),s(t,Ee,e),s(t,ni,e),s(t,ke,e),s(t,ii,e),P(Be,t,e),s(t,pi,e),s(t,Qe,e),s(t,ai,e),s(t,Ze,e),s(t,fi,e),s(t,Ae,e),s(t,ui,e),s(t,Re,e),s(t,ri,e),s(t,Ve,e),s(t,Pi,e),s(t,Xe,e),s(t,Mi,e),s(t,ze,e),s(t,xi,e),P(Fe,t,e),s(t,Ti,e),s(t,Oe,e),s(t,vi,e),s(t,We,e),s(t,mi,e),s(t,Ye,e),s(t,Ci,e),s(t,qe,e),s(t,oi,e),s(t,Ke,e),s(t,hi,e),s(t,tl,e),s(t,ji,e),s(t,el,e),s(t,Li,e),s(t,ll,e),s(t,_i,e),s(t,sl,e),s(t,wi,e),s(t,nl,e),s(t,Ui,e),s(t,il,e),s(t,di,e),P(pl,t,e),s(t,ci,e),s(t,al,e),s(t,bi,e),s(t,fl,e),s(t,yi,e),s(t,ul,e),s(t,gi,e),s(t,rl,e),s(t,Di,e),s(t,Pl,e),s(t,Ji,e),s(t,Ml,e),s(t,Gi,e),s(t,xl,e),s(t,Hi,e),s(t,Tl,e),s(t,$i,e),s(t,vl,e),s(t,Si,e),s(t,ml,e),s(t,Ni,e),s(t,Cl,e),s(t,Ii,e),s(t,ol,e),s(t,Ei,e),s(t,hl,e),s(t,ki,e),s(t,jl,e),s(t,Bi,e),s(t,Ll,e),s(t,Qi,e),s(t,_l,e),s(t,Zi,e),s(t,wl,e),s(t,Ai,e),s(t,Ul,e),s(t,Ri,e),P(dl,t,e),s(t,Vi,e),s(t,cl,e),s(t,Xi,e),s(t,bl,e),s(t,zi,e),s(t,yl,e),s(t,Fi,e),s(t,gl,e),s(t,Oi,e),s(t,Dl,e),s(t,Wi,e),s(t,Jl,e),s(t,Yi,e),s(t,Gl,e),s(t,qi,e),s(t,Hl,e),s(t,Ki,e),s(t,Sl,e),tp=!0},p(t,[e]){const Y1={};e&2&&(Y1.$$scope={dirty:e,ctx:t}),o.$set(Y1)},i(t){tp||(M(j.$$.fragment,t),M(o.$$.fragment,t),M(w.$$.fragment,t),M(b.$$.fragment,t),M(G.$$.fragment,t),M($.$$.fragment,t),M(lt.$$.fragment,t),M(nt.$$.fragment,t),M(ft.$$.fragment,t),M(Pt.$$.fragment,t),M(Tt.$$.fragment,t),M(Jt.$$.fragment,t),M($t.$$.fragment,t),M(Te.$$.fragment,t),M(Ge.$$.fragment,t),M(Be.$$.fragment,t),M(Fe.$$.fragment,t),M(pl.$$.fragment,t),M(dl.$$.fragment,t),tp=!0)},o(t){x(j.$$.fragment,t),x(o.$$.fragment,t),x(w.$$.fragment,t),x(b.$$.fragment,t),x(G.$$.fragment,t),x($.$$.fragment,t),x(lt.$$.fragment,t),x(nt.$$.fragment,t),x(ft.$$.fragment,t),x(Pt.$$.fragment,t),x(Tt.$$.fragment,t),x(Jt.$$.fragment,t),x($t.$$.fragment,t),x(Te.$$.fragment,t),x(Ge.$$.fragment,t),x(Be.$$.fragment,t),x(Fe.$$.fragment,t),x(pl.$$.fragment,t),x(dl.$$.fragment,t),tp=!1},d(t){t&&(l(h),l(C),l($l),l(El),l(L),l(kl),l(Bl),l(_),l(Ql),l(Zl),l(U),l(Al),l(d),l(Rl),l(c),l(Vl),l(Xl),l(y),l(zl),l(g),l(Fl),l(D),l(Ol),l(J),l(Wl),l(Yl),l(H),l(ql),l(Kl),l(S),l(ts),l(N),l(es),l(I),l(ls),l(E),l(ss),l(k),l(ns),l(B),l(is),l(Q),l(ps),l(Z),l(as),l(A),l(fs),l(R),l(us),l(V),l(rs),l(X),l(Ps),l(z),l(Ms),l(F),l(xs),l(O),l(Ts),l(W),l(vs),l(Y),l(ms),l(q),l(Cs),l(K),l(os),l(tt),l(hs),l(et),l(js),l(Ls),l(st),l(_s),l(ws),l(it),l(Us),l(pt),l(ds),l(at),l(cs),l(bs),l(ut),l(ys),l(rt),l(gs),l(Ds),l(Mt),l(Js),l(xt),l(Gs),l(Hs),l(vt),l($s),l(mt),l(Ss),l(Ct),l(Ns),l(ot),l(Is),l(ht),l(Es),l(jt),l(ks),l(Lt),l(Bs),l(_t),l(Qs),l(wt),l(Zs),l(Ut),l(As),l(dt),l(Rs),l(ct),l(Vs),l(bt),l(Xs),l(yt),l(zs),l(gt),l(Fs),l(Dt),l(Os),l(Ws),l(Gt),l(Ys),l(Ht),l(qs),l(Ks),l(St),l(tn),l(Nt),l(en),l(It),l(ln),l(Et),l(sn),l(kt),l(nn),l(Bt),l(pn),l(Qt),l(an),l(Zt),l(fn),l(At),l(un),l(Rt),l(rn),l(Vt),l(Pn),l(Xt),l(Mn),l(zt),l(xn),l(Ft),l(Tn),l(Ot),l(vn),l(Wt),l(mn),l(Yt),l(Cn),l(qt),l(on),l(Kt),l(hn),l(te),l(jn),l(ee),l(Ln),l(le),l(_n),l(se),l(wn),l(ne),l(Un),l(ie),l(dn),l(pe),l(cn),l(ae),l(bn),l(fe),l(yn),l(ue),l(gn),l(re),l(Dn),l(Pe),l(Jn),l(Me),l(Gn),l(xe),l(Hn),l($n),l(ve),l(Sn),l(me),l(Nn),l(Ce),l(In),l(oe),l(En),l(he),l(kn),l(je),l(Bn),l(Le),l(Qn),l(_e),l(Zn),l(we),l(An),l(Ue),l(Rn),l(de),l(Vn),l(ce),l(Xn),l(be),l(zn),l(ye),l(Fn),l(ge),l(On),l(De),l(Wn),l(Je),l(Yn),l(qn),l(He),l(Kn),l($e),l(ti),l(Se),l(ei),l(Ne),l(li),l(Ie),l(si),l(Ee),l(ni),l(ke),l(ii),l(pi),l(Qe),l(ai),l(Ze),l(fi),l(Ae),l(ui),l(Re),l(ri),l(Ve),l(Pi),l(Xe),l(Mi),l(ze),l(xi),l(Ti),l(Oe),l(vi),l(We),l(mi),l(Ye),l(Ci),l(qe),l(oi),l(Ke),l(hi),l(tl),l(ji),l(el),l(Li),l(ll),l(_i),l(sl),l(wi),l(nl),l(Ui),l(il),l(di),l(ci),l(al),l(bi),l(fl),l(yi),l(ul),l(gi),l(rl),l(Di),l(Pl),l(Ji),l(Ml),l(Gi),l(xl),l(Hi),l(Tl),l($i),l(vl),l(Si),l(ml),l(Ni),l(Cl),l(Ii),l(ol),l(Ei),l(hl),l(ki),l(jl),l(Bi),l(Ll),l(Qi),l(_l),l(Zi),l(wl),l(Ai),l(Ul),l(Ri),l(Vi),l(cl),l(Xi),l(bl),l(zi),l(yl),l(Fi),l(gl),l(Oi),l(Dl),l(Wi),l(Jl),l(Yi),l(Gl),l(qi),l(Hl),l(Ki),l(Sl)),l(v),T(j,t),T(o,t),T(w,t),T(b,t),T(G,t),T($,t),T(lt,t),T(nt,t),T(ft,t),T(Pt,t),T(Tt,t),T(Jt,t),T($t,t),T(Te,t),T(Ge,t),T(Be,t),T(Fe,t),T(pl,t),T(dl,t)}}}const Mf='{"title":"다중 GPU에서 효율적인 훈련","local":"efficient-training-on-multiple-gpus","sections":[{"title":"개념","local":"concepts","sections":[],"depth":2},{"title":"확장성 전략","local":"scalability-strategy","sections":[],"depth":2},{"title":"데이터 병렬화","local":"data-parallelism","sections":[{"title":"DP vs DDP","local":"dp-vs-ddp","sections":[],"depth":3}],"depth":2},{"title":"ZeRO 데이터 병렬화","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"네이티브 모델 병렬 처리(수직적) 및 파이프라인 병렬 처리","local":"naive-model-parallelism-vertical-and-pipeline-parallelism","sections":[],"depth":2},{"title":"텐서 병렬 처리","local":"tensor-parallelism","sections":[],"depth":2},{"title":"DP+PP","local":"dppp","sections":[],"depth":2},{"title":"DP+PP+TP","local":"dppptp","sections":[],"depth":2},{"title":"ZeRO DP+PP+TP","local":"zero-dppptp","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"어떤 전략을 사용해야 할까요?","local":"which-strategy-to-use-when","sections":[],"depth":2}],"depth":1}';function xf(Il){return ef(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ff}),[]}class hf extends sf{constructor(v){super(),nf(this,v,xf,Pf,tf,{})}}export{hf as component};
