import{s as is,o as os,n as ps}from"../chunks/scheduler.9bc65507.js";import{S as rs,i as ms,g as i,s as l,r,A as us,h as o,f as s,c as n,j as ns,u as m,x as p,k as Zt,y as cs,a,v as u,d as c,t as d,w as h}from"../chunks/index.707bf1b6.js";import{T as ds}from"../chunks/Tip.c2ecdbf4.js";import{C as f}from"../chunks/CodeBlock.54a9f38d.js";import{D as hs}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as M}from"../chunks/Heading.342b1fa6.js";function gs(Je){let g,T='If you’re interested in basic LLM usage, our high-level <a href="pipeline_tutorial"><code>Pipeline</code></a> interface is a great starting point. However, LLMs often require advanced features like quantization and fine control of the token selection step, which is best done through <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. Autoregressive generation with LLMs is also resource-intensive and should be executed on a GPU for adequate throughput.';return{c(){g=i("p"),g.innerHTML=T},l(y){g=o(y,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1ngfsxw"&&(g.innerHTML=T)},m(y,je){a(y,g,je)},p:ps,d(y){y&&s(g)}}}function Ms(Je){let g,T,y,je,J,Ue,U,ke,k,Gt="LLMs, or Large Language Models, are the key component behind text generation. In a nutshell, they consist of large pretrained transformer models trained to predict the next word (or, more precisely, token) given some input text. Since they predict one token at a time, you need to do something more elaborate to generate new sentences other than just calling the model — you need to do autoregressive generation.",Ze,Z,It='Autoregressive generation is the inference-time procedure of iteratively calling a model with its own generated outputs, given a few initial inputs. In 🤗 Transformers, this is handled by the <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method, which is available to all models with generative capabilities.',Ge,G,vt="This tutorial will show you how to:",Ie,I,_t="<li>Generate text with an LLM</li> <li>Avoid common pitfalls</li> <li>Next steps to help you get the most out of your LLM</li>",ve,v,Bt="Before you begin, make sure you have all the necessary libraries installed:",_e,_,Be,B,We,W,Wt='A language model trained for <a href="tasks/language_modeling">causal language modeling</a> takes a sequence of text tokens as input and returns the probability distribution for the next token.',$e,b,$t='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;Forward pass of an LLM&quot;</figcaption>',Xe,$,Xt="A critical aspect of autoregressive generation with LLMs is how to select the next token from this probability distribution. Anything goes in this step as long as you end up with a token for the next iteration. This means it can be as simple as selecting the most likely token from the probability distribution or as complex as applying a dozen transformations before sampling from the resulting distribution.",Ve,w,Vt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;Autoregressive generation iteratively selects the next token from a probability distribution to generate text&quot;</figcaption>',Re,X,Rt="The process depicted above is repeated iteratively until some stopping condition is reached. Ideally, the stopping condition is dictated by the model, which should learn when to output an end-of-sequence (<code>EOS</code>) token. If this is not the case, generation stops when some predefined maximum length is reached.",xe,V,xt='Properly setting up the token selection step and the stopping condition is essential to make your model behave as you’d expect on your task. That is why we have a <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file associated with each model, which contains a good default generative parameterization and is loaded alongside your model.',Ce,R,Ct="Let’s talk code!",ze,j,He,x,zt="First, you need to load the model.",Le,C,qe,z,Ht="You’ll notice two flags in the <code>from_pretrained</code> call:",Fe,H,Lt='<li><code>device_map</code> ensures the model is moved to your GPU(s)</li> <li><code>load_in_4bit</code> applies <a href="main_classes/quantization">4-bit dynamic quantization</a> to massively reduce the resource requirements</li>',Ne,L,qt="There are other ways to initialize a model, but this is a good baseline to begin with an LLM.",Qe,q,Ft='Next, you need to preprocess your text input with a <a href="tokenizer_summary">tokenizer</a>.',Ee,F,Se,N,Nt='The <code>model_inputs</code> variable holds the tokenized text input, as well as the attention mask. While <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> does its best effort to infer the attention mask when it is not passed, we recommend passing it whenever possible for optimal results.',Ye,Q,Qt='After tokenizing the inputs, you can call the <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to returns the generated tokens. The generated tokens then should be converted to text before printing.',Ae,E,Ke,S,Et="Finally, you don’t need to do it one sequence at a time! You can batch your inputs, which will greatly improve the throughput at a small latency and memory cost. All you need to do is to make sure you pad your inputs properly (more on that below).",De,Y,Pe,A,St="And that’s it! In a few lines of code, you can harness the power of an LLM.",Oe,K,et,D,Yt='There are many <a href="generation_strategies">generation strategies</a>, and sometimes the default values may not be appropriate for your use case. If your outputs aren’t aligned with what you’re expecting, we’ve created a list of the most common pitfalls and how to avoid them.',tt,P,st,O,at,ee,At='If not specified in the <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> returns up to 20 tokens by default. We highly recommend manually setting <code>max_new_tokens</code> in your <code>generate</code> call to control the maximum number of new tokens it can return. Keep in mind LLMs (more precisely, <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only models</a>) also return the input prompt as part of the output.',lt,te,nt,se,it,ae,Kt='By default, and unless specified in the <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> selects the most likely token at each iteration (greedy decoding). Depending on your task, this may be undesirable; creative tasks like chatbots or writing an essay benefit from sampling. On the other hand, input-grounded tasks like audio transcription or translation benefit from greedy decoding. Enable sampling with <code>do_sample=True</code>, and you can learn more about this topic in this <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">blog post</a>.',ot,le,pt,ne,rt,ie,Dt='LLMs are <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only</a> architectures, meaning they continue to iterate on your input prompt. If your inputs do not have the same length, they need to be padded. Since LLMs are not trained to continue from pad tokens, your input needs to be left-padded. Make sure you also don’t forget to pass the attention mask to generate!',mt,oe,ut,pe,ct,re,Pt='Some models and tasks expect a certain input prompt format to work properly. When this format is not applied, you will get a silent performance degradation: the model kinda works, but not as well as if you were following the expected prompt. More information about prompting, including which models and tasks need to be careful, is available in this <a href="tasks/prompting">guide</a>. Let’s see an example with a chat LLM, which makes use of <a href="chat_templating">chat templating</a>:',dt,me,ht,ue,gt,ce,Ot="While the autoregressive generation process is relatively straightforward, making the most out of your LLM can be a challenging endeavor because there are many moving parts. For your next steps to help you dive deeper into LLM usage and understanding:",Mt,de,yt,he,es='<li><a href="generation_strategies">Guide</a> on how to control different generation methods, how to set up the generation configuration file, and how to stream the output;</li> <li><a href="chat_templating">Guide</a> on the prompt template for chat LLMs;</li> <li><a href="tasks/prompting">Guide</a> on to get the most of prompt design;</li> <li>API reference on <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, and <a href="internal/generation_utils">generate-related classes</a>.</li>',ft,ge,bt,Me,ts='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, which focuses on the quality of the open-source models;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, which focuses on LLM throughput.</li>',wt,ye,jt,fe,ss='<li><a href="llm_tutorial_optimization">Guide</a> on how to optimize LLMs for speed and memory;</li> <li><a href="main_classes/quantization">Guide</a> on quantization such as bitsandbytes and autogptq, which shows you how to drastically reduce your memory requirements.</li>',Tt,be,Jt,we,as='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, a production-ready server for LLMs;</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, an extension of 🤗 Transformers that optimizes for specific hardware devices.</li>',Ut,Te,kt;return J=new M({props:{title:"Generation with LLMs",local:"generation-with-llms",headingTag:"h1"}}),U=new hs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"}]}}),_=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),B=new M({props:{title:"Generate text",local:"generate-text",headingTag:"h2"}}),j=new ds({props:{$$slots:{default:[gs]},$$scope:{ctx:Je}}}),C=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),F=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),E=new f({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>`,wrap:!1}}),Y=new f({props:{code:"dG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBNb3N0JTIwTExNcyUyMGRvbid0JTIwaGF2ZSUyMGElMjBwYWQlMjB0b2tlbiUyMGJ5JTIwZGVmYXVsdCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiUyQyUyMCUyMlBvcnR1Z2FsJTIwaXMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>, <span class="hljs-string">&quot;Portugal is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>,
<span class="hljs-string">&#x27;Portugal is a country in southwestern Europe, on the Iber&#x27;</span>]`,wrap:!1}}),K=new M({props:{title:"Common pitfalls",local:"common-pitfalls",headingTag:"h2"}}),P=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMCUyMCUyMyUyME1vc3QlMjBMTE1zJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new M({props:{title:"Generated output is too short/long",local:"generated-output-is-too-shortlong",headingTag:"h3"}}),te=new f({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),se=new M({props:{title:"Incorrect generation mode",local:"incorrect-generation-mode",headingTag:"h3"}}),le=new f({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCg0MiklMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSUyMGFtJTIwYSUyMGNhdC4lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMExMTSUyMCUyQiUyMGdyZWVkeSUyMGRlY29kaW5nJTIwJTNEJTIwcmVwZXRpdGl2ZSUyQyUyMGJvcmluZyUyMG91dHB1dCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwYmVjb21lcyUyMG1vcmUlMjBjcmVhdGl2ZSElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.  Specifically, I am an indoor-only cat.  I&#x27;</span>`,wrap:!1}}),ne=new M({props:{title:"Wrong padding side",local:"wrong-padding-side",headingTag:"h3"}}),oe=new f({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscyUyMHRvJTIwY2FwdHVyZSUyMHRoZSUyMGxvZ2ljLiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjIxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjAlMjJBJTJDJTIwQiUyQyUyMEMlMkMlMjBEJTJDJTIwRSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMFdpdGglMjBsZWZ0LXBhZGRpbmclMkMlMjBpdCUyMHdvcmtzJTIwYXMlMjBleHBlY3RlZCElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTW9zdCUyMExMTXMlMjBkb24ndCUyMGhhdmUlMjBhJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails to capture the logic.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 33333333333&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),pe=new M({props:{title:"Wrong prompt",local:"wrong-prompt",headingTag:"h3"}}),me=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;How many helicopters can a human eat in one sitting? Reply as a thug.&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;I&#x27;m not a thug, but i can tell you that a human cannot eat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Oh no, it did not follow our instruction to reply as a thug! Let&#x27;s see what happens when we write</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># a better prompt and use the right template for this model (through \`tokenizer.apply_chat_template\`)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a thug&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;None, you thug. How bout you try to focus on more useful questions?&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># As we can see, it followed a proper thug style 😎</span>`,wrap:!1}}),ue=new M({props:{title:"Further resources",local:"further-resources",headingTag:"h2"}}),de=new M({props:{title:"Advanced generate usage",local:"advanced-generate-usage",headingTag:"h3"}}),ge=new M({props:{title:"LLM leaderboards",local:"llm-leaderboards",headingTag:"h3"}}),ye=new M({props:{title:"Latency, throughput and memory utilization",local:"latency-throughput-and-memory-utilization",headingTag:"h3"}}),be=new M({props:{title:"Related libraries",local:"related-libraries",headingTag:"h3"}}),{c(){g=i("meta"),T=l(),y=i("p"),je=l(),r(J.$$.fragment),Ue=l(),r(U.$$.fragment),ke=l(),k=i("p"),k.textContent=Gt,Ze=l(),Z=i("p"),Z.innerHTML=It,Ge=l(),G=i("p"),G.textContent=vt,Ie=l(),I=i("ul"),I.innerHTML=_t,ve=l(),v=i("p"),v.textContent=Bt,_e=l(),r(_.$$.fragment),Be=l(),r(B.$$.fragment),We=l(),W=i("p"),W.innerHTML=Wt,$e=l(),b=i("figure"),b.innerHTML=$t,Xe=l(),$=i("p"),$.textContent=Xt,Ve=l(),w=i("figure"),w.innerHTML=Vt,Re=l(),X=i("p"),X.innerHTML=Rt,xe=l(),V=i("p"),V.innerHTML=xt,Ce=l(),R=i("p"),R.textContent=Ct,ze=l(),r(j.$$.fragment),He=l(),x=i("p"),x.textContent=zt,Le=l(),r(C.$$.fragment),qe=l(),z=i("p"),z.innerHTML=Ht,Fe=l(),H=i("ul"),H.innerHTML=Lt,Ne=l(),L=i("p"),L.textContent=qt,Qe=l(),q=i("p"),q.innerHTML=Ft,Ee=l(),r(F.$$.fragment),Se=l(),N=i("p"),N.innerHTML=Nt,Ye=l(),Q=i("p"),Q.innerHTML=Qt,Ae=l(),r(E.$$.fragment),Ke=l(),S=i("p"),S.textContent=Et,De=l(),r(Y.$$.fragment),Pe=l(),A=i("p"),A.textContent=St,Oe=l(),r(K.$$.fragment),et=l(),D=i("p"),D.innerHTML=Yt,tt=l(),r(P.$$.fragment),st=l(),r(O.$$.fragment),at=l(),ee=i("p"),ee.innerHTML=At,lt=l(),r(te.$$.fragment),nt=l(),r(se.$$.fragment),it=l(),ae=i("p"),ae.innerHTML=Kt,ot=l(),r(le.$$.fragment),pt=l(),r(ne.$$.fragment),rt=l(),ie=i("p"),ie.innerHTML=Dt,mt=l(),r(oe.$$.fragment),ut=l(),r(pe.$$.fragment),ct=l(),re=i("p"),re.innerHTML=Pt,dt=l(),r(me.$$.fragment),ht=l(),r(ue.$$.fragment),gt=l(),ce=i("p"),ce.textContent=Ot,Mt=l(),r(de.$$.fragment),yt=l(),he=i("ol"),he.innerHTML=es,ft=l(),r(ge.$$.fragment),bt=l(),Me=i("ol"),Me.innerHTML=ts,wt=l(),r(ye.$$.fragment),jt=l(),fe=i("ol"),fe.innerHTML=ss,Tt=l(),r(be.$$.fragment),Jt=l(),we=i("ol"),we.innerHTML=as,Ut=l(),Te=i("p"),this.h()},l(e){const t=us("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),T=n(e),y=o(e,"P",{}),ns(y).forEach(s),je=n(e),m(J.$$.fragment,e),Ue=n(e),m(U.$$.fragment,e),ke=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-tihwde"&&(k.textContent=Gt),Ze=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-8zo5rx"&&(Z.innerHTML=It),Ge=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1g5tmp7"&&(G.textContent=vt),Ie=n(e),I=o(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-jbjjoq"&&(I.innerHTML=_t),ve=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1c9nexd"&&(v.textContent=Bt),_e=n(e),m(_.$$.fragment,e),Be=n(e),m(B.$$.fragment,e),We=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-e3t4o0"&&(W.innerHTML=Wt),$e=n(e),b=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-hjgddv"&&(b.innerHTML=$t),Xe=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1qja5m9"&&($.textContent=Xt),Ve=n(e),w=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1uqc9hk"&&(w.innerHTML=Vt),Re=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-pprvht"&&(X.innerHTML=Rt),xe=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1qlde8r"&&(V.innerHTML=xt),Ce=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1wpt61n"&&(R.textContent=Ct),ze=n(e),m(j.$$.fragment,e),He=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-17lmqvk"&&(x.textContent=zt),Le=n(e),m(C.$$.fragment,e),qe=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ibsgq1"&&(z.innerHTML=Ht),Fe=n(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1ut1fuh"&&(H.innerHTML=Lt),Ne=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-14llc8d"&&(L.textContent=qt),Qe=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-9uk3l0"&&(q.innerHTML=Ft),Ee=n(e),m(F.$$.fragment,e),Se=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1tcqdl5"&&(N.innerHTML=Nt),Ye=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-rskg6g"&&(Q.innerHTML=Qt),Ae=n(e),m(E.$$.fragment,e),Ke=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1p82il9"&&(S.textContent=Et),De=n(e),m(Y.$$.fragment,e),Pe=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-wj0v9f"&&(A.textContent=St),Oe=n(e),m(K.$$.fragment,e),et=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1h0ongv"&&(D.innerHTML=Yt),tt=n(e),m(P.$$.fragment,e),st=n(e),m(O.$$.fragment,e),at=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-fzjy86"&&(ee.innerHTML=At),lt=n(e),m(te.$$.fragment,e),nt=n(e),m(se.$$.fragment,e),it=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1twm5og"&&(ae.innerHTML=Kt),ot=n(e),m(le.$$.fragment,e),pt=n(e),m(ne.$$.fragment,e),rt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1n0cu3a"&&(ie.innerHTML=Dt),mt=n(e),m(oe.$$.fragment,e),ut=n(e),m(pe.$$.fragment,e),ct=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-136mw01"&&(re.innerHTML=Pt),dt=n(e),m(me.$$.fragment,e),ht=n(e),m(ue.$$.fragment,e),gt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1w0my5d"&&(ce.textContent=Ot),Mt=n(e),m(de.$$.fragment,e),yt=n(e),he=o(e,"OL",{"data-svelte-h":!0}),p(he)!=="svelte-1i02syz"&&(he.innerHTML=es),ft=n(e),m(ge.$$.fragment,e),bt=n(e),Me=o(e,"OL",{"data-svelte-h":!0}),p(Me)!=="svelte-x6edjm"&&(Me.innerHTML=ts),wt=n(e),m(ye.$$.fragment,e),jt=n(e),fe=o(e,"OL",{"data-svelte-h":!0}),p(fe)!=="svelte-1jplvp8"&&(fe.innerHTML=ss),Tt=n(e),m(be.$$.fragment,e),Jt=n(e),we=o(e,"OL",{"data-svelte-h":!0}),p(we)!=="svelte-e8l3du"&&(we.innerHTML=as),Ut=n(e),Te=o(e,"P",{}),ns(Te).forEach(s),this.h()},h(){Zt(g,"name","hf:doc:metadata"),Zt(g,"content",ys),Zt(b,"class","image table text-center m-0 w-full"),Zt(w,"class","image table text-center m-0 w-full")},m(e,t){cs(document.head,g),a(e,T,t),a(e,y,t),a(e,je,t),u(J,e,t),a(e,Ue,t),u(U,e,t),a(e,ke,t),a(e,k,t),a(e,Ze,t),a(e,Z,t),a(e,Ge,t),a(e,G,t),a(e,Ie,t),a(e,I,t),a(e,ve,t),a(e,v,t),a(e,_e,t),u(_,e,t),a(e,Be,t),u(B,e,t),a(e,We,t),a(e,W,t),a(e,$e,t),a(e,b,t),a(e,Xe,t),a(e,$,t),a(e,Ve,t),a(e,w,t),a(e,Re,t),a(e,X,t),a(e,xe,t),a(e,V,t),a(e,Ce,t),a(e,R,t),a(e,ze,t),u(j,e,t),a(e,He,t),a(e,x,t),a(e,Le,t),u(C,e,t),a(e,qe,t),a(e,z,t),a(e,Fe,t),a(e,H,t),a(e,Ne,t),a(e,L,t),a(e,Qe,t),a(e,q,t),a(e,Ee,t),u(F,e,t),a(e,Se,t),a(e,N,t),a(e,Ye,t),a(e,Q,t),a(e,Ae,t),u(E,e,t),a(e,Ke,t),a(e,S,t),a(e,De,t),u(Y,e,t),a(e,Pe,t),a(e,A,t),a(e,Oe,t),u(K,e,t),a(e,et,t),a(e,D,t),a(e,tt,t),u(P,e,t),a(e,st,t),u(O,e,t),a(e,at,t),a(e,ee,t),a(e,lt,t),u(te,e,t),a(e,nt,t),u(se,e,t),a(e,it,t),a(e,ae,t),a(e,ot,t),u(le,e,t),a(e,pt,t),u(ne,e,t),a(e,rt,t),a(e,ie,t),a(e,mt,t),u(oe,e,t),a(e,ut,t),u(pe,e,t),a(e,ct,t),a(e,re,t),a(e,dt,t),u(me,e,t),a(e,ht,t),u(ue,e,t),a(e,gt,t),a(e,ce,t),a(e,Mt,t),u(de,e,t),a(e,yt,t),a(e,he,t),a(e,ft,t),u(ge,e,t),a(e,bt,t),a(e,Me,t),a(e,wt,t),u(ye,e,t),a(e,jt,t),a(e,fe,t),a(e,Tt,t),u(be,e,t),a(e,Jt,t),a(e,we,t),a(e,Ut,t),a(e,Te,t),kt=!0},p(e,[t]){const ls={};t&2&&(ls.$$scope={dirty:t,ctx:e}),j.$set(ls)},i(e){kt||(c(J.$$.fragment,e),c(U.$$.fragment,e),c(_.$$.fragment,e),c(B.$$.fragment,e),c(j.$$.fragment,e),c(C.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(K.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(ge.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),kt=!0)},o(e){d(J.$$.fragment,e),d(U.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(K.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),kt=!1},d(e){e&&(s(T),s(y),s(je),s(Ue),s(ke),s(k),s(Ze),s(Z),s(Ge),s(G),s(Ie),s(I),s(ve),s(v),s(_e),s(Be),s(We),s(W),s($e),s(b),s(Xe),s($),s(Ve),s(w),s(Re),s(X),s(xe),s(V),s(Ce),s(R),s(ze),s(He),s(x),s(Le),s(qe),s(z),s(Fe),s(H),s(Ne),s(L),s(Qe),s(q),s(Ee),s(Se),s(N),s(Ye),s(Q),s(Ae),s(Ke),s(S),s(De),s(Pe),s(A),s(Oe),s(et),s(D),s(tt),s(st),s(at),s(ee),s(lt),s(nt),s(it),s(ae),s(ot),s(pt),s(rt),s(ie),s(mt),s(ut),s(ct),s(re),s(dt),s(ht),s(gt),s(ce),s(Mt),s(yt),s(he),s(ft),s(bt),s(Me),s(wt),s(jt),s(fe),s(Tt),s(Jt),s(we),s(Ut),s(Te)),s(g),h(J,e),h(U,e),h(_,e),h(B,e),h(j,e),h(C,e),h(F,e),h(E,e),h(Y,e),h(K,e),h(P,e),h(O,e),h(te,e),h(se,e),h(le,e),h(ne,e),h(oe,e),h(pe,e),h(me,e),h(ue,e),h(de,e),h(ge,e),h(ye,e),h(be,e)}}}const ys='{"title":"Generation with LLMs","local":"generation-with-llms","sections":[{"title":"Generate text","local":"generate-text","sections":[],"depth":2},{"title":"Common pitfalls","local":"common-pitfalls","sections":[{"title":"Generated output is too short/long","local":"generated-output-is-too-shortlong","sections":[],"depth":3},{"title":"Incorrect generation mode","local":"incorrect-generation-mode","sections":[],"depth":3},{"title":"Wrong padding side","local":"wrong-padding-side","sections":[],"depth":3},{"title":"Wrong prompt","local":"wrong-prompt","sections":[],"depth":3}],"depth":2},{"title":"Further resources","local":"further-resources","sections":[{"title":"Advanced generate usage","local":"advanced-generate-usage","sections":[],"depth":3},{"title":"LLM leaderboards","local":"llm-leaderboards","sections":[],"depth":3},{"title":"Latency, throughput and memory utilization","local":"latency-throughput-and-memory-utilization","sections":[],"depth":3},{"title":"Related libraries","local":"related-libraries","sections":[],"depth":3}],"depth":2}],"depth":1}';function fs(Je){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ks extends rs{constructor(g){super(),ms(this,g,fs,Ms,is,{})}}export{ks as component};
