import{s as Ys,n as Hs,o as Xs}from"../chunks/scheduler.7bc62968.js";import{S as $s,i as Rs,g as M,s as a,r as j,m as tl,H as ys,A as Ls,h as i,f as e,c as t,j as Ml,u as w,x as p,n as il,B as cs,k as Ws,y as o,a as n,v as r,d as J,t as T,w as m}from"../chunks/index.2f8492b0.js";import{C as Ks}from"../chunks/CodeBlock.4e96d6f7.js";import{H as I,E as Fs}from"../chunks/EditOnGithub.2a9ce03a.js";function Ps(js){let U,yl,pl,cl,h,jl,C,ws="In this chapter we will go through a convolutional architecture called GoogleNet.",wl,b,rl,d,rs="The Inception architecture, a convolutional neural network (CNN) designed for tasks in computer vision such as classification and detection, stands out due to its efficiency. It contains fewer than 7 million parameters and is significantly more compact than its predecessors, being 9 times smaller than AlexNet and 22 times smaller than VGG16. This architecture gained recognition in the ImageNet 2014 challenge, where Google’s adaptation, named GoogLeNet (a tribute to LeNet), set new benchmarks in performance while utilizing fewer parameters compared to previous leading methods.",Jl,A,Tl,f,Js="Before the advent of the Inception architecture, models like AlexNet and VGG demonstrated the benefits of deeper network structures. However, deeper networks typically entail more computational steps and can lead to issues such as overfitting and the vanishing gradient problem. The Inception architecture offers a solution, enabling the training of complex CNNs with a reduced count of floating-point parameters.",ml,x,Ul,g,Ts="In prior networks, such as AlexNet or VGG, the fundamental block is the convolution layer itself. However, Lin et al. 2013, introduced the concept of Network In Network, arguing that a single convolution is not necessarily a correct fundamental building block. It ought to be more complex. So, inspired by that, the Inception model authors decided to have a more complex building block called the Inception Module, aptly named after the famous movie - “The Inception” (dream in dream).",ul,v,ms="The Inception Module insists on applying convolution filters of different kernel sizes for feature extraction at multiple scales. For any input feature map, it applies a $1 \\times 1$ convolution, a 3x3 convolution, and a 5x5 convolution in parallel. In addition to convolution a max pooling operation is also applied. All four operations have padding and stride in such a way as to have the same spatial dimension. These features are concatenated and form the input to the next stage. See Figure 1.",Il,k,Us='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/inception_naive.png" alt="inception_naive"/>',hl,B,us="Figure 1: Naive Inception Module",Cl,N,Is="As we can see applying multiple convolutions at multiple scales with bigger kernel sizes, like 5x5, can increase the number of parameters drastically. This problem is pronounced as the input feature size (channel size) increases. So as we go deep in the network stacking these “Inception Modules”, the computation will increase drastically. The simple solution is to reduce the number of features wherever computational requirements seem to increase. The major pain points of high computation are the convolution layers. The feature dimension is reduced by a computationally inexpensive $1 \\times 1$ convolution just before the 3x3 and 5x5 convolution. Let’s see it with an example.",bl,E,hs="We want to convert a feature map of (\\ S \\times S \\times 128 \\) to (\\ S \\times S \\times 256 \\) via a 5x5 convolution. The number of parameters (excluding biases) is 5<em>5</em>128*256 = 819,200. However, if we reduce the feature dimension first by a $1 \\times 1$ convolution to 64, then the number of parameters(excluding biases) is (\\ 1\\times 1\\times 128\\times 64 + 5\\times 5\\times 64\\times 256 = 8,192 + 409,600 = 417,792 \\). That means the number of parameters was reduced by almost half!",dl,Z,Cs="We would also want to reduce the output features of max pooling before concatenating with the output feature map. So, we add one more (\\ 1\\times 1 \\) convolution after the max-pooling layer. We also add a ReLU activation after each (\\ 1\\times 1 \\) convolution increasing non-linearity and complexity of the module. See Figure 2.",Al,Q,bs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/inception_reduced.png" alt="inception_reduced"/>',fl,G,ds="Figure 2: Inception Module",xl,z,As="Also, because of the parallel operations of convolutions at multiple scales, we are ensuring more operations without going deeper into the network, essentially mitigating the vanishing gradient problem.",gl,_,vl,W,fs="In prior networks, like AlexNet or VGG, the final layers would be a few fully connected layers. These fully connected layers, due to their large number of units would contribute to most of the parameters in a network. For example, 89% of the parameters of VGG16 are in the final three fully connected layers. 95% of parameters in AlexNet are in the final fully connected layers. This need can be attributed to the premise that a Convolutional layer is not necessarily complex enough.",kl,D,xs="However, with an Inception block at our disposal, we do not need fully connected layers and a simple average pooling along the spatial dimensions should be enough. This was also derived from the Network in Network paper. However, GoogLeNet included one fully connected layer. They reported an increase of 0.6% in top-1 accuracy.",Bl,S,gs="GoogLeNet has only 15% of the parameters in the fully connected layers.",Nl,V,El,u,ns,Zl,Ds='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>×</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> 1 \\times 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Ql,Gl,Y,vs="The paper introduces the auxiliary classifiers - branch out a few small classifiers from the layers in between and add the loss from these classifiers to the total loss(with less weightage). This ensures that the layers close to the input also receive gradients of decent magnitude.",zl,H,ks="The auxiliary classifier consists of",_l,y,X,as,Wl,Ss='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>5</mn><mo>×</mo><mn>5</mn></mrow><annotation encoding="application/x-tex"> 5 \\times 5 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">5</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">5</span></span></span></span>',Dl,ts,$,Ms,Sl,Vs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>×</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> 1 \\times 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Vl,is,el,Bs="A fully connected layer with 1024 units and rectified linear activation.",ps,nl,Ns="A dropout layer with 70% ratio of dropped outputs.",os,al,Es="A linear layer with softmax loss as the classifier.",Yl,R,Zs="These auxiliary classifiers are removed at inference time. However, minimal gains are achieved from using auxiliary classifiers (0.5%).",Hl,L,Qs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/googlenet_auxiliary_classifier.jpg" alt="googlenet_aux_clf"/>',Xl,K,Gs="Figure 3: An Auxiliary Classifier",$l,F,Rl,P,zs="The complete architecture of GoogLeNet is shown in Figure below. All convolutions, including inside the inception block, use ReLU activation. It starts with two convolution(s) and max-pooling blocks. This is followed by a block of two inception modules (3a and 3b) and a max pooling. This follows a block of 5 inception blocks (4a, 4b, 4c, 4d, 4e) and a max pooling after. The auxiliary classifiers are taken out from outputs of 4a and 4d. Two inception blocks follow (5a and 5b). After this, an average pooling and a fully connected layer of 128 units are used.",Ll,O,_s=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/googlenet_architecture.png" alt="googlenet_arch"/>
Figure 4: Complete GoogLeNet Architecture`,Kl,q,Fl,ll,Pl,sl,Ol,ol,ql;return h=new I({props:{title:"GoogLeNet",local:"googlenet",headingTag:"h1"}}),b=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new I({props:{title:"Architectural Innovations",local:"architectural-innovations",headingTag:"h3"}}),x=new I({props:{title:"The Inception “Network In Network” Module",local:"the-inception-network-in-network-module",headingTag:"h4"}}),_=new I({props:{title:"Average Pooling",local:"average-pooling",headingTag:"h4"}}),V=new I({props:{title:"Auxiliary Classifiers",local:"auxiliary-classifiers",headingTag:"h4"}}),F=new I({props:{title:"Architecture - GoogLeNet",local:"architecture---googlenet",headingTag:"h3"}}),q=new I({props:{title:"Code",local:"code",headingTag:"h3"}}),ll=new Ks({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEElMEFjbGFzcyUyMEJhc2VDb252MmQobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbl9jaGFubmVscyUyQyUyMG91dF9jaGFubmVscyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKEJhc2VDb252MmQlMkMlMjBzZWxmKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5jb252JTIwJTNEJTIwbm4uQ29udjJkKGluX2NoYW5uZWxzJTJDJTIwb3V0X2NoYW5uZWxzJTJDJTIwKiprd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWx1JTIwJTNEJTIwbm4uUmVMVSgpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5jb252KHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYucmVsdSh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFjbGFzcyUyMEluY2VwdGlvbk1vZHVsZShubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGluX2NoYW5uZWxzJTJDJTIwbjF4MSUyQyUyMG4zeDNyZWQlMkMlMjBuM3gzJTJDJTIwbjV4NXJlZCUyQyUyMG41eDUlMkMlMjBwb29sX3Byb2opJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoSW5jZXB0aW9uTW9kdWxlJTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYjElMjAlM0QlMjBCYXNlQ29udjJkKGluX2NoYW5uZWxzJTJDJTIwbjF4MSUyQyUyMGtlcm5lbF9zaXplJTNEMSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmIyJTIwJTNEJTIwbm4uU2VxdWVudGlhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBCYXNlQ29udjJkKGluX2NoYW5uZWxzJTJDJTIwbjN4M3JlZCUyQyUyMGtlcm5lbF9zaXplJTNEMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBCYXNlQ29udjJkKG4zeDNyZWQlMkMlMjBuM3gzJTJDJTIwa2VybmVsX3NpemUlM0QzJTJDJTIwcGFkZGluZyUzRDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYjMlMjAlM0QlMjBubi5TZXF1ZW50aWFsKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEJhc2VDb252MmQoaW5fY2hhbm5lbHMlMkMlMjBuNXg1cmVkJTJDJTIwa2VybmVsX3NpemUlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEJhc2VDb252MmQobjV4NXJlZCUyQyUyMG41eDUlMkMlMjBrZXJuZWxfc2l6ZSUzRDUlMkMlMjBwYWRkaW5nJTNEMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iNCUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTWF4UG9vbDJkKDMlMkMlMjBzdHJpZGUlM0QxJTJDJTIwcGFkZGluZyUzRDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFzZUNvbnYyZChpbl9jaGFubmVscyUyQyUyMHBvb2xfcHJvaiUyQyUyMGtlcm5lbF9zaXplJTNEMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5MSUyMCUzRCUyMHNlbGYuYjEoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5MiUyMCUzRCUyMHNlbGYuYjIoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5MyUyMCUzRCUyMHNlbGYuYjMoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5NCUyMCUzRCUyMHNlbGYuYjQoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB0b3JjaC5jYXQoJTVCeTElMkMlMjB5MiUyQyUyMHkzJTJDJTIweTQlNUQlMkMlMjAxKSUwQSUwQSUwQWNsYXNzJTIwQXV4aWxpYXJ5Q2xhc3NpZmllcihubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGluX2NoYW5uZWxzJTJDJTIwbnVtX2NsYXNzZXMlMkMlMjBkcm9wb3V0JTNEMC43KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKEF1eGlsaWFyeUNsYXNzaWZpZXIlMkMlMjBzZWxmKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wb29sJTIwJTNEJTIwbm4uQXZnUG9vbDJkKDUlMkMlMjBzdHJpZGUlM0QzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29udiUyMCUzRCUyMEJhc2VDb252MmQoaW5fY2hhbm5lbHMlMkMlMjAxMjglMkMlMjBrZXJuZWxfc2l6ZSUzRDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWx1JTIwJTNEJTIwbm4uUmVMVShUcnVlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmxhdHRlbiUyMCUzRCUyMG5uLkZsYXR0ZW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKDIwNDglMkMlMjAxMDI0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZHJvcG91dCUyMCUzRCUyMG5uLkRyb3BvdXQoZHJvcG91dCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcigxMDI0JTJDJTIwbnVtX2NsYXNzZXMpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5wb29sKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuY29udih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZsYXR0ZW4oeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5mYzEoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5yZWx1KHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuZHJvcG91dCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjMih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFjbGFzcyUyMEdvb2dMZU5ldChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVzZV9hdXglM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKEdvb2dMZU5ldCUyQyUyMHNlbGYpLl9faW5pdF9fKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnVzZV9hdXglMjAlM0QlMjB1c2VfYXV4JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwYmxvY2slMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5jb252MSUyMCUzRCUyMEJhc2VDb252MmQoMyUyQyUyMDY0JTJDJTIwa2VybmVsX3NpemUlM0Q3JTJDJTIwc3RyaWRlJTNEMiUyQyUyMHBhZGRpbmclM0QzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubHJuMSUyMCUzRCUyMG5uLkxvY2FsUmVzcG9uc2VOb3JtKDUlMkMlMjBhbHBoYSUzRDAuMDAwMSUyQyUyMGJldGElM0QwLjc1KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubWF4cG9vbDElMjAlM0QlMjBubi5NYXhQb29sMmQoMyUyQyUyMHN0cmlkZSUzRDIlMkMlMjBwYWRkaW5nJTNEMSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjBibG9jayUyMDIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbnYyJTIwJTNEJTIwQmFzZUNvbnYyZCg2NCUyQyUyMDY0JTJDJTIwa2VybmVsX3NpemUlM0QxKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29udjMlMjAlM0QlMjBCYXNlQ29udjJkKDY0JTJDJTIwMTkyJTJDJTIwa2VybmVsX3NpemUlM0QzJTJDJTIwcGFkZGluZyUzRDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5scm4yJTIwJTNEJTIwbm4uTG9jYWxSZXNwb25zZU5vcm0oNSUyQyUyMGFscGhhJTNEMC4wMDAxJTJDJTIwYmV0YSUzRDAuNzUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tYXhwb29sMiUyMCUzRCUyMG5uLk1heFBvb2wyZCgzJTJDJTIwc3RyaWRlJTNEMiUyQyUyMHBhZGRpbmclM0QxKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMyUyMGJsb2NrJTIwMyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5jZXB0aW9uM2ElMjAlM0QlMjBJbmNlcHRpb25Nb2R1bGUoMTkyJTJDJTIwNjQlMkMlMjA5NiUyQyUyMDEyOCUyQyUyMDE2JTJDJTIwMzIlMkMlMjAzMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluY2VwdGlvbjNiJTIwJTNEJTIwSW5jZXB0aW9uTW9kdWxlKDI1NiUyQyUyMDEyOCUyQyUyMDEyOCUyQyUyMDE5MiUyQyUyMDMyJTJDJTIwOTYlMkMlMjA2NCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1heHBvb2wzJTIwJTNEJTIwbm4uTWF4UG9vbDJkKDMlMkMlMjBzdHJpZGUlM0QyJTJDJTIwcGFkZGluZyUzRDEpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwYmxvY2slMjA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbmNlcHRpb240YSUyMCUzRCUyMEluY2VwdGlvbk1vZHVsZSg0ODAlMkMlMjAxOTIlMkMlMjA5NiUyQyUyMDIwOCUyQyUyMDE2JTJDJTIwNDglMkMlMjA2NCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluY2VwdGlvbjRiJTIwJTNEJTIwSW5jZXB0aW9uTW9kdWxlKDUxMiUyQyUyMDE2MCUyQyUyMDExMiUyQyUyMDIyNCUyQyUyMDI0JTJDJTIwNjQlMkMlMjA2NCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluY2VwdGlvbjRjJTIwJTNEJTIwSW5jZXB0aW9uTW9kdWxlKDUxMiUyQyUyMDEyOCUyQyUyMDEyOCUyQyUyMDI1NiUyQyUyMDI0JTJDJTIwNjQlMkMlMjA2NCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluY2VwdGlvbjRkJTIwJTNEJTIwSW5jZXB0aW9uTW9kdWxlKDUxMiUyQyUyMDExMiUyQyUyMDE0NCUyQyUyMDI4OCUyQyUyMDMyJTJDJTIwNjQlMkMlMjA2NCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluY2VwdGlvbjRlJTIwJTNEJTIwSW5jZXB0aW9uTW9kdWxlKDUyOCUyQyUyMDI1NiUyQyUyMDE2MCUyQyUyMDMyMCUyQyUyMDMyJTJDJTIwMTI4JTJDJTIwMTI4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubWF4cG9vbDQlMjAlM0QlMjBubi5NYXhQb29sMmQoMyUyQyUyMHN0cmlkZSUzRDIlMkMlMjBwYWRkaW5nJTNEMSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjBibG9jayUyMDUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluY2VwdGlvbjVhJTIwJTNEJTIwSW5jZXB0aW9uTW9kdWxlKDgzMiUyQyUyMDI1NiUyQyUyMDE2MCUyQyUyMDMyMCUyQyUyMDMyJTJDJTIwMTI4JTJDJTIwMTI4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5jZXB0aW9uNWIlMjAlM0QlMjBJbmNlcHRpb25Nb2R1bGUoODMyJTJDJTIwMzg0JTJDJTIwMTkyJTJDJTIwMzg0JTJDJTIwNDglMkMlMjAxMjglMkMlMjAxMjgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwYXV4aWxpYXJ5JTIwY2xhc3NpZmllciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi51c2VfYXV4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5hdXgxJTIwJTNEJTIwQXV4aWxpYXJ5Q2xhc3NpZmllcig1MTIlMkMlMjAxMDAwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYXV4MiUyMCUzRCUyMEF1eGlsaWFyeUNsYXNzaWZpZXIoNTI4JTJDJTIwMTAwMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjBibG9jayUyMDYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmF2Z3Bvb2wlMjAlM0QlMjBubi5BdmdQb29sMmQoNyUyQyUyMHN0cmlkZSUzRDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kcm9wb3V0JTIwJTNEJTIwbm4uRHJvcG91dCgwLjQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5mYyUyMCUzRCUyMG5uLkxpbmVhcigxMDI0JTJDJTIwMTAwMCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMyUyMGJsb2NrJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmNvbnYxKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubWF4cG9vbDEoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5scm4xKHgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwYmxvY2slMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuY29udjIoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5jb252Myh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmxybjIoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5tYXhwb29sMih4KSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMyUyMGJsb2NrJTIwMyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmluY2VwdGlvbjNhKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuaW5jZXB0aW9uM2IoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5tYXhwb29sMyh4KSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMyUyMGJsb2NrJTIwNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmluY2VwdGlvbjRhKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLnVzZV9hdXglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdXgxJTIwJTNEJTIwc2VsZi5hdXgxKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuaW5jZXB0aW9uNGIoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5pbmNlcHRpb240Yyh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmluY2VwdGlvbjRkKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLnVzZV9hdXglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdXgyJTIwJTNEJTIwc2VsZi5hdXgyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuaW5jZXB0aW9uNGUoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5tYXhwb29sNCh4KSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMyUyMGJsb2NrJTIwNSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmluY2VwdGlvbjVhKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuaW5jZXB0aW9uNWIoeCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjBibG9jayUyMDYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5hdmdwb29sKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHRvcmNoLmZsYXR0ZW4oeCUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuZHJvcG91dCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjKHgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLnVzZV9hdXglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB4JTJDJTIwYXV4MSUyQyUyMGF1eDIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">BaseConv2d</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, out_channels, **kwargs</span>):
        <span class="hljs-built_in">super</span>(BaseConv2d, self).__init__()
        self.conv = nn.Conv2d(in_channels, out_channels, **kwargs)
        self.relu = nn.ReLU()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.conv(x)
        x = self.relu(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">InceptionModule</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, n1x1, n3x3red, n3x3, n5x5red, n5x5, pool_proj</span>):
        <span class="hljs-built_in">super</span>(InceptionModule, self).__init__()

        self.b1 = BaseConv2d(in_channels, n1x1, kernel_size=<span class="hljs-number">1</span>)

        self.b2 = nn.Sequential(
            BaseConv2d(in_channels, n3x3red, kernel_size=<span class="hljs-number">1</span>),
            BaseConv2d(n3x3red, n3x3, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
        )

        self.b3 = nn.Sequential(
            BaseConv2d(in_channels, n5x5red, kernel_size=<span class="hljs-number">1</span>),
            BaseConv2d(n5x5red, n5x5, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
        )

        self.b4 = nn.Sequential(
            nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">1</span>, padding=<span class="hljs-number">1</span>),
            BaseConv2d(in_channels, pool_proj, kernel_size=<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        y1 = self.b1(x)
        y2 = self.b2(x)
        y3 = self.b3(x)
        y4 = self.b4(x)
        <span class="hljs-keyword">return</span> torch.cat([y1, y2, y3, y4], <span class="hljs-number">1</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">AuxiliaryClassifier</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, num_classes, dropout=<span class="hljs-number">0.7</span></span>):
        <span class="hljs-built_in">super</span>(AuxiliaryClassifier, self).__init__()
        self.pool = nn.AvgPool2d(<span class="hljs-number">5</span>, stride=<span class="hljs-number">3</span>)
        self.conv = BaseConv2d(in_channels, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">1</span>)
        self.relu = nn.ReLU(<span class="hljs-literal">True</span>)
        self.flatten = nn.Flatten()
        self.fc1 = nn.Linear(<span class="hljs-number">2048</span>, <span class="hljs-number">1024</span>)
        self.dropout = nn.Dropout(dropout)
        self.fc2 = nn.Linear(<span class="hljs-number">1024</span>, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.pool(x)
        x = self.conv(x)
        x = self.flatten(x)
        x = self.fc1(x)
        x = self.relu(x)
        x = self.dropout(x)
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">GoogLeNet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, use_aux=<span class="hljs-literal">True</span></span>):
        <span class="hljs-built_in">super</span>(GoogLeNet, self).__init__()

        self.use_aux = use_aux
        <span class="hljs-comment">## block 1</span>
        self.conv1 = BaseConv2d(<span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">7</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">3</span>)
        self.lrn1 = nn.LocalResponseNorm(<span class="hljs-number">5</span>, alpha=<span class="hljs-number">0.0001</span>, beta=<span class="hljs-number">0.75</span>)
        self.maxpool1 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 2</span>
        self.conv2 = BaseConv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">1</span>)
        self.conv3 = BaseConv2d(<span class="hljs-number">64</span>, <span class="hljs-number">192</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>)
        self.lrn2 = nn.LocalResponseNorm(<span class="hljs-number">5</span>, alpha=<span class="hljs-number">0.0001</span>, beta=<span class="hljs-number">0.75</span>)
        self.maxpool2 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 3</span>
        self.inception3a = InceptionModule(<span class="hljs-number">192</span>, <span class="hljs-number">64</span>, <span class="hljs-number">96</span>, <span class="hljs-number">128</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>)
        self.inception3b = InceptionModule(<span class="hljs-number">256</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">192</span>, <span class="hljs-number">32</span>, <span class="hljs-number">96</span>, <span class="hljs-number">64</span>)
        self.maxpool3 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 4</span>
        self.inception4a = InceptionModule(<span class="hljs-number">480</span>, <span class="hljs-number">192</span>, <span class="hljs-number">96</span>, <span class="hljs-number">208</span>, <span class="hljs-number">16</span>, <span class="hljs-number">48</span>, <span class="hljs-number">64</span>)
        self.inception4b = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">160</span>, <span class="hljs-number">112</span>, <span class="hljs-number">224</span>, <span class="hljs-number">24</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4c = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">24</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4d = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">112</span>, <span class="hljs-number">144</span>, <span class="hljs-number">288</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4e = InceptionModule(<span class="hljs-number">528</span>, <span class="hljs-number">256</span>, <span class="hljs-number">160</span>, <span class="hljs-number">320</span>, <span class="hljs-number">32</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)
        self.maxpool4 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 5</span>
        self.inception5a = InceptionModule(<span class="hljs-number">832</span>, <span class="hljs-number">256</span>, <span class="hljs-number">160</span>, <span class="hljs-number">320</span>, <span class="hljs-number">32</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)
        self.inception5b = InceptionModule(<span class="hljs-number">832</span>, <span class="hljs-number">384</span>, <span class="hljs-number">192</span>, <span class="hljs-number">384</span>, <span class="hljs-number">48</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)

        <span class="hljs-comment">## auxiliary classifier</span>
        <span class="hljs-keyword">if</span> self.use_aux:
            self.aux1 = AuxiliaryClassifier(<span class="hljs-number">512</span>, <span class="hljs-number">1000</span>)
            self.aux2 = AuxiliaryClassifier(<span class="hljs-number">528</span>, <span class="hljs-number">1000</span>)

        <span class="hljs-comment">## block 6</span>
        self.avgpool = nn.AvgPool2d(<span class="hljs-number">7</span>, stride=<span class="hljs-number">1</span>)
        self.dropout = nn.Dropout(<span class="hljs-number">0.4</span>)
        self.fc = nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">1000</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment">## block 1</span>
        x = self.conv1(x)
        x = self.maxpool1(x)
        x = self.lrn1(x)

        <span class="hljs-comment">## block 2</span>
        x = self.conv2(x)
        x = self.conv3(x)
        x = self.lrn2(x)
        x = self.maxpool2(x)

        <span class="hljs-comment">## block 3</span>
        x = self.inception3a(x)
        x = self.inception3b(x)
        x = self.maxpool3(x)

        <span class="hljs-comment">## block 4</span>
        x = self.inception4a(x)
        <span class="hljs-keyword">if</span> self.use_aux:
            aux1 = self.aux1(x)
        x = self.inception4b(x)
        x = self.inception4c(x)
        x = self.inception4d(x)
        <span class="hljs-keyword">if</span> self.use_aux:
            aux2 = self.aux2(x)
        x = self.inception4e(x)
        x = self.maxpool4(x)

        <span class="hljs-comment">## block 5</span>
        x = self.inception5a(x)
        x = self.inception5b(x)

        <span class="hljs-comment">## block 6</span>
        x = self.avgpool(x)
        x = torch.flatten(x, <span class="hljs-number">1</span>)
        x = self.dropout(x)
        x = self.fc(x)

        <span class="hljs-keyword">if</span> self.use_aux:
            <span class="hljs-keyword">return</span> x, aux1, aux2
        <span class="hljs-keyword">else</span>:
            <span class="hljs-keyword">return</span> x`,wrap:!1}}),sl=new Fs({props:{source:"https://github.com/johko/computer-vision-course/blob/main/chapters/en/unit2/cnns/googlenet.mdx"}}),{c(){U=M("meta"),yl=a(),pl=M("p"),cl=a(),j(h.$$.fragment),jl=a(),C=M("p"),C.textContent=ws,wl=a(),j(b.$$.fragment),rl=a(),d=M("p"),d.textContent=rs,Jl=a(),j(A.$$.fragment),Tl=a(),f=M("p"),f.textContent=Js,ml=a(),j(x.$$.fragment),Ul=a(),g=M("p"),g.textContent=Ts,ul=a(),v=M("p"),v.textContent=ms,Il=a(),k=M("p"),k.innerHTML=Us,hl=a(),B=M("p"),B.textContent=us,Cl=a(),N=M("p"),N.textContent=Is,bl=a(),E=M("p"),E.innerHTML=hs,dl=a(),Z=M("p"),Z.textContent=Cs,Al=a(),Q=M("p"),Q.innerHTML=bs,fl=a(),G=M("p"),G.textContent=ds,xl=a(),z=M("p"),z.textContent=As,gl=a(),j(_.$$.fragment),vl=a(),W=M("p"),W.textContent=fs,kl=a(),D=M("p"),D.textContent=xs,Bl=a(),S=M("p"),S.textContent=gs,Nl=a(),j(V.$$.fragment),El=a(),u=M("p"),ns=tl("With the introduction of compute saving"),Zl=new ys(!1),Ql=tl(" convolution and the replacement of multiple fully connected layers with average pooling, the parameters of this network are reduced significantly, which means we can add more layers and go deeper into the network. However, stacking layers can cause the problem of vanishing gradient, where the gradients get smaller and close to zero while propagating back to the initial layers of the network."),Gl=a(),Y=M("p"),Y.textContent=vs,zl=a(),H=M("p"),H.textContent=ks,_l=a(),y=M("ul"),X=M("li"),as=tl("An average pooling layer with"),Wl=new ys(!1),Dl=tl(" filter size and stride 3."),ts=a(),$=M("li"),Ms=tl("A"),Sl=new ys(!1),Vl=tl(" convolution with 128 filters for dimension reduction and rectified linear activation."),is=a(),el=M("li"),el.textContent=Bs,ps=a(),nl=M("li"),nl.textContent=Ns,os=a(),al=M("li"),al.textContent=Es,Yl=a(),R=M("p"),R.textContent=Zs,Hl=a(),L=M("p"),L.innerHTML=Qs,Xl=a(),K=M("p"),K.textContent=Gs,$l=a(),j(F.$$.fragment),Rl=a(),P=M("p"),P.textContent=zs,Ll=a(),O=M("p"),O.innerHTML=_s,Kl=a(),j(q.$$.fragment),Fl=a(),j(ll.$$.fragment),Pl=a(),j(sl.$$.fragment),Ol=a(),ol=M("p"),this.h()},l(l){const s=Ls("svelte-u9bgzb",document.head);U=i(s,"META",{name:!0,content:!0}),s.forEach(e),yl=t(l),pl=i(l,"P",{}),Ml(pl).forEach(e),cl=t(l),w(h.$$.fragment,l),jl=t(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-xslj5l"&&(C.textContent=ws),wl=t(l),w(b.$$.fragment,l),rl=t(l),d=i(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-a1s7z3"&&(d.textContent=rs),Jl=t(l),w(A.$$.fragment,l),Tl=t(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1v203bk"&&(f.textContent=Js),ml=t(l),w(x.$$.fragment,l),Ul=t(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-z24t8v"&&(g.textContent=Ts),ul=t(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-7ihfvy"&&(v.textContent=ms),Il=t(l),k=i(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-o31koc"&&(k.innerHTML=Us),hl=t(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-16ratth"&&(B.textContent=us),Cl=t(l),N=i(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1sqb65w"&&(N.textContent=Is),bl=t(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-12r3jjo"&&(E.innerHTML=hs),dl=t(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-snbukh"&&(Z.textContent=Cs),Al=t(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-hswu6s"&&(Q.innerHTML=bs),fl=t(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-10lkpf"&&(G.textContent=ds),xl=t(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-tdwvb3"&&(z.textContent=As),gl=t(l),w(_.$$.fragment,l),vl=t(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1qbnxjr"&&(W.textContent=fs),kl=t(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-12625s8"&&(D.textContent=xs),Bl=t(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-18qz3gm"&&(S.textContent=gs),Nl=t(l),w(V.$$.fragment,l),El=t(l),u=i(l,"P",{});var ls=Ml(u);ns=il(ls,"With the introduction of compute saving"),Zl=cs(ls,!1),Ql=il(ls," convolution and the replacement of multiple fully connected layers with average pooling, the parameters of this network are reduced significantly, which means we can add more layers and go deeper into the network. However, stacking layers can cause the problem of vanishing gradient, where the gradients get smaller and close to zero while propagating back to the initial layers of the network."),ls.forEach(e),Gl=t(l),Y=i(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-76pfk2"&&(Y.textContent=vs),zl=t(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-meutr"&&(H.textContent=ks),_l=t(l),y=i(l,"UL",{});var c=Ml(y);X=i(c,"LI",{});var ss=Ml(X);as=il(ss,"An average pooling layer with"),Wl=cs(ss,!1),Dl=il(ss," filter size and stride 3."),ss.forEach(e),ts=t(c),$=i(c,"LI",{});var es=Ml($);Ms=il(es,"A"),Sl=cs(es,!1),Vl=il(es," convolution with 128 filters for dimension reduction and rectified linear activation."),es.forEach(e),is=t(c),el=i(c,"LI",{"data-svelte-h":!0}),p(el)!=="svelte-1n9c038"&&(el.textContent=Bs),ps=t(c),nl=i(c,"LI",{"data-svelte-h":!0}),p(nl)!=="svelte-tksu1v"&&(nl.textContent=Ns),os=t(c),al=i(c,"LI",{"data-svelte-h":!0}),p(al)!=="svelte-i097ho"&&(al.textContent=Es),c.forEach(e),Yl=t(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-4uto13"&&(R.textContent=Zs),Hl=t(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1low2wu"&&(L.innerHTML=Qs),Xl=t(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-5sbbdp"&&(K.textContent=Gs),$l=t(l),w(F.$$.fragment,l),Rl=t(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1e43aaq"&&(P.textContent=zs),Ll=t(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1rdgdjr"&&(O.innerHTML=_s),Kl=t(l),w(q.$$.fragment,l),Fl=t(l),w(ll.$$.fragment,l),Pl=t(l),w(sl.$$.fragment,l),Ol=t(l),ol=i(l,"P",{}),Ml(ol).forEach(e),this.h()},h(){Ws(U,"name","hf:doc:metadata"),Ws(U,"content",Os),Zl.a=Ql,Wl.a=Dl,Sl.a=Vl},m(l,s){o(document.head,U),n(l,yl,s),n(l,pl,s),n(l,cl,s),r(h,l,s),n(l,jl,s),n(l,C,s),n(l,wl,s),r(b,l,s),n(l,rl,s),n(l,d,s),n(l,Jl,s),r(A,l,s),n(l,Tl,s),n(l,f,s),n(l,ml,s),r(x,l,s),n(l,Ul,s),n(l,g,s),n(l,ul,s),n(l,v,s),n(l,Il,s),n(l,k,s),n(l,hl,s),n(l,B,s),n(l,Cl,s),n(l,N,s),n(l,bl,s),n(l,E,s),n(l,dl,s),n(l,Z,s),n(l,Al,s),n(l,Q,s),n(l,fl,s),n(l,G,s),n(l,xl,s),n(l,z,s),n(l,gl,s),r(_,l,s),n(l,vl,s),n(l,W,s),n(l,kl,s),n(l,D,s),n(l,Bl,s),n(l,S,s),n(l,Nl,s),r(V,l,s),n(l,El,s),n(l,u,s),o(u,ns),Zl.m(Ds,u),o(u,Ql),n(l,Gl,s),n(l,Y,s),n(l,zl,s),n(l,H,s),n(l,_l,s),n(l,y,s),o(y,X),o(X,as),Wl.m(Ss,X),o(X,Dl),o(y,ts),o(y,$),o($,Ms),Sl.m(Vs,$),o($,Vl),o(y,is),o(y,el),o(y,ps),o(y,nl),o(y,os),o(y,al),n(l,Yl,s),n(l,R,s),n(l,Hl,s),n(l,L,s),n(l,Xl,s),n(l,K,s),n(l,$l,s),r(F,l,s),n(l,Rl,s),n(l,P,s),n(l,Ll,s),n(l,O,s),n(l,Kl,s),r(q,l,s),n(l,Fl,s),r(ll,l,s),n(l,Pl,s),r(sl,l,s),n(l,Ol,s),n(l,ol,s),ql=!0},p:Hs,i(l){ql||(J(h.$$.fragment,l),J(b.$$.fragment,l),J(A.$$.fragment,l),J(x.$$.fragment,l),J(_.$$.fragment,l),J(V.$$.fragment,l),J(F.$$.fragment,l),J(q.$$.fragment,l),J(ll.$$.fragment,l),J(sl.$$.fragment,l),ql=!0)},o(l){T(h.$$.fragment,l),T(b.$$.fragment,l),T(A.$$.fragment,l),T(x.$$.fragment,l),T(_.$$.fragment,l),T(V.$$.fragment,l),T(F.$$.fragment,l),T(q.$$.fragment,l),T(ll.$$.fragment,l),T(sl.$$.fragment,l),ql=!1},d(l){l&&(e(yl),e(pl),e(cl),e(jl),e(C),e(wl),e(rl),e(d),e(Jl),e(Tl),e(f),e(ml),e(Ul),e(g),e(ul),e(v),e(Il),e(k),e(hl),e(B),e(Cl),e(N),e(bl),e(E),e(dl),e(Z),e(Al),e(Q),e(fl),e(G),e(xl),e(z),e(gl),e(vl),e(W),e(kl),e(D),e(Bl),e(S),e(Nl),e(El),e(u),e(Gl),e(Y),e(zl),e(H),e(_l),e(y),e(Yl),e(R),e(Hl),e(L),e(Xl),e(K),e($l),e(Rl),e(P),e(Ll),e(O),e(Kl),e(Fl),e(Pl),e(Ol),e(ol)),e(U),m(h,l),m(b,l),m(A,l),m(x,l),m(_,l),m(V,l),m(F,l),m(q,l),m(ll,l),m(sl,l)}}}const Os='{"title":"GoogLeNet","local":"googlenet","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Architectural Innovations","local":"architectural-innovations","sections":[{"title":"The Inception “Network In Network” Module","local":"the-inception-network-in-network-module","sections":[],"depth":4},{"title":"Average Pooling","local":"average-pooling","sections":[],"depth":4},{"title":"Auxiliary Classifiers","local":"auxiliary-classifiers","sections":[],"depth":4}],"depth":3},{"title":"Architecture - GoogLeNet","local":"architecture---googlenet","sections":[],"depth":3},{"title":"Code","local":"code","sections":[],"depth":3}],"depth":2}],"depth":1}';function qs(js){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ae extends $s{constructor(U){super(),Rs(this,U,qs,Ps,Ys,{})}}export{ae as component};
