import{s as cs,f as Tt,n as ms,o as us}from"../chunks/scheduler.389d799c.js";import{S as js,i as Ts,g as M,s as a,r as p,A as ws,h as o,f as t,c as n,j as Ne,u as r,x as i,k as u,y as Us,a as s,v as y,d,t as c,w as m}from"../chunks/index.8f81d18f.js";import{C as j}from"../chunks/CodeBlock.3845caa1.js";import{H as h}from"../chunks/Heading.41733039.js";function Js(wt){let J,Ye,xe,Fe,b,Qe,C,Ut="Deploying a 🤗 Transformers models in SageMaker for inference is as easy as:",Le,g,qe,Z,Jt='This guide will show you how to deploy models with zero-code using the <a href="https://github.com/aws/sagemaker-huggingface-inference-toolkit" rel="nofollow">Inference Toolkit</a>. The Inference Toolkit builds on top of the <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow"><code>pipeline</code> feature</a> from 🤗 Transformers. Learn how to:',Pe,B,ht='<li><a href="#installation-and-setup">Install and setup the Inference Toolkit</a>.</li> <li><a href="#deploy-a-transformer-model-trained-in-sagemaker">Deploy a 🤗 Transformers model trained in SageMaker</a>.</li> <li><a href="#deploy-a-model-from-the-hub">Deploy a 🤗 Transformers model from the Hugging Face [model Hub](https://huggingface.co/models)</a>.</li> <li><a href="#run-batch-transform-with-transformers-and-sagemaker">Run a Batch Transform Job using 🤗 Transformers and Amazon SageMaker</a>.</li> <li><a href="#user-defined-code-and-modules">Create a custom inference module</a>.</li>',De,A,Ke,k,ft='Before deploying a 🤗 Transformers model to SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',Oe,W,It="Once you have an AWS account, get started using one of the following:",el,G,bt='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',ll,v,Ct='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',tl,H,gt="Upgrade to the latest <code>sagemaker</code> version.",sl,_,al,$,Zt="<strong>SageMaker environment</strong>",nl,S,Bt="Setup your SageMaker environment as shown below:",Ml,R,ol,z,At="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",il,V,kt="<strong>Local environment</strong>",pl,E,Wt="Setup your local environment as shown below:",rl,x,yl,X,dl,T,Gt,cl,N,vt="There are two ways to deploy your Hugging Face model trained in SageMaker:",ml,Y,Ht="<li>Deploy it after your training has finished.</li> <li>Deploy your saved model at a later time from S3 with the <code>model_data</code>.</li>",ul,F,_t='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/10_deploy_model_from_s3/deploy_transformer_model_from_s3.ipynb" rel="nofollow">deploy_transformer_model_from_s3.ipynb notebook</a> for an example of how to deploy a model from S3 to SageMaker for inference.',jl,Q,Tl,L,$t="To deploy your model directly after training, ensure all required files are saved in your training script, including the tokenizer and the model.",wl,q,St="If you use the Hugging Face <code>Trainer</code>, you can pass your tokenizer as an argument to the <code>Trainer</code>. It will be automatically saved when you call <code>trainer.save_model()</code>.",Ul,P,Jl,D,Rt="After you run your request you can delete the endpoint as shown:",hl,K,fl,O,Il,ee,zt="If you’ve already trained your model and want to deploy it at a later time, use the <code>model_data</code> argument to specify the location of your tokenizer and model weights.",bl,le,Cl,te,Vt="After you run our request, you can delete the endpoint again with:",gl,se,Zl,ae,Bl,ne,Et="For later deployment, you can create a <code>model.tar.gz</code> file that contains all the required files, such as:",Al,Me,xt="<li><code>pytorch_model.bin</code></li> <li><code>tf_model.h5</code></li> <li><code>tokenizer.json</code></li> <li><code>tokenizer_config.json</code></li>",kl,oe,Xt="For example, your file should look like this:",Wl,ie,Gl,pe,Nt="Create your own <code>model.tar.gz</code> from a model from the 🤗 Hub:",vl,re,Yt="<li>Download a model:</li>",Hl,ye,_l,f,Ft="<li>Create a <code>tar</code> file:</li>",$l,de,Sl,I,Qt="<li>Upload <code>model.tar.gz</code> to S3:</li>",Rl,ce,zl,me,Lt="Now you can provide the S3 URI to the <code>model_data</code> argument to deploy your model later.",Vl,ue,El,w,qt,xl,je,Pt="To deploy a model directly from the 🤗 Hub to SageMaker, define two environment variables when you create a <code>HuggingFaceModel</code>:",Xl,Te,Dt='<li><code>HF_MODEL_ID</code> defines the model ID which is automatically loaded from <a href="http://huggingface.co/models" rel="nofollow">huggingface.co/models</a> when you create a SageMaker endpoint. Access 10,000+ models on he 🤗 Hub through this environment variable.</li> <li><code>HF_TASK</code> defines the task for the 🤗 Transformers <code>pipeline</code>. A complete list of tasks can be found <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a>.</li>',Nl,we,Yl,Ue,Kt="After you run our request, you can delete the endpoint again with:",Fl,Je,Ql,he,Ot='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/11_deploy_model_from_hf_hub/deploy_transformer_model_from_hf_hub.ipynb" rel="nofollow">deploy_transformer_model_from_hf_hub.ipynb notebook</a> for an example of how to deploy a model from the 🤗 Hub to SageMaker for inference.',Ll,fe,ql,U,es,Pl,Ie,ls='After training a model, you can use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-batch.html" rel="nofollow">SageMaker batch transform</a> to perform inference with the model. Batch transform accepts your inference data as an S3 URI  and then SageMaker will take care of downloading the data, running the prediction, and uploading the results to S3. For more details about batch transform, take a look <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html" rel="nofollow">here</a>.',Dl,be,ts="⚠️ The Hugging Face Inference DLC currently only supports <code>.jsonl</code> for batch transform due to the complex structure of textual data.",Kl,Ce,ss="<em>Note: Make sure your <code>inputs</code> fit the <code>max_length</code> of the model during preprocessing.</em>",Ol,ge,as='If you trained a model using the Hugging Face Estimator, call the <code>transformer()</code> method to create a transform job for a model based on the training job (see <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#sagemaker-batch-transform" rel="nofollow">here</a> for more details):',et,Ze,lt,Be,ns="If you want to run your batch transform job later or with a model from the 🤗 Hub, create a <code>HuggingFaceModel</code> instance and then call the <code>transformer()</code> method:",tt,Ae,st,ke,Ms="The <code>input.jsonl</code> looks like this:",at,We,nt,Ge,os='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/12_batch_transform_inference/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run a batch transform job for inference.',Mt,ve,ot,He,is='The Hugging Face Inference Toolkit allows the user to override the default methods of the <code>HuggingFaceHandlerService</code>. You will need to create a folder named <code>code/</code> with an <code>inference.py</code> file in it. See <a href="#create-a-model-artifact-for-deployment">here</a> for more details on how to archive your model artifacts. For example:',it,_e,pt,$e,ps="The <code>inference.py</code> file contains your custom inference module, and the <code>requirements.txt</code> file contains additional dependencies that should be added. The custom module can override the following methods:",rt,Se,rs="<li><code>model_fn(model_dir)</code> overrides the default method for loading a model. The return value <code>model</code> will be used in <code>predict</code> for predictions. <code>predict</code> receives argument the <code>model_dir</code>, the path to your unzipped <code>model.tar.gz</code>.</li> <li><code>transform_fn(model, data, content_type, accept_type)</code> overrides the default transform function with your custom implementation. You will need to implement your own <code>preprocess</code>, <code>predict</code> and <code>postprocess</code> steps in the <code>transform_fn</code>. This method can’t be combined with <code>input_fn</code>, <code>predict_fn</code> or <code>output_fn</code> mentioned below.</li> <li><code>input_fn(input_data, content_type)</code> overrides the default method for preprocessing. The return value <code>data</code> will be used in <code>predict</code> for predictions. The inputs are:<ul><li><code>input_data</code> is the raw body of your request.</li> <li><code>content_type</code> is the content type from the request header.</li></ul></li> <li><code>predict_fn(processed_data, model)</code> overrides the default method for predictions. The return value <code>predictions</code> will be used in <code>postprocess</code>. The input is <code>processed_data</code>, the result from <code>preprocess</code>.</li> <li><code>output_fn(prediction, accept)</code> overrides the default method for postprocessing. The return value <code>result</code> will be the response of your request (e.g.<code>JSON</code>). The inputs are:<ul><li><code>predictions</code> is the result from <code>predict</code>.</li> <li><code>accept</code> is the return accept type from the HTTP Request, e.g. <code>application/json</code>.</li></ul></li>",yt,Re,ys="Here is an example of a custom inference module with <code>model_fn</code>, <code>input_fn</code>, <code>predict_fn</code>, and <code>output_fn</code>:",dt,ze,ct,Ve,ds="Customize your inference module with only <code>model_fn</code> and <code>transform_fn</code>:",mt,Ee,ut,Xe,jt;return b=new h({props:{title:"Deploy models to Amazon SageMaker",local:"deploy-models-to-amazon-sagemaker",headingTag:"h1"}}),g=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nJTIwRmFjZSUyME1vZGVsJTIwQ2xhc3MlMjBhbmQlMjBkZXBsb3klMjBpdCUyMGFzJTIwU2FnZU1ha2VyJTIwZW5kcG9pbnQlMEFodWdnaW5nZmFjZV9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoLi4uKS5kZXBsb3koKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class and deploy it as SageMaker endpoint</span>
huggingface_model = HuggingFaceModel(...).deploy()`,wrap:!1}}),A=new h({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),_=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUyMC0tdXBncmFkZQ==",highlighted:"pip install sagemaker --upgrade",wrap:!1}}),R=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),x=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),X=new h({props:{title:"Deploy a 🤗 Transformers model trained in SageMaker",local:"deploy-a--transformers-model-trained-in-sagemaker",headingTag:"h2"}}),Q=new h({props:{title:"Deploy after training",local:"deploy-after-training",headingTag:"h3"}}),P=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIwcHNldWRvJTIwY29kZSUyMHN0YXJ0JTIwJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwY3JlYXRlJTIwSHVnZ2luZyUyMEZhY2UlMjBFc3RpbWF0b3IlMjBmb3IlMjB0cmFpbmluZyUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKC4uLi4pJTBBJTBBJTIzJTIwc3RhcnQlMjB0aGUlMjB0cmFpbiUyMGpvYiUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMGRhdGFzZXRzJTIwYXMlMjBpbnB1dCUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvci5maXQoLi4uKSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMHBzZXVkbyUyMGNvZGUlMjBlbmQlMjAlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaGZfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMGluc3RhbmNlX3R5cGUlM0QlMjJtbC5tNS54bGFyZ2UlMjIpJTBBJTBBJTIzJTIwZXhhbXBsZSUyMHJlcXVlc3QlM0ElMjB5b3UlMjBhbHdheXMlMjBuZWVkJTIwdG8lMjBkZWZpbmUlMjAlMjJpbnB1dHMlMjIlMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyQ2FtZXJhJTIwLSUyMFlvdSUyMGFyZSUyMGF3YXJkZWQlMjBhJTIwU2lQaXglMjBEaWdpdGFsJTIwQ2FtZXJhISUyMGNhbGwlMjAwOTA2MTIyMTA2NiUyMGZyb21tJTIwbGFuZGxpbmUuJTIwRGVsaXZlcnklMjB3aXRoaW4lMjAyOCUyMGRheXMuJTIyJTBBJTdEJTBBJTBBJTIzJTIwcmVxdWVzdCUwQXByZWRpY3Rvci5wcmVkaWN0KGRhdGEp",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment">############ pseudo code start ############</span>

<span class="hljs-comment"># create Hugging Face Estimator for training</span>
huggingface_estimator = HuggingFace(....)

<span class="hljs-comment"># start the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(...)

<span class="hljs-comment">############ pseudo code end ############</span>

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = hf_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>, instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 fromm landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),K=new j({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),O=new h({props:{title:"Deploy with model_data",local:"deploy-with-modeldata",headingTag:"h3"}}),le=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   model_data=<span class="hljs-string">&quot;s3://models/my-bert-model/model.tar.gz&quot;</span>,  <span class="hljs-comment"># path to your trained SageMaker model</span>
   role=role,                                            <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                           <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                    <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 fromm landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),se=new j({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),ae=new h({props:{title:"Create a model artifact for deployment",local:"create-a-model-artifact-for-deployment",headingTag:"h3"}}),ie=new j({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMHZvY2FiLnR4dCUwQSU3Qy0lMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElN0MtJTIwY29uZmlnLmpzb24lMEElN0MtJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24=",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- vocab.txt
|- tokenizer_config.json
|- config.json
|- special_tokens_map.json`,wrap:!1}}),ye=new j({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwZ2l0JTQwaGYuY28lM0ElN0JyZXBvc2l0b3J5JTdE",highlighted:`git lfs install
git <span class="hljs-built_in">clone</span> git@hf.co:{repository}`,wrap:!1}}),de=new j({props:{code:"Y2QlMjAlN0JyZXBvc2l0b3J5JTdEJTBBdGFyJTIwemN2ZiUyMG1vZGVsLnRhci5neiUyMCo=",highlighted:`<span class="hljs-built_in">cd</span> {repository}
tar zcvf model.tar.gz *`,wrap:!1}}),ce=new j({props:{code:"YXdzJTIwczMlMjBjcCUyMG1vZGVsLnRhci5neiUyMCUzQ3MzJTNBJTJGJTJGJTdCbXktczMtcGF0aCU3RCUzRQ==",highlighted:'aws s3 <span class="hljs-built_in">cp</span> model.tar.gz &lt;s3://{my-s3-path}&gt;',wrap:!1}}),ue=new h({props:{title:"Deploy a model from the 🤗 Hub",local:"deploy-a-model-from-the--hub",headingTag:"h2"}}),we=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
  <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased-distilled-squad&#x27;</span>, <span class="hljs-comment"># model_id from hf.co/models</span>
  <span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;question-answering&#x27;</span>                           <span class="hljs-comment"># NLP task you want to use for predictions</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
<span class="hljs-string">&quot;inputs&quot;</span>: {
	<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What is used for inference?&quot;</span>,
	<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
	}
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),Je=new j({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),fe=new h({props:{title:"Run batch transform with 🤗 Transformers and SageMaker",local:"run-batch-transform-with--transformers-and-sagemaker",headingTag:"h2"}}),Ze=new j({props:{code:"YmF0Y2hfam9iJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLnRyYW5zZm9ybWVyKCUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwucDMuMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjBzdHJhdGVneSUzRCdTaW5nbGVSZWNvcmQnKSUwQSUwQSUwQWJhdGNoX2pvYi50cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCdzMyUzQSUyRiUyRnMzLXVyaS10by1iYXRjaC1kYXRhJyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnRfdHlwZSUzRCdhcHBsaWNhdGlvbiUyRmpzb24nJTJDJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwc3BsaXRfdHlwZSUzRCdMaW5lJyk=",highlighted:`batch_job = huggingface_estimator.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>)


batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://s3-uri-to-batch-data&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>)`,wrap:!1}}),Ae=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
	<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
	<span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;text-classification&#x27;</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># create transformer to run a batch job</span>
batch_job = huggingface_model.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>
)

<span class="hljs-comment"># starts batch transform job and uses S3 data as input</span>
batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://sagemaker-s3-demo-test/samples/input.jsonl&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>
)`,wrap:!1}}),We=new j({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIydGhpcyUyMG1vdmllJTIwaXMlMjB0ZXJyaWJsZSUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwYW1hemluZyUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwdGVycmlibGUlMjIlN0QlMEElN0IlMjJpbnB1dHMlMjIlM0ElMjJ0aGlzJTIwbW92aWUlMjBpcyUyMGFtYXppbmclMjIlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),ve=new h({props:{title:"User defined code and modules",local:"user-defined-code-and-modules",headingTag:"h2"}}),_e=new j({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMC4uLi4lMEElN0MtJTIwY29kZSUyRiUwQSUyMCUyMCU3Qy0lMjBpbmZlcmVuY2UucHklMEElMjAlMjAlN0MtJTIwcmVxdWlyZW1lbnRzLnR4dCUyMA==",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- ....
|- code/
  |- inference.py
  |- requirements.txt `,wrap:!1}}),ze=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjBpbnB1dF9mbihpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMCUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YSUwQSUwQWRlZiUyMHByZWRpY3RfZm4oZGF0YSUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNhbGwlMjB5b3VyJTIwY3VzdG9tJTIwbW9kZWwlMjB3aXRoJTIwdGhlJTIwZGF0YSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChkYXRhJTIwJTJDJTIwLi4uJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZWRpY3Rpb25zJTBBJTBBZGVmJTIwb3V0cHV0X2ZuKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2U=",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">input_fn</span>(<span class="hljs-params">input_data, content_type</span>):
    <span class="hljs-comment"># decode the input data  (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)
    <span class="hljs-keyword">return</span> data

<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict_fn</span>(<span class="hljs-params">data, model</span>):
    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... )
    <span class="hljs-keyword">return</span> predictions

<span class="hljs-keyword">def</span> <span class="hljs-title function_">output_fn</span>(<span class="hljs-params">prediction, accept</span>):
    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(prediction, accept)
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),Ee=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjB0cmFuc2Zvcm1fZm4obW9kZWwlMkMlMjBpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlJTJDJTIwYWNjZXB0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY2FsbCUyMHlvdXIlMjBjdXN0b20lMjBtb2RlbCUyMHdpdGglMjB0aGUlMjBkYXRhJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGRhdGElMjAlMkMlMjAuLi4lMjApJTIwJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKG91dHB1dCUyQyUyMGFjY2VwdCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_fn</span>(<span class="hljs-params">model, input_data, content_type, accept</span>):
     <span class="hljs-comment"># decode the input data (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)

    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... ) 

    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(output, accept)

    <span class="hljs-keyword">return</span> response`,wrap:!1}}),{c(){J=M("meta"),Ye=a(),xe=M("p"),Fe=a(),p(b.$$.fragment),Qe=a(),C=M("p"),C.textContent=Ut,Le=a(),p(g.$$.fragment),qe=a(),Z=M("p"),Z.innerHTML=Jt,Pe=a(),B=M("ul"),B.innerHTML=ht,De=a(),p(A.$$.fragment),Ke=a(),k=M("p"),k.innerHTML=ft,Oe=a(),W=M("p"),W.textContent=It,el=a(),G=M("ul"),G.innerHTML=bt,ll=a(),v=M("p"),v.innerHTML=Ct,tl=a(),H=M("p"),H.innerHTML=gt,sl=a(),p(_.$$.fragment),al=a(),$=M("p"),$.innerHTML=Zt,nl=a(),S=M("p"),S.textContent=Bt,Ml=a(),p(R.$$.fragment),ol=a(),z=M("p"),z.innerHTML=At,il=a(),V=M("p"),V.innerHTML=kt,pl=a(),E=M("p"),E.textContent=Wt,rl=a(),p(x.$$.fragment),yl=a(),p(X.$$.fragment),dl=a(),T=M("iframe"),cl=a(),N=M("p"),N.textContent=vt,ml=a(),Y=M("ul"),Y.innerHTML=Ht,ul=a(),F=M("p"),F.innerHTML=_t,jl=a(),p(Q.$$.fragment),Tl=a(),L=M("p"),L.textContent=$t,wl=a(),q=M("p"),q.innerHTML=St,Ul=a(),p(P.$$.fragment),Jl=a(),D=M("p"),D.textContent=Rt,hl=a(),p(K.$$.fragment),fl=a(),p(O.$$.fragment),Il=a(),ee=M("p"),ee.innerHTML=zt,bl=a(),p(le.$$.fragment),Cl=a(),te=M("p"),te.textContent=Vt,gl=a(),p(se.$$.fragment),Zl=a(),p(ae.$$.fragment),Bl=a(),ne=M("p"),ne.innerHTML=Et,Al=a(),Me=M("ul"),Me.innerHTML=xt,kl=a(),oe=M("p"),oe.textContent=Xt,Wl=a(),p(ie.$$.fragment),Gl=a(),pe=M("p"),pe.innerHTML=Nt,vl=a(),re=M("ol"),re.innerHTML=Yt,Hl=a(),p(ye.$$.fragment),_l=a(),f=M("ol"),f.innerHTML=Ft,$l=a(),p(de.$$.fragment),Sl=a(),I=M("ol"),I.innerHTML=Qt,Rl=a(),p(ce.$$.fragment),zl=a(),me=M("p"),me.innerHTML=Lt,Vl=a(),p(ue.$$.fragment),El=a(),w=M("iframe"),xl=a(),je=M("p"),je.innerHTML=Pt,Xl=a(),Te=M("ul"),Te.innerHTML=Dt,Nl=a(),p(we.$$.fragment),Yl=a(),Ue=M("p"),Ue.textContent=Kt,Fl=a(),p(Je.$$.fragment),Ql=a(),he=M("p"),he.innerHTML=Ot,Ll=a(),p(fe.$$.fragment),ql=a(),U=M("iframe"),Pl=a(),Ie=M("p"),Ie.innerHTML=ls,Dl=a(),be=M("p"),be.innerHTML=ts,Kl=a(),Ce=M("p"),Ce.innerHTML=ss,Ol=a(),ge=M("p"),ge.innerHTML=as,et=a(),p(Ze.$$.fragment),lt=a(),Be=M("p"),Be.innerHTML=ns,tt=a(),p(Ae.$$.fragment),st=a(),ke=M("p"),ke.innerHTML=Ms,at=a(),p(We.$$.fragment),nt=a(),Ge=M("p"),Ge.innerHTML=os,Mt=a(),p(ve.$$.fragment),ot=a(),He=M("p"),He.innerHTML=is,it=a(),p(_e.$$.fragment),pt=a(),$e=M("p"),$e.innerHTML=ps,rt=a(),Se=M("ul"),Se.innerHTML=rs,yt=a(),Re=M("p"),Re.innerHTML=ys,dt=a(),p(ze.$$.fragment),ct=a(),Ve=M("p"),Ve.innerHTML=ds,mt=a(),p(Ee.$$.fragment),ut=a(),Xe=M("p"),this.h()},l(e){const l=ws("svelte-u9bgzb",document.head);J=o(l,"META",{name:!0,content:!0}),l.forEach(t),Ye=n(e),xe=o(e,"P",{}),Ne(xe).forEach(t),Fe=n(e),r(b.$$.fragment,e),Qe=n(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ywypfi"&&(C.textContent=Ut),Le=n(e),r(g.$$.fragment,e),qe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-lx9xk7"&&(Z.innerHTML=Jt),Pe=n(e),B=o(e,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-lmxuwx"&&(B.innerHTML=ht),De=n(e),r(A.$$.fragment,e),Ke=n(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-uia7yx"&&(k.innerHTML=ft),Oe=n(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-14pz1nf"&&(W.textContent=It),el=n(e),G=o(e,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-nu9uzs"&&(G.innerHTML=bt),ll=n(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-10vylvb"&&(v.innerHTML=Ct),tl=n(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-183wm56"&&(H.innerHTML=gt),sl=n(e),r(_.$$.fragment,e),al=n(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-aqpf90"&&($.innerHTML=Zt),nl=n(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1n86nit"&&(S.textContent=Bt),Ml=n(e),r(R.$$.fragment,e),ol=n(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-bmcgfj"&&(z.innerHTML=At),il=n(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-12o7543"&&(V.innerHTML=kt),pl=n(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-qjt50s"&&(E.textContent=Wt),rl=n(e),r(x.$$.fragment,e),yl=n(e),r(X.$$.fragment,e),dl=n(e),T=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Ne(T).forEach(t),cl=n(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-gux9y"&&(N.textContent=vt),ml=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),i(Y)!=="svelte-g9t1l6"&&(Y.innerHTML=Ht),ul=n(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1kzoo7i"&&(F.innerHTML=_t),jl=n(e),r(Q.$$.fragment,e),Tl=n(e),L=o(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1bnjjtb"&&(L.textContent=$t),wl=n(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-qrjq9z"&&(q.innerHTML=St),Ul=n(e),r(P.$$.fragment,e),Jl=n(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1704hsx"&&(D.textContent=Rt),hl=n(e),r(K.$$.fragment,e),fl=n(e),r(O.$$.fragment,e),Il=n(e),ee=o(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-xplu1m"&&(ee.innerHTML=zt),bl=n(e),r(le.$$.fragment,e),Cl=n(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-10df72h"&&(te.textContent=Vt),gl=n(e),r(se.$$.fragment,e),Zl=n(e),r(ae.$$.fragment,e),Bl=n(e),ne=o(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-1bx7pn1"&&(ne.innerHTML=Et),Al=n(e),Me=o(e,"UL",{"data-svelte-h":!0}),i(Me)!=="svelte-1yevczk"&&(Me.innerHTML=xt),kl=n(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1fj2qwz"&&(oe.textContent=Xt),Wl=n(e),r(ie.$$.fragment,e),Gl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-6vx79s"&&(pe.innerHTML=Nt),vl=n(e),re=o(e,"OL",{"data-svelte-h":!0}),i(re)!=="svelte-1oe4mbx"&&(re.innerHTML=Yt),Hl=n(e),r(ye.$$.fragment,e),_l=n(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(f)!=="svelte-1dpsw5r"&&(f.innerHTML=Ft),$l=n(e),r(de.$$.fragment,e),Sl=n(e),I=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(I)!=="svelte-1jup9fl"&&(I.innerHTML=Qt),Rl=n(e),r(ce.$$.fragment,e),zl=n(e),me=o(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-fiqqyd"&&(me.innerHTML=Lt),Vl=n(e),r(ue.$$.fragment,e),El=n(e),w=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Ne(w).forEach(t),xl=n(e),je=o(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1rqi6h3"&&(je.innerHTML=Pt),Xl=n(e),Te=o(e,"UL",{"data-svelte-h":!0}),i(Te)!=="svelte-24bif2"&&(Te.innerHTML=Dt),Nl=n(e),r(we.$$.fragment,e),Yl=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-10df72h"&&(Ue.textContent=Kt),Fl=n(e),r(Je.$$.fragment,e),Ql=n(e),he=o(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-116ugu4"&&(he.innerHTML=Ot),Ll=n(e),r(fe.$$.fragment,e),ql=n(e),U=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Ne(U).forEach(t),Pl=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-6zcket"&&(Ie.innerHTML=ls),Dl=n(e),be=o(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-11i511d"&&(be.innerHTML=ts),Kl=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-1aa5m67"&&(Ce.innerHTML=ss),Ol=n(e),ge=o(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-h98oit"&&(ge.innerHTML=as),et=n(e),r(Ze.$$.fragment,e),lt=n(e),Be=o(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-1ttbskl"&&(Be.innerHTML=ns),tt=n(e),r(Ae.$$.fragment,e),st=n(e),ke=o(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1pml3h7"&&(ke.innerHTML=Ms),at=n(e),r(We.$$.fragment,e),nt=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-1uayvx5"&&(Ge.innerHTML=os),Mt=n(e),r(ve.$$.fragment,e),ot=n(e),He=o(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-1ryqcdi"&&(He.innerHTML=is),it=n(e),r(_e.$$.fragment,e),pt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-1jy9y33"&&($e.innerHTML=ps),rt=n(e),Se=o(e,"UL",{"data-svelte-h":!0}),i(Se)!=="svelte-1m8cp8l"&&(Se.innerHTML=rs),yt=n(e),Re=o(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-d9i7vl"&&(Re.innerHTML=ys),dt=n(e),r(ze.$$.fragment,e),ct=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-1cih48j"&&(Ve.innerHTML=ds),mt=n(e),r(Ee.$$.fragment,e),ut=n(e),Xe=o(e,"P",{}),Ne(Xe).forEach(t),this.h()},h(){u(J,"name","hf:doc:metadata"),u(J,"content",hs),u(T,"width","700"),u(T,"height","394"),Tt(T.src,Gt="https://www.youtube.com/embed/pfBGgSGnYLs")||u(T,"src",Gt),u(T,"title","YouTube video player"),u(T,"frameborder","0"),u(T,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),T.allowFullscreen="",u(f,"start","2"),u(I,"start","3"),u(w,"width","700"),u(w,"height","394"),Tt(w.src,qt="https://www.youtube.com/embed/l9QZuazbzWM")||u(w,"src",qt),u(w,"title","YouTube video player"),u(w,"frameborder","0"),u(w,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),w.allowFullscreen="",u(U,"width","700"),u(U,"height","394"),Tt(U.src,es="https://www.youtube.com/embed/lnTixz0tUBg")||u(U,"src",es),u(U,"title","YouTube video player"),u(U,"frameborder","0"),u(U,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),U.allowFullscreen=""},m(e,l){Us(document.head,J),s(e,Ye,l),s(e,xe,l),s(e,Fe,l),y(b,e,l),s(e,Qe,l),s(e,C,l),s(e,Le,l),y(g,e,l),s(e,qe,l),s(e,Z,l),s(e,Pe,l),s(e,B,l),s(e,De,l),y(A,e,l),s(e,Ke,l),s(e,k,l),s(e,Oe,l),s(e,W,l),s(e,el,l),s(e,G,l),s(e,ll,l),s(e,v,l),s(e,tl,l),s(e,H,l),s(e,sl,l),y(_,e,l),s(e,al,l),s(e,$,l),s(e,nl,l),s(e,S,l),s(e,Ml,l),y(R,e,l),s(e,ol,l),s(e,z,l),s(e,il,l),s(e,V,l),s(e,pl,l),s(e,E,l),s(e,rl,l),y(x,e,l),s(e,yl,l),y(X,e,l),s(e,dl,l),s(e,T,l),s(e,cl,l),s(e,N,l),s(e,ml,l),s(e,Y,l),s(e,ul,l),s(e,F,l),s(e,jl,l),y(Q,e,l),s(e,Tl,l),s(e,L,l),s(e,wl,l),s(e,q,l),s(e,Ul,l),y(P,e,l),s(e,Jl,l),s(e,D,l),s(e,hl,l),y(K,e,l),s(e,fl,l),y(O,e,l),s(e,Il,l),s(e,ee,l),s(e,bl,l),y(le,e,l),s(e,Cl,l),s(e,te,l),s(e,gl,l),y(se,e,l),s(e,Zl,l),y(ae,e,l),s(e,Bl,l),s(e,ne,l),s(e,Al,l),s(e,Me,l),s(e,kl,l),s(e,oe,l),s(e,Wl,l),y(ie,e,l),s(e,Gl,l),s(e,pe,l),s(e,vl,l),s(e,re,l),s(e,Hl,l),y(ye,e,l),s(e,_l,l),s(e,f,l),s(e,$l,l),y(de,e,l),s(e,Sl,l),s(e,I,l),s(e,Rl,l),y(ce,e,l),s(e,zl,l),s(e,me,l),s(e,Vl,l),y(ue,e,l),s(e,El,l),s(e,w,l),s(e,xl,l),s(e,je,l),s(e,Xl,l),s(e,Te,l),s(e,Nl,l),y(we,e,l),s(e,Yl,l),s(e,Ue,l),s(e,Fl,l),y(Je,e,l),s(e,Ql,l),s(e,he,l),s(e,Ll,l),y(fe,e,l),s(e,ql,l),s(e,U,l),s(e,Pl,l),s(e,Ie,l),s(e,Dl,l),s(e,be,l),s(e,Kl,l),s(e,Ce,l),s(e,Ol,l),s(e,ge,l),s(e,et,l),y(Ze,e,l),s(e,lt,l),s(e,Be,l),s(e,tt,l),y(Ae,e,l),s(e,st,l),s(e,ke,l),s(e,at,l),y(We,e,l),s(e,nt,l),s(e,Ge,l),s(e,Mt,l),y(ve,e,l),s(e,ot,l),s(e,He,l),s(e,it,l),y(_e,e,l),s(e,pt,l),s(e,$e,l),s(e,rt,l),s(e,Se,l),s(e,yt,l),s(e,Re,l),s(e,dt,l),y(ze,e,l),s(e,ct,l),s(e,Ve,l),s(e,mt,l),y(Ee,e,l),s(e,ut,l),s(e,Xe,l),jt=!0},p:ms,i(e){jt||(d(b.$$.fragment,e),d(g.$$.fragment,e),d(A.$$.fragment,e),d(_.$$.fragment,e),d(R.$$.fragment,e),d(x.$$.fragment,e),d(X.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(ye.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(fe.$$.fragment,e),d(Ze.$$.fragment,e),d(Ae.$$.fragment,e),d(We.$$.fragment,e),d(ve.$$.fragment,e),d(_e.$$.fragment,e),d(ze.$$.fragment,e),d(Ee.$$.fragment,e),jt=!0)},o(e){c(b.$$.fragment,e),c(g.$$.fragment,e),c(A.$$.fragment,e),c(_.$$.fragment,e),c(R.$$.fragment,e),c(x.$$.fragment,e),c(X.$$.fragment,e),c(Q.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(ye.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c(fe.$$.fragment,e),c(Ze.$$.fragment,e),c(Ae.$$.fragment,e),c(We.$$.fragment,e),c(ve.$$.fragment,e),c(_e.$$.fragment,e),c(ze.$$.fragment,e),c(Ee.$$.fragment,e),jt=!1},d(e){e&&(t(Ye),t(xe),t(Fe),t(Qe),t(C),t(Le),t(qe),t(Z),t(Pe),t(B),t(De),t(Ke),t(k),t(Oe),t(W),t(el),t(G),t(ll),t(v),t(tl),t(H),t(sl),t(al),t($),t(nl),t(S),t(Ml),t(ol),t(z),t(il),t(V),t(pl),t(E),t(rl),t(yl),t(dl),t(T),t(cl),t(N),t(ml),t(Y),t(ul),t(F),t(jl),t(Tl),t(L),t(wl),t(q),t(Ul),t(Jl),t(D),t(hl),t(fl),t(Il),t(ee),t(bl),t(Cl),t(te),t(gl),t(Zl),t(Bl),t(ne),t(Al),t(Me),t(kl),t(oe),t(Wl),t(Gl),t(pe),t(vl),t(re),t(Hl),t(_l),t(f),t($l),t(Sl),t(I),t(Rl),t(zl),t(me),t(Vl),t(El),t(w),t(xl),t(je),t(Xl),t(Te),t(Nl),t(Yl),t(Ue),t(Fl),t(Ql),t(he),t(Ll),t(ql),t(U),t(Pl),t(Ie),t(Dl),t(be),t(Kl),t(Ce),t(Ol),t(ge),t(et),t(lt),t(Be),t(tt),t(st),t(ke),t(at),t(nt),t(Ge),t(Mt),t(ot),t(He),t(it),t(pt),t($e),t(rt),t(Se),t(yt),t(Re),t(dt),t(ct),t(Ve),t(mt),t(ut),t(Xe)),t(J),m(b,e),m(g,e),m(A,e),m(_,e),m(R,e),m(x,e),m(X,e),m(Q,e),m(P,e),m(K,e),m(O,e),m(le,e),m(se,e),m(ae,e),m(ie,e),m(ye,e),m(de,e),m(ce,e),m(ue,e),m(we,e),m(Je,e),m(fe,e),m(Ze,e),m(Ae,e),m(We,e),m(ve,e),m(_e,e),m(ze,e),m(Ee,e)}}}const hs='{"title":"Deploy models to Amazon SageMaker","local":"deploy-models-to-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Deploy a 🤗 Transformers model trained in SageMaker","local":"deploy-a--transformers-model-trained-in-sagemaker","sections":[{"title":"Deploy after training","local":"deploy-after-training","sections":[],"depth":3},{"title":"Deploy with model_data","local":"deploy-with-modeldata","sections":[],"depth":3},{"title":"Create a model artifact for deployment","local":"create-a-model-artifact-for-deployment","sections":[],"depth":3}],"depth":2},{"title":"Deploy a model from the 🤗 Hub","local":"deploy-a-model-from-the--hub","sections":[],"depth":2},{"title":"Run batch transform with 🤗 Transformers and SageMaker","local":"run-batch-transform-with--transformers-and-sagemaker","sections":[],"depth":2},{"title":"User defined code and modules","local":"user-defined-code-and-modules","sections":[],"depth":2}],"depth":1}';function fs(wt){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends js{constructor(J){super(),Ts(this,J,fs,Js,cs,{})}}export{Zs as component};
