import{s as Us,n as Is,o as Ws}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Cs,g as p,s as e,r as i,A as $s,h as m,f as l,c as n,j as bs,u as o,x as J,k as fs,y as Zs,a as t,v as c,d as M,t as r,w as h}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as V}from"../chunks/Heading.3097d2ed.js";function Ns(Ms){let g,Y,v,z,j,X,T,rs="<strong>SelecSLS</strong> uses novel selective long and short range skip connections to improve the information flow allowing for a drastically faster network without compromising accuracy.",_,d,H,y,hs="To load a pretrained model:",A,w,F,u,Js="To load and preprocess the image:",D,b,L,f,gs="To get the model predictions:",P,U,q,I,js="To get the top-5 predictions class names:",K,W,O,k,Ts="Replace the model name with the variant you want to use, e.g. <code>selecsls42b</code>. You can find the IDs in the model summaries at the top of this page.",ss,C,ds='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,$,ls,Z,ys="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ts,N,es,x,ws=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,B,ps,G,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,E,is,R,os,S,cs;return j=new V({props:{title:"SelecSLS",local:"selecsls",headingTag:"h1"}}),d=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),w=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NlbGVjc2xzNDJiJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;selecsls42b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),W=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),$=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2VsZWNzbHM0MmInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;selecsls42b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new Q({props:{code:"JTQwYXJ0aWNsZSU3Qk1laHRhXzIwMjAlMkMlMEElMjAlMjAlMjB0aXRsZSUzRCU3QlhOZWN0JTdEJTJDJTBBJTIwJTIwJTIwdm9sdW1lJTNEJTdCMzklN0QlMkMlMEElMjAlMjAlMjBJU1NOJTNEJTdCMTU1Ny03MzY4JTdEJTJDJTBBJTIwJTIwJTIwdXJsJTNEJTdCaHR0cCUzQSUyRiUyRmR4LmRvaS5vcmclMkYxMC4xMTQ1JTJGMzM4NjU2OS4zMzkyNDEwJTdEJTJDJTBBJTIwJTIwJTIwRE9JJTNEJTdCMTAuMTE0NSUyRjMzODY1NjkuMzM5MjQxMCU3RCUyQyUwQSUyMCUyMCUyMG51bWJlciUzRCU3QjQlN0QlMkMlMEElMjAlMjAlMjBqb3VybmFsJTNEJTdCQUNNJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBHcmFwaGljcyU3RCUyQyUwQSUyMCUyMCUyMHB1Ymxpc2hlciUzRCU3QkFzc29jaWF0aW9uJTIwZm9yJTIwQ29tcHV0aW5nJTIwTWFjaGluZXJ5JTIwKEFDTSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JNZWh0YSUyQyUyMER1c2h5YW50JTIwYW5kJTIwU290bnljaGVua28lMkMlMjBPbGVrc2FuZHIlMjBhbmQlMjBNdWVsbGVyJTJDJTIwRnJhbnppc2thJTIwYW5kJTIwWHUlMkMlMjBXZWlwZW5nJTIwYW5kJTIwRWxnaGFyaWIlMkMlMjBNb2hhbWVkJTIwYW5kJTIwRnVhJTJDJTIwUGFzY2FsJTIwYW5kJTIwU2VpZGVsJTJDJTIwSGFucy1QZXRlciUyMGFuZCUyMFJob2RpbiUyQyUyMEhlbGdlJTIwYW5kJTIwUG9ucy1Nb2xsJTJDJTIwR2VyYXJkJTIwYW5kJTIwVGhlb2JhbHQlMkMlMjBDaHJpc3RpYW4lN0QlMkMlMEElMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMG1vbnRoJTNEJTdCSnVsJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Mehta_2020,
   title={XNect}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{39}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1557-7368}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1145/3386569.3392410}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1145/3386569.3392410}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{4}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{ACM Transactions on Graphics}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Association for Computing Machinery (ACM)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Mehta, Dushyant and Sotnychenko, Oleksandr and Mueller, Franziska and Xu, Weipeng and Elgharib, Mohamed and Fua, Pascal and Seidel, Hans-Peter and Rhodin, Helge and Pons-Moll, Gerard and Theobalt, Christian}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Jul}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){g=p("meta"),Y=e(),v=p("p"),z=e(),i(j.$$.fragment),X=e(),T=p("p"),T.innerHTML=rs,_=e(),i(d.$$.fragment),H=e(),y=p("p"),y.textContent=hs,A=e(),i(w.$$.fragment),F=e(),u=p("p"),u.textContent=Js,D=e(),i(b.$$.fragment),L=e(),f=p("p"),f.textContent=gs,P=e(),i(U.$$.fragment),q=e(),I=p("p"),I.textContent=js,K=e(),i(W.$$.fragment),O=e(),k=p("p"),k.innerHTML=Ts,ss=e(),C=p("p"),C.innerHTML=ds,as=e(),i($.$$.fragment),ls=e(),Z=p("p"),Z.textContent=ys,ts=e(),i(N.$$.fragment),es=e(),x=p("p"),x.innerHTML=ws,ns=e(),i(B.$$.fragment),ps=e(),G=p("p"),G.innerHTML=us,ms=e(),i(E.$$.fragment),is=e(),i(R.$$.fragment),os=e(),S=p("p"),this.h()},l(s){const a=$s("svelte-u9bgzb",document.head);g=m(a,"META",{name:!0,content:!0}),a.forEach(l),Y=n(s),v=m(s,"P",{}),bs(v).forEach(l),z=n(s),o(j.$$.fragment,s),X=n(s),T=m(s,"P",{"data-svelte-h":!0}),J(T)!=="svelte-4n5lf1"&&(T.innerHTML=rs),_=n(s),o(d.$$.fragment,s),H=n(s),y=m(s,"P",{"data-svelte-h":!0}),J(y)!=="svelte-18ywhxh"&&(y.textContent=hs),A=n(s),o(w.$$.fragment,s),F=n(s),u=m(s,"P",{"data-svelte-h":!0}),J(u)!=="svelte-1c2ipa8"&&(u.textContent=Js),D=n(s),o(b.$$.fragment,s),L=n(s),f=m(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1n9qsq1"&&(f.textContent=gs),P=n(s),o(U.$$.fragment,s),q=n(s),I=m(s,"P",{"data-svelte-h":!0}),J(I)!=="svelte-19cnvx1"&&(I.textContent=js),K=n(s),o(W.$$.fragment,s),O=n(s),k=m(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1y4pu0a"&&(k.innerHTML=Ts),ss=n(s),C=m(s,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1wmi3ea"&&(C.innerHTML=ds),as=n(s),o($.$$.fragment,s),ls=n(s),Z=m(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-9sr7nh"&&(Z.textContent=ys),ts=n(s),o(N.$$.fragment,s),es=n(s),x=m(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1kguc51"&&(x.innerHTML=ws),ns=n(s),o(B.$$.fragment,s),ps=n(s),G=m(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1n0coha"&&(G.innerHTML=us),ms=n(s),o(E.$$.fragment,s),is=n(s),o(R.$$.fragment,s),os=n(s),S=m(s,"P",{}),bs(S).forEach(l),this.h()},h(){fs(g,"name","hf:doc:metadata"),fs(g,"content",xs)},m(s,a){Zs(document.head,g),t(s,Y,a),t(s,v,a),t(s,z,a),c(j,s,a),t(s,X,a),t(s,T,a),t(s,_,a),c(d,s,a),t(s,H,a),t(s,y,a),t(s,A,a),c(w,s,a),t(s,F,a),t(s,u,a),t(s,D,a),c(b,s,a),t(s,L,a),t(s,f,a),t(s,P,a),c(U,s,a),t(s,q,a),t(s,I,a),t(s,K,a),c(W,s,a),t(s,O,a),t(s,k,a),t(s,ss,a),t(s,C,a),t(s,as,a),c($,s,a),t(s,ls,a),t(s,Z,a),t(s,ts,a),c(N,s,a),t(s,es,a),t(s,x,a),t(s,ns,a),c(B,s,a),t(s,ps,a),t(s,G,a),t(s,ms,a),c(E,s,a),t(s,is,a),c(R,s,a),t(s,os,a),t(s,S,a),cs=!0},p:Is,i(s){cs||(M(j.$$.fragment,s),M(d.$$.fragment,s),M(w.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(W.$$.fragment,s),M($.$$.fragment,s),M(N.$$.fragment,s),M(B.$$.fragment,s),M(E.$$.fragment,s),M(R.$$.fragment,s),cs=!0)},o(s){r(j.$$.fragment,s),r(d.$$.fragment,s),r(w.$$.fragment,s),r(b.$$.fragment,s),r(U.$$.fragment,s),r(W.$$.fragment,s),r($.$$.fragment,s),r(N.$$.fragment,s),r(B.$$.fragment,s),r(E.$$.fragment,s),r(R.$$.fragment,s),cs=!1},d(s){s&&(l(Y),l(v),l(z),l(X),l(T),l(_),l(H),l(y),l(A),l(F),l(u),l(D),l(L),l(f),l(P),l(q),l(I),l(K),l(O),l(k),l(ss),l(C),l(as),l(ls),l(Z),l(ts),l(es),l(x),l(ns),l(ps),l(G),l(ms),l(is),l(os),l(S)),l(g),h(j,s),h(d,s),h(w,s),h(b,s),h(U,s),h(W,s),h($,s),h(N,s),h(B,s),h(E,s),h(R,s)}}}const xs='{"title":"SelecSLS","local":"selecsls","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Bs(Ms){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vs extends ks{constructor(g){super(),Cs(this,g,Bs,Ns,Us,{})}}export{vs as component};
