import{s as ra,n as ia,o as sa}from"../chunks/scheduler.9039eef2.js";import{S as da,i as ma,g as r,s as o,r as p,A as ca,h as i,f as t,c as l,j as v,u as _,x as m,k as T,y as n,a as s,v as g,d as h,t as u,w as f}from"../chunks/index.ded8f90d.js";import{D as M}from"../chunks/Docstring.a2ba2b54.js";import{C as kt}from"../chunks/CodeBlock.8580f3e8.js";import{H as xe}from"../chunks/Heading.f027f30d.js";function pa(Nt){let C,Ie,Oe,ke,k,Ne,N,At=`TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for aligning language models with binary feedback data (e.g., upvote/downvote), as described in the <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">paper</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.
For a full example have a look at  <code>examples/scripts/kto.py</code>.`,Ae,A,Kt=`Depending on how good your base model is, you may or may not need to do SFT before KTO.
This is different from standard RLHF and DPO, which always require SFT.`,Ke,K,Fe,F,Ft="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",Ee,E,Et="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",Le,L,Lt="for example:",De,D,qe,q,Dt=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.`,He,H,ze,z,qt="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Pe,P,Be,B,Ht="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",We,W,zt="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Qe,Q,Pt=`The <code>desirable_weight</code> and <code>undesirable_weight</code> refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (<code>desirable_weight</code> <em>number of positives) to (<code>undesirable_weight</code></em> number of negatives) is in the range 1:1 to 4:3.`,Se,S,Ze,Z,Bt="After this one can then call:",Re,R,Xe,X,Ge,d,G,st,de,Wt="Initialize KTOTrainer.",dt,$,V,mt,me,Qt="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",ct,y,Y,pt,ce,St=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,_t,pe,Zt="Works both with or without labels.",gt,J,ee,ht,_e,Rt="Compute the log probabilities of the given labels under the given logits.",ut,x,te,ft,ge,Xt="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",vt,O,ae,Tt,he,Gt="Generate samples from the model and reference model for the given batch of inputs.",bt,w,ne,Mt,ue,Vt="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",yt,fe,Yt="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",wt,U,oe,Ut,ve,ea="Returns the training <code>~torch.utils.data.DataLoader</code>.",Ct,Te,ta="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",$t,j,le,Jt,be,aa="Compute the KTO loss for a batch of policy and reference model log probabilities.",xt,I,re,Ot,Me,na="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ve,ie,Ye,b,se,jt,ye,oa='KTOConfig collects all training arguments related to the <a href="/docs/trl/v0.8.2/en/trainer#trl.KTOTrainer">KTOTrainer</a> class.',It,we,la=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,et,je,tt;return k=new xe({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),K=new xe({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),D=new kt({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),H=new xe({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),P=new xe({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),S=new kt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMHVuZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSklMEElMEFrdG9fdHJhaW5lciUyMCUzRCUyMEtUT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9yZWYlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
    desirable_weight=<span class="hljs-number">1.0</span>,
    undesirable_weight=<span class="hljs-number">1.0</span>,
)

kto_trainer = KTOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),R=new kt({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),X=new xe({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),G=new M({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L224"}}),V=new M({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L774"}}),Y=new M({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L1199"}}),ee=new M({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),te=new M({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L1004"}}),ae=new M({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L1113"}}),ne=new M({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v2.18.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L721"}}),oe=new M({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L680"}}),le=new M({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),re=new M({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_trainer.py#L1255"}}),ie=new xe({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),se=new M({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/v0.8.2/trl/trainer/kto_config.py#L20"}}),{c(){C=r("meta"),Ie=o(),Oe=r("p"),ke=o(),p(k.$$.fragment),Ne=o(),N=r("p"),N.innerHTML=At,Ae=o(),A=r("p"),A.textContent=Kt,Ke=o(),p(K.$$.fragment),Fe=o(),F=r("p"),F.textContent=Ft,Ee=o(),E=r("ul"),E.innerHTML=Et,Le=o(),L=r("p"),L.textContent=Lt,De=o(),p(D.$$.fragment),qe=o(),q=r("p"),q.innerHTML=Dt,He=o(),p(H.$$.fragment),ze=o(),z=r("p"),z.innerHTML=qt,Pe=o(),p(P.$$.fragment),Be=o(),B=r("p"),B.innerHTML=Ht,We=o(),W=r("p"),W.innerHTML=zt,Qe=o(),Q=r("p"),Q.innerHTML=Pt,Se=o(),p(S.$$.fragment),Ze=o(),Z=r("p"),Z.textContent=Bt,Re=o(),p(R.$$.fragment),Xe=o(),p(X.$$.fragment),Ge=o(),d=r("div"),p(G.$$.fragment),st=o(),de=r("p"),de.textContent=Wt,dt=o(),$=r("div"),p(V.$$.fragment),mt=o(),me=r("p"),me.textContent=Qt,ct=o(),y=r("div"),p(Y.$$.fragment),pt=o(),ce=r("p"),ce.innerHTML=St,_t=o(),pe=r("p"),pe.textContent=Zt,gt=o(),J=r("div"),p(ee.$$.fragment),ht=o(),_e=r("p"),_e.textContent=Rt,ut=o(),x=r("div"),p(te.$$.fragment),ft=o(),ge=r("p"),ge.textContent=Xt,vt=o(),O=r("div"),p(ae.$$.fragment),Tt=o(),he=r("p"),he.textContent=Gt,bt=o(),w=r("div"),p(ne.$$.fragment),Mt=o(),ue=r("p"),ue.innerHTML=Vt,yt=o(),fe=r("p"),fe.innerHTML=Yt,wt=o(),U=r("div"),p(oe.$$.fragment),Ut=o(),ve=r("p"),ve.innerHTML=ea,Ct=o(),Te=r("p"),Te.innerHTML=ta,$t=o(),j=r("div"),p(le.$$.fragment),Jt=o(),be=r("p"),be.textContent=aa,xt=o(),I=r("div"),p(re.$$.fragment),Ot=o(),Me=r("p"),Me.innerHTML=na,Ve=o(),p(ie.$$.fragment),Ye=o(),b=r("div"),p(se.$$.fragment),jt=o(),ye=r("p"),ye.innerHTML=oa,It=o(),we=r("p"),we.innerHTML=la,et=o(),je=r("p"),this.h()},l(e){const a=ca("svelte-u9bgzb",document.head);C=i(a,"META",{name:!0,content:!0}),a.forEach(t),Ie=l(e),Oe=i(e,"P",{}),v(Oe).forEach(t),ke=l(e),_(k.$$.fragment,e),Ne=l(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-171dbf3"&&(N.innerHTML=At),Ae=l(e),A=i(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-z1e9ri"&&(A.textContent=Kt),Ke=l(e),_(K.$$.fragment,e),Fe=l(e),F=i(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1792bye"&&(F.textContent=Ft),Ee=l(e),E=i(e,"UL",{"data-svelte-h":!0}),m(E)!=="svelte-1bk1n3o"&&(E.innerHTML=Et),Le=l(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1gl9mvz"&&(L.textContent=Lt),De=l(e),_(D.$$.fragment,e),qe=l(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-109yt43"&&(q.innerHTML=Dt),He=l(e),_(H.$$.fragment,e),ze=l(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-znx0uh"&&(z.innerHTML=qt),Pe=l(e),_(P.$$.fragment,e),Be=l(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-6k9bp8"&&(B.innerHTML=Ht),We=l(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1eil2tw"&&(W.innerHTML=zt),Qe=l(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-ad0vsu"&&(Q.innerHTML=Pt),Se=l(e),_(S.$$.fragment,e),Ze=l(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1lg6q1l"&&(Z.textContent=Bt),Re=l(e),_(R.$$.fragment,e),Xe=l(e),_(X.$$.fragment,e),Ge=l(e),d=i(e,"DIV",{class:!0});var c=v(d);_(G.$$.fragment,c),st=l(c),de=i(c,"P",{"data-svelte-h":!0}),m(de)!=="svelte-hyhzxp"&&(de.textContent=Wt),dt=l(c),$=i(c,"DIV",{class:!0});var at=v($);_(V.$$.fragment,at),mt=l(at),me=i(at,"P",{"data-svelte-h":!0}),m(me)!=="svelte-pt6g01"&&(me.textContent=Qt),at.forEach(t),ct=l(c),y=i(c,"DIV",{class:!0});var Ue=v(y);_(Y.$$.fragment,Ue),pt=l(Ue),ce=i(Ue,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-8qlty5"&&(ce.innerHTML=St),_t=l(Ue),pe=i(Ue,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1tyo99t"&&(pe.textContent=Zt),Ue.forEach(t),gt=l(c),J=i(c,"DIV",{class:!0});var nt=v(J);_(ee.$$.fragment,nt),ht=l(nt),_e=i(nt,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-4nmimv"&&(_e.textContent=Rt),nt.forEach(t),ut=l(c),x=i(c,"DIV",{class:!0});var ot=v(x);_(te.$$.fragment,ot),ft=l(ot),ge=i(ot,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-db7iek"&&(ge.textContent=Xt),ot.forEach(t),vt=l(c),O=i(c,"DIV",{class:!0});var lt=v(O);_(ae.$$.fragment,lt),Tt=l(lt),he=i(lt,"P",{"data-svelte-h":!0}),m(he)!=="svelte-18uwvbi"&&(he.textContent=Gt),lt.forEach(t),bt=l(c),w=i(c,"DIV",{class:!0});var Ce=v(w);_(ne.$$.fragment,Ce),Mt=l(Ce),ue=i(Ce,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-xesobz"&&(ue.innerHTML=Vt),yt=l(Ce),fe=i(Ce,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-qg43tm"&&(fe.innerHTML=Yt),Ce.forEach(t),wt=l(c),U=i(c,"DIV",{class:!0});var $e=v(U);_(oe.$$.fragment,$e),Ut=l($e),ve=i($e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-dkae9b"&&(ve.innerHTML=ea),Ct=l($e),Te=i($e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-hmd5cw"&&(Te.innerHTML=ta),$e.forEach(t),$t=l(c),j=i(c,"DIV",{class:!0});var rt=v(j);_(le.$$.fragment,rt),Jt=l(rt),be=i(rt,"P",{"data-svelte-h":!0}),m(be)!=="svelte-svckwe"&&(be.textContent=aa),rt.forEach(t),xt=l(c),I=i(c,"DIV",{class:!0});var it=v(I);_(re.$$.fragment,it),Ot=l(it),Me=i(it,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-nqksfz"&&(Me.innerHTML=na),it.forEach(t),c.forEach(t),Ve=l(e),_(ie.$$.fragment,e),Ye=l(e),b=i(e,"DIV",{class:!0});var Je=v(b);_(se.$$.fragment,Je),jt=l(Je),ye=i(Je,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1gswbgt"&&(ye.innerHTML=oa),It=l(Je),we=i(Je,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1xl7jqc"&&(we.innerHTML=la),Je.forEach(t),et=l(e),je=i(e,"P",{}),v(je).forEach(t),this.h()},h(){T(C,"name","hf:doc:metadata"),T(C,"content",_a),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){n(document.head,C),s(e,Ie,a),s(e,Oe,a),s(e,ke,a),g(k,e,a),s(e,Ne,a),s(e,N,a),s(e,Ae,a),s(e,A,a),s(e,Ke,a),g(K,e,a),s(e,Fe,a),s(e,F,a),s(e,Ee,a),s(e,E,a),s(e,Le,a),s(e,L,a),s(e,De,a),g(D,e,a),s(e,qe,a),s(e,q,a),s(e,He,a),g(H,e,a),s(e,ze,a),s(e,z,a),s(e,Pe,a),g(P,e,a),s(e,Be,a),s(e,B,a),s(e,We,a),s(e,W,a),s(e,Qe,a),s(e,Q,a),s(e,Se,a),g(S,e,a),s(e,Ze,a),s(e,Z,a),s(e,Re,a),g(R,e,a),s(e,Xe,a),g(X,e,a),s(e,Ge,a),s(e,d,a),g(G,d,null),n(d,st),n(d,de),n(d,dt),n(d,$),g(V,$,null),n($,mt),n($,me),n(d,ct),n(d,y),g(Y,y,null),n(y,pt),n(y,ce),n(y,_t),n(y,pe),n(d,gt),n(d,J),g(ee,J,null),n(J,ht),n(J,_e),n(d,ut),n(d,x),g(te,x,null),n(x,ft),n(x,ge),n(d,vt),n(d,O),g(ae,O,null),n(O,Tt),n(O,he),n(d,bt),n(d,w),g(ne,w,null),n(w,Mt),n(w,ue),n(w,yt),n(w,fe),n(d,wt),n(d,U),g(oe,U,null),n(U,Ut),n(U,ve),n(U,Ct),n(U,Te),n(d,$t),n(d,j),g(le,j,null),n(j,Jt),n(j,be),n(d,xt),n(d,I),g(re,I,null),n(I,Ot),n(I,Me),s(e,Ve,a),g(ie,e,a),s(e,Ye,a),s(e,b,a),g(se,b,null),n(b,jt),n(b,ye),n(b,It),n(b,we),s(e,et,a),s(e,je,a),tt=!0},p:ia,i(e){tt||(h(k.$$.fragment,e),h(K.$$.fragment,e),h(D.$$.fragment,e),h(H.$$.fragment,e),h(P.$$.fragment,e),h(S.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),tt=!0)},o(e){u(k.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(H.$$.fragment,e),u(P.$$.fragment,e),u(S.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),tt=!1},d(e){e&&(t(Ie),t(Oe),t(ke),t(Ne),t(N),t(Ae),t(A),t(Ke),t(Fe),t(F),t(Ee),t(E),t(Le),t(L),t(De),t(qe),t(q),t(He),t(ze),t(z),t(Pe),t(Be),t(B),t(We),t(W),t(Qe),t(Q),t(Se),t(Ze),t(Z),t(Re),t(Xe),t(Ge),t(d),t(Ve),t(Ye),t(b),t(et),t(je)),t(C),f(k,e),f(K,e),f(D,e),f(H,e),f(P,e),f(S,e),f(R,e),f(X,e),f(G),f(V),f(Y),f(ee),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(ie,e),f(se)}}}const _a='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function ga(Nt){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends da{constructor(C){super(),ma(this,C,ga,pa,ra,{})}}export{ba as component};
