import{s as _e,n as xe,o as Ne}from"../chunks/scheduler.9bc65507.js";import{S as Ve,i as Re,g as m,s as n,r,A as Qe,h as w,f as l,c as s,j as ke,u as i,x as y,k as Ye,y as Ee,a,v as c,d as o,t as p,w as M}from"../chunks/index.707bf1b6.js";import{C as h}from"../chunks/CodeBlock.54a9f38d.js";import{H as F,E as Fe}from"../chunks/EditOnGithub.922df6ba.js";function He(ge){let d,S,H,K,J,L,T,Ue='As models get bigger, parallelism has emerged as a strategy for training larger models on limited hardware and accelerating training speed by several orders of magnitude. At Hugging Face, we created the <a href="https://huggingface.co/docs/accelerate" rel="nofollow">🤗 Accelerate</a> library to help users easily train a 🤗 Transformers model on any type of distributed setup, whether it is multiple GPU’s on one machine or multiple GPU’s across several machines. In this tutorial, learn how to customize your native PyTorch training loop to enable training in a distributed environment.',P,f,D,j,$e="Get started by installing 🤗 Accelerate:",q,u,O,b,Ie='Then import and create an <a href="https://huggingface.co/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator" rel="nofollow">Accelerator</a> object. The <a href="https://huggingface.co/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator" rel="nofollow">Accelerator</a> will automatically detect your type of distributed setup and initialize all the necessary components for training. You don’t need to explicitly place your model on a device.',ee,g,te,U,le,$,Ce='The next step is to pass all the relevant training objects to the <a href="https://huggingface.co/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow">prepare</a> method. This includes your training and evaluation DataLoaders, a model and an optimizer:',ae,I,ne,C,se,B,Be='The last addition is to replace the typical <code>loss.backward()</code> in your training loop with 🤗 Accelerate’s <a href="https://huggingface.co/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator.backward" rel="nofollow">backward</a>method:',re,A,ie,Z,Ae="As you can see in the following code, you only need to add four additional lines of code to your training loop to enable distributed training!",ce,v,oe,W,pe,G,Ze="Once you’ve added the relevant lines of code, launch your training in a script or a notebook like Colaboratory.",Me,X,me,k,ve="If you are running your training from a script, run the following command to create and save a configuration file:",we,Y,ye,_,We="Then launch your training with:",de,x,he,N,Je,V,Ge='🤗 Accelerate can also run in a notebook if you’re planning on using Colaboratory’s TPUs. Wrap all the code responsible for training in a function, and pass it to <a href="https://huggingface.co/docs/accelerate/v0.29.3/en/package_reference/launchers#accelerate.notebook_launcher" rel="nofollow">notebook_launcher</a>:',Te,R,fe,Q,Xe='For more information about 🤗 Accelerate and its rich features, refer to the <a href="https://huggingface.co/docs/accelerate" rel="nofollow">documentation</a>.',je,E,ue,z,be;return J=new F({props:{title:"Distributed training with 🤗 Accelerate",local:"distributed-training-with--accelerate",headingTag:"h1"}}),f=new F({props:{title:"Setup",local:"setup",headingTag:"h2"}}),u=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),g=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()`,wrap:!1}}),U=new F({props:{title:"Prepare to accelerate",local:"prepare-to-accelerate",headingTag:"h2"}}),I=new h({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
<span class="hljs-meta">... </span>    train_dataloader, eval_dataloader, model, optimizer
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new F({props:{title:"Backward",local:"backward",headingTag:"h2"}}),A=new h({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        accelerator.backward(loss)

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),v=new h({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),W=new F({props:{title:"Train",local:"train",headingTag:"h2"}}),X=new F({props:{title:"Train with a script",local:"train-with-a-script",headingTag:"h3"}}),Y=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),x=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py",wrap:!1}}),N=new F({props:{title:"Train with a notebook",local:"train-with-a-notebook",headingTag:"h3"}}),R=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(training_function)`,wrap:!1}}),E=new Fe({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/accelerate.md"}}),{c(){d=m("meta"),S=n(),H=m("p"),K=n(),r(J.$$.fragment),L=n(),T=m("p"),T.innerHTML=Ue,P=n(),r(f.$$.fragment),D=n(),j=m("p"),j.textContent=$e,q=n(),r(u.$$.fragment),O=n(),b=m("p"),b.innerHTML=Ie,ee=n(),r(g.$$.fragment),te=n(),r(U.$$.fragment),le=n(),$=m("p"),$.innerHTML=Ce,ae=n(),r(I.$$.fragment),ne=n(),r(C.$$.fragment),se=n(),B=m("p"),B.innerHTML=Be,re=n(),r(A.$$.fragment),ie=n(),Z=m("p"),Z.textContent=Ae,ce=n(),r(v.$$.fragment),oe=n(),r(W.$$.fragment),pe=n(),G=m("p"),G.textContent=Ze,Me=n(),r(X.$$.fragment),me=n(),k=m("p"),k.textContent=ve,we=n(),r(Y.$$.fragment),ye=n(),_=m("p"),_.textContent=We,de=n(),r(x.$$.fragment),he=n(),r(N.$$.fragment),Je=n(),V=m("p"),V.innerHTML=Ge,Te=n(),r(R.$$.fragment),fe=n(),Q=m("p"),Q.innerHTML=Xe,je=n(),r(E.$$.fragment),ue=n(),z=m("p"),this.h()},l(e){const t=Qe("svelte-u9bgzb",document.head);d=w(t,"META",{name:!0,content:!0}),t.forEach(l),S=s(e),H=w(e,"P",{}),ke(H).forEach(l),K=s(e),i(J.$$.fragment,e),L=s(e),T=w(e,"P",{"data-svelte-h":!0}),y(T)!=="svelte-11mv690"&&(T.innerHTML=Ue),P=s(e),i(f.$$.fragment,e),D=s(e),j=w(e,"P",{"data-svelte-h":!0}),y(j)!=="svelte-1wyzwc5"&&(j.textContent=$e),q=s(e),i(u.$$.fragment,e),O=s(e),b=w(e,"P",{"data-svelte-h":!0}),y(b)!=="svelte-10qwty5"&&(b.innerHTML=Ie),ee=s(e),i(g.$$.fragment,e),te=s(e),i(U.$$.fragment,e),le=s(e),$=w(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-7zwcbz"&&($.innerHTML=Ce),ae=s(e),i(I.$$.fragment,e),ne=s(e),i(C.$$.fragment,e),se=s(e),B=w(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-xjlbll"&&(B.innerHTML=Be),re=s(e),i(A.$$.fragment,e),ie=s(e),Z=w(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-tbmaal"&&(Z.textContent=Ae),ce=s(e),i(v.$$.fragment,e),oe=s(e),i(W.$$.fragment,e),pe=s(e),G=w(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1bmx0kl"&&(G.textContent=Ze),Me=s(e),i(X.$$.fragment,e),me=s(e),k=w(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-d65x2y"&&(k.textContent=ve),we=s(e),i(Y.$$.fragment,e),ye=s(e),_=w(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-xc3fgn"&&(_.textContent=We),de=s(e),i(x.$$.fragment,e),he=s(e),i(N.$$.fragment,e),Je=s(e),V=w(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1gy0624"&&(V.innerHTML=Ge),Te=s(e),i(R.$$.fragment,e),fe=s(e),Q=w(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-5m2lvn"&&(Q.innerHTML=Xe),je=s(e),i(E.$$.fragment,e),ue=s(e),z=w(e,"P",{}),ke(z).forEach(l),this.h()},h(){Ye(d,"name","hf:doc:metadata"),Ye(d,"content",ze)},m(e,t){Ee(document.head,d),a(e,S,t),a(e,H,t),a(e,K,t),c(J,e,t),a(e,L,t),a(e,T,t),a(e,P,t),c(f,e,t),a(e,D,t),a(e,j,t),a(e,q,t),c(u,e,t),a(e,O,t),a(e,b,t),a(e,ee,t),c(g,e,t),a(e,te,t),c(U,e,t),a(e,le,t),a(e,$,t),a(e,ae,t),c(I,e,t),a(e,ne,t),c(C,e,t),a(e,se,t),a(e,B,t),a(e,re,t),c(A,e,t),a(e,ie,t),a(e,Z,t),a(e,ce,t),c(v,e,t),a(e,oe,t),c(W,e,t),a(e,pe,t),a(e,G,t),a(e,Me,t),c(X,e,t),a(e,me,t),a(e,k,t),a(e,we,t),c(Y,e,t),a(e,ye,t),a(e,_,t),a(e,de,t),c(x,e,t),a(e,he,t),c(N,e,t),a(e,Je,t),a(e,V,t),a(e,Te,t),c(R,e,t),a(e,fe,t),a(e,Q,t),a(e,je,t),c(E,e,t),a(e,ue,t),a(e,z,t),be=!0},p:xe,i(e){be||(o(J.$$.fragment,e),o(f.$$.fragment,e),o(u.$$.fragment,e),o(g.$$.fragment,e),o(U.$$.fragment,e),o(I.$$.fragment,e),o(C.$$.fragment,e),o(A.$$.fragment,e),o(v.$$.fragment,e),o(W.$$.fragment,e),o(X.$$.fragment,e),o(Y.$$.fragment,e),o(x.$$.fragment,e),o(N.$$.fragment,e),o(R.$$.fragment,e),o(E.$$.fragment,e),be=!0)},o(e){p(J.$$.fragment,e),p(f.$$.fragment,e),p(u.$$.fragment,e),p(g.$$.fragment,e),p(U.$$.fragment,e),p(I.$$.fragment,e),p(C.$$.fragment,e),p(A.$$.fragment,e),p(v.$$.fragment,e),p(W.$$.fragment,e),p(X.$$.fragment,e),p(Y.$$.fragment,e),p(x.$$.fragment,e),p(N.$$.fragment,e),p(R.$$.fragment,e),p(E.$$.fragment,e),be=!1},d(e){e&&(l(S),l(H),l(K),l(L),l(T),l(P),l(D),l(j),l(q),l(O),l(b),l(ee),l(te),l(le),l($),l(ae),l(ne),l(se),l(B),l(re),l(ie),l(Z),l(ce),l(oe),l(pe),l(G),l(Me),l(me),l(k),l(we),l(ye),l(_),l(de),l(he),l(Je),l(V),l(Te),l(fe),l(Q),l(je),l(ue),l(z)),l(d),M(J,e),M(f,e),M(u,e),M(g,e),M(U,e),M(I,e),M(C,e),M(A,e),M(v,e),M(W,e),M(X,e),M(Y,e),M(x,e),M(N,e),M(R,e),M(E,e)}}}const ze='{"title":"Distributed training with 🤗 Accelerate","local":"distributed-training-with--accelerate","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Prepare to accelerate","local":"prepare-to-accelerate","sections":[],"depth":2},{"title":"Backward","local":"backward","sections":[],"depth":2},{"title":"Train","local":"train","sections":[{"title":"Train with a script","local":"train-with-a-script","sections":[],"depth":3},{"title":"Train with a notebook","local":"train-with-a-notebook","sections":[],"depth":3}],"depth":2}],"depth":1}';function Se(ge){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qe extends Ve{constructor(d){super(),Re(this,d,Se,He,_e,{})}}export{qe as component};
