import{s as St,o as Bt,n as Vt}from"../chunks/scheduler.6062bdaf.js";import{S as Rt,i as Xt,g as i,s as l,r,A as Qt,h as p,f as t,c as n,j as E,u as c,x as u,k as N,y as g,a as e,v as o,d,t as m,w as h}from"../chunks/index.4bca734e.js";import{T as Ht}from"../chunks/Tip.b9ac1f03.js";import{D as Hs}from"../chunks/Docstring.ff53aa02.js";import{C as _}from"../chunks/CodeBlock.cbbddafc.js";import{E as At}from"../chunks/ExampleCodeBlock.d2834193.js";import{H as w,E as Lt}from"../chunks/index.60dd99e8.js";function Dt(Es){let f,$=`Method <code>.validate()</code> is a reserved name on strict dataclasses.
To prevent unexpected behaviors, a <code>StrictDataclassDefinitionError</code> error will be raised if your class already defines one.`;return{c(){f=i("p"),f.innerHTML=$},l(j){f=p(j,"P",{"data-svelte-h":!0}),u(f)!=="svelte-35foux"&&(f.innerHTML=$)},m(j,v){e(j,f,v)},p:Vt,d(j){j&&t(f)}}}function qt(Es){let f,$="Example:",j,v,T;return v=new _({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMGFzX3ZhbGlkYXRlZF9maWVsZCUyQyUyMHN0cmljdCUyQyUyMHZhbGlkYXRlZF9maWVsZCUwQSUwQSU0MGFzX3ZhbGlkYXRlZF9maWVsZCUwQWRlZiUyMHBvc2l0aXZlX2ludCh2YWx1ZSUzQSUyMGludCklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHZhbHVlJTIwJTNFJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyVmFsdWUlMjBtdXN0JTIwYmUlMjBwb3NpdGl2ZSUyQyUyMGdvdCUyMCU3QnZhbHVlJTdEJTIyKSUwQSUwQSU0MHN0cmljdChhY2NlcHRfa3dhcmdzJTNEVHJ1ZSklMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVzZXIlM0ElMEElMjAlMjAlMjAlMjBuYW1lJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwYWdlJTNBJTIwaW50JTIwJTNEJTIwcG9zaXRpdmVfaW50KGRlZmF1bHQlM0QxMCklMEElMEFVc2VyKG5hbWUlM0QlMjJKb2huJTIyKSUwQSUwQVVzZXIobmFtZSUzRCUyMkpvaG4lMjIlMkMlMjBhZ2UlM0QzMCUyQyUyMGxhc3RuYW1lJTNEJTIyRG9lJTIyKSUwQSUwQVVzZXIobmFtZSUzRCUyMkpvaG4lMjIlMkMlMjBhZ2UlM0QlMjIzMCUyMiklMEElMEFVc2VyKG5hbWUlM0QlMjJKb2huJTIyJTJDJTIwYWdlJTNELTEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> as_validated_field, strict, validated_field

<span class="hljs-meta">&gt;&gt;&gt; </span>@as_validated_field
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">positive_int</span>(<span class="hljs-params">value: <span class="hljs-built_in">int</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> value &gt;= <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Value must be positive, got <span class="hljs-subst">{value}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>@strict(accept_kwargs=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">User</span>:
<span class="hljs-meta">... </span>    name: <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>    age: <span class="hljs-built_in">int</span> = positive_int(default=<span class="hljs-number">10</span>)

<span class="hljs-comment"># Initialize</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>)
User(name=<span class="hljs-string">&#x27;John&#x27;</span>, age=<span class="hljs-number">10</span>)

<span class="hljs-comment"># Extra kwargs are accepted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>, age=<span class="hljs-number">30</span>, lastname=<span class="hljs-string">&quot;Doe&quot;</span>)
User(name=<span class="hljs-string">&#x27;John&#x27;</span>, age=<span class="hljs-number">30</span>, *lastname=<span class="hljs-string">&#x27;Doe&#x27;</span>)

<span class="hljs-comment"># Invalid type =&gt; raises</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>, age=<span class="hljs-string">&quot;30&quot;</span>)
huggingface_hub.errors.StrictDataclassFieldValidationError: Validation error <span class="hljs-keyword">for</span> field <span class="hljs-string">&#x27;age&#x27;</span>:
    TypeError: Field <span class="hljs-string">&#x27;age&#x27;</span> expected <span class="hljs-built_in">int</span>, got <span class="hljs-built_in">str</span> (value: <span class="hljs-string">&#x27;30&#x27;</span>)

<span class="hljs-comment"># Invalid value =&gt; raises</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>, age=-<span class="hljs-number">1</span>)
huggingface_hub.errors.StrictDataclassFieldValidationError: Validation error <span class="hljs-keyword">for</span> field <span class="hljs-string">&#x27;age&#x27;</span>:
    ValueError: Value must be positive, got -<span class="hljs-number">1</span>`,wrap:!1}}),{c(){f=i("p"),f.textContent=$,j=l(),r(v.$$.fragment)},l(y){f=p(y,"P",{"data-svelte-h":!0}),u(f)!=="svelte-11lpom8"&&(f.textContent=$),j=n(y),c(v.$$.fragment,y)},m(y,U){e(y,f,U),e(y,j,U),o(v,y,U),T=!0},p:Vt,i(y){T||(d(v.$$.fragment,y),T=!0)},o(y){m(v.$$.fragment,y),T=!1},d(y){y&&(t(f),t(j)),h(v,y)}}}function Pt(Es){let f,$,j,v,T,y,U,rt="The <code>huggingface_hub</code> package provides a utility to create <strong>strict dataclasses</strong>. These are enhanced versions of Python’s standard <code>dataclass</code> with additional validation features. Strict dataclasses ensure that fields are validated both during initialization and assignment, making them ideal for scenarios where data integrity is critical.",Ls,Y,Ds,W,ct="Strict dataclasses are created using the <code>@strict</code> decorator. They extend the functionality of regular dataclasses by:",qs,z,ot="<li>Validating field types based on type hints</li> <li>Supporting custom validators for additional checks</li> <li>Optionally allowing arbitrary keyword arguments in the constructor</li> <li>Validating fields both at initialization and during assignment</li>",Ps,F,Ks,V,dt="<li><strong>Data Integrity</strong>: Ensures fields always contain valid data</li> <li><strong>Ease of Use</strong>: Integrates seamlessly with Python’s <code>dataclass</code> module</li> <li><strong>Flexibility</strong>: Supports custom validators for complex validation logic</li> <li><strong>Lightweight</strong>: Requires no additional dependencies such as Pydantic, attrs, or similar libraries</li>",Os,S,sa,B,aa,R,ta,X,mt="Fields are validated during initialization:",ea,Q,la,H,ht="Consistency between fields is also validated during initialization (class-wise validation):",na,A,ia,L,ut="Fields are also validated during assignment:",pa,D,ra,q,ft="To re-run class-wide validation after assignment, you must call <code>.validate</code> explicitly:",ca,P,oa,K,da,O,gt="You can attach multiple custom validators to fields using <code>validated_field</code>. A validator is a callable that takes a single argument and raises an exception if the value is invalid.",ma,ss,ha,as,yt="In this example, both validators are applied to the <code>hidden_size</code> field.",ua,ts,fa,es,Mt="By default, strict dataclasses only accept fields defined in the class. You can allow additional keyword arguments by setting <code>accept_kwargs=True</code> in the <code>@strict</code> decorator.",ga,ls,ya,ns,jt="Additional keyword arguments appear in the string representation of the dataclass but are prefixed with <code>*</code> to highlight that they are not validated.",Ma,is,ja,ps,bt="Strict dataclasses respect type hints and validate them automatically. For example:",ba,rs,wa,cs,wt="Supported types include:",va,os,vt="<li>Any</li> <li>Union</li> <li>Optional</li> <li>Literal</li> <li>List</li> <li>Dict</li> <li>Tuple</li> <li>Set</li>",Ta,ds,Tt="And any combination of these types. If your need more complex type validation, you can do it through a custom validator.",Ua,ms,Ja,hs,Ut="Methods named <code>validate_xxx</code> are treated as class validators. These methods must only take <code>self</code> as an argument. Class validators are run once during initialization, right after <code>__post_init__</code>. You can define as many of them as needed—they’ll be executed sequentially in the order they appear.",$a,us,Jt="Note that class validators are not automatically re-run when a field is updated after initialization. To manually re-validate the object, you need to call <code>obj.validate()</code>.",_a,fs,Ca,G,Za,gs,Ia,ys,xa,Ms,$t="The <code>@strict</code> decorator enhances a dataclass with strict validation.",Ga,M,js,Pa,Ns,_t="Decorator to add strict validation to a dataclass.",Ka,Ys,Ct=`This decorator must be used on top of <code>@dataclass</code> to ensure IDEs and static typing tools
recognize the class as a dataclass.`,Oa,Ws,Zt="Can be used with or without arguments:",st,zs,It="<li><code>@strict</code></li> <li><code>@strict(accept_kwargs=True)</code></li>",at,k,ka,bs,Ea,ws,xt="Decorator to create a <code>validated_field</code>. Recommended for fields with a single validator to avoid boilerplate code.",Na,C,vs,tt,Fs,Gt="Decorates a validator function as a <code>validated_field</code> (i.e. a dataclass field with a custom validator).",Ya,Ts,Wa,Us,kt="Creates a dataclass field with custom validation.",za,J,Js,et,Vs,Et="Create a dataclass field with a custom validator.",lt,Ss,Nt="Useful to apply several checks to a field. If only applying one rule, check out the <code>as_validated_field</code> decorator.",Fa,$s,Va,Z,_s,nt,Bs,Yt="Base exception for strict dataclasses.",Sa,I,Cs,it,Rs,Wt="Exception thrown when a strict dataclass is defined incorrectly.",Ba,x,Zs,pt,Xs,zt="Exception thrown when a strict dataclass fails validation for a given field.",Ra,Is,Xa,xs,Ft='<li>See discussion in <a href="https://github.com/huggingface/transformers/issues/36329" rel="nofollow">https://github.com/huggingface/transformers/issues/36329</a> regarding adding Pydantic as a dependency. It would be a heavy addition and require careful logic to support both v1 and v2.</li> <li>We don’t need most of Pydantic’s features, especially those related to automatic casting, jsonschema, serialization, aliases, etc.</li> <li>We don’t need the ability to instantiate a class from a dictionary.</li> <li>We don’t want to mutate data. In <code>@strict</code>, “validation” means “checking if a value is valid.” In Pydantic, “validation” means “casting a value, possibly mutating it, and then checking if it’s valid.”</li> <li>We don’t need blazing-fast validation. <code>@strict</code> isn’t designed for heavy loads where performance is critical. Common use cases involve validating a model configuration (performed once and negligible compared to running a model). This allows us to keep the code minimal.</li>',Qa,Gs,Ha,As,Aa;return T=new w({props:{title:"Strict Dataclasses",local:"strict-dataclasses",headingTag:"h1"}}),Y=new w({props:{title:"Overview",local:"overview",headingTag:"h2"}}),F=new w({props:{title:"Benefits",local:"benefits",headingTag:"h2"}}),S=new w({props:{title:"Usage",local:"usage",headingTag:"h2"}}),B=new w({props:{title:"Basic Example",local:"basic-example",headingTag:"h3"}}),R=new _({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUyQyUyMGFzX3ZhbGlkYXRlZF9maWVsZCUwQSUwQSUyMyUyMEN1c3RvbSUyMHZhbGlkYXRvciUyMHRvJTIwZW5zdXJlJTIwYSUyMHZhbHVlJTIwaXMlMjBwb3NpdGl2ZSUwQSU0MGFzX3ZhbGlkYXRlZF9maWVsZCUwQWRlZiUyMHBvc2l0aXZlX2ludCh2YWx1ZSUzQSUyMGludCklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHZhbHVlJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyVmFsdWUlMjBtdXN0JTIwYmUlMjBwb3NpdGl2ZSUyQyUyMGdvdCUyMCU3QnZhbHVlJTdEJTIyKSUwQSUwQSU0MHN0cmljdCUwQSU0MGRhdGFjbGFzcyUwQWNsYXNzJTIwQ29uZmlnJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zaXplJTNBJTIwaW50JTIwJTNEJTIwcG9zaXRpdmVfaW50KGRlZmF1bHQlM0QxNiklMEElMjAlMjAlMjAlMjB2b2NhYl9zaXplJTNBJTIwaW50JTIwJTNEJTIwMzIlMjAlMjAlMjMlMjBEZWZhdWx0JTIwdmFsdWUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBNZXRob2RzJTIwbmFtZWQlMjAlNjB2YWxpZGF0ZV94eHglNjAlMjBhcmUlMjB0cmVhdGVkJTIwYXMlMjBjbGFzcy13aXNlJTIwdmFsaWRhdG9ycyUwQSUyMCUyMCUyMCUyMGRlZiUyMHZhbGlkYXRlX2JpZ19lbm91Z2hfdm9jYWIoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYudm9jYWJfc2l6ZSUyMCUzQyUyMHNlbGYuaGlkZGVuX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMFZhbHVlRXJyb3IoZiUyMnZvY2FiX3NpemUlMjAoJTdCc2VsZi52b2NhYl9zaXplJTdEKSUyMG11c3QlMjBiZSUyMGdyZWF0ZXIlMjB0aGFuJTIwaGlkZGVuX3NpemUlMjAoJTdCc2VsZi5oaWRkZW5fc2l6ZSU3RCklMjIp",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict, as_validated_field

<span class="hljs-comment"># Custom validator to ensure a value is positive</span>
<span class="hljs-meta">@as_validated_field</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">positive_int</span>(<span class="hljs-params">value: <span class="hljs-built_in">int</span></span>):
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> value &gt; <span class="hljs-number">0</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Value must be positive, got <span class="hljs-subst">{value}</span>&quot;</span>)

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    model_type: <span class="hljs-built_in">str</span>
    hidden_size: <span class="hljs-built_in">int</span> = positive_int(default=<span class="hljs-number">16</span>)
    vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">32</span>  <span class="hljs-comment"># Default value</span>

    <span class="hljs-comment"># Methods named \`validate_xxx\` are treated as class-wise validators</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_big_enough_vocab</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.vocab_size &lt; self.hidden_size:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;vocab_size (<span class="hljs-subst">{self.vocab_size}</span>) must be greater than hidden_size (<span class="hljs-subst">{self.hidden_size}</span>)&quot;</span>)`,wrap:!1}}),Q=new _({props:{code:"Y29uZmlnJTIwJTNEJTIwQ29uZmlnKG1vZGVsX3R5cGUlM0QlMjJiZXJ0JTIyJTJDJTIwaGlkZGVuX3NpemUlM0QyNCklMjAlMjAlMjAlMjMlMjBWYWxpZCUwQWNvbmZpZyUyMCUzRCUyMENvbmZpZyhtb2RlbF90eXBlJTNEJTIyYmVydCUyMiUyQyUyMGhpZGRlbl9zaXplJTNELTEpJTIwJTIwJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzRmllbGRWYWxpZGF0aW9uRXJyb3I=",highlighted:`config = Config(model_type=<span class="hljs-string">&quot;bert&quot;</span>, hidden_size=<span class="hljs-number">24</span>)   <span class="hljs-comment"># Valid</span>
config = Config(model_type=<span class="hljs-string">&quot;bert&quot;</span>, hidden_size=-<span class="hljs-number">1</span>)   <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),A=new _({props:{code:"JTIzJTIwJTYwdm9jYWJfc2l6ZSU2MCUyMHRvbyUyMHNtYWxsJTIwY29tcGFyZWQlMjB0byUyMCU2MGhpZGRlbl9zaXplJTYwJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnKG1vZGVsX3R5cGUlM0QlMjJiZXJ0JTIyJTJDJTIwaGlkZGVuX3NpemUlM0QzMiUyQyUyMHZvY2FiX3NpemUlM0QxNiklMjAlMjAlMjAlMjMlMjBSYWlzZXMlMjBTdHJpY3REYXRhY2xhc3NDbGFzc1ZhbGlkYXRpb25FcnJvcg==",highlighted:'<span class="hljs-comment"># `vocab_size` too small compared to `hidden_size`</span>\nconfig = Config(model_type=<span class="hljs-string">&quot;bert&quot;</span>, hidden_size=<span class="hljs-number">32</span>, vocab_size=<span class="hljs-number">16</span>)   <span class="hljs-comment"># Raises StrictDataclassClassValidationError</span>',wrap:!1}}),D=new _({props:{code:"Y29uZmlnLmhpZGRlbl9zaXplJTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwVmFsaWQlMEFjb25maWcuaGlkZGVuX3NpemUlMjAlM0QlMjAtMSUyMCUyMCUyMCUyMyUyMFJhaXNlcyUyMFN0cmljdERhdGFjbGFzc0ZpZWxkVmFsaWRhdGlvbkVycm9y",highlighted:`config.hidden_size = <span class="hljs-number">512</span>  <span class="hljs-comment"># Valid</span>
config.hidden_size = -<span class="hljs-number">1</span>   <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),P=new _({props:{code:"Y29uZmlnLnZhbGlkYXRlKCklMjAlMjAlMjMlMjBSdW5zJTIwYWxsJTIwY2xhc3MlMjB2YWxpZGF0b3Jz",highlighted:'config.validate()  <span class="hljs-comment"># Runs all class validators</span>',wrap:!1}}),K=new w({props:{title:"Custom Validators",local:"custom-validators",headingTag:"h3"}}),ss=new _({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUyQyUyMHZhbGlkYXRlZF9maWVsZCUwQSUwQWRlZiUyMG11bHRpcGxlX29mXzY0KHZhbHVlJTNBJTIwaW50KSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwdmFsdWUlMjAlMjUlMjA2NCUyMCElM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKGYlMjJWYWx1ZSUyMG11c3QlMjBiZSUyMGElMjBtdWx0aXBsZSUyMG9mJTIwNjQlMkMlMjBnb3QlMjAlN0J2YWx1ZSU3RCUyMiklMEElMEElNDBzdHJpY3QlMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMENvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zaXplJTNBJTIwaW50JTIwJTNEJTIwdmFsaWRhdGVkX2ZpZWxkKHZhbGlkYXRvciUzRCU1QnBvc2l0aXZlX2ludCUyQyUyMG11bHRpcGxlX29mXzY0JTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict, validated_field

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiple_of_64</span>(<span class="hljs-params">value: <span class="hljs-built_in">int</span></span>):
    <span class="hljs-keyword">if</span> value % <span class="hljs-number">64</span> != <span class="hljs-number">0</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Value must be a multiple of 64, got <span class="hljs-subst">{value}</span>&quot;</span>)

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    hidden_size: <span class="hljs-built_in">int</span> = validated_field(validator=[positive_int, multiple_of_64])`,wrap:!1}}),ts=new w({props:{title:"Additional Keyword Arguments",local:"additional-keyword-arguments",headingTag:"h3"}}),ls=new _({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUwQSUwQSU0MHN0cmljdChhY2NlcHRfa3dhcmdzJTNEVHJ1ZSklMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMENvbmZpZ1dpdGhLd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjBtb2RlbF90eXBlJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDE2JTBBJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnV2l0aEt3YXJncyhtb2RlbF90eXBlJTNEJTIyYmVydCUyMiUyQyUyMHZvY2FiX3NpemUlM0QzMDAwMCUyQyUyMGV4dHJhX2ZpZWxkJTNEJTIyZXh0cmFfdmFsdWUlMjIpJTBBcHJpbnQoY29uZmlnKSUyMCUyMCUyMyUyMENvbmZpZ1dpdGhLd2FyZ3MobW9kZWxfdHlwZSUzRCdiZXJ0JyUyQyUyMHZvY2FiX3NpemUlM0QzMDAwMCUyQyUyMCpleHRyYV9maWVsZCUzRCdleHRyYV92YWx1ZScp",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict

<span class="hljs-meta">@strict(<span class="hljs-params">accept_kwargs=<span class="hljs-literal">True</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ConfigWithKwargs</span>:
    model_type: <span class="hljs-built_in">str</span>
    vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>

config = ConfigWithKwargs(model_type=<span class="hljs-string">&quot;bert&quot;</span>, vocab_size=<span class="hljs-number">30000</span>, extra_field=<span class="hljs-string">&quot;extra_value&quot;</span>)
<span class="hljs-built_in">print</span>(config)  <span class="hljs-comment"># ConfigWithKwargs(model_type=&#x27;bert&#x27;, vocab_size=30000, *extra_field=&#x27;extra_value&#x27;)</span>`,wrap:!1}}),is=new w({props:{title:"Integration with Type Hints",local:"integration-with-type-hints",headingTag:"h3"}}),rs=new _({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLmRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwc3RyaWN0JTBBJTBBJTQwc3RyaWN0JTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBDb25maWclM0ElMEElMjAlMjAlMjAlMjBsYXllcnMlM0ElMjBMaXN0JTVCaW50JTVEJTBBJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnKGxheWVycyUzRCU1QjY0JTJDJTIwMTI4JTVEKSUyMCUyMCUyMyUyMFZhbGlkJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnKGxheWVycyUzRCUyMm5vdF9hX2xpc3QlMjIpJTIwJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzRmllbGRWYWxpZGF0aW9uRXJyb3I=",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>]

config = Config(layers=[<span class="hljs-number">64</span>, <span class="hljs-number">128</span>])  <span class="hljs-comment"># Valid</span>
config = Config(layers=<span class="hljs-string">&quot;not_a_list&quot;</span>)  <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),ms=new w({props:{title:"Class validators",local:"class-validators",headingTag:"h3"}}),fs=new _({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUwQSUwQSU0MHN0cmljdCUwQSU0MGRhdGFjbGFzcyUwQWNsYXNzJTIwQ29uZmlnJTNBJTBBJTIwJTIwJTIwJTIwZm9vJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwZm9vX2xlbmd0aCUzQSUyMGludCUwQSUyMCUyMCUyMCUyMHVwcGVyX2Nhc2UlM0ElMjBib29sJTIwJTNEJTIwRmFsc2UlMEElMEElMjAlMjAlMjAlMjBkZWYlMjB2YWxpZGF0ZV9mb29fbGVuZ3RoKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc2VsZi5mb28pJTIwISUzRCUyMHNlbGYuZm9vX2xlbmd0aCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyZm9vJTIwbXVzdCUyMGJlJTIwJTdCc2VsZi5mb29fbGVuZ3RoJTdEJTIwY2hhcmFjdGVycyUyMGxvbmclMkMlMjBnb3QlMjAlN0JsZW4oc2VsZi5mb28pJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHZhbGlkYXRlX2Zvb19jYXNpbmcoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYudXBwZXJfY2FzZSUyMGFuZCUyMHNlbGYuZm9vLnVwcGVyKCklMjAhJTNEJTIwc2VsZi5mb28lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMFZhbHVlRXJyb3IoZiUyMmZvbyUyMG11c3QlMjBiZSUyMHVwcGVyY2FzZSUyQyUyMGdvdCUyMCU3QnNlbGYuZm9vJTdEJTIyKSUwQSUwQWNvbmZpZyUyMCUzRCUyMENvbmZpZyhmb28lM0QlMjJiYXIlMjIlMkMlMjBmb29fbGVuZ3RoJTNEMyklMjAlMjMlMjBvayUwQSUwQWNvbmZpZy51cHBlcl9jYXNlJTIwJTNEJTIwVHJ1ZSUwQWNvbmZpZy52YWxpZGF0ZSgpJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzQ2xhc3NWYWxpZGF0aW9uRXJyb3IlMEElMEFDb25maWcoZm9vJTNEJTIyYWJjZCUyMiUyQyUyMGZvb19sZW5ndGglM0QzKSUyMCUyMyUyMFJhaXNlcyUyMFN0cmljdERhdGFjbGFzc0ZpZWxkVmFsaWRhdGlvbkVycm9yJTBBQ29uZmlnKGZvbyUzRCUyMkJhciUyMiUyQyUyMGZvb19sZW5ndGglM0QzJTJDJTIwdXBwZXJfY2FzZSUzRFRydWUpJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzRmllbGRWYWxpZGF0aW9uRXJyb3I=",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    foo: <span class="hljs-built_in">str</span>
    foo_length: <span class="hljs-built_in">int</span>
    upper_case: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_foo_length</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(self.foo) != self.foo_length:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;foo must be <span class="hljs-subst">{self.foo_length}</span> characters long, got <span class="hljs-subst">{<span class="hljs-built_in">len</span>(self.foo)}</span>&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_foo_casing</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.upper_case <span class="hljs-keyword">and</span> self.foo.upper() != self.foo:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;foo must be uppercase, got <span class="hljs-subst">{self.foo}</span>&quot;</span>)

config = Config(foo=<span class="hljs-string">&quot;bar&quot;</span>, foo_length=<span class="hljs-number">3</span>) <span class="hljs-comment"># ok</span>

config.upper_case = <span class="hljs-literal">True</span>
config.validate() <span class="hljs-comment"># Raises StrictDataclassClassValidationError</span>

Config(foo=<span class="hljs-string">&quot;abcd&quot;</span>, foo_length=<span class="hljs-number">3</span>) <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>
Config(foo=<span class="hljs-string">&quot;Bar&quot;</span>, foo_length=<span class="hljs-number">3</span>, upper_case=<span class="hljs-literal">True</span>) <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),G=new Ht({props:{warning:!0,$$slots:{default:[Dt]},$$scope:{ctx:Es}}}),gs=new w({props:{title:"API Reference",local:"api-reference",headingTag:"h2"}}),ys=new w({props:{title:"@strict",local:"huggingface_hub.dataclasses.strict",headingTag:"h3"}}),js=new Hs({props:{name:"huggingface_hub.dataclasses.strict",anchor:"huggingface_hub.dataclasses.strict",parameters:[{name:"accept_kwargs",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.dataclasses.strict.cls",description:`<strong>cls</strong> &#x2014;
The class to convert to a strict dataclass.`,name:"cls"},{anchor:"huggingface_hub.dataclasses.strict.accept_kwargs",description:`<strong>accept_kwargs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, allows arbitrary keyword arguments in <code>__init__</code>. Defaults to False.`,name:"accept_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/dataclasses.py#L40",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The enhanced dataclass with strict validation on field assignment.</p>
`}}),k=new At({props:{anchor:"huggingface_hub.dataclasses.strict.example",$$slots:{default:[qt]},$$scope:{ctx:Es}}}),bs=new w({props:{title:"as_validated_field",local:"huggingface_hub.dataclasses.as_validated_field",headingTag:"h3"}}),vs=new Hs({props:{name:"huggingface_hub.dataclasses.as_validated_field",anchor:"huggingface_hub.dataclasses.as_validated_field",parameters:[{name:"validator",val:": typing.Callable[[typing.Any], NoneType]"}],parametersDescription:[{anchor:"huggingface_hub.dataclasses.as_validated_field.validator",description:`<strong>validator</strong> (<code>Callable</code>) &#x2014;
A method that takes a value as input and raises ValueError/TypeError if the value is invalid.`,name:"validator"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/dataclasses.py#L283"}}),Ts=new w({props:{title:"validated_field",local:"huggingface_hub.dataclasses.validated_field",headingTag:"h3"}}),Js=new Hs({props:{name:"huggingface_hub.dataclasses.validated_field",anchor:"huggingface_hub.dataclasses.validated_field",parameters:[{name:"validator",val:": typing.Union[typing.List[typing.Callable[[typing.Any], NoneType]], typing.Callable[[typing.Any], NoneType]]"},{name:"default",val:": typing.Union[typing.Any, dataclasses._MISSING_TYPE] = <dataclasses._MISSING_TYPE object at 0x7f1ee9517580>"},{name:"default_factory",val:": typing.Union[typing.Callable[[], typing.Any], dataclasses._MISSING_TYPE] = <dataclasses._MISSING_TYPE object at 0x7f1ee9517580>"},{name:"init",val:": bool = True"},{name:"repr",val:": bool = True"},{name:"hash",val:": typing.Optional[bool] = None"},{name:"compare",val:": bool = True"},{name:"metadata",val:": typing.Optional[typing.Dict] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"huggingface_hub.dataclasses.validated_field.validator",description:`<strong>validator</strong> (<code>Callable</code> or <code>List[Callable]</code>) &#x2014;
A method that takes a value as input and raises ValueError/TypeError if the value is invalid.
Can be a list of validators to apply multiple checks.`,name:"validator"},{anchor:"huggingface_hub.dataclasses.validated_field.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional arguments to pass to <code>dataclasses.field()</code>.`,name:"*kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/dataclasses.py#L240",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A field with the validator attached in metadata</p>
`}}),$s=new w({props:{title:"Errors",local:"huggingface_hub.errors.StrictDataclassError",headingTag:"h3"}}),_s=new Hs({props:{name:"class huggingface_hub.errors.StrictDataclassError",anchor:"huggingface_hub.errors.StrictDataclassError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L335"}}),Cs=new Hs({props:{name:"class huggingface_hub.errors.StrictDataclassDefinitionError",anchor:"huggingface_hub.errors.StrictDataclassDefinitionError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L339"}}),Zs=new Hs({props:{name:"class huggingface_hub.errors.StrictDataclassFieldValidationError",anchor:"huggingface_hub.errors.StrictDataclassFieldValidationError",parameters:[{name:"field",val:": str"},{name:"cause",val:": Exception"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L343"}}),Is=new w({props:{title:"Why Not Use pydantic ? (or attrs ? or marshmallow_dataclass ?)",local:"why-not-use-pydantic--or-attrs--or-marshmallowdataclass-",headingTag:"h2"}}),Gs=new Lt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/dataclasses.md"}}),{c(){f=i("meta"),$=l(),j=i("p"),v=l(),r(T.$$.fragment),y=l(),U=i("p"),U.innerHTML=rt,Ls=l(),r(Y.$$.fragment),Ds=l(),W=i("p"),W.innerHTML=ct,qs=l(),z=i("ul"),z.innerHTML=ot,Ps=l(),r(F.$$.fragment),Ks=l(),V=i("ul"),V.innerHTML=dt,Os=l(),r(S.$$.fragment),sa=l(),r(B.$$.fragment),aa=l(),r(R.$$.fragment),ta=l(),X=i("p"),X.textContent=mt,ea=l(),r(Q.$$.fragment),la=l(),H=i("p"),H.textContent=ht,na=l(),r(A.$$.fragment),ia=l(),L=i("p"),L.textContent=ut,pa=l(),r(D.$$.fragment),ra=l(),q=i("p"),q.innerHTML=ft,ca=l(),r(P.$$.fragment),oa=l(),r(K.$$.fragment),da=l(),O=i("p"),O.innerHTML=gt,ma=l(),r(ss.$$.fragment),ha=l(),as=i("p"),as.innerHTML=yt,ua=l(),r(ts.$$.fragment),fa=l(),es=i("p"),es.innerHTML=Mt,ga=l(),r(ls.$$.fragment),ya=l(),ns=i("p"),ns.innerHTML=jt,Ma=l(),r(is.$$.fragment),ja=l(),ps=i("p"),ps.textContent=bt,ba=l(),r(rs.$$.fragment),wa=l(),cs=i("p"),cs.textContent=wt,va=l(),os=i("ul"),os.innerHTML=vt,Ta=l(),ds=i("p"),ds.textContent=Tt,Ua=l(),r(ms.$$.fragment),Ja=l(),hs=i("p"),hs.innerHTML=Ut,$a=l(),us=i("p"),us.innerHTML=Jt,_a=l(),r(fs.$$.fragment),Ca=l(),r(G.$$.fragment),Za=l(),r(gs.$$.fragment),Ia=l(),r(ys.$$.fragment),xa=l(),Ms=i("p"),Ms.innerHTML=$t,Ga=l(),M=i("div"),r(js.$$.fragment),Pa=l(),Ns=i("p"),Ns.textContent=_t,Ka=l(),Ys=i("p"),Ys.innerHTML=Ct,Oa=l(),Ws=i("p"),Ws.textContent=Zt,st=l(),zs=i("ul"),zs.innerHTML=It,at=l(),r(k.$$.fragment),ka=l(),r(bs.$$.fragment),Ea=l(),ws=i("p"),ws.innerHTML=xt,Na=l(),C=i("div"),r(vs.$$.fragment),tt=l(),Fs=i("p"),Fs.innerHTML=Gt,Ya=l(),r(Ts.$$.fragment),Wa=l(),Us=i("p"),Us.textContent=kt,za=l(),J=i("div"),r(Js.$$.fragment),et=l(),Vs=i("p"),Vs.textContent=Et,lt=l(),Ss=i("p"),Ss.innerHTML=Nt,Fa=l(),r($s.$$.fragment),Va=l(),Z=i("div"),r(_s.$$.fragment),nt=l(),Bs=i("p"),Bs.textContent=Yt,Sa=l(),I=i("div"),r(Cs.$$.fragment),it=l(),Rs=i("p"),Rs.textContent=Wt,Ba=l(),x=i("div"),r(Zs.$$.fragment),pt=l(),Xs=i("p"),Xs.textContent=zt,Ra=l(),r(Is.$$.fragment),Xa=l(),xs=i("ul"),xs.innerHTML=Ft,Qa=l(),r(Gs.$$.fragment),Ha=l(),As=i("p"),this.h()},l(s){const a=Qt("svelte-u9bgzb",document.head);f=p(a,"META",{name:!0,content:!0}),a.forEach(t),$=n(s),j=p(s,"P",{}),E(j).forEach(t),v=n(s),c(T.$$.fragment,s),y=n(s),U=p(s,"P",{"data-svelte-h":!0}),u(U)!=="svelte-fulmd4"&&(U.innerHTML=rt),Ls=n(s),c(Y.$$.fragment,s),Ds=n(s),W=p(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-10vup0t"&&(W.innerHTML=ct),qs=n(s),z=p(s,"UL",{"data-svelte-h":!0}),u(z)!=="svelte-16ihdp0"&&(z.innerHTML=ot),Ps=n(s),c(F.$$.fragment,s),Ks=n(s),V=p(s,"UL",{"data-svelte-h":!0}),u(V)!=="svelte-ot4c4r"&&(V.innerHTML=dt),Os=n(s),c(S.$$.fragment,s),sa=n(s),c(B.$$.fragment,s),aa=n(s),c(R.$$.fragment,s),ta=n(s),X=p(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-15zq0bg"&&(X.textContent=mt),ea=n(s),c(Q.$$.fragment,s),la=n(s),H=p(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-i9wly0"&&(H.textContent=ht),na=n(s),c(A.$$.fragment,s),ia=n(s),L=p(s,"P",{"data-svelte-h":!0}),u(L)!=="svelte-qjvxzo"&&(L.textContent=ut),pa=n(s),c(D.$$.fragment,s),ra=n(s),q=p(s,"P",{"data-svelte-h":!0}),u(q)!=="svelte-hrd6us"&&(q.innerHTML=ft),ca=n(s),c(P.$$.fragment,s),oa=n(s),c(K.$$.fragment,s),da=n(s),O=p(s,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1lyst51"&&(O.innerHTML=gt),ma=n(s),c(ss.$$.fragment,s),ha=n(s),as=p(s,"P",{"data-svelte-h":!0}),u(as)!=="svelte-1wuu5e1"&&(as.innerHTML=yt),ua=n(s),c(ts.$$.fragment,s),fa=n(s),es=p(s,"P",{"data-svelte-h":!0}),u(es)!=="svelte-4znjil"&&(es.innerHTML=Mt),ga=n(s),c(ls.$$.fragment,s),ya=n(s),ns=p(s,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-1byxw61"&&(ns.innerHTML=jt),Ma=n(s),c(is.$$.fragment,s),ja=n(s),ps=p(s,"P",{"data-svelte-h":!0}),u(ps)!=="svelte-bve03k"&&(ps.textContent=bt),ba=n(s),c(rs.$$.fragment,s),wa=n(s),cs=p(s,"P",{"data-svelte-h":!0}),u(cs)!=="svelte-n0jw9t"&&(cs.textContent=wt),va=n(s),os=p(s,"UL",{"data-svelte-h":!0}),u(os)!=="svelte-1ha2ndo"&&(os.innerHTML=vt),Ta=n(s),ds=p(s,"P",{"data-svelte-h":!0}),u(ds)!=="svelte-1ekf0af"&&(ds.textContent=Tt),Ua=n(s),c(ms.$$.fragment,s),Ja=n(s),hs=p(s,"P",{"data-svelte-h":!0}),u(hs)!=="svelte-1ekgjeq"&&(hs.innerHTML=Ut),$a=n(s),us=p(s,"P",{"data-svelte-h":!0}),u(us)!=="svelte-jqm6v0"&&(us.innerHTML=Jt),_a=n(s),c(fs.$$.fragment,s),Ca=n(s),c(G.$$.fragment,s),Za=n(s),c(gs.$$.fragment,s),Ia=n(s),c(ys.$$.fragment,s),xa=n(s),Ms=p(s,"P",{"data-svelte-h":!0}),u(Ms)!=="svelte-ikv26"&&(Ms.innerHTML=$t),Ga=n(s),M=p(s,"DIV",{class:!0});var b=E(M);c(js.$$.fragment,b),Pa=n(b),Ns=p(b,"P",{"data-svelte-h":!0}),u(Ns)!=="svelte-187aw77"&&(Ns.textContent=_t),Ka=n(b),Ys=p(b,"P",{"data-svelte-h":!0}),u(Ys)!=="svelte-u5v2s3"&&(Ys.innerHTML=Ct),Oa=n(b),Ws=p(b,"P",{"data-svelte-h":!0}),u(Ws)!=="svelte-1bdscnj"&&(Ws.textContent=Zt),st=n(b),zs=p(b,"UL",{"data-svelte-h":!0}),u(zs)!=="svelte-wwj3n0"&&(zs.innerHTML=It),at=n(b),c(k.$$.fragment,b),b.forEach(t),ka=n(s),c(bs.$$.fragment,s),Ea=n(s),ws=p(s,"P",{"data-svelte-h":!0}),u(ws)!=="svelte-i7oli7"&&(ws.innerHTML=xt),Na=n(s),C=p(s,"DIV",{class:!0});var ks=E(C);c(vs.$$.fragment,ks),tt=n(ks),Fs=p(ks,"P",{"data-svelte-h":!0}),u(Fs)!=="svelte-13ombpu"&&(Fs.innerHTML=Gt),ks.forEach(t),Ya=n(s),c(Ts.$$.fragment,s),Wa=n(s),Us=p(s,"P",{"data-svelte-h":!0}),u(Us)!=="svelte-10d5lmm"&&(Us.textContent=kt),za=n(s),J=p(s,"DIV",{class:!0});var Qs=E(J);c(Js.$$.fragment,Qs),et=n(Qs),Vs=p(Qs,"P",{"data-svelte-h":!0}),u(Vs)!=="svelte-9l09y7"&&(Vs.textContent=Et),lt=n(Qs),Ss=p(Qs,"P",{"data-svelte-h":!0}),u(Ss)!=="svelte-1i7klwo"&&(Ss.innerHTML=Nt),Qs.forEach(t),Fa=n(s),c($s.$$.fragment,s),Va=n(s),Z=p(s,"DIV",{class:!0});var La=E(Z);c(_s.$$.fragment,La),nt=n(La),Bs=p(La,"P",{"data-svelte-h":!0}),u(Bs)!=="svelte-10cvrkm"&&(Bs.textContent=Yt),La.forEach(t),Sa=n(s),I=p(s,"DIV",{class:!0});var Da=E(I);c(Cs.$$.fragment,Da),it=n(Da),Rs=p(Da,"P",{"data-svelte-h":!0}),u(Rs)!=="svelte-9fy9r4"&&(Rs.textContent=Wt),Da.forEach(t),Ba=n(s),x=p(s,"DIV",{class:!0});var qa=E(x);c(Zs.$$.fragment,qa),pt=n(qa),Xs=p(qa,"P",{"data-svelte-h":!0}),u(Xs)!=="svelte-6lkx6s"&&(Xs.textContent=zt),qa.forEach(t),Ra=n(s),c(Is.$$.fragment,s),Xa=n(s),xs=p(s,"UL",{"data-svelte-h":!0}),u(xs)!=="svelte-tvk7gu"&&(xs.innerHTML=Ft),Qa=n(s),c(Gs.$$.fragment,s),Ha=n(s),As=p(s,"P",{}),E(As).forEach(t),this.h()},h(){N(f,"name","hf:doc:metadata"),N(f,"content",Kt),N(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,a){g(document.head,f),e(s,$,a),e(s,j,a),e(s,v,a),o(T,s,a),e(s,y,a),e(s,U,a),e(s,Ls,a),o(Y,s,a),e(s,Ds,a),e(s,W,a),e(s,qs,a),e(s,z,a),e(s,Ps,a),o(F,s,a),e(s,Ks,a),e(s,V,a),e(s,Os,a),o(S,s,a),e(s,sa,a),o(B,s,a),e(s,aa,a),o(R,s,a),e(s,ta,a),e(s,X,a),e(s,ea,a),o(Q,s,a),e(s,la,a),e(s,H,a),e(s,na,a),o(A,s,a),e(s,ia,a),e(s,L,a),e(s,pa,a),o(D,s,a),e(s,ra,a),e(s,q,a),e(s,ca,a),o(P,s,a),e(s,oa,a),o(K,s,a),e(s,da,a),e(s,O,a),e(s,ma,a),o(ss,s,a),e(s,ha,a),e(s,as,a),e(s,ua,a),o(ts,s,a),e(s,fa,a),e(s,es,a),e(s,ga,a),o(ls,s,a),e(s,ya,a),e(s,ns,a),e(s,Ma,a),o(is,s,a),e(s,ja,a),e(s,ps,a),e(s,ba,a),o(rs,s,a),e(s,wa,a),e(s,cs,a),e(s,va,a),e(s,os,a),e(s,Ta,a),e(s,ds,a),e(s,Ua,a),o(ms,s,a),e(s,Ja,a),e(s,hs,a),e(s,$a,a),e(s,us,a),e(s,_a,a),o(fs,s,a),e(s,Ca,a),o(G,s,a),e(s,Za,a),o(gs,s,a),e(s,Ia,a),o(ys,s,a),e(s,xa,a),e(s,Ms,a),e(s,Ga,a),e(s,M,a),o(js,M,null),g(M,Pa),g(M,Ns),g(M,Ka),g(M,Ys),g(M,Oa),g(M,Ws),g(M,st),g(M,zs),g(M,at),o(k,M,null),e(s,ka,a),o(bs,s,a),e(s,Ea,a),e(s,ws,a),e(s,Na,a),e(s,C,a),o(vs,C,null),g(C,tt),g(C,Fs),e(s,Ya,a),o(Ts,s,a),e(s,Wa,a),e(s,Us,a),e(s,za,a),e(s,J,a),o(Js,J,null),g(J,et),g(J,Vs),g(J,lt),g(J,Ss),e(s,Fa,a),o($s,s,a),e(s,Va,a),e(s,Z,a),o(_s,Z,null),g(Z,nt),g(Z,Bs),e(s,Sa,a),e(s,I,a),o(Cs,I,null),g(I,it),g(I,Rs),e(s,Ba,a),e(s,x,a),o(Zs,x,null),g(x,pt),g(x,Xs),e(s,Ra,a),o(Is,s,a),e(s,Xa,a),e(s,xs,a),e(s,Qa,a),o(Gs,s,a),e(s,Ha,a),e(s,As,a),Aa=!0},p(s,[a]){const b={};a&2&&(b.$$scope={dirty:a,ctx:s}),G.$set(b);const ks={};a&2&&(ks.$$scope={dirty:a,ctx:s}),k.$set(ks)},i(s){Aa||(d(T.$$.fragment,s),d(Y.$$.fragment,s),d(F.$$.fragment,s),d(S.$$.fragment,s),d(B.$$.fragment,s),d(R.$$.fragment,s),d(Q.$$.fragment,s),d(A.$$.fragment,s),d(D.$$.fragment,s),d(P.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),d(ts.$$.fragment,s),d(ls.$$.fragment,s),d(is.$$.fragment,s),d(rs.$$.fragment,s),d(ms.$$.fragment,s),d(fs.$$.fragment,s),d(G.$$.fragment,s),d(gs.$$.fragment,s),d(ys.$$.fragment,s),d(js.$$.fragment,s),d(k.$$.fragment,s),d(bs.$$.fragment,s),d(vs.$$.fragment,s),d(Ts.$$.fragment,s),d(Js.$$.fragment,s),d($s.$$.fragment,s),d(_s.$$.fragment,s),d(Cs.$$.fragment,s),d(Zs.$$.fragment,s),d(Is.$$.fragment,s),d(Gs.$$.fragment,s),Aa=!0)},o(s){m(T.$$.fragment,s),m(Y.$$.fragment,s),m(F.$$.fragment,s),m(S.$$.fragment,s),m(B.$$.fragment,s),m(R.$$.fragment,s),m(Q.$$.fragment,s),m(A.$$.fragment,s),m(D.$$.fragment,s),m(P.$$.fragment,s),m(K.$$.fragment,s),m(ss.$$.fragment,s),m(ts.$$.fragment,s),m(ls.$$.fragment,s),m(is.$$.fragment,s),m(rs.$$.fragment,s),m(ms.$$.fragment,s),m(fs.$$.fragment,s),m(G.$$.fragment,s),m(gs.$$.fragment,s),m(ys.$$.fragment,s),m(js.$$.fragment,s),m(k.$$.fragment,s),m(bs.$$.fragment,s),m(vs.$$.fragment,s),m(Ts.$$.fragment,s),m(Js.$$.fragment,s),m($s.$$.fragment,s),m(_s.$$.fragment,s),m(Cs.$$.fragment,s),m(Zs.$$.fragment,s),m(Is.$$.fragment,s),m(Gs.$$.fragment,s),Aa=!1},d(s){s&&(t($),t(j),t(v),t(y),t(U),t(Ls),t(Ds),t(W),t(qs),t(z),t(Ps),t(Ks),t(V),t(Os),t(sa),t(aa),t(ta),t(X),t(ea),t(la),t(H),t(na),t(ia),t(L),t(pa),t(ra),t(q),t(ca),t(oa),t(da),t(O),t(ma),t(ha),t(as),t(ua),t(fa),t(es),t(ga),t(ya),t(ns),t(Ma),t(ja),t(ps),t(ba),t(wa),t(cs),t(va),t(os),t(Ta),t(ds),t(Ua),t(Ja),t(hs),t($a),t(us),t(_a),t(Ca),t(Za),t(Ia),t(xa),t(Ms),t(Ga),t(M),t(ka),t(Ea),t(ws),t(Na),t(C),t(Ya),t(Wa),t(Us),t(za),t(J),t(Fa),t(Va),t(Z),t(Sa),t(I),t(Ba),t(x),t(Ra),t(Xa),t(xs),t(Qa),t(Ha),t(As)),t(f),h(T,s),h(Y,s),h(F,s),h(S,s),h(B,s),h(R,s),h(Q,s),h(A,s),h(D,s),h(P,s),h(K,s),h(ss,s),h(ts,s),h(ls,s),h(is,s),h(rs,s),h(ms,s),h(fs,s),h(G,s),h(gs,s),h(ys,s),h(js),h(k),h(bs,s),h(vs),h(Ts,s),h(Js),h($s,s),h(_s),h(Cs),h(Zs),h(Is,s),h(Gs,s)}}}const Kt='{"title":"Strict Dataclasses","local":"strict-dataclasses","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Benefits","local":"benefits","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Basic Example","local":"basic-example","sections":[],"depth":3},{"title":"Custom Validators","local":"custom-validators","sections":[],"depth":3},{"title":"Additional Keyword Arguments","local":"additional-keyword-arguments","sections":[],"depth":3},{"title":"Integration with Type Hints","local":"integration-with-type-hints","sections":[],"depth":3},{"title":"Class validators","local":"class-validators","sections":[],"depth":3}],"depth":2},{"title":"API Reference","local":"api-reference","sections":[{"title":"@strict","local":"huggingface_hub.dataclasses.strict","sections":[],"depth":3},{"title":"as_validated_field","local":"huggingface_hub.dataclasses.as_validated_field","sections":[],"depth":3},{"title":"validated_field","local":"huggingface_hub.dataclasses.validated_field","sections":[],"depth":3},{"title":"Errors","local":"huggingface_hub.errors.StrictDataclassError","sections":[],"depth":3}],"depth":2},{"title":"Why Not Use pydantic ? (or attrs ? or marshmallow_dataclass ?)","local":"why-not-use-pydantic--or-attrs--or-marshmallowdataclass-","sections":[],"depth":2}],"depth":1}';function Ot(Es){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pe extends Rt{constructor(f){super(),Xt(this,f,Ot,Pt,St,{})}}export{pe as component};
