import{s as Fn,o as Pn,n as Qe}from"../chunks/scheduler.6062bdaf.js";import{S as Kn,i as On,g as d,s,r as p,A as Dn,h as c,f as n,c as l,j as zn,u,x as r,k as Rn,y as ea,a,v as g,d as h,t as f,w as m}from"../chunks/index.4bca734e.js";import{T as Ee}from"../chunks/Tip.b9ac1f03.js";import{C as M}from"../chunks/CodeBlock.cbbddafc.js";import{H as I,E as ta}from"../chunks/index.60dd99e8.js";function na(T){let i,_=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a> documentation
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,o,y,C=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){i=d("p"),i.innerHTML=_,o=s(),y=d("p"),y.innerHTML=C},l(b){i=c(b,"P",{"data-svelte-h":!0}),r(i)!=="svelte-938qx5"&&(i.innerHTML=_),o=l(b),y=c(b,"P",{"data-svelte-h":!0}),r(y)!=="svelte-22w7rm"&&(y.innerHTML=C)},m(b,w){a(b,i,w),a(b,o,w),a(b,y,w)},p:Qe,d(b){b&&(n(i),n(o),n(y))}}}function aa(T){let i,_=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){i=d("p"),i.innerHTML=_},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1o4uc5e"&&(i.innerHTML=_)},m(o,y){a(o,i,y)},p:Qe,d(o){o&&n(i)}}}function sa(T){let i,_=`When using the “hf-inference” provider, each task comes with a recommended model from the 1M+ models available on the Hub.
However, this recommendation can change over time, so it’s best to explicitly set a model once you’ve decided which one to use.
For third-party providers, you must always specify a model that is compatible with that provider.`,o,y,C='Visit the <a href="https://huggingface.co/models?inference=warm" rel="nofollow">Models</a> page on the Hub to explore models available through Inference Providers.';return{c(){i=d("p"),i.textContent=_,o=s(),y=d("p"),y.innerHTML=C},l(b){i=c(b,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1pxsrsl"&&(i.textContent=_),o=l(b),y=c(b,"P",{"data-svelte-h":!0}),r(y)!=="svelte-hp7lk2"&&(y.innerHTML=C)},m(b,w){a(b,i,w),a(b,o,w),a(b,y,w)},p:Qe,d(b){b&&(n(i),n(o),n(y))}}}function la(T){let i,_='Similarily to the OpenAI Python client, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be used to run Chat Completion inference with any OpenAI REST API-compatible endpoint.';return{c(){i=d("p"),i.innerHTML=_},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-142y7rx"&&(i.innerHTML=_)},m(o,y){a(o,i,y)},p:Qe,d(o){o&&n(i)}}}function ia(T){let i,_='Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task.';return{c(){i=d("p"),i.innerHTML=_},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1odjvkm"&&(i.innerHTML=_)},m(o,y){a(o,i,y)},p:Qe,d(o){o&&n(i)}}}function da(T){let i,_='<code>InferenceClient.chat.completions.create</code> is simply an alias for <code>InferenceClient.chat_completion</code>. Check out the package reference of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> for more details. <code>base_url</code> and <code>api_key</code> parameters when instantiating the client are also aliases for <code>model</code> and <code>token</code>. These aliases have been defined to reduce friction when switching from <code>OpenAI</code> to <code>InferenceClient</code>.';return{c(){i=d("p"),i.innerHTML=_},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1dpcgfo"&&(i.innerHTML=_)},m(o,y){a(o,i,y)},p:Qe,d(o){o&&n(i)}}}function ca(T){let i,_,o,y,C,b,w,dn=`Inference is the process of using a trained model to make predictions on new data. Because this process can be compute-intensive, running on a dedicated or external service can be an interesting option.
The <code>huggingface_hub</code> library provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:`,Be,Z,cn='<li><a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a>: a streamlined, unified access to hundreds of machine learning models, powered by our serverless inference partners. This new approach builds on our previous Serverless Inference API, offering more models, improved performance, and greater reliability thanks to world-class providers. Refer to the <a href="https://huggingface.co/docs/inference-providers/index#partners" rel="nofollow">documentation</a> for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li> <li>Local endpoints: you can also run inference with local inference servers like <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://ollama.com/" rel="nofollow">Ollama</a>, <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a>, <a href="https://docs.litellm.ai/docs/simple_proxy" rel="nofollow">LiteLLM</a>, or <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a> by connecting the client to these local endpoints.</li>',Ae,W,rn=`These services can all be called from the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and third-party providers.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,Se,j,Xe,x,ze,q,on="Let’s get started with a text-to-image task:",Re,G,Fe,L,pn=`In the example above, we initialized an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with a third-party provider, <a href="https://replicate.com/" rel="nofollow">Replicate</a>. When using a provider, you must specify the model you want to use. The model id must be the id of the model on the Hugging Face Hub, not the id of the model from the third-party provider.
In our example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a file. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a> documentation.`,Pe,H,un='Let’s now see an example using the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> API. This task uses an LLM to generate a response from a list of messages:',Ke,V,Oe,N,gn='In the example above, we used a third-party provider (<a href="https://www.together.ai/" rel="nofollow">Together AI</a>) and specified which model we want to use (<code>&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</code>). We then gave a list of messages to complete (here, a single question) and passed an additional parameter to the API (<code>max_token=100</code>). The output is a <code>ChatCompletionOutput</code> object that follows the OpenAI specification. The generated content can be accessed with <code>output.choices[0].message.content</code>. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> documentation.',De,$,et,E,tt,Q,hn='If you want to use a specific provider, you can specify it when initializing the client. The default value is “auto” which will select the first of the providers available for the model, sorted by the user’s order in <a href="https://hf.co/settings/inference-providers" rel="nofollow">https://hf.co/settings/inference-providers</a>. Refer to the <a href="#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.',nt,Y,at,B,st,A,fn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",lt,S,it,U,dt,X,ct,z,mn=`The examples we saw above use inference providers. While these prove to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,rt,R,ot,F,yn="Note that you cannot specify both a URL and a provider - they are mutually exclusive. URLs are used to connect directly to deployed endpoints.",pt,P,ut,K,bn='You can use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> to run chat completion with local inference servers (llama.cpp, vllm, litellm server, TGI, mlx, etc.) running on your own machine. The API should be OpenAI API-compatible.',gt,O,ht,J,ft,D,mt,ee,_n="Authentication can be done in two ways:",yt,te,Mn="<strong>Routed through Hugging Face</strong> : Use Hugging Face as a proxy to access third-party providers. The calls will be routed through Hugging Face’s infrastructure using our provider keys, and the usage will be billed directly to your Hugging Face account.",bt,ne,wn='You can authenticate using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>. You can provide your Hugging Face token directly using the <code>api_key</code> parameter:',_t,ae,Mt,se,Tn='If you <em>don’t</em> pass an <code>api_key</code>, the client will attempt to find and use a token stored locally on your machine. This typically happens if you’ve previously logged in. See the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">Authentication Guide</a> for details on login.',wt,le,Tt,ie,In="<strong>Direct access to provider</strong>: Use your own API key to interact directly with the provider’s service:",It,de,Ct,ce,Cn='For more details, refer to the <a href="https://huggingface.co/docs/inference-providers/pricing#routed-requests-vs-direct-calls" rel="nofollow">Inference Providers pricing documentation</a>.',jt,re,$t,oe,jn='<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models, on any provider. It has a simple API that supports the most common tasks. Here is a table showing which providers support which tasks:',Ut,pe,$n='<thead><tr><th>Task</th> <th>Black Forest Labs</th> <th>Cerebras</th> <th>Cohere</th> <th>fal-ai</th> <th>Fireworks AI</th> <th>HF Inference</th> <th>Hyperbolic</th> <th>Nebius AI Studio</th> <th>Novita AI</th> <th>Replicate</th> <th>Sambanova</th> <th>Together</th></tr></thead> <tbody><tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td> <td>❌</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_video">text_to_video()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr></tbody>',Jt,v,vt,ue,kt,ge,Un='The <code>chat_completion</code> task follows <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI’s Python client</a> syntax. What does it mean for you? It means that if you are used to play with <code>OpenAI</code>’s APIs you will be able to switch to <code>huggingface_hub.InferenceClient</code> to work with open-source models by updating just 2 line of code!',Zt,he,Wt,fe,Jn='And that’s it! The only required changes are to replace <code>from openai import OpenAI</code> by <code>from huggingface_hub import InferenceClient</code> and <code>client = OpenAI(...)</code> by <code>client = InferenceClient(...)</code>. You can choose any LLM model from the Hugging Face Hub by passing its model id as <code>model</code> parameter. <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;other=conversational,text-generation-inference&amp;sort=trending" rel="nofollow">Here is a list</a> of supported models. For authentication, you should pass a valid <a href="https://huggingface.co/settings/tokens" rel="nofollow">User Access Token</a> as <code>api_key</code> or authenticate using <code>huggingface_hub</code> (see the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">authentication guide</a>).',xt,me,vn='All input parameters and output format are strictly the same. In particular, you can pass <code>stream=True</code> to receive tokens as they are generated. You can also use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to run inference using <code>asyncio</code>:',qt,ye,Gt,be,kn='You might wonder why using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> instead of OpenAI’s client? There are a few reasons for that:',Lt,_e,Zn='<li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is configured for Hugging Face services. You don’t need to provide a <code>base_url</code> to run models with Inference Providers. You also don’t need to provide a <code>token</code> or <code>api_key</code> if your machine is already correctly logged in.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is tailored for both Text-Generation-Inference (TGI) and <code>transformers</code> frameworks, meaning you are assured it will always be on-par with the latest updates.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is integrated with our Inference Endpoints service, making it easier to launch an Inference Endpoint, check its status and run inference on it. Check out the <a href="./inference_endpoints.md">Inference Endpoints</a> guide for more details.</li>',Ht,k,Vt,Me,Nt,we,Wn=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,Et,Te,Qt,Ie,xn=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,Yt,Ce,Bt,je,qn='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',At,$e,St,Ue,Gn='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',Xt,Je,zt,ve,Ln='As an HF user, you get monthly credits to run inference through various providers on the Hub. The amount of credits you get depends on your type of account (Free or PRO or Enterprise Hub). You get charged for every inference request, depending on the provider’s pricing table. By default, the requests are billed to your personal account. However, it is possible to set the billing so that requests are charged to an organization you are part of by simply passing <code>bill_to=&quot;&lt;your_org_name&gt;&quot;</code> to <code>InferenceClient</code>. For this to work, your organization must be subscribed to Enterprise Hub. For more details about billing, check out <a href="https://huggingface.co/docs/api-inference/pricing#features-using-inference-providers" rel="nofollow">this guide</a>.',Rt,ke,Ft,Ze,Hn="Note that it is NOT possible to charge another user or an organization you are not part of. If you want to grant someone else some credits, you must create a joint organization with them.",Pt,We,Kt,xe,Vn='Inference calls can take a significant amount of time. By default, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will wait “indefinitely” until the inference complete. If you want more control in your workflow, you can set the <code>timeout</code> parameter to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised, which you can catch in your code:',Ot,qe,Dt,Ge,en,Le,Nn=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,tn,He,En=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
being sent to the API.</li>`,nn,Ve,an,Ne,sn,Ye,ln;return C=new I({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),j=new Ee({props:{$$slots:{default:[na]},$$scope:{ctx:T}}}),x=new I({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),G=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcGxpY2F0ZV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBcmVwbGljYXRlX2ltYWdlJTIwJTNEJTIwcmVwbGljYXRlX2NsaWVudC50ZXh0X3RvX2ltYWdlKCUwQXJlcGxpY2F0ZV9pbWFnZS5zYXZlKCUyMmZseWluZ19jYXIucG5nJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># Example with an external provider (e.g. replicate)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image = replicate_client.text_to_image(
    <span class="hljs-string">&quot;A flying car crossing a futuristic cityscape.&quot;</span>,
    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image.save(<span class="hljs-string">&quot;flying_car.png&quot;</span>)
`,wrap:!1}}),V=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQWNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
    }
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;together&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_together_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&quot;eos_token&quot;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&quot;assistant&quot;</span>, content=<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, name=<span class="hljs-literal">None</span>, tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>,
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&quot;text_completion&quot;</span>,
    system_fingerprint=<span class="hljs-string">&quot;2.0.4-sha-f426a33&quot;</span>,
    usage=ChatCompletionOutputUsage(completion_tokens=<span class="hljs-number">8</span>, prompt_tokens=<span class="hljs-number">17</span>, total_tokens=<span class="hljs-number">25</span>),
)`,wrap:!1}}),$=new Ee({props:{warning:!0,$$slots:{default:[aa]},$$scope:{ctx:T}}}),E=new I({props:{title:"Using a specific provider",local:"using-a-specific-provider",headingTag:"h3"}}),Y=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMGFwaV9rZXklM0QlMjJteV9yZXBsaWNhdGVfYXBpX2tleSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;replicate&quot;</span>, api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>)`,wrap:!1}}),B=new I({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),S=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwbW9kZWwlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQocHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;together&quot;</span>, model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;together&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>)`,wrap:!1}}),U=new Ee({props:{$$slots:{default:[sa]},$$scope:{ctx:T}}}),X=new I({props:{title:"Using Inference Endpoints",local:"using-inference-endpoints",headingTag:"h3"}}),R=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),P=new I({props:{title:"Using local endpoints",local:"using-local-endpoints",headingTag:"h3"}}),O=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTIyKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMCUwQSklMEFwcmludChyZXNwb25zZS5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;http://localhost:8080&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">100</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),J=new Ee({props:{$$slots:{default:[la]},$$scope:{ctx:T}}}),D=new I({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),ae=new M({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token</span>
)`,wrap:!1}}),le=new M({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    token=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token</span>
)`,wrap:!1}}),de=new M({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;r8_****&quot;</span>  <span class="hljs-comment"># Your Replicate API key</span>
)`,wrap:!1}}),re=new I({props:{title:"Supported providers and tasks",local:"supported-providers-and-tasks",headingTag:"h2"}}),v=new Ee({props:{$$slots:{default:[ia]},$$scope:{ctx:T}}}),ue=new I({props:{title:"OpenAI compatibility",local:"openai-compatibility",headingTag:"h2"}}),he=new M({props:{code:"LSUyMGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBLSUyMGNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMkIlMjBjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNELi4uJTJDJTBBKSUwQSUwQSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-deletion">- from openai import OpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import InferenceClient</span>

<span class="hljs-deletion">- client = OpenAI(</span>
<span class="hljs-addition">+ client = InferenceClient(</span>
    base_url=...,
    api_key=...,
)


output = client.chat.completions.create(
    model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
    messages=[
        {&quot;role&quot;: &quot;system&quot;, &quot;content&quot;: &quot;You are a helpful assistant.&quot;},
        {&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Count to 10&quot;},
    ],
    stream=True,
    max_tokens=1024,
)

for chunk in output:
    print(chunk.choices[0].delta.content)`,wrap:!1}}),ye=new M({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQS0lMjBmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwQXN5bmNPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEEtJTIwY2xpZW50JTIwJTNEJTIwQXN5bmNPcGVuQUkoKSUwQSUyQiUyMGNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCklMEElMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`import asyncio
<span class="hljs-deletion">- from openai import AsyncOpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import AsyncInferenceClient</span>

<span class="hljs-deletion">- client = AsyncOpenAI()</span>
<span class="hljs-addition">+ client = AsyncInferenceClient()</span>

async def main():
    stream = await client.chat.completions.create(
        model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
        messages=[{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Say this is a test&quot;}],
        stream=True,
    )
    async for chunk in stream:
        print(chunk.choices[0].delta.content or &quot;&quot;, end=&quot;&quot;)

asyncio.run(main())`,wrap:!1}}),k=new Ee({props:{$$slots:{default:[da]},$$scope:{ctx:T}}}),Me=new I({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),Te=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Ce=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in an asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),$e=new I({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),Je=new I({props:{title:"Billing",local:"billing",headingTag:"h3"}}),ke=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMGJpbGxfdG8lM0QlMjJvcGVuYWklMjIpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;fal-ai&quot;</span>, bill_to=<span class="hljs-string">&quot;openai&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),We=new I({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),qe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),Ge=new I({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),Ve=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),Ne=new ta({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){i=d("meta"),_=s(),o=d("p"),y=s(),p(C.$$.fragment),b=s(),w=d("p"),w.innerHTML=dn,Be=s(),Z=d("ol"),Z.innerHTML=cn,Ae=s(),W=d("p"),W.innerHTML=rn,Se=s(),p(j.$$.fragment),Xe=s(),p(x.$$.fragment),ze=s(),q=d("p"),q.textContent=on,Re=s(),p(G.$$.fragment),Fe=s(),L=d("p"),L.innerHTML=pn,Pe=s(),H=d("p"),H.innerHTML=un,Ke=s(),p(V.$$.fragment),Oe=s(),N=d("p"),N.innerHTML=gn,De=s(),p($.$$.fragment),et=s(),p(E.$$.fragment),tt=s(),Q=d("p"),Q.innerHTML=hn,nt=s(),p(Y.$$.fragment),at=s(),p(B.$$.fragment),st=s(),A=d("p"),A.textContent=fn,lt=s(),p(S.$$.fragment),it=s(),p(U.$$.fragment),dt=s(),p(X.$$.fragment),ct=s(),z=d("p"),z.innerHTML=mn,rt=s(),p(R.$$.fragment),ot=s(),F=d("p"),F.textContent=yn,pt=s(),p(P.$$.fragment),ut=s(),K=d("p"),K.innerHTML=bn,gt=s(),p(O.$$.fragment),ht=s(),p(J.$$.fragment),ft=s(),p(D.$$.fragment),mt=s(),ee=d("p"),ee.textContent=_n,yt=s(),te=d("p"),te.innerHTML=Mn,bt=s(),ne=d("p"),ne.innerHTML=wn,_t=s(),p(ae.$$.fragment),Mt=s(),se=d("p"),se.innerHTML=Tn,wt=s(),p(le.$$.fragment),Tt=s(),ie=d("p"),ie.innerHTML=In,It=s(),p(de.$$.fragment),Ct=s(),ce=d("p"),ce.innerHTML=Cn,jt=s(),p(re.$$.fragment),$t=s(),oe=d("p"),oe.innerHTML=jn,Ut=s(),pe=d("table"),pe.innerHTML=$n,Jt=s(),p(v.$$.fragment),vt=s(),p(ue.$$.fragment),kt=s(),ge=d("p"),ge.innerHTML=Un,Zt=s(),p(he.$$.fragment),Wt=s(),fe=d("p"),fe.innerHTML=Jn,xt=s(),me=d("p"),me.innerHTML=vn,qt=s(),p(ye.$$.fragment),Gt=s(),be=d("p"),be.innerHTML=kn,Lt=s(),_e=d("ol"),_e.innerHTML=Zn,Ht=s(),p(k.$$.fragment),Vt=s(),p(Me.$$.fragment),Nt=s(),we=d("p"),we.innerHTML=Wn,Et=s(),p(Te.$$.fragment),Qt=s(),Ie=d("p"),Ie.innerHTML=xn,Yt=s(),p(Ce.$$.fragment),Bt=s(),je=d("p"),je.innerHTML=qn,At=s(),p($e.$$.fragment),St=s(),Ue=d("p"),Ue.innerHTML=Gn,Xt=s(),p(Je.$$.fragment),zt=s(),ve=d("p"),ve.innerHTML=Ln,Rt=s(),p(ke.$$.fragment),Ft=s(),Ze=d("p"),Ze.textContent=Hn,Pt=s(),p(We.$$.fragment),Kt=s(),xe=d("p"),xe.innerHTML=Vn,Ot=s(),p(qe.$$.fragment),Dt=s(),p(Ge.$$.fragment),en=s(),Le=d("p"),Le.innerHTML=Nn,tn=s(),He=d("ul"),He.innerHTML=En,nn=s(),p(Ve.$$.fragment),an=s(),p(Ne.$$.fragment),sn=s(),Ye=d("p"),this.h()},l(e){const t=Dn("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(n),_=l(e),o=c(e,"P",{}),zn(o).forEach(n),y=l(e),u(C.$$.fragment,e),b=l(e),w=c(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-zsbuba"&&(w.innerHTML=dn),Be=l(e),Z=c(e,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-113kt9p"&&(Z.innerHTML=cn),Ae=l(e),W=c(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1vbf08n"&&(W.innerHTML=rn),Se=l(e),u(j.$$.fragment,e),Xe=l(e),u(x.$$.fragment,e),ze=l(e),q=c(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-8lplub"&&(q.textContent=on),Re=l(e),u(G.$$.fragment,e),Fe=l(e),L=c(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-181xjky"&&(L.innerHTML=pn),Pe=l(e),H=c(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1d6dn6"&&(H.innerHTML=un),Ke=l(e),u(V.$$.fragment,e),Oe=l(e),N=c(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-19dgkah"&&(N.innerHTML=gn),De=l(e),u($.$$.fragment,e),et=l(e),u(E.$$.fragment,e),tt=l(e),Q=c(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1uw3jfu"&&(Q.innerHTML=hn),nt=l(e),u(Y.$$.fragment,e),at=l(e),u(B.$$.fragment,e),st=l(e),A=c(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1npu22n"&&(A.textContent=fn),lt=l(e),u(S.$$.fragment,e),it=l(e),u(U.$$.fragment,e),dt=l(e),u(X.$$.fragment,e),ct=l(e),z=c(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-iygc0l"&&(z.innerHTML=mn),rt=l(e),u(R.$$.fragment,e),ot=l(e),F=c(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1yhw21f"&&(F.textContent=yn),pt=l(e),u(P.$$.fragment,e),ut=l(e),K=c(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-76vbgt"&&(K.innerHTML=bn),gt=l(e),u(O.$$.fragment,e),ht=l(e),u(J.$$.fragment,e),ft=l(e),u(D.$$.fragment,e),mt=l(e),ee=c(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-ifnzw0"&&(ee.textContent=_n),yt=l(e),te=c(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-s1ttf4"&&(te.innerHTML=Mn),bt=l(e),ne=c(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-vhv07e"&&(ne.innerHTML=wn),_t=l(e),u(ae.$$.fragment,e),Mt=l(e),se=c(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-jlpf96"&&(se.innerHTML=Tn),wt=l(e),u(le.$$.fragment,e),Tt=l(e),ie=c(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-zxs6jj"&&(ie.innerHTML=In),It=l(e),u(de.$$.fragment,e),Ct=l(e),ce=c(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1sxee5g"&&(ce.innerHTML=Cn),jt=l(e),u(re.$$.fragment,e),$t=l(e),oe=c(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-qhknp8"&&(oe.innerHTML=jn),Ut=l(e),pe=c(e,"TABLE",{"data-svelte-h":!0}),r(pe)!=="svelte-bwo93t"&&(pe.innerHTML=$n),Jt=l(e),u(v.$$.fragment,e),vt=l(e),u(ue.$$.fragment,e),kt=l(e),ge=c(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-bmxago"&&(ge.innerHTML=Un),Zt=l(e),u(he.$$.fragment,e),Wt=l(e),fe=c(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-94ddrt"&&(fe.innerHTML=Jn),xt=l(e),me=c(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1wef96y"&&(me.innerHTML=vn),qt=l(e),u(ye.$$.fragment,e),Gt=l(e),be=c(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-u2g99k"&&(be.innerHTML=kn),Lt=l(e),_e=c(e,"OL",{"data-svelte-h":!0}),r(_e)!=="svelte-zypjkb"&&(_e.innerHTML=Zn),Ht=l(e),u(k.$$.fragment,e),Vt=l(e),u(Me.$$.fragment,e),Nt=l(e),we=c(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1gqwj00"&&(we.innerHTML=Wn),Et=l(e),u(Te.$$.fragment,e),Qt=l(e),Ie=c(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1bdjfju"&&(Ie.innerHTML=xn),Yt=l(e),u(Ce.$$.fragment,e),Bt=l(e),je=c(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-q492az"&&(je.innerHTML=qn),At=l(e),u($e.$$.fragment,e),St=l(e),Ue=c(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-2b1sa3"&&(Ue.innerHTML=Gn),Xt=l(e),u(Je.$$.fragment,e),zt=l(e),ve=c(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-6rcpvw"&&(ve.innerHTML=Ln),Rt=l(e),u(ke.$$.fragment,e),Ft=l(e),Ze=c(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1hpvtqi"&&(Ze.textContent=Hn),Pt=l(e),u(We.$$.fragment,e),Kt=l(e),xe=c(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-t8yvyu"&&(xe.innerHTML=Vn),Ot=l(e),u(qe.$$.fragment,e),Dt=l(e),u(Ge.$$.fragment,e),en=l(e),Le=c(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-4hhs15"&&(Le.innerHTML=Nn),tn=l(e),He=c(e,"UL",{"data-svelte-h":!0}),r(He)!=="svelte-1o9a3e0"&&(He.innerHTML=En),nn=l(e),u(Ve.$$.fragment,e),an=l(e),u(Ne.$$.fragment,e),sn=l(e),Ye=c(e,"P",{}),zn(Ye).forEach(n),this.h()},h(){Rn(i,"name","hf:doc:metadata"),Rn(i,"content",ra)},m(e,t){ea(document.head,i),a(e,_,t),a(e,o,t),a(e,y,t),g(C,e,t),a(e,b,t),a(e,w,t),a(e,Be,t),a(e,Z,t),a(e,Ae,t),a(e,W,t),a(e,Se,t),g(j,e,t),a(e,Xe,t),g(x,e,t),a(e,ze,t),a(e,q,t),a(e,Re,t),g(G,e,t),a(e,Fe,t),a(e,L,t),a(e,Pe,t),a(e,H,t),a(e,Ke,t),g(V,e,t),a(e,Oe,t),a(e,N,t),a(e,De,t),g($,e,t),a(e,et,t),g(E,e,t),a(e,tt,t),a(e,Q,t),a(e,nt,t),g(Y,e,t),a(e,at,t),g(B,e,t),a(e,st,t),a(e,A,t),a(e,lt,t),g(S,e,t),a(e,it,t),g(U,e,t),a(e,dt,t),g(X,e,t),a(e,ct,t),a(e,z,t),a(e,rt,t),g(R,e,t),a(e,ot,t),a(e,F,t),a(e,pt,t),g(P,e,t),a(e,ut,t),a(e,K,t),a(e,gt,t),g(O,e,t),a(e,ht,t),g(J,e,t),a(e,ft,t),g(D,e,t),a(e,mt,t),a(e,ee,t),a(e,yt,t),a(e,te,t),a(e,bt,t),a(e,ne,t),a(e,_t,t),g(ae,e,t),a(e,Mt,t),a(e,se,t),a(e,wt,t),g(le,e,t),a(e,Tt,t),a(e,ie,t),a(e,It,t),g(de,e,t),a(e,Ct,t),a(e,ce,t),a(e,jt,t),g(re,e,t),a(e,$t,t),a(e,oe,t),a(e,Ut,t),a(e,pe,t),a(e,Jt,t),g(v,e,t),a(e,vt,t),g(ue,e,t),a(e,kt,t),a(e,ge,t),a(e,Zt,t),g(he,e,t),a(e,Wt,t),a(e,fe,t),a(e,xt,t),a(e,me,t),a(e,qt,t),g(ye,e,t),a(e,Gt,t),a(e,be,t),a(e,Lt,t),a(e,_e,t),a(e,Ht,t),g(k,e,t),a(e,Vt,t),g(Me,e,t),a(e,Nt,t),a(e,we,t),a(e,Et,t),g(Te,e,t),a(e,Qt,t),a(e,Ie,t),a(e,Yt,t),g(Ce,e,t),a(e,Bt,t),a(e,je,t),a(e,At,t),g($e,e,t),a(e,St,t),a(e,Ue,t),a(e,Xt,t),g(Je,e,t),a(e,zt,t),a(e,ve,t),a(e,Rt,t),g(ke,e,t),a(e,Ft,t),a(e,Ze,t),a(e,Pt,t),g(We,e,t),a(e,Kt,t),a(e,xe,t),a(e,Ot,t),g(qe,e,t),a(e,Dt,t),g(Ge,e,t),a(e,en,t),a(e,Le,t),a(e,tn,t),a(e,He,t),a(e,nn,t),g(Ve,e,t),a(e,an,t),g(Ne,e,t),a(e,sn,t),a(e,Ye,t),ln=!0},p(e,[t]){const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),j.$set(Qn);const Yn={};t&2&&(Yn.$$scope={dirty:t,ctx:e}),$.$set(Yn);const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),U.$set(Bn);const An={};t&2&&(An.$$scope={dirty:t,ctx:e}),J.$set(An);const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),v.$set(Sn);const Xn={};t&2&&(Xn.$$scope={dirty:t,ctx:e}),k.$set(Xn)},i(e){ln||(h(C.$$.fragment,e),h(j.$$.fragment,e),h(x.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(B.$$.fragment,e),h(S.$$.fragment,e),h(U.$$.fragment,e),h(X.$$.fragment,e),h(R.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(J.$$.fragment,e),h(D.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(re.$$.fragment,e),h(v.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(k.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(Je.$$.fragment,e),h(ke.$$.fragment,e),h(We.$$.fragment,e),h(qe.$$.fragment,e),h(Ge.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),ln=!0)},o(e){f(C.$$.fragment,e),f(j.$$.fragment,e),f(x.$$.fragment,e),f(G.$$.fragment,e),f(V.$$.fragment,e),f($.$$.fragment,e),f(E.$$.fragment,e),f(Y.$$.fragment,e),f(B.$$.fragment,e),f(S.$$.fragment,e),f(U.$$.fragment,e),f(X.$$.fragment,e),f(R.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(J.$$.fragment,e),f(D.$$.fragment,e),f(ae.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(re.$$.fragment,e),f(v.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(k.$$.fragment,e),f(Me.$$.fragment,e),f(Te.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(Je.$$.fragment,e),f(ke.$$.fragment,e),f(We.$$.fragment,e),f(qe.$$.fragment,e),f(Ge.$$.fragment,e),f(Ve.$$.fragment,e),f(Ne.$$.fragment,e),ln=!1},d(e){e&&(n(_),n(o),n(y),n(b),n(w),n(Be),n(Z),n(Ae),n(W),n(Se),n(Xe),n(ze),n(q),n(Re),n(Fe),n(L),n(Pe),n(H),n(Ke),n(Oe),n(N),n(De),n(et),n(tt),n(Q),n(nt),n(at),n(st),n(A),n(lt),n(it),n(dt),n(ct),n(z),n(rt),n(ot),n(F),n(pt),n(ut),n(K),n(gt),n(ht),n(ft),n(mt),n(ee),n(yt),n(te),n(bt),n(ne),n(_t),n(Mt),n(se),n(wt),n(Tt),n(ie),n(It),n(Ct),n(ce),n(jt),n($t),n(oe),n(Ut),n(pe),n(Jt),n(vt),n(kt),n(ge),n(Zt),n(Wt),n(fe),n(xt),n(me),n(qt),n(Gt),n(be),n(Lt),n(_e),n(Ht),n(Vt),n(Nt),n(we),n(Et),n(Qt),n(Ie),n(Yt),n(Bt),n(je),n(At),n(St),n(Ue),n(Xt),n(zt),n(ve),n(Rt),n(Ft),n(Ze),n(Pt),n(Kt),n(xe),n(Ot),n(Dt),n(en),n(Le),n(tn),n(He),n(nn),n(an),n(sn),n(Ye)),n(i),m(C,e),m(j,e),m(x,e),m(G,e),m(V,e),m($,e),m(E,e),m(Y,e),m(B,e),m(S,e),m(U,e),m(X,e),m(R,e),m(P,e),m(O,e),m(J,e),m(D,e),m(ae,e),m(le,e),m(de,e),m(re,e),m(v,e),m(ue,e),m(he,e),m(ye,e),m(k,e),m(Me,e),m(Te,e),m(Ce,e),m($e,e),m(Je,e),m(ke,e),m(We,e),m(qe,e),m(Ge,e),m(Ve,e),m(Ne,e)}}}const ra='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific provider","local":"using-a-specific-provider","sections":[],"depth":3},{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using Inference Endpoints","local":"using-inference-endpoints","sections":[],"depth":3},{"title":"Using local endpoints","local":"using-local-endpoints","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"Supported providers and tasks","local":"supported-providers-and-tasks","sections":[],"depth":2},{"title":"OpenAI compatibility","local":"openai-compatibility","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Billing","local":"billing","sections":[],"depth":3},{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2}],"depth":1}';function oa(T){return Pn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends Kn{constructor(i){super(),On(this,i,oa,ca,Fn,{})}}export{ma as component};
