import{s as Un,o as dn,n as le}from"../chunks/scheduler.f6b352c8.js";import{S as jn,i as fn,g as p,s as n,r as c,A as Cn,h as o,f as t,c as a,j as mn,u as M,x as i,k as Jn,y as bn,a as e,v as h,d as y,t as u,w as T}from"../chunks/index.b90df637.js";import{T as se}from"../chunks/Tip.366d2e6e.js";import{C as m}from"../chunks/CodeBlock.e5718f9d.js";import{H as U,E as vn}from"../chunks/index.b1d6a402.js";function gn(C){let r,J='We connect to our Gradio based MCP server via the <a href="https://www.npmjs.com/package/mcp-remote" rel="nofollow"><code>mcp-remote</code></a> package.';return{c(){r=p("p"),r.innerHTML=J},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1a2ezw5"&&(r.innerHTML=J)},m(w,d){e(w,r,d)},p:le,d(w){w&&t(r)}}}function Bn(C){let r,J='The complete <code>McpClient.ts</code> code file is <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/mcp-client/src/McpClient.ts" rel="nofollow">here</a> if you want to follow along using the actual code 🤓';return{c(){r=p("p"),r.innerHTML=J},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1dheya"&&(r.innerHTML=J)},m(w,d){e(w,r,d)},p:le,d(w){w&&t(r)}}}function In(C){let r,J='The complete <code>Agent.ts</code> code file is <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/mcp-client/src/Agent.ts" rel="nofollow">here</a>.';return{c(){r=p("p"),r.innerHTML=J},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-9c5nqs"&&(r.innerHTML=J)},m(w,d){e(w,r,d)},p:le,d(w){w&&t(r)}}}function kn(C){let r,J,w,d,B,Ml,I,te='Now that we’ve built MCP servers in Gradio let’s explore MCP clients even further. This section builds on the experimental project <a href="https://huggingface.co/blog/tiny-agents" rel="nofollow">Tiny Agents</a>, which demonstrates a super simple way of deploying MCP clients that can connect to services like our Gradio sentiment analysis server.',hl,k,ee="In this short exercise, we will walk you through how to implement a TypeScript (JS) MCP client that can communicate with any MCP server, including the Gradio-based sentiment analysis server we built in the previous section. You’ll see how MCP standardizes the way agents interact with tools, making Agentic AI development significantly simpler.",yl,Q,ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/tiny-agents/thumbnail.jpg" alt="meme"/>',ul,N,ae="Image credit https://x.com/adamdotdev",Tl,S,pe="We will show you how to connect your tiny agent to Gradio-based MCP servers, allowing it to leverage both your custom sentiment analysis tool and other pre-built tools.",wl,E,ml,G,oe="If you have NodeJS (with <code>pnpm</code> or <code>npm</code>), just run this in a terminal:",Jl,x,Ul,$,ie="or if using <code>pnpm</code>:",dl,Z,jl,A,re="This installs the package into a temporary folder then executes its command.",fl,W,ce="You’ll see your simple Agent connect to multiple MCP servers (running locally), loading their tools (similar to how it would load your Gradio sentiment analysis tool), then prompting you for a conversation.",Cl,j,Me='<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/tiny-agents/use-filesystem.mp4" type="video/mp4"/>',bl,H,he="By default our example Agent connects to the following two MCP servers:",vl,V,ye='<li>the “canonical” <a href="https://github.com/modelcontextprotocol/servers/tree/main/src/filesystem" rel="nofollow">file system server</a>, which gets access to your Desktop,</li> <li>and the <a href="https://github.com/microsoft/playwright-mcp" rel="nofollow">Playwright MCP</a> server, which knows how to use a sandboxed Chromium browser for you.</li>',gl,R,ue="You can easily add your Gradio sentiment analysis server to this list, as we’ll demonstrate later in this section.",Bl,_,Te=`<p>[!NOTE]
Note: this is a bit counter-intuitive but currently, all MCP servers in tiny agents are actually local processes (though remote servers are coming soon). This doesn’t includes our Gradio server running on localhost:7860.</p>`,Il,z,we="Our input for this first video was:",kl,L,me="<p>write a haiku about the Hugging Face community and write it to a file named “hf.txt” on my Desktop</p>",Ql,X,Je="Now let us try this prompt that involves some Web browsing:",Nl,D,Ue="<p>do a Web Search for HF inference providers on Brave Search and open the first 3 results</p>",Sl,f,de='<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/tiny-agents/brave-search.mp4" type="video/mp4"/>',El,Y,je="With our Gradio sentiment analysis tool connected, we could similarly ask:",Gl,O,fe="<p>analyze the sentiment of this review: “I absolutely loved the product, it exceeded all my expectations!”</p>",xl,q,$l,P,Ce="In terms of model/provider pair, our example Agent uses by default:",Zl,F,be='<li><a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">“Qwen/Qwen2.5-72B-Instruct”</a></li> <li>running on <a href="https://huggingface.co/docs/inference-providers/providers/nebius" rel="nofollow">Nebius</a></li>',Al,K,ve="This is all configurable through env variables! Here, we’ll also show how to add our Gradio MCP server:",Wl,ss,Hl,b,Vl,ls,Rl,ts,ge="What makes connecting Gradio MCP servers to our Tiny Agent possible is that recent LLMs (both closed and open) have been trained for function calling, aka. tool use. This same capability powers our integration with the sentiment analysis tool we built with Gradio.",_l,es,Be="A tool is defined by its name, a description, and a JSONSchema representation of its parameters - exactly how we defined our sentiment analysis function in the Gradio server. Let’s look at a simple example:",zl,ns,Ll,as,Ie="Our Gradio sentiment analysis tool would have a similar structure, with <code>text</code> as the input parameter instead of <code>location</code>.",Xl,ps,ke='The canonical documentation I will link to here is <a href="https://platform.openai.com/docs/guides/function-calling?api-mode=chat" rel="nofollow">OpenAI’s function calling doc</a>. (Yes… OpenAI pretty much defines the LLM standards for the whole community 😅).',Dl,os,Qe=`Inference engines let you pass a list of tools when calling the LLM, and the LLM is free to call zero, one or more of those tools.
As a developer, you run the tools and feed their result back into the LLM to continue the generation.`,Yl,is,Ne="<p>Note that in the backend (at the inference engine level), the tools are simply passed to the model in a specially-formatted <code>chat_template</code>, like any other message, and then parsed out of the response (using model-specific special tokens) to expose them as tool calls.</p>",Ol,rs,ql,cs,Se="Now that we know what a tool is in recent LLMs, let’s implement the actual MCP client that will communicate with our Gradio server and other MCP servers.",Pl,Ms,Ee='The official doc at <a href="https://modelcontextprotocol.io/quickstart/client" rel="nofollow">https://modelcontextprotocol.io/quickstart/client</a> is fairly well-written. You only have to replace any mention of the Anthropic client SDK by any other OpenAI-compatible client SDK. (There is also a <a href="https://modelcontextprotocol.io/llms-full.txt" rel="nofollow">llms.txt</a> you can feed into your LLM of choice to help you code along).',Fl,hs,Ge="As a reminder, we use HF’s <code>InferenceClient</code> for our inference client.",Kl,v,st,ys,xe="Our <code>McpClient</code> class has:",lt,us,$e="<li>an Inference Client (works with any Inference Provider, and <code>huggingface/inference</code> supports both remote and local endpoints)</li> <li>a set of MCP client sessions, one for each connected MCP server (this allows us to connect to multiple servers, including our Gradio server)</li> <li>and a list of available tools that is going to be filled from the connected servers and just slightly re-formatted.</li>",tt,Ts,et,ws,Ze="To connect to a MCP server (like our Gradio sentiment analysis server), the official <code>@modelcontextprotocol/sdk/client</code> TypeScript SDK provides a <code>Client</code> class with a <code>listTools()</code> method:",nt,ms,at,Js,Ae="<code>StdioServerParameters</code> is an interface from the MCP SDK that will let you easily spawn a local process: as we mentioned earlier, currently, all MCP servers are actually local processes, including our Gradio server (though we access it via HTTP).",pt,Us,We="For each MCP server we connect to (including our Gradio sentiment analysis server), we slightly re-format its list of tools and add them to <code>this.availableTools</code>.",ot,ds,it,js,He="Using our sentiment analysis tool (or any other MCP tool) is straightforward. You just pass <code>this.availableTools</code> to your LLM chat-completion, in addition to your usual array of messages:",rt,fs,ct,Cs,Ve="<code>tool_choice: &quot;auto&quot;</code> is the parameter you pass for the LLM to generate zero, one, or multiple tool calls.",Mt,bs,Re="When parsing or streaming the output, the LLM will generate some tool calls (i.e. a function name, and some JSON-encoded arguments), which you (as a developer) need to compute. The MCP client SDK once again makes that very easy; it has a <code>client.callTool()</code> method:",ht,vs,yt,gs,_e="If the LLM chooses to use our sentiment analysis tool, this code will automatically route the call to our Gradio server, execute the analysis, and return the result back to the LLM.",ut,Bs,ze="Finally you will add the resulting tool message to your <code>messages</code> array and back into the LLM.",Tt,Is,wt,ks,Le="Now that we have an MCP client capable of connecting to arbitrary MCP servers (including our Gradio sentiment analysis server) to get lists of tools and capable of injecting them and parsing them from the LLM inference, well… what is an Agent?",mt,Qs,Xe="<p>Once you have an inference client with a set of tools, then an Agent is just a while loop on top of it.</p>",Jt,Ns,De="In more detail, an Agent is simply a combination of:",Ut,Ss,Ye="<li>a system prompt</li> <li>an LLM Inference client</li> <li>an MCP client to hook a set of Tools into it from a bunch of MCP servers (including our Gradio server)</li> <li>some basic control flow (see below for the while loop)</li>",dt,g,jt,Es,Oe="Our Agent class simply extends McpClient:",ft,Gs,Ct,xs,qe='By default, we use a very simple system prompt inspired by the one shared in the <a href="https://cookbook.openai.com/examples/gpt4-1_prompting_guide" rel="nofollow">GPT-4.1 prompting guide</a>.',bt,$s,Pe="Even though this comes from OpenAI 😈, this sentence in particular applies to more and more models, both closed and open:",vt,Zs,Fe="<p>We encourage developers to exclusively use the tools field to pass tools, rather than manually injecting tool descriptions into your prompt and writing a separate parser for tool calls, as some have reported doing in the past.</p>",gt,As,Ke="Which is to say, we don’t need to provide painstakingly formatted lists of tool use examples in the prompt. The <code>tools: this.availableTools</code> param is enough, and the LLM will know how to use both the filesystem tools and our Gradio sentiment analysis tool.",Bt,Ws,sn="Loading the tools on the Agent is literally just connecting to the MCP servers we want (in parallel because it’s so easy to do in JS):",It,Hs,kt,Vs,ln="We add two extra tools (outside of MCP) that can be used by the LLM for our Agent’s control flow:",Qt,Rs,Nt,_s,tn="When calling any of these tools, the Agent will break its loop and give control back to the user for new input.",St,zs,Et,Ls,en="Behold our complete while loop.🎉",Gt,Xs,nn="The gist of our Agent’s main while loop is that we simply iterate with the LLM alternating between tool calling and feeding it the tool results, and we do so <strong>until the LLM starts to respond with two non-tool messages in a row</strong>.",xt,Ds,an="This is the complete while loop:",$t,Ys,Zt,Os,At,qs,pn="Now that we understand both Tiny Agents and Gradio MCP servers, let’s see how they work together! The beauty of MCP is that it provides a standardized way for agents to interact with any MCP-compatible server, including our Gradio-based sentiment analysis server.",Wt,Ps,Ht,Fs,on="To connect our Tiny Agent to the Gradio sentiment analysis server we built earlier, we just need to add it to our list of servers. Here’s how we can modify our agent configuration:",Vt,Ks,Rt,sl,rn="Now our agent can use the sentiment analysis tool alongside other tools! For example, it could:",_t,ll,cn="<li>Read text from a file using the filesystem server</li> <li>Analyze its sentiment using our Gradio server</li> <li>Write the results back to a file</li>",zt,tl,Lt,el,Mn="Here’s what a conversation with our agent might look like:",Xt,nl,Dt,al,Yt,pl,hn="When deploying your Gradio MCP server to Hugging Face Spaces, you’ll need to update the server URL in your agent configuration to point to your deployed space:",Ot,ol,qt,il,yn="This allows your agent to use the sentiment analysis tool from anywhere, not just locally!",Pt,rl,Ft,cl,Kt;return B=new U({props:{title:"Tiny Agents: an MCP-powered agent in 50 lines of code",local:"tiny-agents-an-mcp-powered-agent-in-50-lines-of-code",headingTag:"h1"}}),E=new U({props:{title:"How to run the complete demo",local:"how-to-run-the-complete-demo",headingTag:"h2"}}),x=new m({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZtY3AtY2xpZW50",highlighted:"npx @huggingface/mcp-client",wrap:!1}}),Z=new m({props:{code:"cG5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudA==",highlighted:"pnpx @huggingface/mcp-client",wrap:!1}}),q=new U({props:{title:"Default model and provider",local:"default-model-and-provider",headingTag:"h3"}}),ss=new m({props:{code:"Y29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEFnZW50KCU3QiUwQSUwOXByb3ZpZGVyJTNBJTIwcHJvY2Vzcy5lbnYuUFJPVklERVIlMjAlM0YlM0YlMjAlMjJuZWJpdXMlMjIlMkMlMEElMDltb2RlbCUzQSUyMHByb2Nlc3MuZW52Lk1PREVMX0lEJTIwJTNGJTNGJTIwJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyJTJDJTBBJTA5YXBpS2V5JTNBJTIwcHJvY2Vzcy5lbnYuSEZfVE9LRU4lMkMlMEElMDlzZXJ2ZXJzJTNBJTIwJTVCJTBBJTA5JTA5JTJGJTJGJTIwRGVmYXVsdCUyMHNlcnZlcnMlMEElMDklMDklN0IlMEElMDklMDklMDljb21tYW5kJTNBJTIwJTIybnB4JTIyJTJDJTBBJTA5JTA5JTA5YXJncyUzQSUyMCU1QiUyMiU0MG1vZGVsY29udGV4dHByb3RvY29sJTJGc2VydmVycyUyMiUyQyUyMCUyMmZpbGVzeXN0ZW0lMjIlNUQlMEElMDklMDklN0QlMkMlMEElMDklMDklN0IlMEElMDklMDklMDljb21tYW5kJTNBJTIwJTIybnB4JTIyJTJDJTBBJTA5JTA5JTA5YXJncyUzQSUyMCU1QiUyMnBsYXl3cmlnaHQtbWNwJTIyJTVEJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTA5JTJGJTJGJTIwT3VyJTIwR3JhZGlvJTIwc2VudGltZW50JTIwYW5hbHlzaXMlMjBzZXJ2ZXIlMEElMDklMDklN0IlMEElMDklMDklMDljb21tYW5kJTNBJTIwJTIybnB4JTIyJTJDJTBBJTA5JTA5JTA5YXJncyUzQSUyMCU1QiUwQSUwOSUwOSUwOSUwOSUyMm1jcC1yZW1vdGUlMjIlMkMlMEElMDklMDklMDklMDklMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBNzg2MCUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2UlMjIlMEElMDklMDklMDklNUQlMEElMDklMDklN0QlMEElMDklNUQlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
	<span class="hljs-attr">provider</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">PROVIDER</span> ?? <span class="hljs-string">&quot;nebius&quot;</span>,
	<span class="hljs-attr">model</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">MODEL_ID</span> ?? <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
	<span class="hljs-attr">apiKey</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>,
	<span class="hljs-attr">servers</span>: [
		<span class="hljs-comment">// Default servers</span>
		{
			<span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
			<span class="hljs-attr">args</span>: [<span class="hljs-string">&quot;@modelcontextprotocol/servers&quot;</span>, <span class="hljs-string">&quot;filesystem&quot;</span>]
		},
		{
			<span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
			<span class="hljs-attr">args</span>: [<span class="hljs-string">&quot;playwright-mcp&quot;</span>]
		},
		<span class="hljs-comment">// Our Gradio sentiment analysis server</span>
		{
			<span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
			<span class="hljs-attr">args</span>: [
				<span class="hljs-string">&quot;mcp-remote&quot;</span>,
				<span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>
			]
		}
	],
});`,wrap:!1}}),b=new se({props:{$$slots:{default:[gn]},$$scope:{ctx:C}}}),ls=new U({props:{title:"The foundation for this: tool calling native support in LLMs.",local:"the-foundation-for-this-tool-calling-native-support-in-llms",headingTag:"h2"}}),ns=new m({props:{code:"Y29uc3QlMjB3ZWF0aGVyVG9vbCUyMCUzRCUyMCU3QiUwQSUwOXR5cGUlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUwOWZ1bmN0aW9uJTNBJTIwJTdCJTBBJTA5JTA5bmFtZSUzQSUyMCUyMmdldF93ZWF0aGVyJTIyJTJDJTBBJTA5JTA5ZGVzY3JpcHRpb24lM0ElMjAlMjJHZXQlMjBjdXJyZW50JTIwdGVtcGVyYXR1cmUlMjBmb3IlMjBhJTIwZ2l2ZW4lMjBsb2NhdGlvbi4lMjIlMkMlMEElMDklMDlwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTA5JTA5JTA5dHlwZSUzQSUyMCUyMm9iamVjdCUyMiUyQyUwQSUwOSUwOSUwOXByb3BlcnRpZXMlM0ElMjAlN0IlMEElMDklMDklMDklMDlsb2NhdGlvbiUzQSUyMCU3QiUwQSUwOSUwOSUwOSUwOSUwOXR5cGUlM0ElMjAlMjJzdHJpbmclMjIlMkMlMEElMDklMDklMDklMDklMDlkZXNjcmlwdGlvbiUzQSUyMCUyMkNpdHklMjBhbmQlMjBjb3VudHJ5JTIwZS5nLiUyMEJvZ290JUMzJUExJTJDJTIwQ29sb21iaWElMjIlMkMlMEElMDklMDklMDklMDklN0QlMkMlMEElMDklMDklMDklN0QlMkMlMEElMDklMDklN0QlMkMlMEElMDklN0QlMkMlMEElN0QlM0I=",highlighted:`<span class="hljs-keyword">const</span> weatherTool = {
	<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;function&quot;</span>,
	<span class="hljs-attr">function</span>: {
		<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
		<span class="hljs-attr">description</span>: <span class="hljs-string">&quot;Get current temperature for a given location.&quot;</span>,
		<span class="hljs-attr">parameters</span>: {
			<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;object&quot;</span>,
			<span class="hljs-attr">properties</span>: {
				<span class="hljs-attr">location</span>: {
					<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;string&quot;</span>,
					<span class="hljs-attr">description</span>: <span class="hljs-string">&quot;City and country e.g. Bogotá, Colombia&quot;</span>,
				},
			},
		},
	},
};`,wrap:!1}}),rs=new U({props:{title:"Implementing an MCP client on top of InferenceClient",local:"implementing-an-mcp-client-on-top-of-inferenceclient",headingTag:"h2"}}),v=new se({props:{warning:!1,$$slots:{default:[Bn]},$$scope:{ctx:C}}}),Ts=new m({props:{code:"ZXhwb3J0JTIwY2xhc3MlMjBNY3BDbGllbnQlMjAlN0IlMEElMDlwcm90ZWN0ZWQlMjBjbGllbnQlM0ElMjBJbmZlcmVuY2VDbGllbnQlM0IlMEElMDlwcm90ZWN0ZWQlMjBwcm92aWRlciUzQSUyMHN0cmluZyUzQiUwQSUwOXByb3RlY3RlZCUyMG1vZGVsJTNBJTIwc3RyaW5nJTNCJTBBJTA5cHJpdmF0ZSUyMGNsaWVudHMlM0ElMjBNYXAlM0NUb29sTmFtZSUyQyUyMENsaWVudCUzRSUyMCUzRCUyMG5ldyUyME1hcCgpJTNCJTBBJTA5cHVibGljJTIwcmVhZG9ubHklMjBhdmFpbGFibGVUb29scyUzQSUyMENoYXRDb21wbGV0aW9uSW5wdXRUb29sJTVCJTVEJTIwJTNEJTIwJTVCJTVEJTNCJTBBJTBBJTA5Y29uc3RydWN0b3IoJTdCJTIwcHJvdmlkZXIlMkMlMjBtb2RlbCUyQyUyMGFwaUtleSUyMCU3RCUzQSUyMCU3QiUyMHByb3ZpZGVyJTNBJTIwSW5mZXJlbmNlUHJvdmlkZXIlM0IlMjBtb2RlbCUzQSUyMHN0cmluZyUzQiUyMGFwaUtleSUzQSUyMHN0cmluZyUyMCU3RCklMjAlN0IlMEElMDklMDl0aGlzLmNsaWVudCUyMCUzRCUyMG5ldyUyMEluZmVyZW5jZUNsaWVudChhcGlLZXkpJTNCJTBBJTA5JTA5dGhpcy5wcm92aWRlciUyMCUzRCUyMHByb3ZpZGVyJTNCJTBBJTA5JTA5dGhpcy5tb2RlbCUyMCUzRCUyMG1vZGVsJTNCJTBBJTA5JTdEJTBBJTA5JTBBJTA5JTJGJTJGJTIwJTVCLi4uJTVEJTBBJTdE",highlighted:`<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">McpClient</span> {
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">client</span>: <span class="hljs-title class_">InferenceClient</span>;
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">provider</span>: <span class="hljs-built_in">string</span>;
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">model</span>: <span class="hljs-built_in">string</span>;
	<span class="hljs-keyword">private</span> <span class="hljs-attr">clients</span>: <span class="hljs-title class_">Map</span>&lt;<span class="hljs-title class_">ToolName</span>, <span class="hljs-title class_">Client</span>&gt; = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Map</span>();
	<span class="hljs-keyword">public</span> <span class="hljs-keyword">readonly</span> <span class="hljs-attr">availableTools</span>: <span class="hljs-title class_">ChatCompletionInputTool</span>[] = [];

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params">{ provider, model, apiKey }: { provider: InferenceProvider; model: <span class="hljs-built_in">string</span>; apiKey: <span class="hljs-built_in">string</span> }</span>) {
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">client</span> = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(apiKey);
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">provider</span> = provider;
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span> = model;
	}
	
	<span class="hljs-comment">// [...]</span>
}`,wrap:!1}}),ms=new m({props:{code:"YXN5bmMlMjBhZGRNY3BTZXJ2ZXIoc2VydmVyJTNBJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKSUzQSUyMFByb21pc2UlM0N2b2lkJTNFJTIwJTdCJTBBJTA5Y29uc3QlMjB0cmFuc3BvcnQlMjAlM0QlMjBuZXclMjBTdGRpb0NsaWVudFRyYW5zcG9ydCglN0IlMEElMDklMDkuLi5zZXJ2ZXIlMkMlMEElMDklMDllbnYlM0ElMjAlN0IlMjAuLi5zZXJ2ZXIuZW52JTJDJTIwUEFUSCUzQSUyMHByb2Nlc3MuZW52LlBBVEglMjAlM0YlM0YlMjAlMjIlMjIlMjAlN0QlMkMlMEElMDklN0QpJTNCJTBBJTA5Y29uc3QlMjBtY3AlMjAlM0QlMjBuZXclMjBDbGllbnQoJTdCJTIwbmFtZSUzQSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudCUyMiUyQyUyMHZlcnNpb24lM0ElMjBwYWNrYWdlVmVyc2lvbiUyMCU3RCklM0IlMEElMDlhd2FpdCUyMG1jcC5jb25uZWN0KHRyYW5zcG9ydCklM0IlMEElMEElMDljb25zdCUyMHRvb2xzUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBtY3AubGlzdFRvb2xzKCklM0IlMEElMDlkZWJ1ZyglMEElMDklMDklMjJDb25uZWN0ZWQlMjB0byUyMHNlcnZlciUyMHdpdGglMjB0b29scyUzQSUyMiUyQyUwQSUwOSUwOXRvb2xzUmVzdWx0LnRvb2xzLm1hcCgoJTdCJTIwbmFtZSUyMCU3RCklMjAlM0QlM0UlMjBuYW1lKSUwQSUwOSklM0IlMEElMEElMDlmb3IlMjAoY29uc3QlMjB0b29sJTIwb2YlMjB0b29sc1Jlc3VsdC50b29scyklMjAlN0IlMEElMDklMDl0aGlzLmNsaWVudHMuc2V0KHRvb2wubmFtZSUyQyUyMG1jcCklM0IlMEElMDklN0QlMEElMEElMDl0aGlzLmF2YWlsYWJsZVRvb2xzLnB1c2goJTBBJTA5JTA5Li4udG9vbHNSZXN1bHQudG9vbHMubWFwKCh0b29sKSUyMCUzRCUzRSUyMCU3QiUwQSUwOSUwOSUwOXJldHVybiUyMCU3QiUwQSUwOSUwOSUwOSUwOXR5cGUlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUwOSUwOSUwOSUwOWZ1bmN0aW9uJTNBJTIwJTdCJTBBJTA5JTA5JTA5JTA5JTA5bmFtZSUzQSUyMHRvb2wubmFtZSUyQyUwQSUwOSUwOSUwOSUwOSUwOWRlc2NyaXB0aW9uJTNBJTIwdG9vbC5kZXNjcmlwdGlvbiUyQyUwQSUwOSUwOSUwOSUwOSUwOXBhcmFtZXRlcnMlM0ElMjB0b29sLmlucHV0U2NoZW1hJTJDJTBBJTA5JTA5JTA5JTA5JTdEJTJDJTBBJTA5JTA5JTA5JTdEJTIwc2F0aXNmaWVzJTIwQ2hhdENvbXBsZXRpb25JbnB1dFRvb2wlM0IlMEElMDklMDklN0QpJTBBJTA5KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-title function_">addMcpServer</span>(<span class="hljs-attr">server</span>: <span class="hljs-title class_">StdioServerParameters</span>): <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-built_in">void</span>&gt; {
	<span class="hljs-keyword">const</span> transport = <span class="hljs-keyword">new</span> <span class="hljs-title class_">StdioClientTransport</span>({
		...server,
		<span class="hljs-attr">env</span>: { ...server.<span class="hljs-property">env</span>, <span class="hljs-attr">PATH</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">PATH</span> ?? <span class="hljs-string">&quot;&quot;</span> },
	});
	<span class="hljs-keyword">const</span> mcp = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Client</span>({ <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;@huggingface/mcp-client&quot;</span>, <span class="hljs-attr">version</span>: packageVersion });
	<span class="hljs-keyword">await</span> mcp.<span class="hljs-title function_">connect</span>(transport);

	<span class="hljs-keyword">const</span> toolsResult = <span class="hljs-keyword">await</span> mcp.<span class="hljs-title function_">listTools</span>();
	<span class="hljs-title function_">debug</span>(
		<span class="hljs-string">&quot;Connected to server with tools:&quot;</span>,
		toolsResult.<span class="hljs-property">tools</span>.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">{ name }</span>) =&gt;</span> name)
	);

	<span class="hljs-keyword">for</span> (<span class="hljs-keyword">const</span> tool <span class="hljs-keyword">of</span> toolsResult.<span class="hljs-property">tools</span>) {
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">clients</span>.<span class="hljs-title function_">set</span>(tool.<span class="hljs-property">name</span>, mcp);
	}

	<span class="hljs-variable language_">this</span>.<span class="hljs-property">availableTools</span>.<span class="hljs-title function_">push</span>(
		...toolsResult.<span class="hljs-property">tools</span>.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">tool</span>) =&gt;</span> {
			<span class="hljs-keyword">return</span> {
				<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;function&quot;</span>,
				<span class="hljs-attr">function</span>: {
					<span class="hljs-attr">name</span>: tool.<span class="hljs-property">name</span>,
					<span class="hljs-attr">description</span>: tool.<span class="hljs-property">description</span>,
					<span class="hljs-attr">parameters</span>: tool.<span class="hljs-property">inputSchema</span>,
				},
			} satisfies <span class="hljs-title class_">ChatCompletionInputTool</span>;
		})
	);
}`,wrap:!1}}),ds=new U({props:{title:"How to use the tools",local:"how-to-use-the-tools",headingTag:"h3"}}),fs=new m({props:{code:"Y29uc3QlMjBzdHJlYW0lMjAlM0QlMjB0aGlzLmNsaWVudC5jaGF0Q29tcGxldGlvblN0cmVhbSglN0IlMEElMDlwcm92aWRlciUzQSUyMHRoaXMucHJvdmlkZXIlMkMlMEElMDltb2RlbCUzQSUyMHRoaXMubW9kZWwlMkMlMEElMDltZXNzYWdlcyUyQyUwQSUwOXRvb2xzJTNBJTIwdGhpcy5hdmFpbGFibGVUb29scyUyQyUwQSUwOXRvb2xfY2hvaWNlJTNBJTIwJTIyYXV0byUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> stream = <span class="hljs-variable language_">this</span>.<span class="hljs-property">client</span>.<span class="hljs-title function_">chatCompletionStream</span>({
	<span class="hljs-attr">provider</span>: <span class="hljs-variable language_">this</span>.<span class="hljs-property">provider</span>,
	<span class="hljs-attr">model</span>: <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>,
	messages,
	<span class="hljs-attr">tools</span>: <span class="hljs-variable language_">this</span>.<span class="hljs-property">availableTools</span>,
	<span class="hljs-attr">tool_choice</span>: <span class="hljs-string">&quot;auto&quot;</span>,
});`,wrap:!1}}),vs=new m({props:{code:"Y29uc3QlMjB0b29sTmFtZSUyMCUzRCUyMHRvb2xDYWxsLmZ1bmN0aW9uLm5hbWUlM0IlMEFjb25zdCUyMHRvb2xBcmdzJTIwJTNEJTIwSlNPTi5wYXJzZSh0b29sQ2FsbC5mdW5jdGlvbi5hcmd1bWVudHMpJTNCJTBBJTBBY29uc3QlMjB0b29sTWVzc2FnZSUzQSUyMENoYXRDb21wbGV0aW9uSW5wdXRNZXNzYWdlVG9vbCUyMCUzRCUyMCU3QiUwQSUwOXJvbGUlM0ElMjAlMjJ0b29sJTIyJTJDJTBBJTA5dG9vbF9jYWxsX2lkJTNBJTIwdG9vbENhbGwuaWQlMkMlMEElMDljb250ZW50JTNBJTIwJTIyJTIyJTJDJTBBJTA5bmFtZSUzQSUyMHRvb2xOYW1lJTJDJTBBJTdEJTNCJTBBJTBBJTJGJTJGJTJGJTIwR2V0JTIwdGhlJTIwYXBwcm9wcmlhdGUlMjBzZXNzaW9uJTIwZm9yJTIwdGhpcyUyMHRvb2wlMEFjb25zdCUyMGNsaWVudCUyMCUzRCUyMHRoaXMuY2xpZW50cy5nZXQodG9vbE5hbWUpJTNCJTBBaWYlMjAoY2xpZW50KSUyMCU3QiUwQSUwOWNvbnN0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuY2FsbFRvb2woJTdCJTIwbmFtZSUzQSUyMHRvb2xOYW1lJTJDJTIwYXJndW1lbnRzJTNBJTIwdG9vbEFyZ3MlMjAlN0QpJTNCJTBBJTA5dG9vbE1lc3NhZ2UuY29udGVudCUyMCUzRCUyMHJlc3VsdC5jb250ZW50JTVCMCU1RC50ZXh0JTNCJTBBJTdEJTIwZWxzZSUyMCU3QiUwQSUwOXRvb2xNZXNzYWdlLmNvbnRlbnQlMjAlM0QlMjAlNjBFcnJvciUzQSUyME5vJTIwc2Vzc2lvbiUyMGZvdW5kJTIwZm9yJTIwdG9vbCUzQSUyMCUyNCU3QnRvb2xOYW1lJTdEJTYwJTNCJTBBJTdE",highlighted:`<span class="hljs-keyword">const</span> toolName = toolCall.<span class="hljs-property">function</span>.<span class="hljs-property">name</span>;
<span class="hljs-keyword">const</span> toolArgs = <span class="hljs-title class_">JSON</span>.<span class="hljs-title function_">parse</span>(toolCall.<span class="hljs-property">function</span>.<span class="hljs-property">arguments</span>);

<span class="hljs-keyword">const</span> <span class="hljs-attr">toolMessage</span>: <span class="hljs-title class_">ChatCompletionInputMessageTool</span> = {
	<span class="hljs-attr">role</span>: <span class="hljs-string">&quot;tool&quot;</span>,
	<span class="hljs-attr">tool_call_id</span>: toolCall.<span class="hljs-property">id</span>,
	<span class="hljs-attr">content</span>: <span class="hljs-string">&quot;&quot;</span>,
	<span class="hljs-attr">name</span>: toolName,
};

<span class="hljs-comment">/// Get the appropriate session for this tool</span>
<span class="hljs-keyword">const</span> client = <span class="hljs-variable language_">this</span>.<span class="hljs-property">clients</span>.<span class="hljs-title function_">get</span>(toolName);
<span class="hljs-keyword">if</span> (client) {
	<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">callTool</span>({ <span class="hljs-attr">name</span>: toolName, <span class="hljs-attr">arguments</span>: toolArgs });
	toolMessage.<span class="hljs-property">content</span> = result.<span class="hljs-property">content</span>[<span class="hljs-number">0</span>].<span class="hljs-property">text</span>;
} <span class="hljs-keyword">else</span> {
	toolMessage.<span class="hljs-property">content</span> = <span class="hljs-string">\`Error: No session found for tool: <span class="hljs-subst">\${toolName}</span>\`</span>;
}`,wrap:!1}}),Is=new U({props:{title:"Our 50-lines-of-code Agent 🤯",local:"our-50-lines-of-code-agent-",headingTag:"h2"}}),g=new se({props:{warning:!1,$$slots:{default:[In]},$$scope:{ctx:C}}}),Gs=new m({props:{code:"ZXhwb3J0JTIwY2xhc3MlMjBBZ2VudCUyMGV4dGVuZHMlMjBNY3BDbGllbnQlMjAlN0IlMEElMDlwcml2YXRlJTIwcmVhZG9ubHklMjBzZXJ2ZXJzJTNBJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTVCJTVEJTNCJTBBJTA5cHJvdGVjdGVkJTIwbWVzc2FnZXMlM0ElMjBDaGF0Q29tcGxldGlvbklucHV0TWVzc2FnZSU1QiU1RCUzQiUwQSUwQSUwOWNvbnN0cnVjdG9yKCU3QiUwQSUwOSUwOXByb3ZpZGVyJTJDJTBBJTA5JTA5bW9kZWwlMkMlMEElMDklMDlhcGlLZXklMkMlMEElMDklMDlzZXJ2ZXJzJTJDJTBBJTA5JTA5cHJvbXB0JTJDJTBBJTA5JTdEJTNBJTIwJTdCJTBBJTA5JTA5cHJvdmlkZXIlM0ElMjBJbmZlcmVuY2VQcm92aWRlciUzQiUwQSUwOSUwOW1vZGVsJTNBJTIwc3RyaW5nJTNCJTBBJTA5JTA5YXBpS2V5JTNBJTIwc3RyaW5nJTNCJTBBJTA5JTA5c2VydmVycyUzQSUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyU1QiU1RCUzQiUwQSUwOSUwOXByb21wdCUzRiUzQSUyMHN0cmluZyUzQiUwQSUwOSU3RCklMjAlN0IlMEElMDklMDlzdXBlciglN0IlMjBwcm92aWRlciUyQyUyMG1vZGVsJTJDJTIwYXBpS2V5JTIwJTdEKSUzQiUwQSUwOSUwOXRoaXMuc2VydmVycyUyMCUzRCUyMHNlcnZlcnMlM0IlMEElMDklMDl0aGlzLm1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTA5JTA5JTA5JTdCJTBBJTA5JTA5JTA5JTA5cm9sZSUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUwOSUwOSUwOSUwOWNvbnRlbnQlM0ElMjBwcm9tcHQlMjAlM0YlM0YlMjBERUZBVUxUX1NZU1RFTV9QUk9NUFQlMkMlMEElMDklMDklMDklN0QlMkMlMEElMDklMDklNUQlM0IlMEElMDklN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">Agent</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">McpClient</span> {
	<span class="hljs-keyword">private</span> <span class="hljs-keyword">readonly</span> <span class="hljs-attr">servers</span>: <span class="hljs-title class_">StdioServerParameters</span>[];
	<span class="hljs-keyword">protected</span> <span class="hljs-attr">messages</span>: <span class="hljs-title class_">ChatCompletionInputMessage</span>[];

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params">{
		provider,
		model,
		apiKey,
		servers,
		prompt,
	}: {
		provider: InferenceProvider;
		model: <span class="hljs-built_in">string</span>;
		apiKey: <span class="hljs-built_in">string</span>;
		servers: StdioServerParameters[];
		prompt?: <span class="hljs-built_in">string</span>;
	}</span>) {
		<span class="hljs-variable language_">super</span>({ provider, model, apiKey });
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">servers</span> = servers;
		<span class="hljs-variable language_">this</span>.<span class="hljs-property">messages</span> = [
			{
				<span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>,
				<span class="hljs-attr">content</span>: prompt ?? <span class="hljs-variable constant_">DEFAULT_SYSTEM_PROMPT</span>,
			},
		];
	}
}`,wrap:!1}}),Hs=new m({props:{code:"YXN5bmMlMjBsb2FkVG9vbHMoKSUzQSUyMFByb21pc2UlM0N2b2lkJTNFJTIwJTdCJTBBJTA5YXdhaXQlMjBQcm9taXNlLmFsbCh0aGlzLnNlcnZlcnMubWFwKChzKSUyMCUzRCUzRSUyMHRoaXMuYWRkTWNwU2VydmVyKHMpKSklM0IlMEElN0Q=",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-title function_">loadTools</span>(): <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-built_in">void</span>&gt; {
	<span class="hljs-keyword">await</span> <span class="hljs-title class_">Promise</span>.<span class="hljs-title function_">all</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">servers</span>.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">s</span>) =&gt;</span> <span class="hljs-variable language_">this</span>.<span class="hljs-title function_">addMcpServer</span>(s)));
}`,wrap:!1}}),Rs=new m({props:{code:"Y29uc3QlMjB0YXNrQ29tcGxldGlvblRvb2wlM0ElMjBDaGF0Q29tcGxldGlvbklucHV0VG9vbCUyMCUzRCUyMCU3QiUwQSUwOXR5cGUlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUwOWZ1bmN0aW9uJTNBJTIwJTdCJTBBJTA5JTA5bmFtZSUzQSUyMCUyMnRhc2tfY29tcGxldGUlMjIlMkMlMEElMDklMDlkZXNjcmlwdGlvbiUzQSUyMCUyMkNhbGwlMjB0aGlzJTIwdG9vbCUyMHdoZW4lMjB0aGUlMjB0YXNrJTIwZ2l2ZW4lMjBieSUyMHRoZSUyMHVzZXIlMjBpcyUyMGNvbXBsZXRlJTIyJTJDJTBBJTA5JTA5cGFyYW1ldGVycyUzQSUyMCU3QiUwQSUwOSUwOSUwOXR5cGUlM0ElMjAlMjJvYmplY3QlMjIlMkMlMEElMDklMDklMDlwcm9wZXJ0aWVzJTNBJTIwJTdCJTdEJTJDJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTdEJTJDJTBBJTdEJTNCJTBBY29uc3QlMjBhc2tRdWVzdGlvblRvb2wlM0ElMjBDaGF0Q29tcGxldGlvbklucHV0VG9vbCUyMCUzRCUyMCU3QiUwQSUwOXR5cGUlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUwOWZ1bmN0aW9uJTNBJTIwJTdCJTBBJTA5JTA5bmFtZSUzQSUyMCUyMmFza19xdWVzdGlvbiUyMiUyQyUwQSUwOSUwOWRlc2NyaXB0aW9uJTNBJTIwJTIyQXNrJTIwYSUyMHF1ZXN0aW9uJTIwdG8lMjB0aGUlMjB1c2VyJTIwdG8lMjBnZXQlMjBtb3JlJTIwaW5mbyUyMHJlcXVpcmVkJTIwdG8lMjBzb2x2ZSUyMG9yJTIwY2xhcmlmeSUyMHRoZWlyJTIwcHJvYmxlbS4lMjIlMkMlMEElMDklMDlwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTA5JTA5JTA5dHlwZSUzQSUyMCUyMm9iamVjdCUyMiUyQyUwQSUwOSUwOSUwOXByb3BlcnRpZXMlM0ElMjAlN0IlN0QlMkMlMEElMDklMDklN0QlMkMlMEElMDklN0QlMkMlMEElN0QlM0IlMEFjb25zdCUyMGV4aXRMb29wVG9vbHMlMjAlM0QlMjAlNUJ0YXNrQ29tcGxldGlvblRvb2wlMkMlMjBhc2tRdWVzdGlvblRvb2wlNUQlM0I=",highlighted:`<span class="hljs-keyword">const</span> <span class="hljs-attr">taskCompletionTool</span>: <span class="hljs-title class_">ChatCompletionInputTool</span> = {
	<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;function&quot;</span>,
	<span class="hljs-attr">function</span>: {
		<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;task_complete&quot;</span>,
		<span class="hljs-attr">description</span>: <span class="hljs-string">&quot;Call this tool when the task given by the user is complete&quot;</span>,
		<span class="hljs-attr">parameters</span>: {
			<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;object&quot;</span>,
			<span class="hljs-attr">properties</span>: {},
		},
	},
};
<span class="hljs-keyword">const</span> <span class="hljs-attr">askQuestionTool</span>: <span class="hljs-title class_">ChatCompletionInputTool</span> = {
	<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;function&quot;</span>,
	<span class="hljs-attr">function</span>: {
		<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;ask_question&quot;</span>,
		<span class="hljs-attr">description</span>: <span class="hljs-string">&quot;Ask a question to the user to get more info required to solve or clarify their problem.&quot;</span>,
		<span class="hljs-attr">parameters</span>: {
			<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;object&quot;</span>,
			<span class="hljs-attr">properties</span>: {},
		},
	},
};
<span class="hljs-keyword">const</span> exitLoopTools = [taskCompletionTool, askQuestionTool];`,wrap:!1}}),zs=new U({props:{title:"The complete while loop",local:"the-complete-while-loop",headingTag:"h3"}}),Ys=new m({props:{code:"bGV0JTIwbnVtT2ZUdXJucyUyMCUzRCUyMDAlM0IlMEFsZXQlMjBuZXh0VHVyblNob3VsZENhbGxUb29scyUyMCUzRCUyMHRydWUlM0IlMEF3aGlsZSUyMCh0cnVlKSUyMCU3QiUwQSUwOXRyeSUyMCU3QiUwQSUwOSUwOXlpZWxkKiUyMHRoaXMucHJvY2Vzc1NpbmdsZVR1cm5XaXRoVG9vbHModGhpcy5tZXNzYWdlcyUyQyUyMCU3QiUwQSUwOSUwOSUwOWV4aXRMb29wVG9vbHMlMkMlMEElMDklMDklMDlleGl0SWZGaXJzdENodW5rTm9Ub29sJTNBJTIwbnVtT2ZUdXJucyUyMCUzRSUyMDAlMjAlMjYlMjYlMjBuZXh0VHVyblNob3VsZENhbGxUb29scyUyQyUwQSUwOSUwOSUwOWFib3J0U2lnbmFsJTNBJTIwb3B0cy5hYm9ydFNpZ25hbCUyQyUwQSUwOSUwOSU3RCklM0IlMEElMDklN0QlMjBjYXRjaCUyMChlcnIpJTIwJTdCJTBBJTA5JTA5aWYlMjAoZXJyJTIwaW5zdGFuY2VvZiUyMEVycm9yJTIwJTI2JTI2JTIwZXJyLm1lc3NhZ2UlMjAlM0QlM0QlM0QlMjAlMjJBYm9ydEVycm9yJTIyKSUyMCU3QiUwQSUwOSUwOSUwOXJldHVybiUzQiUwQSUwOSUwOSU3RCUwQSUwOSUwOXRocm93JTIwZXJyJTNCJTBBJTA5JTdEJTBBJTA5bnVtT2ZUdXJucyUyQiUyQiUzQiUwQSUwOWNvbnN0JTIwY3VycmVudExhc3QlMjAlM0QlMjB0aGlzLm1lc3NhZ2VzLmF0KC0xKSElM0IlMEElMDlpZiUyMCglMEElMDklMDljdXJyZW50TGFzdC5yb2xlJTIwJTNEJTNEJTNEJTIwJTIydG9vbCUyMiUyMCUyNiUyNiUwQSUwOSUwOWN1cnJlbnRMYXN0Lm5hbWUlMjAlMjYlMjYlMEElMDklMDlleGl0TG9vcFRvb2xzLm1hcCgodCklMjAlM0QlM0UlMjB0LmZ1bmN0aW9uLm5hbWUpLmluY2x1ZGVzKGN1cnJlbnRMYXN0Lm5hbWUpJTBBJTA5KSUyMCU3QiUwQSUwOSUwOXJldHVybiUzQiUwQSUwOSU3RCUwQSUwOWlmJTIwKGN1cnJlbnRMYXN0LnJvbGUlMjAhJTNEJTNEJTIwJTIydG9vbCUyMiUyMCUyNiUyNiUyMG51bU9mVHVybnMlMjAlM0UlMjBNQVhfTlVNX1RVUk5TKSUyMCU3QiUwQSUwOSUwOXJldHVybiUzQiUwQSUwOSU3RCUwQSUwOWlmJTIwKGN1cnJlbnRMYXN0LnJvbGUlMjAhJTNEJTNEJTIwJTIydG9vbCUyMiUyMCUyNiUyNiUyMG5leHRUdXJuU2hvdWxkQ2FsbFRvb2xzKSUyMCU3QiUwQSUwOSUwOXJldHVybiUzQiUwQSUwOSU3RCUwQSUwOWlmJTIwKGN1cnJlbnRMYXN0LnJvbGUlMjAlM0QlM0QlM0QlMjAlMjJ0b29sJTIyKSUyMCU3QiUwQSUwOSUwOW5leHRUdXJuU2hvdWxkQ2FsbFRvb2xzJTIwJTNEJTIwZmFsc2UlM0IlMEElMDklN0QlMjBlbHNlJTIwJTdCJTBBJTA5JTA5bmV4dFR1cm5TaG91bGRDYWxsVG9vbHMlMjAlM0QlMjB0cnVlJTNCJTBBJTA5JTdEJTBBJTdE",highlighted:`<span class="hljs-keyword">let</span> numOfTurns = <span class="hljs-number">0</span>;
<span class="hljs-keyword">let</span> nextTurnShouldCallTools = <span class="hljs-literal">true</span>;
<span class="hljs-keyword">while</span> (<span class="hljs-literal">true</span>) {
	<span class="hljs-keyword">try</span> {
		<span class="hljs-keyword">yield</span>* <span class="hljs-variable language_">this</span>.<span class="hljs-title function_">processSingleTurnWithTools</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">messages</span>, {
			exitLoopTools,
			<span class="hljs-attr">exitIfFirstChunkNoTool</span>: numOfTurns &gt; <span class="hljs-number">0</span> &amp;&amp; nextTurnShouldCallTools,
			<span class="hljs-attr">abortSignal</span>: opts.<span class="hljs-property">abortSignal</span>,
		});
	} <span class="hljs-keyword">catch</span> (err) {
		<span class="hljs-keyword">if</span> (err <span class="hljs-keyword">instanceof</span> <span class="hljs-title class_">Error</span> &amp;&amp; err.<span class="hljs-property">message</span> === <span class="hljs-string">&quot;AbortError&quot;</span>) {
			<span class="hljs-keyword">return</span>;
		}
		<span class="hljs-keyword">throw</span> err;
	}
	numOfTurns++;
	<span class="hljs-keyword">const</span> currentLast = <span class="hljs-variable language_">this</span>.<span class="hljs-property">messages</span>.<span class="hljs-title function_">at</span>(-<span class="hljs-number">1</span>)!;
	<span class="hljs-keyword">if</span> (
		currentLast.<span class="hljs-property">role</span> === <span class="hljs-string">&quot;tool&quot;</span> &amp;&amp;
		currentLast.<span class="hljs-property">name</span> &amp;&amp;
		exitLoopTools.<span class="hljs-title function_">map</span>(<span class="hljs-function">(<span class="hljs-params">t</span>) =&gt;</span> t.<span class="hljs-property">function</span>.<span class="hljs-property">name</span>).<span class="hljs-title function_">includes</span>(currentLast.<span class="hljs-property">name</span>)
	) {
		<span class="hljs-keyword">return</span>;
	}
	<span class="hljs-keyword">if</span> (currentLast.<span class="hljs-property">role</span> !== <span class="hljs-string">&quot;tool&quot;</span> &amp;&amp; numOfTurns &gt; <span class="hljs-variable constant_">MAX_NUM_TURNS</span>) {
		<span class="hljs-keyword">return</span>;
	}
	<span class="hljs-keyword">if</span> (currentLast.<span class="hljs-property">role</span> !== <span class="hljs-string">&quot;tool&quot;</span> &amp;&amp; nextTurnShouldCallTools) {
		<span class="hljs-keyword">return</span>;
	}
	<span class="hljs-keyword">if</span> (currentLast.<span class="hljs-property">role</span> === <span class="hljs-string">&quot;tool&quot;</span>) {
		nextTurnShouldCallTools = <span class="hljs-literal">false</span>;
	} <span class="hljs-keyword">else</span> {
		nextTurnShouldCallTools = <span class="hljs-literal">true</span>;
	}
}`,wrap:!1}}),Os=new U({props:{title:"Connecting Tiny Agents with Gradio MCP Servers",local:"connecting-tiny-agents-with-gradio-mcp-servers",headingTag:"h2"}}),Ps=new U({props:{title:"Using the Gradio Server with Tiny Agents",local:"using-the-gradio-server-with-tiny-agents",headingTag:"h3"}}),Ks=new m({props:{code:"Y29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEFnZW50KCU3QiUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNBJTIwcHJvY2Vzcy5lbnYuUFJPVklERVIlMjAlM0YlM0YlMjAlMjJuZWJpdXMlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzQSUyMHByb2Nlc3MuZW52Lk1PREVMX0lEJTIwJTNGJTNGJTIwJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpS2V5JTNBJTIwcHJvY2Vzcy5lbnYuSEZfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjBzZXJ2ZXJzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwLi4uJTIwZXhpc3RpbmclMjBzZXJ2ZXJzJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWFuZCUzQSUyMCUyMm5weCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3MlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtY3AtcmVtb3RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTc4NjAlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTIwJTIwJTJGJTJGJTIwWW91ciUyMEdyYWRpbyUyME1DUCUyMHNlcnZlciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
    <span class="hljs-attr">provider</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">PROVIDER</span> ?? <span class="hljs-string">&quot;nebius&quot;</span>,
    <span class="hljs-attr">model</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">MODEL_ID</span> ?? <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
    <span class="hljs-attr">apiKey</span>: process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>,
    <span class="hljs-attr">servers</span>: [
        <span class="hljs-comment">// ... existing servers ...</span>
        {
            <span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
            <span class="hljs-attr">args</span>: [
                <span class="hljs-string">&quot;mcp-remote&quot;</span>,
                <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>  <span class="hljs-comment">// Your Gradio MCP server</span>
            ]
        }
    ],
});`,wrap:!1}}),tl=new U({props:{title:"Example Interaction",local:"example-interaction",headingTag:"h3"}}),nl=new m({props:{code:"VXNlciUzQSUyMFJlYWQlMjB0aGUlMjBmaWxlJTIwJTIyZmVlZGJhY2sudHh0JTIyJTIwZnJvbSUyMG15JTIwRGVza3RvcCUyMGFuZCUyMGFuYWx5emUlMjBpdHMlMjBzZW50aW1lbnQlMEElMEFBZ2VudCUzQSUyMEknbGwlMjBoZWxwJTIweW91JTIwYW5hbHl6ZSUyMHRoZSUyMHNlbnRpbWVudCUyMG9mJTIwdGhlJTIwZmVlZGJhY2slMjBmaWxlLiUyMExldCUyMG1lJTIwYnJlYWslMjB0aGlzJTIwZG93biUyMGludG8lMjBzdGVwcyUzQSUwQSUwQTEuJTIwRmlyc3QlMkMlMjBJJ2xsJTIwcmVhZCUyMHRoZSUyMGZpbGUlMjB1c2luZyUyMHRoZSUyMGZpbGVzeXN0ZW0lMjB0b29sJTBBMi4lMjBUaGVuJTJDJTIwSSdsbCUyMGFuYWx5emUlMjBpdHMlMjBzZW50aW1lbnQlMjB1c2luZyUyMHRoZSUyMHNlbnRpbWVudCUyMGFuYWx5c2lzJTIwdG9vbCUwQTMuJTIwRmluYWxseSUyQyUyMEknbGwlMjB3cml0ZSUyMHRoZSUyMHJlc3VsdHMlMjB0byUyMGElMjBuZXclMjBmaWxlJTBBJTBBJTVCQWdlbnQlMjBwcm9jZWVkcyUyMHRvJTIwdXNlJTIwdGhlJTIwdG9vbHMlMjBhbmQlMjBwcm92aWRlJTIwdGhlJTIwYW5hbHlzaXMlNUQ=",highlighted:`<span class="hljs-symbol">User:</span> Read the file <span class="hljs-string">&quot;feedback.txt&quot;</span> <span class="hljs-keyword">from</span> my Desktop <span class="hljs-built_in">and</span> analyze its sentiment

<span class="hljs-symbol">Agent:</span> I<span class="hljs-comment">&#x27;ll help you analyze the sentiment of the feedback file. Let me break this down into steps:</span>

<span class="hljs-number">1</span>. First, I<span class="hljs-comment">&#x27;ll read the file using the filesystem tool</span>
<span class="hljs-number">2</span>. <span class="hljs-keyword">Then</span>, I<span class="hljs-comment">&#x27;ll analyze its sentiment using the sentiment analysis tool</span>
<span class="hljs-number">3</span>. <span class="hljs-keyword">Finally</span>, I<span class="hljs-comment">&#x27;ll write the results to a new file</span>

[Agent proceeds <span class="hljs-keyword">to</span> use the tools <span class="hljs-built_in">and</span> provide the analysis]`,wrap:!1}}),al=new U({props:{title:"Deployment Considerations",local:"deployment-considerations",headingTag:"h3"}}),ol=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzQSUyMCUyMm5weCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtY3AtcmVtb3RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZZT1VSX1VTRVJOQU1FLW1jcC1zZW50aW1lbnQuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`{
    <span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
    <span class="hljs-attr">args</span>: [
        <span class="hljs-string">&quot;mcp-remote&quot;</span>,
        <span class="hljs-string">&quot;https://YOUR_USERNAME-mcp-sentiment.hf.space/gradio_api/mcp/sse&quot;</span>
    ]
}`,wrap:!1}}),rl=new vn({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/tiny-agents.mdx"}}),{c(){r=p("meta"),J=n(),w=p("p"),d=n(),c(B.$$.fragment),Ml=n(),I=p("p"),I.innerHTML=te,hl=n(),k=p("p"),k.textContent=ee,yl=n(),Q=p("p"),Q.innerHTML=ne,ul=n(),N=p("figcaption"),N.textContent=ae,Tl=n(),S=p("p"),S.textContent=pe,wl=n(),c(E.$$.fragment),ml=n(),G=p("p"),G.innerHTML=oe,Jl=n(),c(x.$$.fragment),Ul=n(),$=p("p"),$.innerHTML=ie,dl=n(),c(Z.$$.fragment),jl=n(),A=p("p"),A.textContent=re,fl=n(),W=p("p"),W.textContent=ce,Cl=n(),j=p("video"),j.innerHTML=Me,bl=n(),H=p("p"),H.textContent=he,vl=n(),V=p("ul"),V.innerHTML=ye,gl=n(),R=p("p"),R.textContent=ue,Bl=n(),_=p("blockquote"),_.innerHTML=Te,Il=n(),z=p("p"),z.textContent=we,kl=n(),L=p("blockquote"),L.innerHTML=me,Ql=n(),X=p("p"),X.textContent=Je,Nl=n(),D=p("blockquote"),D.innerHTML=Ue,Sl=n(),f=p("video"),f.innerHTML=de,El=n(),Y=p("p"),Y.textContent=je,Gl=n(),O=p("blockquote"),O.innerHTML=fe,xl=n(),c(q.$$.fragment),$l=n(),P=p("p"),P.textContent=Ce,Zl=n(),F=p("ul"),F.innerHTML=be,Al=n(),K=p("p"),K.textContent=ve,Wl=n(),c(ss.$$.fragment),Hl=n(),c(b.$$.fragment),Vl=n(),c(ls.$$.fragment),Rl=n(),ts=p("p"),ts.textContent=ge,_l=n(),es=p("p"),es.textContent=Be,zl=n(),c(ns.$$.fragment),Ll=n(),as=p("p"),as.innerHTML=Ie,Xl=n(),ps=p("p"),ps.innerHTML=ke,Dl=n(),os=p("p"),os.textContent=Qe,Yl=n(),is=p("blockquote"),is.innerHTML=Ne,Ol=n(),c(rs.$$.fragment),ql=n(),cs=p("p"),cs.textContent=Se,Pl=n(),Ms=p("p"),Ms.innerHTML=Ee,Fl=n(),hs=p("p"),hs.innerHTML=Ge,Kl=n(),c(v.$$.fragment),st=n(),ys=p("p"),ys.innerHTML=xe,lt=n(),us=p("ul"),us.innerHTML=$e,tt=n(),c(Ts.$$.fragment),et=n(),ws=p("p"),ws.innerHTML=Ze,nt=n(),c(ms.$$.fragment),at=n(),Js=p("p"),Js.innerHTML=Ae,pt=n(),Us=p("p"),Us.innerHTML=We,ot=n(),c(ds.$$.fragment),it=n(),js=p("p"),js.innerHTML=He,rt=n(),c(fs.$$.fragment),ct=n(),Cs=p("p"),Cs.innerHTML=Ve,Mt=n(),bs=p("p"),bs.innerHTML=Re,ht=n(),c(vs.$$.fragment),yt=n(),gs=p("p"),gs.textContent=_e,ut=n(),Bs=p("p"),Bs.innerHTML=ze,Tt=n(),c(Is.$$.fragment),wt=n(),ks=p("p"),ks.textContent=Le,mt=n(),Qs=p("blockquote"),Qs.innerHTML=Xe,Jt=n(),Ns=p("p"),Ns.textContent=De,Ut=n(),Ss=p("ul"),Ss.innerHTML=Ye,dt=n(),c(g.$$.fragment),jt=n(),Es=p("p"),Es.textContent=Oe,ft=n(),c(Gs.$$.fragment),Ct=n(),xs=p("p"),xs.innerHTML=qe,bt=n(),$s=p("p"),$s.textContent=Pe,vt=n(),Zs=p("blockquote"),Zs.innerHTML=Fe,gt=n(),As=p("p"),As.innerHTML=Ke,Bt=n(),Ws=p("p"),Ws.textContent=sn,It=n(),c(Hs.$$.fragment),kt=n(),Vs=p("p"),Vs.textContent=ln,Qt=n(),c(Rs.$$.fragment),Nt=n(),_s=p("p"),_s.textContent=tn,St=n(),c(zs.$$.fragment),Et=n(),Ls=p("p"),Ls.textContent=en,Gt=n(),Xs=p("p"),Xs.innerHTML=nn,xt=n(),Ds=p("p"),Ds.textContent=an,$t=n(),c(Ys.$$.fragment),Zt=n(),c(Os.$$.fragment),At=n(),qs=p("p"),qs.textContent=pn,Wt=n(),c(Ps.$$.fragment),Ht=n(),Fs=p("p"),Fs.textContent=on,Vt=n(),c(Ks.$$.fragment),Rt=n(),sl=p("p"),sl.textContent=rn,_t=n(),ll=p("ol"),ll.innerHTML=cn,zt=n(),c(tl.$$.fragment),Lt=n(),el=p("p"),el.textContent=Mn,Xt=n(),c(nl.$$.fragment),Dt=n(),c(al.$$.fragment),Yt=n(),pl=p("p"),pl.textContent=hn,Ot=n(),c(ol.$$.fragment),qt=n(),il=p("p"),il.textContent=yn,Pt=n(),c(rl.$$.fragment),Ft=n(),cl=p("p"),this.h()},l(s){const l=Cn("svelte-u9bgzb",document.head);r=o(l,"META",{name:!0,content:!0}),l.forEach(t),J=a(s),w=o(s,"P",{}),mn(w).forEach(t),d=a(s),M(B.$$.fragment,s),Ml=a(s),I=o(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1vs4rfu"&&(I.innerHTML=te),hl=a(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-12c504t"&&(k.textContent=ee),yl=a(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1c6ln2u"&&(Q.innerHTML=ne),ul=a(s),N=o(s,"FIGCAPTION",{"data-svelte-h":!0}),i(N)!=="svelte-1m426zi"&&(N.textContent=ae),Tl=a(s),S=o(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-c850ra"&&(S.textContent=pe),wl=a(s),M(E.$$.fragment,s),ml=a(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-5tmxzm"&&(G.innerHTML=oe),Jl=a(s),M(x.$$.fragment,s),Ul=a(s),$=o(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-18cqmtc"&&($.innerHTML=ie),dl=a(s),M(Z.$$.fragment,s),jl=a(s),A=o(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1rl2uch"&&(A.textContent=re),fl=a(s),W=o(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-6nrufp"&&(W.textContent=ce),Cl=a(s),j=o(s,"VIDEO",{"data-svelte-h":!0}),i(j)!=="svelte-ydpjhx"&&(j.innerHTML=Me),bl=a(s),H=o(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-ue9bgn"&&(H.textContent=he),vl=a(s),V=o(s,"UL",{"data-svelte-h":!0}),i(V)!=="svelte-1rloo86"&&(V.innerHTML=ye),gl=a(s),R=o(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-dkho5a"&&(R.textContent=ue),Bl=a(s),_=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(_)!=="svelte-1hqv6uo"&&(_.innerHTML=Te),Il=a(s),z=o(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-23qcc7"&&(z.textContent=we),kl=a(s),L=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(L)!=="svelte-1k51xcu"&&(L.innerHTML=me),Ql=a(s),X=o(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-k51lqc"&&(X.textContent=Je),Nl=a(s),D=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(D)!=="svelte-1b7qxev"&&(D.innerHTML=Ue),Sl=a(s),f=o(s,"VIDEO",{"data-svelte-h":!0}),i(f)!=="svelte-1qpwra9"&&(f.innerHTML=de),El=a(s),Y=o(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1w424gc"&&(Y.textContent=je),Gl=a(s),O=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(O)!=="svelte-1l7y4cp"&&(O.innerHTML=fe),xl=a(s),M(q.$$.fragment,s),$l=a(s),P=o(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1wjumg1"&&(P.textContent=Ce),Zl=a(s),F=o(s,"UL",{"data-svelte-h":!0}),i(F)!=="svelte-1x6yagl"&&(F.innerHTML=be),Al=a(s),K=o(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1rpsaaq"&&(K.textContent=ve),Wl=a(s),M(ss.$$.fragment,s),Hl=a(s),M(b.$$.fragment,s),Vl=a(s),M(ls.$$.fragment,s),Rl=a(s),ts=o(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-8wa0qx"&&(ts.textContent=ge),_l=a(s),es=o(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-os6o10"&&(es.textContent=Be),zl=a(s),M(ns.$$.fragment,s),Ll=a(s),as=o(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-d90icq"&&(as.innerHTML=Ie),Xl=a(s),ps=o(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-3ck7hs"&&(ps.innerHTML=ke),Dl=a(s),os=o(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1lp84k"&&(os.textContent=Qe),Yl=a(s),is=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(is)!=="svelte-1hh6wqm"&&(is.innerHTML=Ne),Ol=a(s),M(rs.$$.fragment,s),ql=a(s),cs=o(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-19qb6of"&&(cs.textContent=Se),Pl=a(s),Ms=o(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-q9m201"&&(Ms.innerHTML=Ee),Fl=a(s),hs=o(s,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-1v369pk"&&(hs.innerHTML=Ge),Kl=a(s),M(v.$$.fragment,s),st=a(s),ys=o(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-18fho66"&&(ys.innerHTML=xe),lt=a(s),us=o(s,"UL",{"data-svelte-h":!0}),i(us)!=="svelte-1rde96s"&&(us.innerHTML=$e),tt=a(s),M(Ts.$$.fragment,s),et=a(s),ws=o(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-18sfj9x"&&(ws.innerHTML=Ze),nt=a(s),M(ms.$$.fragment,s),at=a(s),Js=o(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-3162lo"&&(Js.innerHTML=Ae),pt=a(s),Us=o(s,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-1oiqjdz"&&(Us.innerHTML=We),ot=a(s),M(ds.$$.fragment,s),it=a(s),js=o(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-18597vy"&&(js.innerHTML=He),rt=a(s),M(fs.$$.fragment,s),ct=a(s),Cs=o(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-1xix0ot"&&(Cs.innerHTML=Ve),Mt=a(s),bs=o(s,"P",{"data-svelte-h":!0}),i(bs)!=="svelte-u42pzw"&&(bs.innerHTML=Re),ht=a(s),M(vs.$$.fragment,s),yt=a(s),gs=o(s,"P",{"data-svelte-h":!0}),i(gs)!=="svelte-lk1323"&&(gs.textContent=_e),ut=a(s),Bs=o(s,"P",{"data-svelte-h":!0}),i(Bs)!=="svelte-194evwg"&&(Bs.innerHTML=ze),Tt=a(s),M(Is.$$.fragment,s),wt=a(s),ks=o(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-yri4ab"&&(ks.textContent=Le),mt=a(s),Qs=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Qs)!=="svelte-16vx3n0"&&(Qs.innerHTML=Xe),Jt=a(s),Ns=o(s,"P",{"data-svelte-h":!0}),i(Ns)!=="svelte-1n2s2to"&&(Ns.textContent=De),Ut=a(s),Ss=o(s,"UL",{"data-svelte-h":!0}),i(Ss)!=="svelte-384er2"&&(Ss.innerHTML=Ye),dt=a(s),M(g.$$.fragment,s),jt=a(s),Es=o(s,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-1sf2rot"&&(Es.textContent=Oe),ft=a(s),M(Gs.$$.fragment,s),Ct=a(s),xs=o(s,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-13kag1j"&&(xs.innerHTML=qe),bt=a(s),$s=o(s,"P",{"data-svelte-h":!0}),i($s)!=="svelte-d6h472"&&($s.textContent=Pe),vt=a(s),Zs=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Zs)!=="svelte-1rrcz4w"&&(Zs.innerHTML=Fe),gt=a(s),As=o(s,"P",{"data-svelte-h":!0}),i(As)!=="svelte-xsbh75"&&(As.innerHTML=Ke),Bt=a(s),Ws=o(s,"P",{"data-svelte-h":!0}),i(Ws)!=="svelte-10s8lyx"&&(Ws.textContent=sn),It=a(s),M(Hs.$$.fragment,s),kt=a(s),Vs=o(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-og177e"&&(Vs.textContent=ln),Qt=a(s),M(Rs.$$.fragment,s),Nt=a(s),_s=o(s,"P",{"data-svelte-h":!0}),i(_s)!=="svelte-1hidx2u"&&(_s.textContent=tn),St=a(s),M(zs.$$.fragment,s),Et=a(s),Ls=o(s,"P",{"data-svelte-h":!0}),i(Ls)!=="svelte-1x1f68r"&&(Ls.textContent=en),Gt=a(s),Xs=o(s,"P",{"data-svelte-h":!0}),i(Xs)!=="svelte-18vkmid"&&(Xs.innerHTML=nn),xt=a(s),Ds=o(s,"P",{"data-svelte-h":!0}),i(Ds)!=="svelte-51qcy5"&&(Ds.textContent=an),$t=a(s),M(Ys.$$.fragment,s),Zt=a(s),M(Os.$$.fragment,s),At=a(s),qs=o(s,"P",{"data-svelte-h":!0}),i(qs)!=="svelte-vdesl"&&(qs.textContent=pn),Wt=a(s),M(Ps.$$.fragment,s),Ht=a(s),Fs=o(s,"P",{"data-svelte-h":!0}),i(Fs)!=="svelte-snkwau"&&(Fs.textContent=on),Vt=a(s),M(Ks.$$.fragment,s),Rt=a(s),sl=o(s,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1yuwy1b"&&(sl.textContent=rn),_t=a(s),ll=o(s,"OL",{"data-svelte-h":!0}),i(ll)!=="svelte-1bb9kd9"&&(ll.innerHTML=cn),zt=a(s),M(tl.$$.fragment,s),Lt=a(s),el=o(s,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1qm1dau"&&(el.textContent=Mn),Xt=a(s),M(nl.$$.fragment,s),Dt=a(s),M(al.$$.fragment,s),Yt=a(s),pl=o(s,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1s79p96"&&(pl.textContent=hn),Ot=a(s),M(ol.$$.fragment,s),qt=a(s),il=o(s,"P",{"data-svelte-h":!0}),i(il)!=="svelte-7f5u21"&&(il.textContent=yn),Pt=a(s),M(rl.$$.fragment,s),Ft=a(s),cl=o(s,"P",{}),mn(cl).forEach(t),this.h()},h(){Jn(r,"name","hf:doc:metadata"),Jn(r,"content",Qn),j.controls="",j.autoplay="",j.loop="",f.controls="",f.autoplay="",f.loop=""},m(s,l){bn(document.head,r),e(s,J,l),e(s,w,l),e(s,d,l),h(B,s,l),e(s,Ml,l),e(s,I,l),e(s,hl,l),e(s,k,l),e(s,yl,l),e(s,Q,l),e(s,ul,l),e(s,N,l),e(s,Tl,l),e(s,S,l),e(s,wl,l),h(E,s,l),e(s,ml,l),e(s,G,l),e(s,Jl,l),h(x,s,l),e(s,Ul,l),e(s,$,l),e(s,dl,l),h(Z,s,l),e(s,jl,l),e(s,A,l),e(s,fl,l),e(s,W,l),e(s,Cl,l),e(s,j,l),e(s,bl,l),e(s,H,l),e(s,vl,l),e(s,V,l),e(s,gl,l),e(s,R,l),e(s,Bl,l),e(s,_,l),e(s,Il,l),e(s,z,l),e(s,kl,l),e(s,L,l),e(s,Ql,l),e(s,X,l),e(s,Nl,l),e(s,D,l),e(s,Sl,l),e(s,f,l),e(s,El,l),e(s,Y,l),e(s,Gl,l),e(s,O,l),e(s,xl,l),h(q,s,l),e(s,$l,l),e(s,P,l),e(s,Zl,l),e(s,F,l),e(s,Al,l),e(s,K,l),e(s,Wl,l),h(ss,s,l),e(s,Hl,l),h(b,s,l),e(s,Vl,l),h(ls,s,l),e(s,Rl,l),e(s,ts,l),e(s,_l,l),e(s,es,l),e(s,zl,l),h(ns,s,l),e(s,Ll,l),e(s,as,l),e(s,Xl,l),e(s,ps,l),e(s,Dl,l),e(s,os,l),e(s,Yl,l),e(s,is,l),e(s,Ol,l),h(rs,s,l),e(s,ql,l),e(s,cs,l),e(s,Pl,l),e(s,Ms,l),e(s,Fl,l),e(s,hs,l),e(s,Kl,l),h(v,s,l),e(s,st,l),e(s,ys,l),e(s,lt,l),e(s,us,l),e(s,tt,l),h(Ts,s,l),e(s,et,l),e(s,ws,l),e(s,nt,l),h(ms,s,l),e(s,at,l),e(s,Js,l),e(s,pt,l),e(s,Us,l),e(s,ot,l),h(ds,s,l),e(s,it,l),e(s,js,l),e(s,rt,l),h(fs,s,l),e(s,ct,l),e(s,Cs,l),e(s,Mt,l),e(s,bs,l),e(s,ht,l),h(vs,s,l),e(s,yt,l),e(s,gs,l),e(s,ut,l),e(s,Bs,l),e(s,Tt,l),h(Is,s,l),e(s,wt,l),e(s,ks,l),e(s,mt,l),e(s,Qs,l),e(s,Jt,l),e(s,Ns,l),e(s,Ut,l),e(s,Ss,l),e(s,dt,l),h(g,s,l),e(s,jt,l),e(s,Es,l),e(s,ft,l),h(Gs,s,l),e(s,Ct,l),e(s,xs,l),e(s,bt,l),e(s,$s,l),e(s,vt,l),e(s,Zs,l),e(s,gt,l),e(s,As,l),e(s,Bt,l),e(s,Ws,l),e(s,It,l),h(Hs,s,l),e(s,kt,l),e(s,Vs,l),e(s,Qt,l),h(Rs,s,l),e(s,Nt,l),e(s,_s,l),e(s,St,l),h(zs,s,l),e(s,Et,l),e(s,Ls,l),e(s,Gt,l),e(s,Xs,l),e(s,xt,l),e(s,Ds,l),e(s,$t,l),h(Ys,s,l),e(s,Zt,l),h(Os,s,l),e(s,At,l),e(s,qs,l),e(s,Wt,l),h(Ps,s,l),e(s,Ht,l),e(s,Fs,l),e(s,Vt,l),h(Ks,s,l),e(s,Rt,l),e(s,sl,l),e(s,_t,l),e(s,ll,l),e(s,zt,l),h(tl,s,l),e(s,Lt,l),e(s,el,l),e(s,Xt,l),h(nl,s,l),e(s,Dt,l),h(al,s,l),e(s,Yt,l),e(s,pl,l),e(s,Ot,l),h(ol,s,l),e(s,qt,l),e(s,il,l),e(s,Pt,l),h(rl,s,l),e(s,Ft,l),e(s,cl,l),Kt=!0},p(s,[l]){const un={};l&2&&(un.$$scope={dirty:l,ctx:s}),b.$set(un);const Tn={};l&2&&(Tn.$$scope={dirty:l,ctx:s}),v.$set(Tn);const wn={};l&2&&(wn.$$scope={dirty:l,ctx:s}),g.$set(wn)},i(s){Kt||(y(B.$$.fragment,s),y(E.$$.fragment,s),y(x.$$.fragment,s),y(Z.$$.fragment,s),y(q.$$.fragment,s),y(ss.$$.fragment,s),y(b.$$.fragment,s),y(ls.$$.fragment,s),y(ns.$$.fragment,s),y(rs.$$.fragment,s),y(v.$$.fragment,s),y(Ts.$$.fragment,s),y(ms.$$.fragment,s),y(ds.$$.fragment,s),y(fs.$$.fragment,s),y(vs.$$.fragment,s),y(Is.$$.fragment,s),y(g.$$.fragment,s),y(Gs.$$.fragment,s),y(Hs.$$.fragment,s),y(Rs.$$.fragment,s),y(zs.$$.fragment,s),y(Ys.$$.fragment,s),y(Os.$$.fragment,s),y(Ps.$$.fragment,s),y(Ks.$$.fragment,s),y(tl.$$.fragment,s),y(nl.$$.fragment,s),y(al.$$.fragment,s),y(ol.$$.fragment,s),y(rl.$$.fragment,s),Kt=!0)},o(s){u(B.$$.fragment,s),u(E.$$.fragment,s),u(x.$$.fragment,s),u(Z.$$.fragment,s),u(q.$$.fragment,s),u(ss.$$.fragment,s),u(b.$$.fragment,s),u(ls.$$.fragment,s),u(ns.$$.fragment,s),u(rs.$$.fragment,s),u(v.$$.fragment,s),u(Ts.$$.fragment,s),u(ms.$$.fragment,s),u(ds.$$.fragment,s),u(fs.$$.fragment,s),u(vs.$$.fragment,s),u(Is.$$.fragment,s),u(g.$$.fragment,s),u(Gs.$$.fragment,s),u(Hs.$$.fragment,s),u(Rs.$$.fragment,s),u(zs.$$.fragment,s),u(Ys.$$.fragment,s),u(Os.$$.fragment,s),u(Ps.$$.fragment,s),u(Ks.$$.fragment,s),u(tl.$$.fragment,s),u(nl.$$.fragment,s),u(al.$$.fragment,s),u(ol.$$.fragment,s),u(rl.$$.fragment,s),Kt=!1},d(s){s&&(t(J),t(w),t(d),t(Ml),t(I),t(hl),t(k),t(yl),t(Q),t(ul),t(N),t(Tl),t(S),t(wl),t(ml),t(G),t(Jl),t(Ul),t($),t(dl),t(jl),t(A),t(fl),t(W),t(Cl),t(j),t(bl),t(H),t(vl),t(V),t(gl),t(R),t(Bl),t(_),t(Il),t(z),t(kl),t(L),t(Ql),t(X),t(Nl),t(D),t(Sl),t(f),t(El),t(Y),t(Gl),t(O),t(xl),t($l),t(P),t(Zl),t(F),t(Al),t(K),t(Wl),t(Hl),t(Vl),t(Rl),t(ts),t(_l),t(es),t(zl),t(Ll),t(as),t(Xl),t(ps),t(Dl),t(os),t(Yl),t(is),t(Ol),t(ql),t(cs),t(Pl),t(Ms),t(Fl),t(hs),t(Kl),t(st),t(ys),t(lt),t(us),t(tt),t(et),t(ws),t(nt),t(at),t(Js),t(pt),t(Us),t(ot),t(it),t(js),t(rt),t(ct),t(Cs),t(Mt),t(bs),t(ht),t(yt),t(gs),t(ut),t(Bs),t(Tt),t(wt),t(ks),t(mt),t(Qs),t(Jt),t(Ns),t(Ut),t(Ss),t(dt),t(jt),t(Es),t(ft),t(Ct),t(xs),t(bt),t($s),t(vt),t(Zs),t(gt),t(As),t(Bt),t(Ws),t(It),t(kt),t(Vs),t(Qt),t(Nt),t(_s),t(St),t(Et),t(Ls),t(Gt),t(Xs),t(xt),t(Ds),t($t),t(Zt),t(At),t(qs),t(Wt),t(Ht),t(Fs),t(Vt),t(Rt),t(sl),t(_t),t(ll),t(zt),t(Lt),t(el),t(Xt),t(Dt),t(Yt),t(pl),t(Ot),t(qt),t(il),t(Pt),t(Ft),t(cl)),t(r),T(B,s),T(E,s),T(x,s),T(Z,s),T(q,s),T(ss,s),T(b,s),T(ls,s),T(ns,s),T(rs,s),T(v,s),T(Ts,s),T(ms,s),T(ds,s),T(fs,s),T(vs,s),T(Is,s),T(g,s),T(Gs,s),T(Hs,s),T(Rs,s),T(zs,s),T(Ys,s),T(Os,s),T(Ps,s),T(Ks,s),T(tl,s),T(nl,s),T(al,s),T(ol,s),T(rl,s)}}}const Qn='{"title":"Tiny Agents: an MCP-powered agent in 50 lines of code","local":"tiny-agents-an-mcp-powered-agent-in-50-lines-of-code","sections":[{"title":"How to run the complete demo","local":"how-to-run-the-complete-demo","sections":[{"title":"Default model and provider","local":"default-model-and-provider","sections":[],"depth":3}],"depth":2},{"title":"The foundation for this: tool calling native support in LLMs.","local":"the-foundation-for-this-tool-calling-native-support-in-llms","sections":[],"depth":2},{"title":"Implementing an MCP client on top of InferenceClient","local":"implementing-an-mcp-client-on-top-of-inferenceclient","sections":[{"title":"How to use the tools","local":"how-to-use-the-tools","sections":[],"depth":3}],"depth":2},{"title":"Our 50-lines-of-code Agent 🤯","local":"our-50-lines-of-code-agent-","sections":[{"title":"The complete while loop","local":"the-complete-while-loop","sections":[],"depth":3}],"depth":2},{"title":"Connecting Tiny Agents with Gradio MCP Servers","local":"connecting-tiny-agents-with-gradio-mcp-servers","sections":[{"title":"Using the Gradio Server with Tiny Agents","local":"using-the-gradio-server-with-tiny-agents","sections":[],"depth":3},{"title":"Example Interaction","local":"example-interaction","sections":[],"depth":3},{"title":"Deployment Considerations","local":"deployment-considerations","sections":[],"depth":3}],"depth":2}],"depth":1}';function Nn(C){return dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends jn{constructor(r){super(),fn(this,r,Nn,kn,Un,{})}}export{Zn as component};
