import{s as es,n as ts,o as ns}from"../chunks/scheduler.65852ee5.js";import{S as as,i as Ms,g as M,s as n,r as o,A as ps,h as p,f as e,c as a,j as ls,u as c,x as y,k as ss,y as ys,a as t,v as J,d as i,t as T,w}from"../chunks/index.aa74147d.js";import{D as os,C as q}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as D,E as cs}from"../chunks/EditOnGithub.4eda6a96.js";function Js(kl){let U,O,P,ll,r,sl,j,el,m,Wl='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',tl,I,zl='<p>This tutorial builds upon agent knowledge: to know more about agents, you can start with <a href="agents">this introductory notebook</a></p>',nl,C,vl='<a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">Transformers Agents</a> is a library to build agents, using an LLM to power it in the <code>llm_engine</code> argument. This argument was designed to leave the user maximal freedom to choose any LLM.',al,u,Xl="Let’s see how to build this <code>llm_engine</code> from the APIs of a few leading providers.",Ml,d,pl,h,Ql="Transformers agents provides a built-in <code>HfEngine</code> class that lets you use any model on the Hub via the Serverless API or your own dedicated Endpoint. This is the preferred way to use HF agents.",yl,b,ol,f,cl,g,Jl,A,Sl=`['unicodedata', 're', 'math', 'collections', 'queue', 'itertools', 'random', 'time', 'stat', 'statistics']
`,il,Z,Rl="The <code>llm_engine</code> initialization arg of the agent could be a simple callable such as:",Tl,_,wl,B,$l="This callable is the heart of the llm engine. It should respect these requirements:",Ul,N,Yl='<li>takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat template</a> format and outputs a <code>str</code>.</li> <li>accepts a <code>stop_sequences</code> argument where the agent system will pass it sequences where it should stop generation.</li>',rl,V,Hl="Let’s take a closer look at the code for the <code>HfEngine</code> that we used:",jl,G,ml,E,xl="Here the engine is not a function, but a class with a <code>__call__</code> method, which adds the possibility to store attributes such as the client.",Il,k,Ll=`We also use <code>get_clean_message_list()</code> utility to concatenate successive messages to the same role
This method takes a <code>role_conversions</code> arg to convert the range of roles supported in Transformers Agents to only the ones accepted by your LLM.`,Cl,W,Fl="This recipe can be adapted for any LLM! Let’s look at other examples.",ul,z,dl,v,ql=`Using the above recipe, you can use any LLM inference source as your <code>llm_engine</code>.
Just keep in mind the two main constraints:`,hl,X,Dl='<li><code>llm_engine</code> is a callable that takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat template</a> format and outputs a <code>str</code>.</li> <li>It accepts a <code>stop_sequences</code> argument.</li>',bl,Q,fl,S,gl,R,Al,$,Zl,Y,_l,H,Pl="Go on and implement your <code>llm_engine</code> for <code>transformers.agents</code> with your own LLM inference provider!",Bl,x,Kl="Then to use this shiny new <code>llm_engine</code>, check out these use cases:",Nl,L,Ol='<li><a href="agent_rag">Agentic RAG: turbocharge your RAG with query reformulation and self-query</a></li> <li><a href="agent_text_to_sql">Agent for text-to-SQL with automatic error correction</a></li>',Vl,F,Gl,K,El;return r=new os({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_change_llm.ipynb"}]}}),j=new D({props:{title:"Create a Transformers Agent from any LLM inference provider",local:"create-a-transformers-agent-from-any-llm-inference-provider",headingTag:"h1"}}),d=new D({props:{title:"HuggingFace Serverless API and Dedicated Endpoints",local:"huggingface-serverless-api-and-dedicated-endpoints",headingTag:"h2"}}),b=new q({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcGVuYWklMjBhbnRocm9waWMlMjAlMjJ0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjIlMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:'!pip install openai anthropic <span class="hljs-string">&quot;transformers[agents]&quot;</span> --upgrade -q',wrap:!1}}),f=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),g=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkFwaUVuZ2luZSUyQyUyMFJlYWN0Q29kZUFnZW50JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiUwQWVuZHBvaW50X3VybCUyMCUzRCUyMCUyMnlvdXJfZW5kcG9pbnRfdXJsJTIyJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKG1vZGVsJTNEcmVwb19pZCklMjAlMjAlMjMlMjB5b3UlMjBjb3VsZCUyMHVzZSUyMG1vZGVsJTNEZW5kcG9pbnRfdXJsJTIwaGVyZSUwQSUwQWFnZW50JTIwJTNEJTIwUmVhY3RDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSklMEElMEFhZ2VudC5ydW4oJTIyV2hhdCdzJTIwdGhlJTIwMTB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfApiEngine, ReactCodeAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_url = <span class="hljs-string">&quot;your_endpoint_url&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfApiEngine(model=repo_id)  <span class="hljs-comment"># you could use model=endpoint_url here</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(tools=[], llm_engine=llm_engine)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;What&#x27;s the 10th Fibonacci number?&quot;</span>)`,wrap:!1}}),_=new q({props:{code:"ZGVmJTIwbGxtX2VuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZShtZXNzYWdlcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">llm_engine</span>(<span class="hljs-params">messages, stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> response(messages)`,wrap:!1}}),G=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

llama_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">HfApiEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span></span>):
        self.model = model
        self.client = InferenceClient(model=self.model, timeout=<span class="hljs-number">120</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]], stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=llama_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1500</span>)
        response = response.choices[<span class="hljs-number">0</span>].message.content

        <span class="hljs-comment"># Remove stop sequences from LLM output</span>
        <span class="hljs-keyword">for</span> stop_seq <span class="hljs-keyword">in</span> stop_sequences:
            <span class="hljs-keyword">if</span> response[-<span class="hljs-built_in">len</span>(stop_seq) :] == stop_seq:
                response = response[: -<span class="hljs-built_in">len</span>(stop_seq)]
        <span class="hljs-keyword">return</span> response`,wrap:!1}}),z=new D({props:{title:"Adapting the recipe for any LLM",local:"adapting-the-recipe-for-any-llm",headingTag:"h2"}}),Q=new D({props:{title:"OpenAI",local:"openai",headingTag:"h3"}}),S=new q({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX3JvbGVfY29udmVyc2lvbnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBNZXNzYWdlUm9sZS5UT09MX1JFU1BPTlNFJTNBJTIwTWVzc2FnZVJvbGUuVVNFUiUyQyUwQSU3RCUwQSUwQSUwQWNsYXNzJTIwT3BlbkFJRW5naW5lJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1vZGVsX25hbWUlM0QlMjJncHQtNG8lMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9uYW1lJTIwJTNEJTIwbW9kZWxfbmFtZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyT1BFTkFJX0FQSV9LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwZ2V0X2NsZWFuX21lc3NhZ2VfbGlzdChtZXNzYWdlcyUyQyUyMHJvbGVfY29udmVyc2lvbnMlM0RvcGVuYWlfcm9sZV9jb252ZXJzaW9ucyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHNlbGYuY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEc2VsZi5tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0RtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0b3AlM0RzdG9wX3NlcXVlbmNlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmNob2ljZXMlNUIwJTVELm1lc3NhZ2UuY29udGVudA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content`,wrap:!1}}),R=new D({props:{title:"Anthropic",local:"anthropic",headingTag:"h3"}}),$=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> anthropic <span class="hljs-keyword">import</span> Anthropic, AnthropicBedrock


<span class="hljs-comment"># Cf this page for using Anthropic from Bedrock: https://docs.anthropic.com/en/api/claude-on-amazon-bedrock</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AnthropicEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;claude-3-5-sonnet-20240620&quot;</span>, use_bedrock=<span class="hljs-literal">False</span></span>):
        self.model_name = model_name
        <span class="hljs-keyword">if</span> use_bedrock:
            self.model_name = <span class="hljs-string">&quot;anthropic.claude-3-5-sonnet-20240620-v1:0&quot;</span>
            self.client = AnthropicBedrock(
                aws_access_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_ID&quot;</span>),
                aws_secret_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_KEY&quot;</span>),
                aws_region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
            )
        <span class="hljs-keyword">else</span>:
            self.client = Anthropic(
                api_key=os.getenv(<span class="hljs-string">&quot;ANTHROPIC_API_KEY&quot;</span>),
            )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)
        index_system_message, system_prompt = <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>
        <span class="hljs-keyword">for</span> index, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
            <span class="hljs-keyword">if</span> message[<span class="hljs-string">&quot;role&quot;</span>] == MessageRole.SYSTEM:
                index_system_message = index
                system_prompt = message[<span class="hljs-string">&quot;content&quot;</span>]
        <span class="hljs-keyword">if</span> system_prompt <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">&quot;No system prompt found!&quot;</span>)

        filtered_messages = [message <span class="hljs-keyword">for</span> i, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages) <span class="hljs-keyword">if</span> i != index_system_message]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(filtered_messages) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Error, no user message:&quot;</span>, messages)
            <span class="hljs-keyword">assert</span> <span class="hljs-literal">False</span>

        response = self.client.messages.create(
            model=self.model_name,
            system=system_prompt,
            messages=filtered_messages,
            stop_sequences=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
            max_tokens=<span class="hljs-number">2000</span>,
        )
        full_response_text = <span class="hljs-string">&quot;&quot;</span>
        <span class="hljs-keyword">for</span> content_block <span class="hljs-keyword">in</span> response.content:
            <span class="hljs-keyword">if</span> content_block.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;text&quot;</span>:
                full_response_text += content_block.text
        <span class="hljs-keyword">return</span> full_response_text`,wrap:!1}}),Y=new D({props:{title:"Next steps",local:"next-steps",headingTag:"h3"}}),F=new cs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_change_llm.md"}}),{c(){U=M("meta"),O=n(),P=M("p"),ll=n(),o(r.$$.fragment),sl=n(),o(j.$$.fragment),el=n(),m=M("p"),m.innerHTML=Wl,tl=n(),I=M("blockquote"),I.innerHTML=zl,nl=n(),C=M("p"),C.innerHTML=vl,al=n(),u=M("p"),u.innerHTML=Xl,Ml=n(),o(d.$$.fragment),pl=n(),h=M("p"),h.innerHTML=Ql,yl=n(),o(b.$$.fragment),ol=n(),o(f.$$.fragment),cl=n(),o(g.$$.fragment),Jl=n(),A=M("pre"),A.textContent=Sl,il=n(),Z=M("p"),Z.innerHTML=Rl,Tl=n(),o(_.$$.fragment),wl=n(),B=M("p"),B.textContent=$l,Ul=n(),N=M("ul"),N.innerHTML=Yl,rl=n(),V=M("p"),V.innerHTML=Hl,jl=n(),o(G.$$.fragment),ml=n(),E=M("p"),E.innerHTML=xl,Il=n(),k=M("p"),k.innerHTML=Ll,Cl=n(),W=M("p"),W.textContent=Fl,ul=n(),o(z.$$.fragment),dl=n(),v=M("p"),v.innerHTML=ql,hl=n(),X=M("ul"),X.innerHTML=Dl,bl=n(),o(Q.$$.fragment),fl=n(),o(S.$$.fragment),gl=n(),o(R.$$.fragment),Al=n(),o($.$$.fragment),Zl=n(),o(Y.$$.fragment),_l=n(),H=M("p"),H.innerHTML=Pl,Bl=n(),x=M("p"),x.innerHTML=Kl,Nl=n(),L=M("ul"),L.innerHTML=Ol,Vl=n(),o(F.$$.fragment),Gl=n(),K=M("p"),this.h()},l(l){const s=ps("svelte-u9bgzb",document.head);U=p(s,"META",{name:!0,content:!0}),s.forEach(e),O=a(l),P=p(l,"P",{}),ls(P).forEach(e),ll=a(l),c(r.$$.fragment,l),sl=a(l),c(j.$$.fragment,l),el=a(l),m=p(l,"P",{"data-svelte-h":!0}),y(m)!=="svelte-1xlqnsv"&&(m.innerHTML=Wl),tl=a(l),I=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),y(I)!=="svelte-e9c7ci"&&(I.innerHTML=zl),nl=a(l),C=p(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1ltjt5h"&&(C.innerHTML=vl),al=a(l),u=p(l,"P",{"data-svelte-h":!0}),y(u)!=="svelte-yf816"&&(u.innerHTML=Xl),Ml=a(l),c(d.$$.fragment,l),pl=a(l),h=p(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-mten7z"&&(h.innerHTML=Ql),yl=a(l),c(b.$$.fragment,l),ol=a(l),c(f.$$.fragment,l),cl=a(l),c(g.$$.fragment,l),Jl=a(l),A=p(l,"PRE",{"data-svelte-h":!0}),y(A)!=="svelte-e1jlhm"&&(A.textContent=Sl),il=a(l),Z=p(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-11qe1k7"&&(Z.innerHTML=Rl),Tl=a(l),c(_.$$.fragment,l),wl=a(l),B=p(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-6rr6cb"&&(B.textContent=$l),Ul=a(l),N=p(l,"UL",{"data-svelte-h":!0}),y(N)!=="svelte-1nt75bg"&&(N.innerHTML=Yl),rl=a(l),V=p(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-9ekoxy"&&(V.innerHTML=Hl),jl=a(l),c(G.$$.fragment,l),ml=a(l),E=p(l,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1tebd3j"&&(E.innerHTML=xl),Il=a(l),k=p(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1fzzy0z"&&(k.innerHTML=Ll),Cl=a(l),W=p(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-gyhx71"&&(W.textContent=Fl),ul=a(l),c(z.$$.fragment,l),dl=a(l),v=p(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1uswkmp"&&(v.innerHTML=ql),hl=a(l),X=p(l,"UL",{"data-svelte-h":!0}),y(X)!=="svelte-tdu1zn"&&(X.innerHTML=Dl),bl=a(l),c(Q.$$.fragment,l),fl=a(l),c(S.$$.fragment,l),gl=a(l),c(R.$$.fragment,l),Al=a(l),c($.$$.fragment,l),Zl=a(l),c(Y.$$.fragment,l),_l=a(l),H=p(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1b1f0uu"&&(H.innerHTML=Pl),Bl=a(l),x=p(l,"P",{"data-svelte-h":!0}),y(x)!=="svelte-10vua1y"&&(x.innerHTML=Kl),Nl=a(l),L=p(l,"UL",{"data-svelte-h":!0}),y(L)!=="svelte-1s2n21i"&&(L.innerHTML=Ol),Vl=a(l),c(F.$$.fragment,l),Gl=a(l),K=p(l,"P",{}),ls(K).forEach(e),this.h()},h(){ss(U,"name","hf:doc:metadata"),ss(U,"content",is)},m(l,s){ys(document.head,U),t(l,O,s),t(l,P,s),t(l,ll,s),J(r,l,s),t(l,sl,s),J(j,l,s),t(l,el,s),t(l,m,s),t(l,tl,s),t(l,I,s),t(l,nl,s),t(l,C,s),t(l,al,s),t(l,u,s),t(l,Ml,s),J(d,l,s),t(l,pl,s),t(l,h,s),t(l,yl,s),J(b,l,s),t(l,ol,s),J(f,l,s),t(l,cl,s),J(g,l,s),t(l,Jl,s),t(l,A,s),t(l,il,s),t(l,Z,s),t(l,Tl,s),J(_,l,s),t(l,wl,s),t(l,B,s),t(l,Ul,s),t(l,N,s),t(l,rl,s),t(l,V,s),t(l,jl,s),J(G,l,s),t(l,ml,s),t(l,E,s),t(l,Il,s),t(l,k,s),t(l,Cl,s),t(l,W,s),t(l,ul,s),J(z,l,s),t(l,dl,s),t(l,v,s),t(l,hl,s),t(l,X,s),t(l,bl,s),J(Q,l,s),t(l,fl,s),J(S,l,s),t(l,gl,s),J(R,l,s),t(l,Al,s),J($,l,s),t(l,Zl,s),J(Y,l,s),t(l,_l,s),t(l,H,s),t(l,Bl,s),t(l,x,s),t(l,Nl,s),t(l,L,s),t(l,Vl,s),J(F,l,s),t(l,Gl,s),t(l,K,s),El=!0},p:ts,i(l){El||(i(r.$$.fragment,l),i(j.$$.fragment,l),i(d.$$.fragment,l),i(b.$$.fragment,l),i(f.$$.fragment,l),i(g.$$.fragment,l),i(_.$$.fragment,l),i(G.$$.fragment,l),i(z.$$.fragment,l),i(Q.$$.fragment,l),i(S.$$.fragment,l),i(R.$$.fragment,l),i($.$$.fragment,l),i(Y.$$.fragment,l),i(F.$$.fragment,l),El=!0)},o(l){T(r.$$.fragment,l),T(j.$$.fragment,l),T(d.$$.fragment,l),T(b.$$.fragment,l),T(f.$$.fragment,l),T(g.$$.fragment,l),T(_.$$.fragment,l),T(G.$$.fragment,l),T(z.$$.fragment,l),T(Q.$$.fragment,l),T(S.$$.fragment,l),T(R.$$.fragment,l),T($.$$.fragment,l),T(Y.$$.fragment,l),T(F.$$.fragment,l),El=!1},d(l){l&&(e(O),e(P),e(ll),e(sl),e(el),e(m),e(tl),e(I),e(nl),e(C),e(al),e(u),e(Ml),e(pl),e(h),e(yl),e(ol),e(cl),e(Jl),e(A),e(il),e(Z),e(Tl),e(wl),e(B),e(Ul),e(N),e(rl),e(V),e(jl),e(ml),e(E),e(Il),e(k),e(Cl),e(W),e(ul),e(dl),e(v),e(hl),e(X),e(bl),e(fl),e(gl),e(Al),e(Zl),e(_l),e(H),e(Bl),e(x),e(Nl),e(L),e(Vl),e(Gl),e(K)),e(U),w(r,l),w(j,l),w(d,l),w(b,l),w(f,l),w(g,l),w(_,l),w(G,l),w(z,l),w(Q,l),w(S,l),w(R,l),w($,l),w(Y,l),w(F,l)}}}const is='{"title":"Create a Transformers Agent from any LLM inference provider","local":"create-a-transformers-agent-from-any-llm-inference-provider","sections":[{"title":"HuggingFace Serverless API and Dedicated Endpoints","local":"huggingface-serverless-api-and-dedicated-endpoints","sections":[],"depth":2},{"title":"Adapting the recipe for any LLM","local":"adapting-the-recipe-for-any-llm","sections":[{"title":"OpenAI","local":"openai","sections":[],"depth":3},{"title":"Anthropic","local":"anthropic","sections":[],"depth":3},{"title":"Next steps","local":"next-steps","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ts(kl){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends as{constructor(U){super(),Ms(this,U,Ts,Js,es,{})}}export{ms as component};
