import{s as qe,o as Pe,n as Le}from"../chunks/scheduler.d586627e.js";import{S as De,i as Ke,g as i,s as n,r as u,A as Oe,h as p,f as t,c as a,j as Ae,u as c,x as m,k as L,y as el,a as s,v as r,d as y,t as f,w as M}from"../chunks/index.8589a59c.js";import{T as ll,C as h}from"../chunks/CodeBlock.627f23e9.js";import{H as Be}from"../chunks/Heading.a70e045b.js";function tl(D){let o,J='どのタスクがサポートされているかは、<a href="../api/pipelines/auto_pipeline">AutoPipeline</a> のリファレンスをご覧ください。現在、text-to-image、image-to-image、inpaintingをサポートしています。';return{c(){o=i("p"),o.innerHTML=J},l(d){o=p(d,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1dp1np6"&&(o.innerHTML=J)},m(d,q){s(d,o,q)},p:Le,d(d){d&&t(o)}}}function sl(D){let o,J,d,q,j,K,w,Ve='Diffusersは様々なタスクをこなすことができ、テキストから画像、画像から画像、画像の修復など、複数のタスクに対して同じように事前学習された重みを再利用することができます。しかし、ライブラリや拡散モデルに慣れていない場合、どのタスクにどのパイプラインを使えばいいのかがわかりにくいかもしれません。例えば、 <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> チェックポイントをテキストから画像に変換するために使用している場合、それぞれ<code>StableDiffusionImg2ImgPipeline</code>クラスと<code>StableDiffusionInpaintPipeline</code>クラスでチェックポイントをロードすることで、画像から画像や画像の修復にも使えることを知らない可能性もあります。',O,W,_e="<code>AutoPipeline</code> クラスは、🤗 Diffusers の様々なパイプラインをよりシンプルするために設計されています。この汎用的でタスク重視のパイプラインによってタスクそのものに集中することができます。<code>AutoPipeline</code> は、使用するべき正しいパイプラインクラスを自動的に検出するため、特定のパイプラインクラス名を知らなくても、タスクのチェックポイントを簡単にロードできます。",ee,b,le,G,ve="このチュートリアルでは、<code>AutoPipeline</code> を使用して、事前に学習された重みが与えられたときに、特定のタスクを読み込むためのパイプラインクラスを自動的に推測する方法を示します。",te,T,se,B,Ie='まずはチェックポイントを選ぶことから始めましょう。例えば、 <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> チェックポイントでテキストから画像への変換したいなら、<code>AutoPipelineForText2Image</code>を使います:',ne,V,ae,g,Re='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-text2img.png" alt="generated image of peasant fighting dragon in wood cutting style"/>',ie,_,Xe="<code>AutoPipelineForText2Image</code> を具体的に見ていきましょう:",pe,v,Ce='<li><a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> ファイルから <code>&quot;stable-diffusion&quot;</code> クラスを自動的に検出します。</li> <li><code>&quot;stable-diffusion&quot;</code> のクラス名に基づいて、テキストから画像へ変換する <code>StableDiffusionPipeline</code> を読み込みます。</li>',me,I,Fe="同様に、画像から画像へ変換する場合、<code>AutoPipelineForImage2Image</code> は <code>model_index.json</code> ファイルから <code>&quot;stable-diffusion&quot;</code> チェックポイントを検出し、対応する <code>StableDiffusionImg2ImgPipeline</code> を読み込みます。また、入力画像にノイズの量やバリエーションの追加を決めるための強さなど、パイプラインクラスに固有の追加引数を渡すこともできます:",oe,R,ue,Z,ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-img2img.png" alt="generated image of a vermeer portrait of a dog wearing a pearl earring"/>',ce,X,$e="また、画像の修復を行いたい場合は、 <code>AutoPipelineForInpainting</code> が、同様にベースとなる<code>StableDiffusionInpaintPipeline</code>クラスを読み込みます：",re,C,ye,U,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-inpaint.png" alt="generated image of a tiger sitting on a bench"/>',fe,F,Se="サポートされていないチェックポイントを読み込もうとすると、エラーになります:",Me,k,de,$,be,x,Ee='いくつかのワークフローや多くのパイプラインを読み込む場合、不要なメモリを使ってしまう再読み込みをするよりも、チェックポイントから同じコンポーネントを再利用する方がメモリ効率が良いです。たとえば、テキストから画像への変換にチェックポイントを使い、画像から画像への変換にまたチェックポイントを使いたい場合、<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe" rel="nofollow">from_pipe()</a> メソッドを使用します。このメソッドは、以前読み込まれたパイプラインのコンポーネントを使うことで追加のメモリを消費することなく、新しいパイプラインを作成します。',ge,S,He='<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe" rel="nofollow">from_pipe()</a> メソッドは、元のパイプラインクラスを検出し、実行したいタスクに対応する新しいパイプラインクラスにマッピングします。例えば、テキストから画像への<code>&quot;stable-diffusion&quot;</code> クラスのパイプラインを読み込む場合：',Ze,E,Ue,H,Ye='そして、[from_pipe()] (<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe)%E3%81%AF%E3%80%81%E3%82%82%E3%81%A8%E3%81%AE%60%22stable-diffusion%22%60" rel="nofollow">https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe)は、もとの`“stable-diffusion”`</a> パイプラインのクラスである <code>StableDiffusionImg2ImgPipeline</code> にマップします:',he,Y,Je,Q,Qe="元のパイプラインにオプションとして引数（セーフティチェッカーの無効化など）を渡した場合、この引数も新しいパイプラインに渡されます:",je,z,we,N,ze="新しいパイプラインの動作を変更したい場合は、元のパイプラインの引数や設定を上書きすることができます。例えば、セーフティチェッカーをオンに戻し、<code>strength</code> 引数を追加します:",We,A,Ge,P,Te;return j=new Be({props:{title:"AutoPipeline",local:"autopipeline",headingTag:"h1"}}),b=new ll({props:{$$slots:{default:[tl]},$$scope:{ctx:D}}}),T=new Be({props:{title:"タスクに合わせてAutoPipeline を選択する",local:"タスクに合わせてautopipeline-を選択する",headingTag:"h2"}}),V=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMnBlYXNhbnQlMjBhbmQlMjBkcmFnb24lMjBjb21iYXQlMkMlMjB3b29kJTIwY3V0dGluZyUyMHN0eWxlJTJDJTIwdmlraW5nJTIwZXJhJTJDJTIwYmV2ZWwlMjB3aXRoJTIwcnVuZSUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;peasant and dragon combat, wood cutting style, viking era, bevel with rune&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),R=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBvcnRyYWl0JTIwb2YlMjBhJTIwZG9nJTIwd2VhcmluZyUyMGElMjBwZWFybCUyMGVhcnJpbmclMjIlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGMCUyRjBmJTJGMTY2NV9HaXJsX3dpdGhfYV9QZWFybF9FYXJyaW5nLmpwZyUyRjgwMHB4LTE2NjVfR2lybF93aXRoX2FfUGVhcmxfRWFycmluZy5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwMCUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMTAuNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a portrait of a dog wearing a pearl earring&quot;</span>

url = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/0/0f/1665_Girl_with_a_Pearl_Earring.jpg/800px-1665_Girl_with_a_Pearl_Earring.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipeline(prompt, image, num_inference_steps=<span class="hljs-number">200</span>, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),C=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBtYWplc3RpYyUyMHRpZ2VyJTIwc2l0dGluZyUyMG9uJTIwYSUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMHN0cmVuZ3RoJTNEMC44MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
image = pipeline(prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),k=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZzaGFwLWUtaW1nMmltZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIyVmFsdWVFcnJvciUzQSUyMEF1dG9QaXBlbGluZSUyMGNhbid0JTIwZmluZCUyMGElMjBwaXBlbGluZSUyMGxpbmtlZCUyMHRvJTIwU2hhcEVJbWcySW1nUGlwZWxpbmUlMjBmb3IlMjBOb25lJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;openai/shap-e-img2img&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-string">&quot;ValueError: AutoPipeline can&#x27;t find a pipeline linked to ShapEImg2ImgPipeline for None&quot;</span>`,wrap:!1}}),$=new Be({props:{title:"複数のパイプラインを使用する",local:"複数のパイプラインを使用する",headingTag:"h2"}}),E=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcHJpbnQodHlwZShwaXBlbGluZV90ZXh0MmltZykpJTBBJTIyJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_text2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),Y=new h({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyklMEFwcmludCh0eXBlKHBpcGVsaW5lX2ltZzJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uX2ltZzJpbWcuU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJyUzRSUyMg==",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_img2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion_img2img.StableDiffusionImg2ImgPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),z=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lX2ltZzJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmVfdGV4dDJpbWcpJTBBcHJpbnQocGlwZWxpbmVfaW1nMmltZy5jb25maWcucmVxdWlyZXNfc2FmZXR5X2NoZWNrZXIpJTBBJTIyRmFsc2UlMjI=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;False&quot;</span>`,wrap:!1}}),A=new h({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyUyQyUyMHJlcXVpcmVzX3NhZmV0eV9jaGVja2VyJTNEVHJ1ZSUyQyUyMHN0cmVuZ3RoJTNEMC4zKSUwQXByaW50KHBpcGVsaW5lX2ltZzJpbWcuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMlRydWUlMjI=",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img, requires_safety_checker=<span class="hljs-literal">True</span>, strength=<span class="hljs-number">0.3</span>)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;True&quot;</span>`,wrap:!1}}),{c(){o=i("meta"),J=n(),d=i("p"),q=n(),u(j.$$.fragment),K=n(),w=i("p"),w.innerHTML=Ve,O=n(),W=i("p"),W.innerHTML=_e,ee=n(),u(b.$$.fragment),le=n(),G=i("p"),G.innerHTML=ve,te=n(),u(T.$$.fragment),se=n(),B=i("p"),B.innerHTML=Ie,ne=n(),u(V.$$.fragment),ae=n(),g=i("div"),g.innerHTML=Re,ie=n(),_=i("p"),_.innerHTML=Xe,pe=n(),v=i("ol"),v.innerHTML=Ce,me=n(),I=i("p"),I.innerHTML=Fe,oe=n(),u(R.$$.fragment),ue=n(),Z=i("div"),Z.innerHTML=ke,ce=n(),X=i("p"),X.innerHTML=$e,re=n(),u(C.$$.fragment),ye=n(),U=i("div"),U.innerHTML=xe,fe=n(),F=i("p"),F.textContent=Se,Me=n(),u(k.$$.fragment),de=n(),u($.$$.fragment),be=n(),x=i("p"),x.innerHTML=Ee,ge=n(),S=i("p"),S.innerHTML=He,Ze=n(),u(E.$$.fragment),Ue=n(),H=i("p"),H.innerHTML=Ye,he=n(),u(Y.$$.fragment),Je=n(),Q=i("p"),Q.textContent=Qe,je=n(),u(z.$$.fragment),we=n(),N=i("p"),N.innerHTML=ze,We=n(),u(A.$$.fragment),Ge=n(),P=i("p"),this.h()},l(e){const l=Oe("svelte-u9bgzb",document.head);o=p(l,"META",{name:!0,content:!0}),l.forEach(t),J=a(e),d=p(e,"P",{}),Ae(d).forEach(t),q=a(e),c(j.$$.fragment,e),K=a(e),w=p(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-kcfjtt"&&(w.innerHTML=Ve),O=a(e),W=p(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-bhmuwk"&&(W.innerHTML=_e),ee=a(e),c(b.$$.fragment,e),le=a(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-fxxxlv"&&(G.innerHTML=ve),te=a(e),c(T.$$.fragment,e),se=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-17vhb9v"&&(B.innerHTML=Ie),ne=a(e),c(V.$$.fragment,e),ae=a(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-1yzwly4"&&(g.innerHTML=Re),ie=a(e),_=p(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-bx1qu8"&&(_.innerHTML=Xe),pe=a(e),v=p(e,"OL",{"data-svelte-h":!0}),m(v)!=="svelte-1cyscr8"&&(v.innerHTML=Ce),me=a(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1tv7o7j"&&(I.innerHTML=Fe),oe=a(e),c(R.$$.fragment,e),ue=a(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(Z)!=="svelte-9fi2fw"&&(Z.innerHTML=ke),ce=a(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1a50jb8"&&(X.innerHTML=$e),re=a(e),c(C.$$.fragment,e),ye=a(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(U)!=="svelte-1id5o5z"&&(U.innerHTML=xe),fe=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1iuzdt9"&&(F.textContent=Se),Me=a(e),c(k.$$.fragment,e),de=a(e),c($.$$.fragment,e),be=a(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-q2xv6p"&&(x.innerHTML=Ee),ge=a(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-mczuk5"&&(S.innerHTML=He),Ze=a(e),c(E.$$.fragment,e),Ue=a(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-5m0bbd"&&(H.innerHTML=Ye),he=a(e),c(Y.$$.fragment,e),Je=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1m19tqu"&&(Q.textContent=Qe),je=a(e),c(z.$$.fragment,e),we=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1vu2fjh"&&(N.innerHTML=ze),We=a(e),c(A.$$.fragment,e),Ge=a(e),P=p(e,"P",{}),Ae(P).forEach(t),this.h()},h(){L(o,"name","hf:doc:metadata"),L(o,"content",nl),L(g,"class","flex justify-center"),L(Z,"class","flex justify-center"),L(U,"class","flex justify-center")},m(e,l){el(document.head,o),s(e,J,l),s(e,d,l),s(e,q,l),r(j,e,l),s(e,K,l),s(e,w,l),s(e,O,l),s(e,W,l),s(e,ee,l),r(b,e,l),s(e,le,l),s(e,G,l),s(e,te,l),r(T,e,l),s(e,se,l),s(e,B,l),s(e,ne,l),r(V,e,l),s(e,ae,l),s(e,g,l),s(e,ie,l),s(e,_,l),s(e,pe,l),s(e,v,l),s(e,me,l),s(e,I,l),s(e,oe,l),r(R,e,l),s(e,ue,l),s(e,Z,l),s(e,ce,l),s(e,X,l),s(e,re,l),r(C,e,l),s(e,ye,l),s(e,U,l),s(e,fe,l),s(e,F,l),s(e,Me,l),r(k,e,l),s(e,de,l),r($,e,l),s(e,be,l),s(e,x,l),s(e,ge,l),s(e,S,l),s(e,Ze,l),r(E,e,l),s(e,Ue,l),s(e,H,l),s(e,he,l),r(Y,e,l),s(e,Je,l),s(e,Q,l),s(e,je,l),r(z,e,l),s(e,we,l),s(e,N,l),s(e,We,l),r(A,e,l),s(e,Ge,l),s(e,P,l),Te=!0},p(e,[l]){const Ne={};l&2&&(Ne.$$scope={dirty:l,ctx:e}),b.$set(Ne)},i(e){Te||(y(j.$$.fragment,e),y(b.$$.fragment,e),y(T.$$.fragment,e),y(V.$$.fragment,e),y(R.$$.fragment,e),y(C.$$.fragment,e),y(k.$$.fragment,e),y($.$$.fragment,e),y(E.$$.fragment,e),y(Y.$$.fragment,e),y(z.$$.fragment,e),y(A.$$.fragment,e),Te=!0)},o(e){f(j.$$.fragment,e),f(b.$$.fragment,e),f(T.$$.fragment,e),f(V.$$.fragment,e),f(R.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f($.$$.fragment,e),f(E.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(A.$$.fragment,e),Te=!1},d(e){e&&(t(J),t(d),t(q),t(K),t(w),t(O),t(W),t(ee),t(le),t(G),t(te),t(se),t(B),t(ne),t(ae),t(g),t(ie),t(_),t(pe),t(v),t(me),t(I),t(oe),t(ue),t(Z),t(ce),t(X),t(re),t(ye),t(U),t(fe),t(F),t(Me),t(de),t(be),t(x),t(ge),t(S),t(Ze),t(Ue),t(H),t(he),t(Je),t(Q),t(je),t(we),t(N),t(We),t(Ge),t(P)),t(o),M(j,e),M(b,e),M(T,e),M(V,e),M(R,e),M(C,e),M(k,e),M($,e),M(E,e),M(Y,e),M(z,e),M(A,e)}}}const nl='{"title":"AutoPipeline","local":"autopipeline","sections":[{"title":"タスクに合わせてAutoPipeline を選択する","local":"タスクに合わせてautopipeline-を選択する","sections":[],"depth":2},{"title":"複数のパイプラインを使用する","local":"複数のパイプラインを使用する","sections":[],"depth":2}],"depth":1}';function al(D){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends De{constructor(o){super(),Ke(this,o,al,sl,qe,{})}}export{ul as component};
