import{s as _e,o as Re,n as Xe}from"../chunks/scheduler.d6170356.js";import{S as Fe,i as Qe,g as h,s as l,r as p,A as Ye,h as c,f as a,c as n,j as ve,u as i,x as y,k as Be,y as xe,a as t,v as o,d as r,t as d,w as m}from"../chunks/index.fcd4cc08.js";import{T as We}from"../chunks/Tip.b09c67cf.js";import{C as u}from"../chunks/CodeBlock.db16bf50.js";import{H as w,E as Ne}from"../chunks/index.c1f68a2b.js";function Ve(us){let f,g="Pipelines don’t accept a <code>tqdm</code> object as input but you can use a python generator instead, in the form <code>x for x in tqdm(...)</code>";return{c(){f=h("p"),f.innerHTML=g},l(M){f=c(M,"P",{"data-svelte-h":!0}),y(f)!=="svelte-15dkqvr"&&(f.innerHTML=g)},m(M,ys){t(M,f,ys)},p:Xe,d(M){M&&a(f)}}}function Se(us){let f,g,M,ys,J,Ms,T,he=`<a href="https://github.com/pandas-dev/pandas" rel="nofollow">Pandas</a> is a widely used Python data analysis toolkit.
Since it uses <a href="https://filesystem-spec.readthedocs.io" rel="nofollow">fsspec</a> to read and write remote data, you can use the Hugging Face paths (<a href="/docs/huggingface_hub/guides/hf_file_system#integrations"><code>hf://</code></a>) to read and write data on the Hub.`,ws,j,Us,$,ce="You can load data from local files or from remote storage like Hugging Face Datasets. Pandas supports many formats including CSV, JSON and Parquet:",gs,b,Js,I,ye='To load a file from Hugging Face, the path needs to start with <code>hf://</code>. For example, the path to the <a href="https://huggingface.co/datasets/stanfordnlp/imdb" rel="nofollow">stanfordnlp/imdb</a> dataset repository is <code>hf://datasets/stanfordnlp/imdb</code>. The dataset on Hugging Face contains multiple Parquet files. The Parquet file format is designed to make reading and writing data frames efficient, and to make sharing data across data analysis languages easy. Here is how to load the file <code>plain_text/train-00000-of-00001.parquet</code>:',Ts,Z,js,C,fe='For more information on the Hugging Face paths and how they are implemented, please refer to the <a href="/docs/huggingface_hub/guides/hf_file_system">the client library’s documentation on the HfFileSystem</a>.',$s,G,bs,k,ue="You can save a pandas DataFrame using <code>to_csv/to_json/to_parquet</code> to a local file or to Hugging Face directly.",Is,q,Me='To save the DataFrame on Hugging Face, you first need to <a href="/docs/huggingface_hub/quick-start#login">Login with your Hugging Face account</a>, for example using:',Zs,v,Cs,B,we='Then you can <a href="/docs/huggingface_hub/quick-start#create-a-repository">Create a dataset repository</a>, for example using:',Gs,_,ks,R,Ue='Finally, you can use <a href="/docs/huggingface_hub/guides/hf_file_system#integrations">Hugging Face paths</a> in Pandas:',qs,X,vs,F,Bs,Q,ge="You can load a folder with a metadata file containing a field for the names or paths to the images, structured like this:",_s,Y,Rs,x,Je="You can iterate on the images paths like this:",Xs,W,Fs,N,Te='Since the dataset is in a <a href="https://huggingface.co/docs/hub/en/datasets-image#additional-columns" rel="nofollow">supported structure</a> (a <code>metadata.csv</code> or <code>.jsonl</code> file with a <code>file_name</code> field), you can save this dataset to Hugging Face and the Dataset Viewer shows both the metadata and images on Hugging Face.',Qs,V,Ys,S,xs,H,je='Using <a href="https://github.com/lhoestq/pandas-image-methods" rel="nofollow">pandas-image-methods</a> you enable <code>PIL.Image</code> methods on an image column. It also enables saving the dataset as one single Parquet file containing both the images and the metadata:',Ws,E,Ns,L,$e="All the <code>PIL.Image</code> methods are available, e.g.",Vs,A,Ss,z,Hs,P,be="You can load a folder with a metadata file containing a field for the names or paths to the audios, structured like this:",Es,K,Ls,D,Ie="You can iterate on the audios paths like this:",As,O,zs,ss,Ze='Since the dataset is in a <a href="https://huggingface.co/docs/hub/en/datasets-audio#additional-columns" rel="nofollow">supported structure</a> (a <code>metadata.csv</code> or <code>.jsonl</code> file with a <code>file_name</code> field), you can save it to Hugging Face, and the Hub Dataset Viewer shows both the metadata and audio.',Ps,es,Ks,as,Ds,ts,Ce='Using <a href="https://github.com/lhoestq/pandas-audio-methods" rel="nofollow">pandas-audio-methods</a> you enable <code>soundfile</code> methods on an audio column. It also enables saving the dataset as one single Parquet file containing both the audios and the metadata:',Os,ls,se,ns,Ge="This makes it easy to use with <code>librosa</code> e.g. for resampling:",ee,ps,ae,is,te,os,ke=`You can use <code>transformers</code> pipelines on pandas DataFrames to classify, generate text, images, etc.
This section shows a few examples with <code>tqdm</code> for progress bars.`,le,U,ne,rs,pe,ds,ie,ms,oe,hs,re,cs,de,fs,me;return J=new w({props:{title:"Pandas",local:"pandas",headingTag:"h1"}}),j=new w({props:{title:"Load a DataFrame",local:"load-a-dataframe",headingTag:"h2"}}),b=new u({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWRmJTIwJTNEJTIwcGQucmVhZF9jc3YoJTIycGF0aCUyRnRvJTJGZGF0YS5jc3YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;path/to/data.csv&quot;</span>)`,wrap:!1}}),Z=new u({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWRmJTIwJTNEJTIwcGQucmVhZF9wYXJxdWV0KCUyMmhmJTNBJTJGJTJGZGF0YXNldHMlMkZzdGFuZm9yZG5scCUyRmltZGIlMkZwbGFpbl90ZXh0JTJGdHJhaW4tMDAwMDAtb2YtMDAwMDEucGFycXVldCUyMiklMEFkZiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_parquet(<span class="hljs-string">&quot;hf://datasets/stanfordnlp/imdb/plain_text/train-00000-of-00001.parquet&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df
                                                    text  label
<span class="hljs-number">0</span>      I rented I AM CURIOUS-YELLOW <span class="hljs-keyword">from</span> my video sto...      <span class="hljs-number">0</span>
<span class="hljs-number">1</span>      <span class="hljs-string">&quot;I Am Curious: Yellow&quot;</span> <span class="hljs-keyword">is</span> a risible <span class="hljs-keyword">and</span> preten...      <span class="hljs-number">0</span>
<span class="hljs-number">2</span>      If only to avoid making this <span class="hljs-built_in">type</span> of film <span class="hljs-keyword">in</span> t...      <span class="hljs-number">0</span>
<span class="hljs-number">3</span>      This film was probably inspired by Godard<span class="hljs-string">&#x27;s Ma...      0
4      Oh, brother...after hearing about this ridicul...      0
...                                                  ...    ...
24995  A hit at the time but now better categorised a...      1
24996  I love this movie like no other. Another time ...      1
24997  This film and it&#x27;</span>s sequel Barry Mckenzie holds...      <span class="hljs-number">1</span>
<span class="hljs-number">24998</span>  <span class="hljs-string">&#x27;The Adventures Of Barry McKenzie&#x27;</span> started lif...      <span class="hljs-number">1</span>
<span class="hljs-number">24999</span>  The story centers around Barry McKenzie who mu...      <span class="hljs-number">1</span>`,wrap:!1}}),G=new w({props:{title:"Save a DataFrame",local:"save-a-dataframe",headingTag:"h2"}}),v=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:'huggingface-<span class="hljs-keyword">cli</span> login',wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBSGZBcGkoKS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9kYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

HfApi().create_repo(repo_id=<span class="hljs-string">&quot;username/my_dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),X=new u({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmLnRvX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRmltZGIucGFycXVldCUyMiklMEElMEElMjMlMjBvciUyMHdyaXRlJTIwaW4lMjBzZXBhcmF0ZSUyMGZpbGVzJTIwaWYlMjB0aGUlMjBkYXRhc2V0JTIwaGFzJTIwdHJhaW4lMkZ2YWxpZGF0aW9uJTJGdGVzdCUyMHNwbGl0cyUwQWRmX3RyYWluLnRvX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRnRyYWluLnBhcnF1ZXQlMjIpJTBBZGZfdmFsaWQudG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdmFsaWRhdGlvbi5wYXJxdWV0JTIyKSUwQWRmX3Rlc3QlMjAudG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdGVzdC5wYXJxdWV0JTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/imdb.parquet&quot;</span>)

<span class="hljs-comment"># or write in separate files if the dataset has train/validation/test splits</span>
df_train.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/train.parquet&quot;</span>)
df_valid.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/validation.parquet&quot;</span>)
df_test .to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/test.parquet&quot;</span>)`,wrap:!1}}),F=new w({props:{title:"Use Images",local:"use-images",headingTag:"h2"}}),Y=new u({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`Example <span class="hljs-number">1</span>:            Example <span class="hljs-number">2</span>:
folder/               folder/
├── metadata<span class="hljs-selector-class">.csv</span>      ├── metadata<span class="hljs-selector-class">.csv</span>
├── img000<span class="hljs-selector-class">.png</span>        └── images
├── img001<span class="hljs-selector-class">.png</span>            ├── img000<span class="hljs-selector-class">.png</span>
...                       ...
└── imgNNN<span class="hljs-selector-class">.png</span>            └── imgNNN.png`,wrap:!1}}),W=new u({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWZvbGRlcl9wYXRoJTIwJTNEJTIwJTIycGF0aCUyRnRvJTJGZm9sZGVyJTJGJTIyJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2Nzdihmb2xkZXJfcGF0aCUyMCUyQiUyMCUyMm1ldGFkYXRhLmNzdiUyMiklMEFmb3IlMjBpbWFnZV9wYXRoJTIwaW4lMjAoZm9sZGVyX3BhdGglMjAlMkIlMjBkZiU1QiUyMmZpbGVfbmFtZSUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

folder_path = <span class="hljs-string">&quot;path/to/folder/&quot;</span>
df = pd.read_csv(folder_path + <span class="hljs-string">&quot;metadata.csv&quot;</span>)
<span class="hljs-keyword">for</span> image_path <span class="hljs-keyword">in</span> (folder_path + df[<span class="hljs-string">&quot;file_name&quot;</span>]):
    ...`,wrap:!1}}),V=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZm9sZGVyX3BhdGglMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9pbWFnZV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()

api.upload_folder(
    folder_path=folder_path,
    repo_id=<span class="hljs-string">&quot;username/my_image_dataset&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),S=new w({props:{title:"Image methods and Parquet",local:"image-methods-and-parquet",headingTag:"h3"}}),E=new u({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBwYW5kYXNfaW1hZ2VfbWV0aG9kcyUyMGltcG9ydCUyMFBJTE1ldGhvZHMlMEElMEFwZC5hcGkuZXh0ZW5zaW9ucy5yZWdpc3Rlcl9zZXJpZXNfYWNjZXNzb3IoJTIycGlsJTIyKShQSUxNZXRob2RzKSUwQSUwQWRmJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjAoZm9sZGVyX3BhdGglMjAlMkIlMjBkZiU1QiUyMmZpbGVfbmFtZSUyMiU1RCkucGlsLm9wZW4oKSUwQWRmLnRvX3BhcnF1ZXQoJTIyZGF0YS5wYXJxdWV0JTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> pandas_image_methods <span class="hljs-keyword">import</span> PILMethods

pd.api.extensions.register_series_accessor(<span class="hljs-string">&quot;pil&quot;</span>)(PILMethods)

df[<span class="hljs-string">&quot;image&quot;</span>] = (folder_path + df[<span class="hljs-string">&quot;file_name&quot;</span>]).pil.<span class="hljs-built_in">open</span>()
df.to_parquet(<span class="hljs-string">&quot;data.parquet&quot;</span>)`,wrap:!1}}),A=new u({props:{code:"ZGYlNUIlMjJpbWFnZSUyMiU1RCUyMCUzRCUyMGRmJTVCJTIyaW1hZ2UlMjIlNUQucGlsLnJvdGF0ZSg5MCk=",highlighted:'df[<span class="hljs-string">&quot;image&quot;</span>] = df[<span class="hljs-string">&quot;image&quot;</span>].pil.rotate(<span class="hljs-number">90</span>)',wrap:!1}}),z=new w({props:{title:"Use Audios",local:"use-audios",headingTag:"h2"}}),K=new u({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`Example <span class="hljs-number">1</span>:            Example <span class="hljs-number">2</span>:
folder/               folder/
├── metadata<span class="hljs-selector-class">.csv</span>      ├── metadata<span class="hljs-selector-class">.csv</span>
├── rec000<span class="hljs-selector-class">.wav</span>        └── audios
├── rec001<span class="hljs-selector-class">.wav</span>            ├── rec000<span class="hljs-selector-class">.wav</span>
...                       ...
└── recNNN<span class="hljs-selector-class">.wav</span>            └── recNNN.wav`,wrap:!1}}),O=new u({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWZvbGRlcl9wYXRoJTIwJTNEJTIwJTIycGF0aCUyRnRvJTJGZm9sZGVyJTJGJTIyJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2Nzdihmb2xkZXJfcGF0aCUyMCUyQiUyMCUyMm1ldGFkYXRhLmNzdiUyMiklMEFmb3IlMjBhdWRpb19wYXRoJTIwaW4lMjAoZm9sZGVyX3BhdGglMjAlMkIlMjBkZiU1QiUyMmZpbGVfbmFtZSUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

folder_path = <span class="hljs-string">&quot;path/to/folder/&quot;</span>
df = pd.read_csv(folder_path + <span class="hljs-string">&quot;metadata.csv&quot;</span>)
<span class="hljs-keyword">for</span> audio_path <span class="hljs-keyword">in</span> (folder_path + df[<span class="hljs-string">&quot;file_name&quot;</span>]):
    ...`,wrap:!1}}),es=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZm9sZGVyX3BhdGglMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9hdWRpb19kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()

api.upload_folder(
    folder_path=folder_path,
    repo_id=<span class="hljs-string">&quot;username/my_audio_dataset&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),as=new w({props:{title:"Audio methods and Parquet",local:"audio-methods-and-parquet",headingTag:"h3"}}),ls=new u({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBwYW5kYXNfaW1hZ2VfbWV0aG9kcyUyMGltcG9ydCUyMFNGTWV0aG9kcyUwQSUwQXBkLmFwaS5leHRlbnNpb25zLnJlZ2lzdGVyX3Nlcmllc19hY2Nlc3NvciglMjJzZiUyMikoU0ZNZXRob2RzKSUwQSUwQWRmJTVCJTIyYXVkaW8lMjIlNUQlMjAlM0QlMjAoZm9sZGVyX3BhdGglMjAlMkIlMjBkZiU1QiUyMmZpbGVfbmFtZSUyMiU1RCkuc2Yub3BlbigpJTBBZGYudG9fcGFycXVldCglMjJkYXRhLnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> pandas_image_methods <span class="hljs-keyword">import</span> SFMethods

pd.api.extensions.register_series_accessor(<span class="hljs-string">&quot;sf&quot;</span>)(SFMethods)

df[<span class="hljs-string">&quot;audio&quot;</span>] = (folder_path + df[<span class="hljs-string">&quot;file_name&quot;</span>]).sf.<span class="hljs-built_in">open</span>()
df.to_parquet(<span class="hljs-string">&quot;data.parquet&quot;</span>)`,wrap:!1}}),ps=new u({props:{code:"ZGYlNUIlMjJhdWRpbyUyMiU1RCUyMCUzRCUyMCU1QmxpYnJvc2EubG9hZChhdWRpbyUyQyUyMHNyJTNEMTZfMDAwKSUyMGZvciUyMGF1ZGlvJTIwaW4lMjBkZiU1QiUyMmF1ZGlvJTIyJTVEJTVEJTBBZGYlNUIlMjJhdWRpbyUyMiU1RCUyMCUzRCUyMGRmJTVCJTIyYXVkaW8lMjIlNUQuc2Yud3JpdGUoKQ==",highlighted:`df[<span class="hljs-string">&quot;audio&quot;</span>] = [librosa.load(audio, sr=<span class="hljs-number">16_000</span>) <span class="hljs-keyword">for</span> audio <span class="hljs-keyword">in</span> df[<span class="hljs-string">&quot;audio&quot;</span>]]
df[<span class="hljs-string">&quot;audio&quot;</span>] = df[<span class="hljs-string">&quot;audio&quot;</span>].sf.write()`,wrap:!1}}),is=new w({props:{title:"Use Transformers",local:"use-transformers",headingTag:"h2"}}),U=new We({props:{$$slots:{default:[Ve]},$$scope:{ctx:us}}}),rs=new w({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),ds=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmNsYXBBSSUyRm1vZGVybkJFUlQtYmFzZS1tdWx0aWxpbmd1YWwtc2VudGltZW50JTIyKSUwQSUwQSUyMyUyMENvbXB1dGUlMjBsYWJlbHMlMEFkZiU1QiUyMmxhYmVsJTIyJTVEJTIwJTNEJTIwJTVCeSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIweSUyMGluJTIwcGlwZSh4JTIwZm9yJTIweCUyMGluJTIwdHFkbShkZiU1QiUyMnRleHQlMjIlNUQpKSU1RCUwQSUyMyUyMENvbXB1dGUlMjBsYWJlbHMlMjBhbmQlMjBzY29yZXMlMEFkZiU1QiU1QiUyMmxhYmVsJTIyJTJDJTIwJTIyc2NvcmUlMjIlNUQlNUQlMjAlM0QlMjAlNUIoeSU1QiUyMmxhYmVsJTIyJTVEJTJDJTIweSU1QiUyMnNjb3JlJTIyJTVEKSUyMGZvciUyMHklMjBpbiUyMHBpcGUoeCUyMGZvciUyMHglMjBpbiUyMHRxZG0oZGYlNUIlMjJ0ZXh0JTIyJTVEKSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;clapAI/modernBERT-base-multilingual-sentiment&quot;</span>)

<span class="hljs-comment"># Compute labels</span>
df[<span class="hljs-string">&quot;label&quot;</span>] = [y[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> y <span class="hljs-keyword">in</span> pipe(x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> tqdm(df[<span class="hljs-string">&quot;text&quot;</span>]))]
<span class="hljs-comment"># Compute labels and scores</span>
df[[<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>]] = [(y[<span class="hljs-string">&quot;label&quot;</span>], y[<span class="hljs-string">&quot;score&quot;</span>]) <span class="hljs-keyword">for</span> y <span class="hljs-keyword">in</span> pipe(x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> tqdm(df[<span class="hljs-string">&quot;text&quot;</span>]))]`,wrap:!1}}),ms=new w({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),hs=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyUXdlbiUyRlF3ZW4yLjUtMS41Qi1JbnN0cnVjdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUyMGNoYXQlMjByZXNwb25zZSUwQXByb21wdCUyMCUzRCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMG1haW4lMjB0b3BpYyUyMG9mJTIwdGhpcyUyMHNlbnRlbmNlJTIwJTNGJTIwUkVQTFklMjBJTiUyMExFU1MlMjBUSEFOJTIwMyUyMFdPUkRTLiUyMFNlbnRlbmNlJTNBJTIwJyU3QiU3RCclMjIlMEFkZiU1QiUyMm91dHB1dCUyMiU1RCUyMCUzRCUyMCU1QnklNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1QjElNUQlNUIlMjJjb250ZW50JTIyJTVEJTIwZm9yJTIweSUyMGluJTIwcGlwZSglNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBwcm9tcHQuZm9ybWF0KHgpJTdEJTVEJTIwZm9yJTIweCUyMGluJTIwdHFkbShkZiU1QiUyMnRleHQlMjIlNUQpKSU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;Qwen/Qwen2.5-1.5B-Instruct&quot;</span>)

<span class="hljs-comment"># Generate chat response</span>
prompt = <span class="hljs-string">&quot;What is the main topic of this sentence ? REPLY IN LESS THAN 3 WORDS. Sentence: &#x27;{}&#x27;&quot;</span>
df[<span class="hljs-string">&quot;output&quot;</span>] = [y[<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> y <span class="hljs-keyword">in</span> pipe([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt.<span class="hljs-built_in">format</span>(x)}] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> tqdm(df[<span class="hljs-string">&quot;text&quot;</span>]))]`,wrap:!1}}),cs=new Ne({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-pandas.md"}}),{c(){f=h("meta"),g=l(),M=h("p"),ys=l(),p(J.$$.fragment),Ms=l(),T=h("p"),T.innerHTML=he,ws=l(),p(j.$$.fragment),Us=l(),$=h("p"),$.textContent=ce,gs=l(),p(b.$$.fragment),Js=l(),I=h("p"),I.innerHTML=ye,Ts=l(),p(Z.$$.fragment),js=l(),C=h("p"),C.innerHTML=fe,$s=l(),p(G.$$.fragment),bs=l(),k=h("p"),k.innerHTML=ue,Is=l(),q=h("p"),q.innerHTML=Me,Zs=l(),p(v.$$.fragment),Cs=l(),B=h("p"),B.innerHTML=we,Gs=l(),p(_.$$.fragment),ks=l(),R=h("p"),R.innerHTML=Ue,qs=l(),p(X.$$.fragment),vs=l(),p(F.$$.fragment),Bs=l(),Q=h("p"),Q.textContent=ge,_s=l(),p(Y.$$.fragment),Rs=l(),x=h("p"),x.textContent=Je,Xs=l(),p(W.$$.fragment),Fs=l(),N=h("p"),N.innerHTML=Te,Qs=l(),p(V.$$.fragment),Ys=l(),p(S.$$.fragment),xs=l(),H=h("p"),H.innerHTML=je,Ws=l(),p(E.$$.fragment),Ns=l(),L=h("p"),L.innerHTML=$e,Vs=l(),p(A.$$.fragment),Ss=l(),p(z.$$.fragment),Hs=l(),P=h("p"),P.textContent=be,Es=l(),p(K.$$.fragment),Ls=l(),D=h("p"),D.textContent=Ie,As=l(),p(O.$$.fragment),zs=l(),ss=h("p"),ss.innerHTML=Ze,Ps=l(),p(es.$$.fragment),Ks=l(),p(as.$$.fragment),Ds=l(),ts=h("p"),ts.innerHTML=Ce,Os=l(),p(ls.$$.fragment),se=l(),ns=h("p"),ns.innerHTML=Ge,ee=l(),p(ps.$$.fragment),ae=l(),p(is.$$.fragment),te=l(),os=h("p"),os.innerHTML=ke,le=l(),p(U.$$.fragment),ne=l(),p(rs.$$.fragment),pe=l(),p(ds.$$.fragment),ie=l(),p(ms.$$.fragment),oe=l(),p(hs.$$.fragment),re=l(),p(cs.$$.fragment),de=l(),fs=h("p"),this.h()},l(s){const e=Ye("svelte-u9bgzb",document.head);f=c(e,"META",{name:!0,content:!0}),e.forEach(a),g=n(s),M=c(s,"P",{}),ve(M).forEach(a),ys=n(s),i(J.$$.fragment,s),Ms=n(s),T=c(s,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1d65wub"&&(T.innerHTML=he),ws=n(s),i(j.$$.fragment,s),Us=n(s),$=c(s,"P",{"data-svelte-h":!0}),y($)!=="svelte-1110j0n"&&($.textContent=ce),gs=n(s),i(b.$$.fragment,s),Js=n(s),I=c(s,"P",{"data-svelte-h":!0}),y(I)!=="svelte-yuajzf"&&(I.innerHTML=ye),Ts=n(s),i(Z.$$.fragment,s),js=n(s),C=c(s,"P",{"data-svelte-h":!0}),y(C)!=="svelte-smuvdf"&&(C.innerHTML=fe),$s=n(s),i(G.$$.fragment,s),bs=n(s),k=c(s,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1ec8wgz"&&(k.innerHTML=ue),Is=n(s),q=c(s,"P",{"data-svelte-h":!0}),y(q)!=="svelte-17ov0yg"&&(q.innerHTML=Me),Zs=n(s),i(v.$$.fragment,s),Cs=n(s),B=c(s,"P",{"data-svelte-h":!0}),y(B)!=="svelte-wfb25d"&&(B.innerHTML=we),Gs=n(s),i(_.$$.fragment,s),ks=n(s),R=c(s,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1j7afyv"&&(R.innerHTML=Ue),qs=n(s),i(X.$$.fragment,s),vs=n(s),i(F.$$.fragment,s),Bs=n(s),Q=c(s,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-i1x932"&&(Q.textContent=ge),_s=n(s),i(Y.$$.fragment,s),Rs=n(s),x=c(s,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1wo91tc"&&(x.textContent=Je),Xs=n(s),i(W.$$.fragment,s),Fs=n(s),N=c(s,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1claf2y"&&(N.innerHTML=Te),Qs=n(s),i(V.$$.fragment,s),Ys=n(s),i(S.$$.fragment,s),xs=n(s),H=c(s,"P",{"data-svelte-h":!0}),y(H)!=="svelte-u4wtbg"&&(H.innerHTML=je),Ws=n(s),i(E.$$.fragment,s),Ns=n(s),L=c(s,"P",{"data-svelte-h":!0}),y(L)!=="svelte-1alvzik"&&(L.innerHTML=$e),Vs=n(s),i(A.$$.fragment,s),Ss=n(s),i(z.$$.fragment,s),Hs=n(s),P=c(s,"P",{"data-svelte-h":!0}),y(P)!=="svelte-14ssghx"&&(P.textContent=be),Es=n(s),i(K.$$.fragment,s),Ls=n(s),D=c(s,"P",{"data-svelte-h":!0}),y(D)!=="svelte-9uthgh"&&(D.textContent=Ie),As=n(s),i(O.$$.fragment,s),zs=n(s),ss=c(s,"P",{"data-svelte-h":!0}),y(ss)!=="svelte-mbpxd8"&&(ss.innerHTML=Ze),Ps=n(s),i(es.$$.fragment,s),Ks=n(s),i(as.$$.fragment,s),Ds=n(s),ts=c(s,"P",{"data-svelte-h":!0}),y(ts)!=="svelte-1b7187v"&&(ts.innerHTML=Ce),Os=n(s),i(ls.$$.fragment,s),se=n(s),ns=c(s,"P",{"data-svelte-h":!0}),y(ns)!=="svelte-h7f8qe"&&(ns.innerHTML=Ge),ee=n(s),i(ps.$$.fragment,s),ae=n(s),i(is.$$.fragment,s),te=n(s),os=c(s,"P",{"data-svelte-h":!0}),y(os)!=="svelte-1l7xk3n"&&(os.innerHTML=ke),le=n(s),i(U.$$.fragment,s),ne=n(s),i(rs.$$.fragment,s),pe=n(s),i(ds.$$.fragment,s),ie=n(s),i(ms.$$.fragment,s),oe=n(s),i(hs.$$.fragment,s),re=n(s),i(cs.$$.fragment,s),de=n(s),fs=c(s,"P",{}),ve(fs).forEach(a),this.h()},h(){Be(f,"name","hf:doc:metadata"),Be(f,"content",He)},m(s,e){xe(document.head,f),t(s,g,e),t(s,M,e),t(s,ys,e),o(J,s,e),t(s,Ms,e),t(s,T,e),t(s,ws,e),o(j,s,e),t(s,Us,e),t(s,$,e),t(s,gs,e),o(b,s,e),t(s,Js,e),t(s,I,e),t(s,Ts,e),o(Z,s,e),t(s,js,e),t(s,C,e),t(s,$s,e),o(G,s,e),t(s,bs,e),t(s,k,e),t(s,Is,e),t(s,q,e),t(s,Zs,e),o(v,s,e),t(s,Cs,e),t(s,B,e),t(s,Gs,e),o(_,s,e),t(s,ks,e),t(s,R,e),t(s,qs,e),o(X,s,e),t(s,vs,e),o(F,s,e),t(s,Bs,e),t(s,Q,e),t(s,_s,e),o(Y,s,e),t(s,Rs,e),t(s,x,e),t(s,Xs,e),o(W,s,e),t(s,Fs,e),t(s,N,e),t(s,Qs,e),o(V,s,e),t(s,Ys,e),o(S,s,e),t(s,xs,e),t(s,H,e),t(s,Ws,e),o(E,s,e),t(s,Ns,e),t(s,L,e),t(s,Vs,e),o(A,s,e),t(s,Ss,e),o(z,s,e),t(s,Hs,e),t(s,P,e),t(s,Es,e),o(K,s,e),t(s,Ls,e),t(s,D,e),t(s,As,e),o(O,s,e),t(s,zs,e),t(s,ss,e),t(s,Ps,e),o(es,s,e),t(s,Ks,e),o(as,s,e),t(s,Ds,e),t(s,ts,e),t(s,Os,e),o(ls,s,e),t(s,se,e),t(s,ns,e),t(s,ee,e),o(ps,s,e),t(s,ae,e),o(is,s,e),t(s,te,e),t(s,os,e),t(s,le,e),o(U,s,e),t(s,ne,e),o(rs,s,e),t(s,pe,e),o(ds,s,e),t(s,ie,e),o(ms,s,e),t(s,oe,e),o(hs,s,e),t(s,re,e),o(cs,s,e),t(s,de,e),t(s,fs,e),me=!0},p(s,[e]){const qe={};e&2&&(qe.$$scope={dirty:e,ctx:s}),U.$set(qe)},i(s){me||(r(J.$$.fragment,s),r(j.$$.fragment,s),r(b.$$.fragment,s),r(Z.$$.fragment,s),r(G.$$.fragment,s),r(v.$$.fragment,s),r(_.$$.fragment,s),r(X.$$.fragment,s),r(F.$$.fragment,s),r(Y.$$.fragment,s),r(W.$$.fragment,s),r(V.$$.fragment,s),r(S.$$.fragment,s),r(E.$$.fragment,s),r(A.$$.fragment,s),r(z.$$.fragment,s),r(K.$$.fragment,s),r(O.$$.fragment,s),r(es.$$.fragment,s),r(as.$$.fragment,s),r(ls.$$.fragment,s),r(ps.$$.fragment,s),r(is.$$.fragment,s),r(U.$$.fragment,s),r(rs.$$.fragment,s),r(ds.$$.fragment,s),r(ms.$$.fragment,s),r(hs.$$.fragment,s),r(cs.$$.fragment,s),me=!0)},o(s){d(J.$$.fragment,s),d(j.$$.fragment,s),d(b.$$.fragment,s),d(Z.$$.fragment,s),d(G.$$.fragment,s),d(v.$$.fragment,s),d(_.$$.fragment,s),d(X.$$.fragment,s),d(F.$$.fragment,s),d(Y.$$.fragment,s),d(W.$$.fragment,s),d(V.$$.fragment,s),d(S.$$.fragment,s),d(E.$$.fragment,s),d(A.$$.fragment,s),d(z.$$.fragment,s),d(K.$$.fragment,s),d(O.$$.fragment,s),d(es.$$.fragment,s),d(as.$$.fragment,s),d(ls.$$.fragment,s),d(ps.$$.fragment,s),d(is.$$.fragment,s),d(U.$$.fragment,s),d(rs.$$.fragment,s),d(ds.$$.fragment,s),d(ms.$$.fragment,s),d(hs.$$.fragment,s),d(cs.$$.fragment,s),me=!1},d(s){s&&(a(g),a(M),a(ys),a(Ms),a(T),a(ws),a(Us),a($),a(gs),a(Js),a(I),a(Ts),a(js),a(C),a($s),a(bs),a(k),a(Is),a(q),a(Zs),a(Cs),a(B),a(Gs),a(ks),a(R),a(qs),a(vs),a(Bs),a(Q),a(_s),a(Rs),a(x),a(Xs),a(Fs),a(N),a(Qs),a(Ys),a(xs),a(H),a(Ws),a(Ns),a(L),a(Vs),a(Ss),a(Hs),a(P),a(Es),a(Ls),a(D),a(As),a(zs),a(ss),a(Ps),a(Ks),a(Ds),a(ts),a(Os),a(se),a(ns),a(ee),a(ae),a(te),a(os),a(le),a(ne),a(pe),a(ie),a(oe),a(re),a(de),a(fs)),a(f),m(J,s),m(j,s),m(b,s),m(Z,s),m(G,s),m(v,s),m(_,s),m(X,s),m(F,s),m(Y,s),m(W,s),m(V,s),m(S,s),m(E,s),m(A,s),m(z,s),m(K,s),m(O,s),m(es,s),m(as,s),m(ls,s),m(ps,s),m(is,s),m(U,s),m(rs,s),m(ds,s),m(ms,s),m(hs,s),m(cs,s)}}}const He='{"title":"Pandas","local":"pandas","sections":[{"title":"Load a DataFrame","local":"load-a-dataframe","sections":[],"depth":2},{"title":"Save a DataFrame","local":"save-a-dataframe","sections":[],"depth":2},{"title":"Use Images","local":"use-images","sections":[{"title":"Image methods and Parquet","local":"image-methods-and-parquet","sections":[],"depth":3}],"depth":2},{"title":"Use Audios","local":"use-audios","sections":[{"title":"Audio methods and Parquet","local":"audio-methods-and-parquet","sections":[],"depth":3}],"depth":2},{"title":"Use Transformers","local":"use-transformers","sections":[{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ee(us){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends Fe{constructor(f){super(),Qe(this,f,Ee,Se,_e,{})}}export{De as component};
