import{s as el,n as ll,o as tl}from"../chunks/scheduler.d6170356.js";import{S as sl,i as al,g as i,s as a,r,A as nl,h as m,f as t,c as n,j as Oe,u as c,x as o,k as K,y as il,a as s,v as p,d,t as y,w as h}from"../chunks/index.fcd4cc08.js";import{C as F}from"../chunks/CodeBlock.db16bf50.js";import{H as D,E as ml}from"../chunks/index.c1f68a2b.js";function ol(He){let M,O,q,ee,w,le,f,ke='<code>timm</code>, also known as <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">pytorch-image-models</a>, is an open-source collection of state-of-the-art PyTorch image models, pretrained weights, and utility scripts for training, inference, and validation.',te,g,Ye='This documentation focuses on <code>timm</code> functionality in the Hugging Face Hub instead of the <code>timm</code> library itself. For detailed information about the <code>timm</code> library, visit <a href="https://huggingface.co/docs/timm" rel="nofollow">its documentation</a>.',se,b,ze='You can find a number of <code>timm</code> models on the Hub using the filters on the left of the <a href="https://huggingface.co/models?library=timm&amp;sort=downloads" rel="nofollow">models page</a>.',ae,U,Ve="All models on the Hub come with several useful features:",ne,I,_e='<li>An automatically generated model card, which model authors can complete with <a href="./model-cards">information about their model</a>.</li> <li>Metadata tags help users discover the relevant <code>timm</code> models.</li> <li>An <a href="./models-widgets">interactive widget</a> you can use to play with the model directly in the browser.</li> <li>An <a href="./models-inference">Inference API</a> that allows users to make inference requests.</li>',ie,j,me,W,Ne="Any <code>timm</code> model from the Hugging Face Hub can be loaded with a single line of code as long as you have <code>timm</code> installed! Once you’ve selected a model from the Hub, pass the model’s ID prefixed with <code>hf-hub:</code> to <code>timm</code>’s <code>create_model</code> method to download and instantiate the model.",oe,Z,re,B,Qe="If you want to see how to load a specific model, you can click <strong>Use in timm</strong> and you will be given a working snippet to load it!",ce,J,Ee='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1-dark.png"/>',pe,T,Ae='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2-dark.png"/>',de,x,ye,v,Se="The snippet below shows how you can perform inference on a <code>timm</code> model loaded from the Hub:",he,G,Me,C,Le="This should leave you with a list of predictions, like this:",Je,$,Te,H,ue,k,Re="You can share your <code>timm</code> models directly to the Hugging Face Hub. This will publish a new version of your model to the Hugging Face Hub, creating a model repo for you if it doesn’t already exist.",we,Y,Xe="Before pushing a model, make sure that you’ve logged in to Hugging Face:",fe,z,ge,V,Fe="Alternatively, if you prefer working from a Jupyter or Colaboratory notebook, once you’ve installed <code>huggingface_hub</code> you can log in with:",be,_,Ue,N,De="Then, push your model using the <code>push_to_hf_hub</code> method:",Ie,Q,je,E,We,A,qe='All <code>timm</code> models on the Hub are automatically equipped with an <a href="./models-widgets">inference widget</a>, pictured below for <a href="https://huggingface.co/nateraw/timm-resnet50-beans" rel="nofollow">nateraw/timm-resnet50-beans</a>. Additionally, <code>timm</code> models are available through the <a href="./models-inference">Inference API</a>, which you can access through HTTP with cURL, Python’s <code>requests</code> library, or your preferred method for making network requests.',Ze,u,Pe='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget-dark.png"/>',Be,S,xe,L,ve,R,Ke='<li>timm (pytorch-image-models) <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">GitHub Repo</a>.</li> <li>timm <a href="https://huggingface.co/docs/timm" rel="nofollow">documentation</a>.</li> <li>Additional documentation at <a href="https://timm.fast.ai" rel="nofollow">timmdocs</a> by <a href="https://github.com/amaarora" rel="nofollow">Aman Arora</a>.</li> <li><a href="https://towardsdatascience.com/getting-started-with-pytorch-image-models-timm-a-practitioners-guide-4e77b4bf9055" rel="nofollow">Getting Started with PyTorch Image Models (timm): A Practitioner’s Guide</a> by <a href="https://github.com/Chris-hughes10" rel="nofollow">Chris Hughes</a>.</li>',Ge,X,Ce,P,$e;return w=new D({props:{title:"Using timm at Hugging Face",local:"using-timm-at-hugging-face",headingTag:"h1"}}),j=new D({props:{title:"Using existing models from the Hub",local:"using-existing-models-from-the-hub",headingTag:"h2"}}),Z=new F({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMExvYWRpbmclMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGltbSUyRmVjYV9uZm5ldF9sMCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJTIyaGYtaHViJTNBdGltbSUyRmVjYV9uZm5ldF9sMCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Loading https://huggingface.co/timm/eca_nfnet_l0</span>
model = timm.create_model(<span class="hljs-string">&quot;hf-hub:timm/eca_nfnet_l0&quot;</span>, pretrained=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new D({props:{title:"Inference",local:"inference",headingTag:"h3"}}),G=new F({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> timm
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-comment"># Load from Hub 🔥</span>
model = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:nateraw/resnet50-oxford-iiit-pet&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Set model to eval mode for inference</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># Create Transform</span>
transform = create_transform(**resolve_data_config(model.pretrained_cfg, model=model))

<span class="hljs-comment"># Get the labels from the model config</span>
labels = model.pretrained_cfg[<span class="hljs-string">&#x27;label_names&#x27;</span>]
top_k = <span class="hljs-built_in">min</span>(<span class="hljs-built_in">len</span>(labels), <span class="hljs-number">5</span>)

<span class="hljs-comment"># Use your own image file here...</span>
image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;boxer.jpg&#x27;</span>).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)

<span class="hljs-comment"># Process PIL image with transforms and add a batch dimension</span>
x = transform(image).unsqueeze(<span class="hljs-number">0</span>)

<span class="hljs-comment"># Pass inputs to model forward function to get outputs</span>
out = model(x)

<span class="hljs-comment"># Apply softmax to get predicted probabilities for each class</span>
probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)

<span class="hljs-comment"># Grab the values and indices of top 5 predicted classes</span>
values, indices = torch.topk(probabilities, top_k)

<span class="hljs-comment"># Prepare a nice dict of top k predictions</span>
predictions = [
    {<span class="hljs-string">&quot;label&quot;</span>: labels[i], <span class="hljs-string">&quot;score&quot;</span>: v.item()}
    <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(indices, values)
]
<span class="hljs-built_in">print</span>(predictions)`,wrap:!1}}),$=new F({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdhbWVyaWNhbl9waXRfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTk5OTg4MDc5MDcxMDQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ3N0YWZmb3Jkc2hpcmVfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdtaW5pYXR1cmVfcGluc2NoZXInJTJDJTIwJ3Njb3JlJyUzQSUyMDEuMDAwMDAwMDE0OTAxMTYxMmUtMDclN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ2NoaWh1YWh1YSclMkMlMjAnc2NvcmUnJTNBJTIwMS4wMDAwMDAwMTQ5MDExNjEyZS0wNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QidsYWJlbCclM0ElMjAnYmVhZ2xlJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTBBJTVE",highlighted:`[
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;american_pit_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9999998807907104</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;staffordshire_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;miniature_pinscher&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;chihuahua&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;beagle&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>}
]`,wrap:!1}}),H=new D({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),z=new F({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:`python -m pip install huggingface_hub
huggingface-cli login`,wrap:!1}}),_=new F({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()`,wrap:!1}}),Q=new F({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMEJ1aWxkJTIwb3IlMjBsb2FkJTIwYSUyMG1vZGVsJTJDJTIwZS5nLiUyMHRpbW0ncyUyMHByZXRyYWluZWQlMjByZXNuZXQxOCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0Q0KSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUwQSUyMyUyMCU1QkZpbmUlMjB0dW5lJTIweW91ciUyMG1vZGVsLi4uJTVEJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwUHVzaCUyMGl0JTIwdG8lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBIdWIlMEF0aW1tLm1vZGVscy5odWIucHVzaF90b19oZl9odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAncmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnJTNEJTdCJ2xhYmVscyclM0ElMjAlNUInYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclNUQlN0QlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMHlvdXIlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEFtb2RlbF9yZWxvYWRlZCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUwQSUyMCUyMCUyMCUyMCdoZi1odWIlM0ElM0N5b3VyLXVzZXJuYW1lJTNFJTJGcmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwcHJldHJhaW5lZCUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Build or load a model, e.g. timm&#x27;s pretrained resnet18</span>
model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">4</span>)

<span class="hljs-comment">###########################</span>
<span class="hljs-comment"># [Fine tune your model...]</span>
<span class="hljs-comment">###########################</span>

<span class="hljs-comment"># Push it to the 🤗 Hub</span>
timm.models.hub.push_to_hf_hub(
    model,
    <span class="hljs-string">&#x27;resnet18-random-classifier&#x27;</span>,
    model_config={<span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]}
)

<span class="hljs-comment"># Load your model from the Hub</span>
model_reloaded = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:&lt;your-username&gt;/resnet18-random-classifier&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)`,wrap:!1}}),E=new D({props:{title:"Inference Widget and API",local:"inference-widget-and-api",headingTag:"h2"}}),S=new F({props:{code:"Y3VybCUyMGh0dHBzJTNBJTJGJTJGYXBpLWluZmVyZW5jZS5odWdnaW5nZmFjZS5jbyUyRm1vZGVscyUyRm5hdGVyYXclMkZ0aW1tLXJlc25ldDUwLWJlYW5zJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLVglMjBQT1NUJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBiZWFucy5qcGVnJyUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCU3QiUyNEhGX0FQSV9UT0tFTiU3RCUyMiUwQSUyMyUyMCU1QiU3QiUyMmxhYmVsJTIyJTNBJTIyYW5ndWxhcl9sZWFmX3Nwb3QlMjIlMkMlMjJzY29yZSUyMiUzQTAuOTg0NTk0NzAyNzIwNjQyMSU3RCUyQyU3QiUyMmxhYmVsJTIyJTNBJTIyYmVhbl9ydXN0JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAxMzY4MzE1MDUyMjQxMDg3JTdEJTJDJTdCJTIybGFiZWwlMjIlM0ElMjJoZWFsdGh5JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAwMTcyMjA4NTg3MTczMzcyNSU3RCU1RA==",highlighted:`curl https://api-inference.huggingface.co/models/nateraw/timm-resnet50-beans \\
        -X POST \\
        --data-binary <span class="hljs-string">&#x27;@beans.jpeg&#x27;</span> \\
        -H <span class="hljs-string">&quot;Authorization: Bearer {<span class="hljs-variable">$HF_API_TOKEN</span>}&quot;</span>
<span class="hljs-comment"># [{&quot;label&quot;:&quot;angular_leaf_spot&quot;,&quot;score&quot;:0.9845947027206421},{&quot;label&quot;:&quot;bean_rust&quot;,&quot;score&quot;:0.01368315052241087},{&quot;label&quot;:&quot;healthy&quot;,&quot;score&quot;:0.001722085871733725}]</span>`,wrap:!1}}),L=new D({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),X=new ml({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/timm.md"}}),{c(){M=i("meta"),O=a(),q=i("p"),ee=a(),r(w.$$.fragment),le=a(),f=i("p"),f.innerHTML=ke,te=a(),g=i("p"),g.innerHTML=Ye,se=a(),b=i("p"),b.innerHTML=ze,ae=a(),U=i("p"),U.textContent=Ve,ne=a(),I=i("ol"),I.innerHTML=_e,ie=a(),r(j.$$.fragment),me=a(),W=i("p"),W.innerHTML=Ne,oe=a(),r(Z.$$.fragment),re=a(),B=i("p"),B.innerHTML=Qe,ce=a(),J=i("div"),J.innerHTML=Ee,pe=a(),T=i("div"),T.innerHTML=Ae,de=a(),r(x.$$.fragment),ye=a(),v=i("p"),v.innerHTML=Se,he=a(),r(G.$$.fragment),Me=a(),C=i("p"),C.textContent=Le,Je=a(),r($.$$.fragment),Te=a(),r(H.$$.fragment),ue=a(),k=i("p"),k.innerHTML=Re,we=a(),Y=i("p"),Y.textContent=Xe,fe=a(),r(z.$$.fragment),ge=a(),V=i("p"),V.innerHTML=Fe,be=a(),r(_.$$.fragment),Ue=a(),N=i("p"),N.innerHTML=De,Ie=a(),r(Q.$$.fragment),je=a(),r(E.$$.fragment),We=a(),A=i("p"),A.innerHTML=qe,Ze=a(),u=i("div"),u.innerHTML=Pe,Be=a(),r(S.$$.fragment),xe=a(),r(L.$$.fragment),ve=a(),R=i("ul"),R.innerHTML=Ke,Ge=a(),r(X.$$.fragment),Ce=a(),P=i("p"),this.h()},l(e){const l=nl("svelte-u9bgzb",document.head);M=m(l,"META",{name:!0,content:!0}),l.forEach(t),O=n(e),q=m(e,"P",{}),Oe(q).forEach(t),ee=n(e),c(w.$$.fragment,e),le=n(e),f=m(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1bz9zfk"&&(f.innerHTML=ke),te=n(e),g=m(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1b9kavw"&&(g.innerHTML=Ye),se=n(e),b=m(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-19ixdpv"&&(b.innerHTML=ze),ae=n(e),U=m(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1uvi03j"&&(U.textContent=Ve),ne=n(e),I=m(e,"OL",{"data-svelte-h":!0}),o(I)!=="svelte-1dns05d"&&(I.innerHTML=_e),ie=n(e),c(j.$$.fragment,e),me=n(e),W=m(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-19q2wuk"&&(W.innerHTML=Ne),oe=n(e),c(Z.$$.fragment,e),re=n(e),B=m(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1dv22ye"&&(B.innerHTML=Qe),ce=n(e),J=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-y8p227"&&(J.innerHTML=Ee),pe=n(e),T=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1xvepxr"&&(T.innerHTML=Ae),de=n(e),c(x.$$.fragment,e),ye=n(e),v=m(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-4jjk9c"&&(v.innerHTML=Se),he=n(e),c(G.$$.fragment,e),Me=n(e),C=m(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1hfr7cw"&&(C.textContent=Le),Je=n(e),c($.$$.fragment,e),Te=n(e),c(H.$$.fragment,e),ue=n(e),k=m(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1m2yz24"&&(k.innerHTML=Re),we=n(e),Y=m(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ixi9lc"&&(Y.textContent=Xe),fe=n(e),c(z.$$.fragment,e),ge=n(e),V=m(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-19plf33"&&(V.innerHTML=Fe),be=n(e),c(_.$$.fragment,e),Ue=n(e),N=m(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-13bqgmd"&&(N.innerHTML=De),Ie=n(e),c(Q.$$.fragment,e),je=n(e),c(E.$$.fragment,e),We=n(e),A=m(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1suwl6q"&&(A.innerHTML=qe),Ze=n(e),u=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-11rs1r3"&&(u.innerHTML=Pe),Be=n(e),c(S.$$.fragment,e),xe=n(e),c(L.$$.fragment,e),ve=n(e),R=m(e,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1o8g6cw"&&(R.innerHTML=Ke),Ge=n(e),c(X.$$.fragment,e),Ce=n(e),P=m(e,"P",{}),Oe(P).forEach(t),this.h()},h(){K(M,"name","hf:doc:metadata"),K(M,"content",rl),K(J,"class","flex justify-center"),K(T,"class","flex justify-center"),K(u,"class","flex justify-center")},m(e,l){il(document.head,M),s(e,O,l),s(e,q,l),s(e,ee,l),p(w,e,l),s(e,le,l),s(e,f,l),s(e,te,l),s(e,g,l),s(e,se,l),s(e,b,l),s(e,ae,l),s(e,U,l),s(e,ne,l),s(e,I,l),s(e,ie,l),p(j,e,l),s(e,me,l),s(e,W,l),s(e,oe,l),p(Z,e,l),s(e,re,l),s(e,B,l),s(e,ce,l),s(e,J,l),s(e,pe,l),s(e,T,l),s(e,de,l),p(x,e,l),s(e,ye,l),s(e,v,l),s(e,he,l),p(G,e,l),s(e,Me,l),s(e,C,l),s(e,Je,l),p($,e,l),s(e,Te,l),p(H,e,l),s(e,ue,l),s(e,k,l),s(e,we,l),s(e,Y,l),s(e,fe,l),p(z,e,l),s(e,ge,l),s(e,V,l),s(e,be,l),p(_,e,l),s(e,Ue,l),s(e,N,l),s(e,Ie,l),p(Q,e,l),s(e,je,l),p(E,e,l),s(e,We,l),s(e,A,l),s(e,Ze,l),s(e,u,l),s(e,Be,l),p(S,e,l),s(e,xe,l),p(L,e,l),s(e,ve,l),s(e,R,l),s(e,Ge,l),p(X,e,l),s(e,Ce,l),s(e,P,l),$e=!0},p:ll,i(e){$e||(d(w.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(x.$$.fragment,e),d(G.$$.fragment,e),d($.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(_.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(L.$$.fragment,e),d(X.$$.fragment,e),$e=!0)},o(e){y(w.$$.fragment,e),y(j.$$.fragment,e),y(Z.$$.fragment,e),y(x.$$.fragment,e),y(G.$$.fragment,e),y($.$$.fragment,e),y(H.$$.fragment,e),y(z.$$.fragment,e),y(_.$$.fragment,e),y(Q.$$.fragment,e),y(E.$$.fragment,e),y(S.$$.fragment,e),y(L.$$.fragment,e),y(X.$$.fragment,e),$e=!1},d(e){e&&(t(O),t(q),t(ee),t(le),t(f),t(te),t(g),t(se),t(b),t(ae),t(U),t(ne),t(I),t(ie),t(me),t(W),t(oe),t(re),t(B),t(ce),t(J),t(pe),t(T),t(de),t(ye),t(v),t(he),t(Me),t(C),t(Je),t(Te),t(ue),t(k),t(we),t(Y),t(fe),t(ge),t(V),t(be),t(Ue),t(N),t(Ie),t(je),t(We),t(A),t(Ze),t(u),t(Be),t(xe),t(ve),t(R),t(Ge),t(Ce),t(P)),t(M),h(w,e),h(j,e),h(Z,e),h(x,e),h(G,e),h($,e),h(H,e),h(z,e),h(_,e),h(Q,e),h(E,e),h(S,e),h(L,e),h(X,e)}}}const rl='{"title":"Using timm at Hugging Face","local":"using-timm-at-hugging-face","sections":[{"title":"Using existing models from the Hub","local":"using-existing-models-from-the-hub","sections":[{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Inference Widget and API","local":"inference-widget-and-api","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function cl(He){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends sl{constructor(M){super(),al(this,M,cl,ol,el,{})}}export{Ml as component};
