import{s as He,n as We,o as Ze}from"../chunks/scheduler.d6170356.js";import{S as Ge,i as Ve,g as o,s as n,r as p,A as Be,h as i,f as a,c as l,j as je,u as d,x as r,k as ue,y as ze,a as s,v as f,d as c,t as u,w as g}from"../chunks/index.fcd4cc08.js";import{C as ge}from"../chunks/CodeBlock.db16bf50.js";import{H as X,E as Le}from"../chunks/index.c1f68a2b.js";function Re(he){let m,q,L,F,w,E,b,ye="🤗 <code>transformers</code> is a library maintained by Hugging Face and the community, for state-of-the-art Machine Learning for Pytorch, TensorFlow and JAX. It provides thousands of pretrained models to perform tasks on different modalities such as text, vision, and audio. We are a bit biased, but we really like 🤗 <code>transformers</code>!",P,T,Q,M,we='There are over 25,000 <code>transformers</code> models in the Hub which you can find by filtering at the left of <a href="https://huggingface.co/models?library=transformers&amp;sort=downloads" rel="nofollow">the models page</a>.',S,$,be="You can find models for many different tasks:",Y,J,Te='<li>Extracting the answer from a context (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=question-answering&amp;sort=downloads" rel="nofollow">question-answering</a>).</li> <li>Creating summaries from a large text (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=summarization&amp;sort=downloads" rel="nofollow">summarization</a>).</li> <li>Classify text (e.g. as spam or not spam, <a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=text-classification&amp;sort=downloads" rel="nofollow">text-classification</a>).</li> <li>Generate a new text with models such as GPT (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=text-generation&amp;sort=downloads" rel="nofollow">text-generation</a>).</li> <li>Identify parts of speech (verb, subject, etc.) or entities (country, organization, etc.) in a sentence (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=token-classification&amp;sort=downloads" rel="nofollow">token-classification</a>).</li> <li>Transcribe audio files to text (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=automatic-speech-recognition&amp;sort=downloads" rel="nofollow">automatic-speech-recognition</a>).</li> <li>Classify the speaker or language in an audio file (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=audio-classification&amp;sort=downloads" rel="nofollow">audio-classification</a>).</li> <li>Detect objects in an image (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=object-detection&amp;sort=downloads" rel="nofollow">object-detection</a>).</li> <li>Segment an image (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=image-segmentation&amp;sort=downloads" rel="nofollow">image-segmentation</a>).</li> <li>Do Reinforcement Learning (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=reinforcement-learning&amp;sort=downloads" rel="nofollow">reinforcement-learning</a>)!</li>',A,v,Me="You can try out the models directly in the browser if you want to test them out without downloading them thanks to the in-browser widgets!",N,h,$e='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_widget-dark.png"/>',D,I,K,U,Je="All <code>transformer</code> models are a line away from being used! Depending on how you want to use them, you can use the high-level API using the <code>pipeline</code> function or you can use <code>AutoModel</code> for more control.",O,k,ee,_,ve="You can also load a model from a specific version (based on commit hash, tag name, or branch) as follows:",te,x,ae,C,Ie="If you want to see how to load a specific model, you can click <code>Use in Transformers</code> and you will be given a working snippet that you can load it! If you need further information about the model architecture, you can also click the “Read model documentation” at the bottom of the snippet.",se,y,Ue='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_snippet.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_snippet-dark.png"/>',ne,j,le,H,ke='To read all about sharing models with <code>transformers</code>, please head out to the <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">Share a model</a> guide in the official documentation.',oe,W,_e="Many classes in <code>transformers</code>, such as the models and tokenizers, have a <code>push_to_hub</code> method that allows to easily upload the files to a repository.",ie,Z,re,G,xe='There is much more you can do, so we suggest to review the <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">Share a model</a> guide.',me,V,pe,B,Ce='<li>Transformers <a href="https://github.com/huggingface/transformers" rel="nofollow">library</a>.</li> <li>Transformers <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">docs</a>.</li> <li>Share a model <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">guide</a>.</li>',de,z,fe,R,ce;return w=new X({props:{title:"Using 🤗 transformers at Hugging Face",local:"using--transformers-at-hugging-face",headingTag:"h1"}}),T=new X({props:{title:"Exploring 🤗 transformers in the Hub",local:"exploring--transformers-in-the-hub",headingTag:"h2"}}),I=new X({props:{title:"Using existing models",local:"using-existing-models",headingTag:"h2"}}),k=new ge({props:{code:"JTIzJTIwV2l0aCUyMHBpcGVsaW5lJTJDJTIwanVzdCUyMHNwZWNpZnklMjB0aGUlMjB0YXNrJTIwYW5kJTIwdGhlJTIwbW9kZWwlMjBpZCUyMGZyb20lMjB0aGUlMjBIdWIuJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBJTIzJTIwSWYlMjB5b3UlMjB3YW50JTIwbW9yZSUyMGNvbnRyb2wlMkMlMjB5b3UlMjB3aWxsJTIwbmVlZCUyMHRvJTIwZGVmaW5lJTIwdGhlJTIwdG9rZW5pemVyJTIwYW5kJTIwbW9kZWwuJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-comment"># With pipeline, just specify the task and the model id from the Hub.</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-comment"># If you want more control, you will need to define the tokenizer and model.</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)`,wrap:!1}}),x=new ge({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmp1bGllbi1jJTJGRXNwZXJCRVJUby1zbWFsbCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjIuMC4xJTIyJTIwJTIwJTIzJTIwdGFnJTIwbmFtZSUyQyUyMG9yJTIwYnJhbmNoJTIwbmFtZSUyQyUyMG9yJTIwY29tbWl0JTIwaGFzaCUwQSk=",highlighted:`model = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;julien-c/EsperBERTo-small&quot;</span>, revision=<span class="hljs-string">&quot;v2.0.1&quot;</span>  <span class="hljs-comment"># tag name, or branch name, or commit hash</span>
)`,wrap:!1}}),j=new X({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),Z=new ge({props:{code:"JTIzJTIwUHVzaGluZyUyMG1vZGVsJTIwdG8lMjB5b3VyJTIwb3duJTIwYWNjb3VudCUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBJTIzJTIwUHVzaGluZyUyMHlvdXIlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMEElMjMlMjBQdXNoaW5nJTIwYWxsJTIwdGhpbmdzJTIwYWZ0ZXIlMjB0cmFpbmluZyUwQXRyYWluZXIucHVzaF90b19odWIoKQ==",highlighted:`<span class="hljs-comment"># Pushing model to your own account</span>
model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Pushing your tokenizer</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Pushing all things after training</span>
trainer.push_to_hub()`,wrap:!1}}),V=new X({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),z=new Le({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/transformers.md"}}),{c(){m=o("meta"),q=n(),L=o("p"),F=n(),p(w.$$.fragment),E=n(),b=o("p"),b.innerHTML=ye,P=n(),p(T.$$.fragment),Q=n(),M=o("p"),M.innerHTML=we,S=n(),$=o("p"),$.textContent=be,Y=n(),J=o("ul"),J.innerHTML=Te,A=n(),v=o("p"),v.textContent=Me,N=n(),h=o("div"),h.innerHTML=$e,D=n(),p(I.$$.fragment),K=n(),U=o("p"),U.innerHTML=Je,O=n(),p(k.$$.fragment),ee=n(),_=o("p"),_.textContent=ve,te=n(),p(x.$$.fragment),ae=n(),C=o("p"),C.innerHTML=Ie,se=n(),y=o("div"),y.innerHTML=Ue,ne=n(),p(j.$$.fragment),le=n(),H=o("p"),H.innerHTML=ke,oe=n(),W=o("p"),W.innerHTML=_e,ie=n(),p(Z.$$.fragment),re=n(),G=o("p"),G.innerHTML=xe,me=n(),p(V.$$.fragment),pe=n(),B=o("ul"),B.innerHTML=Ce,de=n(),p(z.$$.fragment),fe=n(),R=o("p"),this.h()},l(e){const t=Be("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(a),q=l(e),L=i(e,"P",{}),je(L).forEach(a),F=l(e),d(w.$$.fragment,e),E=l(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-rpg67t"&&(b.innerHTML=ye),P=l(e),d(T.$$.fragment,e),Q=l(e),M=i(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-o4uiyf"&&(M.innerHTML=we),S=l(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-qpj6j"&&($.textContent=be),Y=l(e),J=i(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-qjs9xt"&&(J.innerHTML=Te),A=l(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-apziil"&&(v.textContent=Me),N=l(e),h=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-435q1z"&&(h.innerHTML=$e),D=l(e),d(I.$$.fragment,e),K=l(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1gtg5ls"&&(U.innerHTML=Je),O=l(e),d(k.$$.fragment,e),ee=l(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-3407pd"&&(_.textContent=ve),te=l(e),d(x.$$.fragment,e),ae=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1quwgdt"&&(C.innerHTML=Ie),se=l(e),y=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-125odup"&&(y.innerHTML=Ue),ne=l(e),d(j.$$.fragment,e),le=l(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1qw74m4"&&(H.innerHTML=ke),oe=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1e42a6j"&&(W.innerHTML=_e),ie=l(e),d(Z.$$.fragment,e),re=l(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-t0bbcx"&&(G.innerHTML=xe),me=l(e),d(V.$$.fragment,e),pe=l(e),B=i(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1n31o8y"&&(B.innerHTML=Ce),de=l(e),d(z.$$.fragment,e),fe=l(e),R=i(e,"P",{}),je(R).forEach(a),this.h()},h(){ue(m,"name","hf:doc:metadata"),ue(m,"content",Xe),ue(h,"class","flex justify-center"),ue(y,"class","flex justify-center")},m(e,t){ze(document.head,m),s(e,q,t),s(e,L,t),s(e,F,t),f(w,e,t),s(e,E,t),s(e,b,t),s(e,P,t),f(T,e,t),s(e,Q,t),s(e,M,t),s(e,S,t),s(e,$,t),s(e,Y,t),s(e,J,t),s(e,A,t),s(e,v,t),s(e,N,t),s(e,h,t),s(e,D,t),f(I,e,t),s(e,K,t),s(e,U,t),s(e,O,t),f(k,e,t),s(e,ee,t),s(e,_,t),s(e,te,t),f(x,e,t),s(e,ae,t),s(e,C,t),s(e,se,t),s(e,y,t),s(e,ne,t),f(j,e,t),s(e,le,t),s(e,H,t),s(e,oe,t),s(e,W,t),s(e,ie,t),f(Z,e,t),s(e,re,t),s(e,G,t),s(e,me,t),f(V,e,t),s(e,pe,t),s(e,B,t),s(e,de,t),f(z,e,t),s(e,fe,t),s(e,R,t),ce=!0},p:We,i(e){ce||(c(w.$$.fragment,e),c(T.$$.fragment,e),c(I.$$.fragment,e),c(k.$$.fragment,e),c(x.$$.fragment,e),c(j.$$.fragment,e),c(Z.$$.fragment,e),c(V.$$.fragment,e),c(z.$$.fragment,e),ce=!0)},o(e){u(w.$$.fragment,e),u(T.$$.fragment,e),u(I.$$.fragment,e),u(k.$$.fragment,e),u(x.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(V.$$.fragment,e),u(z.$$.fragment,e),ce=!1},d(e){e&&(a(q),a(L),a(F),a(E),a(b),a(P),a(Q),a(M),a(S),a($),a(Y),a(J),a(A),a(v),a(N),a(h),a(D),a(K),a(U),a(O),a(ee),a(_),a(te),a(ae),a(C),a(se),a(y),a(ne),a(le),a(H),a(oe),a(W),a(ie),a(re),a(G),a(me),a(pe),a(B),a(de),a(fe),a(R)),a(m),g(w,e),g(T,e),g(I,e),g(k,e),g(x,e),g(j,e),g(Z,e),g(V,e),g(z,e)}}}const Xe='{"title":"Using 🤗 transformers at Hugging Face","local":"using--transformers-at-hugging-face","sections":[{"title":"Exploring 🤗 transformers in the Hub","local":"exploring--transformers-in-the-hub","sections":[],"depth":2},{"title":"Using existing models","local":"using-existing-models","sections":[],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function qe(he){return Ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Se extends Ge{constructor(m){super(),Ve(this,m,qe,Re,He,{})}}export{Se as component};
