import{s as he,n as ue,o as me}from"../chunks/scheduler.d6170356.js";import{S as ce,i as de,g as i,s as l,r as p,A as ye,h as o,f as a,c as n,j as pe,u as r,x as f,k as re,y as ge,a as s,v as h,d as u,t as m,w as c}from"../chunks/index.fcd4cc08.js";import{C as E}from"../chunks/CodeBlock.db16bf50.js";import{H as K,E as we}from"../chunks/index.c1f68a2b.js";function Me(zt){let d,at,tt,st,y,lt,g,Lt=`FiftyOne is an open-source toolkit for curating, visualizing, and
managing unstructured visual data. The library streamlines data-centric
workflows, from finding low-confidence predictions to identifying poor-quality
samples and uncovering hidden patterns in your data. The library supports all
sorts of visual data, from images and videos to PDFs, point clouds, and meshes.`,nt,w,Yt="FiftyOne accommodates object detections, keypoints, polylines, and custom schemas.",it,M,St=`FiftyOne is integrated with the Hugging Face Hub so that you can load and share
FiftyOne datasets directly from the Hub.`,ot,b,Pt='🚀 Try the FiftyOne 🤝 Hugging Face Integration in <a href="https://colab.research.google.com/drive/1l0kzfbJ2wtUw1EGS1tq1PJYoWenMlihp?usp=sharing" rel="nofollow">Colab</a>!',ft,T,pt,U,Rt='First <a href="/docs/huggingface_hub/quick-start#login">login with your Hugging Face account</a>:',rt,J,ht,$,Vt="Make sure you have <code>fiftyone&gt;=0.24.0</code> installed:",ut,j,mt,v,ct,C,At="With <code>load_from_hub()</code> from FiftyOne’s Hugging Face utils, you can load:",dt,I,Ot="<li>Any FiftyOne dataset uploaded to the hub</li> <li>Most image-based datasets stored in Parquet files (which is the standard for datasets uploaded to the hub via the <code>datasets</code> library)</li>",yt,_,gt,k,Nt=`Any dataset pushed to the hub in one of FiftyOne’s <a href="https://docs.voxel51.com/user_guide/dataset_creation/datasets.html#supported-import-formats" rel="nofollow">supported common formats</a>
should have all of the necessary configuration info in its dataset repo on the
hub, so you can load the dataset by specifying its <code>repo_id</code>. As an example, to
load the <a href="https://huggingface.co/datasets/Voxel51/VisDrone2019-DET" rel="nofollow">VisDrone detection dataset</a>:`,wt,F,Mt,Z,Dt='<img src="https://cdn-uploads.huggingface.co/production/uploads/63127e2495407887cb79c5ea/0eKxe_GSsBjt8wMjT9qaI.jpeg" alt="FiftyOne VisDrone dataset"/>',bt,H,Et=`You can <a href="https://docs.voxel51.com/integrations/huggingface.html#configuring-the-download-process" rel="nofollow">customize the download process</a>, including the number of samples to
download, the name of the created dataset object, or whether or not it is persisted
to disk.`,Tt,x,Kt="You can list all the available FiftyOne datasets on the Hub using:",Ut,B,Jt,G,$t,q,te=`You can also use the <code>load_from_hub()</code> function to load datasets from Parquet
files. Type conversions are handled for you, and images are downloaded from URLs
if necessary.`,jt,Q,ee='With this functionality, <a href="https://docs.voxel51.com/integrations/huggingface.html#basic-examples" rel="nofollow">you can load</a> any of the following:',vt,W,ae='<li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-image-classification-datasets-665dfd51020d8b66a56c9b6f" rel="nofollow">FiftyOne-Compatible Image Classification Datasets</a>, like <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food101</a> and <a href="https://huggingface.co/datasets/imagenet_sketch" rel="nofollow">ImageNet-Sketch</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-object-detection-datasets-665e0279c94ae552c7159a2b" rel="nofollow">FiftyOne-Compatible Object Detection Datasets</a> like <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5</a> and <a href="https://huggingface.co/datasets/wider_face" rel="nofollow">WIDER FACE</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-image-segmentation-datasets-665e15b6ddb96a4d7226a380" rel="nofollow">FiftyOne-Compatible Segmentation Datasets</a> like <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">SceneParse150</a> and <a href="https://huggingface.co/datasets/segments/sidewalk-semantic" rel="nofollow">Sidewalk Semantic</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-image-captioning-datasets-665e16e29350244c06084505" rel="nofollow">FiftyOne-Compatible Image Captioning Datasets</a> like <a href="https://huggingface.co/datasets/kakaobrain/coyo-700m" rel="nofollow">COYO-700M</a> and <a href="https://huggingface.co/datasets/jmhessel/newyorker_caption_contest" rel="nofollow">New Yorker Caption Contest</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-vqa-datasets-665e16424ecc8a718156248a" rel="nofollow">FiftyOne-Compatible Visual Question-Answering Datasets</a> like <a href="https://huggingface.co/datasets/textvqa" rel="nofollow">TextVQA</a> and <a href="https://huggingface.co/datasets/derek-thomas/ScienceQA" rel="nofollow">ScienceQA</a></li>',Ct,X,se=`As an example, we can load the first 1,000 samples from the
<a href="https://huggingface.co/datasets/huggan/wikiart" rel="nofollow">WikiArt dataset</a> into FiftyOne with:`,It,z,_t,L,le='<img src="https://cdn-uploads.huggingface.co/production/uploads/63127e2495407887cb79c5ea/PCqCvTlNTG5SLtcK5fwuQ.jpeg" alt="WikiArt Dataset"/>',kt,Y,Ft,S,ne="You can push a dataset to the hub with:",Zt,P,Ht,R,ie=`When you call <code>push_to_hub()</code>, the dataset will be uploaded to the repo
with the specified repo name under your username, and the repo will be created
if necessary. A <a href="./datasets-cards">Dataset Card</a> will automatically be generated and populated with instructions for loading the dataset from the hub. You can upload a thumbnail image/gif to appear on the Dataset Card with the <code>preview_path</code> argument.`,xt,V,oe='Here’s an example using many of these arguments, which would upload the first three samples of FiftyOne’s <a href="https://docs.voxel51.com/user_guide/dataset_zoo/datasets.html#quickstart-video" rel="nofollow">Quickstart Video</a> dataset to the private repo <code>username/my-quickstart-video-dataset</code> with tags, an MIT license, a description, and a preview image:',Bt,A,Gt,O,qt,N,fe='<li><a href="https://colab.research.google.com/drive/1l0kzfbJ2wtUw1EGS1tq1PJYoWenMlihp?usp=sharing" rel="nofollow">🚀 Code-Along Colab Notebook</a></li> <li><a href="https://docs.voxel51.com/user_guide/using_datasets.html#" rel="nofollow">🗺️ User Guide for FiftyOne Datasets</a></li> <li><a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">🤗 FiftyOne 🤝 Hub Integration Docs</a></li> <li><a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library" rel="nofollow">🤗 FiftyOne 🤝 Transformers Integration Docs</a></li> <li><a href="https://github.com/voxel51/fiftyone-huggingface-plugins" rel="nofollow">🧩 FiftyOne Hugging Face Hub Plugin</a></li>',Qt,D,Wt,et,Xt;return y=new K({props:{title:"FiftyOne",local:"fiftyone",headingTag:"h1"}}),T=new K({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),J=new E({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),j=new E({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmlmdHlvbmU=",highlighted:"pip install -U fiftyone",wrap:!1}}),v=new K({props:{title:"Loading Visual Datasets from the Hub",local:"loading-visual-datasets-from-the-hub",headingTag:"h2"}}),_=new K({props:{title:"Loading FiftyOne datasets from the Hub",local:"loading-fiftyone-datasets-from-the-hub",headingTag:"h3"}}),F=new E({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTBBZnJvbSUyMGZpZnR5b25lLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2h1YiUwQSUwQSUyMyUyMyUyMGxvYWQlMjBmcm9tJTIwdGhlJTIwaHViJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZnJvbV9odWIoJTIyVm94ZWw1MSUyRlZpc0Ryb25lMjAxOS1ERVQlMjIpJTBBJTBBJTIzJTIzJTIwdmlzdWFsaXplJTIwaW4lMjBhcHAlMEFzZXNzaW9uJTIwJTNEJTIwZm8ubGF1bmNoX2FwcChkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo
<span class="hljs-keyword">from</span> fiftyone.utils <span class="hljs-keyword">import</span> load_from_hub

<span class="hljs-comment">## load from the hub</span>
dataset = load_from_hub(<span class="hljs-string">&quot;Voxel51/VisDrone2019-DET&quot;</span>)

<span class="hljs-comment">## visualize in app</span>
session = fo.launch_app(dataset)`,wrap:!1}}),B=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X2RhdGFzZXRzKHRhZ3MlM0QlMjJmaWZ0eW9uZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()
api.list_datasets(tags=<span class="hljs-string">&quot;fiftyone&quot;</span>)`,wrap:!1}}),G=new K({props:{title:"Loading Parquet Datasets from the Hub with FiftyOne",local:"loading-parquet-datasets-from-the-hub-with-fiftyone",headingTag:"h3"}}),z=new E({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTBBZnJvbSUyMGZpZnR5b25lLnV0aWxzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2h1YiUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2Zyb21faHViKCUwQSUyMCUyMCUyMCUyMCUyMmh1Z2dhbiUyRndpa2lhcnQlMjIlMkMlMjAlMjAlMjMlMjMlMjByZXBvX2lkJTBBJTIwJTIwJTIwJTIwZm9ybWF0JTNEJTIycGFycXVldCUyMiUyQyUyMCUyMCUyMyUyMyUyMGZvciUyMFBhcnF1ZXQlMjBmb3JtYXQlMEElMjAlMjAlMjAlMjBjbGFzc2lmaWNhdGlvbl9maWVsZHMlM0QlNUIlMjJhcnRpc3QlMjIlMkMlMjAlMjJzdHlsZSUyMiUyQyUyMCUyMmdlbnJlJTIyJTVEJTJDJTIwJTIzJTIzJTIwY29sdW1ucyUyMHRvJTIwdHJlYXQlMjBhcyUyMGNsYXNzaWZpY2F0aW9uJTIwbGFiZWxzJTBBJTIwJTIwJTIwJTIwbWF4X3NhbXBsZXMlM0QxMDAwJTJDJTIwJTIwJTIzJTIwbnVtYmVyJTIwb2YlMjBzYW1wbGVzJTIwdG8lMjBsb2FkJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndpa2lhcnQlMjIlMkMlMjAlMjAlMjMlMjBuYW1lJTIwb2YlMjB0aGUlMjBkYXRhc2V0JTIwaW4lMjBGaWZ0eU9uZSUwQSk=",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo
<span class="hljs-keyword">from</span> fiftyone.utils.huggingface <span class="hljs-keyword">import</span> load_from_hub

dataset = load_from_hub(
    <span class="hljs-string">&quot;huggan/wikiart&quot;</span>,  <span class="hljs-comment">## repo_id</span>
    <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;parquet&quot;</span>,  <span class="hljs-comment">## for Parquet format</span>
    classification_fields=[<span class="hljs-string">&quot;artist&quot;</span>, <span class="hljs-string">&quot;style&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>], <span class="hljs-comment">## columns to treat as classification labels</span>
    max_samples=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># number of samples to load</span>
    name=<span class="hljs-string">&quot;wikiart&quot;</span>,  <span class="hljs-comment"># name of the dataset in FiftyOne</span>
)`,wrap:!1}}),Y=new K({props:{title:"Pushing FiftyOne Datasets to the Hub",local:"pushing-fiftyone-datasets-to-the-hub",headingTag:"h2"}}),P=new E({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTBBaW1wb3J0JTIwZmlmdHlvbmUuem9vJTIwYXMlMjBmb3olMEFmcm9tJTIwZmlmdHlvbmUudXRpbHMuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBwdXNoX3RvX2h1YiUwQSUwQSUyMyUyMyUyMGxvYWQlMjBleGFtcGxlJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBmb3oubG9hZF96b29fZGF0YXNldCglMjJxdWlja3N0YXJ0JTIyKSUwQSUwQSUyMyUyMyUyMHB1c2glMjB0byUyMGh1YiUwQXB1c2hfdG9faHViKGRhdGFzZXQlMkMlMjAlMjJteS1oZi1kYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo
<span class="hljs-keyword">import</span> fiftyone.zoo <span class="hljs-keyword">as</span> foz
<span class="hljs-keyword">from</span> fiftyone.utils.huggingface <span class="hljs-keyword">import</span> push_to_hub

<span class="hljs-comment">## load example dataset</span>
dataset = foz.load_zoo_dataset(<span class="hljs-string">&quot;quickstart&quot;</span>)

<span class="hljs-comment">## push to hub</span>
push_to_hub(dataset, <span class="hljs-string">&quot;my-hf-dataset&quot;</span>)`,wrap:!1}}),A=new E({props:{code:"ZGF0YXNldCUyMCUzRCUyMGZvei5sb2FkX2Zyb21fem9vKCUyMnF1aWNrc3RhcnQtdmlkZW8lMjIlMkMlMjBtYXhfc2FtcGxlcyUzRDMpJTBBJTBBcHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMm15LXF1aWNrc3RhcnQtdmlkZW8tZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhZ3MlM0QlNUIlMjJ2aWRlbyUyMiUyQyUyMCUyMnRyYWNraW5nJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGljZW5zZSUzRCUyMm1pdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyQSUyMGRhdGFzZXQlMjBvZiUyMHZpZGVvJTIwc2FtcGxlcyUyMGZvciUyMHRyYWNraW5nJTIwdGFza3MlMjIlMkMlMEElMjAlMjAlMjAlMjBwcml2YXRlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByZXZpZXdfcGF0aCUzRCUyMiUzQ3BhdGglMkZ0byUyRnByZXZpZXcucG5nJTNFJTIyJTBBKQ==",highlighted:`dataset = foz.load_from_zoo(<span class="hljs-string">&quot;quickstart-video&quot;</span>, max_samples=<span class="hljs-number">3</span>)

push_to_hub(
    dataset,
    <span class="hljs-string">&quot;my-quickstart-video-dataset&quot;</span>,
    tags=[<span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;tracking&quot;</span>],
    license=<span class="hljs-string">&quot;mit&quot;</span>,
    description=<span class="hljs-string">&quot;A dataset of video samples for tracking tasks&quot;</span>,
    private=<span class="hljs-literal">True</span>,
    preview_path=<span class="hljs-string">&quot;&lt;path/to/preview.png&gt;&quot;</span>
)`,wrap:!1}}),O=new K({props:{title:"📚 Resources",local:"-resources",headingTag:"h2"}}),D=new we({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-fiftyone.md"}}),{c(){d=i("meta"),at=l(),tt=i("p"),st=l(),p(y.$$.fragment),lt=l(),g=i("p"),g.textContent=Lt,nt=l(),w=i("p"),w.textContent=Yt,it=l(),M=i("p"),M.textContent=St,ot=l(),b=i("p"),b.innerHTML=Pt,ft=l(),p(T.$$.fragment),pt=l(),U=i("p"),U.innerHTML=Rt,rt=l(),p(J.$$.fragment),ht=l(),$=i("p"),$.innerHTML=Vt,ut=l(),p(j.$$.fragment),mt=l(),p(v.$$.fragment),ct=l(),C=i("p"),C.innerHTML=At,dt=l(),I=i("ul"),I.innerHTML=Ot,yt=l(),p(_.$$.fragment),gt=l(),k=i("p"),k.innerHTML=Nt,wt=l(),p(F.$$.fragment),Mt=l(),Z=i("p"),Z.innerHTML=Dt,bt=l(),H=i("p"),H.innerHTML=Et,Tt=l(),x=i("p"),x.textContent=Kt,Ut=l(),p(B.$$.fragment),Jt=l(),p(G.$$.fragment),$t=l(),q=i("p"),q.innerHTML=te,jt=l(),Q=i("p"),Q.innerHTML=ee,vt=l(),W=i("ul"),W.innerHTML=ae,Ct=l(),X=i("p"),X.innerHTML=se,It=l(),p(z.$$.fragment),_t=l(),L=i("p"),L.innerHTML=le,kt=l(),p(Y.$$.fragment),Ft=l(),S=i("p"),S.textContent=ne,Zt=l(),p(P.$$.fragment),Ht=l(),R=i("p"),R.innerHTML=ie,xt=l(),V=i("p"),V.innerHTML=oe,Bt=l(),p(A.$$.fragment),Gt=l(),p(O.$$.fragment),qt=l(),N=i("ul"),N.innerHTML=fe,Qt=l(),p(D.$$.fragment),Wt=l(),et=i("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);d=o(e,"META",{name:!0,content:!0}),e.forEach(a),at=n(t),tt=o(t,"P",{}),pe(tt).forEach(a),st=n(t),r(y.$$.fragment,t),lt=n(t),g=o(t,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1lbj1j1"&&(g.textContent=Lt),nt=n(t),w=o(t,"P",{"data-svelte-h":!0}),f(w)!=="svelte-v8ipou"&&(w.textContent=Yt),it=n(t),M=o(t,"P",{"data-svelte-h":!0}),f(M)!=="svelte-u1792m"&&(M.textContent=St),ot=n(t),b=o(t,"P",{"data-svelte-h":!0}),f(b)!=="svelte-18tv8ix"&&(b.innerHTML=Pt),ft=n(t),r(T.$$.fragment,t),pt=n(t),U=o(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1klrxm4"&&(U.innerHTML=Rt),rt=n(t),r(J.$$.fragment,t),ht=n(t),$=o(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-qry4me"&&($.innerHTML=Vt),ut=n(t),r(j.$$.fragment,t),mt=n(t),r(v.$$.fragment,t),ct=n(t),C=o(t,"P",{"data-svelte-h":!0}),f(C)!=="svelte-11kuu8j"&&(C.innerHTML=At),dt=n(t),I=o(t,"UL",{"data-svelte-h":!0}),f(I)!=="svelte-1sagvnm"&&(I.innerHTML=Ot),yt=n(t),r(_.$$.fragment,t),gt=n(t),k=o(t,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1hvs1ou"&&(k.innerHTML=Nt),wt=n(t),r(F.$$.fragment,t),Mt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1gciz6k"&&(Z.innerHTML=Dt),bt=n(t),H=o(t,"P",{"data-svelte-h":!0}),f(H)!=="svelte-13ii0ew"&&(H.innerHTML=Et),Tt=n(t),x=o(t,"P",{"data-svelte-h":!0}),f(x)!=="svelte-161ahsi"&&(x.textContent=Kt),Ut=n(t),r(B.$$.fragment,t),Jt=n(t),r(G.$$.fragment,t),$t=n(t),q=o(t,"P",{"data-svelte-h":!0}),f(q)!=="svelte-3fd0el"&&(q.innerHTML=te),jt=n(t),Q=o(t,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1oaxjb2"&&(Q.innerHTML=ee),vt=n(t),W=o(t,"UL",{"data-svelte-h":!0}),f(W)!=="svelte-1nyb7sq"&&(W.innerHTML=ae),Ct=n(t),X=o(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-qu37sz"&&(X.innerHTML=se),It=n(t),r(z.$$.fragment,t),_t=n(t),L=o(t,"P",{"data-svelte-h":!0}),f(L)!=="svelte-66fdrc"&&(L.innerHTML=le),kt=n(t),r(Y.$$.fragment,t),Ft=n(t),S=o(t,"P",{"data-svelte-h":!0}),f(S)!=="svelte-18rtwtv"&&(S.textContent=ne),Zt=n(t),r(P.$$.fragment,t),Ht=n(t),R=o(t,"P",{"data-svelte-h":!0}),f(R)!=="svelte-d3czo4"&&(R.innerHTML=ie),xt=n(t),V=o(t,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1hnqaln"&&(V.innerHTML=oe),Bt=n(t),r(A.$$.fragment,t),Gt=n(t),r(O.$$.fragment,t),qt=n(t),N=o(t,"UL",{"data-svelte-h":!0}),f(N)!=="svelte-16wm5ae"&&(N.innerHTML=fe),Qt=n(t),r(D.$$.fragment,t),Wt=n(t),et=o(t,"P",{}),pe(et).forEach(a),this.h()},h(){re(d,"name","hf:doc:metadata"),re(d,"content",be)},m(t,e){ge(document.head,d),s(t,at,e),s(t,tt,e),s(t,st,e),h(y,t,e),s(t,lt,e),s(t,g,e),s(t,nt,e),s(t,w,e),s(t,it,e),s(t,M,e),s(t,ot,e),s(t,b,e),s(t,ft,e),h(T,t,e),s(t,pt,e),s(t,U,e),s(t,rt,e),h(J,t,e),s(t,ht,e),s(t,$,e),s(t,ut,e),h(j,t,e),s(t,mt,e),h(v,t,e),s(t,ct,e),s(t,C,e),s(t,dt,e),s(t,I,e),s(t,yt,e),h(_,t,e),s(t,gt,e),s(t,k,e),s(t,wt,e),h(F,t,e),s(t,Mt,e),s(t,Z,e),s(t,bt,e),s(t,H,e),s(t,Tt,e),s(t,x,e),s(t,Ut,e),h(B,t,e),s(t,Jt,e),h(G,t,e),s(t,$t,e),s(t,q,e),s(t,jt,e),s(t,Q,e),s(t,vt,e),s(t,W,e),s(t,Ct,e),s(t,X,e),s(t,It,e),h(z,t,e),s(t,_t,e),s(t,L,e),s(t,kt,e),h(Y,t,e),s(t,Ft,e),s(t,S,e),s(t,Zt,e),h(P,t,e),s(t,Ht,e),s(t,R,e),s(t,xt,e),s(t,V,e),s(t,Bt,e),h(A,t,e),s(t,Gt,e),h(O,t,e),s(t,qt,e),s(t,N,e),s(t,Qt,e),h(D,t,e),s(t,Wt,e),s(t,et,e),Xt=!0},p:ue,i(t){Xt||(u(y.$$.fragment,t),u(T.$$.fragment,t),u(J.$$.fragment,t),u(j.$$.fragment,t),u(v.$$.fragment,t),u(_.$$.fragment,t),u(F.$$.fragment,t),u(B.$$.fragment,t),u(G.$$.fragment,t),u(z.$$.fragment,t),u(Y.$$.fragment,t),u(P.$$.fragment,t),u(A.$$.fragment,t),u(O.$$.fragment,t),u(D.$$.fragment,t),Xt=!0)},o(t){m(y.$$.fragment,t),m(T.$$.fragment,t),m(J.$$.fragment,t),m(j.$$.fragment,t),m(v.$$.fragment,t),m(_.$$.fragment,t),m(F.$$.fragment,t),m(B.$$.fragment,t),m(G.$$.fragment,t),m(z.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),m(A.$$.fragment,t),m(O.$$.fragment,t),m(D.$$.fragment,t),Xt=!1},d(t){t&&(a(at),a(tt),a(st),a(lt),a(g),a(nt),a(w),a(it),a(M),a(ot),a(b),a(ft),a(pt),a(U),a(rt),a(ht),a($),a(ut),a(mt),a(ct),a(C),a(dt),a(I),a(yt),a(gt),a(k),a(wt),a(Mt),a(Z),a(bt),a(H),a(Tt),a(x),a(Ut),a(Jt),a($t),a(q),a(jt),a(Q),a(vt),a(W),a(Ct),a(X),a(It),a(_t),a(L),a(kt),a(Ft),a(S),a(Zt),a(Ht),a(R),a(xt),a(V),a(Bt),a(Gt),a(qt),a(N),a(Qt),a(Wt),a(et)),a(d),c(y,t),c(T,t),c(J,t),c(j,t),c(v,t),c(_,t),c(F,t),c(B,t),c(G,t),c(z,t),c(Y,t),c(P,t),c(A,t),c(O,t),c(D,t)}}}const be='{"title":"FiftyOne","local":"fiftyone","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Loading Visual Datasets from the Hub","local":"loading-visual-datasets-from-the-hub","sections":[{"title":"Loading FiftyOne datasets from the Hub","local":"loading-fiftyone-datasets-from-the-hub","sections":[],"depth":3},{"title":"Loading Parquet Datasets from the Hub with FiftyOne","local":"loading-parquet-datasets-from-the-hub-with-fiftyone","sections":[],"depth":3}],"depth":2},{"title":"Pushing FiftyOne Datasets to the Hub","local":"pushing-fiftyone-datasets-to-the-hub","sections":[],"depth":2},{"title":"📚 Resources","local":"-resources","sections":[],"depth":2}],"depth":1}';function Te(zt){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends ce{constructor(d){super(),de(this,d,Te,Me,he,{})}}export{ve as component};
