import{s as Le,n as Ge,o as Ee}from"../chunks/scheduler.d6170356.js";import{S as qe,i as Re,g as n,s as l,r as d,A as Xe,h as o,f as a,c as s,j as Pe,u,x as r,k as Ie,y as Fe,a as i,v as h,d as p,t as f,w as m}from"../chunks/index.fcd4cc08.js";import{C as te}from"../chunks/CodeBlock.db16bf50.js";import{H as b,E as Be}from"../chunks/index.c1f68a2b.js";function Ze(ee){let c,rt,nt,dt,g,ut,y,ae=`The Datasets Hub has support for several libraries in the Open Source ecosystem.
Thanks to the <a href="/docs/huggingface_hub">huggingface_hub Python library</a>, it’s easy to enable sharing your datasets on the Hub.
We’re happy to welcome to the Hub a set of Open Source libraries that are pushing Machine Learning forward.`,ht,w,ie="The table below summarizes the supported libraries and their level of integration.",pt,M,le='<thead><tr><th>Library</th> <th>Description</th> <th>Download from Hub</th> <th>Push to Hub</th></tr></thead> <tbody><tr><td><a href="./datasets-argilla">Argilla</a></td> <td>Collaboration tool for AI engineers and domain experts that value high quality data.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-dask">Dask</a></td> <td>Parallel and distributed computing library that scales the existing Python and PyData ecosystem.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-usage">Datasets</a></td> <td>🤗 Datasets is a library for accessing and sharing datasets for Audio, Computer Vision, and Natural Language Processing (NLP).</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-distilabel">Distilabel</a></td> <td>The framework for synthetic data generation and AI feedback.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-duckdb">DuckDB</a></td> <td>In-process SQL OLAP database management system.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-fiftyone">FiftyOne</a></td> <td>FiftyOne is a library for curation and visualization of image, video, and 3D data.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-pandas">Pandas</a></td> <td>Python data analysis toolkit.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-polars">Polars</a></td> <td>A DataFrame library on top of an OLAP query engine.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-spark">Spark</a></td> <td>Real-time, large-scale data processing tool in a distributed environment.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-webdataset">WebDataset</a></td> <td>Library to write I/O pipelines for large datasets.</td> <td>✅</td> <td>❌</td></tr></tbody>',ft,v,mt,T,se="This guide is designed for developers and maintainers of data libraries and tools who want to integrate with the Hugging Face Hub. Whether you’re building a data processing library, analysis tool, or any software that needs to interact with datasets, this documentation will help you implement a Hub integration.",ct,$,ne="The guide covers:",bt,_,oe="<li>Possible approaches to loading data from the Hub into your library/tool</li> <li>Possible approaches to uploading data from your library/tool to the Hub</li>",gt,H,yt,x,re="If you have a library for working with data, it can be helpful for your users to load data from the Hub.",wt,C,de="In general, we suggest relying on an existing library like <code>datasets</code>, <code>pandas</code> or <code>polars</code> to do this unless you have a specific reason to implement your own. If you require more control over the loading process, you can use the <code>huggingface_hub</code> library, which will allow you, for example, to download a specific subset of files from a repository.",Mt,U,ue='You can find more information about loading data from the Hub <a href="https://huggingface.co/docs/hub/datasets-downloading" rel="nofollow">here</a>.',vt,J,Tt,k,he="The Hub’s dataset viewer and Parquet conversion system provide a standardized way to integrate with datasets, regardless of their original format. This infrastructure is a reliable integration layer between the Hub and external libraries.",$t,j,pe="If the dataset is not already in Parquet, the Hub automatically converts the first 5GB of every dataset to Parquet format to power the dataset viewer and provide consistent access patterns. This standardization offers several benefits for library integrations:",_t,P,fe='<li>Consistent data access patterns regardless of original format</li> <li>Built-in dataset preview and exploration through the Hub’s dataset viewer. The dataset viewer can also be embedded as an iframe in your applications, making it easy to provide rich dataset previews. For more information about embedding the viewer, see the <a href="https://huggingface.co/docs/hub/en/datasets-viewer-embed" rel="nofollow">dataset viewer embedding documentation</a>.</li> <li>Efficient columnar storage optimized for querying. For example, you could use a tool like <a href="https://duckdb.org/" rel="nofollow">DuckDB</a> to query or filter for a specific subset of data.</li> <li>Parquet is well supported across the machine learning and data science ecosystem.</li>',Ht,I,me='For more details on working with the Dataset Viewer API, see the <a href="https://huggingface.co/docs/dataset-viewer/index" rel="nofollow">Dataset Viewer API documentation</a>',xt,L,Ct,G,ce="This section covers possible approaches for adding the ability to upload data to the Hub in your library, i.e. how to implement a <code>push_to_hub</code> method.",Ut,E,be="This guide will cover three primary ways to upload data to the Hub:",Jt,q,ge="<li>using the <code>datasets</code> library and the <code>push_to_hub</code> method</li> <li>using <code>pandas</code> to write to the Hub</li> <li>using the <code>huggingface_hub</code> library and the <code>hf_hub_download</code> method</li> <li>directly using the API or Git LFS</li>",kt,R,jt,X,ye='The most straightforward approach to pushing data to the Hub is to rely on the existing <a href="https://huggingface.co/docs/datasets/v3.2.0/en/package_reference/main_classes#datasets.Dataset.push_to_hub" rel="nofollow"><code>push_to_hub</code></a> method from the <code>datasets</code> library. The <code>push_to_hub</code> method will automatically handle:',Pt,F,we="<li>the creation of the repository</li> <li>the conversion of the dataset to Parquet</li> <li>chunking the dataset into suitable parts</li> <li>uploading the data</li>",It,B,Me="For example, if you have a synthetic data generation library that returns a list of dictionaries, you could simply do the following:",Lt,Z,Gt,S,ve="Examples of this kind of integration:",Et,D,Te='<li><a href="https://github.com/argilla-io/distilabel/blob/8ad48387dfa4d7bd5639065661f1975dcb44c16a/src/distilabel/distiset.py#L77" rel="nofollow">Distilabel</a></li>',qt,z,Rt,A,$e='Polars, Pandas, Dask, Spark and DuckDB all can write to a Hugging Face Hub repository. See <a href="https://huggingface.co/docs/hub/datasets-libraries" rel="nofollow">datasets libraries</a> for more details.',Xt,V,_e="If you are already using one of these libraries in your code, adding the ability to push to the Hub is straightforward. For example, if you have a synthetic data generation library that can return a Pandas DataFrame, here is the code you would need to write to the Hub:",Ft,N,Bt,W,Zt,Y,He="The <code>huggingface_hub</code> Python library offers a more flexible approach to uploading data to the Hub. The library allows you to upload specific files or subsets of files to a repository. This is useful if you have a large dataset that you don’t want to convert to Parquet, want to upload a specific subset of files, or want more control over the repo structure.",St,Q,xe="Depending on your use case, you can upload a file or folder at a specific point in your code, i.e., export annotations from a tool to the Hub when a user clicks “push to Hub”. For example,",Dt,O,zt,K,Ce='You can find more information about ways to upload data to the Hub <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload" rel="nofollow">here</a>.',At,tt,Ue='Alternatively, there are situations where you may want to upload data in the background, for example, synthetic data being generated every 10 minutes. In this case you can use the <code>scheduled_uploads</code> feature of the <code>huggingface_hub</code> library. For more details, see the <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload#scheduled-uploads" rel="nofollow">scheduled uploads documentation</a>.',Vt,et,Je="You can see an example of using this approach to upload data to the Hub in",Nt,at,ke='<li>The <a href="https://github.com/AnswerDotAI/fastdata/blob/main/nbs/00_core.ipynb" rel="nofollow">fastdata</a> library</li> <li>This <a href="https://huggingface.co/spaces/davanstrien/magpie/blob/fc79672c740b8d3d098378dca37c0f191c208de0/app.py#L67" rel="nofollow">magpie</a> Demo Space</li>',Wt,it,Yt,lt,je='For technical questions about integration, feel free to contact the datasets team at <a href="mailto:datasets@huggingface.co">datasets@huggingface.co</a>.',Qt,st,Ot,ot,Kt;return g=new b({props:{title:"Libraries",local:"libraries",headingTag:"h1"}}),v=new b({props:{title:"Integrating data libraries and tools with the Hub",local:"integrating-data-libraries-and-tools-with-the-hub",headingTag:"h2"}}),H=new b({props:{title:"Loading data from the Hub",local:"loading-data-from-the-hub",headingTag:"h3"}}),J=new b({props:{title:"Integrating via the Dataset Viewer and Parquet Files",local:"integrating-via-the-dataset-viewer-and-parquet-files",headingTag:"h4"}}),L=new b({props:{title:"Uploading data to the Hub",local:"uploading-data-to-the-hub",headingTag:"h3"}}),R=new b({props:{title:"Use the datasets library",local:"use-the-datasets-library",headingTag:"h4"}}),Z=new te({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGElMjAlM0QlMjAlNUIlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJXcml0ZSUyMGElMjBjYWtlJTIwcmVjaXBlJTIyJTJDJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAlMjJNZWFzdXJlJTIwMSUyMGN1cCUyMC4uLiUyMiU3RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2xpc3QoZGF0YSklMEFkcy5wdXNoX3RvX2h1YiglMjJVU0VSTkFNRV9PUl9PUkclMkZyZXBvX0lEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

data = [{<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;Write a cake recipe&quot;</span>, <span class="hljs-string">&quot;response&quot;</span>: <span class="hljs-string">&quot;Measure 1 cup ...&quot;</span>}]
ds = Dataset.from_list(data)
ds.push_to_hub(<span class="hljs-string">&quot;USERNAME_OR_ORG/repo_ID&quot;</span>)`,wrap:!1}}),z=new b({props:{title:"Rely on an existing libraries integration with the Hub",local:"rely-on-an-existing-libraries-integration-with-the-hub",headingTag:"h4"}}),N=new te({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMEh1YiUyMEFQSSUwQWhmX2FwaSUyMCUzRCUyMEhmQXBpKHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSklMEElMEElMjMlMjBDcmVhdGUlMjBhJTIwcmVwb3NpdG9yeSUyMChpZiUyMGl0JTIwZG9lc24ndCUyMGV4aXN0KSUwQWhmX2FwaS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiklMEElMEElMjMlMjBDb252ZXJ0JTIweW91ciUyMGRhdGElMjB0byUyMGElMjBEYXRhRnJhbWUlMjBhbmQlMjBzYXZlJTIwZGlyZWN0bHklMjB0byUyMHRoZSUyMEh1YiUwQWRmLnRvX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXktZGF0YXNldCUyRmRhdGEucGFycXVldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-comment"># Initialize the Hub API</span>
hf_api = HfApi(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>))

<span class="hljs-comment"># Create a repository (if it doesn&#x27;t exist)</span>
hf_api.create_repo(repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)

<span class="hljs-comment"># Convert your data to a DataFrame and save directly to the Hub</span>
df.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my-dataset/data.parquet&quot;</span>)`,wrap:!1}}),W=new b({props:{title:"Using the huggingface_hub Python library",local:"using-the-huggingfacehub-python-library",headingTag:"h4"}}),O=new te({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkodG9rZW4lM0RIRl9UT0tFTiklMEElMEFhcGkudXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMiUyRm15LWNvb2wtbGlicmFyeSUyRmRhdGEtZm9sZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktY29vbC1zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21taXRfbWVzc2FnZSUzRCUyMlB1c2glMjBhbm5vdGF0aW9ucyUyMHRvJTIwSHViJTIyJTBBJTIwJTIwJTIwJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb25sJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi(token=HF_TOKEN)

api.upload_folder(
    folder_path=<span class="hljs-string">&quot;/my-cool-library/data-folder&quot;</span>,
    repo_id=<span class="hljs-string">&quot;username/my-cool-space&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    commit_message=<span class="hljs-string">&quot;Push annotations to Hub&quot;</span>
    allow_patterns=<span class="hljs-string">&quot;*.jsonl&quot;</span>,
)`,wrap:!1}}),it=new b({props:{title:"More support",local:"more-support",headingTag:"h2"}}),st=new Be({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-libraries.md"}}),{c(){c=n("meta"),rt=l(),nt=n("p"),dt=l(),d(g.$$.fragment),ut=l(),y=n("p"),y.innerHTML=ae,ht=l(),w=n("p"),w.textContent=ie,pt=l(),M=n("table"),M.innerHTML=le,ft=l(),d(v.$$.fragment),mt=l(),T=n("p"),T.textContent=se,ct=l(),$=n("p"),$.textContent=ne,bt=l(),_=n("ul"),_.innerHTML=oe,gt=l(),d(H.$$.fragment),yt=l(),x=n("p"),x.textContent=re,wt=l(),C=n("p"),C.innerHTML=de,Mt=l(),U=n("p"),U.innerHTML=ue,vt=l(),d(J.$$.fragment),Tt=l(),k=n("p"),k.textContent=he,$t=l(),j=n("p"),j.textContent=pe,_t=l(),P=n("ul"),P.innerHTML=fe,Ht=l(),I=n("p"),I.innerHTML=me,xt=l(),d(L.$$.fragment),Ct=l(),G=n("p"),G.innerHTML=ce,Ut=l(),E=n("p"),E.textContent=be,Jt=l(),q=n("ul"),q.innerHTML=ge,kt=l(),d(R.$$.fragment),jt=l(),X=n("p"),X.innerHTML=ye,Pt=l(),F=n("ul"),F.innerHTML=we,It=l(),B=n("p"),B.textContent=Me,Lt=l(),d(Z.$$.fragment),Gt=l(),S=n("p"),S.textContent=ve,Et=l(),D=n("ul"),D.innerHTML=Te,qt=l(),d(z.$$.fragment),Rt=l(),A=n("p"),A.innerHTML=$e,Xt=l(),V=n("p"),V.textContent=_e,Ft=l(),d(N.$$.fragment),Bt=l(),d(W.$$.fragment),Zt=l(),Y=n("p"),Y.innerHTML=He,St=l(),Q=n("p"),Q.textContent=xe,Dt=l(),d(O.$$.fragment),zt=l(),K=n("p"),K.innerHTML=Ce,At=l(),tt=n("p"),tt.innerHTML=Ue,Vt=l(),et=n("p"),et.textContent=Je,Nt=l(),at=n("ul"),at.innerHTML=ke,Wt=l(),d(it.$$.fragment),Yt=l(),lt=n("p"),lt.innerHTML=je,Qt=l(),d(st.$$.fragment),Ot=l(),ot=n("p"),this.h()},l(t){const e=Xe("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(a),rt=s(t),nt=o(t,"P",{}),Pe(nt).forEach(a),dt=s(t),u(g.$$.fragment,t),ut=s(t),y=o(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-19pvdk"&&(y.innerHTML=ae),ht=s(t),w=o(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-ff3ufa"&&(w.textContent=ie),pt=s(t),M=o(t,"TABLE",{"data-svelte-h":!0}),r(M)!=="svelte-1hcj4t5"&&(M.innerHTML=le),ft=s(t),u(v.$$.fragment,t),mt=s(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1bmppgx"&&(T.textContent=se),ct=s(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-e0z0qx"&&($.textContent=ne),bt=s(t),_=o(t,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-162x9zs"&&(_.innerHTML=oe),gt=s(t),u(H.$$.fragment,t),yt=s(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-chb2m7"&&(x.textContent=re),wt=s(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-m9xre3"&&(C.innerHTML=de),Mt=s(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1kfkj1n"&&(U.innerHTML=ue),vt=s(t),u(J.$$.fragment,t),Tt=s(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-nyvi1q"&&(k.textContent=he),$t=s(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-sdabnb"&&(j.textContent=pe),_t=s(t),P=o(t,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-14xyszt"&&(P.innerHTML=fe),Ht=s(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-145eyta"&&(I.innerHTML=me),xt=s(t),u(L.$$.fragment,t),Ct=s(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ia8icy"&&(G.innerHTML=ce),Ut=s(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-166sdwe"&&(E.textContent=be),Jt=s(t),q=o(t,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1dyhahs"&&(q.innerHTML=ge),kt=s(t),u(R.$$.fragment,t),jt=s(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1x8099z"&&(X.innerHTML=ye),Pt=s(t),F=o(t,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-iaou6v"&&(F.innerHTML=we),It=s(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-d45nz"&&(B.textContent=Me),Lt=s(t),u(Z.$$.fragment,t),Gt=s(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-53l0c9"&&(S.textContent=ve),Et=s(t),D=o(t,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-5zd4l0"&&(D.innerHTML=Te),qt=s(t),u(z.$$.fragment,t),Rt=s(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-15e6e4o"&&(A.innerHTML=$e),Xt=s(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1s8u1ie"&&(V.textContent=_e),Ft=s(t),u(N.$$.fragment,t),Bt=s(t),u(W.$$.fragment,t),Zt=s(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ygt6jd"&&(Y.innerHTML=He),St=s(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-7hs1zn"&&(Q.textContent=xe),Dt=s(t),u(O.$$.fragment,t),zt=s(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-7kkfko"&&(K.innerHTML=Ce),At=s(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-iljeu7"&&(tt.innerHTML=Ue),Vt=s(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-yedhy2"&&(et.textContent=Je),Nt=s(t),at=o(t,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-5ri1p0"&&(at.innerHTML=ke),Wt=s(t),u(it.$$.fragment,t),Yt=s(t),lt=o(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-zmwud2"&&(lt.innerHTML=je),Qt=s(t),u(st.$$.fragment,t),Ot=s(t),ot=o(t,"P",{}),Pe(ot).forEach(a),this.h()},h(){Ie(c,"name","hf:doc:metadata"),Ie(c,"content",Se)},m(t,e){Fe(document.head,c),i(t,rt,e),i(t,nt,e),i(t,dt,e),h(g,t,e),i(t,ut,e),i(t,y,e),i(t,ht,e),i(t,w,e),i(t,pt,e),i(t,M,e),i(t,ft,e),h(v,t,e),i(t,mt,e),i(t,T,e),i(t,ct,e),i(t,$,e),i(t,bt,e),i(t,_,e),i(t,gt,e),h(H,t,e),i(t,yt,e),i(t,x,e),i(t,wt,e),i(t,C,e),i(t,Mt,e),i(t,U,e),i(t,vt,e),h(J,t,e),i(t,Tt,e),i(t,k,e),i(t,$t,e),i(t,j,e),i(t,_t,e),i(t,P,e),i(t,Ht,e),i(t,I,e),i(t,xt,e),h(L,t,e),i(t,Ct,e),i(t,G,e),i(t,Ut,e),i(t,E,e),i(t,Jt,e),i(t,q,e),i(t,kt,e),h(R,t,e),i(t,jt,e),i(t,X,e),i(t,Pt,e),i(t,F,e),i(t,It,e),i(t,B,e),i(t,Lt,e),h(Z,t,e),i(t,Gt,e),i(t,S,e),i(t,Et,e),i(t,D,e),i(t,qt,e),h(z,t,e),i(t,Rt,e),i(t,A,e),i(t,Xt,e),i(t,V,e),i(t,Ft,e),h(N,t,e),i(t,Bt,e),h(W,t,e),i(t,Zt,e),i(t,Y,e),i(t,St,e),i(t,Q,e),i(t,Dt,e),h(O,t,e),i(t,zt,e),i(t,K,e),i(t,At,e),i(t,tt,e),i(t,Vt,e),i(t,et,e),i(t,Nt,e),i(t,at,e),i(t,Wt,e),h(it,t,e),i(t,Yt,e),i(t,lt,e),i(t,Qt,e),h(st,t,e),i(t,Ot,e),i(t,ot,e),Kt=!0},p:Ge,i(t){Kt||(p(g.$$.fragment,t),p(v.$$.fragment,t),p(H.$$.fragment,t),p(J.$$.fragment,t),p(L.$$.fragment,t),p(R.$$.fragment,t),p(Z.$$.fragment,t),p(z.$$.fragment,t),p(N.$$.fragment,t),p(W.$$.fragment,t),p(O.$$.fragment,t),p(it.$$.fragment,t),p(st.$$.fragment,t),Kt=!0)},o(t){f(g.$$.fragment,t),f(v.$$.fragment,t),f(H.$$.fragment,t),f(J.$$.fragment,t),f(L.$$.fragment,t),f(R.$$.fragment,t),f(Z.$$.fragment,t),f(z.$$.fragment,t),f(N.$$.fragment,t),f(W.$$.fragment,t),f(O.$$.fragment,t),f(it.$$.fragment,t),f(st.$$.fragment,t),Kt=!1},d(t){t&&(a(rt),a(nt),a(dt),a(ut),a(y),a(ht),a(w),a(pt),a(M),a(ft),a(mt),a(T),a(ct),a($),a(bt),a(_),a(gt),a(yt),a(x),a(wt),a(C),a(Mt),a(U),a(vt),a(Tt),a(k),a($t),a(j),a(_t),a(P),a(Ht),a(I),a(xt),a(Ct),a(G),a(Ut),a(E),a(Jt),a(q),a(kt),a(jt),a(X),a(Pt),a(F),a(It),a(B),a(Lt),a(Gt),a(S),a(Et),a(D),a(qt),a(Rt),a(A),a(Xt),a(V),a(Ft),a(Bt),a(Zt),a(Y),a(St),a(Q),a(Dt),a(zt),a(K),a(At),a(tt),a(Vt),a(et),a(Nt),a(at),a(Wt),a(Yt),a(lt),a(Qt),a(Ot),a(ot)),a(c),m(g,t),m(v,t),m(H,t),m(J,t),m(L,t),m(R,t),m(Z,t),m(z,t),m(N,t),m(W,t),m(O,t),m(it,t),m(st,t)}}}const Se='{"title":"Libraries","local":"libraries","sections":[{"title":"Integrating data libraries and tools with the Hub","local":"integrating-data-libraries-and-tools-with-the-hub","sections":[{"title":"Loading data from the Hub","local":"loading-data-from-the-hub","sections":[{"title":"Integrating via the Dataset Viewer and Parquet Files","local":"integrating-via-the-dataset-viewer-and-parquet-files","sections":[],"depth":4}],"depth":3},{"title":"Uploading data to the Hub","local":"uploading-data-to-the-hub","sections":[{"title":"Use the datasets library","local":"use-the-datasets-library","sections":[],"depth":4},{"title":"Rely on an existing libraries integration with the Hub","local":"rely-on-an-existing-libraries-integration-with-the-hub","sections":[],"depth":4},{"title":"Using the huggingface_hub Python library","local":"using-the-huggingfacehub-python-library","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"More support","local":"more-support","sections":[],"depth":2}],"depth":1}';function De(ee){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends qe{constructor(c){super(),Re(this,c,De,Ze,Le,{})}}export{We as component};
