import{s as os,n as us,o as cs}from"../chunks/scheduler.d6170356.js";import{S as rs,i as ys,g as i,s as e,r as o,A as ms,h as u,f as a,c as n,j as ns,u as c,x as k,k as ps,y as Ms,a as l,v as r,d as y,t as m,w as M}from"../chunks/index.fcd4cc08.js";import{C as is}from"../chunks/CodeBlock.db16bf50.js";import{H as Z,E as hs}from"../chunks/index.c1f68a2b.js";function Js(D){let p,v,G,z,h,S,J,O="We briefly touched upon the difference between lazy and eager evaluation. On this page we will show how the lazy API can be used to get huge performance benefits.",B,w,K,d,ss="Polars supports two modes of operation: lazy and eager. In the eager API the query is executed immediately while in the lazy API the query is only evaluated once it’s ‘needed’. Deferring the execution to the last minute can have significant performance advantages and is why the lazy API is preferred in most non-interactive cases.",W,g,R,T,ts="We will be using the example from the previous page to show the performance benefits of using the lazy API. The code below will compute the number of uploads from <code>archive.org</code>.",X,j,F,U,Q,I,x,f,N,b,L,C,as="Running both queries leads to following run times on a regular laptop with a household internet connection:",E,q,ls="<li>Eager: <code>1.96</code> seconds</li> <li>Lazy: <code>410</code> milliseconds</li>",V,$,es="The lazy query is ~5 times faster than the eager one. The reason for this is the query optimizer: if we delay <code>collect</code>-ing our dataset until the end, Polars will be able to reason about which columns and rows are required and apply filters as early as possible when reading the data. For file formats such as Parquet that contain metadata (e.g. min, max in a certain group of rows) the difference can even be bigger as Polars can skip entire row groups based on the filters and the metadata without sending the data over the wire.",A,_,H,Y,P;return h=new Z({props:{title:"Optimizations",local:"optimizations",headingTag:"h1"}}),w=new Z({props:{title:"Lazy vs Eager",local:"lazy-vs-eager",headingTag:"h2"}}),g=new Z({props:{title:"Example",local:"example",headingTag:"h2"}}),j=new Z({props:{title:"Eager",local:"eager",headingTag:"h3"}}),U=new is({props:{code:"aW1wb3J0JTIwcG9sYXJzJTIwYXMlMjBwbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBJTBBZGYlMjAlM0QlMjBwbC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGY29tbW9uY3Jhd2wlMkZzdGF0aXN0aWNzJTJGdGxkcy5jc3YlMjIlMkMlMjB0cnlfcGFyc2VfZGF0ZXMlM0RUcnVlKSUwQSUwQWRmJTIwJTNEJTIwZGYuc2VsZWN0KCUyMnN1ZmZpeCUyMiUyQyUyMCUyMmNyYXdsJTIyJTJDJTIwJTIyZGF0ZSUyMiUyQyUyMCUyMnRsZCUyMiUyQyUyMCUyMnBhZ2VzJTIyJTJDJTIwJTIyZG9tYWlucyUyMiklMEFkZiUyMCUzRCUyMGRmLmZpbHRlciglMEElMjAlMjAlMjAlMjAocGwuY29sKCUyMmRhdGUlMjIpJTIwJTNFJTNEJTIwZGF0ZXRpbWUuZGF0ZSgyMDIwJTJDJTIwMSUyQyUyMDEpKSUyMCU3QyUwQSUyMCUyMCUyMCUyMHBsLmNvbCglMjJjcmF3bCUyMikuc3RyLmNvbnRhaW5zKCUyMkNDJTIyKSUwQSklMEFkZiUyMCUzRCUyMGRmLndpdGhfY29sdW1ucyglMEElMjAlMjAlMjAlMjAocGwuY29sKCUyMnBhZ2VzJTIyKSUyMCUyRiUyMHBsLmNvbCglMjJkb21haW5zJTIyKSkuYWxpYXMoJTIycGFnZXNfcGVyX2RvbWFpbiUyMiklMEEpJTBBZGYlMjAlM0QlMjBkZi5ncm91cF9ieSglMjJ0bGQlMjIlMkMlMjAlMjJkYXRlJTIyKS5hZ2coJTBBJTIwJTIwJTIwJTIwcGwuY29sKCUyMnBhZ2VzJTIyKS5zdW0oKSUyQyUwQSUyMCUyMCUyMCUyMHBsLmNvbCglMjJkb21haW5zJTIyKS5zdW0oKSUyQyUwQSklMEFkZiUyMCUzRCUyMGRmLmdyb3VwX2J5KCUyMnRsZCUyMikuYWdnKCUwQSUyMCUyMCUyMCUyMHBsLmNvbCglMjJkYXRlJTIyKS51bmlxdWUoKS5jb3VudCgpLmFsaWFzKCUyMm51bWJlcl9vZl9zY3JhcGVzJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHBsLmNvbCglMjJkb21haW5zJTIyKS5tZWFuKCkuYWxpYXMoJTIyYXZnX251bWJlcl9vZl9kb21haW5zJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHBsLmNvbCglMjJwYWdlcyUyMikuc29ydF9ieSglMjJkYXRlJTIyKS5wY3RfY2hhbmdlKCkubWVhbigpLmFsaWFzKCUyMmF2Z19wYWdlX2dyb3d0aF9yYXRlJTIyKSUyQyUwQSkuc29ydCglMjJhdmdfbnVtYmVyX29mX2RvbWFpbnMlMjIlMkMlMjBkZXNjZW5kaW5nJTNEVHJ1ZSkuaGVhZCgxMCk=",highlighted:`<span class="hljs-keyword">import</span> polars <span class="hljs-keyword">as</span> pl
<span class="hljs-keyword">import</span> datetime

df = pl.read_csv(<span class="hljs-string">&quot;hf://datasets/commoncrawl/statistics/tlds.csv&quot;</span>, try_parse_dates=<span class="hljs-literal">True</span>)

df = df.select(<span class="hljs-string">&quot;suffix&quot;</span>, <span class="hljs-string">&quot;crawl&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>, <span class="hljs-string">&quot;tld&quot;</span>, <span class="hljs-string">&quot;pages&quot;</span>, <span class="hljs-string">&quot;domains&quot;</span>)
df = df.<span class="hljs-built_in">filter</span>(
    (pl.col(<span class="hljs-string">&quot;date&quot;</span>) &gt;= datetime.date(<span class="hljs-number">2020</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)) |
    pl.col(<span class="hljs-string">&quot;crawl&quot;</span>).<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;CC&quot;</span>)
)
df = df.with_columns(
    (pl.col(<span class="hljs-string">&quot;pages&quot;</span>) / pl.col(<span class="hljs-string">&quot;domains&quot;</span>)).alias(<span class="hljs-string">&quot;pages_per_domain&quot;</span>)
)
df = df.group_by(<span class="hljs-string">&quot;tld&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>).agg(
    pl.col(<span class="hljs-string">&quot;pages&quot;</span>).<span class="hljs-built_in">sum</span>(),
    pl.col(<span class="hljs-string">&quot;domains&quot;</span>).<span class="hljs-built_in">sum</span>(),
)
df = df.group_by(<span class="hljs-string">&quot;tld&quot;</span>).agg(
    pl.col(<span class="hljs-string">&quot;date&quot;</span>).unique().count().alias(<span class="hljs-string">&quot;number_of_scrapes&quot;</span>),
    pl.col(<span class="hljs-string">&quot;domains&quot;</span>).mean().alias(<span class="hljs-string">&quot;avg_number_of_domains&quot;</span>),
    pl.col(<span class="hljs-string">&quot;pages&quot;</span>).sort_by(<span class="hljs-string">&quot;date&quot;</span>).pct_change().mean().alias(<span class="hljs-string">&quot;avg_page_growth_rate&quot;</span>),
).sort(<span class="hljs-string">&quot;avg_number_of_domains&quot;</span>, descending=<span class="hljs-literal">True</span>).head(<span class="hljs-number">10</span>)`,wrap:!1}}),I=new Z({props:{title:"Lazy",local:"lazy",headingTag:"h3"}}),f=new is({props:{code:"aW1wb3J0JTIwcG9sYXJzJTIwYXMlMjBwbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBJTBBbGYlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwcGwuc2Nhbl9jc3YoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRmNvbW1vbmNyYXdsJTJGc3RhdGlzdGljcyUyRnRsZHMuY3N2JTIyJTJDJTIwdHJ5X3BhcnNlX2RhdGVzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjAuZmlsdGVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMChwbC5jb2woJTIyZGF0ZSUyMiklMjAlM0UlM0QlMjBkYXRldGltZS5kYXRlKDIwMjAlMkMlMjAxJTJDJTIwMSkpJTIwJTdDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGwuY29sKCUyMmNyYXdsJTIyKS5zdHIuY29udGFpbnMoJTIyQ0MlMjIpJTBBJTIwJTIwJTIwJTIwKS53aXRoX2NvbHVtbnMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHBsLmNvbCglMjJwYWdlcyUyMiklMjAlMkYlMjBwbC5jb2woJTIyZG9tYWlucyUyMikpLmFsaWFzKCUyMnBhZ2VzX3Blcl9kb21haW4lMjIpJTBBJTIwJTIwJTIwJTIwKS5ncm91cF9ieSglMjJ0bGQlMjIlMkMlMjAlMjJkYXRlJTIyKS5hZ2coJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGwuY29sKCUyMnBhZ2VzJTIyKS5zdW0oKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBsLmNvbCglMjJkb21haW5zJTIyKS5zdW0oKSUyQyUwQSUyMCUyMCUyMCUyMCkuZ3JvdXBfYnkoJTIydGxkJTIyKS5hZ2coJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGwuY29sKCUyMmRhdGUlMjIpLnVuaXF1ZSgpLmNvdW50KCkuYWxpYXMoJTIybnVtYmVyX29mX3NjcmFwZXMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGwuY29sKCUyMmRvbWFpbnMlMjIpLm1lYW4oKS5hbGlhcyglMjJhdmdfbnVtYmVyX29mX2RvbWFpbnMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGwuY29sKCUyMnBhZ2VzJTIyKS5zb3J0X2J5KCUyMmRhdGUlMjIpLnBjdF9jaGFuZ2UoKS5tZWFuKCkuYWxpYXMoJTIyYXZnX3BhZ2VfZ3Jvd3RoX3JhdGUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKS5zb3J0KCUyMmF2Z19udW1iZXJfb2ZfZG9tYWlucyUyMiUyQyUyMGRlc2NlbmRpbmclM0RUcnVlKS5oZWFkKDEwKSUwQSklMEFkZiUyMCUzRCUyMGxmLmNvbGxlY3QoKQ==",highlighted:`<span class="hljs-keyword">import</span> polars <span class="hljs-keyword">as</span> pl
<span class="hljs-keyword">import</span> datetime

lf = (
    pl.scan_csv(<span class="hljs-string">&quot;hf://datasets/commoncrawl/statistics/tlds.csv&quot;</span>, try_parse_dates=<span class="hljs-literal">True</span>)
    .<span class="hljs-built_in">filter</span>(
        (pl.col(<span class="hljs-string">&quot;date&quot;</span>) &gt;= datetime.date(<span class="hljs-number">2020</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)) |
        pl.col(<span class="hljs-string">&quot;crawl&quot;</span>).<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;CC&quot;</span>)
    ).with_columns(
        (pl.col(<span class="hljs-string">&quot;pages&quot;</span>) / pl.col(<span class="hljs-string">&quot;domains&quot;</span>)).alias(<span class="hljs-string">&quot;pages_per_domain&quot;</span>)
    ).group_by(<span class="hljs-string">&quot;tld&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>).agg(
        pl.col(<span class="hljs-string">&quot;pages&quot;</span>).<span class="hljs-built_in">sum</span>(),
        pl.col(<span class="hljs-string">&quot;domains&quot;</span>).<span class="hljs-built_in">sum</span>(),
    ).group_by(<span class="hljs-string">&quot;tld&quot;</span>).agg(
        pl.col(<span class="hljs-string">&quot;date&quot;</span>).unique().count().alias(<span class="hljs-string">&quot;number_of_scrapes&quot;</span>),
        pl.col(<span class="hljs-string">&quot;domains&quot;</span>).mean().alias(<span class="hljs-string">&quot;avg_number_of_domains&quot;</span>),
        pl.col(<span class="hljs-string">&quot;pages&quot;</span>).sort_by(<span class="hljs-string">&quot;date&quot;</span>).pct_change().mean().alias(<span class="hljs-string">&quot;avg_page_growth_rate&quot;</span>),
    ).sort(<span class="hljs-string">&quot;avg_number_of_domains&quot;</span>, descending=<span class="hljs-literal">True</span>).head(<span class="hljs-number">10</span>)
)
df = lf.collect()`,wrap:!1}}),b=new Z({props:{title:"Timings",local:"timings",headingTag:"h3"}}),_=new hs({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-polars-optimizations.md"}}),{c(){p=i("meta"),v=e(),G=i("p"),z=e(),o(h.$$.fragment),S=e(),J=i("p"),J.textContent=O,B=e(),o(w.$$.fragment),K=e(),d=i("p"),d.textContent=ss,W=e(),o(g.$$.fragment),R=e(),T=i("p"),T.innerHTML=ts,X=e(),o(j.$$.fragment),F=e(),o(U.$$.fragment),Q=e(),o(I.$$.fragment),x=e(),o(f.$$.fragment),N=e(),o(b.$$.fragment),L=e(),C=i("p"),C.textContent=as,E=e(),q=i("ul"),q.innerHTML=ls,V=e(),$=i("p"),$.innerHTML=es,A=e(),o(_.$$.fragment),H=e(),Y=i("p"),this.h()},l(s){const t=ms("svelte-u9bgzb",document.head);p=u(t,"META",{name:!0,content:!0}),t.forEach(a),v=n(s),G=u(s,"P",{}),ns(G).forEach(a),z=n(s),c(h.$$.fragment,s),S=n(s),J=u(s,"P",{"data-svelte-h":!0}),k(J)!=="svelte-o4igm"&&(J.textContent=O),B=n(s),c(w.$$.fragment,s),K=n(s),d=u(s,"P",{"data-svelte-h":!0}),k(d)!=="svelte-16m8tgd"&&(d.textContent=ss),W=n(s),c(g.$$.fragment,s),R=n(s),T=u(s,"P",{"data-svelte-h":!0}),k(T)!=="svelte-1qs4ke0"&&(T.innerHTML=ts),X=n(s),c(j.$$.fragment,s),F=n(s),c(U.$$.fragment,s),Q=n(s),c(I.$$.fragment,s),x=n(s),c(f.$$.fragment,s),N=n(s),c(b.$$.fragment,s),L=n(s),C=u(s,"P",{"data-svelte-h":!0}),k(C)!=="svelte-7wcll"&&(C.textContent=as),E=n(s),q=u(s,"UL",{"data-svelte-h":!0}),k(q)!=="svelte-1ptfoh2"&&(q.innerHTML=ls),V=n(s),$=u(s,"P",{"data-svelte-h":!0}),k($)!=="svelte-13w92en"&&($.innerHTML=es),A=n(s),c(_.$$.fragment,s),H=n(s),Y=u(s,"P",{}),ns(Y).forEach(a),this.h()},h(){ps(p,"name","hf:doc:metadata"),ps(p,"content",ws)},m(s,t){Ms(document.head,p),l(s,v,t),l(s,G,t),l(s,z,t),r(h,s,t),l(s,S,t),l(s,J,t),l(s,B,t),r(w,s,t),l(s,K,t),l(s,d,t),l(s,W,t),r(g,s,t),l(s,R,t),l(s,T,t),l(s,X,t),r(j,s,t),l(s,F,t),r(U,s,t),l(s,Q,t),r(I,s,t),l(s,x,t),r(f,s,t),l(s,N,t),r(b,s,t),l(s,L,t),l(s,C,t),l(s,E,t),l(s,q,t),l(s,V,t),l(s,$,t),l(s,A,t),r(_,s,t),l(s,H,t),l(s,Y,t),P=!0},p:us,i(s){P||(y(h.$$.fragment,s),y(w.$$.fragment,s),y(g.$$.fragment,s),y(j.$$.fragment,s),y(U.$$.fragment,s),y(I.$$.fragment,s),y(f.$$.fragment,s),y(b.$$.fragment,s),y(_.$$.fragment,s),P=!0)},o(s){m(h.$$.fragment,s),m(w.$$.fragment,s),m(g.$$.fragment,s),m(j.$$.fragment,s),m(U.$$.fragment,s),m(I.$$.fragment,s),m(f.$$.fragment,s),m(b.$$.fragment,s),m(_.$$.fragment,s),P=!1},d(s){s&&(a(v),a(G),a(z),a(S),a(J),a(B),a(K),a(d),a(W),a(R),a(T),a(X),a(F),a(Q),a(x),a(N),a(L),a(C),a(E),a(q),a(V),a($),a(A),a(H),a(Y)),a(p),M(h,s),M(w,s),M(g,s),M(j,s),M(U,s),M(I,s),M(f,s),M(b,s),M(_,s)}}}const ws='{"title":"Optimizations","local":"optimizations","sections":[{"title":"Lazy vs Eager","local":"lazy-vs-eager","sections":[],"depth":2},{"title":"Example","local":"example","sections":[{"title":"Eager","local":"eager","sections":[],"depth":3},{"title":"Lazy","local":"lazy","sections":[],"depth":3},{"title":"Timings","local":"timings","sections":[],"depth":3}],"depth":2}],"depth":1}';function ds(D){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends rs{constructor(p){super(),ys(this,p,ds,Js,os,{})}}export{Is as component};
