import{s as Ft,n as Vt,o as Rt}from"../chunks/scheduler.9039eef2.js";import{S as St,i as Wt,g as n,s as l,r as m,A as At,h as o,f as r,c as a,j as f,u,x as d,k as z,y as t,a as s,v as c,d as _,t as h,w as g}from"../chunks/index.cdcc3d35.js";import{D as x}from"../chunks/Docstring.fff63cfc.js";import{H as ye}from"../chunks/Heading.96ce3702.js";function Kt(gt){let w,Te,xe,we,H,Me,I,bt="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",Ce,q,ke,O,ft="The main task in distributed training / inference is being able to shard things such as the model weights, the gradient, and/or the optimizer state. We built <code>Parallelizer</code> classes to handle the sharding.",Le,U,De,F,zt="The <code>Parallelizer</code> class is the base abstract class being derived for every model supporting model parallelism. It provides methods to parallelize the model and save and load sharded checkpoints.",Ee,p,V,Be,le,vt="Base abstract class that handles model parallelism.",Xe,C,R,Ge,ae,$t=`Parallelizes the model by transforming regular layer into their parallel counterparts.
Each concrete class must implement it.`,Je,P,S,Qe,ie,yt=`Parallelizes the model by transforming regular layer into their parallel counterparts using
<code>cls._parallelize()</code>.`,Ye,ne,xt=`It also makes sure that each parameter has loaded its weights or has been initialized if there is no pre-trained
weights associated to it.`,Ze,y,W,et,oe,Pt="Creates an optimizer ready for a parallelized model from an existing optimizer.",tt,se,Tt="There are two cases:",rt,de,wt=`<li>The optimizer has been created via a lazy constructor from
<code>optimum.neuron.distributed.utils.make_optimizer_constructor_lazy</code>, it which case the exactly intended optimizer is
created for tensor parallelism.</li> <li>The optimizer was created with a regular constructor. In this case the optimizer for tensor parallelism
is created as close as possible to what was intended but that is not guaranteed.</li>`,lt,pe,A,at,me,K,Ne,j,He,B,Mt="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",Ie,v,X,it,k,G,nt,ue,Ct="Provides the list of supported model types for parallelization.",ot,T,J,st,ce,kt="Returns a tuple of 3 booleans where:",dt,_e,Lt="<li>The first element indicates if tensor parallelism can be used for this model,</li> <li>The second element indicates if sequence parallelism can be used on top of tensor parallelism for this model,</li> <li>The third element indicates if pipeline parallelism can be used for this model.</li>",pt,L,Q,mt,he,Dt="Returns the parallelizer class associated to the model.",qe,Y,Oe,Z,Ue,ee,Et="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",Fe,$,te,ut,ge,Nt="Context manager that makes the loading of a model lazy for model parallelism:",ct,be,Ht=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_mp</code> docstring.</li>`,_t,fe,It="If both <code>tensor_parallel_size</code> and <code>pipeline_parallel_size</code> are set to 1, no lazy loading is performed.",Ve,M,re,ht,ze,qt=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,Re,Pe,Se;return H=new ye({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),q=new ye({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),U=new ye({props:{title:"Base Parallelizer",local:"optimum.neuron.distributed.Parallelizer",headingTag:"h3"}}),V=new x({props:{name:"class optimum.neuron.distributed.Parallelizer",anchor:"optimum.neuron.distributed.Parallelizer",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/base.py#L136"}}),R=new x({props:{name:"_parallelize",anchor:"optimum.neuron.distributed.Parallelizer._parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"should_parallelize_layer_predicate_func",val:": typing.Optional[typing.Callable[[torch.nn.modules.module.Module], bool]] = None"},{name:"**parallel_layer_specific_kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.should_parallelize_layer_predicate_func",description:`<strong>should_parallelize_layer_predicate_func</strong> (Optional[Callable[[torch.nn.Module], bool]], defaults to <code>None</code>) &#x2014;
A function that takes a layer as input and returns a boolean specifying if the input layer should be
parallelized. This is useful to skip unnecessary parallelization, for pipeline parallelism for instance.`,name:"should_parallelize_layer_predicate_func"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.*parallel_layer_specific_kwargs",description:`*<strong>*parallel_layer_specific_kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Keyword arguments specific to some parallel layers, they will be ignored by the other parallel layers.`,name:"*parallel_layer_specific_kwargs"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/base.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),S=new x({props:{name:"parallelize",anchor:"optimum.neuron.distributed.Parallelizer.parallelize",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), optimum.neuron.utils.peft_utils.NeuronPeftModel]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"kv_size_multiplier",val:": typing.Optional[int] = None"},{name:"pipeline_parallel_input_names",val:": typing.Union[typing.Tuple[str, ...], typing.Dict[str, typing.Tuple[str, ...]], NoneType] = None"},{name:"pipeline_parallel_num_microbatches",val:": int = 1"},{name:"pipeline_parallel_use_zero1_optimizer",val:": bool = False"},{name:"pipeline_parallel_gradient_checkpointing_enabled",val:": bool = False"},{name:"checkpoint_dir",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"num_local_ranks_per_step",val:": int = 8"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, NeuronPeftModel]</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.kv_size_multiplier",description:`<strong>kv_size_multiplier</strong> (<code>Optional[int], defaults to </code>None\`) &#x2014;
The number of times to replicate the KV heads when the TP size is bigger than the number of KV heads.
If left unspecified, the smallest multiplier that makes the number of KV heads divisible by the TP size
will be used.`,name:"kv_size_multiplier"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_num_microbatches",description:`<strong>pipeline_parallel_num_microbatches</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of microbatches used for pipeline execution.`,name:"pipeline_parallel_num_microbatches"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_use_zero1_optimizer",description:`<strong>pipeline_parallel_use_zero1_optimizer</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When zero-1 optimizer is used, set this to True, so the PP model will understand that zero-1 optimizer
will handle data parallel gradient averaging.`,name:"pipeline_parallel_use_zero1_optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_gradient_checkpointing_enabled",description:`<strong>pipeline_parallel_gradient_checkpointing_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not gradient checkpointing should be enabled when doing pipeline parallelism.`,name:"pipeline_parallel_gradient_checkpointing_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>Optional[Union[str, Path]]</code>) &#x2014;
Path to a sharded checkpoint. If specified, the checkpoint weights will be loaded to the parallelized
model.`,name:"checkpoint_dir"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.num_local_ranks_per_step",description:`<strong>num_local_ranks_per_step</strong> (<code>int</code>, defaults to <code>8</code>) &#x2014;
Corresponds to the number of local ranks that can initialize and load the model weights at the same
time. If the value is inferior to 0, the maximum number of ranks will be used.`,name:"num_local_ranks_per_step"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/base.py#L503",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),W=new x({props:{name:"optimizer_for_mp",anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"orig_param_to_parallel_param_on_xla",val:": typing.Mapping[int, ForwardRef('torch.nn.Parameter')]"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
The original optimizer.`,name:"optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.orig_param_to_parallel_param_on_xla",description:`<strong>orig_param_to_parallel_param_on_xla</strong> (<code>Mapping[int, torch.nn.Parameter]</code>) &#x2014;
A mapping (e.g. dict-like) that maps the id of a parameter in <code>optimizer</code> to the id of its
parallelized counterpart on an XLA device.`,name:"orig_param_to_parallel_param_on_xla"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/base.py#L916",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor parallelism ready optimizer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.optim.Optimizer</code></p>
`}}),A=new x({props:{name:"save_model_sharded_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.save_model_sharded_checkpoint",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('NxDPPModel')]"},{name:"output_dir",val:": typing.Union[str, pathlib.Path]"},{name:"optimizer",val:": typing.Optional[ForwardRef('torch.optim.Optimizer')] = None"},{name:"use_xser",val:": bool = True"},{name:"async_save",val:": bool = False"},{name:"num_local_ranks_per_step",val:": int = 8"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/base.py#L956"}}),K=new x({props:{name:"load_model_sharded_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.load_model_sharded_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"load_dir",val:": typing.Union[str, pathlib.Path]"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/base.py#L1037"}}),j=new ye({props:{title:"Selecting Model-Specific Parallelizer Classes",local:"optimum.neuron.distributed.ParallelizersManager",headingTag:"h3"}}),X=new x({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/parallelizers_manager.py#L53"}}),G=new x({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/parallelizers_manager.py#L66"}}),J=new x({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": typing.Union[str, transformers.modeling_utils.PreTrainedModel, optimum.neuron.utils.peft_utils.NeuronPeftModel]"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/parallelizers_manager.py#L89"}}),Q=new x({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": typing.Union[str, transformers.modeling_utils.PreTrainedModel, optimum.neuron.utils.peft_utils.NeuronPeftModel]"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/parallelizers_manager.py#L114"}}),Y=new ye({props:{title:"Utils",local:"utils",headingTag:"h2"}}),Z=new ye({props:{title:"Lazy Loading",local:"optimum.neuron.distributed.lazy_load_for_parallelism",headingTag:"h3"}}),te=new x({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"},{name:"pipeline_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The tensor parallel size considered.`,name:"tensor_parallel_size"},{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.pipeline_parallel_size",description:`<strong>pipeline_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The pipeline parallel size considered.`,name:"pipeline_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/utils.py#L1614"}}),re=new x({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": typing.Type[ForwardRef('torch.optim.Optimizer')]"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.28.dev1/optimum/neuron/distributed/utils.py#L1661"}}),{c(){w=n("meta"),Te=l(),xe=n("p"),we=l(),m(H.$$.fragment),Me=l(),I=n("p"),I.innerHTML=bt,Ce=l(),m(q.$$.fragment),ke=l(),O=n("p"),O.innerHTML=ft,Le=l(),m(U.$$.fragment),De=l(),F=n("p"),F.innerHTML=zt,Ee=l(),p=n("div"),m(V.$$.fragment),Be=l(),le=n("p"),le.textContent=vt,Xe=l(),C=n("div"),m(R.$$.fragment),Ge=l(),ae=n("p"),ae.textContent=$t,Je=l(),P=n("div"),m(S.$$.fragment),Qe=l(),ie=n("p"),ie.innerHTML=yt,Ye=l(),ne=n("p"),ne.textContent=xt,Ze=l(),y=n("div"),m(W.$$.fragment),et=l(),oe=n("p"),oe.textContent=Pt,tt=l(),se=n("p"),se.textContent=Tt,rt=l(),de=n("ol"),de.innerHTML=wt,lt=l(),pe=n("div"),m(A.$$.fragment),at=l(),me=n("div"),m(K.$$.fragment),Ne=l(),m(j.$$.fragment),He=l(),B=n("p"),B.innerHTML=Mt,Ie=l(),v=n("div"),m(X.$$.fragment),it=l(),k=n("div"),m(G.$$.fragment),nt=l(),ue=n("p"),ue.textContent=Ct,ot=l(),T=n("div"),m(J.$$.fragment),st=l(),ce=n("p"),ce.textContent=kt,dt=l(),_e=n("ul"),_e.innerHTML=Lt,pt=l(),L=n("div"),m(Q.$$.fragment),mt=l(),he=n("p"),he.textContent=Dt,qe=l(),m(Y.$$.fragment),Oe=l(),m(Z.$$.fragment),Ue=l(),ee=n("p"),ee.textContent=Et,Fe=l(),$=n("div"),m(te.$$.fragment),ut=l(),ge=n("p"),ge.textContent=Nt,ct=l(),be=n("ul"),be.innerHTML=Ht,_t=l(),fe=n("p"),fe.innerHTML=It,Ve=l(),M=n("div"),m(re.$$.fragment),ht=l(),ze=n("p"),ze.textContent=qt,Re=l(),Pe=n("p"),this.h()},l(e){const i=At("svelte-u9bgzb",document.head);w=o(i,"META",{name:!0,content:!0}),i.forEach(r),Te=a(e),xe=o(e,"P",{}),f(xe).forEach(r),we=a(e),u(H.$$.fragment,e),Me=a(e),I=o(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-it0u39"&&(I.innerHTML=bt),Ce=a(e),u(q.$$.fragment,e),ke=a(e),O=o(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-5ss4zj"&&(O.innerHTML=ft),Le=a(e),u(U.$$.fragment,e),De=a(e),F=o(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1bsvcro"&&(F.innerHTML=zt),Ee=a(e),p=o(e,"DIV",{class:!0});var b=f(p);u(V.$$.fragment,b),Be=a(b),le=o(b,"P",{"data-svelte-h":!0}),d(le)!=="svelte-h4ipsc"&&(le.textContent=vt),Xe=a(b),C=o(b,"DIV",{class:!0});var We=f(C);u(R.$$.fragment,We),Ge=a(We),ae=o(We,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1e0iews"&&(ae.textContent=$t),We.forEach(r),Je=a(b),P=o(b,"DIV",{class:!0});var ve=f(P);u(S.$$.fragment,ve),Qe=a(ve),ie=o(ve,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1ytdrar"&&(ie.innerHTML=yt),Ye=a(ve),ne=o(ve,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-3oskg6"&&(ne.textContent=xt),ve.forEach(r),Ze=a(b),y=o(b,"DIV",{class:!0});var D=f(y);u(W.$$.fragment,D),et=a(D),oe=o(D,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-gytsrb"&&(oe.textContent=Pt),tt=a(D),se=o(D,"P",{"data-svelte-h":!0}),d(se)!=="svelte-k6ubrx"&&(se.textContent=Tt),rt=a(D),de=o(D,"OL",{"data-svelte-h":!0}),d(de)!=="svelte-ogaf4b"&&(de.innerHTML=wt),D.forEach(r),lt=a(b),pe=o(b,"DIV",{class:!0});var Ot=f(pe);u(A.$$.fragment,Ot),Ot.forEach(r),at=a(b),me=o(b,"DIV",{class:!0});var Ut=f(me);u(K.$$.fragment,Ut),Ut.forEach(r),b.forEach(r),Ne=a(e),u(j.$$.fragment,e),He=a(e),B=o(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1x1mrd0"&&(B.innerHTML=Mt),Ie=a(e),v=o(e,"DIV",{class:!0});var E=f(v);u(X.$$.fragment,E),it=a(E),k=o(E,"DIV",{class:!0});var Ae=f(k);u(G.$$.fragment,Ae),nt=a(Ae),ue=o(Ae,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-esrxt2"&&(ue.textContent=Ct),Ae.forEach(r),ot=a(E),T=o(E,"DIV",{class:!0});var $e=f(T);u(J.$$.fragment,$e),st=a($e),ce=o($e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1pefsnq"&&(ce.textContent=kt),dt=a($e),_e=o($e,"UL",{"data-svelte-h":!0}),d(_e)!=="svelte-1dpu6ok"&&(_e.innerHTML=Lt),$e.forEach(r),pt=a(E),L=o(E,"DIV",{class:!0});var Ke=f(L);u(Q.$$.fragment,Ke),mt=a(Ke),he=o(Ke,"P",{"data-svelte-h":!0}),d(he)!=="svelte-3qe9b8"&&(he.textContent=Dt),Ke.forEach(r),E.forEach(r),qe=a(e),u(Y.$$.fragment,e),Oe=a(e),u(Z.$$.fragment,e),Ue=a(e),ee=o(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-4ddlue"&&(ee.textContent=Et),Fe=a(e),$=o(e,"DIV",{class:!0});var N=f($);u(te.$$.fragment,N),ut=a(N),ge=o(N,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-bh7x4"&&(ge.textContent=Nt),ct=a(N),be=o(N,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-1j7gypf"&&(be.innerHTML=Ht),_t=a(N),fe=o(N,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-oha5tr"&&(fe.innerHTML=It),N.forEach(r),Ve=a(e),M=o(e,"DIV",{class:!0});var je=f(M);u(re.$$.fragment,je),ht=a(je),ze=o(je,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1agud9l"&&(ze.textContent=qt),je.forEach(r),Re=a(e),Pe=o(e,"P",{}),f(Pe).forEach(r),this.h()},h(){z(w,"name","hf:doc:metadata"),z(w,"content",jt),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,w),s(e,Te,i),s(e,xe,i),s(e,we,i),c(H,e,i),s(e,Me,i),s(e,I,i),s(e,Ce,i),c(q,e,i),s(e,ke,i),s(e,O,i),s(e,Le,i),c(U,e,i),s(e,De,i),s(e,F,i),s(e,Ee,i),s(e,p,i),c(V,p,null),t(p,Be),t(p,le),t(p,Xe),t(p,C),c(R,C,null),t(C,Ge),t(C,ae),t(p,Je),t(p,P),c(S,P,null),t(P,Qe),t(P,ie),t(P,Ye),t(P,ne),t(p,Ze),t(p,y),c(W,y,null),t(y,et),t(y,oe),t(y,tt),t(y,se),t(y,rt),t(y,de),t(p,lt),t(p,pe),c(A,pe,null),t(p,at),t(p,me),c(K,me,null),s(e,Ne,i),c(j,e,i),s(e,He,i),s(e,B,i),s(e,Ie,i),s(e,v,i),c(X,v,null),t(v,it),t(v,k),c(G,k,null),t(k,nt),t(k,ue),t(v,ot),t(v,T),c(J,T,null),t(T,st),t(T,ce),t(T,dt),t(T,_e),t(v,pt),t(v,L),c(Q,L,null),t(L,mt),t(L,he),s(e,qe,i),c(Y,e,i),s(e,Oe,i),c(Z,e,i),s(e,Ue,i),s(e,ee,i),s(e,Fe,i),s(e,$,i),c(te,$,null),t($,ut),t($,ge),t($,ct),t($,be),t($,_t),t($,fe),s(e,Ve,i),s(e,M,i),c(re,M,null),t(M,ht),t(M,ze),s(e,Re,i),s(e,Pe,i),Se=!0},p:Vt,i(e){Se||(_(H.$$.fragment,e),_(q.$$.fragment,e),_(U.$$.fragment,e),_(V.$$.fragment,e),_(R.$$.fragment,e),_(S.$$.fragment,e),_(W.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(j.$$.fragment,e),_(X.$$.fragment,e),_(G.$$.fragment,e),_(J.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(Z.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),Se=!0)},o(e){h(H.$$.fragment,e),h(q.$$.fragment,e),h(U.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(j.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(Z.$$.fragment,e),h(te.$$.fragment,e),h(re.$$.fragment,e),Se=!1},d(e){e&&(r(Te),r(xe),r(we),r(Me),r(I),r(Ce),r(ke),r(O),r(Le),r(De),r(F),r(Ee),r(p),r(Ne),r(He),r(B),r(Ie),r(v),r(qe),r(Oe),r(Ue),r(ee),r(Fe),r($),r(Ve),r(M),r(Re),r(Pe)),r(w),g(H,e),g(q,e),g(U,e),g(V),g(R),g(S),g(W),g(A),g(K),g(j,e),g(X),g(G),g(J),g(Q),g(Y,e),g(Z,e),g(te),g(re)}}}const jt='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Base Parallelizer","local":"optimum.neuron.distributed.Parallelizer","sections":[],"depth":3},{"title":"Selecting Model-Specific Parallelizer Classes","local":"optimum.neuron.distributed.ParallelizersManager","sections":[],"depth":3}],"depth":2},{"title":"Utils","local":"utils","sections":[{"title":"Lazy Loading","local":"optimum.neuron.distributed.lazy_load_for_parallelism","sections":[],"depth":3}],"depth":2}],"depth":1}';function Bt(gt){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends St{constructor(w){super(),Wt(this,w,Bt,Kt,Ft,{})}}export{Yt as component};
