import{s as Qs,n as Fs,o as Ys}from"../chunks/scheduler.c59d9fbb.js";import{S as Ss,i as Hs,g as M,s as a,r as m,A as qs,h as p,f as e,c as n,j as Ns,u as i,x as j,k as zs,y as Ls,a as t,v as J,d as c,t as o,w as y}from"../chunks/index.a47918e3.js";import{C as w}from"../chunks/CodeBlock.f26209eb.js";import{H as wl,E as Ks}from"../chunks/index.0513ac52.js";function Ps(ws){let r,rl,ol,Tl,T,dl,d,rs='<a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit</a> is a technique for few-shot text classification that uses contrastive learning to fine-tune Sentence Transformers in domains where little to no labeled data is available. It achieves comparable performance to existing state-of-the-art methods based on large language models, yet requires no prompts and is efficient to train (typically a few seconds on a GPU to minutes on a CPU).',Ul,U,Ts="In this notebook you’ll learn how to further compress SetFit models for faster inference & deployment on GPU using Optimum Onnx.",hl,h,ul,u,ds="Our first step is to install SetFit. Running the following cell will install all the required packages for us.",bl,b,Il,I,fl,f,Us="Before we train and optimize any models, let’s define a performance benchmark that we can use to compare our models. In general, deploying ML models in production environments involves a tradeoff among several constraints:",Cl,C,hs="<li>Model performance: how well does the model perform on a well crafted test set?</li> <li>Latency: how fast can our model deliver predictions?</li> <li>Memory: on what cloud instance or device can we store and load our model?</li>",Al,A,us="The class below defines a simple benchmark that measure each quantity for a given SetFit model and test dataset:",Zl,Z,Bl,B,bs="Beyond that, we’ll create a simple function to plot the performances reported by this benchmark.",Wl,W,Gl,G,Xl,X,Is='Before we optimize any models, let’s train a few baselines as a point of reference. We’ll use the <a href="https://huggingface.co/datasets/SetFit/sst2" rel="nofollow">sst-2</a> dataset, which is a collection of sentiment text catagorized into 2 classes: positive, negative',_l,_,fs="Let’s start by loading the dataset from the Hub:",kl,k,Rl,R,gl,g,Cs="We train a SetFit model with the full dataset. Recall that SetFit excels with few-shot scenario, but this time we are interested to achieve maximum accuracy.",El,E,xl,x,As='Use the following line code to download the <a href="https://huggingface.co/moshew/bge-small-en-v1.5_setfit-sst2-english" rel="nofollow">already finetuned model</a> and evaluate. Alternatively, uncomment the code below it to fine-tune the base model from scratch.',Vl,V,Zs="Note that we perform the evaluations on Google Colab using the free T4 GPU.",vl,v,$l,$,Nl,N,zl,z,Bs="Let’s plot the results to visualise the performance:",Ql,Q,Fl,F,Ws='<img src="https://github.com/huggingface/setfit/assets/37621491/4786eee6-88c8-46ca-95be-801514697a9d" alt="setfit_torch"/>',Yl,Y,Sl,S,Gs='We’ll be using Optimum’s ONNX Runtime support with <code>CUDAExecutionProvider</code> <a href="https://github.com/huggingface/optimum-benchmark/tree/main/examples/fast-mteb#notes" rel="nofollow">because it’s fast while also supporting dynamic shapes</a>.',Hl,H,ql,q,Xs='<a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/optimization#optimizing-a-model-during-the-onnx-export" rel="nofollow"><code>optimum-cli</code></a> makes it extremely easy to export a model to ONNX and apply SOTA graph optimizations / kernel fusions.',Ll,L,Kl,K,_s="We may see some warnings, but these are not ones to be concerned about. We’ll see later that it does not affect the model performance.",Pl,P,ks="First of all, we’ll create a subclass of our performance benchmark to also allow benchmarking ONNX models.",Dl,D,Ol,O,Rs="Then, we can load the converted SentenceTransformer model with the <code>&quot;CUDAExecutionProvider&quot;</code> provider. Feel free to also experiment with other providers, such as <code>&quot;TensorrtExecutionProvider&quot;</code> and <code>&quot;CPUExecutionProvider&quot;</code>. The former may be even faster than <code>&quot;CUDAExecutionProvider&quot;</code>, but requires more installation.",ls,ll,ss,sl,gs="And let’s make a class that uses the tokenizer, ONNX Runtime (ORT) model and a SetFit model head.",es,el,ts,tl,Es="We can initialize this model like so:",as,al,ns,nl,Ms,Ml,xs="Time to benchmark this ONNX model.",ps,pl,ms,ml,is,il,Vs='<img src="https://github.com/huggingface/setfit/assets/37621491/9907ec1d-d4c6-431d-8695-1adc4247a576" alt="setfit_onnx"/>',js,jl,vs="By applying ONNX, we were able to improve the latency from 13.43ms per sample to 2.19ms per sample, for a speedup of 6.13x!",Js,Jl,$s="For further improvements, we recommend increasing the inference batch size, as this may also heavily improve the throughput. For example, setting the batch size to 128 reduces the latency further down to 0.3ms, and down to 0.2ms at a batch size of 2048.",cs,cl,os,yl,ys;return T=new wl({props:{title:"Efficiently run SetFit Models with Optimum",local:"efficiently-run-setfit-models-with-optimum",headingTag:"h1"}}),h=new wl({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),b=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzZXRmaXQlMjBhY2NlbGVyYXRlJTIwLXFxcQ==",highlighted:'!pip <span class="hljs-keyword">install</span> setfit accelerate -qqq',wrap:!1}}),I=new wl({props:{title:"2. Create a performance benchmark",local:"2-create-a-performance-benchmark",headingTag:"h2"}}),Z=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> perf_counter

<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PerformanceBenchmark</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model, dataset, optim_type</span>):
        self.model = model
        self.dataset = dataset
        self.optim_type = optim_type

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_accuracy</span>(<span class="hljs-params">self</span>):
        preds = self.model.predict(self.dataset[<span class="hljs-string">&quot;text&quot;</span>])
        labels = self.dataset[<span class="hljs-string">&quot;label&quot;</span>]
        accuracy = metric.compute(predictions=preds, references=labels)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Accuracy on test set - <span class="hljs-subst">{accuracy[<span class="hljs-string">&#x27;accuracy&#x27;</span>]:<span class="hljs-number">.3</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> accuracy

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_size</span>(<span class="hljs-params">self</span>):
        state_dict = self.model.model_body.state_dict()
        tmp_path = Path(<span class="hljs-string">&quot;model.pt&quot;</span>)
        torch.save(state_dict, tmp_path)
        <span class="hljs-comment"># Calculate size in megabytes</span>
        size_mb = Path(tmp_path).stat().st_size / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)
        <span class="hljs-comment"># Delete temporary file</span>
        tmp_path.unlink()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model size (MB) - <span class="hljs-subst">{size_mb:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;size_mb&quot;</span>: size_mb}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">time_model</span>(<span class="hljs-params">self, query=<span class="hljs-string">&quot;that loves its characters and communicates something rather beautiful about human nature&quot;</span></span>):
        latencies = []
        <span class="hljs-comment"># Warmup</span>
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
            _ = self.model([query])
        <span class="hljs-comment"># Timed run</span>
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">100</span>):
            start_time = perf_counter()
            _ = self.model([query])
            latency = perf_counter() - start_time
            latencies.append(latency)
        <span class="hljs-comment"># Compute run statistics</span>
        time_avg_ms = <span class="hljs-number">1000</span> * np.mean(latencies)
        time_std_ms = <span class="hljs-number">1000</span> * np.std(latencies)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">rf&quot;Average latency (ms) - <span class="hljs-subst">{time_avg_ms:<span class="hljs-number">.2</span>f}</span> +\\- <span class="hljs-subst">{time_std_ms:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;time_avg_ms&quot;</span>: time_avg_ms, <span class="hljs-string">&quot;time_std_ms&quot;</span>: time_std_ms}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_benchmark</span>(<span class="hljs-params">self</span>):
        metrics = {}
        metrics[self.optim_type] = self.compute_size()
        metrics[self.optim_type].update(self.compute_accuracy())
        metrics[self.optim_type].update(self.time_model())
        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),W=new w({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEElMEFkZWYlMjBwbG90X21ldHJpY3MocGVyZl9tZXRyaWNzKSUzQSUwQSUyMCUyMCUyMCUyMGRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChwZXJmX21ldHJpY3MlMkMlMjBvcmllbnQlM0QlMjJpbmRleCUyMiklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBpZHglMjBpbiUyMGRmLmluZGV4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGZfb3B0JTIwJTNEJTIwZGYubG9jJTVCaWR4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0LmVycm9yYmFyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRmX29wdCU1QiUyMnRpbWVfYXZnX21zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGZfb3B0JTVCJTIyYWNjdXJhY3klMjIlNUQlMjAqJTIwMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweGVyciUzRGRmX29wdCU1QiUyMnRpbWVfc3RkX21zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm10JTNEJTIybyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbXMlM0RkZl9vcHQlNUIlMjJzaXplX21iJTIyJTVEJTIwJTJGJTIwMTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbCUzRGlkeCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcHNpemUlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FwdGhpY2slM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGxlZ2VuZCUyMCUzRCUyMHBsdC5sZWdlbmQobG9jJTNEJTIybG93ZXIlMjByaWdodCUyMiklMEElMEElMjAlMjAlMjAlMjBwbHQueWxpbSg2MyUyQyUyMDk1KSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHNsb3dlc3QlMjBtb2RlbCUyMHRvJTIwZGVmaW5lJTIwdGhlJTIweC1heGlzJTIwcmFuZ2UlMEElMjAlMjAlMjAlMjB4bGltJTIwJTNEJTIwbWF4KCU1Qm1ldHJpY3MlNUIlMjJ0aW1lX2F2Z19tcyUyMiU1RCUyMGZvciUyMG1ldHJpY3MlMjBpbiUyMHBlcmZfbWV0cmljcy52YWx1ZXMoKSU1RCklMjAqJTIwMS4yJTBBJTIwJTIwJTIwJTIwcGx0LnhsaW0oMCUyQyUyMHhsaW0pJTBBJTIwJTIwJTIwJTIwcGx0LnlsYWJlbCglMjJBY2N1cmFjeSUyMCglMjUpJTIyKSUwQSUyMCUyMCUyMCUyMHBsdC54bGFiZWwoJTIyQXZlcmFnZSUyMGxhdGVuY3klMjB3aXRoJTIwYmF0Y2hfc2l6ZSUzRDElMjAobXMpJTIyKSUwQSUyMCUyMCUyMCUyMHBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_metrics</span>(<span class="hljs-params">perf_metrics</span>):
    df = pd.DataFrame.from_dict(perf_metrics, orient=<span class="hljs-string">&quot;index&quot;</span>)

    <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> df.index:
        df_opt = df.loc[idx]
        plt.errorbar(
            df_opt[<span class="hljs-string">&quot;time_avg_ms&quot;</span>],
            df_opt[<span class="hljs-string">&quot;accuracy&quot;</span>] * <span class="hljs-number">100</span>,
            xerr=df_opt[<span class="hljs-string">&quot;time_std_ms&quot;</span>],
            fmt=<span class="hljs-string">&quot;o&quot;</span>,
            alpha=<span class="hljs-number">0.5</span>,
            ms=df_opt[<span class="hljs-string">&quot;size_mb&quot;</span>] / <span class="hljs-number">15</span>,
            label=idx,
            capsize=<span class="hljs-number">5</span>,
            capthick=<span class="hljs-number">1</span>,
        )

    legend = plt.legend(loc=<span class="hljs-string">&quot;lower right&quot;</span>)

    plt.ylim(<span class="hljs-number">63</span>, <span class="hljs-number">95</span>)
    <span class="hljs-comment"># Use the slowest model to define the x-axis range</span>
    xlim = <span class="hljs-built_in">max</span>([metrics[<span class="hljs-string">&quot;time_avg_ms&quot;</span>] <span class="hljs-keyword">for</span> metrics <span class="hljs-keyword">in</span> perf_metrics.values()]) * <span class="hljs-number">1.2</span>
    plt.xlim(<span class="hljs-number">0</span>, xlim)
    plt.ylabel(<span class="hljs-string">&quot;Accuracy (%)&quot;</span>)
    plt.xlabel(<span class="hljs-string">&quot;Average latency with batch_size=1 (ms)&quot;</span>)
    plt.show()`,wrap:!1}}),G=new wl({props:{title:"3. Train/evaluate bge-small SetFit models",local:"3-trainevaluate-bge-small-setfit-models",headingTag:"h2"}}),k=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTZXRGaXQlMkZzc3QyJTIyKSUwQWRhdGFzZXQ=",highlighted:`from datasets import load_dataset

<span class="hljs-attribute">dataset</span> <span class="hljs-operator">=</span> load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
dataset`,wrap:!1}}),R=new w({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyUyQyUyMCdsYWJlbF90ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjkyMCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB2YWxpZGF0aW9uJTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclMkMlMjAnbGFiZWxfdGV4dCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDg3MiUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclMkMlMjAnbGFiZWxfdGV4dCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDE4MjElMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">6920</span>
    })
    validation: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">872</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">1821</span>
    })
})`,wrap:!1}}),E=new w({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ2YWxpZGF0aW9uJTIyJTVE",highlighted:`train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>]
test_dataset = dataset[<span class="hljs-string">&quot;validation&quot;</span>]`,wrap:!1}}),v=new w({props:{code:"JTIzJTIwRXZhbHVhdGUlMjB0aGUlMjB1cGxvYWRlZCUyMG1vZGVsISUwQWZyb20lMjBzZXRmaXQlMjBpbXBvcnQlMjBTZXRGaXRNb2RlbCUwQSUwQXNtYWxsX21vZGVsJTIwJTNEJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2hldyUyRmJnZS1zbWFsbC1lbi12MS41X3NldGZpdC1zc3QyLWVuZ2xpc2glMjIpJTBBcGIlMjAlM0QlMjBQZXJmb3JtYW5jZUJlbmNobWFyayhtb2RlbCUzRHNtYWxsX21vZGVsJTJDJTIwZGF0YXNldCUzRHRlc3RfZGF0YXNldCUyQyUyMG9wdGltX3R5cGUlM0QlMjJiZ2Utc21hbGwlMjAoUHlUb3JjaCklMjIpJTBBcGVyZl9tZXRyaWNzJTIwJTNEJTIwcGIucnVuX2JlbmNobWFyaygp",highlighted:`<span class="hljs-comment"># Evaluate the uploaded model!</span>
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

small_model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;moshew/bge-small-en-v1.5_setfit-sst2-english&quot;</span>)
pb = PerformanceBenchmark(model=small_model, dataset=test_dataset, optim_type=<span class="hljs-string">&quot;bge-small (PyTorch)&quot;</span>)
perf_metrics = pb.run_benchmark()`,wrap:!1}}),$=new w({props:{code:"TW9kZWwlMjBzaXplJTIwKE1CKSUyMC0lMjAxMjcuMzMlMEFBY2N1cmFjeSUyMG9uJTIwdGVzdCUyMHNldCUyMC0lMjAwLjkwNiUwQUF2ZXJhZ2UlMjBsYXRlbmN5JTIwKG1zKSUyMC0lMjAxNy40MiUyMCUyQiU1Qy0lMjA0LjQ3",highlighted:`<span class="hljs-attribute">Model</span> size (MB) - <span class="hljs-number">127</span>.<span class="hljs-number">33</span>
<span class="hljs-attribute">Accuracy</span> <span class="hljs-literal">on</span> test set - <span class="hljs-number">0</span>.<span class="hljs-number">906</span>
<span class="hljs-attribute">Average</span> latency (ms) - <span class="hljs-number">17</span>.<span class="hljs-number">42</span> +\\- <span class="hljs-number">4</span>.<span class="hljs-number">47</span>`,wrap:!1}}),N=new w({props:{code:"JTIzJTIwJTIzJTIwRmluZS10dW5lJTIwdGhlJTIwYmFzZSUyMG1vZGVsJTIwYW5kJTIwRXZhbHVhdGUhJTBBJTIzJTIwZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwVHJhaW5lciUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIzJTIwJTIzJTIwTG9hZCUyMHByZXRyYWluZWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEElMjMlMjBzbWFsbF9tb2RlbCUyMCUzRCUyMFNldEZpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjMlMjAlMjAlMjAlMjAlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIlMEElMjMlMjApJTBBJTIzJTIwYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG51bV9pdGVyYXRpb25zJTNEMjApJTBBJTBBJTIzJTIwJTIzJTIwQ3JlYXRlJTIwdHJhaW5lciUwQSUyMyUyMHNtYWxsX3RyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMyUyMCUyMCUyMCUyMG1vZGVsJTNEc21hbGxfbW9kZWwlMkMlMjBhcmdzJTNEYXJncyUyQyUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTBBJTIzJTIwKSUwQSUyMyUyMCUyMyUyMFRyYWluISUwQSUyMyUyMHNtYWxsX3RyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMCUyMyUyMEV2YWx1YXRlISUwQSUyMyUyMHBiJTIwJTNEJTIwUGVyZm9ybWFuY2VCZW5jaG1hcmsoJTBBJTIzJTIwJTIwJTIwJTIwbW9kZWwlM0RzbWFsbF90cmFpbmVyLm1vZGVsJTJDJTIwZGF0YXNldCUzRHRlc3RfZGF0YXNldCUyQyUyMG9wdGltX3R5cGUlM0QlMjJiZ2Utc21hbGwlMjAoYmFzZSklMjIlMEElMjMlMjApJTBBJTIzJTIwcGVyZl9tZXRyaWNzJTIwJTNEJTIwcGIucnVuX2JlbmNobWFyaygp",highlighted:`<span class="hljs-comment"># # Fine-tune the base model and Evaluate!</span>
<span class="hljs-comment"># from setfit import SetFitModel, Trainer, TrainingArguments</span>

<span class="hljs-comment"># # Load pretrained model from the Hub</span>
<span class="hljs-comment"># small_model = SetFitModel.from_pretrained(</span>
<span class="hljs-comment">#    &quot;BAAI/bge-small-en-v1.5&quot;</span>
<span class="hljs-comment"># )</span>
<span class="hljs-comment"># args = TrainingArguments(num_iterations=20)</span>

<span class="hljs-comment"># # Create trainer</span>
<span class="hljs-comment"># small_trainer = Trainer(</span>
<span class="hljs-comment">#    model=small_model, args=args, train_dataset=train_dataset</span>
<span class="hljs-comment"># )</span>
<span class="hljs-comment"># # Train!</span>
<span class="hljs-comment"># small_trainer.train()</span>

<span class="hljs-comment"># # Evaluate!</span>
<span class="hljs-comment"># pb = PerformanceBenchmark(</span>
<span class="hljs-comment">#    model=small_trainer.model, dataset=test_dataset, optim_type=&quot;bge-small (base)&quot;</span>
<span class="hljs-comment"># )</span>
<span class="hljs-comment"># perf_metrics = pb.run_benchmark()</span>`,wrap:!1}}),Q=new w({props:{code:"cGxvdF9tZXRyaWNzKHBlcmZfbWV0cmljcyk=",highlighted:'<span class="hljs-function"><span class="hljs-title">plot_metrics</span><span class="hljs-params">(perf_metrics)</span></span>',wrap:!1}}),Y=new wl({props:{title:"4. Compressing with Optimum ONNX and CUDAExecutionProvider",local:"4-compressing-with-optimum-onnx-and-cudaexecutionprovider",headingTag:"h2"}}),H=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcHRpbXVtJTVCb25ueHJ1bnRpbWUtZ3B1JTVEJTIwLXFxcQ==",highlighted:'!pip <span class="hljs-keyword">install</span> optimum[onnxruntime-gpu] -qqq',wrap:!1}}),L=new w({props:{code:"IW9wdGltdW0tY2xpJTIwZXhwb3J0JTIwb25ueCUyMCU1QyUwQSUyMCUyMC0tbW9kZWwlMjBtb3NoZXclMkZiZ2Utc21hbGwtZW4tdjEuNV9zZXRmaXQtc3N0Mi1lbmdsaXNoJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwZmVhdHVyZS1leHRyYWN0aW9uJTIwJTVDJTBBJTIwJTIwLS1vcHRpbWl6ZSUyME80JTIwJTVDJTBBJTIwJTIwLS1kZXZpY2UlMjBjdWRhJTIwJTVDJTBBJTIwJTIwYmdlX2F1dG9fb3B0X080",highlighted:`!optimum-cli export onnx \\
  --model moshew/bge-small-en-v1<span class="hljs-number">.5</span>_setfit-sst2-english \\
  --task feature-extraction \\
  --optimize O4 \\
  --device cuda \\
  bge_auto_opt_O4`,wrap:!1}}),D=new w({props:{code:"Y2xhc3MlMjBPbm54UGVyZm9ybWFuY2VCZW5jaG1hcmsoUGVyZm9ybWFuY2VCZW5jaG1hcmspJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMCphcmdzJTJDJTIwbW9kZWxfcGF0aCUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsX3BhdGglMjAlM0QlMjBtb2RlbF9wYXRoJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9zaXplKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZV9tYiUyMCUzRCUyMFBhdGgoc2VsZi5tb2RlbF9wYXRoKS5zdGF0KCkuc3Rfc2l6ZSUyMCUyRiUyMCgxMDI0JTIwKiUyMDEwMjQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMk1vZGVsJTIwc2l6ZSUyMChNQiklMjAtJTIwJTdCc2l6ZV9tYiUzQS4yZiU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJzaXplX21iJTIyJTNBJTIwc2l6ZV9tYiU3RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">OnnxPerformanceBenchmark</span>(<span class="hljs-title class_ inherited__">PerformanceBenchmark</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, *args, model_path, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(*args, **kwargs)
        self.model_path = model_path

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_size</span>(<span class="hljs-params">self</span>):
        size_mb = Path(self.model_path).stat().st_size / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model size (MB) - <span class="hljs-subst">{size_mb:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;size_mb&quot;</span>: size_mb}`,wrap:!1}}),ll=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nRmFjZSUyMEh1YiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCdiZ2VfYXV0b19vcHRfTzQnJTJDJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDUxMiklMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvckZlYXR1cmVFeHRyYWN0aW9uLmZyb21fcHJldHJhaW5lZCgnYmdlX2F1dG9fb3B0X080JyUyQyUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-comment"># Load model from HuggingFace Hub</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;bge_auto_opt_O4&#x27;</span>, model_max_length=<span class="hljs-number">512</span>)
ort_model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&#x27;bge_auto_opt_O4&#x27;</span>, provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>)`,wrap:!1}}),el=new w({props:{code:"ZnJvbSUyMHNldGZpdC5leHBvcnRlcnMudXRpbHMlMjBpbXBvcnQlMjBtZWFuX3Bvb2xpbmclMEElMEElMEFjbGFzcyUyME9ubnhTZXRGaXRNb2RlbCUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBvcnRfbW9kZWwlMkMlMjB0b2tlbml6ZXIlMkMlMjBtb2RlbF9oZWFkKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYub3J0X21vZGVsJTIwJTNEJTIwb3J0X21vZGVsJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi50b2tlbml6ZXIlMjAlM0QlMjB0b2tlbml6ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsX2hlYWQlMjAlM0QlMjBtb2RlbF9oZWFkJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlZGljdChzZWxmJTJDJTIwaW5wdXRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVuY29kZWRfaW5wdXRzJTIwJTNEJTIwc2VsZi50b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApLnRvKHNlbGYub3J0X21vZGVsLmRldmljZSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwc2VsZi5vcnRfbW9kZWwoKiplbmNvZGVkX2lucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWJlZGRpbmdzJTIwJTNEJTIwbWVhbl9wb29saW5nKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlNUIlMjJsYXN0X2hpZGRlbl9zdGF0ZSUyMiU1RCUyQyUyMGVuY29kZWRfaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5tb2RlbF9oZWFkLnByZWRpY3QoZW1iZWRkaW5ncy5jcHUoKSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwaW5wdXRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYucHJlZGljdChpbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> setfit.exporters.utils <span class="hljs-keyword">import</span> mean_pooling


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OnnxSetFitModel</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, ort_model, tokenizer, model_head</span>):
        self.ort_model = ort_model
        self.tokenizer = tokenizer
        self.model_head = model_head

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">self, inputs</span>):
        encoded_inputs = self.tokenizer(
            inputs, padding=<span class="hljs-literal">True</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        ).to(self.ort_model.device)

        outputs = self.ort_model(**encoded_inputs)
        embeddings = mean_pooling(
            outputs[<span class="hljs-string">&quot;last_hidden_state&quot;</span>], encoded_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
        )
        <span class="hljs-keyword">return</span> self.model_head.predict(embeddings.cpu())

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, inputs</span>):
        <span class="hljs-keyword">return</span> self.predict(inputs)`,wrap:!1}}),al=new w({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybW9zaGV3JTJGYmdlLXNtYWxsLWVuLXYxLjVfc2V0Zml0LXNzdDItZW5nbGlzaCUyMiklMEFvbm54X3NldGZpdF9tb2RlbCUyMCUzRCUyME9ubnhTZXRGaXRNb2RlbChvcnRfbW9kZWwlMkMlMjB0b2tlbml6ZXIlMkMlMjBtb2RlbC5tb2RlbF9oZWFkKSUwQSUwQSUyMyUyMFBlcmZvcm0lMjBpbmZlcmVuY2UlMEFvbm54X3NldGZpdF9tb2RlbCh0ZXN0X2RhdGFzZXQlNUIlMjJ0ZXh0JTIyJTVEJTVCJTNBMiU1RCk=",highlighted:`model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;moshew/bge-small-en-v1.5_setfit-sst2-english&quot;</span>)
onnx_setfit_model = OnnxSetFitModel(ort_model, tokenizer, model.model_head)

<span class="hljs-comment"># Perform inference</span>
onnx_setfit_model(test_dataset[<span class="hljs-string">&quot;text&quot;</span>][:<span class="hljs-number">2</span>])`,wrap:!1}}),nl=new w({props:{code:"YXJyYXkoJTVCMCUyQyUyMDAlNUQp",highlighted:'<span class="hljs-function"><span class="hljs-title">array</span><span class="hljs-params">([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>])</span></span>',wrap:!1}}),pl=new w({props:{code:"cGIlMjAlM0QlMjBPbm54UGVyZm9ybWFuY2VCZW5jaG1hcmsoJTBBJTIwJTIwJTIwJTIwb25ueF9zZXRmaXRfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0ZXN0X2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjAlMjJiZ2Utc21hbGwlMjAob3B0aW11bSUyME9OTlgpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcGF0aCUzRCUyMmJnZV9hdXRvX29wdF9PNCUyRm1vZGVsLm9ubnglMjIlMkMlMEEpJTBBcGVyZl9tZXRyaWNzLnVwZGF0ZShwYi5ydW5fYmVuY2htYXJrKCkp",highlighted:`pb = OnnxPerformanceBenchmark(
    onnx_setfit_model,
    test_dataset,
    <span class="hljs-string">&quot;bge-small (optimum ONNX)&quot;</span>,
    model_path=<span class="hljs-string">&quot;bge_auto_opt_O4/model.onnx&quot;</span>,
)
perf_metrics.update(pb.run_benchmark())`,wrap:!1}}),ml=new w({props:{code:"cGxvdF9tZXRyaWNzKHBlcmZfbWV0cmljcyk=",highlighted:"plot_metrics(perf_metrics)",wrap:!1}}),cl=new Ks({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/tutorials/onnx.mdx"}}),{c(){r=M("meta"),rl=a(),ol=M("p"),Tl=a(),m(T.$$.fragment),dl=a(),d=M("p"),d.innerHTML=rs,Ul=a(),U=M("p"),U.textContent=Ts,hl=a(),m(h.$$.fragment),ul=a(),u=M("p"),u.textContent=ds,bl=a(),m(b.$$.fragment),Il=a(),m(I.$$.fragment),fl=a(),f=M("p"),f.textContent=Us,Cl=a(),C=M("ul"),C.innerHTML=hs,Al=a(),A=M("p"),A.textContent=us,Zl=a(),m(Z.$$.fragment),Bl=a(),B=M("p"),B.textContent=bs,Wl=a(),m(W.$$.fragment),Gl=a(),m(G.$$.fragment),Xl=a(),X=M("p"),X.innerHTML=Is,_l=a(),_=M("p"),_.textContent=fs,kl=a(),m(k.$$.fragment),Rl=a(),m(R.$$.fragment),gl=a(),g=M("p"),g.textContent=Cs,El=a(),m(E.$$.fragment),xl=a(),x=M("p"),x.innerHTML=As,Vl=a(),V=M("p"),V.textContent=Zs,vl=a(),m(v.$$.fragment),$l=a(),m($.$$.fragment),Nl=a(),m(N.$$.fragment),zl=a(),z=M("p"),z.textContent=Bs,Ql=a(),m(Q.$$.fragment),Fl=a(),F=M("p"),F.innerHTML=Ws,Yl=a(),m(Y.$$.fragment),Sl=a(),S=M("p"),S.innerHTML=Gs,Hl=a(),m(H.$$.fragment),ql=a(),q=M("p"),q.innerHTML=Xs,Ll=a(),m(L.$$.fragment),Kl=a(),K=M("p"),K.textContent=_s,Pl=a(),P=M("p"),P.textContent=ks,Dl=a(),m(D.$$.fragment),Ol=a(),O=M("p"),O.innerHTML=Rs,ls=a(),m(ll.$$.fragment),ss=a(),sl=M("p"),sl.textContent=gs,es=a(),m(el.$$.fragment),ts=a(),tl=M("p"),tl.textContent=Es,as=a(),m(al.$$.fragment),ns=a(),m(nl.$$.fragment),Ms=a(),Ml=M("p"),Ml.textContent=xs,ps=a(),m(pl.$$.fragment),ms=a(),m(ml.$$.fragment),is=a(),il=M("p"),il.innerHTML=Vs,js=a(),jl=M("p"),jl.textContent=vs,Js=a(),Jl=M("p"),Jl.textContent=$s,cs=a(),m(cl.$$.fragment),os=a(),yl=M("p"),this.h()},l(l){const s=qs("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(e),rl=n(l),ol=p(l,"P",{}),Ns(ol).forEach(e),Tl=n(l),i(T.$$.fragment,l),dl=n(l),d=p(l,"P",{"data-svelte-h":!0}),j(d)!=="svelte-n86os7"&&(d.innerHTML=rs),Ul=n(l),U=p(l,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1bd8w5"&&(U.textContent=Ts),hl=n(l),i(h.$$.fragment,l),ul=n(l),u=p(l,"P",{"data-svelte-h":!0}),j(u)!=="svelte-yduaqs"&&(u.textContent=ds),bl=n(l),i(b.$$.fragment,l),Il=n(l),i(I.$$.fragment,l),fl=n(l),f=p(l,"P",{"data-svelte-h":!0}),j(f)!=="svelte-13l2fse"&&(f.textContent=Us),Cl=n(l),C=p(l,"UL",{"data-svelte-h":!0}),j(C)!=="svelte-29gjki"&&(C.innerHTML=hs),Al=n(l),A=p(l,"P",{"data-svelte-h":!0}),j(A)!=="svelte-z4wtvv"&&(A.textContent=us),Zl=n(l),i(Z.$$.fragment,l),Bl=n(l),B=p(l,"P",{"data-svelte-h":!0}),j(B)!=="svelte-6tflkv"&&(B.textContent=bs),Wl=n(l),i(W.$$.fragment,l),Gl=n(l),i(G.$$.fragment,l),Xl=n(l),X=p(l,"P",{"data-svelte-h":!0}),j(X)!=="svelte-15nd2qq"&&(X.innerHTML=Is),_l=n(l),_=p(l,"P",{"data-svelte-h":!0}),j(_)!=="svelte-saerdd"&&(_.textContent=fs),kl=n(l),i(k.$$.fragment,l),Rl=n(l),i(R.$$.fragment,l),gl=n(l),g=p(l,"P",{"data-svelte-h":!0}),j(g)!=="svelte-cffqw7"&&(g.textContent=Cs),El=n(l),i(E.$$.fragment,l),xl=n(l),x=p(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-15w8xvk"&&(x.innerHTML=As),Vl=n(l),V=p(l,"P",{"data-svelte-h":!0}),j(V)!=="svelte-1vdmtnq"&&(V.textContent=Zs),vl=n(l),i(v.$$.fragment,l),$l=n(l),i($.$$.fragment,l),Nl=n(l),i(N.$$.fragment,l),zl=n(l),z=p(l,"P",{"data-svelte-h":!0}),j(z)!=="svelte-1r87202"&&(z.textContent=Bs),Ql=n(l),i(Q.$$.fragment,l),Fl=n(l),F=p(l,"P",{"data-svelte-h":!0}),j(F)!=="svelte-3yqnh2"&&(F.innerHTML=Ws),Yl=n(l),i(Y.$$.fragment,l),Sl=n(l),S=p(l,"P",{"data-svelte-h":!0}),j(S)!=="svelte-1tl60qh"&&(S.innerHTML=Gs),Hl=n(l),i(H.$$.fragment,l),ql=n(l),q=p(l,"P",{"data-svelte-h":!0}),j(q)!=="svelte-4oyakg"&&(q.innerHTML=Xs),Ll=n(l),i(L.$$.fragment,l),Kl=n(l),K=p(l,"P",{"data-svelte-h":!0}),j(K)!=="svelte-hhd52e"&&(K.textContent=_s),Pl=n(l),P=p(l,"P",{"data-svelte-h":!0}),j(P)!=="svelte-2m011h"&&(P.textContent=ks),Dl=n(l),i(D.$$.fragment,l),Ol=n(l),O=p(l,"P",{"data-svelte-h":!0}),j(O)!=="svelte-1n59tl1"&&(O.innerHTML=Rs),ls=n(l),i(ll.$$.fragment,l),ss=n(l),sl=p(l,"P",{"data-svelte-h":!0}),j(sl)!=="svelte-1fs19fo"&&(sl.textContent=gs),es=n(l),i(el.$$.fragment,l),ts=n(l),tl=p(l,"P",{"data-svelte-h":!0}),j(tl)!=="svelte-v502qs"&&(tl.textContent=Es),as=n(l),i(al.$$.fragment,l),ns=n(l),i(nl.$$.fragment,l),Ms=n(l),Ml=p(l,"P",{"data-svelte-h":!0}),j(Ml)!=="svelte-1tr4hv1"&&(Ml.textContent=xs),ps=n(l),i(pl.$$.fragment,l),ms=n(l),i(ml.$$.fragment,l),is=n(l),il=p(l,"P",{"data-svelte-h":!0}),j(il)!=="svelte-1yk7uwi"&&(il.innerHTML=Vs),js=n(l),jl=p(l,"P",{"data-svelte-h":!0}),j(jl)!=="svelte-ph4797"&&(jl.textContent=vs),Js=n(l),Jl=p(l,"P",{"data-svelte-h":!0}),j(Jl)!=="svelte-rbx6kg"&&(Jl.textContent=$s),cs=n(l),i(cl.$$.fragment,l),os=n(l),yl=p(l,"P",{}),Ns(yl).forEach(e),this.h()},h(){zs(r,"name","hf:doc:metadata"),zs(r,"content",Ds)},m(l,s){Ls(document.head,r),t(l,rl,s),t(l,ol,s),t(l,Tl,s),J(T,l,s),t(l,dl,s),t(l,d,s),t(l,Ul,s),t(l,U,s),t(l,hl,s),J(h,l,s),t(l,ul,s),t(l,u,s),t(l,bl,s),J(b,l,s),t(l,Il,s),J(I,l,s),t(l,fl,s),t(l,f,s),t(l,Cl,s),t(l,C,s),t(l,Al,s),t(l,A,s),t(l,Zl,s),J(Z,l,s),t(l,Bl,s),t(l,B,s),t(l,Wl,s),J(W,l,s),t(l,Gl,s),J(G,l,s),t(l,Xl,s),t(l,X,s),t(l,_l,s),t(l,_,s),t(l,kl,s),J(k,l,s),t(l,Rl,s),J(R,l,s),t(l,gl,s),t(l,g,s),t(l,El,s),J(E,l,s),t(l,xl,s),t(l,x,s),t(l,Vl,s),t(l,V,s),t(l,vl,s),J(v,l,s),t(l,$l,s),J($,l,s),t(l,Nl,s),J(N,l,s),t(l,zl,s),t(l,z,s),t(l,Ql,s),J(Q,l,s),t(l,Fl,s),t(l,F,s),t(l,Yl,s),J(Y,l,s),t(l,Sl,s),t(l,S,s),t(l,Hl,s),J(H,l,s),t(l,ql,s),t(l,q,s),t(l,Ll,s),J(L,l,s),t(l,Kl,s),t(l,K,s),t(l,Pl,s),t(l,P,s),t(l,Dl,s),J(D,l,s),t(l,Ol,s),t(l,O,s),t(l,ls,s),J(ll,l,s),t(l,ss,s),t(l,sl,s),t(l,es,s),J(el,l,s),t(l,ts,s),t(l,tl,s),t(l,as,s),J(al,l,s),t(l,ns,s),J(nl,l,s),t(l,Ms,s),t(l,Ml,s),t(l,ps,s),J(pl,l,s),t(l,ms,s),J(ml,l,s),t(l,is,s),t(l,il,s),t(l,js,s),t(l,jl,s),t(l,Js,s),t(l,Jl,s),t(l,cs,s),J(cl,l,s),t(l,os,s),t(l,yl,s),ys=!0},p:Fs,i(l){ys||(c(T.$$.fragment,l),c(h.$$.fragment,l),c(b.$$.fragment,l),c(I.$$.fragment,l),c(Z.$$.fragment,l),c(W.$$.fragment,l),c(G.$$.fragment,l),c(k.$$.fragment,l),c(R.$$.fragment,l),c(E.$$.fragment,l),c(v.$$.fragment,l),c($.$$.fragment,l),c(N.$$.fragment,l),c(Q.$$.fragment,l),c(Y.$$.fragment,l),c(H.$$.fragment,l),c(L.$$.fragment,l),c(D.$$.fragment,l),c(ll.$$.fragment,l),c(el.$$.fragment,l),c(al.$$.fragment,l),c(nl.$$.fragment,l),c(pl.$$.fragment,l),c(ml.$$.fragment,l),c(cl.$$.fragment,l),ys=!0)},o(l){o(T.$$.fragment,l),o(h.$$.fragment,l),o(b.$$.fragment,l),o(I.$$.fragment,l),o(Z.$$.fragment,l),o(W.$$.fragment,l),o(G.$$.fragment,l),o(k.$$.fragment,l),o(R.$$.fragment,l),o(E.$$.fragment,l),o(v.$$.fragment,l),o($.$$.fragment,l),o(N.$$.fragment,l),o(Q.$$.fragment,l),o(Y.$$.fragment,l),o(H.$$.fragment,l),o(L.$$.fragment,l),o(D.$$.fragment,l),o(ll.$$.fragment,l),o(el.$$.fragment,l),o(al.$$.fragment,l),o(nl.$$.fragment,l),o(pl.$$.fragment,l),o(ml.$$.fragment,l),o(cl.$$.fragment,l),ys=!1},d(l){l&&(e(rl),e(ol),e(Tl),e(dl),e(d),e(Ul),e(U),e(hl),e(ul),e(u),e(bl),e(Il),e(fl),e(f),e(Cl),e(C),e(Al),e(A),e(Zl),e(Bl),e(B),e(Wl),e(Gl),e(Xl),e(X),e(_l),e(_),e(kl),e(Rl),e(gl),e(g),e(El),e(xl),e(x),e(Vl),e(V),e(vl),e($l),e(Nl),e(zl),e(z),e(Ql),e(Fl),e(F),e(Yl),e(Sl),e(S),e(Hl),e(ql),e(q),e(Ll),e(Kl),e(K),e(Pl),e(P),e(Dl),e(Ol),e(O),e(ls),e(ss),e(sl),e(es),e(ts),e(tl),e(as),e(ns),e(Ms),e(Ml),e(ps),e(ms),e(is),e(il),e(js),e(jl),e(Js),e(Jl),e(cs),e(os),e(yl)),e(r),y(T,l),y(h,l),y(b,l),y(I,l),y(Z,l),y(W,l),y(G,l),y(k,l),y(R,l),y(E,l),y(v,l),y($,l),y(N,l),y(Q,l),y(Y,l),y(H,l),y(L,l),y(D,l),y(ll,l),y(el,l),y(al,l),y(nl,l),y(pl,l),y(ml,l),y(cl,l)}}}const Ds='{"title":"Efficiently run SetFit Models with Optimum","local":"efficiently-run-setfit-models-with-optimum","sections":[{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Create a performance benchmark","local":"2-create-a-performance-benchmark","sections":[],"depth":2},{"title":"3. Train/evaluate bge-small SetFit models","local":"3-trainevaluate-bge-small-setfit-models","sections":[],"depth":2},{"title":"4. Compressing with Optimum ONNX and CUDAExecutionProvider","local":"4-compressing-with-optimum-onnx-and-cudaexecutionprovider","sections":[],"depth":2}],"depth":1}';function Os(ws){return Ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ae extends Ss{constructor(r){super(),Hs(this,r,Os,Ps,Qs,{})}}export{ae as component};
