import{s as dt,n as yt,o as mt}from"../chunks/scheduler.9212057a.js";import{S as wt,i as ht,g as o,s as n,r as M,A as Jt,h as i,f as l,c as a,j as ct,u as c,x as r,k as ut,y as Tt,a as s,v as u,d,t as y,w as m}from"../chunks/index.59dd74e5.js";import{C as D}from"../chunks/CodeBlock.06303aa5.js";import{D as jt}from"../chunks/DocNotebookDropdown.08420028.js";import{H as bt,E as Ut}from"../chunks/EditOnGithub.9be697b9.js";function ft(He){let p,ee,K,te,w,le,h,se,J,qe="Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",ne,T,Xe="But vanilla RAG has limitations, most importantly these two:",ae,j,Qe="<li>It performs only one retrieval step: if the results are bad, the generation in turn will be bad.</li> <li>Semantic similarity is computed with the user query as a reference, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",oe,b,Ve="We can alleviate these problems by making a RAG agent: very simply, an agent armed with a retriever tool!",ie,U,$e="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",re,f,Se="So it should naively recover some advanced RAG techniques!",pe,I,Fe=`<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a>.
The agent can the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a>.</li>`,Me,g,Le="Let’s build this system. 🛠️",ce,v,Ee="Run the line below to install required dependencies:",ue,C,de,Z,ze=`To call the HF Inference API, you will need a valid token as your environment variable <code>HF_TOKEN</code>.
We use python-dotenv to load it.`,ye,B,me,A,Ye="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many Hugging Face libraries, stored as markdown. We will keep only the documentation for the <code>transformers</code> library.",we,k,Pe="Then prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",he,_,De='We use <a href="https://python.langchain.com/docs/introduction/" rel="nofollow">LangChain</a> for its excellent vector database utilities.',Je,R,Te,G,Ke="Now the documents are ready.",je,x,Oe="So let’s build our agentic RAG system!",be,W,et="👉 We only need a RetrieverTool that our agent can leverage to retrieve information from the knowledge base.",Ue,N,tt='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the simple tool constructor with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="../tutorials/tools">tools tutorial</a>.',fe,H,Ie,q,lt=`We have used BM25, a classic retrieval method, because it’s lightning fast to setup.
To improve retrieval accuracy, you could use replace BM25 with semantic search using vector representations for documents: thus you can head to the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> to select a good embedding model.`,ge,X,st="Now it’s straightforward to create an agent that leverages this <code>retriever_tool</code>!",ve,Q,nt="The agent will need these arguments upon initialization:",Ce,V,at=`<li><code>tools</code>: a list of tools that the agent will be able to call.</li> <li><code>model</code>: the LLM that powers the agent.
Our <code>model</code> must be a callable that takes as input a list of messages and returns text. It also needs to accept a stop_sequences argument that indicates when to stop its generation. For convenience, we directly use the HfEngine class provided in the package to get a LLM engine that calls Hugging Face’s Inference API.</li>`,Ze,$,ot='And we use <a href="meta-llama/Llama-3.3-70B-Instruct">meta-llama/Llama-3.3-70B-Instruct</a> as the llm engine because:',Be,S,it="<li>It has a long 128k context, which is helpful for processing long source documents</li> <li>It is served for free at all times on HF’s Inference API!</li>",Ae,F,rt='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',ke,L,_e,E,pt="Upon initializing the CodeAgent, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as code snippets, but you could replace this prompt template with your own as needed.",Re,z,Mt="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, and executing the tool calls, all in a loop that ends only when tool <code>final_answer</code> is called with the final answer as its argument.",Ge,Y,xe,P,We,O,Ne;return w=new bt({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),h=new jt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"}]}}),C=new D({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcGFuZGFzJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install smolagents pandas langchain langchain-community sentence-transformers faiss-cpu --upgrade -q",wrap:!1}}),B=new D({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),R=new D({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5yZXRyaWV2ZXJzJTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWtub3dsZWRnZV9iYXNlJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGtub3dsZWRnZV9iYXNlLmZpbHRlcihsYW1iZGElMjByb3clM0ElMjByb3clNUIlMjJzb3VyY2UlMjIlNUQuc3RhcnRzd2l0aCglMjJodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycyUyMikpJTBBJTBBc291cmNlX2RvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudChwYWdlX2NvbnRlbnQlM0Rkb2MlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwbWV0YWRhdGElM0QlN0IlMjJzb3VyY2UlMjIlM0ElMjBkb2MlNUIlMjJzb3VyY2UlMjIlNUQuc3BsaXQoJTIyJTJGJTIyKSU1QjElNUQlN0QpJTBBJTIwJTIwJTIwJTIwZm9yJTIwZG9jJTIwaW4lMjBrbm93bGVkZ2VfYmFzZSUwQSU1RCUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoJTBBJTIwJTIwJTIwJTIwY2h1bmtfc2l6ZSUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9zdGFydF9pbmRleCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzdHJpcF93aGl0ZXNwYWNlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHNlcGFyYXRvcnMlM0QlNUIlMjIlNUNuJTVDbiUyMiUyQyUyMCUyMiU1Q24lMjIlMkMlMjAlMjIuJTIyJTJDJTIwJTIyJTIwJTIyJTJDJTIwJTIyJTIyJTVEJTJDJTBBKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoc291cmNlX2RvY3Mp",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)`,wrap:!1}}),H=new D({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),L=new D({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJyZXRyaWV2ZXJfdG9vbCU1RCUyQyUyMG1vZGVsJTNESGZBcGlNb2RlbCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4zLTcwQi1JbnN0cnVjdCUyMiklMkMlMjBtYXhfaXRlcmF0aW9ucyUzRDQlMkMlMjB2ZXJib3NlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(
    tools=[retriever_tool], model=HfApiModel(<span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>), max_iterations=<span class="hljs-number">4</span>, verbose=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new D({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkZvciUyMGElMjB0cmFuc2Zvcm1lcnMlMjBtb2RlbCUyMHRyYWluaW5nJTJDJTIwd2hpY2glMjBpcyUyMHNsb3dlciUyQyUyMHRoZSUyMGZvcndhcmQlMjBvciUyMHRoZSUyMGJhY2t3YXJkJTIwcGFzcyUzRiUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`agent_output = agent.run(<span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),P=new Ut({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/rag.md"}}),{c(){p=o("meta"),ee=n(),K=o("p"),te=n(),M(w.$$.fragment),le=n(),M(h.$$.fragment),se=n(),J=o("p"),J.textContent=qe,ne=n(),T=o("p"),T.textContent=Xe,ae=n(),j=o("ul"),j.innerHTML=Qe,oe=n(),b=o("p"),b.textContent=Ve,ie=n(),U=o("p"),U.textContent=$e,re=n(),f=o("p"),f.textContent=Se,pe=n(),I=o("ul"),I.innerHTML=Fe,Me=n(),g=o("p"),g.textContent=Le,ce=n(),v=o("p"),v.textContent=Ee,ue=n(),M(C.$$.fragment),de=n(),Z=o("p"),Z.innerHTML=ze,ye=n(),M(B.$$.fragment),me=n(),A=o("p"),A.innerHTML=Ye,we=n(),k=o("p"),k.textContent=Pe,he=n(),_=o("p"),_.innerHTML=De,Je=n(),M(R.$$.fragment),Te=n(),G=o("p"),G.textContent=Ke,je=n(),x=o("p"),x.textContent=Oe,be=n(),W=o("p"),W.textContent=et,Ue=n(),N=o("p"),N.innerHTML=tt,fe=n(),M(H.$$.fragment),Ie=n(),q=o("p"),q.innerHTML=lt,ge=n(),X=o("p"),X.innerHTML=st,ve=n(),Q=o("p"),Q.textContent=nt,Ce=n(),V=o("ul"),V.innerHTML=at,Ze=n(),$=o("p"),$.innerHTML=ot,Be=n(),S=o("ul"),S.innerHTML=it,Ae=n(),F=o("p"),F.innerHTML=rt,ke=n(),M(L.$$.fragment),_e=n(),E=o("p"),E.textContent=pt,Re=n(),z=o("p"),z.innerHTML=Mt,Ge=n(),M(Y.$$.fragment),xe=n(),M(P.$$.fragment),We=n(),O=o("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),ee=a(e),K=i(e,"P",{}),ct(K).forEach(l),te=a(e),c(w.$$.fragment,e),le=a(e),c(h.$$.fragment,e),se=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-vj58on"&&(J.textContent=qe),ne=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-le6dse"&&(T.textContent=Xe),ae=a(e),j=i(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1sknqqb"&&(j.innerHTML=Qe),oe=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-c8ziqp"&&(b.textContent=Ve),ie=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1oxrjf8"&&(U.textContent=$e),re=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-i3m4dm"&&(f.textContent=Se),pe=a(e),I=i(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-mq10ec"&&(I.innerHTML=Fe),Me=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-18mh92s"&&(g.textContent=Le),ce=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-16cuoal"&&(v.textContent=Ee),ue=a(e),c(C.$$.fragment,e),de=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1gx6n4r"&&(Z.innerHTML=ze),ye=a(e),c(B.$$.fragment,e),me=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-pnr043"&&(A.innerHTML=Ye),we=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10fmib9"&&(k.textContent=Pe),he=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-15ubgr3"&&(_.innerHTML=De),Je=a(e),c(R.$$.fragment,e),Te=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-zjg126"&&(G.textContent=Ke),je=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-q3vnxy"&&(x.textContent=Oe),be=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-151azqv"&&(W.textContent=et),Ue=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-16enqdj"&&(N.innerHTML=tt),fe=a(e),c(H.$$.fragment,e),Ie=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1rtfitb"&&(q.innerHTML=lt),ge=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1o6dxyl"&&(X.innerHTML=st),ve=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-14g5yev"&&(Q.textContent=nt),Ce=a(e),V=i(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-krum96"&&(V.innerHTML=at),Ze=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-17670xr"&&($.innerHTML=ot),Be=a(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-38rh7n"&&(S.innerHTML=it),Ae=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1faawbb"&&(F.innerHTML=rt),ke=a(e),c(L.$$.fragment,e),_e=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-45t4kd"&&(E.textContent=pt),Re=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ytp34t"&&(z.innerHTML=Mt),Ge=a(e),c(Y.$$.fragment,e),xe=a(e),c(P.$$.fragment,e),We=a(e),O=i(e,"P",{}),ct(O).forEach(l),this.h()},h(){ut(p,"name","hf:doc:metadata"),ut(p,"content",It)},m(e,t){Tt(document.head,p),s(e,ee,t),s(e,K,t),s(e,te,t),u(w,e,t),s(e,le,t),u(h,e,t),s(e,se,t),s(e,J,t),s(e,ne,t),s(e,T,t),s(e,ae,t),s(e,j,t),s(e,oe,t),s(e,b,t),s(e,ie,t),s(e,U,t),s(e,re,t),s(e,f,t),s(e,pe,t),s(e,I,t),s(e,Me,t),s(e,g,t),s(e,ce,t),s(e,v,t),s(e,ue,t),u(C,e,t),s(e,de,t),s(e,Z,t),s(e,ye,t),u(B,e,t),s(e,me,t),s(e,A,t),s(e,we,t),s(e,k,t),s(e,he,t),s(e,_,t),s(e,Je,t),u(R,e,t),s(e,Te,t),s(e,G,t),s(e,je,t),s(e,x,t),s(e,be,t),s(e,W,t),s(e,Ue,t),s(e,N,t),s(e,fe,t),u(H,e,t),s(e,Ie,t),s(e,q,t),s(e,ge,t),s(e,X,t),s(e,ve,t),s(e,Q,t),s(e,Ce,t),s(e,V,t),s(e,Ze,t),s(e,$,t),s(e,Be,t),s(e,S,t),s(e,Ae,t),s(e,F,t),s(e,ke,t),u(L,e,t),s(e,_e,t),s(e,E,t),s(e,Re,t),s(e,z,t),s(e,Ge,t),u(Y,e,t),s(e,xe,t),u(P,e,t),s(e,We,t),s(e,O,t),Ne=!0},p:yt,i(e){Ne||(d(w.$$.fragment,e),d(h.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(H.$$.fragment,e),d(L.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),Ne=!0)},o(e){y(w.$$.fragment,e),y(h.$$.fragment,e),y(C.$$.fragment,e),y(B.$$.fragment,e),y(R.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(Y.$$.fragment,e),y(P.$$.fragment,e),Ne=!1},d(e){e&&(l(ee),l(K),l(te),l(le),l(se),l(J),l(ne),l(T),l(ae),l(j),l(oe),l(b),l(ie),l(U),l(re),l(f),l(pe),l(I),l(Me),l(g),l(ce),l(v),l(ue),l(de),l(Z),l(ye),l(me),l(A),l(we),l(k),l(he),l(_),l(Je),l(Te),l(G),l(je),l(x),l(be),l(W),l(Ue),l(N),l(fe),l(Ie),l(q),l(ge),l(X),l(ve),l(Q),l(Ce),l(V),l(Ze),l($),l(Be),l(S),l(Ae),l(F),l(ke),l(_e),l(E),l(Re),l(z),l(Ge),l(xe),l(We),l(O)),l(p),m(w,e),m(h,e),m(C,e),m(B,e),m(R,e),m(H,e),m(L,e),m(Y,e),m(P,e)}}}const It='{"title":"Agentic RAG","local":"agentic-rag","sections":[],"depth":1}';function gt(He){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends wt{constructor(p){super(),ht(this,p,gt,ft,dt,{})}}export{kt as component};
