import{s as Zs,n as ks,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as Ws,i as Bs,g as p,s as a,r as i,A as Ns,h as m,f as l,c as n,j as Is,u as o,x as r,k as Cs,y as xs,a as e,v as M,d as c,t as J,w as h}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as _}from"../chunks/Heading.3097d2ed.js";function Gs(Js){let w,S,v,Y,T,H,j,hs='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',X,g,ws='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',z,y,F,d,Ts="To load a pretrained model:",D,u,L,b,js="To load and preprocess the image:",q,f,P,U,gs="To get the model predictions:",K,I,O,C,ys="To get the top-5 predictions class names:",ss,Z,ts,k,ds="Replace the model name with the variant you want to use, e.g. <code>gluon_resnet101_v1b</code>. You can find the IDs in the model summaries at the top of this page.",ls,$,us='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',es,W,as,B,bs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ns,N,ps,x,fs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,G,is,E,Us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',os,R,rs,A,Ms,V,cs;return T=new _({props:{title:"(Gluon) ResNet",local:"gluon-resnet",headingTag:"h1"}}),y=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3Jlc25ldDEwMV92MWInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fcmVzbmV0MTAxX3YxYiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),A=new Q({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIZVpSUzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCS2FpbWluZyUyMEhlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWGlhbmd5dSUyMFpoYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2hhb3FpbmclMjBSZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBKaWFuJTIwU3VuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JEZWVwJTIwUmVzaWR1YWwlMjBMZWFybmluZyUyMGZvciUyMEltYWdlJTIwUmVjb2duaXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE1MTIuMDMzODUlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNSU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNTEyLjAzMzg1JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTUxMi4wMzM4NSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QldlZCUyQyUyMDE3JTIwQXByJTIwMjAxOSUyMDE3JTNBMjMlM0E0NSUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSGVaUlMxNS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HeZRS15,
  author    = {Kaiming He and
               Xiangyu Zhang and
               Shaoqing Ren and
               Jian Sun},
  title     = {Deep Residual Learning <span class="hljs-keyword">for</span> Image Recognition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.03385</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.03385</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.03385</span>},
  timestamp = {Wed, <span class="hljs-number">17</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">17</span>:<span class="hljs-number">23</span>:<span class="hljs-number">45</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HeZRS15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),{c(){w=p("meta"),S=a(),v=p("p"),Y=a(),i(T.$$.fragment),H=a(),j=p("p"),j.innerHTML=hs,X=a(),g=p("p"),g.innerHTML=ws,z=a(),i(y.$$.fragment),F=a(),d=p("p"),d.textContent=Ts,D=a(),i(u.$$.fragment),L=a(),b=p("p"),b.textContent=js,q=a(),i(f.$$.fragment),P=a(),U=p("p"),U.textContent=gs,K=a(),i(I.$$.fragment),O=a(),C=p("p"),C.textContent=ys,ss=a(),i(Z.$$.fragment),ts=a(),k=p("p"),k.innerHTML=ds,ls=a(),$=p("p"),$.innerHTML=us,es=a(),i(W.$$.fragment),as=a(),B=p("p"),B.textContent=bs,ns=a(),i(N.$$.fragment),ps=a(),x=p("p"),x.innerHTML=fs,ms=a(),i(G.$$.fragment),is=a(),E=p("p"),E.innerHTML=Us,os=a(),i(R.$$.fragment),rs=a(),i(A.$$.fragment),Ms=a(),V=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);w=m(t,"META",{name:!0,content:!0}),t.forEach(l),S=n(s),v=m(s,"P",{}),Is(v).forEach(l),Y=n(s),o(T.$$.fragment,s),H=n(s),j=m(s,"P",{"data-svelte-h":!0}),r(j)!=="svelte-p6ybkz"&&(j.innerHTML=hs),X=n(s),g=m(s,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1vag5uc"&&(g.innerHTML=ws),z=n(s),o(y.$$.fragment,s),F=n(s),d=m(s,"P",{"data-svelte-h":!0}),r(d)!=="svelte-18ywhxh"&&(d.textContent=Ts),D=n(s),o(u.$$.fragment,s),L=n(s),b=m(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1c2ipa8"&&(b.textContent=js),q=n(s),o(f.$$.fragment,s),P=n(s),U=m(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1n9qsq1"&&(U.textContent=gs),K=n(s),o(I.$$.fragment,s),O=n(s),C=m(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-19cnvx1"&&(C.textContent=ys),ss=n(s),o(Z.$$.fragment,s),ts=n(s),k=m(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-frqp5b"&&(k.innerHTML=ds),ls=n(s),$=m(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1wmi3ea"&&($.innerHTML=us),es=n(s),o(W.$$.fragment,s),as=n(s),B=m(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9sr7nh"&&(B.textContent=bs),ns=n(s),o(N.$$.fragment,s),ps=n(s),x=m(s,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1kguc51"&&(x.innerHTML=fs),ms=n(s),o(G.$$.fragment,s),is=n(s),E=m(s,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1n0coha"&&(E.innerHTML=Us),os=n(s),o(R.$$.fragment,s),rs=n(s),o(A.$$.fragment,s),Ms=n(s),V=m(s,"P",{}),Is(V).forEach(l),this.h()},h(){Cs(w,"name","hf:doc:metadata"),Cs(w,"content",Es)},m(s,t){xs(document.head,w),e(s,S,t),e(s,v,t),e(s,Y,t),M(T,s,t),e(s,H,t),e(s,j,t),e(s,X,t),e(s,g,t),e(s,z,t),M(y,s,t),e(s,F,t),e(s,d,t),e(s,D,t),M(u,s,t),e(s,L,t),e(s,b,t),e(s,q,t),M(f,s,t),e(s,P,t),e(s,U,t),e(s,K,t),M(I,s,t),e(s,O,t),e(s,C,t),e(s,ss,t),M(Z,s,t),e(s,ts,t),e(s,k,t),e(s,ls,t),e(s,$,t),e(s,es,t),M(W,s,t),e(s,as,t),e(s,B,t),e(s,ns,t),M(N,s,t),e(s,ps,t),e(s,x,t),e(s,ms,t),M(G,s,t),e(s,is,t),e(s,E,t),e(s,os,t),M(R,s,t),e(s,rs,t),M(A,s,t),e(s,Ms,t),e(s,V,t),cs=!0},p:ks,i(s){cs||(c(T.$$.fragment,s),c(y.$$.fragment,s),c(u.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(Z.$$.fragment,s),c(W.$$.fragment,s),c(N.$$.fragment,s),c(G.$$.fragment,s),c(R.$$.fragment,s),c(A.$$.fragment,s),cs=!0)},o(s){J(T.$$.fragment,s),J(y.$$.fragment,s),J(u.$$.fragment,s),J(f.$$.fragment,s),J(I.$$.fragment,s),J(Z.$$.fragment,s),J(W.$$.fragment,s),J(N.$$.fragment,s),J(G.$$.fragment,s),J(R.$$.fragment,s),J(A.$$.fragment,s),cs=!1},d(s){s&&(l(S),l(v),l(Y),l(H),l(j),l(X),l(g),l(z),l(F),l(d),l(D),l(L),l(b),l(q),l(P),l(U),l(K),l(O),l(C),l(ss),l(ts),l(k),l(ls),l($),l(es),l(as),l(B),l(ns),l(ps),l(x),l(ms),l(is),l(E),l(os),l(rs),l(Ms),l(V)),l(w),h(T,s),h(y,s),h(u,s),h(f,s),h(I,s),h(Z,s),h(W,s),h(N,s),h(G,s),h(R,s),h(A,s)}}}const Es='{"title":"(Gluon) ResNet","local":"gluon-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rs(Js){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends Ws{constructor(w){super(),Bs(this,w,Rs,Gs,Zs,{})}}export{_s as component};
