import{s as Ut,n as Ct,o as It}from"../chunks/scheduler.85c25b89.js";import{S as $t,i as Zt,g as p,s as l,r as i,A as Wt,h as m,f as e,c as n,j as bt,u as o,x as d,k as ft,y as xt,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.52fa569e.js";import{H as v}from"../chunks/Heading.3097d2ed.js";function kt(rt){let y,R,Q,z,g,S,w,ht='<strong>SE ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',Y,J,F,j,Mt="To load a pretrained model:",H,T,A,u,dt="To load and preprocess the image:",L,b,q,f,yt="To get the model predictions:",D,U,P,C,gt="To get the top-5 predictions class names:",K,I,O,$,wt="Replace the model name with the variant you want to use, e.g. <code>legacy_seresnext101_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",tt,Z,Jt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,W,et,x,jt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,k,lt,N,Tt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,G,pt,B,ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',mt,E,it,V,ot,_,ct;return g=new v({props:{title:"(Legacy) SE-ResNeXt",local:"legacy-se-resnext",headingTag:"h1"}}),J=new v({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2xlZ2FjeV9zZXJlc25leHQxMDFfMzJ4NGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new v({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbGVnYWN5X3NlcmVzbmV4dDEwMV8zMng0ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new v({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new v({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new X({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){y=p("meta"),R=l(),Q=p("p"),z=l(),i(g.$$.fragment),S=l(),w=p("p"),w.innerHTML=ht,Y=l(),i(J.$$.fragment),F=l(),j=p("p"),j.textContent=Mt,H=l(),i(T.$$.fragment),A=l(),u=p("p"),u.textContent=dt,L=l(),i(b.$$.fragment),q=l(),f=p("p"),f.textContent=yt,D=l(),i(U.$$.fragment),P=l(),C=p("p"),C.textContent=gt,K=l(),i(I.$$.fragment),O=l(),$=p("p"),$.innerHTML=wt,tt=l(),Z=p("p"),Z.innerHTML=Jt,st=l(),i(W.$$.fragment),et=l(),x=p("p"),x.textContent=jt,at=l(),i(k.$$.fragment),lt=l(),N=p("p"),N.innerHTML=Tt,nt=l(),i(G.$$.fragment),pt=l(),B=p("p"),B.innerHTML=ut,mt=l(),i(E.$$.fragment),it=l(),i(V.$$.fragment),ot=l(),_=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(e),R=n(t),Q=m(t,"P",{}),bt(Q).forEach(e),z=n(t),o(g.$$.fragment,t),S=n(t),w=m(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1r2b6ta"&&(w.innerHTML=ht),Y=n(t),o(J.$$.fragment,t),F=n(t),j=m(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-18ywhxh"&&(j.textContent=Mt),H=n(t),o(T.$$.fragment,t),A=n(t),u=m(t,"P",{"data-svelte-h":!0}),d(u)!=="svelte-1c2ipa8"&&(u.textContent=dt),L=n(t),o(b.$$.fragment,t),q=n(t),f=m(t,"P",{"data-svelte-h":!0}),d(f)!=="svelte-1n9qsq1"&&(f.textContent=yt),D=n(t),o(U.$$.fragment,t),P=n(t),C=m(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-19cnvx1"&&(C.textContent=gt),K=n(t),o(I.$$.fragment,t),O=n(t),$=m(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-1uvqczn"&&($.innerHTML=wt),tt=n(t),Z=m(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=Jt),st=n(t),o(W.$$.fragment,t),et=n(t),x=m(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-9sr7nh"&&(x.textContent=jt),at=n(t),o(k.$$.fragment,t),lt=n(t),N=m(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1kguc51"&&(N.innerHTML=Tt),nt=n(t),o(G.$$.fragment,t),pt=n(t),B=m(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1n0coha"&&(B.innerHTML=ut),mt=n(t),o(E.$$.fragment,t),it=n(t),o(V.$$.fragment,t),ot=n(t),_=m(t,"P",{}),bt(_).forEach(e),this.h()},h(){ft(y,"name","hf:doc:metadata"),ft(y,"content",Nt)},m(t,s){xt(document.head,y),a(t,R,s),a(t,Q,s),a(t,z,s),c(g,t,s),a(t,S,s),a(t,w,s),a(t,Y,s),c(J,t,s),a(t,F,s),a(t,j,s),a(t,H,s),c(T,t,s),a(t,A,s),a(t,u,s),a(t,L,s),c(b,t,s),a(t,q,s),a(t,f,s),a(t,D,s),c(U,t,s),a(t,P,s),a(t,C,s),a(t,K,s),c(I,t,s),a(t,O,s),a(t,$,s),a(t,tt,s),a(t,Z,s),a(t,st,s),c(W,t,s),a(t,et,s),a(t,x,s),a(t,at,s),c(k,t,s),a(t,lt,s),a(t,N,s),a(t,nt,s),c(G,t,s),a(t,pt,s),a(t,B,s),a(t,mt,s),c(E,t,s),a(t,it,s),c(V,t,s),a(t,ot,s),a(t,_,s),ct=!0},p:Ct,i(t){ct||(r(g.$$.fragment,t),r(J.$$.fragment,t),r(T.$$.fragment,t),r(b.$$.fragment,t),r(U.$$.fragment,t),r(I.$$.fragment,t),r(W.$$.fragment,t),r(k.$$.fragment,t),r(G.$$.fragment,t),r(E.$$.fragment,t),r(V.$$.fragment,t),ct=!0)},o(t){h(g.$$.fragment,t),h(J.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h(I.$$.fragment,t),h(W.$$.fragment,t),h(k.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),h(V.$$.fragment,t),ct=!1},d(t){t&&(e(R),e(Q),e(z),e(S),e(w),e(Y),e(F),e(j),e(H),e(A),e(u),e(L),e(q),e(f),e(D),e(P),e(C),e(K),e(O),e($),e(tt),e(Z),e(st),e(et),e(x),e(at),e(lt),e(N),e(nt),e(pt),e(B),e(mt),e(it),e(ot),e(_)),e(y),M(g,t),M(J,t),M(T,t),M(b,t),M(U,t),M(I,t),M(W,t),M(k,t),M(G,t),M(E,t),M(V,t)}}}const Nt='{"title":"(Legacy) SE-ResNeXt","local":"legacy-se-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Gt(rt){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends $t{constructor(y){super(),Zt(this,y,Gt,kt,Ut,{})}}export{Qt as component};
