import{s as Ut,n as It,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as $t,i as kt,g as p,s as l,r as i,A as Zt,h as m,f as e,c as n,j as ft,u as o,x as J,k as bt,y as Wt,a,v as r,d as c,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as Y}from"../chunks/CodeBlock.94efc595.js";import{H as V}from"../chunks/Heading.3c6e5b17.js";function Bt(ct){let w,R,X,S,y,_,g,ht='<strong>CSPResNeXt</strong> is a convolutional neural network where we apply the Cross Stage Partial Network (CSPNet) approach to <a href="https://paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a>. The CSPNet partitions the feature map of the base layer into two parts and then merges them through a cross-stage hierarchy. The use of a split and merge strategy allows for more gradient flow through the network.',H,d,F,T,Mt="To load a pretrained model:",z,j,A,u,Jt="To load and preprocess the image:",L,f,P,b,wt="To get the model predictions:",D,U,q,I,yt="To get the top-5 predictions class names:",K,C,O,$,gt="Replace the model name with the variant you want to use, e.g. <code>cspresnext50</code>. You can find the IDs in the model summaries at the top of this page.",tt,k,dt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,Z,et,W,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,B,lt,N,jt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,x,pt,G,ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',mt,Q,it,E,ot,v,rt;return y=new V({props:{title:"CSP-ResNeXt",local:"csp-resnext",headingTag:"h1"}}),d=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),j=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2NzcHJlc25leHQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnext50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnY3NwcmVzbmV4dDUwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnext50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Y({props:{code:"JTQwbWlzYyU3QndhbmcyMDE5Y3NwbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JDU1BOZXQlM0ElMjBBJTIwTmV3JTIwQmFja2JvbmUlMjB0aGF0JTIwY2FuJTIwRW5oYW5jZSUyMExlYXJuaW5nJTIwQ2FwYWJpbGl0eSUyMG9mJTIwQ05OJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hpZW4tWWFvJTIwV2FuZyUyMGFuZCUyMEhvbmctWXVhbiUyME1hcmslMjBMaWFvJTIwYW5kJTIwSS1IYXUlMjBZZWglMjBhbmQlMjBZdWVoLUh1YSUyMFd1JTIwYW5kJTIwUGluZy1ZYW5nJTIwQ2hlbiUyMGFuZCUyMEp1bi1XZWklMjBIc2llaCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMS4xMTkyOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{wang2019cspnet,
      title={CSPNet: A New <span class="hljs-keyword">Backbone </span>that can Enhance Learning Capability of CNN}, 
      author={Chien-Yao Wang <span class="hljs-keyword">and </span>Hong-Yuan Mark Liao <span class="hljs-keyword">and </span>I-Hau Yeh <span class="hljs-keyword">and </span>Yueh-Hua Wu <span class="hljs-keyword">and </span>Ping-Yang Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jun-Wei </span>Hsieh},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">11929</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){w=p("meta"),R=l(),X=p("p"),S=l(),i(y.$$.fragment),_=l(),g=p("p"),g.innerHTML=ht,H=l(),i(d.$$.fragment),F=l(),T=p("p"),T.textContent=Mt,z=l(),i(j.$$.fragment),A=l(),u=p("p"),u.textContent=Jt,L=l(),i(f.$$.fragment),P=l(),b=p("p"),b.textContent=wt,D=l(),i(U.$$.fragment),q=l(),I=p("p"),I.textContent=yt,K=l(),i(C.$$.fragment),O=l(),$=p("p"),$.innerHTML=gt,tt=l(),k=p("p"),k.innerHTML=dt,st=l(),i(Z.$$.fragment),et=l(),W=p("p"),W.textContent=Tt,at=l(),i(B.$$.fragment),lt=l(),N=p("p"),N.innerHTML=jt,nt=l(),i(x.$$.fragment),pt=l(),G=p("p"),G.innerHTML=ut,mt=l(),i(Q.$$.fragment),it=l(),i(E.$$.fragment),ot=l(),v=p("p"),this.h()},l(t){const s=Zt("svelte-u9bgzb",document.head);w=m(s,"META",{name:!0,content:!0}),s.forEach(e),R=n(t),X=m(t,"P",{}),ft(X).forEach(e),S=n(t),o(y.$$.fragment,t),_=n(t),g=m(t,"P",{"data-svelte-h":!0}),J(g)!=="svelte-fnwr9k"&&(g.innerHTML=ht),H=n(t),o(d.$$.fragment,t),F=n(t),T=m(t,"P",{"data-svelte-h":!0}),J(T)!=="svelte-18ywhxh"&&(T.textContent=Mt),z=n(t),o(j.$$.fragment,t),A=n(t),u=m(t,"P",{"data-svelte-h":!0}),J(u)!=="svelte-1c2ipa8"&&(u.textContent=Jt),L=n(t),o(f.$$.fragment,t),P=n(t),b=m(t,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1n9qsq1"&&(b.textContent=wt),D=n(t),o(U.$$.fragment,t),q=n(t),I=m(t,"P",{"data-svelte-h":!0}),J(I)!=="svelte-19cnvx1"&&(I.textContent=yt),K=n(t),o(C.$$.fragment,t),O=n(t),$=m(t,"P",{"data-svelte-h":!0}),J($)!=="svelte-iozf60"&&($.innerHTML=gt),tt=n(t),k=m(t,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1wmi3ea"&&(k.innerHTML=dt),st=n(t),o(Z.$$.fragment,t),et=n(t),W=m(t,"P",{"data-svelte-h":!0}),J(W)!=="svelte-9sr7nh"&&(W.textContent=Tt),at=n(t),o(B.$$.fragment,t),lt=n(t),N=m(t,"P",{"data-svelte-h":!0}),J(N)!=="svelte-1kguc51"&&(N.innerHTML=jt),nt=n(t),o(x.$$.fragment,t),pt=n(t),G=m(t,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1n0coha"&&(G.innerHTML=ut),mt=n(t),o(Q.$$.fragment,t),it=n(t),o(E.$$.fragment,t),ot=n(t),v=m(t,"P",{}),ft(v).forEach(e),this.h()},h(){bt(w,"name","hf:doc:metadata"),bt(w,"content",Nt)},m(t,s){Wt(document.head,w),a(t,R,s),a(t,X,s),a(t,S,s),r(y,t,s),a(t,_,s),a(t,g,s),a(t,H,s),r(d,t,s),a(t,F,s),a(t,T,s),a(t,z,s),r(j,t,s),a(t,A,s),a(t,u,s),a(t,L,s),r(f,t,s),a(t,P,s),a(t,b,s),a(t,D,s),r(U,t,s),a(t,q,s),a(t,I,s),a(t,K,s),r(C,t,s),a(t,O,s),a(t,$,s),a(t,tt,s),a(t,k,s),a(t,st,s),r(Z,t,s),a(t,et,s),a(t,W,s),a(t,at,s),r(B,t,s),a(t,lt,s),a(t,N,s),a(t,nt,s),r(x,t,s),a(t,pt,s),a(t,G,s),a(t,mt,s),r(Q,t,s),a(t,it,s),r(E,t,s),a(t,ot,s),a(t,v,s),rt=!0},p:It,i(t){rt||(c(y.$$.fragment,t),c(d.$$.fragment,t),c(j.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c(C.$$.fragment,t),c(Z.$$.fragment,t),c(B.$$.fragment,t),c(x.$$.fragment,t),c(Q.$$.fragment,t),c(E.$$.fragment,t),rt=!0)},o(t){h(y.$$.fragment,t),h(d.$$.fragment,t),h(j.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(Z.$$.fragment,t),h(B.$$.fragment,t),h(x.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),rt=!1},d(t){t&&(e(R),e(X),e(S),e(_),e(g),e(H),e(F),e(T),e(z),e(A),e(u),e(L),e(P),e(b),e(D),e(q),e(I),e(K),e(O),e($),e(tt),e(k),e(st),e(et),e(W),e(at),e(lt),e(N),e(nt),e(pt),e(G),e(mt),e(it),e(ot),e(v)),e(w),M(y,t),M(d,t),M(j,t),M(f,t),M(U,t),M(C,t),M(Z,t),M(B,t),M(x,t),M(Q,t),M(E,t)}}}const Nt='{"title":"CSP-ResNeXt","local":"csp-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xt(ct){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends $t{constructor(w){super(),kt(this,w,xt,Bt,Ut,{})}}export{Xt as component};
