import{s as Is,n as Us,o as Zs}from"../chunks/scheduler.85c25b89.js";import{S as Bs,i as $s,g as p,s as e,r as m,A as ks,h as i,f as a,c as n,j as bs,u as o,x as M,k as fs,y as Ws,a as l,v as r,d as c,t as h,w as J}from"../chunks/index.c9bcf812.js";import{C as v}from"../chunks/CodeBlock.94efc595.js";import{H as Q}from"../chunks/Heading.3c6e5b17.js";function Cs(cs){let j,Y,X,H,g,R,d,hs="<strong>Big Transfer (BiT)</strong> is a type of pretraining recipe that pre-trains  on a large supervised source dataset, and fine-tunes the weights on the target task. Models are trained on the JFT-300M dataset. The finetuned models contained in this collection are finetuned on ImageNet.",F,w,z,T,Js="To load a pretrained model:",A,y,S,u,Ms="To load and preprocess the image:",L,b,D,f,js="To get the model predictions:",P,I,q,U,gs="To get the top-5 predictions class names:",K,Z,O,B,ds="Replace the model name with the variant you want to use, e.g. <code>resnetv2_101x1_bitm</code>. You can find the IDs in the model summaries at the top of this page.",ss,$,ws='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,k,as,W,Ts="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ls,C,es,G,ys=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,x,ps,N,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',is,V,ms,E,os,_,rs;return g=new Q({props:{title:"Big Transfer (BiT)",local:"big-transfer-bit",headingTag:"h1"}}),w=new Q({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldHYyXzEwMXgxX2JpdG0nJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnetv2_101x1_bitm&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Q({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),C=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0djJfMTAxeDFfYml0bSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnetv2_101x1_bitm&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new Q({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),V=new Q({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new v({props:{code:"JTQwbWlzYyU3QmtvbGVzbmlrb3YyMDIwYmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JCaWclMjBUcmFuc2ZlciUyMChCaVQpJTNBJTIwR2VuZXJhbCUyMFZpc3VhbCUyMFJlcHJlc2VudGF0aW9uJTIwTGVhcm5pbmclN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JBbGV4YW5kZXIlMjBLb2xlc25pa292JTIwYW5kJTIwTHVjYXMlMjBCZXllciUyMGFuZCUyMFhpYW9odWElMjBaaGFpJTIwYW5kJTIwSm9hbiUyMFB1aWdjZXJ2ZXIlMjBhbmQlMjBKZXNzaWNhJTIwWXVuZyUyMGFuZCUyMFN5bHZhaW4lMjBHZWxseSUyMGFuZCUyME5laWwlMjBIb3Vsc2J5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTEyLjExMzcwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{kolesnikov<span class="hljs-symbol">2020b</span>ig,
      title={<span class="hljs-keyword">Big </span>Transfer (<span class="hljs-keyword">BiT): </span>General Visual Representation Learning}, 
      author={Alexander Kolesnikov <span class="hljs-keyword">and </span>Lucas <span class="hljs-keyword">Beyer </span><span class="hljs-keyword">and </span>Xiaohua Zhai <span class="hljs-keyword">and </span><span class="hljs-keyword">Joan </span>Puigcerver <span class="hljs-keyword">and </span><span class="hljs-keyword">Jessica </span>Yung <span class="hljs-keyword">and </span>Sylvain Gelly <span class="hljs-keyword">and </span>Neil Houlsby},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">1912</span>.<span class="hljs-number">11370</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){j=p("meta"),Y=e(),X=p("p"),H=e(),m(g.$$.fragment),R=e(),d=p("p"),d.innerHTML=hs,F=e(),m(w.$$.fragment),z=e(),T=p("p"),T.textContent=Js,A=e(),m(y.$$.fragment),S=e(),u=p("p"),u.textContent=Ms,L=e(),m(b.$$.fragment),D=e(),f=p("p"),f.textContent=js,P=e(),m(I.$$.fragment),q=e(),U=p("p"),U.textContent=gs,K=e(),m(Z.$$.fragment),O=e(),B=p("p"),B.innerHTML=ds,ss=e(),$=p("p"),$.innerHTML=ws,ts=e(),m(k.$$.fragment),as=e(),W=p("p"),W.textContent=Ts,ls=e(),m(C.$$.fragment),es=e(),G=p("p"),G.innerHTML=ys,ns=e(),m(x.$$.fragment),ps=e(),N=p("p"),N.innerHTML=us,is=e(),m(V.$$.fragment),ms=e(),m(E.$$.fragment),os=e(),_=p("p"),this.h()},l(s){const t=ks("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(a),Y=n(s),X=i(s,"P",{}),bs(X).forEach(a),H=n(s),o(g.$$.fragment,s),R=n(s),d=i(s,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1la1ia4"&&(d.innerHTML=hs),F=n(s),o(w.$$.fragment,s),z=n(s),T=i(s,"P",{"data-svelte-h":!0}),M(T)!=="svelte-18ywhxh"&&(T.textContent=Js),A=n(s),o(y.$$.fragment,s),S=n(s),u=i(s,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1c2ipa8"&&(u.textContent=Ms),L=n(s),o(b.$$.fragment,s),D=n(s),f=i(s,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1n9qsq1"&&(f.textContent=js),P=n(s),o(I.$$.fragment,s),q=n(s),U=i(s,"P",{"data-svelte-h":!0}),M(U)!=="svelte-19cnvx1"&&(U.textContent=gs),K=n(s),o(Z.$$.fragment,s),O=n(s),B=i(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-xm05fa"&&(B.innerHTML=ds),ss=n(s),$=i(s,"P",{"data-svelte-h":!0}),M($)!=="svelte-1wmi3ea"&&($.innerHTML=ws),ts=n(s),o(k.$$.fragment,s),as=n(s),W=i(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-9sr7nh"&&(W.textContent=Ts),ls=n(s),o(C.$$.fragment,s),es=n(s),G=i(s,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1kguc51"&&(G.innerHTML=ys),ns=n(s),o(x.$$.fragment,s),ps=n(s),N=i(s,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1n0coha"&&(N.innerHTML=us),is=n(s),o(V.$$.fragment,s),ms=n(s),o(E.$$.fragment,s),os=n(s),_=i(s,"P",{}),bs(_).forEach(a),this.h()},h(){fs(j,"name","hf:doc:metadata"),fs(j,"content",Gs)},m(s,t){Ws(document.head,j),l(s,Y,t),l(s,X,t),l(s,H,t),r(g,s,t),l(s,R,t),l(s,d,t),l(s,F,t),r(w,s,t),l(s,z,t),l(s,T,t),l(s,A,t),r(y,s,t),l(s,S,t),l(s,u,t),l(s,L,t),r(b,s,t),l(s,D,t),l(s,f,t),l(s,P,t),r(I,s,t),l(s,q,t),l(s,U,t),l(s,K,t),r(Z,s,t),l(s,O,t),l(s,B,t),l(s,ss,t),l(s,$,t),l(s,ts,t),r(k,s,t),l(s,as,t),l(s,W,t),l(s,ls,t),r(C,s,t),l(s,es,t),l(s,G,t),l(s,ns,t),r(x,s,t),l(s,ps,t),l(s,N,t),l(s,is,t),r(V,s,t),l(s,ms,t),r(E,s,t),l(s,os,t),l(s,_,t),rs=!0},p:Us,i(s){rs||(c(g.$$.fragment,s),c(w.$$.fragment,s),c(y.$$.fragment,s),c(b.$$.fragment,s),c(I.$$.fragment,s),c(Z.$$.fragment,s),c(k.$$.fragment,s),c(C.$$.fragment,s),c(x.$$.fragment,s),c(V.$$.fragment,s),c(E.$$.fragment,s),rs=!0)},o(s){h(g.$$.fragment,s),h(w.$$.fragment,s),h(y.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h(Z.$$.fragment,s),h(k.$$.fragment,s),h(C.$$.fragment,s),h(x.$$.fragment,s),h(V.$$.fragment,s),h(E.$$.fragment,s),rs=!1},d(s){s&&(a(Y),a(X),a(H),a(R),a(d),a(F),a(z),a(T),a(A),a(S),a(u),a(L),a(D),a(f),a(P),a(q),a(U),a(K),a(O),a(B),a(ss),a($),a(ts),a(as),a(W),a(ls),a(es),a(G),a(ns),a(ps),a(N),a(is),a(ms),a(os),a(_)),a(j),J(g,s),J(w,s),J(y,s),J(b,s),J(I,s),J(Z,s),J(k,s),J(C,s),J(x,s),J(V,s),J(E,s)}}}const Gs='{"title":"Big Transfer (BiT)","local":"big-transfer-bit","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xs(cs){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends Bs{constructor(j){super(),$s(this,j,xs,Cs,Is,{})}}export{Xs as component};
