import{S as zr,i as Cr,s as Ir,e as s,k as d,w as M,t as i,M as Er,c as n,d as o,m as p,a as r,x as y,h as a,b as u,G as l,g as c,y as J,q as w,o as b,B as j,v as gr}from"../chunks/vendor-hf-doc-builder.js";import{T as Ps}from"../chunks/Tip-hf-doc-builder.js";import{I as bl}from"../chunks/IconCopyLink-hf-doc-builder.js";import{C as v}from"../chunks/CodeBlock-hf-doc-builder.js";function Zr(L){let m,h;return{c(){m=s("p"),h=i("Se il tuo modello \xE8 molto simile a un modello all\u2019interno della libreria, puoi ri-usare la stessa configurazione di quel modello.")},l(f){m=n(f,"P",{});var U=r(m);h=a(U,"Se il tuo modello \xE8 molto simile a un modello all\u2019interno della libreria, puoi ri-usare la stessa configurazione di quel modello."),U.forEach(o)},m(f,U){c(f,m,U),l(m,h)},d(f){f&&o(m)}}}function Ar(L){let m,h;return{c(){m=s("p"),h=i("Questa API \xE8 sperimentale e potrebbe avere alcuni cambiamenti nei prossimi rilasci.")},l(f){m=n(f,"P",{});var U=r(m);h=a(U,"Questa API \xE8 sperimentale e potrebbe avere alcuni cambiamenti nei prossimi rilasci."),U.forEach(o)},m(f,U){c(f,m,U),l(m,h)},d(f){f&&o(m)}}}function $r(L){let m,h,f,U,F;return{c(){m=s("p"),h=i(`Se stai copiando i file relativi alla modellazione della libreria, dovrai sostituire tutti gli import relativi in cima al file con import del
pacchetto `),f=s("code"),U=i("transformers"),F=i(".")},l(C){m=n(C,"P",{});var $=r(m);h=a($,`Se stai copiando i file relativi alla modellazione della libreria, dovrai sostituire tutti gli import relativi in cima al file con import del
pacchetto `),f=n($,"CODE",{});var K=r(f);U=a(K,"transformers"),K.forEach(o),F=a($,"."),$.forEach(o)},m(C,$){c(C,m,$),l(m,h),l(m,f),l(f,U),l(m,F)},d(C){C&&o(m)}}}function Nr(L){let m,h,f,U,F,C,$,K,Oi,go,Se,xi,Zo,N,Li,be,Ki,ea,jl,la,oa,Ao,S,ee,Ul,je,ia,Tl,aa,$o,Pe,ta,No,Ue,ko,De,sa,Ro,k,Te,na,vl,ra,ca,da,P,pa,hl,ua,ma,_l,fa,Ma,ya,le,Ja,zl,wa,ba,Cl,ja,Bo,R,Ua,Il,Ta,va,El,ha,_a,Wo,B,za,gl,Ca,Ia,Zl,Ea,ga,Xo,He,Za,Go,ve,Qo,I,Aa,Al,$a,Na,$l,ka,Ra,Nl,Ba,Wa,Vo,he,qo,W,Xa,kl,Ga,Qa,Rl,Va,qa,Yo,D,oe,Bl,_e,Ya,Wl,Fa,Fo,X,Sa,Xl,Pa,Da,Gl,Ha,Oa,So,ie,xa,Ql,La,Ka,Po,ze,Do,Oe,et,Ho,Ce,Oo,z,lt,Vl,ot,it,ql,at,tt,Yl,st,nt,Fl,rt,ct,xo,ae,Lo,G,dt,Sl,pt,ut,Pl,mt,ft,Ko,xe,Mt,ei,Ie,li,E,yt,Dl,Jt,wt,Hl,bt,jt,Ol,Ut,Tt,oi,Le,vt,ii,Ee,ai,Q,ht,xl,_t,zt,Ll,Ct,It,ti,H,te,Kl,ge,Et,eo,gt,si,se,ni,T,Zt,lo,At,$t,oo,Nt,kt,io,Rt,Bt,ao,Wt,Xt,to,Gt,Qt,so,Vt,qt,no,Yt,Ft,ri,Ze,ci,V,St,ro,Pt,Dt,co,Ht,Ot,di,ne,pi,Ke,xt,ui,el,Lt,mi,Ae,fi,re,Kt,po,es,ls,Mi,$e,yi,ce,os,uo,is,as,Ji,ll,ts,wi,Ne,bi,ol,ss,ji,ke,Ui,il,ns,Ti,Re,vi,al,rs,hi,Be,_i,g,cs,mo,ds,ps,fo,us,ms,We,fs,Ms,zi,de,ys,tl,Js,ws,Ci,O,pe,Mo,Xe,bs,yo,js,Ii,Z,Us,Jo,Ts,vs,Ge,hs,_s,wo,zs,Cs,Ei,Qe,gi,ue,Is,bo,Es,gs,Zi,Ve,Ai,sl,Zs,$i,x,me,jo,qe,As,Uo,$s,Ni,nl,Ns,ki,q,ks,To,Rs,Bs,vo,Ws,Xs,Ri,Ye,Bi,A,Gs,ho,Qs,Vs,_o,qs,Ys,zo,Fs,Ss,Wi;return C=new bl({}),je=new bl({}),Ue=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`}}),ve=new v({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`}}),he=new v({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)'}}),_e=new bl({}),ze=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`}}),Ce=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),ae=new Ps({props:{$$slots:{default:[Zr]},$$scope:{ctx:L}}}),Ie=new v({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)"}}),Ee=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),ge=new bl({}),se=new Ps({props:{warning:!0,$$slots:{default:[Ar]},$$scope:{ctx:L}}}),Ze=new v({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
\u2514\u2500\u2500 resnet_model
    \u251C\u2500\u2500 __init__.<span class="hljs-keyword">py</span>
    \u251C\u2500\u2500 configuration_resnet.<span class="hljs-keyword">py</span>
    \u2514\u2500\u2500 modeling_resnet.<span class="hljs-keyword">py</span>`}}),ne=new Ps({props:{warning:!0,$$slots:{default:[$r]},$$scope:{ctx:L}}}),Ae=new v({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`}}),$e=new v({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`}}),Ne=new v({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),ke=new v({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),Re=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),Be=new v({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)'}}),Xe=new bl({}),Qe=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),Ve=new v({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`}}),qe=new bl({}),Ye=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`}}),{c(){m=s("meta"),h=d(),f=s("h1"),U=s("a"),F=s("span"),M(C.$$.fragment),$=d(),K=s("span"),Oi=i("Condividere modelli personalizzati"),go=i(`

La libreria \u{1F917} Transformers \xE8 studiata per essere facilmente estendibile. Il codice di ogni modello \xE8 interamente 
situato in una sottocartella del repository senza alcuna astrazione, perci\xF2 puoi facilmente copiare il file di un 
modello e modificarlo in base ai tuoi bisogni.
`),Se=s("p"),xi=i(`Se stai scrivendo un nuovo modello, potrebbe essere pi\xF9 semplice iniziare da zero. In questo tutorial, ti mostreremo
come scrivere un modello personalizzato e la sua configurazione in modo che possa essere utilizzato all\u2019interno di
Transformers, e come condividerlo con la community (assieme al relativo codice) cos\xEC che tutte le persone possano usarlo, anche
se non presente nella libreria \u{1F917} Transformers.`),Zo=d(),N=s("p"),Li=i(`Illustriamo tutto questo su un modello ResNet, avvolgendo la classe ResNet della
`),be=s("a"),Ki=i("libreria timm"),ea=i(" in un "),jl=s("code"),la=i("PreTrainedModel"),oa=i("."),Ao=d(),S=s("h2"),ee=s("a"),Ul=s("span"),M(je.$$.fragment),ia=d(),Tl=s("span"),aa=i("Scrivere una configurazione personalizzata"),$o=i(`

Prima di iniziare a lavorare al modello, scriviamone la configurazione. La configurazione di un modello \xE8 un oggetto
che contiene tutte le informazioni necessarie per la build del modello. Come vedremo nella prossima sezione, il 
modello pu\xF2 soltanto essere inizializzato tramite \`config\`, per cui dovremo rendere tale oggetto pi\xF9 completo possibile.
`),Pe=s("p"),ta=i(`Nel nostro esempio, prenderemo un paio di argomenti della classe ResNet che potremmo voler modificare.
Configurazioni differenti ci daranno quindi i differenti possibili tipi di ResNet. Salveremo poi questi argomenti,
dopo averne controllato la validit\xE0.`),No=d(),M(Ue.$$.fragment),ko=d(),De=s("p"),sa=i("Le tre cose pi\xF9 importanti da ricordare quando scrivi le tue configurazioni sono le seguenti:"),Ro=d(),k=s("ul"),Te=s("li"),na=i("Devi ereditare da "),vl=s("code"),ra=i("Pretrainedconfig"),ca=i(","),da=d(),P=s("li"),pa=i("Il metodo "),hl=s("code"),ua=i("__init__"),ma=i(" del tuo "),_l=s("code"),fa=i("Pretrainedconfig"),Ma=i(" deve accettare i kwargs,"),ya=d(),le=s("li"),Ja=i("I "),zl=s("code"),wa=i("kwargs"),ba=i(" devono essere passati alla superclass "),Cl=s("code"),ja=i("__init__"),Bo=d(),R=s("p"),Ua=i(`L\u2019eredit\xE0 \xE8 importante per assicurarsi di ottenere tutte le funzionalit\xE0 della libreria \u{1F917} transformers,
mentre gli altri due vincoli derivano dal fatto che un `),Il=s("code"),Ta=i("Pretrainedconfig"),va=i(` ha pi\xF9 campi di quelli che stai settando.
Quando ricarichi una config da un metodo `),El=s("code"),ha=i("from_pretrained"),_a=i(`, questi campi devono essere accettati dalla tua config e
poi inviati alla superclasse.`),Wo=d(),B=s("p"),za=i("Definire un "),gl=s("code"),Ca=i("model_type"),Ia=i(" per la tua configurazione (qua "),Zl=s("code"),Ea=i("model_type = \u201Cresnet\u201D"),ga=i(`) non \xE8 obbligatorio, a meno che tu
non voglia registrare il modello con le classi Auto (vedi l\u2019ultima sezione).`),Xo=d(),He=s("p"),Za=i(`Una volta completato, puoi facilmente creare e salvare la tua configurazione come faresti con ogni altra configurazione
di modelli della libreria. Ecco come possiamo creare la config di un resnet50d e salvarlo:`),Go=d(),M(ve.$$.fragment),Qo=d(),I=s("p"),Aa=i("Questo salver\xE0 un file chiamato "),Al=s("code"),$a=i("config.json"),Na=i(" all\u2019interno della cartella "),$l=s("code"),ka=i("custom-resnet"),Ra=i(`. Potrai poi ricaricare la tua
config con il metodo `),Nl=s("code"),Ba=i("from_pretrained"),Wa=i("."),Vo=d(),M(he.$$.fragment),qo=d(),W=s("p"),Xa=i("Puoi anche usare qualunque altro metodo della classe "),kl=s("code"),Ga=i("PretrainedConfig"),Qa=i(", come "),Rl=s("code"),Va=i("push_to_hub()"),qa=i(`
per caricare direttamente la tua configurazione nell\u2019hub.`),Yo=d(),D=s("h2"),oe=s("a"),Bl=s("span"),M(_e.$$.fragment),Ya=d(),Wl=s("span"),Fa=i("Scrivere un modello personalizzato"),Fo=d(),X=s("p"),Sa=i(`Ora che abbiamo la nostra configurazione ResNet, possiamo continuare a scrivere il modello. In realt\xE0, ne scriveremo
due: uno che estrae le features nascoste da una batch di immagini (come `),Xl=s("code"),Pa=i("BertModel"),Da=i(`) e uno che \xE8 utilizzabile per
la classificazione di immagini (come `),Gl=s("code"),Ha=i("BertModelForSequenceClassification"),Oa=i(")."),So=d(),ie=s("p"),xa=i(`Come abbiamo menzionato in precedenza, scriveremo soltanto un wrapper del modello, per mantenerlo semplice ai fini di
questo esempio. L\u2019unica cosa che dobbiamo fare prima di scrivere questa classe \xE8 una mappatura fra i tipi di blocco e
le vere classi dei blocchi. Successivamente il modello \xE8 definito tramite la configurazione, passando tutto quanto alla
classe `),Ql=s("code"),La=i("ResNet"),Ka=i("."),Po=d(),M(ze.$$.fragment),Do=d(),Oe=s("p"),et=i("Per il modello che classificher\xE0 le immagini, cambiamo soltanto il metodo forward:"),Ho=d(),M(Ce.$$.fragment),Oo=d(),z=s("p"),lt=i("Nota come, in entrambi i casi, ereditiamo da "),Vl=s("code"),ot=i("PreTrainedModel"),it=i(` e chiamiamo l\u2019inizializzazione della superclasse
con il metodo `),ql=s("code"),at=i("config"),tt=i(" (un po\u2019 come quando scrivi un normale "),Yl=s("code"),st=i("torch.nn.Module"),nt=i("). La riga che imposta la  "),Fl=s("code"),rt=i("config_class"),ct=i(`
non \xE8 obbligatoria, a meno che tu non voglia registrare il modello con le classi Auto (vedi l\u2019ultima sezione).`),xo=d(),M(ae.$$.fragment),Lo=d(),G=s("p"),dt=i(`Puoi fare in modo che il tuo modello restituisca in output qualunque cosa tu voglia, ma far restituire un dizionario
come abbiamo fatto per `),Sl=s("code"),pt=i("ResnetModelForImageClassification"),ut=i(`, con la funzione di perdita inclusa quando vengono passate le labels,
render\xE0 il tuo modello direttamente utilizzabile all\u2019interno della classe `),Pl=s("code"),mt=i("Trainer"),ft=i(`. Utilizzare altri formati di output va bene
se hai in progetto di utilizzare un tuo loop di allenamento, o se utilizzerai un\u2019altra libreria per l\u2019addestramento.`),Ko=d(),xe=s("p"),Mt=i("Ora che abbiamo la classe del nostro modello, creiamone uno:"),ei=d(),M(Ie.$$.fragment),li=d(),E=s("p"),yt=i("Ribadiamo, puoi usare qualunque metodo dei "),Dl=s("code"),Jt=i("PreTrainedModel"),wt=i(", come "),Hl=s("code"),bt=i("save_pretrained()"),jt=i(` o
`),Ol=s("code"),Ut=i("push_to_hub()"),Tt=i(`. Utilizzeremo quest\u2019ultimo nella prossima sezione, e vedremo come caricare i pesi del
modello assieme al codice del modello stesso. Ma prima, carichiamo alcuni pesi pre-allenati all\u2019interno del nostro modello.`),oi=d(),Le=s("p"),vt=i(`Nel tuo caso specifico, probabilmente allenerai il tuo modello sui tuoi dati. Per velocizzare in questo tutorial,
utilizzeremo la versione pre-allenata del resnet50d. Dato che il nostro modello \xE8 soltanto un wrapper attorno a quel modello,
sar\xE0 facile trasferirne i pesi:`),ii=d(),M(Ee.$$.fragment),ai=d(),Q=s("p"),ht=i("Vediamo adesso come assicurarci che quando facciamo "),xl=s("code"),_t=i("save_pretrained()"),zt=i(" o "),Ll=s("code"),Ct=i("push_to_hub()"),It=i(`,
il codice del modello venga salvato.`),ti=d(),H=s("h2"),te=s("a"),Kl=s("span"),M(ge.$$.fragment),Et=d(),eo=s("span"),gt=i("Inviare il codice all'Hub"),si=d(),M(se.$$.fragment),ni=d(),T=s("p"),Zt=i("Innanzitutto, assicurati che il tuo modello sia completamente definito in un file "),lo=s("code"),At=i(".py"),$t=i(`. Pu\xF2 sfruttare import relativi
ad altri file, purch\xE8 questi siano nella stessa directory (non supportiamo ancora sotto-moduli per questa funzionalit\xE0).
Per questo esempio, definiremo un file `),oo=s("code"),Nt=i("modeling_resnet.py"),kt=i(" e un file "),io=s("code"),Rt=i("configuration_resnet.py"),Bt=i(` in una cartella dell\u2019attuale
working directory chiamata `),ao=s("code"),Wt=i("resnet_model"),Xt=i(". Il file configuration contiene il codice per "),to=s("code"),Gt=i("ResnetConfig"),Qt=i(` e il file modeling
contiene il codice di `),so=s("code"),Vt=i("ResnetModel"),qt=i(" e "),no=s("code"),Yt=i("ResnetModelForImageClassification"),Ft=i("."),ri=d(),M(Ze.$$.fragment),ci=d(),V=s("p"),St=i("Il file "),ro=s("code"),Pt=i("__init__.py"),Dt=i(" pu\xF2 essere vuoto, serve solo perch\xE8 Python capisca che "),co=s("code"),Ht=i("resnet_model"),Ot=i(" pu\xF2 essere utilizzato come un modulo."),di=d(),M(ne.$$.fragment),pi=d(),Ke=s("p"),xt=i("Nota che puoi ri-utilizzare (o usare come sottoclassi) un modello/configurazione esistente."),ui=d(),el=s("p"),Lt=i(`Per condividere il tuo modello con la community, segui questi passi: prima importa il modello ResNet e la sua configurazione
dai nuovi file creati:`),mi=d(),M(Ae.$$.fragment),fi=d(),re=s("p"),Kt=i(`Dopodich\xE8 dovrai dire alla libreria che vuoi copiare i file con il codice di quegli oggetti quando utilizzi il metodo
`),po=s("code"),es=i("save_pretrained"),ls=i(" e registrarli in modo corretto con una Auto classe (specialmente per i modelli). Utilizza semplicemente:"),Mi=d(),M($e.$$.fragment),yi=d(),ce=s("p"),os=i(`Nota che non c\u2019\xE8 bisogno di specificare una Auto classe per la configurazione (c\u2019\xE8 solo una Auto classe per le configurazioni,
`),uo=s("code"),is=i("AutoConfig"),as=i(`, ma \xE8 diversa per i modelli). Il tuo modello personalizato potrebbe essere utilizzato per diverse tasks,
per cui devi specificare quale delle classi Auto \xE8 quella corretta per il tuo modello.`),Ji=d(),ll=s("p"),ts=i("Successivamente, creiamo i modelli e la config come abbiamo fatto in precedenza:"),wi=d(),M(Ne.$$.fragment),bi=d(),ol=s("p"),ss=i("Adesso, per inviare il modello all\u2019Hub, assicurati di aver effettuato l\u2019accesso. Lancia dal tuo terminale:"),ji=d(),M(ke.$$.fragment),Ui=d(),il=s("p"),ns=i("O da un notebook:"),Ti=d(),M(Re.$$.fragment),vi=d(),al=s("p"),rs=i("Potrai poi inviare il tutto sul tuo profilo (o di un\u2019organizzazione di cui fai parte) in questo modo:"),hi=d(),M(Be.$$.fragment),_i=d(),g=s("p"),cs=i("Oltre ai pesi del modello e alla configurazione in formato json, questo ha anche copiato i file "),mo=s("code"),ds=i(".py"),ps=i(` modeling e
configuration all\u2019interno della cartella `),fo=s("code"),us=i("custom-resnet50d"),ms=i(` e ha caricato i risultati sull\u2019Hub. Puoi controllare
i risultati in questa `),We=s("a"),fs=i("model repo"),Ms=i("."),zi=d(),de=s("p"),ys=i("Puoi controllare il tutorial di condivisione "),tl=s("a"),Js=i("tutorial di condivisione"),ws=i(` per pi\xF9 informazioni sul
metodo con cui inviare all\u2019Hub.`),Ci=d(),O=s("h2"),pe=s("a"),Mo=s("span"),M(Xe.$$.fragment),bs=d(),yo=s("span"),js=i("Usare un modello con codice personalizzato"),Ii=d(),Z=s("p"),Us=i(`Puoi usare ogni configurazione, modello o tokenizer con file di codice personalizzati nella sua repository
con le classi Auto e il metodo `),Jo=s("code"),Ts=i("from_pretrained"),vs=i(`. Tutti i files e il codice caricati sull\u2019Hub sono scansionati da malware
(fai riferimento alla documentazione `),Ge=s("a"),hs=i("Hub security"),_s=i(` per pi\xF9 informazioni),
ma dovresti comunque assicurarti dell\u2019affidabilit\xE0 del codice e dell\u2019autore per evitare di eseguire codice dannoso sulla tua macchina.
Imposta `),wo=s("code"),zs=i("trust_remote_code=True"),Cs=i(" per usare un modello con codice personalizzato:"),Ei=d(),M(Qe.$$.fragment),gi=d(),ue=s("p"),Is=i("Inoltre, raccomandiamo fortemente di passare un hash del commit come "),bo=s("code"),Es=i("revision"),gs=i(` per assicurarti che le autrici o gli autori del modello
non abbiano modificato il codice con alcune nuove righe dannose (a meno che non ti fidi completamente della fonte):`),Zi=d(),M(Ve.$$.fragment),Ai=d(),sl=s("p"),Zs=i(`Nota che quando cerchi la storia dei commit della repo del modello sull\u2019Hub, c\u2019\xE8 un bottone con cui facilmente copiare il
commit hash di ciascun commit.`),$i=d(),x=s("h2"),me=s("a"),jo=s("span"),M(qe.$$.fragment),As=d(),Uo=s("span"),$s=i("Registrare un modello con codice personalizzato nelle classi Auto"),Ni=d(),nl=s("p"),Ns=i(`Se stai scrivendo una libreria che estende \u{1F917} Transformers, potresti voler estendere le classi Auto per includere il tuo modello.
Questo \xE8 diverso dall\u2019inviare codice nell\u2019Hub: gli utenti dovranno importare la tua libreria per ottenere il modello personalizzato
(anzich\xE8 scaricare automaticamente il modello dall\u2019Hub).`),ki=d(),q=s("p"),ks=i("Finch\xE8 il tuo file di configurazione ha un attributo "),To=s("code"),Rs=i("model_type"),Bs=i(` diverso dai model types esistenti, e finch\xE8 le tue
classi modello hanno i corretti attributi `),vo=s("code"),Ws=i("config_class"),Xs=i(", potrai semplicemente aggiungerli alle classi Auto come segue:"),Ri=d(),M(Ye.$$.fragment),Bi=d(),A=s("p"),Gs=i("Nota che il primo argomento utilizzato quando registri la configurazione di un modello personalizzato con "),ho=s("code"),Qs=i("AutoConfig"),Vs=i(`
deve corrispondere al `),_o=s("code"),qs=i("model_type"),Ys=i(` della tua configurazione personalizzata, ed il primo argomento utilizzato quando
registri i tuoi modelli personalizzati in una qualunque classe Auto del modello deve corrispondere alla `),zo=s("code"),Fs=i("config_class"),Ss=i(`
di quei modelli.`),this.h()},l(e){const t=Er('[data-svelte="svelte-1phssyn"]',document.head);m=n(t,"META",{name:!0,content:!0}),t.forEach(o),h=p(e),f=n(e,"H1",{class:!0});var Fe=r(f);U=n(Fe,"A",{id:!0,class:!0,href:!0});var Co=r(U);F=n(Co,"SPAN",{});var Io=r(F);y(C.$$.fragment,Io),Io.forEach(o),Co.forEach(o),$=p(Fe),K=n(Fe,"SPAN",{});var Ds=r(K);Oi=a(Ds,"Condividere modelli personalizzati"),Ds.forEach(o),Fe.forEach(o),go=a(e,`

La libreria \u{1F917} Transformers \xE8 studiata per essere facilmente estendibile. Il codice di ogni modello \xE8 interamente 
situato in una sottocartella del repository senza alcuna astrazione, perci\xF2 puoi facilmente copiare il file di un 
modello e modificarlo in base ai tuoi bisogni.
`),Se=n(e,"P",{});var Hs=r(Se);xi=a(Hs,`Se stai scrivendo un nuovo modello, potrebbe essere pi\xF9 semplice iniziare da zero. In questo tutorial, ti mostreremo
come scrivere un modello personalizzato e la sua configurazione in modo che possa essere utilizzato all\u2019interno di
Transformers, e come condividerlo con la community (assieme al relativo codice) cos\xEC che tutte le persone possano usarlo, anche
se non presente nella libreria \u{1F917} Transformers.`),Hs.forEach(o),Zo=p(e),N=n(e,"P",{});var rl=r(N);Li=a(rl,`Illustriamo tutto questo su un modello ResNet, avvolgendo la classe ResNet della
`),be=n(rl,"A",{href:!0,rel:!0});var Os=r(be);Ki=a(Os,"libreria timm"),Os.forEach(o),ea=a(rl," in un "),jl=n(rl,"CODE",{});var xs=r(jl);la=a(xs,"PreTrainedModel"),xs.forEach(o),oa=a(rl,"."),rl.forEach(o),Ao=p(e),S=n(e,"H2",{class:!0});var Xi=r(S);ee=n(Xi,"A",{id:!0,class:!0,href:!0});var Ls=r(ee);Ul=n(Ls,"SPAN",{});var Ks=r(Ul);y(je.$$.fragment,Ks),Ks.forEach(o),Ls.forEach(o),ia=p(Xi),Tl=n(Xi,"SPAN",{});var en=r(Tl);aa=a(en,"Scrivere una configurazione personalizzata"),en.forEach(o),Xi.forEach(o),$o=a(e,`

Prima di iniziare a lavorare al modello, scriviamone la configurazione. La configurazione di un modello \xE8 un oggetto
che contiene tutte le informazioni necessarie per la build del modello. Come vedremo nella prossima sezione, il 
modello pu\xF2 soltanto essere inizializzato tramite \`config\`, per cui dovremo rendere tale oggetto pi\xF9 completo possibile.
`),Pe=n(e,"P",{});var ln=r(Pe);ta=a(ln,`Nel nostro esempio, prenderemo un paio di argomenti della classe ResNet che potremmo voler modificare.
Configurazioni differenti ci daranno quindi i differenti possibili tipi di ResNet. Salveremo poi questi argomenti,
dopo averne controllato la validit\xE0.`),ln.forEach(o),No=p(e),y(Ue.$$.fragment,e),ko=p(e),De=n(e,"P",{});var on=r(De);sa=a(on,"Le tre cose pi\xF9 importanti da ricordare quando scrivi le tue configurazioni sono le seguenti:"),on.forEach(o),Ro=p(e),k=n(e,"UL",{});var cl=r(k);Te=n(cl,"LI",{});var Gi=r(Te);na=a(Gi,"Devi ereditare da "),vl=n(Gi,"CODE",{});var an=r(vl);ra=a(an,"Pretrainedconfig"),an.forEach(o),ca=a(Gi,","),Gi.forEach(o),da=p(cl),P=n(cl,"LI",{});var dl=r(P);pa=a(dl,"Il metodo "),hl=n(dl,"CODE",{});var tn=r(hl);ua=a(tn,"__init__"),tn.forEach(o),ma=a(dl," del tuo "),_l=n(dl,"CODE",{});var sn=r(_l);fa=a(sn,"Pretrainedconfig"),sn.forEach(o),Ma=a(dl," deve accettare i kwargs,"),dl.forEach(o),ya=p(cl),le=n(cl,"LI",{});var Eo=r(le);Ja=a(Eo,"I "),zl=n(Eo,"CODE",{});var nn=r(zl);wa=a(nn,"kwargs"),nn.forEach(o),ba=a(Eo," devono essere passati alla superclass "),Cl=n(Eo,"CODE",{});var rn=r(Cl);ja=a(rn,"__init__"),rn.forEach(o),Eo.forEach(o),cl.forEach(o),Bo=p(e),R=n(e,"P",{});var pl=r(R);Ua=a(pl,`L\u2019eredit\xE0 \xE8 importante per assicurarsi di ottenere tutte le funzionalit\xE0 della libreria \u{1F917} transformers,
mentre gli altri due vincoli derivano dal fatto che un `),Il=n(pl,"CODE",{});var cn=r(Il);Ta=a(cn,"Pretrainedconfig"),cn.forEach(o),va=a(pl,` ha pi\xF9 campi di quelli che stai settando.
Quando ricarichi una config da un metodo `),El=n(pl,"CODE",{});var dn=r(El);ha=a(dn,"from_pretrained"),dn.forEach(o),_a=a(pl,`, questi campi devono essere accettati dalla tua config e
poi inviati alla superclasse.`),pl.forEach(o),Wo=p(e),B=n(e,"P",{});var ul=r(B);za=a(ul,"Definire un "),gl=n(ul,"CODE",{});var pn=r(gl);Ca=a(pn,"model_type"),pn.forEach(o),Ia=a(ul," per la tua configurazione (qua "),Zl=n(ul,"CODE",{});var un=r(Zl);Ea=a(un,"model_type = \u201Cresnet\u201D"),un.forEach(o),ga=a(ul,`) non \xE8 obbligatorio, a meno che tu
non voglia registrare il modello con le classi Auto (vedi l\u2019ultima sezione).`),ul.forEach(o),Xo=p(e),He=n(e,"P",{});var mn=r(He);Za=a(mn,`Una volta completato, puoi facilmente creare e salvare la tua configurazione come faresti con ogni altra configurazione
di modelli della libreria. Ecco come possiamo creare la config di un resnet50d e salvarlo:`),mn.forEach(o),Go=p(e),y(ve.$$.fragment,e),Qo=p(e),I=n(e,"P",{});var fe=r(I);Aa=a(fe,"Questo salver\xE0 un file chiamato "),Al=n(fe,"CODE",{});var fn=r(Al);$a=a(fn,"config.json"),fn.forEach(o),Na=a(fe," all\u2019interno della cartella "),$l=n(fe,"CODE",{});var Mn=r($l);ka=a(Mn,"custom-resnet"),Mn.forEach(o),Ra=a(fe,`. Potrai poi ricaricare la tua
config con il metodo `),Nl=n(fe,"CODE",{});var yn=r(Nl);Ba=a(yn,"from_pretrained"),yn.forEach(o),Wa=a(fe,"."),fe.forEach(o),Vo=p(e),y(he.$$.fragment,e),qo=p(e),W=n(e,"P",{});var ml=r(W);Xa=a(ml,"Puoi anche usare qualunque altro metodo della classe "),kl=n(ml,"CODE",{});var Jn=r(kl);Ga=a(Jn,"PretrainedConfig"),Jn.forEach(o),Qa=a(ml,", come "),Rl=n(ml,"CODE",{});var wn=r(Rl);Va=a(wn,"push_to_hub()"),wn.forEach(o),qa=a(ml,`
per caricare direttamente la tua configurazione nell\u2019hub.`),ml.forEach(o),Yo=p(e),D=n(e,"H2",{class:!0});var Qi=r(D);oe=n(Qi,"A",{id:!0,class:!0,href:!0});var bn=r(oe);Bl=n(bn,"SPAN",{});var jn=r(Bl);y(_e.$$.fragment,jn),jn.forEach(o),bn.forEach(o),Ya=p(Qi),Wl=n(Qi,"SPAN",{});var Un=r(Wl);Fa=a(Un,"Scrivere un modello personalizzato"),Un.forEach(o),Qi.forEach(o),Fo=p(e),X=n(e,"P",{});var fl=r(X);Sa=a(fl,`Ora che abbiamo la nostra configurazione ResNet, possiamo continuare a scrivere il modello. In realt\xE0, ne scriveremo
due: uno che estrae le features nascoste da una batch di immagini (come `),Xl=n(fl,"CODE",{});var Tn=r(Xl);Pa=a(Tn,"BertModel"),Tn.forEach(o),Da=a(fl,`) e uno che \xE8 utilizzabile per
la classificazione di immagini (come `),Gl=n(fl,"CODE",{});var vn=r(Gl);Ha=a(vn,"BertModelForSequenceClassification"),vn.forEach(o),Oa=a(fl,")."),fl.forEach(o),So=p(e),ie=n(e,"P",{});var Vi=r(ie);xa=a(Vi,`Come abbiamo menzionato in precedenza, scriveremo soltanto un wrapper del modello, per mantenerlo semplice ai fini di
questo esempio. L\u2019unica cosa che dobbiamo fare prima di scrivere questa classe \xE8 una mappatura fra i tipi di blocco e
le vere classi dei blocchi. Successivamente il modello \xE8 definito tramite la configurazione, passando tutto quanto alla
classe `),Ql=n(Vi,"CODE",{});var hn=r(Ql);La=a(hn,"ResNet"),hn.forEach(o),Ka=a(Vi,"."),Vi.forEach(o),Po=p(e),y(ze.$$.fragment,e),Do=p(e),Oe=n(e,"P",{});var _n=r(Oe);et=a(_n,"Per il modello che classificher\xE0 le immagini, cambiamo soltanto il metodo forward:"),_n.forEach(o),Ho=p(e),y(Ce.$$.fragment,e),Oo=p(e),z=n(e,"P",{});var Y=r(z);lt=a(Y,"Nota come, in entrambi i casi, ereditiamo da "),Vl=n(Y,"CODE",{});var zn=r(Vl);ot=a(zn,"PreTrainedModel"),zn.forEach(o),it=a(Y,` e chiamiamo l\u2019inizializzazione della superclasse
con il metodo `),ql=n(Y,"CODE",{});var Cn=r(ql);at=a(Cn,"config"),Cn.forEach(o),tt=a(Y," (un po\u2019 come quando scrivi un normale "),Yl=n(Y,"CODE",{});var In=r(Yl);st=a(In,"torch.nn.Module"),In.forEach(o),nt=a(Y,"). La riga che imposta la  "),Fl=n(Y,"CODE",{});var En=r(Fl);rt=a(En,"config_class"),En.forEach(o),ct=a(Y,`
non \xE8 obbligatoria, a meno che tu non voglia registrare il modello con le classi Auto (vedi l\u2019ultima sezione).`),Y.forEach(o),xo=p(e),y(ae.$$.fragment,e),Lo=p(e),G=n(e,"P",{});var Ml=r(G);dt=a(Ml,`Puoi fare in modo che il tuo modello restituisca in output qualunque cosa tu voglia, ma far restituire un dizionario
come abbiamo fatto per `),Sl=n(Ml,"CODE",{});var gn=r(Sl);pt=a(gn,"ResnetModelForImageClassification"),gn.forEach(o),ut=a(Ml,`, con la funzione di perdita inclusa quando vengono passate le labels,
render\xE0 il tuo modello direttamente utilizzabile all\u2019interno della classe `),Pl=n(Ml,"CODE",{});var Zn=r(Pl);mt=a(Zn,"Trainer"),Zn.forEach(o),ft=a(Ml,`. Utilizzare altri formati di output va bene
se hai in progetto di utilizzare un tuo loop di allenamento, o se utilizzerai un\u2019altra libreria per l\u2019addestramento.`),Ml.forEach(o),Ko=p(e),xe=n(e,"P",{});var An=r(xe);Mt=a(An,"Ora che abbiamo la classe del nostro modello, creiamone uno:"),An.forEach(o),ei=p(e),y(Ie.$$.fragment,e),li=p(e),E=n(e,"P",{});var Me=r(E);yt=a(Me,"Ribadiamo, puoi usare qualunque metodo dei "),Dl=n(Me,"CODE",{});var $n=r(Dl);Jt=a($n,"PreTrainedModel"),$n.forEach(o),wt=a(Me,", come "),Hl=n(Me,"CODE",{});var Nn=r(Hl);bt=a(Nn,"save_pretrained()"),Nn.forEach(o),jt=a(Me,` o
`),Ol=n(Me,"CODE",{});var kn=r(Ol);Ut=a(kn,"push_to_hub()"),kn.forEach(o),Tt=a(Me,`. Utilizzeremo quest\u2019ultimo nella prossima sezione, e vedremo come caricare i pesi del
modello assieme al codice del modello stesso. Ma prima, carichiamo alcuni pesi pre-allenati all\u2019interno del nostro modello.`),Me.forEach(o),oi=p(e),Le=n(e,"P",{});var Rn=r(Le);vt=a(Rn,`Nel tuo caso specifico, probabilmente allenerai il tuo modello sui tuoi dati. Per velocizzare in questo tutorial,
utilizzeremo la versione pre-allenata del resnet50d. Dato che il nostro modello \xE8 soltanto un wrapper attorno a quel modello,
sar\xE0 facile trasferirne i pesi:`),Rn.forEach(o),ii=p(e),y(Ee.$$.fragment,e),ai=p(e),Q=n(e,"P",{});var yl=r(Q);ht=a(yl,"Vediamo adesso come assicurarci che quando facciamo "),xl=n(yl,"CODE",{});var Bn=r(xl);_t=a(Bn,"save_pretrained()"),Bn.forEach(o),zt=a(yl," o "),Ll=n(yl,"CODE",{});var Wn=r(Ll);Ct=a(Wn,"push_to_hub()"),Wn.forEach(o),It=a(yl,`,
il codice del modello venga salvato.`),yl.forEach(o),ti=p(e),H=n(e,"H2",{class:!0});var qi=r(H);te=n(qi,"A",{id:!0,class:!0,href:!0});var Xn=r(te);Kl=n(Xn,"SPAN",{});var Gn=r(Kl);y(ge.$$.fragment,Gn),Gn.forEach(o),Xn.forEach(o),Et=p(qi),eo=n(qi,"SPAN",{});var Qn=r(eo);gt=a(Qn,"Inviare il codice all'Hub"),Qn.forEach(o),qi.forEach(o),si=p(e),y(se.$$.fragment,e),ni=p(e),T=n(e,"P",{});var _=r(T);Zt=a(_,"Innanzitutto, assicurati che il tuo modello sia completamente definito in un file "),lo=n(_,"CODE",{});var Vn=r(lo);At=a(Vn,".py"),Vn.forEach(o),$t=a(_,`. Pu\xF2 sfruttare import relativi
ad altri file, purch\xE8 questi siano nella stessa directory (non supportiamo ancora sotto-moduli per questa funzionalit\xE0).
Per questo esempio, definiremo un file `),oo=n(_,"CODE",{});var qn=r(oo);Nt=a(qn,"modeling_resnet.py"),qn.forEach(o),kt=a(_," e un file "),io=n(_,"CODE",{});var Yn=r(io);Rt=a(Yn,"configuration_resnet.py"),Yn.forEach(o),Bt=a(_,` in una cartella dell\u2019attuale
working directory chiamata `),ao=n(_,"CODE",{});var Fn=r(ao);Wt=a(Fn,"resnet_model"),Fn.forEach(o),Xt=a(_,". Il file configuration contiene il codice per "),to=n(_,"CODE",{});var Sn=r(to);Gt=a(Sn,"ResnetConfig"),Sn.forEach(o),Qt=a(_,` e il file modeling
contiene il codice di `),so=n(_,"CODE",{});var Pn=r(so);Vt=a(Pn,"ResnetModel"),Pn.forEach(o),qt=a(_," e "),no=n(_,"CODE",{});var Dn=r(no);Yt=a(Dn,"ResnetModelForImageClassification"),Dn.forEach(o),Ft=a(_,"."),_.forEach(o),ri=p(e),y(Ze.$$.fragment,e),ci=p(e),V=n(e,"P",{});var Jl=r(V);St=a(Jl,"Il file "),ro=n(Jl,"CODE",{});var Hn=r(ro);Pt=a(Hn,"__init__.py"),Hn.forEach(o),Dt=a(Jl," pu\xF2 essere vuoto, serve solo perch\xE8 Python capisca che "),co=n(Jl,"CODE",{});var On=r(co);Ht=a(On,"resnet_model"),On.forEach(o),Ot=a(Jl," pu\xF2 essere utilizzato come un modulo."),Jl.forEach(o),di=p(e),y(ne.$$.fragment,e),pi=p(e),Ke=n(e,"P",{});var xn=r(Ke);xt=a(xn,"Nota che puoi ri-utilizzare (o usare come sottoclassi) un modello/configurazione esistente."),xn.forEach(o),ui=p(e),el=n(e,"P",{});var Ln=r(el);Lt=a(Ln,`Per condividere il tuo modello con la community, segui questi passi: prima importa il modello ResNet e la sua configurazione
dai nuovi file creati:`),Ln.forEach(o),mi=p(e),y(Ae.$$.fragment,e),fi=p(e),re=n(e,"P",{});var Yi=r(re);Kt=a(Yi,`Dopodich\xE8 dovrai dire alla libreria che vuoi copiare i file con il codice di quegli oggetti quando utilizzi il metodo
`),po=n(Yi,"CODE",{});var Kn=r(po);es=a(Kn,"save_pretrained"),Kn.forEach(o),ls=a(Yi," e registrarli in modo corretto con una Auto classe (specialmente per i modelli). Utilizza semplicemente:"),Yi.forEach(o),Mi=p(e),y($e.$$.fragment,e),yi=p(e),ce=n(e,"P",{});var Fi=r(ce);os=a(Fi,`Nota che non c\u2019\xE8 bisogno di specificare una Auto classe per la configurazione (c\u2019\xE8 solo una Auto classe per le configurazioni,
`),uo=n(Fi,"CODE",{});var er=r(uo);is=a(er,"AutoConfig"),er.forEach(o),as=a(Fi,`, ma \xE8 diversa per i modelli). Il tuo modello personalizato potrebbe essere utilizzato per diverse tasks,
per cui devi specificare quale delle classi Auto \xE8 quella corretta per il tuo modello.`),Fi.forEach(o),Ji=p(e),ll=n(e,"P",{});var lr=r(ll);ts=a(lr,"Successivamente, creiamo i modelli e la config come abbiamo fatto in precedenza:"),lr.forEach(o),wi=p(e),y(Ne.$$.fragment,e),bi=p(e),ol=n(e,"P",{});var or=r(ol);ss=a(or,"Adesso, per inviare il modello all\u2019Hub, assicurati di aver effettuato l\u2019accesso. Lancia dal tuo terminale:"),or.forEach(o),ji=p(e),y(ke.$$.fragment,e),Ui=p(e),il=n(e,"P",{});var ir=r(il);ns=a(ir,"O da un notebook:"),ir.forEach(o),Ti=p(e),y(Re.$$.fragment,e),vi=p(e),al=n(e,"P",{});var ar=r(al);rs=a(ar,"Potrai poi inviare il tutto sul tuo profilo (o di un\u2019organizzazione di cui fai parte) in questo modo:"),ar.forEach(o),hi=p(e),y(Be.$$.fragment,e),_i=p(e),g=n(e,"P",{});var ye=r(g);cs=a(ye,"Oltre ai pesi del modello e alla configurazione in formato json, questo ha anche copiato i file "),mo=n(ye,"CODE",{});var tr=r(mo);ds=a(tr,".py"),tr.forEach(o),ps=a(ye,` modeling e
configuration all\u2019interno della cartella `),fo=n(ye,"CODE",{});var sr=r(fo);us=a(sr,"custom-resnet50d"),sr.forEach(o),ms=a(ye,` e ha caricato i risultati sull\u2019Hub. Puoi controllare
i risultati in questa `),We=n(ye,"A",{href:!0,rel:!0});var nr=r(We);fs=a(nr,"model repo"),nr.forEach(o),Ms=a(ye,"."),ye.forEach(o),zi=p(e),de=n(e,"P",{});var Si=r(de);ys=a(Si,"Puoi controllare il tutorial di condivisione "),tl=n(Si,"A",{href:!0});var rr=r(tl);Js=a(rr,"tutorial di condivisione"),rr.forEach(o),ws=a(Si,` per pi\xF9 informazioni sul
metodo con cui inviare all\u2019Hub.`),Si.forEach(o),Ci=p(e),O=n(e,"H2",{class:!0});var Pi=r(O);pe=n(Pi,"A",{id:!0,class:!0,href:!0});var cr=r(pe);Mo=n(cr,"SPAN",{});var dr=r(Mo);y(Xe.$$.fragment,dr),dr.forEach(o),cr.forEach(o),bs=p(Pi),yo=n(Pi,"SPAN",{});var pr=r(yo);js=a(pr,"Usare un modello con codice personalizzato"),pr.forEach(o),Pi.forEach(o),Ii=p(e),Z=n(e,"P",{});var Je=r(Z);Us=a(Je,`Puoi usare ogni configurazione, modello o tokenizer con file di codice personalizzati nella sua repository
con le classi Auto e il metodo `),Jo=n(Je,"CODE",{});var ur=r(Jo);Ts=a(ur,"from_pretrained"),ur.forEach(o),vs=a(Je,`. Tutti i files e il codice caricati sull\u2019Hub sono scansionati da malware
(fai riferimento alla documentazione `),Ge=n(Je,"A",{href:!0,rel:!0});var mr=r(Ge);hs=a(mr,"Hub security"),mr.forEach(o),_s=a(Je,` per pi\xF9 informazioni),
ma dovresti comunque assicurarti dell\u2019affidabilit\xE0 del codice e dell\u2019autore per evitare di eseguire codice dannoso sulla tua macchina.
Imposta `),wo=n(Je,"CODE",{});var fr=r(wo);zs=a(fr,"trust_remote_code=True"),fr.forEach(o),Cs=a(Je," per usare un modello con codice personalizzato:"),Je.forEach(o),Ei=p(e),y(Qe.$$.fragment,e),gi=p(e),ue=n(e,"P",{});var Di=r(ue);Is=a(Di,"Inoltre, raccomandiamo fortemente di passare un hash del commit come "),bo=n(Di,"CODE",{});var Mr=r(bo);Es=a(Mr,"revision"),Mr.forEach(o),gs=a(Di,` per assicurarti che le autrici o gli autori del modello
non abbiano modificato il codice con alcune nuove righe dannose (a meno che non ti fidi completamente della fonte):`),Di.forEach(o),Zi=p(e),y(Ve.$$.fragment,e),Ai=p(e),sl=n(e,"P",{});var yr=r(sl);Zs=a(yr,`Nota che quando cerchi la storia dei commit della repo del modello sull\u2019Hub, c\u2019\xE8 un bottone con cui facilmente copiare il
commit hash di ciascun commit.`),yr.forEach(o),$i=p(e),x=n(e,"H2",{class:!0});var Hi=r(x);me=n(Hi,"A",{id:!0,class:!0,href:!0});var Jr=r(me);jo=n(Jr,"SPAN",{});var wr=r(jo);y(qe.$$.fragment,wr),wr.forEach(o),Jr.forEach(o),As=p(Hi),Uo=n(Hi,"SPAN",{});var br=r(Uo);$s=a(br,"Registrare un modello con codice personalizzato nelle classi Auto"),br.forEach(o),Hi.forEach(o),Ni=p(e),nl=n(e,"P",{});var jr=r(nl);Ns=a(jr,`Se stai scrivendo una libreria che estende \u{1F917} Transformers, potresti voler estendere le classi Auto per includere il tuo modello.
Questo \xE8 diverso dall\u2019inviare codice nell\u2019Hub: gli utenti dovranno importare la tua libreria per ottenere il modello personalizzato
(anzich\xE8 scaricare automaticamente il modello dall\u2019Hub).`),jr.forEach(o),ki=p(e),q=n(e,"P",{});var wl=r(q);ks=a(wl,"Finch\xE8 il tuo file di configurazione ha un attributo "),To=n(wl,"CODE",{});var Ur=r(To);Rs=a(Ur,"model_type"),Ur.forEach(o),Bs=a(wl,` diverso dai model types esistenti, e finch\xE8 le tue
classi modello hanno i corretti attributi `),vo=n(wl,"CODE",{});var Tr=r(vo);Ws=a(Tr,"config_class"),Tr.forEach(o),Xs=a(wl,", potrai semplicemente aggiungerli alle classi Auto come segue:"),wl.forEach(o),Ri=p(e),y(Ye.$$.fragment,e),Bi=p(e),A=n(e,"P",{});var we=r(A);Gs=a(we,"Nota che il primo argomento utilizzato quando registri la configurazione di un modello personalizzato con "),ho=n(we,"CODE",{});var vr=r(ho);Qs=a(vr,"AutoConfig"),vr.forEach(o),Vs=a(we,`
deve corrispondere al `),_o=n(we,"CODE",{});var hr=r(_o);qs=a(hr,"model_type"),hr.forEach(o),Ys=a(we,` della tua configurazione personalizzata, ed il primo argomento utilizzato quando
registri i tuoi modelli personalizzati in una qualunque classe Auto del modello deve corrispondere alla `),zo=n(we,"CODE",{});var _r=r(zo);Fs=a(_r,"config_class"),_r.forEach(o),Ss=a(we,`
di quei modelli.`),we.forEach(o),this.h()},h(){u(m,"name","hf:doc:metadata"),u(m,"content",JSON.stringify(kr)),u(U,"id","condividere-modelli-personalizzati"),u(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(U,"href","#condividere-modelli-personalizzati"),u(f,"class","relative group"),u(be,"href","https://github.com/rwightman/pytorch-image-models"),u(be,"rel","nofollow"),u(ee,"id","scrivere-una-configurazione-personalizzata"),u(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ee,"href","#scrivere-una-configurazione-personalizzata"),u(S,"class","relative group"),u(oe,"id","scrivere-un-modello-personalizzato"),u(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(oe,"href","#scrivere-un-modello-personalizzato"),u(D,"class","relative group"),u(te,"id","inviare-il-codice-allhub"),u(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(te,"href","#inviare-il-codice-allhub"),u(H,"class","relative group"),u(We,"href","https://huggingface.co/sgugger/custom-resnet50d"),u(We,"rel","nofollow"),u(tl,"href","model_sharing"),u(pe,"id","usare-un-modello-con-codice-personalizzato"),u(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(pe,"href","#usare-un-modello-con-codice-personalizzato"),u(O,"class","relative group"),u(Ge,"href","https://huggingface.co/docs/hub/security#malware-scanning"),u(Ge,"rel","nofollow"),u(me,"id","registrare-un-modello-con-codice-personalizzato-nelle-classi-auto"),u(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(me,"href","#registrare-un-modello-con-codice-personalizzato-nelle-classi-auto"),u(x,"class","relative group")},m(e,t){l(document.head,m),c(e,h,t),c(e,f,t),l(f,U),l(U,F),J(C,F,null),l(f,$),l(f,K),l(K,Oi),c(e,go,t),c(e,Se,t),l(Se,xi),c(e,Zo,t),c(e,N,t),l(N,Li),l(N,be),l(be,Ki),l(N,ea),l(N,jl),l(jl,la),l(N,oa),c(e,Ao,t),c(e,S,t),l(S,ee),l(ee,Ul),J(je,Ul,null),l(S,ia),l(S,Tl),l(Tl,aa),c(e,$o,t),c(e,Pe,t),l(Pe,ta),c(e,No,t),J(Ue,e,t),c(e,ko,t),c(e,De,t),l(De,sa),c(e,Ro,t),c(e,k,t),l(k,Te),l(Te,na),l(Te,vl),l(vl,ra),l(Te,ca),l(k,da),l(k,P),l(P,pa),l(P,hl),l(hl,ua),l(P,ma),l(P,_l),l(_l,fa),l(P,Ma),l(k,ya),l(k,le),l(le,Ja),l(le,zl),l(zl,wa),l(le,ba),l(le,Cl),l(Cl,ja),c(e,Bo,t),c(e,R,t),l(R,Ua),l(R,Il),l(Il,Ta),l(R,va),l(R,El),l(El,ha),l(R,_a),c(e,Wo,t),c(e,B,t),l(B,za),l(B,gl),l(gl,Ca),l(B,Ia),l(B,Zl),l(Zl,Ea),l(B,ga),c(e,Xo,t),c(e,He,t),l(He,Za),c(e,Go,t),J(ve,e,t),c(e,Qo,t),c(e,I,t),l(I,Aa),l(I,Al),l(Al,$a),l(I,Na),l(I,$l),l($l,ka),l(I,Ra),l(I,Nl),l(Nl,Ba),l(I,Wa),c(e,Vo,t),J(he,e,t),c(e,qo,t),c(e,W,t),l(W,Xa),l(W,kl),l(kl,Ga),l(W,Qa),l(W,Rl),l(Rl,Va),l(W,qa),c(e,Yo,t),c(e,D,t),l(D,oe),l(oe,Bl),J(_e,Bl,null),l(D,Ya),l(D,Wl),l(Wl,Fa),c(e,Fo,t),c(e,X,t),l(X,Sa),l(X,Xl),l(Xl,Pa),l(X,Da),l(X,Gl),l(Gl,Ha),l(X,Oa),c(e,So,t),c(e,ie,t),l(ie,xa),l(ie,Ql),l(Ql,La),l(ie,Ka),c(e,Po,t),J(ze,e,t),c(e,Do,t),c(e,Oe,t),l(Oe,et),c(e,Ho,t),J(Ce,e,t),c(e,Oo,t),c(e,z,t),l(z,lt),l(z,Vl),l(Vl,ot),l(z,it),l(z,ql),l(ql,at),l(z,tt),l(z,Yl),l(Yl,st),l(z,nt),l(z,Fl),l(Fl,rt),l(z,ct),c(e,xo,t),J(ae,e,t),c(e,Lo,t),c(e,G,t),l(G,dt),l(G,Sl),l(Sl,pt),l(G,ut),l(G,Pl),l(Pl,mt),l(G,ft),c(e,Ko,t),c(e,xe,t),l(xe,Mt),c(e,ei,t),J(Ie,e,t),c(e,li,t),c(e,E,t),l(E,yt),l(E,Dl),l(Dl,Jt),l(E,wt),l(E,Hl),l(Hl,bt),l(E,jt),l(E,Ol),l(Ol,Ut),l(E,Tt),c(e,oi,t),c(e,Le,t),l(Le,vt),c(e,ii,t),J(Ee,e,t),c(e,ai,t),c(e,Q,t),l(Q,ht),l(Q,xl),l(xl,_t),l(Q,zt),l(Q,Ll),l(Ll,Ct),l(Q,It),c(e,ti,t),c(e,H,t),l(H,te),l(te,Kl),J(ge,Kl,null),l(H,Et),l(H,eo),l(eo,gt),c(e,si,t),J(se,e,t),c(e,ni,t),c(e,T,t),l(T,Zt),l(T,lo),l(lo,At),l(T,$t),l(T,oo),l(oo,Nt),l(T,kt),l(T,io),l(io,Rt),l(T,Bt),l(T,ao),l(ao,Wt),l(T,Xt),l(T,to),l(to,Gt),l(T,Qt),l(T,so),l(so,Vt),l(T,qt),l(T,no),l(no,Yt),l(T,Ft),c(e,ri,t),J(Ze,e,t),c(e,ci,t),c(e,V,t),l(V,St),l(V,ro),l(ro,Pt),l(V,Dt),l(V,co),l(co,Ht),l(V,Ot),c(e,di,t),J(ne,e,t),c(e,pi,t),c(e,Ke,t),l(Ke,xt),c(e,ui,t),c(e,el,t),l(el,Lt),c(e,mi,t),J(Ae,e,t),c(e,fi,t),c(e,re,t),l(re,Kt),l(re,po),l(po,es),l(re,ls),c(e,Mi,t),J($e,e,t),c(e,yi,t),c(e,ce,t),l(ce,os),l(ce,uo),l(uo,is),l(ce,as),c(e,Ji,t),c(e,ll,t),l(ll,ts),c(e,wi,t),J(Ne,e,t),c(e,bi,t),c(e,ol,t),l(ol,ss),c(e,ji,t),J(ke,e,t),c(e,Ui,t),c(e,il,t),l(il,ns),c(e,Ti,t),J(Re,e,t),c(e,vi,t),c(e,al,t),l(al,rs),c(e,hi,t),J(Be,e,t),c(e,_i,t),c(e,g,t),l(g,cs),l(g,mo),l(mo,ds),l(g,ps),l(g,fo),l(fo,us),l(g,ms),l(g,We),l(We,fs),l(g,Ms),c(e,zi,t),c(e,de,t),l(de,ys),l(de,tl),l(tl,Js),l(de,ws),c(e,Ci,t),c(e,O,t),l(O,pe),l(pe,Mo),J(Xe,Mo,null),l(O,bs),l(O,yo),l(yo,js),c(e,Ii,t),c(e,Z,t),l(Z,Us),l(Z,Jo),l(Jo,Ts),l(Z,vs),l(Z,Ge),l(Ge,hs),l(Z,_s),l(Z,wo),l(wo,zs),l(Z,Cs),c(e,Ei,t),J(Qe,e,t),c(e,gi,t),c(e,ue,t),l(ue,Is),l(ue,bo),l(bo,Es),l(ue,gs),c(e,Zi,t),J(Ve,e,t),c(e,Ai,t),c(e,sl,t),l(sl,Zs),c(e,$i,t),c(e,x,t),l(x,me),l(me,jo),J(qe,jo,null),l(x,As),l(x,Uo),l(Uo,$s),c(e,Ni,t),c(e,nl,t),l(nl,Ns),c(e,ki,t),c(e,q,t),l(q,ks),l(q,To),l(To,Rs),l(q,Bs),l(q,vo),l(vo,Ws),l(q,Xs),c(e,Ri,t),J(Ye,e,t),c(e,Bi,t),c(e,A,t),l(A,Gs),l(A,ho),l(ho,Qs),l(A,Vs),l(A,_o),l(_o,qs),l(A,Ys),l(A,zo),l(zo,Fs),l(A,Ss),Wi=!0},p(e,[t]){const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),ae.$set(Fe);const Co={};t&2&&(Co.$$scope={dirty:t,ctx:e}),se.$set(Co);const Io={};t&2&&(Io.$$scope={dirty:t,ctx:e}),ne.$set(Io)},i(e){Wi||(w(C.$$.fragment,e),w(je.$$.fragment,e),w(Ue.$$.fragment,e),w(ve.$$.fragment,e),w(he.$$.fragment,e),w(_e.$$.fragment,e),w(ze.$$.fragment,e),w(Ce.$$.fragment,e),w(ae.$$.fragment,e),w(Ie.$$.fragment,e),w(Ee.$$.fragment,e),w(ge.$$.fragment,e),w(se.$$.fragment,e),w(Ze.$$.fragment,e),w(ne.$$.fragment,e),w(Ae.$$.fragment,e),w($e.$$.fragment,e),w(Ne.$$.fragment,e),w(ke.$$.fragment,e),w(Re.$$.fragment,e),w(Be.$$.fragment,e),w(Xe.$$.fragment,e),w(Qe.$$.fragment,e),w(Ve.$$.fragment,e),w(qe.$$.fragment,e),w(Ye.$$.fragment,e),Wi=!0)},o(e){b(C.$$.fragment,e),b(je.$$.fragment,e),b(Ue.$$.fragment,e),b(ve.$$.fragment,e),b(he.$$.fragment,e),b(_e.$$.fragment,e),b(ze.$$.fragment,e),b(Ce.$$.fragment,e),b(ae.$$.fragment,e),b(Ie.$$.fragment,e),b(Ee.$$.fragment,e),b(ge.$$.fragment,e),b(se.$$.fragment,e),b(Ze.$$.fragment,e),b(ne.$$.fragment,e),b(Ae.$$.fragment,e),b($e.$$.fragment,e),b(Ne.$$.fragment,e),b(ke.$$.fragment,e),b(Re.$$.fragment,e),b(Be.$$.fragment,e),b(Xe.$$.fragment,e),b(Qe.$$.fragment,e),b(Ve.$$.fragment,e),b(qe.$$.fragment,e),b(Ye.$$.fragment,e),Wi=!1},d(e){o(m),e&&o(h),e&&o(f),j(C),e&&o(go),e&&o(Se),e&&o(Zo),e&&o(N),e&&o(Ao),e&&o(S),j(je),e&&o($o),e&&o(Pe),e&&o(No),j(Ue,e),e&&o(ko),e&&o(De),e&&o(Ro),e&&o(k),e&&o(Bo),e&&o(R),e&&o(Wo),e&&o(B),e&&o(Xo),e&&o(He),e&&o(Go),j(ve,e),e&&o(Qo),e&&o(I),e&&o(Vo),j(he,e),e&&o(qo),e&&o(W),e&&o(Yo),e&&o(D),j(_e),e&&o(Fo),e&&o(X),e&&o(So),e&&o(ie),e&&o(Po),j(ze,e),e&&o(Do),e&&o(Oe),e&&o(Ho),j(Ce,e),e&&o(Oo),e&&o(z),e&&o(xo),j(ae,e),e&&o(Lo),e&&o(G),e&&o(Ko),e&&o(xe),e&&o(ei),j(Ie,e),e&&o(li),e&&o(E),e&&o(oi),e&&o(Le),e&&o(ii),j(Ee,e),e&&o(ai),e&&o(Q),e&&o(ti),e&&o(H),j(ge),e&&o(si),j(se,e),e&&o(ni),e&&o(T),e&&o(ri),j(Ze,e),e&&o(ci),e&&o(V),e&&o(di),j(ne,e),e&&o(pi),e&&o(Ke),e&&o(ui),e&&o(el),e&&o(mi),j(Ae,e),e&&o(fi),e&&o(re),e&&o(Mi),j($e,e),e&&o(yi),e&&o(ce),e&&o(Ji),e&&o(ll),e&&o(wi),j(Ne,e),e&&o(bi),e&&o(ol),e&&o(ji),j(ke,e),e&&o(Ui),e&&o(il),e&&o(Ti),j(Re,e),e&&o(vi),e&&o(al),e&&o(hi),j(Be,e),e&&o(_i),e&&o(g),e&&o(zi),e&&o(de),e&&o(Ci),e&&o(O),j(Xe),e&&o(Ii),e&&o(Z),e&&o(Ei),j(Qe,e),e&&o(gi),e&&o(ue),e&&o(Zi),j(Ve,e),e&&o(Ai),e&&o(sl),e&&o($i),e&&o(x),j(qe),e&&o(Ni),e&&o(nl),e&&o(ki),e&&o(q),e&&o(Ri),j(Ye,e),e&&o(Bi),e&&o(A)}}}const kr={local:"condividere-modelli-personalizzati",sections:[{local:"scrivere-una-configurazione-personalizzata",title:"Scrivere una configurazione personalizzata"},{local:"scrivere-un-modello-personalizzato",title:"Scrivere un modello personalizzato"},{local:"inviare-il-codice-allhub",title:"Inviare il codice all'Hub"},{local:"usare-un-modello-con-codice-personalizzato",title:"Usare un modello con codice personalizzato"},{local:"registrare-un-modello-con-codice-personalizzato-nelle-classi-auto",title:"Registrare un modello con codice personalizzato nelle classi Auto"}],title:"Condividere modelli personalizzati"};function Rr(L){return gr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qr extends zr{constructor(m){super();Cr(this,m,Rr,Nr,Ir,{})}}export{Qr as default,kr as metadata};
