import{s as rn,f as ln,o as dn,n as U}from"../chunks/scheduler.9bc65507.js";import{S as cn,i as pn,g as n,s as i,u as _,A as mn,h as r,f as t,c as d,j as u,v,y as h,k as f,o as s,a as c,w as b,d as y,t as w,x as M}from"../chunks/index.78c82d43.js";import{T as es}from"../chunks/Tip.87d55b76.js";import{D as Z}from"../chunks/Docstring.f3d04bd2.js";import{C as _t}from"../chunks/CodeBlock.48618ec2.js";import{I as X}from"../chunks/IconCopyLink.bedaa44d.js";import{E as gt}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as hn}from"../chunks/PipelineTag.75b0f707.js";function fn(N){let o,T="Example:",p,m,g;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlc05ldENvbmZpZyUyQyUyMFJlc05ldE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFJlc05ldCUyMHJlc25ldC01MCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBSZXNOZXRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwcmVzbmV0LTUwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBSZXNOZXRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ResNetConfig, ResNetModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ResNet resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ResNetConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ResNetModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){o=n("p"),o.textContent=T,p=i(),_(m.$$.fragment)},l(a){o=r(a,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),p=d(a),v(m.$$.fragment,a)},m(a,$){c(a,o,$),c(a,p,$),b(m,a,$),g=!0},p:U,i(a){g||(y(m.$$.fragment,a),g=!0)},o(a){w(m.$$.fragment,a),g=!1},d(a){a&&(t(o),t(p)),M(m,a)}}}function un(N){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=n("p"),o.innerHTML=T},l(p){o=r(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,m){c(p,o,m)},p:U,d(p){p&&t(o)}}}function gn(N){let o,T="Example:",p,m,g;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFJlc05ldE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZyZXNuZXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBSZXNOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGcmVzbmV0LTUwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ResNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ResNetModel.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`}}),{c(){o=n("p"),o.textContent=T,p=i(),_(m.$$.fragment)},l(a){o=r(a,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),p=d(a),v(m.$$.fragment,a)},m(a,$){c(a,o,$),c(a,p,$),b(m,a,$),g=!0},p:U,i(a){g||(y(m.$$.fragment,a),g=!0)},o(a){w(m.$$.fragment,a),g=!1},d(a){a&&(t(o),t(p)),M(m,a)}}}function _n(N){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=n("p"),o.innerHTML=T},l(p){o=r(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,m){c(p,o,m)},p:U,d(p){p&&t(o)}}}function vn(N){let o,T="Example:",p,m,g;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFJlc05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMFJlc05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnJlc25ldC01MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ResNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ResNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tiger cat`}}),{c(){o=n("p"),o.textContent=T,p=i(),_(m.$$.fragment)},l(a){o=r(a,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),p=d(a),v(m.$$.fragment,a)},m(a,$){c(a,o,$),c(a,p,$),b(m,a,$),g=!0},p:U,i(a){g||(y(m.$$.fragment,a),g=!0)},o(a){w(m.$$.fragment,a),g=!1},d(a){a&&(t(o),t(p)),M(m,a)}}}function bn(N){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=n("p"),o.innerHTML=T},l(p){o=r(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,m){c(p,o,m)},p:U,d(p){p&&t(o)}}}function yn(N){let o,T="Example:",p,m,g;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGUmVzTmV0TW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZyZXNuZXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlJlc05ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZyZXNuZXQtNTAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFResNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFResNetModel.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`}}),{c(){o=n("p"),o.textContent=T,p=i(),_(m.$$.fragment)},l(a){o=r(a,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),p=d(a),v(m.$$.fragment,a)},m(a,$){c(a,o,$),c(a,p,$),b(m,a,$),g=!0},p:U,i(a){g||(y(m.$$.fragment,a),g=!0)},o(a){w(m.$$.fragment,a),g=!1},d(a){a&&(t(o),t(p)),M(m,a)}}}function wn(N){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=n("p"),o.innerHTML=T},l(p){o=r(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,m){c(p,o,m)},p:U,d(p){p&&t(o)}}}function Mn(N){let o,T="Example:",p,m,g;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGUmVzTmV0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGcmVzbmV0LTUwJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZSZXNOZXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZyZXNuZXQtNTAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGludCh0Zi5tYXRoLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFResNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFResNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tiger cat`}}),{c(){o=n("p"),o.textContent=T,p=i(),_(m.$$.fragment)},l(a){o=r(a,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),p=d(a),v(m.$$.fragment,a)},m(a,$){c(a,o,$),c(a,p,$),b(m,a,$),g=!0},p:U,i(a){g||(y(m.$$.fragment,a),g=!0)},o(a){w(m.$$.fragment,a),g=!1},d(a){a&&(t(o),t(p)),M(m,a)}}}function Tn(N){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=n("p"),o.innerHTML=T},l(p){o=r(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,m){c(p,o,m)},p:U,d(p){p&&t(o)}}}function $n(N){let o,T="Examples:",p,m,g;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhSZXNOZXRNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGcmVzbmV0LTUwJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheFJlc05ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZyZXNuZXQtNTAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxResNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxResNetModel.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){o=n("p"),o.textContent=T,p=i(),_(m.$$.fragment)},l(a){o=r(a,"P",{"data-svelte-h":!0}),h(o)!=="svelte-kvfsh7"&&(o.textContent=T),p=d(a),v(m.$$.fragment,a)},m(a,$){c(a,o,$),c(a,p,$),b(m,a,$),g=!0},p:U,i(a){g||(y(m.$$.fragment,a),g=!0)},o(a){w(m.$$.fragment,a),g=!1},d(a){a&&(t(o),t(p)),M(m,a)}}}function Nn(N){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=n("p"),o.innerHTML=T},l(p){o=r(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,m){c(p,o,m)},p:U,d(p){p&&t(o)}}}function Cn(N){let o,T="Example:",p,m,g;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhSZXNOZXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZyZXNuZXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4UmVzTmV0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGcmVzbmV0LTUwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBqYXgubnVtcHkuYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHguaXRlbSgpJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxResNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxResNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = jax.numpy.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx.item()])`}}),{c(){o=n("p"),o.textContent=T,p=i(),_(m.$$.fragment)},l(a){o=r(a,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),p=d(a),v(m.$$.fragment,a)},m(a,$){c(a,o,$),c(a,p,$),b(m,a,$),g=!0},p:U,i(a){g||(y(m.$$.fragment,a),g=!0)},o(a){w(m.$$.fragment,a),g=!1},d(a){a&&(t(o),t(p)),M(m,a)}}}function xn(N){let o,T,p,m,g,a,$,Fe,so,vt,sa="ResNet",bs,A,ee,ts,Je,oo,bt,oa="Overview",ys,Ie,aa='The ResNet model was proposed in <a href="https://arxiv.org/abs/1512.03385" rel="nofollow">Deep Residual Learning for Image Recognition</a> by Kaiming He, Xiangyu Zhang, Shaoqing Ren and Jian Sun. Our implementation follows the small changes made by <a href="https://catalog.ngc.nvidia.com/orgs/nvidia/resources/resnet_50_v1_5_for_pytorch" rel="nofollow">Nvidia</a>, we apply the <code>stride=2</code> for downsampling in bottleneck’s <code>3x3</code> conv and not in the first <code>1x1</code>. This is generally known as “ResNet v1.5”.',ws,Ze,na="ResNet introduced residual connections, they allow to train networks with an unseen number of layers (up to 1000). ResNet won the 2015 ILSVRC & COCO competition, one important milestone in deep computer vision.",Ms,Ue,ra="The abstract from the paper is the following:",Ts,We,la=`<em>Deeper neural networks are more difficult to train. We present a residual learning framework to ease the training of networks that are substantially deeper than those used previously. We explicitly reformulate the layers as learning residual functions with reference to the layer inputs, instead of learning unreferenced functions. We provide comprehensive empirical evidence showing that these residual networks are easier to optimize, and can gain accuracy from considerably increased depth. On the ImageNet dataset we evaluate residual nets with a depth of up to 152 layers---8x deeper than VGG nets but still having lower complexity. An ensemble of these residual nets achieves 3.57% error on the ImageNet test set. This result won the 1st place on the ILSVRC 2015 classification task. We also present analysis on CIFAR-10 with 100 and 1000 layers.
The depth of representations is of central importance for many visual recognition tasks. Solely due to our extremely deep representations, we obtain a 28% relative improvement on the COCO object detection dataset. Deep residual nets are foundations of our submissions to ILSVRC &amp; COCO 2015 competitions, where we also won the 1st places on the tasks of ImageNet detection, ImageNet localization, COCO detection, and COCO segmentation.</em>`,$s,ke,ia="Tips:",Ns,Be,da='<li>One can use <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images for the model.</li>',Cs,ze,ca='The figure below illustrates the architecture of ResNet. Taken from the <a href="https://arxiv.org/abs/1512.03385" rel="nofollow">original paper</a>.',xs,Ve,pa,js,Pe,ma='This model was contributed by <a href="https://huggingface.co/Francesco" rel="nofollow">Francesco</a>. The TensorFlow version of this model was added by <a href="https://huggingface.co/amyeroberts" rel="nofollow">amyeroberts</a>. The original code can be found <a href="https://github.com/KaimingHe/deep-residual-networks" rel="nofollow">here</a>.',Rs,L,te,ss,Ge,ao,yt,ha="Resources",Fs,He,fa="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ResNet.",Js,Ee,Is,Xe,ua='<li><a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetForImageClassification">ResNetForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Zs,Ae,ga="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Us,Q,se,os,Le,no,wt,_a="ResNetConfig",Ws,F,Qe,ro,Mt,va=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a>. It is used to instantiate an
ResNet model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the ResNet
<a href="https://huggingface.co/microsoft/resnet-50" rel="nofollow">microsoft/resnet-50</a> architecture.`,lo,Tt,ba=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,io,oe,ks,Y,ae,as,Ye,co,$t,ya="ResNetModel",Bs,G,Se,po,Nt,wa=`The bare ResNet model outputting raw features without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,mo,W,qe,ho,Ct,Ma='The <a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a> forward method, overrides the <code>__call__</code> special method.',fo,ne,uo,re,zs,S,le,ns,De,go,xt,Ta="ResNetForImageClassification",Vs,J,Oe,_o,jt,$a=`ResNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,vo,Rt,Na=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,bo,k,Ke,yo,Ft,Ca='The <a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetForImageClassification">ResNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',wo,ie,Mo,de,Ps,q,ce,rs,et,To,Jt,xa="TFResNetModel",Gs,H,tt,$o,It,ja=`The bare ResNet model outputting raw features without any specific head on top.
This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and
behavior.`,No,B,st,Co,Zt,Ra='The <a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.TFResNetModel">TFResNetModel</a> forward method, overrides the <code>__call__</code> special method.',xo,pe,jo,me,Hs,D,he,ls,ot,Ro,Ut,Fa="TFResNetForImageClassification",Es,I,at,Fo,Wt,Ja=`ResNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,Jo,kt,Ia=`This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and
behavior.`,Io,z,nt,Zo,Bt,Za='The <a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.TFResNetForImageClassification">TFResNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Uo,fe,Wo,ue,Xs,O,ge,is,rt,ko,zt,Ua="FlaxResNetModel",As,C,lt,Bo,Vt,Wa="The bare ResNet model outputting raw features without any specific head on top.",zo,Pt,ka=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Vo,Gt,Ba=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Po,Ht,za="Finally, this model supports inherent JAX features such as:",Go,Et,Va='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Ho,V,it,Eo,Xt,Pa="The <code>FlaxResNetPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Xo,_e,Ao,ve,Ls,K,be,ds,dt,Lo,At,Ga="FlaxResNetForImageClassification",Qs,x,ct,Qo,Lt,Ha=`ResNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,Yo,Qt,Ea=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,So,Yt,Xa=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,qo,St,Aa="Finally, this model supports inherent JAX features such as:",Do,qt,La='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Oo,P,pt,Ko,Dt,Qa="The <code>FlaxResNetPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",ea,ye,ta,we,Ys,cs,Ss;return Fe=new X({}),Je=new X({}),Ge=new X({}),Ee=new hn({props:{pipeline:"image-classification"}}),Le=new X({}),Qe=new Z({props:{name:"class transformers.ResNetConfig",anchor:"transformers.ResNetConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"embedding_size",val:" = 64"},{name:"hidden_sizes",val:" = [256, 512, 1024, 2048]"},{name:"depths",val:" = [3, 4, 6, 3]"},{name:"layer_type",val:" = 'bottleneck'"},{name:"hidden_act",val:" = 'relu'"},{name:"downsample_in_first_stage",val:" = False"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ResNetConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.ResNetConfig.embedding_size",description:`<strong>embedding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality (hidden size) for the embedding layer.`,name:"embedding_size"},{anchor:"transformers.ResNetConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 512, 1024, 2048]</code>) &#x2014;
Dimensionality (hidden size) at each stage.`,name:"hidden_sizes"},{anchor:"transformers.ResNetConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 4, 6, 3]</code>) &#x2014;
Depth (number of layers) for each stage.`,name:"depths"},{anchor:"transformers.ResNetConfig.layer_type",description:`<strong>layer_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bottleneck&quot;</code>) &#x2014;
The layer to use, it can be either <code>&quot;basic&quot;</code> (used for smaller models, like resnet-18 or resnet-34) or
<code>&quot;bottleneck&quot;</code> (used for larger models like resnet-50 and above).`,name:"layer_type"},{anchor:"transformers.ResNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function in each block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code>
are supported.`,name:"hidden_act"},{anchor:"transformers.ResNetConfig.downsample_in_first_stage",description:`<strong>downsample_in_first_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the first stage will downsample the inputs using a <code>stride</code> of 2.`,name:"downsample_in_first_stage"},{anchor:"transformers.ResNetConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage.`,name:"out_features"},{anchor:"transformers.ResNetConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/configuration_resnet.py#L35"}}),oe=new gt({props:{anchor:"transformers.ResNetConfig.example",$$slots:{default:[fn]},$$scope:{ctx:N}}}),Ye=new X({}),Se=new Z({props:{name:"class transformers.ResNetModel",anchor:"transformers.ResNetModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ResNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_resnet.py#L303"}}),qe=new Z({props:{name:"forward",anchor:"transformers.ResNetModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ResNetModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.ResNetModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ResNetModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_resnet.py#L313",returnDescription:`
<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig"
>ResNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ne=new es({props:{$$slots:{default:[un]},$$scope:{ctx:N}}}),re=new gt({props:{anchor:"transformers.ResNetModel.forward.example",$$slots:{default:[gn]},$$scope:{ctx:N}}}),De=new X({}),Oe=new Z({props:{name:"class transformers.ResNetForImageClassification",anchor:"transformers.ResNetForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ResNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_resnet.py#L356"}}),Ke=new Z({props:{name:"forward",anchor:"transformers.ResNetForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ResNetForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.ResNetForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ResNetForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ResNetForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_resnet.py#L369",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig"
>ResNetConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new es({props:{$$slots:{default:[_n]},$$scope:{ctx:N}}}),de=new gt({props:{anchor:"transformers.ResNetForImageClassification.forward.example",$$slots:{default:[vn]},$$scope:{ctx:N}}}),et=new X({}),tt=new Z({props:{name:"class transformers.TFResNetModel",anchor:"transformers.TFResNetModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFResNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_tf_resnet.py#L372"}}),st=new Z({props:{name:"call",anchor:"transformers.TFResNetModel.call",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFResNetModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFResNetModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFResNetModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_tf_resnet.py#L377",returnDescription:`
<p>A <code>transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndNoAttention</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig"
>ResNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(tf.Tensor)</code></p>
`}}),pe=new es({props:{$$slots:{default:[bn]},$$scope:{ctx:N}}}),me=new gt({props:{anchor:"transformers.TFResNetModel.call.example",$$slots:{default:[yn]},$$scope:{ctx:N}}}),ot=new X({}),at=new Z({props:{name:"class transformers.TFResNetForImageClassification",anchor:"transformers.TFResNetForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFResNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_tf_resnet.py#L414"}}),nt=new Z({props:{name:"call",anchor:"transformers.TFResNetForImageClassification.call",parameters:[{name:"pixel_values",val:": Tensor = None"},{name:"labels",val:": Tensor = None"},{name:"output_hidden_states",val:": bool = None"},{name:"return_dict",val:": bool = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFResNetForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFResNetForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFResNetForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFResNetForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_tf_resnet.py#L431",returnDescription:`
<p>A <code>transformers.modeling_tf_outputs.TFImageClassifierOutputWithNoAttention</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig"
>ResNetConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called
feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_tf_outputs.TFImageClassifierOutputWithNoAttention</code> or <code>tuple(tf.Tensor)</code></p>
`}}),fe=new es({props:{$$slots:{default:[wn]},$$scope:{ctx:N}}}),ue=new gt({props:{anchor:"transformers.TFResNetForImageClassification.call.example",$$slots:{default:[Mn]},$$scope:{ctx:N}}}),rt=new X({}),lt=new Z({props:{name:"class transformers.FlaxResNetModel",anchor:"transformers.FlaxResNetModel",parameters:[{name:"config",val:": ResNetConfig"},{name:"input_shape",val:" = (1, 224, 224, 3)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxResNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxResNetModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_flax_resnet.py#L580"}}),it=new Z({props:{name:"__call__",anchor:"transformers.FlaxResNetModel.__call__",parameters:[{name:"pixel_values",val:""},{name:"params",val:": dict = None"},{name:"train",val:": bool = False"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_flax_resnet.py#L488",returnDescription:`
<p>A <code>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPoolingAndNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.resnet.configuration_resnet.ResNetConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings, if the model has an embedding layer, + one
for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states of the
model at the output of each layer plus the optional initial embedding outputs.</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new es({props:{$$slots:{default:[Tn]},$$scope:{ctx:N}}}),ve=new gt({props:{anchor:"transformers.FlaxResNetModel.__call__.example",$$slots:{default:[$n]},$$scope:{ctx:N}}}),dt=new X({}),ct=new Z({props:{name:"class transformers.FlaxResNetForImageClassification",anchor:"transformers.FlaxResNetForImageClassification",parameters:[{name:"config",val:": ResNetConfig"},{name:"input_shape",val:" = (1, 224, 224, 3)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxResNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxResNetForImageClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_flax_resnet.py#L667"}}),pt=new Z({props:{name:"__call__",anchor:"transformers.FlaxResNetForImageClassification.__call__",parameters:[{name:"pixel_values",val:""},{name:"params",val:": dict = None"},{name:"train",val:": bool = False"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/resnet/modeling_flax_resnet.py#L488",returnDescription:`
<p>A <code>transformers.modeling_flax_outputs.FlaxImageClassifierOutputWithNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.resnet.configuration_resnet.ResNetConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when</li>
<li><strong><code>config.output_hidden_states=True</code>):</strong>
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings, if the model has an embedding layer, + one
for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_flax_outputs.FlaxImageClassifierOutputWithNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new es({props:{$$slots:{default:[Nn]},$$scope:{ctx:N}}}),we=new gt({props:{anchor:"transformers.FlaxResNetForImageClassification.__call__.example",$$slots:{default:[Cn]},$$scope:{ctx:N}}}),{c(){o=n("meta"),T=i(),p=n("p"),m=i(),g=n("h1"),a=n("a"),$=n("span"),_(Fe.$$.fragment),so=i(),vt=n("span"),vt.textContent=sa,bs=i(),A=n("h2"),ee=n("a"),ts=n("span"),_(Je.$$.fragment),oo=i(),bt=n("span"),bt.textContent=oa,ys=i(),Ie=n("p"),Ie.innerHTML=aa,ws=i(),Ze=n("p"),Ze.textContent=na,Ms=i(),Ue=n("p"),Ue.textContent=ra,Ts=i(),We=n("p"),We.innerHTML=la,$s=i(),ke=n("p"),ke.textContent=ia,Ns=i(),Be=n("ul"),Be.innerHTML=da,Cs=i(),ze=n("p"),ze.innerHTML=ca,xs=i(),Ve=n("img"),js=i(),Pe=n("p"),Pe.innerHTML=ma,Rs=i(),L=n("h2"),te=n("a"),ss=n("span"),_(Ge.$$.fragment),ao=i(),yt=n("span"),yt.textContent=ha,Fs=i(),He=n("p"),He.textContent=fa,Js=i(),_(Ee.$$.fragment),Is=i(),Xe=n("ul"),Xe.innerHTML=ua,Zs=i(),Ae=n("p"),Ae.textContent=ga,Us=i(),Q=n("h2"),se=n("a"),os=n("span"),_(Le.$$.fragment),no=i(),wt=n("span"),wt.textContent=_a,Ws=i(),F=n("div"),_(Qe.$$.fragment),ro=i(),Mt=n("p"),Mt.innerHTML=va,lo=i(),Tt=n("p"),Tt.innerHTML=ba,io=i(),_(oe.$$.fragment),ks=i(),Y=n("h2"),ae=n("a"),as=n("span"),_(Ye.$$.fragment),co=i(),$t=n("span"),$t.textContent=ya,Bs=i(),G=n("div"),_(Se.$$.fragment),po=i(),Nt=n("p"),Nt.innerHTML=wa,mo=i(),W=n("div"),_(qe.$$.fragment),ho=i(),Ct=n("p"),Ct.innerHTML=Ma,fo=i(),_(ne.$$.fragment),uo=i(),_(re.$$.fragment),zs=i(),S=n("h2"),le=n("a"),ns=n("span"),_(De.$$.fragment),go=i(),xt=n("span"),xt.textContent=Ta,Vs=i(),J=n("div"),_(Oe.$$.fragment),_o=i(),jt=n("p"),jt.textContent=$a,vo=i(),Rt=n("p"),Rt.innerHTML=Na,bo=i(),k=n("div"),_(Ke.$$.fragment),yo=i(),Ft=n("p"),Ft.innerHTML=Ca,wo=i(),_(ie.$$.fragment),Mo=i(),_(de.$$.fragment),Ps=i(),q=n("h2"),ce=n("a"),rs=n("span"),_(et.$$.fragment),To=i(),Jt=n("span"),Jt.textContent=xa,Gs=i(),H=n("div"),_(tt.$$.fragment),$o=i(),It=n("p"),It.innerHTML=ja,No=i(),B=n("div"),_(st.$$.fragment),Co=i(),Zt=n("p"),Zt.innerHTML=Ra,xo=i(),_(pe.$$.fragment),jo=i(),_(me.$$.fragment),Hs=i(),D=n("h2"),he=n("a"),ls=n("span"),_(ot.$$.fragment),Ro=i(),Ut=n("span"),Ut.textContent=Fa,Es=i(),I=n("div"),_(at.$$.fragment),Fo=i(),Wt=n("p"),Wt.textContent=Ja,Jo=i(),kt=n("p"),kt.innerHTML=Ia,Io=i(),z=n("div"),_(nt.$$.fragment),Zo=i(),Bt=n("p"),Bt.innerHTML=Za,Uo=i(),_(fe.$$.fragment),Wo=i(),_(ue.$$.fragment),Xs=i(),O=n("h2"),ge=n("a"),is=n("span"),_(rt.$$.fragment),ko=i(),zt=n("span"),zt.textContent=Ua,As=i(),C=n("div"),_(lt.$$.fragment),Bo=i(),Vt=n("p"),Vt.textContent=Wa,zo=i(),Pt=n("p"),Pt.innerHTML=ka,Vo=i(),Gt=n("p"),Gt.innerHTML=Ba,Po=i(),Ht=n("p"),Ht.textContent=za,Go=i(),Et=n("ul"),Et.innerHTML=Va,Ho=i(),V=n("div"),_(it.$$.fragment),Eo=i(),Xt=n("p"),Xt.innerHTML=Pa,Xo=i(),_(_e.$$.fragment),Ao=i(),_(ve.$$.fragment),Ls=i(),K=n("h2"),be=n("a"),ds=n("span"),_(dt.$$.fragment),Lo=i(),At=n("span"),At.textContent=Ga,Qs=i(),x=n("div"),_(ct.$$.fragment),Qo=i(),Lt=n("p"),Lt.textContent=Ha,Yo=i(),Qt=n("p"),Qt.innerHTML=Ea,So=i(),Yt=n("p"),Yt.innerHTML=Xa,qo=i(),St=n("p"),St.textContent=Aa,Do=i(),qt=n("ul"),qt.innerHTML=La,Oo=i(),P=n("div"),_(pt.$$.fragment),Ko=i(),Dt=n("p"),Dt.innerHTML=Qa,ea=i(),_(ye.$$.fragment),ta=i(),_(we.$$.fragment),Ys=i(),cs=n("p"),this.h()},l(e){const l=mn("svelte-1phssyn",document.head);o=r(l,"META",{name:!0,content:!0}),l.forEach(t),T=d(e),p=r(e,"P",{}),u(p).forEach(t),m=d(e),g=r(e,"H1",{class:!0});var mt=u(g);a=r(mt,"A",{id:!0,class:!0,href:!0});var ps=u(a);$=r(ps,"SPAN",{});var ms=u($);v(Fe.$$.fragment,ms),ms.forEach(t),ps.forEach(t),so=d(mt),vt=r(mt,"SPAN",{"data-svelte-h":!0}),h(vt)!=="svelte-ww93ci"&&(vt.textContent=sa),mt.forEach(t),bs=d(e),A=r(e,"H2",{class:!0});var ht=u(A);ee=r(ht,"A",{id:!0,class:!0,href:!0});var hs=u(ee);ts=r(hs,"SPAN",{});var fs=u(ts);v(Je.$$.fragment,fs),fs.forEach(t),hs.forEach(t),oo=d(ht),bt=r(ht,"SPAN",{"data-svelte-h":!0}),h(bt)!=="svelte-1jsw1pg"&&(bt.textContent=oa),ht.forEach(t),ys=d(e),Ie=r(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-ybpvez"&&(Ie.innerHTML=aa),ws=d(e),Ze=r(e,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1khrbjk"&&(Ze.textContent=na),Ms=d(e),Ue=r(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-vfdo9a"&&(Ue.textContent=ra),Ts=d(e),We=r(e,"P",{"data-svelte-h":!0}),h(We)!=="svelte-xwc7kf"&&(We.innerHTML=la),$s=d(e),ke=r(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-axv494"&&(ke.textContent=ia),Ns=d(e),Be=r(e,"UL",{"data-svelte-h":!0}),h(Be)!=="svelte-1coa3t1"&&(Be.innerHTML=da),Cs=d(e),ze=r(e,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-17i7uin"&&(ze.innerHTML=ca),xs=d(e),Ve=r(e,"IMG",{width:!0,src:!0}),js=d(e),Pe=r(e,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-1evl8l5"&&(Pe.innerHTML=ma),Rs=d(e),L=r(e,"H2",{class:!0});var ft=u(L);te=r(ft,"A",{id:!0,class:!0,href:!0});var us=u(te);ss=r(us,"SPAN",{});var gs=u(ss);v(Ge.$$.fragment,gs),gs.forEach(t),us.forEach(t),ao=d(ft),yt=r(ft,"SPAN",{"data-svelte-h":!0}),h(yt)!=="svelte-w4zzv6"&&(yt.textContent=ha),ft.forEach(t),Fs=d(e),He=r(e,"P",{"data-svelte-h":!0}),h(He)!=="svelte-1ageb22"&&(He.textContent=fa),Js=d(e),v(Ee.$$.fragment,e),Is=d(e),Xe=r(e,"UL",{"data-svelte-h":!0}),h(Xe)!=="svelte-1e3bg9i"&&(Xe.innerHTML=ua),Zs=d(e),Ae=r(e,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-1xesile"&&(Ae.textContent=ga),Us=d(e),Q=r(e,"H2",{class:!0});var ut=u(Q);se=r(ut,"A",{id:!0,class:!0,href:!0});var _s=u(se);os=r(_s,"SPAN",{});var vs=u(os);v(Le.$$.fragment,vs),vs.forEach(t),_s.forEach(t),no=d(ut),wt=r(ut,"SPAN",{"data-svelte-h":!0}),h(wt)!=="svelte-1cb88k4"&&(wt.textContent=_a),ut.forEach(t),Ws=d(e),F=r(e,"DIV",{class:!0});var E=u(F);v(Qe.$$.fragment,E),ro=d(E),Mt=r(E,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-111ajmy"&&(Mt.innerHTML=va),lo=d(E),Tt=r(E,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-cfh5wl"&&(Tt.innerHTML=ba),io=d(E),v(oe.$$.fragment,E),E.forEach(t),ks=d(e),Y=r(e,"H2",{class:!0});var qs=u(Y);ae=r(qs,"A",{id:!0,class:!0,href:!0});var Ya=u(ae);as=r(Ya,"SPAN",{});var Sa=u(as);v(Ye.$$.fragment,Sa),Sa.forEach(t),Ya.forEach(t),co=d(qs),$t=r(qs,"SPAN",{"data-svelte-h":!0}),h($t)!=="svelte-1cdekit"&&($t.textContent=ya),qs.forEach(t),Bs=d(e),G=r(e,"DIV",{class:!0});var Ot=u(G);v(Se.$$.fragment,Ot),po=d(Ot),Nt=r(Ot,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-6r8zbj"&&(Nt.innerHTML=wa),mo=d(Ot),W=r(Ot,"DIV",{class:!0});var Me=u(W);v(qe.$$.fragment,Me),ho=d(Me),Ct=r(Me,"P",{"data-svelte-h":!0}),h(Ct)!=="svelte-1cu12ac"&&(Ct.innerHTML=Ma),fo=d(Me),v(ne.$$.fragment,Me),uo=d(Me),v(re.$$.fragment,Me),Me.forEach(t),Ot.forEach(t),zs=d(e),S=r(e,"H2",{class:!0});var Ds=u(S);le=r(Ds,"A",{id:!0,class:!0,href:!0});var qa=u(le);ns=r(qa,"SPAN",{});var Da=u(ns);v(De.$$.fragment,Da),Da.forEach(t),qa.forEach(t),go=d(Ds),xt=r(Ds,"SPAN",{"data-svelte-h":!0}),h(xt)!=="svelte-1z0f2oi"&&(xt.textContent=Ta),Ds.forEach(t),Vs=d(e),J=r(e,"DIV",{class:!0});var Te=u(J);v(Oe.$$.fragment,Te),_o=d(Te),jt=r(Te,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-d6857j"&&(jt.textContent=$a),vo=d(Te),Rt=r(Te,"P",{"data-svelte-h":!0}),h(Rt)!=="svelte-1gjh92c"&&(Rt.innerHTML=Na),bo=d(Te),k=r(Te,"DIV",{class:!0});var $e=u(k);v(Ke.$$.fragment,$e),yo=d($e),Ft=r($e,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-shxpxi"&&(Ft.innerHTML=Ca),wo=d($e),v(ie.$$.fragment,$e),Mo=d($e),v(de.$$.fragment,$e),$e.forEach(t),Te.forEach(t),Ps=d(e),q=r(e,"H2",{class:!0});var Os=u(q);ce=r(Os,"A",{id:!0,class:!0,href:!0});var Oa=u(ce);rs=r(Oa,"SPAN",{});var Ka=u(rs);v(et.$$.fragment,Ka),Ka.forEach(t),Oa.forEach(t),To=d(Os),Jt=r(Os,"SPAN",{"data-svelte-h":!0}),h(Jt)!=="svelte-d1capn"&&(Jt.textContent=xa),Os.forEach(t),Gs=d(e),H=r(e,"DIV",{class:!0});var Kt=u(H);v(tt.$$.fragment,Kt),$o=d(Kt),It=r(Kt,"P",{"data-svelte-h":!0}),h(It)!=="svelte-1egd8ne"&&(It.innerHTML=ja),No=d(Kt),B=r(Kt,"DIV",{class:!0});var Ne=u(B);v(st.$$.fragment,Ne),Co=d(Ne),Zt=r(Ne,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-1arkhs"&&(Zt.innerHTML=Ra),xo=d(Ne),v(pe.$$.fragment,Ne),jo=d(Ne),v(me.$$.fragment,Ne),Ne.forEach(t),Kt.forEach(t),Hs=d(e),D=r(e,"H2",{class:!0});var Ks=u(D);he=r(Ks,"A",{id:!0,class:!0,href:!0});var en=u(he);ls=r(en,"SPAN",{});var tn=u(ls);v(ot.$$.fragment,tn),tn.forEach(t),en.forEach(t),Ro=d(Ks),Ut=r(Ks,"SPAN",{"data-svelte-h":!0}),h(Ut)!=="svelte-dpd52c"&&(Ut.textContent=Fa),Ks.forEach(t),Es=d(e),I=r(e,"DIV",{class:!0});var Ce=u(I);v(at.$$.fragment,Ce),Fo=d(Ce),Wt=r(Ce,"P",{"data-svelte-h":!0}),h(Wt)!=="svelte-d6857j"&&(Wt.textContent=Ja),Jo=d(Ce),kt=r(Ce,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-k94fih"&&(kt.innerHTML=Ia),Io=d(Ce),z=r(Ce,"DIV",{class:!0});var xe=u(z);v(nt.$$.fragment,xe),Zo=d(xe),Bt=r(xe,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-165bl1y"&&(Bt.innerHTML=Za),Uo=d(xe),v(fe.$$.fragment,xe),Wo=d(xe),v(ue.$$.fragment,xe),xe.forEach(t),Ce.forEach(t),Xs=d(e),O=r(e,"H2",{class:!0});var eo=u(O);ge=r(eo,"A",{id:!0,class:!0,href:!0});var sn=u(ge);is=r(sn,"SPAN",{});var on=u(is);v(rt.$$.fragment,on),on.forEach(t),sn.forEach(t),ko=d(eo),zt=r(eo,"SPAN",{"data-svelte-h":!0}),h(zt)!=="svelte-vys02w"&&(zt.textContent=Ua),eo.forEach(t),As=d(e),C=r(e,"DIV",{class:!0});var j=u(C);v(lt.$$.fragment,j),Bo=d(j),Vt=r(j,"P",{"data-svelte-h":!0}),h(Vt)!=="svelte-1eswup9"&&(Vt.textContent=Wa),zo=d(j),Pt=r(j,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-1gfofcr"&&(Pt.innerHTML=ka),Vo=d(j),Gt=r(j,"P",{"data-svelte-h":!0}),h(Gt)!=="svelte-9ybkh"&&(Gt.innerHTML=Ba),Po=d(j),Ht=r(j,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-1pplc4a"&&(Ht.textContent=za),Go=d(j),Et=r(j,"UL",{"data-svelte-h":!0}),h(Et)!=="svelte-1w7z84m"&&(Et.innerHTML=Va),Ho=d(j),V=r(j,"DIV",{class:!0});var je=u(V);v(it.$$.fragment,je),Eo=d(je),Xt=r(je,"P",{"data-svelte-h":!0}),h(Xt)!=="svelte-1cjaw40"&&(Xt.innerHTML=Pa),Xo=d(je),v(_e.$$.fragment,je),Ao=d(je),v(ve.$$.fragment,je),je.forEach(t),j.forEach(t),Ls=d(e),K=r(e,"H2",{class:!0});var to=u(K);be=r(to,"A",{id:!0,class:!0,href:!0});var an=u(be);ds=r(an,"SPAN",{});var nn=u(ds);v(dt.$$.fragment,nn),nn.forEach(t),an.forEach(t),Lo=d(to),At=r(to,"SPAN",{"data-svelte-h":!0}),h(At)!=="svelte-1j4eh37"&&(At.textContent=Ga),to.forEach(t),Qs=d(e),x=r(e,"DIV",{class:!0});var R=u(x);v(ct.$$.fragment,R),Qo=d(R),Lt=r(R,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-d6857j"&&(Lt.textContent=Ha),Yo=d(R),Qt=r(R,"P",{"data-svelte-h":!0}),h(Qt)!=="svelte-1gfofcr"&&(Qt.innerHTML=Ea),So=d(R),Yt=r(R,"P",{"data-svelte-h":!0}),h(Yt)!=="svelte-9ybkh"&&(Yt.innerHTML=Xa),qo=d(R),St=r(R,"P",{"data-svelte-h":!0}),h(St)!=="svelte-1pplc4a"&&(St.textContent=Aa),Do=d(R),qt=r(R,"UL",{"data-svelte-h":!0}),h(qt)!=="svelte-1w7z84m"&&(qt.innerHTML=La),Oo=d(R),P=r(R,"DIV",{class:!0});var Re=u(P);v(pt.$$.fragment,Re),Ko=d(Re),Dt=r(Re,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-1cjaw40"&&(Dt.innerHTML=Qa),ea=d(Re),v(ye.$$.fragment,Re),ta=d(Re),v(we.$$.fragment,Re),Re.forEach(t),R.forEach(t),Ys=d(e),cs=r(e,"P",{}),u(cs).forEach(t),this.h()},h(){f(o,"name","hf:doc:metadata"),f(o,"content",JSON.stringify(jn)),f(a,"id","resnet"),f(a,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(a,"href","#resnet"),f(g,"class","relative group"),f(ee,"id","overview"),f(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(ee,"href","#overview"),f(A,"class","relative group"),f(Ve,"width","600"),ln(Ve.src,pa="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/resnet_architecture.png")||f(Ve,"src",pa),f(te,"id","resources"),f(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(te,"href","#resources"),f(L,"class","relative group"),f(se,"id","transformers.ResNetConfig"),f(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(se,"href","#transformers.ResNetConfig"),f(Q,"class","relative group"),f(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ae,"id","transformers.ResNetModel"),f(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(ae,"href","#transformers.ResNetModel"),f(Y,"class","relative group"),f(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(le,"id","transformers.ResNetForImageClassification"),f(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(le,"href","#transformers.ResNetForImageClassification"),f(S,"class","relative group"),f(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ce,"id","transformers.TFResNetModel"),f(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(ce,"href","#transformers.TFResNetModel"),f(q,"class","relative group"),f(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(he,"id","transformers.TFResNetForImageClassification"),f(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(he,"href","#transformers.TFResNetForImageClassification"),f(D,"class","relative group"),f(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ge,"id","transformers.FlaxResNetModel"),f(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(ge,"href","#transformers.FlaxResNetModel"),f(O,"class","relative group"),f(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(be,"id","transformers.FlaxResNetForImageClassification"),f(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(be,"href","#transformers.FlaxResNetForImageClassification"),f(K,"class","relative group"),f(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){s(document.head,o),c(e,T,l),c(e,p,l),c(e,m,l),c(e,g,l),s(g,a),s(a,$),b(Fe,$,null),s(g,so),s(g,vt),c(e,bs,l),c(e,A,l),s(A,ee),s(ee,ts),b(Je,ts,null),s(A,oo),s(A,bt),c(e,ys,l),c(e,Ie,l),c(e,ws,l),c(e,Ze,l),c(e,Ms,l),c(e,Ue,l),c(e,Ts,l),c(e,We,l),c(e,$s,l),c(e,ke,l),c(e,Ns,l),c(e,Be,l),c(e,Cs,l),c(e,ze,l),c(e,xs,l),c(e,Ve,l),c(e,js,l),c(e,Pe,l),c(e,Rs,l),c(e,L,l),s(L,te),s(te,ss),b(Ge,ss,null),s(L,ao),s(L,yt),c(e,Fs,l),c(e,He,l),c(e,Js,l),b(Ee,e,l),c(e,Is,l),c(e,Xe,l),c(e,Zs,l),c(e,Ae,l),c(e,Us,l),c(e,Q,l),s(Q,se),s(se,os),b(Le,os,null),s(Q,no),s(Q,wt),c(e,Ws,l),c(e,F,l),b(Qe,F,null),s(F,ro),s(F,Mt),s(F,lo),s(F,Tt),s(F,io),b(oe,F,null),c(e,ks,l),c(e,Y,l),s(Y,ae),s(ae,as),b(Ye,as,null),s(Y,co),s(Y,$t),c(e,Bs,l),c(e,G,l),b(Se,G,null),s(G,po),s(G,Nt),s(G,mo),s(G,W),b(qe,W,null),s(W,ho),s(W,Ct),s(W,fo),b(ne,W,null),s(W,uo),b(re,W,null),c(e,zs,l),c(e,S,l),s(S,le),s(le,ns),b(De,ns,null),s(S,go),s(S,xt),c(e,Vs,l),c(e,J,l),b(Oe,J,null),s(J,_o),s(J,jt),s(J,vo),s(J,Rt),s(J,bo),s(J,k),b(Ke,k,null),s(k,yo),s(k,Ft),s(k,wo),b(ie,k,null),s(k,Mo),b(de,k,null),c(e,Ps,l),c(e,q,l),s(q,ce),s(ce,rs),b(et,rs,null),s(q,To),s(q,Jt),c(e,Gs,l),c(e,H,l),b(tt,H,null),s(H,$o),s(H,It),s(H,No),s(H,B),b(st,B,null),s(B,Co),s(B,Zt),s(B,xo),b(pe,B,null),s(B,jo),b(me,B,null),c(e,Hs,l),c(e,D,l),s(D,he),s(he,ls),b(ot,ls,null),s(D,Ro),s(D,Ut),c(e,Es,l),c(e,I,l),b(at,I,null),s(I,Fo),s(I,Wt),s(I,Jo),s(I,kt),s(I,Io),s(I,z),b(nt,z,null),s(z,Zo),s(z,Bt),s(z,Uo),b(fe,z,null),s(z,Wo),b(ue,z,null),c(e,Xs,l),c(e,O,l),s(O,ge),s(ge,is),b(rt,is,null),s(O,ko),s(O,zt),c(e,As,l),c(e,C,l),b(lt,C,null),s(C,Bo),s(C,Vt),s(C,zo),s(C,Pt),s(C,Vo),s(C,Gt),s(C,Po),s(C,Ht),s(C,Go),s(C,Et),s(C,Ho),s(C,V),b(it,V,null),s(V,Eo),s(V,Xt),s(V,Xo),b(_e,V,null),s(V,Ao),b(ve,V,null),c(e,Ls,l),c(e,K,l),s(K,be),s(be,ds),b(dt,ds,null),s(K,Lo),s(K,At),c(e,Qs,l),c(e,x,l),b(ct,x,null),s(x,Qo),s(x,Lt),s(x,Yo),s(x,Qt),s(x,So),s(x,Yt),s(x,qo),s(x,St),s(x,Do),s(x,qt),s(x,Oo),s(x,P),b(pt,P,null),s(P,Ko),s(P,Dt),s(P,ea),b(ye,P,null),s(P,ta),b(we,P,null),c(e,Ys,l),c(e,cs,l),Ss=!0},p(e,[l]){const mt={};l&2&&(mt.$$scope={dirty:l,ctx:e}),oe.$set(mt);const ps={};l&2&&(ps.$$scope={dirty:l,ctx:e}),ne.$set(ps);const ms={};l&2&&(ms.$$scope={dirty:l,ctx:e}),re.$set(ms);const ht={};l&2&&(ht.$$scope={dirty:l,ctx:e}),ie.$set(ht);const hs={};l&2&&(hs.$$scope={dirty:l,ctx:e}),de.$set(hs);const fs={};l&2&&(fs.$$scope={dirty:l,ctx:e}),pe.$set(fs);const ft={};l&2&&(ft.$$scope={dirty:l,ctx:e}),me.$set(ft);const us={};l&2&&(us.$$scope={dirty:l,ctx:e}),fe.$set(us);const gs={};l&2&&(gs.$$scope={dirty:l,ctx:e}),ue.$set(gs);const ut={};l&2&&(ut.$$scope={dirty:l,ctx:e}),_e.$set(ut);const _s={};l&2&&(_s.$$scope={dirty:l,ctx:e}),ve.$set(_s);const vs={};l&2&&(vs.$$scope={dirty:l,ctx:e}),ye.$set(vs);const E={};l&2&&(E.$$scope={dirty:l,ctx:e}),we.$set(E)},i(e){Ss||(y(Fe.$$.fragment,e),y(Je.$$.fragment,e),y(Ge.$$.fragment,e),y(Ee.$$.fragment,e),y(Le.$$.fragment,e),y(Qe.$$.fragment,e),y(oe.$$.fragment,e),y(Ye.$$.fragment,e),y(Se.$$.fragment,e),y(qe.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(De.$$.fragment,e),y(Oe.$$.fragment,e),y(Ke.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(st.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(ot.$$.fragment,e),y(at.$$.fragment,e),y(nt.$$.fragment,e),y(fe.$$.fragment,e),y(ue.$$.fragment,e),y(rt.$$.fragment,e),y(lt.$$.fragment,e),y(it.$$.fragment,e),y(_e.$$.fragment,e),y(ve.$$.fragment,e),y(dt.$$.fragment,e),y(ct.$$.fragment,e),y(pt.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),Ss=!0)},o(e){w(Fe.$$.fragment,e),w(Je.$$.fragment,e),w(Ge.$$.fragment,e),w(Ee.$$.fragment,e),w(Le.$$.fragment,e),w(Qe.$$.fragment,e),w(oe.$$.fragment,e),w(Ye.$$.fragment,e),w(Se.$$.fragment,e),w(qe.$$.fragment,e),w(ne.$$.fragment,e),w(re.$$.fragment,e),w(De.$$.fragment,e),w(Oe.$$.fragment,e),w(Ke.$$.fragment,e),w(ie.$$.fragment,e),w(de.$$.fragment,e),w(et.$$.fragment,e),w(tt.$$.fragment,e),w(st.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(ot.$$.fragment,e),w(at.$$.fragment,e),w(nt.$$.fragment,e),w(fe.$$.fragment,e),w(ue.$$.fragment,e),w(rt.$$.fragment,e),w(lt.$$.fragment,e),w(it.$$.fragment,e),w(_e.$$.fragment,e),w(ve.$$.fragment,e),w(dt.$$.fragment,e),w(ct.$$.fragment,e),w(pt.$$.fragment,e),w(ye.$$.fragment,e),w(we.$$.fragment,e),Ss=!1},d(e){e&&(t(T),t(p),t(m),t(g),t(bs),t(A),t(ys),t(Ie),t(ws),t(Ze),t(Ms),t(Ue),t(Ts),t(We),t($s),t(ke),t(Ns),t(Be),t(Cs),t(ze),t(xs),t(Ve),t(js),t(Pe),t(Rs),t(L),t(Fs),t(He),t(Js),t(Is),t(Xe),t(Zs),t(Ae),t(Us),t(Q),t(Ws),t(F),t(ks),t(Y),t(Bs),t(G),t(zs),t(S),t(Vs),t(J),t(Ps),t(q),t(Gs),t(H),t(Hs),t(D),t(Es),t(I),t(Xs),t(O),t(As),t(C),t(Ls),t(K),t(Qs),t(x),t(Ys),t(cs)),t(o),M(Fe),M(Je),M(Ge),M(Ee,e),M(Le),M(Qe),M(oe),M(Ye),M(Se),M(qe),M(ne),M(re),M(De),M(Oe),M(Ke),M(ie),M(de),M(et),M(tt),M(st),M(pe),M(me),M(ot),M(at),M(nt),M(fe),M(ue),M(rt),M(lt),M(it),M(_e),M(ve),M(dt),M(ct),M(pt),M(ye),M(we)}}}const jn={local:"resnet",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.ResNetConfig",title:"ResNetConfig"},{local:"transformers.ResNetModel",title:"ResNetModel"},{local:"transformers.ResNetForImageClassification",title:"ResNetForImageClassification"},{local:"transformers.TFResNetModel",title:"TFResNetModel"},{local:"transformers.TFResNetForImageClassification",title:"TFResNetForImageClassification"},{local:"transformers.FlaxResNetModel",title:"FlaxResNetModel"},{local:"transformers.FlaxResNetForImageClassification",title:"FlaxResNetForImageClassification"}],title:"ResNet"};function Rn(N){return dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zn extends cn{constructor(o){super(),pn(this,o,Rn,xn,rn,{})}}export{zn as component};
