import{s as hb,o as ub,n as C}from"../chunks/scheduler.9bc65507.js";import{S as fb,i as gb,g as a,s as l,u as f,A as _b,h as r,f as s,c as i,j as $,v as g,y as h,k as v,o as n,a as p,w as _,d as b,t as T,x as y}from"../chunks/index.78c82d43.js";import{T as N}from"../chunks/Tip.87d55b76.js";import{D as J}from"../chunks/Docstring.f3d04bd2.js";import{C as q}from"../chunks/CodeBlock.48618ec2.js";import{I as L}from"../chunks/IconCopyLink.bedaa44d.js";import{E as I}from"../chunks/ExampleCodeBlock.872b014d.js";function bb(x){let t,u="Examples:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFsYmVydENvbmZpZyUyQyUyMEFsYmVydE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYW4lMjBBTEJFUlQteHhsYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWFsYmVydF94eGxhcmdlX2NvbmZpZ3VyYXRpb24lMjAlM0QlMjBBbGJlcnRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGFuJTIwQUxCRVJULWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFhbGJlcnRfYmFzZV9jb25maWd1cmF0aW9uJTIwJTNEJTIwQWxiZXJ0Q29uZmlnKCUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zaXplJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2F0dGVudGlvbl9oZWFkcyUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwaW50ZXJtZWRpYXRlX3NpemUlM0QzMDcyJTJDJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwQUxCRVJULWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEFsYmVydE1vZGVsKGFsYmVydF94eGxhcmdlX2NvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AlbertConfig, AlbertModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing an ALBERT-xxlarge style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>albert_xxlarge_configuration = AlbertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing an ALBERT-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>albert_base_configuration = AlbertConfig(
<span class="hljs-meta">... </span>    hidden_size=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_attention_heads=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    intermediate_size=<span class="hljs-number">3072</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the ALBERT-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertModel(albert_xxlarge_configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Tb(x){let t,u="sequence pair mask has the following format:",d,c,w;return c=new q({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-16klr56"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function yb(x){let t,u="sequence pair mask has the following format:",d,c,w;return c=new q({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-16klr56"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function vb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Mb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBbGJlcnRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBbGJlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertModel.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function kb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function wb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBbGJlcnRGb3JQcmVUcmFpbmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBbGJlcnRGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKHRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKS51bnNxdWVlemUoMCklMEElMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyklMEElMEFwcmVkaWN0aW9uX2xvZ2l0cyUyMCUzRCUyMG91dHB1dHMucHJlZGljdGlvbl9sb2dpdHMlMEFzb3BfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5zb3BfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForPreTraining.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor(tokenizer.encode(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, add_special_tokens=<span class="hljs-literal">True</span>)).unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_logits = outputs.prediction_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>sop_logits = outputs.sop_logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function $b(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function xb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEFsYmVydEZvck1hc2tlZExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBbGJlcnRGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBJTIzJTIwYWRkJTIwbWFza190b2tlbiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjAlNUJNQVNLJTVEJTIwaXMlMjBQYXJpcy4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwcmV0cmlldmUlMjBpbmRleCUyMG9mJTIwJTVCTUFTSyU1RCUwQW1hc2tfdG9rZW5faW5kZXglMjAlM0QlMjAoaW5wdXRzLmlucHV0X2lkcyUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkKSU1QjAlNUQubm9uemVybyhhc190dXBsZSUzRFRydWUpJTVCMCU1RCUwQXByZWRpY3RlZF90b2tlbl9pZCUyMCUzRCUyMGxvZ2l0cyU1QjAlMkMlMjBtYXNrX3Rva2VuX2luZGV4JTVELmFyZ21heChheGlzJTNELTEpJTBBdG9rZW5pemVyLmRlY29kZShwcmVkaWN0ZWRfdG9rZW5faWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForMaskedLM.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add mask_token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of [MASK] is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of [MASK]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = (inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>].nonzero(as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = logits[<span class="hljs-number">0</span>, mask_token_index].argmax(axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predicted_token_id)
<span class="hljs-string">&#x27;france&#x27;</span>`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Fb(x){let t,u;return t=new q({props:{code:"bGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC53aGVyZShpbnB1dHMuaW5wdXRfaWRzJTIwJTNEJTNEJTIwdG9rZW5pemVyLm1hc2tfdG9rZW5faWQlMkMlMjBsYWJlbHMlMkMlMjAtMTAwKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscyklMEFyb3VuZChvdXRwdXRzLmxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.where(inputs.input_ids == tokenizer.mask_token_id, labels, -<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(outputs.loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.81</span>`}}),{c(){f(t.$$.fragment)},l(d){g(t.$$.fragment,d)},m(d,c){_(t,d,c),u=!0},p:C,i(d){u||(b(t.$$.fragment,d),u=!0)},o(d){T(t.$$.fragment,d),u=!1},d(d){y(t,d)}}}function jb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Ab(x){let t,u="Example of single-label classification:",d,c,w;return c=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEFsYmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0ZXh0YXR0YWNrJTJGYWxiZXJ0LWJhc2UtdjItaW1kYiUyMiklMEFtb2RlbCUyMCUzRCUyMEFsYmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnRleHRhdHRhY2slMkZhbGJlcnQtYmFzZS12Mi1pbWRiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEFtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBBbGJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ0ZXh0YXR0YWNrJTJGYWxiZXJ0LWJhc2UtdjItaW1kYiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;textattack/albert-base-v2-imdb&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;textattack/albert-base-v2-imdb&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
<span class="hljs-string">&#x27;LABEL_1&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;textattack/albert-base-v2-imdb&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.12</span>`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-ykxpe4"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Cb(x){let t,u="Example of multi-label classification:",d,c,w;return c=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEFsYmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0ZXh0YXR0YWNrJTJGYWxiZXJ0LWJhc2UtdjItaW1kYiUyMiklMEFtb2RlbCUyMCUzRCUyMEFsYmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnRleHRhdHRhY2slMkZhbGJlcnQtYmFzZS12Mi1pbWRiJTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBBbGJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ0ZXh0YXR0YWNrJTJGYWxiZXJ0LWJhc2UtdjItaW1kYiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;textattack/albert-base-v2-imdb&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;textattack/albert-base-v2-imdb&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;textattack/albert-base-v2-imdb&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1l8e32d"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Jb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function zb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBbGJlcnRGb3JNdWx0aXBsZUNob2ljZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBbGJlcnRGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySW4lMjBJdGFseSUyQyUyMHBpenphJTIwc2VydmVkJTIwaW4lMjBmb3JtYWwlMjBzZXR0aW5ncyUyQyUyMHN1Y2glMjBhcyUyMGF0JTIwYSUyMHJlc3RhdXJhbnQlMkMlMjBpcyUyMHByZXNlbnRlZCUyMHVuc2xpY2VkLiUyMiUwQWNob2ljZTAlMjAlM0QlMjAlMjJJdCUyMGlzJTIwZWF0ZW4lMjB3aXRoJTIwYSUyMGZvcmslMjBhbmQlMjBhJTIwa25pZmUuJTIyJTBBY2hvaWNlMSUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdoaWxlJTIwaGVsZCUyMGluJTIwdGhlJTIwaGFuZC4lMjIlMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoMCkudW5zcXVlZXplKDApJTIwJTIwJTIzJTIwY2hvaWNlMCUyMGlzJTIwY29ycmVjdCUyMChhY2NvcmRpbmclMjB0byUyMFdpa2lwZWRpYSUyMCUzQikpJTJDJTIwYmF0Y2glMjBzaXplJTIwMSUwQSUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKCU1QnByb21wdCUyQyUyMHByb21wdCU1RCUyQyUyMCU1QmNob2ljZTAlMkMlMjBjaG9pY2UxJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKiU3QmslM0ElMjB2LnVuc3F1ZWV6ZSgwKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBlbmNvZGluZy5pdGVtcygpJTdEJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUyMCUyMCUyMyUyMGJhdGNoJTIwc2l6ZSUyMGlzJTIwMSUwQSUwQSUyMyUyMHRoZSUyMGxpbmVhciUyMGNsYXNzaWZpZXIlMjBzdGlsbCUyMG5lZWRzJTIwdG8lMjBiZSUyMHRyYWluZWQlMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Ub(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Ib(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBbGJlcnRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMEFsYmVydEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForTokenClassification.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function qb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Wb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBbGJlcnRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydHdta245JTJGYWxiZXJ0LWJhc2UtdjItc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQWxiZXJ0Rm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnR3bWtuOSUyRmFsYmVydC1iYXNlLXYyLXNxdWFkMiUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQXRva2VuaXplci5kZWNvZGUocHJlZGljdF9hbnN3ZXJfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIzJTIwdGFyZ2V0JTIwaXMlMjAlMjJuaWNlJTIwcHVwcGV0JTIyJTBBdGFyZ2V0X3N0YXJ0X2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjEyJTVEKSUwQXRhcmdldF9lbmRfaW5kZXglMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMTMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEdGFyZ2V0X3N0YXJ0X2luZGV4JTJDJTIwZW5kX3Bvc2l0aW9ucyUzRHRhcmdldF9lbmRfaW5kZXgpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AlbertForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;twmkn9/albert-base-v2-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AlbertForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;twmkn9/albert-base-v2-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predict_answer_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;a nice puppet&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">12</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">13</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">7.36</span>`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Nb(x){let t,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",d,c,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,A,Z=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,z,j,H=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=a("p"),t.innerHTML=u,d=l(),c=a("ul"),c.innerHTML=w,o=l(),M=a("p"),M.innerHTML=W,U=l(),A=a("ul"),A.innerHTML=Z,z=l(),j=a("p"),j.innerHTML=H},l(k){t=r(k,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ajbfxg"&&(t.innerHTML=u),d=i(k),c=r(k,"UL",{"data-svelte-h":!0}),h(c)!=="svelte-qm1t26"&&(c.innerHTML=w),o=i(k),M=r(k,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=W),U=i(k),A=r(k,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-15scerc"&&(A.innerHTML=Z),z=i(k),j=r(k,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1an3odd"&&(j.innerHTML=H)},m(k,F){p(k,t,F),p(k,d,F),p(k,c,F),p(k,o,F),p(k,M,F),p(k,U,F),p(k,A,F),p(k,z,F),p(k,j,F)},p:C,d(k){k&&(s(t),s(d),s(c),s(o),s(M),s(U),s(A),s(z),s(j))}}}function Lb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Zb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkFsYmVydE1vZGVsJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQWxiZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAlbertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertModel.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Hb(x){let t,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",d,c,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,A,Z=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,z,j,H=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=a("p"),t.innerHTML=u,d=l(),c=a("ul"),c.innerHTML=w,o=l(),M=a("p"),M.innerHTML=W,U=l(),A=a("ul"),A.innerHTML=Z,z=l(),j=a("p"),j.innerHTML=H},l(k){t=r(k,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ajbfxg"&&(t.innerHTML=u),d=i(k),c=r(k,"UL",{"data-svelte-h":!0}),h(c)!=="svelte-qm1t26"&&(c.innerHTML=w),o=i(k),M=r(k,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=W),U=i(k),A=r(k,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-15scerc"&&(A.innerHTML=Z),z=i(k),j=r(k,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1an3odd"&&(j.innerHTML=H)},m(k,F){p(k,t,F),p(k,d,F),p(k,c,F),p(k,o,F),p(k,M,F),p(k,U,F),p(k,A,F),p(k,z,F),p(k,j,F)},p:C,d(k){k&&(s(t),s(d),s(c),s(o),s(M),s(U),s(A),s(z),s(j))}}}function Bb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Pb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQWxiZXJ0Rm9yUHJlVHJhaW5pbmclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQWxiZXJ0Rm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQSUwQWlucHV0X2lkcyUyMCUzRCUyMHRmLmNvbnN0YW50KHRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSU1Qk5vbmUlMkMlMjAlM0ElNUQlMEElMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyklMEElMEFwcmVkaWN0aW9uX2xvZ2l0cyUyMCUzRCUyMG91dHB1dHMucHJlZGljdGlvbl9sb2dpdHMlMEFzb3BfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5zb3BfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAlbertForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertForPreTraining.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tf.constant(tokenizer.encode(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, add_special_tokens=<span class="hljs-literal">True</span>))[<span class="hljs-literal">None</span>, :]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_logits = outputs.prediction_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>sop_logits = outputs.sop_logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Gb(x){let t,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",d,c,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,A,Z=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,z,j,H=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=a("p"),t.innerHTML=u,d=l(),c=a("ul"),c.innerHTML=w,o=l(),M=a("p"),M.innerHTML=W,U=l(),A=a("ul"),A.innerHTML=Z,z=l(),j=a("p"),j.innerHTML=H},l(k){t=r(k,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ajbfxg"&&(t.innerHTML=u),d=i(k),c=r(k,"UL",{"data-svelte-h":!0}),h(c)!=="svelte-qm1t26"&&(c.innerHTML=w),o=i(k),M=r(k,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=W),U=i(k),A=r(k,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-15scerc"&&(A.innerHTML=Z),z=i(k),j=r(k,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1an3odd"&&(j.innerHTML=H)},m(k,F){p(k,t,F),p(k,d,F),p(k,c,F),p(k,o,F),p(k,M,F),p(k,U,F),p(k,A,F),p(k,z,F),p(k,j,F)},p:C,d(k){k&&(s(t),s(d),s(c),s(o),s(M),s(U),s(A),s(z),s(j))}}}function Rb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Vb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQWxiZXJ0Rm9yTWFza2VkTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQWxiZXJ0Rm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQSUwQSUyMyUyMGFkZCUyMG1hc2tfdG9rZW4lMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZiUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMCU1Qk1BU0slNUQlMjBpcyUyMFBhcmlzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMHJldHJpZXZlJTIwaW5kZXglMjBvZiUyMCU1Qk1BU0slNUQlMEFtYXNrX3Rva2VuX2luZGV4JTIwJTNEJTIwdGYud2hlcmUoaW5wdXRzLmlucHV0X2lkcyUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkKSU1QjAlNUQlNUIxJTVEJTBBcHJlZGljdGVkX3Rva2VuX2lkJTIwJTNEJTIwdGYubWF0aC5hcmdtYXgobG9naXRzJTVCMCUyQyUyMG1hc2tfdG9rZW5faW5kZXglNUQlMkMlMjBheGlzJTNELTEpJTBBdG9rZW5pemVyLmRlY29kZShwcmVkaWN0ZWRfdG9rZW5faWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAlbertForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertForMaskedLM.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add mask_token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">f&quot;The capital of [MASK] is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of [MASK]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = tf.where(inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = tf.math.argmax(logits[<span class="hljs-number">0</span>, mask_token_index], axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predicted_token_id)
<span class="hljs-string">&#x27;france&#x27;</span>`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Xb(x){let t,u;return t=new q({props:{code:"bGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEFsYWJlbHMlMjAlM0QlMjB0Zi53aGVyZShpbnB1dHMuaW5wdXRfaWRzJTIwJTNEJTNEJTIwdG9rZW5pemVyLm1hc2tfdG9rZW5faWQlMkMlMjBsYWJlbHMlMkMlMjAtMTAwKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscyklMEFyb3VuZChmbG9hdChvdXRwdXRzLmxvc3MpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.where(inputs.input_ids == tokenizer.mask_token_id, labels, -<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(outputs.loss), <span class="hljs-number">2</span>)
<span class="hljs-number">0.81</span>`}}),{c(){f(t.$$.fragment)},l(d){g(t.$$.fragment,d)},m(d,c){_(t,d,c),u=!0},p:C,i(d){u||(b(t.$$.fragment,d),u=!0)},o(d){T(t.$$.fragment,d),u=!1},d(d){y(t,d)}}}function Eb(x){let t,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",d,c,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,A,Z=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,z,j,H=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=a("p"),t.innerHTML=u,d=l(),c=a("ul"),c.innerHTML=w,o=l(),M=a("p"),M.innerHTML=W,U=l(),A=a("ul"),A.innerHTML=Z,z=l(),j=a("p"),j.innerHTML=H},l(k){t=r(k,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ajbfxg"&&(t.innerHTML=u),d=i(k),c=r(k,"UL",{"data-svelte-h":!0}),h(c)!=="svelte-qm1t26"&&(c.innerHTML=w),o=i(k),M=r(k,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=W),U=i(k),A=r(k,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-15scerc"&&(A.innerHTML=Z),z=i(k),j=r(k,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1an3odd"&&(j.innerHTML=H)},m(k,F){p(k,t,F),p(k,d,F),p(k,c,F),p(k,o,F),p(k,M,F),p(k,U,F),p(k,A,F),p(k,z,F),p(k,j,F)},p:C,d(k){k&&(s(t),s(d),s(c),s(o),s(M),s(U),s(A),s(z),s(j))}}}function Sb(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Qb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkFsYmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnZ1bWljaGllbiUyRmFsYmVydC1iYXNlLXYyLWltZGIlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkFsYmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnZ1bWljaGllbiUyRmFsYmVydC1iYXNlLXYyLWltZGIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSU1QjAlNUQpJTBBbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAlbertForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;vumichien/albert-base-v2-imdb&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;vumichien/albert-base-v2-imdb&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
<span class="hljs-string">&#x27;LABEL_1&#x27;</span>`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function Yb(x){let t,u;return t=new q({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwVEZBbGJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ2dW1pY2hpZW4lMkZhbGJlcnQtYmFzZS12Mi1pbWRiJTIyJTJDJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdGYuY29uc3RhbnQoMSklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFyb3VuZChmbG9hdChsb3NzKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;vumichien/albert-base-v2-imdb&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.constant(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(loss), <span class="hljs-number">2</span>)
<span class="hljs-number">0.12</span>`}}),{c(){f(t.$$.fragment)},l(d){g(t.$$.fragment,d)},m(d,c){_(t,d,c),u=!0},p:C,i(d){u||(b(t.$$.fragment,d),u=!0)},o(d){T(t.$$.fragment,d),u=!1},d(d){y(t,d)}}}function Db(x){let t,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",d,c,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,A,Z=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,z,j,H=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=a("p"),t.innerHTML=u,d=l(),c=a("ul"),c.innerHTML=w,o=l(),M=a("p"),M.innerHTML=W,U=l(),A=a("ul"),A.innerHTML=Z,z=l(),j=a("p"),j.innerHTML=H},l(k){t=r(k,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ajbfxg"&&(t.innerHTML=u),d=i(k),c=r(k,"UL",{"data-svelte-h":!0}),h(c)!=="svelte-qm1t26"&&(c.innerHTML=w),o=i(k),M=r(k,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=W),U=i(k),A=r(k,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-15scerc"&&(A.innerHTML=Z),z=i(k),j=r(k,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1an3odd"&&(j.innerHTML=H)},m(k,F){p(k,t,F),p(k,d,F),p(k,c,F),p(k,o,F),p(k,M,F),p(k,U,F),p(k,A,F),p(k,z,F),p(k,j,F)},p:C,d(k){k&&(s(t),s(d),s(c),s(o),s(M),s(U),s(A),s(z),s(j))}}}function Ob(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function Kb(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkFsYmVydEZvck11bHRpcGxlQ2hvaWNlJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQWxiZXJ0Rm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkluJTIwSXRhbHklMkMlMjBwaXp6YSUyMHNlcnZlZCUyMGluJTIwZm9ybWFsJTIwc2V0dGluZ3MlMkMlMjBzdWNoJTIwYXMlMjBhdCUyMGElMjByZXN0YXVyYW50JTJDJTIwaXMlMjBwcmVzZW50ZWQlMjB1bnNsaWNlZC4lMjIlMEFjaG9pY2UwJTIwJTNEJTIwJTIySXQlMjBpcyUyMGVhdGVuJTIwd2l0aCUyMGElMjBmb3JrJTIwYW5kJTIwYSUyMGtuaWZlLiUyMiUwQWNob2ljZTElMjAlM0QlMjAlMjJJdCUyMGlzJTIwZWF0ZW4lMjB3aGlsZSUyMGhlbGQlMjBpbiUyMHRoZSUyMGhhbmQuJTIyJTBBJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoJTVCcHJvbXB0JTJDJTIwcHJvbXB0JTVEJTJDJTIwJTVCY2hvaWNlMCUyQyUyMGNob2ljZTElNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHRmLmV4cGFuZF9kaW1zKHYlMkMlMjAwKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBlbmNvZGluZy5pdGVtcygpJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBpcyUyMDElMEElMEElMjMlMjB0aGUlMjBsaW5lYXIlMjBjbGFzc2lmaWVyJTIwc3RpbGwlMjBuZWVkcyUyMHRvJTIwYmUlMjB0cmFpbmVkJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAlbertForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {k: tf.expand_dims(v, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function eT(x){let t,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",d,c,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,A,Z=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,z,j,H=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=a("p"),t.innerHTML=u,d=l(),c=a("ul"),c.innerHTML=w,o=l(),M=a("p"),M.innerHTML=W,U=l(),A=a("ul"),A.innerHTML=Z,z=l(),j=a("p"),j.innerHTML=H},l(k){t=r(k,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ajbfxg"&&(t.innerHTML=u),d=i(k),c=r(k,"UL",{"data-svelte-h":!0}),h(c)!=="svelte-qm1t26"&&(c.innerHTML=w),o=i(k),M=r(k,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=W),U=i(k),A=r(k,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-15scerc"&&(A.innerHTML=Z),z=i(k),j=r(k,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1an3odd"&&(j.innerHTML=H)},m(k,F){p(k,t,F),p(k,d,F),p(k,c,F),p(k,o,F),p(k,M,F),p(k,U,F),p(k,A,F),p(k,z,F),p(k,j,F)},p:C,d(k){k&&(s(t),s(d),s(c),s(o),s(M),s(U),s(A),s(z),s(j))}}}function tT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function nT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkFsYmVydEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBbGJlcnRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2UlMjBpcyUyMGElMjBjb21wYW55JTIwYmFzZWQlMjBpbiUyMFBhcmlzJTIwYW5kJTIwTmV3JTIwWW9yayUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiUwQSklMEElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMHRmLm1hdGguYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdCU1RCUyMGZvciUyMHQlMjBpbiUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlNUIwJTVELm51bXB5KCkudG9saXN0KCklNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAlbertForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertForTokenClassification.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>].numpy().tolist()]`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function oT(x){let t,u;return t=new q({props:{code:"bGFiZWxzJTIwJTNEJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUwQWxvc3MlMjAlM0QlMjB0Zi5tYXRoLnJlZHVjZV9tZWFuKG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3NzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = tf.math.reduce_mean(model(**inputs, labels=labels).loss)`}}),{c(){f(t.$$.fragment)},l(d){g(t.$$.fragment,d)},m(d,c){_(t,d,c),u=!0},p:C,i(d){u||(b(t.$$.fragment,d),u=!0)},o(d){T(t.$$.fragment,d),u=!1},d(d){y(t,d)}}}function sT(x){let t,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",d,c,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,A,Z=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,z,j,H=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=a("p"),t.innerHTML=u,d=l(),c=a("ul"),c.innerHTML=w,o=l(),M=a("p"),M.innerHTML=W,U=l(),A=a("ul"),A.innerHTML=Z,z=l(),j=a("p"),j.innerHTML=H},l(k){t=r(k,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ajbfxg"&&(t.innerHTML=u),d=i(k),c=r(k,"UL",{"data-svelte-h":!0}),h(c)!=="svelte-qm1t26"&&(c.innerHTML=w),o=i(k),M=r(k,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=W),U=i(k),A=r(k,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-15scerc"&&(A.innerHTML=Z),z=i(k),j=r(k,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1an3odd"&&(j.innerHTML=H)},m(k,F){p(k,t,F),p(k,d,F),p(k,c,F),p(k,o,F),p(k,M,F),p(k,U,F),p(k,A,F),p(k,z,F),p(k,j,F)},p:C,d(k){k&&(s(t),s(d),s(c),s(o),s(M),s(U),s(A),s(z),s(j))}}}function aT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function rT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkFsYmVydEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ2dW1pY2hpZW4lMkZhbGJlcnQtYmFzZS12Mi1zcXVhZDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkFsYmVydEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJ2dW1pY2hpZW4lMkZhbGJlcnQtYmFzZS12Mi1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwaW50KHRmLm1hdGguYXJnbWF4KG91dHB1dHMuc3RhcnRfbG9naXRzJTJDJTIwYXhpcyUzRC0xKSU1QjAlNUQpJTBBYW5zd2VyX2VuZF9pbmRleCUyMCUzRCUyMGludCh0Zi5tYXRoLmFyZ21heChvdXRwdXRzLmVuZF9sb2dpdHMlMkMlMjBheGlzJTNELTEpJTVCMCU1RCklMEElMEFwcmVkaWN0X2Fuc3dlcl90b2tlbnMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzJTVCMCUyQyUyMGFuc3dlcl9zdGFydF9pbmRleCUyMCUzQSUyMGFuc3dlcl9lbmRfaW5kZXglMjAlMkIlMjAxJTVEJTBBdG9rZW5pemVyLmRlY29kZShwcmVkaWN0X2Fuc3dlcl90b2tlbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAlbertForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;vumichien/albert-base-v2-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAlbertForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;vumichien/albert-base-v2-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = <span class="hljs-built_in">int</span>(tf.math.argmax(outputs.start_logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = <span class="hljs-built_in">int</span>(tf.math.argmax(outputs.end_logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predict_answer_tokens)
<span class="hljs-string">&#x27;a nice puppet&#x27;</span>`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function lT(x){let t,u;return t=new q({props:{code:"JTIzJTIwdGFyZ2V0JTIwaXMlMjAlMjJuaWNlJTIwcHVwcGV0JTIyJTBBdGFyZ2V0X3N0YXJ0X2luZGV4JTIwJTNEJTIwdGYuY29uc3RhbnQoJTVCMTIlNUQpJTBBdGFyZ2V0X2VuZF9pbmRleCUyMCUzRCUyMHRmLmNvbnN0YW50KCU1QjEzJTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjB0Zi5tYXRoLnJlZHVjZV9tZWFuKG91dHB1dHMubG9zcyklMEFyb3VuZChmbG9hdChsb3NzKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = tf.constant([<span class="hljs-number">12</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = tf.constant([<span class="hljs-number">13</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = tf.math.reduce_mean(outputs.loss)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(loss), <span class="hljs-number">2</span>)
<span class="hljs-number">7.36</span>`}}),{c(){f(t.$$.fragment)},l(d){g(t.$$.fragment,d)},m(d,c){_(t,d,c),u=!0},p:C,i(d){u||(b(t.$$.fragment,d),u=!0)},o(d){T(t.$$.fragment,d),u=!1},d(d){y(t,d)}}}function iT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function dT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4QWxiZXJ0TW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBbGJlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMmpheCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAlbertModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAlbertModel.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function cT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function pT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4QWxiZXJ0Rm9yUHJlVHJhaW5pbmclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBbGJlcnRGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFwcmVkaWN0aW9uX2xvZ2l0cyUyMCUzRCUyMG91dHB1dHMucHJlZGljdGlvbl9sb2dpdHMlMEFzZXFfcmVsYXRpb25zaGlwX2xvZ2l0cyUyMCUzRCUyMG91dHB1dHMuc29wX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAlbertForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAlbertForPreTraining.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_logits = outputs.prediction_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>seq_relationship_logits = outputs.sop_logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function mT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function hT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4QWxiZXJ0Rm9yTWFza2VkTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBbGJlcnRGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMmpheCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAlbertForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAlbertForMaskedLM.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function uT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function fT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4QWxiZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEFsYmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJqYXglMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAlbertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAlbertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function gT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function _T(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4QWxiZXJ0Rm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBbGJlcnRGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySW4lMjBJdGFseSUyQyUyMHBpenphJTIwc2VydmVkJTIwaW4lMjBmb3JtYWwlMjBzZXR0aW5ncyUyQyUyMHN1Y2glMjBhcyUyMGF0JTIwYSUyMHJlc3RhdXJhbnQlMkMlMjBpcyUyMHByZXNlbnRlZCUyMHVuc2xpY2VkLiUyMiUwQWNob2ljZTAlMjAlM0QlMjAlMjJJdCUyMGlzJTIwZWF0ZW4lMjB3aXRoJTIwYSUyMGZvcmslMjBhbmQlMjBhJTIwa25pZmUuJTIyJTBBY2hvaWNlMSUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdoaWxlJTIwaGVsZCUyMGluJTIwdGhlJTIwaGFuZC4lMjIlMEElMEFlbmNvZGluZyUyMCUzRCUyMHRva2VuaXplciglNUJwcm9tcHQlMkMlMjBwcm9tcHQlNUQlMkMlMjAlNUJjaG9pY2UwJTJDJTIwY2hvaWNlMSU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIyamF4JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQSUyMHYlNUJOb25lJTJDJTIwJTNBJTVEJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklN0QpJTBBJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAlbertForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAlbertForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;jax&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v[<span class="hljs-literal">None</span>, :] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()})

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function bT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function TT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4QWxiZXJ0Rm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEFsYmVydEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmFsYmVydC1iYXNlLXYyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJqYXglMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAlbertForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAlbertForTokenClassification.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function yT(x){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=a("p"),t.innerHTML=u},l(d){t=r(d,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(d,c){p(d,t,c)},p:C,d(d){d&&s(t)}}}function vT(x){let t,u="Example:",d,c,w;return c=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4QWxiZXJ0Rm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhbGJlcnQtYmFzZS12MiUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBbGJlcnRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYWxiZXJ0LWJhc2UtdjIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJqYXglMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQXN0YXJ0X3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzJTBBZW5kX3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxAlbertForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAlbertForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;albert-base-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`}}),{c(){t=a("p"),t.textContent=u,d=l(),f(c.$$.fragment)},l(o){t=r(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),d=i(o),g(c.$$.fragment,o)},m(o,M){p(o,t,M),p(o,d,M),_(c,o,M),w=!0},p:C,i(o){w||(b(c.$$.fragment,o),w=!0)},o(o){T(c.$$.fragment,o),w=!1},d(o){o&&(s(t),s(d)),y(c,o)}}}function MT(x){let t,u,d,c,w,o,M,W,U,A,Z="ALBERT",z,j,H='<a href="https://huggingface.co/models?filter=albert"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-albert-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/albert-base-v2"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',k,F,Et,fi,Zo,Nc,qa,Eu="Overview",ud,Ho,Su=`The ALBERT model was proposed in <a href="https://arxiv.org/abs/1909.11942" rel="nofollow">ALBERT: A Lite BERT for Self-supervised Learning of Language Representations</a> by Zhenzhong Lan, Mingda Chen, Sebastian Goodman, Kevin Gimpel, Piyush Sharma,
Radu Soricut. It presents two parameter-reduction techniques to lower memory consumption and increase the training
speed of BERT:`,fd,Bo,Qu="<li>Splitting the embedding matrix into two smaller matrices.</li> <li>Using repeating layers split among groups.</li>",gd,Po,Yu="The abstract from the paper is the following:",_d,Go,Du=`<em>Increasing model size when pretraining natural language representations often results in improved performance on
downstream tasks. However, at some point further model increases become harder due to GPU/TPU memory limitations,
longer training times, and unexpected model degradation. To address these problems, we present two parameter-reduction
techniques to lower memory consumption and increase the training speed of BERT. Comprehensive empirical evidence shows
that our proposed methods lead to models that scale much better compared to the original BERT. We also use a
self-supervised loss that focuses on modeling inter-sentence coherence, and show it consistently helps downstream tasks
with multi-sentence inputs. As a result, our best model establishes new state-of-the-art results on the GLUE, RACE, and
SQuAD benchmarks while having fewer parameters compared to BERT-large.</em>`,bd,Ro,Ou="Tips:",Td,Vo,Ku=`<li>ALBERT is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right rather
than the left.</li> <li>ALBERT uses repeating layers which results in a small memory footprint, however the computational cost remains
similar to a BERT-like architecture with the same number of hidden layers as it has to iterate through the same
number of (repeating) layers.</li> <li>Embedding size E is different from hidden size H justified because the embeddings are context independent (one embedding vector represents one token), whereas hidden states are context dependent (one hidden state represents a sequence of tokens) so it’s more logical to have H &gt;&gt; E. Also, the embedding matrix is large since it’s V x E (V being the vocab size). If E &lt; H, it has less parameters.</li> <li>Layers are split in groups that share parameters (to save memory).
Next sentence prediction is replaced by a sentence ordering prediction: in the inputs, we have two sentences A and B (that are consecutive) and we either feed A followed by B or B followed by A. The model must predict if they have been swapped or not.</li>`,yd,Xo,ef=`This model was contributed by <a href="https://huggingface.co/lysandre" rel="nofollow">lysandre</a>. This model jax version was contributed by
<a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/google-research/ALBERT" rel="nofollow">here</a>.`,vd,_t,St,gi,Eo,Lc,Wa,tf="Documentation resources",Md,So,nf='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li> <li><a href="../tasks/multiple_choice">Multiple choice task guide</a></li>',kd,bt,Qt,_i,Qo,Zc,Na,of="AlbertConfig",wd,ke,Yo,Hc,La,sf=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> or a <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a>. It is used
to instantiate an ALBERT model according to the specified arguments, defining the model architecture. Instantiating
a configuration with the defaults will yield a similar configuration to that of the ALBERT
<a href="https://huggingface.co/albert-xxlarge-v2" rel="nofollow">albert-xxlarge-v2</a> architecture.`,Bc,Za,af=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pc,Yt,$d,Tt,Dt,bi,Do,Gc,Ha,rf="AlbertTokenizer",xd,B,Oo,Rc,Ba,lf='Construct an ALBERT tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',Vc,Pa,df=`This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Xc,dt,Ko,Ec,Ga,cf=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An ALBERT sequence has the following format:`,Sc,Ra,pf="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",Qc,Ot,es,Yc,Va,mf=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Dc,ze,ts,Oc,Xa,hf="Create a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",Kc,Kt,ep,Ea,uf="If <code>token_ids_1</code> is <code>None</code>, this method only returns the first portion of the mask (0s).",tp,Sa,ns,Fd,yt,en,Ti,os,np,Qa,ff="AlbertTokenizerFast",jd,we,ss,op,Ya,gf=`Construct a “fast” ALBERT tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on
<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html?highlight=unigram#models" rel="nofollow">Unigram</a>. This
tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods`,sp,ct,as,ap,Da,_f=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An ALBERT sequence has the following format:`,rp,Oa,bf="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",lp,Ue,rs,ip,Ka,Tf="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",dp,tn,cp,er,yf="if token_ids_1 is None, only returns the first portion of the mask (0s).",Ad,vt,nn,yi,ls,pp,tr,vf="Albert specific outputs",Cd,Mt,is,mp,nr,Mf='Output type of <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a>.',Jd,kt,ds,hp,or,kf='Output type of <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a>.',zd,wt,on,vi,cs,up,sr,wf="AlbertModel",Ud,oe,ps,fp,ar,$f="The bare ALBERT Model transformer outputting raw hidden-states without any specific head on top.",gp,rr,xf=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_p,lr,Ff=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bp,Ie,ms,Tp,ir,jf='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> forward method, overrides the <code>__call__</code> special method.',yp,sn,vp,an,Id,$t,rn,Mi,hs,Mp,dr,Af="AlbertForPreTraining",qd,se,us,kp,cr,Cf=`Albert Model with two heads on top as done during the pretraining: a <code>masked language modeling</code> head and a
<code>sentence order prediction (classification)</code> head.`,wp,pr,Jf=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,$p,mr,zf=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xp,qe,fs,Fp,hr,Uf='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',jp,ln,Ap,dn,Wd,xt,cn,ki,gs,Cp,ur,If="AlbertForMaskedLM",Nd,ae,_s,Jp,fr,qf="Albert Model with a <code>language modeling</code> head on top.",zp,gr,Wf=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Up,_r,Nf=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ip,ce,bs,qp,br,Lf='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Wp,pn,Np,mn,Lp,hn,Ld,Ft,un,wi,Ts,Zp,Tr,Zf="AlbertForSequenceClassification",Zd,re,ys,Hp,yr,Hf=`Albert Model transformer with a sequence classification/regression head on top (a linear layer on top of the pooled
output) e.g. for GLUE tasks.`,Bp,vr,Bf=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pp,Mr,Pf=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gp,pe,vs,Rp,kr,Gf='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertForSequenceClassification">AlbertForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Vp,fn,Xp,gn,Ep,_n,Hd,jt,bn,$i,Ms,Sp,wr,Rf="AlbertForMultipleChoice",Bd,le,ks,Qp,$r,Vf=`Albert Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,Yp,xr,Xf=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Dp,Fr,Ef=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Op,We,ws,Kp,jr,Sf='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertForMultipleChoice">AlbertForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',em,Tn,tm,yn,Pd,At,vn,xi,$s,nm,Ar,Qf="AlbertForTokenClassification",Gd,ie,xs,om,Cr,Yf=`Albert Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,sm,Jr,Df=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,am,zr,Of=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rm,Ne,Fs,lm,Ur,Kf='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertForTokenClassification">AlbertForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',im,Mn,dm,kn,Rd,Ct,wn,Fi,js,cm,Ir,eg="AlbertForQuestionAnswering",Vd,de,As,pm,qr,tg=`Albert Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,mm,Wr,ng=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,hm,Nr,og=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,um,Le,Cs,fm,Lr,sg='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertForQuestionAnswering">AlbertForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',gm,$n,_m,xn,Xd,Jt,Fn,ji,Js,bm,Zr,ag="TFAlbertModel",Ed,Q,zs,Tm,Hr,rg="The bare Albert Model transformer outputting raw hidden-states without any specific head on top.",ym,Br,lg=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vm,Pr,ig=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Mm,jn,km,Ze,Us,wm,Gr,dg='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> forward method, overrides the <code>__call__</code> special method.',$m,An,xm,Cn,Sd,zt,Jn,Ai,Is,Fm,Rr,cg="TFAlbertForPreTraining",Qd,Y,qs,jm,Vr,pg="Albert Model with two heads on top for pretraining: a <code>masked language modeling</code> head and a <code>sentence order prediction</code> (classification) head.",Am,Xr,mg=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Cm,Er,hg=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Jm,zn,zm,He,Ws,Um,Sr,ug='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',Im,Un,qm,In,Yd,Ut,qn,Ci,Ns,Wm,Qr,fg="TFAlbertForMaskedLM",Dd,D,Ls,Nm,Yr,gg="Albert Model with a <code>language modeling</code> head on top.",Lm,Dr,_g=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Zm,Or,bg=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Hm,Wn,Bm,me,Zs,Pm,Kr,Tg='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertForMaskedLM">TFAlbertForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Gm,Nn,Rm,Ln,Vm,Zn,Od,It,Hn,Ji,Hs,Xm,el,yg="TFAlbertForSequenceClassification",Kd,O,Bs,Em,tl,vg=`Albert Model transformer with a sequence classification/regression head on top (a linear layer on top of the pooled
output) e.g. for GLUE tasks.`,Sm,nl,Mg=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qm,ol,kg=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Ym,Bn,Dm,he,Ps,Om,sl,wg='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertForSequenceClassification">TFAlbertForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Km,Pn,eh,Gn,th,Rn,ec,qt,Vn,zi,Gs,nh,al,$g="TFAlbertForMultipleChoice",tc,K,Rs,oh,rl,xg=`Albert Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,sh,ll,Fg=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ah,il,jg=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,rh,Xn,lh,Be,Vs,ih,dl,Ag='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertForMultipleChoice">TFAlbertForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',dh,En,ch,Sn,nc,Wt,Qn,Ui,Xs,ph,cl,Cg="TFAlbertForTokenClassification",oc,ee,Es,mh,pl,Jg=`Albert Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,hh,ml,zg=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,uh,hl,Ug=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,fh,Yn,gh,ue,Ss,_h,ul,Ig='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertForTokenClassification">TFAlbertForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',bh,Dn,Th,On,yh,Kn,sc,Nt,eo,Ii,Qs,vh,fl,qg="TFAlbertForQuestionAnswering",ac,te,Ys,Mh,gl,Wg=`Albert Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layer on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,kh,_l,Ng=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,wh,bl,Lg=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,$h,to,xh,fe,Ds,Fh,Tl,Zg='The <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertForQuestionAnswering">TFAlbertForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',jh,no,Ah,oo,Ch,so,rc,Lt,ao,qi,Os,Jh,yl,Hg="FlaxAlbertModel",lc,P,Ks,zh,vl,Bg="The bare Albert Model transformer outputting raw hidden-states without any specific head on top.",Uh,Ml,Pg=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Ih,kl,Gg=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,qh,wl,Rg="Finally, this model supports inherent JAX features such as:",Wh,$l,Vg='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Nh,Pe,ea,Lh,xl,Xg="The <code>FlaxAlbertPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Zh,ro,Hh,lo,ic,Zt,io,Wi,ta,Bh,Fl,Eg="FlaxAlbertForPreTraining",dc,G,na,Ph,jl,Sg=`Albert Model with two heads on top as done during the pretraining: a <code>masked language modeling</code> head and a
<code>sentence order prediction (classification)</code> head.`,Gh,Al,Qg=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Rh,Cl,Yg=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Vh,Jl,Dg="Finally, this model supports inherent JAX features such as:",Xh,zl,Og='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Eh,Ge,oa,Sh,Ul,Kg="The <code>FlaxAlbertPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Qh,co,Yh,po,cc,Ht,mo,Ni,sa,Dh,Il,e_="FlaxAlbertForMaskedLM",pc,R,aa,Oh,ql,t_="Albert Model with a <code>language modeling</code> head on top.",Kh,Wl,n_=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,eu,Nl,o_=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,tu,Ll,s_="Finally, this model supports inherent JAX features such as:",nu,Zl,a_='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',ou,Re,ra,su,Hl,r_="The <code>FlaxAlbertPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",au,ho,ru,uo,mc,Bt,fo,Li,la,lu,Bl,l_="FlaxAlbertForSequenceClassification",hc,V,ia,iu,Pl,i_=`Albert Model transformer with a sequence classification/regression head on top (a linear layer on top of the pooled
output) e.g. for GLUE tasks.`,du,Gl,d_=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,cu,Rl,c_=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,pu,Vl,p_="Finally, this model supports inherent JAX features such as:",mu,Xl,m_='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',hu,Ve,da,uu,El,h_="The <code>FlaxAlbertPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",fu,go,gu,_o,uc,Pt,bo,Zi,ca,_u,Sl,u_="FlaxAlbertForMultipleChoice",fc,X,pa,bu,Ql,f_=`Albert Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,Tu,Yl,g_=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,yu,Dl,__=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,vu,Ol,b_="Finally, this model supports inherent JAX features such as:",Mu,Kl,T_='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',ku,Xe,ma,wu,ei,y_="The <code>FlaxAlbertPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",$u,To,xu,yo,gc,Gt,vo,Hi,ha,Fu,ti,v_="FlaxAlbertForTokenClassification",_c,E,ua,ju,ni,M_=`Albert Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,Au,oi,k_=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Cu,si,w_=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Ju,ai,$_="Finally, this model supports inherent JAX features such as:",zu,ri,x_='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Uu,Ee,fa,Iu,li,F_="The <code>FlaxAlbertPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",qu,Mo,Wu,ko,bc,Rt,wo,Bi,ga,Nu,ii,j_="FlaxAlbertForQuestionAnswering",Tc,S,_a,Lu,di,A_=`Albert Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Zu,ci,C_=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Hu,pi,J_=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Bu,mi,z_="Finally, this model supports inherent JAX features such as:",Pu,hi,U_='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Gu,Se,ba,Ru,ui,I_="The <code>FlaxAlbertPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Vu,$o,Xu,xo,yc,Pi,vc;return W=new L({}),Zo=new L({}),Eo=new L({}),Qo=new L({}),Yo=new J({props:{name:"class transformers.AlbertConfig",anchor:"transformers.AlbertConfig",parameters:[{name:"vocab_size",val:" = 30000"},{name:"embedding_size",val:" = 128"},{name:"hidden_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 12"},{name:"num_hidden_groups",val:" = 1"},{name:"num_attention_heads",val:" = 64"},{name:"intermediate_size",val:" = 16384"},{name:"inner_group_num",val:" = 1"},{name:"hidden_act",val:" = 'gelu_new'"},{name:"hidden_dropout_prob",val:" = 0"},{name:"attention_probs_dropout_prob",val:" = 0"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"classifier_dropout_prob",val:" = 0.1"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 2"},{name:"eos_token_id",val:" = 3"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AlbertConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30000) &#x2014;
Vocabulary size of the ALBERT model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a>.`,name:"vocab_size"},{anchor:"transformers.AlbertConfig.embedding_size",description:`<strong>embedding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimensionality of vocabulary embeddings.`,name:"embedding_size"},{anchor:"transformers.AlbertConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.AlbertConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.AlbertConfig.num_hidden_groups",description:`<strong>num_hidden_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups for the hidden layers, parameters in the same group are shared.`,name:"num_hidden_groups"},{anchor:"transformers.AlbertConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.AlbertConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.AlbertConfig.inner_group_num",description:`<strong>inner_group_num</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of inner repetition of attention and ffn.`,name:"inner_group_num"},{anchor:"transformers.AlbertConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu_new&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.AlbertConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.AlbertConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.AlbertConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
(e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.AlbertConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.AlbertConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.AlbertConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.AlbertConfig.classifier_dropout_prob",description:`<strong>classifier_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for attached classifiers.`,name:"classifier_dropout_prob"},{anchor:"transformers.AlbertConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;absolute&quot;</code>) &#x2014;
Type of position embedding. Choose one of <code>&quot;absolute&quot;</code>, <code>&quot;relative_key&quot;</code>, <code>&quot;relative_key_query&quot;</code>. For
positional embeddings use <code>&quot;absolute&quot;</code>. For more information on <code>&quot;relative_key&quot;</code>, please refer to
<a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attention with Relative Position Representations (Shaw et al.)</a>.
For more information on <code>&quot;relative_key_query&quot;</code>, please refer to <em>Method 4</em> in <a href="https://arxiv.org/abs/2009.13658" rel="nofollow">Improve Transformer Models
with Better Relative Position Embeddings (Huang et al.)</a>.`,name:"position_embedding_type"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/configuration_albert.py#L36"}}),Yt=new I({props:{anchor:"transformers.AlbertConfig.example",$$slots:{default:[bb]},$$scope:{ctx:x}}}),Do=new L({}),Oo=new J({props:{name:"class transformers.AlbertTokenizer",anchor:"transformers.AlbertTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"remove_space",val:" = True"},{name:"keep_accents",val:" = False"},{name:"bos_token",val:" = '[CLS]'"},{name:"eos_token",val:" = '[SEP]'"},{name:"unk_token",val:" = '<unk>'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '<pad>'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AlbertTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.AlbertTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.AlbertTokenizer.remove_space",description:`<strong>remove_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to strip the text when tokenizing (removing excess spaces before and after the string).`,name:"remove_space"},{anchor:"transformers.AlbertTokenizer.keep_accents",description:`<strong>keep_accents</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to keep accents when tokenizing.`,name:"keep_accents"},{anchor:"transformers.AlbertTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.AlbertTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.AlbertTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.AlbertTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.AlbertTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.AlbertTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.AlbertTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.AlbertTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.AlbertTokenizer.sp_model",description:`<strong>sp_model</strong> (<code>SentencePieceProcessor</code>) &#x2014;
The <em>SentencePiece</em> processor that is used for every conversion (string, tokens and IDs).`,name:"sp_model"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert.py#L59"}}),Ko=new J({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.AlbertTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.AlbertTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.AlbertTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert.py#L271",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),es=new J({props:{name:"get_special_tokens_mask",anchor:"transformers.AlbertTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.AlbertTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.AlbertTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.AlbertTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert.py#L296",returnDescription:`
<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),ts=new J({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.AlbertTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.AlbertTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.AlbertTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert.py#L324",returnDescription:`
<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Kt=new I({props:{anchor:"transformers.AlbertTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[Tb]},$$scope:{ctx:x}}}),ns=new J({props:{name:"save_vocabulary",anchor:"transformers.AlbertTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert.py#L354"}}),os=new L({}),ss=new J({props:{name:"class transformers.AlbertTokenizerFast",anchor:"transformers.AlbertTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"do_lower_case",val:" = True"},{name:"remove_space",val:" = True"},{name:"keep_accents",val:" = False"},{name:"bos_token",val:" = '[CLS]'"},{name:"eos_token",val:" = '[SEP]'"},{name:"unk_token",val:" = '<unk>'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '<pad>'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AlbertTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.AlbertTokenizerFast.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.AlbertTokenizerFast.remove_space",description:`<strong>remove_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to strip the text when tokenizing (removing excess spaces before and after the string).`,name:"remove_space"},{anchor:"transformers.AlbertTokenizerFast.keep_accents",description:`<strong>keep_accents</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to keep accents when tokenizing.`,name:"keep_accents"},{anchor:"transformers.AlbertTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.AlbertTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The end of sequence token. .. note:: When building a sequence using special tokens, this is not the token
that is used for the end of sequence. The token used is the <code>sep_token</code>.`,name:"eos_token"},{anchor:"transformers.AlbertTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.AlbertTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.AlbertTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.AlbertTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.AlbertTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert_fast.py#L72"}}),as=new J({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.AlbertTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.AlbertTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added`,name:"token_ids_0"},{anchor:"transformers.AlbertTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert_fast.py#L173",returnDescription:`
<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),rs=new J({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.AlbertTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.AlbertTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.AlbertTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/tokenization_albert_fast.py#L198",returnDescription:`
<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),tn=new I({props:{anchor:"transformers.AlbertTokenizerFast.create_token_type_ids_from_sequences.example",$$slots:{default:[yb]},$$scope:{ctx:x}}}),ls=new L({}),is=new J({props:{name:"class transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput",anchor:"transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prediction_logits",val:": FloatTensor = None"},{name:"sop_logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput.loss",description:`<strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
Total loss as the sum of the masked language modeling loss and the next sequence prediction
(classification) loss.`,name:"loss"},{anchor:"transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput.prediction_logits",description:`<strong>prediction_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"prediction_logits"},{anchor:"transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput.sop_logits",description:`<strong>sop_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"sop_logits"},{anchor:"transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L531"}}),ds=new J({props:{name:"class transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput",anchor:"transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput",parameters:[{name:"loss",val:": tf.Tensor = None"},{name:"prediction_logits",val:": tf.Tensor = None"},{name:"sop_logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput.prediction_logits",description:`<strong>prediction_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"prediction_logits"},{anchor:"transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput.sop_logits",description:`<strong>sop_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"sop_logits"},{anchor:"transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L655"}}),cs=new L({}),ps=new J({props:{name:"class transformers.AlbertModel",anchor:"transformers.AlbertModel",parameters:[{name:"config",val:": AlbertConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.AlbertModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L634"}}),ms=new J({props:{name:"forward",anchor:"transformers.AlbertModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.AlbertModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AlbertModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AlbertModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.AlbertModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AlbertModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.AlbertModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.AlbertModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AlbertModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AlbertModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L677",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),sn=new N({props:{$$slots:{default:[vb]},$$scope:{ctx:x}}}),an=new I({props:{anchor:"transformers.AlbertModel.forward.example",$$slots:{default:[Mb]},$$scope:{ctx:x}}}),hs=new L({}),us=new J({props:{name:"class transformers.AlbertForPreTraining",anchor:"transformers.AlbertForPreTraining",parameters:[{name:"config",val:": AlbertConfig"}],parametersDescription:[{anchor:"transformers.AlbertForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L763"}}),fs=new J({props:{name:"forward",anchor:"transformers.AlbertForPreTraining.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"sentence_order_label",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.AlbertForPreTraining.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AlbertForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AlbertForPreTraining.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.AlbertForPreTraining.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AlbertForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.AlbertForPreTraining.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.AlbertForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AlbertForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AlbertForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.AlbertForPreTraining.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.AlbertForPreTraining.forward.sentence_order_label",description:`<strong>sentence_order_label</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the next sequence prediction (classification) loss. Input should be a sequence pair
(see <code>input_ids</code> docstring) Indices should be in <code>[0, 1]</code>. <code>0</code> indicates original order (sequence A, then
sequence B), <code>1</code> indicates switched order (sequence B, then sequence A).`,name:"sentence_order_label"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L785",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput"
>transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Total loss as the sum of the masked language modeling loss and the next sequence prediction
(classification) loss.</p>
</li>
<li>
<p><strong>prediction_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>sop_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) — Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput"
>transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ln=new N({props:{$$slots:{default:[kb]},$$scope:{ctx:x}}}),dn=new I({props:{anchor:"transformers.AlbertForPreTraining.forward.example",$$slots:{default:[wb]},$$scope:{ctx:x}}}),gs=new L({}),_s=new J({props:{name:"class transformers.AlbertForMaskedLM",anchor:"transformers.AlbertForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.AlbertForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L911"}}),bs=new J({props:{name:"forward",anchor:"transformers.AlbertForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.AlbertForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AlbertForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AlbertForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.AlbertForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AlbertForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.AlbertForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.AlbertForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AlbertForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AlbertForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.AlbertForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L932",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pn=new N({props:{$$slots:{default:[$b]},$$scope:{ctx:x}}}),mn=new I({props:{anchor:"transformers.AlbertForMaskedLM.forward.example",$$slots:{default:[xb]},$$scope:{ctx:x}}}),hn=new I({props:{anchor:"transformers.AlbertForMaskedLM.forward.example-2",$$slots:{default:[Fb]},$$scope:{ctx:x}}}),Ts=new L({}),ys=new J({props:{name:"class transformers.AlbertForSequenceClassification",anchor:"transformers.AlbertForSequenceClassification",parameters:[{name:"config",val:": AlbertConfig"}],parametersDescription:[{anchor:"transformers.AlbertForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1025"}}),vs=new J({props:{name:"forward",anchor:"transformers.AlbertForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.AlbertForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AlbertForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AlbertForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.AlbertForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AlbertForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.AlbertForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.AlbertForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AlbertForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AlbertForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.AlbertForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1038",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fn=new N({props:{$$slots:{default:[jb]},$$scope:{ctx:x}}}),gn=new I({props:{anchor:"transformers.AlbertForSequenceClassification.forward.example",$$slots:{default:[Ab]},$$scope:{ctx:x}}}),_n=new I({props:{anchor:"transformers.AlbertForSequenceClassification.forward.example-2",$$slots:{default:[Cb]},$$scope:{ctx:x}}}),Ms=new L({}),ks=new J({props:{name:"class transformers.AlbertForMultipleChoice",anchor:"transformers.AlbertForMultipleChoice",parameters:[{name:"config",val:": AlbertConfig"}],parametersDescription:[{anchor:"transformers.AlbertForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1312"}}),ws=new J({props:{name:"forward",anchor:"transformers.AlbertForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.AlbertForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AlbertForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AlbertForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.AlbertForMultipleChoice.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AlbertForMultipleChoice.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.AlbertForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.AlbertForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AlbertForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AlbertForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.AlbertForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <em>num_choices</em> is the size of the second dimension of the input tensors. (see
<em>input_ids</em> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1323",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Tn=new N({props:{$$slots:{default:[Jb]},$$scope:{ctx:x}}}),yn=new I({props:{anchor:"transformers.AlbertForMultipleChoice.forward.example",$$slots:{default:[zb]},$$scope:{ctx:x}}}),$s=new L({}),xs=new J({props:{name:"class transformers.AlbertForTokenClassification",anchor:"transformers.AlbertForTokenClassification",parameters:[{name:"config",val:": AlbertConfig"}],parametersDescription:[{anchor:"transformers.AlbertForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1126"}}),Fs=new J({props:{name:"forward",anchor:"transformers.AlbertForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.AlbertForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AlbertForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AlbertForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.AlbertForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AlbertForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.AlbertForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.AlbertForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AlbertForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AlbertForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.AlbertForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1143",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Mn=new N({props:{$$slots:{default:[Ub]},$$scope:{ctx:x}}}),kn=new I({props:{anchor:"transformers.AlbertForTokenClassification.forward.example",$$slots:{default:[Ib]},$$scope:{ctx:x}}}),js=new L({}),As=new J({props:{name:"class transformers.AlbertForQuestionAnswering",anchor:"transformers.AlbertForQuestionAnswering",parameters:[{name:"config",val:": AlbertConfig"}],parametersDescription:[{anchor:"transformers.AlbertForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1209"}}),Cs=new J({props:{name:"forward",anchor:"transformers.AlbertForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.AlbertForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AlbertForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AlbertForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.AlbertForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AlbertForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.AlbertForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.AlbertForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AlbertForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AlbertForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.AlbertForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.AlbertForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_albert.py#L1220",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$n=new N({props:{$$slots:{default:[qb]},$$scope:{ctx:x}}}),xn=new I({props:{anchor:"transformers.AlbertForQuestionAnswering.forward.example",$$slots:{default:[Wb]},$$scope:{ctx:x}}}),Js=new L({}),zs=new J({props:{name:"class transformers.TFAlbertModel",anchor:"transformers.TFAlbertModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAlbertModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L787"}}),jn=new N({props:{$$slots:{default:[Nb]},$$scope:{ctx:x}}}),Us=new J({props:{name:"call",anchor:"transformers.TFAlbertModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFAlbertModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFAlbertModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFAlbertModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFAlbertModel.call.position_ids",description:`<strong>position_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFAlbertModel.call.head_mask",description:`<strong>head_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFAlbertModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFAlbertModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFAlbertModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFAlbertModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFAlbertModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L793",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you’re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or <code>tuple(tf.Tensor)</code></p>
`}}),An=new N({props:{$$slots:{default:[Lb]},$$scope:{ctx:x}}}),Cn=new I({props:{anchor:"transformers.TFAlbertModel.call.example",$$slots:{default:[Zb]},$$scope:{ctx:x}}}),Is=new L({}),qs=new J({props:{name:"class transformers.TFAlbertForPreTraining",anchor:"transformers.TFAlbertForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAlbertForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L836"}}),zn=new N({props:{$$slots:{default:[Hb]},$$scope:{ctx:x}}}),Ws=new J({props:{name:"call",anchor:"transformers.TFAlbertForPreTraining.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"sentence_order_label",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFAlbertForPreTraining.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFAlbertForPreTraining.call.attention_mask",description:`<strong>attention_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFAlbertForPreTraining.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFAlbertForPreTraining.call.position_ids",description:`<strong>position_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFAlbertForPreTraining.call.head_mask",description:`<strong>head_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFAlbertForPreTraining.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFAlbertForPreTraining.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFAlbertForPreTraining.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFAlbertForPreTraining.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFAlbertForPreTraining.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L852",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput"
>transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>prediction_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>sop_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, 2)</code>) — Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput"
>transformers.models.albert.modeling_tf_albert.TFAlbertForPreTrainingOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Un=new N({props:{$$slots:{default:[Bb]},$$scope:{ctx:x}}}),In=new I({props:{anchor:"transformers.TFAlbertForPreTraining.call.example",$$slots:{default:[Pb]},$$scope:{ctx:x}}}),Ns=new L({}),Ls=new J({props:{name:"class transformers.TFAlbertForMaskedLM",anchor:"transformers.TFAlbertForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAlbertForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L944"}}),Wn=new N({props:{$$slots:{default:[Gb]},$$scope:{ctx:x}}}),Zs=new J({props:{name:"call",anchor:"transformers.TFAlbertForMaskedLM.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFAlbertForMaskedLM.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFAlbertForMaskedLM.call.attention_mask",description:`<strong>attention_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFAlbertForMaskedLM.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFAlbertForMaskedLM.call.position_ids",description:`<strong>position_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFAlbertForMaskedLM.call.head_mask",description:`<strong>head_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFAlbertForMaskedLM.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFAlbertForMaskedLM.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFAlbertForMaskedLM.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFAlbertForMaskedLM.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFAlbertForMaskedLM.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFAlbertForMaskedLM.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L957",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Nn=new N({props:{$$slots:{default:[Rb]},$$scope:{ctx:x}}}),Ln=new I({props:{anchor:"transformers.TFAlbertForMaskedLM.call.example",$$slots:{default:[Vb]},$$scope:{ctx:x}}}),Zn=new I({props:{anchor:"transformers.TFAlbertForMaskedLM.call.example-2",$$slots:{default:[Xb]},$$scope:{ctx:x}}}),Hs=new L({}),Bs=new J({props:{name:"class transformers.TFAlbertForSequenceClassification",anchor:"transformers.TFAlbertForSequenceClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAlbertForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1046"}}),Bn=new N({props:{$$slots:{default:[Eb]},$$scope:{ctx:x}}}),Ps=new J({props:{name:"call",anchor:"transformers.TFAlbertForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFAlbertForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFAlbertForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFAlbertForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFAlbertForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFAlbertForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFAlbertForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFAlbertForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFAlbertForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFAlbertForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFAlbertForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFAlbertForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1062",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Pn=new N({props:{$$slots:{default:[Sb]},$$scope:{ctx:x}}}),Gn=new I({props:{anchor:"transformers.TFAlbertForSequenceClassification.call.example",$$slots:{default:[Qb]},$$scope:{ctx:x}}}),Rn=new I({props:{anchor:"transformers.TFAlbertForSequenceClassification.call.example-2",$$slots:{default:[Yb]},$$scope:{ctx:x}}}),Gs=new L({}),Rs=new J({props:{name:"class transformers.TFAlbertForMultipleChoice",anchor:"transformers.TFAlbertForMultipleChoice",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAlbertForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1306"}}),Xn=new N({props:{$$slots:{default:[Db]},$$scope:{ctx:x}}}),Vs=new J({props:{name:"call",anchor:"transformers.TFAlbertForMultipleChoice.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFAlbertForMultipleChoice.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFAlbertForMultipleChoice.call.attention_mask",description:`<strong>attention_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFAlbertForMultipleChoice.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFAlbertForMultipleChoice.call.position_ids",description:`<strong>position_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFAlbertForMultipleChoice.call.head_mask",description:`<strong>head_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFAlbertForMultipleChoice.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFAlbertForMultipleChoice.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFAlbertForMultipleChoice.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFAlbertForMultipleChoice.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFAlbertForMultipleChoice.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFAlbertForMultipleChoice.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices]</code>
where <code>num_choices</code> is the size of the second dimension of the input tensors. (See <code>input_ids</code> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1320",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput"
>transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <em>(batch_size, )</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput"
>transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),En=new N({props:{$$slots:{default:[Ob]},$$scope:{ctx:x}}}),Sn=new I({props:{anchor:"transformers.TFAlbertForMultipleChoice.call.example",$$slots:{default:[Kb]},$$scope:{ctx:x}}}),Xs=new L({}),Es=new J({props:{name:"class transformers.TFAlbertForTokenClassification",anchor:"transformers.TFAlbertForTokenClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAlbertForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1128"}}),Yn=new N({props:{$$slots:{default:[eT]},$$scope:{ctx:x}}}),Ss=new J({props:{name:"call",anchor:"transformers.TFAlbertForTokenClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFAlbertForTokenClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFAlbertForTokenClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFAlbertForTokenClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFAlbertForTokenClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFAlbertForTokenClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFAlbertForTokenClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFAlbertForTokenClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFAlbertForTokenClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFAlbertForTokenClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFAlbertForTokenClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFAlbertForTokenClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1149",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFTokenClassifierOutput"
>transformers.modeling_tf_outputs.TFTokenClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of unmasked labels, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFTokenClassifierOutput"
>transformers.modeling_tf_outputs.TFTokenClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Dn=new N({props:{$$slots:{default:[tT]},$$scope:{ctx:x}}}),On=new I({props:{anchor:"transformers.TFAlbertForTokenClassification.call.example",$$slots:{default:[nT]},$$scope:{ctx:x}}}),Kn=new I({props:{anchor:"transformers.TFAlbertForTokenClassification.call.example-2",$$slots:{default:[oT]},$$scope:{ctx:x}}}),Qs=new L({}),Ys=new J({props:{name:"class transformers.TFAlbertForQuestionAnswering",anchor:"transformers.TFAlbertForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAlbertForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1211"}}),to=new N({props:{$$slots:{default:[sT]},$$scope:{ctx:x}}}),Ds=new J({props:{name:"call",anchor:"transformers.TFAlbertForQuestionAnswering.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"start_positions",val:": np.ndarray | tf.Tensor | None = None"},{name:"end_positions",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFAlbertForQuestionAnswering.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.attention_mask",description:`<strong>attention_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.position_ids",description:`<strong>position_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.head_mask",description:`<strong>head_mask</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.start_positions",description:`<strong>start_positions</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.TFAlbertForQuestionAnswering.call.end_positions",description:`<strong>end_positions</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_tf_albert.py#L1225",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput"
>transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>start_positions</code> and <code>end_positions</code> are provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput"
>transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),no=new N({props:{$$slots:{default:[aT]},$$scope:{ctx:x}}}),oo=new I({props:{anchor:"transformers.TFAlbertForQuestionAnswering.call.example",$$slots:{default:[rT]},$$scope:{ctx:x}}}),so=new I({props:{anchor:"transformers.TFAlbertForQuestionAnswering.call.example-2",$$slots:{default:[lT]},$$scope:{ctx:x}}}),Os=new L({}),Ks=new J({props:{name:"class transformers.FlaxAlbertModel",anchor:"transformers.FlaxAlbertModel",parameters:[{name:"config",val:": AlbertConfig"},{name:"input_shape",val:": typing.Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAlbertModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxAlbertModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L676"}}),ea=new J({props:{name:"__call__",anchor:"transformers.FlaxAlbertModel.__call__",parameters:[{name:"input_ids",val:""},{name:"attention_mask",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"position_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxAlbertModel.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxAlbertModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxAlbertModel.__call__.token_type_ids",description:`<strong>token_type_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.FlaxAlbertModel.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxAlbertModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L553",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ro=new N({props:{$$slots:{default:[iT]},$$scope:{ctx:x}}}),lo=new I({props:{anchor:"transformers.FlaxAlbertModel.__call__.example",$$slots:{default:[dT]},$$scope:{ctx:x}}}),ta=new L({}),na=new J({props:{name:"class transformers.FlaxAlbertForPreTraining",anchor:"transformers.FlaxAlbertForPreTraining",parameters:[{name:"config",val:": AlbertConfig"},{name:"input_shape",val:": typing.Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAlbertForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxAlbertForPreTraining.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L744"}}),oa=new J({props:{name:"__call__",anchor:"transformers.FlaxAlbertForPreTraining.__call__",parameters:[{name:"input_ids",val:""},{name:"attention_mask",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"position_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxAlbertForPreTraining.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxAlbertForPreTraining.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxAlbertForPreTraining.__call__.token_type_ids",description:`<strong>token_type_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.FlaxAlbertForPreTraining.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxAlbertForPreTraining.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L553",returnDescription:`
<p>A <code>transformers.models.albert.modeling_flax_albert.FlaxAlbertForPreTrainingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>prediction_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>sop_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, 2)</code>) — Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.albert.modeling_flax_albert.FlaxAlbertForPreTrainingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),co=new N({props:{$$slots:{default:[cT]},$$scope:{ctx:x}}}),po=new I({props:{anchor:"transformers.FlaxAlbertForPreTraining.__call__.example",$$slots:{default:[pT]},$$scope:{ctx:x}}}),sa=new L({}),aa=new J({props:{name:"class transformers.FlaxAlbertForMaskedLM",anchor:"transformers.FlaxAlbertForMaskedLM",parameters:[{name:"config",val:": AlbertConfig"},{name:"input_shape",val:": typing.Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAlbertForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxAlbertForMaskedLM.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L827"}}),ra=new J({props:{name:"__call__",anchor:"transformers.FlaxAlbertForMaskedLM.__call__",parameters:[{name:"input_ids",val:""},{name:"attention_mask",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"position_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxAlbertForMaskedLM.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxAlbertForMaskedLM.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxAlbertForMaskedLM.__call__.token_type_ids",description:`<strong>token_type_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.FlaxAlbertForMaskedLM.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxAlbertForMaskedLM.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L553",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ho=new N({props:{$$slots:{default:[mT]},$$scope:{ctx:x}}}),uo=new I({props:{anchor:"transformers.FlaxAlbertForMaskedLM.__call__.example",$$slots:{default:[hT]},$$scope:{ctx:x}}}),la=new L({}),ia=new J({props:{name:"class transformers.FlaxAlbertForSequenceClassification",anchor:"transformers.FlaxAlbertForSequenceClassification",parameters:[{name:"config",val:": AlbertConfig"},{name:"input_shape",val:": typing.Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAlbertForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxAlbertForSequenceClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L895"}}),da=new J({props:{name:"__call__",anchor:"transformers.FlaxAlbertForSequenceClassification.__call__",parameters:[{name:"input_ids",val:""},{name:"attention_mask",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"position_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxAlbertForSequenceClassification.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxAlbertForSequenceClassification.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxAlbertForSequenceClassification.__call__.token_type_ids",description:`<strong>token_type_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.FlaxAlbertForSequenceClassification.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxAlbertForSequenceClassification.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L553",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),go=new N({props:{$$slots:{default:[uT]},$$scope:{ctx:x}}}),_o=new I({props:{anchor:"transformers.FlaxAlbertForSequenceClassification.__call__.example",$$slots:{default:[fT]},$$scope:{ctx:x}}}),ca=new L({}),pa=new J({props:{name:"class transformers.FlaxAlbertForMultipleChoice",anchor:"transformers.FlaxAlbertForMultipleChoice",parameters:[{name:"config",val:": AlbertConfig"},{name:"input_shape",val:": typing.Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAlbertForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxAlbertForMultipleChoice.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L968"}}),ma=new J({props:{name:"__call__",anchor:"transformers.FlaxAlbertForMultipleChoice.__call__",parameters:[{name:"input_ids",val:""},{name:"attention_mask",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"position_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxAlbertForMultipleChoice.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxAlbertForMultipleChoice.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxAlbertForMultipleChoice.__call__.token_type_ids",description:`<strong>token_type_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.FlaxAlbertForMultipleChoice.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxAlbertForMultipleChoice.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L553",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput"
>transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput"
>transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),To=new N({props:{$$slots:{default:[gT]},$$scope:{ctx:x}}}),yo=new I({props:{anchor:"transformers.FlaxAlbertForMultipleChoice.__call__.example",$$slots:{default:[_T]},$$scope:{ctx:x}}}),ha=new L({}),ua=new J({props:{name:"class transformers.FlaxAlbertForTokenClassification",anchor:"transformers.FlaxAlbertForTokenClassification",parameters:[{name:"config",val:": AlbertConfig"},{name:"input_shape",val:": typing.Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAlbertForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxAlbertForTokenClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L1041"}}),fa=new J({props:{name:"__call__",anchor:"transformers.FlaxAlbertForTokenClassification.__call__",parameters:[{name:"input_ids",val:""},{name:"attention_mask",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"position_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxAlbertForTokenClassification.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxAlbertForTokenClassification.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxAlbertForTokenClassification.__call__.token_type_ids",description:`<strong>token_type_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.FlaxAlbertForTokenClassification.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxAlbertForTokenClassification.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L553",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxTokenClassifierOutput"
>transformers.modeling_flax_outputs.FlaxTokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxTokenClassifierOutput"
>transformers.modeling_flax_outputs.FlaxTokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Mo=new N({props:{$$slots:{default:[bT]},$$scope:{ctx:x}}}),ko=new I({props:{anchor:"transformers.FlaxAlbertForTokenClassification.__call__.example",$$slots:{default:[TT]},$$scope:{ctx:x}}}),ga=new L({}),_a=new J({props:{name:"class transformers.FlaxAlbertForQuestionAnswering",anchor:"transformers.FlaxAlbertForQuestionAnswering",parameters:[{name:"config",val:": AlbertConfig"},{name:"input_shape",val:": typing.Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAlbertForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxAlbertForQuestionAnswering.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L1109"}}),ba=new J({props:{name:"__call__",anchor:"transformers.FlaxAlbertForQuestionAnswering.__call__",parameters:[{name:"input_ids",val:""},{name:"attention_mask",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"position_ids",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxAlbertForQuestionAnswering.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxAlbertForQuestionAnswering.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxAlbertForQuestionAnswering.__call__.token_type_ids",description:`<strong>token_type_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.FlaxAlbertForQuestionAnswering.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.`,name:"position_ids"},{anchor:"transformers.FlaxAlbertForQuestionAnswering.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/albert/modeling_flax_albert.py#L553",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput"
>transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/albert#transformers.AlbertConfig"
>AlbertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>start_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput"
>transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$o=new N({props:{$$slots:{default:[yT]},$$scope:{ctx:x}}}),xo=new I({props:{anchor:"transformers.FlaxAlbertForQuestionAnswering.__call__.example",$$slots:{default:[vT]},$$scope:{ctx:x}}}),{c(){t=a("meta"),u=l(),d=a("p"),c=l(),w=a("h1"),o=a("a"),M=a("span"),f(W.$$.fragment),U=l(),A=a("span"),A.textContent=Z,z=l(),j=a("div"),j.innerHTML=H,k=l(),F=a("h2"),Et=a("a"),fi=a("span"),f(Zo.$$.fragment),Nc=l(),qa=a("span"),qa.textContent=Eu,ud=l(),Ho=a("p"),Ho.innerHTML=Su,fd=l(),Bo=a("ul"),Bo.innerHTML=Qu,gd=l(),Po=a("p"),Po.textContent=Yu,_d=l(),Go=a("p"),Go.innerHTML=Du,bd=l(),Ro=a("p"),Ro.textContent=Ou,Td=l(),Vo=a("ul"),Vo.innerHTML=Ku,yd=l(),Xo=a("p"),Xo.innerHTML=ef,vd=l(),_t=a("h2"),St=a("a"),gi=a("span"),f(Eo.$$.fragment),Lc=l(),Wa=a("span"),Wa.textContent=tf,Md=l(),So=a("ul"),So.innerHTML=nf,kd=l(),bt=a("h2"),Qt=a("a"),_i=a("span"),f(Qo.$$.fragment),Zc=l(),Na=a("span"),Na.textContent=of,wd=l(),ke=a("div"),f(Yo.$$.fragment),Hc=l(),La=a("p"),La.innerHTML=sf,Bc=l(),Za=a("p"),Za.innerHTML=af,Pc=l(),f(Yt.$$.fragment),$d=l(),Tt=a("h2"),Dt=a("a"),bi=a("span"),f(Do.$$.fragment),Gc=l(),Ha=a("span"),Ha.textContent=rf,xd=l(),B=a("div"),f(Oo.$$.fragment),Rc=l(),Ba=a("p"),Ba.innerHTML=lf,Vc=l(),Pa=a("p"),Pa.innerHTML=df,Xc=l(),dt=a("div"),f(Ko.$$.fragment),Ec=l(),Ga=a("p"),Ga.textContent=cf,Sc=l(),Ra=a("ul"),Ra.innerHTML=pf,Qc=l(),Ot=a("div"),f(es.$$.fragment),Yc=l(),Va=a("p"),Va.innerHTML=mf,Dc=l(),ze=a("div"),f(ts.$$.fragment),Oc=l(),Xa=a("p"),Xa.textContent=hf,Kc=l(),f(Kt.$$.fragment),ep=l(),Ea=a("p"),Ea.innerHTML=uf,tp=l(),Sa=a("div"),f(ns.$$.fragment),Fd=l(),yt=a("h2"),en=a("a"),Ti=a("span"),f(os.$$.fragment),np=l(),Qa=a("span"),Qa.textContent=ff,jd=l(),we=a("div"),f(ss.$$.fragment),op=l(),Ya=a("p"),Ya.innerHTML=gf,sp=l(),ct=a("div"),f(as.$$.fragment),ap=l(),Da=a("p"),Da.textContent=_f,rp=l(),Oa=a("ul"),Oa.innerHTML=bf,lp=l(),Ue=a("div"),f(rs.$$.fragment),ip=l(),Ka=a("p"),Ka.textContent=Tf,dp=l(),f(tn.$$.fragment),cp=l(),er=a("p"),er.textContent=yf,Ad=l(),vt=a("h2"),nn=a("a"),yi=a("span"),f(ls.$$.fragment),pp=l(),tr=a("span"),tr.textContent=vf,Cd=l(),Mt=a("div"),f(is.$$.fragment),mp=l(),nr=a("p"),nr.innerHTML=Mf,Jd=l(),kt=a("div"),f(ds.$$.fragment),hp=l(),or=a("p"),or.innerHTML=kf,zd=l(),wt=a("h2"),on=a("a"),vi=a("span"),f(cs.$$.fragment),up=l(),sr=a("span"),sr.textContent=wf,Ud=l(),oe=a("div"),f(ps.$$.fragment),fp=l(),ar=a("p"),ar.textContent=$f,gp=l(),rr=a("p"),rr.innerHTML=xf,_p=l(),lr=a("p"),lr.innerHTML=Ff,bp=l(),Ie=a("div"),f(ms.$$.fragment),Tp=l(),ir=a("p"),ir.innerHTML=jf,yp=l(),f(sn.$$.fragment),vp=l(),f(an.$$.fragment),Id=l(),$t=a("h2"),rn=a("a"),Mi=a("span"),f(hs.$$.fragment),Mp=l(),dr=a("span"),dr.textContent=Af,qd=l(),se=a("div"),f(us.$$.fragment),kp=l(),cr=a("p"),cr.innerHTML=Cf,wp=l(),pr=a("p"),pr.innerHTML=Jf,$p=l(),mr=a("p"),mr.innerHTML=zf,xp=l(),qe=a("div"),f(fs.$$.fragment),Fp=l(),hr=a("p"),hr.innerHTML=Uf,jp=l(),f(ln.$$.fragment),Ap=l(),f(dn.$$.fragment),Wd=l(),xt=a("h2"),cn=a("a"),ki=a("span"),f(gs.$$.fragment),Cp=l(),ur=a("span"),ur.textContent=If,Nd=l(),ae=a("div"),f(_s.$$.fragment),Jp=l(),fr=a("p"),fr.innerHTML=qf,zp=l(),gr=a("p"),gr.innerHTML=Wf,Up=l(),_r=a("p"),_r.innerHTML=Nf,Ip=l(),ce=a("div"),f(bs.$$.fragment),qp=l(),br=a("p"),br.innerHTML=Lf,Wp=l(),f(pn.$$.fragment),Np=l(),f(mn.$$.fragment),Lp=l(),f(hn.$$.fragment),Ld=l(),Ft=a("h2"),un=a("a"),wi=a("span"),f(Ts.$$.fragment),Zp=l(),Tr=a("span"),Tr.textContent=Zf,Zd=l(),re=a("div"),f(ys.$$.fragment),Hp=l(),yr=a("p"),yr.textContent=Hf,Bp=l(),vr=a("p"),vr.innerHTML=Bf,Pp=l(),Mr=a("p"),Mr.innerHTML=Pf,Gp=l(),pe=a("div"),f(vs.$$.fragment),Rp=l(),kr=a("p"),kr.innerHTML=Gf,Vp=l(),f(fn.$$.fragment),Xp=l(),f(gn.$$.fragment),Ep=l(),f(_n.$$.fragment),Hd=l(),jt=a("h2"),bn=a("a"),$i=a("span"),f(Ms.$$.fragment),Sp=l(),wr=a("span"),wr.textContent=Rf,Bd=l(),le=a("div"),f(ks.$$.fragment),Qp=l(),$r=a("p"),$r.textContent=Vf,Yp=l(),xr=a("p"),xr.innerHTML=Xf,Dp=l(),Fr=a("p"),Fr.innerHTML=Ef,Op=l(),We=a("div"),f(ws.$$.fragment),Kp=l(),jr=a("p"),jr.innerHTML=Sf,em=l(),f(Tn.$$.fragment),tm=l(),f(yn.$$.fragment),Pd=l(),At=a("h2"),vn=a("a"),xi=a("span"),f($s.$$.fragment),nm=l(),Ar=a("span"),Ar.textContent=Qf,Gd=l(),ie=a("div"),f(xs.$$.fragment),om=l(),Cr=a("p"),Cr.textContent=Yf,sm=l(),Jr=a("p"),Jr.innerHTML=Df,am=l(),zr=a("p"),zr.innerHTML=Of,rm=l(),Ne=a("div"),f(Fs.$$.fragment),lm=l(),Ur=a("p"),Ur.innerHTML=Kf,im=l(),f(Mn.$$.fragment),dm=l(),f(kn.$$.fragment),Rd=l(),Ct=a("h2"),wn=a("a"),Fi=a("span"),f(js.$$.fragment),cm=l(),Ir=a("span"),Ir.textContent=eg,Vd=l(),de=a("div"),f(As.$$.fragment),pm=l(),qr=a("p"),qr.innerHTML=tg,mm=l(),Wr=a("p"),Wr.innerHTML=ng,hm=l(),Nr=a("p"),Nr.innerHTML=og,um=l(),Le=a("div"),f(Cs.$$.fragment),fm=l(),Lr=a("p"),Lr.innerHTML=sg,gm=l(),f($n.$$.fragment),_m=l(),f(xn.$$.fragment),Xd=l(),Jt=a("h2"),Fn=a("a"),ji=a("span"),f(Js.$$.fragment),bm=l(),Zr=a("span"),Zr.textContent=ag,Ed=l(),Q=a("div"),f(zs.$$.fragment),Tm=l(),Hr=a("p"),Hr.textContent=rg,ym=l(),Br=a("p"),Br.innerHTML=lg,vm=l(),Pr=a("p"),Pr.innerHTML=ig,Mm=l(),f(jn.$$.fragment),km=l(),Ze=a("div"),f(Us.$$.fragment),wm=l(),Gr=a("p"),Gr.innerHTML=dg,$m=l(),f(An.$$.fragment),xm=l(),f(Cn.$$.fragment),Sd=l(),zt=a("h2"),Jn=a("a"),Ai=a("span"),f(Is.$$.fragment),Fm=l(),Rr=a("span"),Rr.textContent=cg,Qd=l(),Y=a("div"),f(qs.$$.fragment),jm=l(),Vr=a("p"),Vr.innerHTML=pg,Am=l(),Xr=a("p"),Xr.innerHTML=mg,Cm=l(),Er=a("p"),Er.innerHTML=hg,Jm=l(),f(zn.$$.fragment),zm=l(),He=a("div"),f(Ws.$$.fragment),Um=l(),Sr=a("p"),Sr.innerHTML=ug,Im=l(),f(Un.$$.fragment),qm=l(),f(In.$$.fragment),Yd=l(),Ut=a("h2"),qn=a("a"),Ci=a("span"),f(Ns.$$.fragment),Wm=l(),Qr=a("span"),Qr.textContent=fg,Dd=l(),D=a("div"),f(Ls.$$.fragment),Nm=l(),Yr=a("p"),Yr.innerHTML=gg,Lm=l(),Dr=a("p"),Dr.innerHTML=_g,Zm=l(),Or=a("p"),Or.innerHTML=bg,Hm=l(),f(Wn.$$.fragment),Bm=l(),me=a("div"),f(Zs.$$.fragment),Pm=l(),Kr=a("p"),Kr.innerHTML=Tg,Gm=l(),f(Nn.$$.fragment),Rm=l(),f(Ln.$$.fragment),Vm=l(),f(Zn.$$.fragment),Od=l(),It=a("h2"),Hn=a("a"),Ji=a("span"),f(Hs.$$.fragment),Xm=l(),el=a("span"),el.textContent=yg,Kd=l(),O=a("div"),f(Bs.$$.fragment),Em=l(),tl=a("p"),tl.textContent=vg,Sm=l(),nl=a("p"),nl.innerHTML=Mg,Qm=l(),ol=a("p"),ol.innerHTML=kg,Ym=l(),f(Bn.$$.fragment),Dm=l(),he=a("div"),f(Ps.$$.fragment),Om=l(),sl=a("p"),sl.innerHTML=wg,Km=l(),f(Pn.$$.fragment),eh=l(),f(Gn.$$.fragment),th=l(),f(Rn.$$.fragment),ec=l(),qt=a("h2"),Vn=a("a"),zi=a("span"),f(Gs.$$.fragment),nh=l(),al=a("span"),al.textContent=$g,tc=l(),K=a("div"),f(Rs.$$.fragment),oh=l(),rl=a("p"),rl.textContent=xg,sh=l(),ll=a("p"),ll.innerHTML=Fg,ah=l(),il=a("p"),il.innerHTML=jg,rh=l(),f(Xn.$$.fragment),lh=l(),Be=a("div"),f(Vs.$$.fragment),ih=l(),dl=a("p"),dl.innerHTML=Ag,dh=l(),f(En.$$.fragment),ch=l(),f(Sn.$$.fragment),nc=l(),Wt=a("h2"),Qn=a("a"),Ui=a("span"),f(Xs.$$.fragment),ph=l(),cl=a("span"),cl.textContent=Cg,oc=l(),ee=a("div"),f(Es.$$.fragment),mh=l(),pl=a("p"),pl.textContent=Jg,hh=l(),ml=a("p"),ml.innerHTML=zg,uh=l(),hl=a("p"),hl.innerHTML=Ug,fh=l(),f(Yn.$$.fragment),gh=l(),ue=a("div"),f(Ss.$$.fragment),_h=l(),ul=a("p"),ul.innerHTML=Ig,bh=l(),f(Dn.$$.fragment),Th=l(),f(On.$$.fragment),yh=l(),f(Kn.$$.fragment),sc=l(),Nt=a("h2"),eo=a("a"),Ii=a("span"),f(Qs.$$.fragment),vh=l(),fl=a("span"),fl.textContent=qg,ac=l(),te=a("div"),f(Ys.$$.fragment),Mh=l(),gl=a("p"),gl.innerHTML=Wg,kh=l(),_l=a("p"),_l.innerHTML=Ng,wh=l(),bl=a("p"),bl.innerHTML=Lg,$h=l(),f(to.$$.fragment),xh=l(),fe=a("div"),f(Ds.$$.fragment),Fh=l(),Tl=a("p"),Tl.innerHTML=Zg,jh=l(),f(no.$$.fragment),Ah=l(),f(oo.$$.fragment),Ch=l(),f(so.$$.fragment),rc=l(),Lt=a("h2"),ao=a("a"),qi=a("span"),f(Os.$$.fragment),Jh=l(),yl=a("span"),yl.textContent=Hg,lc=l(),P=a("div"),f(Ks.$$.fragment),zh=l(),vl=a("p"),vl.textContent=Bg,Uh=l(),Ml=a("p"),Ml.innerHTML=Pg,Ih=l(),kl=a("p"),kl.innerHTML=Gg,qh=l(),wl=a("p"),wl.textContent=Rg,Wh=l(),$l=a("ul"),$l.innerHTML=Vg,Nh=l(),Pe=a("div"),f(ea.$$.fragment),Lh=l(),xl=a("p"),xl.innerHTML=Xg,Zh=l(),f(ro.$$.fragment),Hh=l(),f(lo.$$.fragment),ic=l(),Zt=a("h2"),io=a("a"),Wi=a("span"),f(ta.$$.fragment),Bh=l(),Fl=a("span"),Fl.textContent=Eg,dc=l(),G=a("div"),f(na.$$.fragment),Ph=l(),jl=a("p"),jl.innerHTML=Sg,Gh=l(),Al=a("p"),Al.innerHTML=Qg,Rh=l(),Cl=a("p"),Cl.innerHTML=Yg,Vh=l(),Jl=a("p"),Jl.textContent=Dg,Xh=l(),zl=a("ul"),zl.innerHTML=Og,Eh=l(),Ge=a("div"),f(oa.$$.fragment),Sh=l(),Ul=a("p"),Ul.innerHTML=Kg,Qh=l(),f(co.$$.fragment),Yh=l(),f(po.$$.fragment),cc=l(),Ht=a("h2"),mo=a("a"),Ni=a("span"),f(sa.$$.fragment),Dh=l(),Il=a("span"),Il.textContent=e_,pc=l(),R=a("div"),f(aa.$$.fragment),Oh=l(),ql=a("p"),ql.innerHTML=t_,Kh=l(),Wl=a("p"),Wl.innerHTML=n_,eu=l(),Nl=a("p"),Nl.innerHTML=o_,tu=l(),Ll=a("p"),Ll.textContent=s_,nu=l(),Zl=a("ul"),Zl.innerHTML=a_,ou=l(),Re=a("div"),f(ra.$$.fragment),su=l(),Hl=a("p"),Hl.innerHTML=r_,au=l(),f(ho.$$.fragment),ru=l(),f(uo.$$.fragment),mc=l(),Bt=a("h2"),fo=a("a"),Li=a("span"),f(la.$$.fragment),lu=l(),Bl=a("span"),Bl.textContent=l_,hc=l(),V=a("div"),f(ia.$$.fragment),iu=l(),Pl=a("p"),Pl.textContent=i_,du=l(),Gl=a("p"),Gl.innerHTML=d_,cu=l(),Rl=a("p"),Rl.innerHTML=c_,pu=l(),Vl=a("p"),Vl.textContent=p_,mu=l(),Xl=a("ul"),Xl.innerHTML=m_,hu=l(),Ve=a("div"),f(da.$$.fragment),uu=l(),El=a("p"),El.innerHTML=h_,fu=l(),f(go.$$.fragment),gu=l(),f(_o.$$.fragment),uc=l(),Pt=a("h2"),bo=a("a"),Zi=a("span"),f(ca.$$.fragment),_u=l(),Sl=a("span"),Sl.textContent=u_,fc=l(),X=a("div"),f(pa.$$.fragment),bu=l(),Ql=a("p"),Ql.textContent=f_,Tu=l(),Yl=a("p"),Yl.innerHTML=g_,yu=l(),Dl=a("p"),Dl.innerHTML=__,vu=l(),Ol=a("p"),Ol.textContent=b_,Mu=l(),Kl=a("ul"),Kl.innerHTML=T_,ku=l(),Xe=a("div"),f(ma.$$.fragment),wu=l(),ei=a("p"),ei.innerHTML=y_,$u=l(),f(To.$$.fragment),xu=l(),f(yo.$$.fragment),gc=l(),Gt=a("h2"),vo=a("a"),Hi=a("span"),f(ha.$$.fragment),Fu=l(),ti=a("span"),ti.textContent=v_,_c=l(),E=a("div"),f(ua.$$.fragment),ju=l(),ni=a("p"),ni.textContent=M_,Au=l(),oi=a("p"),oi.innerHTML=k_,Cu=l(),si=a("p"),si.innerHTML=w_,Ju=l(),ai=a("p"),ai.textContent=$_,zu=l(),ri=a("ul"),ri.innerHTML=x_,Uu=l(),Ee=a("div"),f(fa.$$.fragment),Iu=l(),li=a("p"),li.innerHTML=F_,qu=l(),f(Mo.$$.fragment),Wu=l(),f(ko.$$.fragment),bc=l(),Rt=a("h2"),wo=a("a"),Bi=a("span"),f(ga.$$.fragment),Nu=l(),ii=a("span"),ii.textContent=j_,Tc=l(),S=a("div"),f(_a.$$.fragment),Lu=l(),di=a("p"),di.innerHTML=A_,Zu=l(),ci=a("p"),ci.innerHTML=C_,Hu=l(),pi=a("p"),pi.innerHTML=J_,Bu=l(),mi=a("p"),mi.textContent=z_,Pu=l(),hi=a("ul"),hi.innerHTML=U_,Gu=l(),Se=a("div"),f(ba.$$.fragment),Ru=l(),ui=a("p"),ui.innerHTML=I_,Vu=l(),f($o.$$.fragment),Xu=l(),f(xo.$$.fragment),yc=l(),Pi=a("p"),this.h()},l(e){const m=_b("svelte-1phssyn",document.head);t=r(m,"META",{name:!0,content:!0}),m.forEach(s),u=i(e),d=r(e,"P",{}),$(d).forEach(s),c=i(e),w=r(e,"H1",{class:!0});var Ta=$(w);o=r(Ta,"A",{id:!0,class:!0,href:!0});var Gi=$(o);M=r(Gi,"SPAN",{});var Ri=$(M);g(W.$$.fragment,Ri),Ri.forEach(s),Gi.forEach(s),U=i(Ta),A=r(Ta,"SPAN",{"data-svelte-h":!0}),h(A)!=="svelte-dnm4h3"&&(A.textContent=Z),Ta.forEach(s),z=i(e),j=r(e,"DIV",{class:!0,"data-svelte-h":!0}),h(j)!=="svelte-h0ieyw"&&(j.innerHTML=H),k=i(e),F=r(e,"H2",{class:!0});var ya=$(F);Et=r(ya,"A",{id:!0,class:!0,href:!0});var Vi=$(Et);fi=r(Vi,"SPAN",{});var Xi=$(fi);g(Zo.$$.fragment,Xi),Xi.forEach(s),Vi.forEach(s),Nc=i(ya),qa=r(ya,"SPAN",{"data-svelte-h":!0}),h(qa)!=="svelte-1jsw1pg"&&(qa.textContent=Eu),ya.forEach(s),ud=i(e),Ho=r(e,"P",{"data-svelte-h":!0}),h(Ho)!=="svelte-13pbz2f"&&(Ho.innerHTML=Su),fd=i(e),Bo=r(e,"UL",{"data-svelte-h":!0}),h(Bo)!=="svelte-hp2fe8"&&(Bo.innerHTML=Qu),gd=i(e),Po=r(e,"P",{"data-svelte-h":!0}),h(Po)!=="svelte-vfdo9a"&&(Po.textContent=Yu),_d=i(e),Go=r(e,"P",{"data-svelte-h":!0}),h(Go)!=="svelte-e7vw4p"&&(Go.innerHTML=Du),bd=i(e),Ro=r(e,"P",{"data-svelte-h":!0}),h(Ro)!=="svelte-axv494"&&(Ro.textContent=Ou),Td=i(e),Vo=r(e,"UL",{"data-svelte-h":!0}),h(Vo)!=="svelte-kwvnzd"&&(Vo.innerHTML=Ku),yd=i(e),Xo=r(e,"P",{"data-svelte-h":!0}),h(Xo)!=="svelte-x8cmte"&&(Xo.innerHTML=ef),vd=i(e),_t=r(e,"H2",{class:!0});var va=$(_t);St=r(va,"A",{id:!0,class:!0,href:!0});var Ei=$(St);gi=r(Ei,"SPAN",{});var Si=$(gi);g(Eo.$$.fragment,Si),Si.forEach(s),Ei.forEach(s),Lc=i(va),Wa=r(va,"SPAN",{"data-svelte-h":!0}),h(Wa)!=="svelte-n3f0j0"&&(Wa.textContent=tf),va.forEach(s),Md=i(e),So=r(e,"UL",{"data-svelte-h":!0}),h(So)!=="svelte-mgusi3"&&(So.innerHTML=nf),kd=i(e),bt=r(e,"H2",{class:!0});var Ma=$(bt);Qt=r(Ma,"A",{id:!0,class:!0,href:!0});var Qi=$(Qt);_i=r(Qi,"SPAN",{});var Yi=$(_i);g(Qo.$$.fragment,Yi),Yi.forEach(s),Qi.forEach(s),Zc=i(Ma),Na=r(Ma,"SPAN",{"data-svelte-h":!0}),h(Na)!=="svelte-qgqo2t"&&(Na.textContent=of),Ma.forEach(s),wd=i(e),ke=r(e,"DIV",{class:!0});var nt=$(ke);g(Yo.$$.fragment,nt),Hc=i(nt),La=r(nt,"P",{"data-svelte-h":!0}),h(La)!=="svelte-cohcs4"&&(La.innerHTML=sf),Bc=i(nt),Za=r(nt,"P",{"data-svelte-h":!0}),h(Za)!=="svelte-cfh5wl"&&(Za.innerHTML=af),Pc=i(nt),g(Yt.$$.fragment,nt),nt.forEach(s),$d=i(e),Tt=r(e,"H2",{class:!0});var ka=$(Tt);Dt=r(ka,"A",{id:!0,class:!0,href:!0});var Di=$(Dt);bi=r(Di,"SPAN",{});var Oi=$(bi);g(Do.$$.fragment,Oi),Oi.forEach(s),Di.forEach(s),Gc=i(ka),Ha=r(ka,"SPAN",{"data-svelte-h":!0}),h(Ha)!=="svelte-135fdsg"&&(Ha.textContent=rf),ka.forEach(s),xd=i(e),B=r(e,"DIV",{class:!0});var ne=$(B);g(Oo.$$.fragment,ne),Rc=i(ne),Ba=r(ne,"P",{"data-svelte-h":!0}),h(Ba)!=="svelte-15hj622"&&(Ba.innerHTML=lf),Vc=i(ne),Pa=r(ne,"P",{"data-svelte-h":!0}),h(Pa)!=="svelte-14xlfoy"&&(Pa.innerHTML=df),Xc=i(ne),dt=r(ne,"DIV",{class:!0});var Vt=$(dt);g(Ko.$$.fragment,Vt),Ec=i(Vt),Ga=r(Vt,"P",{"data-svelte-h":!0}),h(Ga)!=="svelte-1bnx1ll"&&(Ga.textContent=cf),Sc=i(Vt),Ra=r(Vt,"UL",{"data-svelte-h":!0}),h(Ra)!=="svelte-xi6653"&&(Ra.innerHTML=pf),Vt.forEach(s),Qc=i(ne),Ot=r(ne,"DIV",{class:!0});var wa=$(Ot);g(es.$$.fragment,wa),Yc=i(wa),Va=r(wa,"P",{"data-svelte-h":!0}),h(Va)!=="svelte-1f4f5kp"&&(Va.innerHTML=mf),wa.forEach(s),Dc=i(ne),ze=r(ne,"DIV",{class:!0});var ot=$(ze);g(ts.$$.fragment,ot),Oc=i(ot),Xa=r(ot,"P",{"data-svelte-h":!0}),h(Xa)!=="svelte-1e96hgr"&&(Xa.textContent=hf),Kc=i(ot),g(Kt.$$.fragment,ot),ep=i(ot),Ea=r(ot,"P",{"data-svelte-h":!0}),h(Ea)!=="svelte-owoxgn"&&(Ea.innerHTML=uf),ot.forEach(s),tp=i(ne),Sa=r(ne,"DIV",{class:!0});var Ki=$(Sa);g(ns.$$.fragment,Ki),Ki.forEach(s),ne.forEach(s),Fd=i(e),yt=r(e,"H2",{class:!0});var $a=$(yt);en=r($a,"A",{id:!0,class:!0,href:!0});var ed=$(en);Ti=r(ed,"SPAN",{});var td=$(Ti);g(os.$$.fragment,td),td.forEach(s),ed.forEach(s),np=i($a),Qa=r($a,"SPAN",{"data-svelte-h":!0}),h(Qa)!=="svelte-1nnvtry"&&(Qa.textContent=ff),$a.forEach(s),jd=i(e),we=r(e,"DIV",{class:!0});var st=$(we);g(ss.$$.fragment,st),op=i(st),Ya=r(st,"P",{"data-svelte-h":!0}),h(Ya)!=="svelte-1r2y9nj"&&(Ya.innerHTML=gf),sp=i(st),ct=r(st,"DIV",{class:!0});var Xt=$(ct);g(as.$$.fragment,Xt),ap=i(Xt),Da=r(Xt,"P",{"data-svelte-h":!0}),h(Da)!=="svelte-1bnx1ll"&&(Da.textContent=_f),rp=i(Xt),Oa=r(Xt,"UL",{"data-svelte-h":!0}),h(Oa)!=="svelte-xi6653"&&(Oa.innerHTML=bf),Xt.forEach(s),lp=i(st),Ue=r(st,"DIV",{class:!0});var at=$(Ue);g(rs.$$.fragment,at),ip=i(at),Ka=r(at,"P",{"data-svelte-h":!0}),h(Ka)!=="svelte-13bfd60"&&(Ka.textContent=Tf),dp=i(at),g(tn.$$.fragment,at),cp=i(at),er=r(at,"P",{"data-svelte-h":!0}),h(er)!=="svelte-wtrslu"&&(er.textContent=yf),at.forEach(s),st.forEach(s),Ad=i(e),vt=r(e,"H2",{class:!0});var xa=$(vt);nn=r(xa,"A",{id:!0,class:!0,href:!0});var nd=$(nn);yi=r(nd,"SPAN",{});var od=$(yi);g(ls.$$.fragment,od),od.forEach(s),nd.forEach(s),pp=i(xa),tr=r(xa,"SPAN",{"data-svelte-h":!0}),h(tr)!=="svelte-72zqoz"&&(tr.textContent=vf),xa.forEach(s),Cd=i(e),Mt=r(e,"DIV",{class:!0});var Fa=$(Mt);g(is.$$.fragment,Fa),mp=i(Fa),nr=r(Fa,"P",{"data-svelte-h":!0}),h(nr)!=="svelte-17g377h"&&(nr.innerHTML=Mf),Fa.forEach(s),Jd=i(e),kt=r(e,"DIV",{class:!0});var ja=$(kt);g(ds.$$.fragment,ja),hp=i(ja),or=r(ja,"P",{"data-svelte-h":!0}),h(or)!=="svelte-14wt961"&&(or.innerHTML=kf),ja.forEach(s),zd=i(e),wt=r(e,"H2",{class:!0});var Aa=$(wt);on=r(Aa,"A",{id:!0,class:!0,href:!0});var sd=$(on);vi=r(sd,"SPAN",{});var ad=$(vi);g(cs.$$.fragment,ad),ad.forEach(s),sd.forEach(s),up=i(Aa),sr=r(Aa,"SPAN",{"data-svelte-h":!0}),h(sr)!=="svelte-1rrnju8"&&(sr.textContent=wf),Aa.forEach(s),Ud=i(e),oe=r(e,"DIV",{class:!0});var $e=$(oe);g(ps.$$.fragment,$e),fp=i($e),ar=r($e,"P",{"data-svelte-h":!0}),h(ar)!=="svelte-1y2mzsh"&&(ar.textContent=$f),gp=i($e),rr=r($e,"P",{"data-svelte-h":!0}),h(rr)!=="svelte-ev63c"&&(rr.innerHTML=xf),_p=i($e),lr=r($e,"P",{"data-svelte-h":!0}),h(lr)!=="svelte-hswkmf"&&(lr.innerHTML=Ff),bp=i($e),Ie=r($e,"DIV",{class:!0});var rt=$(Ie);g(ms.$$.fragment,rt),Tp=i(rt),ir=r(rt,"P",{"data-svelte-h":!0}),h(ir)!=="svelte-14zaa8r"&&(ir.innerHTML=jf),yp=i(rt),g(sn.$$.fragment,rt),vp=i(rt),g(an.$$.fragment,rt),rt.forEach(s),$e.forEach(s),Id=i(e),$t=r(e,"H2",{class:!0});var Ca=$($t);rn=r(Ca,"A",{id:!0,class:!0,href:!0});var rd=$(rn);Mi=r(rd,"SPAN",{});var ld=$(Mi);g(hs.$$.fragment,ld),ld.forEach(s),rd.forEach(s),Mp=i(Ca),dr=r(Ca,"SPAN",{"data-svelte-h":!0}),h(dr)!=="svelte-1aycqeh"&&(dr.textContent=Af),Ca.forEach(s),qd=i(e),se=r(e,"DIV",{class:!0});var xe=$(se);g(us.$$.fragment,xe),kp=i(xe),cr=r(xe,"P",{"data-svelte-h":!0}),h(cr)!=="svelte-1qm9vpn"&&(cr.innerHTML=Cf),wp=i(xe),pr=r(xe,"P",{"data-svelte-h":!0}),h(pr)!=="svelte-ev63c"&&(pr.innerHTML=Jf),$p=i(xe),mr=r(xe,"P",{"data-svelte-h":!0}),h(mr)!=="svelte-hswkmf"&&(mr.innerHTML=zf),xp=i(xe),qe=r(xe,"DIV",{class:!0});var lt=$(qe);g(fs.$$.fragment,lt),Fp=i(lt),hr=r(lt,"P",{"data-svelte-h":!0}),h(hr)!=="svelte-1lj7b6v"&&(hr.innerHTML=Uf),jp=i(lt),g(ln.$$.fragment,lt),Ap=i(lt),g(dn.$$.fragment,lt),lt.forEach(s),xe.forEach(s),Wd=i(e),xt=r(e,"H2",{class:!0});var Ja=$(xt);cn=r(Ja,"A",{id:!0,class:!0,href:!0});var id=$(cn);ki=r(id,"SPAN",{});var dd=$(ki);g(gs.$$.fragment,dd),dd.forEach(s),id.forEach(s),Cp=i(Ja),ur=r(Ja,"SPAN",{"data-svelte-h":!0}),h(ur)!=="svelte-1i9mhyg"&&(ur.textContent=If),Ja.forEach(s),Nd=i(e),ae=r(e,"DIV",{class:!0});var Fe=$(ae);g(_s.$$.fragment,Fe),Jp=i(Fe),fr=r(Fe,"P",{"data-svelte-h":!0}),h(fr)!=="svelte-q4kelk"&&(fr.innerHTML=qf),zp=i(Fe),gr=r(Fe,"P",{"data-svelte-h":!0}),h(gr)!=="svelte-ev63c"&&(gr.innerHTML=Wf),Up=i(Fe),_r=r(Fe,"P",{"data-svelte-h":!0}),h(_r)!=="svelte-hswkmf"&&(_r.innerHTML=Nf),Ip=i(Fe),ce=r(Fe,"DIV",{class:!0});var je=$(ce);g(bs.$$.fragment,je),qp=i(je),br=r(je,"P",{"data-svelte-h":!0}),h(br)!=="svelte-cw6g6n"&&(br.innerHTML=Lf),Wp=i(je),g(pn.$$.fragment,je),Np=i(je),g(mn.$$.fragment,je),Lp=i(je),g(hn.$$.fragment,je),je.forEach(s),Fe.forEach(s),Ld=i(e),Ft=r(e,"H2",{class:!0});var za=$(Ft);un=r(za,"A",{id:!0,class:!0,href:!0});var cd=$(un);wi=r(cd,"SPAN",{});var pd=$(wi);g(Ts.$$.fragment,pd),pd.forEach(s),cd.forEach(s),Zp=i(za),Tr=r(za,"SPAN",{"data-svelte-h":!0}),h(Tr)!=="svelte-hqlgfz"&&(Tr.textContent=Zf),za.forEach(s),Zd=i(e),re=r(e,"DIV",{class:!0});var Ae=$(re);g(ys.$$.fragment,Ae),Hp=i(Ae),yr=r(Ae,"P",{"data-svelte-h":!0}),h(yr)!=="svelte-1wuvovs"&&(yr.textContent=Hf),Bp=i(Ae),vr=r(Ae,"P",{"data-svelte-h":!0}),h(vr)!=="svelte-ev63c"&&(vr.innerHTML=Bf),Pp=i(Ae),Mr=r(Ae,"P",{"data-svelte-h":!0}),h(Mr)!=="svelte-hswkmf"&&(Mr.innerHTML=Pf),Gp=i(Ae),pe=r(Ae,"DIV",{class:!0});var Ce=$(pe);g(vs.$$.fragment,Ce),Rp=i(Ce),kr=r(Ce,"P",{"data-svelte-h":!0}),h(kr)!=="svelte-1bjugqr"&&(kr.innerHTML=Gf),Vp=i(Ce),g(fn.$$.fragment,Ce),Xp=i(Ce),g(gn.$$.fragment,Ce),Ep=i(Ce),g(_n.$$.fragment,Ce),Ce.forEach(s),Ae.forEach(s),Hd=i(e),jt=r(e,"H2",{class:!0});var Ua=$(jt);bn=r(Ua,"A",{id:!0,class:!0,href:!0});var md=$(bn);$i=r(md,"SPAN",{});var hd=$($i);g(Ms.$$.fragment,hd),hd.forEach(s),md.forEach(s),Sp=i(Ua),wr=r(Ua,"SPAN",{"data-svelte-h":!0}),h(wr)!=="svelte-1gjq7tl"&&(wr.textContent=Rf),Ua.forEach(s),Bd=i(e),le=r(e,"DIV",{class:!0});var Je=$(le);g(ks.$$.fragment,Je),Qp=i(Je),$r=r(Je,"P",{"data-svelte-h":!0}),h($r)!=="svelte-axso2c"&&($r.textContent=Vf),Yp=i(Je),xr=r(Je,"P",{"data-svelte-h":!0}),h(xr)!=="svelte-ev63c"&&(xr.innerHTML=Xf),Dp=i(Je),Fr=r(Je,"P",{"data-svelte-h":!0}),h(Fr)!=="svelte-hswkmf"&&(Fr.innerHTML=Ef),Op=i(Je),We=r(Je,"DIV",{class:!0});var it=$(We);g(ws.$$.fragment,it),Kp=i(it),jr=r(it,"P",{"data-svelte-h":!0}),h(jr)!=="svelte-outukv"&&(jr.innerHTML=Sf),em=i(it),g(Tn.$$.fragment,it),tm=i(it),g(yn.$$.fragment,it),it.forEach(s),Je.forEach(s),Pd=i(e),At=r(e,"H2",{class:!0});var Ia=$(At);vn=r(Ia,"A",{id:!0,class:!0,href:!0});var q_=$(vn);xi=r(q_,"SPAN",{});var W_=$(xi);g($s.$$.fragment,W_),W_.forEach(s),q_.forEach(s),nm=i(Ia),Ar=r(Ia,"SPAN",{"data-svelte-h":!0}),h(Ar)!=="svelte-1mq8lov"&&(Ar.textContent=Qf),Ia.forEach(s),Gd=i(e),ie=r(e,"DIV",{class:!0});var pt=$(ie);g(xs.$$.fragment,pt),om=i(pt),Cr=r(pt,"P",{"data-svelte-h":!0}),h(Cr)!=="svelte-olqnpn"&&(Cr.textContent=Yf),sm=i(pt),Jr=r(pt,"P",{"data-svelte-h":!0}),h(Jr)!=="svelte-ev63c"&&(Jr.innerHTML=Df),am=i(pt),zr=r(pt,"P",{"data-svelte-h":!0}),h(zr)!=="svelte-hswkmf"&&(zr.innerHTML=Of),rm=i(pt),Ne=r(pt,"DIV",{class:!0});var Fo=$(Ne);g(Fs.$$.fragment,Fo),lm=i(Fo),Ur=r(Fo,"P",{"data-svelte-h":!0}),h(Ur)!=="svelte-1wuihqn"&&(Ur.innerHTML=Kf),im=i(Fo),g(Mn.$$.fragment,Fo),dm=i(Fo),g(kn.$$.fragment,Fo),Fo.forEach(s),pt.forEach(s),Rd=i(e),Ct=r(e,"H2",{class:!0});var Mc=$(Ct);wn=r(Mc,"A",{id:!0,class:!0,href:!0});var N_=$(wn);Fi=r(N_,"SPAN",{});var L_=$(Fi);g(js.$$.fragment,L_),L_.forEach(s),N_.forEach(s),cm=i(Mc),Ir=r(Mc,"SPAN",{"data-svelte-h":!0}),h(Ir)!=="svelte-1avf48u"&&(Ir.textContent=eg),Mc.forEach(s),Vd=i(e),de=r(e,"DIV",{class:!0});var mt=$(de);g(As.$$.fragment,mt),pm=i(mt),qr=r(mt,"P",{"data-svelte-h":!0}),h(qr)!=="svelte-v56eal"&&(qr.innerHTML=tg),mm=i(mt),Wr=r(mt,"P",{"data-svelte-h":!0}),h(Wr)!=="svelte-ev63c"&&(Wr.innerHTML=ng),hm=i(mt),Nr=r(mt,"P",{"data-svelte-h":!0}),h(Nr)!=="svelte-hswkmf"&&(Nr.innerHTML=og),um=i(mt),Le=r(mt,"DIV",{class:!0});var jo=$(Le);g(Cs.$$.fragment,jo),fm=i(jo),Lr=r(jo,"P",{"data-svelte-h":!0}),h(Lr)!=="svelte-4f8ib9"&&(Lr.innerHTML=sg),gm=i(jo),g($n.$$.fragment,jo),_m=i(jo),g(xn.$$.fragment,jo),jo.forEach(s),mt.forEach(s),Xd=i(e),Jt=r(e,"H2",{class:!0});var kc=$(Jt);Fn=r(kc,"A",{id:!0,class:!0,href:!0});var Z_=$(Fn);ji=r(Z_,"SPAN",{});var H_=$(ji);g(Js.$$.fragment,H_),H_.forEach(s),Z_.forEach(s),bm=i(kc),Zr=r(kc,"SPAN",{"data-svelte-h":!0}),h(Zr)!=="svelte-ojrkwm"&&(Zr.textContent=ag),kc.forEach(s),Ed=i(e),Q=r(e,"DIV",{class:!0});var Qe=$(Q);g(zs.$$.fragment,Qe),Tm=i(Qe),Hr=r(Qe,"P",{"data-svelte-h":!0}),h(Hr)!=="svelte-psfqdt"&&(Hr.textContent=rg),ym=i(Qe),Br=r(Qe,"P",{"data-svelte-h":!0}),h(Br)!=="svelte-1e9g3w8"&&(Br.innerHTML=lg),vm=i(Qe),Pr=r(Qe,"P",{"data-svelte-h":!0}),h(Pr)!=="svelte-1ivrf8m"&&(Pr.innerHTML=ig),Mm=i(Qe),g(jn.$$.fragment,Qe),km=i(Qe),Ze=r(Qe,"DIV",{class:!0});var Ao=$(Ze);g(Us.$$.fragment,Ao),wm=i(Ao),Gr=r(Ao,"P",{"data-svelte-h":!0}),h(Gr)!=="svelte-1v836o3"&&(Gr.innerHTML=dg),$m=i(Ao),g(An.$$.fragment,Ao),xm=i(Ao),g(Cn.$$.fragment,Ao),Ao.forEach(s),Qe.forEach(s),Sd=i(e),zt=r(e,"H2",{class:!0});var wc=$(zt);Jn=r(wc,"A",{id:!0,class:!0,href:!0});var B_=$(Jn);Ai=r(B_,"SPAN",{});var P_=$(Ai);g(Is.$$.fragment,P_),P_.forEach(s),B_.forEach(s),Fm=i(wc),Rr=r(wc,"SPAN",{"data-svelte-h":!0}),h(Rr)!=="svelte-21b7un"&&(Rr.textContent=cg),wc.forEach(s),Qd=i(e),Y=r(e,"DIV",{class:!0});var Ye=$(Y);g(qs.$$.fragment,Ye),jm=i(Ye),Vr=r(Ye,"P",{"data-svelte-h":!0}),h(Vr)!=="svelte-xc1iay"&&(Vr.innerHTML=pg),Am=i(Ye),Xr=r(Ye,"P",{"data-svelte-h":!0}),h(Xr)!=="svelte-1e9g3w8"&&(Xr.innerHTML=mg),Cm=i(Ye),Er=r(Ye,"P",{"data-svelte-h":!0}),h(Er)!=="svelte-1ivrf8m"&&(Er.innerHTML=hg),Jm=i(Ye),g(zn.$$.fragment,Ye),zm=i(Ye),He=r(Ye,"DIV",{class:!0});var Co=$(He);g(Ws.$$.fragment,Co),Um=i(Co),Sr=r(Co,"P",{"data-svelte-h":!0}),h(Sr)!=="svelte-1b5awu7"&&(Sr.innerHTML=ug),Im=i(Co),g(Un.$$.fragment,Co),qm=i(Co),g(In.$$.fragment,Co),Co.forEach(s),Ye.forEach(s),Yd=i(e),Ut=r(e,"H2",{class:!0});var $c=$(Ut);qn=r($c,"A",{id:!0,class:!0,href:!0});var G_=$(qn);Ci=r(G_,"SPAN",{});var R_=$(Ci);g(Ns.$$.fragment,R_),R_.forEach(s),G_.forEach(s),Wm=i($c),Qr=r($c,"SPAN",{"data-svelte-h":!0}),h(Qr)!=="svelte-uk27ta"&&(Qr.textContent=fg),$c.forEach(s),Dd=i(e),D=r(e,"DIV",{class:!0});var De=$(D);g(Ls.$$.fragment,De),Nm=i(De),Yr=r(De,"P",{"data-svelte-h":!0}),h(Yr)!=="svelte-q4kelk"&&(Yr.innerHTML=gg),Lm=i(De),Dr=r(De,"P",{"data-svelte-h":!0}),h(Dr)!=="svelte-1e9g3w8"&&(Dr.innerHTML=_g),Zm=i(De),Or=r(De,"P",{"data-svelte-h":!0}),h(Or)!=="svelte-1ivrf8m"&&(Or.innerHTML=bg),Hm=i(De),g(Wn.$$.fragment,De),Bm=i(De),me=r(De,"DIV",{class:!0});var ht=$(me);g(Zs.$$.fragment,ht),Pm=i(ht),Kr=r(ht,"P",{"data-svelte-h":!0}),h(Kr)!=="svelte-1xxzya7"&&(Kr.innerHTML=Tg),Gm=i(ht),g(Nn.$$.fragment,ht),Rm=i(ht),g(Ln.$$.fragment,ht),Vm=i(ht),g(Zn.$$.fragment,ht),ht.forEach(s),De.forEach(s),Od=i(e),It=r(e,"H2",{class:!0});var xc=$(It);Hn=r(xc,"A",{id:!0,class:!0,href:!0});var V_=$(Hn);Ji=r(V_,"SPAN",{});var X_=$(Ji);g(Hs.$$.fragment,X_),X_.forEach(s),V_.forEach(s),Xm=i(xc),el=r(xc,"SPAN",{"data-svelte-h":!0}),h(el)!=="svelte-6zhull"&&(el.textContent=yg),xc.forEach(s),Kd=i(e),O=r(e,"DIV",{class:!0});var Oe=$(O);g(Bs.$$.fragment,Oe),Em=i(Oe),tl=r(Oe,"P",{"data-svelte-h":!0}),h(tl)!=="svelte-1wuvovs"&&(tl.textContent=vg),Sm=i(Oe),nl=r(Oe,"P",{"data-svelte-h":!0}),h(nl)!=="svelte-1e9g3w8"&&(nl.innerHTML=Mg),Qm=i(Oe),ol=r(Oe,"P",{"data-svelte-h":!0}),h(ol)!=="svelte-1ivrf8m"&&(ol.innerHTML=kg),Ym=i(Oe),g(Bn.$$.fragment,Oe),Dm=i(Oe),he=r(Oe,"DIV",{class:!0});var ut=$(he);g(Ps.$$.fragment,ut),Om=i(ut),sl=r(ut,"P",{"data-svelte-h":!0}),h(sl)!=="svelte-3upmwf"&&(sl.innerHTML=wg),Km=i(ut),g(Pn.$$.fragment,ut),eh=i(ut),g(Gn.$$.fragment,ut),th=i(ut),g(Rn.$$.fragment,ut),ut.forEach(s),Oe.forEach(s),ec=i(e),qt=r(e,"H2",{class:!0});var Fc=$(qt);Vn=r(Fc,"A",{id:!0,class:!0,href:!0});var E_=$(Vn);zi=r(E_,"SPAN",{});var S_=$(zi);g(Gs.$$.fragment,S_),S_.forEach(s),E_.forEach(s),nh=i(Fc),al=r(Fc,"SPAN",{"data-svelte-h":!0}),h(al)!=="svelte-1dqeukv"&&(al.textContent=$g),Fc.forEach(s),tc=i(e),K=r(e,"DIV",{class:!0});var Ke=$(K);g(Rs.$$.fragment,Ke),oh=i(Ke),rl=r(Ke,"P",{"data-svelte-h":!0}),h(rl)!=="svelte-axso2c"&&(rl.textContent=xg),sh=i(Ke),ll=r(Ke,"P",{"data-svelte-h":!0}),h(ll)!=="svelte-1e9g3w8"&&(ll.innerHTML=Fg),ah=i(Ke),il=r(Ke,"P",{"data-svelte-h":!0}),h(il)!=="svelte-1ivrf8m"&&(il.innerHTML=jg),rh=i(Ke),g(Xn.$$.fragment,Ke),lh=i(Ke),Be=r(Ke,"DIV",{class:!0});var Jo=$(Be);g(Vs.$$.fragment,Jo),ih=i(Jo),dl=r(Jo,"P",{"data-svelte-h":!0}),h(dl)!=="svelte-lb16hf"&&(dl.innerHTML=Ag),dh=i(Jo),g(En.$$.fragment,Jo),ch=i(Jo),g(Sn.$$.fragment,Jo),Jo.forEach(s),Ke.forEach(s),nc=i(e),Wt=r(e,"H2",{class:!0});var jc=$(Wt);Qn=r(jc,"A",{id:!0,class:!0,href:!0});var Q_=$(Qn);Ui=r(Q_,"SPAN",{});var Y_=$(Ui);g(Xs.$$.fragment,Y_),Y_.forEach(s),Q_.forEach(s),ph=i(jc),cl=r(jc,"SPAN",{"data-svelte-h":!0}),h(cl)!=="svelte-1ncuvx5"&&(cl.textContent=Cg),jc.forEach(s),oc=i(e),ee=r(e,"DIV",{class:!0});var et=$(ee);g(Es.$$.fragment,et),mh=i(et),pl=r(et,"P",{"data-svelte-h":!0}),h(pl)!=="svelte-olqnpn"&&(pl.textContent=Jg),hh=i(et),ml=r(et,"P",{"data-svelte-h":!0}),h(ml)!=="svelte-1e9g3w8"&&(ml.innerHTML=zg),uh=i(et),hl=r(et,"P",{"data-svelte-h":!0}),h(hl)!=="svelte-1ivrf8m"&&(hl.innerHTML=Ug),fh=i(et),g(Yn.$$.fragment,et),gh=i(et),ue=r(et,"DIV",{class:!0});var ft=$(ue);g(Ss.$$.fragment,ft),_h=i(ft),ul=r(ft,"P",{"data-svelte-h":!0}),h(ul)!=="svelte-1funa9z"&&(ul.innerHTML=Ig),bh=i(ft),g(Dn.$$.fragment,ft),Th=i(ft),g(On.$$.fragment,ft),yh=i(ft),g(Kn.$$.fragment,ft),ft.forEach(s),et.forEach(s),sc=i(e),Nt=r(e,"H2",{class:!0});var Ac=$(Nt);eo=r(Ac,"A",{id:!0,class:!0,href:!0});var D_=$(eo);Ii=r(D_,"SPAN",{});var O_=$(Ii);g(Qs.$$.fragment,O_),O_.forEach(s),D_.forEach(s),vh=i(Ac),fl=r(Ac,"SPAN",{"data-svelte-h":!0}),h(fl)!=="svelte-dmms9s"&&(fl.textContent=qg),Ac.forEach(s),ac=i(e),te=r(e,"DIV",{class:!0});var tt=$(te);g(Ys.$$.fragment,tt),Mh=i(tt),gl=r(tt,"P",{"data-svelte-h":!0}),h(gl)!=="svelte-72qmgu"&&(gl.innerHTML=Wg),kh=i(tt),_l=r(tt,"P",{"data-svelte-h":!0}),h(_l)!=="svelte-1e9g3w8"&&(_l.innerHTML=Ng),wh=i(tt),bl=r(tt,"P",{"data-svelte-h":!0}),h(bl)!=="svelte-1ivrf8m"&&(bl.innerHTML=Lg),$h=i(tt),g(to.$$.fragment,tt),xh=i(tt),fe=r(tt,"DIV",{class:!0});var gt=$(fe);g(Ds.$$.fragment,gt),Fh=i(gt),Tl=r(gt,"P",{"data-svelte-h":!0}),h(Tl)!=="svelte-6a5fpp"&&(Tl.innerHTML=Zg),jh=i(gt),g(no.$$.fragment,gt),Ah=i(gt),g(oo.$$.fragment,gt),Ch=i(gt),g(so.$$.fragment,gt),gt.forEach(s),tt.forEach(s),rc=i(e),Lt=r(e,"H2",{class:!0});var Cc=$(Lt);ao=r(Cc,"A",{id:!0,class:!0,href:!0});var K_=$(ao);qi=r(K_,"SPAN",{});var eb=$(qi);g(Os.$$.fragment,eb),eb.forEach(s),K_.forEach(s),Jh=i(Cc),yl=r(Cc,"SPAN",{"data-svelte-h":!0}),h(yl)!=="svelte-1bb0t2d"&&(yl.textContent=Hg),Cc.forEach(s),lc=i(e),P=r(e,"DIV",{class:!0});var ge=$(P);g(Ks.$$.fragment,ge),zh=i(ge),vl=r(ge,"P",{"data-svelte-h":!0}),h(vl)!=="svelte-psfqdt"&&(vl.textContent=Bg),Uh=i(ge),Ml=r(ge,"P",{"data-svelte-h":!0}),h(Ml)!=="svelte-1gfofcr"&&(Ml.innerHTML=Pg),Ih=i(ge),kl=r(ge,"P",{"data-svelte-h":!0}),h(kl)!=="svelte-9ybkh"&&(kl.innerHTML=Gg),qh=i(ge),wl=r(ge,"P",{"data-svelte-h":!0}),h(wl)!=="svelte-1pplc4a"&&(wl.textContent=Rg),Wh=i(ge),$l=r(ge,"UL",{"data-svelte-h":!0}),h($l)!=="svelte-1w7z84m"&&($l.innerHTML=Vg),Nh=i(ge),Pe=r(ge,"DIV",{class:!0});var zo=$(Pe);g(ea.$$.fragment,zo),Lh=i(zo),xl=r(zo,"P",{"data-svelte-h":!0}),h(xl)!=="svelte-hsqakh"&&(xl.innerHTML=Xg),Zh=i(zo),g(ro.$$.fragment,zo),Hh=i(zo),g(lo.$$.fragment,zo),zo.forEach(s),ge.forEach(s),ic=i(e),Zt=r(e,"H2",{class:!0});var Jc=$(Zt);io=r(Jc,"A",{id:!0,class:!0,href:!0});var tb=$(io);Wi=r(tb,"SPAN",{});var nb=$(Wi);g(ta.$$.fragment,nb),nb.forEach(s),tb.forEach(s),Bh=i(Jc),Fl=r(Jc,"SPAN",{"data-svelte-h":!0}),h(Fl)!=="svelte-1as1zmk"&&(Fl.textContent=Eg),Jc.forEach(s),dc=i(e),G=r(e,"DIV",{class:!0});var _e=$(G);g(na.$$.fragment,_e),Ph=i(_e),jl=r(_e,"P",{"data-svelte-h":!0}),h(jl)!=="svelte-1qm9vpn"&&(jl.innerHTML=Sg),Gh=i(_e),Al=r(_e,"P",{"data-svelte-h":!0}),h(Al)!=="svelte-1gfofcr"&&(Al.innerHTML=Qg),Rh=i(_e),Cl=r(_e,"P",{"data-svelte-h":!0}),h(Cl)!=="svelte-9ybkh"&&(Cl.innerHTML=Yg),Vh=i(_e),Jl=r(_e,"P",{"data-svelte-h":!0}),h(Jl)!=="svelte-1pplc4a"&&(Jl.textContent=Dg),Xh=i(_e),zl=r(_e,"UL",{"data-svelte-h":!0}),h(zl)!=="svelte-1w7z84m"&&(zl.innerHTML=Og),Eh=i(_e),Ge=r(_e,"DIV",{class:!0});var Uo=$(Ge);g(oa.$$.fragment,Uo),Sh=i(Uo),Ul=r(Uo,"P",{"data-svelte-h":!0}),h(Ul)!=="svelte-hsqakh"&&(Ul.innerHTML=Kg),Qh=i(Uo),g(co.$$.fragment,Uo),Yh=i(Uo),g(po.$$.fragment,Uo),Uo.forEach(s),_e.forEach(s),cc=i(e),Ht=r(e,"H2",{class:!0});var zc=$(Ht);mo=r(zc,"A",{id:!0,class:!0,href:!0});var ob=$(mo);Ni=r(ob,"SPAN",{});var sb=$(Ni);g(sa.$$.fragment,sb),sb.forEach(s),ob.forEach(s),Dh=i(zc),Il=r(zc,"SPAN",{"data-svelte-h":!0}),h(Il)!=="svelte-11uqjy5"&&(Il.textContent=e_),zc.forEach(s),pc=i(e),R=r(e,"DIV",{class:!0});var be=$(R);g(aa.$$.fragment,be),Oh=i(be),ql=r(be,"P",{"data-svelte-h":!0}),h(ql)!=="svelte-q4kelk"&&(ql.innerHTML=t_),Kh=i(be),Wl=r(be,"P",{"data-svelte-h":!0}),h(Wl)!=="svelte-1gfofcr"&&(Wl.innerHTML=n_),eu=i(be),Nl=r(be,"P",{"data-svelte-h":!0}),h(Nl)!=="svelte-9ybkh"&&(Nl.innerHTML=o_),tu=i(be),Ll=r(be,"P",{"data-svelte-h":!0}),h(Ll)!=="svelte-1pplc4a"&&(Ll.textContent=s_),nu=i(be),Zl=r(be,"UL",{"data-svelte-h":!0}),h(Zl)!=="svelte-1w7z84m"&&(Zl.innerHTML=a_),ou=i(be),Re=r(be,"DIV",{class:!0});var Io=$(Re);g(ra.$$.fragment,Io),su=i(Io),Hl=r(Io,"P",{"data-svelte-h":!0}),h(Hl)!=="svelte-hsqakh"&&(Hl.innerHTML=r_),au=i(Io),g(ho.$$.fragment,Io),ru=i(Io),g(uo.$$.fragment,Io),Io.forEach(s),be.forEach(s),mc=i(e),Bt=r(e,"H2",{class:!0});var Uc=$(Bt);fo=r(Uc,"A",{id:!0,class:!0,href:!0});var ab=$(fo);Li=r(ab,"SPAN",{});var rb=$(Li);g(la.$$.fragment,rb),rb.forEach(s),ab.forEach(s),lu=i(Uc),Bl=r(Uc,"SPAN",{"data-svelte-h":!0}),h(Bl)!=="svelte-1g5rkzi"&&(Bl.textContent=l_),Uc.forEach(s),hc=i(e),V=r(e,"DIV",{class:!0});var Te=$(V);g(ia.$$.fragment,Te),iu=i(Te),Pl=r(Te,"P",{"data-svelte-h":!0}),h(Pl)!=="svelte-1wuvovs"&&(Pl.textContent=i_),du=i(Te),Gl=r(Te,"P",{"data-svelte-h":!0}),h(Gl)!=="svelte-1gfofcr"&&(Gl.innerHTML=d_),cu=i(Te),Rl=r(Te,"P",{"data-svelte-h":!0}),h(Rl)!=="svelte-9ybkh"&&(Rl.innerHTML=c_),pu=i(Te),Vl=r(Te,"P",{"data-svelte-h":!0}),h(Vl)!=="svelte-1pplc4a"&&(Vl.textContent=p_),mu=i(Te),Xl=r(Te,"UL",{"data-svelte-h":!0}),h(Xl)!=="svelte-1w7z84m"&&(Xl.innerHTML=m_),hu=i(Te),Ve=r(Te,"DIV",{class:!0});var qo=$(Ve);g(da.$$.fragment,qo),uu=i(qo),El=r(qo,"P",{"data-svelte-h":!0}),h(El)!=="svelte-hsqakh"&&(El.innerHTML=h_),fu=i(qo),g(go.$$.fragment,qo),gu=i(qo),g(_o.$$.fragment,qo),qo.forEach(s),Te.forEach(s),uc=i(e),Pt=r(e,"H2",{class:!0});var Ic=$(Pt);bo=r(Ic,"A",{id:!0,class:!0,href:!0});var lb=$(bo);Zi=r(lb,"SPAN",{});var ib=$(Zi);g(ca.$$.fragment,ib),ib.forEach(s),lb.forEach(s),_u=i(Ic),Sl=r(Ic,"SPAN",{"data-svelte-h":!0}),h(Sl)!=="svelte-1e5bh9o"&&(Sl.textContent=u_),Ic.forEach(s),fc=i(e),X=r(e,"DIV",{class:!0});var ye=$(X);g(pa.$$.fragment,ye),bu=i(ye),Ql=r(ye,"P",{"data-svelte-h":!0}),h(Ql)!=="svelte-axso2c"&&(Ql.textContent=f_),Tu=i(ye),Yl=r(ye,"P",{"data-svelte-h":!0}),h(Yl)!=="svelte-1gfofcr"&&(Yl.innerHTML=g_),yu=i(ye),Dl=r(ye,"P",{"data-svelte-h":!0}),h(Dl)!=="svelte-9ybkh"&&(Dl.innerHTML=__),vu=i(ye),Ol=r(ye,"P",{"data-svelte-h":!0}),h(Ol)!=="svelte-1pplc4a"&&(Ol.textContent=b_),Mu=i(ye),Kl=r(ye,"UL",{"data-svelte-h":!0}),h(Kl)!=="svelte-1w7z84m"&&(Kl.innerHTML=T_),ku=i(ye),Xe=r(ye,"DIV",{class:!0});var Wo=$(Xe);g(ma.$$.fragment,Wo),wu=i(Wo),ei=r(Wo,"P",{"data-svelte-h":!0}),h(ei)!=="svelte-hsqakh"&&(ei.innerHTML=y_),$u=i(Wo),g(To.$$.fragment,Wo),xu=i(Wo),g(yo.$$.fragment,Wo),Wo.forEach(s),ye.forEach(s),gc=i(e),Gt=r(e,"H2",{class:!0});var qc=$(Gt);vo=r(qc,"A",{id:!0,class:!0,href:!0});var db=$(vo);Hi=r(db,"SPAN",{});var cb=$(Hi);g(ha.$$.fragment,cb),cb.forEach(s),db.forEach(s),Fu=i(qc),ti=r(qc,"SPAN",{"data-svelte-h":!0}),h(ti)!=="svelte-2ncw8e"&&(ti.textContent=v_),qc.forEach(s),_c=i(e),E=r(e,"DIV",{class:!0});var ve=$(E);g(ua.$$.fragment,ve),ju=i(ve),ni=r(ve,"P",{"data-svelte-h":!0}),h(ni)!=="svelte-olqnpn"&&(ni.textContent=M_),Au=i(ve),oi=r(ve,"P",{"data-svelte-h":!0}),h(oi)!=="svelte-1gfofcr"&&(oi.innerHTML=k_),Cu=i(ve),si=r(ve,"P",{"data-svelte-h":!0}),h(si)!=="svelte-9ybkh"&&(si.innerHTML=w_),Ju=i(ve),ai=r(ve,"P",{"data-svelte-h":!0}),h(ai)!=="svelte-1pplc4a"&&(ai.textContent=$_),zu=i(ve),ri=r(ve,"UL",{"data-svelte-h":!0}),h(ri)!=="svelte-1w7z84m"&&(ri.innerHTML=x_),Uu=i(ve),Ee=r(ve,"DIV",{class:!0});var No=$(Ee);g(fa.$$.fragment,No),Iu=i(No),li=r(No,"P",{"data-svelte-h":!0}),h(li)!=="svelte-hsqakh"&&(li.innerHTML=F_),qu=i(No),g(Mo.$$.fragment,No),Wu=i(No),g(ko.$$.fragment,No),No.forEach(s),ve.forEach(s),bc=i(e),Rt=r(e,"H2",{class:!0});var Wc=$(Rt);wo=r(Wc,"A",{id:!0,class:!0,href:!0});var pb=$(wo);Bi=r(pb,"SPAN",{});var mb=$(Bi);g(ga.$$.fragment,mb),mb.forEach(s),pb.forEach(s),Nu=i(Wc),ii=r(Wc,"SPAN",{"data-svelte-h":!0}),h(ii)!=="svelte-vprhkf"&&(ii.textContent=j_),Wc.forEach(s),Tc=i(e),S=r(e,"DIV",{class:!0});var Me=$(S);g(_a.$$.fragment,Me),Lu=i(Me),di=r(Me,"P",{"data-svelte-h":!0}),h(di)!=="svelte-v56eal"&&(di.innerHTML=A_),Zu=i(Me),ci=r(Me,"P",{"data-svelte-h":!0}),h(ci)!=="svelte-1gfofcr"&&(ci.innerHTML=C_),Hu=i(Me),pi=r(Me,"P",{"data-svelte-h":!0}),h(pi)!=="svelte-9ybkh"&&(pi.innerHTML=J_),Bu=i(Me),mi=r(Me,"P",{"data-svelte-h":!0}),h(mi)!=="svelte-1pplc4a"&&(mi.textContent=z_),Pu=i(Me),hi=r(Me,"UL",{"data-svelte-h":!0}),h(hi)!=="svelte-1w7z84m"&&(hi.innerHTML=U_),Gu=i(Me),Se=r(Me,"DIV",{class:!0});var Lo=$(Se);g(ba.$$.fragment,Lo),Ru=i(Lo),ui=r(Lo,"P",{"data-svelte-h":!0}),h(ui)!=="svelte-hsqakh"&&(ui.innerHTML=I_),Vu=i(Lo),g($o.$$.fragment,Lo),Xu=i(Lo),g(xo.$$.fragment,Lo),Lo.forEach(s),Me.forEach(s),yc=i(e),Pi=r(e,"P",{}),$(Pi).forEach(s),this.h()},h(){v(t,"name","hf:doc:metadata"),v(t,"content",JSON.stringify(kT)),v(o,"id","albert"),v(o,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(o,"href","#albert"),v(w,"class","relative group"),v(j,"class","flex flex-wrap space-x-1"),v(Et,"id","overview"),v(Et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Et,"href","#overview"),v(F,"class","relative group"),v(St,"id","documentation-resources"),v(St,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(St,"href","#documentation-resources"),v(_t,"class","relative group"),v(Qt,"id","transformers.AlbertConfig"),v(Qt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Qt,"href","#transformers.AlbertConfig"),v(bt,"class","relative group"),v(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Dt,"id","transformers.AlbertTokenizer"),v(Dt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Dt,"href","#transformers.AlbertTokenizer"),v(Tt,"class","relative group"),v(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Sa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"id","transformers.AlbertTokenizerFast"),v(en,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(en,"href","#transformers.AlbertTokenizerFast"),v(yt,"class","relative group"),v(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nn,"id","transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput"),v(nn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(nn,"href","#transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput"),v(vt,"class","relative group"),v(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(on,"id","transformers.AlbertModel"),v(on,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(on,"href","#transformers.AlbertModel"),v(wt,"class","relative group"),v(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rn,"id","transformers.AlbertForPreTraining"),v(rn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(rn,"href","#transformers.AlbertForPreTraining"),v($t,"class","relative group"),v(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cn,"id","transformers.AlbertForMaskedLM"),v(cn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(cn,"href","#transformers.AlbertForMaskedLM"),v(xt,"class","relative group"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(un,"id","transformers.AlbertForSequenceClassification"),v(un,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(un,"href","#transformers.AlbertForSequenceClassification"),v(Ft,"class","relative group"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bn,"id","transformers.AlbertForMultipleChoice"),v(bn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(bn,"href","#transformers.AlbertForMultipleChoice"),v(jt,"class","relative group"),v(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vn,"id","transformers.AlbertForTokenClassification"),v(vn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(vn,"href","#transformers.AlbertForTokenClassification"),v(At,"class","relative group"),v(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wn,"id","transformers.AlbertForQuestionAnswering"),v(wn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(wn,"href","#transformers.AlbertForQuestionAnswering"),v(Ct,"class","relative group"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fn,"id","transformers.TFAlbertModel"),v(Fn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Fn,"href","#transformers.TFAlbertModel"),v(Jt,"class","relative group"),v(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jn,"id","transformers.TFAlbertForPreTraining"),v(Jn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Jn,"href","#transformers.TFAlbertForPreTraining"),v(zt,"class","relative group"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qn,"id","transformers.TFAlbertForMaskedLM"),v(qn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(qn,"href","#transformers.TFAlbertForMaskedLM"),v(Ut,"class","relative group"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hn,"id","transformers.TFAlbertForSequenceClassification"),v(Hn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Hn,"href","#transformers.TFAlbertForSequenceClassification"),v(It,"class","relative group"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vn,"id","transformers.TFAlbertForMultipleChoice"),v(Vn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Vn,"href","#transformers.TFAlbertForMultipleChoice"),v(qt,"class","relative group"),v(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qn,"id","transformers.TFAlbertForTokenClassification"),v(Qn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(Qn,"href","#transformers.TFAlbertForTokenClassification"),v(Wt,"class","relative group"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(eo,"id","transformers.TFAlbertForQuestionAnswering"),v(eo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(eo,"href","#transformers.TFAlbertForQuestionAnswering"),v(Nt,"class","relative group"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ao,"id","transformers.FlaxAlbertModel"),v(ao,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(ao,"href","#transformers.FlaxAlbertModel"),v(Lt,"class","relative group"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(io,"id","transformers.FlaxAlbertForPreTraining"),v(io,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(io,"href","#transformers.FlaxAlbertForPreTraining"),v(Zt,"class","relative group"),v(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mo,"id","transformers.FlaxAlbertForMaskedLM"),v(mo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(mo,"href","#transformers.FlaxAlbertForMaskedLM"),v(Ht,"class","relative group"),v(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fo,"id","transformers.FlaxAlbertForSequenceClassification"),v(fo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(fo,"href","#transformers.FlaxAlbertForSequenceClassification"),v(Bt,"class","relative group"),v(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bo,"id","transformers.FlaxAlbertForMultipleChoice"),v(bo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(bo,"href","#transformers.FlaxAlbertForMultipleChoice"),v(Pt,"class","relative group"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vo,"id","transformers.FlaxAlbertForTokenClassification"),v(vo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(vo,"href","#transformers.FlaxAlbertForTokenClassification"),v(Gt,"class","relative group"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wo,"id","transformers.FlaxAlbertForQuestionAnswering"),v(wo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),v(wo,"href","#transformers.FlaxAlbertForQuestionAnswering"),v(Rt,"class","relative group"),v(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,m){n(document.head,t),p(e,u,m),p(e,d,m),p(e,c,m),p(e,w,m),n(w,o),n(o,M),_(W,M,null),n(w,U),n(w,A),p(e,z,m),p(e,j,m),p(e,k,m),p(e,F,m),n(F,Et),n(Et,fi),_(Zo,fi,null),n(F,Nc),n(F,qa),p(e,ud,m),p(e,Ho,m),p(e,fd,m),p(e,Bo,m),p(e,gd,m),p(e,Po,m),p(e,_d,m),p(e,Go,m),p(e,bd,m),p(e,Ro,m),p(e,Td,m),p(e,Vo,m),p(e,yd,m),p(e,Xo,m),p(e,vd,m),p(e,_t,m),n(_t,St),n(St,gi),_(Eo,gi,null),n(_t,Lc),n(_t,Wa),p(e,Md,m),p(e,So,m),p(e,kd,m),p(e,bt,m),n(bt,Qt),n(Qt,_i),_(Qo,_i,null),n(bt,Zc),n(bt,Na),p(e,wd,m),p(e,ke,m),_(Yo,ke,null),n(ke,Hc),n(ke,La),n(ke,Bc),n(ke,Za),n(ke,Pc),_(Yt,ke,null),p(e,$d,m),p(e,Tt,m),n(Tt,Dt),n(Dt,bi),_(Do,bi,null),n(Tt,Gc),n(Tt,Ha),p(e,xd,m),p(e,B,m),_(Oo,B,null),n(B,Rc),n(B,Ba),n(B,Vc),n(B,Pa),n(B,Xc),n(B,dt),_(Ko,dt,null),n(dt,Ec),n(dt,Ga),n(dt,Sc),n(dt,Ra),n(B,Qc),n(B,Ot),_(es,Ot,null),n(Ot,Yc),n(Ot,Va),n(B,Dc),n(B,ze),_(ts,ze,null),n(ze,Oc),n(ze,Xa),n(ze,Kc),_(Kt,ze,null),n(ze,ep),n(ze,Ea),n(B,tp),n(B,Sa),_(ns,Sa,null),p(e,Fd,m),p(e,yt,m),n(yt,en),n(en,Ti),_(os,Ti,null),n(yt,np),n(yt,Qa),p(e,jd,m),p(e,we,m),_(ss,we,null),n(we,op),n(we,Ya),n(we,sp),n(we,ct),_(as,ct,null),n(ct,ap),n(ct,Da),n(ct,rp),n(ct,Oa),n(we,lp),n(we,Ue),_(rs,Ue,null),n(Ue,ip),n(Ue,Ka),n(Ue,dp),_(tn,Ue,null),n(Ue,cp),n(Ue,er),p(e,Ad,m),p(e,vt,m),n(vt,nn),n(nn,yi),_(ls,yi,null),n(vt,pp),n(vt,tr),p(e,Cd,m),p(e,Mt,m),_(is,Mt,null),n(Mt,mp),n(Mt,nr),p(e,Jd,m),p(e,kt,m),_(ds,kt,null),n(kt,hp),n(kt,or),p(e,zd,m),p(e,wt,m),n(wt,on),n(on,vi),_(cs,vi,null),n(wt,up),n(wt,sr),p(e,Ud,m),p(e,oe,m),_(ps,oe,null),n(oe,fp),n(oe,ar),n(oe,gp),n(oe,rr),n(oe,_p),n(oe,lr),n(oe,bp),n(oe,Ie),_(ms,Ie,null),n(Ie,Tp),n(Ie,ir),n(Ie,yp),_(sn,Ie,null),n(Ie,vp),_(an,Ie,null),p(e,Id,m),p(e,$t,m),n($t,rn),n(rn,Mi),_(hs,Mi,null),n($t,Mp),n($t,dr),p(e,qd,m),p(e,se,m),_(us,se,null),n(se,kp),n(se,cr),n(se,wp),n(se,pr),n(se,$p),n(se,mr),n(se,xp),n(se,qe),_(fs,qe,null),n(qe,Fp),n(qe,hr),n(qe,jp),_(ln,qe,null),n(qe,Ap),_(dn,qe,null),p(e,Wd,m),p(e,xt,m),n(xt,cn),n(cn,ki),_(gs,ki,null),n(xt,Cp),n(xt,ur),p(e,Nd,m),p(e,ae,m),_(_s,ae,null),n(ae,Jp),n(ae,fr),n(ae,zp),n(ae,gr),n(ae,Up),n(ae,_r),n(ae,Ip),n(ae,ce),_(bs,ce,null),n(ce,qp),n(ce,br),n(ce,Wp),_(pn,ce,null),n(ce,Np),_(mn,ce,null),n(ce,Lp),_(hn,ce,null),p(e,Ld,m),p(e,Ft,m),n(Ft,un),n(un,wi),_(Ts,wi,null),n(Ft,Zp),n(Ft,Tr),p(e,Zd,m),p(e,re,m),_(ys,re,null),n(re,Hp),n(re,yr),n(re,Bp),n(re,vr),n(re,Pp),n(re,Mr),n(re,Gp),n(re,pe),_(vs,pe,null),n(pe,Rp),n(pe,kr),n(pe,Vp),_(fn,pe,null),n(pe,Xp),_(gn,pe,null),n(pe,Ep),_(_n,pe,null),p(e,Hd,m),p(e,jt,m),n(jt,bn),n(bn,$i),_(Ms,$i,null),n(jt,Sp),n(jt,wr),p(e,Bd,m),p(e,le,m),_(ks,le,null),n(le,Qp),n(le,$r),n(le,Yp),n(le,xr),n(le,Dp),n(le,Fr),n(le,Op),n(le,We),_(ws,We,null),n(We,Kp),n(We,jr),n(We,em),_(Tn,We,null),n(We,tm),_(yn,We,null),p(e,Pd,m),p(e,At,m),n(At,vn),n(vn,xi),_($s,xi,null),n(At,nm),n(At,Ar),p(e,Gd,m),p(e,ie,m),_(xs,ie,null),n(ie,om),n(ie,Cr),n(ie,sm),n(ie,Jr),n(ie,am),n(ie,zr),n(ie,rm),n(ie,Ne),_(Fs,Ne,null),n(Ne,lm),n(Ne,Ur),n(Ne,im),_(Mn,Ne,null),n(Ne,dm),_(kn,Ne,null),p(e,Rd,m),p(e,Ct,m),n(Ct,wn),n(wn,Fi),_(js,Fi,null),n(Ct,cm),n(Ct,Ir),p(e,Vd,m),p(e,de,m),_(As,de,null),n(de,pm),n(de,qr),n(de,mm),n(de,Wr),n(de,hm),n(de,Nr),n(de,um),n(de,Le),_(Cs,Le,null),n(Le,fm),n(Le,Lr),n(Le,gm),_($n,Le,null),n(Le,_m),_(xn,Le,null),p(e,Xd,m),p(e,Jt,m),n(Jt,Fn),n(Fn,ji),_(Js,ji,null),n(Jt,bm),n(Jt,Zr),p(e,Ed,m),p(e,Q,m),_(zs,Q,null),n(Q,Tm),n(Q,Hr),n(Q,ym),n(Q,Br),n(Q,vm),n(Q,Pr),n(Q,Mm),_(jn,Q,null),n(Q,km),n(Q,Ze),_(Us,Ze,null),n(Ze,wm),n(Ze,Gr),n(Ze,$m),_(An,Ze,null),n(Ze,xm),_(Cn,Ze,null),p(e,Sd,m),p(e,zt,m),n(zt,Jn),n(Jn,Ai),_(Is,Ai,null),n(zt,Fm),n(zt,Rr),p(e,Qd,m),p(e,Y,m),_(qs,Y,null),n(Y,jm),n(Y,Vr),n(Y,Am),n(Y,Xr),n(Y,Cm),n(Y,Er),n(Y,Jm),_(zn,Y,null),n(Y,zm),n(Y,He),_(Ws,He,null),n(He,Um),n(He,Sr),n(He,Im),_(Un,He,null),n(He,qm),_(In,He,null),p(e,Yd,m),p(e,Ut,m),n(Ut,qn),n(qn,Ci),_(Ns,Ci,null),n(Ut,Wm),n(Ut,Qr),p(e,Dd,m),p(e,D,m),_(Ls,D,null),n(D,Nm),n(D,Yr),n(D,Lm),n(D,Dr),n(D,Zm),n(D,Or),n(D,Hm),_(Wn,D,null),n(D,Bm),n(D,me),_(Zs,me,null),n(me,Pm),n(me,Kr),n(me,Gm),_(Nn,me,null),n(me,Rm),_(Ln,me,null),n(me,Vm),_(Zn,me,null),p(e,Od,m),p(e,It,m),n(It,Hn),n(Hn,Ji),_(Hs,Ji,null),n(It,Xm),n(It,el),p(e,Kd,m),p(e,O,m),_(Bs,O,null),n(O,Em),n(O,tl),n(O,Sm),n(O,nl),n(O,Qm),n(O,ol),n(O,Ym),_(Bn,O,null),n(O,Dm),n(O,he),_(Ps,he,null),n(he,Om),n(he,sl),n(he,Km),_(Pn,he,null),n(he,eh),_(Gn,he,null),n(he,th),_(Rn,he,null),p(e,ec,m),p(e,qt,m),n(qt,Vn),n(Vn,zi),_(Gs,zi,null),n(qt,nh),n(qt,al),p(e,tc,m),p(e,K,m),_(Rs,K,null),n(K,oh),n(K,rl),n(K,sh),n(K,ll),n(K,ah),n(K,il),n(K,rh),_(Xn,K,null),n(K,lh),n(K,Be),_(Vs,Be,null),n(Be,ih),n(Be,dl),n(Be,dh),_(En,Be,null),n(Be,ch),_(Sn,Be,null),p(e,nc,m),p(e,Wt,m),n(Wt,Qn),n(Qn,Ui),_(Xs,Ui,null),n(Wt,ph),n(Wt,cl),p(e,oc,m),p(e,ee,m),_(Es,ee,null),n(ee,mh),n(ee,pl),n(ee,hh),n(ee,ml),n(ee,uh),n(ee,hl),n(ee,fh),_(Yn,ee,null),n(ee,gh),n(ee,ue),_(Ss,ue,null),n(ue,_h),n(ue,ul),n(ue,bh),_(Dn,ue,null),n(ue,Th),_(On,ue,null),n(ue,yh),_(Kn,ue,null),p(e,sc,m),p(e,Nt,m),n(Nt,eo),n(eo,Ii),_(Qs,Ii,null),n(Nt,vh),n(Nt,fl),p(e,ac,m),p(e,te,m),_(Ys,te,null),n(te,Mh),n(te,gl),n(te,kh),n(te,_l),n(te,wh),n(te,bl),n(te,$h),_(to,te,null),n(te,xh),n(te,fe),_(Ds,fe,null),n(fe,Fh),n(fe,Tl),n(fe,jh),_(no,fe,null),n(fe,Ah),_(oo,fe,null),n(fe,Ch),_(so,fe,null),p(e,rc,m),p(e,Lt,m),n(Lt,ao),n(ao,qi),_(Os,qi,null),n(Lt,Jh),n(Lt,yl),p(e,lc,m),p(e,P,m),_(Ks,P,null),n(P,zh),n(P,vl),n(P,Uh),n(P,Ml),n(P,Ih),n(P,kl),n(P,qh),n(P,wl),n(P,Wh),n(P,$l),n(P,Nh),n(P,Pe),_(ea,Pe,null),n(Pe,Lh),n(Pe,xl),n(Pe,Zh),_(ro,Pe,null),n(Pe,Hh),_(lo,Pe,null),p(e,ic,m),p(e,Zt,m),n(Zt,io),n(io,Wi),_(ta,Wi,null),n(Zt,Bh),n(Zt,Fl),p(e,dc,m),p(e,G,m),_(na,G,null),n(G,Ph),n(G,jl),n(G,Gh),n(G,Al),n(G,Rh),n(G,Cl),n(G,Vh),n(G,Jl),n(G,Xh),n(G,zl),n(G,Eh),n(G,Ge),_(oa,Ge,null),n(Ge,Sh),n(Ge,Ul),n(Ge,Qh),_(co,Ge,null),n(Ge,Yh),_(po,Ge,null),p(e,cc,m),p(e,Ht,m),n(Ht,mo),n(mo,Ni),_(sa,Ni,null),n(Ht,Dh),n(Ht,Il),p(e,pc,m),p(e,R,m),_(aa,R,null),n(R,Oh),n(R,ql),n(R,Kh),n(R,Wl),n(R,eu),n(R,Nl),n(R,tu),n(R,Ll),n(R,nu),n(R,Zl),n(R,ou),n(R,Re),_(ra,Re,null),n(Re,su),n(Re,Hl),n(Re,au),_(ho,Re,null),n(Re,ru),_(uo,Re,null),p(e,mc,m),p(e,Bt,m),n(Bt,fo),n(fo,Li),_(la,Li,null),n(Bt,lu),n(Bt,Bl),p(e,hc,m),p(e,V,m),_(ia,V,null),n(V,iu),n(V,Pl),n(V,du),n(V,Gl),n(V,cu),n(V,Rl),n(V,pu),n(V,Vl),n(V,mu),n(V,Xl),n(V,hu),n(V,Ve),_(da,Ve,null),n(Ve,uu),n(Ve,El),n(Ve,fu),_(go,Ve,null),n(Ve,gu),_(_o,Ve,null),p(e,uc,m),p(e,Pt,m),n(Pt,bo),n(bo,Zi),_(ca,Zi,null),n(Pt,_u),n(Pt,Sl),p(e,fc,m),p(e,X,m),_(pa,X,null),n(X,bu),n(X,Ql),n(X,Tu),n(X,Yl),n(X,yu),n(X,Dl),n(X,vu),n(X,Ol),n(X,Mu),n(X,Kl),n(X,ku),n(X,Xe),_(ma,Xe,null),n(Xe,wu),n(Xe,ei),n(Xe,$u),_(To,Xe,null),n(Xe,xu),_(yo,Xe,null),p(e,gc,m),p(e,Gt,m),n(Gt,vo),n(vo,Hi),_(ha,Hi,null),n(Gt,Fu),n(Gt,ti),p(e,_c,m),p(e,E,m),_(ua,E,null),n(E,ju),n(E,ni),n(E,Au),n(E,oi),n(E,Cu),n(E,si),n(E,Ju),n(E,ai),n(E,zu),n(E,ri),n(E,Uu),n(E,Ee),_(fa,Ee,null),n(Ee,Iu),n(Ee,li),n(Ee,qu),_(Mo,Ee,null),n(Ee,Wu),_(ko,Ee,null),p(e,bc,m),p(e,Rt,m),n(Rt,wo),n(wo,Bi),_(ga,Bi,null),n(Rt,Nu),n(Rt,ii),p(e,Tc,m),p(e,S,m),_(_a,S,null),n(S,Lu),n(S,di),n(S,Zu),n(S,ci),n(S,Hu),n(S,pi),n(S,Bu),n(S,mi),n(S,Pu),n(S,hi),n(S,Gu),n(S,Se),_(ba,Se,null),n(Se,Ru),n(Se,ui),n(Se,Vu),_($o,Se,null),n(Se,Xu),_(xo,Se,null),p(e,yc,m),p(e,Pi,m),vc=!0},p(e,[m]){const Ta={};m&2&&(Ta.$$scope={dirty:m,ctx:e}),Yt.$set(Ta);const Gi={};m&2&&(Gi.$$scope={dirty:m,ctx:e}),Kt.$set(Gi);const Ri={};m&2&&(Ri.$$scope={dirty:m,ctx:e}),tn.$set(Ri);const ya={};m&2&&(ya.$$scope={dirty:m,ctx:e}),sn.$set(ya);const Vi={};m&2&&(Vi.$$scope={dirty:m,ctx:e}),an.$set(Vi);const Xi={};m&2&&(Xi.$$scope={dirty:m,ctx:e}),ln.$set(Xi);const va={};m&2&&(va.$$scope={dirty:m,ctx:e}),dn.$set(va);const Ei={};m&2&&(Ei.$$scope={dirty:m,ctx:e}),pn.$set(Ei);const Si={};m&2&&(Si.$$scope={dirty:m,ctx:e}),mn.$set(Si);const Ma={};m&2&&(Ma.$$scope={dirty:m,ctx:e}),hn.$set(Ma);const Qi={};m&2&&(Qi.$$scope={dirty:m,ctx:e}),fn.$set(Qi);const Yi={};m&2&&(Yi.$$scope={dirty:m,ctx:e}),gn.$set(Yi);const nt={};m&2&&(nt.$$scope={dirty:m,ctx:e}),_n.$set(nt);const ka={};m&2&&(ka.$$scope={dirty:m,ctx:e}),Tn.$set(ka);const Di={};m&2&&(Di.$$scope={dirty:m,ctx:e}),yn.$set(Di);const Oi={};m&2&&(Oi.$$scope={dirty:m,ctx:e}),Mn.$set(Oi);const ne={};m&2&&(ne.$$scope={dirty:m,ctx:e}),kn.$set(ne);const Vt={};m&2&&(Vt.$$scope={dirty:m,ctx:e}),$n.$set(Vt);const wa={};m&2&&(wa.$$scope={dirty:m,ctx:e}),xn.$set(wa);const ot={};m&2&&(ot.$$scope={dirty:m,ctx:e}),jn.$set(ot);const Ki={};m&2&&(Ki.$$scope={dirty:m,ctx:e}),An.$set(Ki);const $a={};m&2&&($a.$$scope={dirty:m,ctx:e}),Cn.$set($a);const ed={};m&2&&(ed.$$scope={dirty:m,ctx:e}),zn.$set(ed);const td={};m&2&&(td.$$scope={dirty:m,ctx:e}),Un.$set(td);const st={};m&2&&(st.$$scope={dirty:m,ctx:e}),In.$set(st);const Xt={};m&2&&(Xt.$$scope={dirty:m,ctx:e}),Wn.$set(Xt);const at={};m&2&&(at.$$scope={dirty:m,ctx:e}),Nn.$set(at);const xa={};m&2&&(xa.$$scope={dirty:m,ctx:e}),Ln.$set(xa);const nd={};m&2&&(nd.$$scope={dirty:m,ctx:e}),Zn.$set(nd);const od={};m&2&&(od.$$scope={dirty:m,ctx:e}),Bn.$set(od);const Fa={};m&2&&(Fa.$$scope={dirty:m,ctx:e}),Pn.$set(Fa);const ja={};m&2&&(ja.$$scope={dirty:m,ctx:e}),Gn.$set(ja);const Aa={};m&2&&(Aa.$$scope={dirty:m,ctx:e}),Rn.$set(Aa);const sd={};m&2&&(sd.$$scope={dirty:m,ctx:e}),Xn.$set(sd);const ad={};m&2&&(ad.$$scope={dirty:m,ctx:e}),En.$set(ad);const $e={};m&2&&($e.$$scope={dirty:m,ctx:e}),Sn.$set($e);const rt={};m&2&&(rt.$$scope={dirty:m,ctx:e}),Yn.$set(rt);const Ca={};m&2&&(Ca.$$scope={dirty:m,ctx:e}),Dn.$set(Ca);const rd={};m&2&&(rd.$$scope={dirty:m,ctx:e}),On.$set(rd);const ld={};m&2&&(ld.$$scope={dirty:m,ctx:e}),Kn.$set(ld);const xe={};m&2&&(xe.$$scope={dirty:m,ctx:e}),to.$set(xe);const lt={};m&2&&(lt.$$scope={dirty:m,ctx:e}),no.$set(lt);const Ja={};m&2&&(Ja.$$scope={dirty:m,ctx:e}),oo.$set(Ja);const id={};m&2&&(id.$$scope={dirty:m,ctx:e}),so.$set(id);const dd={};m&2&&(dd.$$scope={dirty:m,ctx:e}),ro.$set(dd);const Fe={};m&2&&(Fe.$$scope={dirty:m,ctx:e}),lo.$set(Fe);const je={};m&2&&(je.$$scope={dirty:m,ctx:e}),co.$set(je);const za={};m&2&&(za.$$scope={dirty:m,ctx:e}),po.$set(za);const cd={};m&2&&(cd.$$scope={dirty:m,ctx:e}),ho.$set(cd);const pd={};m&2&&(pd.$$scope={dirty:m,ctx:e}),uo.$set(pd);const Ae={};m&2&&(Ae.$$scope={dirty:m,ctx:e}),go.$set(Ae);const Ce={};m&2&&(Ce.$$scope={dirty:m,ctx:e}),_o.$set(Ce);const Ua={};m&2&&(Ua.$$scope={dirty:m,ctx:e}),To.$set(Ua);const md={};m&2&&(md.$$scope={dirty:m,ctx:e}),yo.$set(md);const hd={};m&2&&(hd.$$scope={dirty:m,ctx:e}),Mo.$set(hd);const Je={};m&2&&(Je.$$scope={dirty:m,ctx:e}),ko.$set(Je);const it={};m&2&&(it.$$scope={dirty:m,ctx:e}),$o.$set(it);const Ia={};m&2&&(Ia.$$scope={dirty:m,ctx:e}),xo.$set(Ia)},i(e){vc||(b(W.$$.fragment,e),b(Zo.$$.fragment,e),b(Eo.$$.fragment,e),b(Qo.$$.fragment,e),b(Yo.$$.fragment,e),b(Yt.$$.fragment,e),b(Do.$$.fragment,e),b(Oo.$$.fragment,e),b(Ko.$$.fragment,e),b(es.$$.fragment,e),b(ts.$$.fragment,e),b(Kt.$$.fragment,e),b(ns.$$.fragment,e),b(os.$$.fragment,e),b(ss.$$.fragment,e),b(as.$$.fragment,e),b(rs.$$.fragment,e),b(tn.$$.fragment,e),b(ls.$$.fragment,e),b(is.$$.fragment,e),b(ds.$$.fragment,e),b(cs.$$.fragment,e),b(ps.$$.fragment,e),b(ms.$$.fragment,e),b(sn.$$.fragment,e),b(an.$$.fragment,e),b(hs.$$.fragment,e),b(us.$$.fragment,e),b(fs.$$.fragment,e),b(ln.$$.fragment,e),b(dn.$$.fragment,e),b(gs.$$.fragment,e),b(_s.$$.fragment,e),b(bs.$$.fragment,e),b(pn.$$.fragment,e),b(mn.$$.fragment,e),b(hn.$$.fragment,e),b(Ts.$$.fragment,e),b(ys.$$.fragment,e),b(vs.$$.fragment,e),b(fn.$$.fragment,e),b(gn.$$.fragment,e),b(_n.$$.fragment,e),b(Ms.$$.fragment,e),b(ks.$$.fragment,e),b(ws.$$.fragment,e),b(Tn.$$.fragment,e),b(yn.$$.fragment,e),b($s.$$.fragment,e),b(xs.$$.fragment,e),b(Fs.$$.fragment,e),b(Mn.$$.fragment,e),b(kn.$$.fragment,e),b(js.$$.fragment,e),b(As.$$.fragment,e),b(Cs.$$.fragment,e),b($n.$$.fragment,e),b(xn.$$.fragment,e),b(Js.$$.fragment,e),b(zs.$$.fragment,e),b(jn.$$.fragment,e),b(Us.$$.fragment,e),b(An.$$.fragment,e),b(Cn.$$.fragment,e),b(Is.$$.fragment,e),b(qs.$$.fragment,e),b(zn.$$.fragment,e),b(Ws.$$.fragment,e),b(Un.$$.fragment,e),b(In.$$.fragment,e),b(Ns.$$.fragment,e),b(Ls.$$.fragment,e),b(Wn.$$.fragment,e),b(Zs.$$.fragment,e),b(Nn.$$.fragment,e),b(Ln.$$.fragment,e),b(Zn.$$.fragment,e),b(Hs.$$.fragment,e),b(Bs.$$.fragment,e),b(Bn.$$.fragment,e),b(Ps.$$.fragment,e),b(Pn.$$.fragment,e),b(Gn.$$.fragment,e),b(Rn.$$.fragment,e),b(Gs.$$.fragment,e),b(Rs.$$.fragment,e),b(Xn.$$.fragment,e),b(Vs.$$.fragment,e),b(En.$$.fragment,e),b(Sn.$$.fragment,e),b(Xs.$$.fragment,e),b(Es.$$.fragment,e),b(Yn.$$.fragment,e),b(Ss.$$.fragment,e),b(Dn.$$.fragment,e),b(On.$$.fragment,e),b(Kn.$$.fragment,e),b(Qs.$$.fragment,e),b(Ys.$$.fragment,e),b(to.$$.fragment,e),b(Ds.$$.fragment,e),b(no.$$.fragment,e),b(oo.$$.fragment,e),b(so.$$.fragment,e),b(Os.$$.fragment,e),b(Ks.$$.fragment,e),b(ea.$$.fragment,e),b(ro.$$.fragment,e),b(lo.$$.fragment,e),b(ta.$$.fragment,e),b(na.$$.fragment,e),b(oa.$$.fragment,e),b(co.$$.fragment,e),b(po.$$.fragment,e),b(sa.$$.fragment,e),b(aa.$$.fragment,e),b(ra.$$.fragment,e),b(ho.$$.fragment,e),b(uo.$$.fragment,e),b(la.$$.fragment,e),b(ia.$$.fragment,e),b(da.$$.fragment,e),b(go.$$.fragment,e),b(_o.$$.fragment,e),b(ca.$$.fragment,e),b(pa.$$.fragment,e),b(ma.$$.fragment,e),b(To.$$.fragment,e),b(yo.$$.fragment,e),b(ha.$$.fragment,e),b(ua.$$.fragment,e),b(fa.$$.fragment,e),b(Mo.$$.fragment,e),b(ko.$$.fragment,e),b(ga.$$.fragment,e),b(_a.$$.fragment,e),b(ba.$$.fragment,e),b($o.$$.fragment,e),b(xo.$$.fragment,e),vc=!0)},o(e){T(W.$$.fragment,e),T(Zo.$$.fragment,e),T(Eo.$$.fragment,e),T(Qo.$$.fragment,e),T(Yo.$$.fragment,e),T(Yt.$$.fragment,e),T(Do.$$.fragment,e),T(Oo.$$.fragment,e),T(Ko.$$.fragment,e),T(es.$$.fragment,e),T(ts.$$.fragment,e),T(Kt.$$.fragment,e),T(ns.$$.fragment,e),T(os.$$.fragment,e),T(ss.$$.fragment,e),T(as.$$.fragment,e),T(rs.$$.fragment,e),T(tn.$$.fragment,e),T(ls.$$.fragment,e),T(is.$$.fragment,e),T(ds.$$.fragment,e),T(cs.$$.fragment,e),T(ps.$$.fragment,e),T(ms.$$.fragment,e),T(sn.$$.fragment,e),T(an.$$.fragment,e),T(hs.$$.fragment,e),T(us.$$.fragment,e),T(fs.$$.fragment,e),T(ln.$$.fragment,e),T(dn.$$.fragment,e),T(gs.$$.fragment,e),T(_s.$$.fragment,e),T(bs.$$.fragment,e),T(pn.$$.fragment,e),T(mn.$$.fragment,e),T(hn.$$.fragment,e),T(Ts.$$.fragment,e),T(ys.$$.fragment,e),T(vs.$$.fragment,e),T(fn.$$.fragment,e),T(gn.$$.fragment,e),T(_n.$$.fragment,e),T(Ms.$$.fragment,e),T(ks.$$.fragment,e),T(ws.$$.fragment,e),T(Tn.$$.fragment,e),T(yn.$$.fragment,e),T($s.$$.fragment,e),T(xs.$$.fragment,e),T(Fs.$$.fragment,e),T(Mn.$$.fragment,e),T(kn.$$.fragment,e),T(js.$$.fragment,e),T(As.$$.fragment,e),T(Cs.$$.fragment,e),T($n.$$.fragment,e),T(xn.$$.fragment,e),T(Js.$$.fragment,e),T(zs.$$.fragment,e),T(jn.$$.fragment,e),T(Us.$$.fragment,e),T(An.$$.fragment,e),T(Cn.$$.fragment,e),T(Is.$$.fragment,e),T(qs.$$.fragment,e),T(zn.$$.fragment,e),T(Ws.$$.fragment,e),T(Un.$$.fragment,e),T(In.$$.fragment,e),T(Ns.$$.fragment,e),T(Ls.$$.fragment,e),T(Wn.$$.fragment,e),T(Zs.$$.fragment,e),T(Nn.$$.fragment,e),T(Ln.$$.fragment,e),T(Zn.$$.fragment,e),T(Hs.$$.fragment,e),T(Bs.$$.fragment,e),T(Bn.$$.fragment,e),T(Ps.$$.fragment,e),T(Pn.$$.fragment,e),T(Gn.$$.fragment,e),T(Rn.$$.fragment,e),T(Gs.$$.fragment,e),T(Rs.$$.fragment,e),T(Xn.$$.fragment,e),T(Vs.$$.fragment,e),T(En.$$.fragment,e),T(Sn.$$.fragment,e),T(Xs.$$.fragment,e),T(Es.$$.fragment,e),T(Yn.$$.fragment,e),T(Ss.$$.fragment,e),T(Dn.$$.fragment,e),T(On.$$.fragment,e),T(Kn.$$.fragment,e),T(Qs.$$.fragment,e),T(Ys.$$.fragment,e),T(to.$$.fragment,e),T(Ds.$$.fragment,e),T(no.$$.fragment,e),T(oo.$$.fragment,e),T(so.$$.fragment,e),T(Os.$$.fragment,e),T(Ks.$$.fragment,e),T(ea.$$.fragment,e),T(ro.$$.fragment,e),T(lo.$$.fragment,e),T(ta.$$.fragment,e),T(na.$$.fragment,e),T(oa.$$.fragment,e),T(co.$$.fragment,e),T(po.$$.fragment,e),T(sa.$$.fragment,e),T(aa.$$.fragment,e),T(ra.$$.fragment,e),T(ho.$$.fragment,e),T(uo.$$.fragment,e),T(la.$$.fragment,e),T(ia.$$.fragment,e),T(da.$$.fragment,e),T(go.$$.fragment,e),T(_o.$$.fragment,e),T(ca.$$.fragment,e),T(pa.$$.fragment,e),T(ma.$$.fragment,e),T(To.$$.fragment,e),T(yo.$$.fragment,e),T(ha.$$.fragment,e),T(ua.$$.fragment,e),T(fa.$$.fragment,e),T(Mo.$$.fragment,e),T(ko.$$.fragment,e),T(ga.$$.fragment,e),T(_a.$$.fragment,e),T(ba.$$.fragment,e),T($o.$$.fragment,e),T(xo.$$.fragment,e),vc=!1},d(e){e&&(s(u),s(d),s(c),s(w),s(z),s(j),s(k),s(F),s(ud),s(Ho),s(fd),s(Bo),s(gd),s(Po),s(_d),s(Go),s(bd),s(Ro),s(Td),s(Vo),s(yd),s(Xo),s(vd),s(_t),s(Md),s(So),s(kd),s(bt),s(wd),s(ke),s($d),s(Tt),s(xd),s(B),s(Fd),s(yt),s(jd),s(we),s(Ad),s(vt),s(Cd),s(Mt),s(Jd),s(kt),s(zd),s(wt),s(Ud),s(oe),s(Id),s($t),s(qd),s(se),s(Wd),s(xt),s(Nd),s(ae),s(Ld),s(Ft),s(Zd),s(re),s(Hd),s(jt),s(Bd),s(le),s(Pd),s(At),s(Gd),s(ie),s(Rd),s(Ct),s(Vd),s(de),s(Xd),s(Jt),s(Ed),s(Q),s(Sd),s(zt),s(Qd),s(Y),s(Yd),s(Ut),s(Dd),s(D),s(Od),s(It),s(Kd),s(O),s(ec),s(qt),s(tc),s(K),s(nc),s(Wt),s(oc),s(ee),s(sc),s(Nt),s(ac),s(te),s(rc),s(Lt),s(lc),s(P),s(ic),s(Zt),s(dc),s(G),s(cc),s(Ht),s(pc),s(R),s(mc),s(Bt),s(hc),s(V),s(uc),s(Pt),s(fc),s(X),s(gc),s(Gt),s(_c),s(E),s(bc),s(Rt),s(Tc),s(S),s(yc),s(Pi)),s(t),y(W),y(Zo),y(Eo),y(Qo),y(Yo),y(Yt),y(Do),y(Oo),y(Ko),y(es),y(ts),y(Kt),y(ns),y(os),y(ss),y(as),y(rs),y(tn),y(ls),y(is),y(ds),y(cs),y(ps),y(ms),y(sn),y(an),y(hs),y(us),y(fs),y(ln),y(dn),y(gs),y(_s),y(bs),y(pn),y(mn),y(hn),y(Ts),y(ys),y(vs),y(fn),y(gn),y(_n),y(Ms),y(ks),y(ws),y(Tn),y(yn),y($s),y(xs),y(Fs),y(Mn),y(kn),y(js),y(As),y(Cs),y($n),y(xn),y(Js),y(zs),y(jn),y(Us),y(An),y(Cn),y(Is),y(qs),y(zn),y(Ws),y(Un),y(In),y(Ns),y(Ls),y(Wn),y(Zs),y(Nn),y(Ln),y(Zn),y(Hs),y(Bs),y(Bn),y(Ps),y(Pn),y(Gn),y(Rn),y(Gs),y(Rs),y(Xn),y(Vs),y(En),y(Sn),y(Xs),y(Es),y(Yn),y(Ss),y(Dn),y(On),y(Kn),y(Qs),y(Ys),y(to),y(Ds),y(no),y(oo),y(so),y(Os),y(Ks),y(ea),y(ro),y(lo),y(ta),y(na),y(oa),y(co),y(po),y(sa),y(aa),y(ra),y(ho),y(uo),y(la),y(ia),y(da),y(go),y(_o),y(ca),y(pa),y(ma),y(To),y(yo),y(ha),y(ua),y(fa),y(Mo),y(ko),y(ga),y(_a),y(ba),y($o),y(xo)}}}const kT={local:"albert",sections:[{local:"overview",title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.AlbertConfig",title:"AlbertConfig"},{local:"transformers.AlbertTokenizer",title:"AlbertTokenizer"},{local:"transformers.AlbertTokenizerFast",title:"AlbertTokenizerFast"},{local:"transformers.models.albert.modeling_albert.AlbertForPreTrainingOutput",title:"Albert specific outputs"},{local:"transformers.AlbertModel",title:"AlbertModel"},{local:"transformers.AlbertForPreTraining",title:"AlbertForPreTraining"},{local:"transformers.AlbertForMaskedLM",title:"AlbertForMaskedLM"},{local:"transformers.AlbertForSequenceClassification",title:"AlbertForSequenceClassification"},{local:"transformers.AlbertForMultipleChoice",title:"AlbertForMultipleChoice"},{local:"transformers.AlbertForTokenClassification",title:"AlbertForTokenClassification"},{local:"transformers.AlbertForQuestionAnswering",title:"AlbertForQuestionAnswering"},{local:"transformers.TFAlbertModel",title:"TFAlbertModel"},{local:"transformers.TFAlbertForPreTraining",title:"TFAlbertForPreTraining"},{local:"transformers.TFAlbertForMaskedLM",title:"TFAlbertForMaskedLM"},{local:"transformers.TFAlbertForSequenceClassification",title:"TFAlbertForSequenceClassification"},{local:"transformers.TFAlbertForMultipleChoice",title:"TFAlbertForMultipleChoice"},{local:"transformers.TFAlbertForTokenClassification",title:"TFAlbertForTokenClassification"},{local:"transformers.TFAlbertForQuestionAnswering",title:"TFAlbertForQuestionAnswering"},{local:"transformers.FlaxAlbertModel",title:"FlaxAlbertModel"},{local:"transformers.FlaxAlbertForPreTraining",title:"FlaxAlbertForPreTraining"},{local:"transformers.FlaxAlbertForMaskedLM",title:"FlaxAlbertForMaskedLM"},{local:"transformers.FlaxAlbertForSequenceClassification",title:"FlaxAlbertForSequenceClassification"},{local:"transformers.FlaxAlbertForMultipleChoice",title:"FlaxAlbertForMultipleChoice"},{local:"transformers.FlaxAlbertForTokenClassification",title:"FlaxAlbertForTokenClassification"},{local:"transformers.FlaxAlbertForQuestionAnswering",title:"FlaxAlbertForQuestionAnswering"}],title:"ALBERT"};function wT(x){return ub(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zT extends fb{constructor(t){super(),gb(this,t,wT,MT,hb,{})}}export{zT as component};
