import{s as is,n as os,o as rs}from"../chunks/scheduler.9bc65507.js";import{S as hs,i as ms,g as p,s as l,r,A as cs,h as i,f as s,c as n,j as ns,u as h,x as o,k as ps,y as Ms,a,v as m,d as c,t as M,w as d}from"../chunks/index.707bf1b6.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{H as u}from"../chunks/Heading.342b1fa6.js";function ds(bt){let j,Je,Te,fe,g,we,T,Ie,U,Ct=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong> as well as message text.`,be,J,xt=`Most commonly, these roles are “user” for messages sent by the user, and “assistant” for messages sent by the model.
Some models also support a “system” role. System messages are usually sent at the beginning of the conversation
and include directives about how the model should behave in the subsequent chat.`,Ce,f,Nt=`All language models, including models fine-tuned for chat, operate on linear sequences of tokens and do not intrinsically
have special handling for roles. This means that role information is usually injected by adding control tokens
between messages, to indicate both the message boundary and the relevant roles.`,xe,w,kt=`Unfortunately, there isn’t (yet!) a standard for which tokens to use, and so different models have been trained
with wildly different formatting and control tokens for chat. This can be a real problem for users - if you use the
wrong format, then the model will be confused by your input, and your performance will be a lot worse than it should be.
This is the problem that <strong>chat templates</strong> aim to resolve.`,Ne,I,vt=`Chat conversations are typically represented as a list of dictionaries, where each dictionary contains <code>role</code>
and <code>content</code> keys, and represents a single chat message. Chat templates are strings containing a Jinja template that
specifies how to format a conversation for a given model into a single tokenizable sequence. By storing this information
with the tokenizer, we can ensure that models get input data in the format they expect.`,ke,b,Qt=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,ve,C,Qe,x,Zt=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>meta-llama/Llama-2-7b-chat-hf</code> model. Note that this model has gated access, so you will have to
<a href="https://huggingface.co/meta-llama/Llama-2-7b-chat-hf" rel="nofollow">request access on the repo</a> if you want to run this code yourself:`,Ze,N,$e,k,$t=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!)`,Ae,v,_e,Q,At=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,Ge,Z,Se,$,_t=`That’s kind of intimidating. Let’s add some newlines and indentation to make it more readable. Note that
we remove the first newline after each block as well as any preceding whitespace before a block by default, using the
Jinja <code>trim_blocks</code> and <code>lstrip_blocks</code> flags. This means that you can write your templates with indentations and
newlines and still have them function correctly!`,ze,A,Be,_,Gt=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,We,G,Ve,S,St="Effectively, the template does three things:",Re,z,zt="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",qe,B,Bt=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,He,W,Ee,V,Wt=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,Xe,R,Fe,q,Vt=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Ye,H,Le,E,Rt=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,Pe,X,De,F,qt=`The method <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>.`,Ke,Y,Oe,L,Ht=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>ConversationalPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,et,P,Et=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat, and to future-proof in case the default templates are ever altered or deprecated.`,tt,D,st,K,Xt=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,at,O,Ft=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. Our default template for models that don’t have a class-specific template follows the
<a href="https://github.com/openai/openai-python/blob/main/chatml.md" rel="nofollow">ChatML format</a>, and this is a good, flexible choice for many use-cases. It looks like this:`,lt,ee,nt,te,Yt=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for “generation prompts” - see the next section for more!`,pt,se,it,ae,Lt=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,ot,le,rt,ne,Pt=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,ht,pe,mt,ie,Dt=`You may notice that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,ct,oe,Mt,re,Kt="Here’s what this will look like without a generation prompt, using the ChatML template we described above:",dt,he,yt,me,Ot="And here’s what it looks like <strong>with</strong> a generation prompt:",jt,ce,ut,Me,es=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with the appropriate control tokens so they know what they’re
supposed to be doing.`,gt,de,ts=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Tt,ye,Ut,je,ss=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>. This applies even if you’re not the model owner - if you’re using a model
with an empty chat template, or one that’s still using the default class template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to
the model repository so that this attribute can be set properly!`,Jt,ue,as=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>ConversationalPipeline</code>!`,ft,ge,ls=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,wt,Ue,It;return g=new u({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),T=new u({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),C=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),N=new y({props:{code:"JTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGxpa2UlMjB0byUyMHNob3clMjBvZmYlMjBob3clMjBjaGF0JTIwdGVtcGxhdGluZyUyMHdvcmtzISUyMiU3RCUyQyUwQSU1RCUwQQ==",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

&gt;&gt; chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

&gt;&gt; tokenizer.use_default_system_prompt = <span class="hljs-literal">False</span>
&gt;&gt; tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST] I&#x27;m doing great. How can I help you today? &lt;/s&gt;&lt;s&gt;[INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),v=new u({props:{title:"How do chat templates work?",local:"how-do-chat-templates-work",headingTag:"h2"}}),Z=new y({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),A=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),G=new y({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),W=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),R=new u({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h2"}}),H=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),X=new y({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),Y=new u({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h2"}}),D=new u({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h2"}}),ee=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),se=new y({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEKSUyMg==",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not add_generation_prompt is defined <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">set</span> add_generation_prompt = false <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> add_generation_prompt <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;|im_start|&gt;assistant\\n&#x27;</span> }}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">)&quot;</span>',wrap:!1}}),le=new y({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful chatbot that will <span class="hljs-built_in">do</span> its best not to say anything so stupid that people tweet about it.&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
How are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing great!&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),pe=new u({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),oe=new y({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),he=new y({props:{code:"JTNFJTNFJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`&gt;&gt; tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),ce=new y({props:{code:"JTNFJTNFJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`&gt;&gt; tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),ye=new u({props:{title:"I want to use chat templates! How should I get started?",local:"i-want-to-use-chat-templates-how-should-i-get-started",headingTag:"h2"}}),{c(){j=p("meta"),Je=l(),Te=p("p"),fe=l(),r(g.$$.fragment),we=l(),r(T.$$.fragment),Ie=l(),U=p("p"),U.innerHTML=Ct,be=l(),J=p("p"),J.textContent=xt,Ce=l(),f=p("p"),f.textContent=Nt,xe=l(),w=p("p"),w.innerHTML=kt,Ne=l(),I=p("p"),I.innerHTML=vt,ke=l(),b=p("p"),b.innerHTML=Qt,ve=l(),r(C.$$.fragment),Qe=l(),x=p("p"),x.innerHTML=Zt,Ze=l(),r(N.$$.fragment),$e=l(),k=p("p"),k.textContent=$t,Ae=l(),r(v.$$.fragment),_e=l(),Q=p("p"),Q.innerHTML=At,Ge=l(),r(Z.$$.fragment),Se=l(),$=p("p"),$.innerHTML=_t,ze=l(),r(A.$$.fragment),Be=l(),_=p("p"),_.innerHTML=Gt,We=l(),r(G.$$.fragment),Ve=l(),S=p("p"),S.textContent=St,Re=l(),z=p("ol"),z.innerHTML=zt,qe=l(),B=p("p"),B.textContent=Bt,He=l(),r(W.$$.fragment),Ee=l(),V=p("p"),V.textContent=Wt,Xe=l(),r(R.$$.fragment),Fe=l(),q=p("p"),q.innerHTML=Vt,Ye=l(),r(H.$$.fragment),Le=l(),E=p("p"),E.innerHTML=Rt,Pe=l(),r(X.$$.fragment),De=l(),F=p("p"),F.innerHTML=qt,Ke=l(),r(Y.$$.fragment),Oe=l(),L=p("p"),L.innerHTML=Ht,et=l(),P=p("p"),P.innerHTML=Et,tt=l(),r(D.$$.fragment),st=l(),K=p("p"),K.textContent=Xt,at=l(),O=p("p"),O.innerHTML=Ft,lt=l(),r(ee.$$.fragment),nt=l(),te=p("p"),te.textContent=Yt,pt=l(),r(se.$$.fragment),it=l(),ae=p("p"),ae.innerHTML=Lt,ot=l(),r(le.$$.fragment),rt=l(),ne=p("p"),ne.innerHTML=Pt,ht=l(),r(pe.$$.fragment),mt=l(),ie=p("p"),ie.innerHTML=Dt,ct=l(),r(oe.$$.fragment),Mt=l(),re=p("p"),re.textContent=Kt,dt=l(),r(he.$$.fragment),yt=l(),me=p("p"),me.innerHTML=Ot,jt=l(),r(ce.$$.fragment),ut=l(),Me=p("p"),Me.textContent=es,gt=l(),de=p("p"),de.innerHTML=ts,Tt=l(),r(ye.$$.fragment),Ut=l(),je=p("p"),je.innerHTML=ss,Jt=l(),ue=p("p"),ue.innerHTML=as,ft=l(),ge=p("p"),ge.textContent=ls,wt=l(),Ue=p("p"),this.h()},l(e){const t=cs("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(s),Je=n(e),Te=i(e,"P",{}),ns(Te).forEach(s),fe=n(e),h(g.$$.fragment,e),we=n(e),h(T.$$.fragment,e),Ie=n(e),U=i(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1ktexn3"&&(U.innerHTML=Ct),be=n(e),J=i(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1xlggqv"&&(J.textContent=xt),Ce=n(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-pmlzkx"&&(f.textContent=Nt),xe=n(e),w=i(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-17e4zh4"&&(w.innerHTML=kt),Ne=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1bgzjn5"&&(I.innerHTML=vt),ke=n(e),b=i(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1n6wf0k"&&(b.innerHTML=Qt),ve=n(e),h(C.$$.fragment,e),Qe=n(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1ensusj"&&(x.innerHTML=Zt),Ze=n(e),h(N.$$.fragment,e),$e=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-7ppdar"&&(k.textContent=$t),Ae=n(e),h(v.$$.fragment,e),_e=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-9hx4bd"&&(Q.innerHTML=At),Ge=n(e),h(Z.$$.fragment,e),Se=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-vicnrv"&&($.innerHTML=_t),ze=n(e),h(A.$$.fragment,e),Be=n(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-zet1qo"&&(_.innerHTML=Gt),We=n(e),h(G.$$.fragment,e),Ve=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-9bdwn1"&&(S.textContent=St),Re=n(e),z=i(e,"OL",{"data-svelte-h":!0}),o(z)!=="svelte-yy2gop"&&(z.innerHTML=zt),qe=n(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-jxu6rq"&&(B.textContent=Bt),He=n(e),h(W.$$.fragment,e),Ee=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-dqaxjt"&&(V.textContent=Wt),Xe=n(e),h(R.$$.fragment,e),Fe=n(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1ubxgh9"&&(q.innerHTML=Vt),Ye=n(e),h(H.$$.fragment,e),Le=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-rfvfyf"&&(E.innerHTML=Rt),Pe=n(e),h(X.$$.fragment,e),De=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1gcex30"&&(F.innerHTML=qt),Ke=n(e),h(Y.$$.fragment,e),Oe=n(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-fwloaj"&&(L.innerHTML=Ht),et=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-118w8i2"&&(P.innerHTML=Et),tt=n(e),h(D.$$.fragment,e),st=n(e),K=i(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-5u6sqi"&&(K.textContent=Xt),at=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-u7dsj6"&&(O.innerHTML=Ft),lt=n(e),h(ee.$$.fragment,e),nt=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-kumxzd"&&(te.textContent=Yt),pt=n(e),h(se.$$.fragment,e),it=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-soh9qu"&&(ae.innerHTML=Lt),ot=n(e),h(le.$$.fragment,e),rt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-11jpq6m"&&(ne.innerHTML=Pt),ht=n(e),h(pe.$$.fragment,e),mt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1jrs4or"&&(ie.innerHTML=Dt),ct=n(e),h(oe.$$.fragment,e),Mt=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-ku5b4p"&&(re.textContent=Kt),dt=n(e),h(he.$$.fragment,e),yt=n(e),me=i(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-61bp3d"&&(me.innerHTML=Ot),jt=n(e),h(ce.$$.fragment,e),ut=n(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1h8j73s"&&(Me.textContent=es),gt=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-76qw2e"&&(de.innerHTML=ts),Tt=n(e),h(ye.$$.fragment,e),Ut=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-ig3f0g"&&(je.innerHTML=ss),Jt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1dmaop5"&&(ue.innerHTML=as),ft=n(e),ge=i(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-197jyne"&&(ge.textContent=ls),wt=n(e),Ue=i(e,"P",{}),ns(Ue).forEach(s),this.h()},h(){ps(j,"name","hf:doc:metadata"),ps(j,"content",ys)},m(e,t){Ms(document.head,j),a(e,Je,t),a(e,Te,t),a(e,fe,t),m(g,e,t),a(e,we,t),m(T,e,t),a(e,Ie,t),a(e,U,t),a(e,be,t),a(e,J,t),a(e,Ce,t),a(e,f,t),a(e,xe,t),a(e,w,t),a(e,Ne,t),a(e,I,t),a(e,ke,t),a(e,b,t),a(e,ve,t),m(C,e,t),a(e,Qe,t),a(e,x,t),a(e,Ze,t),m(N,e,t),a(e,$e,t),a(e,k,t),a(e,Ae,t),m(v,e,t),a(e,_e,t),a(e,Q,t),a(e,Ge,t),m(Z,e,t),a(e,Se,t),a(e,$,t),a(e,ze,t),m(A,e,t),a(e,Be,t),a(e,_,t),a(e,We,t),m(G,e,t),a(e,Ve,t),a(e,S,t),a(e,Re,t),a(e,z,t),a(e,qe,t),a(e,B,t),a(e,He,t),m(W,e,t),a(e,Ee,t),a(e,V,t),a(e,Xe,t),m(R,e,t),a(e,Fe,t),a(e,q,t),a(e,Ye,t),m(H,e,t),a(e,Le,t),a(e,E,t),a(e,Pe,t),m(X,e,t),a(e,De,t),a(e,F,t),a(e,Ke,t),m(Y,e,t),a(e,Oe,t),a(e,L,t),a(e,et,t),a(e,P,t),a(e,tt,t),m(D,e,t),a(e,st,t),a(e,K,t),a(e,at,t),a(e,O,t),a(e,lt,t),m(ee,e,t),a(e,nt,t),a(e,te,t),a(e,pt,t),m(se,e,t),a(e,it,t),a(e,ae,t),a(e,ot,t),m(le,e,t),a(e,rt,t),a(e,ne,t),a(e,ht,t),m(pe,e,t),a(e,mt,t),a(e,ie,t),a(e,ct,t),m(oe,e,t),a(e,Mt,t),a(e,re,t),a(e,dt,t),m(he,e,t),a(e,yt,t),a(e,me,t),a(e,jt,t),m(ce,e,t),a(e,ut,t),a(e,Me,t),a(e,gt,t),a(e,de,t),a(e,Tt,t),m(ye,e,t),a(e,Ut,t),a(e,je,t),a(e,Jt,t),a(e,ue,t),a(e,ft,t),a(e,ge,t),a(e,wt,t),a(e,Ue,t),It=!0},p:os,i(e){It||(c(g.$$.fragment,e),c(T.$$.fragment,e),c(C.$$.fragment,e),c(N.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(A.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(he.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),It=!0)},o(e){M(g.$$.fragment,e),M(T.$$.fragment,e),M(C.$$.fragment,e),M(N.$$.fragment,e),M(v.$$.fragment,e),M(Z.$$.fragment,e),M(A.$$.fragment,e),M(G.$$.fragment,e),M(W.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(pe.$$.fragment,e),M(oe.$$.fragment,e),M(he.$$.fragment,e),M(ce.$$.fragment,e),M(ye.$$.fragment,e),It=!1},d(e){e&&(s(Je),s(Te),s(fe),s(we),s(Ie),s(U),s(be),s(J),s(Ce),s(f),s(xe),s(w),s(Ne),s(I),s(ke),s(b),s(ve),s(Qe),s(x),s(Ze),s($e),s(k),s(Ae),s(_e),s(Q),s(Ge),s(Se),s($),s(ze),s(Be),s(_),s(We),s(Ve),s(S),s(Re),s(z),s(qe),s(B),s(He),s(Ee),s(V),s(Xe),s(Fe),s(q),s(Ye),s(Le),s(E),s(Pe),s(De),s(F),s(Ke),s(Oe),s(L),s(et),s(P),s(tt),s(st),s(K),s(at),s(O),s(lt),s(nt),s(te),s(pt),s(it),s(ae),s(ot),s(rt),s(ne),s(ht),s(mt),s(ie),s(ct),s(Mt),s(re),s(dt),s(yt),s(me),s(jt),s(ut),s(Me),s(gt),s(de),s(Tt),s(Ut),s(je),s(Jt),s(ue),s(ft),s(ge),s(wt),s(Ue)),s(j),d(g,e),d(T,e),d(C,e),d(N,e),d(v,e),d(Z,e),d(A,e),d(G,e),d(W,e),d(R,e),d(H,e),d(X,e),d(Y,e),d(D,e),d(ee,e),d(se,e),d(le,e),d(pe,e),d(oe,e),d(he,e),d(ce,e),d(ye,e)}}}const ys='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do chat templates work?","local":"how-do-chat-templates-work","sections":[],"depth":2},{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":2},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":2},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"I want to use chat templates! How should I get started?","local":"i-want-to-use-chat-templates-how-should-i-get-started","sections":[],"depth":2}],"depth":1}';function js(bt){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends hs{constructor(j){super(),ms(this,j,js,ds,is,{})}}export{Js as component};
