import{s as ke,n as Ye,o as _e}from"../chunks/scheduler.9bc65507.js";import{S as xe,i as Ne,g as m,s as n,r as i,A as Ve,h as d,f as l,c as s,j as Xe,u as r,x as y,k as ve,y as Re,a,v as o,d as p,t as c,w as M}from"../chunks/index.707bf1b6.js";import{H as E,g as Qe}from"../chunks/Heading.98cce615.js";import{C as J}from"../chunks/CodeBlock.54a9f38d.js";function Ee(fe){let w,S,F,z,T,K,j,be='As models get bigger, parallelism has emerged as a strategy for training larger models on limited hardware and accelerating training speed by several orders of magnitude. At Hugging Face, we created the <a href="https://huggingface.co/docs/accelerate" rel="nofollow">🤗 Accelerate</a> library to help users easily train a 🤗 Transformers model on any type of distributed setup, whether it is multiple GPU’s on one machine or multiple GPU’s across several machines. In this tutorial, learn how to customize your native PyTorch training loop to enable training in a distributed environment.',L,h,P,u,Ue="Get started by installing 🤗 Accelerate:",D,f,q,b,ge="Then import and create an <code>Accelerator</code> object. The <code>Accelerator</code> will automatically detect your type of distributed setup and initialize all the necessary components for training. You don’t need to explicitly place your model on a device.",O,U,ee,g,te,$,$e="The next step is to pass all the relevant training objects to the <code>prepare</code> method. This includes your training and evaluation DataLoaders, a model and an optimizer:",le,I,ae,C,ne,B,Ie="The last addition is to replace the typical <code>loss.backward()</code> in your training loop with 🤗 Accelerate’s <code>backward</code>method:",se,Z,ie,A,Ce="As you can see in the following code, you only need to add four additional lines of code to your training loop to enable distributed training!",re,W,oe,G,pe,X,Be="Once you’ve added the relevant lines of code, launch your training in a script or a notebook like Colaboratory.",ce,v,Me,k,Ze="If you are running your training from a script, run the following command to create and save a configuration file:",me,Y,de,_,Ae="Then launch your training with:",ye,x,we,N,Je,V,We="🤗 Accelerate can also run in a notebook if you’re planning on using Colaboratory’s TPUs. Wrap all the code responsible for training in a function, and pass it to <code>notebook_launcher</code>:",Te,R,je,Q,Ge='For more information about 🤗 Accelerate and its rich features, refer to the <a href="https://huggingface.co/docs/accelerate" rel="nofollow">documentation</a>.',he,H,ue;return T=new E({props:{title:"Distributed training with 🤗 Accelerate",local:"distributed-training-with--accelerate",headingTag:"h1"}}),h=new E({props:{title:"Setup",local:"setup",headingTag:"h2"}}),f=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),U=new J({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()`,wrap:!1}}),g=new E({props:{title:"Prepare to accelerate",local:"prepare-to-accelerate",headingTag:"h2"}}),I=new J({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
<span class="hljs-meta">... </span>    train_dataloader, eval_dataloader, model, optimizer
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new E({props:{title:"Backward",local:"backward",headingTag:"h2"}}),Z=new J({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        accelerator.backward(loss)

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),W=new J({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),G=new E({props:{title:"Train",local:"train",headingTag:"h2"}}),v=new E({props:{title:"Train with a script",local:"train-with-a-script",headingTag:"h3"}}),Y=new J({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),x=new J({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py",wrap:!1}}),N=new E({props:{title:"Train with a notebook",local:"train-with-a-notebook",headingTag:"h3"}}),R=new J({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(training_function)`,wrap:!1}}),{c(){w=m("meta"),S=n(),F=m("p"),z=n(),i(T.$$.fragment),K=n(),j=m("p"),j.innerHTML=be,L=n(),i(h.$$.fragment),P=n(),u=m("p"),u.textContent=Ue,D=n(),i(f.$$.fragment),q=n(),b=m("p"),b.innerHTML=ge,O=n(),i(U.$$.fragment),ee=n(),i(g.$$.fragment),te=n(),$=m("p"),$.innerHTML=$e,le=n(),i(I.$$.fragment),ae=n(),i(C.$$.fragment),ne=n(),B=m("p"),B.innerHTML=Ie,se=n(),i(Z.$$.fragment),ie=n(),A=m("p"),A.textContent=Ce,re=n(),i(W.$$.fragment),oe=n(),i(G.$$.fragment),pe=n(),X=m("p"),X.textContent=Be,ce=n(),i(v.$$.fragment),Me=n(),k=m("p"),k.textContent=Ze,me=n(),i(Y.$$.fragment),de=n(),_=m("p"),_.textContent=Ae,ye=n(),i(x.$$.fragment),we=n(),i(N.$$.fragment),Je=n(),V=m("p"),V.innerHTML=We,Te=n(),i(R.$$.fragment),je=n(),Q=m("p"),Q.innerHTML=Ge,he=n(),H=m("p"),this.h()},l(e){const t=Ve("svelte-u9bgzb",document.head);w=d(t,"META",{name:!0,content:!0}),t.forEach(l),S=s(e),F=d(e,"P",{}),Xe(F).forEach(l),z=s(e),r(T.$$.fragment,e),K=s(e),j=d(e,"P",{"data-svelte-h":!0}),y(j)!=="svelte-11mv690"&&(j.innerHTML=be),L=s(e),r(h.$$.fragment,e),P=s(e),u=d(e,"P",{"data-svelte-h":!0}),y(u)!=="svelte-1wyzwc5"&&(u.textContent=Ue),D=s(e),r(f.$$.fragment,e),q=s(e),b=d(e,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1ak96th"&&(b.innerHTML=ge),O=s(e),r(U.$$.fragment,e),ee=s(e),r(g.$$.fragment,e),te=s(e),$=d(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-1gruru4"&&($.innerHTML=$e),le=s(e),r(I.$$.fragment,e),ae=s(e),r(C.$$.fragment,e),ne=s(e),B=d(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-t93teu"&&(B.innerHTML=Ie),se=s(e),r(Z.$$.fragment,e),ie=s(e),A=d(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-tbmaal"&&(A.textContent=Ce),re=s(e),r(W.$$.fragment,e),oe=s(e),r(G.$$.fragment,e),pe=s(e),X=d(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1bmx0kl"&&(X.textContent=Be),ce=s(e),r(v.$$.fragment,e),Me=s(e),k=d(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-d65x2y"&&(k.textContent=Ze),me=s(e),r(Y.$$.fragment,e),de=s(e),_=d(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-xc3fgn"&&(_.textContent=Ae),ye=s(e),r(x.$$.fragment,e),we=s(e),r(N.$$.fragment,e),Je=s(e),V=d(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-ewcbal"&&(V.innerHTML=We),Te=s(e),r(R.$$.fragment,e),je=s(e),Q=d(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-5m2lvn"&&(Q.innerHTML=Ge),he=s(e),H=d(e,"P",{}),Xe(H).forEach(l),this.h()},h(){ve(w,"name","hf:doc:metadata"),ve(w,"content",Fe)},m(e,t){Re(document.head,w),a(e,S,t),a(e,F,t),a(e,z,t),o(T,e,t),a(e,K,t),a(e,j,t),a(e,L,t),o(h,e,t),a(e,P,t),a(e,u,t),a(e,D,t),o(f,e,t),a(e,q,t),a(e,b,t),a(e,O,t),o(U,e,t),a(e,ee,t),o(g,e,t),a(e,te,t),a(e,$,t),a(e,le,t),o(I,e,t),a(e,ae,t),o(C,e,t),a(e,ne,t),a(e,B,t),a(e,se,t),o(Z,e,t),a(e,ie,t),a(e,A,t),a(e,re,t),o(W,e,t),a(e,oe,t),o(G,e,t),a(e,pe,t),a(e,X,t),a(e,ce,t),o(v,e,t),a(e,Me,t),a(e,k,t),a(e,me,t),o(Y,e,t),a(e,de,t),a(e,_,t),a(e,ye,t),o(x,e,t),a(e,we,t),o(N,e,t),a(e,Je,t),a(e,V,t),a(e,Te,t),o(R,e,t),a(e,je,t),a(e,Q,t),a(e,he,t),a(e,H,t),ue=!0},p:Ye,i(e){ue||(p(T.$$.fragment,e),p(h.$$.fragment,e),p(f.$$.fragment,e),p(U.$$.fragment,e),p(g.$$.fragment,e),p(I.$$.fragment,e),p(C.$$.fragment,e),p(Z.$$.fragment,e),p(W.$$.fragment,e),p(G.$$.fragment,e),p(v.$$.fragment,e),p(Y.$$.fragment,e),p(x.$$.fragment,e),p(N.$$.fragment,e),p(R.$$.fragment,e),ue=!0)},o(e){c(T.$$.fragment,e),c(h.$$.fragment,e),c(f.$$.fragment,e),c(U.$$.fragment,e),c(g.$$.fragment,e),c(I.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(G.$$.fragment,e),c(v.$$.fragment,e),c(Y.$$.fragment,e),c(x.$$.fragment,e),c(N.$$.fragment,e),c(R.$$.fragment,e),ue=!1},d(e){e&&(l(S),l(F),l(z),l(K),l(j),l(L),l(P),l(u),l(D),l(q),l(b),l(O),l(ee),l(te),l($),l(le),l(ae),l(ne),l(B),l(se),l(ie),l(A),l(re),l(oe),l(pe),l(X),l(ce),l(Me),l(k),l(me),l(de),l(_),l(ye),l(we),l(Je),l(V),l(Te),l(je),l(Q),l(he),l(H)),l(w),M(T,e),M(h,e),M(f,e),M(U,e),M(g,e),M(I,e),M(C,e),M(Z,e),M(W,e),M(G,e),M(v,e),M(Y,e),M(x,e),M(N,e),M(R,e)}}}const Fe='{"title":"Distributed training with 🤗 Accelerate","local":"distributed-training-with--accelerate","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Prepare to accelerate","local":"prepare-to-accelerate","sections":[],"depth":2},{"title":"Backward","local":"backward","sections":[],"depth":2},{"title":"Train","local":"train","sections":[{"title":"Train with a script","local":"train-with-a-script","sections":[],"depth":3},{"title":"Train with a notebook","local":"train-with-a-notebook","sections":[],"depth":3}],"depth":2}],"depth":1}';function He(fe){return _e(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Qe}),[]}class Pe extends xe{constructor(w){super(),Ne(this,w,He,Ee,ke,{})}}export{Pe as component};
