import{s as sr,o as or,n as z}from"../chunks/scheduler.9bc65507.js";import{S as ar,i as rr,g as p,s as r,r as _,A as lr,h as u,f as i,c as l,j as C,u as M,x as g,k as U,y as o,a as m,v as y,d as b,t as T,w}from"../chunks/index.707bf1b6.js";import{H as se,g as ir}from"../chunks/Heading.98cce615.js";import{T as qn}from"../chunks/Tip.c2ecdbf4.js";import{D as G}from"../chunks/Docstring.d5156d74.js";import{C as x}from"../chunks/CodeBlock.54a9f38d.js";import{E as S}from"../chunks/ExampleCodeBlock.35e257ed.js";function dr(k){let n,f="Examples:",a,s,c;return s=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNxdWVlemVCZXJ0Q29uZmlnJTJDJTIwU3F1ZWV6ZUJlcnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTcXVlZXplQkVSVCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3F1ZWV6ZUJlcnRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwY29uZmlndXJhdGlvbiUyMGFib3ZlJTBBbW9kZWwlMjAlM0QlMjBTcXVlZXplQmVydE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SqueezeBertConfig, SqueezeBertModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SqueezeBERT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SqueezeBertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration above</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function cr(k){let n,f="sequence pair mask has the following format:",a,s,c;return s=new x({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-16klr56"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function pr(k){let n,f="sequence pair mask has the following format:",a,s,c;return s=new x({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-16klr56"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function ur(k){let n,f="Hierarchy:",a,s,c;return s=new x({props:{code:"SW50ZXJuYWwlMjBjbGFzcyUyMGhpZXJhcmNoeSUzQSUwQVNxdWVlemVCZXJ0TW9kZWwlMEElMjAlMjAlMjAlMjBTcXVlZXplQmVydEVuY29kZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcXVlZXplQmVydE1vZHVsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNxdWVlemVCZXJ0U2VsZkF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbnZBY3RpdmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29udkRyb3BvdXRMYXllck5vcm0=",highlighted:`Internal <span class="hljs-keyword">class</span> <span class="hljs-symbol">hierarchy:
<span class="hljs-symbol">SqueezeBertModel</span></span>
    <span class="hljs-symbol">SqueezeBertEncoder</span>
        <span class="hljs-symbol">SqueezeBertModule</span>
        <span class="hljs-symbol">SqueezeBertSelfAttention</span>
            <span class="hljs-symbol">ConvActivation</span>
            <span class="hljs-symbol">ConvDropoutLayerNorm</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ddpap"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function mr(k){let n,f="Data layouts:",a,s,c;return s=new x({props:{code:"SW5wdXQlMjBkYXRhJTIwaXMlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBRGF0YSUyMGluc2lkZSUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBoaWRkZW5fc2l6ZSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMGZvcm1hdC4lMjBCdXQlMkMlMjBpZiUyMCU2MG91dHB1dF9oaWRkZW5fc3RhdGVzJTIwJTNEJTNEJTIwVHJ1ZSU2MCUyQyUyMHRoZSUyMGRhdGElMjBmcm9tJTIwaW5zaWRlJTIwdGhlJTIwZW5jb2RlciUyMGlzJTIwcmV0dXJuZWQlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBVGhlJTIwZmluYWwlMjBvdXRwdXQlMjBvZiUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjBoaWRkZW5fc2l6ZSU1RCUyMGZvcm1hdC4=",highlighted:`<span class="hljs-keyword">Input</span> data <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

Data inside the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, hidden_size, sequence_length] <span class="hljs-keyword">format</span>. But, <span class="hljs-keyword">if</span> \`output_hidden_states == <span class="hljs-keyword">True</span>\`, the data <span class="hljs-keyword">from</span> inside the encoder <span class="hljs-keyword">is</span> returned <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

The final output <span class="hljs-keyword">of</span> the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-5h3nnb"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function hr(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=f},l(a){n=u(a,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(a,s){m(a,n,s)},p:z,d(a){a&&i(n)}}}function fr(k){let n,f="Example:",a,s,c;return s=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcXVlZXplQmVydE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTcXVlZXplQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SqueezeBertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertModel.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-11lpom8"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function gr(k){let n,f="Hierarchy:",a,s,c;return s=new x({props:{code:"SW50ZXJuYWwlMjBjbGFzcyUyMGhpZXJhcmNoeSUzQSUwQVNxdWVlemVCZXJ0TW9kZWwlMEElMjAlMjAlMjAlMjBTcXVlZXplQmVydEVuY29kZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcXVlZXplQmVydE1vZHVsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNxdWVlemVCZXJ0U2VsZkF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbnZBY3RpdmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29udkRyb3BvdXRMYXllck5vcm0=",highlighted:`Internal <span class="hljs-keyword">class</span> <span class="hljs-symbol">hierarchy:
<span class="hljs-symbol">SqueezeBertModel</span></span>
    <span class="hljs-symbol">SqueezeBertEncoder</span>
        <span class="hljs-symbol">SqueezeBertModule</span>
        <span class="hljs-symbol">SqueezeBertSelfAttention</span>
            <span class="hljs-symbol">ConvActivation</span>
            <span class="hljs-symbol">ConvDropoutLayerNorm</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ddpap"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function _r(k){let n,f="Data layouts:",a,s,c;return s=new x({props:{code:"SW5wdXQlMjBkYXRhJTIwaXMlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBRGF0YSUyMGluc2lkZSUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBoaWRkZW5fc2l6ZSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMGZvcm1hdC4lMjBCdXQlMkMlMjBpZiUyMCU2MG91dHB1dF9oaWRkZW5fc3RhdGVzJTIwJTNEJTNEJTIwVHJ1ZSU2MCUyQyUyMHRoZSUyMGRhdGElMjBmcm9tJTIwaW5zaWRlJTIwdGhlJTIwZW5jb2RlciUyMGlzJTIwcmV0dXJuZWQlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBVGhlJTIwZmluYWwlMjBvdXRwdXQlMjBvZiUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjBoaWRkZW5fc2l6ZSU1RCUyMGZvcm1hdC4=",highlighted:`<span class="hljs-keyword">Input</span> data <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

Data inside the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, hidden_size, sequence_length] <span class="hljs-keyword">format</span>. But, <span class="hljs-keyword">if</span> \`output_hidden_states == <span class="hljs-keyword">True</span>\`, the data <span class="hljs-keyword">from</span> inside the encoder <span class="hljs-keyword">is</span> returned <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

The final output <span class="hljs-keyword">of</span> the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-5h3nnb"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function Mr(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=f},l(a){n=u(a,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(a,s){m(a,n,s)},p:z,d(a){a&&i(n)}}}function yr(k){let n,f="Example:",a,s,c;return s=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcXVlZXplQmVydEZvck1hc2tlZExNJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTcXVlZXplQmVydEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwcmV0cmlldmUlMjBpbmRleCUyMG9mJTIwJTVCTUFTSyU1RCUwQW1hc2tfdG9rZW5faW5kZXglMjAlM0QlMjAoaW5wdXRzLmlucHV0X2lkcyUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkKSU1QjAlNUQubm9uemVybyhhc190dXBsZSUzRFRydWUpJTVCMCU1RCUwQSUwQXByZWRpY3RlZF90b2tlbl9pZCUyMCUzRCUyMGxvZ2l0cyU1QjAlMkMlMjBtYXNrX3Rva2VuX2luZGV4JTVELmFyZ21heChheGlzJTNELTEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjMlMjBtYXNrJTIwbGFiZWxzJTIwb2YlMjBub24tJTVCTUFTSyU1RCUyMHRva2VucyUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLndoZXJlKGlucHV0cy5pbnB1dF9pZHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUyQyUyMGxhYmVscyUyQyUyMC0xMDApJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SqueezeBertForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForMaskedLM.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of [MASK]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = (inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>].nonzero(as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = logits[<span class="hljs-number">0</span>, mask_token_index].argmax(axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask labels of non-[MASK] tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.where(inputs.input_ids == tokenizer.mask_token_id, labels, -<span class="hljs-number">100</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-11lpom8"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function br(k){let n,f="Hierarchy:",a,s,c;return s=new x({props:{code:"SW50ZXJuYWwlMjBjbGFzcyUyMGhpZXJhcmNoeSUzQSUwQVNxdWVlemVCZXJ0TW9kZWwlMEElMjAlMjAlMjAlMjBTcXVlZXplQmVydEVuY29kZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcXVlZXplQmVydE1vZHVsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNxdWVlemVCZXJ0U2VsZkF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbnZBY3RpdmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29udkRyb3BvdXRMYXllck5vcm0=",highlighted:`Internal <span class="hljs-keyword">class</span> <span class="hljs-symbol">hierarchy:
<span class="hljs-symbol">SqueezeBertModel</span></span>
    <span class="hljs-symbol">SqueezeBertEncoder</span>
        <span class="hljs-symbol">SqueezeBertModule</span>
        <span class="hljs-symbol">SqueezeBertSelfAttention</span>
            <span class="hljs-symbol">ConvActivation</span>
            <span class="hljs-symbol">ConvDropoutLayerNorm</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ddpap"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function Tr(k){let n,f="Data layouts:",a,s,c;return s=new x({props:{code:"SW5wdXQlMjBkYXRhJTIwaXMlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBRGF0YSUyMGluc2lkZSUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBoaWRkZW5fc2l6ZSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMGZvcm1hdC4lMjBCdXQlMkMlMjBpZiUyMCU2MG91dHB1dF9oaWRkZW5fc3RhdGVzJTIwJTNEJTNEJTIwVHJ1ZSU2MCUyQyUyMHRoZSUyMGRhdGElMjBmcm9tJTIwaW5zaWRlJTIwdGhlJTIwZW5jb2RlciUyMGlzJTIwcmV0dXJuZWQlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBVGhlJTIwZmluYWwlMjBvdXRwdXQlMjBvZiUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjBoaWRkZW5fc2l6ZSU1RCUyMGZvcm1hdC4=",highlighted:`<span class="hljs-keyword">Input</span> data <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

Data inside the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, hidden_size, sequence_length] <span class="hljs-keyword">format</span>. But, <span class="hljs-keyword">if</span> \`output_hidden_states == <span class="hljs-keyword">True</span>\`, the data <span class="hljs-keyword">from</span> inside the encoder <span class="hljs-keyword">is</span> returned <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

The final output <span class="hljs-keyword">of</span> the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-5h3nnb"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function wr(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=f},l(a){n=u(a,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(a,s){m(a,n,s)},p:z,d(a){a&&i(n)}}}function kr(k){let n,f="Example of single-label classification:",a,s,c;return s=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFNxdWVlemVCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnNxdWVlemViZXJ0JTJGc3F1ZWV6ZWJlcnQtdW5jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFNxdWVlemVCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3F1ZWV6ZWJlcnQlMkZzcXVlZXplYmVydC11bmNhc2VkJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBTcXVlZXplQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNxdWVlemViZXJ0JTJGc3F1ZWV6ZWJlcnQtdW5jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SqueezeBertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ykxpe4"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function zr(k){let n,f="Example of multi-label classification:",a,s,c;return s=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFNxdWVlemVCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnNxdWVlemViZXJ0JTJGc3F1ZWV6ZWJlcnQtdW5jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFNxdWVlemVCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3F1ZWV6ZWJlcnQlMkZzcXVlZXplYmVydC11bmNhc2VkJTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBTcXVlZXplQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnNxdWVlemViZXJ0JTJGc3F1ZWV6ZWJlcnQtdW5jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SqueezeBertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-1l8e32d"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function $r(k){let n,f="Hierarchy:",a,s,c;return s=new x({props:{code:"SW50ZXJuYWwlMjBjbGFzcyUyMGhpZXJhcmNoeSUzQSUwQVNxdWVlemVCZXJ0TW9kZWwlMEElMjAlMjAlMjAlMjBTcXVlZXplQmVydEVuY29kZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcXVlZXplQmVydE1vZHVsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNxdWVlemVCZXJ0U2VsZkF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbnZBY3RpdmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29udkRyb3BvdXRMYXllck5vcm0=",highlighted:`Internal <span class="hljs-keyword">class</span> <span class="hljs-symbol">hierarchy:
<span class="hljs-symbol">SqueezeBertModel</span></span>
    <span class="hljs-symbol">SqueezeBertEncoder</span>
        <span class="hljs-symbol">SqueezeBertModule</span>
        <span class="hljs-symbol">SqueezeBertSelfAttention</span>
            <span class="hljs-symbol">ConvActivation</span>
            <span class="hljs-symbol">ConvDropoutLayerNorm</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ddpap"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function vr(k){let n,f="Data layouts:",a,s,c;return s=new x({props:{code:"SW5wdXQlMjBkYXRhJTIwaXMlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBRGF0YSUyMGluc2lkZSUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBoaWRkZW5fc2l6ZSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMGZvcm1hdC4lMjBCdXQlMkMlMjBpZiUyMCU2MG91dHB1dF9oaWRkZW5fc3RhdGVzJTIwJTNEJTNEJTIwVHJ1ZSU2MCUyQyUyMHRoZSUyMGRhdGElMjBmcm9tJTIwaW5zaWRlJTIwdGhlJTIwZW5jb2RlciUyMGlzJTIwcmV0dXJuZWQlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBVGhlJTIwZmluYWwlMjBvdXRwdXQlMjBvZiUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjBoaWRkZW5fc2l6ZSU1RCUyMGZvcm1hdC4=",highlighted:`<span class="hljs-keyword">Input</span> data <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

Data inside the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, hidden_size, sequence_length] <span class="hljs-keyword">format</span>. But, <span class="hljs-keyword">if</span> \`output_hidden_states == <span class="hljs-keyword">True</span>\`, the data <span class="hljs-keyword">from</span> inside the encoder <span class="hljs-keyword">is</span> returned <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

The final output <span class="hljs-keyword">of</span> the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-5h3nnb"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function jr(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=f},l(a){n=u(a,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(a,s){m(a,n,s)},p:z,d(a){a&&i(n)}}}function Br(k){let n,f="Example:",a,s,c;return s=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcXVlZXplQmVydEZvck11bHRpcGxlQ2hvaWNlJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTcXVlZXplQmVydEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySW4lMjBJdGFseSUyQyUyMHBpenphJTIwc2VydmVkJTIwaW4lMjBmb3JtYWwlMjBzZXR0aW5ncyUyQyUyMHN1Y2glMjBhcyUyMGF0JTIwYSUyMHJlc3RhdXJhbnQlMkMlMjBpcyUyMHByZXNlbnRlZCUyMHVuc2xpY2VkLiUyMiUwQWNob2ljZTAlMjAlM0QlMjAlMjJJdCUyMGlzJTIwZWF0ZW4lMjB3aXRoJTIwYSUyMGZvcmslMjBhbmQlMjBhJTIwa25pZmUuJTIyJTBBY2hvaWNlMSUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdoaWxlJTIwaGVsZCUyMGluJTIwdGhlJTIwaGFuZC4lMjIlMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoMCkudW5zcXVlZXplKDApJTIwJTIwJTIzJTIwY2hvaWNlMCUyMGlzJTIwY29ycmVjdCUyMChhY2NvcmRpbmclMjB0byUyMFdpa2lwZWRpYSUyMCUzQikpJTJDJTIwYmF0Y2glMjBzaXplJTIwMSUwQSUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKCU1QnByb21wdCUyQyUyMHByb21wdCU1RCUyQyUyMCU1QmNob2ljZTAlMkMlMjBjaG9pY2UxJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKiU3QmslM0ElMjB2LnVuc3F1ZWV6ZSgwKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBlbmNvZGluZy5pdGVtcygpJTdEJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUyMCUyMCUyMyUyMGJhdGNoJTIwc2l6ZSUyMGlzJTIwMSUwQSUwQSUyMyUyMHRoZSUyMGxpbmVhciUyMGNsYXNzaWZpZXIlMjBzdGlsbCUyMG5lZWRzJTIwdG8lMjBiZSUyMHRyYWluZWQlMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SqueezeBertForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-11lpom8"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function qr(k){let n,f="Hierarchy:",a,s,c;return s=new x({props:{code:"SW50ZXJuYWwlMjBjbGFzcyUyMGhpZXJhcmNoeSUzQSUwQVNxdWVlemVCZXJ0TW9kZWwlMEElMjAlMjAlMjAlMjBTcXVlZXplQmVydEVuY29kZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcXVlZXplQmVydE1vZHVsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNxdWVlemVCZXJ0U2VsZkF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbnZBY3RpdmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29udkRyb3BvdXRMYXllck5vcm0=",highlighted:`Internal <span class="hljs-keyword">class</span> <span class="hljs-symbol">hierarchy:
<span class="hljs-symbol">SqueezeBertModel</span></span>
    <span class="hljs-symbol">SqueezeBertEncoder</span>
        <span class="hljs-symbol">SqueezeBertModule</span>
        <span class="hljs-symbol">SqueezeBertSelfAttention</span>
            <span class="hljs-symbol">ConvActivation</span>
            <span class="hljs-symbol">ConvDropoutLayerNorm</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ddpap"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function Jr(k){let n,f="Data layouts:",a,s,c;return s=new x({props:{code:"SW5wdXQlMjBkYXRhJTIwaXMlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBRGF0YSUyMGluc2lkZSUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBoaWRkZW5fc2l6ZSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMGZvcm1hdC4lMjBCdXQlMkMlMjBpZiUyMCU2MG91dHB1dF9oaWRkZW5fc3RhdGVzJTIwJTNEJTNEJTIwVHJ1ZSU2MCUyQyUyMHRoZSUyMGRhdGElMjBmcm9tJTIwaW5zaWRlJTIwdGhlJTIwZW5jb2RlciUyMGlzJTIwcmV0dXJuZWQlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBVGhlJTIwZmluYWwlMjBvdXRwdXQlMjBvZiUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjBoaWRkZW5fc2l6ZSU1RCUyMGZvcm1hdC4=",highlighted:`<span class="hljs-keyword">Input</span> data <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

Data inside the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, hidden_size, sequence_length] <span class="hljs-keyword">format</span>. But, <span class="hljs-keyword">if</span> \`output_hidden_states == <span class="hljs-keyword">True</span>\`, the data <span class="hljs-keyword">from</span> inside the encoder <span class="hljs-keyword">is</span> returned <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

The final output <span class="hljs-keyword">of</span> the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-5h3nnb"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function Cr(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=f},l(a){n=u(a,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(a,s){m(a,n,s)},p:z,d(a){a&&i(n)}}}function Ur(k){let n,f="Example:",a,s,c;return s=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcXVlZXplQmVydEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnNxdWVlemViZXJ0JTJGc3F1ZWV6ZWJlcnQtdW5jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFNxdWVlemVCZXJ0Rm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3F1ZWV6ZWJlcnQlMkZzcXVlZXplYmVydC11bmNhc2VkJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SqueezeBertForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForTokenClassification.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-11lpom8"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function Sr(k){let n,f="Hierarchy:",a,s,c;return s=new x({props:{code:"SW50ZXJuYWwlMjBjbGFzcyUyMGhpZXJhcmNoeSUzQSUwQVNxdWVlemVCZXJ0TW9kZWwlMEElMjAlMjAlMjAlMjBTcXVlZXplQmVydEVuY29kZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcXVlZXplQmVydE1vZHVsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNxdWVlemVCZXJ0U2VsZkF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbnZBY3RpdmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29udkRyb3BvdXRMYXllck5vcm0=",highlighted:`Internal <span class="hljs-keyword">class</span> <span class="hljs-symbol">hierarchy:
<span class="hljs-symbol">SqueezeBertModel</span></span>
    <span class="hljs-symbol">SqueezeBertEncoder</span>
        <span class="hljs-symbol">SqueezeBertModule</span>
        <span class="hljs-symbol">SqueezeBertSelfAttention</span>
            <span class="hljs-symbol">ConvActivation</span>
            <span class="hljs-symbol">ConvDropoutLayerNorm</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-ddpap"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function xr(k){let n,f="Data layouts:",a,s,c;return s=new x({props:{code:"SW5wdXQlMjBkYXRhJTIwaXMlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBRGF0YSUyMGluc2lkZSUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBoaWRkZW5fc2l6ZSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMGZvcm1hdC4lMjBCdXQlMkMlMjBpZiUyMCU2MG91dHB1dF9oaWRkZW5fc3RhdGVzJTIwJTNEJTNEJTIwVHJ1ZSU2MCUyQyUyMHRoZSUyMGRhdGElMjBmcm9tJTIwaW5zaWRlJTIwdGhlJTIwZW5jb2RlciUyMGlzJTIwcmV0dXJuZWQlMjBpbiUyMCU1QmJhdGNoJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTJDJTIwaGlkZGVuX3NpemUlNUQlMjBmb3JtYXQuJTBBJTBBVGhlJTIwZmluYWwlMjBvdXRwdXQlMjBvZiUyMHRoZSUyMGVuY29kZXIlMjBpcyUyMGluJTIwJTVCYmF0Y2glMkMlMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjBoaWRkZW5fc2l6ZSU1RCUyMGZvcm1hdC4=",highlighted:`<span class="hljs-keyword">Input</span> data <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

Data inside the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, hidden_size, sequence_length] <span class="hljs-keyword">format</span>. But, <span class="hljs-keyword">if</span> \`output_hidden_states == <span class="hljs-keyword">True</span>\`, the data <span class="hljs-keyword">from</span> inside the encoder <span class="hljs-keyword">is</span> returned <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.

The final output <span class="hljs-keyword">of</span> the encoder <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> [batch, sequence_length, hidden_size] <span class="hljs-keyword">format</span>.`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-5h3nnb"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function Zr(k){let n,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=f},l(a){n=u(a,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=f)},m(a,s){m(a,n,s)},p:z,d(a){a&&i(n)}}}function Ir(k){let n,f="Example:",a,s,c;return s=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcXVlZXplQmVydEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTcXVlZXplQmVydEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJzcXVlZXplYmVydCUyRnNxdWVlemViZXJ0LXVuY2FzZWQlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWFuc3dlcl9zdGFydF9pbmRleCUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzLmFyZ21heCgpJTBBYW5zd2VyX2VuZF9pbmRleCUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cy5hcmdtYXgoKSUwQSUwQXByZWRpY3RfYW5zd2VyX3Rva2VucyUyMCUzRCUyMGlucHV0cy5pbnB1dF9pZHMlNUIwJTJDJTIwYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNBJTIwYW5zd2VyX2VuZF9pbmRleCUyMCUyQiUyMDElNUQlMEElMEElMjMlMjB0YXJnZXQlMjBpcyUyMCUyMm5pY2UlMjBwdXBwZXQlMjIlMEF0YXJnZXRfc3RhcnRfaW5kZXglMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMTQlNUQpJTBBdGFyZ2V0X2VuZF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNSU1RCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBzdGFydF9wb3NpdGlvbnMlM0R0YXJnZXRfc3RhcnRfaW5kZXglMkMlMjBlbmRfcG9zaXRpb25zJTNEdGFyZ2V0X2VuZF9pbmRleCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SqueezeBertForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SqueezeBertForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;squeezebert/squeezebert-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){n=p("p"),n.textContent=f,a=r(),_(s.$$.fragment)},l(e){n=u(e,"P",{"data-svelte-h":!0}),g(n)!=="svelte-11lpom8"&&(n.textContent=f),a=l(e),M(s.$$.fragment,e)},m(e,h){m(e,n,h),m(e,a,h),y(s,e,h),c=!0},p:z,i(e){c||(b(s.$$.fragment,e),c=!0)},o(e){T(s.$$.fragment,e),c=!1},d(e){e&&(i(n),i(a)),w(s,e)}}}function Vr(k){let n,f,a,s,c,e,h,Un,Ee,Qo=`The SqueezeBERT model was proposed in <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, Kurt W. Keutzer. It’s a
bidirectional transformer similar to the BERT model. The key difference between the BERT architecture and the
SqueezeBERT architecture is that SqueezeBERT uses <a href="https://blog.yani.io/filter-group-tutorial" rel="nofollow">grouped convolutions</a>
instead of fully-connected layers for the Q, K, V and FFN layers.`,Sn,Qe,Lo="The abstract from the paper is the following:",xn,Le,Ho=`<em>Humans read and write hundreds of billions of messages every day. Further, due to the availability of large datasets,
large computing systems, and better neural network models, natural language processing (NLP) technology has made
significant strides in understanding, proofreading, and organizing these messages. Thus, there is a significant
opportunity to deploy NLP in myriad applications to help web users, social networks, and businesses. In particular, we
consider smartphones and other mobile devices as crucial platforms for deploying NLP models at scale. However, today’s
highly-accurate NLP neural network models such as BERT and RoBERTa are extremely computationally expensive, with
BERT-base taking 1.7 seconds to classify a text snippet on a Pixel 3 smartphone. In this work, we observe that methods
such as grouped convolutions have yielded significant speedups for computer vision networks, but many of these
techniques have not been adopted by NLP neural network designers. We demonstrate how to replace several operations in
self-attention layers with grouped convolutions, and we use this technique in a novel network architecture called
SqueezeBERT, which runs 4.3x faster than BERT-base on the Pixel 3 while achieving competitive accuracy on the GLUE test
set. The SqueezeBERT code will be released.</em>`,Zn,He,Ao="Tips:",In,Ae,Yo=`<li>SqueezeBERT is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right
rather than the left.</li> <li>SqueezeBERT is similar to BERT and therefore relies on the masked language modeling (MLM) objective. It is therefore
efficient at predicting masked tokens and at NLU in general, but is not optimal for text generation. Models trained
with a causal language modeling (CLM) objective are better in that regard.</li> <li>For best results when finetuning on sequence classification tasks, it is recommended to start with the
<em>squeezebert/squeezebert-mnli-headless</em> checkpoint.</li>`,Vn,Ye,Po='This model was contributed by <a href="https://huggingface.co/forresti" rel="nofollow">forresti</a>.',Wn,Pe,Fn,De,Do='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li> <li><a href="../tasks/multiple_choice">Multiple choice task guide</a></li>',Xn,Oe,Gn,E,Ke,rs,qt,Oo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a>. It is used to instantiate a
SqueezeBERT model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SqueezeBERT
<a href="https://huggingface.co/squeezebert/squeezebert-uncased" rel="nofollow">squeezebert/squeezebert-uncased</a> architecture.`,ls,Jt,Ko=`Configuration objects inherit from <a href="/docs/transformers/v4.35.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,is,fe,ds,Ct,ea=`Attributes: pretrained_config_archive_map (Dict[str, str]): A dictionary containing all the available pre-trained
checkpoints.`,Rn,et,Nn,R,tt,cs,Ut,ta="Construct a SqueezeBERT tokenizer. Based on WordPiece.",ps,St,na=`This tokenizer inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,us,pe,nt,ms,xt,sa=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A SqueezeBERT sequence has the following format:`,hs,Zt,oa="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",fs,ge,st,gs,It,aa=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,_s,P,ot,Ms,Vt,ra="Create a mask from the two sequences passed to be used in a sequence-pair classification task. A SqueezeBERT",ys,_e,bs,Wt,la="If <code>token_ids_1</code> is <code>None</code>, this method only returns the first portion of the mask (0s).",Ts,Ft,at,En,rt,Qn,Q,lt,ws,Xt,ia="Construct a “fast” SqueezeBERT tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on WordPiece.",ks,Gt,da=`This tokenizer inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,zs,ue,it,$s,Rt,ca=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A SqueezeBERT sequence has the following format:`,vs,Nt,pa="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",js,D,dt,Bs,Et,ua="Create a mask from the two sequences passed to be used in a sequence-pair classification task. A SqueezeBERT",qs,Me,Js,Qt,ma="If <code>token_ids_1</code> is <code>None</code>, this method only returns the first portion of the mask (0s).",Ln,ct,Hn,$,pt,Cs,Lt,ha="The bare SqueezeBERT Model transformer outputting raw hidden-states without any specific head on top.",Us,Ht,fa=`The SqueezeBERT model was proposed in <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural
networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W.
Keutzer`,Ss,At,ga=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xs,Yt,_a=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Zs,Pt,Ma=`For best results finetuning SqueezeBERT on text classification tasks, it is recommended to use the
<em>squeezebert/squeezebert-mnli-headless</em> checkpoint as a starting point.`,Is,ye,Vs,be,Ws,O,ut,Fs,Dt,ya='The <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a> forward method, overrides the <code>__call__</code> special method.',Xs,Te,Gs,we,An,mt,Yn,v,ht,Rs,Ot,ba="SqueezeBERT Model with a <code>language modeling</code> head on top.",Ns,Kt,Ta=`The SqueezeBERT model was proposed in <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural
networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W.
Keutzer`,Es,en,wa=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qs,tn,ka=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ls,nn,za=`For best results finetuning SqueezeBERT on text classification tasks, it is recommended to use the
<em>squeezebert/squeezebert-mnli-headless</em> checkpoint as a starting point.`,Hs,ke,As,ze,Ys,K,ft,Ps,sn,$a='The <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Ds,$e,Os,ve,Pn,gt,Dn,j,_t,Ks,on,va=`SqueezeBERT Model transformer with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,eo,an,ja=`The SqueezeBERT model was proposed in <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural
networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W.
Keutzer`,to,rn,Ba=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,no,ln,qa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,so,dn,Ja=`For best results finetuning SqueezeBERT on text classification tasks, it is recommended to use the
<em>squeezebert/squeezebert-mnli-headless</em> checkpoint as a starting point.`,oo,je,ao,Be,ro,L,Mt,lo,cn,Ca='The <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertForSequenceClassification">SqueezeBertForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',io,qe,co,Je,po,Ce,On,yt,Kn,B,bt,uo,pn,Ua=`SqueezeBERT Model with a multiple choice classification head on top (a linear layer on top of the pooled output and
a softmax) e.g. for RocStories/SWAG tasks.`,mo,un,Sa=`The SqueezeBERT model was proposed in <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural
networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W.
Keutzer`,ho,mn,xa=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,fo,hn,Za=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,go,fn,Ia=`For best results finetuning SqueezeBERT on text classification tasks, it is recommended to use the
<em>squeezebert/squeezebert-mnli-headless</em> checkpoint as a starting point.`,_o,Ue,Mo,Se,yo,ee,Tt,bo,gn,Va='The <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertForMultipleChoice">SqueezeBertForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',To,xe,wo,Ze,es,wt,ts,q,kt,ko,_n,Wa=`SqueezeBERT Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks.`,zo,Mn,Fa=`The SqueezeBERT model was proposed in <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural
networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W.
Keutzer`,$o,yn,Xa=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vo,bn,Ga=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,jo,Tn,Ra=`For best results finetuning SqueezeBERT on text classification tasks, it is recommended to use the
<em>squeezebert/squeezebert-mnli-headless</em> checkpoint as a starting point.`,Bo,Ie,qo,Ve,Jo,te,zt,Co,wn,Na='The <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertForTokenClassification">SqueezeBertForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Uo,We,So,Fe,ns,$t,ss,J,vt,xo,kn,Ea=`SqueezeBERT Model with a span classification head on top for extractive question-answering tasks like SQuAD (a
linear layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Zo,zn,Qa=`The SqueezeBERT model was proposed in <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural
networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W.
Keutzer`,Io,$n,La=`This model inherits from <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vo,vn,Ha=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wo,jn,Aa=`For best results finetuning SqueezeBERT on text classification tasks, it is recommended to use the
<em>squeezebert/squeezebert-mnli-headless</em> checkpoint as a starting point.`,Fo,Xe,Xo,Ge,Go,ne,jt,Ro,Bn,Ya='The <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertForQuestionAnswering">SqueezeBertForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',No,Re,Eo,Ne,os,Jn,as;return c=new se({props:{title:"SqueezeBERT",local:"squeezebert",headingTag:"h1"}}),h=new se({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Pe=new se({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),Oe=new se({props:{title:"SqueezeBertConfig",local:"transformers.SqueezeBertConfig",headingTag:"h2"}}),Ke=new G({props:{name:"class transformers.SqueezeBertConfig",anchor:"transformers.SqueezeBertConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"embedding_size",val:" = 768"},{name:"q_groups",val:" = 4"},{name:"k_groups",val:" = 4"},{name:"v_groups",val:" = 4"},{name:"post_attention_groups",val:" = 1"},{name:"intermediate_groups",val:" = 4"},{name:"output_groups",val:" = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the SqueezeBERT model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a>.`,name:"vocab_size"},{anchor:"transformers.SqueezeBertConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SqueezeBertConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SqueezeBertConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SqueezeBertConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SqueezeBertConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SqueezeBertConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.SqueezeBertConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SqueezeBertConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SqueezeBertConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.35.1/en/model_doc/bert#transformers.BertModel">BertModel</a> or <a href="/docs/transformers/v4.35.1/en/model_doc/bert#transformers.TFBertModel">TFBertModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.SqueezeBertConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SqueezeBertConfig.layer_norm_eps",description:"<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;",name:"layer_norm_eps"},{anchor:"transformers.SqueezeBertConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The ID of the token in the word embedding to use as padding.`,name:"pad_token_id"},{anchor:"transformers.SqueezeBertConfig.embedding_size",description:`<strong>embedding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The dimension of the word embedding vectors.`,name:"embedding_size"},{anchor:"transformers.SqueezeBertConfig.q_groups",description:`<strong>q_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of groups in Q layer.`,name:"q_groups"},{anchor:"transformers.SqueezeBertConfig.k_groups",description:`<strong>k_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of groups in K layer.`,name:"k_groups"},{anchor:"transformers.SqueezeBertConfig.v_groups",description:`<strong>v_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of groups in V layer.`,name:"v_groups"},{anchor:"transformers.SqueezeBertConfig.post_attention_groups",description:`<strong>post_attention_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of groups in the first feed forward network layer.`,name:"post_attention_groups"},{anchor:"transformers.SqueezeBertConfig.intermediate_groups",description:`<strong>intermediate_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of groups in the second feed forward network layer.`,name:"intermediate_groups"},{anchor:"transformers.SqueezeBertConfig.output_groups",description:`<strong>output_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of groups in the third feed forward network layer.`,name:"output_groups"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/configuration_squeezebert.py#L37"}}),fe=new S({props:{anchor:"transformers.SqueezeBertConfig.example",$$slots:{default:[dr]},$$scope:{ctx:k}}}),et=new se({props:{title:"SqueezeBertTokenizer",local:"transformers.SqueezeBertTokenizer",headingTag:"h2"}}),tt=new G({props:{name:"class transformers.SqueezeBertTokenizer",anchor:"transformers.SqueezeBertTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SqueezeBertTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SqueezeBertTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.SqueezeBertTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.SqueezeBertTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SqueezeBertTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SqueezeBertTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SqueezeBertTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SqueezeBertTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SqueezeBertTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters.</p>
<p>This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SqueezeBertTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original SqueezeBERT).`,name:"strip_accents"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert.py#L79"}}),nt=new G({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SqueezeBertTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.SqueezeBertTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),st=new G({props:{name:"get_special_tokens_mask",anchor:"transformers.SqueezeBertTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SqueezeBertTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SqueezeBertTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.SqueezeBertTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert.py#L237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ot=new G({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.SqueezeBertTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SqueezeBertTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert.py#L265",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_e=new S({props:{anchor:"transformers.SqueezeBertTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[cr]},$$scope:{ctx:k}}}),at=new G({props:{name:"save_vocabulary",anchor:"transformers.SqueezeBertTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert.py#L294"}}),rt=new se({props:{title:"SqueezeBertTokenizerFast",local:"transformers.SqueezeBertTokenizerFast",headingTag:"h2"}}),lt=new G({props:{name:"class transformers.SqueezeBertTokenizerFast",anchor:"transformers.SqueezeBertTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"do_lower_case",val:" = True"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SqueezeBertTokenizerFast.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SqueezeBertTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SqueezeBertTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SqueezeBertTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SqueezeBertTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SqueezeBertTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SqueezeBertTokenizerFast.clean_text",description:`<strong>clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the text before tokenization by removing any control characters and replacing all
whitespaces by the classic one.`,name:"clean_text"},{anchor:"transformers.SqueezeBertTokenizerFast.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see <a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">this
issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SqueezeBertTokenizerFast.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original SqueezeBERT).`,name:"strip_accents"},{anchor:"transformers.SqueezeBertTokenizerFast.wordpieces_prefix",description:`<strong>wordpieces_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;##&quot;</code>) &#x2014;
The prefix for subwords.`,name:"wordpieces_prefix"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert_fast.py#L69"}}),it=new G({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SqueezeBertTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.SqueezeBertTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert_fast.py#L157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),dt=new G({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.SqueezeBertTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SqueezeBertTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/tokenization_squeezebert_fast.py#L181",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Me=new S({props:{anchor:"transformers.SqueezeBertTokenizerFast.create_token_type_ids_from_sequences.example",$$slots:{default:[pr]},$$scope:{ctx:k}}}),ct=new se({props:{title:"SqueezeBertModel",local:"transformers.SqueezeBertModel",headingTag:"h2"}}),pt=new G({props:{name:"class transformers.SqueezeBertModel",anchor:"transformers.SqueezeBertModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L547"}}),ye=new S({props:{anchor:"transformers.SqueezeBertModel.example",$$slots:{default:[ur]},$$scope:{ctx:k}}}),be=new S({props:{anchor:"transformers.SqueezeBertModel.example-2",$$slots:{default:[mr]},$$scope:{ctx:k}}}),ut=new G({props:{name:"forward",anchor:"transformers.SqueezeBertModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SqueezeBertModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SqueezeBertModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SqueezeBertModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SqueezeBertModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SqueezeBertModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SqueezeBertModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SqueezeBertModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SqueezeBertModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig"
>SqueezeBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new qn({props:{$$slots:{default:[hr]},$$scope:{ctx:k}}}),we=new S({props:{anchor:"transformers.SqueezeBertModel.forward.example",$$slots:{default:[fr]},$$scope:{ctx:k}}}),mt=new se({props:{title:"SqueezeBertForMaskedLM",local:"transformers.SqueezeBertForMaskedLM",headingTag:"h2"}}),ht=new G({props:{name:"class transformers.SqueezeBertForMaskedLM",anchor:"transformers.SqueezeBertForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L647"}}),ke=new S({props:{anchor:"transformers.SqueezeBertForMaskedLM.example",$$slots:{default:[gr]},$$scope:{ctx:k}}}),ze=new S({props:{anchor:"transformers.SqueezeBertForMaskedLM.example-2",$$slots:{default:[_r]},$$scope:{ctx:k}}}),ft=new G({props:{name:"forward",anchor:"transformers.SqueezeBertForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SqueezeBertForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L665",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig"
>SqueezeBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$e=new qn({props:{$$slots:{default:[Mr]},$$scope:{ctx:k}}}),ve=new S({props:{anchor:"transformers.SqueezeBertForMaskedLM.forward.example",$$slots:{default:[yr]},$$scope:{ctx:k}}}),gt=new se({props:{title:"SqueezeBertForSequenceClassification",local:"transformers.SqueezeBertForSequenceClassification",headingTag:"h2"}}),_t=new G({props:{name:"class transformers.SqueezeBertForSequenceClassification",anchor:"transformers.SqueezeBertForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L731"}}),je=new S({props:{anchor:"transformers.SqueezeBertForSequenceClassification.example",$$slots:{default:[br]},$$scope:{ctx:k}}}),Be=new S({props:{anchor:"transformers.SqueezeBertForSequenceClassification.example-2",$$slots:{default:[Tr]},$$scope:{ctx:k}}}),Mt=new G({props:{name:"forward",anchor:"transformers.SqueezeBertForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SqueezeBertForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L744",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig"
>SqueezeBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),qe=new qn({props:{$$slots:{default:[wr]},$$scope:{ctx:k}}}),Je=new S({props:{anchor:"transformers.SqueezeBertForSequenceClassification.forward.example",$$slots:{default:[kr]},$$scope:{ctx:k}}}),Ce=new S({props:{anchor:"transformers.SqueezeBertForSequenceClassification.forward.example-2",$$slots:{default:[zr]},$$scope:{ctx:k}}}),yt=new se({props:{title:"SqueezeBertForMultipleChoice",local:"transformers.SqueezeBertForMultipleChoice",headingTag:"h2"}}),bt=new G({props:{name:"class transformers.SqueezeBertForMultipleChoice",anchor:"transformers.SqueezeBertForMultipleChoice",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L830"}}),Ue=new S({props:{anchor:"transformers.SqueezeBertForMultipleChoice.example",$$slots:{default:[$r]},$$scope:{ctx:k}}}),Se=new S({props:{anchor:"transformers.SqueezeBertForMultipleChoice.example-2",$$slots:{default:[vr]},$$scope:{ctx:k}}}),Tt=new G({props:{name:"forward",anchor:"transformers.SqueezeBertForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SqueezeBertForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <em>num_choices</em> is the size of the second dimension of the input tensors. (see
<em>input_ids</em> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L841",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig"
>SqueezeBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),xe=new qn({props:{$$slots:{default:[jr]},$$scope:{ctx:k}}}),Ze=new S({props:{anchor:"transformers.SqueezeBertForMultipleChoice.forward.example",$$slots:{default:[Br]},$$scope:{ctx:k}}}),wt=new se({props:{title:"SqueezeBertForTokenClassification",local:"transformers.SqueezeBertForTokenClassification",headingTag:"h2"}}),kt=new G({props:{name:"class transformers.SqueezeBertForTokenClassification",anchor:"transformers.SqueezeBertForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L923"}}),Ie=new S({props:{anchor:"transformers.SqueezeBertForTokenClassification.example",$$slots:{default:[qr]},$$scope:{ctx:k}}}),Ve=new S({props:{anchor:"transformers.SqueezeBertForTokenClassification.example-2",$$slots:{default:[Jr]},$$scope:{ctx:k}}}),zt=new G({props:{name:"forward",anchor:"transformers.SqueezeBertForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SqueezeBertForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L935",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig"
>SqueezeBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),We=new qn({props:{$$slots:{default:[Cr]},$$scope:{ctx:k}}}),Fe=new S({props:{anchor:"transformers.SqueezeBertForTokenClassification.forward.example",$$slots:{default:[Ur]},$$scope:{ctx:k}}}),$t=new se({props:{title:"SqueezeBertForQuestionAnswering",local:"transformers.SqueezeBertForQuestionAnswering",headingTag:"h2"}}),vt=new G({props:{name:"class transformers.SqueezeBertForQuestionAnswering",anchor:"transformers.SqueezeBertForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SqueezeBertForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L1001"}}),Xe=new S({props:{anchor:"transformers.SqueezeBertForQuestionAnswering.example",$$slots:{default:[Sr]},$$scope:{ctx:k}}}),Ge=new S({props:{anchor:"transformers.SqueezeBertForQuestionAnswering.example-2",$$slots:{default:[xr]},$$scope:{ctx:k}}}),jt=new G({props:{name:"forward",anchor:"transformers.SqueezeBertForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.35.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.35.1/src/transformers/models/squeezebert/modeling_squeezebert.py#L1012",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig"
>SqueezeBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.1/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Re=new qn({props:{$$slots:{default:[Zr]},$$scope:{ctx:k}}}),Ne=new S({props:{anchor:"transformers.SqueezeBertForQuestionAnswering.forward.example",$$slots:{default:[Ir]},$$scope:{ctx:k}}}),{c(){n=p("meta"),f=r(),a=p("p"),s=r(),_(c.$$.fragment),e=r(),_(h.$$.fragment),Un=r(),Ee=p("p"),Ee.innerHTML=Qo,Sn=r(),Qe=p("p"),Qe.textContent=Lo,xn=r(),Le=p("p"),Le.innerHTML=Ho,Zn=r(),He=p("p"),He.textContent=Ao,In=r(),Ae=p("ul"),Ae.innerHTML=Yo,Vn=r(),Ye=p("p"),Ye.innerHTML=Po,Wn=r(),_(Pe.$$.fragment),Fn=r(),De=p("ul"),De.innerHTML=Do,Xn=r(),_(Oe.$$.fragment),Gn=r(),E=p("div"),_(Ke.$$.fragment),rs=r(),qt=p("p"),qt.innerHTML=Oo,ls=r(),Jt=p("p"),Jt.innerHTML=Ko,is=r(),_(fe.$$.fragment),ds=r(),Ct=p("p"),Ct.textContent=ea,Rn=r(),_(et.$$.fragment),Nn=r(),R=p("div"),_(tt.$$.fragment),cs=r(),Ut=p("p"),Ut.textContent=ta,ps=r(),St=p("p"),St.innerHTML=na,us=r(),pe=p("div"),_(nt.$$.fragment),ms=r(),xt=p("p"),xt.textContent=sa,hs=r(),Zt=p("ul"),Zt.innerHTML=oa,fs=r(),ge=p("div"),_(st.$$.fragment),gs=r(),It=p("p"),It.innerHTML=aa,_s=r(),P=p("div"),_(ot.$$.fragment),Ms=r(),Vt=p("p"),Vt.textContent=ra,ys=r(),_(_e.$$.fragment),bs=r(),Wt=p("p"),Wt.innerHTML=la,Ts=r(),Ft=p("div"),_(at.$$.fragment),En=r(),_(rt.$$.fragment),Qn=r(),Q=p("div"),_(lt.$$.fragment),ws=r(),Xt=p("p"),Xt.innerHTML=ia,ks=r(),Gt=p("p"),Gt.innerHTML=da,zs=r(),ue=p("div"),_(it.$$.fragment),$s=r(),Rt=p("p"),Rt.textContent=ca,vs=r(),Nt=p("ul"),Nt.innerHTML=pa,js=r(),D=p("div"),_(dt.$$.fragment),Bs=r(),Et=p("p"),Et.textContent=ua,qs=r(),_(Me.$$.fragment),Js=r(),Qt=p("p"),Qt.innerHTML=ma,Ln=r(),_(ct.$$.fragment),Hn=r(),$=p("div"),_(pt.$$.fragment),Cs=r(),Lt=p("p"),Lt.textContent=ha,Us=r(),Ht=p("p"),Ht.innerHTML=fa,Ss=r(),At=p("p"),At.innerHTML=ga,xs=r(),Yt=p("p"),Yt.innerHTML=_a,Zs=r(),Pt=p("p"),Pt.innerHTML=Ma,Is=r(),_(ye.$$.fragment),Vs=r(),_(be.$$.fragment),Ws=r(),O=p("div"),_(ut.$$.fragment),Fs=r(),Dt=p("p"),Dt.innerHTML=ya,Xs=r(),_(Te.$$.fragment),Gs=r(),_(we.$$.fragment),An=r(),_(mt.$$.fragment),Yn=r(),v=p("div"),_(ht.$$.fragment),Rs=r(),Ot=p("p"),Ot.innerHTML=ba,Ns=r(),Kt=p("p"),Kt.innerHTML=Ta,Es=r(),en=p("p"),en.innerHTML=wa,Qs=r(),tn=p("p"),tn.innerHTML=ka,Ls=r(),nn=p("p"),nn.innerHTML=za,Hs=r(),_(ke.$$.fragment),As=r(),_(ze.$$.fragment),Ys=r(),K=p("div"),_(ft.$$.fragment),Ps=r(),sn=p("p"),sn.innerHTML=$a,Ds=r(),_($e.$$.fragment),Os=r(),_(ve.$$.fragment),Pn=r(),_(gt.$$.fragment),Dn=r(),j=p("div"),_(_t.$$.fragment),Ks=r(),on=p("p"),on.textContent=va,eo=r(),an=p("p"),an.innerHTML=ja,to=r(),rn=p("p"),rn.innerHTML=Ba,no=r(),ln=p("p"),ln.innerHTML=qa,so=r(),dn=p("p"),dn.innerHTML=Ja,oo=r(),_(je.$$.fragment),ao=r(),_(Be.$$.fragment),ro=r(),L=p("div"),_(Mt.$$.fragment),lo=r(),cn=p("p"),cn.innerHTML=Ca,io=r(),_(qe.$$.fragment),co=r(),_(Je.$$.fragment),po=r(),_(Ce.$$.fragment),On=r(),_(yt.$$.fragment),Kn=r(),B=p("div"),_(bt.$$.fragment),uo=r(),pn=p("p"),pn.textContent=Ua,mo=r(),un=p("p"),un.innerHTML=Sa,ho=r(),mn=p("p"),mn.innerHTML=xa,fo=r(),hn=p("p"),hn.innerHTML=Za,go=r(),fn=p("p"),fn.innerHTML=Ia,_o=r(),_(Ue.$$.fragment),Mo=r(),_(Se.$$.fragment),yo=r(),ee=p("div"),_(Tt.$$.fragment),bo=r(),gn=p("p"),gn.innerHTML=Va,To=r(),_(xe.$$.fragment),wo=r(),_(Ze.$$.fragment),es=r(),_(wt.$$.fragment),ts=r(),q=p("div"),_(kt.$$.fragment),ko=r(),_n=p("p"),_n.textContent=Wa,zo=r(),Mn=p("p"),Mn.innerHTML=Fa,$o=r(),yn=p("p"),yn.innerHTML=Xa,vo=r(),bn=p("p"),bn.innerHTML=Ga,jo=r(),Tn=p("p"),Tn.innerHTML=Ra,Bo=r(),_(Ie.$$.fragment),qo=r(),_(Ve.$$.fragment),Jo=r(),te=p("div"),_(zt.$$.fragment),Co=r(),wn=p("p"),wn.innerHTML=Na,Uo=r(),_(We.$$.fragment),So=r(),_(Fe.$$.fragment),ns=r(),_($t.$$.fragment),ss=r(),J=p("div"),_(vt.$$.fragment),xo=r(),kn=p("p"),kn.innerHTML=Ea,Zo=r(),zn=p("p"),zn.innerHTML=Qa,Io=r(),$n=p("p"),$n.innerHTML=La,Vo=r(),vn=p("p"),vn.innerHTML=Ha,Wo=r(),jn=p("p"),jn.innerHTML=Aa,Fo=r(),_(Xe.$$.fragment),Xo=r(),_(Ge.$$.fragment),Go=r(),ne=p("div"),_(jt.$$.fragment),Ro=r(),Bn=p("p"),Bn.innerHTML=Ya,No=r(),_(Re.$$.fragment),Eo=r(),_(Ne.$$.fragment),os=r(),Jn=p("p"),this.h()},l(t){const d=lr("svelte-u9bgzb",document.head);n=u(d,"META",{name:!0,content:!0}),d.forEach(i),f=l(t),a=u(t,"P",{}),C(a).forEach(i),s=l(t),M(c.$$.fragment,t),e=l(t),M(h.$$.fragment,t),Un=l(t),Ee=u(t,"P",{"data-svelte-h":!0}),g(Ee)!=="svelte-c24mw5"&&(Ee.innerHTML=Qo),Sn=l(t),Qe=u(t,"P",{"data-svelte-h":!0}),g(Qe)!=="svelte-vfdo9a"&&(Qe.textContent=Lo),xn=l(t),Le=u(t,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-1emzktv"&&(Le.innerHTML=Ho),Zn=l(t),He=u(t,"P",{"data-svelte-h":!0}),g(He)!=="svelte-axv494"&&(He.textContent=Ao),In=l(t),Ae=u(t,"UL",{"data-svelte-h":!0}),g(Ae)!=="svelte-6f7ytb"&&(Ae.innerHTML=Yo),Vn=l(t),Ye=u(t,"P",{"data-svelte-h":!0}),g(Ye)!=="svelte-1e4x21"&&(Ye.innerHTML=Po),Wn=l(t),M(Pe.$$.fragment,t),Fn=l(t),De=u(t,"UL",{"data-svelte-h":!0}),g(De)!=="svelte-mgusi3"&&(De.innerHTML=Do),Xn=l(t),M(Oe.$$.fragment,t),Gn=l(t),E=u(t,"DIV",{class:!0});var H=C(E);M(Ke.$$.fragment,H),rs=l(H),qt=u(H,"P",{"data-svelte-h":!0}),g(qt)!=="svelte-30ck72"&&(qt.innerHTML=Oo),ls=l(H),Jt=u(H,"P",{"data-svelte-h":!0}),g(Jt)!=="svelte-vwygs5"&&(Jt.innerHTML=Ko),is=l(H),M(fe.$$.fragment,H),ds=l(H),Ct=u(H,"P",{"data-svelte-h":!0}),g(Ct)!=="svelte-d6jcef"&&(Ct.textContent=ea),H.forEach(i),Rn=l(t),M(et.$$.fragment,t),Nn=l(t),R=u(t,"DIV",{class:!0});var N=C(R);M(tt.$$.fragment,N),cs=l(N),Ut=u(N,"P",{"data-svelte-h":!0}),g(Ut)!=="svelte-1jixb9u"&&(Ut.textContent=ta),ps=l(N),St=u(N,"P",{"data-svelte-h":!0}),g(St)!=="svelte-dc76nq"&&(St.innerHTML=na),us=l(N),pe=u(N,"DIV",{class:!0});var me=C(pe);M(nt.$$.fragment,me),ms=l(me),xt=u(me,"P",{"data-svelte-h":!0}),g(xt)!=="svelte-19k3keo"&&(xt.textContent=sa),hs=l(me),Zt=u(me,"UL",{"data-svelte-h":!0}),g(Zt)!=="svelte-xi6653"&&(Zt.innerHTML=oa),me.forEach(i),fs=l(N),ge=u(N,"DIV",{class:!0});var Bt=C(ge);M(st.$$.fragment,Bt),gs=l(Bt),It=u(Bt,"P",{"data-svelte-h":!0}),g(It)!=="svelte-1f4f5kp"&&(It.innerHTML=aa),Bt.forEach(i),_s=l(N),P=u(N,"DIV",{class:!0});var oe=C(P);M(ot.$$.fragment,oe),Ms=l(oe),Vt=u(oe,"P",{"data-svelte-h":!0}),g(Vt)!=="svelte-xscjvq"&&(Vt.textContent=ra),ys=l(oe),M(_e.$$.fragment,oe),bs=l(oe),Wt=u(oe,"P",{"data-svelte-h":!0}),g(Wt)!=="svelte-owoxgn"&&(Wt.innerHTML=la),oe.forEach(i),Ts=l(N),Ft=u(N,"DIV",{class:!0});var Cn=C(Ft);M(at.$$.fragment,Cn),Cn.forEach(i),N.forEach(i),En=l(t),M(rt.$$.fragment,t),Qn=l(t),Q=u(t,"DIV",{class:!0});var A=C(Q);M(lt.$$.fragment,A),ws=l(A),Xt=u(A,"P",{"data-svelte-h":!0}),g(Xt)!=="svelte-56e233"&&(Xt.innerHTML=ia),ks=l(A),Gt=u(A,"P",{"data-svelte-h":!0}),g(Gt)!=="svelte-om9ndu"&&(Gt.innerHTML=da),zs=l(A),ue=u(A,"DIV",{class:!0});var he=C(ue);M(it.$$.fragment,he),$s=l(he),Rt=u(he,"P",{"data-svelte-h":!0}),g(Rt)!=="svelte-19k3keo"&&(Rt.textContent=ca),vs=l(he),Nt=u(he,"UL",{"data-svelte-h":!0}),g(Nt)!=="svelte-xi6653"&&(Nt.innerHTML=pa),he.forEach(i),js=l(A),D=u(A,"DIV",{class:!0});var ae=C(D);M(dt.$$.fragment,ae),Bs=l(ae),Et=u(ae,"P",{"data-svelte-h":!0}),g(Et)!=="svelte-xscjvq"&&(Et.textContent=ua),qs=l(ae),M(Me.$$.fragment,ae),Js=l(ae),Qt=u(ae,"P",{"data-svelte-h":!0}),g(Qt)!=="svelte-owoxgn"&&(Qt.innerHTML=ma),ae.forEach(i),A.forEach(i),Ln=l(t),M(ct.$$.fragment,t),Hn=l(t),$=u(t,"DIV",{class:!0});var Z=C($);M(pt.$$.fragment,Z),Cs=l(Z),Lt=u(Z,"P",{"data-svelte-h":!0}),g(Lt)!=="svelte-16cmvyq"&&(Lt.textContent=ha),Us=l(Z),Ht=u(Z,"P",{"data-svelte-h":!0}),g(Ht)!=="svelte-1w0u28z"&&(Ht.innerHTML=fa),Ss=l(Z),At=u(Z,"P",{"data-svelte-h":!0}),g(At)!=="svelte-wn3f6s"&&(At.innerHTML=ga),xs=l(Z),Yt=u(Z,"P",{"data-svelte-h":!0}),g(Yt)!=="svelte-hswkmf"&&(Yt.innerHTML=_a),Zs=l(Z),Pt=u(Z,"P",{"data-svelte-h":!0}),g(Pt)!=="svelte-7hyh0a"&&(Pt.innerHTML=Ma),Is=l(Z),M(ye.$$.fragment,Z),Vs=l(Z),M(be.$$.fragment,Z),Ws=l(Z),O=u(Z,"DIV",{class:!0});var re=C(O);M(ut.$$.fragment,re),Fs=l(re),Dt=u(re,"P",{"data-svelte-h":!0}),g(Dt)!=="svelte-1eit5q0"&&(Dt.innerHTML=ya),Xs=l(re),M(Te.$$.fragment,re),Gs=l(re),M(we.$$.fragment,re),re.forEach(i),Z.forEach(i),An=l(t),M(mt.$$.fragment,t),Yn=l(t),v=u(t,"DIV",{class:!0});var I=C(v);M(ht.$$.fragment,I),Rs=l(I),Ot=u(I,"P",{"data-svelte-h":!0}),g(Ot)!=="svelte-1xelfoh"&&(Ot.innerHTML=ba),Ns=l(I),Kt=u(I,"P",{"data-svelte-h":!0}),g(Kt)!=="svelte-1w0u28z"&&(Kt.innerHTML=Ta),Es=l(I),en=u(I,"P",{"data-svelte-h":!0}),g(en)!=="svelte-wn3f6s"&&(en.innerHTML=wa),Qs=l(I),tn=u(I,"P",{"data-svelte-h":!0}),g(tn)!=="svelte-hswkmf"&&(tn.innerHTML=ka),Ls=l(I),nn=u(I,"P",{"data-svelte-h":!0}),g(nn)!=="svelte-7hyh0a"&&(nn.innerHTML=za),Hs=l(I),M(ke.$$.fragment,I),As=l(I),M(ze.$$.fragment,I),Ys=l(I),K=u(I,"DIV",{class:!0});var le=C(K);M(ft.$$.fragment,le),Ps=l(le),sn=u(le,"P",{"data-svelte-h":!0}),g(sn)!=="svelte-o30x3s"&&(sn.innerHTML=$a),Ds=l(le),M($e.$$.fragment,le),Os=l(le),M(ve.$$.fragment,le),le.forEach(i),I.forEach(i),Pn=l(t),M(gt.$$.fragment,t),Dn=l(t),j=u(t,"DIV",{class:!0});var V=C(j);M(_t.$$.fragment,V),Ks=l(V),on=u(V,"P",{"data-svelte-h":!0}),g(on)!=="svelte-13ur6tp"&&(on.textContent=va),eo=l(V),an=u(V,"P",{"data-svelte-h":!0}),g(an)!=="svelte-1w0u28z"&&(an.innerHTML=ja),to=l(V),rn=u(V,"P",{"data-svelte-h":!0}),g(rn)!=="svelte-wn3f6s"&&(rn.innerHTML=Ba),no=l(V),ln=u(V,"P",{"data-svelte-h":!0}),g(ln)!=="svelte-hswkmf"&&(ln.innerHTML=qa),so=l(V),dn=u(V,"P",{"data-svelte-h":!0}),g(dn)!=="svelte-7hyh0a"&&(dn.innerHTML=Ja),oo=l(V),M(je.$$.fragment,V),ao=l(V),M(Be.$$.fragment,V),ro=l(V),L=u(V,"DIV",{class:!0});var Y=C(L);M(Mt.$$.fragment,Y),lo=l(Y),cn=u(Y,"P",{"data-svelte-h":!0}),g(cn)!=="svelte-tt9jry"&&(cn.innerHTML=Ca),io=l(Y),M(qe.$$.fragment,Y),co=l(Y),M(Je.$$.fragment,Y),po=l(Y),M(Ce.$$.fragment,Y),Y.forEach(i),V.forEach(i),On=l(t),M(yt.$$.fragment,t),Kn=l(t),B=u(t,"DIV",{class:!0});var W=C(B);M(bt.$$.fragment,W),uo=l(W),pn=u(W,"P",{"data-svelte-h":!0}),g(pn)!=="svelte-16ytd0h"&&(pn.textContent=Ua),mo=l(W),un=u(W,"P",{"data-svelte-h":!0}),g(un)!=="svelte-1w0u28z"&&(un.innerHTML=Sa),ho=l(W),mn=u(W,"P",{"data-svelte-h":!0}),g(mn)!=="svelte-wn3f6s"&&(mn.innerHTML=xa),fo=l(W),hn=u(W,"P",{"data-svelte-h":!0}),g(hn)!=="svelte-hswkmf"&&(hn.innerHTML=Za),go=l(W),fn=u(W,"P",{"data-svelte-h":!0}),g(fn)!=="svelte-7hyh0a"&&(fn.innerHTML=Ia),_o=l(W),M(Ue.$$.fragment,W),Mo=l(W),M(Se.$$.fragment,W),yo=l(W),ee=u(W,"DIV",{class:!0});var ie=C(ee);M(Tt.$$.fragment,ie),bo=l(ie),gn=u(ie,"P",{"data-svelte-h":!0}),g(gn)!=="svelte-1jkf4ny"&&(gn.innerHTML=Va),To=l(ie),M(xe.$$.fragment,ie),wo=l(ie),M(Ze.$$.fragment,ie),ie.forEach(i),W.forEach(i),es=l(t),M(wt.$$.fragment,t),ts=l(t),q=u(t,"DIV",{class:!0});var F=C(q);M(kt.$$.fragment,F),ko=l(F),_n=u(F,"P",{"data-svelte-h":!0}),g(_n)!=="svelte-mxl4k"&&(_n.textContent=Wa),zo=l(F),Mn=u(F,"P",{"data-svelte-h":!0}),g(Mn)!=="svelte-1w0u28z"&&(Mn.innerHTML=Fa),$o=l(F),yn=u(F,"P",{"data-svelte-h":!0}),g(yn)!=="svelte-wn3f6s"&&(yn.innerHTML=Xa),vo=l(F),bn=u(F,"P",{"data-svelte-h":!0}),g(bn)!=="svelte-hswkmf"&&(bn.innerHTML=Ga),jo=l(F),Tn=u(F,"P",{"data-svelte-h":!0}),g(Tn)!=="svelte-7hyh0a"&&(Tn.innerHTML=Ra),Bo=l(F),M(Ie.$$.fragment,F),qo=l(F),M(Ve.$$.fragment,F),Jo=l(F),te=u(F,"DIV",{class:!0});var de=C(te);M(zt.$$.fragment,de),Co=l(de),wn=u(de,"P",{"data-svelte-h":!0}),g(wn)!=="svelte-32xeyc"&&(wn.innerHTML=Na),Uo=l(de),M(We.$$.fragment,de),So=l(de),M(Fe.$$.fragment,de),de.forEach(i),F.forEach(i),ns=l(t),M($t.$$.fragment,t),ss=l(t),J=u(t,"DIV",{class:!0});var X=C(J);M(vt.$$.fragment,X),xo=l(X),kn=u(X,"P",{"data-svelte-h":!0}),g(kn)!=="svelte-23oevy"&&(kn.innerHTML=Ea),Zo=l(X),zn=u(X,"P",{"data-svelte-h":!0}),g(zn)!=="svelte-1w0u28z"&&(zn.innerHTML=Qa),Io=l(X),$n=u(X,"P",{"data-svelte-h":!0}),g($n)!=="svelte-wn3f6s"&&($n.innerHTML=La),Vo=l(X),vn=u(X,"P",{"data-svelte-h":!0}),g(vn)!=="svelte-hswkmf"&&(vn.innerHTML=Ha),Wo=l(X),jn=u(X,"P",{"data-svelte-h":!0}),g(jn)!=="svelte-7hyh0a"&&(jn.innerHTML=Aa),Fo=l(X),M(Xe.$$.fragment,X),Xo=l(X),M(Ge.$$.fragment,X),Go=l(X),ne=u(X,"DIV",{class:!0});var ce=C(ne);M(jt.$$.fragment,ce),Ro=l(ce),Bn=u(ce,"P",{"data-svelte-h":!0}),g(Bn)!=="svelte-1ux0a48"&&(Bn.innerHTML=Ya),No=l(ce),M(Re.$$.fragment,ce),Eo=l(ce),M(Ne.$$.fragment,ce),ce.forEach(i),X.forEach(i),os=l(t),Jn=u(t,"P",{}),C(Jn).forEach(i),this.h()},h(){U(n,"name","hf:doc:metadata"),U(n,"content",Wr),U(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,d){o(document.head,n),m(t,f,d),m(t,a,d),m(t,s,d),y(c,t,d),m(t,e,d),y(h,t,d),m(t,Un,d),m(t,Ee,d),m(t,Sn,d),m(t,Qe,d),m(t,xn,d),m(t,Le,d),m(t,Zn,d),m(t,He,d),m(t,In,d),m(t,Ae,d),m(t,Vn,d),m(t,Ye,d),m(t,Wn,d),y(Pe,t,d),m(t,Fn,d),m(t,De,d),m(t,Xn,d),y(Oe,t,d),m(t,Gn,d),m(t,E,d),y(Ke,E,null),o(E,rs),o(E,qt),o(E,ls),o(E,Jt),o(E,is),y(fe,E,null),o(E,ds),o(E,Ct),m(t,Rn,d),y(et,t,d),m(t,Nn,d),m(t,R,d),y(tt,R,null),o(R,cs),o(R,Ut),o(R,ps),o(R,St),o(R,us),o(R,pe),y(nt,pe,null),o(pe,ms),o(pe,xt),o(pe,hs),o(pe,Zt),o(R,fs),o(R,ge),y(st,ge,null),o(ge,gs),o(ge,It),o(R,_s),o(R,P),y(ot,P,null),o(P,Ms),o(P,Vt),o(P,ys),y(_e,P,null),o(P,bs),o(P,Wt),o(R,Ts),o(R,Ft),y(at,Ft,null),m(t,En,d),y(rt,t,d),m(t,Qn,d),m(t,Q,d),y(lt,Q,null),o(Q,ws),o(Q,Xt),o(Q,ks),o(Q,Gt),o(Q,zs),o(Q,ue),y(it,ue,null),o(ue,$s),o(ue,Rt),o(ue,vs),o(ue,Nt),o(Q,js),o(Q,D),y(dt,D,null),o(D,Bs),o(D,Et),o(D,qs),y(Me,D,null),o(D,Js),o(D,Qt),m(t,Ln,d),y(ct,t,d),m(t,Hn,d),m(t,$,d),y(pt,$,null),o($,Cs),o($,Lt),o($,Us),o($,Ht),o($,Ss),o($,At),o($,xs),o($,Yt),o($,Zs),o($,Pt),o($,Is),y(ye,$,null),o($,Vs),y(be,$,null),o($,Ws),o($,O),y(ut,O,null),o(O,Fs),o(O,Dt),o(O,Xs),y(Te,O,null),o(O,Gs),y(we,O,null),m(t,An,d),y(mt,t,d),m(t,Yn,d),m(t,v,d),y(ht,v,null),o(v,Rs),o(v,Ot),o(v,Ns),o(v,Kt),o(v,Es),o(v,en),o(v,Qs),o(v,tn),o(v,Ls),o(v,nn),o(v,Hs),y(ke,v,null),o(v,As),y(ze,v,null),o(v,Ys),o(v,K),y(ft,K,null),o(K,Ps),o(K,sn),o(K,Ds),y($e,K,null),o(K,Os),y(ve,K,null),m(t,Pn,d),y(gt,t,d),m(t,Dn,d),m(t,j,d),y(_t,j,null),o(j,Ks),o(j,on),o(j,eo),o(j,an),o(j,to),o(j,rn),o(j,no),o(j,ln),o(j,so),o(j,dn),o(j,oo),y(je,j,null),o(j,ao),y(Be,j,null),o(j,ro),o(j,L),y(Mt,L,null),o(L,lo),o(L,cn),o(L,io),y(qe,L,null),o(L,co),y(Je,L,null),o(L,po),y(Ce,L,null),m(t,On,d),y(yt,t,d),m(t,Kn,d),m(t,B,d),y(bt,B,null),o(B,uo),o(B,pn),o(B,mo),o(B,un),o(B,ho),o(B,mn),o(B,fo),o(B,hn),o(B,go),o(B,fn),o(B,_o),y(Ue,B,null),o(B,Mo),y(Se,B,null),o(B,yo),o(B,ee),y(Tt,ee,null),o(ee,bo),o(ee,gn),o(ee,To),y(xe,ee,null),o(ee,wo),y(Ze,ee,null),m(t,es,d),y(wt,t,d),m(t,ts,d),m(t,q,d),y(kt,q,null),o(q,ko),o(q,_n),o(q,zo),o(q,Mn),o(q,$o),o(q,yn),o(q,vo),o(q,bn),o(q,jo),o(q,Tn),o(q,Bo),y(Ie,q,null),o(q,qo),y(Ve,q,null),o(q,Jo),o(q,te),y(zt,te,null),o(te,Co),o(te,wn),o(te,Uo),y(We,te,null),o(te,So),y(Fe,te,null),m(t,ns,d),y($t,t,d),m(t,ss,d),m(t,J,d),y(vt,J,null),o(J,xo),o(J,kn),o(J,Zo),o(J,zn),o(J,Io),o(J,$n),o(J,Vo),o(J,vn),o(J,Wo),o(J,jn),o(J,Fo),y(Xe,J,null),o(J,Xo),y(Ge,J,null),o(J,Go),o(J,ne),y(jt,ne,null),o(ne,Ro),o(ne,Bn),o(ne,No),y(Re,ne,null),o(ne,Eo),y(Ne,ne,null),m(t,os,d),m(t,Jn,d),as=!0},p(t,[d]){const H={};d&2&&(H.$$scope={dirty:d,ctx:t}),fe.$set(H);const N={};d&2&&(N.$$scope={dirty:d,ctx:t}),_e.$set(N);const me={};d&2&&(me.$$scope={dirty:d,ctx:t}),Me.$set(me);const Bt={};d&2&&(Bt.$$scope={dirty:d,ctx:t}),ye.$set(Bt);const oe={};d&2&&(oe.$$scope={dirty:d,ctx:t}),be.$set(oe);const Cn={};d&2&&(Cn.$$scope={dirty:d,ctx:t}),Te.$set(Cn);const A={};d&2&&(A.$$scope={dirty:d,ctx:t}),we.$set(A);const he={};d&2&&(he.$$scope={dirty:d,ctx:t}),ke.$set(he);const ae={};d&2&&(ae.$$scope={dirty:d,ctx:t}),ze.$set(ae);const Z={};d&2&&(Z.$$scope={dirty:d,ctx:t}),$e.$set(Z);const re={};d&2&&(re.$$scope={dirty:d,ctx:t}),ve.$set(re);const I={};d&2&&(I.$$scope={dirty:d,ctx:t}),je.$set(I);const le={};d&2&&(le.$$scope={dirty:d,ctx:t}),Be.$set(le);const V={};d&2&&(V.$$scope={dirty:d,ctx:t}),qe.$set(V);const Y={};d&2&&(Y.$$scope={dirty:d,ctx:t}),Je.$set(Y);const W={};d&2&&(W.$$scope={dirty:d,ctx:t}),Ce.$set(W);const ie={};d&2&&(ie.$$scope={dirty:d,ctx:t}),Ue.$set(ie);const F={};d&2&&(F.$$scope={dirty:d,ctx:t}),Se.$set(F);const de={};d&2&&(de.$$scope={dirty:d,ctx:t}),xe.$set(de);const X={};d&2&&(X.$$scope={dirty:d,ctx:t}),Ze.$set(X);const ce={};d&2&&(ce.$$scope={dirty:d,ctx:t}),Ie.$set(ce);const Pa={};d&2&&(Pa.$$scope={dirty:d,ctx:t}),Ve.$set(Pa);const Da={};d&2&&(Da.$$scope={dirty:d,ctx:t}),We.$set(Da);const Oa={};d&2&&(Oa.$$scope={dirty:d,ctx:t}),Fe.$set(Oa);const Ka={};d&2&&(Ka.$$scope={dirty:d,ctx:t}),Xe.$set(Ka);const er={};d&2&&(er.$$scope={dirty:d,ctx:t}),Ge.$set(er);const tr={};d&2&&(tr.$$scope={dirty:d,ctx:t}),Re.$set(tr);const nr={};d&2&&(nr.$$scope={dirty:d,ctx:t}),Ne.$set(nr)},i(t){as||(b(c.$$.fragment,t),b(h.$$.fragment,t),b(Pe.$$.fragment,t),b(Oe.$$.fragment,t),b(Ke.$$.fragment,t),b(fe.$$.fragment,t),b(et.$$.fragment,t),b(tt.$$.fragment,t),b(nt.$$.fragment,t),b(st.$$.fragment,t),b(ot.$$.fragment,t),b(_e.$$.fragment,t),b(at.$$.fragment,t),b(rt.$$.fragment,t),b(lt.$$.fragment,t),b(it.$$.fragment,t),b(dt.$$.fragment,t),b(Me.$$.fragment,t),b(ct.$$.fragment,t),b(pt.$$.fragment,t),b(ye.$$.fragment,t),b(be.$$.fragment,t),b(ut.$$.fragment,t),b(Te.$$.fragment,t),b(we.$$.fragment,t),b(mt.$$.fragment,t),b(ht.$$.fragment,t),b(ke.$$.fragment,t),b(ze.$$.fragment,t),b(ft.$$.fragment,t),b($e.$$.fragment,t),b(ve.$$.fragment,t),b(gt.$$.fragment,t),b(_t.$$.fragment,t),b(je.$$.fragment,t),b(Be.$$.fragment,t),b(Mt.$$.fragment,t),b(qe.$$.fragment,t),b(Je.$$.fragment,t),b(Ce.$$.fragment,t),b(yt.$$.fragment,t),b(bt.$$.fragment,t),b(Ue.$$.fragment,t),b(Se.$$.fragment,t),b(Tt.$$.fragment,t),b(xe.$$.fragment,t),b(Ze.$$.fragment,t),b(wt.$$.fragment,t),b(kt.$$.fragment,t),b(Ie.$$.fragment,t),b(Ve.$$.fragment,t),b(zt.$$.fragment,t),b(We.$$.fragment,t),b(Fe.$$.fragment,t),b($t.$$.fragment,t),b(vt.$$.fragment,t),b(Xe.$$.fragment,t),b(Ge.$$.fragment,t),b(jt.$$.fragment,t),b(Re.$$.fragment,t),b(Ne.$$.fragment,t),as=!0)},o(t){T(c.$$.fragment,t),T(h.$$.fragment,t),T(Pe.$$.fragment,t),T(Oe.$$.fragment,t),T(Ke.$$.fragment,t),T(fe.$$.fragment,t),T(et.$$.fragment,t),T(tt.$$.fragment,t),T(nt.$$.fragment,t),T(st.$$.fragment,t),T(ot.$$.fragment,t),T(_e.$$.fragment,t),T(at.$$.fragment,t),T(rt.$$.fragment,t),T(lt.$$.fragment,t),T(it.$$.fragment,t),T(dt.$$.fragment,t),T(Me.$$.fragment,t),T(ct.$$.fragment,t),T(pt.$$.fragment,t),T(ye.$$.fragment,t),T(be.$$.fragment,t),T(ut.$$.fragment,t),T(Te.$$.fragment,t),T(we.$$.fragment,t),T(mt.$$.fragment,t),T(ht.$$.fragment,t),T(ke.$$.fragment,t),T(ze.$$.fragment,t),T(ft.$$.fragment,t),T($e.$$.fragment,t),T(ve.$$.fragment,t),T(gt.$$.fragment,t),T(_t.$$.fragment,t),T(je.$$.fragment,t),T(Be.$$.fragment,t),T(Mt.$$.fragment,t),T(qe.$$.fragment,t),T(Je.$$.fragment,t),T(Ce.$$.fragment,t),T(yt.$$.fragment,t),T(bt.$$.fragment,t),T(Ue.$$.fragment,t),T(Se.$$.fragment,t),T(Tt.$$.fragment,t),T(xe.$$.fragment,t),T(Ze.$$.fragment,t),T(wt.$$.fragment,t),T(kt.$$.fragment,t),T(Ie.$$.fragment,t),T(Ve.$$.fragment,t),T(zt.$$.fragment,t),T(We.$$.fragment,t),T(Fe.$$.fragment,t),T($t.$$.fragment,t),T(vt.$$.fragment,t),T(Xe.$$.fragment,t),T(Ge.$$.fragment,t),T(jt.$$.fragment,t),T(Re.$$.fragment,t),T(Ne.$$.fragment,t),as=!1},d(t){t&&(i(f),i(a),i(s),i(e),i(Un),i(Ee),i(Sn),i(Qe),i(xn),i(Le),i(Zn),i(He),i(In),i(Ae),i(Vn),i(Ye),i(Wn),i(Fn),i(De),i(Xn),i(Gn),i(E),i(Rn),i(Nn),i(R),i(En),i(Qn),i(Q),i(Ln),i(Hn),i($),i(An),i(Yn),i(v),i(Pn),i(Dn),i(j),i(On),i(Kn),i(B),i(es),i(ts),i(q),i(ns),i(ss),i(J),i(os),i(Jn)),i(n),w(c,t),w(h,t),w(Pe,t),w(Oe,t),w(Ke),w(fe),w(et,t),w(tt),w(nt),w(st),w(ot),w(_e),w(at),w(rt,t),w(lt),w(it),w(dt),w(Me),w(ct,t),w(pt),w(ye),w(be),w(ut),w(Te),w(we),w(mt,t),w(ht),w(ke),w(ze),w(ft),w($e),w(ve),w(gt,t),w(_t),w(je),w(Be),w(Mt),w(qe),w(Je),w(Ce),w(yt,t),w(bt),w(Ue),w(Se),w(Tt),w(xe),w(Ze),w(wt,t),w(kt),w(Ie),w(Ve),w(zt),w(We),w(Fe),w($t,t),w(vt),w(Xe),w(Ge),w(jt),w(Re),w(Ne)}}}const Wr='{"title":"SqueezeBERT","local":"squeezebert","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"SqueezeBertConfig","local":"transformers.SqueezeBertConfig","sections":[],"depth":2},{"title":"SqueezeBertTokenizer","local":"transformers.SqueezeBertTokenizer","sections":[],"depth":2},{"title":"SqueezeBertTokenizerFast","local":"transformers.SqueezeBertTokenizerFast","sections":[],"depth":2},{"title":"SqueezeBertModel","local":"transformers.SqueezeBertModel","sections":[],"depth":2},{"title":"SqueezeBertForMaskedLM","local":"transformers.SqueezeBertForMaskedLM","sections":[],"depth":2},{"title":"SqueezeBertForSequenceClassification","local":"transformers.SqueezeBertForSequenceClassification","sections":[],"depth":2},{"title":"SqueezeBertForMultipleChoice","local":"transformers.SqueezeBertForMultipleChoice","sections":[],"depth":2},{"title":"SqueezeBertForTokenClassification","local":"transformers.SqueezeBertForTokenClassification","sections":[],"depth":2},{"title":"SqueezeBertForQuestionAnswering","local":"transformers.SqueezeBertForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function Fr(k){return or(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ir}),[]}class Hr extends ar{constructor(n){super(),rr(this,n,Fr,Vr,sr,{})}}export{Hr as component};
