import{s as Nt,f as Vt,o as Xt,n as E}from"../chunks/scheduler.9bc65507.js";import{S as Et,i as St,g as c,s as r,r as w,A as Ht,h as p,f as o,c as i,j as ee,u as b,x as f,k as P,y as h,a as l,v as j,d as J,t as U,w as v}from"../chunks/index.707bf1b6.js";import{T as js}from"../chunks/Tip.c2ecdbf4.js";import{D as oe}from"../chunks/Docstring.17db21ae.js";import{C as ce}from"../chunks/CodeBlock.54a9f38d.js";import{F as mt,M as Cs}from"../chunks/Markdown.fef84341.js";import{E as zs}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as xe}from"../chunks/Heading.342b1fa6.js";function Yt(C){let e,d="Initializing a model with a pre-trained base and randomly initialized classification heads from the hub can be done as shown below.",s,n,m,a,u='Of course, you don’t necessarily have to follow one of these three ways in which TAPAS was fine-tuned. You can also experiment by defining any hyperparameters you want when initializing <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, and then create a <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> based on that configuration. For example, if you have a dataset that has both conversational questions and questions that might involve aggregation, then you can do it this way. Here’s an example:',W,y,F;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMGZvciUyMGV4YW1wbGUlMkMlMjB0aGUlMjBiYXNlJTIwc2l6ZWQlMjBtb2RlbCUyMHdpdGglMjBkZWZhdWx0JTIwU1FBJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdUUSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWclMjAlM0QlMjBUYXBhc0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdpa2lTUUwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcoJTIyZ29vZ2xlLWJhc2UtZmluZXR1bmVkLXdpa2lzcWwtc3VwZXJ2aXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIlMkMlMjBjb25maWclM0Rjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for example, the base sized model with default SQA configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WikiSQL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(<span class="hljs-string">&quot;google-base-finetuned-wikisql-supervised&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),y=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMHlvdSUyMGNhbiUyMGluaXRpYWxpemUlMjB0aGUlMjBjbGFzc2lmaWNhdGlvbiUyMGhlYWRzJTIwYW55JTIwd2F5JTIweW91JTIwd2FudCUyMChzZWUlMjBkb2NzJTIwb2YlMjBUYXBhc0NvbmZpZyklMEFjb25maWclMjAlM0QlMjBUYXBhc0NvbmZpZyhudW1fYWdncmVnYXRpb25fbGFiZWxzJTNEMyUyQyUyMGF2ZXJhZ2VfbG9naXRzX3Blcl9jZWxsJTNEVHJ1ZSklMEElMjMlMjBpbml0aWFsaXppbmclMjB0aGUlMjBwcmUtdHJhaW5lZCUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMG91ciUyMGN1c3RvbSUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZHMlMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIlMkMlMjBjb25maWclM0Rjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can initialize the classification heads any way you want (see docs of TapasConfig)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(num_aggregation_labels=<span class="hljs-number">3</span>, average_logits_per_cell=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initializing the pre-trained base sized model with our custom classification heads</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment),m=r(),a=c("p"),a.innerHTML=u,W=r(),w(y.$$.fragment)},l(I){e=p(I,"P",{"data-svelte-h":!0}),f(e)!=="svelte-4jdzmp"&&(e.textContent=d),s=i(I),b(n.$$.fragment,I),m=i(I),a=p(I,"P",{"data-svelte-h":!0}),f(a)!=="svelte-15hr3r8"&&(a.innerHTML=u),W=i(I),b(y.$$.fragment,I)},m(I,Z){l(I,e,Z),l(I,s,Z),j(n,I,Z),l(I,m,Z),l(I,a,Z),l(I,W,Z),j(y,I,Z),F=!0},p:E,i(I){F||(J(n.$$.fragment,I),J(y.$$.fragment,I),F=!0)},o(I){U(n.$$.fragment,I),U(y.$$.fragment,I),F=!1},d(I){I&&(o(e),o(s),o(m),o(a),o(W)),v(n,I),v(y,I)}}}function Lt(C){let e,d;return e=new Cs({props:{$$slots:{default:[Yt]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function Pt(C){let e,d='Initializing a model with a pre-trained base and randomly initialized classification heads from the hub can be done as shown below. Be sure to have installed the <a href="https://github.com/tensorflow/probability" rel="nofollow">tensorflow_probability</a> dependency:',s,n,m,a,u='Of course, you don’t necessarily have to follow one of these three ways in which TAPAS was fine-tuned. You can also experiment by defining any hyperparameters you want when initializing <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, and then create a <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> based on that configuration. For example, if you have a dataset that has both conversational questions and questions that might involve aggregation, then you can do it this way. Here’s an example:',W,y,F;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwZm9yJTIwZXhhbXBsZSUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMGRlZmF1bHQlMjBTUUElMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBURlRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBJTBBJTIzJTIwb3IlMkMlMjB0aGUlMjBiYXNlJTIwc2l6ZWQlMjBtb2RlbCUyMHdpdGglMjBXVFElMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdpa2lTUUwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcoJTIyZ29vZ2xlLWJhc2UtZmluZXR1bmVkLXdpa2lzcWwtc3VwZXJ2aXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for example, the base sized model with default SQA configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WikiSQL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(<span class="hljs-string">&quot;google-base-finetuned-wikisql-supervised&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),y=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIweW91JTIwY2FuJTIwaW5pdGlhbGl6ZSUyMHRoZSUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZHMlMjBhbnklMjB3YXklMjB5b3UlMjB3YW50JTIwKHNlZSUyMGRvY3MlMjBvZiUyMFRhcGFzQ29uZmlnKSUwQWNvbmZpZyUyMCUzRCUyMFRhcGFzQ29uZmlnKG51bV9hZ2dyZWdhdGlvbl9sYWJlbHMlM0QzJTJDJTIwYXZlcmFnZV9sb2dpdHNfcGVyX2NlbGwlM0RUcnVlKSUwQSUyMyUyMGluaXRpYWxpemluZyUyMHRoZSUyMHByZS10cmFpbmVkJTIwYmFzZSUyMHNpemVkJTIwbW9kZWwlMjB3aXRoJTIwb3VyJTIwY3VzdG9tJTIwY2xhc3NpZmljYXRpb24lMjBoZWFkcyUwQW1vZGVsJTIwJTNEJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTJDJTIwY29uZmlnJTNEY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can initialize the classification heads any way you want (see docs of TapasConfig)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(num_aggregation_labels=<span class="hljs-number">3</span>, average_logits_per_cell=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initializing the pre-trained base sized model with our custom classification heads</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),{c(){e=c("p"),e.innerHTML=d,s=r(),w(n.$$.fragment),m=r(),a=c("p"),a.innerHTML=u,W=r(),w(y.$$.fragment)},l(I){e=p(I,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1b9vztz"&&(e.innerHTML=d),s=i(I),b(n.$$.fragment,I),m=i(I),a=p(I,"P",{"data-svelte-h":!0}),f(a)!=="svelte-13b39cc"&&(a.innerHTML=u),W=i(I),b(y.$$.fragment,I)},m(I,Z){l(I,e,Z),l(I,s,Z),j(n,I,Z),l(I,m,Z),l(I,a,Z),l(I,W,Z),j(y,I,Z),F=!0},p:E,i(I){F||(J(n.$$.fragment,I),J(y.$$.fragment,I),F=!0)},o(I){U(n.$$.fragment,I),U(y.$$.fragment,I),F=!1},d(I){I&&(o(e),o(s),o(m),o(a),o(W)),v(n,I),v(y,I)}}}function Dt(C){let e,d;return e=new Cs({props:{$$slots:{default:[Pt]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function Ot(C){let e,d=`Third, given that you’ve prepared your data in this TSV/CSV format (and corresponding CSV files containing the tabular data), you can then use <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> to convert table-question pairs into <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code> and so on. Again, based on which of the three cases you picked above, <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> requires different
inputs to be fine-tuned:`,s,n,m="<thead><tr><th><strong>Task</strong></th> <th><strong>Required inputs</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code></td></tr> <tr><td>Weak supervision for aggregation</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code>, <code>numeric_values</code>, <code>numeric_values_scale</code>, <code>float_answer</code></td></tr> <tr><td>Strong supervision for aggregation</td> <td><code>input ids</code>, <code>attention mask</code>, <code>token type ids</code>, <code>labels</code>, <code>aggregation_labels</code></td></tr></tbody>",a,u,W='<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates the <code>labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> based on the <code>answer_coordinates</code> and <code>answer_text</code> columns of the TSV file. The <code>float_answer</code> and <code>aggregation_labels</code> are already in the TSV file of step 2. Here’s an example:',y,F,I,Z,z=`Note that <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> expects the data of the table to be <strong>text-only</strong>. You can use <code>.astype(str)</code> on a dataframe to turn it into text-only data.
Of course, this only shows how to encode a single training example. It is advised to create a dataloader to iterate over batches:`,G,g,$;return F=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVGFwYXNUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUyMkFjdG9ycyUyMiUzQSUyMCU1QiUyMkJyYWQlMjBQaXR0JTIyJTJDJTIwJTIyTGVvbmFyZG8lMjBEaSUyMENhcHJpbyUyMiUyQyUyMCUyMkdlb3JnZSUyMENsb29uZXklMjIlNUQlMkMlMjAlMjJOdW1iZXIlMjBvZiUyMG1vdmllcyUyMiUzQSUyMCU1QiUyMjg3JTIyJTJDJTIwJTIyNTMlMjIlMkMlMjAlMjI2OSUyMiU1RCU3RCUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaXJzdCUyMGFjdG9yJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMHRvdGFsJTIwbnVtYmVyJTIwb2YlMjBtb3ZpZXMlM0YlMjIlMkMlMEElNUQlMEFhbnN3ZXJfY29vcmRpbmF0ZXMlMjAlM0QlMjAlNUIlNUIoMCUyQyUyMDApJTVEJTJDJTIwJTVCKDIlMkMlMjAxKSU1RCUyQyUyMCU1QigwJTJDJTIwMSklMkMlMjAoMSUyQyUyMDEpJTJDJTIwKDIlMkMlMjAxKSU1RCU1RCUwQWFuc3dlcl90ZXh0JTIwJTNEJTIwJTVCJTVCJTIyQnJhZCUyMFBpdHQlMjIlNUQlMkMlMjAlNUIlMjI2OSUyMiU1RCUyQyUyMCU1QiUyMjIwOSUyMiU1RCU1RCUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjB0YWJsZSUzRHRhYmxlJTJDJTBBJTIwJTIwJTIwJTIwcXVlcmllcyUzRHF1ZXJpZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfY29vcmRpbmF0ZXMlM0RhbnN3ZXJfY29vcmRpbmF0ZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfdGV4dCUzRGFuc3dlcl90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWlucHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_coordinates = [[(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>)], [(<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)], [(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)]]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_text = [[<span class="hljs-string">&quot;Brad Pitt&quot;</span>], [<span class="hljs-string">&quot;69&quot;</span>], [<span class="hljs-string">&quot;209&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table,
<span class="hljs-meta">... </span>    queries=queries,
<span class="hljs-meta">... </span>    answer_coordinates=answer_coordinates,
<span class="hljs-meta">... </span>    answer_text=answer_text,
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[...]]), <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[[...]]]),
<span class="hljs-string">&#x27;numeric_values&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;numeric_values_scale: tensor([[ ... ]]), labels: tensor([[ ... ]])}</span>`,wrap:!1}}),g=new ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBJTBBdHN2X3BhdGglMjAlM0QlMjAlMjJ5b3VyX3BhdGhfdG9fdGhlX3Rzdl9maWxlJTIyJTBBdGFibGVfY3N2X3BhdGglMjAlM0QlMjAlMjJ5b3VyX3BhdGhfdG9fYV9kaXJlY3RvcnlfY29udGFpbmluZ19hbGxfY3N2X2ZpbGVzJTIyJTBBJTBBJTBBY2xhc3MlMjBUYWJsZURhdGFzZXQodG9yY2gudXRpbHMuZGF0YS5EYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBkYXRhJTJDJTIwdG9rZW5pemVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGF0YSUyMCUzRCUyMGRhdGElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnRva2VuaXplciUyMCUzRCUyMHRva2VuaXplciUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fZ2V0aXRlbV9fKHNlbGYlMkMlMjBpZHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaXRlbSUyMCUzRCUyMGRhdGEuaWxvYyU1QmlkeCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhYmxlJTIwJTNEJTIwcGQucmVhZF9jc3YodGFibGVfY3N2X3BhdGglMjAlMkIlMjBpdGVtLnRhYmxlX2ZpbGUpLmFzdHlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTIwJTIwJTIzJTIwYmUlMjBzdXJlJTIwdG8lMjBtYWtlJTIweW91ciUyMHRhYmxlJTIwZGF0YSUyMHRleHQlMjBvbmx5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2RpbmclMjAlM0QlMjBzZWxmLnRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YWJsZSUzRHRhYmxlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcmllcyUzRGl0ZW0ucXVlc3Rpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbnN3ZXJfY29vcmRpbmF0ZXMlM0RpdGVtLmFuc3dlcl9jb29yZGluYXRlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuc3dlcl90ZXh0JTNEaXRlbS5hbnN3ZXJfdGV4dCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHJlbW92ZSUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTIwd2hpY2glMjB0aGUlMjB0b2tlbml6ZXIlMjBhZGRzJTIwYnklMjBkZWZhdWx0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2RpbmclMjAlM0QlMjAlN0JrZXklM0ElMjB2YWwuc3F1ZWV6ZSgwKSUyMGZvciUyMGtleSUyQyUyMHZhbCUyMGluJTIwZW5jb2RpbmcuaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGFkZCUyMHRoZSUyMGZsb2F0X2Fuc3dlciUyMHdoaWNoJTIwaXMlMjBhbHNvJTIwcmVxdWlyZWQlMjAod2VhayUyMHN1cGVydmlzaW9uJTIwZm9yJTIwYWdncmVnYXRpb24lMjBjYXNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVuY29kaW5nJTVCJTIyZmxvYXRfYW5zd2VyJTIyJTVEJTIwJTNEJTIwdG9yY2gudGVuc29yKGl0ZW0uZmxvYXRfYW5zd2VyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGVuY29kaW5nJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19sZW5fXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGxlbihzZWxmLmRhdGEpJTBBJTBBJTBBZGF0YSUyMCUzRCUyMHBkLnJlYWRfY3N2KHRzdl9wYXRoJTJDJTIwc2VwJTNEJTIyJTVDdCUyMiklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwVGFibGVEYXRhc2V0KGRhdGElMkMlMjB0b2tlbml6ZXIpJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMHRvcmNoLnV0aWxzLmRhdGEuRGF0YUxvYWRlcih0cmFpbl9kYXRhc2V0JTJDJTIwYmF0Y2hfc2l6ZSUzRDMyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tsv_path = <span class="hljs-string">&quot;your_path_to_the_tsv_file&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table_csv_path = <span class="hljs-string">&quot;your_path_to_a_directory_containing_all_csv_files&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TableDataset</span>(torch.utils.data.Dataset):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, data, tokenizer</span>):
<span class="hljs-meta">... </span>        self.data = data
<span class="hljs-meta">... </span>        self.tokenizer = tokenizer

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
<span class="hljs-meta">... </span>        item = data.iloc[idx]
<span class="hljs-meta">... </span>        table = pd.read_csv(table_csv_path + item.table_file).astype(
<span class="hljs-meta">... </span>            <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>        )  <span class="hljs-comment"># be sure to make your table data text only</span>
<span class="hljs-meta">... </span>        encoding = self.tokenizer(
<span class="hljs-meta">... </span>            table=table,
<span class="hljs-meta">... </span>            queries=item.question,
<span class="hljs-meta">... </span>            answer_coordinates=item.answer_coordinates,
<span class="hljs-meta">... </span>            answer_text=item.answer_text,
<span class="hljs-meta">... </span>            truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        <span class="hljs-comment"># remove the batch dimension which the tokenizer adds by default</span>
<span class="hljs-meta">... </span>        encoding = {key: val.squeeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">... </span>        <span class="hljs-comment"># add the float_answer which is also required (weak supervision for aggregation case)</span>
<span class="hljs-meta">... </span>        encoding[<span class="hljs-string">&quot;float_answer&quot;</span>] = torch.tensor(item.float_answer)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> encoding

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.data)


<span class="hljs-meta">&gt;&gt;&gt; </span>data = pd.read_csv(tsv_path, sep=<span class="hljs-string">&quot;\\t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = TableDataset(data, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(train_dataset, batch_size=<span class="hljs-number">32</span>)`,wrap:!1}}),{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("table"),n.innerHTML=m,a=r(),u=c("p"),u.innerHTML=W,y=r(),w(F.$$.fragment),I=r(),Z=c("p"),Z.innerHTML=z,G=r(),w(g.$$.fragment)},l(k){e=p(k,"P",{"data-svelte-h":!0}),f(e)!=="svelte-zl6lqu"&&(e.innerHTML=d),s=i(k),n=p(k,"TABLE",{"data-svelte-h":!0}),f(n)!=="svelte-1f72bji"&&(n.innerHTML=m),a=i(k),u=p(k,"P",{"data-svelte-h":!0}),f(u)!=="svelte-pgniej"&&(u.innerHTML=W),y=i(k),b(F.$$.fragment,k),I=i(k),Z=p(k,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1vcf4vo"&&(Z.innerHTML=z),G=i(k),b(g.$$.fragment,k)},m(k,q){l(k,e,q),l(k,s,q),l(k,n,q),l(k,a,q),l(k,u,q),l(k,y,q),j(F,k,q),l(k,I,q),l(k,Z,q),l(k,G,q),j(g,k,q),$=!0},p:E,i(k){$||(J(F.$$.fragment,k),J(g.$$.fragment,k),$=!0)},o(k){U(F.$$.fragment,k),U(g.$$.fragment,k),$=!1},d(k){k&&(o(e),o(s),o(n),o(a),o(u),o(y),o(I),o(Z),o(G)),v(F,k),v(g,k)}}}function Kt(C){let e,d;return e=new Cs({props:{$$slots:{default:[Ot]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function en(C){let e,d=`Third, given that you’ve prepared your data in this TSV/CSV format (and corresponding CSV files containing the tabular data), you can then use <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> to convert table-question pairs into <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code> and so on. Again, based on which of the three cases you picked above, <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> requires different
inputs to be fine-tuned:`,s,n,m="<thead><tr><th><strong>Task</strong></th> <th><strong>Required inputs</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code></td></tr> <tr><td>Weak supervision for aggregation</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code>, <code>numeric_values</code>, <code>numeric_values_scale</code>, <code>float_answer</code></td></tr> <tr><td>Strong supervision for aggregation</td> <td><code>input ids</code>, <code>attention mask</code>, <code>token type ids</code>, <code>labels</code>, <code>aggregation_labels</code></td></tr></tbody>",a,u,W='<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates the <code>labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> based on the <code>answer_coordinates</code> and <code>answer_text</code> columns of the TSV file. The <code>float_answer</code> and <code>aggregation_labels</code> are already in the TSV file of step 2. Here’s an example:',y,F,I,Z,z=`Note that <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> expects the data of the table to be <strong>text-only</strong>. You can use <code>.astype(str)</code> on a dataframe to turn it into text-only data.
Of course, this only shows how to encode a single training example. It is advised to create a dataloader to iterate over batches:`,G,g,$;return F=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVGFwYXNUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUyMkFjdG9ycyUyMiUzQSUyMCU1QiUyMkJyYWQlMjBQaXR0JTIyJTJDJTIwJTIyTGVvbmFyZG8lMjBEaSUyMENhcHJpbyUyMiUyQyUyMCUyMkdlb3JnZSUyMENsb29uZXklMjIlNUQlMkMlMjAlMjJOdW1iZXIlMjBvZiUyMG1vdmllcyUyMiUzQSUyMCU1QiUyMjg3JTIyJTJDJTIwJTIyNTMlMjIlMkMlMjAlMjI2OSUyMiU1RCU3RCUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaXJzdCUyMGFjdG9yJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMHRvdGFsJTIwbnVtYmVyJTIwb2YlMjBtb3ZpZXMlM0YlMjIlMkMlMEElNUQlMEFhbnN3ZXJfY29vcmRpbmF0ZXMlMjAlM0QlMjAlNUIlNUIoMCUyQyUyMDApJTVEJTJDJTIwJTVCKDIlMkMlMjAxKSU1RCUyQyUyMCU1QigwJTJDJTIwMSklMkMlMjAoMSUyQyUyMDEpJTJDJTIwKDIlMkMlMjAxKSU1RCU1RCUwQWFuc3dlcl90ZXh0JTIwJTNEJTIwJTVCJTVCJTIyQnJhZCUyMFBpdHQlMjIlNUQlMkMlMjAlNUIlMjI2OSUyMiU1RCUyQyUyMCU1QiUyMjIwOSUyMiU1RCU1RCUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjB0YWJsZSUzRHRhYmxlJTJDJTBBJTIwJTIwJTIwJTIwcXVlcmllcyUzRHF1ZXJpZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfY29vcmRpbmF0ZXMlM0RhbnN3ZXJfY29vcmRpbmF0ZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfdGV4dCUzRGFuc3dlcl90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyJTJDJTBBKSUwQWlucHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_coordinates = [[(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>)], [(<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)], [(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)]]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_text = [[<span class="hljs-string">&quot;Brad Pitt&quot;</span>], [<span class="hljs-string">&quot;69&quot;</span>], [<span class="hljs-string">&quot;209&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table,
<span class="hljs-meta">... </span>    queries=queries,
<span class="hljs-meta">... </span>    answer_coordinates=answer_coordinates,
<span class="hljs-meta">... </span>    answer_text=answer_text,
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;tf&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[...]]), <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[[...]]]),
<span class="hljs-string">&#x27;numeric_values&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;numeric_values_scale: tensor([[ ... ]]), labels: tensor([[ ... ]])}</span>`,wrap:!1}}),g=new ce({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tsv_path = <span class="hljs-string">&quot;your_path_to_the_tsv_file&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table_csv_path = <span class="hljs-string">&quot;your_path_to_a_directory_containing_all_csv_files&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TableDataset</span>:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, data, tokenizer</span>):
<span class="hljs-meta">... </span>        self.data = data
<span class="hljs-meta">... </span>        self.tokenizer = tokenizer

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__iter__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.__len__()):
<span class="hljs-meta">... </span>            item = self.data.iloc[idx]
<span class="hljs-meta">... </span>            table = pd.read_csv(table_csv_path + item.table_file).astype(
<span class="hljs-meta">... </span>                <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>            )  <span class="hljs-comment"># be sure to make your table data text only</span>
<span class="hljs-meta">... </span>            encoding = self.tokenizer(
<span class="hljs-meta">... </span>                table=table,
<span class="hljs-meta">... </span>                queries=item.question,
<span class="hljs-meta">... </span>                answer_coordinates=item.answer_coordinates,
<span class="hljs-meta">... </span>                answer_text=item.answer_text,
<span class="hljs-meta">... </span>                truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>                padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>                return_tensors=<span class="hljs-string">&quot;tf&quot;</span>,
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            <span class="hljs-comment"># remove the batch dimension which the tokenizer adds by default</span>
<span class="hljs-meta">... </span>            encoding = {key: tf.squeeze(val, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">... </span>            <span class="hljs-comment"># add the float_answer which is also required (weak supervision for aggregation case)</span>
<span class="hljs-meta">... </span>            encoding[<span class="hljs-string">&quot;float_answer&quot;</span>] = tf.convert_to_tensor(item.float_answer, dtype=tf.float32)
<span class="hljs-meta">... </span>            <span class="hljs-keyword">yield</span> encoding[<span class="hljs-string">&quot;input_ids&quot;</span>], encoding[<span class="hljs-string">&quot;attention_mask&quot;</span>], encoding[<span class="hljs-string">&quot;numeric_values&quot;</span>], encoding[
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;numeric_values_scale&quot;</span>
<span class="hljs-meta">... </span>            ], encoding[<span class="hljs-string">&quot;token_type_ids&quot;</span>], encoding[<span class="hljs-string">&quot;labels&quot;</span>], encoding[<span class="hljs-string">&quot;float_answer&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.data)


<span class="hljs-meta">&gt;&gt;&gt; </span>data = pd.read_csv(tsv_path, sep=<span class="hljs-string">&quot;\\t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = TableDataset(data, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_signature = (
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>, <span class="hljs-number">7</span>), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = tf.data.Dataset.from_generator(train_dataset, output_signature=output_signature).batch(<span class="hljs-number">32</span>)`,wrap:!1}}),{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("table"),n.innerHTML=m,a=r(),u=c("p"),u.innerHTML=W,y=r(),w(F.$$.fragment),I=r(),Z=c("p"),Z.innerHTML=z,G=r(),w(g.$$.fragment)},l(k){e=p(k,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1w1nwqm"&&(e.innerHTML=d),s=i(k),n=p(k,"TABLE",{"data-svelte-h":!0}),f(n)!=="svelte-1f72bji"&&(n.innerHTML=m),a=i(k),u=p(k,"P",{"data-svelte-h":!0}),f(u)!=="svelte-pgniej"&&(u.innerHTML=W),y=i(k),b(F.$$.fragment,k),I=i(k),Z=p(k,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1vcf4vo"&&(Z.innerHTML=z),G=i(k),b(g.$$.fragment,k)},m(k,q){l(k,e,q),l(k,s,q),l(k,n,q),l(k,a,q),l(k,u,q),l(k,y,q),j(F,k,q),l(k,I,q),l(k,Z,q),l(k,G,q),j(g,k,q),$=!0},p:E,i(k){$||(J(F.$$.fragment,k),J(g.$$.fragment,k),$=!0)},o(k){U(F.$$.fragment,k),U(g.$$.fragment,k),$=!1},d(k){k&&(o(e),o(s),o(n),o(a),o(u),o(y),o(I),o(Z),o(G)),v(F,k),v(g,k)}}}function sn(C){let e,d;return e=new Cs({props:{$$slots:{default:[en]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function tn(C){let e,d='You can then fine-tune <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> as follows (shown here for the weak supervision for aggregation case):',s,n,m;return n=new ce({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering, AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># this is the default WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(
<span class="hljs-meta">... </span>    num_aggregation_labels=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    use_answer_as_supervision=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    answer_loss_cutoff=<span class="hljs-number">0.664694</span>,
<span class="hljs-meta">... </span>    cell_selection_preference=<span class="hljs-number">0.207951</span>,
<span class="hljs-meta">... </span>    huber_loss_delta=<span class="hljs-number">0.121194</span>,
<span class="hljs-meta">... </span>    init_cell_selection_weights_to_zero=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    select_one_column=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_empty_column_selection=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.0352513</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):  <span class="hljs-comment"># loop over the dataset multiple times</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># get the inputs;</span>
<span class="hljs-meta">... </span>        input_ids = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">... </span>        attention_mask = batch[<span class="hljs-string">&quot;attention_mask&quot;</span>]
<span class="hljs-meta">... </span>        token_type_ids = batch[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
<span class="hljs-meta">... </span>        labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>        numeric_values = batch[<span class="hljs-string">&quot;numeric_values&quot;</span>]
<span class="hljs-meta">... </span>        numeric_values_scale = batch[<span class="hljs-string">&quot;numeric_values_scale&quot;</span>]
<span class="hljs-meta">... </span>        float_answer = batch[<span class="hljs-string">&quot;float_answer&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># zero the parameter gradients</span>
<span class="hljs-meta">... </span>        optimizer.zero_grad()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward + backward + optimize</span>
<span class="hljs-meta">... </span>        outputs = model(
<span class="hljs-meta">... </span>            input_ids=input_ids,
<span class="hljs-meta">... </span>            attention_mask=attention_mask,
<span class="hljs-meta">... </span>            token_type_ids=token_type_ids,
<span class="hljs-meta">... </span>            labels=labels,
<span class="hljs-meta">... </span>            numeric_values=numeric_values,
<span class="hljs-meta">... </span>            numeric_values_scale=numeric_values_scale,
<span class="hljs-meta">... </span>            float_answer=float_answer,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()`,wrap:!1}}),{c(){e=c("p"),e.innerHTML=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1msv26y"&&(e.innerHTML=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function nn(C){let e,d;return e=new Cs({props:{$$slots:{default:[tn]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function an(C){let e,d='You can then fine-tune <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> as follows (shown here for the weak supervision for aggregation case):',s,n,m;return n=new ce({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># this is the default WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(
<span class="hljs-meta">... </span>    num_aggregation_labels=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    use_answer_as_supervision=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    answer_loss_cutoff=<span class="hljs-number">0.664694</span>,
<span class="hljs-meta">... </span>    cell_selection_preference=<span class="hljs-number">0.207951</span>,
<span class="hljs-meta">... </span>    huber_loss_delta=<span class="hljs-number">0.121194</span>,
<span class="hljs-meta">... </span>    init_cell_selection_weights_to_zero=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    select_one_column=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_empty_column_selection=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.0352513</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):  <span class="hljs-comment"># loop over the dataset multiple times</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># get the inputs;</span>
<span class="hljs-meta">... </span>        input_ids = batch[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        attention_mask = batch[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        token_type_ids = batch[<span class="hljs-number">4</span>]
<span class="hljs-meta">... </span>        labels = batch[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        numeric_values = batch[<span class="hljs-number">2</span>]
<span class="hljs-meta">... </span>        numeric_values_scale = batch[<span class="hljs-number">3</span>]
<span class="hljs-meta">... </span>        float_answer = batch[<span class="hljs-number">6</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward + backward + optimize</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> tf.GradientTape() <span class="hljs-keyword">as</span> tape:
<span class="hljs-meta">... </span>            outputs = model(
<span class="hljs-meta">... </span>                input_ids=input_ids,
<span class="hljs-meta">... </span>                attention_mask=attention_mask,
<span class="hljs-meta">... </span>                token_type_ids=token_type_ids,
<span class="hljs-meta">... </span>                labels=labels,
<span class="hljs-meta">... </span>                numeric_values=numeric_values,
<span class="hljs-meta">... </span>                numeric_values_scale=numeric_values_scale,
<span class="hljs-meta">... </span>                float_answer=float_answer,
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>        grads = tape.gradient(outputs.loss, model.trainable_weights)
<span class="hljs-meta">... </span>        optimizer.apply_gradients(<span class="hljs-built_in">zip</span>(grads, model.trainable_weights))`,wrap:!1}}),{c(){e=c("p"),e.innerHTML=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1cb6ntu"&&(e.innerHTML=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function on(C){let e,d;return e=new Cs({props:{$$slots:{default:[an]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function ln(C){let e,d='Here we explain how you can use <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> for inference (i.e. making predictions on new data). For inference, only <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> (which you can obtain using <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) have to be provided to the model to obtain the logits. Next, you can use the handy <code>~models.tapas.tokenization_tapas.convert_logits_to_predictions</code> method to convert these into predicted coordinates and optional aggregation indices.',s,n,m="However, note that inference is <strong>different</strong> depending on whether or not the setup is conversational. In a non-conversational set-up, inference can be done in parallel on all table-question pairs of a batch. Here’s an example of that:",a,u,W;return u=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTJDJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTBBbW9kZWwlMjAlM0QlMjBUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQXRva2VuaXplciUyMCUzRCUyMFRhcGFzVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlN0QlMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwZmlyc3QlMjBhY3RvciUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkhvdyUyMG1hbnklMjBtb3ZpZXMlMjBoYXMlMjBHZW9yZ2UlMjBDbG9vbmV5JTIwcGxheWVkJTIwaW4lM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjB0b3RhbCUyMG51bWJlciUyMG9mJTIwbW92aWVzJTNGJTIyJTJDJTBBJTVEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBcHJlZGljdGVkX2Fuc3dlcl9jb29yZGluYXRlcyUyQyUyMHByZWRpY3RlZF9hZ2dyZWdhdGlvbl9pbmRpY2VzJTIwJTNEJTIwdG9rZW5pemVyLmNvbnZlcnRfbG9naXRzX3RvX3ByZWRpY3Rpb25zKCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMG91dHB1dHMubG9naXRzLmRldGFjaCgpJTJDJTIwb3V0cHV0cy5sb2dpdHNfYWdncmVnYXRpb24uZGV0YWNoKCklMEEpJTBBJTBBJTIzJTIwbGV0J3MlMjBwcmludCUyMG91dCUyMHRoZSUyMHJlc3VsdHMlM0ElMEFpZDJhZ2dyZWdhdGlvbiUyMCUzRCUyMCU3QjAlM0ElMjAlMjJOT05FJTIyJTJDJTIwMSUzQSUyMCUyMlNVTSUyMiUyQyUyMDIlM0ElMjAlMjJBVkVSQUdFJTIyJTJDJTIwMyUzQSUyMCUyMkNPVU5UJTIyJTdEJTBBYWdncmVnYXRpb25fcHJlZGljdGlvbnNfc3RyaW5nJTIwJTNEJTIwJTVCaWQyYWdncmVnYXRpb24lNUJ4JTVEJTIwZm9yJTIweCUyMGluJTIwcHJlZGljdGVkX2FnZ3JlZ2F0aW9uX2luZGljZXMlNUQlMEElMEFhbnN3ZXJzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwY29vcmRpbmF0ZXMlMjBpbiUyMHByZWRpY3RlZF9hbnN3ZXJfY29vcmRpbmF0ZXMlM0ElMEElMjAlMjAlMjAlMjBpZiUyMGxlbihjb29yZGluYXRlcyklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwb25seSUyMGElMjBzaW5nbGUlMjBjZWxsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5zd2Vycy5hcHBlbmQodGFibGUuaWF0JTVCY29vcmRpbmF0ZXMlNUIwJTVEJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBtdWx0aXBsZSUyMGNlbGxzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2VsbF92YWx1ZXMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBjb29yZGluYXRlJTIwaW4lMjBjb29yZGluYXRlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNlbGxfdmFsdWVzLmFwcGVuZCh0YWJsZS5pYXQlNUJjb29yZGluYXRlJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuc3dlcnMuYXBwZW5kKCUyMiUyQyUyMCUyMi5qb2luKGNlbGxfdmFsdWVzKSklMEElMEFkaXNwbGF5KHRhYmxlKSUwQXByaW50KCUyMiUyMiklMEFmb3IlMjBxdWVyeSUyQyUyMGFuc3dlciUyQyUyMHByZWRpY3RlZF9hZ2clMjBpbiUyMHppcChxdWVyaWVzJTJDJTIwYW5zd2VycyUyQyUyMGFnZ3JlZ2F0aW9uX3ByZWRpY3Rpb25zX3N0cmluZyklM0ElMEElMjAlMjAlMjAlMjBwcmludChxdWVyeSklMEElMjAlMjAlMjAlMjBpZiUyMHByZWRpY3RlZF9hZ2clMjAlM0QlM0QlMjAlMjJOT05FJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyUHJlZGljdGVkJTIwYW5zd2VyJTNBJTIwJTIyJTIwJTJCJTIwYW5zd2VyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJQcmVkaWN0ZWQlMjBhbnN3ZXIlM0ElMjAlMjIlMjAlMkIlMjBwcmVkaWN0ZWRfYWdnJTIwJTJCJTIwJTIyJTIwJTNFJTIwJTIyJTIwJTJCJTIwYW5zd2VyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer_coordinates, predicted_aggregation_indices = tokenizer.convert_logits_to_predictions(
<span class="hljs-meta">... </span>    inputs, outputs.logits.detach(), outputs.logits_aggregation.detach()
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s print out the results:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2aggregation = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;NONE&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;SUM&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;AVERAGE&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;COUNT&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aggregation_predictions_string = [id2aggregation[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> predicted_aggregation_indices]

<span class="hljs-meta">&gt;&gt;&gt; </span>answers = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> coordinates <span class="hljs-keyword">in</span> predicted_answer_coordinates:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(coordinates) == <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># only a single cell:</span>
<span class="hljs-meta">... </span>        answers.append(table.iat[coordinates[<span class="hljs-number">0</span>]])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># multiple cells</span>
<span class="hljs-meta">... </span>        cell_values = []
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> coordinate <span class="hljs-keyword">in</span> coordinates:
<span class="hljs-meta">... </span>            cell_values.append(table.iat[coordinate])
<span class="hljs-meta">... </span>        answers.append(<span class="hljs-string">&quot;, &quot;</span>.join(cell_values))

<span class="hljs-meta">&gt;&gt;&gt; </span>display(table)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> query, answer, predicted_agg <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queries, answers, aggregation_predictions_string):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> predicted_agg == <span class="hljs-string">&quot;NONE&quot;</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + answer)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + predicted_agg + <span class="hljs-string">&quot; &gt; &quot;</span> + answer)
What <span class="hljs-keyword">is</span> the name of the first actor?
Predicted answer: Brad Pitt
How many movies has George Clooney played <span class="hljs-keyword">in</span>?
Predicted answer: COUNT &gt; <span class="hljs-number">69</span>
What <span class="hljs-keyword">is</span> the total number of movies?
Predicted answer: SUM &gt; <span class="hljs-number">87</span>, <span class="hljs-number">53</span>, <span class="hljs-number">69</span>`,wrap:!1}}),{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("p"),n.innerHTML=m,a=r(),w(u.$$.fragment)},l(y){e=p(y,"P",{"data-svelte-h":!0}),f(e)!=="svelte-xizb6l"&&(e.innerHTML=d),s=i(y),n=p(y,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1xx2q6p"&&(n.innerHTML=m),a=i(y),b(u.$$.fragment,y)},m(y,F){l(y,e,F),l(y,s,F),l(y,n,F),l(y,a,F),j(u,y,F),W=!0},p:E,i(y){W||(J(u.$$.fragment,y),W=!0)},o(y){U(u.$$.fragment,y),W=!1},d(y){y&&(o(e),o(s),o(n),o(a)),v(u,y)}}}function rn(C){let e,d;return e=new Cs({props:{$$slots:{default:[ln]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function dn(C){let e,d='Here we explain how you can use <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> for inference (i.e. making predictions on new data). For inference, only <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> (which you can obtain using <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) have to be provided to the model to obtain the logits. Next, you can use the handy <code>~models.tapas.tokenization_tapas.convert_logits_to_predictions</code> method to convert these into predicted coordinates and optional aggregation indices.',s,n,m="However, note that inference is <strong>different</strong> depending on whether or not the setup is conversational. In a non-conversational set-up, inference can be done in parallel on all table-question pairs of a batch. Here’s an example of that:",a,u,W;return u=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTJDJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIlMEFtb2RlbCUyMCUzRCUyMFRGVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBUYXBhc1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMEFkYXRhJTIwJTNEJTIwJTdCJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTdEJTBBcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGZpcnN0JTIwYWN0b3IlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3clMjBtYW55JTIwbW92aWVzJTIwaGFzJTIwR2VvcmdlJTIwQ2xvb25leSUyMHBsYXllZCUyMGluJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwdG90YWwlMjBudW1iZXIlMjBvZiUyMG1vdmllcyUzRiUyMiUyQyUwQSU1RCUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0YWJsZSUzRHRhYmxlJTJDJTIwcXVlcmllcyUzRHF1ZXJpZXMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQXByZWRpY3RlZF9hbnN3ZXJfY29vcmRpbmF0ZXMlMkMlMjBwcmVkaWN0ZWRfYWdncmVnYXRpb25faW5kaWNlcyUyMCUzRCUyMHRva2VuaXplci5jb252ZXJ0X2xvZ2l0c190b19wcmVkaWN0aW9ucyglMEElMjAlMjAlMjAlMjBpbnB1dHMlMkMlMjBvdXRwdXRzLmxvZ2l0cyUyQyUyMG91dHB1dHMubG9naXRzX2FnZ3JlZ2F0aW9uJTBBKSUwQSUwQSUyMyUyMGxldCdzJTIwcHJpbnQlMjBvdXQlMjB0aGUlMjByZXN1bHRzJTNBJTBBaWQyYWdncmVnYXRpb24lMjAlM0QlMjAlN0IwJTNBJTIwJTIyTk9ORSUyMiUyQyUyMDElM0ElMjAlMjJTVU0lMjIlMkMlMjAyJTNBJTIwJTIyQVZFUkFHRSUyMiUyQyUyMDMlM0ElMjAlMjJDT1VOVCUyMiU3RCUwQWFnZ3JlZ2F0aW9uX3ByZWRpY3Rpb25zX3N0cmluZyUyMCUzRCUyMCU1QmlkMmFnZ3JlZ2F0aW9uJTVCeCU1RCUyMGZvciUyMHglMjBpbiUyMHByZWRpY3RlZF9hZ2dyZWdhdGlvbl9pbmRpY2VzJTVEJTBBJTBBYW5zd2VycyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMGNvb3JkaW5hdGVzJTIwaW4lMjBwcmVkaWN0ZWRfYW5zd2VyX2Nvb3JkaW5hdGVzJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4oY29vcmRpbmF0ZXMpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9ubHklMjBhJTIwc2luZ2xlJTIwY2VsbCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuc3dlcnMuYXBwZW5kKHRhYmxlLmlhdCU1QmNvb3JkaW5hdGVzJTVCMCU1RCU1RCklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbXVsdGlwbGUlMjBjZWxscyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNlbGxfdmFsdWVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwY29vcmRpbmF0ZSUyMGluJTIwY29vcmRpbmF0ZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjZWxsX3ZhbHVlcy5hcHBlbmQodGFibGUuaWF0JTVCY29vcmRpbmF0ZSU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbnN3ZXJzLmFwcGVuZCglMjIlMkMlMjAlMjIuam9pbihjZWxsX3ZhbHVlcykpJTBBJTBBZGlzcGxheSh0YWJsZSklMEFwcmludCglMjIlMjIpJTBBZm9yJTIwcXVlcnklMkMlMjBhbnN3ZXIlMkMlMjBwcmVkaWN0ZWRfYWdnJTIwaW4lMjB6aXAocXVlcmllcyUyQyUyMGFuc3dlcnMlMkMlMjBhZ2dyZWdhdGlvbl9wcmVkaWN0aW9uc19zdHJpbmcpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQocXVlcnkpJTBBJTIwJTIwJTIwJTIwaWYlMjBwcmVkaWN0ZWRfYWdnJTIwJTNEJTNEJTIwJTIyTk9ORSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMCUyMiUyMCUyQiUyMGFuc3dlciklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyUHJlZGljdGVkJTIwYW5zd2VyJTNBJTIwJTIyJTIwJTJCJTIwcHJlZGljdGVkX2FnZyUyMCUyQiUyMCUyMiUyMCUzRSUyMCUyMiUyMCUyQiUyMGFuc3dlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer, TFTapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer_coordinates, predicted_aggregation_indices = tokenizer.convert_logits_to_predictions(
<span class="hljs-meta">... </span>    inputs, outputs.logits, outputs.logits_aggregation
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s print out the results:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2aggregation = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;NONE&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;SUM&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;AVERAGE&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;COUNT&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aggregation_predictions_string = [id2aggregation[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> predicted_aggregation_indices]

<span class="hljs-meta">&gt;&gt;&gt; </span>answers = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> coordinates <span class="hljs-keyword">in</span> predicted_answer_coordinates:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(coordinates) == <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># only a single cell:</span>
<span class="hljs-meta">... </span>        answers.append(table.iat[coordinates[<span class="hljs-number">0</span>]])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># multiple cells</span>
<span class="hljs-meta">... </span>        cell_values = []
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> coordinate <span class="hljs-keyword">in</span> coordinates:
<span class="hljs-meta">... </span>            cell_values.append(table.iat[coordinate])
<span class="hljs-meta">... </span>        answers.append(<span class="hljs-string">&quot;, &quot;</span>.join(cell_values))

<span class="hljs-meta">&gt;&gt;&gt; </span>display(table)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> query, answer, predicted_agg <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queries, answers, aggregation_predictions_string):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> predicted_agg == <span class="hljs-string">&quot;NONE&quot;</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + answer)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + predicted_agg + <span class="hljs-string">&quot; &gt; &quot;</span> + answer)
What <span class="hljs-keyword">is</span> the name of the first actor?
Predicted answer: Brad Pitt
How many movies has George Clooney played <span class="hljs-keyword">in</span>?
Predicted answer: COUNT &gt; <span class="hljs-number">69</span>
What <span class="hljs-keyword">is</span> the total number of movies?
Predicted answer: SUM &gt; <span class="hljs-number">87</span>, <span class="hljs-number">53</span>, <span class="hljs-number">69</span>`,wrap:!1}}),{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("p"),n.innerHTML=m,a=r(),w(u.$$.fragment)},l(y){e=p(y,"P",{"data-svelte-h":!0}),f(e)!=="svelte-80dt5f"&&(e.innerHTML=d),s=i(y),n=p(y,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1xx2q6p"&&(n.innerHTML=m),a=i(y),b(u.$$.fragment,y)},m(y,F){l(y,e,F),l(y,s,F),l(y,n,F),l(y,a,F),j(u,y,F),W=!0},p:E,i(y){W||(J(u.$$.fragment,y),W=!0)},o(y){U(u.$$.fragment,y),W=!1},d(y){y&&(o(e),o(s),o(n),o(a)),v(u,y)}}}function cn(C){let e,d;return e=new Cs({props:{$$slots:{default:[dn]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function pn(C){let e,d="Example:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzTW9kZWwlMkMlMjBUYXBhc0NvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBkZWZhdWx0JTIwKFNRQSklMjBUYXBhcyUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVGFwYXNDb25maWcoKSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasModel, TapasConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a default (SQA) Tapas configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TapasConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-11lpom8"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function mn(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function hn(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc01vZGVsJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMCUyMkhvdyUyMG9sZCUyMGlzJTIwQnJhZCUyMFBpdHQlM0YlMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIodGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0RxdWVyaWVzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function un(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function gn(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0Zvck1hc2tlZExNJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc0Zvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwdGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0QlMjJIb3clMjBtYW55JTIwJTVCTUFTSyU1RCUyMGhhcyUyMEdlb3JnZSUyMCU1Qk1BU0slNUQlMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many [MASK] has George [MASK] played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function fn(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function Mn(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhlcmUlMjBpcyUyMG9ubHklMjBvbmUlMjBhY3RvciUyMHdobyUyMGlzJTIwNDUlMjB5ZWFycyUyMG9sZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoZXJlJTIwYXJlJTIwMyUyMGFjdG9ycyUyMHdoaWNoJTIwcGxheWVkJTIwaW4lMjBtb3JlJTIwdGhhbiUyMDYwJTIwbW92aWVzJTIyJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSUyQyUyMDAlNUQpJTIwJTIwJTIzJTIwMSUyMG1lYW5zJTIwZW50YWlsZWQlMkMlMjAwJTIwbWVhbnMlMjByZWZ1dGVkJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There is only one actor who is 45 years old&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There are 3 actors which played in more than 60 movies&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>, <span class="hljs-number">0</span>])  <span class="hljs-comment"># 1 means entailed, 0 means refuted</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function Tn(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function yn(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkFnZSUyMiUzQSUyMCU1QiUyMjU2JTIyJTJDJTIwJTIyNDUlMjIlMkMlMjAlMjI1OSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTJDJTBBJTdEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBcXVlcmllcyUyMCUzRCUyMCU1QiUyMkhvdyUyMG1hbnklMjBtb3ZpZXMlMjBoYXMlMjBHZW9yZ2UlMjBDbG9vbmV5JTIwcGxheWVkJTIwaW4lM0YlMjIlMkMlMjAlMjJIb3clMjBvbGQlMjBpcyUyMEJyYWQlMjBQaXR0JTNGJTIyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsb2dpdHNfYWdncmVnYXRpb24lMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19hZ2dyZWdhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_aggregation = outputs.logits_aggregation`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function _n(C){let e,d,s,n,m,a,u=`The bare Tapas Model transformer outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,W,y,F=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,I,Z,z='This class is a small change compared to <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertModel">BertModel</a>, taking into account the additional token type ids.',G,g,$=`The model can behave as an encoder (with only self-attention) as well as a decoder, in which case a layer of
cross-attention is added between the self-attention layers, following the architecture described in <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">Attention is
all you need</a> by Ashish Vaswani, Noam Shazeer, Niki Parmar, Jakob Uszkoreit,
Llion Jones, Aidan N. Gomez, Lukasz Kaiser and Illia Polosukhin.`,k,q,ts,Ve,Ce,Fs='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> forward method, overrides the <code>__call__</code> special method.',Fe,pe,Xe,ve,me,Ee,L,Q,ns,Se,Ze,Zs=`Tapas Model with a <code>language modeling</code> head on top.
This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,He,Ae,As=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ye,se,Re,he,ps,ue='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',we,$e,ke,as,ms,K,Js,V,ge,os,Qe,S=`Tapas Model with a sequence classification head on top (a linear layer on top of the pooled output), e.g. for table
entailment tasks, such as TabFact (Chen et al., 2020).`,ls,Le,Be=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,$s,Pe,qe=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Bs,le,te,Us,Ie,rs='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForSequenceClassification">TapasForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ys,X,is,We,be,hs,us,x,ds,ze,je,gs=`Tapas Model with a cell selection head and optional aggregation head on top for question-answering tasks on tables
(linear layers on top of the hidden-states output to compute <code>logits</code> and optional <code>logits_aggregation</code>), e.g. for
SQA, WTQ or WikiSQL-supervised tasks.`,fs,R,Ms=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_s,re,Gs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ws,H,De,Oe,Ne,vs='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Ke,fe,bs,N,Ge;return e=new xe({props:{title:"TapasModel",local:"transformers.TapasModel",headingTag:"h2"}}),n=new oe({props:{name:"class transformers.TapasModel",anchor:"transformers.TapasModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.TapasModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L835"}}),ts=new oe({props:{name:"forward",anchor:"transformers.TapasModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TapasModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L876",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new js({props:{$$slots:{default:[mn]},$$scope:{ctx:C}}}),ve=new zs({props:{anchor:"transformers.TapasModel.forward.example",$$slots:{default:[hn]},$$scope:{ctx:C}}}),Ee=new xe({props:{title:"TapasForMaskedLM",local:"transformers.TapasForMaskedLM",headingTag:"h2"}}),ns=new oe({props:{name:"class transformers.TapasForMaskedLM",anchor:"transformers.TapasForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TapasForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L991"}}),Re=new oe({props:{name:"forward",anchor:"transformers.TapasForMaskedLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L1012",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$e=new js({props:{$$slots:{default:[un]},$$scope:{ctx:C}}}),as=new zs({props:{anchor:"transformers.TapasForMaskedLM.forward.example",$$slots:{default:[gn]},$$scope:{ctx:C}}}),K=new xe({props:{title:"TapasForSequenceClassification",local:"transformers.TapasForSequenceClassification",headingTag:"h2"}}),ge=new oe({props:{name:"class transformers.TapasForSequenceClassification",anchor:"transformers.TapasForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TapasForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L1446"}}),te=new oe({props:{name:"forward",anchor:"transformers.TapasForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TapasForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy). Note: this is called
&#x201C;classification_class_index&#x201D; in the original implementation.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L1465",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new js({props:{$$slots:{default:[fn]},$$scope:{ctx:C}}}),We=new zs({props:{anchor:"transformers.TapasForSequenceClassification.forward.example",$$slots:{default:[Mn]},$$scope:{ctx:C}}}),hs=new xe({props:{title:"TapasForQuestionAnswering",local:"transformers.TapasForQuestionAnswering",headingTag:"h2"}}),ds=new oe({props:{name:"class transformers.TapasForQuestionAnswering",anchor:"transformers.TapasForQuestionAnswering",parameters:[{name:"config",val:": TapasConfig"}],parametersDescription:[{anchor:"transformers.TapasForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L1100"}}),De=new oe({props:{name:"forward",anchor:"transformers.TapasForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"table_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"aggregation_labels",val:": Optional = None"},{name:"float_answer",val:": Optional = None"},{name:"numeric_values",val:": Optional = None"},{name:"numeric_values_scale",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TapasForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForQuestionAnswering.forward.table_mask",description:`<strong>table_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Mask for the table. Indicates which tokens belong to the table (1). Question tokens, table headers and
padding are 0.`,name:"table_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Labels per token for computing the hierarchical cell selection loss. This encodes the positions of the
answer appearing in the table. Can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.</p>
<ul>
<li>1 for tokens that are <strong>part of the answer</strong>,</li>
<li>0 for tokens that are <strong>not part of the answer</strong>.</li>
</ul>`,name:"labels"},{anchor:"transformers.TapasForQuestionAnswering.forward.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Aggregation function index for every example in the batch for computing the aggregation loss. Indices
should be in <code>[0, ..., config.num_aggregation_labels - 1]</code>. Only required in case of strong supervision for
aggregation (WikiSQL-supervised).`,name:"aggregation_labels"},{anchor:"transformers.TapasForQuestionAnswering.forward.float_answer",description:`<strong>float_answer</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Float answer for every example in the batch. Set to <em>float(&#x2018;nan&#x2019;)</em> for cell selection questions. Only
required in case of weak supervision (WTQ) to calculate the aggregate mask and regression loss.`,name:"float_answer"},{anchor:"transformers.TapasForQuestionAnswering.forward.numeric_values",description:`<strong>numeric_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Numeric values of every token, NaN for tokens which are not numeric values. Can be obtained using
<a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case of weak supervision for aggregation (WTQ) to calculate the
regression loss.`,name:"numeric_values"},{anchor:"transformers.TapasForQuestionAnswering.forward.numeric_values_scale",description:`<strong>numeric_values_scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Scale of the numeric values of every token. Can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case
of weak supervision for aggregation (WTQ) to calculate the regression loss.`,name:"numeric_values_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L1143",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"
>transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) — Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Prediction scores of the cell selection head, for every token.</li>
<li><strong>logits_aggregation</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) — Prediction scores of the aggregation head, for every aggregation operator.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"
>transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new js({props:{$$slots:{default:[Tn]},$$scope:{ctx:C}}}),N=new zs({props:{anchor:"transformers.TapasForQuestionAnswering.forward.example",$$slots:{default:[yn]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment),d=r(),s=c("div"),w(n.$$.fragment),m=r(),a=c("p"),a.innerHTML=u,W=r(),y=c("p"),y.innerHTML=F,I=r(),Z=c("p"),Z.innerHTML=z,G=r(),g=c("p"),g.innerHTML=$,k=r(),q=c("div"),w(ts.$$.fragment),Ve=r(),Ce=c("p"),Ce.innerHTML=Fs,Fe=r(),w(pe.$$.fragment),Xe=r(),w(ve.$$.fragment),me=r(),w(Ee.$$.fragment),L=r(),Q=c("div"),w(ns.$$.fragment),Se=r(),Ze=c("p"),Ze.innerHTML=Zs,He=r(),Ae=c("p"),Ae.innerHTML=As,Ye=r(),se=c("div"),w(Re.$$.fragment),he=r(),ps=c("p"),ps.innerHTML=ue,we=r(),w($e.$$.fragment),ke=r(),w(as.$$.fragment),ms=r(),w(K.$$.fragment),Js=r(),V=c("div"),w(ge.$$.fragment),os=r(),Qe=c("p"),Qe.textContent=S,ls=r(),Le=c("p"),Le.innerHTML=Be,$s=r(),Pe=c("p"),Pe.innerHTML=qe,Bs=r(),le=c("div"),w(te.$$.fragment),Us=r(),Ie=c("p"),Ie.innerHTML=rs,ys=r(),w(X.$$.fragment),is=r(),w(We.$$.fragment),be=r(),w(hs.$$.fragment),us=r(),x=c("div"),w(ds.$$.fragment),ze=r(),je=c("p"),je.innerHTML=gs,fs=r(),R=c("p"),R.innerHTML=Ms,_s=r(),re=c("p"),re.innerHTML=Gs,ws=r(),H=c("div"),w(De.$$.fragment),Oe=r(),Ne=c("p"),Ne.innerHTML=vs,Ke=r(),w(fe.$$.fragment),bs=r(),w(N.$$.fragment),this.h()},l(_){b(e.$$.fragment,_),d=i(_),s=p(_,"DIV",{class:!0});var B=ee(s);b(n.$$.fragment,B),m=i(B),a=p(B,"P",{"data-svelte-h":!0}),f(a)!=="svelte-m7xim8"&&(a.innerHTML=u),W=i(B),y=p(B,"P",{"data-svelte-h":!0}),f(y)!=="svelte-hswkmf"&&(y.innerHTML=F),I=i(B),Z=p(B,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1eaihel"&&(Z.innerHTML=z),G=i(B),g=p(B,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1du13oj"&&(g.innerHTML=$),k=i(B),q=p(B,"DIV",{class:!0});var ne=ee(q);b(ts.$$.fragment,ne),Ve=i(ne),Ce=p(ne,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-1hddpjp"&&(Ce.innerHTML=Fs),Fe=i(ne),b(pe.$$.fragment,ne),Xe=i(ne),b(ve.$$.fragment,ne),ne.forEach(o),B.forEach(o),me=i(_),b(Ee.$$.fragment,_),L=i(_),Q=p(_,"DIV",{class:!0});var Me=ee(Q);b(ns.$$.fragment,Me),Se=i(Me),Ze=p(Me,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-tw66dr"&&(Ze.innerHTML=Zs),He=i(Me),Ae=p(Me,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-hswkmf"&&(Ae.innerHTML=As),Ye=i(Me),se=p(Me,"DIV",{class:!0});var Y=ee(se);b(Re.$$.fragment,Y),he=i(Y),ps=p(Y,"P",{"data-svelte-h":!0}),f(ps)!=="svelte-173rc6t"&&(ps.innerHTML=ue),we=i(Y),b($e.$$.fragment,Y),ke=i(Y),b(as.$$.fragment,Y),Y.forEach(o),Me.forEach(o),ms=i(_),b(K.$$.fragment,_),Js=i(_),V=p(_,"DIV",{class:!0});var Te=ee(V);b(ge.$$.fragment,Te),os=i(Te),Qe=p(Te,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-1ez74bv"&&(Qe.textContent=S),ls=i(Te),Le=p(Te,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-19b0qqu"&&(Le.innerHTML=Be),$s=i(Te),Pe=p(Te,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-hswkmf"&&(Pe.innerHTML=qe),Bs=i(Te),le=p(Te,"DIV",{class:!0});var O=ee(le);b(te.$$.fragment,O),Us=i(O),Ie=p(O,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1jpbgij"&&(Ie.innerHTML=rs),ys=i(O),b(X.$$.fragment,O),is=i(O),b(We.$$.fragment,O),O.forEach(o),Te.forEach(o),be=i(_),b(hs.$$.fragment,_),us=i(_),x=p(_,"DIV",{class:!0});var D=ee(x);b(ds.$$.fragment,D),ze=i(D),je=p(D,"P",{"data-svelte-h":!0}),f(je)!=="svelte-5p7316"&&(je.innerHTML=gs),fs=i(D),R=p(D,"P",{"data-svelte-h":!0}),f(R)!=="svelte-19b0qqu"&&(R.innerHTML=Ms),_s=i(D),re=p(D,"P",{"data-svelte-h":!0}),f(re)!=="svelte-hswkmf"&&(re.innerHTML=Gs),ws=i(D),H=p(D,"DIV",{class:!0});var M=ee(H);b(De.$$.fragment,M),Oe=i(M),Ne=p(M,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-27xdll"&&(Ne.innerHTML=vs),Ke=i(M),b(fe.$$.fragment,M),bs=i(M),b(N.$$.fragment,M),M.forEach(o),D.forEach(o),this.h()},h(){P(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(_,B){j(e,_,B),l(_,d,B),l(_,s,B),j(n,s,null),h(s,m),h(s,a),h(s,W),h(s,y),h(s,I),h(s,Z),h(s,G),h(s,g),h(s,k),h(s,q),j(ts,q,null),h(q,Ve),h(q,Ce),h(q,Fe),j(pe,q,null),h(q,Xe),j(ve,q,null),l(_,me,B),j(Ee,_,B),l(_,L,B),l(_,Q,B),j(ns,Q,null),h(Q,Se),h(Q,Ze),h(Q,He),h(Q,Ae),h(Q,Ye),h(Q,se),j(Re,se,null),h(se,he),h(se,ps),h(se,we),j($e,se,null),h(se,ke),j(as,se,null),l(_,ms,B),j(K,_,B),l(_,Js,B),l(_,V,B),j(ge,V,null),h(V,os),h(V,Qe),h(V,ls),h(V,Le),h(V,$s),h(V,Pe),h(V,Bs),h(V,le),j(te,le,null),h(le,Us),h(le,Ie),h(le,ys),j(X,le,null),h(le,is),j(We,le,null),l(_,be,B),j(hs,_,B),l(_,us,B),l(_,x,B),j(ds,x,null),h(x,ze),h(x,je),h(x,fs),h(x,R),h(x,_s),h(x,re),h(x,ws),h(x,H),j(De,H,null),h(H,Oe),h(H,Ne),h(H,Ke),j(fe,H,null),h(H,bs),j(N,H,null),Ge=!0},p(_,B){const ne={};B&2&&(ne.$$scope={dirty:B,ctx:_}),pe.$set(ne);const Me={};B&2&&(Me.$$scope={dirty:B,ctx:_}),ve.$set(Me);const Y={};B&2&&(Y.$$scope={dirty:B,ctx:_}),$e.$set(Y);const Te={};B&2&&(Te.$$scope={dirty:B,ctx:_}),as.$set(Te);const O={};B&2&&(O.$$scope={dirty:B,ctx:_}),X.$set(O);const D={};B&2&&(D.$$scope={dirty:B,ctx:_}),We.$set(D);const M={};B&2&&(M.$$scope={dirty:B,ctx:_}),fe.$set(M);const A={};B&2&&(A.$$scope={dirty:B,ctx:_}),N.$set(A)},i(_){Ge||(J(e.$$.fragment,_),J(n.$$.fragment,_),J(ts.$$.fragment,_),J(pe.$$.fragment,_),J(ve.$$.fragment,_),J(Ee.$$.fragment,_),J(ns.$$.fragment,_),J(Re.$$.fragment,_),J($e.$$.fragment,_),J(as.$$.fragment,_),J(K.$$.fragment,_),J(ge.$$.fragment,_),J(te.$$.fragment,_),J(X.$$.fragment,_),J(We.$$.fragment,_),J(hs.$$.fragment,_),J(ds.$$.fragment,_),J(De.$$.fragment,_),J(fe.$$.fragment,_),J(N.$$.fragment,_),Ge=!0)},o(_){U(e.$$.fragment,_),U(n.$$.fragment,_),U(ts.$$.fragment,_),U(pe.$$.fragment,_),U(ve.$$.fragment,_),U(Ee.$$.fragment,_),U(ns.$$.fragment,_),U(Re.$$.fragment,_),U($e.$$.fragment,_),U(as.$$.fragment,_),U(K.$$.fragment,_),U(ge.$$.fragment,_),U(te.$$.fragment,_),U(X.$$.fragment,_),U(We.$$.fragment,_),U(hs.$$.fragment,_),U(ds.$$.fragment,_),U(De.$$.fragment,_),U(fe.$$.fragment,_),U(N.$$.fragment,_),Ge=!1},d(_){_&&(o(d),o(s),o(me),o(L),o(Q),o(ms),o(Js),o(V),o(be),o(us),o(x)),v(e,_),v(n),v(ts),v(pe),v(ve),v(Ee,_),v(ns),v(Re),v($e),v(as),v(K,_),v(ge),v(te),v(X),v(We),v(hs,_),v(ds),v(De),v(fe),v(N)}}}function wn(C){let e,d;return e=new Cs({props:{$$slots:{default:[_n]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function bn(C){let e,d="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",s,n,m="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,u,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,y,F,I=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,z,G=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("ul"),n.innerHTML=m,a=r(),u=c("p"),u.innerHTML=W,y=r(),F=c("ul"),F.innerHTML=I,Z=r(),z=c("p"),z.innerHTML=G},l(g){e=p(g,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1ajbfxg"&&(e.innerHTML=d),s=i(g),n=p(g,"UL",{"data-svelte-h":!0}),f(n)!=="svelte-qm1t26"&&(n.innerHTML=m),a=i(g),u=p(g,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1v9qsc5"&&(u.innerHTML=W),y=i(g),F=p(g,"UL",{"data-svelte-h":!0}),f(F)!=="svelte-15scerc"&&(F.innerHTML=I),Z=i(g),z=p(g,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1an3odd"&&(z.innerHTML=G)},m(g,$){l(g,e,$),l(g,s,$),l(g,n,$),l(g,a,$),l(g,u,$),l(g,y,$),l(g,F,$),l(g,Z,$),l(g,z,$)},p:E,d(g){g&&(o(e),o(s),o(n),o(a),o(u),o(y),o(F),o(Z),o(z))}}}function jn(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function Jn(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc01vZGVsJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMCUyMkhvdyUyMG9sZCUyMGlzJTIwQnJhZCUyMFBpdHQlM0YlMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIodGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0RxdWVyaWVzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function Un(C){let e,d="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",s,n,m="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,u,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,y,F,I=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,z,G=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("ul"),n.innerHTML=m,a=r(),u=c("p"),u.innerHTML=W,y=r(),F=c("ul"),F.innerHTML=I,Z=r(),z=c("p"),z.innerHTML=G},l(g){e=p(g,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1ajbfxg"&&(e.innerHTML=d),s=i(g),n=p(g,"UL",{"data-svelte-h":!0}),f(n)!=="svelte-qm1t26"&&(n.innerHTML=m),a=i(g),u=p(g,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1v9qsc5"&&(u.innerHTML=W),y=i(g),F=p(g,"UL",{"data-svelte-h":!0}),f(F)!=="svelte-15scerc"&&(F.innerHTML=I),Z=i(g),z=p(g,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1an3odd"&&(z.innerHTML=G)},m(g,$){l(g,e,$),l(g,s,$),l(g,n,$),l(g,a,$),l(g,u,$),l(g,y,$),l(g,F,$),l(g,Z,$),l(g,z,$)},p:E,d(g){g&&(o(e),o(s),o(n),o(a),o(u),o(y),o(F),o(Z),o(z))}}}function vn(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function kn(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0Zvck1hc2tlZExNJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc0Zvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwdGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0QlMjJIb3clMjBtYW55JTIwJTVCTUFTSyU1RCUyMGhhcyUyMEdlb3JnZSUyMCU1Qk1BU0slNUQlMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIlMEEpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many [MASK] has George [MASK] played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function In(C){let e,d="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",s,n,m="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,u,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,y,F,I=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,z,G=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("ul"),n.innerHTML=m,a=r(),u=c("p"),u.innerHTML=W,y=r(),F=c("ul"),F.innerHTML=I,Z=r(),z=c("p"),z.innerHTML=G},l(g){e=p(g,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1ajbfxg"&&(e.innerHTML=d),s=i(g),n=p(g,"UL",{"data-svelte-h":!0}),f(n)!=="svelte-qm1t26"&&(n.innerHTML=m),a=i(g),u=p(g,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1v9qsc5"&&(u.innerHTML=W),y=i(g),F=p(g,"UL",{"data-svelte-h":!0}),f(F)!=="svelte-15scerc"&&(F.innerHTML=I),Z=i(g),z=p(g,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1an3odd"&&(z.innerHTML=G)},m(g,$){l(g,e,$),l(g,s,$),l(g,n,$),l(g,a,$),l(g,u,$),l(g,y,$),l(g,F,$),l(g,Z,$),l(g,z,$)},p:E,d(g){g&&(o(e),o(s),o(n),o(a),o(u),o(y),o(F),o(Z),o(z))}}}function Cn(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function Fn(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhlcmUlMjBpcyUyMG9ubHklMjBvbmUlMjBhY3RvciUyMHdobyUyMGlzJTIwNDUlMjB5ZWFycyUyMG9sZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoZXJlJTIwYXJlJTIwMyUyMGFjdG9ycyUyMHdoaWNoJTIwcGxheWVkJTIwaW4lMjBtb3JlJTIwdGhhbiUyMDYwJTIwbW92aWVzJTIyJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFsYWJlbHMlMjAlM0QlMjB0Zi5jb252ZXJ0X3RvX3RlbnNvciglNUIxJTJDJTIwMCU1RCklMjAlMjAlMjMlMjAxJTIwbWVhbnMlMjBlbnRhaWxlZCUyQyUyMDAlMjBtZWFucyUyMHJlZnV0ZWQlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There is only one actor who is 45 years old&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There are 3 actors which played in more than 60 movies&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.convert_to_tensor([<span class="hljs-number">1</span>, <span class="hljs-number">0</span>])  <span class="hljs-comment"># 1 means entailed, 0 means refuted</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function Zn(C){let e,d="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",s,n,m="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,u,W=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,y,F,I=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,z,G=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=d,s=r(),n=c("ul"),n.innerHTML=m,a=r(),u=c("p"),u.innerHTML=W,y=r(),F=c("ul"),F.innerHTML=I,Z=r(),z=c("p"),z.innerHTML=G},l(g){e=p(g,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1ajbfxg"&&(e.innerHTML=d),s=i(g),n=p(g,"UL",{"data-svelte-h":!0}),f(n)!=="svelte-qm1t26"&&(n.innerHTML=m),a=i(g),u=p(g,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1v9qsc5"&&(u.innerHTML=W),y=i(g),F=p(g,"UL",{"data-svelte-h":!0}),f(F)!=="svelte-15scerc"&&(F.innerHTML=I),Z=i(g),z=p(g,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1an3odd"&&(z.innerHTML=G)},m(g,$){l(g,e,$),l(g,s,$),l(g,n,$),l(g,a,$),l(g,u,$),l(g,y,$),l(g,F,$),l(g,Z,$),l(g,z,$)},p:E,d(g){g&&(o(e),o(s),o(n),o(a),o(u),o(y),o(F),o(Z),o(z))}}}function An(C){let e,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=d},l(s){e=p(s,"P",{"data-svelte-h":!0}),f(e)!=="svelte-fincs2"&&(e.innerHTML=d)},m(s,n){l(s,e,n)},p:E,d(s){s&&o(e)}}}function $n(C){let e,d="Examples:",s,n,m;return n=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkFnZSUyMiUzQSUyMCU1QiUyMjU2JTIyJTJDJTIwJTIyNDUlMjIlMkMlMjAlMjI1OSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTJDJTBBJTdEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBcXVlcmllcyUyMCUzRCUyMCU1QiUyMkhvdyUyMG1hbnklMjBtb3ZpZXMlMjBoYXMlMjBHZW9yZ2UlMjBDbG9vbmV5JTIwcGxheWVkJTIwaW4lM0YlMjIlMkMlMjAlMjJIb3clMjBvbGQlMjBpcyUyMEJyYWQlMjBQaXR0JTNGJTIyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsb2dpdHNfYWdncmVnYXRpb24lMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19hZ2dyZWdhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_aggregation = outputs.logits_aggregation`,wrap:!1}}),{c(){e=c("p"),e.textContent=d,s=r(),w(n.$$.fragment)},l(a){e=p(a,"P",{"data-svelte-h":!0}),f(e)!=="svelte-kvfsh7"&&(e.textContent=d),s=i(a),b(n.$$.fragment,a)},m(a,u){l(a,e,u),l(a,s,u),j(n,a,u),m=!0},p:E,i(a){m||(J(n.$$.fragment,a),m=!0)},o(a){U(n.$$.fragment,a),m=!1},d(a){a&&(o(e),o(s)),v(n,a)}}}function Bn(C){let e,d,s,n,m,a,u="The bare Tapas Model transformer outputting raw hidden-states without any specific head on top.",W,y,F=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,I,Z,z=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,G,g,$,k,q,ts,Ve,Ce='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> forward method, overrides the <code>__call__</code> special method.',Fs,Fe,pe,Xe,ve,me,Ee,L,Q,ns,Se,Ze="Tapas Model with a <code>language modeling</code> head on top.",Zs,He,Ae=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,As,Ye,se=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Re,he,ps,ue,we,$e,ke,as='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',ms,K,Js,V,ge,os,Qe,S,ls,Le,Be,$s=`Tapas Model with a sequence classification head on top (a linear layer on top of the pooled output), e.g. for table
entailment tasks, such as TabFact (Chen et al., 2020).`,Pe,qe,Bs=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,le,te,Us=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Ie,rs,ys,X,is,We,be,hs='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForSequenceClassification">TFTapasForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',us,x,ds,ze,je,gs,fs,R,Ms,_s,re,Gs=`Tapas Model with a cell selection head and optional aggregation head on top for question-answering tasks on tables
(linear layers on top of the hidden-states output to compute <code>logits</code> and optional <code>logits_aggregation</code>), e.g. for
SQA, WTQ or WikiSQL-supervised tasks.`,ws,H,De=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Oe,Ne,vs=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Ke,fe,bs,N,Ge,_,B,ne='The <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Me,Y,Te,O,D;return e=new xe({props:{title:"TFTapasModel",local:"transformers.TFTapasModel",headingTag:"h2"}}),n=new oe({props:{name:"class transformers.TFTapasModel",anchor:"transformers.TFTapasModel",parameters:[{name:"config",val:": TapasConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1109"}}),g=new js({props:{$$slots:{default:[bn]},$$scope:{ctx:C}}}),q=new oe({props:{name:"call",anchor:"transformers.TFTapasModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasModel.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasModel.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasModel.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you’re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Fe=new js({props:{$$slots:{default:[jn]},$$scope:{ctx:C}}}),Xe=new zs({props:{anchor:"transformers.TFTapasModel.call.example",$$slots:{default:[Jn]},$$scope:{ctx:C}}}),me=new xe({props:{title:"TFTapasForMaskedLM",local:"transformers.TFTapasForMaskedLM",headingTag:"h2"}}),Q=new oe({props:{name:"class transformers.TFTapasForMaskedLM",anchor:"transformers.TFTapasForMaskedLM",parameters:[{name:"config",val:": TapasConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1184"}}),he=new js({props:{$$slots:{default:[Un]},$$scope:{ctx:C}}}),we=new oe({props:{name:"call",anchor:"transformers.TFTapasForMaskedLM.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForMaskedLM.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForMaskedLM.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForMaskedLM.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForMaskedLM.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForMaskedLM.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForMaskedLM.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForMaskedLM.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForMaskedLM.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> or <code>np.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1201",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),K=new js({props:{$$slots:{default:[vn]},$$scope:{ctx:C}}}),V=new zs({props:{anchor:"transformers.TFTapasForMaskedLM.call.example",$$slots:{default:[kn]},$$scope:{ctx:C}}}),os=new xe({props:{title:"TFTapasForSequenceClassification",local:"transformers.TFTapasForSequenceClassification",headingTag:"h2"}}),ls=new oe({props:{name:"class transformers.TFTapasForSequenceClassification",anchor:"transformers.TFTapasForSequenceClassification",parameters:[{name:"config",val:": TapasConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1731"}}),rs=new js({props:{$$slots:{default:[In]},$$scope:{ctx:C}}}),is=new oe({props:{name:"call",anchor:"transformers.TFTapasForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy). Note: this is called
&#x201C;classification_class_index&#x201D; in the original implementation.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1750",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),x=new js({props:{$$slots:{default:[Cn]},$$scope:{ctx:C}}}),ze=new zs({props:{anchor:"transformers.TFTapasForSequenceClassification.call.example",$$slots:{default:[Fn]},$$scope:{ctx:C}}}),gs=new xe({props:{title:"TFTapasForQuestionAnswering",local:"transformers.TFTapasForQuestionAnswering",headingTag:"h2"}}),Ms=new oe({props:{name:"class transformers.TFTapasForQuestionAnswering",anchor:"transformers.TFTapasForQuestionAnswering",parameters:[{name:"config",val:": TapasConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1388"}}),fe=new js({props:{$$slots:{default:[Zn]},$$scope:{ctx:C}}}),Ge=new oe({props:{name:"call",anchor:"transformers.TFTapasForQuestionAnswering.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"table_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"aggregation_labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"float_answer",val:": np.ndarray | tf.Tensor | None = None"},{name:"numeric_values",val:": np.ndarray | tf.Tensor | None = None"},{name:"numeric_values_scale",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForQuestionAnswering.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForQuestionAnswering.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForQuestionAnswering.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForQuestionAnswering.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForQuestionAnswering.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForQuestionAnswering.call.table_mask",description:`<strong>table_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Mask for the table. Indicates which tokens belong to the table (1). Question tokens, table headers and
padding are 0.`,name:"table_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Labels per token for computing the hierarchical cell selection loss. This encodes the positions of the
answer appearing in the table. Can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.</p>
<ul>
<li>1 for tokens that are <strong>part of the answer</strong>,</li>
<li>0 for tokens that are <strong>not part of the answer</strong>.</li>
</ul>`,name:"labels"},{anchor:"transformers.TFTapasForQuestionAnswering.call.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Aggregation function index for every example in the batch for computing the aggregation loss. Indices
should be in <code>[0, ..., config.num_aggregation_labels - 1]</code>. Only required in case of strong supervision for
aggregation (WikiSQL-supervised).`,name:"aggregation_labels"},{anchor:"transformers.TFTapasForQuestionAnswering.call.float_answer",description:`<strong>float_answer</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Float answer for every example in the batch. Set to <em>float(&#x2018;nan&#x2019;)</em> for cell selection questions. Only
required in case of weak supervision (WTQ) to calculate the aggregate mask and regression loss.`,name:"float_answer"},{anchor:"transformers.TFTapasForQuestionAnswering.call.numeric_values",description:`<strong>numeric_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Numeric values of every token, NaN for tokens which are not numeric values. Can be obtained using
<a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case of weak supervision for aggregation (WTQ) to calculate the
regression loss.`,name:"numeric_values"},{anchor:"transformers.TFTapasForQuestionAnswering.call.numeric_values_scale",description:`<strong>numeric_values_scale</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Scale of the numeric values of every token. Can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case
of weak supervision for aggregation (WTQ) to calculate the regression loss.`,name:"numeric_values_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tf_tapas.py#L1418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.tapas.modeling_tf_tapas.TFTableQuestionAnsweringOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) — Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.</li>
<li><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) — Prediction scores of the cell selection head, for every token.</li>
<li><strong>logits_aggregation</strong> (<code>tf.Tensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) — Prediction scores of the aggregation head, for every aggregation operator.</li>
<li><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.tapas.modeling_tf_tapas.TFTableQuestionAnsweringOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Y=new js({props:{$$slots:{default:[An]},$$scope:{ctx:C}}}),O=new zs({props:{anchor:"transformers.TFTapasForQuestionAnswering.call.example",$$slots:{default:[$n]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment),d=r(),s=c("div"),w(n.$$.fragment),m=r(),a=c("p"),a.textContent=u,W=r(),y=c("p"),y.innerHTML=F,I=r(),Z=c("p"),Z.innerHTML=z,G=r(),w(g.$$.fragment),$=r(),k=c("div"),w(q.$$.fragment),ts=r(),Ve=c("p"),Ve.innerHTML=Ce,Fs=r(),w(Fe.$$.fragment),pe=r(),w(Xe.$$.fragment),ve=r(),w(me.$$.fragment),Ee=r(),L=c("div"),w(Q.$$.fragment),ns=r(),Se=c("p"),Se.innerHTML=Ze,Zs=r(),He=c("p"),He.innerHTML=Ae,As=r(),Ye=c("p"),Ye.innerHTML=se,Re=r(),w(he.$$.fragment),ps=r(),ue=c("div"),w(we.$$.fragment),$e=r(),ke=c("p"),ke.innerHTML=as,ms=r(),w(K.$$.fragment),Js=r(),w(V.$$.fragment),ge=r(),w(os.$$.fragment),Qe=r(),S=c("div"),w(ls.$$.fragment),Le=r(),Be=c("p"),Be.textContent=$s,Pe=r(),qe=c("p"),qe.innerHTML=Bs,le=r(),te=c("p"),te.innerHTML=Us,Ie=r(),w(rs.$$.fragment),ys=r(),X=c("div"),w(is.$$.fragment),We=r(),be=c("p"),be.innerHTML=hs,us=r(),w(x.$$.fragment),ds=r(),w(ze.$$.fragment),je=r(),w(gs.$$.fragment),fs=r(),R=c("div"),w(Ms.$$.fragment),_s=r(),re=c("p"),re.innerHTML=Gs,ws=r(),H=c("p"),H.innerHTML=De,Oe=r(),Ne=c("p"),Ne.innerHTML=vs,Ke=r(),w(fe.$$.fragment),bs=r(),N=c("div"),w(Ge.$$.fragment),_=r(),B=c("p"),B.innerHTML=ne,Me=r(),w(Y.$$.fragment),Te=r(),w(O.$$.fragment),this.h()},l(M){b(e.$$.fragment,M),d=i(M),s=p(M,"DIV",{class:!0});var A=ee(s);b(n.$$.fragment,A),m=i(A),a=p(A,"P",{"data-svelte-h":!0}),f(a)!=="svelte-a941xg"&&(a.textContent=u),W=i(A),y=p(A,"P",{"data-svelte-h":!0}),f(y)!=="svelte-n0y7t5"&&(y.innerHTML=F),I=i(A),Z=p(A,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1be7e3c"&&(Z.innerHTML=z),G=i(A),b(g.$$.fragment,A),$=i(A),k=p(A,"DIV",{class:!0});var cs=ee(k);b(q.$$.fragment,cs),ts=i(cs),Ve=p(cs,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-1okpto9"&&(Ve.innerHTML=Ce),Fs=i(cs),b(Fe.$$.fragment,cs),pe=i(cs),b(Xe.$$.fragment,cs),cs.forEach(o),A.forEach(o),ve=i(M),b(me.$$.fragment,M),Ee=i(M),L=p(M,"DIV",{class:!0});var ye=ee(L);b(Q.$$.fragment,ye),ns=i(ye),Se=p(ye,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-1e80fxn"&&(Se.innerHTML=Ze),Zs=i(ye),He=p(ye,"P",{"data-svelte-h":!0}),f(He)!=="svelte-n0y7t5"&&(He.innerHTML=Ae),As=i(ye),Ye=p(ye,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-1be7e3c"&&(Ye.innerHTML=se),Re=i(ye),b(he.$$.fragment,ye),ps=i(ye),ue=p(ye,"DIV",{class:!0});var Je=ee(ue);b(we.$$.fragment,Je),$e=i(Je),ke=p(Je,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1ef553d"&&(ke.innerHTML=as),ms=i(Je),b(K.$$.fragment,Je),Js=i(Je),b(V.$$.fragment,Je),Je.forEach(o),ye.forEach(o),ge=i(M),b(os.$$.fragment,M),Qe=i(M),S=p(M,"DIV",{class:!0});var _e=ee(S);b(ls.$$.fragment,_e),Le=i(_e),Be=p(_e,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-1ez74bv"&&(Be.textContent=$s),Pe=i(_e),qe=p(_e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-n0y7t5"&&(qe.innerHTML=Bs),le=i(_e),te=p(_e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-1be7e3c"&&(te.innerHTML=Us),Ie=i(_e),b(rs.$$.fragment,_e),ys=i(_e),X=p(_e,"DIV",{class:!0});var ie=ee(X);b(is.$$.fragment,ie),We=i(ie),be=p(ie,"P",{"data-svelte-h":!0}),f(be)!=="svelte-14jf0nf"&&(be.innerHTML=hs),us=i(ie),b(x.$$.fragment,ie),ds=i(ie),b(ze.$$.fragment,ie),ie.forEach(o),_e.forEach(o),je=i(M),b(gs.$$.fragment,M),fs=i(M),R=p(M,"DIV",{class:!0});var ae=ee(R);b(Ms.$$.fragment,ae),_s=i(ae),re=p(ae,"P",{"data-svelte-h":!0}),f(re)!=="svelte-5p7316"&&(re.innerHTML=Gs),ws=i(ae),H=p(ae,"P",{"data-svelte-h":!0}),f(H)!=="svelte-n0y7t5"&&(H.innerHTML=De),Oe=i(ae),Ne=p(ae,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-1be7e3c"&&(Ne.innerHTML=vs),Ke=i(ae),b(fe.$$.fragment,ae),bs=i(ae),N=p(ae,"DIV",{class:!0});var es=ee(N);b(Ge.$$.fragment,es),_=i(es),B=p(es,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1qfklk1"&&(B.innerHTML=ne),Me=i(es),b(Y.$$.fragment,es),Te=i(es),b(O.$$.fragment,es),es.forEach(o),ae.forEach(o),this.h()},h(){P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(M,A){j(e,M,A),l(M,d,A),l(M,s,A),j(n,s,null),h(s,m),h(s,a),h(s,W),h(s,y),h(s,I),h(s,Z),h(s,G),j(g,s,null),h(s,$),h(s,k),j(q,k,null),h(k,ts),h(k,Ve),h(k,Fs),j(Fe,k,null),h(k,pe),j(Xe,k,null),l(M,ve,A),j(me,M,A),l(M,Ee,A),l(M,L,A),j(Q,L,null),h(L,ns),h(L,Se),h(L,Zs),h(L,He),h(L,As),h(L,Ye),h(L,Re),j(he,L,null),h(L,ps),h(L,ue),j(we,ue,null),h(ue,$e),h(ue,ke),h(ue,ms),j(K,ue,null),h(ue,Js),j(V,ue,null),l(M,ge,A),j(os,M,A),l(M,Qe,A),l(M,S,A),j(ls,S,null),h(S,Le),h(S,Be),h(S,Pe),h(S,qe),h(S,le),h(S,te),h(S,Ie),j(rs,S,null),h(S,ys),h(S,X),j(is,X,null),h(X,We),h(X,be),h(X,us),j(x,X,null),h(X,ds),j(ze,X,null),l(M,je,A),j(gs,M,A),l(M,fs,A),l(M,R,A),j(Ms,R,null),h(R,_s),h(R,re),h(R,ws),h(R,H),h(R,Oe),h(R,Ne),h(R,Ke),j(fe,R,null),h(R,bs),h(R,N),j(Ge,N,null),h(N,_),h(N,B),h(N,Me),j(Y,N,null),h(N,Te),j(O,N,null),D=!0},p(M,A){const cs={};A&2&&(cs.$$scope={dirty:A,ctx:M}),g.$set(cs);const ye={};A&2&&(ye.$$scope={dirty:A,ctx:M}),Fe.$set(ye);const Je={};A&2&&(Je.$$scope={dirty:A,ctx:M}),Xe.$set(Je);const _e={};A&2&&(_e.$$scope={dirty:A,ctx:M}),he.$set(_e);const ie={};A&2&&(ie.$$scope={dirty:A,ctx:M}),K.$set(ie);const ae={};A&2&&(ae.$$scope={dirty:A,ctx:M}),V.$set(ae);const es={};A&2&&(es.$$scope={dirty:A,ctx:M}),rs.$set(es);const qs={};A&2&&(qs.$$scope={dirty:A,ctx:M}),x.$set(qs);const dt={};A&2&&(dt.$$scope={dirty:A,ctx:M}),ze.$set(dt);const Ns={};A&2&&(Ns.$$scope={dirty:A,ctx:M}),fe.$set(Ns);const ks={};A&2&&(ks.$$scope={dirty:A,ctx:M}),Y.$set(ks);const Vs={};A&2&&(Vs.$$scope={dirty:A,ctx:M}),O.$set(Vs)},i(M){D||(J(e.$$.fragment,M),J(n.$$.fragment,M),J(g.$$.fragment,M),J(q.$$.fragment,M),J(Fe.$$.fragment,M),J(Xe.$$.fragment,M),J(me.$$.fragment,M),J(Q.$$.fragment,M),J(he.$$.fragment,M),J(we.$$.fragment,M),J(K.$$.fragment,M),J(V.$$.fragment,M),J(os.$$.fragment,M),J(ls.$$.fragment,M),J(rs.$$.fragment,M),J(is.$$.fragment,M),J(x.$$.fragment,M),J(ze.$$.fragment,M),J(gs.$$.fragment,M),J(Ms.$$.fragment,M),J(fe.$$.fragment,M),J(Ge.$$.fragment,M),J(Y.$$.fragment,M),J(O.$$.fragment,M),D=!0)},o(M){U(e.$$.fragment,M),U(n.$$.fragment,M),U(g.$$.fragment,M),U(q.$$.fragment,M),U(Fe.$$.fragment,M),U(Xe.$$.fragment,M),U(me.$$.fragment,M),U(Q.$$.fragment,M),U(he.$$.fragment,M),U(we.$$.fragment,M),U(K.$$.fragment,M),U(V.$$.fragment,M),U(os.$$.fragment,M),U(ls.$$.fragment,M),U(rs.$$.fragment,M),U(is.$$.fragment,M),U(x.$$.fragment,M),U(ze.$$.fragment,M),U(gs.$$.fragment,M),U(Ms.$$.fragment,M),U(fe.$$.fragment,M),U(Ge.$$.fragment,M),U(Y.$$.fragment,M),U(O.$$.fragment,M),D=!1},d(M){M&&(o(d),o(s),o(ve),o(Ee),o(L),o(ge),o(Qe),o(S),o(je),o(fs),o(R)),v(e,M),v(n),v(g),v(q),v(Fe),v(Xe),v(me,M),v(Q),v(he),v(we),v(K),v(V),v(os,M),v(ls),v(rs),v(is),v(x),v(ze),v(gs,M),v(Ms),v(fe),v(Ge),v(Y),v(O)}}}function qn(C){let e,d;return e=new Cs({props:{$$slots:{default:[Bn]},$$scope:{ctx:C}}}),{c(){w(e.$$.fragment)},l(s){b(e.$$.fragment,s)},m(s,n){j(e,s,n),d=!0},p(s,n){const m={};n&2&&(m.$$scope={dirty:n,ctx:s}),e.$set(m)},i(s){d||(J(e.$$.fragment,s),d=!0)},o(s){U(e.$$.fragment,s),d=!1},d(s){v(e,s)}}}function Wn(C){let e,d,s,n,m,a,u,W,y,F=`The TAPAS model was proposed in <a href="https://www.aclweb.org/anthology/2020.acl-main.398" rel="nofollow">TAPAS: Weakly Supervised Table Parsing via Pre-training</a>
by Jonathan Herzig, Paweł Krzysztof Nowak, Thomas Müller, Francesco Piccinno and Julian Martin Eisenschlos. It’s a BERT-based model specifically
designed (and pre-trained) for answering questions about tabular data. Compared to BERT, TAPAS uses relative position embeddings and has 7
token types that encode tabular structure. TAPAS is pre-trained on the masked language modeling (MLM) objective on a large dataset comprising
millions of tables from English Wikipedia and corresponding texts.`,I,Z,z="For question answering, TAPAS has 2 heads on top: a cell selection head and an aggregation head, for (optionally) performing aggregations (such as counting or summing) among selected cells. TAPAS has been fine-tuned on several datasets:",G,g,$='<li><a href="https://www.microsoft.com/en-us/download/details.aspx?id=54253" rel="nofollow">SQA</a> (Sequential Question Answering by Microsoft)</li> <li><a href="https://github.com/ppasupat/WikiTableQuestions" rel="nofollow">WTQ</a> (Wiki Table Questions by Stanford University)</li> <li><a href="https://github.com/salesforce/WikiSQL" rel="nofollow">WikiSQL</a> (by Salesforce).</li>',k,q,ts="It achieves state-of-the-art on both SQA and WTQ, while having comparable performance to SOTA on WikiSQL, with a much simpler architecture.",Ve,Ce,Fs="The abstract from the paper is the following:",Fe,pe,Xe="<em>Answering natural language questions over tables is usually seen as a semantic parsing task. To alleviate the collection cost of full logical forms, one popular approach focuses on weak supervision consisting of denotations instead of logical forms. However, training semantic parsers from weak supervision poses difficulties, and in addition, the generated logical forms are only used as an intermediate step prior to retrieving the denotation. In this paper, we present TAPAS, an approach to question answering over tables without generating logical forms. TAPAS trains from weak supervision, and predicts the denotation by selecting table cells and optionally applying a corresponding aggregation operator to such selection. TAPAS extends BERT’s architecture to encode tables as input, initializes from an effective joint pre-training of text segments and tables crawled from Wikipedia, and is trained end-to-end. We experiment with three different semantic parsing datasets, and find that TAPAS outperforms or rivals semantic parsing models by improving state-of-the-art accuracy on SQA from 55.1 to 67.2 and performing on par with the state-of-the-art on WIKISQL and WIKITQ, but with a simpler model architecture. We additionally find that transfer learning, which is trivial in our setting, from WIKISQL to WIKITQ, yields 48.7 accuracy, 4.2 points above the state-of-the-art.</em>",ve,me,Ee='In addition, the authors have further pre-trained TAPAS to recognize <strong>table entailment</strong>, by creating a balanced dataset of millions of automatically created training examples which are learned in an intermediate step prior to fine-tuning. The authors of TAPAS call this further pre-training intermediate pre-training (since TAPAS is first pre-trained on MLM, and then on another dataset). They found that intermediate pre-training further improves performance on SQA, achieving a new state-of-the-art as well as state-of-the-art on <a href="https://github.com/wenhuchen/Table-Fact-Checking" rel="nofollow">TabFact</a>, a large-scale dataset with 16k Wikipedia tables for table entailment (a binary classification task). For more details, see their follow-up paper: <a href="https://www.aclweb.org/anthology/2020.findings-emnlp.27/" rel="nofollow">Understanding tables with intermediate pre-training</a> by Julian Martin Eisenschlos, Syrine Krichene and Thomas Müller.',L,Q,ns,Se,Ze,Zs='TAPAS architecture. Taken from the <a href="https://ai.googleblog.com/2020/04/using-neural-networks-to-find-answers.html">original blog post</a>.',He,Ae,As='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The Tensorflow version of this model was contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/google-research/tapas" rel="nofollow">here</a>.',Ye,se,Re,he,ps='<li>TAPAS is a model that uses relative position embeddings by default (restarting the position embeddings at every cell of the table). Note that this is something that was added after the publication of the original TAPAS paper. According to the authors, this usually results in a slightly better performance, and allows you to encode longer sequences without running out of embeddings. This is reflected in the <code>reset_position_index_per_cell</code> parameter of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, which is set to <code>True</code> by default. The default versions of the models available on the <a href="https://huggingface.co/models?search=tapas" rel="nofollow">hub</a> all use relative position embeddings. You can still use the ones with absolute position embeddings by passing in an additional argument <code>revision=&quot;no_reset&quot;</code> when calling the <code>from_pretrained()</code> method. Note that it’s usually advised to pad the inputs on the right rather than the left.</li> <li>TAPAS is based on BERT, so <code>TAPAS-base</code> for example corresponds to a <code>BERT-base</code> architecture. Of course, <code>TAPAS-large</code> will result in the best performance (the results reported in the paper are from <code>TAPAS-large</code>). Results of the various sized models are shown on the <a href="https://github.com/google-research/tapas" rel="nofollow">original GitHub repository</a>.</li> <li>TAPAS has checkpoints fine-tuned on SQA, which are capable of answering questions related to a table in a conversational set-up. This means that you can ask follow-up questions such as “what is his age?” related to the previous question. Note that the forward pass of TAPAS is a bit different in case of a conversational set-up: in that case, you have to feed every table-question pair one by one to the model, such that the <code>prev_labels</code> token type ids can be overwritten by the predicted <code>labels</code> of the model to the previous question. See “Usage” section for more info.</li> <li>TAPAS is similar to BERT and therefore relies on the masked language modeling (MLM) objective. It is therefore efficient at predicting masked tokens and at NLU in general, but is not optimal for text generation. Models trained with a causal language modeling (CLM) objective are better in that regard. Note that TAPAS can be used as an encoder in the EncoderDecoderModel framework, to combine it with an autoregressive text decoder such as GPT-2.</li>',ue,we,$e,ke,as='Here we explain how you can fine-tune <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> on your own dataset.',ms,K,Js="<strong>STEP 1: Choose one of the 3 ways in which you can use TAPAS - or experiment</strong>",V,ge,os='Basically, there are 3 different ways in which one can fine-tune <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a>, corresponding to the different datasets on which Tapas was fine-tuned:',Qe,S,ls="<li>SQA: if you’re interested in asking follow-up questions related to a table, in a conversational set-up. For example if you first ask “what’s the name of the first actor?” then you can ask a follow-up question such as “how old is he?“. Here, questions do not involve any aggregation (all questions are cell selection questions).</li> <li>WTQ: if you’re not interested in asking questions in a conversational set-up, but rather just asking questions related to a table, which might involve aggregation, such as counting a number of rows, summing up cell values or averaging cell values. You can then for example ask “what’s the total number of goals Cristiano Ronaldo made in his career?“. This case is also called <strong>weak supervision</strong>, since the model itself must learn the appropriate aggregation operator (SUM/COUNT/AVERAGE/NONE) given only the answer to the question as supervision.</li> <li>WikiSQL-supervised: this dataset is based on WikiSQL with the model being given the ground truth aggregation operator during training. This is also called <strong>strong supervision</strong>. Here, learning the appropriate aggregation operator is much easier.</li>",Le,Be,$s="To summarize:",Pe,qe,Bs="<thead><tr><th><strong>Task</strong></th> <th><strong>Example dataset</strong></th> <th><strong>Description</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td>SQA</td> <td>Conversational, only cell selection questions</td></tr> <tr><td>Weak supervision for aggregation</td> <td>WTQ</td> <td>Questions might involve aggregation, and the model must learn this given only the answer as supervision</td></tr> <tr><td>Strong supervision for aggregation</td> <td>WikiSQL-supervised</td> <td>Questions might involve aggregation, and the model must learn this given the gold aggregation operator</td></tr></tbody>",le,te,Us,Ie,rs='What you can also do is start from an already fine-tuned checkpoint. A note here is that the already fine-tuned checkpoint on WTQ has some issues due to the L2-loss which is somewhat brittle. See <a href="https://github.com/google-research/tapas/issues/91#issuecomment-735719340" rel="nofollow">here</a> for more info.',ys,X,is='For a list of all pre-trained and fine-tuned TAPAS checkpoints available on HuggingFace’s  hub, see <a href="https://huggingface.co/models?search=tapas" rel="nofollow">here</a>.',We,be,hs="<strong>STEP 2: Prepare your data in the SQA format</strong>",us,x,ds='Second, no matter what you picked above, you should prepare your dataset in the <a href="https://www.microsoft.com/en-us/download/details.aspx?id=54253" rel="nofollow">SQA</a> format. This format is a TSV/CSV file with the following columns:',ze,je,gs="<li><code>id</code>: optional, id of the table-question pair, for bookkeeping purposes.</li> <li><code>annotator</code>: optional, id of the person who annotated the table-question pair, for bookkeeping purposes.</li> <li><code>position</code>: integer indicating if the question is the first, second, third,… related to the table. Only required in case of conversational setup (SQA). You don’t need this column in case you’re going for WTQ/WikiSQL-supervised.</li> <li><code>question</code>: string</li> <li><code>table_file</code>: string, name of a csv file containing the tabular data</li> <li><code>answer_coordinates</code>: list of one or more tuples (each tuple being a cell coordinate, i.e. row, column pair that is part of the answer)</li> <li><code>answer_text</code>: list of one or more strings (each string being a cell value that is part of the answer)</li> <li><code>aggregation_label</code>: index of the aggregation operator. Only required in case of strong supervision for aggregation (the WikiSQL-supervised case)</li> <li><code>float_answer</code>: the float answer to the question, if there is one (np.nan if there isn’t). Only required in case of weak supervision for aggregation (such as WTQ and WikiSQL)</li>",fs,R,Ms='The tables themselves should be present in a folder, each table being a separate csv file. Note that the authors of the TAPAS algorithm used conversion scripts with some automated logic to convert the other datasets (WTQ, WikiSQL) into the SQA format. The author explains this <a href="https://github.com/google-research/tapas/issues/50#issuecomment-705465960" rel="nofollow">here</a>. A conversion of this script that works with HuggingFace’s implementation can be found <a href="https://github.com/NielsRogge/tapas_utils" rel="nofollow">here</a>. Interestingly, these conversion scripts are not perfect (the <code>answer_coordinates</code> and <code>float_answer</code> fields are populated based on the <code>answer_text</code>), meaning that WTQ and WikiSQL results could actually be improved.',_s,re,Gs="<strong>STEP 3: Convert your data into tensors using TapasTokenizer</strong>",ws,H,De,Oe,Ne=`Note that here, we encode each table-question pair independently. This is fine as long as your dataset is <strong>not conversational</strong>. In case your dataset involves conversational questions (such as in SQA), then you should first group together the <code>queries</code>, <code>answer_coordinates</code> and <code>answer_text</code> per table (in the order of their <code>position</code>
index) and batch encode each table with its questions. This will make sure that the <code>prev_labels</code> token types (see docs of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) are set correctly. See <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> for more info. See <a href="https://github.com/kamalkraj/Tapas-Tutorial/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> for more info regarding using the TensorFlow model.`,vs,Ke,fe="**STEP 4: Train (fine-tune) the model",bs,N,Ge,_,B,ne,Me,Y,Te='In case of a conversational set-up, then each table-question pair must be provided <strong>sequentially</strong> to the model, such that the <code>prev_labels</code> token types can be overwritten by the predicted <code>labels</code> of the previous table-question pair. Again, more info can be found in <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> (for PyTorch) and <a href="https://github.com/kamalkraj/Tapas-Tutorial/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> (for TensorFlow).',O,D,M,A,cs='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li>',ye,Je,_e,ie,ae,es,qs,dt='Output type of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a>.',Ns,ks,Vs,ss,Xs,Tt,Os,At=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>. It is used to instantiate a TAPAS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the TAPAS
<a href="https://huggingface.co/google/tapas-base-finetuned-sqa" rel="nofollow">google/tapas-base-finetuned-sqa</a> architecture.`,yt,Ks,$t=`Configuration objects inherit from <code>PreTrainedConfig</code> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,_t,et,Bt=`Hyperparameters additional to BERT are taken from run_task_main.py and hparam_utils.py of the original
implementation. Original implementation available at <a href="https://github.com/google-research/tapas/tree/master" rel="nofollow">https://github.com/google-research/tapas/tree/master</a>.`,wt,xs,ht,Es,ut,de,Ss,bt,st,qt=`Construct a TAPAS tokenizer. Based on WordPiece. Flattens a table and one or more related sentences to be used by
TAPAS models.`,jt,tt,Wt=`This tokenizer inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods. <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates several token type ids to
encode tabular structure. To be more precise, it adds 7 token type ids, in the following order: <code>segment_ids</code>,
<code>column_ids</code>, <code>row_ids</code>, <code>prev_labels</code>, <code>column_ranks</code>, <code>inv_column_ranks</code> and <code>numeric_relations</code>:`,Jt,nt,zt=`<li>segment_ids: indicate whether a token belongs to the question (0) or the table (1). 0 for special tokens and
padding.</li> <li>column_ids: indicate to which column of the table a token belongs (starting from 1). Is 0 for all question
tokens, special tokens and padding.</li> <li>row_ids: indicate to which row of the table a token belongs (starting from 1). Is 0 for all question tokens,
special tokens and padding. Tokens of column headers are also 0.</li> <li>prev_labels: indicate whether a token was (part of) an answer to the previous question (1) or not (0). Useful in
a conversational setup (such as SQA).</li> <li>column_ranks: indicate the rank of a table token relative to a column, if applicable. For example, if you have a
column “number of movies” with values 87, 53 and 69, then the column ranks of these tokens are 3, 1 and 2
respectively. 0 for all question tokens, special tokens and padding.</li> <li>inv_column_ranks: indicate the inverse rank of a table token relative to a column, if applicable. For example, if
you have a column “number of movies” with values 87, 53 and 69, then the inverse column ranks of these tokens are
1, 3 and 2 respectively. 0 for all question tokens, special tokens and padding.</li> <li>numeric_relations: indicate numeric relations between the question and the tokens of the table. 0 for all
question tokens, special tokens and padding.</li>`,Ut,at,Gt=`<a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> runs end-to-end tokenization on a table and associated sentences: punctuation splitting and
wordpiece.`,vt,Rs,Hs,kt,ot,xt="Main method to tokenize and prepare for the model one or several sequence(s) related to a table.",It,Is,Ys,Ct,lt,Rt=`Converts logits of <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> to actual predicted answer coordinates and optional
aggregation indices.`,Ft,rt,Qt=`The original implementation, on which this function is based, can be found
<a href="https://github.com/google-research/tapas/blob/4908213eb4df7aa988573350278b44c4dbe3f71b/tapas/experiments/prediction_utils.py#L288" rel="nofollow">here</a>.`,Zt,it,Ls,gt,Qs,ft,ct,Mt;return m=new xe({props:{title:"TAPAS",local:"tapas",headingTag:"h1"}}),u=new xe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new xe({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),we=new xe({props:{title:"Usage: fine-tuning",local:"usage-fine-tuning",headingTag:"h2"}}),te=new mt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Dt],pytorch:[Lt]},$$scope:{ctx:C}}}),H=new mt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[sn],pytorch:[Kt]},$$scope:{ctx:C}}}),N=new mt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[on],pytorch:[nn]},$$scope:{ctx:C}}}),_=new xe({props:{title:"Usage: inference",local:"usage-inference",headingTag:"h2"}}),ne=new mt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[cn],pytorch:[rn]},$$scope:{ctx:C}}}),D=new xe({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Je=new xe({props:{title:"TAPAS specific outputs",local:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",headingTag:"h2"}}),ae=new oe({props:{name:"class transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"logits_aggregation",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) &#x2014;
Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.`,name:"loss"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Prediction scores of the cell selection head, for every token.`,name:"logits"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.logits_aggregation",description:`<strong>logits_aggregation</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) &#x2014;
Prediction scores of the aggregation head, for every aggregation operator.`,name:"logits_aggregation"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/modeling_tapas.py#L97"}}),ks=new xe({props:{title:"TapasConfig",local:"transformers.TapasConfig",headingTag:"h2"}}),Xs=new oe({props:{name:"class transformers.TapasConfig",anchor:"transformers.TapasConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 1024"},{name:"type_vocab_sizes",val:" = [3, 256, 256, 2, 256, 256, 10]"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"positive_label_weight",val:" = 10.0"},{name:"num_aggregation_labels",val:" = 0"},{name:"aggregation_loss_weight",val:" = 1.0"},{name:"use_answer_as_supervision",val:" = None"},{name:"answer_loss_importance",val:" = 1.0"},{name:"use_normalized_answer_loss",val:" = False"},{name:"huber_loss_delta",val:" = None"},{name:"temperature",val:" = 1.0"},{name:"aggregation_temperature",val:" = 1.0"},{name:"use_gumbel_for_cells",val:" = False"},{name:"use_gumbel_for_aggregation",val:" = False"},{name:"average_approximation_function",val:" = 'ratio'"},{name:"cell_selection_preference",val:" = None"},{name:"answer_loss_cutoff",val:" = None"},{name:"max_num_rows",val:" = 64"},{name:"max_num_columns",val:" = 32"},{name:"average_logits_per_cell",val:" = False"},{name:"select_one_column",val:" = True"},{name:"allow_empty_column_selection",val:" = False"},{name:"init_cell_selection_weights_to_zero",val:" = False"},{name:"reset_position_index_per_cell",val:" = True"},{name:"disable_per_token_loss",val:" = False"},{name:"aggregation_labels",val:" = None"},{name:"no_aggregation_label_index",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the TAPAS model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>.`,name:"vocab_size"},{anchor:"transformers.TapasConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.TapasConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TapasConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TapasConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TapasConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;swish&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TapasConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.TapasConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.TapasConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.TapasConfig.type_vocab_sizes",description:`<strong>type_vocab_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 256, 256, 2, 256, 256, 10]</code>) &#x2014;
The vocabulary sizes of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>.`,name:"type_vocab_sizes"},{anchor:"transformers.TapasConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TapasConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TapasConfig.positive_label_weight",description:`<strong>positive_label_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
Weight for positive labels.`,name:"positive_label_weight"},{anchor:"transformers.TapasConfig.num_aggregation_labels",description:`<strong>num_aggregation_labels</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The number of aggregation operators to predict.`,name:"num_aggregation_labels"},{anchor:"transformers.TapasConfig.aggregation_loss_weight",description:`<strong>aggregation_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Importance weight for the aggregation loss.`,name:"aggregation_loss_weight"},{anchor:"transformers.TapasConfig.use_answer_as_supervision",description:`<strong>use_answer_as_supervision</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the answer as the only supervision for aggregation examples.`,name:"use_answer_as_supervision"},{anchor:"transformers.TapasConfig.answer_loss_importance",description:`<strong>answer_loss_importance</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Importance weight for the regression loss.`,name:"answer_loss_importance"},{anchor:"transformers.TapasConfig.use_normalized_answer_loss",description:`<strong>use_normalized_answer_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the answer loss by the maximum of the predicted and expected value.`,name:"use_normalized_answer_loss"},{anchor:"transformers.TapasConfig.huber_loss_delta",description:`<strong>huber_loss_delta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Delta parameter used to calculate the regression loss.`,name:"huber_loss_delta"},{anchor:"transformers.TapasConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Value used to control (OR change) the skewness of cell logits probabilities.`,name:"temperature"},{anchor:"transformers.TapasConfig.aggregation_temperature",description:`<strong>aggregation_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Scales aggregation logits to control the skewness of probabilities.`,name:"aggregation_temperature"},{anchor:"transformers.TapasConfig.use_gumbel_for_cells",description:`<strong>use_gumbel_for_cells</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply Gumbel-Softmax to cell selection.`,name:"use_gumbel_for_cells"},{anchor:"transformers.TapasConfig.use_gumbel_for_aggregation",description:`<strong>use_gumbel_for_aggregation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply Gumbel-Softmax to aggregation selection.`,name:"use_gumbel_for_aggregation"},{anchor:"transformers.TapasConfig.average_approximation_function",description:`<strong>average_approximation_function</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;ratio&quot;</code>) &#x2014;
Method to calculate the expected average of cells in the weak supervision case. One of <code>&quot;ratio&quot;</code>,
<code>&quot;first_order&quot;</code> or <code>&quot;second_order&quot;</code>.`,name:"average_approximation_function"},{anchor:"transformers.TapasConfig.cell_selection_preference",description:`<strong>cell_selection_preference</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Preference for cell selection in ambiguous cases. Only applicable in case of weak supervision for
aggregation (WTQ, WikiSQL). If the total mass of the aggregation probabilities (excluding the &#x201C;NONE&#x201D;
operator) is higher than this hyperparameter, then aggregation is predicted for an example.`,name:"cell_selection_preference"},{anchor:"transformers.TapasConfig.answer_loss_cutoff",description:`<strong>answer_loss_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Ignore examples with answer loss larger than cutoff.`,name:"answer_loss_cutoff"},{anchor:"transformers.TapasConfig.max_num_rows",description:`<strong>max_num_rows</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Maximum number of rows.`,name:"max_num_rows"},{anchor:"transformers.TapasConfig.max_num_columns",description:`<strong>max_num_columns</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Maximum number of columns.`,name:"max_num_columns"},{anchor:"transformers.TapasConfig.average_logits_per_cell",description:`<strong>average_logits_per_cell</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to average logits per cell.`,name:"average_logits_per_cell"},{anchor:"transformers.TapasConfig.select_one_column",description:`<strong>select_one_column</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to constrain the model to only select cells from a single column.`,name:"select_one_column"},{anchor:"transformers.TapasConfig.allow_empty_column_selection",description:`<strong>allow_empty_column_selection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to allow not to select any column.`,name:"allow_empty_column_selection"},{anchor:"transformers.TapasConfig.init_cell_selection_weights_to_zero",description:`<strong>init_cell_selection_weights_to_zero</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to initialize cell selection weights to 0 so that the initial probabilities are 50%.`,name:"init_cell_selection_weights_to_zero"},{anchor:"transformers.TapasConfig.reset_position_index_per_cell",description:`<strong>reset_position_index_per_cell</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to restart position indexes at every cell (i.e. use relative position embeddings).`,name:"reset_position_index_per_cell"},{anchor:"transformers.TapasConfig.disable_per_token_loss",description:`<strong>disable_per_token_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to disable any (strong or weak) supervision on cells.`,name:"disable_per_token_loss"},{anchor:"transformers.TapasConfig.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>Dict[int, label]</code>, <em>optional</em>) &#x2014;
The aggregation labels used to aggregate the results. For example, the WTQ models have the following
aggregation labels: <code>{0: &quot;NONE&quot;, 1: &quot;SUM&quot;, 2: &quot;AVERAGE&quot;, 3: &quot;COUNT&quot;}</code>`,name:"aggregation_labels"},{anchor:"transformers.TapasConfig.no_aggregation_label_index",description:`<strong>no_aggregation_label_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the aggregation labels are defined and one of these labels represents &#x201C;No aggregation&#x201D;, this should be
set to its index. For example, the WTQ models have the &#x201C;NONE&#x201D; aggregation label at index 0, so that value
should be set to 0 for these models.`,name:"no_aggregation_label_index"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/configuration_tapas.py#L45"}}),xs=new zs({props:{anchor:"transformers.TapasConfig.example",$$slots:{default:[pn]},$$scope:{ctx:C}}}),Es=new xe({props:{title:"TapasTokenizer",local:"transformers.TapasTokenizer",headingTag:"h2"}}),Ss=new oe({props:{name:"class transformers.TapasTokenizer",anchor:"transformers.TapasTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"empty_token",val:" = '[EMPTY]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"cell_trim_length",val:": int = -1"},{name:"max_column_id",val:": int = None"},{name:"max_row_id",val:": int = None"},{name:"strip_column_names",val:": bool = False"},{name:"update_answer_coordinates",val:": bool = False"},{name:"min_question_length",val:" = None"},{name:"max_question_length",val:" = None"},{name:"model_max_length",val:": int = 512"},{name:"additional_special_tokens",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.TapasTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.TapasTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.TapasTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.TapasTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.TapasTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.TapasTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.TapasTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.TapasTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.TapasTokenizer.empty_token",description:`<strong>empty_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EMPTY]&quot;</code>) &#x2014;
The token used for empty cell values in a table. Empty cell values include &quot;&quot;, &#x201C;n/a&#x201D;, &#x201C;nan&#x201D; and &#x201D;?&#x201C;.`,name:"empty_token"},{anchor:"transformers.TapasTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.TapasTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.TapasTokenizer.cell_trim_length",description:`<strong>cell_trim_length</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
If &gt; 0: Trim cells so that the length is &lt;= this value. Also disables further cell trimming, should thus be
used with <code>truncation</code> set to <code>True</code>.`,name:"cell_trim_length"},{anchor:"transformers.TapasTokenizer.max_column_id",description:`<strong>max_column_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Max column id to extract.`,name:"max_column_id"},{anchor:"transformers.TapasTokenizer.max_row_id",description:`<strong>max_row_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Max row id to extract.`,name:"max_row_id"},{anchor:"transformers.TapasTokenizer.strip_column_names",description:`<strong>strip_column_names</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add empty strings instead of column names.`,name:"strip_column_names"},{anchor:"transformers.TapasTokenizer.update_answer_coordinates",description:`<strong>update_answer_coordinates</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to recompute the answer coordinates from the answer text.`,name:"update_answer_coordinates"},{anchor:"transformers.TapasTokenizer.min_question_length",description:`<strong>min_question_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Minimum length of each question in terms of tokens (will be skipped otherwise).`,name:"min_question_length"},{anchor:"transformers.TapasTokenizer.max_question_length",description:`<strong>max_question_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of each question in terms of tokens (will be skipped otherwise).`,name:"max_question_length"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/tokenization_tapas.py#L237"}}),Hs=new oe({props:{name:"__call__",anchor:"transformers.TapasTokenizer.__call__",parameters:[{name:"table",val:": pd.DataFrame"},{name:"queries",val:": Union = None"},{name:"answer_coordinates",val:": Union = None"},{name:"answer_text",val:": Union = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = False"},{name:"max_length",val:": Optional = None"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasTokenizer.__call__.table",description:`<strong>table</strong> (<code>pd.DataFrame</code>) &#x2014;
Table containing tabular data. Note that all cell values must be text. Use <em>.astype(str)</em> on a Pandas
dataframe to convert it to string.`,name:"table"},{anchor:"transformers.TapasTokenizer.__call__.queries",description:`<strong>queries</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
Question or batch of questions related to a table to be encoded. Note that in case of a batch, all
questions must refer to the <strong>same</strong> table.`,name:"queries"},{anchor:"transformers.TapasTokenizer.__call__.answer_coordinates",description:`<strong>answer_coordinates</strong> (<code>List[Tuple]</code> or <code>List[List[Tuple]]</code>, <em>optional</em>) &#x2014;
Answer coordinates of each table-question pair in the batch. In case only a single table-question pair
is provided, then the answer_coordinates must be a single list of one or more tuples. Each tuple must
be a (row_index, column_index) pair. The first data row (not the column header row) has index 0. The
first column has index 0. In case a batch of table-question pairs is provided, then the
answer_coordinates must be a list of lists of tuples (each list corresponding to a single
table-question pair).`,name:"answer_coordinates"},{anchor:"transformers.TapasTokenizer.__call__.answer_text",description:`<strong>answer_text</strong> (<code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Answer text of each table-question pair in the batch. In case only a single table-question pair is
provided, then the answer_text must be a single list of one or more strings. Each string must be the
answer text of a corresponding answer coordinate. In case a batch of table-question pairs is provided,
then the answer_coordinates must be a list of lists of strings (each list corresponding to a single
table-question pair).`,name:"answer_text"},{anchor:"transformers.TapasTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.TapasTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.38.1/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.TapasTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <code>TapasTruncationStrategy</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;drop_rows_to_fit&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code>
or to the maximum acceptable input length for the model if that argument is not provided. This will
truncate row by row, removing rows from the table.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.TapasTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.TapasTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.TapasTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.TapasTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.38.1/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/tokenization_tapas.py#L588"}}),Ys=new oe({props:{name:"convert_logits_to_predictions",anchor:"transformers.TapasTokenizer.convert_logits_to_predictions",parameters:[{name:"data",val:""},{name:"logits",val:""},{name:"logits_agg",val:" = None"},{name:"cell_classification_threshold",val:" = 0.5"}],parametersDescription:[{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary mapping features to actual values. Should be created using <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>.`,name:"data"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.logits",description:`<strong>logits</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Tensor containing the logits at the token level.`,name:"logits"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.logits_agg",description:`<strong>logits_agg</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_aggregation_labels)</code>, <em>optional</em>) &#x2014;
Tensor containing the aggregation logits.`,name:"logits_agg"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.cell_classification_threshold",description:`<strong>cell_classification_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to be used for cell selection. All table cells for which their probability is larger than
this threshold will be selected.`,name:"cell_classification_threshold"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/tokenization_tapas.py#L1951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>predicted_answer_coordinates (<code>List[List[[tuple]]</code> of length <code>batch_size</code>): Predicted answer coordinates
as a list of lists of tuples. Each element in the list contains the predicted answer coordinates of a
single example in the batch, as a list of tuples. Each tuple is a cell, i.e. (row index, column index).</li>
<li>predicted_aggregation_indices (<code>List[int]</code>of length <code>batch_size</code>, <em>optional</em>, returned when
<code>logits_aggregation</code> is provided): Predicted aggregation operator indices of the aggregation head.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple</code> comprising various elements depending on the inputs</p>
`}}),Ls=new oe({props:{name:"save_vocabulary",anchor:"transformers.TapasTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/tapas/tokenization_tapas.py#L456"}}),Qs=new mt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[qn],pytorch:[wn]},$$scope:{ctx:C}}}),{c(){e=c("meta"),d=r(),s=c("p"),n=r(),w(m.$$.fragment),a=r(),w(u.$$.fragment),W=r(),y=c("p"),y.innerHTML=F,I=r(),Z=c("p"),Z.textContent=z,G=r(),g=c("ul"),g.innerHTML=$,k=r(),q=c("p"),q.textContent=ts,Ve=r(),Ce=c("p"),Ce.textContent=Fs,Fe=r(),pe=c("p"),pe.innerHTML=Xe,ve=r(),me=c("p"),me.innerHTML=Ee,L=r(),Q=c("img"),Se=r(),Ze=c("small"),Ze.innerHTML=Zs,He=r(),Ae=c("p"),Ae.innerHTML=As,Ye=r(),w(se.$$.fragment),Re=r(),he=c("ul"),he.innerHTML=ps,ue=r(),w(we.$$.fragment),$e=r(),ke=c("p"),ke.innerHTML=as,ms=r(),K=c("p"),K.innerHTML=Js,V=r(),ge=c("p"),ge.innerHTML=os,Qe=r(),S=c("ol"),S.innerHTML=ls,Le=r(),Be=c("p"),Be.textContent=$s,Pe=r(),qe=c("table"),qe.innerHTML=Bs,le=r(),w(te.$$.fragment),Us=r(),Ie=c("p"),Ie.innerHTML=rs,ys=r(),X=c("p"),X.innerHTML=is,We=r(),be=c("p"),be.innerHTML=hs,us=r(),x=c("p"),x.innerHTML=ds,ze=r(),je=c("ul"),je.innerHTML=gs,fs=r(),R=c("p"),R.innerHTML=Ms,_s=r(),re=c("p"),re.innerHTML=Gs,ws=r(),w(H.$$.fragment),De=r(),Oe=c("p"),Oe.innerHTML=Ne,vs=r(),Ke=c("p"),Ke.textContent=fe,bs=r(),w(N.$$.fragment),Ge=r(),w(_.$$.fragment),B=r(),w(ne.$$.fragment),Me=r(),Y=c("p"),Y.innerHTML=Te,O=r(),w(D.$$.fragment),M=r(),A=c("ul"),A.innerHTML=cs,ye=r(),w(Je.$$.fragment),_e=r(),ie=c("div"),w(ae.$$.fragment),es=r(),qs=c("p"),qs.innerHTML=dt,Ns=r(),w(ks.$$.fragment),Vs=r(),ss=c("div"),w(Xs.$$.fragment),Tt=r(),Os=c("p"),Os.innerHTML=At,yt=r(),Ks=c("p"),Ks.innerHTML=$t,_t=r(),et=c("p"),et.innerHTML=Bt,wt=r(),w(xs.$$.fragment),ht=r(),w(Es.$$.fragment),ut=r(),de=c("div"),w(Ss.$$.fragment),bt=r(),st=c("p"),st.textContent=qt,jt=r(),tt=c("p"),tt.innerHTML=Wt,Jt=r(),nt=c("ul"),nt.innerHTML=zt,Ut=r(),at=c("p"),at.innerHTML=Gt,vt=r(),Rs=c("div"),w(Hs.$$.fragment),kt=r(),ot=c("p"),ot.textContent=xt,It=r(),Is=c("div"),w(Ys.$$.fragment),Ct=r(),lt=c("p"),lt.innerHTML=Rt,Ft=r(),rt=c("p"),rt.innerHTML=Qt,Zt=r(),it=c("div"),w(Ls.$$.fragment),gt=r(),w(Qs.$$.fragment),ft=r(),ct=c("p"),this.h()},l(t){const T=Ht("svelte-u9bgzb",document.head);e=p(T,"META",{name:!0,content:!0}),T.forEach(o),d=i(t),s=p(t,"P",{}),ee(s).forEach(o),n=i(t),b(m.$$.fragment,t),a=i(t),b(u.$$.fragment,t),W=i(t),y=p(t,"P",{"data-svelte-h":!0}),f(y)!=="svelte-am6ou9"&&(y.innerHTML=F),I=i(t),Z=p(t,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1snuwkh"&&(Z.textContent=z),G=i(t),g=p(t,"UL",{"data-svelte-h":!0}),f(g)!=="svelte-1aokkv"&&(g.innerHTML=$),k=i(t),q=p(t,"P",{"data-svelte-h":!0}),f(q)!=="svelte-1pk4od4"&&(q.textContent=ts),Ve=i(t),Ce=p(t,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-vfdo9a"&&(Ce.textContent=Fs),Fe=i(t),pe=p(t,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1oi615j"&&(pe.innerHTML=Xe),ve=i(t),me=p(t,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1fjg7gp"&&(me.innerHTML=Ee),L=i(t),Q=p(t,"IMG",{src:!0,alt:!0,width:!0}),Se=i(t),Ze=p(t,"SMALL",{"data-svelte-h":!0}),f(Ze)!=="svelte-1fxzkn1"&&(Ze.innerHTML=Zs),He=i(t),Ae=p(t,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-1kjfplh"&&(Ae.innerHTML=As),Ye=i(t),b(se.$$.fragment,t),Re=i(t),he=p(t,"UL",{"data-svelte-h":!0}),f(he)!=="svelte-ii3zt1"&&(he.innerHTML=ps),ue=i(t),b(we.$$.fragment,t),$e=i(t),ke=p(t,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1skpl2o"&&(ke.innerHTML=as),ms=i(t),K=p(t,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1u8kyba"&&(K.innerHTML=Js),V=i(t),ge=p(t,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-16mwtm6"&&(ge.innerHTML=os),Qe=i(t),S=p(t,"OL",{"data-svelte-h":!0}),f(S)!=="svelte-tuiuxn"&&(S.innerHTML=ls),Le=i(t),Be=p(t,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-qp6rba"&&(Be.textContent=$s),Pe=i(t),qe=p(t,"TABLE",{"data-svelte-h":!0}),f(qe)!=="svelte-b5t657"&&(qe.innerHTML=Bs),le=i(t),b(te.$$.fragment,t),Us=i(t),Ie=p(t,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1lvt4t7"&&(Ie.innerHTML=rs),ys=i(t),X=p(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-11t6wp"&&(X.innerHTML=is),We=i(t),be=p(t,"P",{"data-svelte-h":!0}),f(be)!=="svelte-pu8jy3"&&(be.innerHTML=hs),us=i(t),x=p(t,"P",{"data-svelte-h":!0}),f(x)!=="svelte-1nqdyw2"&&(x.innerHTML=ds),ze=i(t),je=p(t,"UL",{"data-svelte-h":!0}),f(je)!=="svelte-1togvt3"&&(je.innerHTML=gs),fs=i(t),R=p(t,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1e5s2fl"&&(R.innerHTML=Ms),_s=i(t),re=p(t,"P",{"data-svelte-h":!0}),f(re)!=="svelte-1gz8ozq"&&(re.innerHTML=Gs),ws=i(t),b(H.$$.fragment,t),De=i(t),Oe=p(t,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-1z1td3"&&(Oe.innerHTML=Ne),vs=i(t),Ke=p(t,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-t321cw"&&(Ke.textContent=fe),bs=i(t),b(N.$$.fragment,t),Ge=i(t),b(_.$$.fragment,t),B=i(t),b(ne.$$.fragment,t),Me=i(t),Y=p(t,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-6imxw1"&&(Y.innerHTML=Te),O=i(t),b(D.$$.fragment,t),M=i(t),A=p(t,"UL",{"data-svelte-h":!0}),f(A)!=="svelte-1cf57f1"&&(A.innerHTML=cs),ye=i(t),b(Je.$$.fragment,t),_e=i(t),ie=p(t,"DIV",{class:!0});var Ps=ee(ie);b(ae.$$.fragment,Ps),es=i(Ps),qs=p(Ps,"P",{"data-svelte-h":!0}),f(qs)!=="svelte-tge4n5"&&(qs.innerHTML=dt),Ps.forEach(o),Ns=i(t),b(ks.$$.fragment,t),Vs=i(t),ss=p(t,"DIV",{class:!0});var Ts=ee(ss);b(Xs.$$.fragment,Ts),Tt=i(Ts),Os=p(Ts,"P",{"data-svelte-h":!0}),f(Os)!=="svelte-bfm69h"&&(Os.innerHTML=At),yt=i(Ts),Ks=p(Ts,"P",{"data-svelte-h":!0}),f(Ks)!=="svelte-der8qk"&&(Ks.innerHTML=$t),_t=i(Ts),et=p(Ts,"P",{"data-svelte-h":!0}),f(et)!=="svelte-n4fsha"&&(et.innerHTML=Bt),wt=i(Ts),b(xs.$$.fragment,Ts),Ts.forEach(o),ht=i(t),b(Es.$$.fragment,t),ut=i(t),de=p(t,"DIV",{class:!0});var Ue=ee(de);b(Ss.$$.fragment,Ue),bt=i(Ue),st=p(Ue,"P",{"data-svelte-h":!0}),f(st)!=="svelte-1hmtb4d"&&(st.textContent=qt),jt=i(Ue),tt=p(Ue,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-3oary5"&&(tt.innerHTML=Wt),Jt=i(Ue),nt=p(Ue,"UL",{"data-svelte-h":!0}),f(nt)!=="svelte-hp7g7u"&&(nt.innerHTML=zt),Ut=i(Ue),at=p(Ue,"P",{"data-svelte-h":!0}),f(at)!=="svelte-11m25dt"&&(at.innerHTML=Gt),vt=i(Ue),Rs=p(Ue,"DIV",{class:!0});var Ds=ee(Rs);b(Hs.$$.fragment,Ds),kt=i(Ds),ot=p(Ds,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-1j6vv4o"&&(ot.textContent=xt),Ds.forEach(o),It=i(Ue),Is=p(Ue,"DIV",{class:!0});var Ws=ee(Is);b(Ys.$$.fragment,Ws),Ct=i(Ws),lt=p(Ws,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-1x1ledq"&&(lt.innerHTML=Rt),Ft=i(Ws),rt=p(Ws,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-1yeewnh"&&(rt.innerHTML=Qt),Ws.forEach(o),Zt=i(Ue),it=p(Ue,"DIV",{class:!0});var pt=ee(it);b(Ls.$$.fragment,pt),pt.forEach(o),Ue.forEach(o),gt=i(t),b(Qs.$$.fragment,t),ft=i(t),ct=p(t,"P",{}),ee(ct).forEach(o),this.h()},h(){P(e,"name","hf:doc:metadata"),P(e,"content",zn),Vt(Q.src,ns="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tapas_architecture.png")||P(Q,"src",ns),P(Q,"alt","drawing"),P(Q,"width","600"),P(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(Rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,T){h(document.head,e),l(t,d,T),l(t,s,T),l(t,n,T),j(m,t,T),l(t,a,T),j(u,t,T),l(t,W,T),l(t,y,T),l(t,I,T),l(t,Z,T),l(t,G,T),l(t,g,T),l(t,k,T),l(t,q,T),l(t,Ve,T),l(t,Ce,T),l(t,Fe,T),l(t,pe,T),l(t,ve,T),l(t,me,T),l(t,L,T),l(t,Q,T),l(t,Se,T),l(t,Ze,T),l(t,He,T),l(t,Ae,T),l(t,Ye,T),j(se,t,T),l(t,Re,T),l(t,he,T),l(t,ue,T),j(we,t,T),l(t,$e,T),l(t,ke,T),l(t,ms,T),l(t,K,T),l(t,V,T),l(t,ge,T),l(t,Qe,T),l(t,S,T),l(t,Le,T),l(t,Be,T),l(t,Pe,T),l(t,qe,T),l(t,le,T),j(te,t,T),l(t,Us,T),l(t,Ie,T),l(t,ys,T),l(t,X,T),l(t,We,T),l(t,be,T),l(t,us,T),l(t,x,T),l(t,ze,T),l(t,je,T),l(t,fs,T),l(t,R,T),l(t,_s,T),l(t,re,T),l(t,ws,T),j(H,t,T),l(t,De,T),l(t,Oe,T),l(t,vs,T),l(t,Ke,T),l(t,bs,T),j(N,t,T),l(t,Ge,T),j(_,t,T),l(t,B,T),j(ne,t,T),l(t,Me,T),l(t,Y,T),l(t,O,T),j(D,t,T),l(t,M,T),l(t,A,T),l(t,ye,T),j(Je,t,T),l(t,_e,T),l(t,ie,T),j(ae,ie,null),h(ie,es),h(ie,qs),l(t,Ns,T),j(ks,t,T),l(t,Vs,T),l(t,ss,T),j(Xs,ss,null),h(ss,Tt),h(ss,Os),h(ss,yt),h(ss,Ks),h(ss,_t),h(ss,et),h(ss,wt),j(xs,ss,null),l(t,ht,T),j(Es,t,T),l(t,ut,T),l(t,de,T),j(Ss,de,null),h(de,bt),h(de,st),h(de,jt),h(de,tt),h(de,Jt),h(de,nt),h(de,Ut),h(de,at),h(de,vt),h(de,Rs),j(Hs,Rs,null),h(Rs,kt),h(Rs,ot),h(de,It),h(de,Is),j(Ys,Is,null),h(Is,Ct),h(Is,lt),h(Is,Ft),h(Is,rt),h(de,Zt),h(de,it),j(Ls,it,null),l(t,gt,T),j(Qs,t,T),l(t,ft,T),l(t,ct,T),Mt=!0},p(t,[T]){const Ps={};T&2&&(Ps.$$scope={dirty:T,ctx:t}),te.$set(Ps);const Ts={};T&2&&(Ts.$$scope={dirty:T,ctx:t}),H.$set(Ts);const Ue={};T&2&&(Ue.$$scope={dirty:T,ctx:t}),N.$set(Ue);const Ds={};T&2&&(Ds.$$scope={dirty:T,ctx:t}),ne.$set(Ds);const Ws={};T&2&&(Ws.$$scope={dirty:T,ctx:t}),xs.$set(Ws);const pt={};T&2&&(pt.$$scope={dirty:T,ctx:t}),Qs.$set(pt)},i(t){Mt||(J(m.$$.fragment,t),J(u.$$.fragment,t),J(se.$$.fragment,t),J(we.$$.fragment,t),J(te.$$.fragment,t),J(H.$$.fragment,t),J(N.$$.fragment,t),J(_.$$.fragment,t),J(ne.$$.fragment,t),J(D.$$.fragment,t),J(Je.$$.fragment,t),J(ae.$$.fragment,t),J(ks.$$.fragment,t),J(Xs.$$.fragment,t),J(xs.$$.fragment,t),J(Es.$$.fragment,t),J(Ss.$$.fragment,t),J(Hs.$$.fragment,t),J(Ys.$$.fragment,t),J(Ls.$$.fragment,t),J(Qs.$$.fragment,t),Mt=!0)},o(t){U(m.$$.fragment,t),U(u.$$.fragment,t),U(se.$$.fragment,t),U(we.$$.fragment,t),U(te.$$.fragment,t),U(H.$$.fragment,t),U(N.$$.fragment,t),U(_.$$.fragment,t),U(ne.$$.fragment,t),U(D.$$.fragment,t),U(Je.$$.fragment,t),U(ae.$$.fragment,t),U(ks.$$.fragment,t),U(Xs.$$.fragment,t),U(xs.$$.fragment,t),U(Es.$$.fragment,t),U(Ss.$$.fragment,t),U(Hs.$$.fragment,t),U(Ys.$$.fragment,t),U(Ls.$$.fragment,t),U(Qs.$$.fragment,t),Mt=!1},d(t){t&&(o(d),o(s),o(n),o(a),o(W),o(y),o(I),o(Z),o(G),o(g),o(k),o(q),o(Ve),o(Ce),o(Fe),o(pe),o(ve),o(me),o(L),o(Q),o(Se),o(Ze),o(He),o(Ae),o(Ye),o(Re),o(he),o(ue),o($e),o(ke),o(ms),o(K),o(V),o(ge),o(Qe),o(S),o(Le),o(Be),o(Pe),o(qe),o(le),o(Us),o(Ie),o(ys),o(X),o(We),o(be),o(us),o(x),o(ze),o(je),o(fs),o(R),o(_s),o(re),o(ws),o(De),o(Oe),o(vs),o(Ke),o(bs),o(Ge),o(B),o(Me),o(Y),o(O),o(M),o(A),o(ye),o(_e),o(ie),o(Ns),o(Vs),o(ss),o(ht),o(ut),o(de),o(gt),o(ft),o(ct)),o(e),v(m,t),v(u,t),v(se,t),v(we,t),v(te,t),v(H,t),v(N,t),v(_,t),v(ne,t),v(D,t),v(Je,t),v(ae),v(ks,t),v(Xs),v(xs),v(Es,t),v(Ss),v(Hs),v(Ys),v(Ls),v(Qs,t)}}}const zn='{"title":"TAPAS","local":"tapas","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage: fine-tuning","local":"usage-fine-tuning","sections":[],"depth":2},{"title":"Usage: inference","local":"usage-inference","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"TAPAS specific outputs","local":"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput","sections":[],"depth":2},{"title":"TapasConfig","local":"transformers.TapasConfig","sections":[],"depth":2},{"title":"TapasTokenizer","local":"transformers.TapasTokenizer","sections":[],"depth":2},{"title":"TapasModel","local":"transformers.TapasModel","sections":[],"depth":2},{"title":"TapasForMaskedLM","local":"transformers.TapasForMaskedLM","sections":[],"depth":2},{"title":"TapasForSequenceClassification","local":"transformers.TapasForSequenceClassification","sections":[],"depth":2},{"title":"TapasForQuestionAnswering","local":"transformers.TapasForQuestionAnswering","sections":[],"depth":2},{"title":"TFTapasModel","local":"transformers.TFTapasModel","sections":[],"depth":2},{"title":"TFTapasForMaskedLM","local":"transformers.TFTapasForMaskedLM","sections":[],"depth":2},{"title":"TFTapasForSequenceClassification","local":"transformers.TFTapasForSequenceClassification","sections":[],"depth":2},{"title":"TFTapasForQuestionAnswering","local":"transformers.TFTapasForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function Gn(C){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hn extends Et{constructor(e){super(),St(this,e,Gn,Wn,Nt,{})}}export{Hn as component};
