import{s as He,n as Xe,o as Le}from"../chunks/scheduler.9bc65507.js";import{S as ke,i as Ae,g as r,s as l,r as X,A as Je,h as s,f as n,c as a,j as Ue,u as L,x as o,k as Ie,y as ze,a as i,v as k,d as A,t as J,w as z}from"../chunks/index.707bf1b6.js";import{C as Ee}from"../chunks/CodeBlock.54a9f38d.js";import{H as j}from"../chunks/Heading.342b1fa6.js";function Re(de){let p,V,R,S,c,Y,u,fe="This guide focuses on training large models efficiently on CPU.",G,d,W,f,me="Mixed precision uses single (fp32) and half-precision (bf16/fp16) data types in a model to accelerate training or inference while still preserving much of the single-precision accuracy. Modern CPUs such as 3rd and 4th Gen Intel® Xeon® Scalable processors natively support bf16, so you should get more performance out of the box by enabling mixed precision training with bf16.",q,m,he="To further maximize training performance, you can use Intel® Extension for PyTorch (IPEX), which is a library built on PyTorch and adds additional CPU instruction level architecture (ISA) level support such as Intel® Advanced Vector Extensions 512 Vector Neural Network Instructions (Intel® AVX512-VNNI), and Intel® Advanced Matrix Extensions (Intel® AMX) for an extra performance boost on Intel CPUs. However, CPUs with only AVX2 (e.g., AMD or older Intel CPUs) are not guaranteed to have better performance under IPEX.",F,h,xe="Auto Mixed Precision (AMP) for CPU backends has been enabled since PyTorch 1.10. AMP support for bf16 on CPUs and bf16 operator optimization is also supported in IPEX and partially upstreamed to the main PyTorch branch. You can get better performance and user experience with IPEX AMP.",N,x,ge='Check more detailed information for <a href="https://intel.github.io/intel-extension-for-pytorch/cpu/latest/tutorials/features/amp.html" rel="nofollow">Auto Mixed Precision</a>.',Z,g,Q,_,_e="IPEX release is following PyTorch, to install via pip:",D,M,Me='<thead><tr><th align="center">PyTorch Version</th> <th align="center">IPEX version</th></tr></thead> <tbody><tr><td align="center">2.1.x</td> <td align="center">2.1.100+cpu</td></tr> <tr><td align="center">2.0.x</td> <td align="center">2.0.100+cpu</td></tr> <tr><td align="center">1.13</td> <td align="center">1.13.0+cpu</td></tr> <tr><td align="center">1.12</td> <td align="center">1.12.300+cpu</td></tr></tbody>',K,T,Te="Please run <code>pip list | grep torch</code> to get your <code>pytorch_version</code>, so you can get the <code>IPEX version_name</code>.",O,b,ee,C,be='You can check the latest versions in <a href="https://developer.intel.com/ipex-whl-stable-cpu" rel="nofollow">ipex-whl-stable-cpu</a> if needed.',te,P,Ce='Check more approaches for <a href="https://intel.github.io/intel-extension-for-pytorch/cpu/latest/tutorials/installation.html" rel="nofollow">IPEX installation</a>.',ne,$,ie,v,Pe="To enable auto mixed precision with IPEX in Trainer, users should add <code>use_ipex</code>, <code>bf16</code> and <code>no_cuda</code> in training command arguments.",le,w,$e='Take an example of the use cases on <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/question-answering" rel="nofollow">Transformers question-answering</a>',ae,y,ve=`<li>Training with IPEX using BF16 auto mixed precision on CPU:<pre> python run_qa.py \\
--model_name_or_path google-bert/bert-base-uncased \\
--dataset_name squad \\
--do_train \\
--do_eval \\
--per_device_train_batch_size 12 \\
--learning_rate 3e-5 \\
--num_train_epochs 2 \\
--max_seq_length 384 \\
--doc_stride 128 \\
--output_dir /tmp/debug_squad/ \\
<b>--use_ipex</b> \\
<b>--bf16</b> \\
<b>--use_cpu</b></pre></li>`,re,U,we="If you want to enable <code>use_ipex</code> and <code>bf16</code> in your script, add these parameters to <code>TrainingArguments</code> like this:",se,I,oe,E,pe,H,ye='Blog: <a href="https://huggingface.co/blog/intel-sapphire-rapids" rel="nofollow">Accelerating PyTorch Transformers with Intel Sapphire Rapids</a>',ce,B,ue;return c=new j({props:{title:"Efficient Training on CPU",local:"efficient-training-on-cpu",headingTag:"h1"}}),d=new j({props:{title:"Mixed precision with IPEX",local:"mixed-precision-with-ipex",headingTag:"h2"}}),g=new j({props:{title:"IPEX installation:",local:"ipex-installation",headingTag:"h3"}}),b=new Ee({props:{code:"cGlwJTIwaW5zdGFsbCUyMGludGVsX2V4dGVuc2lvbl9mb3JfcHl0b3JjaCUzRCUzRCUzQ3ZlcnNpb25fbmFtZSUzRSUyMC1mJTIwaHR0cHMlM0ElMkYlMkZkZXZlbG9wZXIuaW50ZWwuY29tJTJGaXBleC13aGwtc3RhYmxlLWNwdQ==",highlighted:"pip install intel_extension_for_pytorch==&lt;version_name&gt; -f https://developer.intel.com/ipex-whl-stable-cpu",wrap:!1}}),$=new j({props:{title:"Usage in Trainer",local:"usage-in-trainer",headingTag:"h3"}}),I=new Ee({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RhcmdzLm91dHB1dF9wYXRoJTJDJTBBJTJCJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjB1c2VfaXBleCUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjB1c2VfY3B1JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCoqa3dhcmdzJTBBKQ==",highlighted:`training_args = TrainingArguments(
    output_dir=args.output_path,
<span class="hljs-addition">+   bf16=True,</span>
<span class="hljs-addition">+   use_ipex=True,</span>
<span class="hljs-addition">+   use_cpu=True,</span>
    **kwargs
)`,wrap:!1}}),E=new j({props:{title:"Practice example",local:"practice-example",headingTag:"h3"}}),{c(){p=r("meta"),V=l(),R=r("p"),S=l(),X(c.$$.fragment),Y=l(),u=r("p"),u.textContent=fe,G=l(),X(d.$$.fragment),W=l(),f=r("p"),f.textContent=me,q=l(),m=r("p"),m.textContent=he,F=l(),h=r("p"),h.textContent=xe,N=l(),x=r("p"),x.innerHTML=ge,Z=l(),X(g.$$.fragment),Q=l(),_=r("p"),_.textContent=_e,D=l(),M=r("table"),M.innerHTML=Me,K=l(),T=r("p"),T.innerHTML=Te,O=l(),X(b.$$.fragment),ee=l(),C=r("p"),C.innerHTML=be,te=l(),P=r("p"),P.innerHTML=Ce,ne=l(),X($.$$.fragment),ie=l(),v=r("p"),v.innerHTML=Pe,le=l(),w=r("p"),w.innerHTML=$e,ae=l(),y=r("ul"),y.innerHTML=ve,re=l(),U=r("p"),U.innerHTML=we,se=l(),X(I.$$.fragment),oe=l(),X(E.$$.fragment),pe=l(),H=r("p"),H.innerHTML=ye,ce=l(),B=r("p"),this.h()},l(e){const t=Je("svelte-u9bgzb",document.head);p=s(t,"META",{name:!0,content:!0}),t.forEach(n),V=a(e),R=s(e,"P",{}),Ue(R).forEach(n),S=a(e),L(c.$$.fragment,e),Y=a(e),u=s(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-16zn87f"&&(u.textContent=fe),G=a(e),L(d.$$.fragment,e),W=a(e),f=s(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1t5d7gz"&&(f.textContent=me),q=a(e),m=s(e,"P",{"data-svelte-h":!0}),o(m)!=="svelte-7ixgfk"&&(m.textContent=he),F=a(e),h=s(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1aa4rsn"&&(h.textContent=xe),N=a(e),x=s(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1orckb5"&&(x.innerHTML=ge),Z=a(e),L(g.$$.fragment,e),Q=a(e),_=s(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-yt7jgu"&&(_.textContent=_e),D=a(e),M=s(e,"TABLE",{"data-svelte-h":!0}),o(M)!=="svelte-63v1d5"&&(M.innerHTML=Me),K=a(e),T=s(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-op7gjt"&&(T.innerHTML=Te),O=a(e),L(b.$$.fragment,e),ee=a(e),C=s(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-6sdt3v"&&(C.innerHTML=be),te=a(e),P=s(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-6x6sx"&&(P.innerHTML=Ce),ne=a(e),L($.$$.fragment,e),ie=a(e),v=s(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-550t3u"&&(v.innerHTML=Pe),le=a(e),w=s(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1t7mun5"&&(w.innerHTML=$e),ae=a(e),y=s(e,"UL",{"data-svelte-h":!0}),o(y)!=="svelte-1p4s7xp"&&(y.innerHTML=ve),re=a(e),U=s(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-w7vrf2"&&(U.innerHTML=we),se=a(e),L(I.$$.fragment,e),oe=a(e),L(E.$$.fragment,e),pe=a(e),H=s(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-w7zs5j"&&(H.innerHTML=ye),ce=a(e),B=s(e,"P",{}),Ue(B).forEach(n),this.h()},h(){Ie(p,"name","hf:doc:metadata"),Ie(p,"content",Be)},m(e,t){ze(document.head,p),i(e,V,t),i(e,R,t),i(e,S,t),k(c,e,t),i(e,Y,t),i(e,u,t),i(e,G,t),k(d,e,t),i(e,W,t),i(e,f,t),i(e,q,t),i(e,m,t),i(e,F,t),i(e,h,t),i(e,N,t),i(e,x,t),i(e,Z,t),k(g,e,t),i(e,Q,t),i(e,_,t),i(e,D,t),i(e,M,t),i(e,K,t),i(e,T,t),i(e,O,t),k(b,e,t),i(e,ee,t),i(e,C,t),i(e,te,t),i(e,P,t),i(e,ne,t),k($,e,t),i(e,ie,t),i(e,v,t),i(e,le,t),i(e,w,t),i(e,ae,t),i(e,y,t),i(e,re,t),i(e,U,t),i(e,se,t),k(I,e,t),i(e,oe,t),k(E,e,t),i(e,pe,t),i(e,H,t),i(e,ce,t),i(e,B,t),ue=!0},p:Xe,i(e){ue||(A(c.$$.fragment,e),A(d.$$.fragment,e),A(g.$$.fragment,e),A(b.$$.fragment,e),A($.$$.fragment,e),A(I.$$.fragment,e),A(E.$$.fragment,e),ue=!0)},o(e){J(c.$$.fragment,e),J(d.$$.fragment,e),J(g.$$.fragment,e),J(b.$$.fragment,e),J($.$$.fragment,e),J(I.$$.fragment,e),J(E.$$.fragment,e),ue=!1},d(e){e&&(n(V),n(R),n(S),n(Y),n(u),n(G),n(W),n(f),n(q),n(m),n(F),n(h),n(N),n(x),n(Z),n(Q),n(_),n(D),n(M),n(K),n(T),n(O),n(ee),n(C),n(te),n(P),n(ne),n(ie),n(v),n(le),n(w),n(ae),n(y),n(re),n(U),n(se),n(oe),n(pe),n(H),n(ce),n(B)),n(p),z(c,e),z(d,e),z(g,e),z(b,e),z($,e),z(I,e),z(E,e)}}}const Be='{"title":"Efficient Training on CPU","local":"efficient-training-on-cpu","sections":[{"title":"Mixed precision with IPEX","local":"mixed-precision-with-ipex","sections":[{"title":"IPEX installation:","local":"ipex-installation","sections":[],"depth":3},{"title":"Usage in Trainer","local":"usage-in-trainer","sections":[],"depth":3},{"title":"Practice example","local":"practice-example","sections":[],"depth":3}],"depth":2}],"depth":1}';function je(de){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends ke{constructor(p){super(),Ae(this,p,je,Re,He,{})}}export{We as component};
