import{s as Uo,f as Jo,o as Wo,n as Ue}from"../chunks/scheduler.9bc65507.js";import{S as qo,i as No,g as d,s as a,r as h,A as Zo,h as c,f as o,c as r,j as x,u,x as g,k as M,y as l,a as i,v as f,d as _,t as T,w as b}from"../chunks/index.707bf1b6.js";import{T as so}from"../chunks/Tip.c2ecdbf4.js";import{D as q}from"../chunks/Docstring.17db21ae.js";import{C as Ct}from"../chunks/CodeBlock.54a9f38d.js";import{E as kt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as Ro}from"../chunks/PipelineTag.44585822.js";import{H as R}from"../chunks/Heading.342b1fa6.js";function Bo(w){let n,v="Example:",m,p,y;return p=new Ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEltYWdlR1BUQ29uZmlnJTJDJTIwSW1hZ2VHUFRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBJbWFnZUdQVCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSW1hZ2VHUFRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwSW1hZ2VHUFRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ImageGPTConfig, ImageGPTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ImageGPT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ImageGPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(s),u(p.$$.fragment,s)},m(s,I){i(s,n,I),i(s,m,I),f(p,s,I),y=!0},p:Ue,i(s){y||(_(p.$$.fragment,s),y=!0)},o(s){T(p.$$.fragment,s),y=!1},d(s){s&&(o(n),o(m)),b(p,s)}}}function Lo(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){i(m,n,p)},p:Ue,d(m){m&&o(n)}}}function Vo(w){let n,v="Examples:",m,p,y;return p=new Ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEltYWdlR1BUTW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmltYWdlZ3B0LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwSW1hZ2VHUFRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGaW1hZ2VncHQtc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ImageGPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTModel.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(s),u(p.$$.fragment,s)},m(s,I){i(s,n,I),i(s,m,I),f(p,s,I),y=!0},p:Ue,i(s){y||(_(p.$$.fragment,s),y=!0)},o(s){T(p.$$.fragment,s),y=!1},d(s){s&&(o(n),o(m)),b(p,s)}}}function Ho(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){i(m,n,p)},p:Ue,d(m){m&&o(n)}}}function So(w){let n,v="Examples:",m,p,y;return p=new Ct({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ImageGPTForCausalImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTForCausalImageModeling.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># unconditional generation of 8 images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = torch.full((batch_size, <span class="hljs-number">1</span>), model.config.vocab_size - <span class="hljs-number">1</span>)  <span class="hljs-comment"># initialize with SOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = context.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(
<span class="hljs-meta">... </span>    input_ids=context, max_length=model.config.n_positions + <span class="hljs-number">1</span>, temperature=<span class="hljs-number">1.0</span>, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">40</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>clusters = image_processor.clusters
<span class="hljs-meta">&gt;&gt;&gt; </span>height = image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>width = image_processor.size[<span class="hljs-string">&quot;width&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>samples = output[:, <span class="hljs-number">1</span>:].cpu().detach().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>samples_img = [
<span class="hljs-meta">... </span>    np.reshape(np.rint(<span class="hljs-number">127.5</span> * (clusters[s] + <span class="hljs-number">1.0</span>)), [height, width, <span class="hljs-number">3</span>]).astype(np.uint8) <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> samples
<span class="hljs-meta">... </span>]  <span class="hljs-comment"># convert color cluster tokens back to pixels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>f, axes = plt.subplots(<span class="hljs-number">1</span>, batch_size, dpi=<span class="hljs-number">300</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> img, ax <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(samples_img, axes):
<span class="hljs-meta">... </span>    ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>    ax.imshow(img)`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(s),u(p.$$.fragment,s)},m(s,I){i(s,n,I),i(s,m,I),f(p,s,I),y=!0},p:Ue,i(s){y||(_(p.$$.fragment,s),y=!0)},o(s){T(p.$$.fragment,s),y=!1},d(s){s&&(o(n),o(m)),b(p,s)}}}function Eo(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),g(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){i(m,n,p)},p:Ue,d(m){m&&o(n)}}}function Xo(w){let n,v="Examples:",m,p,y;return p=new Ct({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEltYWdlR1BURm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGaW1hZ2VncHQtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBJbWFnZUdQVEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmltYWdlZ3B0LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ImageGPTForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTForImageClassification.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),g(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(s),u(p.$$.fragment,s)},m(s,I){i(s,n,I),i(s,m,I),f(p,s,I),y=!0},p:Ue,i(s){y||(_(p.$$.fragment,s),y=!0)},o(s){T(p.$$.fragment,s),y=!1},d(s){s&&(o(n),o(m)),b(p,s)}}}function Qo(w){let n,v,m,p,y,s,I,Ke,te,ao=`The ImageGPT model was proposed in <a href="https://openai.com/blog/image-gpt" rel="nofollow">Generative Pretraining from Pixels</a> by Mark
Chen, Alec Radford, Rewon Child, Jeffrey Wu, Heewoo Jun, David Luan, Ilya Sutskever. ImageGPT (iGPT) is a GPT-2-like
model trained to predict the next pixel value, allowing for both unconditional and conditional image generation.`,et,oe,ro="The abstract from the paper is the following:",tt,ne,io=`<em>Inspired by progress in unsupervised representation learning for natural language, we examine whether similar models
can learn useful representations for images. We train a sequence Transformer to auto-regressively predict pixels,
without incorporating knowledge of the 2D input structure. Despite training on low-resolution ImageNet without labels,
we find that a GPT-2 scale model learns strong image representations as measured by linear probing, fine-tuning, and
low-data classification. On CIFAR-10, we achieve 96.3% accuracy with a linear probe, outperforming a supervised Wide
ResNet, and 99.0% accuracy with full fine-tuning, matching the top supervised pre-trained models. We are also
competitive with self-supervised benchmarks on ImageNet when substituting pixels for a VQVAE encoding, achieving 69.0%
top-1 accuracy on a linear probe of our features.</em>`,ot,V,lo,nt,se,co="Summary of the approach. Taken from the [original paper](https://cdn.openai.com/papers/Generative_Pretraining_from_Pixels_V2.pdf).",st,ae,mo=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>, based on <a href="https://github.com/openai/image-gpt/issues/7" rel="nofollow">this issue</a>. The original code can be found
<a href="https://github.com/openai/image-gpt" rel="nofollow">here</a>.`,at,re,rt,ie,po=`<li>ImageGPT is almost exactly the same as <a href="gpt2">GPT-2</a>, with the exception that a different activation
function is used (namely “quick gelu”), and the layer normalization layers don’t mean center the inputs. ImageGPT
also doesn’t have tied input- and output embeddings.</li> <li>As the time- and memory requirements of the attention mechanism of Transformers scales quadratically in the sequence
length, the authors pre-trained ImageGPT on smaller input resolutions, such as 32x32 and 64x64. However, feeding a
sequence of 32x32x3=3072 tokens from 0..255 into a Transformer is still prohibitively large. Therefore, the authors
applied k-means clustering to the (R,G,B) pixel values with k=512. This way, we only have a 32*32 = 1024-long
sequence, but now of integers in the range 0..511. So we are shrinking the sequence length at the cost of a bigger
embedding matrix. In other words, the vocabulary size of ImageGPT is 512, + 1 for a special “start of sentence” (SOS)
token, used at the beginning of every sequence. One can use <a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTImageProcessor">ImageGPTImageProcessor</a> to prepare
images for the model.</li> <li>Despite being pre-trained entirely unsupervised (i.e. without the use of any labels), ImageGPT produces fairly
performant image features useful for downstream tasks, such as image classification. The authors showed that the
features in the middle of the network are the most performant, and can be used as-is to train a linear model (such as
a sklearn logistic regression model for example). This is also referred to as “linear probing”. Features can be
easily obtained by first forwarding the image through the model, then specifying <code>output_hidden_states=True</code>, and
then average-pool the hidden states at whatever layer you like.</li> <li>Alternatively, one can further fine-tune the entire model on a downstream dataset, similar to BERT. For this, you can
use <a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a>.</li> <li>ImageGPT comes in different sizes: there’s ImageGPT-small, ImageGPT-medium and ImageGPT-large. The authors did also
train an XL variant, which they didn’t release. The differences in size are summarized in the following table:</li>`,it,le,go="<thead><tr><th><strong>Model variant</strong></th> <th><strong>Depths</strong></th> <th><strong>Hidden sizes</strong></th> <th><strong>Decoder hidden size</strong></th> <th><strong>Params (M)</strong></th> <th><strong>ImageNet-1k Top 1</strong></th></tr></thead> <tbody><tr><td>MiT-b0</td> <td>[2, 2, 2, 2]</td> <td>[32, 64, 160, 256]</td> <td>256</td> <td>3.7</td> <td>70.5</td></tr> <tr><td>MiT-b1</td> <td>[2, 2, 2, 2]</td> <td>[64, 128, 320, 512]</td> <td>256</td> <td>14.0</td> <td>78.7</td></tr> <tr><td>MiT-b2</td> <td>[3, 4, 6, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>25.4</td> <td>81.6</td></tr> <tr><td>MiT-b3</td> <td>[3, 4, 18, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>45.2</td> <td>83.1</td></tr> <tr><td>MiT-b4</td> <td>[3, 8, 27, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>62.6</td> <td>83.6</td></tr> <tr><td>MiT-b5</td> <td>[3, 6, 40, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>82.0</td> <td>83.8</td></tr></tbody>",lt,de,dt,ce,ho="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ImageGPT.",ct,me,mt,pe,uo='<li>Demo notebooks for ImageGPT can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/ImageGPT" rel="nofollow">here</a>.</li> <li><a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',pt,ge,fo="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",gt,he,ht,C,ue,Gt,Je,_o=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> or a <code>TFImageGPTModel</code>. It is
used to instantiate a GPT-2 model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the ImageGPT
<a href="https://huggingface.co/openai/imagegpt-small" rel="nofollow">openai/imagegpt-small</a> architecture.`,xt,We,To=`Configuration objects inherit from <a href="/docs/transformers/v4.39.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.39.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,zt,H,ut,fe,ft,B,_e,jt,S,Te,Ft,qe,bo="Preprocess an image or a batch of images.",_t,be,Tt,U,ye,Ut,Ne,yo=`Constructs a ImageGPT image processor. This image processor can be used to resize images to a smaller resolution
(such as 32x32 or 64x64), normalize them and finally color quantize them to obtain sequences of “pixel values”
(color clusters).`,Jt,E,ve,Wt,Ze,vo="Preprocess an image or batch of images.",bt,Ie,yt,P,we,qt,Re,Io="The bare ImageGPT Model transformer outputting raw hidden-states without any specific head on top.",Nt,Be,wo=`This model inherits from <a href="/docs/transformers/v4.39.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Zt,Le,Mo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,z,Me,Bt,Ve,Po='The <a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> forward method, overrides the <code>__call__</code> special method.',Lt,X,Vt,Q,vt,Pe,It,$,$e,Ht,He,$o=`The ImageGPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,St,Se,ko=`This model inherits from <a href="/docs/transformers/v4.39.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Et,Ee,Co=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Xt,j,ke,Qt,Xe,Go='The <a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTForCausalImageModeling">ImageGPTForCausalImageModeling</a> forward method, overrides the <code>__call__</code> special method.',At,A,Dt,D,wt,Ce,Mt,k,Ge,Ot,Qe,xo=`The ImageGPT Model transformer with an image classification head on top (linear layer).
<a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> average-pools the hidden states in order to do the classification.`,Yt,Ae,zo=`This model inherits from <a href="/docs/transformers/v4.39.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Kt,De,jo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,eo,F,xe,to,Oe,Fo='The <a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',oo,O,no,Y,Pt,Ye,$t;return y=new R({props:{title:"ImageGPT",local:"imagegpt",headingTag:"h1"}}),I=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),re=new R({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),de=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),me=new Ro({props:{pipeline:"image-classification"}}),he=new R({props:{title:"ImageGPTConfig",local:"transformers.ImageGPTConfig",headingTag:"h2"}}),ue=new q({props:{name:"class transformers.ImageGPTConfig",anchor:"transformers.ImageGPTConfig",parameters:[{name:"vocab_size",val:" = 513"},{name:"n_positions",val:" = 1024"},{name:"n_embd",val:" = 512"},{name:"n_layer",val:" = 24"},{name:"n_head",val:" = 8"},{name:"n_inner",val:" = None"},{name:"activation_function",val:" = 'quick_gelu'"},{name:"resid_pdrop",val:" = 0.1"},{name:"embd_pdrop",val:" = 0.1"},{name:"attn_pdrop",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"initializer_range",val:" = 0.02"},{name:"scale_attn_weights",val:" = True"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"scale_attn_by_inverse_layer_idx",val:" = False"},{name:"reorder_and_upcast_attn",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageGPTConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Vocabulary size of the GPT-2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> or <code>TFImageGPTModel</code>.`,name:"vocab_size"},{anchor:"transformers.ImageGPTConfig.n_positions",description:`<strong>n_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 32*32) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"n_positions"},{anchor:"transformers.ImageGPTConfig.n_embd",description:`<strong>n_embd</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"n_embd"},{anchor:"transformers.ImageGPTConfig.n_layer",description:`<strong>n_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layer"},{anchor:"transformers.ImageGPTConfig.n_head",description:`<strong>n_head</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_head"},{anchor:"transformers.ImageGPTConfig.n_inner",description:`<strong>n_inner</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
Dimensionality of the inner feed-forward layers. <code>None</code> will set it to 4 times n_embd`,name:"n_inner"},{anchor:"transformers.ImageGPTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
Activation function (can be one of the activation functions defined in src/transformers/activations.py).
Defaults to &#x201C;quick_gelu&#x201D;.`,name:"activation_function"},{anchor:"transformers.ImageGPTConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"resid_pdrop"},{anchor:"transformers.ImageGPTConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.ImageGPTConfig.attn_pdrop",description:`<strong>attn_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention.`,name:"attn_pdrop"},{anchor:"transformers.ImageGPTConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.ImageGPTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ImageGPTConfig.scale_attn_weights",description:`<strong>scale_attn_weights</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Scale attention weights by dividing by sqrt(hidden_size)..`,name:"scale_attn_weights"},{anchor:"transformers.ImageGPTConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.ImageGPTConfig.scale_attn_by_inverse_layer_idx",description:`<strong>scale_attn_by_inverse_layer_idx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to additionally scale attention weights by <code>1 / layer_idx + 1</code>.`,name:"scale_attn_by_inverse_layer_idx"},{anchor:"transformers.ImageGPTConfig.reorder_and_upcast_attn",description:`<strong>reorder_and_upcast_attn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to scale keys (K) prior to computing attention (dot-product) and upcast attention
dot-product/softmax to float() when training with mixed precision.`,name:"reorder_and_upcast_attn"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/configuration_imagegpt.py#L37"}}),H=new kt({props:{anchor:"transformers.ImageGPTConfig.example",$$slots:{default:[Bo]},$$scope:{ctx:w}}}),fe=new R({props:{title:"ImageGPTFeatureExtractor",local:"transformers.ImageGPTFeatureExtractor",headingTag:"h2"}}),_e=new q({props:{name:"class transformers.ImageGPTFeatureExtractor",anchor:"transformers.ImageGPTFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/feature_extraction_imagegpt.py#L26"}}),Te=new q({props:{name:"__call__",anchor:"transformers.ImageGPTFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/image_processing_utils.py#L549"}}),be=new R({props:{title:"ImageGPTImageProcessor",local:"transformers.ImageGPTImageProcessor",headingTag:"h2"}}),ye=new q({props:{name:"class transformers.ImageGPTImageProcessor",anchor:"transformers.ImageGPTImageProcessor",parameters:[{name:"clusters",val:": Union = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_normalize",val:": bool = True"},{name:"do_color_quantize",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageGPTImageProcessor.clusters",description:`<strong>clusters</strong> (<code>np.ndarray</code> or <code>List[List[int]]</code>, <em>optional</em>) &#x2014;
The color clusters to use, of shape <code>(n_clusters, 3)</code> when color quantizing. Can be overriden by <code>clusters</code>
in <code>preprocess</code>.`,name:"clusters"},{anchor:"transformers.ImageGPTImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s dimensions to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by
<code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.ImageGPTImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the image after resizing. Can be overridden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.ImageGPTImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.ImageGPTImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image pixel value to between [-1, 1]. Can be overridden by <code>do_normalize</code> in
<code>preprocess</code>.`,name:"do_normalize"},{anchor:"transformers.ImageGPTImageProcessor.do_color_quantize",description:`<strong>do_color_quantize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to color quantize the image. Can be overridden by <code>do_color_quantize</code> in <code>preprocess</code>.`,name:"do_color_quantize"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/image_processing_imagegpt.py#L60"}}),ve=new q({props:{name:"preprocess",anchor:"transformers.ImageGPTImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_normalize",val:": bool = None"},{name:"do_color_quantize",val:": Optional = None"},{name:"clusters",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageGPTImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_normalize=False</code>.`,name:"images"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image`,name:"do_normalize"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.do_color_quantize",description:`<strong>do_color_quantize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_color_quantize</code>) &#x2014;
Whether to color quantize the image.`,name:"do_color_quantize"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.clusters",description:`<strong>clusters</strong> (<code>np.ndarray</code> or <code>List[List[int]]</code>, <em>optional</em>, defaults to <code>self.clusters</code>) &#x2014;
Clusters used to quantize the image of shape <code>(n_clusters, 3)</code>. Only has an effect if
<code>do_color_quantize</code> is set to <code>True</code>.`,name:"clusters"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
Only has an effect if <code>do_color_quantize</code> is set to <code>False</code>.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/image_processing_imagegpt.py#L189"}}),Ie=new R({props:{title:"ImageGPTModel",local:"transformers.ImageGPTModel",headingTag:"h2"}}),we=new q({props:{name:"class transformers.ImageGPTModel",anchor:"transformers.ImageGPTModel",parameters:[{name:"config",val:": ImageGPTConfig"}],parametersDescription:[{anchor:"transformers.ImageGPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/modeling_imagegpt.py#L608"}}),Me=new q({props:{name:"forward",anchor:"transformers.ImageGPTModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**kwargs",val:": Any"}],parametersDescription:[{anchor:"transformers.ImageGPTModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.39.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ImageGPTImageProcessor.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.ImageGPTModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.ImageGPTModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ImageGPTModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ImageGPTModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ImageGPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ImageGPTModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.ImageGPTModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ImageGPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ImageGPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ImageGPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ImageGPTModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/modeling_imagegpt.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.39.2/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTConfig"
>ImageGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.39.2/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new so({props:{$$slots:{default:[Lo]},$$scope:{ctx:w}}}),Q=new kt({props:{anchor:"transformers.ImageGPTModel.forward.example",$$slots:{default:[Vo]},$$scope:{ctx:w}}}),Pe=new R({props:{title:"ImageGPTForCausalImageModeling",local:"transformers.ImageGPTForCausalImageModeling",headingTag:"h2"}}),$e=new q({props:{name:"class transformers.ImageGPTForCausalImageModeling",anchor:"transformers.ImageGPTForCausalImageModeling",parameters:[{name:"config",val:": ImageGPTConfig"}],parametersDescription:[{anchor:"transformers.ImageGPTForCausalImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/modeling_imagegpt.py#L876"}}),ke=new q({props:{name:"forward",anchor:"transformers.ImageGPTForCausalImageModeling.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**kwargs",val:": Any"}],parametersDescription:[{anchor:"transformers.ImageGPTForCausalImageModeling.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.39.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ImageGPTImageProcessor.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/modeling_imagegpt.py#L940",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.39.2/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTConfig"
>ImageGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.39.2/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new so({props:{$$slots:{default:[Ho]},$$scope:{ctx:w}}}),D=new kt({props:{anchor:"transformers.ImageGPTForCausalImageModeling.forward.example",$$slots:{default:[So]},$$scope:{ctx:w}}}),Ce=new R({props:{title:"ImageGPTForImageClassification",local:"transformers.ImageGPTForImageClassification",headingTag:"h2"}}),Ge=new q({props:{name:"class transformers.ImageGPTForImageClassification",anchor:"transformers.ImageGPTForImageClassification",parameters:[{name:"config",val:": ImageGPTConfig"}],parametersDescription:[{anchor:"transformers.ImageGPTForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/modeling_imagegpt.py#L1076"}}),xe=new q({props:{name:"forward",anchor:"transformers.ImageGPTForImageClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**kwargs",val:": Any"}],parametersDescription:[{anchor:"transformers.ImageGPTForImageClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.39.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ImageGPTImageProcessor.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.ImageGPTForImageClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.ImageGPTForImageClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ImageGPTForImageClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ImageGPTForImageClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ImageGPTForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ImageGPTForImageClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.ImageGPTForImageClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ImageGPTForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ImageGPTForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ImageGPTForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ImageGPTForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/models/imagegpt/modeling_imagegpt.py#L1093",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.39.2/en/model_doc/imagegpt#transformers.ImageGPTConfig"
>ImageGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new so({props:{$$slots:{default:[Eo]},$$scope:{ctx:w}}}),Y=new kt({props:{anchor:"transformers.ImageGPTForImageClassification.forward.example",$$slots:{default:[Xo]},$$scope:{ctx:w}}}),{c(){n=d("meta"),v=a(),m=d("p"),p=a(),h(y.$$.fragment),s=a(),h(I.$$.fragment),Ke=a(),te=d("p"),te.innerHTML=ao,et=a(),oe=d("p"),oe.textContent=ro,tt=a(),ne=d("p"),ne.innerHTML=io,ot=a(),V=d("img"),nt=a(),se=d("small"),se.textContent=co,st=a(),ae=d("p"),ae.innerHTML=mo,at=a(),h(re.$$.fragment),rt=a(),ie=d("ul"),ie.innerHTML=po,it=a(),le=d("table"),le.innerHTML=go,lt=a(),h(de.$$.fragment),dt=a(),ce=d("p"),ce.textContent=ho,ct=a(),h(me.$$.fragment),mt=a(),pe=d("ul"),pe.innerHTML=uo,pt=a(),ge=d("p"),ge.textContent=fo,gt=a(),h(he.$$.fragment),ht=a(),C=d("div"),h(ue.$$.fragment),Gt=a(),Je=d("p"),Je.innerHTML=_o,xt=a(),We=d("p"),We.innerHTML=To,zt=a(),h(H.$$.fragment),ut=a(),h(fe.$$.fragment),ft=a(),B=d("div"),h(_e.$$.fragment),jt=a(),S=d("div"),h(Te.$$.fragment),Ft=a(),qe=d("p"),qe.textContent=bo,_t=a(),h(be.$$.fragment),Tt=a(),U=d("div"),h(ye.$$.fragment),Ut=a(),Ne=d("p"),Ne.textContent=yo,Jt=a(),E=d("div"),h(ve.$$.fragment),Wt=a(),Ze=d("p"),Ze.textContent=vo,bt=a(),h(Ie.$$.fragment),yt=a(),P=d("div"),h(we.$$.fragment),qt=a(),Re=d("p"),Re.textContent=Io,Nt=a(),Be=d("p"),Be.innerHTML=wo,Zt=a(),Le=d("p"),Le.innerHTML=Mo,Rt=a(),z=d("div"),h(Me.$$.fragment),Bt=a(),Ve=d("p"),Ve.innerHTML=Po,Lt=a(),h(X.$$.fragment),Vt=a(),h(Q.$$.fragment),vt=a(),h(Pe.$$.fragment),It=a(),$=d("div"),h($e.$$.fragment),Ht=a(),He=d("p"),He.textContent=$o,St=a(),Se=d("p"),Se.innerHTML=ko,Et=a(),Ee=d("p"),Ee.innerHTML=Co,Xt=a(),j=d("div"),h(ke.$$.fragment),Qt=a(),Xe=d("p"),Xe.innerHTML=Go,At=a(),h(A.$$.fragment),Dt=a(),h(D.$$.fragment),wt=a(),h(Ce.$$.fragment),Mt=a(),k=d("div"),h(Ge.$$.fragment),Ot=a(),Qe=d("p"),Qe.innerHTML=xo,Yt=a(),Ae=d("p"),Ae.innerHTML=zo,Kt=a(),De=d("p"),De.innerHTML=jo,eo=a(),F=d("div"),h(xe.$$.fragment),to=a(),Oe=d("p"),Oe.innerHTML=Fo,oo=a(),h(O.$$.fragment),no=a(),h(Y.$$.fragment),Pt=a(),Ye=d("p"),this.h()},l(e){const t=Zo("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),v=r(e),m=c(e,"P",{}),x(m).forEach(o),p=r(e),u(y.$$.fragment,e),s=r(e),u(I.$$.fragment,e),Ke=r(e),te=c(e,"P",{"data-svelte-h":!0}),g(te)!=="svelte-thwva5"&&(te.innerHTML=ao),et=r(e),oe=c(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-vfdo9a"&&(oe.textContent=ro),tt=r(e),ne=c(e,"P",{"data-svelte-h":!0}),g(ne)!=="svelte-1nknq39"&&(ne.innerHTML=io),ot=r(e),V=c(e,"IMG",{src:!0,alt:!0,width:!0}),nt=r(e),se=c(e,"SMALL",{"data-svelte-h":!0}),g(se)!=="svelte-1yh5y0e"&&(se.textContent=co),st=r(e),ae=c(e,"P",{"data-svelte-h":!0}),g(ae)!=="svelte-1y5dk1"&&(ae.innerHTML=mo),at=r(e),u(re.$$.fragment,e),rt=r(e),ie=c(e,"UL",{"data-svelte-h":!0}),g(ie)!=="svelte-d3pp4z"&&(ie.innerHTML=po),it=r(e),le=c(e,"TABLE",{"data-svelte-h":!0}),g(le)!=="svelte-631n1h"&&(le.innerHTML=go),lt=r(e),u(de.$$.fragment,e),dt=r(e),ce=c(e,"P",{"data-svelte-h":!0}),g(ce)!=="svelte-34o9qd"&&(ce.textContent=ho),ct=r(e),u(me.$$.fragment,e),mt=r(e),pe=c(e,"UL",{"data-svelte-h":!0}),g(pe)!=="svelte-16u4krc"&&(pe.innerHTML=uo),pt=r(e),ge=c(e,"P",{"data-svelte-h":!0}),g(ge)!=="svelte-1xesile"&&(ge.textContent=fo),gt=r(e),u(he.$$.fragment,e),ht=r(e),C=c(e,"DIV",{class:!0});var J=x(C);u(ue.$$.fragment,J),Gt=r(J),Je=c(J,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-aqevcm"&&(Je.innerHTML=_o),xt=r(J),We=c(J,"P",{"data-svelte-h":!0}),g(We)!=="svelte-1wty4gf"&&(We.innerHTML=To),zt=r(J),u(H.$$.fragment,J),J.forEach(o),ut=r(e),u(fe.$$.fragment,e),ft=r(e),B=c(e,"DIV",{class:!0});var ze=x(B);u(_e.$$.fragment,ze),jt=r(ze),S=c(ze,"DIV",{class:!0});var je=x(S);u(Te.$$.fragment,je),Ft=r(je),qe=c(je,"P",{"data-svelte-h":!0}),g(qe)!=="svelte-khengj"&&(qe.textContent=bo),je.forEach(o),ze.forEach(o),_t=r(e),u(be.$$.fragment,e),Tt=r(e),U=c(e,"DIV",{class:!0});var L=x(U);u(ye.$$.fragment,L),Ut=r(L),Ne=c(L,"P",{"data-svelte-h":!0}),g(Ne)!=="svelte-4cfp03"&&(Ne.textContent=yo),Jt=r(L),E=c(L,"DIV",{class:!0});var Fe=x(E);u(ve.$$.fragment,Fe),Wt=r(Fe),Ze=c(Fe,"P",{"data-svelte-h":!0}),g(Ze)!=="svelte-1x3yxsa"&&(Ze.textContent=vo),Fe.forEach(o),L.forEach(o),bt=r(e),u(Ie.$$.fragment,e),yt=r(e),P=c(e,"DIV",{class:!0});var G=x(P);u(we.$$.fragment,G),qt=r(G),Re=c(G,"P",{"data-svelte-h":!0}),g(Re)!=="svelte-fy7x11"&&(Re.textContent=Io),Nt=r(G),Be=c(G,"P",{"data-svelte-h":!0}),g(Be)!=="svelte-1xn1kz7"&&(Be.innerHTML=wo),Zt=r(G),Le=c(G,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-hswkmf"&&(Le.innerHTML=Mo),Rt=r(G),z=c(G,"DIV",{class:!0});var W=x(z);u(Me.$$.fragment,W),Bt=r(W),Ve=c(W,"P",{"data-svelte-h":!0}),g(Ve)!=="svelte-1c6tqva"&&(Ve.innerHTML=Po),Lt=r(W),u(X.$$.fragment,W),Vt=r(W),u(Q.$$.fragment,W),W.forEach(o),G.forEach(o),vt=r(e),u(Pe.$$.fragment,e),It=r(e),$=c(e,"DIV",{class:!0});var N=x($);u($e.$$.fragment,N),Ht=r(N),He=c(N,"P",{"data-svelte-h":!0}),g(He)!=="svelte-1jpvdp1"&&(He.textContent=$o),St=r(N),Se=c(N,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-1xn1kz7"&&(Se.innerHTML=ko),Et=r(N),Ee=c(N,"P",{"data-svelte-h":!0}),g(Ee)!=="svelte-hswkmf"&&(Ee.innerHTML=Co),Xt=r(N),j=c(N,"DIV",{class:!0});var K=x(j);u(ke.$$.fragment,K),Qt=r(K),Xe=c(K,"P",{"data-svelte-h":!0}),g(Xe)!=="svelte-18v8o2y"&&(Xe.innerHTML=Go),At=r(K),u(A.$$.fragment,K),Dt=r(K),u(D.$$.fragment,K),K.forEach(o),N.forEach(o),wt=r(e),u(Ce.$$.fragment,e),Mt=r(e),k=c(e,"DIV",{class:!0});var Z=x(k);u(Ge.$$.fragment,Z),Ot=r(Z),Qe=c(Z,"P",{"data-svelte-h":!0}),g(Qe)!=="svelte-1a1qe4"&&(Qe.innerHTML=xo),Yt=r(Z),Ae=c(Z,"P",{"data-svelte-h":!0}),g(Ae)!=="svelte-1xn1kz7"&&(Ae.innerHTML=zo),Kt=r(Z),De=c(Z,"P",{"data-svelte-h":!0}),g(De)!=="svelte-hswkmf"&&(De.innerHTML=jo),eo=r(Z),F=c(Z,"DIV",{class:!0});var ee=x(F);u(xe.$$.fragment,ee),to=r(ee),Oe=c(ee,"P",{"data-svelte-h":!0}),g(Oe)!=="svelte-1p6uoqq"&&(Oe.innerHTML=Fo),oo=r(ee),u(O.$$.fragment,ee),no=r(ee),u(Y.$$.fragment,ee),ee.forEach(o),Z.forEach(o),Pt=r(e),Ye=c(e,"P",{}),x(Ye).forEach(o),this.h()},h(){M(n,"name","hf:doc:metadata"),M(n,"content",Ao),Jo(V.src,lo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/imagegpt_architecture.png")||M(V,"src",lo),M(V,"alt","drawing"),M(V,"width","600"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,n),i(e,v,t),i(e,m,t),i(e,p,t),f(y,e,t),i(e,s,t),f(I,e,t),i(e,Ke,t),i(e,te,t),i(e,et,t),i(e,oe,t),i(e,tt,t),i(e,ne,t),i(e,ot,t),i(e,V,t),i(e,nt,t),i(e,se,t),i(e,st,t),i(e,ae,t),i(e,at,t),f(re,e,t),i(e,rt,t),i(e,ie,t),i(e,it,t),i(e,le,t),i(e,lt,t),f(de,e,t),i(e,dt,t),i(e,ce,t),i(e,ct,t),f(me,e,t),i(e,mt,t),i(e,pe,t),i(e,pt,t),i(e,ge,t),i(e,gt,t),f(he,e,t),i(e,ht,t),i(e,C,t),f(ue,C,null),l(C,Gt),l(C,Je),l(C,xt),l(C,We),l(C,zt),f(H,C,null),i(e,ut,t),f(fe,e,t),i(e,ft,t),i(e,B,t),f(_e,B,null),l(B,jt),l(B,S),f(Te,S,null),l(S,Ft),l(S,qe),i(e,_t,t),f(be,e,t),i(e,Tt,t),i(e,U,t),f(ye,U,null),l(U,Ut),l(U,Ne),l(U,Jt),l(U,E),f(ve,E,null),l(E,Wt),l(E,Ze),i(e,bt,t),f(Ie,e,t),i(e,yt,t),i(e,P,t),f(we,P,null),l(P,qt),l(P,Re),l(P,Nt),l(P,Be),l(P,Zt),l(P,Le),l(P,Rt),l(P,z),f(Me,z,null),l(z,Bt),l(z,Ve),l(z,Lt),f(X,z,null),l(z,Vt),f(Q,z,null),i(e,vt,t),f(Pe,e,t),i(e,It,t),i(e,$,t),f($e,$,null),l($,Ht),l($,He),l($,St),l($,Se),l($,Et),l($,Ee),l($,Xt),l($,j),f(ke,j,null),l(j,Qt),l(j,Xe),l(j,At),f(A,j,null),l(j,Dt),f(D,j,null),i(e,wt,t),f(Ce,e,t),i(e,Mt,t),i(e,k,t),f(Ge,k,null),l(k,Ot),l(k,Qe),l(k,Yt),l(k,Ae),l(k,Kt),l(k,De),l(k,eo),l(k,F),f(xe,F,null),l(F,to),l(F,Oe),l(F,oo),f(O,F,null),l(F,no),f(Y,F,null),i(e,Pt,t),i(e,Ye,t),$t=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),H.$set(J);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),X.$set(ze);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),Q.$set(je);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),A.$set(L);const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),D.$set(Fe);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),O.$set(G);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),Y.$set(W)},i(e){$t||(_(y.$$.fragment,e),_(I.$$.fragment,e),_(re.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(H.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(Ie.$$.fragment,e),_(we.$$.fragment,e),_(Me.$$.fragment,e),_(X.$$.fragment,e),_(Q.$$.fragment,e),_(Pe.$$.fragment,e),_($e.$$.fragment,e),_(ke.$$.fragment,e),_(A.$$.fragment,e),_(D.$$.fragment,e),_(Ce.$$.fragment,e),_(Ge.$$.fragment,e),_(xe.$$.fragment,e),_(O.$$.fragment,e),_(Y.$$.fragment,e),$t=!0)},o(e){T(y.$$.fragment,e),T(I.$$.fragment,e),T(re.$$.fragment,e),T(de.$$.fragment,e),T(me.$$.fragment,e),T(he.$$.fragment,e),T(ue.$$.fragment,e),T(H.$$.fragment,e),T(fe.$$.fragment,e),T(_e.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(ye.$$.fragment,e),T(ve.$$.fragment,e),T(Ie.$$.fragment,e),T(we.$$.fragment,e),T(Me.$$.fragment,e),T(X.$$.fragment,e),T(Q.$$.fragment,e),T(Pe.$$.fragment,e),T($e.$$.fragment,e),T(ke.$$.fragment,e),T(A.$$.fragment,e),T(D.$$.fragment,e),T(Ce.$$.fragment,e),T(Ge.$$.fragment,e),T(xe.$$.fragment,e),T(O.$$.fragment,e),T(Y.$$.fragment,e),$t=!1},d(e){e&&(o(v),o(m),o(p),o(s),o(Ke),o(te),o(et),o(oe),o(tt),o(ne),o(ot),o(V),o(nt),o(se),o(st),o(ae),o(at),o(rt),o(ie),o(it),o(le),o(lt),o(dt),o(ce),o(ct),o(mt),o(pe),o(pt),o(ge),o(gt),o(ht),o(C),o(ut),o(ft),o(B),o(_t),o(Tt),o(U),o(bt),o(yt),o(P),o(vt),o(It),o($),o(wt),o(Mt),o(k),o(Pt),o(Ye)),o(n),b(y,e),b(I,e),b(re,e),b(de,e),b(me,e),b(he,e),b(ue),b(H),b(fe,e),b(_e),b(Te),b(be,e),b(ye),b(ve),b(Ie,e),b(we),b(Me),b(X),b(Q),b(Pe,e),b($e),b(ke),b(A),b(D),b(Ce,e),b(Ge),b(xe),b(O),b(Y)}}}const Ao='{"title":"ImageGPT","local":"imagegpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"ImageGPTConfig","local":"transformers.ImageGPTConfig","sections":[],"depth":2},{"title":"ImageGPTFeatureExtractor","local":"transformers.ImageGPTFeatureExtractor","sections":[],"depth":2},{"title":"ImageGPTImageProcessor","local":"transformers.ImageGPTImageProcessor","sections":[],"depth":2},{"title":"ImageGPTModel","local":"transformers.ImageGPTModel","sections":[],"depth":2},{"title":"ImageGPTForCausalImageModeling","local":"transformers.ImageGPTForCausalImageModeling","sections":[],"depth":2},{"title":"ImageGPTForImageClassification","local":"transformers.ImageGPTForImageClassification","sections":[],"depth":2}],"depth":1}';function Do(w){return Wo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class an extends qo{constructor(n){super(),No(this,n,Do,Qo,Uo,{})}}export{an as component};
