import{s as Cs,o as Xs,n as Is}from"../chunks/scheduler.9bc65507.js";import{S as Rs,i as _s,g as o,s as n,r as p,A as Hs,h as i,f as s,c as l,j as Vs,u as c,x as r,k as St,y as $s,a,v as m,d,t as h,w as u}from"../chunks/index.707bf1b6.js";import{T as zs}from"../chunks/Tip.c2ecdbf4.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{H as M,E as xs}from"../chunks/EditOnGithub.922df6ba.js";function Ns(Xe){let g,j="The API for the streamer classes is still under development and may change in the future.";return{c(){g=o("p"),g.textContent=j},l(b){g=i(b,"P",{"data-svelte-h":!0}),r(g)!=="svelte-gv2g1g"&&(g.textContent=j)},m(b,Ve){a(b,g,Ve)},p:Is,d(b){b&&s(g)}}}function Qs(Xe){let g,j,b,Ve,T,Ie,U,qt=`Text generation is essential to many NLP tasks, such as open-ended text generation, summarization, translation, and
more. It also plays a role in a variety of mixed-modality applications that have text as an output like speech-to-text
and vision-to-text. Some of the models that can generate text include
GPT2, XLNet, OpenAI GPT, CTRL, TransformerXL, XLM, Bart, T5, GIT, Whisper.`,Re,J,At=`Check out a few examples that use <code>~transformers.generation_utils.GenerationMixin.generate</code> method to produce
text outputs for different tasks:`,_e,Z,Lt='<li><a href="./tasks/summarization#inference">Text summarization</a></li> <li><a href="./model_doc/git#transformers.GitForCausalLM.forward.example">Image captioning</a></li> <li><a href="./model_doc/whisper#transformers.WhisperForConditionalGeneration.forward.example">Audio transcription</a></li>',He,v,Dt=`Note that the inputs to the generate method depend on the model’s modality. They are returned by the model’s preprocessor
class, such as AutoTokenizer or AutoProcessor. If a model’s preprocessor creates more than one kind of input, pass all
the inputs to generate(). You can learn more about the individual model’s preprocessor in the corresponding model’s documentation.`,$e,k,Kt=`The process of selecting output tokens to generate text is known as decoding, and you can customize the decoding strategy
that the <code>generate()</code> method will use. Modifying a decoding strategy does not change the values of any trainable parameters.
However, it can have a noticeable impact on the quality of the generated output. It can help reduce repetition in the text
and make it more coherent.`,ze,W,Pt="This guide describes:",xe,G,Ot="<li>default generation configuration</li> <li>common decoding strategies and their main parameters</li> <li>saving and sharing custom generation configurations with your fine-tuned model on 🤗 Hub</li>",Ne,B,Qe,V,es=`A decoding strategy for a model is defined in its generation configuration. When using pre-trained models for inference
within a <a href="/docs/transformers/v4.40.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, the models call the <code>PreTrainedModel.generate()</code> method that applies a default generation
configuration under the hood. The default configuration is also used when no custom configuration has been saved with
the model.`,Fe,C,ts=`When you load a model explicitly, you can inspect the generation configuration that comes with it through
<code>model.generation_config</code>:`,Ye,X,Ee,I,ss=`Printing out the <code>model.generation_config</code> reveals only the values that are different from the default generation
configuration, and does not list any of the default values.`,Se,R,as=`The default generation configuration limits the size of the output combined with the input prompt to a maximum of 20
tokens to avoid running into resource limitations. The default decoding strategy is greedy search, which is the simplest decoding strategy that picks a token with the highest probability as the next token. For many tasks
and small output sizes this works well. However, when used to generate longer outputs, greedy search can start
producing highly repetitive results.`,qe,_,Ae,H,ns="You can override any <code>generation_config</code> by passing the parameters and their values directly to the <code>generate</code> method:",Le,$,De,z,ls=`Even if the default decoding strategy mostly works for your task, you can still tweak a few things. Some of the
commonly adjusted parameters include:`,Ke,x,os=`<li><code>max_new_tokens</code>: the maximum number of tokens to generate. In other words, the size of the output sequence, not
including the tokens in the prompt. As an alternative to using the output’s length as a stopping criteria, you can choose
to stop generation whenever the full generation exceeds some amount of time. To learn more, check <a href="/docs/transformers/v4.40.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>.</li> <li><code>num_beams</code>: by specifying a number of beams higher than 1, you are effectively switching from greedy search to
beam search. This strategy evaluates several hypotheses at each time step and eventually chooses the hypothesis that
has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with a lower probability initial tokens and would’ve been ignored by the greedy search. Visualize how it works <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">here</a>.</li> <li><code>do_sample</code>: if set to <code>True</code>, this parameter enables decoding strategies such as multinomial sampling, beam-search
multinomial sampling, Top-K sampling and Top-p sampling. All these strategies select the next token from the probability
distribution over the entire vocabulary with various strategy-specific adjustments.</li> <li><code>num_return_sequences</code>: the number of sequence candidates to return for each input. This option is only available for
the decoding strategies that support multiple sequence candidates, e.g. variations of beam search and sampling. Decoding
strategies like greedy search and contrastive search return a single output sequence.</li>`,Pe,N,Oe,Q,is="If you would like to share your fine-tuned model with a specific generation configuration, you can:",et,F,rs='<li>Create a <a href="/docs/transformers/v4.40.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> class instance</li> <li>Specify the decoding strategy parameters</li> <li>Save your generation configuration with <a href="/docs/transformers/v4.40.1/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>, making sure to leave its <code>config_file_name</code> argument empty</li> <li>Set <code>push_to_hub</code> to <code>True</code> to upload your config to the model’s repo</li>',tt,Y,st,E,ps=`You can also store several generation configurations in a single directory, making use of the <code>config_file_name</code>
argument in <a href="/docs/transformers/v4.40.1/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>. You can later instantiate them with <a href="/docs/transformers/v4.40.1/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">GenerationConfig.from_pretrained()</a>. This is useful if you want to
store several generation configurations for a single model (e.g. one for creative text generation with sampling, and
one for summarization with beam search). You must have the right Hub permissions to add configuration files to a model.`,at,S,nt,q,lt,A,cs=`The <code>generate()</code> supports streaming, through its <code>streamer</code> input. The <code>streamer</code> input is compatible with any instance
from a class that has the following methods: <code>put()</code> and <code>end()</code>. Internally, <code>put()</code> is used to push new tokens and
<code>end()</code> is used to flag the end of text generation.`,ot,w,it,L,ms=`In practice, you can craft your own streaming class for all sorts of purposes! We also have basic streaming classes
ready for you to use. For example, you can use the <a href="/docs/transformers/v4.40.1/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> class to stream the output of <code>generate()</code> into
your screen, one word at a time:`,rt,D,pt,K,ct,P,ds=`Certain combinations of the <code>generate()</code> parameters, and ultimately <code>generation_config</code>, can be used to enable specific
decoding strategies. If you are new to this concept, we recommend reading <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">this blog post that illustrates how common decoding strategies work</a>.`,mt,O,hs="Here, we’ll show some of the parameters that control the decoding strategies and illustrate how you can use them.",dt,ee,ht,te,us="<code>generate</code> uses greedy search decoding by default so you don’t have to pass any parameters to enable it. This means the parameters <code>num_beams</code> is set to 1 and <code>do_sample=False</code>.",ut,se,gt,ae,yt,ne,gs=`The contrastive search decoding strategy was proposed in the 2022 paper <a href="https://arxiv.org/abs/2202.06417" rel="nofollow">A Contrastive Framework for Neural Text Generation</a>.
It demonstrates superior results for generating non-repetitive yet coherent long outputs. To learn how contrastive search
works, check out <a href="https://huggingface.co/blog/introducing-csearch" rel="nofollow">this blog post</a>.
The two main parameters that enable and control the behavior of contrastive search are <code>penalty_alpha</code> and <code>top_k</code>:`,Mt,le,bt,oe,ft,ie,ys=`As opposed to greedy search that always chooses a token with the highest probability as the
next token, multinomial sampling (also called ancestral sampling) randomly selects the next token based on the probability distribution over the entire
vocabulary given by the model. Every token with a non-zero probability has a chance of being selected, thus reducing the
risk of repetition.`,wt,re,Ms="To enable multinomial sampling set <code>do_sample=True</code> and <code>num_beams=1</code>.",jt,pe,Tt,ce,Ut,me,bs=`Unlike greedy search, beam-search decoding keeps several hypotheses at each time step and eventually chooses
the hypothesis that has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with lower probability initial tokens and would’ve been ignored by the greedy search.`,Jt,f,fs='<img style="max-width: 90%; margin: auto;" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beam_search.png"/>',Zt,de,ws='You can visualize how beam-search decoding works in <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">this interactive demo</a>: type your input sentence, and play with the parameters to see how the decoding beams change.',vt,he,js="To enable this decoding strategy, specify the <code>num_beams</code> (aka number of hypotheses to keep track of) that is greater than 1.",kt,ue,Wt,ge,Gt,ye,Ts=`As the name implies, this decoding strategy combines beam search with multinomial sampling. You need to specify
the <code>num_beams</code> greater than 1, and set <code>do_sample=True</code> to use this decoding strategy.`,Bt,Me,Vt,be,Ct,fe,Us=`The diverse beam search decoding strategy is an extension of the beam search strategy that allows for generating a more diverse
set of beam sequences to choose from. To learn how it works, refer to <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence Models</a>.
This approach has three main parameters: <code>num_beams</code>, <code>num_beam_groups</code>, and <code>diversity_penalty</code>.
The diversity penalty ensures the outputs are distinct across groups, and beam search is used within each group.`,Xt,we,It,je,Js=`This guide illustrates the main parameters that enable various decoding strategies. More advanced parameters exist for the
<code>generate</code> method, which gives you even further control over the <code>generate</code> method’s behavior.
For the complete list of the available parameters, refer to the <a href="./main_classes/text_generation.md">API documentation</a>.`,Rt,Te,_t,Ue,Zs=`Speculative decoding (also known as assisted decoding) is a modification of the decoding strategies above, that uses an
assistant model (ideally a much smaller one) with the same tokenizer, to generate a few candidate tokens. The main
model then validates the candidate tokens in a single forward pass, which speeds up the decoding process. If
<code>do_sample=True</code>, then the token validation with resampling introduced in the
<a href="https://arxiv.org/pdf/2211.17192.pdf" rel="nofollow">speculative decoding paper</a> is used.`,Ht,Je,vs=`Currently, only greedy search and sampling are supported with assisted decoding, and assisted decoding doesn’t support batched inputs.
To learn more about assisted decoding, check <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">this blog post</a>.`,$t,Ze,ks="To enable assisted decoding, set the <code>assistant_model</code> argument with a model.",zt,ve,xt,ke,Ws=`When using assisted decoding with sampling methods, you can use the <code>temperature</code> argument to control the randomness,
just like in multinomial sampling. However, in assisted decoding, reducing the temperature may help improve the latency.`,Nt,We,Qt,Ge,Gs=`Alternativelly, you can also set the <code>prompt_lookup_num_tokens</code> to trigger n-gram based assisted decoding, as opposed
to model based assisted decoding. You can read more about it <a href="https://twitter.com/joao_gante/status/1747322413006643259" rel="nofollow">here</a>.`,Ft,Be,Yt,Ce,Et;return T=new M({props:{title:"Text generation strategies",local:"text-generation-strategies",headingTag:"h1"}}),B=new M({props:{title:"Default text generation configuration",local:"default-text-generation-configuration",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config
GenerationConfig {
  <span class="hljs-string">&quot;bos_token_id&quot;</span>: <span class="hljs-number">50256</span>,
  <span class="hljs-string">&quot;eos_token_id&quot;</span>: <span class="hljs-number">50256</span>
}
&lt;BLANKLINE&gt;`,wrap:!1}}),_=new M({props:{title:"Customize text generation",local:"customize-text-generation",headingTag:"h2"}}),$=new y({props:{code:"bXlfbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>my_model.generate(**inputs, num_beams=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">True</span>)',wrap:!1}}),N=new M({props:{title:"Save a custom decoding strategy with your model",local:"save-a-custom-decoding-strategy-with-your-model",headingTag:"h2"}}),Y=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwR2VuZXJhdGlvbkNvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm15X2FjY291bnQlMkZteV9tb2RlbCUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDUwJTJDJTIwZW9zX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQSklMEFnZW5lcmF0aW9uX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIybXlfYWNjb3VudCUyRm15X21vZGVsJTIyJTJDJTIwcHVzaF90b19odWIlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">50</span>, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">50</span>, eos_token_id=model.config.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LXNtYWxsJTIyKSUwQSUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZWFybHlfc3RvcHBpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUzRDAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuJTNEbW9kZWwuY29uZmlnLnBhZF90b2tlbl9pZCUyQyUwQSklMEElMEElMjMlMjBUaXAlM0ElMjBhZGQlMjAlNjBwdXNoX3RvX2h1YiUzRFRydWUlNjAlMjB0byUyMHB1c2glMjB0byUyMHRoZSUyMEh1YiUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIlMkZ0bXAlMjIlMkMlMjAlMjJ0cmFuc2xhdGlvbl9nZW5lcmF0aW9uX2NvbmZpZy5qc29uJTIyKSUwQSUwQSUyMyUyMFlvdSUyMGNvdWxkJTIwdGhlbiUyMHVzZSUyMHRoZSUyMG5hbWVkJTIwZ2VuZXJhdGlvbiUyMGNvbmZpZyUyMGZpbGUlMjB0byUyMHBhcmFtZXRlcml6ZSUyMGdlbmVyYXRpb24lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnRtcCUyMiUyQyUyMCUyMnRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLmpzb24lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMENvbmZpZ3VyYXRpb24lMjBmaWxlcyUyMGFyZSUyMGVhc3klMjB0byUyMHVzZSElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGdlbmVyYXRpb25fY29uZmlnJTNEZ2VuZXJhdGlvbl9jb25maWcpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    early_stopping=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    decoder_start_token_id=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    eos_token_id=model.config.eos_token_id,
<span class="hljs-meta">... </span>    pad_token=model.config.pad_token_id,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: add \`push_to_hub=True\` to push to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config.save_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You could then use the named generation config file to parameterize generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;translate English to French: Configuration files are easy to use!&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, generation_config=generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Les fichiers de configuration sont faciles à utiliser!&#x27;</span>]`,wrap:!1}}),q=new M({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),w=new zs({props:{warning:!0,$$slots:{default:[Ns]},$$scope:{ctx:Xe}}}),D=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),K=new M({props:{title:"Decoding strategies",local:"decoding-strategies",headingTag:"h2"}}),ee=new M({props:{title:"Greedy Search",local:"greedy-search",headingTag:"h3"}}),se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkklMjBsb29rJTIwZm9yd2FyZCUyMHRvJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I look forward to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;I look forward to seeing you all again!\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n&#x27;</span>]`,wrap:!1}}),ae=new M({props:{title:"Contrastive search",local:"contrastive-search",headingTag:"h3"}}),le=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1sYXJnZSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHBlbmFsdHlfYWxwaGElM0QwLjYlMkMlMjB0b3BfayUzRDQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Hugging Face Company is a family owned and operated business. We pride ourselves on being the best
in the business and our customer service is second to none.\\n\\nIf you have any questions about our
products or services, feel free to contact us at any time. We look forward to hearing from you!&#x27;</span>]`,wrap:!1}}),oe=new M({props:{title:"Multinomial sampling",local:"multinomial-sampling",headingTag:"h3"}}),pe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoMCklMjAlMjAlMjMlMjBGb3IlMjByZXByb2R1Y2liaWxpdHklMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDItbGFyZ2UlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVG9kYXklMjB3YXMlMjBhbiUyMGFtYXppbmclMjBkYXklMjBiZWNhdXNlJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG51bV9iZWFtcyUzRDElMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Today was an amazing day because&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, num_beams=<span class="hljs-number">1</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Today was an amazing day because we received these wonderful items by the way of a gift shop. The box arrived on a Thursday and I opened it on Monday afternoon to receive the gifts. Both bags featured pieces from all the previous years!\\n\\nThe box had lots of surprises in it, including some sweet little mini chocolate chips! I don&#x27;t think I&#x27;d eat all of these. This was definitely one of the most expensive presents I have ever got, I actually got most of them for free!\\n\\nThe first package came&quot;</span>]`,wrap:!1}}),ce=new M({props:{title:"Beam-search decoding",local:"beam-search-decoding",headingTag:"h3"}}),ue=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBhc3RvbmlzaGluZyUyMGhvdyUyMG9uZSUyMGNhbiUyMiUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1tZWRpdW0lMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbnVtX2JlYW1zJTNENSUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;It is astonishing how one can&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-medium&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;It is astonishing how one can have such a profound impact on the lives of so many people in such a short period of
time.&quot;\\n\\nHe added: &quot;I am very proud of the work I have been able to do in the last few years.\\n\\n&quot;I have&#x27;</span>]`,wrap:!1}}),ge=new M({props:{title:"Beam-search multinomial sampling",local:"beam-search-multinomial-sampling",headingTag:"h3"}}),Me=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMkMlMjBzZXRfc2VlZCUwQXNldF9zZWVkKDApJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIydHJhbnNsYXRlJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwVGhlJTIwaG91c2UlMjBpcyUyMHdvbmRlcmZ1bC4lMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDUlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;translate English to German: The house is wonderful.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google-t5/t5-small&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Das Haus ist wunderbar.&#x27;</span>`,wrap:!1}}),be=new M({props:{title:"Diverse beam search decoding",local:"diverse-beam-search-decoding",headingTag:"h3"}}),we=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/pegasus-xsum&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Permaculture Design Principles are a set of universal design principles &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;that can be applied to any location, climate and culture, and they allow us to design &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the most efficient and sustainable human habitation and food production systems. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture is a design system that encompasses a wide variety of disciplines, such &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;as ecology, landscape design, environmental science and energy conservation, and the &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture design principles are drawn from these various disciplines. Each individual &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;design principle itself embodies a complete conceptual framework based on sound &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;scientific principles. When we bring all these separate  principles together, we can &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;create a design system that both looks at whole systems, the parts that these systems &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;consist of, and how those parts interact with each other to create a complex, dynamic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;living system. Each design principle serves as a tool that allows us to integrate all &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the separate parts of a design, referred to as elements, into a functional, synergistic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;whole system, where the elements harmoniously interact and work together in the most &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;efficient way possible.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, num_beam_groups=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">30</span>, diversity_penalty=<span class="hljs-number">1.0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;The Design Principles are a set of universal design principles that can be applied to any location, climate and
culture, and they allow us to design the&#x27;</span>`,wrap:!1}}),Te=new M({props:{title:"Speculative Decoding",local:"speculative-decoding",headingTag:"h3"}}),ve=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMS40Yi1kZWR1cGVkJTIyJTBBYXNzaXN0YW50X2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJFbGV1dGhlckFJJTJGcHl0aGlhLTE2MG0tZGVkdXBlZCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoYXNzaXN0YW50X2NoZWNrcG9pbnQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are sitting in a bar. Alice is drinking a beer and Bob is drinking a&#x27;</span>]`,wrap:!1}}),We=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoNDIpJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyRWxldXRoZXJBSSUyRnB5dGhpYS0xLjRiLWRlZHVwZWQlMjIlMEFhc3Npc3RhbnRfY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMTYwbS1kZWR1cGVkJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChhc3Npc3RhbnRfY2hlY2twb2ludCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBhc3Npc3RhbnRfbW9kZWwlM0Rhc3Npc3RhbnRfbW9kZWwlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob, a couple of friends of mine, who are both in the same office as&#x27;</span>]`,wrap:!1}}),Be=new xs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/generation_strategies.md"}}),{c(){g=o("meta"),j=n(),b=o("p"),Ve=n(),p(T.$$.fragment),Ie=n(),U=o("p"),U.textContent=qt,Re=n(),J=o("p"),J.innerHTML=At,_e=n(),Z=o("ul"),Z.innerHTML=Lt,He=n(),v=o("p"),v.textContent=Dt,$e=n(),k=o("p"),k.innerHTML=Kt,ze=n(),W=o("p"),W.textContent=Pt,xe=n(),G=o("ul"),G.innerHTML=Ot,Ne=n(),p(B.$$.fragment),Qe=n(),V=o("p"),V.innerHTML=es,Fe=n(),C=o("p"),C.innerHTML=ts,Ye=n(),p(X.$$.fragment),Ee=n(),I=o("p"),I.innerHTML=ss,Se=n(),R=o("p"),R.textContent=as,qe=n(),p(_.$$.fragment),Ae=n(),H=o("p"),H.innerHTML=ns,Le=n(),p($.$$.fragment),De=n(),z=o("p"),z.textContent=ls,Ke=n(),x=o("ul"),x.innerHTML=os,Pe=n(),p(N.$$.fragment),Oe=n(),Q=o("p"),Q.textContent=is,et=n(),F=o("ul"),F.innerHTML=rs,tt=n(),p(Y.$$.fragment),st=n(),E=o("p"),E.innerHTML=ps,at=n(),p(S.$$.fragment),nt=n(),p(q.$$.fragment),lt=n(),A=o("p"),A.innerHTML=cs,ot=n(),p(w.$$.fragment),it=n(),L=o("p"),L.innerHTML=ms,rt=n(),p(D.$$.fragment),pt=n(),p(K.$$.fragment),ct=n(),P=o("p"),P.innerHTML=ds,mt=n(),O=o("p"),O.textContent=hs,dt=n(),p(ee.$$.fragment),ht=n(),te=o("p"),te.innerHTML=us,ut=n(),p(se.$$.fragment),gt=n(),p(ae.$$.fragment),yt=n(),ne=o("p"),ne.innerHTML=gs,Mt=n(),p(le.$$.fragment),bt=n(),p(oe.$$.fragment),ft=n(),ie=o("p"),ie.textContent=ys,wt=n(),re=o("p"),re.innerHTML=Ms,jt=n(),p(pe.$$.fragment),Tt=n(),p(ce.$$.fragment),Ut=n(),me=o("p"),me.textContent=bs,Jt=n(),f=o("a"),f.innerHTML=fs,Zt=n(),de=o("p"),de.innerHTML=ws,vt=n(),he=o("p"),he.innerHTML=js,kt=n(),p(ue.$$.fragment),Wt=n(),p(ge.$$.fragment),Gt=n(),ye=o("p"),ye.innerHTML=Ts,Bt=n(),p(Me.$$.fragment),Vt=n(),p(be.$$.fragment),Ct=n(),fe=o("p"),fe.innerHTML=Us,Xt=n(),p(we.$$.fragment),It=n(),je=o("p"),je.innerHTML=Js,Rt=n(),p(Te.$$.fragment),_t=n(),Ue=o("p"),Ue.innerHTML=Zs,Ht=n(),Je=o("p"),Je.innerHTML=vs,$t=n(),Ze=o("p"),Ze.innerHTML=ks,zt=n(),p(ve.$$.fragment),xt=n(),ke=o("p"),ke.innerHTML=Ws,Nt=n(),p(We.$$.fragment),Qt=n(),Ge=o("p"),Ge.innerHTML=Gs,Ft=n(),p(Be.$$.fragment),Yt=n(),Ce=o("p"),this.h()},l(e){const t=Hs("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(s),j=l(e),b=i(e,"P",{}),Vs(b).forEach(s),Ve=l(e),c(T.$$.fragment,e),Ie=l(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1pq6r4w"&&(U.textContent=qt),Re=l(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1anycgm"&&(J.innerHTML=At),_e=l(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-18jzu0"&&(Z.innerHTML=Lt),He=l(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-5iqkcx"&&(v.textContent=Dt),$e=l(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-agd87v"&&(k.innerHTML=Kt),ze=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1gun7m8"&&(W.textContent=Pt),xe=l(e),G=i(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-l1azua"&&(G.innerHTML=Ot),Ne=l(e),c(B.$$.fragment,e),Qe=l(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-6sl490"&&(V.innerHTML=es),Fe=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-2o7gdz"&&(C.innerHTML=ts),Ye=l(e),c(X.$$.fragment,e),Ee=l(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-18srzjs"&&(I.innerHTML=ss),Se=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-32rftl"&&(R.textContent=as),qe=l(e),c(_.$$.fragment,e),Ae=l(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-qprijs"&&(H.innerHTML=ns),Le=l(e),c($.$$.fragment,e),De=l(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-t9z639"&&(z.textContent=ls),Ke=l(e),x=i(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-l4x44s"&&(x.innerHTML=os),Pe=l(e),c(N.$$.fragment,e),Oe=l(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1l1ri2h"&&(Q.textContent=is),et=l(e),F=i(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-3sw03u"&&(F.innerHTML=rs),tt=l(e),c(Y.$$.fragment,e),st=l(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-xu9fa7"&&(E.innerHTML=ps),at=l(e),c(S.$$.fragment,e),nt=l(e),c(q.$$.fragment,e),lt=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-12rh7l9"&&(A.innerHTML=cs),ot=l(e),c(w.$$.fragment,e),it=l(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-xra43f"&&(L.innerHTML=ms),rt=l(e),c(D.$$.fragment,e),pt=l(e),c(K.$$.fragment,e),ct=l(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ip87dk"&&(P.innerHTML=ds),mt=l(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-nugt5b"&&(O.textContent=hs),dt=l(e),c(ee.$$.fragment,e),ht=l(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1m7rj88"&&(te.innerHTML=us),ut=l(e),c(se.$$.fragment,e),gt=l(e),c(ae.$$.fragment,e),yt=l(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-m0y9j6"&&(ne.innerHTML=gs),Mt=l(e),c(le.$$.fragment,e),bt=l(e),c(oe.$$.fragment,e),ft=l(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-vsvvis"&&(ie.textContent=ys),wt=l(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-ldtxsn"&&(re.innerHTML=Ms),jt=l(e),c(pe.$$.fragment,e),Tt=l(e),c(ce.$$.fragment,e),Ut=l(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-149ek3p"&&(me.textContent=bs),Jt=l(e),f=i(e,"A",{href:!0,class:!0,"data-svelte-h":!0}),r(f)!=="svelte-1ck2qcm"&&(f.innerHTML=fs),Zt=l(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ymxnsd"&&(de.innerHTML=ws),vt=l(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-krswod"&&(he.innerHTML=js),kt=l(e),c(ue.$$.fragment,e),Wt=l(e),c(ge.$$.fragment,e),Gt=l(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-zgjlvh"&&(ye.innerHTML=Ts),Bt=l(e),c(Me.$$.fragment,e),Vt=l(e),c(be.$$.fragment,e),Ct=l(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-zdhf65"&&(fe.innerHTML=Us),Xt=l(e),c(we.$$.fragment,e),It=l(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1e7mt8t"&&(je.innerHTML=Js),Rt=l(e),c(Te.$$.fragment,e),_t=l(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-13d2q9j"&&(Ue.innerHTML=Zs),Ht=l(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-xy91hv"&&(Je.innerHTML=vs),$t=l(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-ebd3ly"&&(Ze.innerHTML=ks),zt=l(e),c(ve.$$.fragment,e),xt=l(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-nm0fxt"&&(ke.innerHTML=Ws),Nt=l(e),c(We.$$.fragment,e),Qt=l(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-lf7edt"&&(Ge.innerHTML=Gs),Ft=l(e),c(Be.$$.fragment,e),Yt=l(e),Ce=i(e,"P",{}),Vs(Ce).forEach(s),this.h()},h(){St(g,"name","hf:doc:metadata"),St(g,"content",Fs),St(f,"href","https://huggingface.co/spaces/m-ric/beam_search_visualizer"),St(f,"class","flex flex-col justify-center")},m(e,t){$s(document.head,g),a(e,j,t),a(e,b,t),a(e,Ve,t),m(T,e,t),a(e,Ie,t),a(e,U,t),a(e,Re,t),a(e,J,t),a(e,_e,t),a(e,Z,t),a(e,He,t),a(e,v,t),a(e,$e,t),a(e,k,t),a(e,ze,t),a(e,W,t),a(e,xe,t),a(e,G,t),a(e,Ne,t),m(B,e,t),a(e,Qe,t),a(e,V,t),a(e,Fe,t),a(e,C,t),a(e,Ye,t),m(X,e,t),a(e,Ee,t),a(e,I,t),a(e,Se,t),a(e,R,t),a(e,qe,t),m(_,e,t),a(e,Ae,t),a(e,H,t),a(e,Le,t),m($,e,t),a(e,De,t),a(e,z,t),a(e,Ke,t),a(e,x,t),a(e,Pe,t),m(N,e,t),a(e,Oe,t),a(e,Q,t),a(e,et,t),a(e,F,t),a(e,tt,t),m(Y,e,t),a(e,st,t),a(e,E,t),a(e,at,t),m(S,e,t),a(e,nt,t),m(q,e,t),a(e,lt,t),a(e,A,t),a(e,ot,t),m(w,e,t),a(e,it,t),a(e,L,t),a(e,rt,t),m(D,e,t),a(e,pt,t),m(K,e,t),a(e,ct,t),a(e,P,t),a(e,mt,t),a(e,O,t),a(e,dt,t),m(ee,e,t),a(e,ht,t),a(e,te,t),a(e,ut,t),m(se,e,t),a(e,gt,t),m(ae,e,t),a(e,yt,t),a(e,ne,t),a(e,Mt,t),m(le,e,t),a(e,bt,t),m(oe,e,t),a(e,ft,t),a(e,ie,t),a(e,wt,t),a(e,re,t),a(e,jt,t),m(pe,e,t),a(e,Tt,t),m(ce,e,t),a(e,Ut,t),a(e,me,t),a(e,Jt,t),a(e,f,t),a(e,Zt,t),a(e,de,t),a(e,vt,t),a(e,he,t),a(e,kt,t),m(ue,e,t),a(e,Wt,t),m(ge,e,t),a(e,Gt,t),a(e,ye,t),a(e,Bt,t),m(Me,e,t),a(e,Vt,t),m(be,e,t),a(e,Ct,t),a(e,fe,t),a(e,Xt,t),m(we,e,t),a(e,It,t),a(e,je,t),a(e,Rt,t),m(Te,e,t),a(e,_t,t),a(e,Ue,t),a(e,Ht,t),a(e,Je,t),a(e,$t,t),a(e,Ze,t),a(e,zt,t),m(ve,e,t),a(e,xt,t),a(e,ke,t),a(e,Nt,t),m(We,e,t),a(e,Qt,t),a(e,Ge,t),a(e,Ft,t),m(Be,e,t),a(e,Yt,t),a(e,Ce,t),Et=!0},p(e,[t]){const Bs={};t&2&&(Bs.$$scope={dirty:t,ctx:e}),w.$set(Bs)},i(e){Et||(d(T.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(_.$$.fragment,e),d($.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(w.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(we.$$.fragment,e),d(Te.$$.fragment,e),d(ve.$$.fragment,e),d(We.$$.fragment,e),d(Be.$$.fragment,e),Et=!0)},o(e){h(T.$$.fragment,e),h(B.$$.fragment,e),h(X.$$.fragment,e),h(_.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(q.$$.fragment,e),h(w.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),Et=!1},d(e){e&&(s(j),s(b),s(Ve),s(Ie),s(U),s(Re),s(J),s(_e),s(Z),s(He),s(v),s($e),s(k),s(ze),s(W),s(xe),s(G),s(Ne),s(Qe),s(V),s(Fe),s(C),s(Ye),s(Ee),s(I),s(Se),s(R),s(qe),s(Ae),s(H),s(Le),s(De),s(z),s(Ke),s(x),s(Pe),s(Oe),s(Q),s(et),s(F),s(tt),s(st),s(E),s(at),s(nt),s(lt),s(A),s(ot),s(it),s(L),s(rt),s(pt),s(ct),s(P),s(mt),s(O),s(dt),s(ht),s(te),s(ut),s(gt),s(yt),s(ne),s(Mt),s(bt),s(ft),s(ie),s(wt),s(re),s(jt),s(Tt),s(Ut),s(me),s(Jt),s(f),s(Zt),s(de),s(vt),s(he),s(kt),s(Wt),s(Gt),s(ye),s(Bt),s(Vt),s(Ct),s(fe),s(Xt),s(It),s(je),s(Rt),s(_t),s(Ue),s(Ht),s(Je),s($t),s(Ze),s(zt),s(xt),s(ke),s(Nt),s(Qt),s(Ge),s(Ft),s(Yt),s(Ce)),s(g),u(T,e),u(B,e),u(X,e),u(_,e),u($,e),u(N,e),u(Y,e),u(S,e),u(q,e),u(w,e),u(D,e),u(K,e),u(ee,e),u(se,e),u(ae,e),u(le,e),u(oe,e),u(pe,e),u(ce,e),u(ue,e),u(ge,e),u(Me,e),u(be,e),u(we,e),u(Te,e),u(ve,e),u(We,e),u(Be,e)}}}const Fs='{"title":"Text generation strategies","local":"text-generation-strategies","sections":[{"title":"Default text generation configuration","local":"default-text-generation-configuration","sections":[],"depth":2},{"title":"Customize text generation","local":"customize-text-generation","sections":[],"depth":2},{"title":"Save a custom decoding strategy with your model","local":"save-a-custom-decoding-strategy-with-your-model","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Decoding strategies","local":"decoding-strategies","sections":[{"title":"Greedy Search","local":"greedy-search","sections":[],"depth":3},{"title":"Contrastive search","local":"contrastive-search","sections":[],"depth":3},{"title":"Multinomial sampling","local":"multinomial-sampling","sections":[],"depth":3},{"title":"Beam-search decoding","local":"beam-search-decoding","sections":[],"depth":3},{"title":"Beam-search multinomial sampling","local":"beam-search-multinomial-sampling","sections":[],"depth":3},{"title":"Diverse beam search decoding","local":"diverse-beam-search-decoding","sections":[],"depth":3},{"title":"Speculative Decoding","local":"speculative-decoding","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ys(Xe){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Rs{constructor(g){super(),_s(this,g,Ys,Qs,Cs,{})}}export{Ds as component};
