import{s as dt,n as ft,o as ht}from"../chunks/scheduler.9bc65507.js";import{S as wt,i as yt,g as o,s,r as p,A as Tt,h as i,f as n,c as a,j as ct,u as m,x as r,k as ut,y as bt,a as l,v as c,d as u,t as d,w as f}from"../chunks/index.707bf1b6.js";import{C as w}from"../chunks/CodeBlock.54a9f38d.js";import{D as Mt}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as ne,E as gt}from"../chunks/EditOnGithub.922df6ba.js";function Jt(Ye){let h,le,ee,se,y,ae,T,oe,b,He='Accelerated Linear Algebra, dubbed XLA, is a compiler for accelerating the runtime of TensorFlow Models. From the <a href="https://www.tensorflow.org/xla" rel="nofollow">official documentation</a>:',ie,M,Ne="XLA (Accelerated Linear Algebra) is a domain-specific compiler for linear algebra that can accelerate TensorFlow models with potentially no source code changes.",re,g,Ae='Using XLA in TensorFlow is simple – it comes packaged inside the <code>tensorflow</code> library, and it can be triggered with the <code>jit_compile</code> argument in any graph-creating function such as <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>. When using Keras methods like <code>fit()</code> and <code>predict()</code>, you can enable XLA simply by passing the <code>jit_compile</code> argument to <code>model.compile()</code>. However, XLA is not limited to these methods - it can also be used to accelerate any arbitrary <code>tf.function</code>.',pe,J,Qe='Several TensorFlow methods in 🤗 Transformers have been rewritten to be XLA-compatible, including text generation for models such as <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a> and <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>, as well as speech processing for models such as <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.',me,U,qe="While the exact amount of speed-up is very much model-dependent, for TensorFlow text generation models inside 🤗 Transformers, we noticed a speed-up of ~100x. This document will explain how you can use XLA for these models to get the maximum amount of performance. We’ll also provide links to additional resources if you’re interested to learn more about the benchmarks and our design philosophy behind the XLA integration.",ce,j,ue,k,Se="Let us consider the following model in TensorFlow:",de,Z,fe,_,Pe="The above model accepts inputs having a dimension of <code>(10, )</code>. We can use the model for running a forward pass like so:",he,G,we,X,De="In order to run the forward pass with an XLA-compiled function, we’d need to do:",ye,R,Te,v,Ke="The default <code>call()</code> function of the <code>model</code> is used for compiling the XLA graph. But if there’s any other model function you want to compile into XLA that’s also possible with:",be,W,Me,I,ge,x,Oe="To enable XLA-accelerated generation within 🤗 Transformers, you need to have a recent version of <code>transformers</code> installed. You can install it by running:",Je,$,Ue,V,et="And then you can run the following code:",je,F,ke,C,tt="As you can notice, enabling XLA on <code>generate()</code> is just a single line of code. The rest of the code remains unchanged. However, there are a couple of gotchas in the above code snippet that are specific to XLA. You need to be aware of those to realize the speed-ups that XLA can bring in. We discuss these in the following section.",Ze,B,_e,z,nt='When you are executing an XLA-enabled function (like <code>xla_generate()</code> above) for the first time, it will internally try to infer the computation graph, which is time-consuming.  This process is known as <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“tracing”</a>.',Ge,L,lt="You might notice that the generation time is not fast. Successive calls of <code>xla_generate()</code> (or any other XLA-enabled function) won’t have to infer the computation graph, given the inputs to the function follow the same shape with which the computation graph was initially built. While this is not a problem for modalities with fixed input shapes (e.g., images), you must pay attention if you are working with variable input shape modalities (e.g., text).",Xe,E,st="To ensure <code>xla_generate()</code> always operates with the same input shapes, you can specify the <code>padding</code> arguments when calling the tokenizer.",Re,Y,ve,H,at="This way, you can ensure that the inputs to <code>xla_generate()</code> will always receive inputs with the shape it was traced with and thus leading to speed-ups in the generation time. You can verify this with the code below:",We,N,Ie,A,ot="On a Tesla T4 GPU, you can expect the outputs like so:",xe,Q,$e,q,it="The first call to <code>xla_generate()</code> is time-consuming because of tracing, but the successive calls are orders of magnitude faster. Keep in mind that any change in the generation options at any point with trigger re-tracing and thus leading to slow-downs in the generation time.",Ve,S,rt="We didn’t cover all the text generation options 🤗 Transformers provides in this document. We encourage you to read the documentation for advanced use cases.",Fe,P,Ce,D,pt="Here, we leave you with some additional resources if you want to delve deeper into XLA in 🤗 Transformers and in general.",Be,K,mt='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">This Colab Notebook</a> provides an interactive demonstration if you want to fiddle with the XLA-compatible encoder-decoder (like <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>) and decoder-only (like <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>) text generation models.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">This blog post</a> provides an overview of the comparison benchmarks for XLA-compatible models along with a friendly introduction to XLA in TensorFlow.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">This blog post</a> discusses our design philosophy behind adding XLA support to the TensorFlow models in 🤗 Transformers.</li> <li>Recommended posts for learning more about XLA and TensorFlow graphs in general:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: Optimizing Compiler for Machine Learning</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">Introduction to graphs and tf.function</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">Better performance with tf.function</a></li></ul></li>',ze,O,Le,te,Ee;return y=new ne({props:{title:"XLA Integration for TensorFlow Models",local:"xla-integration-for-tensorflow-models",headingTag:"h1"}}),T=new Mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"}]}}),j=new ne({props:{title:"Running TF functions with XLA",local:"running-tf-functions-with-xla",headingTag:"h2"}}),Z=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),G=new w({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`,wrap:!1}}),R=new w({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),W=new w({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),I=new ne({props:{title:"Running a TF text generation model with XLA from 🤗 Transformers",local:"running-a-tf-text-generation-model-with-xla-from--transformers",headingTag:"h2"}}),$=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),F=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQSUyMyUyME9uZSUyMGxpbmUlMjB0byUyMGNyZWF0ZSUyMGFuJTIwWExBJTIwZ2VuZXJhdGlvbiUyMGZ1bmN0aW9uJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMiklMEElMjMlMjBHZW5lcmF0ZWQlMjAtLSUyMFRlbnNvckZsb3clMjBpcyUyMGFuJTIwb3Blbi1zb3VyY2UlMkMlMjBvcGVuLXNvdXJjZSUyQyUyMGRpc3RyaWJ1dGVkLXNvdXJjZSUyMGFwcGxpY2F0aW9uJTIwJTIzJTIwZnJhbWV3b3JrJTIwZm9yJTIwdGhl",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),B=new ne({props:{title:"Gotchas to be aware of",local:"gotchas-to-be-aware-of",headingTag:"h2"}}),Y=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBJTIzJTIwSGVyZSUyQyUyMHdlJTIwY2FsbCUyMHRoZSUyMHRva2VuaXplciUyMHdpdGglMjBwYWRkaW5nJTIwb3B0aW9ucy4lMEF0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEFkZWNvZGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZiUyMkdlbmVyYXRlZCUyMC0tJTIwJTdCZGVjb2RlZF90ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),N=new w({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQWZvciUyMGlucHV0X3N0cmluZyUyMGluJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTJDJTIwJTIyVGVuc29yRmxvdyUyMGlzJTIwYSUyMiUyQyUyMCUyMlRGTGl0ZSUyMGlzJTIwYSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjBwYWRfdG9fbXVsdGlwbGVfb2YlM0Q4JTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUyMCUyMCUyMCUyMHN0YXJ0JTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEElMjAlMjAlMjAlMjBlbmQlMjAlM0QlMjB0aW1lLnRpbWVfbnMoKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJFeGVjdXRpb24lMjB0aW1lJTIwLS0lMjAlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDFlNiUzQS4xZiU3RCUyMG1zJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),Q=new w({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),P=new ne({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),O=new gt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tf_xla.md"}}),{c(){h=o("meta"),le=s(),ee=o("p"),se=s(),p(y.$$.fragment),ae=s(),p(T.$$.fragment),oe=s(),b=o("p"),b.innerHTML=He,ie=s(),M=o("p"),M.textContent=Ne,re=s(),g=o("p"),g.innerHTML=Ae,pe=s(),J=o("p"),J.innerHTML=Qe,me=s(),U=o("p"),U.textContent=qe,ce=s(),p(j.$$.fragment),ue=s(),k=o("p"),k.textContent=Se,de=s(),p(Z.$$.fragment),fe=s(),_=o("p"),_.innerHTML=Pe,he=s(),p(G.$$.fragment),we=s(),X=o("p"),X.textContent=De,ye=s(),p(R.$$.fragment),Te=s(),v=o("p"),v.innerHTML=Ke,be=s(),p(W.$$.fragment),Me=s(),p(I.$$.fragment),ge=s(),x=o("p"),x.innerHTML=Oe,Je=s(),p($.$$.fragment),Ue=s(),V=o("p"),V.textContent=et,je=s(),p(F.$$.fragment),ke=s(),C=o("p"),C.innerHTML=tt,Ze=s(),p(B.$$.fragment),_e=s(),z=o("p"),z.innerHTML=nt,Ge=s(),L=o("p"),L.innerHTML=lt,Xe=s(),E=o("p"),E.innerHTML=st,Re=s(),p(Y.$$.fragment),ve=s(),H=o("p"),H.innerHTML=at,We=s(),p(N.$$.fragment),Ie=s(),A=o("p"),A.textContent=ot,xe=s(),p(Q.$$.fragment),$e=s(),q=o("p"),q.innerHTML=it,Ve=s(),S=o("p"),S.textContent=rt,Fe=s(),p(P.$$.fragment),Ce=s(),D=o("p"),D.textContent=pt,Be=s(),K=o("ul"),K.innerHTML=mt,ze=s(),p(O.$$.fragment),Le=s(),te=o("p"),this.h()},l(e){const t=Tt("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(n),le=a(e),ee=i(e,"P",{}),ct(ee).forEach(n),se=a(e),m(y.$$.fragment,e),ae=a(e),m(T.$$.fragment,e),oe=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-afit4t"&&(b.innerHTML=He),ie=a(e),M=i(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1rjg69l"&&(M.textContent=Ne),re=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-8rwpb7"&&(g.innerHTML=Ae),pe=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1sup5o3"&&(J.innerHTML=Qe),me=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-v22hyz"&&(U.textContent=qe),ce=a(e),m(j.$$.fragment,e),ue=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1n8d5xl"&&(k.textContent=Se),de=a(e),m(Z.$$.fragment,e),fe=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-137qaqi"&&(_.innerHTML=Pe),he=a(e),m(G.$$.fragment,e),we=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xkaplb"&&(X.textContent=De),ye=a(e),m(R.$$.fragment,e),Te=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3tnenm"&&(v.innerHTML=Ke),be=a(e),m(W.$$.fragment,e),Me=a(e),m(I.$$.fragment,e),ge=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1tqra4o"&&(x.innerHTML=Oe),Je=a(e),m($.$$.fragment,e),Ue=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-5mrt6v"&&(V.textContent=et),je=a(e),m(F.$$.fragment,e),ke=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-xz55ih"&&(C.innerHTML=tt),Ze=a(e),m(B.$$.fragment,e),_e=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1tw7ufk"&&(z.innerHTML=nt),Ge=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1v603pg"&&(L.innerHTML=lt),Xe=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1s9agvy"&&(E.innerHTML=st),Re=a(e),m(Y.$$.fragment,e),ve=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1nbul0x"&&(H.innerHTML=at),We=a(e),m(N.$$.fragment,e),Ie=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-zm3wt3"&&(A.textContent=ot),xe=a(e),m(Q.$$.fragment,e),$e=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-18ijq7m"&&(q.innerHTML=it),Ve=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-149gqik"&&(S.textContent=rt),Fe=a(e),m(P.$$.fragment,e),Ce=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-k2oxa5"&&(D.textContent=pt),Be=a(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-19xtsh9"&&(K.innerHTML=mt),ze=a(e),m(O.$$.fragment,e),Le=a(e),te=i(e,"P",{}),ct(te).forEach(n),this.h()},h(){ut(h,"name","hf:doc:metadata"),ut(h,"content",Ut)},m(e,t){bt(document.head,h),l(e,le,t),l(e,ee,t),l(e,se,t),c(y,e,t),l(e,ae,t),c(T,e,t),l(e,oe,t),l(e,b,t),l(e,ie,t),l(e,M,t),l(e,re,t),l(e,g,t),l(e,pe,t),l(e,J,t),l(e,me,t),l(e,U,t),l(e,ce,t),c(j,e,t),l(e,ue,t),l(e,k,t),l(e,de,t),c(Z,e,t),l(e,fe,t),l(e,_,t),l(e,he,t),c(G,e,t),l(e,we,t),l(e,X,t),l(e,ye,t),c(R,e,t),l(e,Te,t),l(e,v,t),l(e,be,t),c(W,e,t),l(e,Me,t),c(I,e,t),l(e,ge,t),l(e,x,t),l(e,Je,t),c($,e,t),l(e,Ue,t),l(e,V,t),l(e,je,t),c(F,e,t),l(e,ke,t),l(e,C,t),l(e,Ze,t),c(B,e,t),l(e,_e,t),l(e,z,t),l(e,Ge,t),l(e,L,t),l(e,Xe,t),l(e,E,t),l(e,Re,t),c(Y,e,t),l(e,ve,t),l(e,H,t),l(e,We,t),c(N,e,t),l(e,Ie,t),l(e,A,t),l(e,xe,t),c(Q,e,t),l(e,$e,t),l(e,q,t),l(e,Ve,t),l(e,S,t),l(e,Fe,t),c(P,e,t),l(e,Ce,t),l(e,D,t),l(e,Be,t),l(e,K,t),l(e,ze,t),c(O,e,t),l(e,Le,t),l(e,te,t),Ee=!0},p:ft,i(e){Ee||(u(y.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(R.$$.fragment,e),u(W.$$.fragment,e),u(I.$$.fragment,e),u($.$$.fragment,e),u(F.$$.fragment,e),u(B.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),Ee=!0)},o(e){d(y.$$.fragment,e),d(T.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(W.$$.fragment,e),d(I.$$.fragment,e),d($.$$.fragment,e),d(F.$$.fragment,e),d(B.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),Ee=!1},d(e){e&&(n(le),n(ee),n(se),n(ae),n(oe),n(b),n(ie),n(M),n(re),n(g),n(pe),n(J),n(me),n(U),n(ce),n(ue),n(k),n(de),n(fe),n(_),n(he),n(we),n(X),n(ye),n(Te),n(v),n(be),n(Me),n(ge),n(x),n(Je),n(Ue),n(V),n(je),n(ke),n(C),n(Ze),n(_e),n(z),n(Ge),n(L),n(Xe),n(E),n(Re),n(ve),n(H),n(We),n(Ie),n(A),n(xe),n($e),n(q),n(Ve),n(S),n(Fe),n(Ce),n(D),n(Be),n(K),n(ze),n(Le),n(te)),n(h),f(y,e),f(T,e),f(j,e),f(Z,e),f(G,e),f(R,e),f(W,e),f(I,e),f($,e),f(F,e),f(B,e),f(Y,e),f(N,e),f(Q,e),f(P,e),f(O,e)}}}const Ut='{"title":"XLA Integration for TensorFlow Models","local":"xla-integration-for-tensorflow-models","sections":[{"title":"Running TF functions with XLA","local":"running-tf-functions-with-xla","sections":[],"depth":2},{"title":"Running a TF text generation model with XLA from 🤗 Transformers","local":"running-a-tf-text-generation-model-with-xla-from--transformers","sections":[],"depth":2},{"title":"Gotchas to be aware of","local":"gotchas-to-be-aware-of","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function jt(Ye){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends wt{constructor(h){super(),yt(this,h,jt,Jt,dt,{})}}export{Rt as component};
