import{s as Gn,f as Ca,o as Bn,n as ba}from"../chunks/scheduler.85c25b89.js";import{S as vn,i as An,g as u,s as a,r as p,A as kn,h as y,f as e,c as n,j as Os,u as o,x as j,k as w,y as Zn,a as l,v as r,d as i,t as M,w as c}from"../chunks/index.c142fe32.js";import{T as wa}from"../chunks/Tip.993c623e.js";import{C as h}from"../chunks/CodeBlock.a5e95a57.js";import{H as J,E as Rn}from"../chunks/EditOnGithub.a592e7aa.js";function Xn($){let d,f="While both the prompt-only and language modeling types are similar, they differ in how the input is handled. In the prompt-only type, the prompt represents a partial input that expects the model to complete or continue, while in the language modeling type, the input is treated as a complete sentence or sequence. These two types are processed differently by TRL. Below is an example showing the difference in the output of the <code>apply_chat_template</code> function for each type:",U,T,I,g,b="<li>The prompt-only output includes a <code>&#39;&lt;|assistant|&gt;\\n&#39;</code>, indicating the beginning of the assistant’s turn and expecting the model to generate a completion.</li> <li>In contrast, the language modeling output treats the input as a complete sequence and terminates it with <code>&#39;&lt;|endoftext|&gt;&#39;</code>, signaling the end of the text and not expecting any additional content.</li>",C;return T=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEElMjMlMjBFeGFtcGxlJTIwZm9yJTIwcHJvbXB0LW9ubHklMjB0eXBlJTBBcHJvbXB0X29ubHlfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnByb21wdCUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTVEJTdEJTBBYXBwbHlfY2hhdF90ZW1wbGF0ZShwcm9tcHRfb25seV9leGFtcGxlJTJDJTIwdG9rZW5pemVyKSUwQSUyMyUyME91dHB1dCUzQSUyMCU3Qidwcm9tcHQnJTNBJTIwJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclN0QlMEElMEElMjMlMjBFeGFtcGxlJTIwZm9yJTIwbGFuZ3VhZ2UlMjBtb2RlbGluZyUyMHR5cGUlMEFsbV9leGFtcGxlJTIwJTNEJTIwJTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCU3RCUwQWFwcGx5X2NoYXRfdGVtcGxhdGUobG1fZXhhbXBsZSUyQyUyMHRva2VuaXplciklMEElMjMlMjBPdXRwdXQlM0ElMjAlN0IndGV4dCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTdE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

<span class="hljs-comment"># Example for prompt-only type</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(prompt_only_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;}</span>

<span class="hljs-comment"># Example for language modeling type</span>
lm_example = {<span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(lm_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;text&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),{c(){d=u("p"),d.innerHTML=f,U=a(),p(T.$$.fragment),I=a(),g=u("ul"),g.innerHTML=b},l(m){d=y(m,"P",{"data-svelte-h":!0}),j(d)!=="svelte-1k9p4sz"&&(d.innerHTML=f),U=n(m),o(T.$$.fragment,m),I=n(m),g=y(m,"UL",{"data-svelte-h":!0}),j(g)!=="svelte-17mqw6t"&&(g.innerHTML=b)},m(m,q){l(m,d,q),l(m,U,q),r(T,m,q),l(m,I,q),l(m,g,q),C=!0},p:ba,i(m){C||(i(T.$$.fragment,m),C=!0)},o(m){M(T.$$.fragment,m),C=!1},d(m){m&&(e(d),e(U),e(I),e(g)),c(T,m)}}}function Vn($){let d,f=`TRL trainers only support standard dataset formats, <a href="https://github.com/huggingface/trl/issues/2071" rel="nofollow">for now</a>. If you have a conversational dataset, you must first convert it into a standard format.
For more information on how to work with conversational datasets, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.`;return{c(){d=u("p"),d.innerHTML=f},l(U){d=y(U,"P",{"data-svelte-h":!0}),j(d)!=="svelte-38co2n"&&(d.innerHTML=f)},m(U,T){l(U,d,T)},p:ba,d(U){U&&e(d)}}}function En($){let d,f=`We recommend using the <a href="/docs/trl/v0.12.2/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> function instead of calling <code>tokenizer.apply_chat_template</code> directly. Handling chat templates for non-language modeling datasets can be tricky and may result in errors, such as mistakenly placing a system prompt in the middle conversation.
For additional examples, see <a href="https://github.com/huggingface/trl/pull/1930#issuecomment-2292908614" rel="nofollow">#1930 (comment)</a>. The <a href="/docs/trl/v0.12.2/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> is designed to handle these intricacies and ensure the correct application of chat templates for various tasks.`;return{c(){d=u("p"),d.innerHTML=f},l(U){d=y(U,"P",{"data-svelte-h":!0}),j(d)!=="svelte-qfjtby"&&(d.innerHTML=f)},m(U,T){l(U,d,T)},p:ba,d(U){U&&e(d)}}}function Wn($){let d,f='It’s important to note that chat templates are model-specific. For example, if you use the chat template from <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-8B-Instruct</a> with the above example, you get a different output:',U,T,I,g,b="Always use the chat template associated with the model you’re working with. Using the wrong template can lead to inaccurate or unexpected results.",C;return T=new h({props:{code:"YXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTJDJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSklMEElMjMlMjBPdXRwdXQlM0ElMEElMjMlMjAlN0IncHJvbXB0JyUzQSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSU1Q25Zb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lM0MlN0NpbV9lbmQlN0MlM0UlNUNuJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTVDbldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMkMlMEElMjMlMjAlMjAnY29tcGxldGlvbiclM0ElMjAnSXQlMjBpcyUyMGJsdWUuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiclN0Q=",highlighted:`apply_chat_template(example, AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>))
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nWhat color is the sky?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;,</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: &#x27;It is blue.&lt;|im_end|&gt;\\n&#x27;}</span>`,wrap:!1}}),{c(){d=u("p"),d.innerHTML=f,U=a(),p(T.$$.fragment),I=a(),g=u("p"),g.textContent=b},l(m){d=y(m,"P",{"data-svelte-h":!0}),j(d)!=="svelte-6bgf58"&&(d.innerHTML=f),U=n(m),o(T.$$.fragment,m),I=n(m),g=y(m,"P",{"data-svelte-h":!0}),j(g)!=="svelte-ien9e7"&&(g.textContent=b)},m(m,q){l(m,d,q),l(m,U,q),r(T,m,q),l(m,I,q),l(m,g,q),C=!0},p:ba,i(m){C||(i(T.$$.fragment,m),C=!0)},o(m){M(T.$$.fragment,m),C=!1},d(m){m&&(e(d),e(U),e(I),e(g)),c(T,m)}}}function zn($){let d,f,U,T,I,g,b,C="This guide provides an overview of the dataset formats and types supported by each trainer in TRL.",m,q,te,k,$a="<li>The <em>format</em> of a dataset refers to how the data is structured, typically categorized as either <em>standard</em> or <em>conversational</em>.</li> <li>The <em>type</em> is associated with the specific task the dataset is designed for, such as <em>prompt-only</em> or <em>preference</em>. Each type is characterized by its columns, which vary according to the task, as shown in the table.</li>",se,Z,Qa=`<tbody><tr><th>Type \\ Format</th> <th>Standard</th> <th>Conversational</th></tr> <tr><td>Language modeling</td> <td><pre><code>{&quot;text&quot;: &quot;The sky is blue.&quot;}</code></pre></td> <td><pre><code>{&quot;messages&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Prompt-only</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}]}</code></pre></td></tr> <tr><td>Prompt-completion</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;chosen&quot;: &quot; blue.&quot;,
 &quot;rejected&quot;: &quot; green.&quot;}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: &quot;The sky is blue.&quot;,
 &quot;rejected&quot;: &quot;The sky is green.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;chosen&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
 &quot;rejected&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
 &quot;rejected&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
                {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre></td></tr> <tr><td>Unpaired preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;,
 &quot;label&quot;: True}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}],
 &quot;label&quot;: False}</code></pre></td></tr></tbody>`,ee,R,le,X,ae,V,Na="The standard dataset format typically consists of plain text strings. The columns in the dataset vary depending on the task. This is the format expected by TRL trainers. Below are examples of standard dataset formats for different tasks:",ne,E,pe,W,oe,z,xa="Conversational datasets are used for tasks involving dialogues or chat interactions between users and assistants. Unlike standard dataset formats, these contain sequences of messages where each message has a <code>role</code> (e.g., <code>&quot;user&quot;</code> or <code>&quot;assistant&quot;</code>) and <code>content</code> (the message text).",re,S,ie,_,Ga="Just like standard datasets, the columns in conversational datasets vary depending on the task. For instance, a preference dataset would include columns like <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> to compare responses:",Me,F,ce,Y,Ba='Conversational datasets are useful for training chat models, but must be converted into a standard format before being used with TRL trainers. This is typically done using chat templates specific to the model being used. For more information, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.',ue,H,ye,L,je,D,va="A language modeling dataset consists of a column <code>&quot;text&quot;</code> (or <code>&quot;messages&quot;</code> for conversational datasets) containing a full sequence of text.",he,P,me,K,de,O,Aa="In a prompt-only dataset, only the initial prompt (the question or partial sentence) is provided under the key <code>&quot;prompt&quot;</code>. The training typically involves generating the completion based on this prompt, where the model learns to continue or complete the given input.",Je,tt,Ue,G,Te,st,ge,et,ka="A prompt-completion dataset includes a <code>&quot;prompt&quot;</code> and a <code>&quot;completion&quot;</code>.",qe,lt,Ie,at,fe,nt,Za=`A preference dataset is used for tasks where the model is trained to choose between two or more possible completions to the same prompt. This dataset includes a <code>&quot;prompt&quot;</code>, a <code>&quot;chosen&quot;</code> completion, and a <code>&quot;rejected&quot;</code> completion. The model is trained to select the <code>&quot;chosen&quot;</code> response over the <code>&quot;rejected&quot;</code> response.
Some dataset may not include the <code>&quot;prompt&quot;</code> column, in which case the prompt is implicit and directly included in the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions. We recommend using explicit prompts whenever possible.`,we,pt,be,ot,Ra='Some preference datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>. You can also explore the <a href="https://huggingface.co/collections/librarian-bots/direct-preference-optimization-datasets-66964b12835f46289b6ef2fc" rel="nofollow">librarian-bots’ DPO Collections</a> to identify preference datasets.',Ce,rt,$e,it,Xa="An unpaired preference dataset is similar to a preference dataset but instead of having <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions for the same prompt, it includes a single <code>&quot;completion&quot;</code> and a <code>&quot;label&quot;</code> indicating whether the completion is preferred or not.",Qe,Mt,Ne,ct,xe,ut,Va="Choosing the right dataset type depends on the task you are working on and the specific requirements of the TRL trainer you are using. Below is a brief overview of the dataset types supported by each TRL trainer.",Ge,yt,Ea='<thead><tr><th>Trainer</th> <th>Expected dataset type</th></tr></thead> <tbody><tr><td><a href="/docs/trl/v0.12.2/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/gkd_trainer#trl.GKDTrainer">GKDTrainer</a></td> <td><a href="#prompt-completion">Prompt-completion</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/iterative_sft_trainer#trl.IterativeSFTTrainer">IterativeSFTTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a></td> <td><a href="#unpaired-preference">Unpaired preference</a> or <a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/nash_md_trainer#trl.NashMDTrainer">NashMDTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a></td> <td><a href="#preference">Preference (explicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/ppo_trainer#trl.PPOTrainer">PPOTrainer</a></td> <td>Tokenized language modeling</td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a></td> <td><a href="#preference">Preference (implicit prompt recommended)</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a></td> <td><a href="#language-modeling">Language modeling</a></td></tr> <tr><td><a href="/docs/trl/v0.12.2/en/xpo_trainer#trl.XPOTrainer">XPOTrainer</a></td> <td><a href="#prompt-only">Prompt-only</a></td></tr></tbody>',Be,B,ve,jt,Ae,ht,Wa=`Conversational datasets are increasingly common, especially for training chat models. However, TRL trainers (except <a href="/docs/trl/v0.12.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>) don’t support conversational datasets in their raw format. These datasets must first be converted into a standard format.
Fortunately, TRL offers tools to easily handle this conversion, which are detailed below.`,ke,mt,Ze,dt,za="TRL trainers do not support conversational datasets in their raw format. To use them, you need to convert them into a standard dataset format using a chat template. This template is provided by the tokenizer of the model you use.",Re,Jt,Sa='For detailed instructions on using chat templating, refer to the <a href="https://huggingface.co/docs/transformers/en/chat_templating" rel="nofollow">Chat templating section in the <code>transformers</code> documentation</a>.',Xe,Ut,_a='In TRL, the method you apply to convert the dataset will vary depending on the task. Fortunately, TRL provides a helper function called <a href="/docs/trl/v0.12.2/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> to simplify this process. Here’s an example of how to use it:',Ve,Tt,Ee,gt,Fa='Alternatively, you can use the <a href="https://huggingface.co/docs/datasets/v3.2.0/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> method to apply the template across an entire dataset:',We,qt,ze,v,Se,A,_e,It,Fe,ft,Ya="Many datasets come in formats tailored to specific tasks, which might not be directly compatible with TRL. To use such datasets with TRL, you may need to preprocess and convert them into the required format.",Ye,wt,Ha='To make this easier, we provide a set of <a href="https://github.com/huggingface/trl/tree/main/examples/datasets" rel="nofollow">example scripts</a> that cover common dataset conversions.',He,bt,Le,Ct,La='Let’s take the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a> as an example. Here’s a preview of the dataset:',De,Q,Da,Pe,$t,Pa="As shown above, the dataset format does not match the expected structure. It’s not in a conversational format, the column names differ, and the results pertain to different models (e.g., Bard, GPT-4) and aspects (e.g., “helpfulness”, “honesty”).",Ke,Qt,Ka='By using the provided conversion script <a href="https://github.com/huggingface/trl/tree/main/examples/datasets/ultrafeedback.py" rel="nofollow"><code>examples/datasets/ultrafeedback.py</code></a>, you can transform this dataset into an unpaired preference type, and push it to the Hub:',Oe,Nt,tl,xt,Oa="Once converted, the dataset will look like this:",sl,N,tn,el,Gt,sn="Now, you can use this dataset with TRL!",ll,Bt,en="By adapting the provided scripts or creating your own, you can convert any dataset into a format compatible with TRL.",al,vt,nl,At,ln="This section provides example code to help you convert between different dataset types. While some conversions can be performed after applying the chat template (i.e., in the standard format), we recommend performing the conversion before applying the chat template to ensure it works consistently.",pl,kt,an="For simplicity, some of the examples below do not follow this recommendation and use the standard format. However, the conversions can be applied directly to the conversational format without modification.",ol,Zt,nn='<thead><tr><th>From \\ To</th> <th>Language modeling</th> <th>Prompt-completion</th> <th>Prompt-only</th> <th>Preference with implicit prompt</th> <th>Preference</th> <th>Unpaired preference</th></tr></thead> <tbody><tr><td>Language modeling</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-completion</td> <td><a href="#from-prompt-completion-to-language-modeling-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-prompt-completion-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-only</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Preference with implicit prompt</td> <td><a href="#from-preference-with-implicit-prompt-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-implicit-to-explicit-prompt-preference-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-unpaired-preference-dataset">🔗</a></td></tr> <tr><td>Preference</td> <td><a href="#from-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-only-dataset">🔗</a></td> <td><a href="#from-explicit-to-implicit-prompt-preference-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-preference-to-unpaired-preference-dataset">🔗</a></td></tr> <tr><td>Unpaired preference</td> <td><a href="#from-unpaired-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr></tbody>',rl,Rt,il,Xt,pn="To convert a prompt-completion dataset into a language modeling dataset, concatenate the prompt and the completion.",Ml,Vt,cl,Et,ul,Wt,yl,zt,on="To convert a prompt-completion dataset into a prompt-only dataset, remove the completion.",jl,St,hl,_t,ml,Ft,dl,Yt,rn="To convert a preference with implicit prompt dataset into a language modeling dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;text&quot;</code>.",Jl,Ht,Ul,Lt,Tl,Dt,gl,Pt,Mn='To convert a preference dataset with implicit prompt into a prompt-completion dataset, extract the prompt with <a href="/docs/trl/v0.12.2/en/data_utils#trl.extract_prompt">extract_prompt()</a>, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.',ql,Kt,Il,Ot,fl,ts,wl,ss,cn='To convert a preference dataset with implicit prompt into a prompt-only dataset, extract the prompt with <a href="/docs/trl/v0.12.2/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and remove the rejected and the chosen.',bl,es,Cl,ls,$l,as,Ql,ns,un='To convert a preference dataset with implicit prompt into a preference dataset with explicit prompt, extract the prompt with <a href="/docs/trl/v0.12.2/en/data_utils#trl.extract_prompt">extract_prompt()</a>.',Nl,ps,xl,os,Gl,rs,Bl,is,yn='To convert a preference dataset with implicit prompt into an unpaired preference dataset, extract the prompt with <a href="/docs/trl/v0.12.2/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and unpair the dataset with <a href="/docs/trl/v0.12.2/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',vl,Ms,Al,cs,kl,us,Zl,ys,jn="To convert a preference dataset into a language modeling dataset, remove the rejected, concatenate the prompt and the chosen into the <code>&quot;text&quot;</code> column.",Rl,js,Xl,hs,Vl,ms,El,ds,hn="To convert a preference dataset into a prompt-completion dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.",Wl,Js,zl,Us,Sl,Ts,_l,gs,mn="To convert a preference dataset into a prompt-only dataset, remove the rejected and the chosen.",Fl,qs,Yl,Is,Hl,fs,Ll,ws,dn="To convert a preference dataset with explicit prompt into a preference dataset with implicit prompt, concatenate the prompt to both chosen and rejected, and remove the prompt.",Dl,bs,Pl,Cs,Kl,$s,Ol,Qs,Jn='To convert dataset into an unpaired preference dataset, unpair the dataset with <a href="/docs/trl/v0.12.2/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',ta,Ns,sa,xs,ea,Gs,la,Bs,Un="To convert an unpaired preference dataset into a language modeling dataset, concatenate the prompt and the completion into the <code>&quot;text&quot;</code> column, and remove the prompt, completion and label columns.",aa,vs,na,As,pa,ks,oa,Zs,Tn="To convert an unpaired preference dataset into a prompt-completion dataset, remove the label columns.",ra,Rs,ia,Xs,Ma,Vs,ca,Es,gn="To convert an unpaired preference dataset into a prompt-only dataset, remove the completion and the label columns.",ua,Ws,ya,zs,ja,Ss,ha,_s,qn="Some trainers also support fine-tuning vision-language models (VLMs) using image-text pairs. In this scenario, it’s recommended to use a conversational format, as each model handles image placeholders in text differently.",ma,Fs,In="A conversational vision dataset differs from a standard conversational dataset in two key ways:",da,Ys,fn="<li>The dataset must contain the key <code>images</code> with the image data.</li> <li>The <code>&quot;content&quot;</code> field in messages must be a list of dictionaries, where each dictionary specifies the type of data: <code>&quot;image&quot;</code> or <code>&quot;text&quot;</code>.</li>",Ja,Hs,wn="Example:",Ua,Ls,Ta,Ds,bn='An example of a conversational vision dataset is the <a href="https://huggingface.co/datasets/openbmb/RLAIF-V-Dataset" rel="nofollow">openbmb/RLAIF-V-Dataset</a>. Below is an embedded view of the dataset’s training data, allowing you to explore it directly:',ga,x,Cn,qa,Ps,Ia,Ks,fa;return I=new J({props:{title:"Dataset formats and types",local:"dataset-formats-and-types",headingTag:"h1"}}),q=new J({props:{title:"Overview of the dataset formats and types",local:"overview-of-the-dataset-formats-and-types",headingTag:"h2"}}),R=new J({props:{title:"Formats",local:"formats",headingTag:"h3"}}),X=new J({props:{title:"Standard",local:"standard",headingTag:"h4"}}),E=new h({props:{code:"JTIzJTIwTGFuZ3VhZ2UlMjBtb2RlbGluZyUwQWV4YW1wbGUlMjAlM0QlMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBibHVlLiUyMiU3RCUwQSUyMyUyMFByZWZlcmVuY2UlMEFleGFtcGxlJTIwJTNEJTIwJTdCJTIyY2hvc2VuJTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBibHVlLiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBncmVlbi4lMjIlN0Q=",highlighted:`<span class="hljs-comment"># Language modeling</span>
example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}
<span class="hljs-comment"># Preference</span>
example = {<span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;The sky is green.&quot;</span>}`,wrap:!1}}),W=new J({props:{title:"Conversational",local:"conversational",headingTag:"h4"}}),S=new h({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
]`,wrap:!1}}),F=new h({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwZ3JlZW4uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdE",highlighted:`example = {
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>},
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>},
    ],
}`,wrap:!1}}),H=new J({props:{title:"Types",local:"types",headingTag:"h3"}}),L=new J({props:{title:"Language modeling",local:"language-modeling",headingTag:"h4"}}),P=new h({props:{code:"bGFuZ3VhZ2VfbW9kZWxpbmdfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnRleHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMGJsdWUuJTIyJTdE",highlighted:'language_modeling_example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}',wrap:!1}}),K=new J({props:{title:"Prompt-only",local:"prompt-only",headingTag:"h4"}}),tt=new h({props:{code:"cHJvbXB0X29ubHlfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIyJTdE",highlighted:'prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>}',wrap:!1}}),G=new wa({props:{$$slots:{default:[Xn]},$$scope:{ctx:$}}}),st=new J({props:{title:"Prompt-completion",local:"prompt-completion",headingTag:"h4"}}),lt=new h({props:{code:"cHJvbXB0X2NvbXBsZXRpb25fZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUyMGJsdWUuJTIyJTdE",highlighted:'prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>}',wrap:!1}}),at=new J({props:{title:"Preference",local:"preference",headingTag:"h4"}}),pt=new h({props:{code:"JTIzJTIwZXhwbGljaXQlMjBwcm9tcHQlMEFwcmVmZXJlbmNlX2V4YW1wbGUlMjAlM0QlMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMmNob3NlbiUyMiUzQSUyMCUyMiUyMGJsdWUuJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlMjIlMjBncmVlbi4lMjIlN0QlMjAlMjAlMjMlMjByZWNvbW1lbmRlZCUwQSUyMyUyMGltcGxpY2l0JTIwcHJvbXB0JTBBcHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTIyY2hvc2VuJTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBibHVlLiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBncmVlbi4lMjIlN0Q=",highlighted:`<span class="hljs-comment"># explicit prompt</span>
preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot; green.&quot;</span>}  <span class="hljs-comment"># recommended</span>
<span class="hljs-comment"># implicit prompt</span>
preference_example = {<span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;The sky is green.&quot;</span>}`,wrap:!1}}),rt=new J({props:{title:"Unpaired preference",local:"unpaired-preference",headingTag:"h4"}}),Mt=new h({props:{code:"dW5wYWlyZWRfcHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjJsYWJlbCUyMiUzQSUyMFRydWUlN0Q=",highlighted:'unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}',wrap:!1}}),ct=new J({props:{title:"Which dataset type to use?",local:"which-dataset-type-to-use",headingTag:"h2"}}),B=new wa({props:{$$slots:{default:[Vn]},$$scope:{ctx:$}}}),jt=new J({props:{title:"Working with conversational datasets in TRL",local:"working-with-conversational-datasets-in-trl",headingTag:"h2"}}),mt=new J({props:{title:"Converting a conversational dataset into a standard dataset",local:"converting-a-conversational-dataset-into-a-standard-dataset",headingTag:"h3"}}),Tt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEFleGFtcGxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlMEElN0QlMEElMEFhcHBseV9jaGF0X3RlbXBsYXRlKGV4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTBBJTIzJTIwT3V0cHV0JTNBJTBBJTIzJTIwJTdCJ3Byb21wdCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyUyQyUyMCdjb21wbGV0aW9uJyUzQSUyMCdJdCUyMGlzJTIwYmx1ZS4lM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
    <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]
}

apply_chat_template(example, tokenizer)
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;, &#x27;completion&#x27;: &#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),qt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBhcHBseV9jaGF0X3RlbXBsYXRlJTBBJTBBZGF0YXNldF9kaWN0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlNUQlMEElN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZGF0YXNldF9kaWN0KSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChhcHBseV9jaGF0X3RlbXBsYXRlJTJDJTIwZm5fa3dhcmdzJTNEJTdCJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTdEKSUwQSUyMyUyME91dHB1dCUzQSUwQSUyMyUyMCU3Qidwcm9tcHQnJTNBJTIwJTVCJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMkMlMEElMjMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTNDJTdDZW5kJTdDJTNFJTVDbiUzQyU3Q2Fzc2lzdGFudCU3QyUzRSU1Q24nJTVEJTJDJTBBJTIzJTIwJTIwJ2NvbXBsZXRpb24nJTNBJTIwJTVCJ0l0JTIwaXMlMjBibHVlLiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTJDJTIwJ0luJTIwdGhlJTIwc2t5LiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
               [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}]],
    <span class="hljs-string">&quot;completion&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                   [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}]]
}

dataset = Dataset.from_dict(dataset_dict)
dataset = dataset.<span class="hljs-built_in">map</span>(apply_chat_template, fn_kwargs={<span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer})
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: [&#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;,</span>
<span class="hljs-comment">#             &#x27;&lt;|user|&gt;\\nWhere is the sun?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;],</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: [&#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;, &#x27;In the sky.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;]}</span>`,wrap:!1}}),v=new wa({props:{warning:!0,$$slots:{default:[En]},$$scope:{ctx:$}}}),A=new wa({props:{warning:!0,$$slots:{default:[Wn]},$$scope:{ctx:$}}}),It=new J({props:{title:"Using any dataset with TRL: preprocessing and conversion",local:"using-any-dataset-with-trl-preprocessing-and-conversion",headingTag:"h2"}}),bt=new J({props:{title:"Example: UltraFeedback dataset",local:"example-ultrafeedback-dataset",headingTag:"h3"}}),Nt=new h({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZkYXRhc2V0cyUyRnVsdHJhZmVlZGJhY2sucHklMjAtLXB1c2hfdG9faHViJTIwLS1yZXBvX2lkJTIwdHJsLWxpYiUyRnVsdHJhZmVlZGJhY2stZ3B0LTMuNS10dXJiby1oZWxwZnVsbmVzcw==",highlighted:"python examples/datasets/ultrafeedback.py --push_to_hub --repo_id trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness",wrap:!1}}),vt=new J({props:{title:"Utilities for converting dataset types",local:"utilities-for-converting-dataset-types",headingTag:"h2"}}),Rt=new J({props:{title:"From prompt-completion to language modeling dataset",local:"from-prompt-completion-to-language-modeling-dataset",headingTag:"h3"}}),Vt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdF9wcm9tcHRfY29tcGxldGlvbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNvbXBsZXRpb24lMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF9jb21wbGV0aW9uJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIlMjJwcm9tcHQlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_completion, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),Et=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Wt=new J({props:{title:"From prompt-completion to prompt-only dataset",local:"from-prompt-completion-to-prompt-only-dataset",headingTag:"h3"}}),St=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),_t=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Ft=new J({props:{title:"From preference with implicit prompt to language modeling dataset",local:"from-preference-with-implicit-prompt-to-language-modeling-dataset",headingTag:"h3"}}),Ht=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMGJsdWUuJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMlRoZSUyMHNreSUyMGlzJTIwZ3JlZW4uJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNlYS4lMjIlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJ0ZXh0JTIyKS5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot;The sky is green.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sea.&quot;</span>],
})

dataset = dataset.rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>)`,wrap:!1}}),Lt=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Dt=new J({props:{title:"From preference with implicit prompt to prompt-completion dataset",local:"from-preference-with-implicit-prompt-to-prompt-completion-dataset",headingTag:"h3"}}),Kt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCUyMnJlamVjdGVkJTIyKS5yZW5hbWVfY29sdW1uKCUyMmNob3NlbiUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),Ot=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}], <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}]}`,wrap:!1}}),ts=new J({props:{title:"From preference with implicit prompt to prompt-only dataset",local:"from-preference-with-implicit-prompt-to-prompt-only-dataset",headingTag:"h3"}}),es=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNob3NlbiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),ls=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}]}`,wrap:!1}}),as=new J({props:{title:"From implicit to explicit prompt preference dataset",local:"from-implicit-to-explicit-prompt-preference-dataset",headingTag:"h3"}}),ps=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)`,wrap:!1}}),os=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),rs=new J({props:{title:"From preference with implicit prompt to unpaired preference dataset",local:"from-preference-with-implicit-prompt-to-unpaired-preference-dataset",headingTag:"h3"}}),Ms=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUyQyUyMHVucGFpcl9wcmVmZXJlbmNlX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2t5LiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNlYS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGV4dHJhY3RfcHJvbXB0KSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt, unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)
dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),cs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),us=new J({props:{title:"From preference to language modeling dataset",local:"from-preference-to-language-modeling-dataset",headingTag:"h3"}}),js=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X2Nob3NlbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNob3NlbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRfcHJvbXB0X2Nob3NlbiUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIycHJvbXB0JTIyJTJDJTIwJTIyY2hvc2VuJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_chosen</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_chosen, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),hs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),ms=new J({props:{title:"From preference to prompt-completion dataset",local:"from-preference-to-prompt-completion-dataset",headingTag:"h3"}}),Js=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMikucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),Us=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),Ts=new J({props:{title:"From preference to prompt-only dataset",local:"from-preference-to-prompt-only-dataset",headingTag:"h3"}}),qs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglNUIlMjJjaG9zZW4lMjIlMkMlMjAlMjJyZWplY3RlZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),Is=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),fs=new J({props:{title:"From explicit to implicit prompt preference dataset",local:"from-explicit-to-implicit-prompt-preference-dataset",headingTag:"h3"}}),bs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X3RvX2NvbXBsZXRpb25zKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyY2hvc2VuJTIyJTNBJTIwZXhhbXBsZSU1QiUyMnByb21wdCUyMiU1RCUyMCUyQiUyMGV4YW1wbGUlNUIlMjJjaG9zZW4lMjIlNUQlMkMlMjAlMjJyZWplY3RlZCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIycmVqZWN0ZWQlMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF90b19jb21wbGV0aW9ucyUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTIycHJvbXB0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_to_completions</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;chosen&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>], <span class="hljs-string">&quot;rejected&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;rejected&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_to_completions, remove_columns=<span class="hljs-string">&quot;prompt&quot;</span>)`,wrap:!1}}),Cs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),$s=new J({props:{title:"From preference to unpaired preference dataset",local:"from-preference-to-unpaired-preference-dataset",headingTag:"h3"}}),Ns=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBzZWEuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),xs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),Gs=new J({props:{title:"From unpaired preference to language modeling dataset",local:"from-unpaired-preference-to-language-modeling-dataset",headingTag:"h3"}}),vs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdGVuYXRlX3Byb21wdF9jb21wbGV0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydGV4dCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIyY29tcGxldGlvbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRlbmF0ZV9wcm9tcHRfY29tcGxldGlvbikucmVtb3ZlX2NvbHVtbnMoJTVCJTIycHJvbXB0JTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUyQyUyMCUyMmxhYmVsJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concatenate_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concatenate_prompt_completion).remove_columns([<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),As=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),ks=new J({props:{title:"From unpaired preference to prompt-completion dataset",local:"from-unpaired-preference-to-prompt-completion-dataset",headingTag:"h3"}}),Rs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMmxhYmVsJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Xs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),Vs=new J({props:{title:"From unpaired preference to prompt-only dataset",local:"from-unpaired-preference-to-prompt-only-dataset",headingTag:"h3"}}),Ws=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNvbXBsZXRpb24lMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),zs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Ss=new J({props:{title:"Vision datasets",local:"vision-datasets",headingTag:"h2"}}),Ls=new h({props:{code:"JTIzJTIwVGV4dHVhbCUyMGRhdGFzZXQlM0ElMEElMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlMEElMEElMjMlMjBWaXNpb24lMjBkYXRhc2V0JTNBJTBBJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTIwaW4lMjB0aGUlMjBpbWFnZSUzRiUyMiU3RCUwQSU1RA==",highlighted:`<span class="hljs-comment"># Textual dataset:</span>
<span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>

<span class="hljs-comment"># Vision dataset:</span>
<span class="hljs-string">&quot;content&quot;</span>: [
    {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
    {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What color is the sky in the image?&quot;</span>}
]`,wrap:!1}}),Ps=new Rn({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dataset_formats.mdx"}}),{c(){d=u("meta"),f=a(),U=u("p"),T=a(),p(I.$$.fragment),g=a(),b=u("p"),b.textContent=C,m=a(),p(q.$$.fragment),te=a(),k=u("ul"),k.innerHTML=$a,se=a(),Z=u("table"),Z.innerHTML=Qa,ee=a(),p(R.$$.fragment),le=a(),p(X.$$.fragment),ae=a(),V=u("p"),V.textContent=Na,ne=a(),p(E.$$.fragment),pe=a(),p(W.$$.fragment),oe=a(),z=u("p"),z.innerHTML=xa,re=a(),p(S.$$.fragment),ie=a(),_=u("p"),_.innerHTML=Ga,Me=a(),p(F.$$.fragment),ce=a(),Y=u("p"),Y.innerHTML=Ba,ue=a(),p(H.$$.fragment),ye=a(),p(L.$$.fragment),je=a(),D=u("p"),D.innerHTML=va,he=a(),p(P.$$.fragment),me=a(),p(K.$$.fragment),de=a(),O=u("p"),O.innerHTML=Aa,Je=a(),p(tt.$$.fragment),Ue=a(),p(G.$$.fragment),Te=a(),p(st.$$.fragment),ge=a(),et=u("p"),et.innerHTML=ka,qe=a(),p(lt.$$.fragment),Ie=a(),p(at.$$.fragment),fe=a(),nt=u("p"),nt.innerHTML=Za,we=a(),p(pt.$$.fragment),be=a(),ot=u("p"),ot.innerHTML=Ra,Ce=a(),p(rt.$$.fragment),$e=a(),it=u("p"),it.innerHTML=Xa,Qe=a(),p(Mt.$$.fragment),Ne=a(),p(ct.$$.fragment),xe=a(),ut=u("p"),ut.textContent=Va,Ge=a(),yt=u("table"),yt.innerHTML=Ea,Be=a(),p(B.$$.fragment),ve=a(),p(jt.$$.fragment),Ae=a(),ht=u("p"),ht.innerHTML=Wa,ke=a(),p(mt.$$.fragment),Ze=a(),dt=u("p"),dt.textContent=za,Re=a(),Jt=u("p"),Jt.innerHTML=Sa,Xe=a(),Ut=u("p"),Ut.innerHTML=_a,Ve=a(),p(Tt.$$.fragment),Ee=a(),gt=u("p"),gt.innerHTML=Fa,We=a(),p(qt.$$.fragment),ze=a(),p(v.$$.fragment),Se=a(),p(A.$$.fragment),_e=a(),p(It.$$.fragment),Fe=a(),ft=u("p"),ft.textContent=Ya,Ye=a(),wt=u("p"),wt.innerHTML=Ha,He=a(),p(bt.$$.fragment),Le=a(),Ct=u("p"),Ct.innerHTML=La,De=a(),Q=u("iframe"),Pe=a(),$t=u("p"),$t.textContent=Pa,Ke=a(),Qt=u("p"),Qt.innerHTML=Ka,Oe=a(),p(Nt.$$.fragment),tl=a(),xt=u("p"),xt.textContent=Oa,sl=a(),N=u("iframe"),el=a(),Gt=u("p"),Gt.textContent=sn,ll=a(),Bt=u("p"),Bt.textContent=en,al=a(),p(vt.$$.fragment),nl=a(),At=u("p"),At.textContent=ln,pl=a(),kt=u("p"),kt.textContent=an,ol=a(),Zt=u("table"),Zt.innerHTML=nn,rl=a(),p(Rt.$$.fragment),il=a(),Xt=u("p"),Xt.textContent=pn,Ml=a(),p(Vt.$$.fragment),cl=a(),p(Et.$$.fragment),ul=a(),p(Wt.$$.fragment),yl=a(),zt=u("p"),zt.textContent=on,jl=a(),p(St.$$.fragment),hl=a(),p(_t.$$.fragment),ml=a(),p(Ft.$$.fragment),dl=a(),Yt=u("p"),Yt.innerHTML=rn,Jl=a(),p(Ht.$$.fragment),Ul=a(),p(Lt.$$.fragment),Tl=a(),p(Dt.$$.fragment),gl=a(),Pt=u("p"),Pt.innerHTML=Mn,ql=a(),p(Kt.$$.fragment),Il=a(),p(Ot.$$.fragment),fl=a(),p(ts.$$.fragment),wl=a(),ss=u("p"),ss.innerHTML=cn,bl=a(),p(es.$$.fragment),Cl=a(),p(ls.$$.fragment),$l=a(),p(as.$$.fragment),Ql=a(),ns=u("p"),ns.innerHTML=un,Nl=a(),p(ps.$$.fragment),xl=a(),p(os.$$.fragment),Gl=a(),p(rs.$$.fragment),Bl=a(),is=u("p"),is.innerHTML=yn,vl=a(),p(Ms.$$.fragment),Al=a(),p(cs.$$.fragment),kl=a(),p(us.$$.fragment),Zl=a(),ys=u("p"),ys.innerHTML=jn,Rl=a(),p(js.$$.fragment),Xl=a(),p(hs.$$.fragment),Vl=a(),p(ms.$$.fragment),El=a(),ds=u("p"),ds.innerHTML=hn,Wl=a(),p(Js.$$.fragment),zl=a(),p(Us.$$.fragment),Sl=a(),p(Ts.$$.fragment),_l=a(),gs=u("p"),gs.textContent=mn,Fl=a(),p(qs.$$.fragment),Yl=a(),p(Is.$$.fragment),Hl=a(),p(fs.$$.fragment),Ll=a(),ws=u("p"),ws.textContent=dn,Dl=a(),p(bs.$$.fragment),Pl=a(),p(Cs.$$.fragment),Kl=a(),p($s.$$.fragment),Ol=a(),Qs=u("p"),Qs.innerHTML=Jn,ta=a(),p(Ns.$$.fragment),sa=a(),p(xs.$$.fragment),ea=a(),p(Gs.$$.fragment),la=a(),Bs=u("p"),Bs.innerHTML=Un,aa=a(),p(vs.$$.fragment),na=a(),p(As.$$.fragment),pa=a(),p(ks.$$.fragment),oa=a(),Zs=u("p"),Zs.textContent=Tn,ra=a(),p(Rs.$$.fragment),ia=a(),p(Xs.$$.fragment),Ma=a(),p(Vs.$$.fragment),ca=a(),Es=u("p"),Es.textContent=gn,ua=a(),p(Ws.$$.fragment),ya=a(),p(zs.$$.fragment),ja=a(),p(Ss.$$.fragment),ha=a(),_s=u("p"),_s.textContent=qn,ma=a(),Fs=u("p"),Fs.textContent=In,da=a(),Ys=u("ol"),Ys.innerHTML=fn,Ja=a(),Hs=u("p"),Hs.textContent=wn,Ua=a(),p(Ls.$$.fragment),Ta=a(),Ds=u("p"),Ds.innerHTML=bn,ga=a(),x=u("iframe"),qa=a(),p(Ps.$$.fragment),Ia=a(),Ks=u("p"),this.h()},l(t){const s=kn("svelte-u9bgzb",document.head);d=y(s,"META",{name:!0,content:!0}),s.forEach(e),f=n(t),U=y(t,"P",{}),Os(U).forEach(e),T=n(t),o(I.$$.fragment,t),g=n(t),b=y(t,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1976wsu"&&(b.textContent=C),m=n(t),o(q.$$.fragment,t),te=n(t),k=y(t,"UL",{"data-svelte-h":!0}),j(k)!=="svelte-fvfcsu"&&(k.innerHTML=$a),se=n(t),Z=y(t,"TABLE",{"data-svelte-h":!0}),j(Z)!=="svelte-1yhsmnf"&&(Z.innerHTML=Qa),ee=n(t),o(R.$$.fragment,t),le=n(t),o(X.$$.fragment,t),ae=n(t),V=y(t,"P",{"data-svelte-h":!0}),j(V)!=="svelte-n22pbc"&&(V.textContent=Na),ne=n(t),o(E.$$.fragment,t),pe=n(t),o(W.$$.fragment,t),oe=n(t),z=y(t,"P",{"data-svelte-h":!0}),j(z)!=="svelte-ftn6so"&&(z.innerHTML=xa),re=n(t),o(S.$$.fragment,t),ie=n(t),_=y(t,"P",{"data-svelte-h":!0}),j(_)!=="svelte-49qzt0"&&(_.innerHTML=Ga),Me=n(t),o(F.$$.fragment,t),ce=n(t),Y=y(t,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-1de5sg2"&&(Y.innerHTML=Ba),ue=n(t),o(H.$$.fragment,t),ye=n(t),o(L.$$.fragment,t),je=n(t),D=y(t,"P",{"data-svelte-h":!0}),j(D)!=="svelte-zfzona"&&(D.innerHTML=va),he=n(t),o(P.$$.fragment,t),me=n(t),o(K.$$.fragment,t),de=n(t),O=y(t,"P",{"data-svelte-h":!0}),j(O)!=="svelte-1fi7big"&&(O.innerHTML=Aa),Je=n(t),o(tt.$$.fragment,t),Ue=n(t),o(G.$$.fragment,t),Te=n(t),o(st.$$.fragment,t),ge=n(t),et=y(t,"P",{"data-svelte-h":!0}),j(et)!=="svelte-1qh8h3u"&&(et.innerHTML=ka),qe=n(t),o(lt.$$.fragment,t),Ie=n(t),o(at.$$.fragment,t),fe=n(t),nt=y(t,"P",{"data-svelte-h":!0}),j(nt)!=="svelte-fpgtkb"&&(nt.innerHTML=Za),we=n(t),o(pt.$$.fragment,t),be=n(t),ot=y(t,"P",{"data-svelte-h":!0}),j(ot)!=="svelte-144ttmo"&&(ot.innerHTML=Ra),Ce=n(t),o(rt.$$.fragment,t),$e=n(t),it=y(t,"P",{"data-svelte-h":!0}),j(it)!=="svelte-ds3631"&&(it.innerHTML=Xa),Qe=n(t),o(Mt.$$.fragment,t),Ne=n(t),o(ct.$$.fragment,t),xe=n(t),ut=y(t,"P",{"data-svelte-h":!0}),j(ut)!=="svelte-vrn817"&&(ut.textContent=Va),Ge=n(t),yt=y(t,"TABLE",{"data-svelte-h":!0}),j(yt)!=="svelte-1gmsf36"&&(yt.innerHTML=Ea),Be=n(t),o(B.$$.fragment,t),ve=n(t),o(jt.$$.fragment,t),Ae=n(t),ht=y(t,"P",{"data-svelte-h":!0}),j(ht)!=="svelte-6ryxrp"&&(ht.innerHTML=Wa),ke=n(t),o(mt.$$.fragment,t),Ze=n(t),dt=y(t,"P",{"data-svelte-h":!0}),j(dt)!=="svelte-1gfjzu"&&(dt.textContent=za),Re=n(t),Jt=y(t,"P",{"data-svelte-h":!0}),j(Jt)!=="svelte-19t1v1h"&&(Jt.innerHTML=Sa),Xe=n(t),Ut=y(t,"P",{"data-svelte-h":!0}),j(Ut)!=="svelte-s4gemw"&&(Ut.innerHTML=_a),Ve=n(t),o(Tt.$$.fragment,t),Ee=n(t),gt=y(t,"P",{"data-svelte-h":!0}),j(gt)!=="svelte-yoytwl"&&(gt.innerHTML=Fa),We=n(t),o(qt.$$.fragment,t),ze=n(t),o(v.$$.fragment,t),Se=n(t),o(A.$$.fragment,t),_e=n(t),o(It.$$.fragment,t),Fe=n(t),ft=y(t,"P",{"data-svelte-h":!0}),j(ft)!=="svelte-n0cp2u"&&(ft.textContent=Ya),Ye=n(t),wt=y(t,"P",{"data-svelte-h":!0}),j(wt)!=="svelte-wbjjp8"&&(wt.innerHTML=Ha),He=n(t),o(bt.$$.fragment,t),Le=n(t),Ct=y(t,"P",{"data-svelte-h":!0}),j(Ct)!=="svelte-dr0jz6"&&(Ct.innerHTML=La),De=n(t),Q=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Os(Q).forEach(e),Pe=n(t),$t=y(t,"P",{"data-svelte-h":!0}),j($t)!=="svelte-1f6n8q4"&&($t.textContent=Pa),Ke=n(t),Qt=y(t,"P",{"data-svelte-h":!0}),j(Qt)!=="svelte-17l9hcf"&&(Qt.innerHTML=Ka),Oe=n(t),o(Nt.$$.fragment,t),tl=n(t),xt=y(t,"P",{"data-svelte-h":!0}),j(xt)!=="svelte-hplhuu"&&(xt.textContent=Oa),sl=n(t),N=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Os(N).forEach(e),el=n(t),Gt=y(t,"P",{"data-svelte-h":!0}),j(Gt)!=="svelte-jt9cd3"&&(Gt.textContent=sn),ll=n(t),Bt=y(t,"P",{"data-svelte-h":!0}),j(Bt)!=="svelte-1rvlfj0"&&(Bt.textContent=en),al=n(t),o(vt.$$.fragment,t),nl=n(t),At=y(t,"P",{"data-svelte-h":!0}),j(At)!=="svelte-1ttdd1s"&&(At.textContent=ln),pl=n(t),kt=y(t,"P",{"data-svelte-h":!0}),j(kt)!=="svelte-17l70ga"&&(kt.textContent=an),ol=n(t),Zt=y(t,"TABLE",{"data-svelte-h":!0}),j(Zt)!=="svelte-1a5ldcp"&&(Zt.innerHTML=nn),rl=n(t),o(Rt.$$.fragment,t),il=n(t),Xt=y(t,"P",{"data-svelte-h":!0}),j(Xt)!=="svelte-q88m1s"&&(Xt.textContent=pn),Ml=n(t),o(Vt.$$.fragment,t),cl=n(t),o(Et.$$.fragment,t),ul=n(t),o(Wt.$$.fragment,t),yl=n(t),zt=y(t,"P",{"data-svelte-h":!0}),j(zt)!=="svelte-dplhkb"&&(zt.textContent=on),jl=n(t),o(St.$$.fragment,t),hl=n(t),o(_t.$$.fragment,t),ml=n(t),o(Ft.$$.fragment,t),dl=n(t),Yt=y(t,"P",{"data-svelte-h":!0}),j(Yt)!=="svelte-u8pmva"&&(Yt.innerHTML=rn),Jl=n(t),o(Ht.$$.fragment,t),Ul=n(t),o(Lt.$$.fragment,t),Tl=n(t),o(Dt.$$.fragment,t),gl=n(t),Pt=y(t,"P",{"data-svelte-h":!0}),j(Pt)!=="svelte-3phxny"&&(Pt.innerHTML=Mn),ql=n(t),o(Kt.$$.fragment,t),Il=n(t),o(Ot.$$.fragment,t),fl=n(t),o(ts.$$.fragment,t),wl=n(t),ss=y(t,"P",{"data-svelte-h":!0}),j(ss)!=="svelte-e0qc38"&&(ss.innerHTML=cn),bl=n(t),o(es.$$.fragment,t),Cl=n(t),o(ls.$$.fragment,t),$l=n(t),o(as.$$.fragment,t),Ql=n(t),ns=y(t,"P",{"data-svelte-h":!0}),j(ns)!=="svelte-21pxgk"&&(ns.innerHTML=un),Nl=n(t),o(ps.$$.fragment,t),xl=n(t),o(os.$$.fragment,t),Gl=n(t),o(rs.$$.fragment,t),Bl=n(t),is=y(t,"P",{"data-svelte-h":!0}),j(is)!=="svelte-19t9hfm"&&(is.innerHTML=yn),vl=n(t),o(Ms.$$.fragment,t),Al=n(t),o(cs.$$.fragment,t),kl=n(t),o(us.$$.fragment,t),Zl=n(t),ys=y(t,"P",{"data-svelte-h":!0}),j(ys)!=="svelte-1azgh8u"&&(ys.innerHTML=jn),Rl=n(t),o(js.$$.fragment,t),Xl=n(t),o(hs.$$.fragment,t),Vl=n(t),o(ms.$$.fragment,t),El=n(t),ds=y(t,"P",{"data-svelte-h":!0}),j(ds)!=="svelte-thhn9e"&&(ds.innerHTML=hn),Wl=n(t),o(Js.$$.fragment,t),zl=n(t),o(Us.$$.fragment,t),Sl=n(t),o(Ts.$$.fragment,t),_l=n(t),gs=y(t,"P",{"data-svelte-h":!0}),j(gs)!=="svelte-yu2uu5"&&(gs.textContent=mn),Fl=n(t),o(qs.$$.fragment,t),Yl=n(t),o(Is.$$.fragment,t),Hl=n(t),o(fs.$$.fragment,t),Ll=n(t),ws=y(t,"P",{"data-svelte-h":!0}),j(ws)!=="svelte-slr0da"&&(ws.textContent=dn),Dl=n(t),o(bs.$$.fragment,t),Pl=n(t),o(Cs.$$.fragment,t),Kl=n(t),o($s.$$.fragment,t),Ol=n(t),Qs=y(t,"P",{"data-svelte-h":!0}),j(Qs)!=="svelte-12ab0gt"&&(Qs.innerHTML=Jn),ta=n(t),o(Ns.$$.fragment,t),sa=n(t),o(xs.$$.fragment,t),ea=n(t),o(Gs.$$.fragment,t),la=n(t),Bs=y(t,"P",{"data-svelte-h":!0}),j(Bs)!=="svelte-jxvlnn"&&(Bs.innerHTML=Un),aa=n(t),o(vs.$$.fragment,t),na=n(t),o(As.$$.fragment,t),pa=n(t),o(ks.$$.fragment,t),oa=n(t),Zs=y(t,"P",{"data-svelte-h":!0}),j(Zs)!=="svelte-1gh6vos"&&(Zs.textContent=Tn),ra=n(t),o(Rs.$$.fragment,t),ia=n(t),o(Xs.$$.fragment,t),Ma=n(t),o(Vs.$$.fragment,t),ca=n(t),Es=y(t,"P",{"data-svelte-h":!0}),j(Es)!=="svelte-1x58tju"&&(Es.textContent=gn),ua=n(t),o(Ws.$$.fragment,t),ya=n(t),o(zs.$$.fragment,t),ja=n(t),o(Ss.$$.fragment,t),ha=n(t),_s=y(t,"P",{"data-svelte-h":!0}),j(_s)!=="svelte-1f2j4bf"&&(_s.textContent=qn),ma=n(t),Fs=y(t,"P",{"data-svelte-h":!0}),j(Fs)!=="svelte-1dkity6"&&(Fs.textContent=In),da=n(t),Ys=y(t,"OL",{"data-svelte-h":!0}),j(Ys)!=="svelte-imd92t"&&(Ys.innerHTML=fn),Ja=n(t),Hs=y(t,"P",{"data-svelte-h":!0}),j(Hs)!=="svelte-11lpom8"&&(Hs.textContent=wn),Ua=n(t),o(Ls.$$.fragment,t),Ta=n(t),Ds=y(t,"P",{"data-svelte-h":!0}),j(Ds)!=="svelte-11ot8l1"&&(Ds.innerHTML=bn),ga=n(t),x=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Os(x).forEach(e),qa=n(t),o(Ps.$$.fragment,t),Ia=n(t),Ks=y(t,"P",{}),Os(Ks).forEach(e),this.h()},h(){w(d,"name","hf:doc:metadata"),w(d,"content",Sn),Ca(Q.src,Da="https://huggingface.co/datasets/openbmb/UltraFeedback/embed/viewer/default/train")||w(Q,"src",Da),w(Q,"frameborder","0"),w(Q,"width","100%"),w(Q,"height","560px"),Ca(N.src,tn="https://huggingface.co/datasets/trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness/embed/viewer/default/train?row=0")||w(N,"src",tn),w(N,"frameborder","0"),w(N,"width","100%"),w(N,"height","560px"),Ca(x.src,Cn="https://huggingface.co/datasets/trl-lib/rlaif-v/embed/viewer/default/train")||w(x,"src",Cn),w(x,"frameborder","0"),w(x,"width","100%"),w(x,"height","560px")},m(t,s){Zn(document.head,d),l(t,f,s),l(t,U,s),l(t,T,s),r(I,t,s),l(t,g,s),l(t,b,s),l(t,m,s),r(q,t,s),l(t,te,s),l(t,k,s),l(t,se,s),l(t,Z,s),l(t,ee,s),r(R,t,s),l(t,le,s),r(X,t,s),l(t,ae,s),l(t,V,s),l(t,ne,s),r(E,t,s),l(t,pe,s),r(W,t,s),l(t,oe,s),l(t,z,s),l(t,re,s),r(S,t,s),l(t,ie,s),l(t,_,s),l(t,Me,s),r(F,t,s),l(t,ce,s),l(t,Y,s),l(t,ue,s),r(H,t,s),l(t,ye,s),r(L,t,s),l(t,je,s),l(t,D,s),l(t,he,s),r(P,t,s),l(t,me,s),r(K,t,s),l(t,de,s),l(t,O,s),l(t,Je,s),r(tt,t,s),l(t,Ue,s),r(G,t,s),l(t,Te,s),r(st,t,s),l(t,ge,s),l(t,et,s),l(t,qe,s),r(lt,t,s),l(t,Ie,s),r(at,t,s),l(t,fe,s),l(t,nt,s),l(t,we,s),r(pt,t,s),l(t,be,s),l(t,ot,s),l(t,Ce,s),r(rt,t,s),l(t,$e,s),l(t,it,s),l(t,Qe,s),r(Mt,t,s),l(t,Ne,s),r(ct,t,s),l(t,xe,s),l(t,ut,s),l(t,Ge,s),l(t,yt,s),l(t,Be,s),r(B,t,s),l(t,ve,s),r(jt,t,s),l(t,Ae,s),l(t,ht,s),l(t,ke,s),r(mt,t,s),l(t,Ze,s),l(t,dt,s),l(t,Re,s),l(t,Jt,s),l(t,Xe,s),l(t,Ut,s),l(t,Ve,s),r(Tt,t,s),l(t,Ee,s),l(t,gt,s),l(t,We,s),r(qt,t,s),l(t,ze,s),r(v,t,s),l(t,Se,s),r(A,t,s),l(t,_e,s),r(It,t,s),l(t,Fe,s),l(t,ft,s),l(t,Ye,s),l(t,wt,s),l(t,He,s),r(bt,t,s),l(t,Le,s),l(t,Ct,s),l(t,De,s),l(t,Q,s),l(t,Pe,s),l(t,$t,s),l(t,Ke,s),l(t,Qt,s),l(t,Oe,s),r(Nt,t,s),l(t,tl,s),l(t,xt,s),l(t,sl,s),l(t,N,s),l(t,el,s),l(t,Gt,s),l(t,ll,s),l(t,Bt,s),l(t,al,s),r(vt,t,s),l(t,nl,s),l(t,At,s),l(t,pl,s),l(t,kt,s),l(t,ol,s),l(t,Zt,s),l(t,rl,s),r(Rt,t,s),l(t,il,s),l(t,Xt,s),l(t,Ml,s),r(Vt,t,s),l(t,cl,s),r(Et,t,s),l(t,ul,s),r(Wt,t,s),l(t,yl,s),l(t,zt,s),l(t,jl,s),r(St,t,s),l(t,hl,s),r(_t,t,s),l(t,ml,s),r(Ft,t,s),l(t,dl,s),l(t,Yt,s),l(t,Jl,s),r(Ht,t,s),l(t,Ul,s),r(Lt,t,s),l(t,Tl,s),r(Dt,t,s),l(t,gl,s),l(t,Pt,s),l(t,ql,s),r(Kt,t,s),l(t,Il,s),r(Ot,t,s),l(t,fl,s),r(ts,t,s),l(t,wl,s),l(t,ss,s),l(t,bl,s),r(es,t,s),l(t,Cl,s),r(ls,t,s),l(t,$l,s),r(as,t,s),l(t,Ql,s),l(t,ns,s),l(t,Nl,s),r(ps,t,s),l(t,xl,s),r(os,t,s),l(t,Gl,s),r(rs,t,s),l(t,Bl,s),l(t,is,s),l(t,vl,s),r(Ms,t,s),l(t,Al,s),r(cs,t,s),l(t,kl,s),r(us,t,s),l(t,Zl,s),l(t,ys,s),l(t,Rl,s),r(js,t,s),l(t,Xl,s),r(hs,t,s),l(t,Vl,s),r(ms,t,s),l(t,El,s),l(t,ds,s),l(t,Wl,s),r(Js,t,s),l(t,zl,s),r(Us,t,s),l(t,Sl,s),r(Ts,t,s),l(t,_l,s),l(t,gs,s),l(t,Fl,s),r(qs,t,s),l(t,Yl,s),r(Is,t,s),l(t,Hl,s),r(fs,t,s),l(t,Ll,s),l(t,ws,s),l(t,Dl,s),r(bs,t,s),l(t,Pl,s),r(Cs,t,s),l(t,Kl,s),r($s,t,s),l(t,Ol,s),l(t,Qs,s),l(t,ta,s),r(Ns,t,s),l(t,sa,s),r(xs,t,s),l(t,ea,s),r(Gs,t,s),l(t,la,s),l(t,Bs,s),l(t,aa,s),r(vs,t,s),l(t,na,s),r(As,t,s),l(t,pa,s),r(ks,t,s),l(t,oa,s),l(t,Zs,s),l(t,ra,s),r(Rs,t,s),l(t,ia,s),r(Xs,t,s),l(t,Ma,s),r(Vs,t,s),l(t,ca,s),l(t,Es,s),l(t,ua,s),r(Ws,t,s),l(t,ya,s),r(zs,t,s),l(t,ja,s),r(Ss,t,s),l(t,ha,s),l(t,_s,s),l(t,ma,s),l(t,Fs,s),l(t,da,s),l(t,Ys,s),l(t,Ja,s),l(t,Hs,s),l(t,Ua,s),r(Ls,t,s),l(t,Ta,s),l(t,Ds,s),l(t,ga,s),l(t,x,s),l(t,qa,s),r(Ps,t,s),l(t,Ia,s),l(t,Ks,s),fa=!0},p(t,[s]){const $n={};s&2&&($n.$$scope={dirty:s,ctx:t}),G.$set($n);const Qn={};s&2&&(Qn.$$scope={dirty:s,ctx:t}),B.$set(Qn);const Nn={};s&2&&(Nn.$$scope={dirty:s,ctx:t}),v.$set(Nn);const xn={};s&2&&(xn.$$scope={dirty:s,ctx:t}),A.$set(xn)},i(t){fa||(i(I.$$.fragment,t),i(q.$$.fragment,t),i(R.$$.fragment,t),i(X.$$.fragment,t),i(E.$$.fragment,t),i(W.$$.fragment,t),i(S.$$.fragment,t),i(F.$$.fragment,t),i(H.$$.fragment,t),i(L.$$.fragment,t),i(P.$$.fragment,t),i(K.$$.fragment,t),i(tt.$$.fragment,t),i(G.$$.fragment,t),i(st.$$.fragment,t),i(lt.$$.fragment,t),i(at.$$.fragment,t),i(pt.$$.fragment,t),i(rt.$$.fragment,t),i(Mt.$$.fragment,t),i(ct.$$.fragment,t),i(B.$$.fragment,t),i(jt.$$.fragment,t),i(mt.$$.fragment,t),i(Tt.$$.fragment,t),i(qt.$$.fragment,t),i(v.$$.fragment,t),i(A.$$.fragment,t),i(It.$$.fragment,t),i(bt.$$.fragment,t),i(Nt.$$.fragment,t),i(vt.$$.fragment,t),i(Rt.$$.fragment,t),i(Vt.$$.fragment,t),i(Et.$$.fragment,t),i(Wt.$$.fragment,t),i(St.$$.fragment,t),i(_t.$$.fragment,t),i(Ft.$$.fragment,t),i(Ht.$$.fragment,t),i(Lt.$$.fragment,t),i(Dt.$$.fragment,t),i(Kt.$$.fragment,t),i(Ot.$$.fragment,t),i(ts.$$.fragment,t),i(es.$$.fragment,t),i(ls.$$.fragment,t),i(as.$$.fragment,t),i(ps.$$.fragment,t),i(os.$$.fragment,t),i(rs.$$.fragment,t),i(Ms.$$.fragment,t),i(cs.$$.fragment,t),i(us.$$.fragment,t),i(js.$$.fragment,t),i(hs.$$.fragment,t),i(ms.$$.fragment,t),i(Js.$$.fragment,t),i(Us.$$.fragment,t),i(Ts.$$.fragment,t),i(qs.$$.fragment,t),i(Is.$$.fragment,t),i(fs.$$.fragment,t),i(bs.$$.fragment,t),i(Cs.$$.fragment,t),i($s.$$.fragment,t),i(Ns.$$.fragment,t),i(xs.$$.fragment,t),i(Gs.$$.fragment,t),i(vs.$$.fragment,t),i(As.$$.fragment,t),i(ks.$$.fragment,t),i(Rs.$$.fragment,t),i(Xs.$$.fragment,t),i(Vs.$$.fragment,t),i(Ws.$$.fragment,t),i(zs.$$.fragment,t),i(Ss.$$.fragment,t),i(Ls.$$.fragment,t),i(Ps.$$.fragment,t),fa=!0)},o(t){M(I.$$.fragment,t),M(q.$$.fragment,t),M(R.$$.fragment,t),M(X.$$.fragment,t),M(E.$$.fragment,t),M(W.$$.fragment,t),M(S.$$.fragment,t),M(F.$$.fragment,t),M(H.$$.fragment,t),M(L.$$.fragment,t),M(P.$$.fragment,t),M(K.$$.fragment,t),M(tt.$$.fragment,t),M(G.$$.fragment,t),M(st.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(ct.$$.fragment,t),M(B.$$.fragment,t),M(jt.$$.fragment,t),M(mt.$$.fragment,t),M(Tt.$$.fragment,t),M(qt.$$.fragment,t),M(v.$$.fragment,t),M(A.$$.fragment,t),M(It.$$.fragment,t),M(bt.$$.fragment,t),M(Nt.$$.fragment,t),M(vt.$$.fragment,t),M(Rt.$$.fragment,t),M(Vt.$$.fragment,t),M(Et.$$.fragment,t),M(Wt.$$.fragment,t),M(St.$$.fragment,t),M(_t.$$.fragment,t),M(Ft.$$.fragment,t),M(Ht.$$.fragment,t),M(Lt.$$.fragment,t),M(Dt.$$.fragment,t),M(Kt.$$.fragment,t),M(Ot.$$.fragment,t),M(ts.$$.fragment,t),M(es.$$.fragment,t),M(ls.$$.fragment,t),M(as.$$.fragment,t),M(ps.$$.fragment,t),M(os.$$.fragment,t),M(rs.$$.fragment,t),M(Ms.$$.fragment,t),M(cs.$$.fragment,t),M(us.$$.fragment,t),M(js.$$.fragment,t),M(hs.$$.fragment,t),M(ms.$$.fragment,t),M(Js.$$.fragment,t),M(Us.$$.fragment,t),M(Ts.$$.fragment,t),M(qs.$$.fragment,t),M(Is.$$.fragment,t),M(fs.$$.fragment,t),M(bs.$$.fragment,t),M(Cs.$$.fragment,t),M($s.$$.fragment,t),M(Ns.$$.fragment,t),M(xs.$$.fragment,t),M(Gs.$$.fragment,t),M(vs.$$.fragment,t),M(As.$$.fragment,t),M(ks.$$.fragment,t),M(Rs.$$.fragment,t),M(Xs.$$.fragment,t),M(Vs.$$.fragment,t),M(Ws.$$.fragment,t),M(zs.$$.fragment,t),M(Ss.$$.fragment,t),M(Ls.$$.fragment,t),M(Ps.$$.fragment,t),fa=!1},d(t){t&&(e(f),e(U),e(T),e(g),e(b),e(m),e(te),e(k),e(se),e(Z),e(ee),e(le),e(ae),e(V),e(ne),e(pe),e(oe),e(z),e(re),e(ie),e(_),e(Me),e(ce),e(Y),e(ue),e(ye),e(je),e(D),e(he),e(me),e(de),e(O),e(Je),e(Ue),e(Te),e(ge),e(et),e(qe),e(Ie),e(fe),e(nt),e(we),e(be),e(ot),e(Ce),e($e),e(it),e(Qe),e(Ne),e(xe),e(ut),e(Ge),e(yt),e(Be),e(ve),e(Ae),e(ht),e(ke),e(Ze),e(dt),e(Re),e(Jt),e(Xe),e(Ut),e(Ve),e(Ee),e(gt),e(We),e(ze),e(Se),e(_e),e(Fe),e(ft),e(Ye),e(wt),e(He),e(Le),e(Ct),e(De),e(Q),e(Pe),e($t),e(Ke),e(Qt),e(Oe),e(tl),e(xt),e(sl),e(N),e(el),e(Gt),e(ll),e(Bt),e(al),e(nl),e(At),e(pl),e(kt),e(ol),e(Zt),e(rl),e(il),e(Xt),e(Ml),e(cl),e(ul),e(yl),e(zt),e(jl),e(hl),e(ml),e(dl),e(Yt),e(Jl),e(Ul),e(Tl),e(gl),e(Pt),e(ql),e(Il),e(fl),e(wl),e(ss),e(bl),e(Cl),e($l),e(Ql),e(ns),e(Nl),e(xl),e(Gl),e(Bl),e(is),e(vl),e(Al),e(kl),e(Zl),e(ys),e(Rl),e(Xl),e(Vl),e(El),e(ds),e(Wl),e(zl),e(Sl),e(_l),e(gs),e(Fl),e(Yl),e(Hl),e(Ll),e(ws),e(Dl),e(Pl),e(Kl),e(Ol),e(Qs),e(ta),e(sa),e(ea),e(la),e(Bs),e(aa),e(na),e(pa),e(oa),e(Zs),e(ra),e(ia),e(Ma),e(ca),e(Es),e(ua),e(ya),e(ja),e(ha),e(_s),e(ma),e(Fs),e(da),e(Ys),e(Ja),e(Hs),e(Ua),e(Ta),e(Ds),e(ga),e(x),e(qa),e(Ia),e(Ks)),e(d),c(I,t),c(q,t),c(R,t),c(X,t),c(E,t),c(W,t),c(S,t),c(F,t),c(H,t),c(L,t),c(P,t),c(K,t),c(tt,t),c(G,t),c(st,t),c(lt,t),c(at,t),c(pt,t),c(rt,t),c(Mt,t),c(ct,t),c(B,t),c(jt,t),c(mt,t),c(Tt,t),c(qt,t),c(v,t),c(A,t),c(It,t),c(bt,t),c(Nt,t),c(vt,t),c(Rt,t),c(Vt,t),c(Et,t),c(Wt,t),c(St,t),c(_t,t),c(Ft,t),c(Ht,t),c(Lt,t),c(Dt,t),c(Kt,t),c(Ot,t),c(ts,t),c(es,t),c(ls,t),c(as,t),c(ps,t),c(os,t),c(rs,t),c(Ms,t),c(cs,t),c(us,t),c(js,t),c(hs,t),c(ms,t),c(Js,t),c(Us,t),c(Ts,t),c(qs,t),c(Is,t),c(fs,t),c(bs,t),c(Cs,t),c($s,t),c(Ns,t),c(xs,t),c(Gs,t),c(vs,t),c(As,t),c(ks,t),c(Rs,t),c(Xs,t),c(Vs,t),c(Ws,t),c(zs,t),c(Ss,t),c(Ls,t),c(Ps,t)}}}const Sn='{"title":"Dataset formats and types","local":"dataset-formats-and-types","sections":[{"title":"Overview of the dataset formats and types","local":"overview-of-the-dataset-formats-and-types","sections":[{"title":"Formats","local":"formats","sections":[{"title":"Standard","local":"standard","sections":[],"depth":4},{"title":"Conversational","local":"conversational","sections":[],"depth":4}],"depth":3},{"title":"Types","local":"types","sections":[{"title":"Language modeling","local":"language-modeling","sections":[],"depth":4},{"title":"Prompt-only","local":"prompt-only","sections":[],"depth":4},{"title":"Prompt-completion","local":"prompt-completion","sections":[],"depth":4},{"title":"Preference","local":"preference","sections":[],"depth":4},{"title":"Unpaired preference","local":"unpaired-preference","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Which dataset type to use?","local":"which-dataset-type-to-use","sections":[],"depth":2},{"title":"Working with conversational datasets in TRL","local":"working-with-conversational-datasets-in-trl","sections":[{"title":"Converting a conversational dataset into a standard dataset","local":"converting-a-conversational-dataset-into-a-standard-dataset","sections":[],"depth":3}],"depth":2},{"title":"Using any dataset with TRL: preprocessing and conversion","local":"using-any-dataset-with-trl-preprocessing-and-conversion","sections":[{"title":"Example: UltraFeedback dataset","local":"example-ultrafeedback-dataset","sections":[],"depth":3}],"depth":2},{"title":"Utilities for converting dataset types","local":"utilities-for-converting-dataset-types","sections":[{"title":"From prompt-completion to language modeling dataset","local":"from-prompt-completion-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From prompt-completion to prompt-only dataset","local":"from-prompt-completion-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to language modeling dataset","local":"from-preference-with-implicit-prompt-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-completion dataset","local":"from-preference-with-implicit-prompt-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-only dataset","local":"from-preference-with-implicit-prompt-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From implicit to explicit prompt preference dataset","local":"from-implicit-to-explicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to unpaired preference dataset","local":"from-preference-with-implicit-prompt-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From preference to language modeling dataset","local":"from-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference to prompt-completion dataset","local":"from-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference to prompt-only dataset","local":"from-preference-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From explicit to implicit prompt preference dataset","local":"from-explicit-to-implicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference to unpaired preference dataset","local":"from-preference-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From unpaired preference to language modeling dataset","local":"from-unpaired-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-completion dataset","local":"from-unpaired-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-only dataset","local":"from-unpaired-preference-to-prompt-only-dataset","sections":[],"depth":3}],"depth":2},{"title":"Vision datasets","local":"vision-datasets","sections":[],"depth":2}],"depth":1}';function _n($){return Bn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends vn{constructor(d){super(),An(this,d,_n,zn,Gn,{})}}export{Pn as component};
