import{s as we,o as be,n as ye}from"../chunks/scheduler.182ea377.js";import{S as Te,i as je,g as p,s as l,r as T,A as Je,h as m,f as n,c as r,j as N,u as j,x as y,k as Y,y as g,a as s,v as J,d as P,t as U,w as I}from"../chunks/index.abf12888.js";import{T as Pe}from"../chunks/Tip.230e2334.js";import{D as pe}from"../chunks/Docstring.93f6f462.js";import{C as Ue}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ie}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as me}from"../chunks/Heading.16916d63.js";function ve(B){let a,_='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=p("p"),a.innerHTML=_},l(o){a=m(o,"P",{"data-svelte-h":!0}),y(a)!=="svelte-1wmc0l4"&&(a.innerHTML=_)},m(o,c){s(o,a,c)},p:ye,d(o){o&&n(a)}}}function $e(B){let a,_="Example:",o,c,u;return c=new Ue({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> RePaintPipeline, RePaintScheduler


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/celeba_hq_256.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/mask_256.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the original image and the mask as PIL images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>original_image = download_image(img_url).resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = download_image(mask_url).resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the RePaint scheduler and pipeline based on a pretrained DDPM model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = RePaintScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-ema-celebahq-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = RePaintPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-ema-celebahq-256&quot;</span>, scheduler=scheduler)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=original_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">250</span>,
<span class="hljs-meta">... </span>    eta=<span class="hljs-number">0.0</span>,
<span class="hljs-meta">... </span>    jump_length=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    jump_n_sample=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpainted_image = output.images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=p("p"),a.textContent=_,o=l(),T(c.$$.fragment)},l(i){a=m(i,"P",{"data-svelte-h":!0}),y(a)!=="svelte-11lpom8"&&(a.textContent=_),o=r(i),j(c.$$.fragment,i)},m(i,f){s(i,a,f),s(i,o,f),J(c,i,f),u=!0},p:ye,i(i){u||(P(c.$$.fragment,i),u=!0)},o(i){U(c.$$.fragment,i),u=!1},d(i){i&&(n(a),n(o)),I(c,i)}}}function ke(B){let a,_,o,c,u,i,f,ce='<a href="https://huggingface.co/papers/2201.09865" rel="nofollow">RePaint: Inpainting using Denoising Diffusion Probabilistic Models</a> is by Andreas Lugmayr, Martin Danelljan, Andres Romero, Fisher Yu, Radu Timofte, Luc Van Gool.',F,k,de="The abstract from the paper is:",z,R,ue=`<em>Free-form inpainting is the task of adding new content to an image in the regions specified by an arbitrary binary mask. Most existing approaches train for a certain distribution of masks, which limits their generalization capabilities to unseen mask types. Furthermore, training with pixel-wise and perceptual losses often leads to simple textural extensions towards the missing areas instead of semantically meaningful generation. In this work, we propose RePaint: A Denoising Diffusion Probabilistic Model (DDPM) based inpainting approach that is applicable to even extreme masks. We employ a pretrained unconditional DDPM as the generative prior. To condition the generation process, we only alter the reverse diffusion iterations by sampling the unmasked regions using the given image information. Since this technique does not modify or condition the original DDPM network itself, the model produces high-quality and diverse output images for any inpainting form. We validate our method for both faces and general-purpose image inpainting using standard and extreme masks.
RePaint outperforms state-of-the-art Autoregressive, and GAN approaches for at least five out of six mask distributions.</em>`,H,W,ge='The original codebase can be found at <a href="https://github.com/andreas128/RePaint" rel="nofollow">andreas128/RePaint</a>.',Q,v,q,x,A,d,Z,ae,L,fe="Pipeline for image inpainting using RePaint.",se,S,he=`This model inherits from <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ie,M,C,le,E,_e="The call function to the pipeline for generation.",re,$,O,G,K,w,V,oe,X,Me="Output class for image pipelines.",ee,D,te;return u=new me({props:{title:"RePaint",local:"repaint",headingTag:"h1"}}),v=new Pe({props:{$$slots:{default:[ve]},$$scope:{ctx:B}}}),x=new me({props:{title:"RePaintPipeline",local:"diffusers.RePaintPipeline",headingTag:"h2"}}),Z=new pe({props:{name:"class diffusers.RePaintPipeline",anchor:"diffusers.RePaintPipeline",parameters:[{name:"unet",val:""},{name:"scheduler",val:""}],parametersDescription:[{anchor:"diffusers.RePaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.1/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>) &#x2014;
A <code>UNet2DModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.RePaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.1/en/api/schedulers/repaint#diffusers.RePaintScheduler">RePaintScheduler</a>) &#x2014;
A <code>RePaintScheduler</code> to be used in combination with <code>unet</code> to denoise the encoded image.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/repaint/pipeline_repaint.py#L76"}}),C=new pe({props:{name:"__call__",anchor:"diffusers.RePaintPipeline.__call__",parameters:[{name:"image",val:": typing.Union[torch.Tensor, PIL.Image.Image]"},{name:"mask_image",val:": typing.Union[torch.Tensor, PIL.Image.Image]"},{name:"num_inference_steps",val:": int = 250"},{name:"eta",val:": float = 0.0"},{name:"jump_length",val:": int = 10"},{name:"jump_n_sample",val:": int = 10"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.RePaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code>) &#x2014;
The original image to inpaint on.`,name:"image"},{anchor:"diffusers.RePaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code>) &#x2014;
The mask_image where 0.0 define which part of the original image to inpaint.`,name:"mask_image"},{anchor:"diffusers.RePaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1000) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.RePaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>) &#x2014;
The weight of the added noise in a diffusion step. Its value is between 0.0 and 1.0; 0.0 corresponds to
DDIM and 1.0 is the DDPM scheduler.`,name:"eta"},{anchor:"diffusers.RePaintPipeline.__call__.jump_length",description:`<strong>jump_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The number of steps taken forward in time before going backward in time for a single jump (&#x201C;j&#x201D; in
RePaint paper). Take a look at Figure 9 and 10 in the <a href="https://arxiv.org/pdf/2201.09865.pdf" rel="nofollow">paper</a>.`,name:"jump_length"},{anchor:"diffusers.RePaintPipeline.__call__.jump_n_sample",description:`<strong>jump_n_sample</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The number of times to make a forward time jump for a given chosen time sample. Take a look at Figure 9
and 10 in the <a href="https://arxiv.org/pdf/2201.09865.pdf" rel="nofollow">paper</a>.`,name:"jump_n_sample"},{anchor:"diffusers.RePaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.RePaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <code>optional</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.RePaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/repaint/pipeline_repaint.py#L98",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),$=new Ie({props:{anchor:"diffusers.RePaintPipeline.__call__.example",$$slots:{default:[$e]},$$scope:{ctx:B}}}),G=new me({props:{title:"ImagePipelineOutput",local:"diffusers.ImagePipelineOutput",headingTag:"h2"}}),V=new pe({props:{name:"class diffusers.ImagePipelineOutput",anchor:"diffusers.ImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.ImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.1/src/diffusers/pipelines/pipeline_utils.py#L110"}}),{c(){a=p("meta"),_=l(),o=p("p"),c=l(),T(u.$$.fragment),i=l(),f=p("p"),f.innerHTML=ce,F=l(),k=p("p"),k.textContent=de,z=l(),R=p("p"),R.innerHTML=ue,H=l(),W=p("p"),W.innerHTML=ge,Q=l(),T(v.$$.fragment),q=l(),T(x.$$.fragment),A=l(),d=p("div"),T(Z.$$.fragment),ae=l(),L=p("p"),L.textContent=fe,se=l(),S=p("p"),S.innerHTML=he,ie=l(),M=p("div"),T(C.$$.fragment),le=l(),E=p("p"),E.textContent=_e,re=l(),T($.$$.fragment),O=l(),T(G.$$.fragment),K=l(),w=p("div"),T(V.$$.fragment),oe=l(),X=p("p"),X.textContent=Me,ee=l(),D=p("p"),this.h()},l(e){const t=Je("svelte-u9bgzb",document.head);a=m(t,"META",{name:!0,content:!0}),t.forEach(n),_=r(e),o=m(e,"P",{}),N(o).forEach(n),c=r(e),j(u.$$.fragment,e),i=r(e),f=m(e,"P",{"data-svelte-h":!0}),y(f)!=="svelte-166nark"&&(f.innerHTML=ce),F=r(e),k=m(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1cwsb16"&&(k.textContent=de),z=r(e),R=m(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1i307wn"&&(R.innerHTML=ue),H=r(e),W=m(e,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1ah6n3"&&(W.innerHTML=ge),Q=r(e),j(v.$$.fragment,e),q=r(e),j(x.$$.fragment,e),A=r(e),d=m(e,"DIV",{class:!0});var h=N(d);j(Z.$$.fragment,h),ae=r(h),L=m(h,"P",{"data-svelte-h":!0}),y(L)!=="svelte-2ooowa"&&(L.textContent=fe),se=r(h),S=m(h,"P",{"data-svelte-h":!0}),y(S)!=="svelte-cys7ny"&&(S.innerHTML=he),ie=r(h),M=m(h,"DIV",{class:!0});var b=N(M);j(C.$$.fragment,b),le=r(b),E=m(b,"P",{"data-svelte-h":!0}),y(E)!=="svelte-50j04k"&&(E.textContent=_e),re=r(b),j($.$$.fragment,b),b.forEach(n),h.forEach(n),O=r(e),j(G.$$.fragment,e),K=r(e),w=m(e,"DIV",{class:!0});var ne=N(w);j(V.$$.fragment,ne),oe=r(ne),X=m(ne,"P",{"data-svelte-h":!0}),y(X)!=="svelte-19wetgi"&&(X.textContent=Me),ne.forEach(n),ee=r(e),D=m(e,"P",{}),N(D).forEach(n),this.h()},h(){Y(a,"name","hf:doc:metadata"),Y(a,"content",Re),Y(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){g(document.head,a),s(e,_,t),s(e,o,t),s(e,c,t),J(u,e,t),s(e,i,t),s(e,f,t),s(e,F,t),s(e,k,t),s(e,z,t),s(e,R,t),s(e,H,t),s(e,W,t),s(e,Q,t),J(v,e,t),s(e,q,t),J(x,e,t),s(e,A,t),s(e,d,t),J(Z,d,null),g(d,ae),g(d,L),g(d,se),g(d,S),g(d,ie),g(d,M),J(C,M,null),g(M,le),g(M,E),g(M,re),J($,M,null),s(e,O,t),J(G,e,t),s(e,K,t),s(e,w,t),J(V,w,null),g(w,oe),g(w,X),s(e,ee,t),s(e,D,t),te=!0},p(e,[t]){const h={};t&2&&(h.$$scope={dirty:t,ctx:e}),v.$set(h);const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),$.$set(b)},i(e){te||(P(u.$$.fragment,e),P(v.$$.fragment,e),P(x.$$.fragment,e),P(Z.$$.fragment,e),P(C.$$.fragment,e),P($.$$.fragment,e),P(G.$$.fragment,e),P(V.$$.fragment,e),te=!0)},o(e){U(u.$$.fragment,e),U(v.$$.fragment,e),U(x.$$.fragment,e),U(Z.$$.fragment,e),U(C.$$.fragment,e),U($.$$.fragment,e),U(G.$$.fragment,e),U(V.$$.fragment,e),te=!1},d(e){e&&(n(_),n(o),n(c),n(i),n(f),n(F),n(k),n(z),n(R),n(H),n(W),n(Q),n(q),n(A),n(d),n(O),n(K),n(w),n(ee),n(D)),n(a),I(u,e),I(v,e),I(x,e),I(Z),I(C),I($),I(G,e),I(V)}}}const Re='{"title":"RePaint","local":"repaint","sections":[{"title":"RePaintPipeline","local":"diffusers.RePaintPipeline","sections":[],"depth":2},{"title":"ImagePipelineOutput","local":"diffusers.ImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function We(B){return be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Se extends Te{constructor(a){super(),je(this,a,We,ke,we,{})}}export{Se as component};
