import{s as Fa,n as Oa,o as et}from"../chunks/scheduler.36a0863c.js";import{S as st,i as at,g as l,s as n,r,m as na,H as oa,A as tt,h as i,f as a,c as o,j as ze,u,x as p,n as la,B as ia,k as _e,y as Le,a as t,v as c,d as m,t as d,w as g}from"../chunks/index.f891bdb2.js";import{Y as pa}from"../chunks/Youtube.0cbacd3d.js";import{C as q}from"../chunks/CodeBlock.3ec784ea.js";import{D as nt}from"../chunks/DocNotebookDropdown.81c1f0fb.js";import{H as f,E as ot}from"../chunks/EditOnGithub.a58e27a9.js";function lt(ua){let b,Ee,Ce,He,j,Ae,M,De,v,ca="En esta página, veremos más de cerca la tokenización.",Se,T,Be,J,ma='Como vimos en <a href="preprocessing">el tutorial de preprocesamiento</a>, tokenizar un texto es dividirlo en palabras o subpalabras, que luego se convierten en indices o ids a través de una tabla de búsqueda. Convertir palabras o subpalabras en ids es sencillo, así que en esta descripción general, nos centraremos en dividir un texto en palabras o subpalabras (es decir, tokenizar un texto). Más específicamente, examinaremos los tres principales tipos de tokenizadores utilizados en 🤗 Transformers: <a href="#byte-pair-encoding">Byte-Pair Encoding (BPE)</a>, <a href="#wordpiece">WordPiece</a> y <a href="#sentencepiece">SentencePiece</a>, y mostraremos ejemplos de qué tipo de tokenizador se utiliza en cada modelo.',Ze,k,da='Ten en cuenta que en las páginas de los modelos, puedes ver la documentación del tokenizador asociado para saber qué tipo de tokenizador se utilizó en el modelo preentrenado. Por ejemplo, si miramos <a href="https://huggingface.co/docs/transformers/en/model_doc/bert#transformers.BertTokenizer" rel="nofollow">BertTokenizer</a>, podemos ver que dicho modelo utiliza <a href="#wordpiece">WordPiece</a>.',Ge,w,Ve,z,ga="Dividir un texto en trozos más pequeños es más difícil de lo que parece, y hay múltiples formas de hacerlo. Por ejemplo, veamos la oración <code>&quot;Don&#39;t you love 🤗 Transformers? We sure do.&quot;</code>",Ne,$,We,x,ha="Una forma sencilla de tokenizar este texto es dividirlo por espacios, lo que daría:",Qe,I,Xe,U,qa="Este es un primer paso sensato, pero si miramos los tokens <code>&quot;Transformers?&quot;</code> y <code>&quot;do.&quot;</code>, notamos que las puntuaciones están unidas a las palabras <code>&quot;Transformer&quot;</code> y <code>&quot;do&quot;</code>, lo que es subóptimo. Deberíamos tener en cuenta la puntuación para que un modelo no tenga que aprender una representación diferente de una palabra y cada posible símbolo de puntuación que podría seguirle, lo que explotaría el número de representaciones que el modelo tiene que aprender. Teniendo en cuenta la puntuación, tokenizar nuestro texto daría:",Ke,_,Re,C,ba="Mejor. Sin embargo, es desventajoso cómo la tokenización trata la palabra <code>&quot;Don&#39;t&quot;</code>. <code>&quot;Don&#39;t&quot;</code> significa <code>&quot;do not&quot;</code>, así que sería mejor tokenizada como <code>[&quot;Do&quot;, &quot;n&#39;t&quot;]</code>. Aquí es donde las cosas comienzan a complicarse, y es la razon por la que cada modelo tiene su propio tipo de tokenizador. Dependiendo de las reglas que apliquemos para tokenizar un texto, se genera una salida tokenizada diferente para el mismo texto. Un modelo preentrenado solo se desempeña correctamente si se le proporciona una entrada que fue tokenizada con las mismas reglas que se utilizaron para tokenizar sus datos de entrenamiento.",Ye,P,ya='<a href="https://spacy.io/" rel="nofollow">spaCy</a> y <a href="http://www.statmt.org/moses/?n=Development.GetStarted" rel="nofollow">Moses</a> son dos tokenizadores basados en reglas populares. Al aplicarlos en nuestro ejemplo, <em>spaCy</em> y <em>Moses</em> generarían algo como:',Fe,L,Oe,E,fa='Como se puede ver, aquí se utiliza tokenización de espacio y puntuación, así como tokenización basada en reglas. La tokenización de espacio y puntuación y la tokenización basada en reglas son ambos ejemplos de tokenización de palabras, que se define de manera simple como dividir oraciones en palabras. Aunque es la forma más intuitiva de dividir textos en trozos más pequeños, este método de tokenización puede generar problemas para corpus de texto masivos. En este caso, la tokenización de espacio y puntuación suele generar un vocabulario muy grande (el conjunto de todas las palabras y tokens únicos utilizados). <em>Ej.</em>, <a href="https://huggingface.co/docs/transformers/main/en/model_doc/transfo-xl" rel="nofollow">Transformer XL</a> utiliza tokenización de espacio y puntuación, lo que resulta en un tamaño de vocabulario de 267,735.',es,H,ja="Un tamaño de vocabulario tan grande fuerza al modelo a tener una matriz de embeddings enormemente grande como capa de entrada y salida, lo que causa un aumento tanto en la complejidad de memoria como en la complejidad de tiempo. En general, los modelos de transformadores rara vez tienen un tamaño de vocabulario mayor que 50,000, especialmente si están preentrenados solo en un idioma.",ss,A,Ma="Entonces, si la simple tokenización de espacios y puntuación es insatisfactoria, ¿por qué no tokenizar simplemente en caracteres?",as,D,ts,S,va="Aunque la tokenización de caracteres es muy simple y reduciría significativamente la complejidad de memoria y tiempo, hace que sea mucho más difícil para el modelo aprender representaciones de entrada significativas. <em>Ej.</em> aprender una representación independiente del contexto para la letra <code>&quot;t&quot;</code> es mucho más difícil que aprender una representación independiente del contexto para la palabra <code>&quot;today&quot;</code>. Por lo tanto, la tokenización de caracteres suele acompañarse de una pérdida de rendimiento. Así que para obtener lo mejor de ambos mundos, los modelos de transformadores utilizan un híbrido entre la tokenización de nivel de palabra y de nivel de carácter llamada <strong>tokenización de subpalabras</strong>.",ns,B,os,Z,ls,G,Ta="Los algoritmos de tokenización de subpalabras se basan en el principio de que las palabras frecuentemente utilizadas no deberían dividirse en subpalabras más pequeñas, pero las palabras raras deberían descomponerse en subpalabras significativas. Por ejemplo, <code>&quot;annoyingly&quot;</code> podría considerarse una palabra rara y descomponerse en <code>&quot;annoying&quot;</code> y <code>&quot;ly&quot;</code>. Ambas <code>&quot;annoying&quot;</code> y <code>&quot;ly&quot;</code> como subpalabras independientes aparecerían con más frecuencia al mismo tiempo que se mantiene el significado de <code>&quot;annoyingly&quot;</code> por el significado compuesto de <code>&quot;annoying&quot;</code> y <code>&quot;ly&quot;</code>. Esto es especialmente útil en lenguas aglutinantes como el turco, donde puedes formar palabras complejas (casi) arbitrariamente largas concatenando subpalabras.",is,V,Ja='La tokenización de subpalabras permite al modelo tener un tamaño de vocabulario razonable mientras puede aprender representaciones contextuales independientes significativas. Además, la tokenización de subpalabras permite al modelo procesar palabras que nunca ha visto antes, descomponiéndolas en subpalabras conocidas. Por ejemplo, el tokenizador <a href="https://huggingface.co/docs/transformers/en/model_doc/bert#transformers.BertTokenizer" rel="nofollow">BertTokenizer</a> tokeniza <code>&quot;I have a new GPU!&quot;</code> de la siguiente manera:',ps,N,rs,W,ka="Debido a que estamos considerando el modelo sin mayúsculas, la oración se convirtió a minúsculas primero. Podemos ver que las palabras <code>[&quot;i&quot;, &quot;have&quot;, &quot;a&quot;, &quot;new&quot;]</code> están presentes en el vocabulario del tokenizador, pero la palabra <code>&quot;gpu&quot;</code> no. En consecuencia, el tokenizador divide <code>&quot;gpu&quot;</code> en subpalabras conocidas: <code>[&quot;gp&quot; y &quot;##u&quot;]</code>. <code>&quot;##&quot;</code> significa que el resto del token debería adjuntarse al anterior, sin espacio (para decodificar o revertir la tokenización).",us,Q,wa='Como otro ejemplo, el tokenizador <a href="https://huggingface.co/docs/transformers/en/model_doc/xlnet#transformers.XLNetTokenizer" rel="nofollow">XLNetTokenizer</a> tokeniza nuestro texto de ejemplo anterior de la siguiente manera:',cs,X,ms,K,za='Hablaremos del significado de esos <code>&quot;▁&quot;</code> cuando veamos <a href="#sentencepiece">SentencePiece</a>. Como se puede ver, la palabra rara <code>&quot;Transformers&quot;</code> se ha dividido en las subpalabras más frecuentes <code>&quot;Transform&quot;</code> y <code>&quot;ers&quot;</code>.',ds,R,$a="Ahora, veamos cómo funcionan los diferentes algoritmos de tokenización de subpalabras. Ten en cuenta que todos esos algoritmos de tokenización se basan en alguna forma de entrenamiento que usualmente se realiza en el corpus en el que se entrenará el modelo correspondiente.",gs,$e,hs,Y,qs,F,xa='La Codificación por Pares de Bytes (BPE por sus siglas en inglés) fue introducida en <a href="https://arxiv.org/abs/1508.07909" rel="nofollow">Neural Machine Translation of Rare Words with Subword Units (Sennrich et al., 2015)</a>. BPE se basa en un pre-tokenizador que divide los datos de entrenamiento en palabras. La pre-tokenización puede ser tan simple como la tokenización por espacio, por ejemplo, <a href="https://huggingface.co/docs/transformers/en/model_doc/gpt2" rel="nofollow">GPT-2</a>, <a href="https://huggingface.co/docs/transformers/en/model_doc/roberta" rel="nofollow">RoBERTa</a>. La pre-tokenización más avanzada incluye la tokenización basada en reglas, por ejemplo, <a href="https://huggingface.co/docs/transformers/en/model_doc/xlm" rel="nofollow">XLM</a>, <a href="https://huggingface.co/docs/transformers/en/model_doc/flaubert" rel="nofollow">FlauBERT</a> que utiliza Moses para la mayoría de los idiomas, o <a href="https://huggingface.co/docs/transformers/en/model_doc/openai-gpt" rel="nofollow">GPT</a> que utiliza spaCy y ftfy, para contar la frecuencia de cada palabra en el corpus de entrenamiento.',bs,O,Ia="Después de la pre-tokenización, se ha creado un conjunto de palabras únicas y ha determinado la frecuencia con la que cada palabra apareció en los datos de entrenamiento. A continuación, BPE crea un vocabulario base que consiste en todos los símbolos que aparecen en el conjunto de palabras únicas y aprende reglas de fusión para formar un nuevo símbolo a partir de dos símbolos del vocabulario base. Lo hace hasta que el vocabulario ha alcanzado el tamaño de vocabulario deseado. Tenga en cuenta que el tamaño de vocabulario deseado es un hiperparámetro que se debe definir antes de entrenar el tokenizador.",ys,ee,Ua="Por ejemplo, supongamos que después de la pre-tokenización, se ha determinado el siguiente conjunto de palabras, incluyendo su frecuencia:",fs,se,js,ae,_a="En consecuencia, el vocabulario base es <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Dividiendo todas las palabras en símbolos del vocabulario base, obtenemos:",Ms,te,vs,ne,Ca="Luego, BPE cuenta la frecuencia de cada par de símbolos posible y selecciona el par de símbolos que ocurre con más frecuencia. En el ejemplo anterior, <code>&quot;h&quot;</code> seguido de <code>&quot;u&quot;</code> está presente <em>10 + 5 = 15</em> veces (10 veces en las 10 ocurrencias de <code>&quot;hug&quot;</code>, 5 veces en las 5 ocurrencias de <code>&quot;hugs&quot;</code>). Sin embargo, el par de símbolos más frecuente es <code>&quot;u&quot;</code> seguido de <code>&quot;g&quot;</code>, que ocurre <em>10 + 5 + 5 = 20</em> veces en total. Por lo tanto, la primera regla de fusión que aprende el tokenizador es agrupar todos los símbolos <code>&quot;u&quot;</code> seguidos de un símbolo <code>&quot;g&quot;</code> juntos. A continuación, <code>&quot;ug&quot;</code> se agrega al vocabulario. El conjunto de palabras entonces se convierte en",Ts,oe,Js,le,Pa="Seguidamente, BPE identifica el próximo par de símbolos más común. Es <code>&quot;u&quot;</code> seguido de <code>&quot;n&quot;</code>, que ocurre 16 veces. <code>&quot;u&quot;</code>, <code>&quot;n&quot;</code> se fusionan en <code>&quot;un&quot;</code> y se agregan al vocabulario. El próximo par de símbolos más frecuente es <code>&quot;h&quot;</code> seguido de <code>&quot;ug&quot;</code>, que ocurre 15 veces. De nuevo, el par se fusiona y <code>&quot;hug&quot;</code> se puede agregar al vocabulario.",ks,ie,La="En este momento, el vocabulario es <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;, &quot;ug&quot;, &quot;un&quot;, &quot;hug&quot;]</code> y nuestro conjunto de palabras únicas se representa como:",ws,pe,zs,re,Ea="Suponiendo que el entrenamiento por Byte-Pair Encoding se detuviera en este punto, las reglas de combinación aprendidas se aplicarían entonces a nuevas palabras (siempre que esas nuevas palabras no incluyan símbolos que no estuvieran en el vocabulario base). Por ejemplo, la palabra <code>&quot;bug&quot;</code> se tokenizaría como <code>[&quot;b&quot;, &quot;ug&quot;]</code>, pero <code>&quot;mug&quot;</code> se tokenizaría como <code>[&quot;&lt;unk&gt;&quot;, &quot;ug&quot;]</code> ya que el símbolo <code>&quot;m&quot;</code> no está en el vocabulario base. En general, las letras individuales como <code>&quot;m&quot;</code> no se reemplazan por el símbolo <code>&quot;&lt;unk&gt;&quot;</code> porque los datos de entrenamiento usualmente incluyen al menos una ocurrencia de cada letra, pero es probable que suceda para caracteres especiales como los emojis.",$s,ue,Ha='Como se mencionó anteriormente, el tamaño del vocabulario, es decir, el tamaño del vocabulario base + el número de combinaciones, es un hiperparámetro que se debe elegir. Por ejemplo, <a href="https://huggingface.co/docs/transformers/en/model_doc/openai-gpt" rel="nofollow">GPT</a> tiene un tamaño de vocabulario de 40,478 ya que tienen 478 caracteres base y eligieron detener el entrenamiento después de 40,000 combinaciones.',xs,ce,Is,me,Aa='Un vocabulario base que incluya todos los caracteres base posibles puede ser bastante extenso si, por ejemplo, se consideran todos los caracteres unicode como caracteres base. Para tener un vocabulario base mejor, <a href="https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf" rel="nofollow">GPT-2</a> utiliza bytes como vocabulario base, lo que es un truco astuto para forzar el vocabulario base a ser de tamaño 256 mientras se asegura de que cada carácter base esté incluido en el vocabulario. Con algunas reglas adicionales para tratar con la puntuación, el tokenizador de GPT2 puede tokenizar cualquier texto sin la necesidad del símbolo <code>&lt;unk&gt;</code>. <a href="https://huggingface.co/docs/transformers/en/model_doc/gpt2" rel="nofollow">GPT-2</a> tiene un tamaño de vocabulario de 50,257, lo que corresponde a los 256 tokens base de bytes, un token especial de fin de texto y los símbolos aprendidos con 50,000 combinaciones.',Us,xe,_s,de,Cs,ge,Da='WordPiece es el algoritmo de tokenización de subpalabras utilizado por <a href="https://huggingface.co/docs/transformers/en/model_doc/bert" rel="nofollow">BERT</a>, <a href="https://huggingface.co/docs/transformers/main/en/model_doc/distilbert" rel="nofollow">DistilBERT</a> y <a href="https://huggingface.co/docs/transformers/main/en/model_doc/electra" rel="nofollow">Electra</a>. El algoritmo fue descrito en <a href="https://static.googleusercontent.com/media/research.google.com/ja//pubs/archive/37842.pdf" rel="nofollow">Japanese and Korean Voice Search (Schuster et al., 2012)</a> y es muy similar a BPE. WordPiece inicializa el vocabulario para incluir cada carácter presente en los datos de entrenamiento y aprende progresivamente un número determinado de reglas de fusión. A diferencia de BPE, WordPiece no elige el par de símbolos más frecuente, sino el que maximiza la probabilidad de los datos de entrenamiento una vez agregado al vocabulario.',Ps,he,Sa="¿Qué significa esto exactamente? Refiriéndonos al ejemplo anterior, maximizar la probabilidad de los datos de entrenamiento es equivalente a encontrar el par de símbolos cuya probabilidad dividida entre las probabilidades de su primer símbolo seguido de su segundo símbolo es la mayor entre todos los pares de símbolos. <em>Ej.</em> <code>&quot;u&quot;</code> seguido de <code>&quot;g&quot;</code> solo habría sido combinado si la probabilidad de <code>&quot;ug&quot;</code> dividida entre <code>&quot;u&quot;</code> y <code>&quot;g&quot;</code> habría sido mayor que para cualquier otro par de símbolos. Intuitivamente, WordPiece es ligeramente diferente a BPE en que evalúa lo que <em>pierde</em> al fusionar dos símbolos para asegurarse de que <em>valga la pena</em>.",Ls,Ie,Es,qe,Hs,be,Ba='Unigram es un algoritmo de tokenización de subpalabras introducido en <a href="https://arxiv.org/pdf/1804.10959.pdf" rel="nofollow">Subword Regularization: Improving Neural Network Translation Models with Multiple Subword Candidates (Kudo, 2018)</a>. A diferencia de BPE o WordPiece, Unigram inicializa su vocabulario base con un gran número de símbolos y progresivamente recorta cada símbolo para obtener un vocabulario más pequeño. El vocabulario base podría corresponder, por ejemplo, a todas las palabras pre-tokenizadas y las subcadenas más comunes. Unigram no se utiliza directamente para ninguno de los modelos transformers, pero se utiliza en conjunto con <a href="#sentencepiece">SentencePiece</a>.',As,ye,Za="En cada paso de entrenamiento, el algoritmo Unigram define una pérdida (a menudo definida como la probabilidad logarítmica) sobre los datos de entrenamiento dados el vocabulario actual y un modelo de lenguaje unigram. Luego, para cada símbolo en el vocabulario, el algoritmo calcula cuánto aumentaría la pérdida general si el símbolo se eliminara del vocabulario. Luego, Unigram elimina un porcentaje <code>p</code> de los símbolos cuyo aumento de pérdida es el más bajo (siendo <code>p</code> generalmente 10% o 20%), es decir, aquellos símbolos que menos afectan la pérdida general sobre los datos de entrenamiento. Este proceso se repite hasta que el vocabulario haya alcanzado el tamaño deseado. El algoritmo Unigram siempre mantiene los caracteres base para que cualquier palabra pueda ser tokenizada.",Ds,fe,Ga="Debido a que Unigram no se basa en reglas de combinación (en contraste con BPE y WordPiece), el algoritmo tiene varias formas de tokenizar nuevo texto después del entrenamiento. Por ejemplo, si un tokenizador Unigram entrenado exhibe el vocabulario:",Ss,je,Bs,Me,Va="<code>&quot;hugs&quot;</code> podría ser tokenizado tanto como <code>[&quot;hug&quot;, &quot;s&quot;]</code>, <code>[&quot;h&quot;, &quot;ug&quot;, &quot;s&quot;]</code> o <code>[&quot;h&quot;, &quot;u&quot;, &quot;g&quot;, &quot;s&quot;]</code>. ¿Cuál elegir? Unigram guarda la probabilidad de cada token en el corpus de entrenamiento junto con el vocabulario, para que la probabilidad de que cada posible tokenización pueda ser computada después del entrenamiento. El algoritmo simplemente elige la tokenización más probable en la práctica, pero también ofrece la posibilidad de muestrear una posible tokenización según sus probabilidades.",Zs,h,ra,Gs,Xa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>x</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex">x_{1}, \\dots, x_{N}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Vs,Ns,Ka='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex">x_{i}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Ws,Qs,Ra='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">S(x_{i})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Xs,Ks,Ya=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi mathvariant="script">L</mi><mo>=</mo><mo>−</mo><munderover><mo>∑</mo><mrow><mi>i</mi><mo>=</mo><mn>1</mn></mrow><mi>N</mi></munderover><mi>log</mi><mo>⁡</mo><mrow><mo fence="true">(</mo><munder><mo>∑</mo><mrow><mi>x</mi><mo>∈</mo><mi>S</mi><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mo stretchy="false">)</mo></mrow></munder><mi>p</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">\\mathcal{L} = -\\sum_{i=1}^{N} \\log \\left ( \\sum_{x \\in S(x_{i})} p(x) \\right )</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathcal">L</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.6em;vertical-align:-1.55em;"></span><span class="mord">−</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mrel mtight">=</span><span class="mord mtight">1</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2777em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.05em;"><span style="top:-4.05em;"><span class="pstrut" style="height:5.6em;"></span><span style="width:0.875em;height:3.600em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='3.600em' viewBox='0 0 875 3600'><path d='M863,9c0,-2,-2,-5,-6,-9c0,0,-17,0,-17,0c-12.7,0,-19.3,0.3,-20,1
c-5.3,5.3,-10.3,11,-15,17c-242.7,294.7,-395.3,682,-458,1162c-21.3,163.3,-33.3,349,
-36,557 l0,84c0.2,6,0,26,0,60c2,159.3,10,310.7,24,454c53.3,528,210,
949.7,470,1265c4.7,6,9.7,11.7,15,17c0.7,0.7,7,1,19,1c0,0,18,0,18,0c4,-4,6,-7,6,-9
c0,-2.7,-3.3,-8.7,-10,-18c-135.3,-192.7,-235.5,-414.3,-300.5,-665c-65,-250.7,-102.5,
-544.7,-112.5,-882c-2,-104,-3,-167,-3,-189
l0,-92c0,-162.7,5.7,-314,17,-454c20.7,-272,63.7,-513,129,-723c65.3,
-210,155.3,-396.3,270,-559c6.7,-9.3,10,-15.3,10,-18z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.55em;"><span></span></span></span></span></span></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.05em;"><span style="top:-1.809em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∈</span><span class="mord mathnormal mtight" style="margin-right:0.05764em;">S</span><span class="mopen mtight">(</span><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3281em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.143em;"><span></span></span></span></span></span></span><span class="mclose mtight">)</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.516em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">p</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)</span><span class="mclose"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.05em;"><span style="top:-4.05em;"><span class="pstrut" style="height:5.6em;"></span><span style="width:0.875em;height:3.600em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='3.600em' viewBox='0 0 875 3600'><path d='M76,0c-16.7,0,-25,3,-25,9c0,2,2,6.3,6,13c21.3,28.7,42.3,60.3,
63,95c96.7,156.7,172.8,332.5,228.5,527.5c55.7,195,92.8,416.5,111.5,664.5
c11.3,139.3,17,290.7,17,454c0,28,1.7,43,3.3,45l0,9
c-3,4,-3.3,16.7,-3.3,38c0,162,-5.7,313.7,-17,455c-18.7,248,-55.8,469.3,-111.5,664
c-55.7,194.7,-131.8,370.3,-228.5,527c-20.7,34.7,-41.7,66.3,-63,95c-2,3.3,-4,7,-6,11
c0,7.3,5.7,11,17,11c0,0,11,0,11,0c9.3,0,14.3,-0.3,15,-1c5.3,-5.3,10.3,-11,15,-17
c242.7,-294.7,395.3,-681.7,458,-1161c21.3,-164.7,33.3,-350.7,36,-558
l0,-144c-2,-159.3,-10,-310.7,-24,-454c-53.3,-528,-210,-949.7,
-470,-1265c-4.7,-6,-9.7,-11.7,-15,-17c-0.7,-0.7,-6.7,-1,-18,-1z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.55em;"><span></span></span></span></span></span></span></span></span></span></span></span>`,Rs,Ue,Ys,ve,Fs,Te,Na='Todos los algoritmos de tokenización descritos hasta ahora tienen el mismo problema: se asume que el texto de entrada utiliza espacios para separar palabras. Sin embargo, no todos los idiomas utilizan espacios para separar palabras. Una posible solución es utilizar pre-tokenizadores específicos del idioma, <em>ej.</em> <a href="https://huggingface.co/docs/transformers/en/model_doc/xlm" rel="nofollow">XLM</a> utiliza un pre-tokenizador específico para chino, japonés y tailandés. Para resolver este problema de manera más general, <a href="https://arxiv.org/pdf/1808.06226.pdf" rel="nofollow">SentencePiece: A simple and language independent subword tokenizer and detokenizer for Neural Text Processing (Kudo et al., 2018)</a> trata el texto de entrada como una corriente de entrada bruta, por lo que incluye el espacio en el conjunto de caracteres para utilizar. Luego utiliza el algoritmo BPE o unigram para construir el vocabulario apropiado.',Os,Je,Wa='Por ejemplo, <a href="https://huggingface.co/docs/transformers/en/model_doc/xlnet#transformers.XLNetTokenizer" rel="nofollow"><code>XLNetTokenizer</code></a> utiliza SentencePiece, razón por la cual en el ejemplo anterior se incluyó el carácter <code>&quot;▁&quot;</code> en el vocabulario. Decodificar con SentencePiece es muy fácil, ya que todos los tokens pueden simplemente concatenarse y <code>&quot;▁&quot;</code> se reemplaza por un espacio.',ea,ke,Qa='Todos los modelos transformers de nuestra biblioteca que utilizan SentencePiece lo utilizan en combinación con Unigram. Ejemplos de los modelos que utilizan SentencePiece son <a href="https://huggingface.co/docs/transformers/en/model_doc/albert" rel="nofollow">ALBERT</a>, <a href="https://huggingface.co/docs/transformers/en/model_doc/xlnet" rel="nofollow">XLNet</a>, <a href="https://huggingface.co/docs/transformers/en/model_doc/marian" rel="nofollow">Marian</a> y <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5" rel="nofollow">T5</a>.',sa,we,aa,Pe,ta;return j=new f({props:{title:"Descripción general de los tokenizadores",local:"descripción-general-de-los-tokenizadores",headingTag:"h1"}}),M=new nt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/tokenizer_summary.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/tokenizer_summary.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/tokenizer_summary.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/tokenizer_summary.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/tokenizer_summary.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/tokenizer_summary.ipynb"}]}}),T=new pa({props:{id:"VFp38yj8h3A"}}),w=new f({props:{title:"Introducción",local:"introducción",headingTag:"h2"}}),$=new pa({props:{id:"nhJxYji1aho"}}),I=new q({props:{code:"JTVCJTIyRG9uJ3QlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8uJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Don&#x27;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do.&quot;</span>]</span>',wrap:!1}}),_=new q({props:{code:"JTVCJTIyRG9uJTIyJTJDJTIwJTIyJyUyMiUyQyUyMCUyMnQlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8lMjIlMkMlMjAlMjIuJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Don&quot;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]</span>',wrap:!1}}),L=new q({props:{code:"JTVCJTIyRG8lMjIlMkMlMjAlMjJuJ3QlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8lMjIlMkMlMjAlMjIuJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Do&quot;</span>, <span class="hljs-string">&quot;n&#x27;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]</span>',wrap:!1}}),D=new pa({props:{id:"ssLq_EK2jLE"}}),B=new f({props:{title:"Tokenización de subpalabras",local:"tokenización-de-subpalabras",headingTag:"h2"}}),Z=new pa({props:{id:"zHvTiHr506c"}}),N=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXRva2VuaXplci50b2tlbml6ZSglMjJJJTIwaGF2ZSUyMGElMjBuZXclMjBHUFUhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.tokenize(<span class="hljs-string">&quot;I have a new GPU!&quot;</span>)
[<span class="hljs-string">&quot;i&quot;</span>, <span class="hljs-string">&quot;have&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;new&quot;</span>, <span class="hljs-string">&quot;gp&quot;</span>, <span class="hljs-string">&quot;##u&quot;</span>, <span class="hljs-string">&quot;!&quot;</span>]`,wrap:!1}}),X=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnhsbmV0JTJGeGxuZXQtYmFzZS1jYXNlZCUyMiklMEF0b2tlbml6ZXIudG9rZW5pemUoJTIyRG9uJ3QlMjB5b3UlMjBsb3ZlJTIwJUYwJTlGJUE0JTk3JTIwVHJhbnNmb3JtZXJzJTNGJTIwV2UlMjBzdXJlJTIwZG8uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLNetTokenizer.from_pretrained(<span class="hljs-string">&quot;xlnet/xlnet-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.tokenize(<span class="hljs-string">&quot;Don&#x27;t you love 🤗 Transformers? We sure do.&quot;</span>)
[<span class="hljs-string">&quot;▁Don&quot;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, <span class="hljs-string">&quot;▁you&quot;</span>, <span class="hljs-string">&quot;▁love&quot;</span>, <span class="hljs-string">&quot;▁&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;▁&quot;</span>, <span class="hljs-string">&quot;Transform&quot;</span>, <span class="hljs-string">&quot;ers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;▁We&quot;</span>, <span class="hljs-string">&quot;▁sure&quot;</span>, <span class="hljs-string">&quot;▁do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]`,wrap:!1}}),Y=new f({props:{title:"Byte-Pair Encoding (BPE)",local:"byte-pair-encoding-bpe",headingTag:"h3"}}),se=new q({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),te=new q({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),oe=new q({props:{code:"KCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),pe=new q({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),ce=new f({props:{title:"Byte-level BPE",local:"byte-level-bpe",headingTag:"h4"}}),de=new f({props:{title:"WordPiece",local:"wordpiece",headingTag:"h3"}}),qe=new f({props:{title:"Unigram",local:"unigram",headingTag:"h3"}}),je=new q({props:{code:"JTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTJDJTIwJTIydW4lMjIlMkMlMjAlMjJodWclMjIlNUQlMkM=",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]</span>,',wrap:!1}}),ve=new f({props:{title:"SentencePiece",local:"sentencepiece",headingTag:"h3"}}),we=new ot({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/tokenizer_summary.md"}}),{c(){b=l("meta"),Ee=n(),Ce=l("p"),He=n(),r(j.$$.fragment),Ae=n(),r(M.$$.fragment),De=n(),v=l("p"),v.textContent=ca,Se=n(),r(T.$$.fragment),Be=n(),J=l("p"),J.innerHTML=ma,Ze=n(),k=l("p"),k.innerHTML=da,Ge=n(),r(w.$$.fragment),Ve=n(),z=l("p"),z.innerHTML=ga,Ne=n(),r($.$$.fragment),We=n(),x=l("p"),x.textContent=ha,Qe=n(),r(I.$$.fragment),Xe=n(),U=l("p"),U.innerHTML=qa,Ke=n(),r(_.$$.fragment),Re=n(),C=l("p"),C.innerHTML=ba,Ye=n(),P=l("p"),P.innerHTML=ya,Fe=n(),r(L.$$.fragment),Oe=n(),E=l("p"),E.innerHTML=fa,es=n(),H=l("p"),H.textContent=ja,ss=n(),A=l("p"),A.textContent=Ma,as=n(),r(D.$$.fragment),ts=n(),S=l("p"),S.innerHTML=va,ns=n(),r(B.$$.fragment),os=n(),r(Z.$$.fragment),ls=n(),G=l("p"),G.innerHTML=Ta,is=n(),V=l("p"),V.innerHTML=Ja,ps=n(),r(N.$$.fragment),rs=n(),W=l("p"),W.innerHTML=ka,us=n(),Q=l("p"),Q.innerHTML=wa,cs=n(),r(X.$$.fragment),ms=n(),K=l("p"),K.innerHTML=za,ds=n(),R=l("p"),R.textContent=$a,gs=n(),$e=l("a"),hs=n(),r(Y.$$.fragment),qs=n(),F=l("p"),F.innerHTML=xa,bs=n(),O=l("p"),O.textContent=Ia,ys=n(),ee=l("p"),ee.textContent=Ua,fs=n(),r(se.$$.fragment),js=n(),ae=l("p"),ae.innerHTML=_a,Ms=n(),r(te.$$.fragment),vs=n(),ne=l("p"),ne.innerHTML=Ca,Ts=n(),r(oe.$$.fragment),Js=n(),le=l("p"),le.innerHTML=Pa,ks=n(),ie=l("p"),ie.innerHTML=La,ws=n(),r(pe.$$.fragment),zs=n(),re=l("p"),re.innerHTML=Ea,$s=n(),ue=l("p"),ue.innerHTML=Ha,xs=n(),r(ce.$$.fragment),Is=n(),me=l("p"),me.innerHTML=Aa,Us=n(),xe=l("a"),_s=n(),r(de.$$.fragment),Cs=n(),ge=l("p"),ge.innerHTML=Da,Ps=n(),he=l("p"),he.innerHTML=Sa,Ls=n(),Ie=l("a"),Es=n(),r(qe.$$.fragment),Hs=n(),be=l("p"),be.innerHTML=Ba,As=n(),ye=l("p"),ye.innerHTML=Za,Ds=n(),fe=l("p"),fe.textContent=Ga,Ss=n(),r(je.$$.fragment),Bs=n(),Me=l("p"),Me.innerHTML=Va,Zs=n(),h=l("p"),ra=na("Esas probabilidades están definidas por la pérdida en la que se entrena el tokenizador. Suponiendo que los datos de entrenamiento constan de las palabras"),Gs=new oa(!1),Vs=na(" y que el conjunto de todas las posibles tokenizaciones para una palabra"),Ns=new oa(!1),Ws=na(" se define como"),Qs=new oa(!1),Xs=na(`, entonces la pérdida general se define como:
`),Ks=new oa(!1),Rs=n(),Ue=l("a"),Ys=n(),r(ve.$$.fragment),Fs=n(),Te=l("p"),Te.innerHTML=Na,Os=n(),Je=l("p"),Je.innerHTML=Wa,ea=n(),ke=l("p"),ke.innerHTML=Qa,sa=n(),r(we.$$.fragment),aa=n(),Pe=l("p"),this.h()},l(e){const s=tt("svelte-u9bgzb",document.head);b=i(s,"META",{name:!0,content:!0}),s.forEach(a),Ee=o(e),Ce=i(e,"P",{}),ze(Ce).forEach(a),He=o(e),u(j.$$.fragment,e),Ae=o(e),u(M.$$.fragment,e),De=o(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-7vn46s"&&(v.textContent=ca),Se=o(e),u(T.$$.fragment,e),Be=o(e),J=i(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-17qauf8"&&(J.innerHTML=ma),Ze=o(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-178it90"&&(k.innerHTML=da),Ge=o(e),u(w.$$.fragment,e),Ve=o(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1nc315g"&&(z.innerHTML=ga),Ne=o(e),u($.$$.fragment,e),We=o(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-xdhowc"&&(x.textContent=ha),Qe=o(e),u(I.$$.fragment,e),Xe=o(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-je3r35"&&(U.innerHTML=qa),Ke=o(e),u(_.$$.fragment,e),Re=o(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1kg7pw2"&&(C.innerHTML=ba),Ye=o(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-6p3h4z"&&(P.innerHTML=ya),Fe=o(e),u(L.$$.fragment,e),Oe=o(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-dby55m"&&(E.innerHTML=fa),es=o(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-eah7gj"&&(H.textContent=ja),ss=o(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1wtokos"&&(A.textContent=Ma),as=o(e),u(D.$$.fragment,e),ts=o(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-181pmek"&&(S.innerHTML=va),ns=o(e),u(B.$$.fragment,e),os=o(e),u(Z.$$.fragment,e),ls=o(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-l5b1i1"&&(G.innerHTML=Ta),is=o(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-g67zcs"&&(V.innerHTML=Ja),ps=o(e),u(N.$$.fragment,e),rs=o(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1tcj0t0"&&(W.innerHTML=ka),us=o(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1nmk1i5"&&(Q.innerHTML=wa),cs=o(e),u(X.$$.fragment,e),ms=o(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-12xbjue"&&(K.innerHTML=za),ds=o(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-7j50ya"&&(R.textContent=$a),gs=o(e),$e=i(e,"A",{id:!0}),ze($e).forEach(a),hs=o(e),u(Y.$$.fragment,e),qs=o(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-17p20fs"&&(F.innerHTML=xa),bs=o(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-wxf2bn"&&(O.textContent=Ia),ys=o(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-2ajdoo"&&(ee.textContent=Ua),fs=o(e),u(se.$$.fragment,e),js=o(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-tva4tw"&&(ae.innerHTML=_a),Ms=o(e),u(te.$$.fragment,e),vs=o(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-5ubn2i"&&(ne.innerHTML=Ca),Ts=o(e),u(oe.$$.fragment,e),Js=o(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1d6vbkg"&&(le.innerHTML=Pa),ks=o(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-ror599"&&(ie.innerHTML=La),ws=o(e),u(pe.$$.fragment,e),zs=o(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-11p6r3k"&&(re.innerHTML=Ea),$s=o(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-zt86zl"&&(ue.innerHTML=Ha),xs=o(e),u(ce.$$.fragment,e),Is=o(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1sh4680"&&(me.innerHTML=Aa),Us=o(e),xe=i(e,"A",{id:!0}),ze(xe).forEach(a),_s=o(e),u(de.$$.fragment,e),Cs=o(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1y2g9fg"&&(ge.innerHTML=Da),Ps=o(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1rlmwbp"&&(he.innerHTML=Sa),Ls=o(e),Ie=i(e,"A",{id:!0}),ze(Ie).forEach(a),Es=o(e),u(qe.$$.fragment,e),Hs=o(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-relfho"&&(be.innerHTML=Ba),As=o(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1g481d7"&&(ye.innerHTML=Za),Ds=o(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-7cutyt"&&(fe.textContent=Ga),Ss=o(e),u(je.$$.fragment,e),Bs=o(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1yuq5lm"&&(Me.innerHTML=Va),Zs=o(e),h=i(e,"P",{});var y=ze(h);ra=la(y,"Esas probabilidades están definidas por la pérdida en la que se entrena el tokenizador. Suponiendo que los datos de entrenamiento constan de las palabras"),Gs=ia(y,!1),Vs=la(y," y que el conjunto de todas las posibles tokenizaciones para una palabra"),Ns=ia(y,!1),Ws=la(y," se define como"),Qs=ia(y,!1),Xs=la(y,`, entonces la pérdida general se define como:
`),Ks=ia(y,!1),y.forEach(a),Rs=o(e),Ue=i(e,"A",{id:!0}),ze(Ue).forEach(a),Ys=o(e),u(ve.$$.fragment,e),Fs=o(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-17rcjdb"&&(Te.innerHTML=Na),Os=o(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1rifrxx"&&(Je.innerHTML=Wa),ea=o(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-sywsma"&&(ke.innerHTML=Qa),sa=o(e),u(we.$$.fragment,e),aa=o(e),Pe=i(e,"P",{}),ze(Pe).forEach(a),this.h()},h(){_e(b,"name","hf:doc:metadata"),_e(b,"content",it),_e($e,"id","byte-pair-encoding"),_e(xe,"id","wordpiece"),_e(Ie,"id","unigram"),Gs.a=Vs,Ns.a=Ws,Qs.a=Xs,Ks.a=null,_e(Ue,"id","sentencepiece")},m(e,s){Le(document.head,b),t(e,Ee,s),t(e,Ce,s),t(e,He,s),c(j,e,s),t(e,Ae,s),c(M,e,s),t(e,De,s),t(e,v,s),t(e,Se,s),c(T,e,s),t(e,Be,s),t(e,J,s),t(e,Ze,s),t(e,k,s),t(e,Ge,s),c(w,e,s),t(e,Ve,s),t(e,z,s),t(e,Ne,s),c($,e,s),t(e,We,s),t(e,x,s),t(e,Qe,s),c(I,e,s),t(e,Xe,s),t(e,U,s),t(e,Ke,s),c(_,e,s),t(e,Re,s),t(e,C,s),t(e,Ye,s),t(e,P,s),t(e,Fe,s),c(L,e,s),t(e,Oe,s),t(e,E,s),t(e,es,s),t(e,H,s),t(e,ss,s),t(e,A,s),t(e,as,s),c(D,e,s),t(e,ts,s),t(e,S,s),t(e,ns,s),c(B,e,s),t(e,os,s),c(Z,e,s),t(e,ls,s),t(e,G,s),t(e,is,s),t(e,V,s),t(e,ps,s),c(N,e,s),t(e,rs,s),t(e,W,s),t(e,us,s),t(e,Q,s),t(e,cs,s),c(X,e,s),t(e,ms,s),t(e,K,s),t(e,ds,s),t(e,R,s),t(e,gs,s),t(e,$e,s),t(e,hs,s),c(Y,e,s),t(e,qs,s),t(e,F,s),t(e,bs,s),t(e,O,s),t(e,ys,s),t(e,ee,s),t(e,fs,s),c(se,e,s),t(e,js,s),t(e,ae,s),t(e,Ms,s),c(te,e,s),t(e,vs,s),t(e,ne,s),t(e,Ts,s),c(oe,e,s),t(e,Js,s),t(e,le,s),t(e,ks,s),t(e,ie,s),t(e,ws,s),c(pe,e,s),t(e,zs,s),t(e,re,s),t(e,$s,s),t(e,ue,s),t(e,xs,s),c(ce,e,s),t(e,Is,s),t(e,me,s),t(e,Us,s),t(e,xe,s),t(e,_s,s),c(de,e,s),t(e,Cs,s),t(e,ge,s),t(e,Ps,s),t(e,he,s),t(e,Ls,s),t(e,Ie,s),t(e,Es,s),c(qe,e,s),t(e,Hs,s),t(e,be,s),t(e,As,s),t(e,ye,s),t(e,Ds,s),t(e,fe,s),t(e,Ss,s),c(je,e,s),t(e,Bs,s),t(e,Me,s),t(e,Zs,s),t(e,h,s),Le(h,ra),Gs.m(Xa,h),Le(h,Vs),Ns.m(Ka,h),Le(h,Ws),Qs.m(Ra,h),Le(h,Xs),Ks.m(Ya,h),t(e,Rs,s),t(e,Ue,s),t(e,Ys,s),c(ve,e,s),t(e,Fs,s),t(e,Te,s),t(e,Os,s),t(e,Je,s),t(e,ea,s),t(e,ke,s),t(e,sa,s),c(we,e,s),t(e,aa,s),t(e,Pe,s),ta=!0},p:Oa,i(e){ta||(m(j.$$.fragment,e),m(M.$$.fragment,e),m(T.$$.fragment,e),m(w.$$.fragment,e),m($.$$.fragment,e),m(I.$$.fragment,e),m(_.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(B.$$.fragment,e),m(Z.$$.fragment,e),m(N.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(se.$$.fragment,e),m(te.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(qe.$$.fragment,e),m(je.$$.fragment,e),m(ve.$$.fragment,e),m(we.$$.fragment,e),ta=!0)},o(e){d(j.$$.fragment,e),d(M.$$.fragment,e),d(T.$$.fragment,e),d(w.$$.fragment,e),d($.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(N.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(se.$$.fragment,e),d(te.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(qe.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),d(we.$$.fragment,e),ta=!1},d(e){e&&(a(Ee),a(Ce),a(He),a(Ae),a(De),a(v),a(Se),a(Be),a(J),a(Ze),a(k),a(Ge),a(Ve),a(z),a(Ne),a(We),a(x),a(Qe),a(Xe),a(U),a(Ke),a(Re),a(C),a(Ye),a(P),a(Fe),a(Oe),a(E),a(es),a(H),a(ss),a(A),a(as),a(ts),a(S),a(ns),a(os),a(ls),a(G),a(is),a(V),a(ps),a(rs),a(W),a(us),a(Q),a(cs),a(ms),a(K),a(ds),a(R),a(gs),a($e),a(hs),a(qs),a(F),a(bs),a(O),a(ys),a(ee),a(fs),a(js),a(ae),a(Ms),a(vs),a(ne),a(Ts),a(Js),a(le),a(ks),a(ie),a(ws),a(zs),a(re),a($s),a(ue),a(xs),a(Is),a(me),a(Us),a(xe),a(_s),a(Cs),a(ge),a(Ps),a(he),a(Ls),a(Ie),a(Es),a(Hs),a(be),a(As),a(ye),a(Ds),a(fe),a(Ss),a(Bs),a(Me),a(Zs),a(h),a(Rs),a(Ue),a(Ys),a(Fs),a(Te),a(Os),a(Je),a(ea),a(ke),a(sa),a(aa),a(Pe)),a(b),g(j,e),g(M,e),g(T,e),g(w,e),g($,e),g(I,e),g(_,e),g(L,e),g(D,e),g(B,e),g(Z,e),g(N,e),g(X,e),g(Y,e),g(se,e),g(te,e),g(oe,e),g(pe,e),g(ce,e),g(de,e),g(qe,e),g(je,e),g(ve,e),g(we,e)}}}const it='{"title":"Descripción general de los tokenizadores","local":"descripción-general-de-los-tokenizadores","sections":[{"title":"Introducción","local":"introducción","sections":[],"depth":2},{"title":"Tokenización de subpalabras","local":"tokenización-de-subpalabras","sections":[{"title":"Byte-Pair Encoding (BPE)","local":"byte-pair-encoding-bpe","sections":[{"title":"Byte-level BPE","local":"byte-level-bpe","sections":[],"depth":4}],"depth":3},{"title":"WordPiece","local":"wordpiece","sections":[],"depth":3},{"title":"Unigram","local":"unigram","sections":[],"depth":3},{"title":"SentencePiece","local":"sentencepiece","sections":[],"depth":3}],"depth":2}],"depth":1}';function pt(ua){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends st{constructor(b){super(),at(this,b,pt,lt,Fa,{})}}export{ht as component};
