import{s as Rl,n as Il,o as $l}from"../chunks/scheduler.b108d059.js";import{S as _l,i as Tl,g as d,s as i,r as g,A as bl,h as o,f as a,c as m,j as n,u,x as s,k as r,y as vl,a as l,v as c,d as p,t as f,w as h}from"../chunks/index.008de539.js";import{C as Cl}from"../chunks/CodeBlock.3968c746.js";import{H as w}from"../chunks/Heading.88bfeb84.js";function xl(Ea){let R,Be,je,ke,I,Ye,$,Ke,_,Aa="Helper module for image processing.",Je,T,Ua=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,qe,b,ja='<li><a href="#module_utils/image">utils/image</a><ul><li><em>static</em><ul><li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/image..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li></ul></li></ul></li>',Ne,Se,Ze,v,Ge,C,We,x,za='<strong>Kind</strong>: static class of <a href="#module_utils/image"><code>utils/image</code></a>',De,H,Ba='<li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li>',Oe,Ve,Fe,L,Qe,y,Xe,P,ka="Create a new <code>RawImage</code> object.",et,M,Ya="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Uint8ClampedArray</code> | <code>Uint8Array</code></td><td><p>The pixel data.</p></td> </tr><tr><td>width</td><td><code>number</code></td><td><p>The width of the image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the image.</p></td> </tr><tr><td>channels</td><td><code>1</code> | <code>2</code> | <code>3</code> | <code>4</code></td><td><p>The number of channels.</p></td></tr></tbody>",tt,at,lt,E,it,A,mt,U,Ka="Convert the image to grayscale format.",dt,j,Ja='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',ot,st,rt,z,nt,B,gt,k,qa="Convert the image to RGB format.",ut,Y,Na='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',ct,pt,ft,K,ht,J,wt,q,Sa="Convert the image to RGBA format.",Rt,N,Za='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',It,$t,_t,S,Tt,Z,bt,G,Ga="Resize the image to the given dimensions. This method uses the canvas API to perform the resizing.",vt,W,Wa='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - <code>this</code> to support chaining.',Ct,D,Da="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>width</td><td><code>number</code></td><td><p>The width of the new image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the new image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>Additional options for resizing.</p></td> </tr><tr><td>[options.resample]</td><td><code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code> | <code>string</code></td><td><p>The resampling method to use.</p></td></tr></tbody>",xt,Ht,Lt,O,yt,V,Pt,F,Oa="Clone the image",Mt,Q,Va='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The cloned image',Et,At,Ut,X,jt,ee,zt,te,Fa="Helper method for converting image to have a certain number of channels",Bt,ae,Qa='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',kt,le,Xa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>numChannels</td><td><code>number</code></td><td><p>The number of channels. Must be 1, 3, or 4.</p></td></tr></tbody>",Yt,Kt,Jt,ie,qt,me,Nt,de,el="Save the image to the given path.",St,oe,tl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',Zt,se,al="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td><td><p>The path to save the image to.</p></td></tr></tbody>",Gt,Wt,Dt,re,Ot,ne,Vt,ge,ll="Helper method for reading an image from a variety of input types.",Ft,ue,il='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image object.',Qt,ce,ml="<strong>Example:</strong> Read image from a URL.",Xt,pe,ea,fe,dl="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>RawImage</code> | <code>string</code> | <code>URL</code></td></tr></tbody>",ta,aa,la,he,ia,we,ma,Re,ol="Read an image from a URL or file path.",da,Ie,sl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',oa,$e,rl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The URL or file path to read the image from.</p></td></tr></tbody>",sa,ra,na,_e,ga,Te,ua,be,nl="Helper method to create a new Image from a blob.",ca,ve,gl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',pa,Ce,ul="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>blob</td><td><code>Blob</code></td><td><p>The blob to read the image from.</p></td></tr></tbody>",fa,ha,wa,xe,Ra,He,Ia,Le,cl="Helper method to create a new Image from a tensor",$a,ye,pl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',_a,Pe,fl="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>tensor</td><td><code>*</code></td></tr></tbody>",Ta,ba,va,Me,Ca,Ee,xa,Ae,hl="Mapping from file extensions to MIME types.",Ha,Ue,wl='<strong>Kind</strong>: inner constant of <a href="#module_utils/image"><code>utils/image</code></a>',La,ya,Pa,ze,Ma;return $=new w({props:{title:"utils/image",local:"utilsimage",headingTag:"h1"}}),C=new w({props:{title:"utils/image.RawImage",local:"utilsimagerawimage",headingTag:"h2"}}),y=new w({props:{title:"new RawImage(data, width, height, channels)",local:"new-rawimagedata-width-height-channels",headingTag:"h3"}}),A=new w({props:{title:"rawImage.grayscale() ⇒ <code> RawImage </code>",local:"rawimagegrayscale--code-rawimage-code",headingTag:"h3"}}),B=new w({props:{title:"rawImage.rgb() ⇒ <code> RawImage </code>",local:"rawimagergb--code-rawimage-code",headingTag:"h3"}}),J=new w({props:{title:"rawImage.rgba() ⇒ <code> RawImage </code>",local:"rawimagergba--code-rawimage-code",headingTag:"h3"}}),Z=new w({props:{title:"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>",local:"rawimageresizewidth-height-options--code-promise--rawimage--code",headingTag:"h3"}}),V=new w({props:{title:"rawImage.clone() ⇒ <code> RawImage </code>",local:"rawimageclone--code-rawimage-code",headingTag:"h3"}}),ee=new w({props:{title:"rawImage.convert(numChannels) ⇒ <code> RawImage </code>",local:"rawimageconvertnumchannels--code-rawimage-code",headingTag:"h3"}}),me=new w({props:{title:"rawImage.save(path)",local:"rawimagesavepath",headingTag:"h3"}}),ne=new w({props:{title:"RawImage.read(input) ⇒ <code> * </code>",local:"rawimagereadinput--code--code",headingTag:"h3"}}),pe=new Cl({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjBhd2FpdCUyMFJhd0ltYWdlLnJlYWQoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmb290YmFsbC1tYXRjaC5qcGcnKSUzQiUwQSUyRiUyRiUyMFJhd0ltYWdlJTIw",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-comment">// RawImage </span>`,wrap:!1}}),we=new w({props:{title:"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromurlurl--code-promise--rawimage--code",headingTag:"h3"}}),Te=new w({props:{title:"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromblobblob--code-promise--rawimage--code",headingTag:"h3"}}),He=new w({props:{title:"RawImage.fromTensor(tensor)",local:"rawimagefromtensortensor",headingTag:"h3"}}),Ee=new w({props:{title:"utils/image~CONTENT_TYPE_MAP",local:"utilsimagecontenttypemap",headingTag:"h2"}}),{c(){R=d("meta"),Be=i(),je=d("p"),ke=i(),I=d("a"),Ye=i(),g($.$$.fragment),Ke=i(),_=d("p"),_.textContent=Aa,Je=i(),T=d("p"),T.textContent=Ua,qe=i(),b=d("ul"),b.innerHTML=ja,Ne=i(),Se=d("hr"),Ze=i(),v=d("a"),Ge=i(),g(C.$$.fragment),We=i(),x=d("p"),x.innerHTML=za,De=i(),H=d("ul"),H.innerHTML=Ba,Oe=i(),Ve=d("hr"),Fe=i(),L=d("a"),Qe=i(),g(y.$$.fragment),Xe=i(),P=d("p"),P.innerHTML=ka,et=i(),M=d("table"),M.innerHTML=Ya,tt=i(),at=d("hr"),lt=i(),E=d("a"),it=i(),g(A.$$.fragment),mt=i(),U=d("p"),U.textContent=Ka,dt=i(),j=d("p"),j.innerHTML=Ja,ot=i(),st=d("hr"),rt=i(),z=d("a"),nt=i(),g(B.$$.fragment),gt=i(),k=d("p"),k.textContent=qa,ut=i(),Y=d("p"),Y.innerHTML=Na,ct=i(),pt=d("hr"),ft=i(),K=d("a"),ht=i(),g(J.$$.fragment),wt=i(),q=d("p"),q.textContent=Sa,Rt=i(),N=d("p"),N.innerHTML=Za,It=i(),$t=d("hr"),_t=i(),S=d("a"),Tt=i(),g(Z.$$.fragment),bt=i(),G=d("p"),G.textContent=Ga,vt=i(),W=d("p"),W.innerHTML=Wa,Ct=i(),D=d("table"),D.innerHTML=Da,xt=i(),Ht=d("hr"),Lt=i(),O=d("a"),yt=i(),g(V.$$.fragment),Pt=i(),F=d("p"),F.textContent=Oa,Mt=i(),Q=d("p"),Q.innerHTML=Va,Et=i(),At=d("hr"),Ut=i(),X=d("a"),jt=i(),g(ee.$$.fragment),zt=i(),te=d("p"),te.textContent=Fa,Bt=i(),ae=d("p"),ae.innerHTML=Qa,kt=i(),le=d("table"),le.innerHTML=Xa,Yt=i(),Kt=d("hr"),Jt=i(),ie=d("a"),qt=i(),g(me.$$.fragment),Nt=i(),de=d("p"),de.textContent=el,St=i(),oe=d("p"),oe.innerHTML=tl,Zt=i(),se=d("table"),se.innerHTML=al,Gt=i(),Wt=d("hr"),Dt=i(),re=d("a"),Ot=i(),g(ne.$$.fragment),Vt=i(),ge=d("p"),ge.textContent=ll,Ft=i(),ue=d("p"),ue.innerHTML=il,Qt=i(),ce=d("p"),ce.innerHTML=ml,Xt=i(),g(pe.$$.fragment),ea=i(),fe=d("table"),fe.innerHTML=dl,ta=i(),aa=d("hr"),la=i(),he=d("a"),ia=i(),g(we.$$.fragment),ma=i(),Re=d("p"),Re.textContent=ol,da=i(),Ie=d("p"),Ie.innerHTML=sl,oa=i(),$e=d("table"),$e.innerHTML=rl,sa=i(),ra=d("hr"),na=i(),_e=d("a"),ga=i(),g(Te.$$.fragment),ua=i(),be=d("p"),be.textContent=nl,ca=i(),ve=d("p"),ve.innerHTML=gl,pa=i(),Ce=d("table"),Ce.innerHTML=ul,fa=i(),ha=d("hr"),wa=i(),xe=d("a"),Ra=i(),g(He.$$.fragment),Ia=i(),Le=d("p"),Le.textContent=cl,$a=i(),ye=d("p"),ye.innerHTML=pl,_a=i(),Pe=d("table"),Pe.innerHTML=fl,Ta=i(),ba=d("hr"),va=i(),Me=d("a"),Ca=i(),g(Ee.$$.fragment),xa=i(),Ae=d("p"),Ae.textContent=hl,Ha=i(),Ue=d("p"),Ue.innerHTML=wl,La=i(),ya=d("hr"),Pa=i(),ze=d("p"),this.h()},l(e){const t=bl("svelte-u9bgzb",document.head);R=o(t,"META",{name:!0,content:!0}),t.forEach(a),Be=m(e),je=o(e,"P",{}),n(je).forEach(a),ke=m(e),I=o(e,"A",{id:!0,class:!0}),n(I).forEach(a),Ye=m(e),u($.$$.fragment,e),Ke=m(e),_=o(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-18hbqrt"&&(_.textContent=Aa),Je=m(e),T=o(e,"P",{"data-svelte-h":!0}),s(T)!=="svelte-il3kl8"&&(T.textContent=Ua),qe=m(e),b=o(e,"UL",{"data-svelte-h":!0}),s(b)!=="svelte-1lzw7to"&&(b.innerHTML=ja),Ne=m(e),Se=o(e,"HR",{}),Ze=m(e),v=o(e,"A",{id:!0,class:!0}),n(v).forEach(a),Ge=m(e),u(C.$$.fragment,e),We=m(e),x=o(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-f7iksk"&&(x.innerHTML=za),De=m(e),H=o(e,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-2q61yl"&&(H.innerHTML=Ba),Oe=m(e),Ve=o(e,"HR",{}),Fe=m(e),L=o(e,"A",{id:!0,class:!0}),n(L).forEach(a),Qe=m(e),u(y.$$.fragment,e),Xe=m(e),P=o(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-36fe9a"&&(P.innerHTML=ka),et=m(e),M=o(e,"TABLE",{"data-svelte-h":!0}),s(M)!=="svelte-vkeoul"&&(M.innerHTML=Ya),tt=m(e),at=o(e,"HR",{}),lt=m(e),E=o(e,"A",{id:!0,class:!0}),n(E).forEach(a),it=m(e),u(A.$$.fragment,e),mt=m(e),U=o(e,"P",{"data-svelte-h":!0}),s(U)!=="svelte-1owjjfe"&&(U.textContent=Ka),dt=m(e),j=o(e,"P",{"data-svelte-h":!0}),s(j)!=="svelte-11e9r18"&&(j.innerHTML=Ja),ot=m(e),st=o(e,"HR",{}),rt=m(e),z=o(e,"A",{id:!0,class:!0}),n(z).forEach(a),nt=m(e),u(B.$$.fragment,e),gt=m(e),k=o(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-qyo04e"&&(k.textContent=qa),ut=m(e),Y=o(e,"P",{"data-svelte-h":!0}),s(Y)!=="svelte-11e9r18"&&(Y.innerHTML=Na),ct=m(e),pt=o(e,"HR",{}),ft=m(e),K=o(e,"A",{id:!0,class:!0}),n(K).forEach(a),ht=m(e),u(J.$$.fragment,e),wt=m(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-19kp14j"&&(q.textContent=Sa),Rt=m(e),N=o(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-11e9r18"&&(N.innerHTML=Za),It=m(e),$t=o(e,"HR",{}),_t=m(e),S=o(e,"A",{id:!0,class:!0}),n(S).forEach(a),Tt=m(e),u(Z.$$.fragment,e),bt=m(e),G=o(e,"P",{"data-svelte-h":!0}),s(G)!=="svelte-s4dm9o"&&(G.textContent=Ga),vt=m(e),W=o(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1jh8cjr"&&(W.innerHTML=Wa),Ct=m(e),D=o(e,"TABLE",{"data-svelte-h":!0}),s(D)!=="svelte-ya0vko"&&(D.innerHTML=Da),xt=m(e),Ht=o(e,"HR",{}),Lt=m(e),O=o(e,"A",{id:!0,class:!0}),n(O).forEach(a),yt=m(e),u(V.$$.fragment,e),Pt=m(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1eu6jk3"&&(F.textContent=Oa),Mt=m(e),Q=o(e,"P",{"data-svelte-h":!0}),s(Q)!=="svelte-1w4hta5"&&(Q.innerHTML=Va),Et=m(e),At=o(e,"HR",{}),Ut=m(e),X=o(e,"A",{id:!0,class:!0}),n(X).forEach(a),jt=m(e),u(ee.$$.fragment,e),zt=m(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-5ze294"&&(te.textContent=Fa),Bt=m(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-11e9r18"&&(ae.innerHTML=Qa),kt=m(e),le=o(e,"TABLE",{"data-svelte-h":!0}),s(le)!=="svelte-1hxqxaq"&&(le.innerHTML=Xa),Yt=m(e),Kt=o(e,"HR",{}),Jt=m(e),ie=o(e,"A",{id:!0,class:!0}),n(ie).forEach(a),qt=m(e),u(me.$$.fragment,e),Nt=m(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-119su55"&&(de.textContent=el),St=m(e),oe=o(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-1epyezb"&&(oe.innerHTML=tl),Zt=m(e),se=o(e,"TABLE",{"data-svelte-h":!0}),s(se)!=="svelte-1h4z9xq"&&(se.innerHTML=al),Gt=m(e),Wt=o(e,"HR",{}),Dt=m(e),re=o(e,"A",{id:!0,class:!0}),n(re).forEach(a),Ot=m(e),u(ne.$$.fragment,e),Vt=m(e),ge=o(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-5659h9"&&(ge.textContent=ll),Ft=m(e),ue=o(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1800vfp"&&(ue.innerHTML=il),Qt=m(e),ce=o(e,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-14z54gq"&&(ce.innerHTML=ml),Xt=m(e),u(pe.$$.fragment,e),ea=m(e),fe=o(e,"TABLE",{"data-svelte-h":!0}),s(fe)!=="svelte-eqolu5"&&(fe.innerHTML=dl),ta=m(e),aa=o(e,"HR",{}),la=m(e),he=o(e,"A",{id:!0,class:!0}),n(he).forEach(a),ia=m(e),u(we.$$.fragment,e),ma=m(e),Re=o(e,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1355z3u"&&(Re.textContent=ol),da=m(e),Ie=o(e,"P",{"data-svelte-h":!0}),s(Ie)!=="svelte-10btw3j"&&(Ie.innerHTML=sl),oa=m(e),$e=o(e,"TABLE",{"data-svelte-h":!0}),s($e)!=="svelte-ncveta"&&($e.innerHTML=rl),sa=m(e),ra=o(e,"HR",{}),na=m(e),_e=o(e,"A",{id:!0,class:!0}),n(_e).forEach(a),ga=m(e),u(Te.$$.fragment,e),ua=m(e),be=o(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-1s704mu"&&(be.textContent=nl),ca=m(e),ve=o(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-10btw3j"&&(ve.innerHTML=gl),pa=m(e),Ce=o(e,"TABLE",{"data-svelte-h":!0}),s(Ce)!=="svelte-34rbhe"&&(Ce.innerHTML=ul),fa=m(e),ha=o(e,"HR",{}),wa=m(e),xe=o(e,"A",{id:!0,class:!0}),n(xe).forEach(a),Ra=m(e),u(He.$$.fragment,e),Ia=m(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-nwy2y"&&(Le.textContent=cl),$a=m(e),ye=o(e,"P",{"data-svelte-h":!0}),s(ye)!=="svelte-sl3vqa"&&(ye.innerHTML=pl),_a=m(e),Pe=o(e,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-t797x5"&&(Pe.innerHTML=fl),Ta=m(e),ba=o(e,"HR",{}),va=m(e),Me=o(e,"A",{id:!0,class:!0}),n(Me).forEach(a),Ca=m(e),u(Ee.$$.fragment,e),xa=m(e),Ae=o(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-15u13r6"&&(Ae.textContent=hl),Ha=m(e),Ue=o(e,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1cwm6ga"&&(Ue.innerHTML=wl),La=m(e),ya=o(e,"HR",{}),Pa=m(e),ze=o(e,"P",{}),n(ze).forEach(a),this.h()},h(){r(R,"name","hf:doc:metadata"),r(R,"content",Hl),r(I,"id","module_utils/image"),r(I,"class","group"),r(v,"id","module_utils/image.RawImage"),r(v,"class","group"),r(L,"id","new_module_utils/image.RawImage_new"),r(L,"class","group"),r(E,"id","module_utils/image.RawImage+grayscale"),r(E,"class","group"),r(z,"id","module_utils/image.RawImage+rgb"),r(z,"class","group"),r(K,"id","module_utils/image.RawImage+rgba"),r(K,"class","group"),r(S,"id","module_utils/image.RawImage+resize"),r(S,"class","group"),r(O,"id","module_utils/image.RawImage+clone"),r(O,"class","group"),r(X,"id","module_utils/image.RawImage+convert"),r(X,"class","group"),r(ie,"id","module_utils/image.RawImage+save"),r(ie,"class","group"),r(re,"id","module_utils/image.RawImage.read"),r(re,"class","group"),r(he,"id","module_utils/image.RawImage.fromURL"),r(he,"class","group"),r(_e,"id","module_utils/image.RawImage.fromBlob"),r(_e,"class","group"),r(xe,"id","module_utils/image.RawImage.fromTensor"),r(xe,"class","group"),r(Me,"id","module_utils/image..CONTENT_TYPE_MAP"),r(Me,"class","group")},m(e,t){vl(document.head,R),l(e,Be,t),l(e,je,t),l(e,ke,t),l(e,I,t),l(e,Ye,t),c($,e,t),l(e,Ke,t),l(e,_,t),l(e,Je,t),l(e,T,t),l(e,qe,t),l(e,b,t),l(e,Ne,t),l(e,Se,t),l(e,Ze,t),l(e,v,t),l(e,Ge,t),c(C,e,t),l(e,We,t),l(e,x,t),l(e,De,t),l(e,H,t),l(e,Oe,t),l(e,Ve,t),l(e,Fe,t),l(e,L,t),l(e,Qe,t),c(y,e,t),l(e,Xe,t),l(e,P,t),l(e,et,t),l(e,M,t),l(e,tt,t),l(e,at,t),l(e,lt,t),l(e,E,t),l(e,it,t),c(A,e,t),l(e,mt,t),l(e,U,t),l(e,dt,t),l(e,j,t),l(e,ot,t),l(e,st,t),l(e,rt,t),l(e,z,t),l(e,nt,t),c(B,e,t),l(e,gt,t),l(e,k,t),l(e,ut,t),l(e,Y,t),l(e,ct,t),l(e,pt,t),l(e,ft,t),l(e,K,t),l(e,ht,t),c(J,e,t),l(e,wt,t),l(e,q,t),l(e,Rt,t),l(e,N,t),l(e,It,t),l(e,$t,t),l(e,_t,t),l(e,S,t),l(e,Tt,t),c(Z,e,t),l(e,bt,t),l(e,G,t),l(e,vt,t),l(e,W,t),l(e,Ct,t),l(e,D,t),l(e,xt,t),l(e,Ht,t),l(e,Lt,t),l(e,O,t),l(e,yt,t),c(V,e,t),l(e,Pt,t),l(e,F,t),l(e,Mt,t),l(e,Q,t),l(e,Et,t),l(e,At,t),l(e,Ut,t),l(e,X,t),l(e,jt,t),c(ee,e,t),l(e,zt,t),l(e,te,t),l(e,Bt,t),l(e,ae,t),l(e,kt,t),l(e,le,t),l(e,Yt,t),l(e,Kt,t),l(e,Jt,t),l(e,ie,t),l(e,qt,t),c(me,e,t),l(e,Nt,t),l(e,de,t),l(e,St,t),l(e,oe,t),l(e,Zt,t),l(e,se,t),l(e,Gt,t),l(e,Wt,t),l(e,Dt,t),l(e,re,t),l(e,Ot,t),c(ne,e,t),l(e,Vt,t),l(e,ge,t),l(e,Ft,t),l(e,ue,t),l(e,Qt,t),l(e,ce,t),l(e,Xt,t),c(pe,e,t),l(e,ea,t),l(e,fe,t),l(e,ta,t),l(e,aa,t),l(e,la,t),l(e,he,t),l(e,ia,t),c(we,e,t),l(e,ma,t),l(e,Re,t),l(e,da,t),l(e,Ie,t),l(e,oa,t),l(e,$e,t),l(e,sa,t),l(e,ra,t),l(e,na,t),l(e,_e,t),l(e,ga,t),c(Te,e,t),l(e,ua,t),l(e,be,t),l(e,ca,t),l(e,ve,t),l(e,pa,t),l(e,Ce,t),l(e,fa,t),l(e,ha,t),l(e,wa,t),l(e,xe,t),l(e,Ra,t),c(He,e,t),l(e,Ia,t),l(e,Le,t),l(e,$a,t),l(e,ye,t),l(e,_a,t),l(e,Pe,t),l(e,Ta,t),l(e,ba,t),l(e,va,t),l(e,Me,t),l(e,Ca,t),c(Ee,e,t),l(e,xa,t),l(e,Ae,t),l(e,Ha,t),l(e,Ue,t),l(e,La,t),l(e,ya,t),l(e,Pa,t),l(e,ze,t),Ma=!0},p:Il,i(e){Ma||(p($.$$.fragment,e),p(C.$$.fragment,e),p(y.$$.fragment,e),p(A.$$.fragment,e),p(B.$$.fragment,e),p(J.$$.fragment,e),p(Z.$$.fragment,e),p(V.$$.fragment,e),p(ee.$$.fragment,e),p(me.$$.fragment,e),p(ne.$$.fragment,e),p(pe.$$.fragment,e),p(we.$$.fragment,e),p(Te.$$.fragment,e),p(He.$$.fragment,e),p(Ee.$$.fragment,e),Ma=!0)},o(e){f($.$$.fragment,e),f(C.$$.fragment,e),f(y.$$.fragment,e),f(A.$$.fragment,e),f(B.$$.fragment,e),f(J.$$.fragment,e),f(Z.$$.fragment,e),f(V.$$.fragment,e),f(ee.$$.fragment,e),f(me.$$.fragment,e),f(ne.$$.fragment,e),f(pe.$$.fragment,e),f(we.$$.fragment,e),f(Te.$$.fragment,e),f(He.$$.fragment,e),f(Ee.$$.fragment,e),Ma=!1},d(e){e&&(a(Be),a(je),a(ke),a(I),a(Ye),a(Ke),a(_),a(Je),a(T),a(qe),a(b),a(Ne),a(Se),a(Ze),a(v),a(Ge),a(We),a(x),a(De),a(H),a(Oe),a(Ve),a(Fe),a(L),a(Qe),a(Xe),a(P),a(et),a(M),a(tt),a(at),a(lt),a(E),a(it),a(mt),a(U),a(dt),a(j),a(ot),a(st),a(rt),a(z),a(nt),a(gt),a(k),a(ut),a(Y),a(ct),a(pt),a(ft),a(K),a(ht),a(wt),a(q),a(Rt),a(N),a(It),a($t),a(_t),a(S),a(Tt),a(bt),a(G),a(vt),a(W),a(Ct),a(D),a(xt),a(Ht),a(Lt),a(O),a(yt),a(Pt),a(F),a(Mt),a(Q),a(Et),a(At),a(Ut),a(X),a(jt),a(zt),a(te),a(Bt),a(ae),a(kt),a(le),a(Yt),a(Kt),a(Jt),a(ie),a(qt),a(Nt),a(de),a(St),a(oe),a(Zt),a(se),a(Gt),a(Wt),a(Dt),a(re),a(Ot),a(Vt),a(ge),a(Ft),a(ue),a(Qt),a(ce),a(Xt),a(ea),a(fe),a(ta),a(aa),a(la),a(he),a(ia),a(ma),a(Re),a(da),a(Ie),a(oa),a($e),a(sa),a(ra),a(na),a(_e),a(ga),a(ua),a(be),a(ca),a(ve),a(pa),a(Ce),a(fa),a(ha),a(wa),a(xe),a(Ra),a(Ia),a(Le),a($a),a(ye),a(_a),a(Pe),a(Ta),a(ba),a(va),a(Me),a(Ca),a(xa),a(Ae),a(Ha),a(Ue),a(La),a(ya),a(Pa),a(ze)),a(R),h($,e),h(C,e),h(y,e),h(A,e),h(B,e),h(J,e),h(Z,e),h(V,e),h(ee,e),h(me,e),h(ne,e),h(pe,e),h(we,e),h(Te,e),h(He,e),h(Ee,e)}}}const Hl='{"title":"utils/image","local":"utilsimage","sections":[{"title":"utils/image.RawImage","local":"utilsimagerawimage","sections":[{"title":"new RawImage(data, width, height, channels)","local":"new-rawimagedata-width-height-channels","sections":[],"depth":3},{"title":"rawImage.grayscale() ⇒ <code> RawImage </code>","local":"rawimagegrayscale--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgb() ⇒ <code> RawImage </code>","local":"rawimagergb--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgba() ⇒ <code> RawImage </code>","local":"rawimagergba--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>","local":"rawimageresizewidth-height-options--code-promise--rawimage--code","sections":[],"depth":3},{"title":"rawImage.clone() ⇒ <code> RawImage </code>","local":"rawimageclone--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.convert(numChannels) ⇒ <code> RawImage </code>","local":"rawimageconvertnumchannels--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.save(path)","local":"rawimagesavepath","sections":[],"depth":3},{"title":"RawImage.read(input) ⇒ <code> * </code>","local":"rawimagereadinput--code--code","sections":[],"depth":3},{"title":"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromurlurl--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromblobblob--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromTensor(tensor)","local":"rawimagefromtensortensor","sections":[],"depth":3}],"depth":2},{"title":"utils/image~CONTENT_TYPE_MAP","local":"utilsimagecontenttypemap","sections":[],"depth":2}],"depth":1}';function Ll(Ea){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Al extends _l{constructor(R){super(),Tl(this,R,Ll,xl,Rl,{})}}export{Al as component};
