import{s as _l,o as Zl,n as $l}from"../chunks/scheduler.c57aa7ef.js";import{S as jl,i as vl,g as i,s,r as p,A as Ul,h as o,f as a,c as n,j as Tl,u as d,x as r,k as Ua,y as kl,a as l,v as m,d as h,t as f,w as u}from"../chunks/index.c50cb18e.js";import{T as Jl}from"../chunks/Tip.9268b0ca.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as y,E as Cl}from"../chunks/EditOnGithub.958a8a49.js";function Rl(Pe){let c,g='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:$l,d(w){w&&a(c)}}}function Ll(Pe){let c,g='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:$l,d(w){w&&a(c)}}}function Bl(Pe){let c,g,w,b,_,Ke,Z,ka='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Oe,j,Ca="This guide explores in more detail other options and features for using LoRA.",et,v,tt,U,Ra='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',at,k,La='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',lt,C,st,R,Ba="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",nt,L,it,B,ot,I,Ia='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',rt,W,Wa="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",pt,G,dt,A,Ga="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",mt,Q,ht,X,Aa='For detailed instruction on using PiSSA, please follow <a href="https://github.com/fxmeng/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',ft,V,ut,q,Qa='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',ct,x,Xa="You just need to pass a single additional option to use OLoRA:",Mt,H,wt,F,Va='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',yt,z,gt,E,bt,Y,qa='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Tt,N,xa="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Jt,S,$t,P,Ha="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",_t,D,Zt,K,Fa='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',jt,O,za="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",vt,ee,Ea="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",Ut,te,Ya="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",kt,T,Ct,ae,Rt,le,Na='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Lt,se,Bt,ne,It,ie,Sa='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Wt,oe,Gt,re,At,pe,Pa='<li>DoRA only supports linear and Conv2d layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Qt,de,Xt,me,Da='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Vt,he,qt,fe,xt,ue,Ka='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Ht,ce,Ft,Me,Oa='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',zt,we,el=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Et,ye,Yt,ge,tl='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Nt,be,al="Below is a diagram that explains the intuition of LoRA adapter merging:",St,J,ll='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',Pt,Te,sl="We show in the snippets below how to run that using PEFT.",Dt,Je,Kt,$e,nl='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',Ot,_e,ea,Ze,il='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',ta,je,ol="First load the base model:",aa,ve,la,Ue,rl="Then we load the first adapter:",sa,ke,na,Ce,pl="Then load a different adapter and merge it with the first one:",ia,Re,oa,$,ra,Le,dl="Now, perform inference:",pa,Be,da,Ie,ma,We,ml='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',ha,Ge,fa,Ae,hl='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',ua,Qe,ca,Xe,Ma,Ve,fl="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",wa,qe,ul="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an examle of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",ya,xe,ga,He,cl="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",ba,Fe,Ta,ze,Ml="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",Ja,Ee,$a,Ye,wl="Using this features has some drawbacks, namely:",_a,Ne,yl='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Za,Se,ja,De,va;return _=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),v=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),C=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),L=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),B=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),G=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),Q=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),V=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),H=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),z=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),E=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),S=new y({props:{title:"A more convienient way",local:"a-more-convienient-way",headingTag:"h4"}}),D=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),T=new Jl({props:{$$slots:{default:[Rl]},$$scope:{ctx:Pe}}}),ae=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),se=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ne=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),oe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),re=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),de=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),he=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),fe=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),ce=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),ye=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),Je=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),_e=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),ve=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),ke=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Re=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),$=new Jl({props:{$$slots:{default:[Ll]},$$scope:{ctx:Pe}}}),Be=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Ie=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Ge=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Qe=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Xe=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),xe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Fe=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Ee=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),Se=new Cl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),g=s(),w=i("p"),b=s(),p(_.$$.fragment),Ke=s(),Z=i("p"),Z.innerHTML=ka,Oe=s(),j=i("p"),j.textContent=Ca,et=s(),p(v.$$.fragment),tt=s(),U=i("p"),U.innerHTML=Ra,at=s(),k=i("p"),k.innerHTML=La,lt=s(),p(C.$$.fragment),st=s(),R=i("p"),R.innerHTML=Ba,nt=s(),p(L.$$.fragment),it=s(),p(B.$$.fragment),ot=s(),I=i("p"),I.innerHTML=Ia,rt=s(),W=i("p"),W.textContent=Wa,pt=s(),p(G.$$.fragment),dt=s(),A=i("p"),A.textContent=Ga,mt=s(),p(Q.$$.fragment),ht=s(),X=i("p"),X.innerHTML=Aa,ft=s(),p(V.$$.fragment),ut=s(),q=i("p"),q.innerHTML=Qa,ct=s(),x=i("p"),x.textContent=Xa,Mt=s(),p(H.$$.fragment),wt=s(),F=i("p"),F.innerHTML=Va,yt=s(),p(z.$$.fragment),gt=s(),p(E.$$.fragment),bt=s(),Y=i("p"),Y.innerHTML=qa,Tt=s(),N=i("p"),N.innerHTML=xa,Jt=s(),p(S.$$.fragment),$t=s(),P=i("p"),P.innerHTML=Ha,_t=s(),p(D.$$.fragment),Zt=s(),K=i("p"),K.innerHTML=Fa,jt=s(),O=i("p"),O.innerHTML=za,vt=s(),ee=i("p"),ee.innerHTML=Ea,Ut=s(),te=i("ul"),te.innerHTML=Ya,kt=s(),p(T.$$.fragment),Ct=s(),p(ae.$$.fragment),Rt=s(),le=i("p"),le.innerHTML=Na,Lt=s(),p(se.$$.fragment),Bt=s(),p(ne.$$.fragment),It=s(),ie=i("p"),ie.innerHTML=Sa,Wt=s(),p(oe.$$.fragment),Gt=s(),p(re.$$.fragment),At=s(),pe=i("ul"),pe.innerHTML=Pa,Qt=s(),p(de.$$.fragment),Xt=s(),me=i("p"),me.innerHTML=Da,Vt=s(),p(he.$$.fragment),qt=s(),p(fe.$$.fragment),xt=s(),ue=i("p"),ue.innerHTML=Ka,Ht=s(),p(ce.$$.fragment),Ft=s(),Me=i("p"),Me.innerHTML=Oa,zt=s(),we=i("p"),we.innerHTML=el,Et=s(),p(ye.$$.fragment),Yt=s(),ge=i("p"),ge.innerHTML=tl,Nt=s(),be=i("p"),be.textContent=al,St=s(),J=i("div"),J.innerHTML=ll,Pt=s(),Te=i("p"),Te.textContent=sl,Dt=s(),p(Je.$$.fragment),Kt=s(),$e=i("p"),$e.innerHTML=nl,Ot=s(),p(_e.$$.fragment),ea=s(),Ze=i("p"),Ze.innerHTML=il,ta=s(),je=i("p"),je.textContent=ol,aa=s(),p(ve.$$.fragment),la=s(),Ue=i("p"),Ue.textContent=rl,sa=s(),p(ke.$$.fragment),na=s(),Ce=i("p"),Ce.textContent=pl,ia=s(),p(Re.$$.fragment),oa=s(),p($.$$.fragment),ra=s(),Le=i("p"),Le.textContent=dl,pa=s(),p(Be.$$.fragment),da=s(),p(Ie.$$.fragment),ma=s(),We=i("p"),We.innerHTML=ml,ha=s(),p(Ge.$$.fragment),fa=s(),Ae=i("p"),Ae.innerHTML=hl,ua=s(),p(Qe.$$.fragment),ca=s(),p(Xe.$$.fragment),Ma=s(),Ve=i("p"),Ve.textContent=fl,wa=s(),qe=i("p"),qe.innerHTML=ul,ya=s(),p(xe.$$.fragment),ga=s(),He=i("p"),He.innerHTML=cl,ba=s(),p(Fe.$$.fragment),Ta=s(),ze=i("p"),ze.innerHTML=Ml,Ja=s(),p(Ee.$$.fragment),$a=s(),Ye=i("p"),Ye.textContent=wl,_a=s(),Ne=i("ul"),Ne.innerHTML=yl,Za=s(),p(Se.$$.fragment),ja=s(),De=i("p"),this.h()},l(e){const t=Ul("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),g=n(e),w=o(e,"P",{}),Tl(w).forEach(a),b=n(e),d(_.$$.fragment,e),Ke=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-38uxl6"&&(Z.innerHTML=ka),Oe=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ovsn32"&&(j.textContent=Ca),et=n(e),d(v.$$.fragment,e),tt=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-j883mf"&&(U.innerHTML=Ra),at=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1fujb7a"&&(k.innerHTML=La),lt=n(e),d(C.$$.fragment,e),st=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-mwvui1"&&(R.innerHTML=Ba),nt=n(e),d(L.$$.fragment,e),it=n(e),d(B.$$.fragment,e),ot=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1skluc"&&(I.innerHTML=Ia),rt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1hy0lgx"&&(W.textContent=Wa),pt=n(e),d(G.$$.fragment,e),dt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-auzrbb"&&(A.textContent=Ga),mt=n(e),d(Q.$$.fragment,e),ht=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-u5znzv"&&(X.innerHTML=Aa),ft=n(e),d(V.$$.fragment,e),ut=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-17kc0j8"&&(q.innerHTML=Qa),ct=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1j9g8qn"&&(x.textContent=Xa),Mt=n(e),d(H.$$.fragment,e),wt=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-sulxp4"&&(F.innerHTML=Va),yt=n(e),d(z.$$.fragment,e),gt=n(e),d(E.$$.fragment,e),bt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ts8vpq"&&(Y.innerHTML=qa),Tt=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-7f0aai"&&(N.innerHTML=xa),Jt=n(e),d(S.$$.fragment,e),$t=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-14vtcq9"&&(P.innerHTML=Ha),_t=n(e),d(D.$$.fragment,e),Zt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1nywyxh"&&(K.innerHTML=Fa),jt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1d2jix1"&&(O.innerHTML=za),vt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-yl8kok"&&(ee.innerHTML=Ea),Ut=n(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-12tl4fy"&&(te.innerHTML=Ya),kt=n(e),d(T.$$.fragment,e),Ct=n(e),d(ae.$$.fragment,e),Rt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-omuw13"&&(le.innerHTML=Na),Lt=n(e),d(se.$$.fragment,e),Bt=n(e),d(ne.$$.fragment,e),It=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ukfkwt"&&(ie.innerHTML=Sa),Wt=n(e),d(oe.$$.fragment,e),Gt=n(e),d(re.$$.fragment,e),At=n(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-1lkjk8m"&&(pe.innerHTML=Pa),Qt=n(e),d(de.$$.fragment,e),Xt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-15vxux2"&&(me.innerHTML=Da),Vt=n(e),d(he.$$.fragment,e),qt=n(e),d(fe.$$.fragment,e),xt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1mosto0"&&(ue.innerHTML=Ka),Ht=n(e),d(ce.$$.fragment,e),Ft=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1safyei"&&(Me.innerHTML=Oa),zt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-foj0wd"&&(we.innerHTML=el),Et=n(e),d(ye.$$.fragment,e),Yt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1c3h9aa"&&(ge.innerHTML=tl),Nt=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1wwmf5r"&&(be.textContent=al),St=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1f6iuw5"&&(J.innerHTML=ll),Pt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-hlzwis"&&(Te.textContent=sl),Dt=n(e),d(Je.$$.fragment,e),Kt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-m3cr6r"&&($e.innerHTML=nl),Ot=n(e),d(_e.$$.fragment,e),ea=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-kbqhpl"&&(Ze.innerHTML=il),ta=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1mwdwt1"&&(je.textContent=ol),aa=n(e),d(ve.$$.fragment,e),la=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-nuhu05"&&(Ue.textContent=rl),sa=n(e),d(ke.$$.fragment,e),na=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1n53hd9"&&(Ce.textContent=pl),ia=n(e),d(Re.$$.fragment,e),oa=n(e),d($.$$.fragment,e),ra=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-qwbdkg"&&(Le.textContent=dl),pa=n(e),d(Be.$$.fragment,e),da=n(e),d(Ie.$$.fragment,e),ma=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-ke62q2"&&(We.innerHTML=ml),ha=n(e),d(Ge.$$.fragment,e),fa=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-cvmoj6"&&(Ae.innerHTML=hl),ua=n(e),d(Qe.$$.fragment,e),ca=n(e),d(Xe.$$.fragment,e),Ma=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1fq5tpu"&&(Ve.textContent=fl),wa=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-6zt8d6"&&(qe.innerHTML=ul),ya=n(e),d(xe.$$.fragment,e),ga=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-6wkyom"&&(He.innerHTML=cl),ba=n(e),d(Fe.$$.fragment,e),Ta=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1o40ch6"&&(ze.innerHTML=Ml),Ja=n(e),d(Ee.$$.fragment,e),$a=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-fpz5mj"&&(Ye.textContent=wl),_a=n(e),Ne=o(e,"UL",{"data-svelte-h":!0}),r(Ne)!=="svelte-1jk1r7d"&&(Ne.innerHTML=yl),Za=n(e),d(Se.$$.fragment,e),ja=n(e),De=o(e,"P",{}),Tl(De).forEach(a),this.h()},h(){Ua(c,"name","hf:doc:metadata"),Ua(c,"content",Il),Ua(J,"class","flex justify-center")},m(e,t){kl(document.head,c),l(e,g,t),l(e,w,t),l(e,b,t),m(_,e,t),l(e,Ke,t),l(e,Z,t),l(e,Oe,t),l(e,j,t),l(e,et,t),m(v,e,t),l(e,tt,t),l(e,U,t),l(e,at,t),l(e,k,t),l(e,lt,t),m(C,e,t),l(e,st,t),l(e,R,t),l(e,nt,t),m(L,e,t),l(e,it,t),m(B,e,t),l(e,ot,t),l(e,I,t),l(e,rt,t),l(e,W,t),l(e,pt,t),m(G,e,t),l(e,dt,t),l(e,A,t),l(e,mt,t),m(Q,e,t),l(e,ht,t),l(e,X,t),l(e,ft,t),m(V,e,t),l(e,ut,t),l(e,q,t),l(e,ct,t),l(e,x,t),l(e,Mt,t),m(H,e,t),l(e,wt,t),l(e,F,t),l(e,yt,t),m(z,e,t),l(e,gt,t),m(E,e,t),l(e,bt,t),l(e,Y,t),l(e,Tt,t),l(e,N,t),l(e,Jt,t),m(S,e,t),l(e,$t,t),l(e,P,t),l(e,_t,t),m(D,e,t),l(e,Zt,t),l(e,K,t),l(e,jt,t),l(e,O,t),l(e,vt,t),l(e,ee,t),l(e,Ut,t),l(e,te,t),l(e,kt,t),m(T,e,t),l(e,Ct,t),m(ae,e,t),l(e,Rt,t),l(e,le,t),l(e,Lt,t),m(se,e,t),l(e,Bt,t),m(ne,e,t),l(e,It,t),l(e,ie,t),l(e,Wt,t),m(oe,e,t),l(e,Gt,t),m(re,e,t),l(e,At,t),l(e,pe,t),l(e,Qt,t),m(de,e,t),l(e,Xt,t),l(e,me,t),l(e,Vt,t),m(he,e,t),l(e,qt,t),m(fe,e,t),l(e,xt,t),l(e,ue,t),l(e,Ht,t),m(ce,e,t),l(e,Ft,t),l(e,Me,t),l(e,zt,t),l(e,we,t),l(e,Et,t),m(ye,e,t),l(e,Yt,t),l(e,ge,t),l(e,Nt,t),l(e,be,t),l(e,St,t),l(e,J,t),l(e,Pt,t),l(e,Te,t),l(e,Dt,t),m(Je,e,t),l(e,Kt,t),l(e,$e,t),l(e,Ot,t),m(_e,e,t),l(e,ea,t),l(e,Ze,t),l(e,ta,t),l(e,je,t),l(e,aa,t),m(ve,e,t),l(e,la,t),l(e,Ue,t),l(e,sa,t),m(ke,e,t),l(e,na,t),l(e,Ce,t),l(e,ia,t),m(Re,e,t),l(e,oa,t),m($,e,t),l(e,ra,t),l(e,Le,t),l(e,pa,t),m(Be,e,t),l(e,da,t),m(Ie,e,t),l(e,ma,t),l(e,We,t),l(e,ha,t),m(Ge,e,t),l(e,fa,t),l(e,Ae,t),l(e,ua,t),m(Qe,e,t),l(e,ca,t),m(Xe,e,t),l(e,Ma,t),l(e,Ve,t),l(e,wa,t),l(e,qe,t),l(e,ya,t),m(xe,e,t),l(e,ga,t),l(e,He,t),l(e,ba,t),m(Fe,e,t),l(e,Ta,t),l(e,ze,t),l(e,Ja,t),m(Ee,e,t),l(e,$a,t),l(e,Ye,t),l(e,_a,t),l(e,Ne,t),l(e,Za,t),m(Se,e,t),l(e,ja,t),l(e,De,t),va=!0},p(e,[t]){const gl={};t&2&&(gl.$$scope={dirty:t,ctx:e}),T.$set(gl);const bl={};t&2&&(bl.$$scope={dirty:t,ctx:e}),$.$set(bl)},i(e){va||(h(_.$$.fragment,e),h(v.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(Q.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(T.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(ce.$$.fragment,e),h(ye.$$.fragment,e),h(Je.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Re.$$.fragment,e),h($.$$.fragment,e),h(Be.$$.fragment,e),h(Ie.$$.fragment,e),h(Ge.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(xe.$$.fragment,e),h(Fe.$$.fragment,e),h(Ee.$$.fragment,e),h(Se.$$.fragment,e),va=!0)},o(e){f(_.$$.fragment,e),f(v.$$.fragment,e),f(C.$$.fragment,e),f(L.$$.fragment,e),f(B.$$.fragment,e),f(G.$$.fragment,e),f(Q.$$.fragment,e),f(V.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(T.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ce.$$.fragment,e),f(ye.$$.fragment,e),f(Je.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(Re.$$.fragment,e),f($.$$.fragment,e),f(Be.$$.fragment,e),f(Ie.$$.fragment,e),f(Ge.$$.fragment,e),f(Qe.$$.fragment,e),f(Xe.$$.fragment,e),f(xe.$$.fragment,e),f(Fe.$$.fragment,e),f(Ee.$$.fragment,e),f(Se.$$.fragment,e),va=!1},d(e){e&&(a(g),a(w),a(b),a(Ke),a(Z),a(Oe),a(j),a(et),a(tt),a(U),a(at),a(k),a(lt),a(st),a(R),a(nt),a(it),a(ot),a(I),a(rt),a(W),a(pt),a(dt),a(A),a(mt),a(ht),a(X),a(ft),a(ut),a(q),a(ct),a(x),a(Mt),a(wt),a(F),a(yt),a(gt),a(bt),a(Y),a(Tt),a(N),a(Jt),a($t),a(P),a(_t),a(Zt),a(K),a(jt),a(O),a(vt),a(ee),a(Ut),a(te),a(kt),a(Ct),a(Rt),a(le),a(Lt),a(Bt),a(It),a(ie),a(Wt),a(Gt),a(At),a(pe),a(Qt),a(Xt),a(me),a(Vt),a(qt),a(xt),a(ue),a(Ht),a(Ft),a(Me),a(zt),a(we),a(Et),a(Yt),a(ge),a(Nt),a(be),a(St),a(J),a(Pt),a(Te),a(Dt),a(Kt),a($e),a(Ot),a(ea),a(Ze),a(ta),a(je),a(aa),a(la),a(Ue),a(sa),a(na),a(Ce),a(ia),a(oa),a(ra),a(Le),a(pa),a(da),a(ma),a(We),a(ha),a(fa),a(Ae),a(ua),a(ca),a(Ma),a(Ve),a(wa),a(qe),a(ya),a(ga),a(He),a(ba),a(Ta),a(ze),a(Ja),a($a),a(Ye),a(_a),a(Ne),a(Za),a(ja),a(De)),a(c),u(_,e),u(v,e),u(C,e),u(L,e),u(B,e),u(G,e),u(Q,e),u(V,e),u(H,e),u(z,e),u(E,e),u(S,e),u(D,e),u(T,e),u(ae,e),u(se,e),u(ne,e),u(oe,e),u(re,e),u(de,e),u(he,e),u(fe,e),u(ce,e),u(ye,e),u(Je,e),u(_e,e),u(ve,e),u(ke,e),u(Re,e),u($,e),u(Be,e),u(Ie,e),u(Ge,e),u(Qe,e),u(Xe,e),u(xe,e),u(Fe,e),u(Ee,e),u(Se,e)}}}const Il='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convienient way","local":"a-more-convienient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wl(Pe){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends jl{constructor(c){super(),vl(this,c,Wl,Bl,_l,{})}}export{ql as component};
