import{s as ua,o as ha,n as V}from"../chunks/scheduler.8c3d61f6.js";import{S as _a,i as ba,g as l,s as a,r as f,A as va,h as r,f as i,c as o,j as T,u,x as c,k as C,y as t,a as g,v as h,d as _,t as b,w as v}from"../chunks/index.da70eac4.js";import{T as Et}from"../chunks/Tip.1d9b8c37.js";import{D as J}from"../chunks/Docstring.6b390b9a.js";import{C as Y}from"../chunks/CodeBlock.00a903b3.js";import{E as Nt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as ot,E as Ia}from"../chunks/EditOnGithub.1e64e623.js";function wa(P){let n,I='For text-to-image we use <code>stabilityai/stable-diffusion-2-1-unclip-small</code> as it was trained on CLIP ViT-L/14 embedding, the same as the Karlo model prior. <a href="https://hf.co/stabilityai/stable-diffusion-2-1-unclip" rel="nofollow">stabilityai/stable-diffusion-2-1-unclip</a> was trained on OpenCLIP ViT-H, so we don’t recommend its use.';return{c(){n=l("p"),n.innerHTML=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),c(n)!=="svelte-ascgy4"&&(n.innerHTML=I)},m(d,m){g(d,n,m)},p:V,d(d){d&&i(n)}}}function ya(P){let n,I='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){n=l("p"),n.innerHTML=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),c(n)!=="svelte-1wmc0l4"&&(n.innerHTML=I)},m(d,m){g(d,n,m)},p:V,d(d){d&&i(n)}}}function $a(P){let n,I="Examples:",d,m,w;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZ1c2luZyUyRnN0YWJsZS11bmNsaXAtMi0xLWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTIwJTIwJTIzJTIwVE9ETyUyMHVwZGF0ZSUyMG1vZGVsJTIwcGF0aCUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2hvcnNlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_horse.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=a(),f(m.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),c(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(s),u(m.$$.fragment,s)},m(s,M){g(s,n,M),g(s,d,M),h(m,s,M),w=!0},p:V,i(s){w||(_(m.$$.fragment,s),w=!0)},o(s){b(m.$$.fragment,s),w=!1},d(s){s&&(i(n),i(d)),v(m,s)}}}function Ma(P){let n,I=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),c(n)!=="svelte-ackzsn"&&(n.innerHTML=I)},m(d,m){g(d,n,m)},p:V,d(d){d&&i(n)}}}function xa(P){let n,I="Examples:",d,m,w;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=a(),f(m.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),c(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(s),u(m.$$.fragment,s)},m(s,M){g(s,n,M),g(s,d,M),h(m,s,M),w=!0},p:V,i(s){w||(_(m.$$.fragment,s),w=!0)},o(s){b(m.$$.fragment,s),w=!1},d(s){s&&(i(n),i(d)),v(m,s)}}}function Ua(P){let n,I=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),c(n)!=="svelte-17p1lpg"&&(n.textContent=I)},m(d,m){g(d,n,m)},p:V,d(d){d&&i(n)}}}function Pa(P){let n,I="Examples:",d,m,w;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=a(),f(m.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),c(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(s),u(m.$$.fragment,s)},m(s,M){g(s,n,M),g(s,d,M),h(m,s,M),w=!0},p:V,i(s){w||(_(m.$$.fragment,s),w=!0)},o(s){b(m.$$.fragment,s),w=!1},d(s){s&&(i(n),i(d)),v(m,s)}}}function Ta(P){let n,I="Examples:",d,m,w;return m=new Y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS11bmNsaXAtc21hbGwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoaW5pdF9pbWFnZSUyQyUyMHByb21wdCkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(init_image, prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=a(),f(m.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),c(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(s),u(m.$$.fragment,s)},m(s,M){g(s,n,M),g(s,d,M),h(m,s,M),w=!0},p:V,i(s){w||(_(m.$$.fragment,s),w=!0)},o(s){b(m.$$.fragment,s),w=!1},d(s){s&&(i(n),i(d)),v(m,s)}}}function Ca(P){let n,I=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),c(n)!=="svelte-ackzsn"&&(n.innerHTML=I)},m(d,m){g(d,n,m)},p:V,d(d){d&&i(n)}}}function Ja(P){let n,I="Examples:",d,m,w;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=a(),f(m.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),c(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(s),u(m.$$.fragment,s)},m(s,M){g(s,n,M),g(s,d,M),h(m,s,M),w=!0},p:V,i(s){w||(_(m.$$.fragment,s),w=!0)},o(s){b(m.$$.fragment,s),w=!1},d(s){s&&(i(n),i(d)),v(m,s)}}}function La(P){let n,I=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),c(n)!=="svelte-17p1lpg"&&(n.textContent=I)},m(d,m){g(d,n,m)},p:V,d(d){d&&i(n)}}}function Za(P){let n,I="Examples:",d,m,w;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=a(),f(m.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),c(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(s),u(m.$$.fragment,s)},m(s,M){g(s,n,M),g(s,d,M),h(m,s,M),w=!0},p:V,i(s){w||(_(m.$$.fragment,s),w=!0)},o(s){b(m.$$.fragment,s),w=!1},d(s){s&&(i(n),i(d)),v(m,s)}}}function ja(P){let n,I,d,m,w,s,M,Ts=`Stable unCLIP checkpoints are finetuned from <a href="./stable_diffusion/stable_diffusion_2">Stable Diffusion 2.1</a> checkpoints to condition on CLIP image embeddings.
Stable unCLIP still conditions on text embeddings. Given the two separate conditionings, stable unCLIP can be used
for text guided image variation. When combined with an unCLIP prior, it can also be used for full text to image generation.`,Rt,be,Cs="The abstract from the paper is:",Ft,ve,Js="<em>Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.</em>",Ht,Ie,Yt,we,Ls="Stable unCLIP takes  <code>noise_level</code> as input during inference which determines how much noise is added to the image embeddings. A higher <code>noise_level</code> increases variation in the final un-noised images. By default, we do not add any additional noise to the image embeddings (<code>noise_level = 0</code>).",Qt,ye,Dt,$e,Zs='Stable unCLIP can be leveraged for text-to-image generation by pipelining it with the prior model of KakaoBrain’s open source DALL-E 2 replication <a href="https://huggingface.co/kakaobrain/karlo-v1-alpha" rel="nofollow">Karlo</a>:',At,Me,qt,Q,Ot,xe,Kt,Ue,en,Pe,js="Optionally, you can also pass a prompt to <code>pipe</code> such as:",tn,Te,nn,D,sn,Ce,an,y,Je,vn,it,ks="Pipeline for text-to-image generation using stable unCLIP.",In,lt,Ss=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,wn,rt,Ws="The pipeline also inherits the following loading methods:",yn,pt,Gs='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',$n,N,Le,Mn,dt,Bs="The call function to the pipeline for generation.",xn,A,Un,k,Ze,Pn,mt,Vs=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Tn,q,Cn,O,Jn,K,je,Ln,ct,Xs=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Zn,ee,ke,jn,gt,Es=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,kn,te,Se,Sn,ft,Ns=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Wn,S,We,Gn,ut,zs=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Bn,ne,Vn,se,Xn,ae,Ge,En,ht,Rs='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Nn,oe,Be,zn,_t,Fs="Encodes the prompt into text encoder hidden states.",Rn,L,Ve,Fn,bt,Hs=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,Hn,vt,Ys="The noise is applied in two ways:",Yn,It,Qs="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",Qn,wt,Ds="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",Dn,yt,As="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",on,Xe,ln,$,Ee,An,$t,qs="Pipeline for text-guided image-to-image generation using stable unCLIP.",qn,Mt,Os=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,On,xt,Ks="The pipeline also inherits the following loading methods:",Kn,Ut,ea='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',es,z,Ne,ts,Pt,ta="The call function to the pipeline for generation.",ns,ie,ss,W,ze,as,Tt,na=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,os,le,is,re,ls,pe,Re,rs,Ct,sa=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,ps,de,Fe,ds,Jt,aa=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ms,me,He,cs,Lt,oa=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,gs,G,Ye,fs,Zt,ia=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,us,ce,hs,ge,_s,fe,Qe,bs,jt,la='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',vs,ue,De,Is,kt,ra="Encodes the prompt into text encoder hidden states.",ws,Z,Ae,ys,St,pa=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,$s,Wt,da="The noise is applied in two ways:",Ms,Gt,ma="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",xs,Bt,ca="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",Us,Vt,ga="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",rn,qe,pn,R,Oe,Ps,Xt,fa="Output class for image pipelines.",dn,Ke,mn,zt,cn;return w=new ot({props:{title:"Stable unCLIP",local:"stable-unclip",headingTag:"h1"}}),Ie=new ot({props:{title:"Tips",local:"tips",headingTag:"h2"}}),ye=new ot({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),Me=new Y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UnCLIPScheduler, DDPMScheduler, StableUnCLIPPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> PriorTransformer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTokenizer, CLIPTextModelWithProjection

prior_model_id = <span class="hljs-string">&quot;kakaobrain/karlo-v1-alpha&quot;</span>
data_type = torch.float16
prior = PriorTransformer.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior&quot;</span>, torch_dtype=data_type)

prior_text_model_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
prior_tokenizer = CLIPTokenizer.from_pretrained(prior_text_model_id)
prior_text_model = CLIPTextModelWithProjection.from_pretrained(prior_text_model_id, torch_dtype=data_type)
prior_scheduler = UnCLIPScheduler.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior_scheduler&quot;</span>)
prior_scheduler = DDPMScheduler.from_config(prior_scheduler.config)

stable_unclip_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>

pipe = StableUnCLIPPipeline.from_pretrained(
    stable_unclip_model_id,
    torch_dtype=data_type,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    prior_tokenizer=prior_tokenizer,
    prior_text_encoder=prior_text_model,
    prior=prior,
    prior_scheduler=prior_scheduler,
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
wave_prompt = <span class="hljs-string">&quot;dramatic wave, the Oceans roar, Strong wave spiral across the oceans as the waves unfurl into roaring crests; perfect wave form; perfect wave shape; dramatic wave shape; wave shape unbelievable; wave; wave shape spectacular&quot;</span>

image = pipe(prompt=wave_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Q=new Et({props:{warning:!0,$$slots:{default:[wa]},$$scope:{ctx:P}}}),xe=new ot({props:{title:"Text guided Image-to-Image Variation",local:"text-guided-image-to-image-variation",headingTag:"h3"}}),Ue=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLXVuY2xpcCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhdGlvbiUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3RhYmxlX3VuY2xpcCUyRnRhcnNpbGFfZG9fYW1hcmFsLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKGluaXRfaW1hZ2UpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJ2YXJpYXRpb25faW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip&quot;</span>, torch_dtype=torch.float16, variation=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/stable_unclip/tarsila_do_amaral.png&quot;</span>
init_image = load_image(url)

images = pipe(init_image).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image.png&quot;</span>)`,wrap:!1}}),Te=new Y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShpbml0X2ltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

image = pipe(init_image, prompt=prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new Et({props:{$$slots:{default:[ya]},$$scope:{ctx:P}}}),Ce=new ot({props:{title:"StableUnCLIPPipeline",local:"diffusers.StableUnCLIPPipeline",headingTag:"h2"}}),Je=new J({props:{name:"class diffusers.StableUnCLIPPipeline",anchor:"diffusers.StableUnCLIPPipeline",parameters:[{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior",val:": PriorTransformer"},{name:"prior_scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"prior_tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen <code>CLIPTextModelWithProjection</code> text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.StableUnCLIPPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Scheduler used in the prior denoising process.`,name:"prior_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen <code>CLIPTextModel</code> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L61"}}),Le=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Optional = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"noise_level",val:": int = 0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_latents",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps in the prior denoising process. More denoising steps usually lead to a
higher quality image at the expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"prior_guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_latents",description:`<strong>prior_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
embedding generation in the prior denoising process. Can be used to tweak the same generation with
different prompts. If not provided, a latents tensor is generated by sampling using the supplied random
<code>generator</code>.`,name:"prior_latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L636",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),A=new Nt({props:{anchor:"diffusers.StableUnCLIPPipeline.__call__.example",$$slots:{default:[$a]},$$scope:{ctx:P}}}),Ze=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1672"}}),q=new Et({props:{warning:!0,$$slots:{default:[Ma]},$$scope:{ctx:P}}}),O=new Nt({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.example",$$slots:{default:[xa]},$$scope:{ctx:P}}}),je=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1712"}}),ke=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1857"}}),Se=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),We=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1611"}}),ne=new Et({props:{warning:!0,$$slots:{default:[Ua]},$$scope:{ctx:P}}}),se=new Nt({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Pa]},$$scope:{ctx:P}}}),Ge=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1646"}}),Be=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L288"}}),Ve=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": Optional = None"},{name:"generator",val:": Optional = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L590"}}),Xe=new ot({props:{title:"StableUnCLIPImg2ImgPipeline",local:"diffusers.StableUnCLIPImg2ImgPipeline",headingTag:"h2"}}),Ee=new J({props:{name:"class diffusers.StableUnCLIPImg2ImgPipeline",anchor:"diffusers.StableUnCLIPImg2ImgPipeline",parameters:[{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
Feature extractor for image pre-processing before being encoded.`,name:"feature_extractor"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
CLIP vision model for encoding images.`,name:"image_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>~transformers.CLIPTokenizer</code>) &#x2014;
A [<code>~transformers.CLIPTokenizer</code>)].`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L72"}}),Ne=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__",parameters:[{name:"image",val:": Union = None"},{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Optional = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"noise_level",val:": int = 0"},{name:"image_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, either <code>prompt_embeds</code> will be
used or prompt is initialized to <code>&quot;&quot;</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code> or tensor representing an image batch. The image is encoded to its CLIP embedding which the
<code>unet</code> is conditioned on. The image is <em>not</em> encoded by the <code>vae</code> and then used as the latents in the
denoising process like it is in the standard Stable Diffusion text-guided image variation process.`,name:"image"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated CLIP embeddings to condition the <code>unet</code> on. These latents are not used in the denoising
process. If you want to provide pre-generated latents, pass them to <code>__call__</code> as <code>latents</code>.`,name:"image_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L615",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ie=new Nt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.example",$$slots:{default:[Ta]},$$scope:{ctx:P}}}),ze=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1672"}}),le=new Et({props:{warning:!0,$$slots:{default:[Ca]},$$scope:{ctx:P}}}),re=new Nt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[Ja]},$$scope:{ctx:P}}}),Re=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1712"}}),Fe=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1857"}}),He=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),Ye=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1611"}}),ce=new Et({props:{warning:!0,$$slots:{default:[La]},$$scope:{ctx:P}}}),ge=new Nt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Za]},$$scope:{ctx:P}}}),Qe=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1646"}}),De=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L250"}}),Ae=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": Optional = None"},{name:"generator",val:": Optional = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L569"}}),qe=new ot({props:{title:"ImagePipelineOutput",local:"diffusers.ImagePipelineOutput",headingTag:"h2"}}),Oe=new J({props:{name:"class diffusers.ImagePipelineOutput",anchor:"diffusers.ImagePipelineOutput",parameters:[{name:"images",val:": Union"}],parametersDescription:[{anchor:"diffusers.ImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L103"}}),Ke=new Ia({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_unclip.md"}}),{c(){n=l("meta"),I=a(),d=l("p"),m=a(),f(w.$$.fragment),s=a(),M=l("p"),M.innerHTML=Ts,Rt=a(),be=l("p"),be.textContent=Cs,Ft=a(),ve=l("p"),ve.innerHTML=Js,Ht=a(),f(Ie.$$.fragment),Yt=a(),we=l("p"),we.innerHTML=Ls,Qt=a(),f(ye.$$.fragment),Dt=a(),$e=l("p"),$e.innerHTML=Zs,At=a(),f(Me.$$.fragment),qt=a(),f(Q.$$.fragment),Ot=a(),f(xe.$$.fragment),Kt=a(),f(Ue.$$.fragment),en=a(),Pe=l("p"),Pe.innerHTML=js,tn=a(),f(Te.$$.fragment),nn=a(),f(D.$$.fragment),sn=a(),f(Ce.$$.fragment),an=a(),y=l("div"),f(Je.$$.fragment),vn=a(),it=l("p"),it.textContent=ks,In=a(),lt=l("p"),lt.innerHTML=Ss,wn=a(),rt=l("p"),rt.textContent=Ws,yn=a(),pt=l("ul"),pt.innerHTML=Gs,$n=a(),N=l("div"),f(Le.$$.fragment),Mn=a(),dt=l("p"),dt.textContent=Bs,xn=a(),f(A.$$.fragment),Un=a(),k=l("div"),f(Ze.$$.fragment),Pn=a(),mt=l("p"),mt.textContent=Vs,Tn=a(),f(q.$$.fragment),Cn=a(),f(O.$$.fragment),Jn=a(),K=l("div"),f(je.$$.fragment),Ln=a(),ct=l("p"),ct.innerHTML=Xs,Zn=a(),ee=l("div"),f(ke.$$.fragment),jn=a(),gt=l("p"),gt.textContent=Es,kn=a(),te=l("div"),f(Se.$$.fragment),Sn=a(),ft=l("p"),ft.innerHTML=Ns,Wn=a(),S=l("div"),f(We.$$.fragment),Gn=a(),ut=l("p"),ut.innerHTML=zs,Bn=a(),f(ne.$$.fragment),Vn=a(),f(se.$$.fragment),Xn=a(),ae=l("div"),f(Ge.$$.fragment),En=a(),ht=l("p"),ht.innerHTML=Rs,Nn=a(),oe=l("div"),f(Be.$$.fragment),zn=a(),_t=l("p"),_t.textContent=Fs,Rn=a(),L=l("div"),f(Ve.$$.fragment),Fn=a(),bt=l("p"),bt.innerHTML=Hs,Hn=a(),vt=l("p"),vt.textContent=Ys,Yn=a(),It=l("ol"),It.innerHTML=Qs,Qn=a(),wt=l("p"),wt.innerHTML=Ds,Dn=a(),yt=l("p"),yt.textContent=As,on=a(),f(Xe.$$.fragment),ln=a(),$=l("div"),f(Ee.$$.fragment),An=a(),$t=l("p"),$t.textContent=qs,qn=a(),Mt=l("p"),Mt.innerHTML=Os,On=a(),xt=l("p"),xt.textContent=Ks,Kn=a(),Ut=l("ul"),Ut.innerHTML=ea,es=a(),z=l("div"),f(Ne.$$.fragment),ts=a(),Pt=l("p"),Pt.textContent=ta,ns=a(),f(ie.$$.fragment),ss=a(),W=l("div"),f(ze.$$.fragment),as=a(),Tt=l("p"),Tt.textContent=na,os=a(),f(le.$$.fragment),is=a(),f(re.$$.fragment),ls=a(),pe=l("div"),f(Re.$$.fragment),rs=a(),Ct=l("p"),Ct.innerHTML=sa,ps=a(),de=l("div"),f(Fe.$$.fragment),ds=a(),Jt=l("p"),Jt.textContent=aa,ms=a(),me=l("div"),f(He.$$.fragment),cs=a(),Lt=l("p"),Lt.innerHTML=oa,gs=a(),G=l("div"),f(Ye.$$.fragment),fs=a(),Zt=l("p"),Zt.innerHTML=ia,us=a(),f(ce.$$.fragment),hs=a(),f(ge.$$.fragment),_s=a(),fe=l("div"),f(Qe.$$.fragment),bs=a(),jt=l("p"),jt.innerHTML=la,vs=a(),ue=l("div"),f(De.$$.fragment),Is=a(),kt=l("p"),kt.textContent=ra,ws=a(),Z=l("div"),f(Ae.$$.fragment),ys=a(),St=l("p"),St.innerHTML=pa,$s=a(),Wt=l("p"),Wt.textContent=da,Ms=a(),Gt=l("ol"),Gt.innerHTML=ma,xs=a(),Bt=l("p"),Bt.innerHTML=ca,Us=a(),Vt=l("p"),Vt.textContent=ga,rn=a(),f(qe.$$.fragment),pn=a(),R=l("div"),f(Oe.$$.fragment),Ps=a(),Xt=l("p"),Xt.textContent=fa,dn=a(),f(Ke.$$.fragment),mn=a(),zt=l("p"),this.h()},l(e){const p=va("svelte-u9bgzb",document.head);n=r(p,"META",{name:!0,content:!0}),p.forEach(i),I=o(e),d=r(e,"P",{}),T(d).forEach(i),m=o(e),u(w.$$.fragment,e),s=o(e),M=r(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-bd6hsa"&&(M.innerHTML=Ts),Rt=o(e),be=r(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-1cwsb16"&&(be.textContent=Cs),Ft=o(e),ve=r(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-ha34c8"&&(ve.innerHTML=Js),Ht=o(e),u(Ie.$$.fragment,e),Yt=o(e),we=r(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-ozodyw"&&(we.innerHTML=Ls),Qt=o(e),u(ye.$$.fragment,e),Dt=o(e),$e=r(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1sz02mh"&&($e.innerHTML=Zs),At=o(e),u(Me.$$.fragment,e),qt=o(e),u(Q.$$.fragment,e),Ot=o(e),u(xe.$$.fragment,e),Kt=o(e),u(Ue.$$.fragment,e),en=o(e),Pe=r(e,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-1mvqeru"&&(Pe.innerHTML=js),tn=o(e),u(Te.$$.fragment,e),nn=o(e),u(D.$$.fragment,e),sn=o(e),u(Ce.$$.fragment,e),an=o(e),y=r(e,"DIV",{class:!0});var x=T(y);u(Je.$$.fragment,x),vn=o(x),it=r(x,"P",{"data-svelte-h":!0}),c(it)!=="svelte-2c89j6"&&(it.textContent=ks),In=o(x),lt=r(x,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-496sm0"&&(lt.innerHTML=Ss),wn=o(x),rt=r(x,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-14s6m4u"&&(rt.textContent=Ws),yn=o(x),pt=r(x,"UL",{"data-svelte-h":!0}),c(pt)!=="svelte-txtwv6"&&(pt.innerHTML=Gs),$n=o(x),N=r(x,"DIV",{class:!0});var F=T(N);u(Le.$$.fragment,F),Mn=o(F),dt=r(F,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-50j04k"&&(dt.textContent=Bs),xn=o(F),u(A.$$.fragment,F),F.forEach(i),Un=o(x),k=r(x,"DIV",{class:!0});var X=T(k);u(Ze.$$.fragment,X),Pn=o(X),mt=r(X,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-10jaql7"&&(mt.textContent=Vs),Tn=o(X),u(q.$$.fragment,X),Cn=o(X),u(O.$$.fragment,X),X.forEach(i),Jn=o(x),K=r(x,"DIV",{class:!0});var et=T(K);u(je.$$.fragment,et),Ln=o(et),ct=r(et,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-1lh0nh5"&&(ct.innerHTML=Xs),et.forEach(i),Zn=o(x),ee=r(x,"DIV",{class:!0});var tt=T(ee);u(ke.$$.fragment,tt),jn=o(tt),gt=r(tt,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-14bnrb6"&&(gt.textContent=Es),tt.forEach(i),kn=o(x),te=r(x,"DIV",{class:!0});var nt=T(te);u(Se.$$.fragment,nt),Sn=o(nt),ft=r(nt,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-1s3c06i"&&(ft.innerHTML=Ns),nt.forEach(i),Wn=o(x),S=r(x,"DIV",{class:!0});var E=T(S);u(We.$$.fragment,E),Gn=o(E),ut=r(E,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-e03q3e"&&(ut.innerHTML=zs),Bn=o(E),u(ne.$$.fragment,E),Vn=o(E),u(se.$$.fragment,E),E.forEach(i),Xn=o(x),ae=r(x,"DIV",{class:!0});var st=T(ae);u(Ge.$$.fragment,st),En=o(st),ht=r(st,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-1vfte1e"&&(ht.innerHTML=Rs),st.forEach(i),Nn=o(x),oe=r(x,"DIV",{class:!0});var at=T(oe);u(Be.$$.fragment,at),zn=o(at),_t=r(at,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-16q0ax1"&&(_t.textContent=Fs),at.forEach(i),Rn=o(x),L=r(x,"DIV",{class:!0});var j=T(L);u(Ve.$$.fragment,j),Fn=o(j),bt=r(j,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-1e71opl"&&(bt.innerHTML=Hs),Hn=o(j),vt=r(j,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-acyrt"&&(vt.textContent=Ys),Yn=o(j),It=r(j,"OL",{"data-svelte-h":!0}),c(It)!=="svelte-114uhci"&&(It.innerHTML=Qs),Qn=o(j),wt=r(j,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-46dthp"&&(wt.innerHTML=Ds),Dn=o(j),yt=r(j,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-4ngutd"&&(yt.textContent=As),j.forEach(i),x.forEach(i),on=o(e),u(Xe.$$.fragment,e),ln=o(e),$=r(e,"DIV",{class:!0});var U=T($);u(Ee.$$.fragment,U),An=o(U),$t=r(U,"P",{"data-svelte-h":!0}),c($t)!=="svelte-y15i80"&&($t.textContent=qs),qn=o(U),Mt=r(U,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-496sm0"&&(Mt.innerHTML=Os),On=o(U),xt=r(U,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-14s6m4u"&&(xt.textContent=Ks),Kn=o(U),Ut=r(U,"UL",{"data-svelte-h":!0}),c(Ut)!=="svelte-txtwv6"&&(Ut.innerHTML=ea),es=o(U),z=r(U,"DIV",{class:!0});var H=T(z);u(Ne.$$.fragment,H),ts=o(H),Pt=r(H,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-50j04k"&&(Pt.textContent=ta),ns=o(H),u(ie.$$.fragment,H),H.forEach(i),ss=o(U),W=r(U,"DIV",{class:!0});var he=T(W);u(ze.$$.fragment,he),as=o(he),Tt=r(he,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-10jaql7"&&(Tt.textContent=na),os=o(he),u(le.$$.fragment,he),is=o(he),u(re.$$.fragment,he),he.forEach(i),ls=o(U),pe=r(U,"DIV",{class:!0});var gn=T(pe);u(Re.$$.fragment,gn),rs=o(gn),Ct=r(gn,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1lh0nh5"&&(Ct.innerHTML=sa),gn.forEach(i),ps=o(U),de=r(U,"DIV",{class:!0});var fn=T(de);u(Fe.$$.fragment,fn),ds=o(fn),Jt=r(fn,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-14bnrb6"&&(Jt.textContent=aa),fn.forEach(i),ms=o(U),me=r(U,"DIV",{class:!0});var un=T(me);u(He.$$.fragment,un),cs=o(un),Lt=r(un,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-1s3c06i"&&(Lt.innerHTML=oa),un.forEach(i),gs=o(U),G=r(U,"DIV",{class:!0});var _e=T(G);u(Ye.$$.fragment,_e),fs=o(_e),Zt=r(_e,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-e03q3e"&&(Zt.innerHTML=ia),us=o(_e),u(ce.$$.fragment,_e),hs=o(_e),u(ge.$$.fragment,_e),_e.forEach(i),_s=o(U),fe=r(U,"DIV",{class:!0});var hn=T(fe);u(Qe.$$.fragment,hn),bs=o(hn),jt=r(hn,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-1vfte1e"&&(jt.innerHTML=la),hn.forEach(i),vs=o(U),ue=r(U,"DIV",{class:!0});var _n=T(ue);u(De.$$.fragment,_n),Is=o(_n),kt=r(_n,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-16q0ax1"&&(kt.textContent=ra),_n.forEach(i),ws=o(U),Z=r(U,"DIV",{class:!0});var B=T(Z);u(Ae.$$.fragment,B),ys=o(B),St=r(B,"P",{"data-svelte-h":!0}),c(St)!=="svelte-1e71opl"&&(St.innerHTML=pa),$s=o(B),Wt=r(B,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-acyrt"&&(Wt.textContent=da),Ms=o(B),Gt=r(B,"OL",{"data-svelte-h":!0}),c(Gt)!=="svelte-114uhci"&&(Gt.innerHTML=ma),xs=o(B),Bt=r(B,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-46dthp"&&(Bt.innerHTML=ca),Us=o(B),Vt=r(B,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-4ngutd"&&(Vt.textContent=ga),B.forEach(i),U.forEach(i),rn=o(e),u(qe.$$.fragment,e),pn=o(e),R=r(e,"DIV",{class:!0});var bn=T(R);u(Oe.$$.fragment,bn),Ps=o(bn),Xt=r(bn,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-19wetgi"&&(Xt.textContent=fa),bn.forEach(i),dn=o(e),u(Ke.$$.fragment,e),mn=o(e),zt=r(e,"P",{}),T(zt).forEach(i),this.h()},h(){C(n,"name","hf:doc:metadata"),C(n,"content",ka),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,n),g(e,I,p),g(e,d,p),g(e,m,p),h(w,e,p),g(e,s,p),g(e,M,p),g(e,Rt,p),g(e,be,p),g(e,Ft,p),g(e,ve,p),g(e,Ht,p),h(Ie,e,p),g(e,Yt,p),g(e,we,p),g(e,Qt,p),h(ye,e,p),g(e,Dt,p),g(e,$e,p),g(e,At,p),h(Me,e,p),g(e,qt,p),h(Q,e,p),g(e,Ot,p),h(xe,e,p),g(e,Kt,p),h(Ue,e,p),g(e,en,p),g(e,Pe,p),g(e,tn,p),h(Te,e,p),g(e,nn,p),h(D,e,p),g(e,sn,p),h(Ce,e,p),g(e,an,p),g(e,y,p),h(Je,y,null),t(y,vn),t(y,it),t(y,In),t(y,lt),t(y,wn),t(y,rt),t(y,yn),t(y,pt),t(y,$n),t(y,N),h(Le,N,null),t(N,Mn),t(N,dt),t(N,xn),h(A,N,null),t(y,Un),t(y,k),h(Ze,k,null),t(k,Pn),t(k,mt),t(k,Tn),h(q,k,null),t(k,Cn),h(O,k,null),t(y,Jn),t(y,K),h(je,K,null),t(K,Ln),t(K,ct),t(y,Zn),t(y,ee),h(ke,ee,null),t(ee,jn),t(ee,gt),t(y,kn),t(y,te),h(Se,te,null),t(te,Sn),t(te,ft),t(y,Wn),t(y,S),h(We,S,null),t(S,Gn),t(S,ut),t(S,Bn),h(ne,S,null),t(S,Vn),h(se,S,null),t(y,Xn),t(y,ae),h(Ge,ae,null),t(ae,En),t(ae,ht),t(y,Nn),t(y,oe),h(Be,oe,null),t(oe,zn),t(oe,_t),t(y,Rn),t(y,L),h(Ve,L,null),t(L,Fn),t(L,bt),t(L,Hn),t(L,vt),t(L,Yn),t(L,It),t(L,Qn),t(L,wt),t(L,Dn),t(L,yt),g(e,on,p),h(Xe,e,p),g(e,ln,p),g(e,$,p),h(Ee,$,null),t($,An),t($,$t),t($,qn),t($,Mt),t($,On),t($,xt),t($,Kn),t($,Ut),t($,es),t($,z),h(Ne,z,null),t(z,ts),t(z,Pt),t(z,ns),h(ie,z,null),t($,ss),t($,W),h(ze,W,null),t(W,as),t(W,Tt),t(W,os),h(le,W,null),t(W,is),h(re,W,null),t($,ls),t($,pe),h(Re,pe,null),t(pe,rs),t(pe,Ct),t($,ps),t($,de),h(Fe,de,null),t(de,ds),t(de,Jt),t($,ms),t($,me),h(He,me,null),t(me,cs),t(me,Lt),t($,gs),t($,G),h(Ye,G,null),t(G,fs),t(G,Zt),t(G,us),h(ce,G,null),t(G,hs),h(ge,G,null),t($,_s),t($,fe),h(Qe,fe,null),t(fe,bs),t(fe,jt),t($,vs),t($,ue),h(De,ue,null),t(ue,Is),t(ue,kt),t($,ws),t($,Z),h(Ae,Z,null),t(Z,ys),t(Z,St),t(Z,$s),t(Z,Wt),t(Z,Ms),t(Z,Gt),t(Z,xs),t(Z,Bt),t(Z,Us),t(Z,Vt),g(e,rn,p),h(qe,e,p),g(e,pn,p),g(e,R,p),h(Oe,R,null),t(R,Ps),t(R,Xt),g(e,dn,p),h(Ke,e,p),g(e,mn,p),g(e,zt,p),cn=!0},p(e,[p]){const x={};p&2&&(x.$$scope={dirty:p,ctx:e}),Q.$set(x);const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),D.$set(F);const X={};p&2&&(X.$$scope={dirty:p,ctx:e}),A.$set(X);const et={};p&2&&(et.$$scope={dirty:p,ctx:e}),q.$set(et);const tt={};p&2&&(tt.$$scope={dirty:p,ctx:e}),O.$set(tt);const nt={};p&2&&(nt.$$scope={dirty:p,ctx:e}),ne.$set(nt);const E={};p&2&&(E.$$scope={dirty:p,ctx:e}),se.$set(E);const st={};p&2&&(st.$$scope={dirty:p,ctx:e}),ie.$set(st);const at={};p&2&&(at.$$scope={dirty:p,ctx:e}),le.$set(at);const j={};p&2&&(j.$$scope={dirty:p,ctx:e}),re.$set(j);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),ce.$set(U);const H={};p&2&&(H.$$scope={dirty:p,ctx:e}),ge.$set(H)},i(e){cn||(_(w.$$.fragment,e),_(Ie.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(Q.$$.fragment,e),_(xe.$$.fragment,e),_(Ue.$$.fragment,e),_(Te.$$.fragment,e),_(D.$$.fragment,e),_(Ce.$$.fragment,e),_(Je.$$.fragment,e),_(Le.$$.fragment,e),_(A.$$.fragment,e),_(Ze.$$.fragment,e),_(q.$$.fragment,e),_(O.$$.fragment,e),_(je.$$.fragment,e),_(ke.$$.fragment,e),_(Se.$$.fragment,e),_(We.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),_(Xe.$$.fragment,e),_(Ee.$$.fragment,e),_(Ne.$$.fragment,e),_(ie.$$.fragment,e),_(ze.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(Re.$$.fragment,e),_(Fe.$$.fragment,e),_(He.$$.fragment,e),_(Ye.$$.fragment,e),_(ce.$$.fragment,e),_(ge.$$.fragment,e),_(Qe.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(qe.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),cn=!0)},o(e){b(w.$$.fragment,e),b(Ie.$$.fragment,e),b(ye.$$.fragment,e),b(Me.$$.fragment,e),b(Q.$$.fragment,e),b(xe.$$.fragment,e),b(Ue.$$.fragment,e),b(Te.$$.fragment,e),b(D.$$.fragment,e),b(Ce.$$.fragment,e),b(Je.$$.fragment,e),b(Le.$$.fragment,e),b(A.$$.fragment,e),b(Ze.$$.fragment,e),b(q.$$.fragment,e),b(O.$$.fragment,e),b(je.$$.fragment,e),b(ke.$$.fragment,e),b(Se.$$.fragment,e),b(We.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(Ge.$$.fragment,e),b(Be.$$.fragment,e),b(Ve.$$.fragment,e),b(Xe.$$.fragment,e),b(Ee.$$.fragment,e),b(Ne.$$.fragment,e),b(ie.$$.fragment,e),b(ze.$$.fragment,e),b(le.$$.fragment,e),b(re.$$.fragment,e),b(Re.$$.fragment,e),b(Fe.$$.fragment,e),b(He.$$.fragment,e),b(Ye.$$.fragment,e),b(ce.$$.fragment,e),b(ge.$$.fragment,e),b(Qe.$$.fragment,e),b(De.$$.fragment,e),b(Ae.$$.fragment,e),b(qe.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),cn=!1},d(e){e&&(i(I),i(d),i(m),i(s),i(M),i(Rt),i(be),i(Ft),i(ve),i(Ht),i(Yt),i(we),i(Qt),i(Dt),i($e),i(At),i(qt),i(Ot),i(Kt),i(en),i(Pe),i(tn),i(nn),i(sn),i(an),i(y),i(on),i(ln),i($),i(rn),i(pn),i(R),i(dn),i(mn),i(zt)),i(n),v(w,e),v(Ie,e),v(ye,e),v(Me,e),v(Q,e),v(xe,e),v(Ue,e),v(Te,e),v(D,e),v(Ce,e),v(Je),v(Le),v(A),v(Ze),v(q),v(O),v(je),v(ke),v(Se),v(We),v(ne),v(se),v(Ge),v(Be),v(Ve),v(Xe,e),v(Ee),v(Ne),v(ie),v(ze),v(le),v(re),v(Re),v(Fe),v(He),v(Ye),v(ce),v(ge),v(Qe),v(De),v(Ae),v(qe,e),v(Oe),v(Ke,e)}}}const ka='{"title":"Stable unCLIP","local":"stable-unclip","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Text guided Image-to-Image Variation","local":"text-guided-image-to-image-variation","sections":[],"depth":3}],"depth":2},{"title":"StableUnCLIPPipeline","local":"diffusers.StableUnCLIPPipeline","sections":[],"depth":2},{"title":"StableUnCLIPImg2ImgPipeline","local":"diffusers.StableUnCLIPImg2ImgPipeline","sections":[],"depth":2},{"title":"ImagePipelineOutput","local":"diffusers.ImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function Sa(P){return ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends _a{constructor(n){super(),ba(this,n,Sa,ja,ua,{})}}export{za as component};
