import{s as Cn,o as Jn,n as Tt}from"../chunks/scheduler.8c3d61f6.js";import{S as Gn,i as Un,g as s,s as o,r as m,A as Ln,h as r,f as t,c as i,j as P,u as g,x as c,k as M,y as a,a as l,v as u,d as f,t as _,w as h}from"../chunks/index.da70eac4.js";import{T as In}from"../chunks/Tip.1d9b8c37.js";import{D as k}from"../chunks/Docstring.932cdff3.js";import{C as en}from"../chunks/CodeBlock.a9c4becf.js";import{E as kn}from"../chunks/ExampleCodeBlock.c0461b09.js";import{H as He,E as An}from"../chunks/index.ef90fe87.js";function En(C){let p,$='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=s("p"),p.innerHTML=$},l(b){p=r(b,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1qn15hi"&&(p.innerHTML=$)},m(b,v){l(b,p,v)},p:Tt,d(b){b&&t(p)}}}function jn(C){let p,$='Make sure to pass the <code>variant</code> argument for downloaded checkpoints to use lower disk space. Set it to <code>&quot;fp16&quot;</code> for models with recommended dtype as <code>torch.float16</code>, and <code>&quot;bf16&quot;</code> for models with recommended dtype as <code>torch.bfloat16</code>. By default, <code>torch.float32</code> weights are downloaded, which use twice the amount of disk storage. Additionally, <code>torch.float32</code> weights can be downcasted on-the-fly by specifying the <code>torch_dtype</code> argument. Read about it in the <a href="https://huggingface.co/docs/diffusers/v0.31.0/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained" rel="nofollow">docs</a>.';return{c(){p=s("p"),p.innerHTML=$},l(b){p=r(b,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1k3bkk9"&&(p.innerHTML=$)},m(b,v){l(b,p,v)},p:Tt,d(b){b&&t(p)}}}function Zn(C){let p,$="Examples:",b,v,T;return v=new en({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2FuYVBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFNhbmFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfQkYxNl9kaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MzIlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUudGV4dF9lbmNvZGVyLnRvKHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudHJhbnNmb3JtZXIlMjAlM0QlMjBwaXBlLnRyYW5zZm9ybWVyLnRvKHRvcmNoLmJmbG9hdDE2KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0QnYSUyMGN5YmVycHVuayUyMGNhdCUyMHdpdGglMjBhJTIwbmVvbiUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMCUyMlNhbmElMjInKSU1QjAlNUQlMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SanaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SanaPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers&quot;</span>, torch_dtype=torch.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = pipe.transformer.to(torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=<span class="hljs-string">&#x27;a cyberpunk cat with a neon sign that says &quot;Sana&quot;&#x27;</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){p=s("p"),p.textContent=$,b=o(),m(v.$$.fragment)},l(d){p=r(d,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=$),b=i(d),g(v.$$.fragment,d)},m(d,S){l(d,p,S),l(d,b,S),u(v,d,S),T=!0},p:Tt,i(d){T||(f(v.$$.fragment,d),T=!0)},o(d){_(v.$$.fragment,d),T=!1},d(d){d&&(t(p),t(b)),h(v,d)}}}function Bn(C){let p,$="Examples:",b,v,T;return v=new en({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2FuYVBBR1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFNhbmFQQUdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfQkYxNl9kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWdfYXBwbGllZF9sYXllcnMlM0QlNUIlMjJ0cmFuc2Zvcm1lcl9ibG9ja3MuOCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS50ZXh0X2VuY29kZXIudG8odG9yY2guYmZsb2F0MTYpJTBBcGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHBpcGUudHJhbnNmb3JtZXIudG8odG9yY2guYmZsb2F0MTYpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRCdhJTIwY3liZXJwdW5rJTIwY2F0JTIwd2l0aCUyMGElMjBuZW9uJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwJTIyU2FuYSUyMicpJTVCMCU1RCUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SanaPAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SanaPAGPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers&quot;</span>,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-string">&quot;transformer_blocks.8&quot;</span>],
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = pipe.transformer.to(torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=<span class="hljs-string">&#x27;a cyberpunk cat with a neon sign that says &quot;Sana&quot;&#x27;</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){p=s("p"),p.textContent=$,b=o(),m(v.$$.fragment)},l(d){p=r(d,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=$),b=i(d),g(v.$$.fragment,d)},m(d,S){l(d,p,S),l(d,b,S),u(v,d,S),T=!0},p:Tt,i(d){T||(f(v.$$.fragment,d),T=!0)},o(d){_(v.$$.fragment,d),T=!1},d(d){d&&(t(p),t(b)),h(v,d)}}}function qn(C){let p,$,b,v,T,d,S,tn='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/> <img alt="MPS" src="https://img.shields.io/badge/MPS-000000?style=flat&amp;logo=apple&amp;logoColor=white%22"/>',Re,X,nn='<a href="https://huggingface.co/papers/2410.10629" rel="nofollow">SANA: Efficient High-Resolution Image Synthesis with Linear Diffusion Transformers</a> from NVIDIA and MIT HAN Lab, by Enze Xie, Junsong Chen, Junyu Chen, Han Cai, Haotian Tang, Yujun Lin, Zhekai Zhang, Muyang Li, Ligeng Zhu, Yao Lu, Song Han.',ze,Y,an="The abstract from the paper is:",De,Q,on="<em>We introduce Sana, a text-to-image framework that can efficiently generate images up to 4096×4096 resolution. Sana can synthesize high-resolution, high-quality images with strong text-image alignment at a remarkably fast speed, deployable on laptop GPU. Core designs include: (1) Deep compression autoencoder: unlike traditional AEs, which compress images only 8×, we trained an AE that can compress images 32×, effectively reducing the number of latent tokens. (2) Linear DiT: we replace all vanilla attention in DiT with linear attention, which is more efficient at high resolutions without sacrificing quality. (3) Decoder-only text encoder: we replaced T5 with modern decoder-only small LLM as the text encoder and designed complex human instruction with in-context learning to enhance the image-text alignment. (4) Efficient training and sampling: we propose Flow-DPM-Solver to reduce sampling steps, with efficient caption labeling and selection to accelerate convergence. As a result, Sana-0.6B is very competitive with modern giant diffusion model (e.g. Flux-12B), being 20 times smaller and 100+ times faster in measured throughput. Moreover, Sana-0.6B can be deployed on a 16GB laptop GPU, taking less than 1 second to generate a 1024×1024 resolution image. Sana enables content creation at low cost. Code and model will be publicly released.</em>",Xe,A,Ye,O,sn='This pipeline was contributed by <a href="https://github.com/lawrence-cj" rel="nofollow">lawrence-cj</a> and <a href="https://github.com/chenjy2003" rel="nofollow">chenjy2003</a>. The original codebase can be found <a href="https://github.com/NVlabs/Sana" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/Efficient-Large-Model" rel="nofollow">hf.co/Efficient-Large-Model</a>.',Qe,K,rn="Available models:",Oe,ee,ln='<thead><tr><th align="center">Model</th> <th align="center">Recommended dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_MultiLing_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_MultiLing_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_512px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_512px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_512px_MultiLing_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_512px_MultiLing_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_600M_1024px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_600M_1024px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_600M_512px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_600M_512px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr></tbody>',Ke,te,pn='Refer to <a href="https://huggingface.co/collections/Efficient-Large-Model/sana-673efba2a57ed99843f11f9e" rel="nofollow">this</a> collection for more information.',et,ne,dn="Note: The recommended dtype mentioned is for the transformer weights. The text encoder and VAE weights must stay in <code>torch.bfloat16</code> or <code>torch.float32</code> for the model to work correctly. Please refer to the inference example below to see how to load the model with the recommended dtype.",tt,E,nt,ae,at,oe,cn="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",ot,ie,mn='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/sana#diffusers.SanaPipeline">SanaPipeline</a> for inference with bitsandbytes.',it,se,st,re,rt,y,le,Pt,Ie,gn='Pipeline for text-to-image generation using <a href="https://huggingface.co/papers/2410.10629" rel="nofollow">Sana</a>.',$t,J,pe,St,ke,un="Function invoked when calling the pipeline for generation.",It,j,kt,Z,de,Ct,Ce,fn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Jt,B,ce,Gt,Je,_n=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ut,q,me,Lt,Ge,hn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,At,N,ge,Et,Ue,bn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,jt,V,ue,Zt,Le,vn="Encodes the prompt into text encoder hidden states.",lt,fe,pt,w,_e,Bt,Ae,yn=`Pipeline for text-to-image generation using <a href="https://huggingface.co/papers/2410.10629" rel="nofollow">Sana</a>. This pipeline
supports the use of <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/pag" rel="nofollow">Perturbed Attention Guidance
(PAG)</a>.`,qt,G,he,Nt,Ee,wn="Function invoked when calling the pipeline for generation.",Vt,F,Ft,W,be,Wt,je,xn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ht,H,ve,Rt,Ze,Mn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,zt,R,ye,Dt,Be,Tn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Xt,z,we,Yt,qe,Pn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Qt,D,xe,Ot,Ne,$n="Encodes the prompt into text encoder hidden states.",dt,Me,ct,U,Te,Kt,Ve,Sn="Output class for Sana pipelines.",mt,Pe,gt,We,ut;return T=new He({props:{title:"SanaPipeline",local:"sanapipeline",headingTag:"h1"}}),A=new In({props:{$$slots:{default:[En]},$$scope:{ctx:C}}}),E=new In({props:{$$slots:{default:[jn]},$$scope:{ctx:C}}}),ae=new He({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),se=new en({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBTYW5hVHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwU2FuYVBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTJDJTIwQXV0b01vZGVsJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdGV4dF9lbmNvZGVyXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkVmZmljaWVudC1MYXJnZS1Nb2RlbCUyRlNhbmFfMTYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMFNhbmFUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkVmZmljaWVudC1MYXJnZS1Nb2RlbCUyRlNhbmFfMTYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMFNhbmFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyXzhiaXQlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyXzhiaXQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYmFsYW5jZWQlMjIlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHRpbnklMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyMG9uJTIwdGhlJTIwbW9vbiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzYW5hLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, SanaTransformer2DModel, SanaPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, AutoModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = SanaTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = SanaPipeline.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sana.png&quot;</span>)`,wrap:!1}}),re=new He({props:{title:"SanaPipeline",local:"diffusers.SanaPipeline",headingTag:"h2"}}),le=new k({props:{name:"class diffusers.SanaPipeline",anchor:"diffusers.SanaPipeline",parameters:[{name:"tokenizer",val:": typing.Union[transformers.models.gemma.tokenization_gemma.GemmaTokenizer, transformers.models.gemma.tokenization_gemma_fast.GemmaTokenizerFast]"},{name:"text_encoder",val:": Gemma2PreTrainedModel"},{name:"vae",val:": AutoencoderDC"},{name:"transformer",val:": SanaTransformer2DModel"},{name:"scheduler",val:": DPMSolverMultistepScheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_sana.py#L189"}}),pe=new k({props:{name:"__call__",anchor:"diffusers.SanaPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"clean_caption",val:": bool = False"},{name:"use_resolution_binning",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:`: typing.List[str] = ["Given a user prompt, generate an 'Enhanced prompt' that provides detailed visual descriptions suitable for image generation. Evaluate the level of detail in the user prompt:", '- If the prompt is simple, focus on adding specifics about colors, shapes, sizes, textures, and spatial relationships to create vivid and concrete scenes.', '- If the prompt is already detailed, refine and enhance the existing details slightly without overcomplicating.', 'Here are examples of how to transform or refine prompts:', '- User Prompt: A cat sleeping -> Enhanced: A small, fluffy white cat curled up in a round shape, sleeping peacefully on a warm sunny windowsill, surrounded by pots of blooming red flowers.', '- User Prompt: A busy city street -> Enhanced: A bustling city street scene at dusk, featuring glowing street lamps, a diverse crowd of people in colorful clothing, and a double-decker bus passing by towering glass skyscrapers.', 'Please generate only the enhanced description for the prompt below and avoid including any additional commentary or evaluations:', 'User Prompt: ']`}],parametersDescription:[{anchor:"diffusers.SanaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SanaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SanaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.SanaPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.SanaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SanaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SanaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SanaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.SanaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.SanaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SanaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.SanaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SanaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SanaPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SanaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.SanaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.SanaPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SanaPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SanaPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>300</code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"},{anchor:"diffusers.SanaPipeline.__call__.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Instructions for complex human attention:
<a href="https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55" rel="nofollow">https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55</a>.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_sana.py#L702",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/sana#diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput"
>SanaPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/sana#diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput"
>SanaPipelineOutput</a> or <code>tuple</code></p>
`}}),j=new kn({props:{anchor:"diffusers.SanaPipeline.__call__.example",$$slots:{default:[Zn]},$$scope:{ctx:C}}}),de=new k({props:{name:"disable_vae_slicing",anchor:"diffusers.SanaPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_sana.py#L229"}}),ce=new k({props:{name:"disable_vae_tiling",anchor:"diffusers.SanaPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_sana.py#L244"}}),me=new k({props:{name:"enable_vae_slicing",anchor:"diffusers.SanaPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_sana.py#L222"}}),ge=new k({props:{name:"enable_vae_tiling",anchor:"diffusers.SanaPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_sana.py#L236"}}),ue=new k({props:{name:"encode_prompt",anchor:"diffusers.SanaPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:": typing.Optional[typing.List[str]] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.SanaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SanaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.SanaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Sana, it&#x2019;s should be the embeddings of the &quot;&quot; string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.SanaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.SanaPipeline.encode_prompt.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>list[str]</code>, defaults to <code>complex_human_instruction</code>) &#x2014;
If <code>complex_human_instruction</code> is not empty, the function will use the complex Human instruction for
the prompt.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_sana.py#L309"}}),fe=new He({props:{title:"SanaPAGPipeline",local:"diffusers.SanaPAGPipeline",headingTag:"h2"}}),_e=new k({props:{name:"class diffusers.SanaPAGPipeline",anchor:"diffusers.SanaPAGPipeline",parameters:[{name:"tokenizer",val:": typing.Union[transformers.models.gemma.tokenization_gemma.GemmaTokenizer, transformers.models.gemma.tokenization_gemma_fast.GemmaTokenizerFast]"},{name:"text_encoder",val:": Gemma2PreTrainedModel"},{name:"vae",val:": AutoencoderDC"},{name:"transformer",val:": SanaTransformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"pag_applied_layers",val:": typing.Union[str, typing.List[str]] = 'transformer_blocks.0'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L147"}}),he=new k({props:{name:"__call__",anchor:"diffusers.SanaPAGPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"clean_caption",val:": bool = False"},{name:"use_resolution_binning",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:`: typing.List[str] = ["Given a user prompt, generate an 'Enhanced prompt' that provides detailed visual descriptions suitable for image generation. Evaluate the level of detail in the user prompt:", '- If the prompt is simple, focus on adding specifics about colors, shapes, sizes, textures, and spatial relationships to create vivid and concrete scenes.', '- If the prompt is already detailed, refine and enhance the existing details slightly without overcomplicating.', 'Here are examples of how to transform or refine prompts:', '- User Prompt: A cat sleeping -> Enhanced: A small, fluffy white cat curled up in a round shape, sleeping peacefully on a warm sunny windowsill, surrounded by pots of blooming red flowers.', '- User Prompt: A busy city street -> Enhanced: A bustling city street scene at dusk, featuring glowing street lamps, a diverse crowd of people in colorful clothing, and a double-decker bus passing by towering glass skyscrapers.', 'Please generate only the enhanced description for the prompt below and avoid including any additional commentary or evaluations:', 'User Prompt: ']`},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.SanaPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SanaPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.SanaPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.SanaPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SanaPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SanaPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SanaPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.SanaPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.SanaPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SanaPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.SanaPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SanaPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SanaPAGPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.SanaPAGPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.SanaPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SanaPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SanaPAGPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 300) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.SanaPAGPipeline.__call__.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Instructions for complex human attention:
<a href="https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55" rel="nofollow">https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55</a>.`,name:"complex_human_instruction"},{anchor:"diffusers.SanaPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.SanaPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L623",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),F=new kn({props:{anchor:"diffusers.SanaPAGPipeline.__call__.example",$$slots:{default:[Bn]},$$scope:{ctx:C}}}),be=new k({props:{name:"disable_vae_slicing",anchor:"diffusers.SanaPAGPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L195"}}),ve=new k({props:{name:"disable_vae_tiling",anchor:"diffusers.SanaPAGPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L210"}}),ye=new k({props:{name:"enable_vae_slicing",anchor:"diffusers.SanaPAGPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L188"}}),we=new k({props:{name:"enable_vae_tiling",anchor:"diffusers.SanaPAGPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L202"}}),xe=new k({props:{name:"encode_prompt",anchor:"diffusers.SanaPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"diffusers.SanaPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Sana, it&#x2019;s should be the embeddings of the &quot;&quot; string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>list[str]</code>, defaults to <code>complex_human_instruction</code>) &#x2014;
If <code>complex_human_instruction</code> is not empty, the function will use the complex Human instruction for
the prompt.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L217"}}),Me=new He({props:{title:"SanaPipelineOutput",local:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",headingTag:"h2"}}),Te=new k({props:{name:"class diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",anchor:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/sana/pipeline_output.py#L10"}}),Pe=new An({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/sana.md"}}),{c(){p=s("meta"),$=o(),b=s("p"),v=o(),m(T.$$.fragment),d=o(),S=s("div"),S.innerHTML=tn,Re=o(),X=s("p"),X.innerHTML=nn,ze=o(),Y=s("p"),Y.textContent=an,De=o(),Q=s("p"),Q.innerHTML=on,Xe=o(),m(A.$$.fragment),Ye=o(),O=s("p"),O.innerHTML=sn,Qe=o(),K=s("p"),K.textContent=rn,Oe=o(),ee=s("table"),ee.innerHTML=ln,Ke=o(),te=s("p"),te.innerHTML=pn,et=o(),ne=s("p"),ne.innerHTML=dn,tt=o(),m(E.$$.fragment),nt=o(),m(ae.$$.fragment),at=o(),oe=s("p"),oe.textContent=cn,ot=o(),ie=s("p"),ie.innerHTML=mn,it=o(),m(se.$$.fragment),st=o(),m(re.$$.fragment),rt=o(),y=s("div"),m(le.$$.fragment),Pt=o(),Ie=s("p"),Ie.innerHTML=gn,$t=o(),J=s("div"),m(pe.$$.fragment),St=o(),ke=s("p"),ke.textContent=un,It=o(),m(j.$$.fragment),kt=o(),Z=s("div"),m(de.$$.fragment),Ct=o(),Ce=s("p"),Ce.innerHTML=fn,Jt=o(),B=s("div"),m(ce.$$.fragment),Gt=o(),Je=s("p"),Je.innerHTML=_n,Ut=o(),q=s("div"),m(me.$$.fragment),Lt=o(),Ge=s("p"),Ge.textContent=hn,At=o(),N=s("div"),m(ge.$$.fragment),Et=o(),Ue=s("p"),Ue.textContent=bn,jt=o(),V=s("div"),m(ue.$$.fragment),Zt=o(),Le=s("p"),Le.textContent=vn,lt=o(),m(fe.$$.fragment),pt=o(),w=s("div"),m(_e.$$.fragment),Bt=o(),Ae=s("p"),Ae.innerHTML=yn,qt=o(),G=s("div"),m(he.$$.fragment),Nt=o(),Ee=s("p"),Ee.textContent=wn,Vt=o(),m(F.$$.fragment),Ft=o(),W=s("div"),m(be.$$.fragment),Wt=o(),je=s("p"),je.innerHTML=xn,Ht=o(),H=s("div"),m(ve.$$.fragment),Rt=o(),Ze=s("p"),Ze.innerHTML=Mn,zt=o(),R=s("div"),m(ye.$$.fragment),Dt=o(),Be=s("p"),Be.textContent=Tn,Xt=o(),z=s("div"),m(we.$$.fragment),Yt=o(),qe=s("p"),qe.textContent=Pn,Qt=o(),D=s("div"),m(xe.$$.fragment),Ot=o(),Ne=s("p"),Ne.textContent=$n,dt=o(),m(Me.$$.fragment),ct=o(),U=s("div"),m(Te.$$.fragment),Kt=o(),Ve=s("p"),Ve.textContent=Sn,mt=o(),m(Pe.$$.fragment),gt=o(),We=s("p"),this.h()},l(e){const n=Ln("svelte-u9bgzb",document.head);p=r(n,"META",{name:!0,content:!0}),n.forEach(t),$=i(e),b=r(e,"P",{}),P(b).forEach(t),v=i(e),g(T.$$.fragment,e),d=i(e),S=r(e,"DIV",{class:!0,"data-svelte-h":!0}),c(S)!=="svelte-1elo7hh"&&(S.innerHTML=tn),Re=i(e),X=r(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-h8aibn"&&(X.innerHTML=nn),ze=i(e),Y=r(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1cwsb16"&&(Y.textContent=an),De=i(e),Q=r(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1uh3w7a"&&(Q.innerHTML=on),Xe=i(e),g(A.$$.fragment,e),Ye=i(e),O=r(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1eg28j8"&&(O.innerHTML=sn),Qe=i(e),K=r(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1bob28v"&&(K.textContent=rn),Oe=i(e),ee=r(e,"TABLE",{"data-svelte-h":!0}),c(ee)!=="svelte-dcodwq"&&(ee.innerHTML=ln),Ke=i(e),te=r(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1swlfqd"&&(te.innerHTML=pn),et=i(e),ne=r(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-okwwje"&&(ne.innerHTML=dn),tt=i(e),g(E.$$.fragment,e),nt=i(e),g(ae.$$.fragment,e),at=i(e),oe=r(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1ou2pxc"&&(oe.textContent=cn),ot=i(e),ie=r(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-z3hp9b"&&(ie.innerHTML=mn),it=i(e),g(se.$$.fragment,e),st=i(e),g(re.$$.fragment,e),rt=i(e),y=r(e,"DIV",{class:!0});var x=P(y);g(le.$$.fragment,x),Pt=i(x),Ie=r(x,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-1ot17tf"&&(Ie.innerHTML=gn),$t=i(x),J=r(x,"DIV",{class:!0});var L=P(J);g(pe.$$.fragment,L),St=i(L),ke=r(L,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-v78lg8"&&(ke.textContent=un),It=i(L),g(j.$$.fragment,L),L.forEach(t),kt=i(x),Z=r(x,"DIV",{class:!0});var $e=P(Z);g(de.$$.fragment,$e),Ct=i($e),Ce=r($e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1s3c06i"&&(Ce.innerHTML=fn),$e.forEach(t),Jt=i(x),B=r(x,"DIV",{class:!0});var Se=P(B);g(ce.$$.fragment,Se),Gt=i(Se),Je=r(Se,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-pkn4ui"&&(Je.innerHTML=_n),Se.forEach(t),Ut=i(x),q=r(x,"DIV",{class:!0});var ft=P(q);g(me.$$.fragment,ft),Lt=i(ft),Ge=r(ft,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-14bnrb6"&&(Ge.textContent=hn),ft.forEach(t),At=i(x),N=r(x,"DIV",{class:!0});var _t=P(N);g(ge.$$.fragment,_t),Et=i(_t),Ue=r(_t,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1xwrf7t"&&(Ue.textContent=bn),_t.forEach(t),jt=i(x),V=r(x,"DIV",{class:!0});var ht=P(V);g(ue.$$.fragment,ht),Zt=i(ht),Le=r(ht,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-16q0ax1"&&(Le.textContent=vn),ht.forEach(t),x.forEach(t),lt=i(e),g(fe.$$.fragment,e),pt=i(e),w=r(e,"DIV",{class:!0});var I=P(w);g(_e.$$.fragment,I),Bt=i(I),Ae=r(I,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-vrq74s"&&(Ae.innerHTML=yn),qt=i(I),G=r(I,"DIV",{class:!0});var Fe=P(G);g(he.$$.fragment,Fe),Nt=i(Fe),Ee=r(Fe,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-v78lg8"&&(Ee.textContent=wn),Vt=i(Fe),g(F.$$.fragment,Fe),Fe.forEach(t),Ft=i(I),W=r(I,"DIV",{class:!0});var bt=P(W);g(be.$$.fragment,bt),Wt=i(bt),je=r(bt,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1s3c06i"&&(je.innerHTML=xn),bt.forEach(t),Ht=i(I),H=r(I,"DIV",{class:!0});var vt=P(H);g(ve.$$.fragment,vt),Rt=i(vt),Ze=r(vt,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-pkn4ui"&&(Ze.innerHTML=Mn),vt.forEach(t),zt=i(I),R=r(I,"DIV",{class:!0});var yt=P(R);g(ye.$$.fragment,yt),Dt=i(yt),Be=r(yt,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-14bnrb6"&&(Be.textContent=Tn),yt.forEach(t),Xt=i(I),z=r(I,"DIV",{class:!0});var wt=P(z);g(we.$$.fragment,wt),Yt=i(wt),qe=r(wt,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-1xwrf7t"&&(qe.textContent=Pn),wt.forEach(t),Qt=i(I),D=r(I,"DIV",{class:!0});var xt=P(D);g(xe.$$.fragment,xt),Ot=i(xt),Ne=r(xt,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-16q0ax1"&&(Ne.textContent=$n),xt.forEach(t),I.forEach(t),dt=i(e),g(Me.$$.fragment,e),ct=i(e),U=r(e,"DIV",{class:!0});var Mt=P(U);g(Te.$$.fragment,Mt),Kt=i(Mt),Ve=r(Mt,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-1h3n85u"&&(Ve.textContent=Sn),Mt.forEach(t),mt=i(e),g(Pe.$$.fragment,e),gt=i(e),We=r(e,"P",{}),P(We).forEach(t),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",Nn),M(S,"class","flex flex-wrap space-x-1"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,p),l(e,$,n),l(e,b,n),l(e,v,n),u(T,e,n),l(e,d,n),l(e,S,n),l(e,Re,n),l(e,X,n),l(e,ze,n),l(e,Y,n),l(e,De,n),l(e,Q,n),l(e,Xe,n),u(A,e,n),l(e,Ye,n),l(e,O,n),l(e,Qe,n),l(e,K,n),l(e,Oe,n),l(e,ee,n),l(e,Ke,n),l(e,te,n),l(e,et,n),l(e,ne,n),l(e,tt,n),u(E,e,n),l(e,nt,n),u(ae,e,n),l(e,at,n),l(e,oe,n),l(e,ot,n),l(e,ie,n),l(e,it,n),u(se,e,n),l(e,st,n),u(re,e,n),l(e,rt,n),l(e,y,n),u(le,y,null),a(y,Pt),a(y,Ie),a(y,$t),a(y,J),u(pe,J,null),a(J,St),a(J,ke),a(J,It),u(j,J,null),a(y,kt),a(y,Z),u(de,Z,null),a(Z,Ct),a(Z,Ce),a(y,Jt),a(y,B),u(ce,B,null),a(B,Gt),a(B,Je),a(y,Ut),a(y,q),u(me,q,null),a(q,Lt),a(q,Ge),a(y,At),a(y,N),u(ge,N,null),a(N,Et),a(N,Ue),a(y,jt),a(y,V),u(ue,V,null),a(V,Zt),a(V,Le),l(e,lt,n),u(fe,e,n),l(e,pt,n),l(e,w,n),u(_e,w,null),a(w,Bt),a(w,Ae),a(w,qt),a(w,G),u(he,G,null),a(G,Nt),a(G,Ee),a(G,Vt),u(F,G,null),a(w,Ft),a(w,W),u(be,W,null),a(W,Wt),a(W,je),a(w,Ht),a(w,H),u(ve,H,null),a(H,Rt),a(H,Ze),a(w,zt),a(w,R),u(ye,R,null),a(R,Dt),a(R,Be),a(w,Xt),a(w,z),u(we,z,null),a(z,Yt),a(z,qe),a(w,Qt),a(w,D),u(xe,D,null),a(D,Ot),a(D,Ne),l(e,dt,n),u(Me,e,n),l(e,ct,n),l(e,U,n),u(Te,U,null),a(U,Kt),a(U,Ve),l(e,mt,n),u(Pe,e,n),l(e,gt,n),l(e,We,n),ut=!0},p(e,[n]){const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),A.$set(x);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),E.$set(L);const $e={};n&2&&($e.$$scope={dirty:n,ctx:e}),j.$set($e);const Se={};n&2&&(Se.$$scope={dirty:n,ctx:e}),F.$set(Se)},i(e){ut||(f(T.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(j.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(he.$$.fragment,e),f(F.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(xe.$$.fragment,e),f(Me.$$.fragment,e),f(Te.$$.fragment,e),f(Pe.$$.fragment,e),ut=!0)},o(e){_(T.$$.fragment,e),_(A.$$.fragment,e),_(E.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(j.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(he.$$.fragment,e),_(F.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(Pe.$$.fragment,e),ut=!1},d(e){e&&(t($),t(b),t(v),t(d),t(S),t(Re),t(X),t(ze),t(Y),t(De),t(Q),t(Xe),t(Ye),t(O),t(Qe),t(K),t(Oe),t(ee),t(Ke),t(te),t(et),t(ne),t(tt),t(nt),t(at),t(oe),t(ot),t(ie),t(it),t(st),t(rt),t(y),t(lt),t(pt),t(w),t(dt),t(ct),t(U),t(mt),t(gt),t(We)),t(p),h(T,e),h(A,e),h(E,e),h(ae,e),h(se,e),h(re,e),h(le),h(pe),h(j),h(de),h(ce),h(me),h(ge),h(ue),h(fe,e),h(_e),h(he),h(F),h(be),h(ve),h(ye),h(we),h(xe),h(Me,e),h(Te),h(Pe,e)}}}const Nn='{"title":"SanaPipeline","local":"sanapipeline","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"SanaPipeline","local":"diffusers.SanaPipeline","sections":[],"depth":2},{"title":"SanaPAGPipeline","local":"diffusers.SanaPAGPipeline","sections":[],"depth":2},{"title":"SanaPipelineOutput","local":"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput","sections":[],"depth":2}],"depth":1}';function Vn(C){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yn extends Gn{constructor(p){super(),Un(this,p,Vn,qn,Cn,{})}}export{Yn as component};
