import{s as Ge,n as Je,o as De}from"../chunks/scheduler.8c3d61f6.js";import{S as je,i as Ke,g as i,s,r as c,A as Ce,h as r,f as n,c as a,j as F,u as m,x as b,k as N,y as g,a as o,v as d,d as u,t as p,w as f}from"../chunks/index.da70eac4.js";import{D as ge}from"../chunks/Docstring.932cdff3.js";import{C as Re}from"../chunks/CodeBlock.a9c4becf.js";import{H as V,E as Be}from"../chunks/index.ef90fe87.js";function Ee(we){let h,S,Y,I,w,H,M,Me='Improved larger variational autoencoder (VAE) model with KL loss for inpainting task: <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">Designing a Better Asymmetric VQGAN for StableDiffusion</a> by Zixin Zhu, Xuelu Feng, Dongdong Chen, Jianmin Bao, Le Wang, Yinpeng Chen, Lu Yuan, Gang Hua.',O,k,ke="The abstract from the paper is:",q,$,$e='<em>StableDiffusion is a revolutionary text-to-image generator that is causing a stir in the world of image generation and editing. Unlike traditional methods that learn a diffusion model in pixel space, StableDiffusion learns a diffusion model in the latent space via a VQGAN, ensuring both efficiency and quality. It not only supports image generation tasks, but also enables image editing for real images, such as image inpainting and local editing. However, we have observed that the vanilla VQGAN used in StableDiffusion leads to significant information loss, causing distortion artifacts even in non-edited image regions. To this end, we propose a new asymmetric VQGAN with two simple designs. Firstly, in addition to the input from the encoder, the decoder contains a conditional branch that incorporates information from task-specific priors, such as the unmasked image region in inpainting. Secondly, the decoder is much heavier than the encoder, allowing for more detailed recovery while only slightly increasing the total inference cost. The training cost of our asymmetric VQGAN is cheap, and we only need to retrain a new asymmetric decoder while keeping the vanilla VQGAN encoder and StableDiffusion unchanged. Our asymmetric VQGAN can be widely used in StableDiffusion-based inpainting and local editing methods. Extensive experiments demonstrate that it can significantly improve the inpainting and editing performance, while maintaining the original text-to-image capability. The code is available at <a href="https://github.com/buxiangzhiren/Asymmetric_VQGAN" rel="nofollow">https://github.com/buxiangzhiren/Asymmetric_VQGAN</a></em>',P,A,Ae="Evaluation results can be found in section 4.1 of the original paper.",ee,T,te,x,Te='<li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5</a></li> <li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2</a></li>',ne,Z,oe,W,se,L,ae,l,U,he,R,xe=`Designing a Better Asymmetric VQGAN for StableDiffusion <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">https://arxiv.org/abs/2306.04632</a> . A VAE model with KL loss
for encoding images into latents and decoding latent representations into images.`,_e,B,Ze=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,ye,E,G,ie,J,re,_,D,be,X,We="Output of AutoencoderKL encoding method.",le,j,ce,y,K,ve,z,Le="Output of decoding method.",me,C,de,Q,ue;return w=new V({props:{title:"AsymmetricAutoencoderKL",local:"asymmetricautoencoderkl",headingTag:"h1"}}),T=new V({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),Z=new V({props:{title:"Example Usage",local:"example-usage",headingTag:"h2"}}),W=new Re({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFzeW1tZXRyaWNBdXRvZW5jb2RlcktMJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBwZXJzb24lMjB3aXRoJTIwYmVhcmQlMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZjZWxlYmFfaHFfMjU2LnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZtYXNrXzI1Ni5wbmclMjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIpJTBBcGlwZS52YWUlMjAlM0QlMjBBc3ltbWV0cmljQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIyY3Jvc3MtYXR0ZW50aW9uJTJGYXN5bW1ldHJpYy1hdXRvZW5jb2Rlci1rbC14LTEtNSUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEb3JpZ2luYWxfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AsymmetricAutoencoderKL, StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid


prompt = <span class="hljs-string">&quot;a photo of a person with beard&quot;</span>
img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/celeba_hq_256.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/mask_256.png&quot;</span>

original_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>)
pipe.vae = AsymmetricAutoencoderKL.from_pretrained(<span class="hljs-string">&quot;cross-attention/asymmetric-autoencoder-kl-x-1-5&quot;</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(prompt=prompt, image=original_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),L=new V({props:{title:"AsymmetricAutoencoderKL",local:"diffusers.AsymmetricAutoencoderKL",headingTag:"h2"}}),U=new ge({props:{name:"class diffusers.AsymmetricAutoencoderKL",anchor:"diffusers.AsymmetricAutoencoderKL",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"down_block_types",val:": typing.Tuple[str, ...] = ('DownEncoderBlock2D',)"},{name:"down_block_out_channels",val:": typing.Tuple[int, ...] = (64,)"},{name:"layers_per_down_block",val:": int = 1"},{name:"up_block_types",val:": typing.Tuple[str, ...] = ('UpDecoderBlock2D',)"},{name:"up_block_out_channels",val:": typing.Tuple[int, ...] = (64,)"},{name:"layers_per_up_block",val:": int = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"latent_channels",val:": int = 4"},{name:"norm_num_groups",val:": int = 32"},{name:"sample_size",val:": int = 32"},{name:"scaling_factor",val:": float = 0.18215"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.in_channels",description:"<strong>in_channels</strong> (int, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.out_channels",description:"<strong>out_channels</strong> (int,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;DownEncoderBlock2D&quot;,)</code>) &#x2014;
Tuple of downsample block types.`,name:"down_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_out_channels",description:`<strong>down_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of down block output channels.`,name:"down_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_down_block",description:`<strong>layers_per_down_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for down block.`,name:"layers_per_down_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpDecoderBlock2D&quot;,)</code>) &#x2014;
Tuple of upsample block types.`,name:"up_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_out_channels",description:`<strong>up_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of up block output channels.`,name:"up_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_up_block",description:`<strong>layers_per_up_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for up block.`,name:"layers_per_up_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AsymmetricAutoencoderKL.latent_channels",description:"<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the latent space.",name:"latent_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.sample_size",description:"<strong>sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014; Sample input size.",name:"sample_size"},{anchor:"diffusers.AsymmetricAutoencoderKL.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
Number of groups to use for the first normalization layer in ResNet blocks.`,name:"norm_num_groups"},{anchor:"diffusers.AsymmetricAutoencoderKL.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L26"}}),G=new ge({props:{name:"forward",anchor:"diffusers.AsymmetricAutoencoderKL.forward",parameters:[{name:"sample",val:": Tensor"},{name:"mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sample_posterior",val:": bool = False"},{name:"return_dict",val:": bool = True"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample",description:"<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.mask",description:"<strong>mask</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014; Optional inpainting mask.",name:"mask"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample_posterior",description:`<strong>sample_posterior</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample from the posterior.`,name:"sample_posterior"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L158"}}),J=new V({props:{title:"AutoencoderKLOutput",local:"diffusers.models.modeling_outputs.AutoencoderKLOutput",headingTag:"h2"}}),D=new ge({props:{name:"class diffusers.models.modeling_outputs.AutoencoderKLOutput",anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput",parameters:[{name:"latent_dist",val:": DiagonalGaussianDistribution"}],parametersDescription:[{anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput.latent_dist",description:`<strong>latent_dist</strong> (<code>DiagonalGaussianDistribution</code>) &#x2014;
Encoded outputs of <code>Encoder</code> represented as the mean and logvar of <code>DiagonalGaussianDistribution</code>.
<code>DiagonalGaussianDistribution</code> allows for sampling latents from the distribution.`,name:"latent_dist"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L6"}}),j=new V({props:{title:"DecoderOutput",local:"diffusers.models.autoencoders.vae.DecoderOutput",headingTag:"h2"}}),K=new ge({props:{name:"class diffusers.models.autoencoders.vae.DecoderOutput",anchor:"diffusers.models.autoencoders.vae.DecoderOutput",parameters:[{name:"sample",val:": Tensor"},{name:"commit_loss",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"diffusers.models.autoencoders.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vae.py#L46"}}),C=new Be({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/asymmetricautoencoderkl.md"}}),{c(){h=i("meta"),S=s(),Y=i("p"),I=s(),c(w.$$.fragment),H=s(),M=i("p"),M.innerHTML=Me,O=s(),k=i("p"),k.textContent=ke,q=s(),$=i("p"),$.innerHTML=$e,P=s(),A=i("p"),A.textContent=Ae,ee=s(),c(T.$$.fragment),te=s(),x=i("ul"),x.innerHTML=Te,ne=s(),c(Z.$$.fragment),oe=s(),c(W.$$.fragment),se=s(),c(L.$$.fragment),ae=s(),l=i("div"),c(U.$$.fragment),he=s(),R=i("p"),R.innerHTML=xe,_e=s(),B=i("p"),B.innerHTML=Ze,ye=s(),E=i("div"),c(G.$$.fragment),ie=s(),c(J.$$.fragment),re=s(),_=i("div"),c(D.$$.fragment),be=s(),X=i("p"),X.textContent=We,le=s(),c(j.$$.fragment),ce=s(),y=i("div"),c(K.$$.fragment),ve=s(),z=i("p"),z.textContent=Le,me=s(),c(C.$$.fragment),de=s(),Q=i("p"),this.h()},l(e){const t=Ce("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(n),S=a(e),Y=r(e,"P",{}),F(Y).forEach(n),I=a(e),m(w.$$.fragment,e),H=a(e),M=r(e,"P",{"data-svelte-h":!0}),b(M)!=="svelte-8mpj0"&&(M.innerHTML=Me),O=a(e),k=r(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-1cwsb16"&&(k.textContent=ke),q=a(e),$=r(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-ggnlwl"&&($.innerHTML=$e),P=a(e),A=r(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-1dzj46z"&&(A.textContent=Ae),ee=a(e),m(T.$$.fragment,e),te=a(e),x=r(e,"UL",{"data-svelte-h":!0}),b(x)!=="svelte-1m6ravg"&&(x.innerHTML=Te),ne=a(e),m(Z.$$.fragment,e),oe=a(e),m(W.$$.fragment,e),se=a(e),m(L.$$.fragment,e),ae=a(e),l=r(e,"DIV",{class:!0});var v=F(l);m(U.$$.fragment,v),he=a(v),R=r(v,"P",{"data-svelte-h":!0}),b(R)!=="svelte-4v08r1"&&(R.innerHTML=xe),_e=a(v),B=r(v,"P",{"data-svelte-h":!0}),b(B)!=="svelte-1hyu2ru"&&(B.innerHTML=Ze),ye=a(v),E=r(v,"DIV",{class:!0});var Ue=F(E);m(G.$$.fragment,Ue),Ue.forEach(n),v.forEach(n),ie=a(e),m(J.$$.fragment,e),re=a(e),_=r(e,"DIV",{class:!0});var pe=F(_);m(D.$$.fragment,pe),be=a(pe),X=r(pe,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1vsc7ag"&&(X.textContent=We),pe.forEach(n),le=a(e),m(j.$$.fragment,e),ce=a(e),y=r(e,"DIV",{class:!0});var fe=F(y);m(K.$$.fragment,fe),ve=a(fe),z=r(fe,"P",{"data-svelte-h":!0}),b(z)!=="svelte-18u8upa"&&(z.textContent=Le),fe.forEach(n),me=a(e),m(C.$$.fragment,e),de=a(e),Q=r(e,"P",{}),F(Q).forEach(n),this.h()},h(){N(h,"name","hf:doc:metadata"),N(h,"content",Xe),N(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){g(document.head,h),o(e,S,t),o(e,Y,t),o(e,I,t),d(w,e,t),o(e,H,t),o(e,M,t),o(e,O,t),o(e,k,t),o(e,q,t),o(e,$,t),o(e,P,t),o(e,A,t),o(e,ee,t),d(T,e,t),o(e,te,t),o(e,x,t),o(e,ne,t),d(Z,e,t),o(e,oe,t),d(W,e,t),o(e,se,t),d(L,e,t),o(e,ae,t),o(e,l,t),d(U,l,null),g(l,he),g(l,R),g(l,_e),g(l,B),g(l,ye),g(l,E),d(G,E,null),o(e,ie,t),d(J,e,t),o(e,re,t),o(e,_,t),d(D,_,null),g(_,be),g(_,X),o(e,le,t),d(j,e,t),o(e,ce,t),o(e,y,t),d(K,y,null),g(y,ve),g(y,z),o(e,me,t),d(C,e,t),o(e,de,t),o(e,Q,t),ue=!0},p:Je,i(e){ue||(u(w.$$.fragment,e),u(T.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(J.$$.fragment,e),u(D.$$.fragment,e),u(j.$$.fragment,e),u(K.$$.fragment,e),u(C.$$.fragment,e),ue=!0)},o(e){p(w.$$.fragment,e),p(T.$$.fragment,e),p(Z.$$.fragment,e),p(W.$$.fragment,e),p(L.$$.fragment,e),p(U.$$.fragment,e),p(G.$$.fragment,e),p(J.$$.fragment,e),p(D.$$.fragment,e),p(j.$$.fragment,e),p(K.$$.fragment,e),p(C.$$.fragment,e),ue=!1},d(e){e&&(n(S),n(Y),n(I),n(H),n(M),n(O),n(k),n(q),n($),n(P),n(A),n(ee),n(te),n(x),n(ne),n(oe),n(se),n(ae),n(l),n(ie),n(re),n(_),n(le),n(ce),n(y),n(me),n(de),n(Q)),n(h),f(w,e),f(T,e),f(Z,e),f(W,e),f(L,e),f(U),f(G),f(J,e),f(D),f(j,e),f(K),f(C,e)}}}const Xe='{"title":"AsymmetricAutoencoderKL","local":"asymmetricautoencoderkl","sections":[{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Example Usage","local":"example-usage","sections":[],"depth":2},{"title":"AsymmetricAutoencoderKL","local":"diffusers.AsymmetricAutoencoderKL","sections":[],"depth":2},{"title":"AutoencoderKLOutput","local":"diffusers.models.modeling_outputs.AutoencoderKLOutput","sections":[],"depth":2},{"title":"DecoderOutput","local":"diffusers.models.autoencoders.vae.DecoderOutput","sections":[],"depth":2}],"depth":1}';function ze(we){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Se extends je{constructor(h){super(),Ke(this,h,ze,Ee,Ge,{})}}export{Se as component};
