import{S as hw,i as uw,s as fw,e as o,k as l,w as _,t as a,M as gw,c as s,d as r,m as d,a as n,x as P,h as i,b as c,N as vw,G as e,g as h,y as b,q as w,o as y,B as $,v as _w,L as $t}from"../../chunks/vendor-hf-doc-builder.js";import{T as wt}from"../../chunks/Tip-hf-doc-builder.js";import{D as x}from"../../chunks/Docstring-hf-doc-builder.js";import{C as kt}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as C}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as yt}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function Pw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverModel, PerceiverConfig

# Initializing a Perceiver deepmind/language-perceiver style configuration
configuration = PerceiverConfig()

# Initializing a model from the deepmind/language-perceiver style configuration
model = PerceiverModel(configuration)

# Accessing the model configuration
configuration = model.config`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){u=o("p"),T=a("Example:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Example:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function bw(E){let u,T;return{c(){u=o("p"),T=a(`NumPy arrays and PyTorch tensors are converted to PIL images when resizing, so the most efficient is to pass
PIL images.`)},l(v){u=s(v,"P",{});var g=n(u);T=i(g,`NumPy arrays and PyTorch tensors are converted to PIL images when resizing, so the most efficient is to pass
PIL images.`),g.forEach(r)},m(v,g){h(v,u,g),e(u,T)},d(v){v&&r(u)}}}function ww(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function yw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverConfig, PerceiverTokenizer, PerceiverFeatureExtractor, PerceiverModel
from transformers.models.perceiver.modeling_perceiver import (
    PerceiverTextPreprocessor,
    PerceiverImagePreprocessor,
    PerceiverClassificationDecoder,
)
import torch
import requests
from PIL import Image

# EXAMPLE 1: using the Perceiver to classify texts
# - we define a TextPreprocessor, which can be used to embed tokens
# - we define a ClassificationDecoder, which can be used to decode the
# final hidden states of the latents to classification logits
# using trainable position embeddings
config = PerceiverConfig()
preprocessor = PerceiverTextPreprocessor(config)
decoder = PerceiverClassificationDecoder(
    config,
    num_channels=config.d_latents,
    trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
    use_query_residual=True,
)
model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

# you can then do a forward pass as follows:
tokenizer = PerceiverTokenizer()
text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)

# EXAMPLE 2: using the Perceiver to classify images
# - we define an ImagePreprocessor, which can be used to embed images
preprocessor = PerceiverImagePreprocessor(
    config,
    prep_type="conv1x1",
    spatial_downsample=1,
    out_channels=256,
    position_encoding_type="trainable",
    concat_or_add_pos="concat",
    project_pos_dim=256,
    trainable_position_encoding_kwargs=dict(
        num_channels=256,
        index_dims=config.image_size**2,
    ),
)

model = PerceiverModel(
    config,
    input_preprocessor=preprocessor,
    decoder=PerceiverClassificationDecoder(
        config,
        num_channels=config.d_latents,
        trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
        use_query_residual=True,
    ),
)

# you can then do a forward pass as follows:
feature_extractor = PerceiverFeatureExtractor()
url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)
inputs = feature_extractor(image, return_tensors="pt").pixel_values

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverFeatureExtractor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function $w(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function kw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverTokenizer, PerceiverForMaskedLM
import torch

tokenizer = PerceiverTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForMaskedLM.from_pretrained("deepmind/language-perceiver")

# training
text = "This is an incomplete sentence where some words are missing."
inputs = tokenizer(text, padding="max_length", return_tensors="pt")
# mask " missing."
inputs["input_ids"][0, 52:61] = tokenizer.mask_token_id
labels = tokenizer(text, padding="max_length", return_tensors="pt").input_ids

outputs = model(**inputs, labels=labels)
loss = outputs.loss
logits = outputs.logits

# inference
text = "This is an incomplete sentence where some words are missing."
encoding = tokenizer(text, padding="max_length", return_tensors="pt")

# mask bytes corresponding to " missing.". Note that the model performs much better if the masked span starts with a space.
encoding["input_ids"][0, 52:61] = tokenizer.mask_token_id

# forward pass
with torch.no_grad():
    outputs = model(**encoding)
logits = outputs.logits

masked_tokens_predictions = logits[0, 52:61].argmax(dim=-1).tolist()
tokenizer.decode(masked_tokens_predictions)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function Tw(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function xw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverTokenizer, PerceiverForSequenceClassification

tokenizer = PerceiverTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForSequenceClassification.from_pretrained("deepmind/language-perceiver")

text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids
outputs = model(inputs=inputs)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function Ew(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Fw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverFeatureExtractor, PerceiverForImageClassificationLearned
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

feature_extractor = PerceiverFeatureExtractor.from_pretrained("deepmind/vision-perceiver-learned")
model = PerceiverForImageClassificationLearned.from_pretrained("deepmind/vision-perceiver-learned")

inputs = feature_extractor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverFeatureExtractor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function Cw(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function jw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverFeatureExtractor, PerceiverForImageClassificationFourier
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

feature_extractor = PerceiverFeatureExtractor.from_pretrained("deepmind/vision-perceiver-fourier")
model = PerceiverForImageClassificationFourier.from_pretrained("deepmind/vision-perceiver-fourier")

inputs = feature_extractor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverFeatureExtractor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function Mw(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Iw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverFeatureExtractor, PerceiverForImageClassificationConvProcessing
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

feature_extractor = PerceiverFeatureExtractor.from_pretrained("deepmind/vision-perceiver-conv")
model = PerceiverForImageClassificationConvProcessing.from_pretrained("deepmind/vision-perceiver-conv")

inputs = feature_extractor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverFeatureExtractor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = PerceiverFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function qw(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function zw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverForOpticalFlow
import torch

model = PerceiverForOpticalFlow.from_pretrained("deepmind/optical-flow-perceiver")

# in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,
# leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)
# patches have shape (batch_size, num_frames, num_channels, height, width)
# the authors train on resolutions of 368 x 496
patches = torch.randn(1, 2, 27, 368, 496)
outputs = model(inputs=patches)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function Aw(E){let u,T,v,g,k;return{c(){u=o("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=o("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var F=n(v);g=i(F,"Module"),F.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Dw(E){let u,T,v,g,k;return g=new kt({props:{code:`from transformers import PerceiverForMultimodalAutoencoding
import torch
import numpy as np

# create multimodal inputs
images = torch.randn((1, 16, 3, 224, 224))
audio = torch.randn((1, 30720, 1))
inputs = dict(image=images, audio=audio, label=torch.zeros((images.shape[0], 700)))

model = PerceiverForMultimodalAutoencoding.from_pretrained("deepmind/multimodal-perceiver")

# in the Perceiver IO paper, videos are auto-encoded in chunks
# each chunk subsamples different index dimensions of the image and audio modality decoder queries
nchunks = 128
image_chunk_size = np.prod((16, 224, 224)) // nchunks
audio_chunk_size = audio.shape[1] // model.config.samples_per_patch // nchunks
# process the first chunk
chunk_idx = 0
subsampling = {
    "image": torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + 1)),
    "audio": torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + 1)),
    "label": None,
}

outputs = model(inputs=inputs, subsampled_output_points=subsampling)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){u=o("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:$t,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function Ow(E){let u,T,v,g,k,p,f,F,ep,xc,$e,Tt,Xn,Ar,tp,Zn,rp,Ec,xt,op,Dr,sp,np,Fc,Et,ap,Or,ip,cp,Cc,Ns,lp,jc,Ls,Qn,dp,Mc,Ss,pp,Ic,Bs,mp,qc,D,hp,Hs,up,fp,Yn,gp,vp,ea,_p,Pp,ta,bp,wp,ra,yp,$p,zc,Ws,kp,Ac,M,Tp,oa,xp,Ep,sa,Fp,Cp,na,jp,Mp,aa,Ip,qp,ia,zp,Ap,ca,Dp,Op,Dc,Ft,x_,Oc,Nr,Np,Vs,Lp,Nc,ve,Sp,Lr,Bp,Hp,Sr,Wp,Vp,Lc,Us,Up,Sc,Ct,Br,Rp,Hr,Kp,Jp,Gp,Wr,Xp,Vr,Zp,Qp,Bc,Ur,la,Yp,em,Hc,Rs,_e,tm,da,rm,om,pa,sm,nm,Rr,am,Wc,ke,jt,ma,Kr,im,ha,cm,Vc,Te,Jr,lm,ua,dm,Uc,xe,Gr,pm,fa,mm,Rc,Ee,Xr,hm,ga,um,Kc,Fe,Zr,fm,va,gm,Jc,Ce,Mt,_a,Qr,vm,Pa,_m,Gc,V,Yr,Pm,je,bm,Ks,wm,ym,eo,$m,km,Tm,Me,xm,Js,Em,Fm,Gs,Cm,jm,Mm,It,Xc,Ie,qt,ba,to,Im,wa,qm,Zc,U,ro,zm,ya,Am,Dm,oo,Om,Xs,Nm,Lm,Sm,zt,so,Bm,$a,Hm,Qc,qe,At,ka,no,Wm,Ta,Vm,Yc,R,ao,Um,xa,Rm,Km,io,Jm,Zs,Gm,Xm,Zm,Pe,co,Qm,Ea,Ym,eh,Dt,el,ze,Ot,Fa,lo,th,Ca,rh,tl,ae,po,oh,mo,sh,ja,nh,ah,ih,ho,ch,Ma,lh,dh,rl,Ae,Nt,Ia,uo,ph,qa,mh,ol,ie,fo,hh,za,uh,fh,K,gh,Aa,vh,_h,Da,Ph,bh,Oa,wh,yh,Na,$h,kh,sl,De,Lt,La,go,Th,Sa,xh,nl,Oe,vo,Eh,Ba,Fh,al,Ne,St,Ha,_o,Ch,Wa,jh,il,Le,Po,Mh,Va,Ih,cl,Se,Bt,Ua,bo,qh,Ra,zh,ll,ce,wo,Ah,Ka,Dh,Oh,Ja,Nh,dl,Be,Ht,Ga,yo,Lh,Xa,Sh,pl,He,$o,Bh,Za,Hh,ml,We,Wt,Qa,ko,Wh,Ya,Vh,hl,le,To,Uh,ei,Rh,Kh,ti,Jh,ul,Ve,Vt,ri,xo,Gh,oi,Xh,fl,Ue,Eo,Zh,Fo,Qh,si,Yh,eu,gl,Re,Ut,ni,Co,tu,ai,ru,vl,Ke,jo,ou,ii,su,_l,Je,Rt,ci,Mo,nu,li,au,Pl,Ge,Io,iu,qo,cu,di,lu,du,bl,Xe,Kt,pi,zo,pu,mi,mu,wl,de,Ao,hu,Do,uu,hi,fu,gu,vu,ui,_u,yl,Ze,Jt,fi,Oo,Pu,gi,bu,$l,Qe,No,wu,vi,yu,kl,Ye,Gt,_i,Lo,$u,Pi,ku,Tl,et,So,Tu,bi,xu,xl,tt,Xt,wi,Bo,Eu,yi,Fu,El,rt,Ho,Cu,$i,ju,Fl,ot,Zt,ki,Wo,Mu,Ti,Iu,Cl,st,Vo,qu,xi,zu,jl,nt,Qt,Ei,Uo,Au,Fi,Du,Ml,pe,Ro,Ou,Ko,Nu,Jo,Lu,Su,Bu,J,Go,Hu,at,Wu,Qs,Vu,Uu,Ci,Ru,Ku,Ju,Yt,Gu,er,Il,it,tr,ji,Xo,Xu,Mi,Zu,ql,me,Zo,Qu,Qo,Yu,Yo,ef,tf,rf,G,es,of,ct,sf,Ys,nf,af,Ii,cf,lf,df,rr,pf,or,zl,lt,sr,qi,ts,mf,zi,hf,Al,he,rs,uf,os,ff,ss,gf,vf,_f,X,ns,Pf,dt,bf,en,wf,yf,Ai,$f,kf,Tf,nr,xf,ar,Dl,pt,ir,Di,as,Ef,Oi,Ff,Ol,q,is,Cf,Ni,jf,Mf,Li,If,qf,S,tn,zf,Af,rn,Df,Of,Si,Nf,Lf,on,Sf,Bf,sn,Hf,Wf,Vf,cs,Uf,ls,Rf,Kf,Jf,Z,ds,Gf,mt,Xf,nn,Zf,Qf,Bi,Yf,eg,tg,cr,rg,lr,Nl,ht,dr,Hi,ps,og,Wi,sg,Ll,z,ms,ng,Vi,ag,ig,Ui,cg,lg,B,an,dg,pg,cn,mg,hg,Ri,ug,fg,ln,gg,vg,dn,_g,Pg,bg,hs,wg,us,yg,$g,kg,Q,fs,Tg,ut,xg,pn,Eg,Fg,Ki,Cg,jg,Mg,pr,Ig,mr,Sl,ft,hr,Ji,gs,qg,Gi,zg,Bl,A,vs,Ag,Xi,Dg,Og,Zi,Ng,Lg,H,mn,Sg,Bg,hn,Hg,Wg,Qi,Vg,Ug,un,Rg,Kg,fn,Jg,Gg,Xg,_s,Zg,Ps,Qg,Yg,ev,Y,bs,tv,gt,rv,gn,ov,sv,Yi,nv,av,iv,ur,cv,fr,Hl,vt,gr,ec,ws,lv,tc,dv,Wl,O,ys,pv,N,mv,vn,hv,uv,_n,fv,gv,rc,vv,_v,Pn,Pv,bv,bn,wv,yv,$v,oc,kv,Tv,$s,xv,ks,Ev,Fv,Cv,ee,Ts,jv,_t,Mv,wn,Iv,qv,sc,zv,Av,Dv,vr,Ov,_r,Vl,Pt,Pr,nc,xs,Nv,ac,Lv,Ul,j,Es,Sv,ic,Bv,Hv,br,yn,Wv,Vv,$n,Uv,Rv,Kv,be,kn,Jv,Gv,Tn,Xv,Zv,xn,Qv,Yv,e_,wr,En,t_,r_,Fn,o_,s_,n_,Fs,a_,cc,i_,c_,l_,lc,d_,p_,Cs,m_,js,h_,u_,f_,te,Ms,g_,bt,v_,Cn,__,P_,dc,b_,w_,y_,yr,$_,$r,Rl;return p=new C({}),Ar=new C({}),Kr=new C({}),Jr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L62"}}),Gr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L93"}}),Xr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L111"}}),Zr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L142"}}),Qr=new C({}),Yr=new x({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"position_embedding_init_scale",val:" = 0.02"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"is_encoder_decoder",val:" = False"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&apos;kv&apos;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to [368, 496]) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/configuration_perceiver.py#L36"}}),It=new yt({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[Pw]},$$scope:{ctx:E}}}),to=new C({}),ro=new x({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/tokenization_perceiver.py#L27"}}),so=new x({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = False"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.22.2/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.22.2/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability &gt;= 7.5 (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.22.2/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/v4.22.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/tokenization_utils_base.py#L2410",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> \u2014 List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> \u2014 List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>\u201Ctoken_type_ids\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> \u2014 List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>\u201Cattention_mask\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> \u2014 List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> \u2014 Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> \u2014 List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> \u2014 The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),no=new C({}),ao=new x({props:{name:"class transformers.PerceiverFeatureExtractor",anchor:"transformers.PerceiverFeatureExtractor",parameters:[{name:"do_center_crop",val:" = True"},{name:"crop_size",val:" = 256"},{name:"do_resize",val:" = True"},{name:"size",val:" = 224"},{name:"resample",val:" = <Resampling.BICUBIC: 3>"},{name:"do_normalize",val:" = True"},{name:"image_mean",val:" = None"},{name:"image_std",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverFeatureExtractor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to crop the input at the center. If the input size is smaller than <code>crop_size</code> along any edge, the
image is padded with 0&#x2019;s and then center cropped.`,name:"do_center_crop"},{anchor:"transformers.PerceiverFeatureExtractor.crop_size",description:`<strong>crop_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Desired output size when applying center-cropping. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.PerceiverFeatureExtractor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.PerceiverFeatureExtractor.size",description:`<strong>size</strong> (<code>int</code> or <code>Tuple(int)</code>, <em>optional</em>, defaults to 224) &#x2014;
Resize the input to the given size. If a tuple is provided, it should be (width, height). If only an
integer is provided, then the input will be resized to (size, size). Only has an effect if <code>do_resize</code> is
set to <code>True</code>.`,name:"size"},{anchor:"transformers.PerceiverFeatureExtractor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>PIL.Image.BICUBIC</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.NEAREST</code>, <code>PIL.Image.BOX</code>,
<code>PIL.Image.BILINEAR</code>, <code>PIL.Image.HAMMING</code>, <code>PIL.Image.BICUBIC</code> or <code>PIL.Image.LANCZOS</code>. Only has an effect
if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverFeatureExtractor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with <code>image_mean</code> and <code>image_std</code>.`,name:"do_normalize"},{anchor:"transformers.PerceiverFeatureExtractor.image_mean",description:`<strong>image_mean</strong> (<code>List[int]</code>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images.`,name:"image_mean"},{anchor:"transformers.PerceiverFeatureExtractor.image_std",description:`<strong>image_std</strong> (<code>List[int]</code>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/feature_extraction_perceiver.py#L36"}}),co=new x({props:{name:"__call__",anchor:"transformers.PerceiverFeatureExtractor.__call__",parameters:[{name:"images",val:": typing.Union[PIL.Image.Image, numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverFeatureExtractor.__call__.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. In case of a NumPy array/PyTorch tensor, each image should be of shape (C, H, W), where C is a
number of channels, H and W are image height and width.`,name:"images"},{anchor:"transformers.PerceiverFeatureExtractor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.22.2/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>, defaults to <code>&apos;np&apos;</code>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/feature_extraction_perceiver.py#L120",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> \u2014 Pixel values to be fed to a model, of shape (batch_size, num_channels, height,
width).</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Dt=new wt({props:{warning:!0,$$slots:{default:[bw]},$$scope:{ctx:E}}}),lo=new C({}),po=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2796"}}),uo=new C({}),fo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2954"}}),go=new C({}),vo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L3183"}}),_o=new C({}),Po=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L3209"}}),bo=new C({}),wo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]]]"},{name:"mask_probs",val:": typing.Union[typing.Mapping[str, float], NoneType] = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L3306"}}),yo=new C({}),$o=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2006"}}),ko=new C({}),To=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": typing.Optional[str] = 'trainable'"},{name:"output_index_dims",val:": typing.Optional[int] = None"},{name:"num_channels",val:": typing.Optional[int] = 128"},{name:"subsampled_index_dims",val:": typing.Optional[int] = None"},{name:"qk_channels",val:": typing.Optional[int] = None"},{name:"v_channels",val:": typing.Optional[int] = None"},{name:"num_heads",val:": typing.Optional[int] = 1"},{name:"widening_factor",val:": typing.Optional[int] = 1"},{name:"use_query_residual",val:": typing.Optional[bool] = False"},{name:"concat_preprocessed_input",val:": typing.Optional[bool] = False"},{name:"final_project",val:": typing.Optional[bool] = True"},{name:"position_encoding_only",val:": typing.Optional[bool] = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2032"}}),xo=new C({}),Eo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2218"}}),Co=new C({}),jo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2264"}}),Mo=new C({}),Io=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": typing.List[int]"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2299"}}),zo=new C({}),Ao=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": typing.Optional[int] = 2"},{name:"subsampled_index_dims",val:": typing.Union[typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder], NoneType] = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2376"}}),Oo=new C({}),No=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2933"}}),Lo=new C({}),So=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2905"}}),Bo=new C({}),Ho=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2885"}}),Wo=new C({}),Vo=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Any]]"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L2851"}}),Uo=new C({}),Ro=new x({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:" = None"},{name:"input_preprocessor",val:": typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]] = None"},{name:"output_postprocessor",val:": typing.Callable[..., typing.Any] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<em>DecoderType</em>, <em>optional</em>) &#x2014;
Optional decoder to use to decode the latent representation of the encoder. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder</em>.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<em>PreprocessorType</em>, <em>optional</em>) &#x2014;
Optional input preprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor</em>.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<em>PostprocessorType</em>, <em>optional</em>) &#x2014;
Optional output postprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor</em>.`,name:"output_postprocessor"},{anchor:"transformers.PerceiverModel.Note",description:"<strong>Note</strong> that you can define your own decoders, preprocessors and/or postprocessors to fit your use-case. &#x2014;",name:"Note"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L717"}}),Go=new x({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L753",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) \u2014 Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Yt=new wt({props:{$$slots:{default:[ww]},$$scope:{ctx:E}}}),er=new yt({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[yw]},$$scope:{ctx:E}}}),Xo=new C({}),Zo=new x({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L950"}}),es=new x({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L981",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) \u2014 Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),rr=new wt({props:{$$slots:{default:[$w]},$$scope:{ctx:E}}}),or=new yt({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[kw]},$$scope:{ctx:E}}}),ts=new C({}),rs=new x({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1077"}}),ns=new x({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1098",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),nr=new wt({props:{$$slots:{default:[Tw]},$$scope:{ctx:E}}}),ar=new yt({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[xw]},$$scope:{ctx:E}}}),as=new C({}),is=new x({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1200"}}),ds=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1231",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),cr=new wt({props:{$$slots:{default:[Ew]},$$scope:{ctx:E}}}),lr=new yt({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[Fw]},$$scope:{ctx:E}}}),ps=new C({}),ms=new x({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1339"}}),fs=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1368",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pr=new wt({props:{$$slots:{default:[Cw]},$$scope:{ctx:E}}}),mr=new yt({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[jw]},$$scope:{ctx:E}}}),gs=new C({}),vs=new x({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1475"}}),bs=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1505",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ur=new wt({props:{$$slots:{default:[Mw]},$$scope:{ctx:E}}}),fr=new yt({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[Iw]},$$scope:{ctx:E}}}),ws=new C({}),ys=new x({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1612"}}),Ts=new x({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1659",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),vr=new wt({props:{$$slots:{default:[qw]},$$scope:{ctx:E}}}),_r=new yt({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[zw]},$$scope:{ctx:E}}}),xs=new C({}),Es=new x({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.22.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1752"}}),Ms=new x({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.22.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.22.2/src/transformers/models/perceiver/modeling_perceiver.py#L1868",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),yr=new wt({props:{$$slots:{default:[Aw]},$$scope:{ctx:E}}}),$r=new yt({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[Dw]},$$scope:{ctx:E}}}),{c(){u=o("meta"),T=l(),v=o("h1"),g=o("a"),k=o("span"),_(p.$$.fragment),f=l(),F=o("span"),ep=a("Perceiver"),xc=l(),$e=o("h2"),Tt=o("a"),Xn=o("span"),_(Ar.$$.fragment),tp=l(),Zn=o("span"),rp=a("Overview"),Ec=l(),xt=o("p"),op=a("The Perceiver IO model was proposed in "),Dr=o("a"),sp=a(`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),np=a(` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),Fc=l(),Et=o("p"),ap=a("Perceiver IO is a generalization of "),Or=o("a"),ip=a("Perceiver"),cp=a(` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Cc=l(),Ns=o("p"),lp=a("The abstract from the paper is the following:"),jc=l(),Ls=o("p"),Qn=o("em"),dp=a(`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),Mc=l(),Ss=o("p"),pp=a("Here\u2019s a TLDR explaining how Perceiver works:"),Ic=l(),Bs=o("p"),mp=a(`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),qc=l(),D=o("p"),hp=a("Internally, "),Hs=o("a"),up=a("PerceiverModel"),fp=a(" will create the latents, which is a tensor of shape "),Yn=o("code"),gp=a("(batch_size, num_latents, d_latents)"),vp=a(". One must provide "),ea=o("code"),_p=a("inputs"),Pp=a(` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),ta=o("code"),bp=a("d_latents"),wp=a(" to "),ra=o("code"),yp=a("num_labels"),$p=a("."),zc=l(),Ws=o("p"),kp=a(`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),Ac=l(),M=o("p"),Tp=a(`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),oa=o("code"),xp=a("inputs"),Ep=a(` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),sa=o("code"),Fp=a("outputs"),Cp=a(" as being of shape: "),na=o("code"),jp=a("(batch_size, 2048, 768)"),Mp=a(`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),aa=o("code"),Ip=a("outputs"),qp=a(" tensor. After cross-attention, one still has a tensor of shape "),ia=o("code"),zp=a("(batch_size, 2048, 768)"),Ap=a(`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),ca=o("code"),Dp=a("(batch_size, 2048, 262)"),Op=a(` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),Dc=l(),Ft=o("img"),Oc=l(),Nr=o("small"),Np=a("Perceiver IO architecture. Taken from the "),Vs=o("a"),Lp=a("original paper"),Nc=l(),ve=o("p"),Sp=a("This model was contributed by "),Lr=o("a"),Bp=a("nielsr"),Hp=a(`. The original code can be found
`),Sr=o("a"),Wp=a("here"),Vp=a("."),Lc=l(),Us=o("p"),Up=a("Tips:"),Sc=l(),Ct=o("ul"),Br=o("li"),Rp=a("The quickest way to get started with the Perceiver is by checking the "),Hr=o("a"),Kp=a(`tutorial
notebooks`),Jp=a("."),Gp=l(),Wr=o("li"),Xp=a("Refer to the "),Vr=o("a"),Zp=a("blog post"),Qp=a(` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),Bc=l(),Ur=o("p"),la=o("strong"),Yp=a("Note"),em=a(":"),Hc=l(),Rs=o("ul"),_e=o("li"),tm=a("Perceiver does "),da=o("strong"),rm=a("not"),om=a(" work with "),pa=o("code"),sm=a("torch.nn.DataParallel"),nm=a(" due to a bug in PyTorch, see "),Rr=o("a"),am=a("issue #36035"),Wc=l(),ke=o("h2"),jt=o("a"),ma=o("span"),_(Kr.$$.fragment),im=l(),ha=o("span"),cm=a("Perceiver specific outputs"),Vc=l(),Te=o("div"),_(Jr.$$.fragment),lm=l(),ua=o("p"),dm=a("Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),Uc=l(),xe=o("div"),_(Gr.$$.fragment),pm=l(),fa=o("p"),mm=a("Base class for Perceiver decoder outputs, with potential cross-attentions."),Rc=l(),Ee=o("div"),_(Xr.$$.fragment),hm=l(),ga=o("p"),um=a("Base class for Perceiver\u2019s masked language model outputs."),Kc=l(),Fe=o("div"),_(Zr.$$.fragment),fm=l(),va=o("p"),gm=a(`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),Jc=l(),Ce=o("h2"),Mt=o("a"),_a=o("span"),_(Qr.$$.fragment),vm=l(),Pa=o("span"),_m=a("PerceiverConfig"),Gc=l(),V=o("div"),_(Yr.$$.fragment),Pm=l(),je=o("p"),bm=a("This is the configuration class to store the configuration of a "),Ks=o("a"),wm=a("PerceiverModel"),ym=a(`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),eo=o("a"),$m=a("deepmind/language-perceiver"),km=a(" architecture."),Tm=l(),Me=o("p"),xm=a("Configuration objects inherit from "),Js=o("a"),Em=a("PretrainedConfig"),Fm=a(` and can be used to control the model outputs. Read the
documentation from `),Gs=o("a"),Cm=a("PretrainedConfig"),jm=a(" for more information."),Mm=l(),_(It.$$.fragment),Xc=l(),Ie=o("h2"),qt=o("a"),ba=o("span"),_(to.$$.fragment),Im=l(),wa=o("span"),qm=a("PerceiverTokenizer"),Zc=l(),U=o("div"),_(ro.$$.fragment),zm=l(),ya=o("p"),Am=a("Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),Dm=l(),oo=o("p"),Om=a("This tokenizer inherits from "),Xs=o("a"),Nm=a("PreTrainedTokenizer"),Lm=a(` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),Sm=l(),zt=o("div"),_(so.$$.fragment),Bm=l(),$a=o("p"),Hm=a(`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),Qc=l(),qe=o("h2"),At=o("a"),ka=o("span"),_(no.$$.fragment),Wm=l(),Ta=o("span"),Vm=a("PerceiverFeatureExtractor"),Yc=l(),R=o("div"),_(ao.$$.fragment),Um=l(),xa=o("p"),Rm=a("Constructs a Perceiver feature extractor."),Km=l(),io=o("p"),Jm=a("This feature extractor inherits from "),Zs=o("a"),Gm=a("ImageFeatureExtractionMixin"),Xm=a(` which contains most of the main methods. Users
should refer to this superclass for more information regarding those methods.`),Zm=l(),Pe=o("div"),_(co.$$.fragment),Qm=l(),Ea=o("p"),Ym=a("Main method to prepare for the model one or several image(s)."),eh=l(),_(Dt.$$.fragment),el=l(),ze=o("h2"),Ot=o("a"),Fa=o("span"),_(lo.$$.fragment),th=l(),Ca=o("span"),rh=a("PerceiverTextPreprocessor"),tl=l(),ae=o("div"),_(po.$$.fragment),oh=l(),mo=o("p"),sh=a("Text preprocessing for Perceiver Encoder. Can be used to embed "),ja=o("code"),nh=a("inputs"),ah=a(" and add positional encodings."),ih=l(),ho=o("p"),ch=a("The dimensionality of the embeddings is determined by the "),Ma=o("code"),lh=a("d_model"),dh=a(" attribute of the configuration."),rl=l(),Ae=o("h2"),Nt=o("a"),Ia=o("span"),_(uo.$$.fragment),ph=l(),qa=o("span"),mh=a("PerceiverImagePreprocessor"),ol=l(),ie=o("div"),_(fo.$$.fragment),hh=l(),za=o("p"),uh=a("Image preprocessing for Perceiver Encoder."),fh=l(),K=o("p"),gh=a("Note: the "),Aa=o("em"),vh=a("out_channels"),_h=a(" argument refers to the output channels of a convolutional layer, if "),Da=o("em"),Ph=a("prep_type"),bh=a(` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Oa=o("em"),wh=a("num_channels"),yh=a(` of the
position encoding kwargs are set equal to the `),Na=o("em"),$h=a("out_channels"),kh=a("."),sl=l(),De=o("h2"),Lt=o("a"),La=o("span"),_(go.$$.fragment),Th=l(),Sa=o("span"),xh=a("PerceiverOneHotPreprocessor"),nl=l(),Oe=o("div"),_(vo.$$.fragment),Eh=l(),Ba=o("p"),Fh=a("One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),al=l(),Ne=o("h2"),St=o("a"),Ha=o("span"),_(_o.$$.fragment),Ch=l(),Wa=o("span"),jh=a("PerceiverAudioPreprocessor"),il=l(),Le=o("div"),_(Po.$$.fragment),Mh=l(),Va=o("p"),Ih=a("Audio preprocessing for Perceiver Encoder."),cl=l(),Se=o("h2"),Bt=o("a"),Ua=o("span"),_(bo.$$.fragment),qh=l(),Ra=o("span"),zh=a("PerceiverMultimodalPreprocessor"),ll=l(),ce=o("div"),_(wo.$$.fragment),Ah=l(),Ka=o("p"),Dh=a("Multimodal preprocessing for Perceiver Encoder."),Oh=l(),Ja=o("p"),Nh=a(`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),dl=l(),Be=o("h2"),Ht=o("a"),Ga=o("span"),_(yo.$$.fragment),Lh=l(),Xa=o("span"),Sh=a("PerceiverProjectionDecoder"),pl=l(),He=o("div"),_($o.$$.fragment),Bh=l(),Za=o("p"),Hh=a("Baseline projection decoder (no cross-attention)."),ml=l(),We=o("h2"),Wt=o("a"),Qa=o("span"),_(ko.$$.fragment),Wh=l(),Ya=o("span"),Vh=a("PerceiverBasicDecoder"),hl=l(),le=o("div"),_(To.$$.fragment),Uh=l(),ei=o("p"),Rh=a(`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),Kh=l(),ti=o("p"),Jh=a("The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),ul=l(),Ve=o("h2"),Vt=o("a"),ri=o("span"),_(xo.$$.fragment),Gh=l(),oi=o("span"),Xh=a("PerceiverClassificationDecoder"),fl=l(),Ue=o("div"),_(Eo.$$.fragment),Zh=l(),Fo=o("p"),Qh=a("Cross-attention based classification decoder. Light-weight wrapper of "),si=o("code"),Yh=a("PerceiverBasicDecoder"),eu=a(` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),gl=l(),Re=o("h2"),Ut=o("a"),ni=o("span"),_(Co.$$.fragment),tu=l(),ai=o("span"),ru=a("PerceiverOpticalFlowDecoder"),vl=l(),Ke=o("div"),_(jo.$$.fragment),ou=l(),ii=o("p"),su=a("Cross-attention based optical flow decoder."),_l=l(),Je=o("h2"),Rt=o("a"),ci=o("span"),_(Mo.$$.fragment),nu=l(),li=o("span"),au=a("PerceiverBasicVideoAutoencodingDecoder"),Pl=l(),Ge=o("div"),_(Io.$$.fragment),iu=l(),qo=o("p"),cu=a("Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),di=o("em"),lu=a("PerceiverBasicDecoder"),du=a(`] with video
reshaping logic.`),bl=l(),Xe=o("h2"),Kt=o("a"),pi=o("span"),_(zo.$$.fragment),pu=l(),mi=o("span"),mu=a("PerceiverMultimodalDecoder"),wl=l(),de=o("div"),_(Ao.$$.fragment),hu=l(),Do=o("p"),uu=a("Multimodal decoding by composing uni-modal decoders. The "),hi=o("em"),fu=a("modalities"),gu=a(` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),vu=l(),ui=o("p"),_u=a("Next, there is a shared cross attention operation across all modalities."),yl=l(),Ze=o("h2"),Jt=o("a"),fi=o("span"),_(Oo.$$.fragment),Pu=l(),gi=o("span"),bu=a("PerceiverProjectionPostprocessor"),$l=l(),Qe=o("div"),_(No.$$.fragment),wu=l(),vi=o("p"),yu=a(`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),kl=l(),Ye=o("h2"),Gt=o("a"),_i=o("span"),_(Lo.$$.fragment),$u=l(),Pi=o("span"),ku=a("PerceiverAudioPostprocessor"),Tl=l(),et=o("div"),_(So.$$.fragment),Tu=l(),bi=o("p"),xu=a("Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),xl=l(),tt=o("h2"),Xt=o("a"),wi=o("span"),_(Bo.$$.fragment),Eu=l(),yi=o("span"),Fu=a("PerceiverClassificationPostprocessor"),El=l(),rt=o("div"),_(Ho.$$.fragment),Cu=l(),$i=o("p"),ju=a("Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),Fl=l(),ot=o("h2"),Zt=o("a"),ki=o("span"),_(Wo.$$.fragment),Mu=l(),Ti=o("span"),Iu=a("PerceiverMultimodalPostprocessor"),Cl=l(),st=o("div"),_(Vo.$$.fragment),qu=l(),xi=o("p"),zu=a(`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),jl=l(),nt=o("h2"),Qt=o("a"),Ei=o("span"),_(Uo.$$.fragment),Au=l(),Fi=o("span"),Du=a("PerceiverModel"),Ml=l(),pe=o("div"),_(Ro.$$.fragment),Ou=l(),Ko=o("p"),Nu=a(`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Jo=o("a"),Lu=a("torch.nn.Module"),Su=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Bu=l(),J=o("div"),_(Go.$$.fragment),Hu=l(),at=o("p"),Wu=a("The "),Qs=o("a"),Vu=a("PerceiverModel"),Uu=a(" forward method, overrides the "),Ci=o("code"),Ru=a("__call__"),Ku=a(" special method."),Ju=l(),_(Yt.$$.fragment),Gu=l(),_(er.$$.fragment),Il=l(),it=o("h2"),tr=o("a"),ji=o("span"),_(Xo.$$.fragment),Xu=l(),Mi=o("span"),Zu=a("PerceiverForMaskedLM"),ql=l(),me=o("div"),_(Zo.$$.fragment),Qu=l(),Qo=o("p"),Yu=a(`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),Yo=o("a"),ef=a("torch.nn.Module"),tf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),rf=l(),G=o("div"),_(es.$$.fragment),of=l(),ct=o("p"),sf=a("The "),Ys=o("a"),nf=a("PerceiverForMaskedLM"),af=a(" forward method, overrides the "),Ii=o("code"),cf=a("__call__"),lf=a(" special method."),df=l(),_(rr.$$.fragment),pf=l(),_(or.$$.fragment),zl=l(),lt=o("h2"),sr=o("a"),qi=o("span"),_(ts.$$.fragment),mf=l(),zi=o("span"),hf=a("PerceiverForSequenceClassification"),Al=l(),he=o("div"),_(rs.$$.fragment),uf=l(),os=o("p"),ff=a(`Example use of Perceiver for text classification.
This model is a PyTorch `),ss=o("a"),gf=a("torch.nn.Module"),vf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),_f=l(),X=o("div"),_(ns.$$.fragment),Pf=l(),dt=o("p"),bf=a("The "),en=o("a"),wf=a("PerceiverForSequenceClassification"),yf=a(" forward method, overrides the "),Ai=o("code"),$f=a("__call__"),kf=a(" special method."),Tf=l(),_(nr.$$.fragment),xf=l(),_(ar.$$.fragment),Dl=l(),pt=o("h2"),ir=o("a"),Di=o("span"),_(as.$$.fragment),Ef=l(),Oi=o("span"),Ff=a("PerceiverForImageClassificationLearned"),Ol=l(),q=o("div"),_(is.$$.fragment),Cf=l(),Ni=o("p"),jf=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Mf=l(),Li=o("p"),If=a(`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),qf=l(),S=o("p"),tn=o("a"),zf=a("PerceiverForImageClassificationLearned"),Af=a(" uses "),rn=o("a"),Df=a("PerceiverImagePreprocessor"),Of=a(`
(with `),Si=o("code"),Nf=a('prep_type="conv1x1"'),Lf=a(`) to preprocess the input images, and
`),on=o("a"),Sf=a("PerceiverClassificationDecoder"),Bf=a(` to decode the latent representation of
`),sn=o("a"),Hf=a("PerceiverModel"),Wf=a(" into classification logits."),Vf=l(),cs=o("p"),Uf=a("This model is a PyTorch "),ls=o("a"),Rf=a("torch.nn.Module"),Kf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Jf=l(),Z=o("div"),_(ds.$$.fragment),Gf=l(),mt=o("p"),Xf=a("The "),nn=o("a"),Zf=a("PerceiverForImageClassificationLearned"),Qf=a(" forward method, overrides the "),Bi=o("code"),Yf=a("__call__"),eg=a(" special method."),tg=l(),_(cr.$$.fragment),rg=l(),_(lr.$$.fragment),Nl=l(),ht=o("h2"),dr=o("a"),Hi=o("span"),_(ps.$$.fragment),og=l(),Wi=o("span"),sg=a("PerceiverForImageClassificationFourier"),Ll=l(),z=o("div"),_(ms.$$.fragment),ng=l(),Vi=o("p"),ag=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),ig=l(),Ui=o("p"),cg=a(`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),lg=l(),B=o("p"),an=o("a"),dg=a("PerceiverForImageClassificationLearned"),pg=a(" uses "),cn=o("a"),mg=a("PerceiverImagePreprocessor"),hg=a(`
(with `),Ri=o("code"),ug=a('prep_type="pixels"'),fg=a(`) to preprocess the input images, and
`),ln=o("a"),gg=a("PerceiverClassificationDecoder"),vg=a(` to decode the latent representation of
`),dn=o("a"),_g=a("PerceiverModel"),Pg=a(" into classification logits."),bg=l(),hs=o("p"),wg=a("This model is a PyTorch "),us=o("a"),yg=a("torch.nn.Module"),$g=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),kg=l(),Q=o("div"),_(fs.$$.fragment),Tg=l(),ut=o("p"),xg=a("The "),pn=o("a"),Eg=a("PerceiverForImageClassificationFourier"),Fg=a(" forward method, overrides the "),Ki=o("code"),Cg=a("__call__"),jg=a(" special method."),Mg=l(),_(pr.$$.fragment),Ig=l(),_(mr.$$.fragment),Sl=l(),ft=o("h2"),hr=o("a"),Ji=o("span"),_(gs.$$.fragment),qg=l(),Gi=o("span"),zg=a("PerceiverForImageClassificationConvProcessing"),Bl=l(),A=o("div"),_(vs.$$.fragment),Ag=l(),Xi=o("p"),Dg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Og=l(),Zi=o("p"),Ng=a(`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),Lg=l(),H=o("p"),mn=o("a"),Sg=a("PerceiverForImageClassificationLearned"),Bg=a(" uses "),hn=o("a"),Hg=a("PerceiverImagePreprocessor"),Wg=a(`
(with `),Qi=o("code"),Vg=a('prep_type="conv"'),Ug=a(`) to preprocess the input images, and
`),un=o("a"),Rg=a("PerceiverClassificationDecoder"),Kg=a(` to decode the latent representation of
`),fn=o("a"),Jg=a("PerceiverModel"),Gg=a(" into classification logits."),Xg=l(),_s=o("p"),Zg=a("This model is a PyTorch "),Ps=o("a"),Qg=a("torch.nn.Module"),Yg=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),ev=l(),Y=o("div"),_(bs.$$.fragment),tv=l(),gt=o("p"),rv=a("The "),gn=o("a"),ov=a("PerceiverForImageClassificationConvProcessing"),sv=a(" forward method, overrides the "),Yi=o("code"),nv=a("__call__"),av=a(" special method."),iv=l(),_(ur.$$.fragment),cv=l(),_(fr.$$.fragment),Hl=l(),vt=o("h2"),gr=o("a"),ec=o("span"),_(ws.$$.fragment),lv=l(),tc=o("span"),dv=a("PerceiverForOpticalFlow"),Wl=l(),O=o("div"),_(ys.$$.fragment),pv=l(),N=o("p"),mv=a("Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),vn=o("a"),hv=a("PerceiverForOpticalFlow"),uv=a(` uses
`),_n=o("a"),fv=a("PerceiverImagePreprocessor"),gv=a(" (with "),rc=o("em"),vv=a("prep_type=\u201Cpatches\u201D"),_v=a(`) to preprocess the
input images, and `),Pn=o("a"),Pv=a("PerceiverOpticalFlowDecoder"),bv=a(` to decode the latent
representation of `),bn=o("a"),wv=a("PerceiverModel"),yv=a("."),$v=l(),oc=o("p"),kv=a(`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),Tv=l(),$s=o("p"),xv=a("This model is a PyTorch "),ks=o("a"),Ev=a("torch.nn.Module"),Fv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Cv=l(),ee=o("div"),_(Ts.$$.fragment),jv=l(),_t=o("p"),Mv=a("The "),wn=o("a"),Iv=a("PerceiverForOpticalFlow"),qv=a(" forward method, overrides the "),sc=o("code"),zv=a("__call__"),Av=a(" special method."),Dv=l(),_(vr.$$.fragment),Ov=l(),_(_r.$$.fragment),Vl=l(),Pt=o("h2"),Pr=o("a"),nc=o("span"),_(xs.$$.fragment),Nv=l(),ac=o("span"),Lv=a("PerceiverForMultimodalAutoencoding"),Ul=l(),j=o("div"),_(Es.$$.fragment),Sv=l(),ic=o("p"),Bv=a("Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),Hv=l(),br=o("p"),yn=o("a"),Wv=a("PerceiverForMultimodalAutoencoding"),Vv=a(" uses "),$n=o("a"),Uv=a("PerceiverMultimodalPreprocessor"),Rv=a(` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),Kv=l(),be=o("p"),kn=o("a"),Jv=a("PerceiverMultimodalDecoder"),Gv=a(` is used to decode the latent representation of
`),Tn=o("a"),Xv=a("PerceiverModel"),Zv=a(`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),xn=o("a"),Qv=a("PerceiverForMultimodalAutoencoding"),Yv=a("."),e_=l(),wr=o("p"),En=o("a"),t_=a("PerceiverMultimodalDecoder"),r_=a(` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),Fn=o("a"),o_=a("PerceiverModel"),s_=a("."),n_=l(),Fs=o("p"),a_=a("Finally, "),cc=o("code"),i_=a("PerceiverMultiModalPostprocessor"),c_=a(` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),l_=l(),lc=o("p"),d_=a(`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),p_=l(),Cs=o("p"),m_=a("This model is a PyTorch "),js=o("a"),h_=a("torch.nn.Module"),u_=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),f_=l(),te=o("div"),_(Ms.$$.fragment),g_=l(),bt=o("p"),v_=a("The "),Cn=o("a"),__=a("PerceiverForMultimodalAutoencoding"),P_=a(" forward method, overrides the "),dc=o("code"),b_=a("__call__"),w_=a(" special method."),y_=l(),_(yr.$$.fragment),$_=l(),_($r.$$.fragment),this.h()},l(t){const m=gw('[data-svelte="svelte-1phssyn"]',document.head);u=s(m,"META",{name:!0,content:!0}),m.forEach(r),T=d(t),v=s(t,"H1",{class:!0});var Is=n(v);g=s(Is,"A",{id:!0,class:!0,href:!0});var pc=n(g);k=s(pc,"SPAN",{});var mc=n(k);P(p.$$.fragment,mc),mc.forEach(r),pc.forEach(r),f=d(Is),F=s(Is,"SPAN",{});var hc=n(F);ep=i(hc,"Perceiver"),hc.forEach(r),Is.forEach(r),xc=d(t),$e=s(t,"H2",{class:!0});var qs=n($e);Tt=s(qs,"A",{id:!0,class:!0,href:!0});var uc=n(Tt);Xn=s(uc,"SPAN",{});var fc=n(Xn);P(Ar.$$.fragment,fc),fc.forEach(r),uc.forEach(r),tp=d(qs),Zn=s(qs,"SPAN",{});var gc=n(Zn);rp=i(gc,"Overview"),gc.forEach(r),qs.forEach(r),Ec=d(t),xt=s(t,"P",{});var zs=n(xt);op=i(zs,"The Perceiver IO model was proposed in "),Dr=s(zs,"A",{href:!0,rel:!0});var vc=n(Dr);sp=i(vc,`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),vc.forEach(r),np=i(zs,` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),zs.forEach(r),Fc=d(t),Et=s(t,"P",{});var As=n(Et);ap=i(As,"Perceiver IO is a generalization of "),Or=s(As,"A",{href:!0,rel:!0});var _c=n(Or);ip=i(_c,"Perceiver"),_c.forEach(r),cp=i(As,` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),As.forEach(r),Cc=d(t),Ns=s(t,"P",{});var Pc=n(Ns);lp=i(Pc,"The abstract from the paper is the following:"),Pc.forEach(r),jc=d(t),Ls=s(t,"P",{});var bc=n(Ls);Qn=s(bc,"EM",{});var wc=n(Qn);dp=i(wc,`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),wc.forEach(r),bc.forEach(r),Mc=d(t),Ss=s(t,"P",{});var yc=n(Ss);pp=i(yc,"Here\u2019s a TLDR explaining how Perceiver works:"),yc.forEach(r),Ic=d(t),Bs=s(t,"P",{});var $c=n(Bs);mp=i($c,`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),$c.forEach(r),qc=d(t),D=s(t,"P",{});var L=n(D);hp=i(L,"Internally, "),Hs=s(L,"A",{href:!0});var E_=n(Hs);up=i(E_,"PerceiverModel"),E_.forEach(r),fp=i(L," will create the latents, which is a tensor of shape "),Yn=s(L,"CODE",{});var F_=n(Yn);gp=i(F_,"(batch_size, num_latents, d_latents)"),F_.forEach(r),vp=i(L,". One must provide "),ea=s(L,"CODE",{});var C_=n(ea);_p=i(C_,"inputs"),C_.forEach(r),Pp=i(L,` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),ta=s(L,"CODE",{});var j_=n(ta);bp=i(j_,"d_latents"),j_.forEach(r),wp=i(L," to "),ra=s(L,"CODE",{});var M_=n(ra);yp=i(M_,"num_labels"),M_.forEach(r),$p=i(L,"."),L.forEach(r),zc=d(t),Ws=s(t,"P",{});var I_=n(Ws);kp=i(I_,`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),I_.forEach(r),Ac=d(t),M=s(t,"P",{});var W=n(M);Tp=i(W,`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),oa=s(W,"CODE",{});var q_=n(oa);xp=i(q_,"inputs"),q_.forEach(r),Ep=i(W,` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),sa=s(W,"CODE",{});var z_=n(sa);Fp=i(z_,"outputs"),z_.forEach(r),Cp=i(W," as being of shape: "),na=s(W,"CODE",{});var A_=n(na);jp=i(A_,"(batch_size, 2048, 768)"),A_.forEach(r),Mp=i(W,`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),aa=s(W,"CODE",{});var D_=n(aa);Ip=i(D_,"outputs"),D_.forEach(r),qp=i(W," tensor. After cross-attention, one still has a tensor of shape "),ia=s(W,"CODE",{});var O_=n(ia);zp=i(O_,"(batch_size, 2048, 768)"),O_.forEach(r),Ap=i(W,`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),ca=s(W,"CODE",{});var N_=n(ca);Dp=i(N_,"(batch_size, 2048, 262)"),N_.forEach(r),Op=i(W,` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),W.forEach(r),Dc=d(t),Ft=s(t,"IMG",{src:!0,alt:!0,width:!0}),Oc=d(t),Nr=s(t,"SMALL",{});var k_=n(Nr);Np=i(k_,"Perceiver IO architecture. Taken from the "),Vs=s(k_,"A",{href:!0});var L_=n(Vs);Lp=i(L_,"original paper"),L_.forEach(r),k_.forEach(r),Nc=d(t),ve=s(t,"P",{});var jn=n(ve);Sp=i(jn,"This model was contributed by "),Lr=s(jn,"A",{href:!0,rel:!0});var S_=n(Lr);Bp=i(S_,"nielsr"),S_.forEach(r),Hp=i(jn,`. The original code can be found
`),Sr=s(jn,"A",{href:!0,rel:!0});var B_=n(Sr);Wp=i(B_,"here"),B_.forEach(r),Vp=i(jn,"."),jn.forEach(r),Lc=d(t),Us=s(t,"P",{});var H_=n(Us);Up=i(H_,"Tips:"),H_.forEach(r),Sc=d(t),Ct=s(t,"UL",{});var Kl=n(Ct);Br=s(Kl,"LI",{});var Jl=n(Br);Rp=i(Jl,"The quickest way to get started with the Perceiver is by checking the "),Hr=s(Jl,"A",{href:!0,rel:!0});var W_=n(Hr);Kp=i(W_,`tutorial
notebooks`),W_.forEach(r),Jp=i(Jl,"."),Jl.forEach(r),Gp=d(Kl),Wr=s(Kl,"LI",{});var Gl=n(Wr);Xp=i(Gl,"Refer to the "),Vr=s(Gl,"A",{href:!0,rel:!0});var V_=n(Vr);Zp=i(V_,"blog post"),V_.forEach(r),Qp=i(Gl,` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),Gl.forEach(r),Kl.forEach(r),Bc=d(t),Ur=s(t,"P",{});var T_=n(Ur);la=s(T_,"STRONG",{});var U_=n(la);Yp=i(U_,"Note"),U_.forEach(r),em=i(T_,":"),T_.forEach(r),Hc=d(t),Rs=s(t,"UL",{});var R_=n(Rs);_e=s(R_,"LI",{});var Ds=n(_e);tm=i(Ds,"Perceiver does "),da=s(Ds,"STRONG",{});var K_=n(da);rm=i(K_,"not"),K_.forEach(r),om=i(Ds," work with "),pa=s(Ds,"CODE",{});var J_=n(pa);sm=i(J_,"torch.nn.DataParallel"),J_.forEach(r),nm=i(Ds," due to a bug in PyTorch, see "),Rr=s(Ds,"A",{href:!0,rel:!0});var G_=n(Rr);am=i(G_,"issue #36035"),G_.forEach(r),Ds.forEach(r),R_.forEach(r),Wc=d(t),ke=s(t,"H2",{class:!0});var Xl=n(ke);jt=s(Xl,"A",{id:!0,class:!0,href:!0});var X_=n(jt);ma=s(X_,"SPAN",{});var Z_=n(ma);P(Kr.$$.fragment,Z_),Z_.forEach(r),X_.forEach(r),im=d(Xl),ha=s(Xl,"SPAN",{});var Q_=n(ha);cm=i(Q_,"Perceiver specific outputs"),Q_.forEach(r),Xl.forEach(r),Vc=d(t),Te=s(t,"DIV",{class:!0});var Zl=n(Te);P(Jr.$$.fragment,Zl),lm=d(Zl),ua=s(Zl,"P",{});var Y_=n(ua);dm=i(Y_,"Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),Y_.forEach(r),Zl.forEach(r),Uc=d(t),xe=s(t,"DIV",{class:!0});var Ql=n(xe);P(Gr.$$.fragment,Ql),pm=d(Ql),fa=s(Ql,"P",{});var e2=n(fa);mm=i(e2,"Base class for Perceiver decoder outputs, with potential cross-attentions."),e2.forEach(r),Ql.forEach(r),Rc=d(t),Ee=s(t,"DIV",{class:!0});var Yl=n(Ee);P(Xr.$$.fragment,Yl),hm=d(Yl),ga=s(Yl,"P",{});var t2=n(ga);um=i(t2,"Base class for Perceiver\u2019s masked language model outputs."),t2.forEach(r),Yl.forEach(r),Kc=d(t),Fe=s(t,"DIV",{class:!0});var ed=n(Fe);P(Zr.$$.fragment,ed),fm=d(ed),va=s(ed,"P",{});var r2=n(va);gm=i(r2,`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),r2.forEach(r),ed.forEach(r),Jc=d(t),Ce=s(t,"H2",{class:!0});var td=n(Ce);Mt=s(td,"A",{id:!0,class:!0,href:!0});var o2=n(Mt);_a=s(o2,"SPAN",{});var s2=n(_a);P(Qr.$$.fragment,s2),s2.forEach(r),o2.forEach(r),vm=d(td),Pa=s(td,"SPAN",{});var n2=n(Pa);_m=i(n2,"PerceiverConfig"),n2.forEach(r),td.forEach(r),Gc=d(t),V=s(t,"DIV",{class:!0});var kr=n(V);P(Yr.$$.fragment,kr),Pm=d(kr),je=s(kr,"P",{});var Mn=n(je);bm=i(Mn,"This is the configuration class to store the configuration of a "),Ks=s(Mn,"A",{href:!0});var a2=n(Ks);wm=i(a2,"PerceiverModel"),a2.forEach(r),ym=i(Mn,`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),eo=s(Mn,"A",{href:!0,rel:!0});var i2=n(eo);$m=i(i2,"deepmind/language-perceiver"),i2.forEach(r),km=i(Mn," architecture."),Mn.forEach(r),Tm=d(kr),Me=s(kr,"P",{});var In=n(Me);xm=i(In,"Configuration objects inherit from "),Js=s(In,"A",{href:!0});var c2=n(Js);Em=i(c2,"PretrainedConfig"),c2.forEach(r),Fm=i(In,` and can be used to control the model outputs. Read the
documentation from `),Gs=s(In,"A",{href:!0});var l2=n(Gs);Cm=i(l2,"PretrainedConfig"),l2.forEach(r),jm=i(In," for more information."),In.forEach(r),Mm=d(kr),P(It.$$.fragment,kr),kr.forEach(r),Xc=d(t),Ie=s(t,"H2",{class:!0});var rd=n(Ie);qt=s(rd,"A",{id:!0,class:!0,href:!0});var d2=n(qt);ba=s(d2,"SPAN",{});var p2=n(ba);P(to.$$.fragment,p2),p2.forEach(r),d2.forEach(r),Im=d(rd),wa=s(rd,"SPAN",{});var m2=n(wa);qm=i(m2,"PerceiverTokenizer"),m2.forEach(r),rd.forEach(r),Zc=d(t),U=s(t,"DIV",{class:!0});var Tr=n(U);P(ro.$$.fragment,Tr),zm=d(Tr),ya=s(Tr,"P",{});var h2=n(ya);Am=i(h2,"Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),h2.forEach(r),Dm=d(Tr),oo=s(Tr,"P",{});var od=n(oo);Om=i(od,"This tokenizer inherits from "),Xs=s(od,"A",{href:!0});var u2=n(Xs);Nm=i(u2,"PreTrainedTokenizer"),u2.forEach(r),Lm=i(od,` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),od.forEach(r),Sm=d(Tr),zt=s(Tr,"DIV",{class:!0});var sd=n(zt);P(so.$$.fragment,sd),Bm=d(sd),$a=s(sd,"P",{});var f2=n($a);Hm=i(f2,`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),f2.forEach(r),sd.forEach(r),Tr.forEach(r),Qc=d(t),qe=s(t,"H2",{class:!0});var nd=n(qe);At=s(nd,"A",{id:!0,class:!0,href:!0});var g2=n(At);ka=s(g2,"SPAN",{});var v2=n(ka);P(no.$$.fragment,v2),v2.forEach(r),g2.forEach(r),Wm=d(nd),Ta=s(nd,"SPAN",{});var _2=n(Ta);Vm=i(_2,"PerceiverFeatureExtractor"),_2.forEach(r),nd.forEach(r),Yc=d(t),R=s(t,"DIV",{class:!0});var xr=n(R);P(ao.$$.fragment,xr),Um=d(xr),xa=s(xr,"P",{});var P2=n(xa);Rm=i(P2,"Constructs a Perceiver feature extractor."),P2.forEach(r),Km=d(xr),io=s(xr,"P",{});var ad=n(io);Jm=i(ad,"This feature extractor inherits from "),Zs=s(ad,"A",{href:!0});var b2=n(Zs);Gm=i(b2,"ImageFeatureExtractionMixin"),b2.forEach(r),Xm=i(ad,` which contains most of the main methods. Users
should refer to this superclass for more information regarding those methods.`),ad.forEach(r),Zm=d(xr),Pe=s(xr,"DIV",{class:!0});var qn=n(Pe);P(co.$$.fragment,qn),Qm=d(qn),Ea=s(qn,"P",{});var w2=n(Ea);Ym=i(w2,"Main method to prepare for the model one or several image(s)."),w2.forEach(r),eh=d(qn),P(Dt.$$.fragment,qn),qn.forEach(r),xr.forEach(r),el=d(t),ze=s(t,"H2",{class:!0});var id=n(ze);Ot=s(id,"A",{id:!0,class:!0,href:!0});var y2=n(Ot);Fa=s(y2,"SPAN",{});var $2=n(Fa);P(lo.$$.fragment,$2),$2.forEach(r),y2.forEach(r),th=d(id),Ca=s(id,"SPAN",{});var k2=n(Ca);rh=i(k2,"PerceiverTextPreprocessor"),k2.forEach(r),id.forEach(r),tl=d(t),ae=s(t,"DIV",{class:!0});var zn=n(ae);P(po.$$.fragment,zn),oh=d(zn),mo=s(zn,"P",{});var cd=n(mo);sh=i(cd,"Text preprocessing for Perceiver Encoder. Can be used to embed "),ja=s(cd,"CODE",{});var T2=n(ja);nh=i(T2,"inputs"),T2.forEach(r),ah=i(cd," and add positional encodings."),cd.forEach(r),ih=d(zn),ho=s(zn,"P",{});var ld=n(ho);ch=i(ld,"The dimensionality of the embeddings is determined by the "),Ma=s(ld,"CODE",{});var x2=n(Ma);lh=i(x2,"d_model"),x2.forEach(r),dh=i(ld," attribute of the configuration."),ld.forEach(r),zn.forEach(r),rl=d(t),Ae=s(t,"H2",{class:!0});var dd=n(Ae);Nt=s(dd,"A",{id:!0,class:!0,href:!0});var E2=n(Nt);Ia=s(E2,"SPAN",{});var F2=n(Ia);P(uo.$$.fragment,F2),F2.forEach(r),E2.forEach(r),ph=d(dd),qa=s(dd,"SPAN",{});var C2=n(qa);mh=i(C2,"PerceiverImagePreprocessor"),C2.forEach(r),dd.forEach(r),ol=d(t),ie=s(t,"DIV",{class:!0});var An=n(ie);P(fo.$$.fragment,An),hh=d(An),za=s(An,"P",{});var j2=n(za);uh=i(j2,"Image preprocessing for Perceiver Encoder."),j2.forEach(r),fh=d(An),K=s(An,"P",{});var we=n(K);gh=i(we,"Note: the "),Aa=s(we,"EM",{});var M2=n(Aa);vh=i(M2,"out_channels"),M2.forEach(r),_h=i(we," argument refers to the output channels of a convolutional layer, if "),Da=s(we,"EM",{});var I2=n(Da);Ph=i(I2,"prep_type"),I2.forEach(r),bh=i(we,` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Oa=s(we,"EM",{});var q2=n(Oa);wh=i(q2,"num_channels"),q2.forEach(r),yh=i(we,` of the
position encoding kwargs are set equal to the `),Na=s(we,"EM",{});var z2=n(Na);$h=i(z2,"out_channels"),z2.forEach(r),kh=i(we,"."),we.forEach(r),An.forEach(r),sl=d(t),De=s(t,"H2",{class:!0});var pd=n(De);Lt=s(pd,"A",{id:!0,class:!0,href:!0});var A2=n(Lt);La=s(A2,"SPAN",{});var D2=n(La);P(go.$$.fragment,D2),D2.forEach(r),A2.forEach(r),Th=d(pd),Sa=s(pd,"SPAN",{});var O2=n(Sa);xh=i(O2,"PerceiverOneHotPreprocessor"),O2.forEach(r),pd.forEach(r),nl=d(t),Oe=s(t,"DIV",{class:!0});var md=n(Oe);P(vo.$$.fragment,md),Eh=d(md),Ba=s(md,"P",{});var N2=n(Ba);Fh=i(N2,"One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),N2.forEach(r),md.forEach(r),al=d(t),Ne=s(t,"H2",{class:!0});var hd=n(Ne);St=s(hd,"A",{id:!0,class:!0,href:!0});var L2=n(St);Ha=s(L2,"SPAN",{});var S2=n(Ha);P(_o.$$.fragment,S2),S2.forEach(r),L2.forEach(r),Ch=d(hd),Wa=s(hd,"SPAN",{});var B2=n(Wa);jh=i(B2,"PerceiverAudioPreprocessor"),B2.forEach(r),hd.forEach(r),il=d(t),Le=s(t,"DIV",{class:!0});var ud=n(Le);P(Po.$$.fragment,ud),Mh=d(ud),Va=s(ud,"P",{});var H2=n(Va);Ih=i(H2,"Audio preprocessing for Perceiver Encoder."),H2.forEach(r),ud.forEach(r),cl=d(t),Se=s(t,"H2",{class:!0});var fd=n(Se);Bt=s(fd,"A",{id:!0,class:!0,href:!0});var W2=n(Bt);Ua=s(W2,"SPAN",{});var V2=n(Ua);P(bo.$$.fragment,V2),V2.forEach(r),W2.forEach(r),qh=d(fd),Ra=s(fd,"SPAN",{});var U2=n(Ra);zh=i(U2,"PerceiverMultimodalPreprocessor"),U2.forEach(r),fd.forEach(r),ll=d(t),ce=s(t,"DIV",{class:!0});var Dn=n(ce);P(wo.$$.fragment,Dn),Ah=d(Dn),Ka=s(Dn,"P",{});var R2=n(Ka);Dh=i(R2,"Multimodal preprocessing for Perceiver Encoder."),R2.forEach(r),Oh=d(Dn),Ja=s(Dn,"P",{});var K2=n(Ja);Nh=i(K2,`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),K2.forEach(r),Dn.forEach(r),dl=d(t),Be=s(t,"H2",{class:!0});var gd=n(Be);Ht=s(gd,"A",{id:!0,class:!0,href:!0});var J2=n(Ht);Ga=s(J2,"SPAN",{});var G2=n(Ga);P(yo.$$.fragment,G2),G2.forEach(r),J2.forEach(r),Lh=d(gd),Xa=s(gd,"SPAN",{});var X2=n(Xa);Sh=i(X2,"PerceiverProjectionDecoder"),X2.forEach(r),gd.forEach(r),pl=d(t),He=s(t,"DIV",{class:!0});var vd=n(He);P($o.$$.fragment,vd),Bh=d(vd),Za=s(vd,"P",{});var Z2=n(Za);Hh=i(Z2,"Baseline projection decoder (no cross-attention)."),Z2.forEach(r),vd.forEach(r),ml=d(t),We=s(t,"H2",{class:!0});var _d=n(We);Wt=s(_d,"A",{id:!0,class:!0,href:!0});var Q2=n(Wt);Qa=s(Q2,"SPAN",{});var Y2=n(Qa);P(ko.$$.fragment,Y2),Y2.forEach(r),Q2.forEach(r),Wh=d(_d),Ya=s(_d,"SPAN",{});var eP=n(Ya);Vh=i(eP,"PerceiverBasicDecoder"),eP.forEach(r),_d.forEach(r),hl=d(t),le=s(t,"DIV",{class:!0});var On=n(le);P(To.$$.fragment,On),Uh=d(On),ei=s(On,"P",{});var tP=n(ei);Rh=i(tP,`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),tP.forEach(r),Kh=d(On),ti=s(On,"P",{});var rP=n(ti);Jh=i(rP,"The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),rP.forEach(r),On.forEach(r),ul=d(t),Ve=s(t,"H2",{class:!0});var Pd=n(Ve);Vt=s(Pd,"A",{id:!0,class:!0,href:!0});var oP=n(Vt);ri=s(oP,"SPAN",{});var sP=n(ri);P(xo.$$.fragment,sP),sP.forEach(r),oP.forEach(r),Gh=d(Pd),oi=s(Pd,"SPAN",{});var nP=n(oi);Xh=i(nP,"PerceiverClassificationDecoder"),nP.forEach(r),Pd.forEach(r),fl=d(t),Ue=s(t,"DIV",{class:!0});var bd=n(Ue);P(Eo.$$.fragment,bd),Zh=d(bd),Fo=s(bd,"P",{});var wd=n(Fo);Qh=i(wd,"Cross-attention based classification decoder. Light-weight wrapper of "),si=s(wd,"CODE",{});var aP=n(si);Yh=i(aP,"PerceiverBasicDecoder"),aP.forEach(r),eu=i(wd,` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),wd.forEach(r),bd.forEach(r),gl=d(t),Re=s(t,"H2",{class:!0});var yd=n(Re);Ut=s(yd,"A",{id:!0,class:!0,href:!0});var iP=n(Ut);ni=s(iP,"SPAN",{});var cP=n(ni);P(Co.$$.fragment,cP),cP.forEach(r),iP.forEach(r),tu=d(yd),ai=s(yd,"SPAN",{});var lP=n(ai);ru=i(lP,"PerceiverOpticalFlowDecoder"),lP.forEach(r),yd.forEach(r),vl=d(t),Ke=s(t,"DIV",{class:!0});var $d=n(Ke);P(jo.$$.fragment,$d),ou=d($d),ii=s($d,"P",{});var dP=n(ii);su=i(dP,"Cross-attention based optical flow decoder."),dP.forEach(r),$d.forEach(r),_l=d(t),Je=s(t,"H2",{class:!0});var kd=n(Je);Rt=s(kd,"A",{id:!0,class:!0,href:!0});var pP=n(Rt);ci=s(pP,"SPAN",{});var mP=n(ci);P(Mo.$$.fragment,mP),mP.forEach(r),pP.forEach(r),nu=d(kd),li=s(kd,"SPAN",{});var hP=n(li);au=i(hP,"PerceiverBasicVideoAutoencodingDecoder"),hP.forEach(r),kd.forEach(r),Pl=d(t),Ge=s(t,"DIV",{class:!0});var Td=n(Ge);P(Io.$$.fragment,Td),iu=d(Td),qo=s(Td,"P",{});var xd=n(qo);cu=i(xd,"Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),di=s(xd,"EM",{});var uP=n(di);lu=i(uP,"PerceiverBasicDecoder"),uP.forEach(r),du=i(xd,`] with video
reshaping logic.`),xd.forEach(r),Td.forEach(r),bl=d(t),Xe=s(t,"H2",{class:!0});var Ed=n(Xe);Kt=s(Ed,"A",{id:!0,class:!0,href:!0});var fP=n(Kt);pi=s(fP,"SPAN",{});var gP=n(pi);P(zo.$$.fragment,gP),gP.forEach(r),fP.forEach(r),pu=d(Ed),mi=s(Ed,"SPAN",{});var vP=n(mi);mu=i(vP,"PerceiverMultimodalDecoder"),vP.forEach(r),Ed.forEach(r),wl=d(t),de=s(t,"DIV",{class:!0});var Nn=n(de);P(Ao.$$.fragment,Nn),hu=d(Nn),Do=s(Nn,"P",{});var Fd=n(Do);uu=i(Fd,"Multimodal decoding by composing uni-modal decoders. The "),hi=s(Fd,"EM",{});var _P=n(hi);fu=i(_P,"modalities"),_P.forEach(r),gu=i(Fd,` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),Fd.forEach(r),vu=d(Nn),ui=s(Nn,"P",{});var PP=n(ui);_u=i(PP,"Next, there is a shared cross attention operation across all modalities."),PP.forEach(r),Nn.forEach(r),yl=d(t),Ze=s(t,"H2",{class:!0});var Cd=n(Ze);Jt=s(Cd,"A",{id:!0,class:!0,href:!0});var bP=n(Jt);fi=s(bP,"SPAN",{});var wP=n(fi);P(Oo.$$.fragment,wP),wP.forEach(r),bP.forEach(r),Pu=d(Cd),gi=s(Cd,"SPAN",{});var yP=n(gi);bu=i(yP,"PerceiverProjectionPostprocessor"),yP.forEach(r),Cd.forEach(r),$l=d(t),Qe=s(t,"DIV",{class:!0});var jd=n(Qe);P(No.$$.fragment,jd),wu=d(jd),vi=s(jd,"P",{});var $P=n(vi);yu=i($P,`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),$P.forEach(r),jd.forEach(r),kl=d(t),Ye=s(t,"H2",{class:!0});var Md=n(Ye);Gt=s(Md,"A",{id:!0,class:!0,href:!0});var kP=n(Gt);_i=s(kP,"SPAN",{});var TP=n(_i);P(Lo.$$.fragment,TP),TP.forEach(r),kP.forEach(r),$u=d(Md),Pi=s(Md,"SPAN",{});var xP=n(Pi);ku=i(xP,"PerceiverAudioPostprocessor"),xP.forEach(r),Md.forEach(r),Tl=d(t),et=s(t,"DIV",{class:!0});var Id=n(et);P(So.$$.fragment,Id),Tu=d(Id),bi=s(Id,"P",{});var EP=n(bi);xu=i(EP,"Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),EP.forEach(r),Id.forEach(r),xl=d(t),tt=s(t,"H2",{class:!0});var qd=n(tt);Xt=s(qd,"A",{id:!0,class:!0,href:!0});var FP=n(Xt);wi=s(FP,"SPAN",{});var CP=n(wi);P(Bo.$$.fragment,CP),CP.forEach(r),FP.forEach(r),Eu=d(qd),yi=s(qd,"SPAN",{});var jP=n(yi);Fu=i(jP,"PerceiverClassificationPostprocessor"),jP.forEach(r),qd.forEach(r),El=d(t),rt=s(t,"DIV",{class:!0});var zd=n(rt);P(Ho.$$.fragment,zd),Cu=d(zd),$i=s(zd,"P",{});var MP=n($i);ju=i(MP,"Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),MP.forEach(r),zd.forEach(r),Fl=d(t),ot=s(t,"H2",{class:!0});var Ad=n(ot);Zt=s(Ad,"A",{id:!0,class:!0,href:!0});var IP=n(Zt);ki=s(IP,"SPAN",{});var qP=n(ki);P(Wo.$$.fragment,qP),qP.forEach(r),IP.forEach(r),Mu=d(Ad),Ti=s(Ad,"SPAN",{});var zP=n(Ti);Iu=i(zP,"PerceiverMultimodalPostprocessor"),zP.forEach(r),Ad.forEach(r),Cl=d(t),st=s(t,"DIV",{class:!0});var Dd=n(st);P(Vo.$$.fragment,Dd),qu=d(Dd),xi=s(Dd,"P",{});var AP=n(xi);zu=i(AP,`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),AP.forEach(r),Dd.forEach(r),jl=d(t),nt=s(t,"H2",{class:!0});var Od=n(nt);Qt=s(Od,"A",{id:!0,class:!0,href:!0});var DP=n(Qt);Ei=s(DP,"SPAN",{});var OP=n(Ei);P(Uo.$$.fragment,OP),OP.forEach(r),DP.forEach(r),Au=d(Od),Fi=s(Od,"SPAN",{});var NP=n(Fi);Du=i(NP,"PerceiverModel"),NP.forEach(r),Od.forEach(r),Ml=d(t),pe=s(t,"DIV",{class:!0});var Ln=n(pe);P(Ro.$$.fragment,Ln),Ou=d(Ln),Ko=s(Ln,"P",{});var Nd=n(Ko);Nu=i(Nd,`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Jo=s(Nd,"A",{href:!0,rel:!0});var LP=n(Jo);Lu=i(LP,"torch.nn.Module"),LP.forEach(r),Su=i(Nd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Nd.forEach(r),Bu=d(Ln),J=s(Ln,"DIV",{class:!0});var Er=n(J);P(Go.$$.fragment,Er),Hu=d(Er),at=s(Er,"P",{});var Sn=n(at);Wu=i(Sn,"The "),Qs=s(Sn,"A",{href:!0});var SP=n(Qs);Vu=i(SP,"PerceiverModel"),SP.forEach(r),Uu=i(Sn," forward method, overrides the "),Ci=s(Sn,"CODE",{});var BP=n(Ci);Ru=i(BP,"__call__"),BP.forEach(r),Ku=i(Sn," special method."),Sn.forEach(r),Ju=d(Er),P(Yt.$$.fragment,Er),Gu=d(Er),P(er.$$.fragment,Er),Er.forEach(r),Ln.forEach(r),Il=d(t),it=s(t,"H2",{class:!0});var Ld=n(it);tr=s(Ld,"A",{id:!0,class:!0,href:!0});var HP=n(tr);ji=s(HP,"SPAN",{});var WP=n(ji);P(Xo.$$.fragment,WP),WP.forEach(r),HP.forEach(r),Xu=d(Ld),Mi=s(Ld,"SPAN",{});var VP=n(Mi);Zu=i(VP,"PerceiverForMaskedLM"),VP.forEach(r),Ld.forEach(r),ql=d(t),me=s(t,"DIV",{class:!0});var Bn=n(me);P(Zo.$$.fragment,Bn),Qu=d(Bn),Qo=s(Bn,"P",{});var Sd=n(Qo);Yu=i(Sd,`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),Yo=s(Sd,"A",{href:!0,rel:!0});var UP=n(Yo);ef=i(UP,"torch.nn.Module"),UP.forEach(r),tf=i(Sd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Sd.forEach(r),rf=d(Bn),G=s(Bn,"DIV",{class:!0});var Fr=n(G);P(es.$$.fragment,Fr),of=d(Fr),ct=s(Fr,"P",{});var Hn=n(ct);sf=i(Hn,"The "),Ys=s(Hn,"A",{href:!0});var RP=n(Ys);nf=i(RP,"PerceiverForMaskedLM"),RP.forEach(r),af=i(Hn," forward method, overrides the "),Ii=s(Hn,"CODE",{});var KP=n(Ii);cf=i(KP,"__call__"),KP.forEach(r),lf=i(Hn," special method."),Hn.forEach(r),df=d(Fr),P(rr.$$.fragment,Fr),pf=d(Fr),P(or.$$.fragment,Fr),Fr.forEach(r),Bn.forEach(r),zl=d(t),lt=s(t,"H2",{class:!0});var Bd=n(lt);sr=s(Bd,"A",{id:!0,class:!0,href:!0});var JP=n(sr);qi=s(JP,"SPAN",{});var GP=n(qi);P(ts.$$.fragment,GP),GP.forEach(r),JP.forEach(r),mf=d(Bd),zi=s(Bd,"SPAN",{});var XP=n(zi);hf=i(XP,"PerceiverForSequenceClassification"),XP.forEach(r),Bd.forEach(r),Al=d(t),he=s(t,"DIV",{class:!0});var Wn=n(he);P(rs.$$.fragment,Wn),uf=d(Wn),os=s(Wn,"P",{});var Hd=n(os);ff=i(Hd,`Example use of Perceiver for text classification.
This model is a PyTorch `),ss=s(Hd,"A",{href:!0,rel:!0});var ZP=n(ss);gf=i(ZP,"torch.nn.Module"),ZP.forEach(r),vf=i(Hd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Hd.forEach(r),_f=d(Wn),X=s(Wn,"DIV",{class:!0});var Cr=n(X);P(ns.$$.fragment,Cr),Pf=d(Cr),dt=s(Cr,"P",{});var Vn=n(dt);bf=i(Vn,"The "),en=s(Vn,"A",{href:!0});var QP=n(en);wf=i(QP,"PerceiverForSequenceClassification"),QP.forEach(r),yf=i(Vn," forward method, overrides the "),Ai=s(Vn,"CODE",{});var YP=n(Ai);$f=i(YP,"__call__"),YP.forEach(r),kf=i(Vn," special method."),Vn.forEach(r),Tf=d(Cr),P(nr.$$.fragment,Cr),xf=d(Cr),P(ar.$$.fragment,Cr),Cr.forEach(r),Wn.forEach(r),Dl=d(t),pt=s(t,"H2",{class:!0});var Wd=n(pt);ir=s(Wd,"A",{id:!0,class:!0,href:!0});var eb=n(ir);Di=s(eb,"SPAN",{});var tb=n(Di);P(as.$$.fragment,tb),tb.forEach(r),eb.forEach(r),Ef=d(Wd),Oi=s(Wd,"SPAN",{});var rb=n(Oi);Ff=i(rb,"PerceiverForImageClassificationLearned"),rb.forEach(r),Wd.forEach(r),Ol=d(t),q=s(t,"DIV",{class:!0});var re=n(q);P(is.$$.fragment,re),Cf=d(re),Ni=s(re,"P",{});var ob=n(Ni);jf=i(ob,"Example use of Perceiver for image classification, for tasks such as ImageNet."),ob.forEach(r),Mf=d(re),Li=s(re,"P",{});var sb=n(Li);If=i(sb,`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),sb.forEach(r),qf=d(re),S=s(re,"P",{});var ue=n(S);tn=s(ue,"A",{href:!0});var nb=n(tn);zf=i(nb,"PerceiverForImageClassificationLearned"),nb.forEach(r),Af=i(ue," uses "),rn=s(ue,"A",{href:!0});var ab=n(rn);Df=i(ab,"PerceiverImagePreprocessor"),ab.forEach(r),Of=i(ue,`
(with `),Si=s(ue,"CODE",{});var ib=n(Si);Nf=i(ib,'prep_type="conv1x1"'),ib.forEach(r),Lf=i(ue,`) to preprocess the input images, and
`),on=s(ue,"A",{href:!0});var cb=n(on);Sf=i(cb,"PerceiverClassificationDecoder"),cb.forEach(r),Bf=i(ue,` to decode the latent representation of
`),sn=s(ue,"A",{href:!0});var lb=n(sn);Hf=i(lb,"PerceiverModel"),lb.forEach(r),Wf=i(ue," into classification logits."),ue.forEach(r),Vf=d(re),cs=s(re,"P",{});var Vd=n(cs);Uf=i(Vd,"This model is a PyTorch "),ls=s(Vd,"A",{href:!0,rel:!0});var db=n(ls);Rf=i(db,"torch.nn.Module"),db.forEach(r),Kf=i(Vd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Vd.forEach(r),Jf=d(re),Z=s(re,"DIV",{class:!0});var jr=n(Z);P(ds.$$.fragment,jr),Gf=d(jr),mt=s(jr,"P",{});var Un=n(mt);Xf=i(Un,"The "),nn=s(Un,"A",{href:!0});var pb=n(nn);Zf=i(pb,"PerceiverForImageClassificationLearned"),pb.forEach(r),Qf=i(Un," forward method, overrides the "),Bi=s(Un,"CODE",{});var mb=n(Bi);Yf=i(mb,"__call__"),mb.forEach(r),eg=i(Un," special method."),Un.forEach(r),tg=d(jr),P(cr.$$.fragment,jr),rg=d(jr),P(lr.$$.fragment,jr),jr.forEach(r),re.forEach(r),Nl=d(t),ht=s(t,"H2",{class:!0});var Ud=n(ht);dr=s(Ud,"A",{id:!0,class:!0,href:!0});var hb=n(dr);Hi=s(hb,"SPAN",{});var ub=n(Hi);P(ps.$$.fragment,ub),ub.forEach(r),hb.forEach(r),og=d(Ud),Wi=s(Ud,"SPAN",{});var fb=n(Wi);sg=i(fb,"PerceiverForImageClassificationFourier"),fb.forEach(r),Ud.forEach(r),Ll=d(t),z=s(t,"DIV",{class:!0});var oe=n(z);P(ms.$$.fragment,oe),ng=d(oe),Vi=s(oe,"P",{});var gb=n(Vi);ag=i(gb,"Example use of Perceiver for image classification, for tasks such as ImageNet."),gb.forEach(r),ig=d(oe),Ui=s(oe,"P",{});var vb=n(Ui);cg=i(vb,`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),vb.forEach(r),lg=d(oe),B=s(oe,"P",{});var fe=n(B);an=s(fe,"A",{href:!0});var _b=n(an);dg=i(_b,"PerceiverForImageClassificationLearned"),_b.forEach(r),pg=i(fe," uses "),cn=s(fe,"A",{href:!0});var Pb=n(cn);mg=i(Pb,"PerceiverImagePreprocessor"),Pb.forEach(r),hg=i(fe,`
(with `),Ri=s(fe,"CODE",{});var bb=n(Ri);ug=i(bb,'prep_type="pixels"'),bb.forEach(r),fg=i(fe,`) to preprocess the input images, and
`),ln=s(fe,"A",{href:!0});var wb=n(ln);gg=i(wb,"PerceiverClassificationDecoder"),wb.forEach(r),vg=i(fe,` to decode the latent representation of
`),dn=s(fe,"A",{href:!0});var yb=n(dn);_g=i(yb,"PerceiverModel"),yb.forEach(r),Pg=i(fe," into classification logits."),fe.forEach(r),bg=d(oe),hs=s(oe,"P",{});var Rd=n(hs);wg=i(Rd,"This model is a PyTorch "),us=s(Rd,"A",{href:!0,rel:!0});var $b=n(us);yg=i($b,"torch.nn.Module"),$b.forEach(r),$g=i(Rd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Rd.forEach(r),kg=d(oe),Q=s(oe,"DIV",{class:!0});var Mr=n(Q);P(fs.$$.fragment,Mr),Tg=d(Mr),ut=s(Mr,"P",{});var Rn=n(ut);xg=i(Rn,"The "),pn=s(Rn,"A",{href:!0});var kb=n(pn);Eg=i(kb,"PerceiverForImageClassificationFourier"),kb.forEach(r),Fg=i(Rn," forward method, overrides the "),Ki=s(Rn,"CODE",{});var Tb=n(Ki);Cg=i(Tb,"__call__"),Tb.forEach(r),jg=i(Rn," special method."),Rn.forEach(r),Mg=d(Mr),P(pr.$$.fragment,Mr),Ig=d(Mr),P(mr.$$.fragment,Mr),Mr.forEach(r),oe.forEach(r),Sl=d(t),ft=s(t,"H2",{class:!0});var Kd=n(ft);hr=s(Kd,"A",{id:!0,class:!0,href:!0});var xb=n(hr);Ji=s(xb,"SPAN",{});var Eb=n(Ji);P(gs.$$.fragment,Eb),Eb.forEach(r),xb.forEach(r),qg=d(Kd),Gi=s(Kd,"SPAN",{});var Fb=n(Gi);zg=i(Fb,"PerceiverForImageClassificationConvProcessing"),Fb.forEach(r),Kd.forEach(r),Bl=d(t),A=s(t,"DIV",{class:!0});var se=n(A);P(vs.$$.fragment,se),Ag=d(se),Xi=s(se,"P",{});var Cb=n(Xi);Dg=i(Cb,"Example use of Perceiver for image classification, for tasks such as ImageNet."),Cb.forEach(r),Og=d(se),Zi=s(se,"P",{});var jb=n(Zi);Ng=i(jb,`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),jb.forEach(r),Lg=d(se),H=s(se,"P",{});var ge=n(H);mn=s(ge,"A",{href:!0});var Mb=n(mn);Sg=i(Mb,"PerceiverForImageClassificationLearned"),Mb.forEach(r),Bg=i(ge," uses "),hn=s(ge,"A",{href:!0});var Ib=n(hn);Hg=i(Ib,"PerceiverImagePreprocessor"),Ib.forEach(r),Wg=i(ge,`
(with `),Qi=s(ge,"CODE",{});var qb=n(Qi);Vg=i(qb,'prep_type="conv"'),qb.forEach(r),Ug=i(ge,`) to preprocess the input images, and
`),un=s(ge,"A",{href:!0});var zb=n(un);Rg=i(zb,"PerceiverClassificationDecoder"),zb.forEach(r),Kg=i(ge,` to decode the latent representation of
`),fn=s(ge,"A",{href:!0});var Ab=n(fn);Jg=i(Ab,"PerceiverModel"),Ab.forEach(r),Gg=i(ge," into classification logits."),ge.forEach(r),Xg=d(se),_s=s(se,"P",{});var Jd=n(_s);Zg=i(Jd,"This model is a PyTorch "),Ps=s(Jd,"A",{href:!0,rel:!0});var Db=n(Ps);Qg=i(Db,"torch.nn.Module"),Db.forEach(r),Yg=i(Jd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Jd.forEach(r),ev=d(se),Y=s(se,"DIV",{class:!0});var Ir=n(Y);P(bs.$$.fragment,Ir),tv=d(Ir),gt=s(Ir,"P",{});var Kn=n(gt);rv=i(Kn,"The "),gn=s(Kn,"A",{href:!0});var Ob=n(gn);ov=i(Ob,"PerceiverForImageClassificationConvProcessing"),Ob.forEach(r),sv=i(Kn," forward method, overrides the "),Yi=s(Kn,"CODE",{});var Nb=n(Yi);nv=i(Nb,"__call__"),Nb.forEach(r),av=i(Kn," special method."),Kn.forEach(r),iv=d(Ir),P(ur.$$.fragment,Ir),cv=d(Ir),P(fr.$$.fragment,Ir),Ir.forEach(r),se.forEach(r),Hl=d(t),vt=s(t,"H2",{class:!0});var Gd=n(vt);gr=s(Gd,"A",{id:!0,class:!0,href:!0});var Lb=n(gr);ec=s(Lb,"SPAN",{});var Sb=n(ec);P(ws.$$.fragment,Sb),Sb.forEach(r),Lb.forEach(r),lv=d(Gd),tc=s(Gd,"SPAN",{});var Bb=n(tc);dv=i(Bb,"PerceiverForOpticalFlow"),Bb.forEach(r),Gd.forEach(r),Wl=d(t),O=s(t,"DIV",{class:!0});var ye=n(O);P(ys.$$.fragment,ye),pv=d(ye),N=s(ye,"P",{});var ne=n(N);mv=i(ne,"Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),vn=s(ne,"A",{href:!0});var Hb=n(vn);hv=i(Hb,"PerceiverForOpticalFlow"),Hb.forEach(r),uv=i(ne,` uses
`),_n=s(ne,"A",{href:!0});var Wb=n(_n);fv=i(Wb,"PerceiverImagePreprocessor"),Wb.forEach(r),gv=i(ne," (with "),rc=s(ne,"EM",{});var Vb=n(rc);vv=i(Vb,"prep_type=\u201Cpatches\u201D"),Vb.forEach(r),_v=i(ne,`) to preprocess the
input images, and `),Pn=s(ne,"A",{href:!0});var Ub=n(Pn);Pv=i(Ub,"PerceiverOpticalFlowDecoder"),Ub.forEach(r),bv=i(ne,` to decode the latent
representation of `),bn=s(ne,"A",{href:!0});var Rb=n(bn);wv=i(Rb,"PerceiverModel"),Rb.forEach(r),yv=i(ne,"."),ne.forEach(r),$v=d(ye),oc=s(ye,"P",{});var Kb=n(oc);kv=i(Kb,`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),Kb.forEach(r),Tv=d(ye),$s=s(ye,"P",{});var Xd=n($s);xv=i(Xd,"This model is a PyTorch "),ks=s(Xd,"A",{href:!0,rel:!0});var Jb=n(ks);Ev=i(Jb,"torch.nn.Module"),Jb.forEach(r),Fv=i(Xd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Xd.forEach(r),Cv=d(ye),ee=s(ye,"DIV",{class:!0});var qr=n(ee);P(Ts.$$.fragment,qr),jv=d(qr),_t=s(qr,"P",{});var Jn=n(_t);Mv=i(Jn,"The "),wn=s(Jn,"A",{href:!0});var Gb=n(wn);Iv=i(Gb,"PerceiverForOpticalFlow"),Gb.forEach(r),qv=i(Jn," forward method, overrides the "),sc=s(Jn,"CODE",{});var Xb=n(sc);zv=i(Xb,"__call__"),Xb.forEach(r),Av=i(Jn," special method."),Jn.forEach(r),Dv=d(qr),P(vr.$$.fragment,qr),Ov=d(qr),P(_r.$$.fragment,qr),qr.forEach(r),ye.forEach(r),Vl=d(t),Pt=s(t,"H2",{class:!0});var Zd=n(Pt);Pr=s(Zd,"A",{id:!0,class:!0,href:!0});var Zb=n(Pr);nc=s(Zb,"SPAN",{});var Qb=n(nc);P(xs.$$.fragment,Qb),Qb.forEach(r),Zb.forEach(r),Nv=d(Zd),ac=s(Zd,"SPAN",{});var Yb=n(ac);Lv=i(Yb,"PerceiverForMultimodalAutoencoding"),Yb.forEach(r),Zd.forEach(r),Ul=d(t),j=s(t,"DIV",{class:!0});var I=n(j);P(Es.$$.fragment,I),Sv=d(I),ic=s(I,"P",{});var ew=n(ic);Bv=i(ew,"Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),ew.forEach(r),Hv=d(I),br=s(I,"P",{});var kc=n(br);yn=s(kc,"A",{href:!0});var tw=n(yn);Wv=i(tw,"PerceiverForMultimodalAutoencoding"),tw.forEach(r),Vv=i(kc," uses "),$n=s(kc,"A",{href:!0});var rw=n($n);Uv=i(rw,"PerceiverMultimodalPreprocessor"),rw.forEach(r),Rv=i(kc,` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),kc.forEach(r),Kv=d(I),be=s(I,"P",{});var Os=n(be);kn=s(Os,"A",{href:!0});var ow=n(kn);Jv=i(ow,"PerceiverMultimodalDecoder"),ow.forEach(r),Gv=i(Os,` is used to decode the latent representation of
`),Tn=s(Os,"A",{href:!0});var sw=n(Tn);Xv=i(sw,"PerceiverModel"),sw.forEach(r),Zv=i(Os,`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),xn=s(Os,"A",{href:!0});var nw=n(xn);Qv=i(nw,"PerceiverForMultimodalAutoencoding"),nw.forEach(r),Yv=i(Os,"."),Os.forEach(r),e_=d(I),wr=s(I,"P",{});var Tc=n(wr);En=s(Tc,"A",{href:!0});var aw=n(En);t_=i(aw,"PerceiverMultimodalDecoder"),aw.forEach(r),r_=i(Tc,` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),Fn=s(Tc,"A",{href:!0});var iw=n(Fn);o_=i(iw,"PerceiverModel"),iw.forEach(r),s_=i(Tc,"."),Tc.forEach(r),n_=d(I),Fs=s(I,"P",{});var Qd=n(Fs);a_=i(Qd,"Finally, "),cc=s(Qd,"CODE",{});var cw=n(cc);i_=i(cw,"PerceiverMultiModalPostprocessor"),cw.forEach(r),c_=i(Qd,` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),Qd.forEach(r),l_=d(I),lc=s(I,"P",{});var lw=n(lc);d_=i(lw,`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),lw.forEach(r),p_=d(I),Cs=s(I,"P",{});var Yd=n(Cs);m_=i(Yd,"This model is a PyTorch "),js=s(Yd,"A",{href:!0,rel:!0});var dw=n(js);h_=i(dw,"torch.nn.Module"),dw.forEach(r),u_=i(Yd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Yd.forEach(r),f_=d(I),te=s(I,"DIV",{class:!0});var zr=n(te);P(Ms.$$.fragment,zr),g_=d(zr),bt=s(zr,"P",{});var Gn=n(bt);v_=i(Gn,"The "),Cn=s(Gn,"A",{href:!0});var pw=n(Cn);__=i(pw,"PerceiverForMultimodalAutoencoding"),pw.forEach(r),P_=i(Gn," forward method, overrides the "),dc=s(Gn,"CODE",{});var mw=n(dc);b_=i(mw,"__call__"),mw.forEach(r),w_=i(Gn," special method."),Gn.forEach(r),y_=d(zr),P(yr.$$.fragment,zr),$_=d(zr),P($r.$$.fragment,zr),zr.forEach(r),I.forEach(r),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",JSON.stringify(Nw)),c(g,"id","perceiver"),c(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(g,"href","#perceiver"),c(v,"class","relative group"),c(Tt,"id","overview"),c(Tt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Tt,"href","#overview"),c($e,"class","relative group"),c(Dr,"href","https://arxiv.org/abs/2107.14795"),c(Dr,"rel","nofollow"),c(Or,"href","https://arxiv.org/abs/2103.03206"),c(Or,"rel","nofollow"),c(Hs,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),vw(Ft.src,x_="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||c(Ft,"src",x_),c(Ft,"alt","drawing"),c(Ft,"width","600"),c(Vs,"href","https://arxiv.org/abs/2105.15203"),c(Lr,"href","https://huggingface.co/nielsr"),c(Lr,"rel","nofollow"),c(Sr,"href","https://github.com/deepmind/deepmind-research/tree/master/perceiver"),c(Sr,"rel","nofollow"),c(Hr,"href","https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver"),c(Hr,"rel","nofollow"),c(Vr,"href","https://huggingface.co/blog/perceiver"),c(Vr,"rel","nofollow"),c(Rr,"href","https://github.com/pytorch/pytorch/issues/36035"),c(Rr,"rel","nofollow"),c(jt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(jt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(jt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(ke,"class","relative group"),c(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Mt,"id","transformers.PerceiverConfig"),c(Mt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Mt,"href","#transformers.PerceiverConfig"),c(Ce,"class","relative group"),c(Ks,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(eo,"href","https://huggingface.co/deepmind/language-perceiver"),c(eo,"rel","nofollow"),c(Js,"href","/docs/transformers/v4.22.2/en/main_classes/configuration#transformers.PretrainedConfig"),c(Gs,"href","/docs/transformers/v4.22.2/en/main_classes/configuration#transformers.PretrainedConfig"),c(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(qt,"id","transformers.PerceiverTokenizer"),c(qt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(qt,"href","#transformers.PerceiverTokenizer"),c(Ie,"class","relative group"),c(Xs,"href","/docs/transformers/v4.22.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer"),c(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(At,"id","transformers.PerceiverFeatureExtractor"),c(At,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(At,"href","#transformers.PerceiverFeatureExtractor"),c(qe,"class","relative group"),c(Zs,"href","/docs/transformers/v4.22.2/en/main_classes/feature_extractor#transformers.ImageFeatureExtractionMixin"),c(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ot,"id","transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(Ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ot,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(ze,"class","relative group"),c(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Nt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Nt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Nt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Ae,"class","relative group"),c(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Lt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Lt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(De,"class","relative group"),c(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(St,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(St,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(St,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Ne,"class","relative group"),c(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Bt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Bt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Bt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Se,"class","relative group"),c(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ht,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ht,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Be,"class","relative group"),c(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Wt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Wt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Wt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(We,"class","relative group"),c(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Vt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Vt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Vt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Ve,"class","relative group"),c(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ut,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Ut,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ut,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Re,"class","relative group"),c(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Rt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Rt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Je,"class","relative group"),c(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Kt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Kt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Kt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Xe,"class","relative group"),c(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Jt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Jt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Jt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Ze,"class","relative group"),c(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Gt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(Gt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Gt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(Ye,"class","relative group"),c(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Xt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(Xt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Xt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(tt,"class","relative group"),c(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Zt,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(Zt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Zt,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(ot,"class","relative group"),c(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Qt,"id","transformers.PerceiverModel"),c(Qt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Qt,"href","#transformers.PerceiverModel"),c(nt,"class","relative group"),c(Jo,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Jo,"rel","nofollow"),c(Qs,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(tr,"id","transformers.PerceiverForMaskedLM"),c(tr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(tr,"href","#transformers.PerceiverForMaskedLM"),c(it,"class","relative group"),c(Yo,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Yo,"rel","nofollow"),c(Ys,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForMaskedLM"),c(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(sr,"id","transformers.PerceiverForSequenceClassification"),c(sr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(sr,"href","#transformers.PerceiverForSequenceClassification"),c(lt,"class","relative group"),c(ss,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ss,"rel","nofollow"),c(en,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification"),c(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ir,"id","transformers.PerceiverForImageClassificationLearned"),c(ir,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ir,"href","#transformers.PerceiverForImageClassificationLearned"),c(pt,"class","relative group"),c(tn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(rn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(on,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(sn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(ls,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ls,"rel","nofollow"),c(nn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(dr,"id","transformers.PerceiverForImageClassificationFourier"),c(dr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(dr,"href","#transformers.PerceiverForImageClassificationFourier"),c(ht,"class","relative group"),c(an,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(cn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(ln,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(dn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(us,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(us,"rel","nofollow"),c(pn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier"),c(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(hr,"id","transformers.PerceiverForImageClassificationConvProcessing"),c(hr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(hr,"href","#transformers.PerceiverForImageClassificationConvProcessing"),c(ft,"class","relative group"),c(mn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(hn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(un,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(fn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(Ps,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Ps,"rel","nofollow"),c(gn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing"),c(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(gr,"id","transformers.PerceiverForOpticalFlow"),c(gr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(gr,"href","#transformers.PerceiverForOpticalFlow"),c(vt,"class","relative group"),c(vn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(_n,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Pn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(bn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(ks,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ks,"rel","nofollow"),c(wn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Pr,"id","transformers.PerceiverForMultimodalAutoencoding"),c(Pr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Pr,"href","#transformers.PerceiverForMultimodalAutoencoding"),c(Pt,"class","relative group"),c(yn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c($n,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(kn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Tn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(xn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(En,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Fn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverModel"),c(js,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(js,"rel","nofollow"),c(Cn,"href","/docs/transformers/v4.22.2/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,m){e(document.head,u),h(t,T,m),h(t,v,m),e(v,g),e(g,k),b(p,k,null),e(v,f),e(v,F),e(F,ep),h(t,xc,m),h(t,$e,m),e($e,Tt),e(Tt,Xn),b(Ar,Xn,null),e($e,tp),e($e,Zn),e(Zn,rp),h(t,Ec,m),h(t,xt,m),e(xt,op),e(xt,Dr),e(Dr,sp),e(xt,np),h(t,Fc,m),h(t,Et,m),e(Et,ap),e(Et,Or),e(Or,ip),e(Et,cp),h(t,Cc,m),h(t,Ns,m),e(Ns,lp),h(t,jc,m),h(t,Ls,m),e(Ls,Qn),e(Qn,dp),h(t,Mc,m),h(t,Ss,m),e(Ss,pp),h(t,Ic,m),h(t,Bs,m),e(Bs,mp),h(t,qc,m),h(t,D,m),e(D,hp),e(D,Hs),e(Hs,up),e(D,fp),e(D,Yn),e(Yn,gp),e(D,vp),e(D,ea),e(ea,_p),e(D,Pp),e(D,ta),e(ta,bp),e(D,wp),e(D,ra),e(ra,yp),e(D,$p),h(t,zc,m),h(t,Ws,m),e(Ws,kp),h(t,Ac,m),h(t,M,m),e(M,Tp),e(M,oa),e(oa,xp),e(M,Ep),e(M,sa),e(sa,Fp),e(M,Cp),e(M,na),e(na,jp),e(M,Mp),e(M,aa),e(aa,Ip),e(M,qp),e(M,ia),e(ia,zp),e(M,Ap),e(M,ca),e(ca,Dp),e(M,Op),h(t,Dc,m),h(t,Ft,m),h(t,Oc,m),h(t,Nr,m),e(Nr,Np),e(Nr,Vs),e(Vs,Lp),h(t,Nc,m),h(t,ve,m),e(ve,Sp),e(ve,Lr),e(Lr,Bp),e(ve,Hp),e(ve,Sr),e(Sr,Wp),e(ve,Vp),h(t,Lc,m),h(t,Us,m),e(Us,Up),h(t,Sc,m),h(t,Ct,m),e(Ct,Br),e(Br,Rp),e(Br,Hr),e(Hr,Kp),e(Br,Jp),e(Ct,Gp),e(Ct,Wr),e(Wr,Xp),e(Wr,Vr),e(Vr,Zp),e(Wr,Qp),h(t,Bc,m),h(t,Ur,m),e(Ur,la),e(la,Yp),e(Ur,em),h(t,Hc,m),h(t,Rs,m),e(Rs,_e),e(_e,tm),e(_e,da),e(da,rm),e(_e,om),e(_e,pa),e(pa,sm),e(_e,nm),e(_e,Rr),e(Rr,am),h(t,Wc,m),h(t,ke,m),e(ke,jt),e(jt,ma),b(Kr,ma,null),e(ke,im),e(ke,ha),e(ha,cm),h(t,Vc,m),h(t,Te,m),b(Jr,Te,null),e(Te,lm),e(Te,ua),e(ua,dm),h(t,Uc,m),h(t,xe,m),b(Gr,xe,null),e(xe,pm),e(xe,fa),e(fa,mm),h(t,Rc,m),h(t,Ee,m),b(Xr,Ee,null),e(Ee,hm),e(Ee,ga),e(ga,um),h(t,Kc,m),h(t,Fe,m),b(Zr,Fe,null),e(Fe,fm),e(Fe,va),e(va,gm),h(t,Jc,m),h(t,Ce,m),e(Ce,Mt),e(Mt,_a),b(Qr,_a,null),e(Ce,vm),e(Ce,Pa),e(Pa,_m),h(t,Gc,m),h(t,V,m),b(Yr,V,null),e(V,Pm),e(V,je),e(je,bm),e(je,Ks),e(Ks,wm),e(je,ym),e(je,eo),e(eo,$m),e(je,km),e(V,Tm),e(V,Me),e(Me,xm),e(Me,Js),e(Js,Em),e(Me,Fm),e(Me,Gs),e(Gs,Cm),e(Me,jm),e(V,Mm),b(It,V,null),h(t,Xc,m),h(t,Ie,m),e(Ie,qt),e(qt,ba),b(to,ba,null),e(Ie,Im),e(Ie,wa),e(wa,qm),h(t,Zc,m),h(t,U,m),b(ro,U,null),e(U,zm),e(U,ya),e(ya,Am),e(U,Dm),e(U,oo),e(oo,Om),e(oo,Xs),e(Xs,Nm),e(oo,Lm),e(U,Sm),e(U,zt),b(so,zt,null),e(zt,Bm),e(zt,$a),e($a,Hm),h(t,Qc,m),h(t,qe,m),e(qe,At),e(At,ka),b(no,ka,null),e(qe,Wm),e(qe,Ta),e(Ta,Vm),h(t,Yc,m),h(t,R,m),b(ao,R,null),e(R,Um),e(R,xa),e(xa,Rm),e(R,Km),e(R,io),e(io,Jm),e(io,Zs),e(Zs,Gm),e(io,Xm),e(R,Zm),e(R,Pe),b(co,Pe,null),e(Pe,Qm),e(Pe,Ea),e(Ea,Ym),e(Pe,eh),b(Dt,Pe,null),h(t,el,m),h(t,ze,m),e(ze,Ot),e(Ot,Fa),b(lo,Fa,null),e(ze,th),e(ze,Ca),e(Ca,rh),h(t,tl,m),h(t,ae,m),b(po,ae,null),e(ae,oh),e(ae,mo),e(mo,sh),e(mo,ja),e(ja,nh),e(mo,ah),e(ae,ih),e(ae,ho),e(ho,ch),e(ho,Ma),e(Ma,lh),e(ho,dh),h(t,rl,m),h(t,Ae,m),e(Ae,Nt),e(Nt,Ia),b(uo,Ia,null),e(Ae,ph),e(Ae,qa),e(qa,mh),h(t,ol,m),h(t,ie,m),b(fo,ie,null),e(ie,hh),e(ie,za),e(za,uh),e(ie,fh),e(ie,K),e(K,gh),e(K,Aa),e(Aa,vh),e(K,_h),e(K,Da),e(Da,Ph),e(K,bh),e(K,Oa),e(Oa,wh),e(K,yh),e(K,Na),e(Na,$h),e(K,kh),h(t,sl,m),h(t,De,m),e(De,Lt),e(Lt,La),b(go,La,null),e(De,Th),e(De,Sa),e(Sa,xh),h(t,nl,m),h(t,Oe,m),b(vo,Oe,null),e(Oe,Eh),e(Oe,Ba),e(Ba,Fh),h(t,al,m),h(t,Ne,m),e(Ne,St),e(St,Ha),b(_o,Ha,null),e(Ne,Ch),e(Ne,Wa),e(Wa,jh),h(t,il,m),h(t,Le,m),b(Po,Le,null),e(Le,Mh),e(Le,Va),e(Va,Ih),h(t,cl,m),h(t,Se,m),e(Se,Bt),e(Bt,Ua),b(bo,Ua,null),e(Se,qh),e(Se,Ra),e(Ra,zh),h(t,ll,m),h(t,ce,m),b(wo,ce,null),e(ce,Ah),e(ce,Ka),e(Ka,Dh),e(ce,Oh),e(ce,Ja),e(Ja,Nh),h(t,dl,m),h(t,Be,m),e(Be,Ht),e(Ht,Ga),b(yo,Ga,null),e(Be,Lh),e(Be,Xa),e(Xa,Sh),h(t,pl,m),h(t,He,m),b($o,He,null),e(He,Bh),e(He,Za),e(Za,Hh),h(t,ml,m),h(t,We,m),e(We,Wt),e(Wt,Qa),b(ko,Qa,null),e(We,Wh),e(We,Ya),e(Ya,Vh),h(t,hl,m),h(t,le,m),b(To,le,null),e(le,Uh),e(le,ei),e(ei,Rh),e(le,Kh),e(le,ti),e(ti,Jh),h(t,ul,m),h(t,Ve,m),e(Ve,Vt),e(Vt,ri),b(xo,ri,null),e(Ve,Gh),e(Ve,oi),e(oi,Xh),h(t,fl,m),h(t,Ue,m),b(Eo,Ue,null),e(Ue,Zh),e(Ue,Fo),e(Fo,Qh),e(Fo,si),e(si,Yh),e(Fo,eu),h(t,gl,m),h(t,Re,m),e(Re,Ut),e(Ut,ni),b(Co,ni,null),e(Re,tu),e(Re,ai),e(ai,ru),h(t,vl,m),h(t,Ke,m),b(jo,Ke,null),e(Ke,ou),e(Ke,ii),e(ii,su),h(t,_l,m),h(t,Je,m),e(Je,Rt),e(Rt,ci),b(Mo,ci,null),e(Je,nu),e(Je,li),e(li,au),h(t,Pl,m),h(t,Ge,m),b(Io,Ge,null),e(Ge,iu),e(Ge,qo),e(qo,cu),e(qo,di),e(di,lu),e(qo,du),h(t,bl,m),h(t,Xe,m),e(Xe,Kt),e(Kt,pi),b(zo,pi,null),e(Xe,pu),e(Xe,mi),e(mi,mu),h(t,wl,m),h(t,de,m),b(Ao,de,null),e(de,hu),e(de,Do),e(Do,uu),e(Do,hi),e(hi,fu),e(Do,gu),e(de,vu),e(de,ui),e(ui,_u),h(t,yl,m),h(t,Ze,m),e(Ze,Jt),e(Jt,fi),b(Oo,fi,null),e(Ze,Pu),e(Ze,gi),e(gi,bu),h(t,$l,m),h(t,Qe,m),b(No,Qe,null),e(Qe,wu),e(Qe,vi),e(vi,yu),h(t,kl,m),h(t,Ye,m),e(Ye,Gt),e(Gt,_i),b(Lo,_i,null),e(Ye,$u),e(Ye,Pi),e(Pi,ku),h(t,Tl,m),h(t,et,m),b(So,et,null),e(et,Tu),e(et,bi),e(bi,xu),h(t,xl,m),h(t,tt,m),e(tt,Xt),e(Xt,wi),b(Bo,wi,null),e(tt,Eu),e(tt,yi),e(yi,Fu),h(t,El,m),h(t,rt,m),b(Ho,rt,null),e(rt,Cu),e(rt,$i),e($i,ju),h(t,Fl,m),h(t,ot,m),e(ot,Zt),e(Zt,ki),b(Wo,ki,null),e(ot,Mu),e(ot,Ti),e(Ti,Iu),h(t,Cl,m),h(t,st,m),b(Vo,st,null),e(st,qu),e(st,xi),e(xi,zu),h(t,jl,m),h(t,nt,m),e(nt,Qt),e(Qt,Ei),b(Uo,Ei,null),e(nt,Au),e(nt,Fi),e(Fi,Du),h(t,Ml,m),h(t,pe,m),b(Ro,pe,null),e(pe,Ou),e(pe,Ko),e(Ko,Nu),e(Ko,Jo),e(Jo,Lu),e(Ko,Su),e(pe,Bu),e(pe,J),b(Go,J,null),e(J,Hu),e(J,at),e(at,Wu),e(at,Qs),e(Qs,Vu),e(at,Uu),e(at,Ci),e(Ci,Ru),e(at,Ku),e(J,Ju),b(Yt,J,null),e(J,Gu),b(er,J,null),h(t,Il,m),h(t,it,m),e(it,tr),e(tr,ji),b(Xo,ji,null),e(it,Xu),e(it,Mi),e(Mi,Zu),h(t,ql,m),h(t,me,m),b(Zo,me,null),e(me,Qu),e(me,Qo),e(Qo,Yu),e(Qo,Yo),e(Yo,ef),e(Qo,tf),e(me,rf),e(me,G),b(es,G,null),e(G,of),e(G,ct),e(ct,sf),e(ct,Ys),e(Ys,nf),e(ct,af),e(ct,Ii),e(Ii,cf),e(ct,lf),e(G,df),b(rr,G,null),e(G,pf),b(or,G,null),h(t,zl,m),h(t,lt,m),e(lt,sr),e(sr,qi),b(ts,qi,null),e(lt,mf),e(lt,zi),e(zi,hf),h(t,Al,m),h(t,he,m),b(rs,he,null),e(he,uf),e(he,os),e(os,ff),e(os,ss),e(ss,gf),e(os,vf),e(he,_f),e(he,X),b(ns,X,null),e(X,Pf),e(X,dt),e(dt,bf),e(dt,en),e(en,wf),e(dt,yf),e(dt,Ai),e(Ai,$f),e(dt,kf),e(X,Tf),b(nr,X,null),e(X,xf),b(ar,X,null),h(t,Dl,m),h(t,pt,m),e(pt,ir),e(ir,Di),b(as,Di,null),e(pt,Ef),e(pt,Oi),e(Oi,Ff),h(t,Ol,m),h(t,q,m),b(is,q,null),e(q,Cf),e(q,Ni),e(Ni,jf),e(q,Mf),e(q,Li),e(Li,If),e(q,qf),e(q,S),e(S,tn),e(tn,zf),e(S,Af),e(S,rn),e(rn,Df),e(S,Of),e(S,Si),e(Si,Nf),e(S,Lf),e(S,on),e(on,Sf),e(S,Bf),e(S,sn),e(sn,Hf),e(S,Wf),e(q,Vf),e(q,cs),e(cs,Uf),e(cs,ls),e(ls,Rf),e(cs,Kf),e(q,Jf),e(q,Z),b(ds,Z,null),e(Z,Gf),e(Z,mt),e(mt,Xf),e(mt,nn),e(nn,Zf),e(mt,Qf),e(mt,Bi),e(Bi,Yf),e(mt,eg),e(Z,tg),b(cr,Z,null),e(Z,rg),b(lr,Z,null),h(t,Nl,m),h(t,ht,m),e(ht,dr),e(dr,Hi),b(ps,Hi,null),e(ht,og),e(ht,Wi),e(Wi,sg),h(t,Ll,m),h(t,z,m),b(ms,z,null),e(z,ng),e(z,Vi),e(Vi,ag),e(z,ig),e(z,Ui),e(Ui,cg),e(z,lg),e(z,B),e(B,an),e(an,dg),e(B,pg),e(B,cn),e(cn,mg),e(B,hg),e(B,Ri),e(Ri,ug),e(B,fg),e(B,ln),e(ln,gg),e(B,vg),e(B,dn),e(dn,_g),e(B,Pg),e(z,bg),e(z,hs),e(hs,wg),e(hs,us),e(us,yg),e(hs,$g),e(z,kg),e(z,Q),b(fs,Q,null),e(Q,Tg),e(Q,ut),e(ut,xg),e(ut,pn),e(pn,Eg),e(ut,Fg),e(ut,Ki),e(Ki,Cg),e(ut,jg),e(Q,Mg),b(pr,Q,null),e(Q,Ig),b(mr,Q,null),h(t,Sl,m),h(t,ft,m),e(ft,hr),e(hr,Ji),b(gs,Ji,null),e(ft,qg),e(ft,Gi),e(Gi,zg),h(t,Bl,m),h(t,A,m),b(vs,A,null),e(A,Ag),e(A,Xi),e(Xi,Dg),e(A,Og),e(A,Zi),e(Zi,Ng),e(A,Lg),e(A,H),e(H,mn),e(mn,Sg),e(H,Bg),e(H,hn),e(hn,Hg),e(H,Wg),e(H,Qi),e(Qi,Vg),e(H,Ug),e(H,un),e(un,Rg),e(H,Kg),e(H,fn),e(fn,Jg),e(H,Gg),e(A,Xg),e(A,_s),e(_s,Zg),e(_s,Ps),e(Ps,Qg),e(_s,Yg),e(A,ev),e(A,Y),b(bs,Y,null),e(Y,tv),e(Y,gt),e(gt,rv),e(gt,gn),e(gn,ov),e(gt,sv),e(gt,Yi),e(Yi,nv),e(gt,av),e(Y,iv),b(ur,Y,null),e(Y,cv),b(fr,Y,null),h(t,Hl,m),h(t,vt,m),e(vt,gr),e(gr,ec),b(ws,ec,null),e(vt,lv),e(vt,tc),e(tc,dv),h(t,Wl,m),h(t,O,m),b(ys,O,null),e(O,pv),e(O,N),e(N,mv),e(N,vn),e(vn,hv),e(N,uv),e(N,_n),e(_n,fv),e(N,gv),e(N,rc),e(rc,vv),e(N,_v),e(N,Pn),e(Pn,Pv),e(N,bv),e(N,bn),e(bn,wv),e(N,yv),e(O,$v),e(O,oc),e(oc,kv),e(O,Tv),e(O,$s),e($s,xv),e($s,ks),e(ks,Ev),e($s,Fv),e(O,Cv),e(O,ee),b(Ts,ee,null),e(ee,jv),e(ee,_t),e(_t,Mv),e(_t,wn),e(wn,Iv),e(_t,qv),e(_t,sc),e(sc,zv),e(_t,Av),e(ee,Dv),b(vr,ee,null),e(ee,Ov),b(_r,ee,null),h(t,Vl,m),h(t,Pt,m),e(Pt,Pr),e(Pr,nc),b(xs,nc,null),e(Pt,Nv),e(Pt,ac),e(ac,Lv),h(t,Ul,m),h(t,j,m),b(Es,j,null),e(j,Sv),e(j,ic),e(ic,Bv),e(j,Hv),e(j,br),e(br,yn),e(yn,Wv),e(br,Vv),e(br,$n),e($n,Uv),e(br,Rv),e(j,Kv),e(j,be),e(be,kn),e(kn,Jv),e(be,Gv),e(be,Tn),e(Tn,Xv),e(be,Zv),e(be,xn),e(xn,Qv),e(be,Yv),e(j,e_),e(j,wr),e(wr,En),e(En,t_),e(wr,r_),e(wr,Fn),e(Fn,o_),e(wr,s_),e(j,n_),e(j,Fs),e(Fs,a_),e(Fs,cc),e(cc,i_),e(Fs,c_),e(j,l_),e(j,lc),e(lc,d_),e(j,p_),e(j,Cs),e(Cs,m_),e(Cs,js),e(js,h_),e(Cs,u_),e(j,f_),e(j,te),b(Ms,te,null),e(te,g_),e(te,bt),e(bt,v_),e(bt,Cn),e(Cn,__),e(bt,P_),e(bt,dc),e(dc,b_),e(bt,w_),e(te,y_),b(yr,te,null),e(te,$_),b($r,te,null),Rl=!0},p(t,[m]){const Is={};m&2&&(Is.$$scope={dirty:m,ctx:t}),It.$set(Is);const pc={};m&2&&(pc.$$scope={dirty:m,ctx:t}),Dt.$set(pc);const mc={};m&2&&(mc.$$scope={dirty:m,ctx:t}),Yt.$set(mc);const hc={};m&2&&(hc.$$scope={dirty:m,ctx:t}),er.$set(hc);const qs={};m&2&&(qs.$$scope={dirty:m,ctx:t}),rr.$set(qs);const uc={};m&2&&(uc.$$scope={dirty:m,ctx:t}),or.$set(uc);const fc={};m&2&&(fc.$$scope={dirty:m,ctx:t}),nr.$set(fc);const gc={};m&2&&(gc.$$scope={dirty:m,ctx:t}),ar.$set(gc);const zs={};m&2&&(zs.$$scope={dirty:m,ctx:t}),cr.$set(zs);const vc={};m&2&&(vc.$$scope={dirty:m,ctx:t}),lr.$set(vc);const As={};m&2&&(As.$$scope={dirty:m,ctx:t}),pr.$set(As);const _c={};m&2&&(_c.$$scope={dirty:m,ctx:t}),mr.$set(_c);const Pc={};m&2&&(Pc.$$scope={dirty:m,ctx:t}),ur.$set(Pc);const bc={};m&2&&(bc.$$scope={dirty:m,ctx:t}),fr.$set(bc);const wc={};m&2&&(wc.$$scope={dirty:m,ctx:t}),vr.$set(wc);const yc={};m&2&&(yc.$$scope={dirty:m,ctx:t}),_r.$set(yc);const $c={};m&2&&($c.$$scope={dirty:m,ctx:t}),yr.$set($c);const L={};m&2&&(L.$$scope={dirty:m,ctx:t}),$r.$set(L)},i(t){Rl||(w(p.$$.fragment,t),w(Ar.$$.fragment,t),w(Kr.$$.fragment,t),w(Jr.$$.fragment,t),w(Gr.$$.fragment,t),w(Xr.$$.fragment,t),w(Zr.$$.fragment,t),w(Qr.$$.fragment,t),w(Yr.$$.fragment,t),w(It.$$.fragment,t),w(to.$$.fragment,t),w(ro.$$.fragment,t),w(so.$$.fragment,t),w(no.$$.fragment,t),w(ao.$$.fragment,t),w(co.$$.fragment,t),w(Dt.$$.fragment,t),w(lo.$$.fragment,t),w(po.$$.fragment,t),w(uo.$$.fragment,t),w(fo.$$.fragment,t),w(go.$$.fragment,t),w(vo.$$.fragment,t),w(_o.$$.fragment,t),w(Po.$$.fragment,t),w(bo.$$.fragment,t),w(wo.$$.fragment,t),w(yo.$$.fragment,t),w($o.$$.fragment,t),w(ko.$$.fragment,t),w(To.$$.fragment,t),w(xo.$$.fragment,t),w(Eo.$$.fragment,t),w(Co.$$.fragment,t),w(jo.$$.fragment,t),w(Mo.$$.fragment,t),w(Io.$$.fragment,t),w(zo.$$.fragment,t),w(Ao.$$.fragment,t),w(Oo.$$.fragment,t),w(No.$$.fragment,t),w(Lo.$$.fragment,t),w(So.$$.fragment,t),w(Bo.$$.fragment,t),w(Ho.$$.fragment,t),w(Wo.$$.fragment,t),w(Vo.$$.fragment,t),w(Uo.$$.fragment,t),w(Ro.$$.fragment,t),w(Go.$$.fragment,t),w(Yt.$$.fragment,t),w(er.$$.fragment,t),w(Xo.$$.fragment,t),w(Zo.$$.fragment,t),w(es.$$.fragment,t),w(rr.$$.fragment,t),w(or.$$.fragment,t),w(ts.$$.fragment,t),w(rs.$$.fragment,t),w(ns.$$.fragment,t),w(nr.$$.fragment,t),w(ar.$$.fragment,t),w(as.$$.fragment,t),w(is.$$.fragment,t),w(ds.$$.fragment,t),w(cr.$$.fragment,t),w(lr.$$.fragment,t),w(ps.$$.fragment,t),w(ms.$$.fragment,t),w(fs.$$.fragment,t),w(pr.$$.fragment,t),w(mr.$$.fragment,t),w(gs.$$.fragment,t),w(vs.$$.fragment,t),w(bs.$$.fragment,t),w(ur.$$.fragment,t),w(fr.$$.fragment,t),w(ws.$$.fragment,t),w(ys.$$.fragment,t),w(Ts.$$.fragment,t),w(vr.$$.fragment,t),w(_r.$$.fragment,t),w(xs.$$.fragment,t),w(Es.$$.fragment,t),w(Ms.$$.fragment,t),w(yr.$$.fragment,t),w($r.$$.fragment,t),Rl=!0)},o(t){y(p.$$.fragment,t),y(Ar.$$.fragment,t),y(Kr.$$.fragment,t),y(Jr.$$.fragment,t),y(Gr.$$.fragment,t),y(Xr.$$.fragment,t),y(Zr.$$.fragment,t),y(Qr.$$.fragment,t),y(Yr.$$.fragment,t),y(It.$$.fragment,t),y(to.$$.fragment,t),y(ro.$$.fragment,t),y(so.$$.fragment,t),y(no.$$.fragment,t),y(ao.$$.fragment,t),y(co.$$.fragment,t),y(Dt.$$.fragment,t),y(lo.$$.fragment,t),y(po.$$.fragment,t),y(uo.$$.fragment,t),y(fo.$$.fragment,t),y(go.$$.fragment,t),y(vo.$$.fragment,t),y(_o.$$.fragment,t),y(Po.$$.fragment,t),y(bo.$$.fragment,t),y(wo.$$.fragment,t),y(yo.$$.fragment,t),y($o.$$.fragment,t),y(ko.$$.fragment,t),y(To.$$.fragment,t),y(xo.$$.fragment,t),y(Eo.$$.fragment,t),y(Co.$$.fragment,t),y(jo.$$.fragment,t),y(Mo.$$.fragment,t),y(Io.$$.fragment,t),y(zo.$$.fragment,t),y(Ao.$$.fragment,t),y(Oo.$$.fragment,t),y(No.$$.fragment,t),y(Lo.$$.fragment,t),y(So.$$.fragment,t),y(Bo.$$.fragment,t),y(Ho.$$.fragment,t),y(Wo.$$.fragment,t),y(Vo.$$.fragment,t),y(Uo.$$.fragment,t),y(Ro.$$.fragment,t),y(Go.$$.fragment,t),y(Yt.$$.fragment,t),y(er.$$.fragment,t),y(Xo.$$.fragment,t),y(Zo.$$.fragment,t),y(es.$$.fragment,t),y(rr.$$.fragment,t),y(or.$$.fragment,t),y(ts.$$.fragment,t),y(rs.$$.fragment,t),y(ns.$$.fragment,t),y(nr.$$.fragment,t),y(ar.$$.fragment,t),y(as.$$.fragment,t),y(is.$$.fragment,t),y(ds.$$.fragment,t),y(cr.$$.fragment,t),y(lr.$$.fragment,t),y(ps.$$.fragment,t),y(ms.$$.fragment,t),y(fs.$$.fragment,t),y(pr.$$.fragment,t),y(mr.$$.fragment,t),y(gs.$$.fragment,t),y(vs.$$.fragment,t),y(bs.$$.fragment,t),y(ur.$$.fragment,t),y(fr.$$.fragment,t),y(ws.$$.fragment,t),y(ys.$$.fragment,t),y(Ts.$$.fragment,t),y(vr.$$.fragment,t),y(_r.$$.fragment,t),y(xs.$$.fragment,t),y(Es.$$.fragment,t),y(Ms.$$.fragment,t),y(yr.$$.fragment,t),y($r.$$.fragment,t),Rl=!1},d(t){r(u),t&&r(T),t&&r(v),$(p),t&&r(xc),t&&r($e),$(Ar),t&&r(Ec),t&&r(xt),t&&r(Fc),t&&r(Et),t&&r(Cc),t&&r(Ns),t&&r(jc),t&&r(Ls),t&&r(Mc),t&&r(Ss),t&&r(Ic),t&&r(Bs),t&&r(qc),t&&r(D),t&&r(zc),t&&r(Ws),t&&r(Ac),t&&r(M),t&&r(Dc),t&&r(Ft),t&&r(Oc),t&&r(Nr),t&&r(Nc),t&&r(ve),t&&r(Lc),t&&r(Us),t&&r(Sc),t&&r(Ct),t&&r(Bc),t&&r(Ur),t&&r(Hc),t&&r(Rs),t&&r(Wc),t&&r(ke),$(Kr),t&&r(Vc),t&&r(Te),$(Jr),t&&r(Uc),t&&r(xe),$(Gr),t&&r(Rc),t&&r(Ee),$(Xr),t&&r(Kc),t&&r(Fe),$(Zr),t&&r(Jc),t&&r(Ce),$(Qr),t&&r(Gc),t&&r(V),$(Yr),$(It),t&&r(Xc),t&&r(Ie),$(to),t&&r(Zc),t&&r(U),$(ro),$(so),t&&r(Qc),t&&r(qe),$(no),t&&r(Yc),t&&r(R),$(ao),$(co),$(Dt),t&&r(el),t&&r(ze),$(lo),t&&r(tl),t&&r(ae),$(po),t&&r(rl),t&&r(Ae),$(uo),t&&r(ol),t&&r(ie),$(fo),t&&r(sl),t&&r(De),$(go),t&&r(nl),t&&r(Oe),$(vo),t&&r(al),t&&r(Ne),$(_o),t&&r(il),t&&r(Le),$(Po),t&&r(cl),t&&r(Se),$(bo),t&&r(ll),t&&r(ce),$(wo),t&&r(dl),t&&r(Be),$(yo),t&&r(pl),t&&r(He),$($o),t&&r(ml),t&&r(We),$(ko),t&&r(hl),t&&r(le),$(To),t&&r(ul),t&&r(Ve),$(xo),t&&r(fl),t&&r(Ue),$(Eo),t&&r(gl),t&&r(Re),$(Co),t&&r(vl),t&&r(Ke),$(jo),t&&r(_l),t&&r(Je),$(Mo),t&&r(Pl),t&&r(Ge),$(Io),t&&r(bl),t&&r(Xe),$(zo),t&&r(wl),t&&r(de),$(Ao),t&&r(yl),t&&r(Ze),$(Oo),t&&r($l),t&&r(Qe),$(No),t&&r(kl),t&&r(Ye),$(Lo),t&&r(Tl),t&&r(et),$(So),t&&r(xl),t&&r(tt),$(Bo),t&&r(El),t&&r(rt),$(Ho),t&&r(Fl),t&&r(ot),$(Wo),t&&r(Cl),t&&r(st),$(Vo),t&&r(jl),t&&r(nt),$(Uo),t&&r(Ml),t&&r(pe),$(Ro),$(Go),$(Yt),$(er),t&&r(Il),t&&r(it),$(Xo),t&&r(ql),t&&r(me),$(Zo),$(es),$(rr),$(or),t&&r(zl),t&&r(lt),$(ts),t&&r(Al),t&&r(he),$(rs),$(ns),$(nr),$(ar),t&&r(Dl),t&&r(pt),$(as),t&&r(Ol),t&&r(q),$(is),$(ds),$(cr),$(lr),t&&r(Nl),t&&r(ht),$(ps),t&&r(Ll),t&&r(z),$(ms),$(fs),$(pr),$(mr),t&&r(Sl),t&&r(ft),$(gs),t&&r(Bl),t&&r(A),$(vs),$(bs),$(ur),$(fr),t&&r(Hl),t&&r(vt),$(ws),t&&r(Wl),t&&r(O),$(ys),$(Ts),$(vr),$(_r),t&&r(Vl),t&&r(Pt),$(xs),t&&r(Ul),t&&r(j),$(Es),$(Ms),$(yr),$($r)}}}const Nw={local:"perceiver",sections:[{local:"overview",title:"Overview"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",title:"Perceiver specific outputs"},{local:"transformers.PerceiverConfig",title:"PerceiverConfig"},{local:"transformers.PerceiverTokenizer",title:"PerceiverTokenizer"},{local:"transformers.PerceiverFeatureExtractor",title:"PerceiverFeatureExtractor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",title:"PerceiverTextPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",title:"PerceiverImagePreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",title:"PerceiverOneHotPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",title:"PerceiverAudioPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",title:"PerceiverMultimodalPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",title:"PerceiverProjectionDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",title:"PerceiverBasicDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",title:"PerceiverClassificationDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",title:"PerceiverOpticalFlowDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",title:"PerceiverBasicVideoAutoencodingDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",title:"PerceiverMultimodalDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",title:"PerceiverProjectionPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",title:"PerceiverAudioPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",title:"PerceiverClassificationPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",title:"PerceiverMultimodalPostprocessor"},{local:"transformers.PerceiverModel",title:"PerceiverModel"},{local:"transformers.PerceiverForMaskedLM",title:"PerceiverForMaskedLM"},{local:"transformers.PerceiverForSequenceClassification",title:"PerceiverForSequenceClassification"},{local:"transformers.PerceiverForImageClassificationLearned",title:"PerceiverForImageClassificationLearned"},{local:"transformers.PerceiverForImageClassificationFourier",title:"PerceiverForImageClassificationFourier"},{local:"transformers.PerceiverForImageClassificationConvProcessing",title:"PerceiverForImageClassificationConvProcessing"},{local:"transformers.PerceiverForOpticalFlow",title:"PerceiverForOpticalFlow"},{local:"transformers.PerceiverForMultimodalAutoencoding",title:"PerceiverForMultimodalAutoencoding"}],title:"Perceiver"};function Lw(E){return _w(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rw extends hw{constructor(u){super();uw(this,u,Lw,Ow,fw,{})}}export{Rw as default,Nw as metadata};
