import{s as Pe,n as Ke,o as qe}from"../chunks/scheduler.9bc65507.js";import{S as Ae,i as Oe,g as p,s as l,r as J,A as es,h as i,f as t,c as n,j as Qe,u as m,x as o,k as Ve,y as ss,a,v as r,d as w,t as T,w as c}from"../chunks/index.707bf1b6.js";import{C as u}from"../chunks/CodeBlock.54a9f38d.js";import{D as ts}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as as,E as ls}from"../chunks/EditOnGithub.922df6ba.js";function ns(We){let h,K,Q,q,M,A,b,O,f,Ze="Image-to-Image task is the task where an application receives an image and outputs another image. This has various subtasks, including image enhancement (super resolution, low light enhancement, deraining and so on), image inpainting, and more.",ee,I,xe="This guide will show you how to:",se,y,Ne="<li>Use an image-to-image pipeline for super resolution task,</li> <li>Run image-to-image models for same task without a pipeline.</li>",te,j,De="Note that as of the time this guide is released, <code>image-to-image</code> pipeline only supports super resolution task.",ae,$,_e="Let’s begin by installing the necessary libraries.",le,v,ne,C,ze='We can now initialize the pipeline with a <a href="https://huggingface.co/caidas/swin2SR-lightweight-x2-64" rel="nofollow">Swin2SR model</a>. We can then infer with the pipeline by calling it with an image. As of now, only <a href="https://huggingface.co/models?sort=trending&amp;search=swin2sr" rel="nofollow">Swin2SR models</a> are supported in this pipeline.',pe,U,ie,k,Ge="Now, let’s load an image.",oe,V,Je,W,me,g,Se='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg" alt="Photo of a cat"/>',re,Z,Re="We can now do inference with the pipeline. We will get an upscaled version of the cat image.",we,x,Te,N,ce,D,Be="If you wish to do inference yourself with no pipeline, you can use the <code>Swin2SRForImageSuperResolution</code> and <code>Swin2SRImageProcessor</code> classes of transformers. We will use the same model checkpoint for this. Let’s initialize the model and the processor.",ue,_,he,z,He="<code>pipeline</code> abstracts away the preprocessing and postprocessing steps that we have to do ourselves, so let’s preprocess the image. We will pass the image to the processor and then move the pixel values to GPU.",ge,G,de,S,Ye="We can now infer the image by passing pixel values to the model.",Me,R,be,B,Le="Output is an object of type <code>ImageSuperResolutionOutput</code> that looks like below 👇",fe,H,Ie,Y,Ee="We need to get the <code>reconstruction</code> and post-process it for visualization. Let’s see how it looks like.",ye,L,je,E,Xe="We need to squeeze the output and get rid of axis 0, clip the values, then convert it to be numpy float. Then we will arrange axes to have the shape [1072, 880], and finally, bring the output back to range [0, 255].",$e,X,ve,d,Fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat_upscaled.png" alt="Upscaled photo of a cat"/>',Ce,F,Ue,P,ke;return M=new as({props:{title:"Image-to-Image Task Guide",local:"image-to-image-task-guide",headingTag:"h1"}}),b=new ts({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"}]}}),v=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),U=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdjdWRhJyUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAnY3B1JyklMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXRvLWltYWdlJTIyJTJDJTIwbW9kZWwlM0QlMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-to-image&quot;</span>, model=<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>, device=device)`,wrap:!1}}),V=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmNhdC5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmludChpbWFnZS5zaXplKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-built_in">print</span>(image.size)`,wrap:!1}}),W=new u({props:{code:"JTIzJTIwKDUzMiUyQyUyMDQzMik=",highlighted:'<span class="hljs-comment"># (532, 432)</span>',wrap:!1}}),x=new u({props:{code:"dXBzY2FsZWQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQXByaW50KHVwc2NhbGVkLnNpemUp",highlighted:`upscaled = pipe(image)
<span class="hljs-built_in">print</span>(upscaled.size)`,wrap:!1}}),N=new u({props:{code:"JTIzJTIwKDEwNzIlMkMlMjA4ODAp",highlighted:'<span class="hljs-comment"># (1072, 880)</span>',wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JGb3JJbWFnZVN1cGVyUmVzb2x1dGlvbiUyQyUyMFN3aW4yU1JJbWFnZVByb2Nlc3NvciUyMCUwQSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU3dpbjJTUkltYWdlUHJvY2Vzc29yKCUyMmNhaWRhcyUyRnN3aW4yU1ItbGlnaHR3ZWlnaHQteDItNjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRForImageSuperResolution, Swin2SRImageProcessor 

model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>).to(device)
processor = Swin2SRImageProcessor(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>)`,wrap:!1}}),G=new u({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBcHJpbnQocGl4ZWxfdmFsdWVzLnNoYXBlKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHBpeGVsX3ZhbHVlcy50byhkZXZpY2Up",highlighted:`pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-built_in">print</span>(pixel_values.shape)

pixel_values = pixel_values.to(device)`,wrap:!1}}),R=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">with</span> torch.no_grad():
  outputs = model(pixel_values)`,wrap:!1}}),H=new u({props:{code:"KGxvc3MlM0ROb25lJTJDJTIwcmVjb25zdHJ1Y3Rpb24lM0R0ZW5zb3IoJTVCJTVCJTVCJTVCMC44MjcwJTJDJTIwMC44MjY5JTJDJTIwMC44Mjc1JTJDJTIwJTIwLi4uJTJDJTIwMC43NDYzJTJDJTIwMC43NDQ2JTJDJTIwMC43NDUzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44Mjg3JTJDJTIwMC44Mjc4JTJDJTIwMC44MjgzJTJDJTIwJTIwLi4uJTJDJTIwMC43NDUxJTJDJTIwMC43NDQ4JTJDJTIwMC43NDU3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44MjgwJTJDJTIwMC44MjczJTJDJTIwMC44MjY5JTJDJTIwJTIwLi4uJTJDJTIwMC43NDQ3JTJDJTIwMC43NDQ2JTJDJTIwMC43NDUyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTIzJTJDJTIwMC41OTMzJTJDJTIwMC41OTI0JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjk3JTJDJTIwMC4wNjk1JTJDJTIwMC4wNzA2JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI2JTJDJTIwMC41OTMyJTJDJTIwMC41OTI2JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjczJTJDJTIwMC4wNjg3JTJDJTIwMC4wNzA1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI3JTJDJTIwMC41OTE0JTJDJTIwMC41OTIyJTJDJTIwJTIwLi4uJTJDJTIwMC4wNjY0JTJDJTIwMC4wNjk0JTJDJTIwMC4wNzE4JTVEJTVEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV2aWNlJTNEJ2N1ZGElM0EwJyklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKQ==",highlighted:`(<span class="hljs-name">loss=None</span>, reconstruction=tensor([[[[<span class="hljs-name">0.8270</span>, <span class="hljs-number">0.8269</span>, <span class="hljs-number">0.8275</span>,  ..., <span class="hljs-number">0.7463</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7453</span>],
          [<span class="hljs-name">0.8287</span>, <span class="hljs-number">0.8278</span>, <span class="hljs-number">0.8283</span>,  ..., <span class="hljs-number">0.7451</span>, <span class="hljs-number">0.7448</span>, <span class="hljs-number">0.7457</span>],
          [<span class="hljs-name">0.8280</span>, <span class="hljs-number">0.8273</span>, <span class="hljs-number">0.8269</span>,  ..., <span class="hljs-number">0.7447</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7452</span>],
          ...,
          [<span class="hljs-name">0.5923</span>, <span class="hljs-number">0.5933</span>, <span class="hljs-number">0.5924</span>,  ..., <span class="hljs-number">0.0697</span>, <span class="hljs-number">0.0695</span>, <span class="hljs-number">0.0706</span>],
          [<span class="hljs-name">0.5926</span>, <span class="hljs-number">0.5932</span>, <span class="hljs-number">0.5926</span>,  ..., <span class="hljs-number">0.0673</span>, <span class="hljs-number">0.0687</span>, <span class="hljs-number">0.0705</span>],
          [<span class="hljs-name">0.5927</span>, <span class="hljs-number">0.5914</span>, <span class="hljs-number">0.5922</span>,  ..., <span class="hljs-number">0.0664</span>, <span class="hljs-number">0.0694</span>, <span class="hljs-number">0.0718</span>]]]],
       device=<span class="hljs-symbol">&#x27;cuda:0</span>&#x27;), hidden_states=None, attentions=None)`,wrap:!1}}),L=new u({props:{code:"b3V0cHV0cy5yZWNvbnN0cnVjdGlvbi5kYXRhLnNoYXBlJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDg4MCUyQyUyMDEwNzIlNUQp",highlighted:`outputs.reconstruction.data.shape
<span class="hljs-comment"># torch.Size([1, 3, 880, 1072])</span>`,wrap:!1}}),X=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwc3F1ZWV6ZSUyQyUyMHRha2UlMjB0byUyMENQVSUyMGFuZCUyMGNsaXAlMjB0aGUlMjB2YWx1ZXMlMEFvdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uLmRhdGEuc3F1ZWV6ZSgpLmNwdSgpLmNsYW1wXygwJTJDJTIwMSkubnVtcHkoKSUwQSUyMyUyMHJlYXJyYW5nZSUyMHRoZSUyMGF4ZXMlMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEElMjMlMjBicmluZyUyMHZhbHVlcyUyMGJhY2slMjB0byUyMHBpeGVsJTIwdmFsdWVzJTIwcmFuZ2UlMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMEFJbWFnZS5mcm9tYXJyYXkob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># squeeze, take to CPU and clip the values</span>
output = outputs.reconstruction.data.squeeze().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-comment"># rearrange the axes</span>
output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-comment"># bring values back to pixel values range</span>
output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)
Image.fromarray(output)`,wrap:!1}}),F=new ls({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_to_image.md"}}),{c(){h=p("meta"),K=l(),Q=p("p"),q=l(),J(M.$$.fragment),A=l(),J(b.$$.fragment),O=l(),f=p("p"),f.textContent=Ze,ee=l(),I=p("p"),I.textContent=xe,se=l(),y=p("ul"),y.innerHTML=Ne,te=l(),j=p("p"),j.innerHTML=De,ae=l(),$=p("p"),$.textContent=_e,le=l(),J(v.$$.fragment),ne=l(),C=p("p"),C.innerHTML=ze,pe=l(),J(U.$$.fragment),ie=l(),k=p("p"),k.textContent=Ge,oe=l(),J(V.$$.fragment),Je=l(),J(W.$$.fragment),me=l(),g=p("div"),g.innerHTML=Se,re=l(),Z=p("p"),Z.textContent=Re,we=l(),J(x.$$.fragment),Te=l(),J(N.$$.fragment),ce=l(),D=p("p"),D.innerHTML=Be,ue=l(),J(_.$$.fragment),he=l(),z=p("p"),z.innerHTML=He,ge=l(),J(G.$$.fragment),de=l(),S=p("p"),S.textContent=Ye,Me=l(),J(R.$$.fragment),be=l(),B=p("p"),B.innerHTML=Le,fe=l(),J(H.$$.fragment),Ie=l(),Y=p("p"),Y.innerHTML=Ee,ye=l(),J(L.$$.fragment),je=l(),E=p("p"),E.textContent=Xe,$e=l(),J(X.$$.fragment),ve=l(),d=p("div"),d.innerHTML=Fe,Ce=l(),J(F.$$.fragment),Ue=l(),P=p("p"),this.h()},l(e){const s=es("svelte-u9bgzb",document.head);h=i(s,"META",{name:!0,content:!0}),s.forEach(t),K=n(e),Q=i(e,"P",{}),Qe(Q).forEach(t),q=n(e),m(M.$$.fragment,e),A=n(e),m(b.$$.fragment,e),O=n(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1m5ab0h"&&(f.textContent=Ze),ee=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1aff4p7"&&(I.textContent=xe),se=n(e),y=i(e,"UL",{"data-svelte-h":!0}),o(y)!=="svelte-1dytd0b"&&(y.innerHTML=Ne),te=n(e),j=i(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-j21dpj"&&(j.innerHTML=De),ae=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-2ffb0z"&&($.textContent=_e),le=n(e),m(v.$$.fragment,e),ne=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-6x8yac"&&(C.innerHTML=ze),pe=n(e),m(U.$$.fragment,e),ie=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-dx2hkj"&&(k.textContent=Ge),oe=n(e),m(V.$$.fragment,e),Je=n(e),m(W.$$.fragment,e),me=n(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-muvbux"&&(g.innerHTML=Se),re=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-jehike"&&(Z.textContent=Re),we=n(e),m(x.$$.fragment,e),Te=n(e),m(N.$$.fragment,e),ce=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-7mqp02"&&(D.innerHTML=Be),ue=n(e),m(_.$$.fragment,e),he=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-cwlggi"&&(z.innerHTML=He),ge=n(e),m(G.$$.fragment,e),de=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-z8yxu1"&&(S.textContent=Ye),Me=n(e),m(R.$$.fragment,e),be=n(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-yf1rhn"&&(B.innerHTML=Le),fe=n(e),m(H.$$.fragment,e),Ie=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-nzl4n2"&&(Y.innerHTML=Ee),ye=n(e),m(L.$$.fragment,e),je=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-z07gu"&&(E.textContent=Xe),$e=n(e),m(X.$$.fragment,e),ve=n(e),d=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-1u1oaeg"&&(d.innerHTML=Fe),Ce=n(e),m(F.$$.fragment,e),Ue=n(e),P=i(e,"P",{}),Qe(P).forEach(t),this.h()},h(){Ve(h,"name","hf:doc:metadata"),Ve(h,"content",ps),Ve(g,"class","flex justify-center"),Ve(d,"class","flex justify-center")},m(e,s){ss(document.head,h),a(e,K,s),a(e,Q,s),a(e,q,s),r(M,e,s),a(e,A,s),r(b,e,s),a(e,O,s),a(e,f,s),a(e,ee,s),a(e,I,s),a(e,se,s),a(e,y,s),a(e,te,s),a(e,j,s),a(e,ae,s),a(e,$,s),a(e,le,s),r(v,e,s),a(e,ne,s),a(e,C,s),a(e,pe,s),r(U,e,s),a(e,ie,s),a(e,k,s),a(e,oe,s),r(V,e,s),a(e,Je,s),r(W,e,s),a(e,me,s),a(e,g,s),a(e,re,s),a(e,Z,s),a(e,we,s),r(x,e,s),a(e,Te,s),r(N,e,s),a(e,ce,s),a(e,D,s),a(e,ue,s),r(_,e,s),a(e,he,s),a(e,z,s),a(e,ge,s),r(G,e,s),a(e,de,s),a(e,S,s),a(e,Me,s),r(R,e,s),a(e,be,s),a(e,B,s),a(e,fe,s),r(H,e,s),a(e,Ie,s),a(e,Y,s),a(e,ye,s),r(L,e,s),a(e,je,s),a(e,E,s),a(e,$e,s),r(X,e,s),a(e,ve,s),a(e,d,s),a(e,Ce,s),r(F,e,s),a(e,Ue,s),a(e,P,s),ke=!0},p:Ke,i(e){ke||(w(M.$$.fragment,e),w(b.$$.fragment,e),w(v.$$.fragment,e),w(U.$$.fragment,e),w(V.$$.fragment,e),w(W.$$.fragment,e),w(x.$$.fragment,e),w(N.$$.fragment,e),w(_.$$.fragment,e),w(G.$$.fragment,e),w(R.$$.fragment,e),w(H.$$.fragment,e),w(L.$$.fragment,e),w(X.$$.fragment,e),w(F.$$.fragment,e),ke=!0)},o(e){T(M.$$.fragment,e),T(b.$$.fragment,e),T(v.$$.fragment,e),T(U.$$.fragment,e),T(V.$$.fragment,e),T(W.$$.fragment,e),T(x.$$.fragment,e),T(N.$$.fragment,e),T(_.$$.fragment,e),T(G.$$.fragment,e),T(R.$$.fragment,e),T(H.$$.fragment,e),T(L.$$.fragment,e),T(X.$$.fragment,e),T(F.$$.fragment,e),ke=!1},d(e){e&&(t(K),t(Q),t(q),t(A),t(O),t(f),t(ee),t(I),t(se),t(y),t(te),t(j),t(ae),t($),t(le),t(ne),t(C),t(pe),t(ie),t(k),t(oe),t(Je),t(me),t(g),t(re),t(Z),t(we),t(Te),t(ce),t(D),t(ue),t(he),t(z),t(ge),t(de),t(S),t(Me),t(be),t(B),t(fe),t(Ie),t(Y),t(ye),t(je),t(E),t($e),t(ve),t(d),t(Ce),t(Ue),t(P)),t(h),c(M,e),c(b,e),c(v,e),c(U,e),c(V,e),c(W,e),c(x,e),c(N,e),c(_,e),c(G,e),c(R,e),c(H,e),c(L,e),c(X,e),c(F,e)}}}const ps='{"title":"Image-to-Image Task Guide","local":"image-to-image-task-guide","sections":[],"depth":1}';function is(We){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends Ae{constructor(h){super(),Oe(this,h,is,ns,Pe,{})}}export{Ts as component};
