import{s as bt,o as wt,n as Tt}from"../chunks/scheduler.182ea377.js";import{S as Zt,i as jt,g as i,s as n,r,A as Ct,h as o,f as s,c as a,j as Jt,u as c,x as p,k as js,y as vt,a as t,v as f,d as u,t as d,w as M}from"../chunks/index.abf12888.js";import{T as Ut}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as It}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as U}from"../chunks/Heading.16916d63.js";function gt(Ae){let m,J='💡 Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you are interested in learning in more detail about how the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){m=i("p"),m.innerHTML=J},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-164e214"&&(m.innerHTML=J)},m(h,T){t(h,m,T)},p:Tt,d(h){h&&s(m)}}}function Vt(Ae){let m,J="💡 When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories instead of variations (for example, <code>stable-diffusion-v1-4</code> and <code>stable-diffusion-v1-5</code>).";return{c(){m=i("p"),m.innerHTML=J},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1bx6mv6"&&(m.innerHTML=J)},m(h,T){t(h,m,T)},p:Tt,d(h){h&&s(m)}}}function Wt(Ae){let m,J,h,T,C,Le,v,Pe,I,Cs='Having an easy way to use a diffusion system for inference is essential to 🧨 Diffusers. Diffusion systems often consist of multiple components like parameterized models, tokenizers, and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API, while remaining flexible enough to be adapted for other use cases, such as loading each component individually as building blocks to assemble your own diffusion system.',Oe,g,vs="Everything you need for inference or training is accessible with the <code>from_pretrained()</code> method.",Ke,V,Is="This guide will show you how to load:",el,W,gs="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li> <li>models and schedulers</li>",ll,k,sl,b,tl,R,Vs='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is the simplest and most generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> method automatically detects the correct pipeline class from the checkpoint, downloads, and caches all the required configuration and weight files, and returns a pipeline instance ready for inference.',nl,N,al,B,Ws='You can also load a checkpoint with its specific pipeline class. The example above loaded a Stable Diffusion model; to get the same result, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class:',il,G,ol,_,ks='A checkpoint (such as <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow"><code>CompVis/stable-diffusion-v1-4</code></a> or <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) may also be used for more than one task, like text-to-image or image-to-image. To differentiate what task you want to use the checkpoint for, you have to load it directly with its corresponding task-specific pipeline class:',pl,$,rl,Q,Rs="You can use the Space below to gauge the memory requirements of a pipeline you want to load beforehand without downloading the pipeline checkpoints:",cl,w,Ns='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=light" width="850" height="1600"></iframe>',fl,Z,Bs='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=dark" width="850" height="1600"></iframe>',ul,X,dl,E,Gs='To load a diffusion pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow"><code>git-lfs</code></a> to manually download the checkpoint (in this case, <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) to your local disk. This creates a local folder, <code>./stable-diffusion-v1-5</code>, on your disk:',Ml,z,ml,x,_s='Then pass the local path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>:',yl,D,hl,H,$s='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download any files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',Jl,S,Ul,q,Qs="You can customize the default components of any pipeline with another compatible component. Customization is important because:",Tl,Y,Xs="<li>Changing the scheduler is important for exploring the trade-off between generation speed and quality.</li> <li>Different components of a model are typically trained independently and you can swap out a component with a better-performing one.</li> <li>During finetuning, usually only some components - like the UNet or text encoder - are trained.</li>",bl,A,Es="To find out which schedulers are compatible for customization, you can use the <code>compatibles</code> method:",wl,F,Zl,L,zs='Let’s use the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method to replace the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> with a more performant scheduler, <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>. The <code>subfolder=&quot;scheduler&quot;</code> argument is required to load the scheduler configuration from the correct <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.',jl,P,xs='Then you can pass the new <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> instance to the <code>scheduler</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Cl,O,vl,K,Il,ee,Ds='Diffusion models like Stable Diffusion can generate harmful content, which is why 🧨 Diffusers has a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> to check generated outputs against known hardcoded NSFW content. If you’d like to disable the safety checker for whatever reason, pass <code>None</code> to the <code>safety_checker</code> argument:',gl,le,Vl,se,Wl,te,Hs='You can also reuse the same components in multiple pipelines to avoid loading the weights into RAM twice. Use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.components">components</a> method to save the components:',kl,ne,Rl,ae,Ss="Then you can pass the <code>components</code> to another pipeline without reloading the weights into RAM:",Nl,ie,Bl,oe,qs="You can also pass the components individually to the pipeline if you want more flexibility over which components to reuse or disable. For example, to reuse the same components in the text-to-image pipeline, except for the safety checker and feature extractor, in the image-to-image pipeline:",Gl,pe,_l,re,$l,ce,Ys="A checkpoint variant is usually a checkpoint whose weights are:",Ql,fe,As='<li>Stored in a different floating point type for lower precision and lower storage, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow"><code>torch.float16</code></a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights, which shouldn’t be used for inference. You should use these to continue fine-tuning a model.</li>',Xl,j,El,ue,Fs='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">Safetensors</a>), model structure, and weights that have identical tensor shapes.',zl,de,Ls="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.bin</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.bin</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.bin</td> <td><code>variant</code></td></tr></tbody>",xl,Me,Ps="There are two important arguments to know for loading variants:",Dl,me,Os='<li><p><code>torch_dtype</code> defines the floating point precision of the loaded checkpoints. For example, if you want to save bandwidth by loading a <code>fp16</code> variant, you should specify <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to <code>fp16</code>. Otherwise, the <code>fp16</code> weights are converted to the default <code>fp32</code> precision. You can also load the original checkpoint without defining the <code>variant</code> argument, and convert it to <code>fp16</code> with <code>torch_dtype=torch.float16</code>. In this case, the default <code>fp32</code> weights are downloaded first, and then they’re converted to <code>fp16</code> after loading.</p></li> <li><p><code>variant</code> defines which files should be loaded from the repository. For example, if you want to load a <code>non_ema</code> variant from the <a href="https://huggingface.co/diffusers/stable-diffusion-variants/tree/main/unet" rel="nofollow"><code>diffusers/stable-diffusion-variants</code></a> repository, you should specify <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> files.</p></li>',Hl,ye,Sl,he,Ks='To save a checkpoint stored in a different floating-point type or as a non-EMA variant, use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method and specify the <code>variant</code> argument. You should try and save a variant to the same folder as the original checkpoint, so you can load both from the same folder:',ql,Je,Yl,Ue,et="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint:",Al,Te,Fl,be,Ll,we,lt='Models are loaded from the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> method, which downloads and caches the latest version of the model weights and configurations. If the latest files are available in the local cache, <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> reuses files in the cache instead of re-downloading them.',Pl,Ze,st='Models can be loaded from a subfolder with the <code>subfolder</code> argument. For example, the model weights for <code>runwayml/stable-diffusion-v1-5</code> are stored in the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/unet" rel="nofollow"><code>unet</code></a> subfolder:',Ol,je,Kl,Ce,tt='Or directly from a repository’s <a href="https://huggingface.co/google/ddpm-cifar10-32/tree/main" rel="nofollow">directory</a>:',es,ve,ls,Ie,nt='You can also load and save model variants by specifying the <code>variant</code> argument in <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> and <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>:',ss,ge,ts,Ve,ns,We,at='Schedulers are loaded from the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method, and unlike models, schedulers are <strong>not parameterized</strong> or <strong>trained</strong>; they are defined by a configuration file.',as,ke,it=`Loading schedulers does not consume any significant amount of memory and the same configuration file can be used for a variety of different schedulers.
For example, the following schedulers are compatible with <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which means you can load the same scheduler configuration file in any of these classes:`,is,Re,os,Ne,ps,Be,ot='As a class method, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',rs,Ge,pt='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',cs,_e,rt='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>.',fs,$e,us,Qe,ct='You’ll see pipeline is an instance of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',ds,Xe,ft='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',Ms,Ee,ms,ze,ut='Compare the components of the pipeline instance to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',ys,xe,hs,De,dt="You can access each of the components of the pipeline as an attribute to view its configuration:",Js,He,Us,Se,Mt='Every pipeline expects a <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Ts,qe,mt="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",bs,Ye,ws,Fe,Zs;return C=new U({props:{title:"Load pipelines, models, and schedulers",local:"load-pipelines-models-and-schedulers",headingTag:"h1"}}),v=new It({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),k=new U({props:{title:"Diffusion Pipeline",local:"diffusion-pipeline",headingTag:"h2"}}),b=new Ut({props:{$$slots:{default:[gt]},$$scope:{ctx:Ae}}}),N=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionImg2ImgPipeline.from_pretrained(repo_id)`,wrap:!1}}),X=new U({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),z=new y({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new U({props:{title:"Swap components in a pipeline",local:"swap-components-in-a-pipeline",headingTag:"h3"}}),F=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFzdGFibGVfZGlmZnVzaW9uLnNjaGVkdWxlci5jb21wYXRpYmxlcw==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion.scheduler.compatibles`,wrap:!1}}),O=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, EulerDiscreteScheduler

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
scheduler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, scheduler=scheduler, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),K=new U({props:{title:"Safety checker",local:"safety-checker",headingTag:"h3"}}),le=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMjIlMjIlMjIlMEFZb3UlMjBoYXZlJTIwZGlzYWJsZWQlMjB0aGUlMjBzYWZldHklMjBjaGVja2VyJTIwZm9yJTIwJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIwYnklMjBwYXNzaW5nJTIwJTYwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTYwLiUyMEVuc3VyZSUyMHRoYXQlMjB5b3UlMjBhYmlkZSUyMGJ5JTIwdGhlJTIwY29uZGl0aW9ucyUyMG9mJTIwdGhlJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwbGljZW5zZSUyMGFuZCUyMGRvJTIwbm90JTIwZXhwb3NlJTIwdW5maWx0ZXJlZCUyMHJlc3VsdHMlMjBpbiUyMHNlcnZpY2VzJTIwb3IlMjBhcHBsaWNhdGlvbnMlMjBvcGVuJTIwdG8lMjB0aGUlMjBwdWJsaWMuJTIwQm90aCUyMHRoZSUyMGRpZmZ1c2VycyUyMHRlYW0lMjBhbmQlMjBIdWdnaW5nJTIwRmFjZSUyMHN0cm9uZ2x5JTIwcmVjb21tZW5kJTIwa2VlcGluZyUyMHRoZSUyMHNhZmV0eSUyMGZpbHRlciUyMGVuYWJsZWQlMjBpbiUyMGFsbCUyMHB1YmxpYy1mYWNpbmclMjBjaXJjdW1zdGFuY2VzJTJDJTIwZGlzYWJsaW5nJTIwaXQlMjBvbmx5JTIwZm9yJTIwdXNlJTIwY2FzZXMlMjB0aGF0JTIwaW52b2x2ZSUyMGFuYWx5emluZyUyMG5ldHdvcmslMjBiZWhhdmlvciUyMG9yJTIwYXVkaXRpbmclMjBpdHMlMjByZXN1bHRzLiUyMEZvciUyMG1vcmUlMjBpbmZvcm1hdGlvbiUyQyUyMHBsZWFzZSUyMGhhdmUlMjBhJTIwbG9vayUyMGF0JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMlMkZwdWxsJTJGMjU0JTIwLiUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),se=new U({props:{title:"Reuse components across pipelines",local:"reuse-components-across-pipelines",headingTag:"h3"}}),ne=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5jb21wb25lbnRz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

components = stable_diffusion_txt2img.components`,wrap:!1}}),ie=new y({props:{code:"c3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqY29tcG9uZW50cyk=",highlighted:"stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(**components)",wrap:!1}}),pe=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBc3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHZhZSUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy52YWUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHVuZXQlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudW5ldCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5zY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(
    vae=stable_diffusion_txt2img.vae,
    text_encoder=stable_diffusion_txt2img.text_encoder,
    tokenizer=stable_diffusion_txt2img.tokenizer,
    unet=stable_diffusion_txt2img.unet,
    scheduler=stable_diffusion_txt2img.scheduler,
    safety_checker=<span class="hljs-literal">None</span>,
    feature_extractor=<span class="hljs-literal">None</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),re=new U({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),j=new Ut({props:{$$slots:{default:[Vt]},$$scope:{ctx:Ae}}}),ye=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBsb2FkJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMGxvYWQlMjBub25fZW1hJTIwdmFyaWFudCUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load fp16 variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># load non_ema variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Je=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwc2F2ZSUyMGFzJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUyMyUyMHNhdmUlMjBhcyUyMG5vbi1lbWElMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># save as fp16 variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-comment"># save as non-ema variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),Te=new y({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIzJTIwJUYwJTlGJTkxJThEJTIwdGhpcyUyMHdvcmtzJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),be=new U({props:{title:"Models",local:"models",headingTag:"h2"}}),je=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
model = UNet2DConditionModel.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ve=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

repo_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>
model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ge=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbG9jYWwtdW5ldCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
model.save_pretrained(<span class="hljs-string">&quot;./local-unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),Ve=new U({props:{title:"Schedulers",local:"schedulers",headingTag:"h2"}}),Re=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRERJTVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMFBORE1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBKSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQWRkcG0lMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRkaW0lMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXBuZG0lMjAlM0QlMjBQTkRNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWxtcyUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWV1bGVyX2FuYyUyMCUzRCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBZXVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEElMjMlMjByZXBsYWNlJTIwJTYwZHBtJTYwJTIwd2l0aCUyMGFueSUyMG9mJTIwJTYwZGRwbSU2MCUyQyUyMCU2MGRkaW0lNjAlMkMlMjAlNjBwbmRtJTYwJTJDJTIwJTYwbG1zJTYwJTJDJTIwJTYwZXVsZXJfYW5jJTYwJTJDJTIwJTYwZXVsZXIlNjAlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEZHBtJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDPMScheduler,
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    EulerAncestralDiscreteScheduler,
    EulerDiscreteScheduler,
    DPMSolverMultistepScheduler,
)

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

ddpm = DDPMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
ddim = DDIMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
pndm = PNDMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
lms = LMSDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler_anc = EulerAncestralDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
dpm = DPMSolverMultistepScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-comment"># replace \`dpm\` with any of \`ddpm\`, \`ddim\`, \`pndm\`, \`lms\`, \`euler_anc\`, \`euler\`</span>
pipeline = StableDiffusionPipeline.from_pretrained(repo_id, scheduler=dpm, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ne=new U({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),$e=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcHJpbnQocGlwZWxpbmUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),Ee=new y({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),xe=new y({props:{code:"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",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`,wrap:!1}}),He=new y({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Ye=new y({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),{c(){m=i("meta"),J=n(),h=i("p"),T=n(),r(C.$$.fragment),Le=n(),r(v.$$.fragment),Pe=n(),I=i("p"),I.innerHTML=Cs,Oe=n(),g=i("p"),g.innerHTML=vs,Ke=n(),V=i("p"),V.textContent=Is,el=n(),W=i("ul"),W.innerHTML=gs,ll=n(),r(k.$$.fragment),sl=n(),r(b.$$.fragment),tl=n(),R=i("p"),R.innerHTML=Vs,nl=n(),r(N.$$.fragment),al=n(),B=i("p"),B.innerHTML=Ws,il=n(),r(G.$$.fragment),ol=n(),_=i("p"),_.innerHTML=ks,pl=n(),r($.$$.fragment),rl=n(),Q=i("p"),Q.textContent=Rs,cl=n(),w=i("div"),w.innerHTML=Ns,fl=n(),Z=i("div"),Z.innerHTML=Bs,ul=n(),r(X.$$.fragment),dl=n(),E=i("p"),E.innerHTML=Gs,Ml=n(),r(z.$$.fragment),ml=n(),x=i("p"),x.innerHTML=_s,yl=n(),r(D.$$.fragment),hl=n(),H=i("p"),H.innerHTML=$s,Jl=n(),r(S.$$.fragment),Ul=n(),q=i("p"),q.textContent=Qs,Tl=n(),Y=i("ul"),Y.innerHTML=Xs,bl=n(),A=i("p"),A.innerHTML=Es,wl=n(),r(F.$$.fragment),Zl=n(),L=i("p"),L.innerHTML=zs,jl=n(),P=i("p"),P.innerHTML=xs,Cl=n(),r(O.$$.fragment),vl=n(),r(K.$$.fragment),Il=n(),ee=i("p"),ee.innerHTML=Ds,gl=n(),r(le.$$.fragment),Vl=n(),r(se.$$.fragment),Wl=n(),te=i("p"),te.innerHTML=Hs,kl=n(),r(ne.$$.fragment),Rl=n(),ae=i("p"),ae.innerHTML=Ss,Nl=n(),r(ie.$$.fragment),Bl=n(),oe=i("p"),oe.textContent=qs,Gl=n(),r(pe.$$.fragment),_l=n(),r(re.$$.fragment),$l=n(),ce=i("p"),ce.textContent=Ys,Ql=n(),fe=i("ul"),fe.innerHTML=As,Xl=n(),r(j.$$.fragment),El=n(),ue=i("p"),ue.innerHTML=Fs,zl=n(),de=i("table"),de.innerHTML=Ls,xl=n(),Me=i("p"),Me.textContent=Ps,Dl=n(),me=i("ul"),me.innerHTML=Os,Hl=n(),r(ye.$$.fragment),Sl=n(),he=i("p"),he.innerHTML=Ks,ql=n(),r(Je.$$.fragment),Yl=n(),Ue=i("p"),Ue.innerHTML=et,Al=n(),r(Te.$$.fragment),Fl=n(),r(be.$$.fragment),Ll=n(),we=i("p"),we.innerHTML=lt,Pl=n(),Ze=i("p"),Ze.innerHTML=st,Ol=n(),r(je.$$.fragment),Kl=n(),Ce=i("p"),Ce.innerHTML=tt,es=n(),r(ve.$$.fragment),ls=n(),Ie=i("p"),Ie.innerHTML=nt,ss=n(),r(ge.$$.fragment),ts=n(),r(Ve.$$.fragment),ns=n(),We=i("p"),We.innerHTML=at,as=n(),ke=i("p"),ke.innerHTML=it,is=n(),r(Re.$$.fragment),os=n(),r(Ne.$$.fragment),ps=n(),Be=i("p"),Be.innerHTML=ot,rs=n(),Ge=i("ul"),Ge.innerHTML=pt,cs=n(),_e=i("p"),_e.innerHTML=rt,fs=n(),r($e.$$.fragment),us=n(),Qe=i("p"),Qe.innerHTML=ct,ds=n(),Xe=i("ul"),Xe.innerHTML=ft,Ms=n(),r(Ee.$$.fragment),ms=n(),ze=i("p"),ze.innerHTML=ut,ys=n(),r(xe.$$.fragment),hs=n(),De=i("p"),De.textContent=dt,Js=n(),r(He.$$.fragment),Us=n(),Se=i("p"),Se.innerHTML=Mt,Ts=n(),qe=i("ul"),qe.innerHTML=mt,bs=n(),r(Ye.$$.fragment),ws=n(),Fe=i("p"),this.h()},l(e){const l=Ct("svelte-u9bgzb",document.head);m=o(l,"META",{name:!0,content:!0}),l.forEach(s),J=a(e),h=o(e,"P",{}),Jt(h).forEach(s),T=a(e),c(C.$$.fragment,e),Le=a(e),c(v.$$.fragment,e),Pe=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-b825yc"&&(I.innerHTML=Cs),Oe=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1let6ok"&&(g.innerHTML=vs),Ke=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-b6mpdv"&&(V.textContent=Is),el=a(e),W=o(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-19eqgr5"&&(W.innerHTML=gs),ll=a(e),c(k.$$.fragment,e),sl=a(e),c(b.$$.fragment,e),tl=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1een31v"&&(R.innerHTML=Vs),nl=a(e),c(N.$$.fragment,e),al=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-87p7"&&(B.innerHTML=Ws),il=a(e),c(G.$$.fragment,e),ol=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1dc1tjj"&&(_.innerHTML=ks),pl=a(e),c($.$$.fragment,e),rl=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1gn1gle"&&(Q.textContent=Rs),cl=a(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1eacg44"&&(w.innerHTML=Ns),fl=a(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-1scmarz"&&(Z.innerHTML=Bs),ul=a(e),c(X.$$.fragment,e),dl=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-zzamd0"&&(E.innerHTML=Gs),Ml=a(e),c(z.$$.fragment,e),ml=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-14lmk7e"&&(x.innerHTML=_s),yl=a(e),c(D.$$.fragment,e),hl=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-i8rr5s"&&(H.innerHTML=$s),Jl=a(e),c(S.$$.fragment,e),Ul=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1b4jg3u"&&(q.textContent=Qs),Tl=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-vp14rw"&&(Y.innerHTML=Xs),bl=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-s7xu2t"&&(A.innerHTML=Es),wl=a(e),c(F.$$.fragment,e),Zl=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1llio5t"&&(L.innerHTML=zs),jl=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1cym4i4"&&(P.innerHTML=xs),Cl=a(e),c(O.$$.fragment,e),vl=a(e),c(K.$$.fragment,e),Il=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-181junk"&&(ee.innerHTML=Ds),gl=a(e),c(le.$$.fragment,e),Vl=a(e),c(se.$$.fragment,e),Wl=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-12c191q"&&(te.innerHTML=Hs),kl=a(e),c(ne.$$.fragment,e),Rl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-jytaak"&&(ae.innerHTML=Ss),Nl=a(e),c(ie.$$.fragment,e),Bl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1o7di1p"&&(oe.textContent=qs),Gl=a(e),c(pe.$$.fragment,e),_l=a(e),c(re.$$.fragment,e),$l=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-144ljdh"&&(ce.textContent=Ys),Ql=a(e),fe=o(e,"UL",{"data-svelte-h":!0}),p(fe)!=="svelte-1j7sdrg"&&(fe.innerHTML=As),Xl=a(e),c(j.$$.fragment,e),El=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-q0e9bt"&&(ue.innerHTML=Fs),zl=a(e),de=o(e,"TABLE",{"data-svelte-h":!0}),p(de)!=="svelte-1e3wdtx"&&(de.innerHTML=Ls),xl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-16brnlv"&&(Me.textContent=Ps),Dl=a(e),me=o(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-11239e9"&&(me.innerHTML=Os),Hl=a(e),c(ye.$$.fragment,e),Sl=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-utq62g"&&(he.innerHTML=Ks),ql=a(e),c(Je.$$.fragment,e),Yl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-ydb193"&&(Ue.innerHTML=et),Al=a(e),c(Te.$$.fragment,e),Fl=a(e),c(be.$$.fragment,e),Ll=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1cl76mo"&&(we.innerHTML=lt),Pl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1y53na1"&&(Ze.innerHTML=st),Ol=a(e),c(je.$$.fragment,e),Kl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-7x7c45"&&(Ce.innerHTML=tt),es=a(e),c(ve.$$.fragment,e),ls=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-h4z70l"&&(Ie.innerHTML=nt),ss=a(e),c(ge.$$.fragment,e),ts=a(e),c(Ve.$$.fragment,e),ns=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1xjd8d0"&&(We.innerHTML=at),as=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-ubdfig"&&(ke.innerHTML=it),is=a(e),c(Re.$$.fragment,e),os=a(e),c(Ne.$$.fragment,e),ps=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-nr77qh"&&(Be.innerHTML=ot),rs=a(e),Ge=o(e,"UL",{"data-svelte-h":!0}),p(Ge)!=="svelte-17dcgvz"&&(Ge.innerHTML=pt),cs=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-jme5sm"&&(_e.innerHTML=rt),fs=a(e),c($e.$$.fragment,e),us=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-102ytrs"&&(Qe.innerHTML=ct),ds=a(e),Xe=o(e,"UL",{"data-svelte-h":!0}),p(Xe)!=="svelte-1e5gxzy"&&(Xe.innerHTML=ft),Ms=a(e),c(Ee.$$.fragment,e),ms=a(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-173hqz7"&&(ze.innerHTML=ut),ys=a(e),c(xe.$$.fragment,e),hs=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-5jik9b"&&(De.textContent=dt),Js=a(e),c(He.$$.fragment,e),Us=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1uoxyh2"&&(Se.innerHTML=Mt),Ts=a(e),qe=o(e,"UL",{"data-svelte-h":!0}),p(qe)!=="svelte-hr84vt"&&(qe.innerHTML=mt),bs=a(e),c(Ye.$$.fragment,e),ws=a(e),Fe=o(e,"P",{}),Jt(Fe).forEach(s),this.h()},h(){js(m,"name","hf:doc:metadata"),js(m,"content",kt),js(w,"class","block dark:hidden"),js(Z,"class","hidden dark:block")},m(e,l){vt(document.head,m),t(e,J,l),t(e,h,l),t(e,T,l),f(C,e,l),t(e,Le,l),f(v,e,l),t(e,Pe,l),t(e,I,l),t(e,Oe,l),t(e,g,l),t(e,Ke,l),t(e,V,l),t(e,el,l),t(e,W,l),t(e,ll,l),f(k,e,l),t(e,sl,l),f(b,e,l),t(e,tl,l),t(e,R,l),t(e,nl,l),f(N,e,l),t(e,al,l),t(e,B,l),t(e,il,l),f(G,e,l),t(e,ol,l),t(e,_,l),t(e,pl,l),f($,e,l),t(e,rl,l),t(e,Q,l),t(e,cl,l),t(e,w,l),t(e,fl,l),t(e,Z,l),t(e,ul,l),f(X,e,l),t(e,dl,l),t(e,E,l),t(e,Ml,l),f(z,e,l),t(e,ml,l),t(e,x,l),t(e,yl,l),f(D,e,l),t(e,hl,l),t(e,H,l),t(e,Jl,l),f(S,e,l),t(e,Ul,l),t(e,q,l),t(e,Tl,l),t(e,Y,l),t(e,bl,l),t(e,A,l),t(e,wl,l),f(F,e,l),t(e,Zl,l),t(e,L,l),t(e,jl,l),t(e,P,l),t(e,Cl,l),f(O,e,l),t(e,vl,l),f(K,e,l),t(e,Il,l),t(e,ee,l),t(e,gl,l),f(le,e,l),t(e,Vl,l),f(se,e,l),t(e,Wl,l),t(e,te,l),t(e,kl,l),f(ne,e,l),t(e,Rl,l),t(e,ae,l),t(e,Nl,l),f(ie,e,l),t(e,Bl,l),t(e,oe,l),t(e,Gl,l),f(pe,e,l),t(e,_l,l),f(re,e,l),t(e,$l,l),t(e,ce,l),t(e,Ql,l),t(e,fe,l),t(e,Xl,l),f(j,e,l),t(e,El,l),t(e,ue,l),t(e,zl,l),t(e,de,l),t(e,xl,l),t(e,Me,l),t(e,Dl,l),t(e,me,l),t(e,Hl,l),f(ye,e,l),t(e,Sl,l),t(e,he,l),t(e,ql,l),f(Je,e,l),t(e,Yl,l),t(e,Ue,l),t(e,Al,l),f(Te,e,l),t(e,Fl,l),f(be,e,l),t(e,Ll,l),t(e,we,l),t(e,Pl,l),t(e,Ze,l),t(e,Ol,l),f(je,e,l),t(e,Kl,l),t(e,Ce,l),t(e,es,l),f(ve,e,l),t(e,ls,l),t(e,Ie,l),t(e,ss,l),f(ge,e,l),t(e,ts,l),f(Ve,e,l),t(e,ns,l),t(e,We,l),t(e,as,l),t(e,ke,l),t(e,is,l),f(Re,e,l),t(e,os,l),f(Ne,e,l),t(e,ps,l),t(e,Be,l),t(e,rs,l),t(e,Ge,l),t(e,cs,l),t(e,_e,l),t(e,fs,l),f($e,e,l),t(e,us,l),t(e,Qe,l),t(e,ds,l),t(e,Xe,l),t(e,Ms,l),f(Ee,e,l),t(e,ms,l),t(e,ze,l),t(e,ys,l),f(xe,e,l),t(e,hs,l),t(e,De,l),t(e,Js,l),f(He,e,l),t(e,Us,l),t(e,Se,l),t(e,Ts,l),t(e,qe,l),t(e,bs,l),f(Ye,e,l),t(e,ws,l),t(e,Fe,l),Zs=!0},p(e,[l]){const yt={};l&2&&(yt.$$scope={dirty:l,ctx:e}),b.$set(yt);const ht={};l&2&&(ht.$$scope={dirty:l,ctx:e}),j.$set(ht)},i(e){Zs||(u(C.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(b.$$.fragment,e),u(N.$$.fragment,e),u(G.$$.fragment,e),u($.$$.fragment,e),u(X.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(re.$$.fragment,e),u(j.$$.fragment,e),u(ye.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u(je.$$.fragment,e),u(ve.$$.fragment,e),u(ge.$$.fragment,e),u(Ve.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u($e.$$.fragment,e),u(Ee.$$.fragment,e),u(xe.$$.fragment,e),u(He.$$.fragment,e),u(Ye.$$.fragment,e),Zs=!0)},o(e){d(C.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(b.$$.fragment,e),d(N.$$.fragment,e),d(G.$$.fragment,e),d($.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(D.$$.fragment,e),d(S.$$.fragment,e),d(F.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(re.$$.fragment,e),d(j.$$.fragment,e),d(ye.$$.fragment,e),d(Je.$$.fragment,e),d(Te.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),d(ge.$$.fragment,e),d(Ve.$$.fragment,e),d(Re.$$.fragment,e),d(Ne.$$.fragment,e),d($e.$$.fragment,e),d(Ee.$$.fragment,e),d(xe.$$.fragment,e),d(He.$$.fragment,e),d(Ye.$$.fragment,e),Zs=!1},d(e){e&&(s(J),s(h),s(T),s(Le),s(Pe),s(I),s(Oe),s(g),s(Ke),s(V),s(el),s(W),s(ll),s(sl),s(tl),s(R),s(nl),s(al),s(B),s(il),s(ol),s(_),s(pl),s(rl),s(Q),s(cl),s(w),s(fl),s(Z),s(ul),s(dl),s(E),s(Ml),s(ml),s(x),s(yl),s(hl),s(H),s(Jl),s(Ul),s(q),s(Tl),s(Y),s(bl),s(A),s(wl),s(Zl),s(L),s(jl),s(P),s(Cl),s(vl),s(Il),s(ee),s(gl),s(Vl),s(Wl),s(te),s(kl),s(Rl),s(ae),s(Nl),s(Bl),s(oe),s(Gl),s(_l),s($l),s(ce),s(Ql),s(fe),s(Xl),s(El),s(ue),s(zl),s(de),s(xl),s(Me),s(Dl),s(me),s(Hl),s(Sl),s(he),s(ql),s(Yl),s(Ue),s(Al),s(Fl),s(Ll),s(we),s(Pl),s(Ze),s(Ol),s(Kl),s(Ce),s(es),s(ls),s(Ie),s(ss),s(ts),s(ns),s(We),s(as),s(ke),s(is),s(os),s(ps),s(Be),s(rs),s(Ge),s(cs),s(_e),s(fs),s(us),s(Qe),s(ds),s(Xe),s(Ms),s(ms),s(ze),s(ys),s(hs),s(De),s(Js),s(Us),s(Se),s(Ts),s(qe),s(bs),s(ws),s(Fe)),s(m),M(C,e),M(v,e),M(k,e),M(b,e),M(N,e),M(G,e),M($,e),M(X,e),M(z,e),M(D,e),M(S,e),M(F,e),M(O,e),M(K,e),M(le,e),M(se,e),M(ne,e),M(ie,e),M(pe,e),M(re,e),M(j,e),M(ye,e),M(Je,e),M(Te,e),M(be,e),M(je,e),M(ve,e),M(ge,e),M(Ve,e),M(Re,e),M(Ne,e),M($e,e),M(Ee,e),M(xe,e),M(He,e),M(Ye,e)}}}const kt='{"title":"Load pipelines, models, and schedulers","local":"load-pipelines-models-and-schedulers","sections":[{"title":"Diffusion Pipeline","local":"diffusion-pipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3},{"title":"Swap components in a pipeline","local":"swap-components-in-a-pipeline","sections":[],"depth":3},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":3},{"title":"Reuse components across pipelines","local":"reuse-components-across-pipelines","sections":[],"depth":3}],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Schedulers","local":"schedulers","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function Rt(Ae){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends Zt{constructor(m){super(),jt(this,m,Rt,Wt,bt,{})}}export{Xt as component};
